%{  /* y.tab.y -*-C-*- Yacc file for On Server Filtering */
    /*
     * Copyright (c) 1998 Qualcomm Incorporated. All rights reserved.
     *
     * File        : y.tab.y
     * Project     : Delivery agent implementing "On Server Filtering".
     * Comments    : From draft-showalter-sieve-04.txt
     *
     * Caution     : 
     *
     * Revisions   :
     *  xx/xx/xx   [py]
     *         - File added.
     *
     *
     */
#include <stdlib.h>
#include <stdio.h>
#include "dastruct.h"
extern int yylex();
extern int yyparse();
extern void yyerror();
%}

%union {
    unsigned int uiNumber;
    StrV     *svString;
}
%token IF ELSE
%token ANYOF ALLOF EXISTS FALSE HEADER NOT SIZE SUPPORT TRUE
%token OVER UNDER CONTAINS MATCHES IS
%token REJCT DISCARD FILEINTO FORWARD KEEP REPLY STOP
%token NUMBER STRING WSP
%%

start:     command { YYACCEPT; }

commands:  /* empty */
         | commands command
        ;

command:   action ';'
         | block
        ;

block:    '{' commands '}'

action:    REJCT STRING 
         | FILEINTO STRING
         | FORWARD STRING
         | KEEP
         | REPLY STRING
         | STOP
         | DISCARD
        ;
%%

extern FILE *yyin, *yyout;

int main(int argc, char *argv[])
{
    if(argc > 2) {
	fprintf(stderr, "Usage: %s <sieve_file>\n", argv[0]);
	return -1;
    }
    if(argc == 1)
	yyin = stdin;
    else
	yyin = fopen(argv[1],"r");
    if(!yyin) {
	fprintf(stderr, "Failed to open script file %s\n", argv[1]);
	return -1;
    }
    do {
	if(yyparse() == 0) {
	    fprintf(stdout, "Command successfull\n");
	}
    }while( !feof(yyin) );
    return 0;
}
