#define SHA_DIGEST_LENGTH 20
/* The SHA block size and message digest sizes, in bytes */

#define SHA_DATASIZE    64
#define SHA_DATALEN     16
#define SHA_DIGESTSIZE  20
#define SHA_DIGESTLEN    5
/* The structure for storing SHA info */

typedef struct {
  unsigned int digest[SHA_DIGESTLEN];  /* Message digest */
  unsigned int count_l, count_h;       /* 64-bit block count */
  unsigned char block[SHA_DATASIZE];     /* SHA data buffer */
  int index;                             /* index into buffer */
} SHA1_CTX;

void SHA1_init(SHA1_CTX *ctx);
void SHA1_update(SHA1_CTX *ctx, const unsigned char *buffer, unsigned int len);
void SHA1_final(SHA1_CTX *ctx);
void SHA1_digest(SHA1_CTX *ctx, unsigned char *s);
