#include <unistd.h>
#include "qconfirm.h"
#include "strerr.h"
#include "pathexec.h"
#include "coe.h"
#include "env.h"
#include "wait.h"
#include "fd.h"

#define FATAL "qconfirm-inject: fatal: "

static int qpid;

int open_qmail_inject(int *fd, char *to) {
  int p[2];

  if (pipe(p) == -1) {
    strerr_warn2(FATAL, "unable to pipe(); ", &strerr_sys);
    return(-1);
  }
  if ((qpid =fork()) == -1) {
    strerr_warn2(FATAL, "unable to fork(): ", &strerr_sys);
    close(p[0]); close(p[1]);
    return(-1);
  }
  if (! qpid) {
    const char *args[4];

    close(p[1]);
    if (fd_move(0, p[0]) == -1) {
      strerr_warn2(FATAL, "unable to set descriptor for qmail-inject: ", \
		   &strerr_sys);
      return(-1);
    }
    args[0] =QMAIL_HOME "/bin/qmail-inject";
    if (to) { 
      args[1] ="--";
      args[2] =to;
      args[3] =0;
    }
    else args[1] =0;
    pathexec_run(*args, args, (const char **)environ);
    strerr_die2sys(111, FATAL, "unable to run qmail-inject: ");
  }
  close(p[0]);
  *fd =p[1];
  return(1);
}
int close_qmail_inject() {
  int wstat;

  if (wait_pid(&wstat, qpid) == -1) {
    strerr_warn2(FATAL, "wait failed: ", &strerr_sys);
    return(-1);
  }
  if (wait_exitcode(wstat) != 0) {
    strerr_warn2(FATAL, "qmail-inject crashed.", 0);
    return(-1);
  }
  return(1);
}
