#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include "sig.h"
#include "qconfirm.h"
#include "qconfirm_conf_get.h"
#include "qconfirm_inject.h"
#include "qconfirm_key.h"
#include "next_paragraph.h"
#include "getline.h"
#include "strerr.h"
#include "error.h"
#include "buffer.h"
#include "env.h"
#include "str.h"
#include "fd.h"
#include "pathexec.h"
#include "wait.h"
#include "stralloc.h"
#include "byte.h"
#include "open.h"
#include "fmt.h"
#include "scan.h"
#include "sgetopt.h"

#define USAGE " [-v] [-t sec] [-d dir ] "
#define VERSION "$Id: qconfirm-control.c,v 1.10 2003/11/21 13:45:53 pape Exp $"
#define FATAL "qconfirm-control: fatal: "
#define WARNING "qconfirm-control: warning: "
#define INFO "qconfirm-control: info: "

#define QCONTROLQUOTE "> "

const char *progname;

char *qconfirm_dir;
char *qcontrol_owner;
char *qconfirm_prepend;
char *qcontrol_quote;
char *mailname;
char *dflt;
char *local;
char *host;
char *sender;

int verbose =0;
unsigned long timeout =300;

char *key;
stralloc sa ={0};
stralloc command ={0};
struct stat st;
buffer b;
char b_space[BUFFER_OUTSIZE];
int fd;
int pid;
int wstat;
char inode[FMT_ULONG];

void usage() { strerr_die4x(111, "usage: ", progname, USAGE, "\n"); }
void die_nomem() { strerr_die2x(111, FATAL, "out of memory."); }
void fatal(char *m1, char *m2) { strerr_die4sys(111, FATAL, m1, m2, ": "); }
void warn(char *m1, char *m2) { strerr_warn3(WARNING, m1, m2, 0); }
void info(char *m1, char *m2) { strerr_die3x(0, INFO, m1, m2); }
void defer(char *m1, char *m2) { strerr_die3x(111, INFO, m1, m2); }
void bounce(char *m) { strerr_die1x(100, m); }

char* create_ctrl() {
  if (fstat(0, &st) == -1) fatal("unable to fstat stdin", 0);
  inode[fmt_ulong(inode, st.st_ino)] = 0;
  if (! inode) fatal("bad inode", 0);

  do {
    if (! stralloc_copyb(&sa, (char *) &st.st_ino, 1)) die_nomem();
    if (! stralloc_cats(&sa, sender)) die_nomem();
    if (! (key =qconfirm_key(&sa))) die_nomem();
    if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
    if (! stralloc_cats(&sa, "/control/")) die_nomem();
    if (! stralloc_cats(&sa, key)) die_nomem();
    if (! stralloc_0(&sa)) die_nomem();
  } while (stat(sa.s, &st) != -1);
  if (errno != error_noent) fatal("unable to stat: ", sa.s);
  if (open_trunc(sa.s) == -1) fatal("unable to create: ", sa.s);
  if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&sa, "/control/")) die_nomem();
  if (! stralloc_cats(&sa, inode)) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if (symlink(key, sa.s) == -1)
    fatal("unable to create symbolic link: ", sa.s);
  return(key);
}

int check_ctrl() {
  int stamp;
  time_t now;
  char buf[33];

  if (fstat(0, &st) == -1) fatal("unable to fstat stdin", 0);
  inode[fmt_ulong(inode, st.st_ino)] = 0;
  if (! inode) fatal("bad inode", 0);
  stamp =st.st_mtime;

  if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&sa, "/control/")) die_nomem();
  if (! stralloc_cats(&sa, inode)) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if (stat(sa.s, &st) == -1) {
    if (errno != error_noent) fatal("unable to stat: ", sa.s);
    return(1);
  }
  /* check timeout and mode */
  now =time(NULL);
  if (((now -stamp) > timeout) || ((st.st_mode & S_IRWXU) == S_IWUSR)) {
    /* remove */
    if (readlink(sa.s, buf, 32) != 32)
      fatal("unable to read key from inode: ", inode);
    buf[32] =0;
    if (unlink(sa.s) == -1) warn("unable to unlink: ", sa.s);
    if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
    if (! stralloc_cats(&sa, "/control/")) die_nomem();
    if (! stralloc_catb(&sa, buf, 32)) die_nomem();
    if (! stralloc_0(&sa)) die_nomem();
    if (unlink(sa.s) == -1) warn("unable to unlink: ", sa.s);
    info("remove: ", buf);
  }
  defer("active: ", inode);
  return(-1);
}

int check_key() {
  if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
  if (! stralloc_cats(&sa, "/control/")) die_nomem();
  if (! stralloc_cats(&sa, dflt)) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if (stat(sa.s, &st) == -1) bounce("not authorized.");
  if ((st.st_mode & S_IRWXU) == S_IWUSR) bounce("not authorized.");
  return(1);
}

int run_qconfirm(char *arg, char *addresses, buffer *out) {
  char *prog[1000];
  int progc;
  int i;

  prog[0] ="qconfirm";
  prog[1] =arg;
  prog[2] =0;
  progc =2;

  if (addresses) {
    i =0;
    for (;;) {
      while ((addresses[i] == ' ') || (addresses[i] == '\t')) ++i;
      if (! addresses[i]) break;
      prog[progc++] =&addresses[i];
      if (progc == 999) {
	warn("too many addresses, truncate.", 0);
	break;
      }
      while (addresses[i] && (addresses[i] != ' ') && (addresses[i] != '\t'))
	++i;
      if (! addresses[i]) break;
      addresses[i++] =0;
    }
    prog[progc] =0;
  }
  if (verbose) {
    buffer_puts(out, " ");
    for (i =0; i < progc; ++i) {
      buffer_puts(out, " ");
      buffer_puts(out, prog[i]);
    }
    buffer_puts(out, "\n");
  }
  buffer_flush(out);

  if ((pid =fork()) == -1) fatal("unable to fork", 0);
  if (! pid) {
    /* child */
    if (fd_move(1, out->fd) == -1) fatal("unable to set filedescriptor", 0);
    if (fd_copy(2, 1) == -1) fatal("unable to set filedescriptor", 0);
    pathexec((const char **)prog);
    fatal("unable to run: ", prog[0]);
  }
  if (wait_pid(&wstat, pid) == -1) fatal(prog[0], ": wait failed");
  if (wait_exitcode(wstat) != 0) warn(prog[0], ": exited abnormally.");
  buffer_putsflush(out, "\n");
  return(1);
}

int qconfirm_list(char *arg, char *extension) {
  if (open_qmail_inject(&fd, qcontrol_owner) == -1)
    fatal("unable to start qmail-inject", 0);
  buffer_init(&b, buffer_unixwrite, fd, b_space, sizeof b_space);
  buffer_puts(&b, "Return-Path: <>\n");
  buffer_puts(&b, "Subject: qconfirm list\n");
  buffer_puts(&b, "From: \"");
  buffer_puts(&b, mailname);
  buffer_puts(&b, "\" <");
  buffer_puts(&b, local);
  if (extension) buffer_puts(&b, extension);
  buffer_puts(&b, "@");
  buffer_puts(&b, host);
  buffer_puts(&b, ">\nTo: ");
  buffer_puts(&b, qcontrol_owner);
  buffer_puts(&b, "\n\n");

  if (! stralloc_copys(&sa, "qconfirm list ")) die_nomem();
  if (! stralloc_cats(&sa, arg)) die_nomem();
  if (! stralloc_cats(&sa, " | sort -r")) die_nomem();
  if (! stralloc_0(&sa)) die_nomem();
  if (verbose) {
    buffer_puts(&b, "  ");
    buffer_puts(&b, sa.s);
    buffer_puts(&b, "\n");
  }
  buffer_flush(&b);
  if ((pid =fork()) == -1) fatal("unable to fork", 0);
  if (! pid) {
    /* child */
    const char *prog[4];
	  
    if (fd_move(1, b.fd) == -1) fatal("unable to set filedescriptor", 0);
    if (fd_copy(2, 1) == -1) fatal("unable to set filedescriptor", 0);
    prog[0] ="sh";
    prog[1] ="-c";
    prog[2] =sa.s;
    prog[3] =0;
    pathexec(prog);
    fatal("unable to run: ", sa.s);
  }
  if (wait_pid(&wstat, pid) == -1) fatal(sa.s, ": wait failed");
  if (wait_exitcode(wstat) != 0) warn(sa.s, ": exited abnormally.");
  buffer_putsflush(&b, "\n");
  return(1);
}

int process() {
  int r;
  stralloc args ={0};

  if (open_qmail_inject(&fd, qcontrol_owner) == -1)
    fatal("unable to start qmail-inject", 0);
  buffer_init(&b, buffer_unixwrite, fd, b_space, sizeof b_space);
  buffer_puts(&b, "Return-Path: <>\n");
  buffer_puts(&b, "Subject: qconfirm control\n");
  buffer_puts(&b, "From: \"");
  buffer_puts(&b, mailname);
  buffer_puts(&b, "\" <");
  buffer_puts(&b, local);
  buffer_puts(&b, "@");
  buffer_puts(&b, host);
  buffer_puts(&b, ">\nTo: ");
  buffer_puts(&b, qcontrol_owner);
  buffer_putsflush(&b, "\n\n");

  /* process message */
  /* skip header */
  if (next_paragraph(buffer_0) == -1) strerr_die2x(0, WARNING, "no body.");
  if (! stralloc_copys(&args, "")) die_nomem();

  /* lines */
  while ((r =getline(buffer_0, &sa)) > 0) {
    if (sa.s[0] == '\n') continue;
    if ((sa.len > 2) && str_start(sa.s, qcontrol_quote)) {
      int i, j;

      /* quoted qconfirm list item */
      buffer_puts(&b, qcontrol_quote);
      buffer_put(&b, sa.s, sa.len);
      if ((sa.s[2] < '1') || (sa.s[2] > '9')) continue;
      if ((i =byte_chr(&sa.s[2], sa.len -2, ' ')) == sa.len -2) {
	if (verbose) buffer_putsflush(&b, "parse error.\n");
	continue;
      }
      i +=3;
      for (j =i; sa.s[j]; ++j) {
	if ((sa.s[j] == ' ') || (sa.s[j] == '\n')) break;
      }
      if (j > i) {
	if (! stralloc_catb(&args, &sa.s[i], j -i)) die_nomem();
	if (! stralloc_cats(&args, " ")) die_nomem();
	if (verbose) {
	  buffer_puts(&b, "  ");
	  buffer_put(&b, &sa.s[i], j -i);
	  buffer_puts(&b, "\n");
	}
      }
      buffer_flush(&b);
      continue;
    }
    if ((sa.len >= 6) && str_start(sa.s, "accept")) {
      if ((sa.s[6] == ' ') && sa.s[7]) {
	if (! stralloc_catb(&args, &sa.s[7], sa.len -7)) die_nomem();
	if (args.s[args.len -1] == '\n')
	  args.s[args.len -1] =0;
      }
      if (! stralloc_0(&args)) die_nomem();
      buffer_puts(&b, qcontrol_quote);
      buffer_putflush(&b, sa.s, sa.len);
      run_qconfirm("accept", args.s, &b);
      if (! stralloc_copys(&args, "")) die_nomem();
      continue;
    }
    if ((sa.len >= 4) && str_start(sa.s, "drop")) {
      if ((sa.s[4] == ' ') && sa.s[5]) {
	if (! stralloc_catb(&args, &sa.s[5], sa.len -5)) die_nomem();
	if (args.s[args.len -1] == '\n')
	  args.s[args.len -1] =0;
      }
      if (! stralloc_0(&args)) die_nomem();
      buffer_puts(&b, qcontrol_quote);
      buffer_putflush(&b, sa.s, sa.len);
      run_qconfirm("drop", args.s, &b);
      if (! stralloc_copys(&args, "")) die_nomem();
      continue;
    }
    if ((sa.len >= 6) && str_start(sa.s, "bounce")) {
      if ((sa.s[6] == ' ') && sa.s[7]) {
	if (! stralloc_catb(&args, &sa.s[7], sa.len -7)) die_nomem();
	if (args.s[args.len -1] == '\n')
	  args.s[args.len -1] =0;
      }
      if (! stralloc_0(&args)) die_nomem();
      buffer_puts(&b, qcontrol_quote);
      buffer_putflush(&b, sa.s, sa.len);
      run_qconfirm("bounce", args.s, &b);
      if (! stralloc_copys(&args, "")) die_nomem();
      continue;
    }
    if ((sa.len >= 3) && str_start(sa.s, "bad")) {
      if ((sa.s[3] == ' ') && sa.s[4]) {
	if (! stralloc_catb(&args, &sa.s[4], sa.len -4)) die_nomem();
	if (args.s[args.len -1] == '\n')
	  args.s[args.len -1] =0;
      }
      if (! stralloc_0(&args)) die_nomem();
      buffer_puts(&b, qcontrol_quote);
      buffer_putflush(&b, sa.s, sa.len);
      run_qconfirm("bad", args.s, &b);
      if (! stralloc_copys(&args, "")) die_nomem();
      continue;
    }
    if ((sa.len >= 7) && str_start(sa.s, "pending")) {
      if ((sa.s[7] == ' ') && sa.s[8]) {
	if (! stralloc_catb(&args, &sa.s[8], sa.len -8)) die_nomem();
	if (args.s[args.len -1] == '\n')
	  args.s[args.len -1] =0;
      }
      if (! stralloc_0(&args)) die_nomem();
      buffer_puts(&b, qcontrol_quote);
      buffer_putflush(&b, sa.s, sa.len);
      run_qconfirm("pending", args.s, &b);
      if (! stralloc_copys(&args, "")) die_nomem();
      continue;
    }
    if ((sa.len >= 6) && str_start(sa.s, "remove")) {
      if ((sa.s[6] == ' ') && sa.s[7]) {
	if (! stralloc_catb(&args, &sa.s[7], sa.len -7)) die_nomem();
	if (args.s[args.len -1] == '\n')
	  args.s[args.len -1] =0;
      }
      if (! stralloc_0(&args)) die_nomem();
      buffer_puts(&b, qcontrol_quote);
      buffer_putflush(&b, sa.s, sa.len);
      run_qconfirm("remove", args.s, &b);
      if (! stralloc_copys(&args, "")) die_nomem();
      continue;
    }
    if ((sa.len >= 5) && str_start(sa.s, "sneak")) {
      if ((sa.s[5] == ' ') && sa.s[6]) {
	if (! stralloc_catb(&args, &sa.s[6], sa.len -6)) die_nomem();
	if (args.s[args.len -1] == '\n')
	  args.s[args.len -1] =0;
      }
      if (! stralloc_0(&args)) die_nomem();
      buffer_puts(&b, qcontrol_quote);
      buffer_putflush(&b, sa.s, sa.len);
      run_qconfirm("sneak", args.s, &b);
      if (! stralloc_copys(&args, "")) die_nomem();
      continue;
    }
    if ((sa.len >= 4) && str_start(sa.s, "list")) {
      if ((sa.s[4] == ' ') && sa.s[5]) {
	if (! stralloc_copyb(&args, &sa.s[5], sa.len -5)) die_nomem();
	if (args.s[args.len -1] == '\n')
	  args.s[args.len -1] =0;
      }
      if (! stralloc_0(&args)) die_nomem();
      buffer_puts(&b, qcontrol_quote);
      buffer_putflush(&b, sa.s, sa.len);
      run_qconfirm("list", args.s, &b);
      if (! stralloc_copys(&args, "")) die_nomem();
      continue;
    }
    if ((sa.len >= 6) && str_start(sa.s, "thanks")) {
      buffer_puts(&b, qcontrol_quote);
      buffer_put(&b, sa.s, sa.len);
      /* remove this key */
      if (! stralloc_copys(&sa, qconfirm_dir)) die_nomem();
      if (! stralloc_cats(&sa, "/control/")) die_nomem();
      if (! stralloc_cats(&sa, dflt)) die_nomem();
      if (! stralloc_0(&sa)) die_nomem();
      if (chmod(sa.s, S_IWUSR) == -1)
	fatal("unable to chmod: ", sa.s);
      buffer_puts(&b, "Removing temporary authorization.\n");
      break;
    }
    if ((sa.len >= 4) && str_start(sa.s, "stop")) {
      buffer_puts(&b, qcontrol_quote);
      buffer_put(&b, sa.s, sa.len);
      break;
    }
    buffer_puts(&b, qcontrol_quote);
    buffer_put(&b, sa.s, sa.len);
    buffer_putsflush(&b, "unknown command.\n\n");
  }
  buffer_putsflush(&b, "Stopping processing here.\n");
  close(fd);
  if (! close_qmail_inject()) fatal("unable to run qmail-inject", 0);
  return(1);
}

int main(int argc, const char **argv) {
  int i;
  int opt;

  progname =*argv;
  umask(0177);
  sig_ignore(sig_pipe);

  qconfirm_dir =env_get("QCONFIRM_DIR");

  while ((opt =getopt(argc, argv, "vVt:d:")) != opteof) {
    switch(opt) {
    case 'v': verbose =1; break;
    case 't': scan_ulong(optarg, &timeout); break;
    case 'd': qconfirm_dir =(char *)optarg; break;
    case 'V': strerr_warn1(VERSION, 0);
    case '?': usage();
    }
  }
  argv +=optind;

  sender =env_get("SENDER");
  if (! sender)
    strerr_die2x(100, FATAL, "environment variable SENDER not set.\n");
  dflt =env_get("DEFAULT");
  if (! dflt)
    strerr_die2x(100, FATAL, "environment variable DEFAULT not set.\n");
  local =env_get("LOCAL");
  if (! local)
    strerr_die2x(100, FATAL, "environment variable LOCAL not set.\n");
  host =env_get("HOST");
  if (! host)
    strerr_die2x(100, FATAL, "environment variable HOST not set.\n");

  if (! qconfirm_dir) qconfirm_dir =QCONFIRMDIR;
  qconfirm_prepend =conf_get_dflt(qconfirm_dir, "QCONFIRM_PREPEND", "");
  if (! qconfirm_prepend)
    fatal("unable to read config: ", "QCONFIRM_PREPEND");
  qcontrol_quote =conf_get_dflt(qconfirm_dir, "QCONTROL_QUOTE", QCONTROLQUOTE);
  if (! qcontrol_quote)
    fatal("unable to read config: ", "QCONTROL_QUOTE");
  qcontrol_owner =conf_get(qconfirm_dir, "QCONTROL_OWNER");
  if (! qcontrol_owner)
    fatal("unable to read config: ", "QCONTROL_OWNER");
  if (! *qcontrol_owner)
    strerr_die2x(100, FATAL, "QCONTROL_OWNER is empty.\n");
  mailname =conf_get_dflt(qconfirm_dir, "QCONFIRM_MAILNAME", QCONFIRMMAILNAME);
  if (! mailname)
    fatal("unable to read config: ", "QCONFIRM_MAILNAME");

  if (! pathexec_env("QCONFIRM_DIR", qconfirm_dir)) die_nomem();

  i =str_len(qconfirm_prepend);
  if (byte_equal(qconfirm_prepend, i, local)) local +=i;

  i =str_len(dflt);
  switch(i) {
  case 2: /* ok */
    if (str_equal("ok", dflt)) {
      check_ctrl();
      key =create_ctrl();
      local[str_len(local) -i] =0;
      qconfirm_list("ok", key);
      defer("create: ", inode);
    }
    break;
  case 3: /* bad */
    if (str_equal("bad", dflt)) {
      check_ctrl();
      key =create_ctrl();
      local[str_len(local) -i] =0;
      qconfirm_list("bad", key);
      defer("create: ", inode);
    }
    break;
  case 6:
    if (str_equal("return", dflt)) {
      check_ctrl();
      key =create_ctrl();
      local[str_len(local) -i] =0;
      qconfirm_list("return", key);
      defer("create: ", inode);
    }
    break;
  case 0: case 7: /* create control and list pending */
    if (! *dflt || str_equal("pending", dflt)) {
      check_ctrl();
      key =create_ctrl();
      local[str_len(local) -i] =0;
      qconfirm_list("", key);
      defer("create: ", inode);
    }
    break;
  case 32: /* key */
    check_key();
    process();
    info("processed", 0);
    break;
  }
  bounce("Sorry, no mailbox here by that name.");
  _exit(0);
}
