/* $NoKeywords: $ */
/*
//
// Copyright (c) 1993-2012 Robert McNeel & Associates. All rights reserved.
// OpenNURBS, Rhinoceros, and Rhino3D are registered trademarks of Robert
// McNeel & Associates.
//
// THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
// ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF
// MERCHANTABILITY ARE HEREBY DISCLAIMED.
//				
// For complete openNURBS copyright information see <http://www.opennurbs.org>.
//
////////////////////////////////////////////////////////////////
*/

#include "opennurbs.h"

#if !defined(ON_COMPILING_OPENNURBS)
// This check is included in all opennurbs source .c and .cpp files to insure
// ON_COMPILING_OPENNURBS is defined when opennurbs source is compiled.
// When opennurbs source is being compiled, ON_COMPILING_OPENNURBS is defined 
// and the opennurbs .h files alter what is declared and how it is declared.
#error ON_COMPILING_OPENNURBS must be defined when compiling opennurbs
#endif

#if !defined(ON_RUNTIME_WIN)
#error Do not use for Windows builds.
#endif

#include "opennurbs_internal_unicode_cp.h"

#if defined(ON_DOUBLE_BYTE_CODE_PAGE_SUPPORT)

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x81(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8141: code_point = 0xAC02; break; // HANGUL SYLLABLE KIYEOK A SSANGKIYEOK
    case 0x8142: code_point = 0xAC03; break; // HANGUL SYLLABLE KIYEOK A KIYEOKSIOS
    case 0x8143: code_point = 0xAC05; break; // HANGUL SYLLABLE KIYEOK A NIEUNCIEUC
    case 0x8144: code_point = 0xAC06; break; // HANGUL SYLLABLE KIYEOK A NIEUNHIEUH
    case 0x8145: code_point = 0xAC0B; break; // HANGUL SYLLABLE KIYEOK A RIEULPIEUP
    case 0x8146: code_point = 0xAC0C; break; // HANGUL SYLLABLE KIYEOK A RIEULSIOS
    case 0x8147: code_point = 0xAC0D; break; // HANGUL SYLLABLE KIYEOK A RIEULTHIEUTH
    case 0x8148: code_point = 0xAC0E; break; // HANGUL SYLLABLE KIYEOK A RIEULPHIEUPH
    case 0x8149: code_point = 0xAC0F; break; // HANGUL SYLLABLE KIYEOK A RIEULHIEUH
    case 0x814A: code_point = 0xAC18; break; // HANGUL SYLLABLE KIYEOK A KHIEUKH
    case 0x814B: code_point = 0xAC1E; break; // HANGUL SYLLABLE KIYEOK AE SSANGKIYEOK
    case 0x814C: code_point = 0xAC1F; break; // HANGUL SYLLABLE KIYEOK AE KIYEOKSIOS
    case 0x814D: code_point = 0xAC21; break; // HANGUL SYLLABLE KIYEOK AE NIEUNCIEUC
    case 0x814E: code_point = 0xAC22; break; // HANGUL SYLLABLE KIYEOK AE NIEUNHIEUH
    case 0x814F: code_point = 0xAC23; break; // HANGUL SYLLABLE KIYEOK AE TIKEUT
    case 0x8150: code_point = 0xAC25; break; // HANGUL SYLLABLE KIYEOK AE RIEULKIYEOK
    case 0x8151: code_point = 0xAC26; break; // HANGUL SYLLABLE KIYEOK AE RIEULMIEUM
    case 0x8152: code_point = 0xAC27; break; // HANGUL SYLLABLE KIYEOK AE RIEULPIEUP
    case 0x8153: code_point = 0xAC28; break; // HANGUL SYLLABLE KIYEOK AE RIEULSIOS
    case 0x8154: code_point = 0xAC29; break; // HANGUL SYLLABLE KIYEOK AE RIEULTHIEUTH
    case 0x8155: code_point = 0xAC2A; break; // HANGUL SYLLABLE KIYEOK AE RIEULPHIEUPH
    case 0x8156: code_point = 0xAC2B; break; // HANGUL SYLLABLE KIYEOK AE RIEULHIEUH
    case 0x8157: code_point = 0xAC2E; break; // HANGUL SYLLABLE KIYEOK AE PIEUPSIOS
    case 0x8158: code_point = 0xAC32; break; // HANGUL SYLLABLE KIYEOK AE CIEUC
    case 0x8159: code_point = 0xAC33; break; // HANGUL SYLLABLE KIYEOK AE CHIEUCH
    case 0x815A: code_point = 0xAC34; break; // HANGUL SYLLABLE KIYEOK AE KHIEUKH
    case 0x8161: code_point = 0xAC35; break; // HANGUL SYLLABLE KIYEOK AE THIEUTH
    case 0x8162: code_point = 0xAC36; break; // HANGUL SYLLABLE KIYEOK AE PHIEUPH
    case 0x8163: code_point = 0xAC37; break; // HANGUL SYLLABLE KIYEOK AE HIEUH
    case 0x8164: code_point = 0xAC3A; break; // HANGUL SYLLABLE KIYEOK YA SSANGKIYEOK
    case 0x8165: code_point = 0xAC3B; break; // HANGUL SYLLABLE KIYEOK YA KIYEOKSIOS
    case 0x8166: code_point = 0xAC3D; break; // HANGUL SYLLABLE KIYEOK YA NIEUNCIEUC
    case 0x8167: code_point = 0xAC3E; break; // HANGUL SYLLABLE KIYEOK YA NIEUNHIEUH
    case 0x8168: code_point = 0xAC3F; break; // HANGUL SYLLABLE KIYEOK YA TIKEUT
    case 0x8169: code_point = 0xAC41; break; // HANGUL SYLLABLE KIYEOK YA RIEULKIYEOK
    case 0x816A: code_point = 0xAC42; break; // HANGUL SYLLABLE KIYEOK YA RIEULMIEUM
    case 0x816B: code_point = 0xAC43; break; // HANGUL SYLLABLE KIYEOK YA RIEULPIEUP
    case 0x816C: code_point = 0xAC44; break; // HANGUL SYLLABLE KIYEOK YA RIEULSIOS
    case 0x816D: code_point = 0xAC45; break; // HANGUL SYLLABLE KIYEOK YA RIEULTHIEUTH
    case 0x816E: code_point = 0xAC46; break; // HANGUL SYLLABLE KIYEOK YA RIEULPHIEUPH
    case 0x816F: code_point = 0xAC47; break; // HANGUL SYLLABLE KIYEOK YA RIEULHIEUH
    case 0x8170: code_point = 0xAC48; break; // HANGUL SYLLABLE KIYEOK YA MIEUM
    case 0x8171: code_point = 0xAC49; break; // HANGUL SYLLABLE KIYEOK YA PIEUP
    case 0x8172: code_point = 0xAC4A; break; // HANGUL SYLLABLE KIYEOK YA PIEUPSIOS
    case 0x8173: code_point = 0xAC4C; break; // HANGUL SYLLABLE KIYEOK YA SSANGSIOS
    case 0x8174: code_point = 0xAC4E; break; // HANGUL SYLLABLE KIYEOK YA CIEUC
    case 0x8175: code_point = 0xAC4F; break; // HANGUL SYLLABLE KIYEOK YA CHIEUCH
    case 0x8176: code_point = 0xAC50; break; // HANGUL SYLLABLE KIYEOK YA KHIEUKH
    case 0x8177: code_point = 0xAC51; break; // HANGUL SYLLABLE KIYEOK YA THIEUTH
    case 0x8178: code_point = 0xAC52; break; // HANGUL SYLLABLE KIYEOK YA PHIEUPH
    case 0x8179: code_point = 0xAC53; break; // HANGUL SYLLABLE KIYEOK YA HIEUH
    case 0x817A: code_point = 0xAC55; break; // HANGUL SYLLABLE KIYEOK YAE KIYEOK
    case 0x8181: code_point = 0xAC56; break; // HANGUL SYLLABLE KIYEOK YAE SSANGKIYEOK
    case 0x8182: code_point = 0xAC57; break; // HANGUL SYLLABLE KIYEOK YAE KIYEOKSIOS
    case 0x8183: code_point = 0xAC59; break; // HANGUL SYLLABLE KIYEOK YAE NIEUNCIEUC
    case 0x8184: code_point = 0xAC5A; break; // HANGUL SYLLABLE KIYEOK YAE NIEUNHIEUH
    case 0x8185: code_point = 0xAC5B; break; // HANGUL SYLLABLE KIYEOK YAE TIKEUT
    case 0x8186: code_point = 0xAC5D; break; // HANGUL SYLLABLE KIYEOK YAE RIEULKIYEOK
    case 0x8187: code_point = 0xAC5E; break; // HANGUL SYLLABLE KIYEOK YAE RIEULMIEUM
    case 0x8188: code_point = 0xAC5F; break; // HANGUL SYLLABLE KIYEOK YAE RIEULPIEUP
    case 0x8189: code_point = 0xAC60; break; // HANGUL SYLLABLE KIYEOK YAE RIEULSIOS
    case 0x818A: code_point = 0xAC61; break; // HANGUL SYLLABLE KIYEOK YAE RIEULTHIEUTH
    case 0x818B: code_point = 0xAC62; break; // HANGUL SYLLABLE KIYEOK YAE RIEULPHIEUPH
    case 0x818C: code_point = 0xAC63; break; // HANGUL SYLLABLE KIYEOK YAE RIEULHIEUH
    case 0x818D: code_point = 0xAC64; break; // HANGUL SYLLABLE KIYEOK YAE MIEUM
    case 0x818E: code_point = 0xAC65; break; // HANGUL SYLLABLE KIYEOK YAE PIEUP
    case 0x818F: code_point = 0xAC66; break; // HANGUL SYLLABLE KIYEOK YAE PIEUPSIOS
    case 0x8190: code_point = 0xAC67; break; // HANGUL SYLLABLE KIYEOK YAE SIOS
    case 0x8191: code_point = 0xAC68; break; // HANGUL SYLLABLE KIYEOK YAE SSANGSIOS
    case 0x8192: code_point = 0xAC69; break; // HANGUL SYLLABLE KIYEOK YAE IEUNG
    case 0x8193: code_point = 0xAC6A; break; // HANGUL SYLLABLE KIYEOK YAE CIEUC
    case 0x8194: code_point = 0xAC6B; break; // HANGUL SYLLABLE KIYEOK YAE CHIEUCH
    case 0x8195: code_point = 0xAC6C; break; // HANGUL SYLLABLE KIYEOK YAE KHIEUKH
    case 0x8196: code_point = 0xAC6D; break; // HANGUL SYLLABLE KIYEOK YAE THIEUTH
    case 0x8197: code_point = 0xAC6E; break; // HANGUL SYLLABLE KIYEOK YAE PHIEUPH
    case 0x8198: code_point = 0xAC6F; break; // HANGUL SYLLABLE KIYEOK YAE HIEUH
    case 0x8199: code_point = 0xAC72; break; // HANGUL SYLLABLE KIYEOK EO SSANGKIYEOK
    case 0x819A: code_point = 0xAC73; break; // HANGUL SYLLABLE KIYEOK EO KIYEOKSIOS
    case 0x819B: code_point = 0xAC75; break; // HANGUL SYLLABLE KIYEOK EO NIEUNCIEUC
    case 0x819C: code_point = 0xAC76; break; // HANGUL SYLLABLE KIYEOK EO NIEUNHIEUH
    case 0x819D: code_point = 0xAC79; break; // HANGUL SYLLABLE KIYEOK EO RIEULKIYEOK
    case 0x819E: code_point = 0xAC7B; break; // HANGUL SYLLABLE KIYEOK EO RIEULPIEUP
    case 0x819F: code_point = 0xAC7C; break; // HANGUL SYLLABLE KIYEOK EO RIEULSIOS
    case 0x81A0: code_point = 0xAC7D; break; // HANGUL SYLLABLE KIYEOK EO RIEULTHIEUTH
    case 0x81A1: code_point = 0xAC7E; break; // HANGUL SYLLABLE KIYEOK EO RIEULPHIEUPH
    case 0x81A2: code_point = 0xAC7F; break; // HANGUL SYLLABLE KIYEOK EO RIEULHIEUH
    case 0x81A3: code_point = 0xAC82; break; // HANGUL SYLLABLE KIYEOK EO PIEUPSIOS
    case 0x81A4: code_point = 0xAC87; break; // HANGUL SYLLABLE KIYEOK EO CHIEUCH
    case 0x81A5: code_point = 0xAC88; break; // HANGUL SYLLABLE KIYEOK EO KHIEUKH
    case 0x81A6: code_point = 0xAC8D; break; // HANGUL SYLLABLE KIYEOK E KIYEOK
    case 0x81A7: code_point = 0xAC8E; break; // HANGUL SYLLABLE KIYEOK E SSANGKIYEOK
    case 0x81A8: code_point = 0xAC8F; break; // HANGUL SYLLABLE KIYEOK E KIYEOKSIOS
    case 0x81A9: code_point = 0xAC91; break; // HANGUL SYLLABLE KIYEOK E NIEUNCIEUC
    case 0x81AA: code_point = 0xAC92; break; // HANGUL SYLLABLE KIYEOK E NIEUNHIEUH
    case 0x81AB: code_point = 0xAC93; break; // HANGUL SYLLABLE KIYEOK E TIKEUT
    case 0x81AC: code_point = 0xAC95; break; // HANGUL SYLLABLE KIYEOK E RIEULKIYEOK
    case 0x81AD: code_point = 0xAC96; break; // HANGUL SYLLABLE KIYEOK E RIEULMIEUM
    case 0x81AE: code_point = 0xAC97; break; // HANGUL SYLLABLE KIYEOK E RIEULPIEUP
    case 0x81AF: code_point = 0xAC98; break; // HANGUL SYLLABLE KIYEOK E RIEULSIOS
    case 0x81B0: code_point = 0xAC99; break; // HANGUL SYLLABLE KIYEOK E RIEULTHIEUTH
    case 0x81B1: code_point = 0xAC9A; break; // HANGUL SYLLABLE KIYEOK E RIEULPHIEUPH
    case 0x81B2: code_point = 0xAC9B; break; // HANGUL SYLLABLE KIYEOK E RIEULHIEUH
    case 0x81B3: code_point = 0xAC9E; break; // HANGUL SYLLABLE KIYEOK E PIEUPSIOS
    case 0x81B4: code_point = 0xACA2; break; // HANGUL SYLLABLE KIYEOK E CIEUC
    case 0x81B5: code_point = 0xACA3; break; // HANGUL SYLLABLE KIYEOK E CHIEUCH
    case 0x81B6: code_point = 0xACA4; break; // HANGUL SYLLABLE KIYEOK E KHIEUKH
    case 0x81B7: code_point = 0xACA5; break; // HANGUL SYLLABLE KIYEOK E THIEUTH
    case 0x81B8: code_point = 0xACA6; break; // HANGUL SYLLABLE KIYEOK E PHIEUPH
    case 0x81B9: code_point = 0xACA7; break; // HANGUL SYLLABLE KIYEOK E HIEUH
    case 0x81BA: code_point = 0xACAB; break; // HANGUL SYLLABLE KIYEOK YEO KIYEOKSIOS
    case 0x81BB: code_point = 0xACAD; break; // HANGUL SYLLABLE KIYEOK YEO NIEUNCIEUC
    case 0x81BC: code_point = 0xACAE; break; // HANGUL SYLLABLE KIYEOK YEO NIEUNHIEUH
    case 0x81BD: code_point = 0xACB1; break; // HANGUL SYLLABLE KIYEOK YEO RIEULKIYEOK
    case 0x81BE: code_point = 0xACB2; break; // HANGUL SYLLABLE KIYEOK YEO RIEULMIEUM
    case 0x81BF: code_point = 0xACB3; break; // HANGUL SYLLABLE KIYEOK YEO RIEULPIEUP
    case 0x81C0: code_point = 0xACB4; break; // HANGUL SYLLABLE KIYEOK YEO RIEULSIOS
    case 0x81C1: code_point = 0xACB5; break; // HANGUL SYLLABLE KIYEOK YEO RIEULTHIEUTH
    case 0x81C2: code_point = 0xACB6; break; // HANGUL SYLLABLE KIYEOK YEO RIEULPHIEUPH
    case 0x81C3: code_point = 0xACB7; break; // HANGUL SYLLABLE KIYEOK YEO RIEULHIEUH
    case 0x81C4: code_point = 0xACBA; break; // HANGUL SYLLABLE KIYEOK YEO PIEUPSIOS
    case 0x81C5: code_point = 0xACBE; break; // HANGUL SYLLABLE KIYEOK YEO CIEUC
    case 0x81C6: code_point = 0xACBF; break; // HANGUL SYLLABLE KIYEOK YEO CHIEUCH
    case 0x81C7: code_point = 0xACC0; break; // HANGUL SYLLABLE KIYEOK YEO KHIEUKH
    case 0x81C8: code_point = 0xACC2; break; // HANGUL SYLLABLE KIYEOK YEO PHIEUPH
    case 0x81C9: code_point = 0xACC3; break; // HANGUL SYLLABLE KIYEOK YEO HIEUH
    case 0x81CA: code_point = 0xACC5; break; // HANGUL SYLLABLE KIYEOK YE KIYEOK
    case 0x81CB: code_point = 0xACC6; break; // HANGUL SYLLABLE KIYEOK YE SSANGKIYEOK
    case 0x81CC: code_point = 0xACC7; break; // HANGUL SYLLABLE KIYEOK YE KIYEOKSIOS
    case 0x81CD: code_point = 0xACC9; break; // HANGUL SYLLABLE KIYEOK YE NIEUNCIEUC
    case 0x81CE: code_point = 0xACCA; break; // HANGUL SYLLABLE KIYEOK YE NIEUNHIEUH
    case 0x81CF: code_point = 0xACCB; break; // HANGUL SYLLABLE KIYEOK YE TIKEUT
    case 0x81D0: code_point = 0xACCD; break; // HANGUL SYLLABLE KIYEOK YE RIEULKIYEOK
    case 0x81D1: code_point = 0xACCE; break; // HANGUL SYLLABLE KIYEOK YE RIEULMIEUM
    case 0x81D2: code_point = 0xACCF; break; // HANGUL SYLLABLE KIYEOK YE RIEULPIEUP
    case 0x81D3: code_point = 0xACD0; break; // HANGUL SYLLABLE KIYEOK YE RIEULSIOS
    case 0x81D4: code_point = 0xACD1; break; // HANGUL SYLLABLE KIYEOK YE RIEULTHIEUTH
    case 0x81D5: code_point = 0xACD2; break; // HANGUL SYLLABLE KIYEOK YE RIEULPHIEUPH
    case 0x81D6: code_point = 0xACD3; break; // HANGUL SYLLABLE KIYEOK YE RIEULHIEUH
    case 0x81D7: code_point = 0xACD4; break; // HANGUL SYLLABLE KIYEOK YE MIEUM
    case 0x81D8: code_point = 0xACD6; break; // HANGUL SYLLABLE KIYEOK YE PIEUPSIOS
    case 0x81D9: code_point = 0xACD8; break; // HANGUL SYLLABLE KIYEOK YE SSANGSIOS
    case 0x81DA: code_point = 0xACD9; break; // HANGUL SYLLABLE KIYEOK YE IEUNG
    case 0x81DB: code_point = 0xACDA; break; // HANGUL SYLLABLE KIYEOK YE CIEUC
    case 0x81DC: code_point = 0xACDB; break; // HANGUL SYLLABLE KIYEOK YE CHIEUCH
    case 0x81DD: code_point = 0xACDC; break; // HANGUL SYLLABLE KIYEOK YE KHIEUKH
    case 0x81DE: code_point = 0xACDD; break; // HANGUL SYLLABLE KIYEOK YE THIEUTH
    case 0x81DF: code_point = 0xACDE; break; // HANGUL SYLLABLE KIYEOK YE PHIEUPH
    case 0x81E0: code_point = 0xACDF; break; // HANGUL SYLLABLE KIYEOK YE HIEUH
    case 0x81E1: code_point = 0xACE2; break; // HANGUL SYLLABLE KIYEOK O SSANGKIYEOK
    case 0x81E2: code_point = 0xACE3; break; // HANGUL SYLLABLE KIYEOK O KIYEOKSIOS
    case 0x81E3: code_point = 0xACE5; break; // HANGUL SYLLABLE KIYEOK O NIEUNCIEUC
    case 0x81E4: code_point = 0xACE6; break; // HANGUL SYLLABLE KIYEOK O NIEUNHIEUH
    case 0x81E5: code_point = 0xACE9; break; // HANGUL SYLLABLE KIYEOK O RIEULKIYEOK
    case 0x81E6: code_point = 0xACEB; break; // HANGUL SYLLABLE KIYEOK O RIEULPIEUP
    case 0x81E7: code_point = 0xACED; break; // HANGUL SYLLABLE KIYEOK O RIEULTHIEUTH
    case 0x81E8: code_point = 0xACEE; break; // HANGUL SYLLABLE KIYEOK O RIEULPHIEUPH
    case 0x81E9: code_point = 0xACF2; break; // HANGUL SYLLABLE KIYEOK O PIEUPSIOS
    case 0x81EA: code_point = 0xACF4; break; // HANGUL SYLLABLE KIYEOK O SSANGSIOS
    case 0x81EB: code_point = 0xACF7; break; // HANGUL SYLLABLE KIYEOK O CHIEUCH
    case 0x81EC: code_point = 0xACF8; break; // HANGUL SYLLABLE KIYEOK O KHIEUKH
    case 0x81ED: code_point = 0xACF9; break; // HANGUL SYLLABLE KIYEOK O THIEUTH
    case 0x81EE: code_point = 0xACFA; break; // HANGUL SYLLABLE KIYEOK O PHIEUPH
    case 0x81EF: code_point = 0xACFB; break; // HANGUL SYLLABLE KIYEOK O HIEUH
    case 0x81F0: code_point = 0xACFE; break; // HANGUL SYLLABLE KIYEOK WA SSANGKIYEOK
    case 0x81F1: code_point = 0xACFF; break; // HANGUL SYLLABLE KIYEOK WA KIYEOKSIOS
    case 0x81F2: code_point = 0xAD01; break; // HANGUL SYLLABLE KIYEOK WA NIEUNCIEUC
    case 0x81F3: code_point = 0xAD02; break; // HANGUL SYLLABLE KIYEOK WA NIEUNHIEUH
    case 0x81F4: code_point = 0xAD03; break; // HANGUL SYLLABLE KIYEOK WA TIKEUT
    case 0x81F5: code_point = 0xAD05; break; // HANGUL SYLLABLE KIYEOK WA RIEULKIYEOK
    case 0x81F6: code_point = 0xAD07; break; // HANGUL SYLLABLE KIYEOK WA RIEULPIEUP
    case 0x81F7: code_point = 0xAD08; break; // HANGUL SYLLABLE KIYEOK WA RIEULSIOS
    case 0x81F8: code_point = 0xAD09; break; // HANGUL SYLLABLE KIYEOK WA RIEULTHIEUTH
    case 0x81F9: code_point = 0xAD0A; break; // HANGUL SYLLABLE KIYEOK WA RIEULPHIEUPH
    case 0x81FA: code_point = 0xAD0B; break; // HANGUL SYLLABLE KIYEOK WA RIEULHIEUH
    case 0x81FB: code_point = 0xAD0E; break; // HANGUL SYLLABLE KIYEOK WA PIEUPSIOS
    case 0x81FC: code_point = 0xAD10; break; // HANGUL SYLLABLE KIYEOK WA SSANGSIOS
    case 0x81FD: code_point = 0xAD12; break; // HANGUL SYLLABLE KIYEOK WA CIEUC
    case 0x81FE: code_point = 0xAD13; break; // HANGUL SYLLABLE KIYEOK WA CHIEUCH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x82(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8241: code_point = 0xAD14; break; // HANGUL SYLLABLE KIYEOK WA KHIEUKH
    case 0x8242: code_point = 0xAD15; break; // HANGUL SYLLABLE KIYEOK WA THIEUTH
    case 0x8243: code_point = 0xAD16; break; // HANGUL SYLLABLE KIYEOK WA PHIEUPH
    case 0x8244: code_point = 0xAD17; break; // HANGUL SYLLABLE KIYEOK WA HIEUH
    case 0x8245: code_point = 0xAD19; break; // HANGUL SYLLABLE KIYEOK WAE KIYEOK
    case 0x8246: code_point = 0xAD1A; break; // HANGUL SYLLABLE KIYEOK WAE SSANGKIYEOK
    case 0x8247: code_point = 0xAD1B; break; // HANGUL SYLLABLE KIYEOK WAE KIYEOKSIOS
    case 0x8248: code_point = 0xAD1D; break; // HANGUL SYLLABLE KIYEOK WAE NIEUNCIEUC
    case 0x8249: code_point = 0xAD1E; break; // HANGUL SYLLABLE KIYEOK WAE NIEUNHIEUH
    case 0x824A: code_point = 0xAD1F; break; // HANGUL SYLLABLE KIYEOK WAE TIKEUT
    case 0x824B: code_point = 0xAD21; break; // HANGUL SYLLABLE KIYEOK WAE RIEULKIYEOK
    case 0x824C: code_point = 0xAD22; break; // HANGUL SYLLABLE KIYEOK WAE RIEULMIEUM
    case 0x824D: code_point = 0xAD23; break; // HANGUL SYLLABLE KIYEOK WAE RIEULPIEUP
    case 0x824E: code_point = 0xAD24; break; // HANGUL SYLLABLE KIYEOK WAE RIEULSIOS
    case 0x824F: code_point = 0xAD25; break; // HANGUL SYLLABLE KIYEOK WAE RIEULTHIEUTH
    case 0x8250: code_point = 0xAD26; break; // HANGUL SYLLABLE KIYEOK WAE RIEULPHIEUPH
    case 0x8251: code_point = 0xAD27; break; // HANGUL SYLLABLE KIYEOK WAE RIEULHIEUH
    case 0x8252: code_point = 0xAD28; break; // HANGUL SYLLABLE KIYEOK WAE MIEUM
    case 0x8253: code_point = 0xAD2A; break; // HANGUL SYLLABLE KIYEOK WAE PIEUPSIOS
    case 0x8254: code_point = 0xAD2B; break; // HANGUL SYLLABLE KIYEOK WAE SIOS
    case 0x8255: code_point = 0xAD2E; break; // HANGUL SYLLABLE KIYEOK WAE CIEUC
    case 0x8256: code_point = 0xAD2F; break; // HANGUL SYLLABLE KIYEOK WAE CHIEUCH
    case 0x8257: code_point = 0xAD30; break; // HANGUL SYLLABLE KIYEOK WAE KHIEUKH
    case 0x8258: code_point = 0xAD31; break; // HANGUL SYLLABLE KIYEOK WAE THIEUTH
    case 0x8259: code_point = 0xAD32; break; // HANGUL SYLLABLE KIYEOK WAE PHIEUPH
    case 0x825A: code_point = 0xAD33; break; // HANGUL SYLLABLE KIYEOK WAE HIEUH
    case 0x8261: code_point = 0xAD36; break; // HANGUL SYLLABLE KIYEOK OE SSANGKIYEOK
    case 0x8262: code_point = 0xAD37; break; // HANGUL SYLLABLE KIYEOK OE KIYEOKSIOS
    case 0x8263: code_point = 0xAD39; break; // HANGUL SYLLABLE KIYEOK OE NIEUNCIEUC
    case 0x8264: code_point = 0xAD3A; break; // HANGUL SYLLABLE KIYEOK OE NIEUNHIEUH
    case 0x8265: code_point = 0xAD3B; break; // HANGUL SYLLABLE KIYEOK OE TIKEUT
    case 0x8266: code_point = 0xAD3D; break; // HANGUL SYLLABLE KIYEOK OE RIEULKIYEOK
    case 0x8267: code_point = 0xAD3E; break; // HANGUL SYLLABLE KIYEOK OE RIEULMIEUM
    case 0x8268: code_point = 0xAD3F; break; // HANGUL SYLLABLE KIYEOK OE RIEULPIEUP
    case 0x8269: code_point = 0xAD40; break; // HANGUL SYLLABLE KIYEOK OE RIEULSIOS
    case 0x826A: code_point = 0xAD41; break; // HANGUL SYLLABLE KIYEOK OE RIEULTHIEUTH
    case 0x826B: code_point = 0xAD42; break; // HANGUL SYLLABLE KIYEOK OE RIEULPHIEUPH
    case 0x826C: code_point = 0xAD43; break; // HANGUL SYLLABLE KIYEOK OE RIEULHIEUH
    case 0x826D: code_point = 0xAD46; break; // HANGUL SYLLABLE KIYEOK OE PIEUPSIOS
    case 0x826E: code_point = 0xAD48; break; // HANGUL SYLLABLE KIYEOK OE SSANGSIOS
    case 0x826F: code_point = 0xAD4A; break; // HANGUL SYLLABLE KIYEOK OE CIEUC
    case 0x8270: code_point = 0xAD4B; break; // HANGUL SYLLABLE KIYEOK OE CHIEUCH
    case 0x8271: code_point = 0xAD4C; break; // HANGUL SYLLABLE KIYEOK OE KHIEUKH
    case 0x8272: code_point = 0xAD4D; break; // HANGUL SYLLABLE KIYEOK OE THIEUTH
    case 0x8273: code_point = 0xAD4E; break; // HANGUL SYLLABLE KIYEOK OE PHIEUPH
    case 0x8274: code_point = 0xAD4F; break; // HANGUL SYLLABLE KIYEOK OE HIEUH
    case 0x8275: code_point = 0xAD51; break; // HANGUL SYLLABLE KIYEOK YO KIYEOK
    case 0x8276: code_point = 0xAD52; break; // HANGUL SYLLABLE KIYEOK YO SSANGKIYEOK
    case 0x8277: code_point = 0xAD53; break; // HANGUL SYLLABLE KIYEOK YO KIYEOKSIOS
    case 0x8278: code_point = 0xAD55; break; // HANGUL SYLLABLE KIYEOK YO NIEUNCIEUC
    case 0x8279: code_point = 0xAD56; break; // HANGUL SYLLABLE KIYEOK YO NIEUNHIEUH
    case 0x827A: code_point = 0xAD57; break; // HANGUL SYLLABLE KIYEOK YO TIKEUT
    case 0x8281: code_point = 0xAD59; break; // HANGUL SYLLABLE KIYEOK YO RIEULKIYEOK
    case 0x8282: code_point = 0xAD5A; break; // HANGUL SYLLABLE KIYEOK YO RIEULMIEUM
    case 0x8283: code_point = 0xAD5B; break; // HANGUL SYLLABLE KIYEOK YO RIEULPIEUP
    case 0x8284: code_point = 0xAD5C; break; // HANGUL SYLLABLE KIYEOK YO RIEULSIOS
    case 0x8285: code_point = 0xAD5D; break; // HANGUL SYLLABLE KIYEOK YO RIEULTHIEUTH
    case 0x8286: code_point = 0xAD5E; break; // HANGUL SYLLABLE KIYEOK YO RIEULPHIEUPH
    case 0x8287: code_point = 0xAD5F; break; // HANGUL SYLLABLE KIYEOK YO RIEULHIEUH
    case 0x8288: code_point = 0xAD60; break; // HANGUL SYLLABLE KIYEOK YO MIEUM
    case 0x8289: code_point = 0xAD62; break; // HANGUL SYLLABLE KIYEOK YO PIEUPSIOS
    case 0x828A: code_point = 0xAD64; break; // HANGUL SYLLABLE KIYEOK YO SSANGSIOS
    case 0x828B: code_point = 0xAD65; break; // HANGUL SYLLABLE KIYEOK YO IEUNG
    case 0x828C: code_point = 0xAD66; break; // HANGUL SYLLABLE KIYEOK YO CIEUC
    case 0x828D: code_point = 0xAD67; break; // HANGUL SYLLABLE KIYEOK YO CHIEUCH
    case 0x828E: code_point = 0xAD68; break; // HANGUL SYLLABLE KIYEOK YO KHIEUKH
    case 0x828F: code_point = 0xAD69; break; // HANGUL SYLLABLE KIYEOK YO THIEUTH
    case 0x8290: code_point = 0xAD6A; break; // HANGUL SYLLABLE KIYEOK YO PHIEUPH
    case 0x8291: code_point = 0xAD6B; break; // HANGUL SYLLABLE KIYEOK YO HIEUH
    case 0x8292: code_point = 0xAD6E; break; // HANGUL SYLLABLE KIYEOK U SSANGKIYEOK
    case 0x8293: code_point = 0xAD6F; break; // HANGUL SYLLABLE KIYEOK U KIYEOKSIOS
    case 0x8294: code_point = 0xAD71; break; // HANGUL SYLLABLE KIYEOK U NIEUNCIEUC
    case 0x8295: code_point = 0xAD72; break; // HANGUL SYLLABLE KIYEOK U NIEUNHIEUH
    case 0x8296: code_point = 0xAD77; break; // HANGUL SYLLABLE KIYEOK U RIEULPIEUP
    case 0x8297: code_point = 0xAD78; break; // HANGUL SYLLABLE KIYEOK U RIEULSIOS
    case 0x8298: code_point = 0xAD79; break; // HANGUL SYLLABLE KIYEOK U RIEULTHIEUTH
    case 0x8299: code_point = 0xAD7A; break; // HANGUL SYLLABLE KIYEOK U RIEULPHIEUPH
    case 0x829A: code_point = 0xAD7E; break; // HANGUL SYLLABLE KIYEOK U PIEUPSIOS
    case 0x829B: code_point = 0xAD80; break; // HANGUL SYLLABLE KIYEOK U SSANGSIOS
    case 0x829C: code_point = 0xAD83; break; // HANGUL SYLLABLE KIYEOK U CHIEUCH
    case 0x829D: code_point = 0xAD84; break; // HANGUL SYLLABLE KIYEOK U KHIEUKH
    case 0x829E: code_point = 0xAD85; break; // HANGUL SYLLABLE KIYEOK U THIEUTH
    case 0x829F: code_point = 0xAD86; break; // HANGUL SYLLABLE KIYEOK U PHIEUPH
    case 0x82A0: code_point = 0xAD87; break; // HANGUL SYLLABLE KIYEOK U HIEUH
    case 0x82A1: code_point = 0xAD8A; break; // HANGUL SYLLABLE KIYEOK WEO SSANGKIYEOK
    case 0x82A2: code_point = 0xAD8B; break; // HANGUL SYLLABLE KIYEOK WEO KIYEOKSIOS
    case 0x82A3: code_point = 0xAD8D; break; // HANGUL SYLLABLE KIYEOK WEO NIEUNCIEUC
    case 0x82A4: code_point = 0xAD8E; break; // HANGUL SYLLABLE KIYEOK WEO NIEUNHIEUH
    case 0x82A5: code_point = 0xAD8F; break; // HANGUL SYLLABLE KIYEOK WEO TIKEUT
    case 0x82A6: code_point = 0xAD91; break; // HANGUL SYLLABLE KIYEOK WEO RIEULKIYEOK
    case 0x82A7: code_point = 0xAD92; break; // HANGUL SYLLABLE KIYEOK WEO RIEULMIEUM
    case 0x82A8: code_point = 0xAD93; break; // HANGUL SYLLABLE KIYEOK WEO RIEULPIEUP
    case 0x82A9: code_point = 0xAD94; break; // HANGUL SYLLABLE KIYEOK WEO RIEULSIOS
    case 0x82AA: code_point = 0xAD95; break; // HANGUL SYLLABLE KIYEOK WEO RIEULTHIEUTH
    case 0x82AB: code_point = 0xAD96; break; // HANGUL SYLLABLE KIYEOK WEO RIEULPHIEUPH
    case 0x82AC: code_point = 0xAD97; break; // HANGUL SYLLABLE KIYEOK WEO RIEULHIEUH
    case 0x82AD: code_point = 0xAD98; break; // HANGUL SYLLABLE KIYEOK WEO MIEUM
    case 0x82AE: code_point = 0xAD99; break; // HANGUL SYLLABLE KIYEOK WEO PIEUP
    case 0x82AF: code_point = 0xAD9A; break; // HANGUL SYLLABLE KIYEOK WEO PIEUPSIOS
    case 0x82B0: code_point = 0xAD9B; break; // HANGUL SYLLABLE KIYEOK WEO SIOS
    case 0x82B1: code_point = 0xAD9E; break; // HANGUL SYLLABLE KIYEOK WEO CIEUC
    case 0x82B2: code_point = 0xAD9F; break; // HANGUL SYLLABLE KIYEOK WEO CHIEUCH
    case 0x82B3: code_point = 0xADA0; break; // HANGUL SYLLABLE KIYEOK WEO KHIEUKH
    case 0x82B4: code_point = 0xADA1; break; // HANGUL SYLLABLE KIYEOK WEO THIEUTH
    case 0x82B5: code_point = 0xADA2; break; // HANGUL SYLLABLE KIYEOK WEO PHIEUPH
    case 0x82B6: code_point = 0xADA3; break; // HANGUL SYLLABLE KIYEOK WEO HIEUH
    case 0x82B7: code_point = 0xADA5; break; // HANGUL SYLLABLE KIYEOK WE KIYEOK
    case 0x82B8: code_point = 0xADA6; break; // HANGUL SYLLABLE KIYEOK WE SSANGKIYEOK
    case 0x82B9: code_point = 0xADA7; break; // HANGUL SYLLABLE KIYEOK WE KIYEOKSIOS
    case 0x82BA: code_point = 0xADA8; break; // HANGUL SYLLABLE KIYEOK WE NIEUN
    case 0x82BB: code_point = 0xADA9; break; // HANGUL SYLLABLE KIYEOK WE NIEUNCIEUC
    case 0x82BC: code_point = 0xADAA; break; // HANGUL SYLLABLE KIYEOK WE NIEUNHIEUH
    case 0x82BD: code_point = 0xADAB; break; // HANGUL SYLLABLE KIYEOK WE TIKEUT
    case 0x82BE: code_point = 0xADAC; break; // HANGUL SYLLABLE KIYEOK WE RIEUL
    case 0x82BF: code_point = 0xADAD; break; // HANGUL SYLLABLE KIYEOK WE RIEULKIYEOK
    case 0x82C0: code_point = 0xADAE; break; // HANGUL SYLLABLE KIYEOK WE RIEULMIEUM
    case 0x82C1: code_point = 0xADAF; break; // HANGUL SYLLABLE KIYEOK WE RIEULPIEUP
    case 0x82C2: code_point = 0xADB0; break; // HANGUL SYLLABLE KIYEOK WE RIEULSIOS
    case 0x82C3: code_point = 0xADB1; break; // HANGUL SYLLABLE KIYEOK WE RIEULTHIEUTH
    case 0x82C4: code_point = 0xADB2; break; // HANGUL SYLLABLE KIYEOK WE RIEULPHIEUPH
    case 0x82C5: code_point = 0xADB3; break; // HANGUL SYLLABLE KIYEOK WE RIEULHIEUH
    case 0x82C6: code_point = 0xADB4; break; // HANGUL SYLLABLE KIYEOK WE MIEUM
    case 0x82C7: code_point = 0xADB5; break; // HANGUL SYLLABLE KIYEOK WE PIEUP
    case 0x82C8: code_point = 0xADB6; break; // HANGUL SYLLABLE KIYEOK WE PIEUPSIOS
    case 0x82C9: code_point = 0xADB8; break; // HANGUL SYLLABLE KIYEOK WE SSANGSIOS
    case 0x82CA: code_point = 0xADB9; break; // HANGUL SYLLABLE KIYEOK WE IEUNG
    case 0x82CB: code_point = 0xADBA; break; // HANGUL SYLLABLE KIYEOK WE CIEUC
    case 0x82CC: code_point = 0xADBB; break; // HANGUL SYLLABLE KIYEOK WE CHIEUCH
    case 0x82CD: code_point = 0xADBC; break; // HANGUL SYLLABLE KIYEOK WE KHIEUKH
    case 0x82CE: code_point = 0xADBD; break; // HANGUL SYLLABLE KIYEOK WE THIEUTH
    case 0x82CF: code_point = 0xADBE; break; // HANGUL SYLLABLE KIYEOK WE PHIEUPH
    case 0x82D0: code_point = 0xADBF; break; // HANGUL SYLLABLE KIYEOK WE HIEUH
    case 0x82D1: code_point = 0xADC2; break; // HANGUL SYLLABLE KIYEOK WI SSANGKIYEOK
    case 0x82D2: code_point = 0xADC3; break; // HANGUL SYLLABLE KIYEOK WI KIYEOKSIOS
    case 0x82D3: code_point = 0xADC5; break; // HANGUL SYLLABLE KIYEOK WI NIEUNCIEUC
    case 0x82D4: code_point = 0xADC6; break; // HANGUL SYLLABLE KIYEOK WI NIEUNHIEUH
    case 0x82D5: code_point = 0xADC7; break; // HANGUL SYLLABLE KIYEOK WI TIKEUT
    case 0x82D6: code_point = 0xADC9; break; // HANGUL SYLLABLE KIYEOK WI RIEULKIYEOK
    case 0x82D7: code_point = 0xADCA; break; // HANGUL SYLLABLE KIYEOK WI RIEULMIEUM
    case 0x82D8: code_point = 0xADCB; break; // HANGUL SYLLABLE KIYEOK WI RIEULPIEUP
    case 0x82D9: code_point = 0xADCC; break; // HANGUL SYLLABLE KIYEOK WI RIEULSIOS
    case 0x82DA: code_point = 0xADCD; break; // HANGUL SYLLABLE KIYEOK WI RIEULTHIEUTH
    case 0x82DB: code_point = 0xADCE; break; // HANGUL SYLLABLE KIYEOK WI RIEULPHIEUPH
    case 0x82DC: code_point = 0xADCF; break; // HANGUL SYLLABLE KIYEOK WI RIEULHIEUH
    case 0x82DD: code_point = 0xADD2; break; // HANGUL SYLLABLE KIYEOK WI PIEUPSIOS
    case 0x82DE: code_point = 0xADD4; break; // HANGUL SYLLABLE KIYEOK WI SSANGSIOS
    case 0x82DF: code_point = 0xADD5; break; // HANGUL SYLLABLE KIYEOK WI IEUNG
    case 0x82E0: code_point = 0xADD6; break; // HANGUL SYLLABLE KIYEOK WI CIEUC
    case 0x82E1: code_point = 0xADD7; break; // HANGUL SYLLABLE KIYEOK WI CHIEUCH
    case 0x82E2: code_point = 0xADD8; break; // HANGUL SYLLABLE KIYEOK WI KHIEUKH
    case 0x82E3: code_point = 0xADD9; break; // HANGUL SYLLABLE KIYEOK WI THIEUTH
    case 0x82E4: code_point = 0xADDA; break; // HANGUL SYLLABLE KIYEOK WI PHIEUPH
    case 0x82E5: code_point = 0xADDB; break; // HANGUL SYLLABLE KIYEOK WI HIEUH
    case 0x82E6: code_point = 0xADDD; break; // HANGUL SYLLABLE KIYEOK YU KIYEOK
    case 0x82E7: code_point = 0xADDE; break; // HANGUL SYLLABLE KIYEOK YU SSANGKIYEOK
    case 0x82E8: code_point = 0xADDF; break; // HANGUL SYLLABLE KIYEOK YU KIYEOKSIOS
    case 0x82E9: code_point = 0xADE1; break; // HANGUL SYLLABLE KIYEOK YU NIEUNCIEUC
    case 0x82EA: code_point = 0xADE2; break; // HANGUL SYLLABLE KIYEOK YU NIEUNHIEUH
    case 0x82EB: code_point = 0xADE3; break; // HANGUL SYLLABLE KIYEOK YU TIKEUT
    case 0x82EC: code_point = 0xADE5; break; // HANGUL SYLLABLE KIYEOK YU RIEULKIYEOK
    case 0x82ED: code_point = 0xADE6; break; // HANGUL SYLLABLE KIYEOK YU RIEULMIEUM
    case 0x82EE: code_point = 0xADE7; break; // HANGUL SYLLABLE KIYEOK YU RIEULPIEUP
    case 0x82EF: code_point = 0xADE8; break; // HANGUL SYLLABLE KIYEOK YU RIEULSIOS
    case 0x82F0: code_point = 0xADE9; break; // HANGUL SYLLABLE KIYEOK YU RIEULTHIEUTH
    case 0x82F1: code_point = 0xADEA; break; // HANGUL SYLLABLE KIYEOK YU RIEULPHIEUPH
    case 0x82F2: code_point = 0xADEB; break; // HANGUL SYLLABLE KIYEOK YU RIEULHIEUH
    case 0x82F3: code_point = 0xADEC; break; // HANGUL SYLLABLE KIYEOK YU MIEUM
    case 0x82F4: code_point = 0xADED; break; // HANGUL SYLLABLE KIYEOK YU PIEUP
    case 0x82F5: code_point = 0xADEE; break; // HANGUL SYLLABLE KIYEOK YU PIEUPSIOS
    case 0x82F6: code_point = 0xADEF; break; // HANGUL SYLLABLE KIYEOK YU SIOS
    case 0x82F7: code_point = 0xADF0; break; // HANGUL SYLLABLE KIYEOK YU SSANGSIOS
    case 0x82F8: code_point = 0xADF1; break; // HANGUL SYLLABLE KIYEOK YU IEUNG
    case 0x82F9: code_point = 0xADF2; break; // HANGUL SYLLABLE KIYEOK YU CIEUC
    case 0x82FA: code_point = 0xADF3; break; // HANGUL SYLLABLE KIYEOK YU CHIEUCH
    case 0x82FB: code_point = 0xADF4; break; // HANGUL SYLLABLE KIYEOK YU KHIEUKH
    case 0x82FC: code_point = 0xADF5; break; // HANGUL SYLLABLE KIYEOK YU THIEUTH
    case 0x82FD: code_point = 0xADF6; break; // HANGUL SYLLABLE KIYEOK YU PHIEUPH
    case 0x82FE: code_point = 0xADF7; break; // HANGUL SYLLABLE KIYEOK YU HIEUH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x83(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8341: code_point = 0xADFA; break; // HANGUL SYLLABLE KIYEOK EU SSANGKIYEOK
    case 0x8342: code_point = 0xADFB; break; // HANGUL SYLLABLE KIYEOK EU KIYEOKSIOS
    case 0x8343: code_point = 0xADFD; break; // HANGUL SYLLABLE KIYEOK EU NIEUNCIEUC
    case 0x8344: code_point = 0xADFE; break; // HANGUL SYLLABLE KIYEOK EU NIEUNHIEUH
    case 0x8345: code_point = 0xAE02; break; // HANGUL SYLLABLE KIYEOK EU RIEULMIEUM
    case 0x8346: code_point = 0xAE03; break; // HANGUL SYLLABLE KIYEOK EU RIEULPIEUP
    case 0x8347: code_point = 0xAE04; break; // HANGUL SYLLABLE KIYEOK EU RIEULSIOS
    case 0x8348: code_point = 0xAE05; break; // HANGUL SYLLABLE KIYEOK EU RIEULTHIEUTH
    case 0x8349: code_point = 0xAE06; break; // HANGUL SYLLABLE KIYEOK EU RIEULPHIEUPH
    case 0x834A: code_point = 0xAE07; break; // HANGUL SYLLABLE KIYEOK EU RIEULHIEUH
    case 0x834B: code_point = 0xAE0A; break; // HANGUL SYLLABLE KIYEOK EU PIEUPSIOS
    case 0x834C: code_point = 0xAE0C; break; // HANGUL SYLLABLE KIYEOK EU SSANGSIOS
    case 0x834D: code_point = 0xAE0E; break; // HANGUL SYLLABLE KIYEOK EU CIEUC
    case 0x834E: code_point = 0xAE0F; break; // HANGUL SYLLABLE KIYEOK EU CHIEUCH
    case 0x834F: code_point = 0xAE10; break; // HANGUL SYLLABLE KIYEOK EU KHIEUKH
    case 0x8350: code_point = 0xAE11; break; // HANGUL SYLLABLE KIYEOK EU THIEUTH
    case 0x8351: code_point = 0xAE12; break; // HANGUL SYLLABLE KIYEOK EU PHIEUPH
    case 0x8352: code_point = 0xAE13; break; // HANGUL SYLLABLE KIYEOK EU HIEUH
    case 0x8353: code_point = 0xAE15; break; // HANGUL SYLLABLE KIYEOK YI KIYEOK
    case 0x8354: code_point = 0xAE16; break; // HANGUL SYLLABLE KIYEOK YI SSANGKIYEOK
    case 0x8355: code_point = 0xAE17; break; // HANGUL SYLLABLE KIYEOK YI KIYEOKSIOS
    case 0x8356: code_point = 0xAE18; break; // HANGUL SYLLABLE KIYEOK YI NIEUN
    case 0x8357: code_point = 0xAE19; break; // HANGUL SYLLABLE KIYEOK YI NIEUNCIEUC
    case 0x8358: code_point = 0xAE1A; break; // HANGUL SYLLABLE KIYEOK YI NIEUNHIEUH
    case 0x8359: code_point = 0xAE1B; break; // HANGUL SYLLABLE KIYEOK YI TIKEUT
    case 0x835A: code_point = 0xAE1C; break; // HANGUL SYLLABLE KIYEOK YI RIEUL
    case 0x8361: code_point = 0xAE1D; break; // HANGUL SYLLABLE KIYEOK YI RIEULKIYEOK
    case 0x8362: code_point = 0xAE1E; break; // HANGUL SYLLABLE KIYEOK YI RIEULMIEUM
    case 0x8363: code_point = 0xAE1F; break; // HANGUL SYLLABLE KIYEOK YI RIEULPIEUP
    case 0x8364: code_point = 0xAE20; break; // HANGUL SYLLABLE KIYEOK YI RIEULSIOS
    case 0x8365: code_point = 0xAE21; break; // HANGUL SYLLABLE KIYEOK YI RIEULTHIEUTH
    case 0x8366: code_point = 0xAE22; break; // HANGUL SYLLABLE KIYEOK YI RIEULPHIEUPH
    case 0x8367: code_point = 0xAE23; break; // HANGUL SYLLABLE KIYEOK YI RIEULHIEUH
    case 0x8368: code_point = 0xAE24; break; // HANGUL SYLLABLE KIYEOK YI MIEUM
    case 0x8369: code_point = 0xAE25; break; // HANGUL SYLLABLE KIYEOK YI PIEUP
    case 0x836A: code_point = 0xAE26; break; // HANGUL SYLLABLE KIYEOK YI PIEUPSIOS
    case 0x836B: code_point = 0xAE27; break; // HANGUL SYLLABLE KIYEOK YI SIOS
    case 0x836C: code_point = 0xAE28; break; // HANGUL SYLLABLE KIYEOK YI SSANGSIOS
    case 0x836D: code_point = 0xAE29; break; // HANGUL SYLLABLE KIYEOK YI IEUNG
    case 0x836E: code_point = 0xAE2A; break; // HANGUL SYLLABLE KIYEOK YI CIEUC
    case 0x836F: code_point = 0xAE2B; break; // HANGUL SYLLABLE KIYEOK YI CHIEUCH
    case 0x8370: code_point = 0xAE2C; break; // HANGUL SYLLABLE KIYEOK YI KHIEUKH
    case 0x8371: code_point = 0xAE2D; break; // HANGUL SYLLABLE KIYEOK YI THIEUTH
    case 0x8372: code_point = 0xAE2E; break; // HANGUL SYLLABLE KIYEOK YI PHIEUPH
    case 0x8373: code_point = 0xAE2F; break; // HANGUL SYLLABLE KIYEOK YI HIEUH
    case 0x8374: code_point = 0xAE32; break; // HANGUL SYLLABLE KIYEOK I SSANGKIYEOK
    case 0x8375: code_point = 0xAE33; break; // HANGUL SYLLABLE KIYEOK I KIYEOKSIOS
    case 0x8376: code_point = 0xAE35; break; // HANGUL SYLLABLE KIYEOK I NIEUNCIEUC
    case 0x8377: code_point = 0xAE36; break; // HANGUL SYLLABLE KIYEOK I NIEUNHIEUH
    case 0x8378: code_point = 0xAE39; break; // HANGUL SYLLABLE KIYEOK I RIEULKIYEOK
    case 0x8379: code_point = 0xAE3B; break; // HANGUL SYLLABLE KIYEOK I RIEULPIEUP
    case 0x837A: code_point = 0xAE3C; break; // HANGUL SYLLABLE KIYEOK I RIEULSIOS
    case 0x8381: code_point = 0xAE3D; break; // HANGUL SYLLABLE KIYEOK I RIEULTHIEUTH
    case 0x8382: code_point = 0xAE3E; break; // HANGUL SYLLABLE KIYEOK I RIEULPHIEUPH
    case 0x8383: code_point = 0xAE3F; break; // HANGUL SYLLABLE KIYEOK I RIEULHIEUH
    case 0x8384: code_point = 0xAE42; break; // HANGUL SYLLABLE KIYEOK I PIEUPSIOS
    case 0x8385: code_point = 0xAE44; break; // HANGUL SYLLABLE KIYEOK I SSANGSIOS
    case 0x8386: code_point = 0xAE47; break; // HANGUL SYLLABLE KIYEOK I CHIEUCH
    case 0x8387: code_point = 0xAE48; break; // HANGUL SYLLABLE KIYEOK I KHIEUKH
    case 0x8388: code_point = 0xAE49; break; // HANGUL SYLLABLE KIYEOK I THIEUTH
    case 0x8389: code_point = 0xAE4B; break; // HANGUL SYLLABLE KIYEOK I HIEUH
    case 0x838A: code_point = 0xAE4F; break; // HANGUL SYLLABLE SSANGKIYEOK A KIYEOKSIOS
    case 0x838B: code_point = 0xAE51; break; // HANGUL SYLLABLE SSANGKIYEOK A NIEUNCIEUC
    case 0x838C: code_point = 0xAE52; break; // HANGUL SYLLABLE SSANGKIYEOK A NIEUNHIEUH
    case 0x838D: code_point = 0xAE53; break; // HANGUL SYLLABLE SSANGKIYEOK A TIKEUT
    case 0x838E: code_point = 0xAE55; break; // HANGUL SYLLABLE SSANGKIYEOK A RIEULKIYEOK
    case 0x838F: code_point = 0xAE57; break; // HANGUL SYLLABLE SSANGKIYEOK A RIEULPIEUP
    case 0x8390: code_point = 0xAE58; break; // HANGUL SYLLABLE SSANGKIYEOK A RIEULSIOS
    case 0x8391: code_point = 0xAE59; break; // HANGUL SYLLABLE SSANGKIYEOK A RIEULTHIEUTH
    case 0x8392: code_point = 0xAE5A; break; // HANGUL SYLLABLE SSANGKIYEOK A RIEULPHIEUPH
    case 0x8393: code_point = 0xAE5B; break; // HANGUL SYLLABLE SSANGKIYEOK A RIEULHIEUH
    case 0x8394: code_point = 0xAE5E; break; // HANGUL SYLLABLE SSANGKIYEOK A PIEUPSIOS
    case 0x8395: code_point = 0xAE62; break; // HANGUL SYLLABLE SSANGKIYEOK A CIEUC
    case 0x8396: code_point = 0xAE63; break; // HANGUL SYLLABLE SSANGKIYEOK A CHIEUCH
    case 0x8397: code_point = 0xAE64; break; // HANGUL SYLLABLE SSANGKIYEOK A KHIEUKH
    case 0x8398: code_point = 0xAE66; break; // HANGUL SYLLABLE SSANGKIYEOK A PHIEUPH
    case 0x8399: code_point = 0xAE67; break; // HANGUL SYLLABLE SSANGKIYEOK A HIEUH
    case 0x839A: code_point = 0xAE6A; break; // HANGUL SYLLABLE SSANGKIYEOK AE SSANGKIYEOK
    case 0x839B: code_point = 0xAE6B; break; // HANGUL SYLLABLE SSANGKIYEOK AE KIYEOKSIOS
    case 0x839C: code_point = 0xAE6D; break; // HANGUL SYLLABLE SSANGKIYEOK AE NIEUNCIEUC
    case 0x839D: code_point = 0xAE6E; break; // HANGUL SYLLABLE SSANGKIYEOK AE NIEUNHIEUH
    case 0x839E: code_point = 0xAE6F; break; // HANGUL SYLLABLE SSANGKIYEOK AE TIKEUT
    case 0x839F: code_point = 0xAE71; break; // HANGUL SYLLABLE SSANGKIYEOK AE RIEULKIYEOK
    case 0x83A0: code_point = 0xAE72; break; // HANGUL SYLLABLE SSANGKIYEOK AE RIEULMIEUM
    case 0x83A1: code_point = 0xAE73; break; // HANGUL SYLLABLE SSANGKIYEOK AE RIEULPIEUP
    case 0x83A2: code_point = 0xAE74; break; // HANGUL SYLLABLE SSANGKIYEOK AE RIEULSIOS
    case 0x83A3: code_point = 0xAE75; break; // HANGUL SYLLABLE SSANGKIYEOK AE RIEULTHIEUTH
    case 0x83A4: code_point = 0xAE76; break; // HANGUL SYLLABLE SSANGKIYEOK AE RIEULPHIEUPH
    case 0x83A5: code_point = 0xAE77; break; // HANGUL SYLLABLE SSANGKIYEOK AE RIEULHIEUH
    case 0x83A6: code_point = 0xAE7A; break; // HANGUL SYLLABLE SSANGKIYEOK AE PIEUPSIOS
    case 0x83A7: code_point = 0xAE7E; break; // HANGUL SYLLABLE SSANGKIYEOK AE CIEUC
    case 0x83A8: code_point = 0xAE7F; break; // HANGUL SYLLABLE SSANGKIYEOK AE CHIEUCH
    case 0x83A9: code_point = 0xAE80; break; // HANGUL SYLLABLE SSANGKIYEOK AE KHIEUKH
    case 0x83AA: code_point = 0xAE81; break; // HANGUL SYLLABLE SSANGKIYEOK AE THIEUTH
    case 0x83AB: code_point = 0xAE82; break; // HANGUL SYLLABLE SSANGKIYEOK AE PHIEUPH
    case 0x83AC: code_point = 0xAE83; break; // HANGUL SYLLABLE SSANGKIYEOK AE HIEUH
    case 0x83AD: code_point = 0xAE86; break; // HANGUL SYLLABLE SSANGKIYEOK YA SSANGKIYEOK
    case 0x83AE: code_point = 0xAE87; break; // HANGUL SYLLABLE SSANGKIYEOK YA KIYEOKSIOS
    case 0x83AF: code_point = 0xAE88; break; // HANGUL SYLLABLE SSANGKIYEOK YA NIEUN
    case 0x83B0: code_point = 0xAE89; break; // HANGUL SYLLABLE SSANGKIYEOK YA NIEUNCIEUC
    case 0x83B1: code_point = 0xAE8A; break; // HANGUL SYLLABLE SSANGKIYEOK YA NIEUNHIEUH
    case 0x83B2: code_point = 0xAE8B; break; // HANGUL SYLLABLE SSANGKIYEOK YA TIKEUT
    case 0x83B3: code_point = 0xAE8D; break; // HANGUL SYLLABLE SSANGKIYEOK YA RIEULKIYEOK
    case 0x83B4: code_point = 0xAE8E; break; // HANGUL SYLLABLE SSANGKIYEOK YA RIEULMIEUM
    case 0x83B5: code_point = 0xAE8F; break; // HANGUL SYLLABLE SSANGKIYEOK YA RIEULPIEUP
    case 0x83B6: code_point = 0xAE90; break; // HANGUL SYLLABLE SSANGKIYEOK YA RIEULSIOS
    case 0x83B7: code_point = 0xAE91; break; // HANGUL SYLLABLE SSANGKIYEOK YA RIEULTHIEUTH
    case 0x83B8: code_point = 0xAE92; break; // HANGUL SYLLABLE SSANGKIYEOK YA RIEULPHIEUPH
    case 0x83B9: code_point = 0xAE93; break; // HANGUL SYLLABLE SSANGKIYEOK YA RIEULHIEUH
    case 0x83BA: code_point = 0xAE94; break; // HANGUL SYLLABLE SSANGKIYEOK YA MIEUM
    case 0x83BB: code_point = 0xAE95; break; // HANGUL SYLLABLE SSANGKIYEOK YA PIEUP
    case 0x83BC: code_point = 0xAE96; break; // HANGUL SYLLABLE SSANGKIYEOK YA PIEUPSIOS
    case 0x83BD: code_point = 0xAE97; break; // HANGUL SYLLABLE SSANGKIYEOK YA SIOS
    case 0x83BE: code_point = 0xAE98; break; // HANGUL SYLLABLE SSANGKIYEOK YA SSANGSIOS
    case 0x83BF: code_point = 0xAE99; break; // HANGUL SYLLABLE SSANGKIYEOK YA IEUNG
    case 0x83C0: code_point = 0xAE9A; break; // HANGUL SYLLABLE SSANGKIYEOK YA CIEUC
    case 0x83C1: code_point = 0xAE9B; break; // HANGUL SYLLABLE SSANGKIYEOK YA CHIEUCH
    case 0x83C2: code_point = 0xAE9C; break; // HANGUL SYLLABLE SSANGKIYEOK YA KHIEUKH
    case 0x83C3: code_point = 0xAE9D; break; // HANGUL SYLLABLE SSANGKIYEOK YA THIEUTH
    case 0x83C4: code_point = 0xAE9E; break; // HANGUL SYLLABLE SSANGKIYEOK YA PHIEUPH
    case 0x83C5: code_point = 0xAE9F; break; // HANGUL SYLLABLE SSANGKIYEOK YA HIEUH
    case 0x83C6: code_point = 0xAEA0; break; // HANGUL SYLLABLE SSANGKIYEOK YAE
    case 0x83C7: code_point = 0xAEA1; break; // HANGUL SYLLABLE SSANGKIYEOK YAE KIYEOK
    case 0x83C8: code_point = 0xAEA2; break; // HANGUL SYLLABLE SSANGKIYEOK YAE SSANGKIYEOK
    case 0x83C9: code_point = 0xAEA3; break; // HANGUL SYLLABLE SSANGKIYEOK YAE KIYEOKSIOS
    case 0x83CA: code_point = 0xAEA4; break; // HANGUL SYLLABLE SSANGKIYEOK YAE NIEUN
    case 0x83CB: code_point = 0xAEA5; break; // HANGUL SYLLABLE SSANGKIYEOK YAE NIEUNCIEUC
    case 0x83CC: code_point = 0xAEA6; break; // HANGUL SYLLABLE SSANGKIYEOK YAE NIEUNHIEUH
    case 0x83CD: code_point = 0xAEA7; break; // HANGUL SYLLABLE SSANGKIYEOK YAE TIKEUT
    case 0x83CE: code_point = 0xAEA8; break; // HANGUL SYLLABLE SSANGKIYEOK YAE RIEUL
    case 0x83CF: code_point = 0xAEA9; break; // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULKIYEOK
    case 0x83D0: code_point = 0xAEAA; break; // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULMIEUM
    case 0x83D1: code_point = 0xAEAB; break; // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULPIEUP
    case 0x83D2: code_point = 0xAEAC; break; // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULSIOS
    case 0x83D3: code_point = 0xAEAD; break; // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULTHIEUTH
    case 0x83D4: code_point = 0xAEAE; break; // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULPHIEUPH
    case 0x83D5: code_point = 0xAEAF; break; // HANGUL SYLLABLE SSANGKIYEOK YAE RIEULHIEUH
    case 0x83D6: code_point = 0xAEB0; break; // HANGUL SYLLABLE SSANGKIYEOK YAE MIEUM
    case 0x83D7: code_point = 0xAEB1; break; // HANGUL SYLLABLE SSANGKIYEOK YAE PIEUP
    case 0x83D8: code_point = 0xAEB2; break; // HANGUL SYLLABLE SSANGKIYEOK YAE PIEUPSIOS
    case 0x83D9: code_point = 0xAEB3; break; // HANGUL SYLLABLE SSANGKIYEOK YAE SIOS
    case 0x83DA: code_point = 0xAEB4; break; // HANGUL SYLLABLE SSANGKIYEOK YAE SSANGSIOS
    case 0x83DB: code_point = 0xAEB5; break; // HANGUL SYLLABLE SSANGKIYEOK YAE IEUNG
    case 0x83DC: code_point = 0xAEB6; break; // HANGUL SYLLABLE SSANGKIYEOK YAE CIEUC
    case 0x83DD: code_point = 0xAEB7; break; // HANGUL SYLLABLE SSANGKIYEOK YAE CHIEUCH
    case 0x83DE: code_point = 0xAEB8; break; // HANGUL SYLLABLE SSANGKIYEOK YAE KHIEUKH
    case 0x83DF: code_point = 0xAEB9; break; // HANGUL SYLLABLE SSANGKIYEOK YAE THIEUTH
    case 0x83E0: code_point = 0xAEBA; break; // HANGUL SYLLABLE SSANGKIYEOK YAE PHIEUPH
    case 0x83E1: code_point = 0xAEBB; break; // HANGUL SYLLABLE SSANGKIYEOK YAE HIEUH
    case 0x83E2: code_point = 0xAEBF; break; // HANGUL SYLLABLE SSANGKIYEOK EO KIYEOKSIOS
    case 0x83E3: code_point = 0xAEC1; break; // HANGUL SYLLABLE SSANGKIYEOK EO NIEUNCIEUC
    case 0x83E4: code_point = 0xAEC2; break; // HANGUL SYLLABLE SSANGKIYEOK EO NIEUNHIEUH
    case 0x83E5: code_point = 0xAEC3; break; // HANGUL SYLLABLE SSANGKIYEOK EO TIKEUT
    case 0x83E6: code_point = 0xAEC5; break; // HANGUL SYLLABLE SSANGKIYEOK EO RIEULKIYEOK
    case 0x83E7: code_point = 0xAEC6; break; // HANGUL SYLLABLE SSANGKIYEOK EO RIEULMIEUM
    case 0x83E8: code_point = 0xAEC7; break; // HANGUL SYLLABLE SSANGKIYEOK EO RIEULPIEUP
    case 0x83E9: code_point = 0xAEC8; break; // HANGUL SYLLABLE SSANGKIYEOK EO RIEULSIOS
    case 0x83EA: code_point = 0xAEC9; break; // HANGUL SYLLABLE SSANGKIYEOK EO RIEULTHIEUTH
    case 0x83EB: code_point = 0xAECA; break; // HANGUL SYLLABLE SSANGKIYEOK EO RIEULPHIEUPH
    case 0x83EC: code_point = 0xAECB; break; // HANGUL SYLLABLE SSANGKIYEOK EO RIEULHIEUH
    case 0x83ED: code_point = 0xAECE; break; // HANGUL SYLLABLE SSANGKIYEOK EO PIEUPSIOS
    case 0x83EE: code_point = 0xAED2; break; // HANGUL SYLLABLE SSANGKIYEOK EO CIEUC
    case 0x83EF: code_point = 0xAED3; break; // HANGUL SYLLABLE SSANGKIYEOK EO CHIEUCH
    case 0x83F0: code_point = 0xAED4; break; // HANGUL SYLLABLE SSANGKIYEOK EO KHIEUKH
    case 0x83F1: code_point = 0xAED5; break; // HANGUL SYLLABLE SSANGKIYEOK EO THIEUTH
    case 0x83F2: code_point = 0xAED6; break; // HANGUL SYLLABLE SSANGKIYEOK EO PHIEUPH
    case 0x83F3: code_point = 0xAED7; break; // HANGUL SYLLABLE SSANGKIYEOK EO HIEUH
    case 0x83F4: code_point = 0xAEDA; break; // HANGUL SYLLABLE SSANGKIYEOK E SSANGKIYEOK
    case 0x83F5: code_point = 0xAEDB; break; // HANGUL SYLLABLE SSANGKIYEOK E KIYEOKSIOS
    case 0x83F6: code_point = 0xAEDD; break; // HANGUL SYLLABLE SSANGKIYEOK E NIEUNCIEUC
    case 0x83F7: code_point = 0xAEDE; break; // HANGUL SYLLABLE SSANGKIYEOK E NIEUNHIEUH
    case 0x83F8: code_point = 0xAEDF; break; // HANGUL SYLLABLE SSANGKIYEOK E TIKEUT
    case 0x83F9: code_point = 0xAEE0; break; // HANGUL SYLLABLE SSANGKIYEOK E RIEUL
    case 0x83FA: code_point = 0xAEE1; break; // HANGUL SYLLABLE SSANGKIYEOK E RIEULKIYEOK
    case 0x83FB: code_point = 0xAEE2; break; // HANGUL SYLLABLE SSANGKIYEOK E RIEULMIEUM
    case 0x83FC: code_point = 0xAEE3; break; // HANGUL SYLLABLE SSANGKIYEOK E RIEULPIEUP
    case 0x83FD: code_point = 0xAEE4; break; // HANGUL SYLLABLE SSANGKIYEOK E RIEULSIOS
    case 0x83FE: code_point = 0xAEE5; break; // HANGUL SYLLABLE SSANGKIYEOK E RIEULTHIEUTH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x84(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8441: code_point = 0xAEE6; break; // HANGUL SYLLABLE SSANGKIYEOK E RIEULPHIEUPH
    case 0x8442: code_point = 0xAEE7; break; // HANGUL SYLLABLE SSANGKIYEOK E RIEULHIEUH
    case 0x8443: code_point = 0xAEE9; break; // HANGUL SYLLABLE SSANGKIYEOK E PIEUP
    case 0x8444: code_point = 0xAEEA; break; // HANGUL SYLLABLE SSANGKIYEOK E PIEUPSIOS
    case 0x8445: code_point = 0xAEEC; break; // HANGUL SYLLABLE SSANGKIYEOK E SSANGSIOS
    case 0x8446: code_point = 0xAEEE; break; // HANGUL SYLLABLE SSANGKIYEOK E CIEUC
    case 0x8447: code_point = 0xAEEF; break; // HANGUL SYLLABLE SSANGKIYEOK E CHIEUCH
    case 0x8448: code_point = 0xAEF0; break; // HANGUL SYLLABLE SSANGKIYEOK E KHIEUKH
    case 0x8449: code_point = 0xAEF1; break; // HANGUL SYLLABLE SSANGKIYEOK E THIEUTH
    case 0x844A: code_point = 0xAEF2; break; // HANGUL SYLLABLE SSANGKIYEOK E PHIEUPH
    case 0x844B: code_point = 0xAEF3; break; // HANGUL SYLLABLE SSANGKIYEOK E HIEUH
    case 0x844C: code_point = 0xAEF5; break; // HANGUL SYLLABLE SSANGKIYEOK YEO KIYEOK
    case 0x844D: code_point = 0xAEF6; break; // HANGUL SYLLABLE SSANGKIYEOK YEO SSANGKIYEOK
    case 0x844E: code_point = 0xAEF7; break; // HANGUL SYLLABLE SSANGKIYEOK YEO KIYEOKSIOS
    case 0x844F: code_point = 0xAEF9; break; // HANGUL SYLLABLE SSANGKIYEOK YEO NIEUNCIEUC
    case 0x8450: code_point = 0xAEFA; break; // HANGUL SYLLABLE SSANGKIYEOK YEO NIEUNHIEUH
    case 0x8451: code_point = 0xAEFB; break; // HANGUL SYLLABLE SSANGKIYEOK YEO TIKEUT
    case 0x8452: code_point = 0xAEFD; break; // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULKIYEOK
    case 0x8453: code_point = 0xAEFE; break; // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULMIEUM
    case 0x8454: code_point = 0xAEFF; break; // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULPIEUP
    case 0x8455: code_point = 0xAF00; break; // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULSIOS
    case 0x8456: code_point = 0xAF01; break; // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULTHIEUTH
    case 0x8457: code_point = 0xAF02; break; // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULPHIEUPH
    case 0x8458: code_point = 0xAF03; break; // HANGUL SYLLABLE SSANGKIYEOK YEO RIEULHIEUH
    case 0x8459: code_point = 0xAF04; break; // HANGUL SYLLABLE SSANGKIYEOK YEO MIEUM
    case 0x845A: code_point = 0xAF05; break; // HANGUL SYLLABLE SSANGKIYEOK YEO PIEUP
    case 0x8461: code_point = 0xAF06; break; // HANGUL SYLLABLE SSANGKIYEOK YEO PIEUPSIOS
    case 0x8462: code_point = 0xAF09; break; // HANGUL SYLLABLE SSANGKIYEOK YEO IEUNG
    case 0x8463: code_point = 0xAF0A; break; // HANGUL SYLLABLE SSANGKIYEOK YEO CIEUC
    case 0x8464: code_point = 0xAF0B; break; // HANGUL SYLLABLE SSANGKIYEOK YEO CHIEUCH
    case 0x8465: code_point = 0xAF0C; break; // HANGUL SYLLABLE SSANGKIYEOK YEO KHIEUKH
    case 0x8466: code_point = 0xAF0E; break; // HANGUL SYLLABLE SSANGKIYEOK YEO PHIEUPH
    case 0x8467: code_point = 0xAF0F; break; // HANGUL SYLLABLE SSANGKIYEOK YEO HIEUH
    case 0x8468: code_point = 0xAF11; break; // HANGUL SYLLABLE SSANGKIYEOK YE KIYEOK
    case 0x8469: code_point = 0xAF12; break; // HANGUL SYLLABLE SSANGKIYEOK YE SSANGKIYEOK
    case 0x846A: code_point = 0xAF13; break; // HANGUL SYLLABLE SSANGKIYEOK YE KIYEOKSIOS
    case 0x846B: code_point = 0xAF14; break; // HANGUL SYLLABLE SSANGKIYEOK YE NIEUN
    case 0x846C: code_point = 0xAF15; break; // HANGUL SYLLABLE SSANGKIYEOK YE NIEUNCIEUC
    case 0x846D: code_point = 0xAF16; break; // HANGUL SYLLABLE SSANGKIYEOK YE NIEUNHIEUH
    case 0x846E: code_point = 0xAF17; break; // HANGUL SYLLABLE SSANGKIYEOK YE TIKEUT
    case 0x846F: code_point = 0xAF18; break; // HANGUL SYLLABLE SSANGKIYEOK YE RIEUL
    case 0x8470: code_point = 0xAF19; break; // HANGUL SYLLABLE SSANGKIYEOK YE RIEULKIYEOK
    case 0x8471: code_point = 0xAF1A; break; // HANGUL SYLLABLE SSANGKIYEOK YE RIEULMIEUM
    case 0x8472: code_point = 0xAF1B; break; // HANGUL SYLLABLE SSANGKIYEOK YE RIEULPIEUP
    case 0x8473: code_point = 0xAF1C; break; // HANGUL SYLLABLE SSANGKIYEOK YE RIEULSIOS
    case 0x8474: code_point = 0xAF1D; break; // HANGUL SYLLABLE SSANGKIYEOK YE RIEULTHIEUTH
    case 0x8475: code_point = 0xAF1E; break; // HANGUL SYLLABLE SSANGKIYEOK YE RIEULPHIEUPH
    case 0x8476: code_point = 0xAF1F; break; // HANGUL SYLLABLE SSANGKIYEOK YE RIEULHIEUH
    case 0x8477: code_point = 0xAF20; break; // HANGUL SYLLABLE SSANGKIYEOK YE MIEUM
    case 0x8478: code_point = 0xAF21; break; // HANGUL SYLLABLE SSANGKIYEOK YE PIEUP
    case 0x8479: code_point = 0xAF22; break; // HANGUL SYLLABLE SSANGKIYEOK YE PIEUPSIOS
    case 0x847A: code_point = 0xAF23; break; // HANGUL SYLLABLE SSANGKIYEOK YE SIOS
    case 0x8481: code_point = 0xAF24; break; // HANGUL SYLLABLE SSANGKIYEOK YE SSANGSIOS
    case 0x8482: code_point = 0xAF25; break; // HANGUL SYLLABLE SSANGKIYEOK YE IEUNG
    case 0x8483: code_point = 0xAF26; break; // HANGUL SYLLABLE SSANGKIYEOK YE CIEUC
    case 0x8484: code_point = 0xAF27; break; // HANGUL SYLLABLE SSANGKIYEOK YE CHIEUCH
    case 0x8485: code_point = 0xAF28; break; // HANGUL SYLLABLE SSANGKIYEOK YE KHIEUKH
    case 0x8486: code_point = 0xAF29; break; // HANGUL SYLLABLE SSANGKIYEOK YE THIEUTH
    case 0x8487: code_point = 0xAF2A; break; // HANGUL SYLLABLE SSANGKIYEOK YE PHIEUPH
    case 0x8488: code_point = 0xAF2B; break; // HANGUL SYLLABLE SSANGKIYEOK YE HIEUH
    case 0x8489: code_point = 0xAF2E; break; // HANGUL SYLLABLE SSANGKIYEOK O SSANGKIYEOK
    case 0x848A: code_point = 0xAF2F; break; // HANGUL SYLLABLE SSANGKIYEOK O KIYEOKSIOS
    case 0x848B: code_point = 0xAF31; break; // HANGUL SYLLABLE SSANGKIYEOK O NIEUNCIEUC
    case 0x848C: code_point = 0xAF33; break; // HANGUL SYLLABLE SSANGKIYEOK O TIKEUT
    case 0x848D: code_point = 0xAF35; break; // HANGUL SYLLABLE SSANGKIYEOK O RIEULKIYEOK
    case 0x848E: code_point = 0xAF36; break; // HANGUL SYLLABLE SSANGKIYEOK O RIEULMIEUM
    case 0x848F: code_point = 0xAF37; break; // HANGUL SYLLABLE SSANGKIYEOK O RIEULPIEUP
    case 0x8490: code_point = 0xAF38; break; // HANGUL SYLLABLE SSANGKIYEOK O RIEULSIOS
    case 0x8491: code_point = 0xAF39; break; // HANGUL SYLLABLE SSANGKIYEOK O RIEULTHIEUTH
    case 0x8492: code_point = 0xAF3A; break; // HANGUL SYLLABLE SSANGKIYEOK O RIEULPHIEUPH
    case 0x8493: code_point = 0xAF3B; break; // HANGUL SYLLABLE SSANGKIYEOK O RIEULHIEUH
    case 0x8494: code_point = 0xAF3E; break; // HANGUL SYLLABLE SSANGKIYEOK O PIEUPSIOS
    case 0x8495: code_point = 0xAF40; break; // HANGUL SYLLABLE SSANGKIYEOK O SSANGSIOS
    case 0x8496: code_point = 0xAF44; break; // HANGUL SYLLABLE SSANGKIYEOK O KHIEUKH
    case 0x8497: code_point = 0xAF45; break; // HANGUL SYLLABLE SSANGKIYEOK O THIEUTH
    case 0x8498: code_point = 0xAF46; break; // HANGUL SYLLABLE SSANGKIYEOK O PHIEUPH
    case 0x8499: code_point = 0xAF47; break; // HANGUL SYLLABLE SSANGKIYEOK O HIEUH
    case 0x849A: code_point = 0xAF4A; break; // HANGUL SYLLABLE SSANGKIYEOK WA SSANGKIYEOK
    case 0x849B: code_point = 0xAF4B; break; // HANGUL SYLLABLE SSANGKIYEOK WA KIYEOKSIOS
    case 0x849C: code_point = 0xAF4C; break; // HANGUL SYLLABLE SSANGKIYEOK WA NIEUN
    case 0x849D: code_point = 0xAF4D; break; // HANGUL SYLLABLE SSANGKIYEOK WA NIEUNCIEUC
    case 0x849E: code_point = 0xAF4E; break; // HANGUL SYLLABLE SSANGKIYEOK WA NIEUNHIEUH
    case 0x849F: code_point = 0xAF4F; break; // HANGUL SYLLABLE SSANGKIYEOK WA TIKEUT
    case 0x84A0: code_point = 0xAF51; break; // HANGUL SYLLABLE SSANGKIYEOK WA RIEULKIYEOK
    case 0x84A1: code_point = 0xAF52; break; // HANGUL SYLLABLE SSANGKIYEOK WA RIEULMIEUM
    case 0x84A2: code_point = 0xAF53; break; // HANGUL SYLLABLE SSANGKIYEOK WA RIEULPIEUP
    case 0x84A3: code_point = 0xAF54; break; // HANGUL SYLLABLE SSANGKIYEOK WA RIEULSIOS
    case 0x84A4: code_point = 0xAF55; break; // HANGUL SYLLABLE SSANGKIYEOK WA RIEULTHIEUTH
    case 0x84A5: code_point = 0xAF56; break; // HANGUL SYLLABLE SSANGKIYEOK WA RIEULPHIEUPH
    case 0x84A6: code_point = 0xAF57; break; // HANGUL SYLLABLE SSANGKIYEOK WA RIEULHIEUH
    case 0x84A7: code_point = 0xAF58; break; // HANGUL SYLLABLE SSANGKIYEOK WA MIEUM
    case 0x84A8: code_point = 0xAF59; break; // HANGUL SYLLABLE SSANGKIYEOK WA PIEUP
    case 0x84A9: code_point = 0xAF5A; break; // HANGUL SYLLABLE SSANGKIYEOK WA PIEUPSIOS
    case 0x84AA: code_point = 0xAF5B; break; // HANGUL SYLLABLE SSANGKIYEOK WA SIOS
    case 0x84AB: code_point = 0xAF5E; break; // HANGUL SYLLABLE SSANGKIYEOK WA CIEUC
    case 0x84AC: code_point = 0xAF5F; break; // HANGUL SYLLABLE SSANGKIYEOK WA CHIEUCH
    case 0x84AD: code_point = 0xAF60; break; // HANGUL SYLLABLE SSANGKIYEOK WA KHIEUKH
    case 0x84AE: code_point = 0xAF61; break; // HANGUL SYLLABLE SSANGKIYEOK WA THIEUTH
    case 0x84AF: code_point = 0xAF62; break; // HANGUL SYLLABLE SSANGKIYEOK WA PHIEUPH
    case 0x84B0: code_point = 0xAF63; break; // HANGUL SYLLABLE SSANGKIYEOK WA HIEUH
    case 0x84B1: code_point = 0xAF66; break; // HANGUL SYLLABLE SSANGKIYEOK WAE SSANGKIYEOK
    case 0x84B2: code_point = 0xAF67; break; // HANGUL SYLLABLE SSANGKIYEOK WAE KIYEOKSIOS
    case 0x84B3: code_point = 0xAF68; break; // HANGUL SYLLABLE SSANGKIYEOK WAE NIEUN
    case 0x84B4: code_point = 0xAF69; break; // HANGUL SYLLABLE SSANGKIYEOK WAE NIEUNCIEUC
    case 0x84B5: code_point = 0xAF6A; break; // HANGUL SYLLABLE SSANGKIYEOK WAE NIEUNHIEUH
    case 0x84B6: code_point = 0xAF6B; break; // HANGUL SYLLABLE SSANGKIYEOK WAE TIKEUT
    case 0x84B7: code_point = 0xAF6C; break; // HANGUL SYLLABLE SSANGKIYEOK WAE RIEUL
    case 0x84B8: code_point = 0xAF6D; break; // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULKIYEOK
    case 0x84B9: code_point = 0xAF6E; break; // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULMIEUM
    case 0x84BA: code_point = 0xAF6F; break; // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULPIEUP
    case 0x84BB: code_point = 0xAF70; break; // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULSIOS
    case 0x84BC: code_point = 0xAF71; break; // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULTHIEUTH
    case 0x84BD: code_point = 0xAF72; break; // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULPHIEUPH
    case 0x84BE: code_point = 0xAF73; break; // HANGUL SYLLABLE SSANGKIYEOK WAE RIEULHIEUH
    case 0x84BF: code_point = 0xAF74; break; // HANGUL SYLLABLE SSANGKIYEOK WAE MIEUM
    case 0x84C0: code_point = 0xAF75; break; // HANGUL SYLLABLE SSANGKIYEOK WAE PIEUP
    case 0x84C1: code_point = 0xAF76; break; // HANGUL SYLLABLE SSANGKIYEOK WAE PIEUPSIOS
    case 0x84C2: code_point = 0xAF77; break; // HANGUL SYLLABLE SSANGKIYEOK WAE SIOS
    case 0x84C3: code_point = 0xAF78; break; // HANGUL SYLLABLE SSANGKIYEOK WAE SSANGSIOS
    case 0x84C4: code_point = 0xAF7A; break; // HANGUL SYLLABLE SSANGKIYEOK WAE CIEUC
    case 0x84C5: code_point = 0xAF7B; break; // HANGUL SYLLABLE SSANGKIYEOK WAE CHIEUCH
    case 0x84C6: code_point = 0xAF7C; break; // HANGUL SYLLABLE SSANGKIYEOK WAE KHIEUKH
    case 0x84C7: code_point = 0xAF7D; break; // HANGUL SYLLABLE SSANGKIYEOK WAE THIEUTH
    case 0x84C8: code_point = 0xAF7E; break; // HANGUL SYLLABLE SSANGKIYEOK WAE PHIEUPH
    case 0x84C9: code_point = 0xAF7F; break; // HANGUL SYLLABLE SSANGKIYEOK WAE HIEUH
    case 0x84CA: code_point = 0xAF81; break; // HANGUL SYLLABLE SSANGKIYEOK OE KIYEOK
    case 0x84CB: code_point = 0xAF82; break; // HANGUL SYLLABLE SSANGKIYEOK OE SSANGKIYEOK
    case 0x84CC: code_point = 0xAF83; break; // HANGUL SYLLABLE SSANGKIYEOK OE KIYEOKSIOS
    case 0x84CD: code_point = 0xAF85; break; // HANGUL SYLLABLE SSANGKIYEOK OE NIEUNCIEUC
    case 0x84CE: code_point = 0xAF86; break; // HANGUL SYLLABLE SSANGKIYEOK OE NIEUNHIEUH
    case 0x84CF: code_point = 0xAF87; break; // HANGUL SYLLABLE SSANGKIYEOK OE TIKEUT
    case 0x84D0: code_point = 0xAF89; break; // HANGUL SYLLABLE SSANGKIYEOK OE RIEULKIYEOK
    case 0x84D1: code_point = 0xAF8A; break; // HANGUL SYLLABLE SSANGKIYEOK OE RIEULMIEUM
    case 0x84D2: code_point = 0xAF8B; break; // HANGUL SYLLABLE SSANGKIYEOK OE RIEULPIEUP
    case 0x84D3: code_point = 0xAF8C; break; // HANGUL SYLLABLE SSANGKIYEOK OE RIEULSIOS
    case 0x84D4: code_point = 0xAF8D; break; // HANGUL SYLLABLE SSANGKIYEOK OE RIEULTHIEUTH
    case 0x84D5: code_point = 0xAF8E; break; // HANGUL SYLLABLE SSANGKIYEOK OE RIEULPHIEUPH
    case 0x84D6: code_point = 0xAF8F; break; // HANGUL SYLLABLE SSANGKIYEOK OE RIEULHIEUH
    case 0x84D7: code_point = 0xAF92; break; // HANGUL SYLLABLE SSANGKIYEOK OE PIEUPSIOS
    case 0x84D8: code_point = 0xAF93; break; // HANGUL SYLLABLE SSANGKIYEOK OE SIOS
    case 0x84D9: code_point = 0xAF94; break; // HANGUL SYLLABLE SSANGKIYEOK OE SSANGSIOS
    case 0x84DA: code_point = 0xAF96; break; // HANGUL SYLLABLE SSANGKIYEOK OE CIEUC
    case 0x84DB: code_point = 0xAF97; break; // HANGUL SYLLABLE SSANGKIYEOK OE CHIEUCH
    case 0x84DC: code_point = 0xAF98; break; // HANGUL SYLLABLE SSANGKIYEOK OE KHIEUKH
    case 0x84DD: code_point = 0xAF99; break; // HANGUL SYLLABLE SSANGKIYEOK OE THIEUTH
    case 0x84DE: code_point = 0xAF9A; break; // HANGUL SYLLABLE SSANGKIYEOK OE PHIEUPH
    case 0x84DF: code_point = 0xAF9B; break; // HANGUL SYLLABLE SSANGKIYEOK OE HIEUH
    case 0x84E0: code_point = 0xAF9D; break; // HANGUL SYLLABLE SSANGKIYEOK YO KIYEOK
    case 0x84E1: code_point = 0xAF9E; break; // HANGUL SYLLABLE SSANGKIYEOK YO SSANGKIYEOK
    case 0x84E2: code_point = 0xAF9F; break; // HANGUL SYLLABLE SSANGKIYEOK YO KIYEOKSIOS
    case 0x84E3: code_point = 0xAFA0; break; // HANGUL SYLLABLE SSANGKIYEOK YO NIEUN
    case 0x84E4: code_point = 0xAFA1; break; // HANGUL SYLLABLE SSANGKIYEOK YO NIEUNCIEUC
    case 0x84E5: code_point = 0xAFA2; break; // HANGUL SYLLABLE SSANGKIYEOK YO NIEUNHIEUH
    case 0x84E6: code_point = 0xAFA3; break; // HANGUL SYLLABLE SSANGKIYEOK YO TIKEUT
    case 0x84E7: code_point = 0xAFA4; break; // HANGUL SYLLABLE SSANGKIYEOK YO RIEUL
    case 0x84E8: code_point = 0xAFA5; break; // HANGUL SYLLABLE SSANGKIYEOK YO RIEULKIYEOK
    case 0x84E9: code_point = 0xAFA6; break; // HANGUL SYLLABLE SSANGKIYEOK YO RIEULMIEUM
    case 0x84EA: code_point = 0xAFA7; break; // HANGUL SYLLABLE SSANGKIYEOK YO RIEULPIEUP
    case 0x84EB: code_point = 0xAFA8; break; // HANGUL SYLLABLE SSANGKIYEOK YO RIEULSIOS
    case 0x84EC: code_point = 0xAFA9; break; // HANGUL SYLLABLE SSANGKIYEOK YO RIEULTHIEUTH
    case 0x84ED: code_point = 0xAFAA; break; // HANGUL SYLLABLE SSANGKIYEOK YO RIEULPHIEUPH
    case 0x84EE: code_point = 0xAFAB; break; // HANGUL SYLLABLE SSANGKIYEOK YO RIEULHIEUH
    case 0x84EF: code_point = 0xAFAC; break; // HANGUL SYLLABLE SSANGKIYEOK YO MIEUM
    case 0x84F0: code_point = 0xAFAD; break; // HANGUL SYLLABLE SSANGKIYEOK YO PIEUP
    case 0x84F1: code_point = 0xAFAE; break; // HANGUL SYLLABLE SSANGKIYEOK YO PIEUPSIOS
    case 0x84F2: code_point = 0xAFAF; break; // HANGUL SYLLABLE SSANGKIYEOK YO SIOS
    case 0x84F3: code_point = 0xAFB0; break; // HANGUL SYLLABLE SSANGKIYEOK YO SSANGSIOS
    case 0x84F4: code_point = 0xAFB1; break; // HANGUL SYLLABLE SSANGKIYEOK YO IEUNG
    case 0x84F5: code_point = 0xAFB2; break; // HANGUL SYLLABLE SSANGKIYEOK YO CIEUC
    case 0x84F6: code_point = 0xAFB3; break; // HANGUL SYLLABLE SSANGKIYEOK YO CHIEUCH
    case 0x84F7: code_point = 0xAFB4; break; // HANGUL SYLLABLE SSANGKIYEOK YO KHIEUKH
    case 0x84F8: code_point = 0xAFB5; break; // HANGUL SYLLABLE SSANGKIYEOK YO THIEUTH
    case 0x84F9: code_point = 0xAFB6; break; // HANGUL SYLLABLE SSANGKIYEOK YO PHIEUPH
    case 0x84FA: code_point = 0xAFB7; break; // HANGUL SYLLABLE SSANGKIYEOK YO HIEUH
    case 0x84FB: code_point = 0xAFBA; break; // HANGUL SYLLABLE SSANGKIYEOK U SSANGKIYEOK
    case 0x84FC: code_point = 0xAFBB; break; // HANGUL SYLLABLE SSANGKIYEOK U KIYEOKSIOS
    case 0x84FD: code_point = 0xAFBD; break; // HANGUL SYLLABLE SSANGKIYEOK U NIEUNCIEUC
    case 0x84FE: code_point = 0xAFBE; break; // HANGUL SYLLABLE SSANGKIYEOK U NIEUNHIEUH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x85(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8541: code_point = 0xAFBF; break; // HANGUL SYLLABLE SSANGKIYEOK U TIKEUT
    case 0x8542: code_point = 0xAFC1; break; // HANGUL SYLLABLE SSANGKIYEOK U RIEULKIYEOK
    case 0x8543: code_point = 0xAFC2; break; // HANGUL SYLLABLE SSANGKIYEOK U RIEULMIEUM
    case 0x8544: code_point = 0xAFC3; break; // HANGUL SYLLABLE SSANGKIYEOK U RIEULPIEUP
    case 0x8545: code_point = 0xAFC4; break; // HANGUL SYLLABLE SSANGKIYEOK U RIEULSIOS
    case 0x8546: code_point = 0xAFC5; break; // HANGUL SYLLABLE SSANGKIYEOK U RIEULTHIEUTH
    case 0x8547: code_point = 0xAFC6; break; // HANGUL SYLLABLE SSANGKIYEOK U RIEULPHIEUPH
    case 0x8548: code_point = 0xAFCA; break; // HANGUL SYLLABLE SSANGKIYEOK U PIEUPSIOS
    case 0x8549: code_point = 0xAFCC; break; // HANGUL SYLLABLE SSANGKIYEOK U SSANGSIOS
    case 0x854A: code_point = 0xAFCF; break; // HANGUL SYLLABLE SSANGKIYEOK U CHIEUCH
    case 0x854B: code_point = 0xAFD0; break; // HANGUL SYLLABLE SSANGKIYEOK U KHIEUKH
    case 0x854C: code_point = 0xAFD1; break; // HANGUL SYLLABLE SSANGKIYEOK U THIEUTH
    case 0x854D: code_point = 0xAFD2; break; // HANGUL SYLLABLE SSANGKIYEOK U PHIEUPH
    case 0x854E: code_point = 0xAFD3; break; // HANGUL SYLLABLE SSANGKIYEOK U HIEUH
    case 0x854F: code_point = 0xAFD5; break; // HANGUL SYLLABLE SSANGKIYEOK WEO KIYEOK
    case 0x8550: code_point = 0xAFD6; break; // HANGUL SYLLABLE SSANGKIYEOK WEO SSANGKIYEOK
    case 0x8551: code_point = 0xAFD7; break; // HANGUL SYLLABLE SSANGKIYEOK WEO KIYEOKSIOS
    case 0x8552: code_point = 0xAFD8; break; // HANGUL SYLLABLE SSANGKIYEOK WEO NIEUN
    case 0x8553: code_point = 0xAFD9; break; // HANGUL SYLLABLE SSANGKIYEOK WEO NIEUNCIEUC
    case 0x8554: code_point = 0xAFDA; break; // HANGUL SYLLABLE SSANGKIYEOK WEO NIEUNHIEUH
    case 0x8555: code_point = 0xAFDB; break; // HANGUL SYLLABLE SSANGKIYEOK WEO TIKEUT
    case 0x8556: code_point = 0xAFDD; break; // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULKIYEOK
    case 0x8557: code_point = 0xAFDE; break; // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULMIEUM
    case 0x8558: code_point = 0xAFDF; break; // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULPIEUP
    case 0x8559: code_point = 0xAFE0; break; // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULSIOS
    case 0x855A: code_point = 0xAFE1; break; // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULTHIEUTH
    case 0x8561: code_point = 0xAFE2; break; // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULPHIEUPH
    case 0x8562: code_point = 0xAFE3; break; // HANGUL SYLLABLE SSANGKIYEOK WEO RIEULHIEUH
    case 0x8563: code_point = 0xAFE4; break; // HANGUL SYLLABLE SSANGKIYEOK WEO MIEUM
    case 0x8564: code_point = 0xAFE5; break; // HANGUL SYLLABLE SSANGKIYEOK WEO PIEUP
    case 0x8565: code_point = 0xAFE6; break; // HANGUL SYLLABLE SSANGKIYEOK WEO PIEUPSIOS
    case 0x8566: code_point = 0xAFE7; break; // HANGUL SYLLABLE SSANGKIYEOK WEO SIOS
    case 0x8567: code_point = 0xAFEA; break; // HANGUL SYLLABLE SSANGKIYEOK WEO CIEUC
    case 0x8568: code_point = 0xAFEB; break; // HANGUL SYLLABLE SSANGKIYEOK WEO CHIEUCH
    case 0x8569: code_point = 0xAFEC; break; // HANGUL SYLLABLE SSANGKIYEOK WEO KHIEUKH
    case 0x856A: code_point = 0xAFED; break; // HANGUL SYLLABLE SSANGKIYEOK WEO THIEUTH
    case 0x856B: code_point = 0xAFEE; break; // HANGUL SYLLABLE SSANGKIYEOK WEO PHIEUPH
    case 0x856C: code_point = 0xAFEF; break; // HANGUL SYLLABLE SSANGKIYEOK WEO HIEUH
    case 0x856D: code_point = 0xAFF2; break; // HANGUL SYLLABLE SSANGKIYEOK WE SSANGKIYEOK
    case 0x856E: code_point = 0xAFF3; break; // HANGUL SYLLABLE SSANGKIYEOK WE KIYEOKSIOS
    case 0x856F: code_point = 0xAFF5; break; // HANGUL SYLLABLE SSANGKIYEOK WE NIEUNCIEUC
    case 0x8570: code_point = 0xAFF6; break; // HANGUL SYLLABLE SSANGKIYEOK WE NIEUNHIEUH
    case 0x8571: code_point = 0xAFF7; break; // HANGUL SYLLABLE SSANGKIYEOK WE TIKEUT
    case 0x8572: code_point = 0xAFF9; break; // HANGUL SYLLABLE SSANGKIYEOK WE RIEULKIYEOK
    case 0x8573: code_point = 0xAFFA; break; // HANGUL SYLLABLE SSANGKIYEOK WE RIEULMIEUM
    case 0x8574: code_point = 0xAFFB; break; // HANGUL SYLLABLE SSANGKIYEOK WE RIEULPIEUP
    case 0x8575: code_point = 0xAFFC; break; // HANGUL SYLLABLE SSANGKIYEOK WE RIEULSIOS
    case 0x8576: code_point = 0xAFFD; break; // HANGUL SYLLABLE SSANGKIYEOK WE RIEULTHIEUTH
    case 0x8577: code_point = 0xAFFE; break; // HANGUL SYLLABLE SSANGKIYEOK WE RIEULPHIEUPH
    case 0x8578: code_point = 0xAFFF; break; // HANGUL SYLLABLE SSANGKIYEOK WE RIEULHIEUH
    case 0x8579: code_point = 0xB002; break; // HANGUL SYLLABLE SSANGKIYEOK WE PIEUPSIOS
    case 0x857A: code_point = 0xB003; break; // HANGUL SYLLABLE SSANGKIYEOK WE SIOS
    case 0x8581: code_point = 0xB005; break; // HANGUL SYLLABLE SSANGKIYEOK WE IEUNG
    case 0x8582: code_point = 0xB006; break; // HANGUL SYLLABLE SSANGKIYEOK WE CIEUC
    case 0x8583: code_point = 0xB007; break; // HANGUL SYLLABLE SSANGKIYEOK WE CHIEUCH
    case 0x8584: code_point = 0xB008; break; // HANGUL SYLLABLE SSANGKIYEOK WE KHIEUKH
    case 0x8585: code_point = 0xB009; break; // HANGUL SYLLABLE SSANGKIYEOK WE THIEUTH
    case 0x8586: code_point = 0xB00A; break; // HANGUL SYLLABLE SSANGKIYEOK WE PHIEUPH
    case 0x8587: code_point = 0xB00B; break; // HANGUL SYLLABLE SSANGKIYEOK WE HIEUH
    case 0x8588: code_point = 0xB00D; break; // HANGUL SYLLABLE SSANGKIYEOK WI KIYEOK
    case 0x8589: code_point = 0xB00E; break; // HANGUL SYLLABLE SSANGKIYEOK WI SSANGKIYEOK
    case 0x858A: code_point = 0xB00F; break; // HANGUL SYLLABLE SSANGKIYEOK WI KIYEOKSIOS
    case 0x858B: code_point = 0xB011; break; // HANGUL SYLLABLE SSANGKIYEOK WI NIEUNCIEUC
    case 0x858C: code_point = 0xB012; break; // HANGUL SYLLABLE SSANGKIYEOK WI NIEUNHIEUH
    case 0x858D: code_point = 0xB013; break; // HANGUL SYLLABLE SSANGKIYEOK WI TIKEUT
    case 0x858E: code_point = 0xB015; break; // HANGUL SYLLABLE SSANGKIYEOK WI RIEULKIYEOK
    case 0x858F: code_point = 0xB016; break; // HANGUL SYLLABLE SSANGKIYEOK WI RIEULMIEUM
    case 0x8590: code_point = 0xB017; break; // HANGUL SYLLABLE SSANGKIYEOK WI RIEULPIEUP
    case 0x8591: code_point = 0xB018; break; // HANGUL SYLLABLE SSANGKIYEOK WI RIEULSIOS
    case 0x8592: code_point = 0xB019; break; // HANGUL SYLLABLE SSANGKIYEOK WI RIEULTHIEUTH
    case 0x8593: code_point = 0xB01A; break; // HANGUL SYLLABLE SSANGKIYEOK WI RIEULPHIEUPH
    case 0x8594: code_point = 0xB01B; break; // HANGUL SYLLABLE SSANGKIYEOK WI RIEULHIEUH
    case 0x8595: code_point = 0xB01E; break; // HANGUL SYLLABLE SSANGKIYEOK WI PIEUPSIOS
    case 0x8596: code_point = 0xB01F; break; // HANGUL SYLLABLE SSANGKIYEOK WI SIOS
    case 0x8597: code_point = 0xB020; break; // HANGUL SYLLABLE SSANGKIYEOK WI SSANGSIOS
    case 0x8598: code_point = 0xB021; break; // HANGUL SYLLABLE SSANGKIYEOK WI IEUNG
    case 0x8599: code_point = 0xB022; break; // HANGUL SYLLABLE SSANGKIYEOK WI CIEUC
    case 0x859A: code_point = 0xB023; break; // HANGUL SYLLABLE SSANGKIYEOK WI CHIEUCH
    case 0x859B: code_point = 0xB024; break; // HANGUL SYLLABLE SSANGKIYEOK WI KHIEUKH
    case 0x859C: code_point = 0xB025; break; // HANGUL SYLLABLE SSANGKIYEOK WI THIEUTH
    case 0x859D: code_point = 0xB026; break; // HANGUL SYLLABLE SSANGKIYEOK WI PHIEUPH
    case 0x859E: code_point = 0xB027; break; // HANGUL SYLLABLE SSANGKIYEOK WI HIEUH
    case 0x859F: code_point = 0xB029; break; // HANGUL SYLLABLE SSANGKIYEOK YU KIYEOK
    case 0x85A0: code_point = 0xB02A; break; // HANGUL SYLLABLE SSANGKIYEOK YU SSANGKIYEOK
    case 0x85A1: code_point = 0xB02B; break; // HANGUL SYLLABLE SSANGKIYEOK YU KIYEOKSIOS
    case 0x85A2: code_point = 0xB02C; break; // HANGUL SYLLABLE SSANGKIYEOK YU NIEUN
    case 0x85A3: code_point = 0xB02D; break; // HANGUL SYLLABLE SSANGKIYEOK YU NIEUNCIEUC
    case 0x85A4: code_point = 0xB02E; break; // HANGUL SYLLABLE SSANGKIYEOK YU NIEUNHIEUH
    case 0x85A5: code_point = 0xB02F; break; // HANGUL SYLLABLE SSANGKIYEOK YU TIKEUT
    case 0x85A6: code_point = 0xB030; break; // HANGUL SYLLABLE SSANGKIYEOK YU RIEUL
    case 0x85A7: code_point = 0xB031; break; // HANGUL SYLLABLE SSANGKIYEOK YU RIEULKIYEOK
    case 0x85A8: code_point = 0xB032; break; // HANGUL SYLLABLE SSANGKIYEOK YU RIEULMIEUM
    case 0x85A9: code_point = 0xB033; break; // HANGUL SYLLABLE SSANGKIYEOK YU RIEULPIEUP
    case 0x85AA: code_point = 0xB034; break; // HANGUL SYLLABLE SSANGKIYEOK YU RIEULSIOS
    case 0x85AB: code_point = 0xB035; break; // HANGUL SYLLABLE SSANGKIYEOK YU RIEULTHIEUTH
    case 0x85AC: code_point = 0xB036; break; // HANGUL SYLLABLE SSANGKIYEOK YU RIEULPHIEUPH
    case 0x85AD: code_point = 0xB037; break; // HANGUL SYLLABLE SSANGKIYEOK YU RIEULHIEUH
    case 0x85AE: code_point = 0xB038; break; // HANGUL SYLLABLE SSANGKIYEOK YU MIEUM
    case 0x85AF: code_point = 0xB039; break; // HANGUL SYLLABLE SSANGKIYEOK YU PIEUP
    case 0x85B0: code_point = 0xB03A; break; // HANGUL SYLLABLE SSANGKIYEOK YU PIEUPSIOS
    case 0x85B1: code_point = 0xB03B; break; // HANGUL SYLLABLE SSANGKIYEOK YU SIOS
    case 0x85B2: code_point = 0xB03C; break; // HANGUL SYLLABLE SSANGKIYEOK YU SSANGSIOS
    case 0x85B3: code_point = 0xB03D; break; // HANGUL SYLLABLE SSANGKIYEOK YU IEUNG
    case 0x85B4: code_point = 0xB03E; break; // HANGUL SYLLABLE SSANGKIYEOK YU CIEUC
    case 0x85B5: code_point = 0xB03F; break; // HANGUL SYLLABLE SSANGKIYEOK YU CHIEUCH
    case 0x85B6: code_point = 0xB040; break; // HANGUL SYLLABLE SSANGKIYEOK YU KHIEUKH
    case 0x85B7: code_point = 0xB041; break; // HANGUL SYLLABLE SSANGKIYEOK YU THIEUTH
    case 0x85B8: code_point = 0xB042; break; // HANGUL SYLLABLE SSANGKIYEOK YU PHIEUPH
    case 0x85B9: code_point = 0xB043; break; // HANGUL SYLLABLE SSANGKIYEOK YU HIEUH
    case 0x85BA: code_point = 0xB046; break; // HANGUL SYLLABLE SSANGKIYEOK EU SSANGKIYEOK
    case 0x85BB: code_point = 0xB047; break; // HANGUL SYLLABLE SSANGKIYEOK EU KIYEOKSIOS
    case 0x85BC: code_point = 0xB049; break; // HANGUL SYLLABLE SSANGKIYEOK EU NIEUNCIEUC
    case 0x85BD: code_point = 0xB04B; break; // HANGUL SYLLABLE SSANGKIYEOK EU TIKEUT
    case 0x85BE: code_point = 0xB04D; break; // HANGUL SYLLABLE SSANGKIYEOK EU RIEULKIYEOK
    case 0x85BF: code_point = 0xB04F; break; // HANGUL SYLLABLE SSANGKIYEOK EU RIEULPIEUP
    case 0x85C0: code_point = 0xB050; break; // HANGUL SYLLABLE SSANGKIYEOK EU RIEULSIOS
    case 0x85C1: code_point = 0xB051; break; // HANGUL SYLLABLE SSANGKIYEOK EU RIEULTHIEUTH
    case 0x85C2: code_point = 0xB052; break; // HANGUL SYLLABLE SSANGKIYEOK EU RIEULPHIEUPH
    case 0x85C3: code_point = 0xB056; break; // HANGUL SYLLABLE SSANGKIYEOK EU PIEUPSIOS
    case 0x85C4: code_point = 0xB058; break; // HANGUL SYLLABLE SSANGKIYEOK EU SSANGSIOS
    case 0x85C5: code_point = 0xB05A; break; // HANGUL SYLLABLE SSANGKIYEOK EU CIEUC
    case 0x85C6: code_point = 0xB05B; break; // HANGUL SYLLABLE SSANGKIYEOK EU CHIEUCH
    case 0x85C7: code_point = 0xB05C; break; // HANGUL SYLLABLE SSANGKIYEOK EU KHIEUKH
    case 0x85C8: code_point = 0xB05E; break; // HANGUL SYLLABLE SSANGKIYEOK EU PHIEUPH
    case 0x85C9: code_point = 0xB05F; break; // HANGUL SYLLABLE SSANGKIYEOK EU HIEUH
    case 0x85CA: code_point = 0xB060; break; // HANGUL SYLLABLE SSANGKIYEOK YI
    case 0x85CB: code_point = 0xB061; break; // HANGUL SYLLABLE SSANGKIYEOK YI KIYEOK
    case 0x85CC: code_point = 0xB062; break; // HANGUL SYLLABLE SSANGKIYEOK YI SSANGKIYEOK
    case 0x85CD: code_point = 0xB063; break; // HANGUL SYLLABLE SSANGKIYEOK YI KIYEOKSIOS
    case 0x85CE: code_point = 0xB064; break; // HANGUL SYLLABLE SSANGKIYEOK YI NIEUN
    case 0x85CF: code_point = 0xB065; break; // HANGUL SYLLABLE SSANGKIYEOK YI NIEUNCIEUC
    case 0x85D0: code_point = 0xB066; break; // HANGUL SYLLABLE SSANGKIYEOK YI NIEUNHIEUH
    case 0x85D1: code_point = 0xB067; break; // HANGUL SYLLABLE SSANGKIYEOK YI TIKEUT
    case 0x85D2: code_point = 0xB068; break; // HANGUL SYLLABLE SSANGKIYEOK YI RIEUL
    case 0x85D3: code_point = 0xB069; break; // HANGUL SYLLABLE SSANGKIYEOK YI RIEULKIYEOK
    case 0x85D4: code_point = 0xB06A; break; // HANGUL SYLLABLE SSANGKIYEOK YI RIEULMIEUM
    case 0x85D5: code_point = 0xB06B; break; // HANGUL SYLLABLE SSANGKIYEOK YI RIEULPIEUP
    case 0x85D6: code_point = 0xB06C; break; // HANGUL SYLLABLE SSANGKIYEOK YI RIEULSIOS
    case 0x85D7: code_point = 0xB06D; break; // HANGUL SYLLABLE SSANGKIYEOK YI RIEULTHIEUTH
    case 0x85D8: code_point = 0xB06E; break; // HANGUL SYLLABLE SSANGKIYEOK YI RIEULPHIEUPH
    case 0x85D9: code_point = 0xB06F; break; // HANGUL SYLLABLE SSANGKIYEOK YI RIEULHIEUH
    case 0x85DA: code_point = 0xB070; break; // HANGUL SYLLABLE SSANGKIYEOK YI MIEUM
    case 0x85DB: code_point = 0xB071; break; // HANGUL SYLLABLE SSANGKIYEOK YI PIEUP
    case 0x85DC: code_point = 0xB072; break; // HANGUL SYLLABLE SSANGKIYEOK YI PIEUPSIOS
    case 0x85DD: code_point = 0xB073; break; // HANGUL SYLLABLE SSANGKIYEOK YI SIOS
    case 0x85DE: code_point = 0xB074; break; // HANGUL SYLLABLE SSANGKIYEOK YI SSANGSIOS
    case 0x85DF: code_point = 0xB075; break; // HANGUL SYLLABLE SSANGKIYEOK YI IEUNG
    case 0x85E0: code_point = 0xB076; break; // HANGUL SYLLABLE SSANGKIYEOK YI CIEUC
    case 0x85E1: code_point = 0xB077; break; // HANGUL SYLLABLE SSANGKIYEOK YI CHIEUCH
    case 0x85E2: code_point = 0xB078; break; // HANGUL SYLLABLE SSANGKIYEOK YI KHIEUKH
    case 0x85E3: code_point = 0xB079; break; // HANGUL SYLLABLE SSANGKIYEOK YI THIEUTH
    case 0x85E4: code_point = 0xB07A; break; // HANGUL SYLLABLE SSANGKIYEOK YI PHIEUPH
    case 0x85E5: code_point = 0xB07B; break; // HANGUL SYLLABLE SSANGKIYEOK YI HIEUH
    case 0x85E6: code_point = 0xB07E; break; // HANGUL SYLLABLE SSANGKIYEOK I SSANGKIYEOK
    case 0x85E7: code_point = 0xB07F; break; // HANGUL SYLLABLE SSANGKIYEOK I KIYEOKSIOS
    case 0x85E8: code_point = 0xB081; break; // HANGUL SYLLABLE SSANGKIYEOK I NIEUNCIEUC
    case 0x85E9: code_point = 0xB082; break; // HANGUL SYLLABLE SSANGKIYEOK I NIEUNHIEUH
    case 0x85EA: code_point = 0xB083; break; // HANGUL SYLLABLE SSANGKIYEOK I TIKEUT
    case 0x85EB: code_point = 0xB085; break; // HANGUL SYLLABLE SSANGKIYEOK I RIEULKIYEOK
    case 0x85EC: code_point = 0xB086; break; // HANGUL SYLLABLE SSANGKIYEOK I RIEULMIEUM
    case 0x85ED: code_point = 0xB087; break; // HANGUL SYLLABLE SSANGKIYEOK I RIEULPIEUP
    case 0x85EE: code_point = 0xB088; break; // HANGUL SYLLABLE SSANGKIYEOK I RIEULSIOS
    case 0x85EF: code_point = 0xB089; break; // HANGUL SYLLABLE SSANGKIYEOK I RIEULTHIEUTH
    case 0x85F0: code_point = 0xB08A; break; // HANGUL SYLLABLE SSANGKIYEOK I RIEULPHIEUPH
    case 0x85F1: code_point = 0xB08B; break; // HANGUL SYLLABLE SSANGKIYEOK I RIEULHIEUH
    case 0x85F2: code_point = 0xB08E; break; // HANGUL SYLLABLE SSANGKIYEOK I PIEUPSIOS
    case 0x85F3: code_point = 0xB090; break; // HANGUL SYLLABLE SSANGKIYEOK I SSANGSIOS
    case 0x85F4: code_point = 0xB092; break; // HANGUL SYLLABLE SSANGKIYEOK I CIEUC
    case 0x85F5: code_point = 0xB093; break; // HANGUL SYLLABLE SSANGKIYEOK I CHIEUCH
    case 0x85F6: code_point = 0xB094; break; // HANGUL SYLLABLE SSANGKIYEOK I KHIEUKH
    case 0x85F7: code_point = 0xB095; break; // HANGUL SYLLABLE SSANGKIYEOK I THIEUTH
    case 0x85F8: code_point = 0xB096; break; // HANGUL SYLLABLE SSANGKIYEOK I PHIEUPH
    case 0x85F9: code_point = 0xB097; break; // HANGUL SYLLABLE SSANGKIYEOK I HIEUH
    case 0x85FA: code_point = 0xB09B; break; // HANGUL SYLLABLE NIEUN A KIYEOKSIOS
    case 0x85FB: code_point = 0xB09D; break; // HANGUL SYLLABLE NIEUN A NIEUNCIEUC
    case 0x85FC: code_point = 0xB09E; break; // HANGUL SYLLABLE NIEUN A NIEUNHIEUH
    case 0x85FD: code_point = 0xB0A3; break; // HANGUL SYLLABLE NIEUN A RIEULPIEUP
    case 0x85FE: code_point = 0xB0A4; break; // HANGUL SYLLABLE NIEUN A RIEULSIOS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x86(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8641: code_point = 0xB0A5; break; // HANGUL SYLLABLE NIEUN A RIEULTHIEUTH
    case 0x8642: code_point = 0xB0A6; break; // HANGUL SYLLABLE NIEUN A RIEULPHIEUPH
    case 0x8643: code_point = 0xB0A7; break; // HANGUL SYLLABLE NIEUN A RIEULHIEUH
    case 0x8644: code_point = 0xB0AA; break; // HANGUL SYLLABLE NIEUN A PIEUPSIOS
    case 0x8645: code_point = 0xB0B0; break; // HANGUL SYLLABLE NIEUN A KHIEUKH
    case 0x8646: code_point = 0xB0B2; break; // HANGUL SYLLABLE NIEUN A PHIEUPH
    case 0x8647: code_point = 0xB0B6; break; // HANGUL SYLLABLE NIEUN AE SSANGKIYEOK
    case 0x8648: code_point = 0xB0B7; break; // HANGUL SYLLABLE NIEUN AE KIYEOKSIOS
    case 0x8649: code_point = 0xB0B9; break; // HANGUL SYLLABLE NIEUN AE NIEUNCIEUC
    case 0x864A: code_point = 0xB0BA; break; // HANGUL SYLLABLE NIEUN AE NIEUNHIEUH
    case 0x864B: code_point = 0xB0BB; break; // HANGUL SYLLABLE NIEUN AE TIKEUT
    case 0x864C: code_point = 0xB0BD; break; // HANGUL SYLLABLE NIEUN AE RIEULKIYEOK
    case 0x864D: code_point = 0xB0BE; break; // HANGUL SYLLABLE NIEUN AE RIEULMIEUM
    case 0x864E: code_point = 0xB0BF; break; // HANGUL SYLLABLE NIEUN AE RIEULPIEUP
    case 0x864F: code_point = 0xB0C0; break; // HANGUL SYLLABLE NIEUN AE RIEULSIOS
    case 0x8650: code_point = 0xB0C1; break; // HANGUL SYLLABLE NIEUN AE RIEULTHIEUTH
    case 0x8651: code_point = 0xB0C2; break; // HANGUL SYLLABLE NIEUN AE RIEULPHIEUPH
    case 0x8652: code_point = 0xB0C3; break; // HANGUL SYLLABLE NIEUN AE RIEULHIEUH
    case 0x8653: code_point = 0xB0C6; break; // HANGUL SYLLABLE NIEUN AE PIEUPSIOS
    case 0x8654: code_point = 0xB0CA; break; // HANGUL SYLLABLE NIEUN AE CIEUC
    case 0x8655: code_point = 0xB0CB; break; // HANGUL SYLLABLE NIEUN AE CHIEUCH
    case 0x8656: code_point = 0xB0CC; break; // HANGUL SYLLABLE NIEUN AE KHIEUKH
    case 0x8657: code_point = 0xB0CD; break; // HANGUL SYLLABLE NIEUN AE THIEUTH
    case 0x8658: code_point = 0xB0CE; break; // HANGUL SYLLABLE NIEUN AE PHIEUPH
    case 0x8659: code_point = 0xB0CF; break; // HANGUL SYLLABLE NIEUN AE HIEUH
    case 0x865A: code_point = 0xB0D2; break; // HANGUL SYLLABLE NIEUN YA SSANGKIYEOK
    case 0x8661: code_point = 0xB0D3; break; // HANGUL SYLLABLE NIEUN YA KIYEOKSIOS
    case 0x8662: code_point = 0xB0D5; break; // HANGUL SYLLABLE NIEUN YA NIEUNCIEUC
    case 0x8663: code_point = 0xB0D6; break; // HANGUL SYLLABLE NIEUN YA NIEUNHIEUH
    case 0x8664: code_point = 0xB0D7; break; // HANGUL SYLLABLE NIEUN YA TIKEUT
    case 0x8665: code_point = 0xB0D9; break; // HANGUL SYLLABLE NIEUN YA RIEULKIYEOK
    case 0x8666: code_point = 0xB0DA; break; // HANGUL SYLLABLE NIEUN YA RIEULMIEUM
    case 0x8667: code_point = 0xB0DB; break; // HANGUL SYLLABLE NIEUN YA RIEULPIEUP
    case 0x8668: code_point = 0xB0DC; break; // HANGUL SYLLABLE NIEUN YA RIEULSIOS
    case 0x8669: code_point = 0xB0DD; break; // HANGUL SYLLABLE NIEUN YA RIEULTHIEUTH
    case 0x866A: code_point = 0xB0DE; break; // HANGUL SYLLABLE NIEUN YA RIEULPHIEUPH
    case 0x866B: code_point = 0xB0DF; break; // HANGUL SYLLABLE NIEUN YA RIEULHIEUH
    case 0x866C: code_point = 0xB0E1; break; // HANGUL SYLLABLE NIEUN YA PIEUP
    case 0x866D: code_point = 0xB0E2; break; // HANGUL SYLLABLE NIEUN YA PIEUPSIOS
    case 0x866E: code_point = 0xB0E3; break; // HANGUL SYLLABLE NIEUN YA SIOS
    case 0x866F: code_point = 0xB0E4; break; // HANGUL SYLLABLE NIEUN YA SSANGSIOS
    case 0x8670: code_point = 0xB0E6; break; // HANGUL SYLLABLE NIEUN YA CIEUC
    case 0x8671: code_point = 0xB0E7; break; // HANGUL SYLLABLE NIEUN YA CHIEUCH
    case 0x8672: code_point = 0xB0E8; break; // HANGUL SYLLABLE NIEUN YA KHIEUKH
    case 0x8673: code_point = 0xB0E9; break; // HANGUL SYLLABLE NIEUN YA THIEUTH
    case 0x8674: code_point = 0xB0EA; break; // HANGUL SYLLABLE NIEUN YA PHIEUPH
    case 0x8675: code_point = 0xB0EB; break; // HANGUL SYLLABLE NIEUN YA HIEUH
    case 0x8676: code_point = 0xB0EC; break; // HANGUL SYLLABLE NIEUN YAE
    case 0x8677: code_point = 0xB0ED; break; // HANGUL SYLLABLE NIEUN YAE KIYEOK
    case 0x8678: code_point = 0xB0EE; break; // HANGUL SYLLABLE NIEUN YAE SSANGKIYEOK
    case 0x8679: code_point = 0xB0EF; break; // HANGUL SYLLABLE NIEUN YAE KIYEOKSIOS
    case 0x867A: code_point = 0xB0F0; break; // HANGUL SYLLABLE NIEUN YAE NIEUN
    case 0x8681: code_point = 0xB0F1; break; // HANGUL SYLLABLE NIEUN YAE NIEUNCIEUC
    case 0x8682: code_point = 0xB0F2; break; // HANGUL SYLLABLE NIEUN YAE NIEUNHIEUH
    case 0x8683: code_point = 0xB0F3; break; // HANGUL SYLLABLE NIEUN YAE TIKEUT
    case 0x8684: code_point = 0xB0F4; break; // HANGUL SYLLABLE NIEUN YAE RIEUL
    case 0x8685: code_point = 0xB0F5; break; // HANGUL SYLLABLE NIEUN YAE RIEULKIYEOK
    case 0x8686: code_point = 0xB0F6; break; // HANGUL SYLLABLE NIEUN YAE RIEULMIEUM
    case 0x8687: code_point = 0xB0F7; break; // HANGUL SYLLABLE NIEUN YAE RIEULPIEUP
    case 0x8688: code_point = 0xB0F8; break; // HANGUL SYLLABLE NIEUN YAE RIEULSIOS
    case 0x8689: code_point = 0xB0F9; break; // HANGUL SYLLABLE NIEUN YAE RIEULTHIEUTH
    case 0x868A: code_point = 0xB0FA; break; // HANGUL SYLLABLE NIEUN YAE RIEULPHIEUPH
    case 0x868B: code_point = 0xB0FB; break; // HANGUL SYLLABLE NIEUN YAE RIEULHIEUH
    case 0x868C: code_point = 0xB0FC; break; // HANGUL SYLLABLE NIEUN YAE MIEUM
    case 0x868D: code_point = 0xB0FD; break; // HANGUL SYLLABLE NIEUN YAE PIEUP
    case 0x868E: code_point = 0xB0FE; break; // HANGUL SYLLABLE NIEUN YAE PIEUPSIOS
    case 0x868F: code_point = 0xB0FF; break; // HANGUL SYLLABLE NIEUN YAE SIOS
    case 0x8690: code_point = 0xB100; break; // HANGUL SYLLABLE NIEUN YAE SSANGSIOS
    case 0x8691: code_point = 0xB101; break; // HANGUL SYLLABLE NIEUN YAE IEUNG
    case 0x8692: code_point = 0xB102; break; // HANGUL SYLLABLE NIEUN YAE CIEUC
    case 0x8693: code_point = 0xB103; break; // HANGUL SYLLABLE NIEUN YAE CHIEUCH
    case 0x8694: code_point = 0xB104; break; // HANGUL SYLLABLE NIEUN YAE KHIEUKH
    case 0x8695: code_point = 0xB105; break; // HANGUL SYLLABLE NIEUN YAE THIEUTH
    case 0x8696: code_point = 0xB106; break; // HANGUL SYLLABLE NIEUN YAE PHIEUPH
    case 0x8697: code_point = 0xB107; break; // HANGUL SYLLABLE NIEUN YAE HIEUH
    case 0x8698: code_point = 0xB10A; break; // HANGUL SYLLABLE NIEUN EO SSANGKIYEOK
    case 0x8699: code_point = 0xB10D; break; // HANGUL SYLLABLE NIEUN EO NIEUNCIEUC
    case 0x869A: code_point = 0xB10E; break; // HANGUL SYLLABLE NIEUN EO NIEUNHIEUH
    case 0x869B: code_point = 0xB10F; break; // HANGUL SYLLABLE NIEUN EO TIKEUT
    case 0x869C: code_point = 0xB111; break; // HANGUL SYLLABLE NIEUN EO RIEULKIYEOK
    case 0x869D: code_point = 0xB114; break; // HANGUL SYLLABLE NIEUN EO RIEULSIOS
    case 0x869E: code_point = 0xB115; break; // HANGUL SYLLABLE NIEUN EO RIEULTHIEUTH
    case 0x869F: code_point = 0xB116; break; // HANGUL SYLLABLE NIEUN EO RIEULPHIEUPH
    case 0x86A0: code_point = 0xB117; break; // HANGUL SYLLABLE NIEUN EO RIEULHIEUH
    case 0x86A1: code_point = 0xB11A; break; // HANGUL SYLLABLE NIEUN EO PIEUPSIOS
    case 0x86A2: code_point = 0xB11E; break; // HANGUL SYLLABLE NIEUN EO CIEUC
    case 0x86A3: code_point = 0xB11F; break; // HANGUL SYLLABLE NIEUN EO CHIEUCH
    case 0x86A4: code_point = 0xB120; break; // HANGUL SYLLABLE NIEUN EO KHIEUKH
    case 0x86A5: code_point = 0xB121; break; // HANGUL SYLLABLE NIEUN EO THIEUTH
    case 0x86A6: code_point = 0xB122; break; // HANGUL SYLLABLE NIEUN EO PHIEUPH
    case 0x86A7: code_point = 0xB126; break; // HANGUL SYLLABLE NIEUN E SSANGKIYEOK
    case 0x86A8: code_point = 0xB127; break; // HANGUL SYLLABLE NIEUN E KIYEOKSIOS
    case 0x86A9: code_point = 0xB129; break; // HANGUL SYLLABLE NIEUN E NIEUNCIEUC
    case 0x86AA: code_point = 0xB12A; break; // HANGUL SYLLABLE NIEUN E NIEUNHIEUH
    case 0x86AB: code_point = 0xB12B; break; // HANGUL SYLLABLE NIEUN E TIKEUT
    case 0x86AC: code_point = 0xB12D; break; // HANGUL SYLLABLE NIEUN E RIEULKIYEOK
    case 0x86AD: code_point = 0xB12E; break; // HANGUL SYLLABLE NIEUN E RIEULMIEUM
    case 0x86AE: code_point = 0xB12F; break; // HANGUL SYLLABLE NIEUN E RIEULPIEUP
    case 0x86AF: code_point = 0xB130; break; // HANGUL SYLLABLE NIEUN E RIEULSIOS
    case 0x86B0: code_point = 0xB131; break; // HANGUL SYLLABLE NIEUN E RIEULTHIEUTH
    case 0x86B1: code_point = 0xB132; break; // HANGUL SYLLABLE NIEUN E RIEULPHIEUPH
    case 0x86B2: code_point = 0xB133; break; // HANGUL SYLLABLE NIEUN E RIEULHIEUH
    case 0x86B3: code_point = 0xB136; break; // HANGUL SYLLABLE NIEUN E PIEUPSIOS
    case 0x86B4: code_point = 0xB13A; break; // HANGUL SYLLABLE NIEUN E CIEUC
    case 0x86B5: code_point = 0xB13B; break; // HANGUL SYLLABLE NIEUN E CHIEUCH
    case 0x86B6: code_point = 0xB13C; break; // HANGUL SYLLABLE NIEUN E KHIEUKH
    case 0x86B7: code_point = 0xB13D; break; // HANGUL SYLLABLE NIEUN E THIEUTH
    case 0x86B8: code_point = 0xB13E; break; // HANGUL SYLLABLE NIEUN E PHIEUPH
    case 0x86B9: code_point = 0xB13F; break; // HANGUL SYLLABLE NIEUN E HIEUH
    case 0x86BA: code_point = 0xB142; break; // HANGUL SYLLABLE NIEUN YEO SSANGKIYEOK
    case 0x86BB: code_point = 0xB143; break; // HANGUL SYLLABLE NIEUN YEO KIYEOKSIOS
    case 0x86BC: code_point = 0xB145; break; // HANGUL SYLLABLE NIEUN YEO NIEUNCIEUC
    case 0x86BD: code_point = 0xB146; break; // HANGUL SYLLABLE NIEUN YEO NIEUNHIEUH
    case 0x86BE: code_point = 0xB147; break; // HANGUL SYLLABLE NIEUN YEO TIKEUT
    case 0x86BF: code_point = 0xB149; break; // HANGUL SYLLABLE NIEUN YEO RIEULKIYEOK
    case 0x86C0: code_point = 0xB14A; break; // HANGUL SYLLABLE NIEUN YEO RIEULMIEUM
    case 0x86C1: code_point = 0xB14B; break; // HANGUL SYLLABLE NIEUN YEO RIEULPIEUP
    case 0x86C2: code_point = 0xB14C; break; // HANGUL SYLLABLE NIEUN YEO RIEULSIOS
    case 0x86C3: code_point = 0xB14D; break; // HANGUL SYLLABLE NIEUN YEO RIEULTHIEUTH
    case 0x86C4: code_point = 0xB14E; break; // HANGUL SYLLABLE NIEUN YEO RIEULPHIEUPH
    case 0x86C5: code_point = 0xB14F; break; // HANGUL SYLLABLE NIEUN YEO RIEULHIEUH
    case 0x86C6: code_point = 0xB152; break; // HANGUL SYLLABLE NIEUN YEO PIEUPSIOS
    case 0x86C7: code_point = 0xB153; break; // HANGUL SYLLABLE NIEUN YEO SIOS
    case 0x86C8: code_point = 0xB156; break; // HANGUL SYLLABLE NIEUN YEO CIEUC
    case 0x86C9: code_point = 0xB157; break; // HANGUL SYLLABLE NIEUN YEO CHIEUCH
    case 0x86CA: code_point = 0xB159; break; // HANGUL SYLLABLE NIEUN YEO THIEUTH
    case 0x86CB: code_point = 0xB15A; break; // HANGUL SYLLABLE NIEUN YEO PHIEUPH
    case 0x86CC: code_point = 0xB15B; break; // HANGUL SYLLABLE NIEUN YEO HIEUH
    case 0x86CD: code_point = 0xB15D; break; // HANGUL SYLLABLE NIEUN YE KIYEOK
    case 0x86CE: code_point = 0xB15E; break; // HANGUL SYLLABLE NIEUN YE SSANGKIYEOK
    case 0x86CF: code_point = 0xB15F; break; // HANGUL SYLLABLE NIEUN YE KIYEOKSIOS
    case 0x86D0: code_point = 0xB161; break; // HANGUL SYLLABLE NIEUN YE NIEUNCIEUC
    case 0x86D1: code_point = 0xB162; break; // HANGUL SYLLABLE NIEUN YE NIEUNHIEUH
    case 0x86D2: code_point = 0xB163; break; // HANGUL SYLLABLE NIEUN YE TIKEUT
    case 0x86D3: code_point = 0xB164; break; // HANGUL SYLLABLE NIEUN YE RIEUL
    case 0x86D4: code_point = 0xB165; break; // HANGUL SYLLABLE NIEUN YE RIEULKIYEOK
    case 0x86D5: code_point = 0xB166; break; // HANGUL SYLLABLE NIEUN YE RIEULMIEUM
    case 0x86D6: code_point = 0xB167; break; // HANGUL SYLLABLE NIEUN YE RIEULPIEUP
    case 0x86D7: code_point = 0xB168; break; // HANGUL SYLLABLE NIEUN YE RIEULSIOS
    case 0x86D8: code_point = 0xB169; break; // HANGUL SYLLABLE NIEUN YE RIEULTHIEUTH
    case 0x86D9: code_point = 0xB16A; break; // HANGUL SYLLABLE NIEUN YE RIEULPHIEUPH
    case 0x86DA: code_point = 0xB16B; break; // HANGUL SYLLABLE NIEUN YE RIEULHIEUH
    case 0x86DB: code_point = 0xB16C; break; // HANGUL SYLLABLE NIEUN YE MIEUM
    case 0x86DC: code_point = 0xB16D; break; // HANGUL SYLLABLE NIEUN YE PIEUP
    case 0x86DD: code_point = 0xB16E; break; // HANGUL SYLLABLE NIEUN YE PIEUPSIOS
    case 0x86DE: code_point = 0xB16F; break; // HANGUL SYLLABLE NIEUN YE SIOS
    case 0x86DF: code_point = 0xB170; break; // HANGUL SYLLABLE NIEUN YE SSANGSIOS
    case 0x86E0: code_point = 0xB171; break; // HANGUL SYLLABLE NIEUN YE IEUNG
    case 0x86E1: code_point = 0xB172; break; // HANGUL SYLLABLE NIEUN YE CIEUC
    case 0x86E2: code_point = 0xB173; break; // HANGUL SYLLABLE NIEUN YE CHIEUCH
    case 0x86E3: code_point = 0xB174; break; // HANGUL SYLLABLE NIEUN YE KHIEUKH
    case 0x86E4: code_point = 0xB175; break; // HANGUL SYLLABLE NIEUN YE THIEUTH
    case 0x86E5: code_point = 0xB176; break; // HANGUL SYLLABLE NIEUN YE PHIEUPH
    case 0x86E6: code_point = 0xB177; break; // HANGUL SYLLABLE NIEUN YE HIEUH
    case 0x86E7: code_point = 0xB17A; break; // HANGUL SYLLABLE NIEUN O SSANGKIYEOK
    case 0x86E8: code_point = 0xB17B; break; // HANGUL SYLLABLE NIEUN O KIYEOKSIOS
    case 0x86E9: code_point = 0xB17D; break; // HANGUL SYLLABLE NIEUN O NIEUNCIEUC
    case 0x86EA: code_point = 0xB17E; break; // HANGUL SYLLABLE NIEUN O NIEUNHIEUH
    case 0x86EB: code_point = 0xB17F; break; // HANGUL SYLLABLE NIEUN O TIKEUT
    case 0x86EC: code_point = 0xB181; break; // HANGUL SYLLABLE NIEUN O RIEULKIYEOK
    case 0x86ED: code_point = 0xB183; break; // HANGUL SYLLABLE NIEUN O RIEULPIEUP
    case 0x86EE: code_point = 0xB184; break; // HANGUL SYLLABLE NIEUN O RIEULSIOS
    case 0x86EF: code_point = 0xB185; break; // HANGUL SYLLABLE NIEUN O RIEULTHIEUTH
    case 0x86F0: code_point = 0xB186; break; // HANGUL SYLLABLE NIEUN O RIEULPHIEUPH
    case 0x86F1: code_point = 0xB187; break; // HANGUL SYLLABLE NIEUN O RIEULHIEUH
    case 0x86F2: code_point = 0xB18A; break; // HANGUL SYLLABLE NIEUN O PIEUPSIOS
    case 0x86F3: code_point = 0xB18C; break; // HANGUL SYLLABLE NIEUN O SSANGSIOS
    case 0x86F4: code_point = 0xB18E; break; // HANGUL SYLLABLE NIEUN O CIEUC
    case 0x86F5: code_point = 0xB18F; break; // HANGUL SYLLABLE NIEUN O CHIEUCH
    case 0x86F6: code_point = 0xB190; break; // HANGUL SYLLABLE NIEUN O KHIEUKH
    case 0x86F7: code_point = 0xB191; break; // HANGUL SYLLABLE NIEUN O THIEUTH
    case 0x86F8: code_point = 0xB195; break; // HANGUL SYLLABLE NIEUN WA KIYEOK
    case 0x86F9: code_point = 0xB196; break; // HANGUL SYLLABLE NIEUN WA SSANGKIYEOK
    case 0x86FA: code_point = 0xB197; break; // HANGUL SYLLABLE NIEUN WA KIYEOKSIOS
    case 0x86FB: code_point = 0xB199; break; // HANGUL SYLLABLE NIEUN WA NIEUNCIEUC
    case 0x86FC: code_point = 0xB19A; break; // HANGUL SYLLABLE NIEUN WA NIEUNHIEUH
    case 0x86FD: code_point = 0xB19B; break; // HANGUL SYLLABLE NIEUN WA TIKEUT
    case 0x86FE: code_point = 0xB19D; break; // HANGUL SYLLABLE NIEUN WA RIEULKIYEOK
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x87(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8741: code_point = 0xB19E; break; // HANGUL SYLLABLE NIEUN WA RIEULMIEUM
    case 0x8742: code_point = 0xB19F; break; // HANGUL SYLLABLE NIEUN WA RIEULPIEUP
    case 0x8743: code_point = 0xB1A0; break; // HANGUL SYLLABLE NIEUN WA RIEULSIOS
    case 0x8744: code_point = 0xB1A1; break; // HANGUL SYLLABLE NIEUN WA RIEULTHIEUTH
    case 0x8745: code_point = 0xB1A2; break; // HANGUL SYLLABLE NIEUN WA RIEULPHIEUPH
    case 0x8746: code_point = 0xB1A3; break; // HANGUL SYLLABLE NIEUN WA RIEULHIEUH
    case 0x8747: code_point = 0xB1A4; break; // HANGUL SYLLABLE NIEUN WA MIEUM
    case 0x8748: code_point = 0xB1A5; break; // HANGUL SYLLABLE NIEUN WA PIEUP
    case 0x8749: code_point = 0xB1A6; break; // HANGUL SYLLABLE NIEUN WA PIEUPSIOS
    case 0x874A: code_point = 0xB1A7; break; // HANGUL SYLLABLE NIEUN WA SIOS
    case 0x874B: code_point = 0xB1A9; break; // HANGUL SYLLABLE NIEUN WA IEUNG
    case 0x874C: code_point = 0xB1AA; break; // HANGUL SYLLABLE NIEUN WA CIEUC
    case 0x874D: code_point = 0xB1AB; break; // HANGUL SYLLABLE NIEUN WA CHIEUCH
    case 0x874E: code_point = 0xB1AC; break; // HANGUL SYLLABLE NIEUN WA KHIEUKH
    case 0x874F: code_point = 0xB1AD; break; // HANGUL SYLLABLE NIEUN WA THIEUTH
    case 0x8750: code_point = 0xB1AE; break; // HANGUL SYLLABLE NIEUN WA PHIEUPH
    case 0x8751: code_point = 0xB1AF; break; // HANGUL SYLLABLE NIEUN WA HIEUH
    case 0x8752: code_point = 0xB1B0; break; // HANGUL SYLLABLE NIEUN WAE
    case 0x8753: code_point = 0xB1B1; break; // HANGUL SYLLABLE NIEUN WAE KIYEOK
    case 0x8754: code_point = 0xB1B2; break; // HANGUL SYLLABLE NIEUN WAE SSANGKIYEOK
    case 0x8755: code_point = 0xB1B3; break; // HANGUL SYLLABLE NIEUN WAE KIYEOKSIOS
    case 0x8756: code_point = 0xB1B4; break; // HANGUL SYLLABLE NIEUN WAE NIEUN
    case 0x8757: code_point = 0xB1B5; break; // HANGUL SYLLABLE NIEUN WAE NIEUNCIEUC
    case 0x8758: code_point = 0xB1B6; break; // HANGUL SYLLABLE NIEUN WAE NIEUNHIEUH
    case 0x8759: code_point = 0xB1B7; break; // HANGUL SYLLABLE NIEUN WAE TIKEUT
    case 0x875A: code_point = 0xB1B8; break; // HANGUL SYLLABLE NIEUN WAE RIEUL
    case 0x8761: code_point = 0xB1B9; break; // HANGUL SYLLABLE NIEUN WAE RIEULKIYEOK
    case 0x8762: code_point = 0xB1BA; break; // HANGUL SYLLABLE NIEUN WAE RIEULMIEUM
    case 0x8763: code_point = 0xB1BB; break; // HANGUL SYLLABLE NIEUN WAE RIEULPIEUP
    case 0x8764: code_point = 0xB1BC; break; // HANGUL SYLLABLE NIEUN WAE RIEULSIOS
    case 0x8765: code_point = 0xB1BD; break; // HANGUL SYLLABLE NIEUN WAE RIEULTHIEUTH
    case 0x8766: code_point = 0xB1BE; break; // HANGUL SYLLABLE NIEUN WAE RIEULPHIEUPH
    case 0x8767: code_point = 0xB1BF; break; // HANGUL SYLLABLE NIEUN WAE RIEULHIEUH
    case 0x8768: code_point = 0xB1C0; break; // HANGUL SYLLABLE NIEUN WAE MIEUM
    case 0x8769: code_point = 0xB1C1; break; // HANGUL SYLLABLE NIEUN WAE PIEUP
    case 0x876A: code_point = 0xB1C2; break; // HANGUL SYLLABLE NIEUN WAE PIEUPSIOS
    case 0x876B: code_point = 0xB1C3; break; // HANGUL SYLLABLE NIEUN WAE SIOS
    case 0x876C: code_point = 0xB1C4; break; // HANGUL SYLLABLE NIEUN WAE SSANGSIOS
    case 0x876D: code_point = 0xB1C5; break; // HANGUL SYLLABLE NIEUN WAE IEUNG
    case 0x876E: code_point = 0xB1C6; break; // HANGUL SYLLABLE NIEUN WAE CIEUC
    case 0x876F: code_point = 0xB1C7; break; // HANGUL SYLLABLE NIEUN WAE CHIEUCH
    case 0x8770: code_point = 0xB1C8; break; // HANGUL SYLLABLE NIEUN WAE KHIEUKH
    case 0x8771: code_point = 0xB1C9; break; // HANGUL SYLLABLE NIEUN WAE THIEUTH
    case 0x8772: code_point = 0xB1CA; break; // HANGUL SYLLABLE NIEUN WAE PHIEUPH
    case 0x8773: code_point = 0xB1CB; break; // HANGUL SYLLABLE NIEUN WAE HIEUH
    case 0x8774: code_point = 0xB1CD; break; // HANGUL SYLLABLE NIEUN OE KIYEOK
    case 0x8775: code_point = 0xB1CE; break; // HANGUL SYLLABLE NIEUN OE SSANGKIYEOK
    case 0x8776: code_point = 0xB1CF; break; // HANGUL SYLLABLE NIEUN OE KIYEOKSIOS
    case 0x8777: code_point = 0xB1D1; break; // HANGUL SYLLABLE NIEUN OE NIEUNCIEUC
    case 0x8778: code_point = 0xB1D2; break; // HANGUL SYLLABLE NIEUN OE NIEUNHIEUH
    case 0x8779: code_point = 0xB1D3; break; // HANGUL SYLLABLE NIEUN OE TIKEUT
    case 0x877A: code_point = 0xB1D5; break; // HANGUL SYLLABLE NIEUN OE RIEULKIYEOK
    case 0x8781: code_point = 0xB1D6; break; // HANGUL SYLLABLE NIEUN OE RIEULMIEUM
    case 0x8782: code_point = 0xB1D7; break; // HANGUL SYLLABLE NIEUN OE RIEULPIEUP
    case 0x8783: code_point = 0xB1D8; break; // HANGUL SYLLABLE NIEUN OE RIEULSIOS
    case 0x8784: code_point = 0xB1D9; break; // HANGUL SYLLABLE NIEUN OE RIEULTHIEUTH
    case 0x8785: code_point = 0xB1DA; break; // HANGUL SYLLABLE NIEUN OE RIEULPHIEUPH
    case 0x8786: code_point = 0xB1DB; break; // HANGUL SYLLABLE NIEUN OE RIEULHIEUH
    case 0x8787: code_point = 0xB1DE; break; // HANGUL SYLLABLE NIEUN OE PIEUPSIOS
    case 0x8788: code_point = 0xB1E0; break; // HANGUL SYLLABLE NIEUN OE SSANGSIOS
    case 0x8789: code_point = 0xB1E1; break; // HANGUL SYLLABLE NIEUN OE IEUNG
    case 0x878A: code_point = 0xB1E2; break; // HANGUL SYLLABLE NIEUN OE CIEUC
    case 0x878B: code_point = 0xB1E3; break; // HANGUL SYLLABLE NIEUN OE CHIEUCH
    case 0x878C: code_point = 0xB1E4; break; // HANGUL SYLLABLE NIEUN OE KHIEUKH
    case 0x878D: code_point = 0xB1E5; break; // HANGUL SYLLABLE NIEUN OE THIEUTH
    case 0x878E: code_point = 0xB1E6; break; // HANGUL SYLLABLE NIEUN OE PHIEUPH
    case 0x878F: code_point = 0xB1E7; break; // HANGUL SYLLABLE NIEUN OE HIEUH
    case 0x8790: code_point = 0xB1EA; break; // HANGUL SYLLABLE NIEUN YO SSANGKIYEOK
    case 0x8791: code_point = 0xB1EB; break; // HANGUL SYLLABLE NIEUN YO KIYEOKSIOS
    case 0x8792: code_point = 0xB1ED; break; // HANGUL SYLLABLE NIEUN YO NIEUNCIEUC
    case 0x8793: code_point = 0xB1EE; break; // HANGUL SYLLABLE NIEUN YO NIEUNHIEUH
    case 0x8794: code_point = 0xB1EF; break; // HANGUL SYLLABLE NIEUN YO TIKEUT
    case 0x8795: code_point = 0xB1F1; break; // HANGUL SYLLABLE NIEUN YO RIEULKIYEOK
    case 0x8796: code_point = 0xB1F2; break; // HANGUL SYLLABLE NIEUN YO RIEULMIEUM
    case 0x8797: code_point = 0xB1F3; break; // HANGUL SYLLABLE NIEUN YO RIEULPIEUP
    case 0x8798: code_point = 0xB1F4; break; // HANGUL SYLLABLE NIEUN YO RIEULSIOS
    case 0x8799: code_point = 0xB1F5; break; // HANGUL SYLLABLE NIEUN YO RIEULTHIEUTH
    case 0x879A: code_point = 0xB1F6; break; // HANGUL SYLLABLE NIEUN YO RIEULPHIEUPH
    case 0x879B: code_point = 0xB1F7; break; // HANGUL SYLLABLE NIEUN YO RIEULHIEUH
    case 0x879C: code_point = 0xB1F8; break; // HANGUL SYLLABLE NIEUN YO MIEUM
    case 0x879D: code_point = 0xB1FA; break; // HANGUL SYLLABLE NIEUN YO PIEUPSIOS
    case 0x879E: code_point = 0xB1FC; break; // HANGUL SYLLABLE NIEUN YO SSANGSIOS
    case 0x879F: code_point = 0xB1FE; break; // HANGUL SYLLABLE NIEUN YO CIEUC
    case 0x87A0: code_point = 0xB1FF; break; // HANGUL SYLLABLE NIEUN YO CHIEUCH
    case 0x87A1: code_point = 0xB200; break; // HANGUL SYLLABLE NIEUN YO KHIEUKH
    case 0x87A2: code_point = 0xB201; break; // HANGUL SYLLABLE NIEUN YO THIEUTH
    case 0x87A3: code_point = 0xB202; break; // HANGUL SYLLABLE NIEUN YO PHIEUPH
    case 0x87A4: code_point = 0xB203; break; // HANGUL SYLLABLE NIEUN YO HIEUH
    case 0x87A5: code_point = 0xB206; break; // HANGUL SYLLABLE NIEUN U SSANGKIYEOK
    case 0x87A6: code_point = 0xB207; break; // HANGUL SYLLABLE NIEUN U KIYEOKSIOS
    case 0x87A7: code_point = 0xB209; break; // HANGUL SYLLABLE NIEUN U NIEUNCIEUC
    case 0x87A8: code_point = 0xB20A; break; // HANGUL SYLLABLE NIEUN U NIEUNHIEUH
    case 0x87A9: code_point = 0xB20D; break; // HANGUL SYLLABLE NIEUN U RIEULKIYEOK
    case 0x87AA: code_point = 0xB20E; break; // HANGUL SYLLABLE NIEUN U RIEULMIEUM
    case 0x87AB: code_point = 0xB20F; break; // HANGUL SYLLABLE NIEUN U RIEULPIEUP
    case 0x87AC: code_point = 0xB210; break; // HANGUL SYLLABLE NIEUN U RIEULSIOS
    case 0x87AD: code_point = 0xB211; break; // HANGUL SYLLABLE NIEUN U RIEULTHIEUTH
    case 0x87AE: code_point = 0xB212; break; // HANGUL SYLLABLE NIEUN U RIEULPHIEUPH
    case 0x87AF: code_point = 0xB213; break; // HANGUL SYLLABLE NIEUN U RIEULHIEUH
    case 0x87B0: code_point = 0xB216; break; // HANGUL SYLLABLE NIEUN U PIEUPSIOS
    case 0x87B1: code_point = 0xB218; break; // HANGUL SYLLABLE NIEUN U SSANGSIOS
    case 0x87B2: code_point = 0xB21A; break; // HANGUL SYLLABLE NIEUN U CIEUC
    case 0x87B3: code_point = 0xB21B; break; // HANGUL SYLLABLE NIEUN U CHIEUCH
    case 0x87B4: code_point = 0xB21C; break; // HANGUL SYLLABLE NIEUN U KHIEUKH
    case 0x87B5: code_point = 0xB21D; break; // HANGUL SYLLABLE NIEUN U THIEUTH
    case 0x87B6: code_point = 0xB21E; break; // HANGUL SYLLABLE NIEUN U PHIEUPH
    case 0x87B7: code_point = 0xB21F; break; // HANGUL SYLLABLE NIEUN U HIEUH
    case 0x87B8: code_point = 0xB221; break; // HANGUL SYLLABLE NIEUN WEO KIYEOK
    case 0x87B9: code_point = 0xB222; break; // HANGUL SYLLABLE NIEUN WEO SSANGKIYEOK
    case 0x87BA: code_point = 0xB223; break; // HANGUL SYLLABLE NIEUN WEO KIYEOKSIOS
    case 0x87BB: code_point = 0xB224; break; // HANGUL SYLLABLE NIEUN WEO NIEUN
    case 0x87BC: code_point = 0xB225; break; // HANGUL SYLLABLE NIEUN WEO NIEUNCIEUC
    case 0x87BD: code_point = 0xB226; break; // HANGUL SYLLABLE NIEUN WEO NIEUNHIEUH
    case 0x87BE: code_point = 0xB227; break; // HANGUL SYLLABLE NIEUN WEO TIKEUT
    case 0x87BF: code_point = 0xB228; break; // HANGUL SYLLABLE NIEUN WEO RIEUL
    case 0x87C0: code_point = 0xB229; break; // HANGUL SYLLABLE NIEUN WEO RIEULKIYEOK
    case 0x87C1: code_point = 0xB22A; break; // HANGUL SYLLABLE NIEUN WEO RIEULMIEUM
    case 0x87C2: code_point = 0xB22B; break; // HANGUL SYLLABLE NIEUN WEO RIEULPIEUP
    case 0x87C3: code_point = 0xB22C; break; // HANGUL SYLLABLE NIEUN WEO RIEULSIOS
    case 0x87C4: code_point = 0xB22D; break; // HANGUL SYLLABLE NIEUN WEO RIEULTHIEUTH
    case 0x87C5: code_point = 0xB22E; break; // HANGUL SYLLABLE NIEUN WEO RIEULPHIEUPH
    case 0x87C6: code_point = 0xB22F; break; // HANGUL SYLLABLE NIEUN WEO RIEULHIEUH
    case 0x87C7: code_point = 0xB230; break; // HANGUL SYLLABLE NIEUN WEO MIEUM
    case 0x87C8: code_point = 0xB231; break; // HANGUL SYLLABLE NIEUN WEO PIEUP
    case 0x87C9: code_point = 0xB232; break; // HANGUL SYLLABLE NIEUN WEO PIEUPSIOS
    case 0x87CA: code_point = 0xB233; break; // HANGUL SYLLABLE NIEUN WEO SIOS
    case 0x87CB: code_point = 0xB235; break; // HANGUL SYLLABLE NIEUN WEO IEUNG
    case 0x87CC: code_point = 0xB236; break; // HANGUL SYLLABLE NIEUN WEO CIEUC
    case 0x87CD: code_point = 0xB237; break; // HANGUL SYLLABLE NIEUN WEO CHIEUCH
    case 0x87CE: code_point = 0xB238; break; // HANGUL SYLLABLE NIEUN WEO KHIEUKH
    case 0x87CF: code_point = 0xB239; break; // HANGUL SYLLABLE NIEUN WEO THIEUTH
    case 0x87D0: code_point = 0xB23A; break; // HANGUL SYLLABLE NIEUN WEO PHIEUPH
    case 0x87D1: code_point = 0xB23B; break; // HANGUL SYLLABLE NIEUN WEO HIEUH
    case 0x87D2: code_point = 0xB23D; break; // HANGUL SYLLABLE NIEUN WE KIYEOK
    case 0x87D3: code_point = 0xB23E; break; // HANGUL SYLLABLE NIEUN WE SSANGKIYEOK
    case 0x87D4: code_point = 0xB23F; break; // HANGUL SYLLABLE NIEUN WE KIYEOKSIOS
    case 0x87D5: code_point = 0xB240; break; // HANGUL SYLLABLE NIEUN WE NIEUN
    case 0x87D6: code_point = 0xB241; break; // HANGUL SYLLABLE NIEUN WE NIEUNCIEUC
    case 0x87D7: code_point = 0xB242; break; // HANGUL SYLLABLE NIEUN WE NIEUNHIEUH
    case 0x87D8: code_point = 0xB243; break; // HANGUL SYLLABLE NIEUN WE TIKEUT
    case 0x87D9: code_point = 0xB244; break; // HANGUL SYLLABLE NIEUN WE RIEUL
    case 0x87DA: code_point = 0xB245; break; // HANGUL SYLLABLE NIEUN WE RIEULKIYEOK
    case 0x87DB: code_point = 0xB246; break; // HANGUL SYLLABLE NIEUN WE RIEULMIEUM
    case 0x87DC: code_point = 0xB247; break; // HANGUL SYLLABLE NIEUN WE RIEULPIEUP
    case 0x87DD: code_point = 0xB248; break; // HANGUL SYLLABLE NIEUN WE RIEULSIOS
    case 0x87DE: code_point = 0xB249; break; // HANGUL SYLLABLE NIEUN WE RIEULTHIEUTH
    case 0x87DF: code_point = 0xB24A; break; // HANGUL SYLLABLE NIEUN WE RIEULPHIEUPH
    case 0x87E0: code_point = 0xB24B; break; // HANGUL SYLLABLE NIEUN WE RIEULHIEUH
    case 0x87E1: code_point = 0xB24C; break; // HANGUL SYLLABLE NIEUN WE MIEUM
    case 0x87E2: code_point = 0xB24D; break; // HANGUL SYLLABLE NIEUN WE PIEUP
    case 0x87E3: code_point = 0xB24E; break; // HANGUL SYLLABLE NIEUN WE PIEUPSIOS
    case 0x87E4: code_point = 0xB24F; break; // HANGUL SYLLABLE NIEUN WE SIOS
    case 0x87E5: code_point = 0xB250; break; // HANGUL SYLLABLE NIEUN WE SSANGSIOS
    case 0x87E6: code_point = 0xB251; break; // HANGUL SYLLABLE NIEUN WE IEUNG
    case 0x87E7: code_point = 0xB252; break; // HANGUL SYLLABLE NIEUN WE CIEUC
    case 0x87E8: code_point = 0xB253; break; // HANGUL SYLLABLE NIEUN WE CHIEUCH
    case 0x87E9: code_point = 0xB254; break; // HANGUL SYLLABLE NIEUN WE KHIEUKH
    case 0x87EA: code_point = 0xB255; break; // HANGUL SYLLABLE NIEUN WE THIEUTH
    case 0x87EB: code_point = 0xB256; break; // HANGUL SYLLABLE NIEUN WE PHIEUPH
    case 0x87EC: code_point = 0xB257; break; // HANGUL SYLLABLE NIEUN WE HIEUH
    case 0x87ED: code_point = 0xB259; break; // HANGUL SYLLABLE NIEUN WI KIYEOK
    case 0x87EE: code_point = 0xB25A; break; // HANGUL SYLLABLE NIEUN WI SSANGKIYEOK
    case 0x87EF: code_point = 0xB25B; break; // HANGUL SYLLABLE NIEUN WI KIYEOKSIOS
    case 0x87F0: code_point = 0xB25D; break; // HANGUL SYLLABLE NIEUN WI NIEUNCIEUC
    case 0x87F1: code_point = 0xB25E; break; // HANGUL SYLLABLE NIEUN WI NIEUNHIEUH
    case 0x87F2: code_point = 0xB25F; break; // HANGUL SYLLABLE NIEUN WI TIKEUT
    case 0x87F3: code_point = 0xB261; break; // HANGUL SYLLABLE NIEUN WI RIEULKIYEOK
    case 0x87F4: code_point = 0xB262; break; // HANGUL SYLLABLE NIEUN WI RIEULMIEUM
    case 0x87F5: code_point = 0xB263; break; // HANGUL SYLLABLE NIEUN WI RIEULPIEUP
    case 0x87F6: code_point = 0xB264; break; // HANGUL SYLLABLE NIEUN WI RIEULSIOS
    case 0x87F7: code_point = 0xB265; break; // HANGUL SYLLABLE NIEUN WI RIEULTHIEUTH
    case 0x87F8: code_point = 0xB266; break; // HANGUL SYLLABLE NIEUN WI RIEULPHIEUPH
    case 0x87F9: code_point = 0xB267; break; // HANGUL SYLLABLE NIEUN WI RIEULHIEUH
    case 0x87FA: code_point = 0xB26A; break; // HANGUL SYLLABLE NIEUN WI PIEUPSIOS
    case 0x87FB: code_point = 0xB26B; break; // HANGUL SYLLABLE NIEUN WI SIOS
    case 0x87FC: code_point = 0xB26C; break; // HANGUL SYLLABLE NIEUN WI SSANGSIOS
    case 0x87FD: code_point = 0xB26D; break; // HANGUL SYLLABLE NIEUN WI IEUNG
    case 0x87FE: code_point = 0xB26E; break; // HANGUL SYLLABLE NIEUN WI CIEUC
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x88(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8841: code_point = 0xB26F; break; // HANGUL SYLLABLE NIEUN WI CHIEUCH
    case 0x8842: code_point = 0xB270; break; // HANGUL SYLLABLE NIEUN WI KHIEUKH
    case 0x8843: code_point = 0xB271; break; // HANGUL SYLLABLE NIEUN WI THIEUTH
    case 0x8844: code_point = 0xB272; break; // HANGUL SYLLABLE NIEUN WI PHIEUPH
    case 0x8845: code_point = 0xB273; break; // HANGUL SYLLABLE NIEUN WI HIEUH
    case 0x8846: code_point = 0xB276; break; // HANGUL SYLLABLE NIEUN YU SSANGKIYEOK
    case 0x8847: code_point = 0xB277; break; // HANGUL SYLLABLE NIEUN YU KIYEOKSIOS
    case 0x8848: code_point = 0xB278; break; // HANGUL SYLLABLE NIEUN YU NIEUN
    case 0x8849: code_point = 0xB279; break; // HANGUL SYLLABLE NIEUN YU NIEUNCIEUC
    case 0x884A: code_point = 0xB27A; break; // HANGUL SYLLABLE NIEUN YU NIEUNHIEUH
    case 0x884B: code_point = 0xB27B; break; // HANGUL SYLLABLE NIEUN YU TIKEUT
    case 0x884C: code_point = 0xB27D; break; // HANGUL SYLLABLE NIEUN YU RIEULKIYEOK
    case 0x884D: code_point = 0xB27E; break; // HANGUL SYLLABLE NIEUN YU RIEULMIEUM
    case 0x884E: code_point = 0xB27F; break; // HANGUL SYLLABLE NIEUN YU RIEULPIEUP
    case 0x884F: code_point = 0xB280; break; // HANGUL SYLLABLE NIEUN YU RIEULSIOS
    case 0x8850: code_point = 0xB281; break; // HANGUL SYLLABLE NIEUN YU RIEULTHIEUTH
    case 0x8851: code_point = 0xB282; break; // HANGUL SYLLABLE NIEUN YU RIEULPHIEUPH
    case 0x8852: code_point = 0xB283; break; // HANGUL SYLLABLE NIEUN YU RIEULHIEUH
    case 0x8853: code_point = 0xB286; break; // HANGUL SYLLABLE NIEUN YU PIEUPSIOS
    case 0x8854: code_point = 0xB287; break; // HANGUL SYLLABLE NIEUN YU SIOS
    case 0x8855: code_point = 0xB288; break; // HANGUL SYLLABLE NIEUN YU SSANGSIOS
    case 0x8856: code_point = 0xB28A; break; // HANGUL SYLLABLE NIEUN YU CIEUC
    case 0x8857: code_point = 0xB28B; break; // HANGUL SYLLABLE NIEUN YU CHIEUCH
    case 0x8858: code_point = 0xB28C; break; // HANGUL SYLLABLE NIEUN YU KHIEUKH
    case 0x8859: code_point = 0xB28D; break; // HANGUL SYLLABLE NIEUN YU THIEUTH
    case 0x885A: code_point = 0xB28E; break; // HANGUL SYLLABLE NIEUN YU PHIEUPH
    case 0x8861: code_point = 0xB28F; break; // HANGUL SYLLABLE NIEUN YU HIEUH
    case 0x8862: code_point = 0xB292; break; // HANGUL SYLLABLE NIEUN EU SSANGKIYEOK
    case 0x8863: code_point = 0xB293; break; // HANGUL SYLLABLE NIEUN EU KIYEOKSIOS
    case 0x8864: code_point = 0xB295; break; // HANGUL SYLLABLE NIEUN EU NIEUNCIEUC
    case 0x8865: code_point = 0xB296; break; // HANGUL SYLLABLE NIEUN EU NIEUNHIEUH
    case 0x8866: code_point = 0xB297; break; // HANGUL SYLLABLE NIEUN EU TIKEUT
    case 0x8867: code_point = 0xB29B; break; // HANGUL SYLLABLE NIEUN EU RIEULPIEUP
    case 0x8868: code_point = 0xB29C; break; // HANGUL SYLLABLE NIEUN EU RIEULSIOS
    case 0x8869: code_point = 0xB29D; break; // HANGUL SYLLABLE NIEUN EU RIEULTHIEUTH
    case 0x886A: code_point = 0xB29E; break; // HANGUL SYLLABLE NIEUN EU RIEULPHIEUPH
    case 0x886B: code_point = 0xB29F; break; // HANGUL SYLLABLE NIEUN EU RIEULHIEUH
    case 0x886C: code_point = 0xB2A2; break; // HANGUL SYLLABLE NIEUN EU PIEUPSIOS
    case 0x886D: code_point = 0xB2A4; break; // HANGUL SYLLABLE NIEUN EU SSANGSIOS
    case 0x886E: code_point = 0xB2A7; break; // HANGUL SYLLABLE NIEUN EU CHIEUCH
    case 0x886F: code_point = 0xB2A8; break; // HANGUL SYLLABLE NIEUN EU KHIEUKH
    case 0x8870: code_point = 0xB2A9; break; // HANGUL SYLLABLE NIEUN EU THIEUTH
    case 0x8871: code_point = 0xB2AB; break; // HANGUL SYLLABLE NIEUN EU HIEUH
    case 0x8872: code_point = 0xB2AD; break; // HANGUL SYLLABLE NIEUN YI KIYEOK
    case 0x8873: code_point = 0xB2AE; break; // HANGUL SYLLABLE NIEUN YI SSANGKIYEOK
    case 0x8874: code_point = 0xB2AF; break; // HANGUL SYLLABLE NIEUN YI KIYEOKSIOS
    case 0x8875: code_point = 0xB2B1; break; // HANGUL SYLLABLE NIEUN YI NIEUNCIEUC
    case 0x8876: code_point = 0xB2B2; break; // HANGUL SYLLABLE NIEUN YI NIEUNHIEUH
    case 0x8877: code_point = 0xB2B3; break; // HANGUL SYLLABLE NIEUN YI TIKEUT
    case 0x8878: code_point = 0xB2B5; break; // HANGUL SYLLABLE NIEUN YI RIEULKIYEOK
    case 0x8879: code_point = 0xB2B6; break; // HANGUL SYLLABLE NIEUN YI RIEULMIEUM
    case 0x887A: code_point = 0xB2B7; break; // HANGUL SYLLABLE NIEUN YI RIEULPIEUP
    case 0x8881: code_point = 0xB2B8; break; // HANGUL SYLLABLE NIEUN YI RIEULSIOS
    case 0x8882: code_point = 0xB2B9; break; // HANGUL SYLLABLE NIEUN YI RIEULTHIEUTH
    case 0x8883: code_point = 0xB2BA; break; // HANGUL SYLLABLE NIEUN YI RIEULPHIEUPH
    case 0x8884: code_point = 0xB2BB; break; // HANGUL SYLLABLE NIEUN YI RIEULHIEUH
    case 0x8885: code_point = 0xB2BC; break; // HANGUL SYLLABLE NIEUN YI MIEUM
    case 0x8886: code_point = 0xB2BD; break; // HANGUL SYLLABLE NIEUN YI PIEUP
    case 0x8887: code_point = 0xB2BE; break; // HANGUL SYLLABLE NIEUN YI PIEUPSIOS
    case 0x8888: code_point = 0xB2BF; break; // HANGUL SYLLABLE NIEUN YI SIOS
    case 0x8889: code_point = 0xB2C0; break; // HANGUL SYLLABLE NIEUN YI SSANGSIOS
    case 0x888A: code_point = 0xB2C1; break; // HANGUL SYLLABLE NIEUN YI IEUNG
    case 0x888B: code_point = 0xB2C2; break; // HANGUL SYLLABLE NIEUN YI CIEUC
    case 0x888C: code_point = 0xB2C3; break; // HANGUL SYLLABLE NIEUN YI CHIEUCH
    case 0x888D: code_point = 0xB2C4; break; // HANGUL SYLLABLE NIEUN YI KHIEUKH
    case 0x888E: code_point = 0xB2C5; break; // HANGUL SYLLABLE NIEUN YI THIEUTH
    case 0x888F: code_point = 0xB2C6; break; // HANGUL SYLLABLE NIEUN YI PHIEUPH
    case 0x8890: code_point = 0xB2C7; break; // HANGUL SYLLABLE NIEUN YI HIEUH
    case 0x8891: code_point = 0xB2CA; break; // HANGUL SYLLABLE NIEUN I SSANGKIYEOK
    case 0x8892: code_point = 0xB2CB; break; // HANGUL SYLLABLE NIEUN I KIYEOKSIOS
    case 0x8893: code_point = 0xB2CD; break; // HANGUL SYLLABLE NIEUN I NIEUNCIEUC
    case 0x8894: code_point = 0xB2CE; break; // HANGUL SYLLABLE NIEUN I NIEUNHIEUH
    case 0x8895: code_point = 0xB2CF; break; // HANGUL SYLLABLE NIEUN I TIKEUT
    case 0x8896: code_point = 0xB2D1; break; // HANGUL SYLLABLE NIEUN I RIEULKIYEOK
    case 0x8897: code_point = 0xB2D3; break; // HANGUL SYLLABLE NIEUN I RIEULPIEUP
    case 0x8898: code_point = 0xB2D4; break; // HANGUL SYLLABLE NIEUN I RIEULSIOS
    case 0x8899: code_point = 0xB2D5; break; // HANGUL SYLLABLE NIEUN I RIEULTHIEUTH
    case 0x889A: code_point = 0xB2D6; break; // HANGUL SYLLABLE NIEUN I RIEULPHIEUPH
    case 0x889B: code_point = 0xB2D7; break; // HANGUL SYLLABLE NIEUN I RIEULHIEUH
    case 0x889C: code_point = 0xB2DA; break; // HANGUL SYLLABLE NIEUN I PIEUPSIOS
    case 0x889D: code_point = 0xB2DC; break; // HANGUL SYLLABLE NIEUN I SSANGSIOS
    case 0x889E: code_point = 0xB2DE; break; // HANGUL SYLLABLE NIEUN I CIEUC
    case 0x889F: code_point = 0xB2DF; break; // HANGUL SYLLABLE NIEUN I CHIEUCH
    case 0x88A0: code_point = 0xB2E0; break; // HANGUL SYLLABLE NIEUN I KHIEUKH
    case 0x88A1: code_point = 0xB2E1; break; // HANGUL SYLLABLE NIEUN I THIEUTH
    case 0x88A2: code_point = 0xB2E3; break; // HANGUL SYLLABLE NIEUN I HIEUH
    case 0x88A3: code_point = 0xB2E7; break; // HANGUL SYLLABLE TIKEUT A KIYEOKSIOS
    case 0x88A4: code_point = 0xB2E9; break; // HANGUL SYLLABLE TIKEUT A NIEUNCIEUC
    case 0x88A5: code_point = 0xB2EA; break; // HANGUL SYLLABLE TIKEUT A NIEUNHIEUH
    case 0x88A6: code_point = 0xB2F0; break; // HANGUL SYLLABLE TIKEUT A RIEULSIOS
    case 0x88A7: code_point = 0xB2F1; break; // HANGUL SYLLABLE TIKEUT A RIEULTHIEUTH
    case 0x88A8: code_point = 0xB2F2; break; // HANGUL SYLLABLE TIKEUT A RIEULPHIEUPH
    case 0x88A9: code_point = 0xB2F6; break; // HANGUL SYLLABLE TIKEUT A PIEUPSIOS
    case 0x88AA: code_point = 0xB2FC; break; // HANGUL SYLLABLE TIKEUT A KHIEUKH
    case 0x88AB: code_point = 0xB2FD; break; // HANGUL SYLLABLE TIKEUT A THIEUTH
    case 0x88AC: code_point = 0xB2FE; break; // HANGUL SYLLABLE TIKEUT A PHIEUPH
    case 0x88AD: code_point = 0xB302; break; // HANGUL SYLLABLE TIKEUT AE SSANGKIYEOK
    case 0x88AE: code_point = 0xB303; break; // HANGUL SYLLABLE TIKEUT AE KIYEOKSIOS
    case 0x88AF: code_point = 0xB305; break; // HANGUL SYLLABLE TIKEUT AE NIEUNCIEUC
    case 0x88B0: code_point = 0xB306; break; // HANGUL SYLLABLE TIKEUT AE NIEUNHIEUH
    case 0x88B1: code_point = 0xB307; break; // HANGUL SYLLABLE TIKEUT AE TIKEUT
    case 0x88B2: code_point = 0xB309; break; // HANGUL SYLLABLE TIKEUT AE RIEULKIYEOK
    case 0x88B3: code_point = 0xB30A; break; // HANGUL SYLLABLE TIKEUT AE RIEULMIEUM
    case 0x88B4: code_point = 0xB30B; break; // HANGUL SYLLABLE TIKEUT AE RIEULPIEUP
    case 0x88B5: code_point = 0xB30C; break; // HANGUL SYLLABLE TIKEUT AE RIEULSIOS
    case 0x88B6: code_point = 0xB30D; break; // HANGUL SYLLABLE TIKEUT AE RIEULTHIEUTH
    case 0x88B7: code_point = 0xB30E; break; // HANGUL SYLLABLE TIKEUT AE RIEULPHIEUPH
    case 0x88B8: code_point = 0xB30F; break; // HANGUL SYLLABLE TIKEUT AE RIEULHIEUH
    case 0x88B9: code_point = 0xB312; break; // HANGUL SYLLABLE TIKEUT AE PIEUPSIOS
    case 0x88BA: code_point = 0xB316; break; // HANGUL SYLLABLE TIKEUT AE CIEUC
    case 0x88BB: code_point = 0xB317; break; // HANGUL SYLLABLE TIKEUT AE CHIEUCH
    case 0x88BC: code_point = 0xB318; break; // HANGUL SYLLABLE TIKEUT AE KHIEUKH
    case 0x88BD: code_point = 0xB319; break; // HANGUL SYLLABLE TIKEUT AE THIEUTH
    case 0x88BE: code_point = 0xB31A; break; // HANGUL SYLLABLE TIKEUT AE PHIEUPH
    case 0x88BF: code_point = 0xB31B; break; // HANGUL SYLLABLE TIKEUT AE HIEUH
    case 0x88C0: code_point = 0xB31D; break; // HANGUL SYLLABLE TIKEUT YA KIYEOK
    case 0x88C1: code_point = 0xB31E; break; // HANGUL SYLLABLE TIKEUT YA SSANGKIYEOK
    case 0x88C2: code_point = 0xB31F; break; // HANGUL SYLLABLE TIKEUT YA KIYEOKSIOS
    case 0x88C3: code_point = 0xB320; break; // HANGUL SYLLABLE TIKEUT YA NIEUN
    case 0x88C4: code_point = 0xB321; break; // HANGUL SYLLABLE TIKEUT YA NIEUNCIEUC
    case 0x88C5: code_point = 0xB322; break; // HANGUL SYLLABLE TIKEUT YA NIEUNHIEUH
    case 0x88C6: code_point = 0xB323; break; // HANGUL SYLLABLE TIKEUT YA TIKEUT
    case 0x88C7: code_point = 0xB324; break; // HANGUL SYLLABLE TIKEUT YA RIEUL
    case 0x88C8: code_point = 0xB325; break; // HANGUL SYLLABLE TIKEUT YA RIEULKIYEOK
    case 0x88C9: code_point = 0xB326; break; // HANGUL SYLLABLE TIKEUT YA RIEULMIEUM
    case 0x88CA: code_point = 0xB327; break; // HANGUL SYLLABLE TIKEUT YA RIEULPIEUP
    case 0x88CB: code_point = 0xB328; break; // HANGUL SYLLABLE TIKEUT YA RIEULSIOS
    case 0x88CC: code_point = 0xB329; break; // HANGUL SYLLABLE TIKEUT YA RIEULTHIEUTH
    case 0x88CD: code_point = 0xB32A; break; // HANGUL SYLLABLE TIKEUT YA RIEULPHIEUPH
    case 0x88CE: code_point = 0xB32B; break; // HANGUL SYLLABLE TIKEUT YA RIEULHIEUH
    case 0x88CF: code_point = 0xB32C; break; // HANGUL SYLLABLE TIKEUT YA MIEUM
    case 0x88D0: code_point = 0xB32D; break; // HANGUL SYLLABLE TIKEUT YA PIEUP
    case 0x88D1: code_point = 0xB32E; break; // HANGUL SYLLABLE TIKEUT YA PIEUPSIOS
    case 0x88D2: code_point = 0xB32F; break; // HANGUL SYLLABLE TIKEUT YA SIOS
    case 0x88D3: code_point = 0xB330; break; // HANGUL SYLLABLE TIKEUT YA SSANGSIOS
    case 0x88D4: code_point = 0xB331; break; // HANGUL SYLLABLE TIKEUT YA IEUNG
    case 0x88D5: code_point = 0xB332; break; // HANGUL SYLLABLE TIKEUT YA CIEUC
    case 0x88D6: code_point = 0xB333; break; // HANGUL SYLLABLE TIKEUT YA CHIEUCH
    case 0x88D7: code_point = 0xB334; break; // HANGUL SYLLABLE TIKEUT YA KHIEUKH
    case 0x88D8: code_point = 0xB335; break; // HANGUL SYLLABLE TIKEUT YA THIEUTH
    case 0x88D9: code_point = 0xB336; break; // HANGUL SYLLABLE TIKEUT YA PHIEUPH
    case 0x88DA: code_point = 0xB337; break; // HANGUL SYLLABLE TIKEUT YA HIEUH
    case 0x88DB: code_point = 0xB338; break; // HANGUL SYLLABLE TIKEUT YAE
    case 0x88DC: code_point = 0xB339; break; // HANGUL SYLLABLE TIKEUT YAE KIYEOK
    case 0x88DD: code_point = 0xB33A; break; // HANGUL SYLLABLE TIKEUT YAE SSANGKIYEOK
    case 0x88DE: code_point = 0xB33B; break; // HANGUL SYLLABLE TIKEUT YAE KIYEOKSIOS
    case 0x88DF: code_point = 0xB33C; break; // HANGUL SYLLABLE TIKEUT YAE NIEUN
    case 0x88E0: code_point = 0xB33D; break; // HANGUL SYLLABLE TIKEUT YAE NIEUNCIEUC
    case 0x88E1: code_point = 0xB33E; break; // HANGUL SYLLABLE TIKEUT YAE NIEUNHIEUH
    case 0x88E2: code_point = 0xB33F; break; // HANGUL SYLLABLE TIKEUT YAE TIKEUT
    case 0x88E3: code_point = 0xB340; break; // HANGUL SYLLABLE TIKEUT YAE RIEUL
    case 0x88E4: code_point = 0xB341; break; // HANGUL SYLLABLE TIKEUT YAE RIEULKIYEOK
    case 0x88E5: code_point = 0xB342; break; // HANGUL SYLLABLE TIKEUT YAE RIEULMIEUM
    case 0x88E6: code_point = 0xB343; break; // HANGUL SYLLABLE TIKEUT YAE RIEULPIEUP
    case 0x88E7: code_point = 0xB344; break; // HANGUL SYLLABLE TIKEUT YAE RIEULSIOS
    case 0x88E8: code_point = 0xB345; break; // HANGUL SYLLABLE TIKEUT YAE RIEULTHIEUTH
    case 0x88E9: code_point = 0xB346; break; // HANGUL SYLLABLE TIKEUT YAE RIEULPHIEUPH
    case 0x88EA: code_point = 0xB347; break; // HANGUL SYLLABLE TIKEUT YAE RIEULHIEUH
    case 0x88EB: code_point = 0xB348; break; // HANGUL SYLLABLE TIKEUT YAE MIEUM
    case 0x88EC: code_point = 0xB349; break; // HANGUL SYLLABLE TIKEUT YAE PIEUP
    case 0x88ED: code_point = 0xB34A; break; // HANGUL SYLLABLE TIKEUT YAE PIEUPSIOS
    case 0x88EE: code_point = 0xB34B; break; // HANGUL SYLLABLE TIKEUT YAE SIOS
    case 0x88EF: code_point = 0xB34C; break; // HANGUL SYLLABLE TIKEUT YAE SSANGSIOS
    case 0x88F0: code_point = 0xB34D; break; // HANGUL SYLLABLE TIKEUT YAE IEUNG
    case 0x88F1: code_point = 0xB34E; break; // HANGUL SYLLABLE TIKEUT YAE CIEUC
    case 0x88F2: code_point = 0xB34F; break; // HANGUL SYLLABLE TIKEUT YAE CHIEUCH
    case 0x88F3: code_point = 0xB350; break; // HANGUL SYLLABLE TIKEUT YAE KHIEUKH
    case 0x88F4: code_point = 0xB351; break; // HANGUL SYLLABLE TIKEUT YAE THIEUTH
    case 0x88F5: code_point = 0xB352; break; // HANGUL SYLLABLE TIKEUT YAE PHIEUPH
    case 0x88F6: code_point = 0xB353; break; // HANGUL SYLLABLE TIKEUT YAE HIEUH
    case 0x88F7: code_point = 0xB357; break; // HANGUL SYLLABLE TIKEUT EO KIYEOKSIOS
    case 0x88F8: code_point = 0xB359; break; // HANGUL SYLLABLE TIKEUT EO NIEUNCIEUC
    case 0x88F9: code_point = 0xB35A; break; // HANGUL SYLLABLE TIKEUT EO NIEUNHIEUH
    case 0x88FA: code_point = 0xB35D; break; // HANGUL SYLLABLE TIKEUT EO RIEULKIYEOK
    case 0x88FB: code_point = 0xB360; break; // HANGUL SYLLABLE TIKEUT EO RIEULSIOS
    case 0x88FC: code_point = 0xB361; break; // HANGUL SYLLABLE TIKEUT EO RIEULTHIEUTH
    case 0x88FD: code_point = 0xB362; break; // HANGUL SYLLABLE TIKEUT EO RIEULPHIEUPH
    case 0x88FE: code_point = 0xB363; break; // HANGUL SYLLABLE TIKEUT EO RIEULHIEUH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x89(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8941: code_point = 0xB366; break; // HANGUL SYLLABLE TIKEUT EO PIEUPSIOS
    case 0x8942: code_point = 0xB368; break; // HANGUL SYLLABLE TIKEUT EO SSANGSIOS
    case 0x8943: code_point = 0xB36A; break; // HANGUL SYLLABLE TIKEUT EO CIEUC
    case 0x8944: code_point = 0xB36C; break; // HANGUL SYLLABLE TIKEUT EO KHIEUKH
    case 0x8945: code_point = 0xB36D; break; // HANGUL SYLLABLE TIKEUT EO THIEUTH
    case 0x8946: code_point = 0xB36F; break; // HANGUL SYLLABLE TIKEUT EO HIEUH
    case 0x8947: code_point = 0xB372; break; // HANGUL SYLLABLE TIKEUT E SSANGKIYEOK
    case 0x8948: code_point = 0xB373; break; // HANGUL SYLLABLE TIKEUT E KIYEOKSIOS
    case 0x8949: code_point = 0xB375; break; // HANGUL SYLLABLE TIKEUT E NIEUNCIEUC
    case 0x894A: code_point = 0xB376; break; // HANGUL SYLLABLE TIKEUT E NIEUNHIEUH
    case 0x894B: code_point = 0xB377; break; // HANGUL SYLLABLE TIKEUT E TIKEUT
    case 0x894C: code_point = 0xB379; break; // HANGUL SYLLABLE TIKEUT E RIEULKIYEOK
    case 0x894D: code_point = 0xB37A; break; // HANGUL SYLLABLE TIKEUT E RIEULMIEUM
    case 0x894E: code_point = 0xB37B; break; // HANGUL SYLLABLE TIKEUT E RIEULPIEUP
    case 0x894F: code_point = 0xB37C; break; // HANGUL SYLLABLE TIKEUT E RIEULSIOS
    case 0x8950: code_point = 0xB37D; break; // HANGUL SYLLABLE TIKEUT E RIEULTHIEUTH
    case 0x8951: code_point = 0xB37E; break; // HANGUL SYLLABLE TIKEUT E RIEULPHIEUPH
    case 0x8952: code_point = 0xB37F; break; // HANGUL SYLLABLE TIKEUT E RIEULHIEUH
    case 0x8953: code_point = 0xB382; break; // HANGUL SYLLABLE TIKEUT E PIEUPSIOS
    case 0x8954: code_point = 0xB386; break; // HANGUL SYLLABLE TIKEUT E CIEUC
    case 0x8955: code_point = 0xB387; break; // HANGUL SYLLABLE TIKEUT E CHIEUCH
    case 0x8956: code_point = 0xB388; break; // HANGUL SYLLABLE TIKEUT E KHIEUKH
    case 0x8957: code_point = 0xB389; break; // HANGUL SYLLABLE TIKEUT E THIEUTH
    case 0x8958: code_point = 0xB38A; break; // HANGUL SYLLABLE TIKEUT E PHIEUPH
    case 0x8959: code_point = 0xB38B; break; // HANGUL SYLLABLE TIKEUT E HIEUH
    case 0x895A: code_point = 0xB38D; break; // HANGUL SYLLABLE TIKEUT YEO KIYEOK
    case 0x8961: code_point = 0xB38E; break; // HANGUL SYLLABLE TIKEUT YEO SSANGKIYEOK
    case 0x8962: code_point = 0xB38F; break; // HANGUL SYLLABLE TIKEUT YEO KIYEOKSIOS
    case 0x8963: code_point = 0xB391; break; // HANGUL SYLLABLE TIKEUT YEO NIEUNCIEUC
    case 0x8964: code_point = 0xB392; break; // HANGUL SYLLABLE TIKEUT YEO NIEUNHIEUH
    case 0x8965: code_point = 0xB393; break; // HANGUL SYLLABLE TIKEUT YEO TIKEUT
    case 0x8966: code_point = 0xB395; break; // HANGUL SYLLABLE TIKEUT YEO RIEULKIYEOK
    case 0x8967: code_point = 0xB396; break; // HANGUL SYLLABLE TIKEUT YEO RIEULMIEUM
    case 0x8968: code_point = 0xB397; break; // HANGUL SYLLABLE TIKEUT YEO RIEULPIEUP
    case 0x8969: code_point = 0xB398; break; // HANGUL SYLLABLE TIKEUT YEO RIEULSIOS
    case 0x896A: code_point = 0xB399; break; // HANGUL SYLLABLE TIKEUT YEO RIEULTHIEUTH
    case 0x896B: code_point = 0xB39A; break; // HANGUL SYLLABLE TIKEUT YEO RIEULPHIEUPH
    case 0x896C: code_point = 0xB39B; break; // HANGUL SYLLABLE TIKEUT YEO RIEULHIEUH
    case 0x896D: code_point = 0xB39C; break; // HANGUL SYLLABLE TIKEUT YEO MIEUM
    case 0x896E: code_point = 0xB39D; break; // HANGUL SYLLABLE TIKEUT YEO PIEUP
    case 0x896F: code_point = 0xB39E; break; // HANGUL SYLLABLE TIKEUT YEO PIEUPSIOS
    case 0x8970: code_point = 0xB39F; break; // HANGUL SYLLABLE TIKEUT YEO SIOS
    case 0x8971: code_point = 0xB3A2; break; // HANGUL SYLLABLE TIKEUT YEO CIEUC
    case 0x8972: code_point = 0xB3A3; break; // HANGUL SYLLABLE TIKEUT YEO CHIEUCH
    case 0x8973: code_point = 0xB3A4; break; // HANGUL SYLLABLE TIKEUT YEO KHIEUKH
    case 0x8974: code_point = 0xB3A5; break; // HANGUL SYLLABLE TIKEUT YEO THIEUTH
    case 0x8975: code_point = 0xB3A6; break; // HANGUL SYLLABLE TIKEUT YEO PHIEUPH
    case 0x8976: code_point = 0xB3A7; break; // HANGUL SYLLABLE TIKEUT YEO HIEUH
    case 0x8977: code_point = 0xB3A9; break; // HANGUL SYLLABLE TIKEUT YE KIYEOK
    case 0x8978: code_point = 0xB3AA; break; // HANGUL SYLLABLE TIKEUT YE SSANGKIYEOK
    case 0x8979: code_point = 0xB3AB; break; // HANGUL SYLLABLE TIKEUT YE KIYEOKSIOS
    case 0x897A: code_point = 0xB3AD; break; // HANGUL SYLLABLE TIKEUT YE NIEUNCIEUC
    case 0x8981: code_point = 0xB3AE; break; // HANGUL SYLLABLE TIKEUT YE NIEUNHIEUH
    case 0x8982: code_point = 0xB3AF; break; // HANGUL SYLLABLE TIKEUT YE TIKEUT
    case 0x8983: code_point = 0xB3B0; break; // HANGUL SYLLABLE TIKEUT YE RIEUL
    case 0x8984: code_point = 0xB3B1; break; // HANGUL SYLLABLE TIKEUT YE RIEULKIYEOK
    case 0x8985: code_point = 0xB3B2; break; // HANGUL SYLLABLE TIKEUT YE RIEULMIEUM
    case 0x8986: code_point = 0xB3B3; break; // HANGUL SYLLABLE TIKEUT YE RIEULPIEUP
    case 0x8987: code_point = 0xB3B4; break; // HANGUL SYLLABLE TIKEUT YE RIEULSIOS
    case 0x8988: code_point = 0xB3B5; break; // HANGUL SYLLABLE TIKEUT YE RIEULTHIEUTH
    case 0x8989: code_point = 0xB3B6; break; // HANGUL SYLLABLE TIKEUT YE RIEULPHIEUPH
    case 0x898A: code_point = 0xB3B7; break; // HANGUL SYLLABLE TIKEUT YE RIEULHIEUH
    case 0x898B: code_point = 0xB3B8; break; // HANGUL SYLLABLE TIKEUT YE MIEUM
    case 0x898C: code_point = 0xB3B9; break; // HANGUL SYLLABLE TIKEUT YE PIEUP
    case 0x898D: code_point = 0xB3BA; break; // HANGUL SYLLABLE TIKEUT YE PIEUPSIOS
    case 0x898E: code_point = 0xB3BB; break; // HANGUL SYLLABLE TIKEUT YE SIOS
    case 0x898F: code_point = 0xB3BC; break; // HANGUL SYLLABLE TIKEUT YE SSANGSIOS
    case 0x8990: code_point = 0xB3BD; break; // HANGUL SYLLABLE TIKEUT YE IEUNG
    case 0x8991: code_point = 0xB3BE; break; // HANGUL SYLLABLE TIKEUT YE CIEUC
    case 0x8992: code_point = 0xB3BF; break; // HANGUL SYLLABLE TIKEUT YE CHIEUCH
    case 0x8993: code_point = 0xB3C0; break; // HANGUL SYLLABLE TIKEUT YE KHIEUKH
    case 0x8994: code_point = 0xB3C1; break; // HANGUL SYLLABLE TIKEUT YE THIEUTH
    case 0x8995: code_point = 0xB3C2; break; // HANGUL SYLLABLE TIKEUT YE PHIEUPH
    case 0x8996: code_point = 0xB3C3; break; // HANGUL SYLLABLE TIKEUT YE HIEUH
    case 0x8997: code_point = 0xB3C6; break; // HANGUL SYLLABLE TIKEUT O SSANGKIYEOK
    case 0x8998: code_point = 0xB3C7; break; // HANGUL SYLLABLE TIKEUT O KIYEOKSIOS
    case 0x8999: code_point = 0xB3C9; break; // HANGUL SYLLABLE TIKEUT O NIEUNCIEUC
    case 0x899A: code_point = 0xB3CA; break; // HANGUL SYLLABLE TIKEUT O NIEUNHIEUH
    case 0x899B: code_point = 0xB3CD; break; // HANGUL SYLLABLE TIKEUT O RIEULKIYEOK
    case 0x899C: code_point = 0xB3CF; break; // HANGUL SYLLABLE TIKEUT O RIEULPIEUP
    case 0x899D: code_point = 0xB3D1; break; // HANGUL SYLLABLE TIKEUT O RIEULTHIEUTH
    case 0x899E: code_point = 0xB3D2; break; // HANGUL SYLLABLE TIKEUT O RIEULPHIEUPH
    case 0x899F: code_point = 0xB3D3; break; // HANGUL SYLLABLE TIKEUT O RIEULHIEUH
    case 0x89A0: code_point = 0xB3D6; break; // HANGUL SYLLABLE TIKEUT O PIEUPSIOS
    case 0x89A1: code_point = 0xB3D8; break; // HANGUL SYLLABLE TIKEUT O SSANGSIOS
    case 0x89A2: code_point = 0xB3DA; break; // HANGUL SYLLABLE TIKEUT O CIEUC
    case 0x89A3: code_point = 0xB3DC; break; // HANGUL SYLLABLE TIKEUT O KHIEUKH
    case 0x89A4: code_point = 0xB3DE; break; // HANGUL SYLLABLE TIKEUT O PHIEUPH
    case 0x89A5: code_point = 0xB3DF; break; // HANGUL SYLLABLE TIKEUT O HIEUH
    case 0x89A6: code_point = 0xB3E1; break; // HANGUL SYLLABLE TIKEUT WA KIYEOK
    case 0x89A7: code_point = 0xB3E2; break; // HANGUL SYLLABLE TIKEUT WA SSANGKIYEOK
    case 0x89A8: code_point = 0xB3E3; break; // HANGUL SYLLABLE TIKEUT WA KIYEOKSIOS
    case 0x89A9: code_point = 0xB3E5; break; // HANGUL SYLLABLE TIKEUT WA NIEUNCIEUC
    case 0x89AA: code_point = 0xB3E6; break; // HANGUL SYLLABLE TIKEUT WA NIEUNHIEUH
    case 0x89AB: code_point = 0xB3E7; break; // HANGUL SYLLABLE TIKEUT WA TIKEUT
    case 0x89AC: code_point = 0xB3E9; break; // HANGUL SYLLABLE TIKEUT WA RIEULKIYEOK
    case 0x89AD: code_point = 0xB3EA; break; // HANGUL SYLLABLE TIKEUT WA RIEULMIEUM
    case 0x89AE: code_point = 0xB3EB; break; // HANGUL SYLLABLE TIKEUT WA RIEULPIEUP
    case 0x89AF: code_point = 0xB3EC; break; // HANGUL SYLLABLE TIKEUT WA RIEULSIOS
    case 0x89B0: code_point = 0xB3ED; break; // HANGUL SYLLABLE TIKEUT WA RIEULTHIEUTH
    case 0x89B1: code_point = 0xB3EE; break; // HANGUL SYLLABLE TIKEUT WA RIEULPHIEUPH
    case 0x89B2: code_point = 0xB3EF; break; // HANGUL SYLLABLE TIKEUT WA RIEULHIEUH
    case 0x89B3: code_point = 0xB3F0; break; // HANGUL SYLLABLE TIKEUT WA MIEUM
    case 0x89B4: code_point = 0xB3F1; break; // HANGUL SYLLABLE TIKEUT WA PIEUP
    case 0x89B5: code_point = 0xB3F2; break; // HANGUL SYLLABLE TIKEUT WA PIEUPSIOS
    case 0x89B6: code_point = 0xB3F3; break; // HANGUL SYLLABLE TIKEUT WA SIOS
    case 0x89B7: code_point = 0xB3F4; break; // HANGUL SYLLABLE TIKEUT WA SSANGSIOS
    case 0x89B8: code_point = 0xB3F5; break; // HANGUL SYLLABLE TIKEUT WA IEUNG
    case 0x89B9: code_point = 0xB3F6; break; // HANGUL SYLLABLE TIKEUT WA CIEUC
    case 0x89BA: code_point = 0xB3F7; break; // HANGUL SYLLABLE TIKEUT WA CHIEUCH
    case 0x89BB: code_point = 0xB3F8; break; // HANGUL SYLLABLE TIKEUT WA KHIEUKH
    case 0x89BC: code_point = 0xB3F9; break; // HANGUL SYLLABLE TIKEUT WA THIEUTH
    case 0x89BD: code_point = 0xB3FA; break; // HANGUL SYLLABLE TIKEUT WA PHIEUPH
    case 0x89BE: code_point = 0xB3FB; break; // HANGUL SYLLABLE TIKEUT WA HIEUH
    case 0x89BF: code_point = 0xB3FD; break; // HANGUL SYLLABLE TIKEUT WAE KIYEOK
    case 0x89C0: code_point = 0xB3FE; break; // HANGUL SYLLABLE TIKEUT WAE SSANGKIYEOK
    case 0x89C1: code_point = 0xB3FF; break; // HANGUL SYLLABLE TIKEUT WAE KIYEOKSIOS
    case 0x89C2: code_point = 0xB400; break; // HANGUL SYLLABLE TIKEUT WAE NIEUN
    case 0x89C3: code_point = 0xB401; break; // HANGUL SYLLABLE TIKEUT WAE NIEUNCIEUC
    case 0x89C4: code_point = 0xB402; break; // HANGUL SYLLABLE TIKEUT WAE NIEUNHIEUH
    case 0x89C5: code_point = 0xB403; break; // HANGUL SYLLABLE TIKEUT WAE TIKEUT
    case 0x89C6: code_point = 0xB404; break; // HANGUL SYLLABLE TIKEUT WAE RIEUL
    case 0x89C7: code_point = 0xB405; break; // HANGUL SYLLABLE TIKEUT WAE RIEULKIYEOK
    case 0x89C8: code_point = 0xB406; break; // HANGUL SYLLABLE TIKEUT WAE RIEULMIEUM
    case 0x89C9: code_point = 0xB407; break; // HANGUL SYLLABLE TIKEUT WAE RIEULPIEUP
    case 0x89CA: code_point = 0xB408; break; // HANGUL SYLLABLE TIKEUT WAE RIEULSIOS
    case 0x89CB: code_point = 0xB409; break; // HANGUL SYLLABLE TIKEUT WAE RIEULTHIEUTH
    case 0x89CC: code_point = 0xB40A; break; // HANGUL SYLLABLE TIKEUT WAE RIEULPHIEUPH
    case 0x89CD: code_point = 0xB40B; break; // HANGUL SYLLABLE TIKEUT WAE RIEULHIEUH
    case 0x89CE: code_point = 0xB40C; break; // HANGUL SYLLABLE TIKEUT WAE MIEUM
    case 0x89CF: code_point = 0xB40D; break; // HANGUL SYLLABLE TIKEUT WAE PIEUP
    case 0x89D0: code_point = 0xB40E; break; // HANGUL SYLLABLE TIKEUT WAE PIEUPSIOS
    case 0x89D1: code_point = 0xB40F; break; // HANGUL SYLLABLE TIKEUT WAE SIOS
    case 0x89D2: code_point = 0xB411; break; // HANGUL SYLLABLE TIKEUT WAE IEUNG
    case 0x89D3: code_point = 0xB412; break; // HANGUL SYLLABLE TIKEUT WAE CIEUC
    case 0x89D4: code_point = 0xB413; break; // HANGUL SYLLABLE TIKEUT WAE CHIEUCH
    case 0x89D5: code_point = 0xB414; break; // HANGUL SYLLABLE TIKEUT WAE KHIEUKH
    case 0x89D6: code_point = 0xB415; break; // HANGUL SYLLABLE TIKEUT WAE THIEUTH
    case 0x89D7: code_point = 0xB416; break; // HANGUL SYLLABLE TIKEUT WAE PHIEUPH
    case 0x89D8: code_point = 0xB417; break; // HANGUL SYLLABLE TIKEUT WAE HIEUH
    case 0x89D9: code_point = 0xB419; break; // HANGUL SYLLABLE TIKEUT OE KIYEOK
    case 0x89DA: code_point = 0xB41A; break; // HANGUL SYLLABLE TIKEUT OE SSANGKIYEOK
    case 0x89DB: code_point = 0xB41B; break; // HANGUL SYLLABLE TIKEUT OE KIYEOKSIOS
    case 0x89DC: code_point = 0xB41D; break; // HANGUL SYLLABLE TIKEUT OE NIEUNCIEUC
    case 0x89DD: code_point = 0xB41E; break; // HANGUL SYLLABLE TIKEUT OE NIEUNHIEUH
    case 0x89DE: code_point = 0xB41F; break; // HANGUL SYLLABLE TIKEUT OE TIKEUT
    case 0x89DF: code_point = 0xB421; break; // HANGUL SYLLABLE TIKEUT OE RIEULKIYEOK
    case 0x89E0: code_point = 0xB422; break; // HANGUL SYLLABLE TIKEUT OE RIEULMIEUM
    case 0x89E1: code_point = 0xB423; break; // HANGUL SYLLABLE TIKEUT OE RIEULPIEUP
    case 0x89E2: code_point = 0xB424; break; // HANGUL SYLLABLE TIKEUT OE RIEULSIOS
    case 0x89E3: code_point = 0xB425; break; // HANGUL SYLLABLE TIKEUT OE RIEULTHIEUTH
    case 0x89E4: code_point = 0xB426; break; // HANGUL SYLLABLE TIKEUT OE RIEULPHIEUPH
    case 0x89E5: code_point = 0xB427; break; // HANGUL SYLLABLE TIKEUT OE RIEULHIEUH
    case 0x89E6: code_point = 0xB42A; break; // HANGUL SYLLABLE TIKEUT OE PIEUPSIOS
    case 0x89E7: code_point = 0xB42C; break; // HANGUL SYLLABLE TIKEUT OE SSANGSIOS
    case 0x89E8: code_point = 0xB42D; break; // HANGUL SYLLABLE TIKEUT OE IEUNG
    case 0x89E9: code_point = 0xB42E; break; // HANGUL SYLLABLE TIKEUT OE CIEUC
    case 0x89EA: code_point = 0xB42F; break; // HANGUL SYLLABLE TIKEUT OE CHIEUCH
    case 0x89EB: code_point = 0xB430; break; // HANGUL SYLLABLE TIKEUT OE KHIEUKH
    case 0x89EC: code_point = 0xB431; break; // HANGUL SYLLABLE TIKEUT OE THIEUTH
    case 0x89ED: code_point = 0xB432; break; // HANGUL SYLLABLE TIKEUT OE PHIEUPH
    case 0x89EE: code_point = 0xB433; break; // HANGUL SYLLABLE TIKEUT OE HIEUH
    case 0x89EF: code_point = 0xB435; break; // HANGUL SYLLABLE TIKEUT YO KIYEOK
    case 0x89F0: code_point = 0xB436; break; // HANGUL SYLLABLE TIKEUT YO SSANGKIYEOK
    case 0x89F1: code_point = 0xB437; break; // HANGUL SYLLABLE TIKEUT YO KIYEOKSIOS
    case 0x89F2: code_point = 0xB438; break; // HANGUL SYLLABLE TIKEUT YO NIEUN
    case 0x89F3: code_point = 0xB439; break; // HANGUL SYLLABLE TIKEUT YO NIEUNCIEUC
    case 0x89F4: code_point = 0xB43A; break; // HANGUL SYLLABLE TIKEUT YO NIEUNHIEUH
    case 0x89F5: code_point = 0xB43B; break; // HANGUL SYLLABLE TIKEUT YO TIKEUT
    case 0x89F6: code_point = 0xB43C; break; // HANGUL SYLLABLE TIKEUT YO RIEUL
    case 0x89F7: code_point = 0xB43D; break; // HANGUL SYLLABLE TIKEUT YO RIEULKIYEOK
    case 0x89F8: code_point = 0xB43E; break; // HANGUL SYLLABLE TIKEUT YO RIEULMIEUM
    case 0x89F9: code_point = 0xB43F; break; // HANGUL SYLLABLE TIKEUT YO RIEULPIEUP
    case 0x89FA: code_point = 0xB440; break; // HANGUL SYLLABLE TIKEUT YO RIEULSIOS
    case 0x89FB: code_point = 0xB441; break; // HANGUL SYLLABLE TIKEUT YO RIEULTHIEUTH
    case 0x89FC: code_point = 0xB442; break; // HANGUL SYLLABLE TIKEUT YO RIEULPHIEUPH
    case 0x89FD: code_point = 0xB443; break; // HANGUL SYLLABLE TIKEUT YO RIEULHIEUH
    case 0x89FE: code_point = 0xB444; break; // HANGUL SYLLABLE TIKEUT YO MIEUM
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x8A(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8A41: code_point = 0xB445; break; // HANGUL SYLLABLE TIKEUT YO PIEUP
    case 0x8A42: code_point = 0xB446; break; // HANGUL SYLLABLE TIKEUT YO PIEUPSIOS
    case 0x8A43: code_point = 0xB447; break; // HANGUL SYLLABLE TIKEUT YO SIOS
    case 0x8A44: code_point = 0xB448; break; // HANGUL SYLLABLE TIKEUT YO SSANGSIOS
    case 0x8A45: code_point = 0xB449; break; // HANGUL SYLLABLE TIKEUT YO IEUNG
    case 0x8A46: code_point = 0xB44A; break; // HANGUL SYLLABLE TIKEUT YO CIEUC
    case 0x8A47: code_point = 0xB44B; break; // HANGUL SYLLABLE TIKEUT YO CHIEUCH
    case 0x8A48: code_point = 0xB44C; break; // HANGUL SYLLABLE TIKEUT YO KHIEUKH
    case 0x8A49: code_point = 0xB44D; break; // HANGUL SYLLABLE TIKEUT YO THIEUTH
    case 0x8A4A: code_point = 0xB44E; break; // HANGUL SYLLABLE TIKEUT YO PHIEUPH
    case 0x8A4B: code_point = 0xB44F; break; // HANGUL SYLLABLE TIKEUT YO HIEUH
    case 0x8A4C: code_point = 0xB452; break; // HANGUL SYLLABLE TIKEUT U SSANGKIYEOK
    case 0x8A4D: code_point = 0xB453; break; // HANGUL SYLLABLE TIKEUT U KIYEOKSIOS
    case 0x8A4E: code_point = 0xB455; break; // HANGUL SYLLABLE TIKEUT U NIEUNCIEUC
    case 0x8A4F: code_point = 0xB456; break; // HANGUL SYLLABLE TIKEUT U NIEUNHIEUH
    case 0x8A50: code_point = 0xB457; break; // HANGUL SYLLABLE TIKEUT U TIKEUT
    case 0x8A51: code_point = 0xB459; break; // HANGUL SYLLABLE TIKEUT U RIEULKIYEOK
    case 0x8A52: code_point = 0xB45A; break; // HANGUL SYLLABLE TIKEUT U RIEULMIEUM
    case 0x8A53: code_point = 0xB45B; break; // HANGUL SYLLABLE TIKEUT U RIEULPIEUP
    case 0x8A54: code_point = 0xB45C; break; // HANGUL SYLLABLE TIKEUT U RIEULSIOS
    case 0x8A55: code_point = 0xB45D; break; // HANGUL SYLLABLE TIKEUT U RIEULTHIEUTH
    case 0x8A56: code_point = 0xB45E; break; // HANGUL SYLLABLE TIKEUT U RIEULPHIEUPH
    case 0x8A57: code_point = 0xB45F; break; // HANGUL SYLLABLE TIKEUT U RIEULHIEUH
    case 0x8A58: code_point = 0xB462; break; // HANGUL SYLLABLE TIKEUT U PIEUPSIOS
    case 0x8A59: code_point = 0xB464; break; // HANGUL SYLLABLE TIKEUT U SSANGSIOS
    case 0x8A5A: code_point = 0xB466; break; // HANGUL SYLLABLE TIKEUT U CIEUC
    case 0x8A61: code_point = 0xB467; break; // HANGUL SYLLABLE TIKEUT U CHIEUCH
    case 0x8A62: code_point = 0xB468; break; // HANGUL SYLLABLE TIKEUT U KHIEUKH
    case 0x8A63: code_point = 0xB469; break; // HANGUL SYLLABLE TIKEUT U THIEUTH
    case 0x8A64: code_point = 0xB46A; break; // HANGUL SYLLABLE TIKEUT U PHIEUPH
    case 0x8A65: code_point = 0xB46B; break; // HANGUL SYLLABLE TIKEUT U HIEUH
    case 0x8A66: code_point = 0xB46D; break; // HANGUL SYLLABLE TIKEUT WEO KIYEOK
    case 0x8A67: code_point = 0xB46E; break; // HANGUL SYLLABLE TIKEUT WEO SSANGKIYEOK
    case 0x8A68: code_point = 0xB46F; break; // HANGUL SYLLABLE TIKEUT WEO KIYEOKSIOS
    case 0x8A69: code_point = 0xB470; break; // HANGUL SYLLABLE TIKEUT WEO NIEUN
    case 0x8A6A: code_point = 0xB471; break; // HANGUL SYLLABLE TIKEUT WEO NIEUNCIEUC
    case 0x8A6B: code_point = 0xB472; break; // HANGUL SYLLABLE TIKEUT WEO NIEUNHIEUH
    case 0x8A6C: code_point = 0xB473; break; // HANGUL SYLLABLE TIKEUT WEO TIKEUT
    case 0x8A6D: code_point = 0xB474; break; // HANGUL SYLLABLE TIKEUT WEO RIEUL
    case 0x8A6E: code_point = 0xB475; break; // HANGUL SYLLABLE TIKEUT WEO RIEULKIYEOK
    case 0x8A6F: code_point = 0xB476; break; // HANGUL SYLLABLE TIKEUT WEO RIEULMIEUM
    case 0x8A70: code_point = 0xB477; break; // HANGUL SYLLABLE TIKEUT WEO RIEULPIEUP
    case 0x8A71: code_point = 0xB478; break; // HANGUL SYLLABLE TIKEUT WEO RIEULSIOS
    case 0x8A72: code_point = 0xB479; break; // HANGUL SYLLABLE TIKEUT WEO RIEULTHIEUTH
    case 0x8A73: code_point = 0xB47A; break; // HANGUL SYLLABLE TIKEUT WEO RIEULPHIEUPH
    case 0x8A74: code_point = 0xB47B; break; // HANGUL SYLLABLE TIKEUT WEO RIEULHIEUH
    case 0x8A75: code_point = 0xB47C; break; // HANGUL SYLLABLE TIKEUT WEO MIEUM
    case 0x8A76: code_point = 0xB47D; break; // HANGUL SYLLABLE TIKEUT WEO PIEUP
    case 0x8A77: code_point = 0xB47E; break; // HANGUL SYLLABLE TIKEUT WEO PIEUPSIOS
    case 0x8A78: code_point = 0xB47F; break; // HANGUL SYLLABLE TIKEUT WEO SIOS
    case 0x8A79: code_point = 0xB481; break; // HANGUL SYLLABLE TIKEUT WEO IEUNG
    case 0x8A7A: code_point = 0xB482; break; // HANGUL SYLLABLE TIKEUT WEO CIEUC
    case 0x8A81: code_point = 0xB483; break; // HANGUL SYLLABLE TIKEUT WEO CHIEUCH
    case 0x8A82: code_point = 0xB484; break; // HANGUL SYLLABLE TIKEUT WEO KHIEUKH
    case 0x8A83: code_point = 0xB485; break; // HANGUL SYLLABLE TIKEUT WEO THIEUTH
    case 0x8A84: code_point = 0xB486; break; // HANGUL SYLLABLE TIKEUT WEO PHIEUPH
    case 0x8A85: code_point = 0xB487; break; // HANGUL SYLLABLE TIKEUT WEO HIEUH
    case 0x8A86: code_point = 0xB489; break; // HANGUL SYLLABLE TIKEUT WE KIYEOK
    case 0x8A87: code_point = 0xB48A; break; // HANGUL SYLLABLE TIKEUT WE SSANGKIYEOK
    case 0x8A88: code_point = 0xB48B; break; // HANGUL SYLLABLE TIKEUT WE KIYEOKSIOS
    case 0x8A89: code_point = 0xB48C; break; // HANGUL SYLLABLE TIKEUT WE NIEUN
    case 0x8A8A: code_point = 0xB48D; break; // HANGUL SYLLABLE TIKEUT WE NIEUNCIEUC
    case 0x8A8B: code_point = 0xB48E; break; // HANGUL SYLLABLE TIKEUT WE NIEUNHIEUH
    case 0x8A8C: code_point = 0xB48F; break; // HANGUL SYLLABLE TIKEUT WE TIKEUT
    case 0x8A8D: code_point = 0xB490; break; // HANGUL SYLLABLE TIKEUT WE RIEUL
    case 0x8A8E: code_point = 0xB491; break; // HANGUL SYLLABLE TIKEUT WE RIEULKIYEOK
    case 0x8A8F: code_point = 0xB492; break; // HANGUL SYLLABLE TIKEUT WE RIEULMIEUM
    case 0x8A90: code_point = 0xB493; break; // HANGUL SYLLABLE TIKEUT WE RIEULPIEUP
    case 0x8A91: code_point = 0xB494; break; // HANGUL SYLLABLE TIKEUT WE RIEULSIOS
    case 0x8A92: code_point = 0xB495; break; // HANGUL SYLLABLE TIKEUT WE RIEULTHIEUTH
    case 0x8A93: code_point = 0xB496; break; // HANGUL SYLLABLE TIKEUT WE RIEULPHIEUPH
    case 0x8A94: code_point = 0xB497; break; // HANGUL SYLLABLE TIKEUT WE RIEULHIEUH
    case 0x8A95: code_point = 0xB498; break; // HANGUL SYLLABLE TIKEUT WE MIEUM
    case 0x8A96: code_point = 0xB499; break; // HANGUL SYLLABLE TIKEUT WE PIEUP
    case 0x8A97: code_point = 0xB49A; break; // HANGUL SYLLABLE TIKEUT WE PIEUPSIOS
    case 0x8A98: code_point = 0xB49B; break; // HANGUL SYLLABLE TIKEUT WE SIOS
    case 0x8A99: code_point = 0xB49C; break; // HANGUL SYLLABLE TIKEUT WE SSANGSIOS
    case 0x8A9A: code_point = 0xB49E; break; // HANGUL SYLLABLE TIKEUT WE CIEUC
    case 0x8A9B: code_point = 0xB49F; break; // HANGUL SYLLABLE TIKEUT WE CHIEUCH
    case 0x8A9C: code_point = 0xB4A0; break; // HANGUL SYLLABLE TIKEUT WE KHIEUKH
    case 0x8A9D: code_point = 0xB4A1; break; // HANGUL SYLLABLE TIKEUT WE THIEUTH
    case 0x8A9E: code_point = 0xB4A2; break; // HANGUL SYLLABLE TIKEUT WE PHIEUPH
    case 0x8A9F: code_point = 0xB4A3; break; // HANGUL SYLLABLE TIKEUT WE HIEUH
    case 0x8AA0: code_point = 0xB4A5; break; // HANGUL SYLLABLE TIKEUT WI KIYEOK
    case 0x8AA1: code_point = 0xB4A6; break; // HANGUL SYLLABLE TIKEUT WI SSANGKIYEOK
    case 0x8AA2: code_point = 0xB4A7; break; // HANGUL SYLLABLE TIKEUT WI KIYEOKSIOS
    case 0x8AA3: code_point = 0xB4A9; break; // HANGUL SYLLABLE TIKEUT WI NIEUNCIEUC
    case 0x8AA4: code_point = 0xB4AA; break; // HANGUL SYLLABLE TIKEUT WI NIEUNHIEUH
    case 0x8AA5: code_point = 0xB4AB; break; // HANGUL SYLLABLE TIKEUT WI TIKEUT
    case 0x8AA6: code_point = 0xB4AD; break; // HANGUL SYLLABLE TIKEUT WI RIEULKIYEOK
    case 0x8AA7: code_point = 0xB4AE; break; // HANGUL SYLLABLE TIKEUT WI RIEULMIEUM
    case 0x8AA8: code_point = 0xB4AF; break; // HANGUL SYLLABLE TIKEUT WI RIEULPIEUP
    case 0x8AA9: code_point = 0xB4B0; break; // HANGUL SYLLABLE TIKEUT WI RIEULSIOS
    case 0x8AAA: code_point = 0xB4B1; break; // HANGUL SYLLABLE TIKEUT WI RIEULTHIEUTH
    case 0x8AAB: code_point = 0xB4B2; break; // HANGUL SYLLABLE TIKEUT WI RIEULPHIEUPH
    case 0x8AAC: code_point = 0xB4B3; break; // HANGUL SYLLABLE TIKEUT WI RIEULHIEUH
    case 0x8AAD: code_point = 0xB4B4; break; // HANGUL SYLLABLE TIKEUT WI MIEUM
    case 0x8AAE: code_point = 0xB4B6; break; // HANGUL SYLLABLE TIKEUT WI PIEUPSIOS
    case 0x8AAF: code_point = 0xB4B8; break; // HANGUL SYLLABLE TIKEUT WI SSANGSIOS
    case 0x8AB0: code_point = 0xB4BA; break; // HANGUL SYLLABLE TIKEUT WI CIEUC
    case 0x8AB1: code_point = 0xB4BB; break; // HANGUL SYLLABLE TIKEUT WI CHIEUCH
    case 0x8AB2: code_point = 0xB4BC; break; // HANGUL SYLLABLE TIKEUT WI KHIEUKH
    case 0x8AB3: code_point = 0xB4BD; break; // HANGUL SYLLABLE TIKEUT WI THIEUTH
    case 0x8AB4: code_point = 0xB4BE; break; // HANGUL SYLLABLE TIKEUT WI PHIEUPH
    case 0x8AB5: code_point = 0xB4BF; break; // HANGUL SYLLABLE TIKEUT WI HIEUH
    case 0x8AB6: code_point = 0xB4C1; break; // HANGUL SYLLABLE TIKEUT YU KIYEOK
    case 0x8AB7: code_point = 0xB4C2; break; // HANGUL SYLLABLE TIKEUT YU SSANGKIYEOK
    case 0x8AB8: code_point = 0xB4C3; break; // HANGUL SYLLABLE TIKEUT YU KIYEOKSIOS
    case 0x8AB9: code_point = 0xB4C5; break; // HANGUL SYLLABLE TIKEUT YU NIEUNCIEUC
    case 0x8ABA: code_point = 0xB4C6; break; // HANGUL SYLLABLE TIKEUT YU NIEUNHIEUH
    case 0x8ABB: code_point = 0xB4C7; break; // HANGUL SYLLABLE TIKEUT YU TIKEUT
    case 0x8ABC: code_point = 0xB4C9; break; // HANGUL SYLLABLE TIKEUT YU RIEULKIYEOK
    case 0x8ABD: code_point = 0xB4CA; break; // HANGUL SYLLABLE TIKEUT YU RIEULMIEUM
    case 0x8ABE: code_point = 0xB4CB; break; // HANGUL SYLLABLE TIKEUT YU RIEULPIEUP
    case 0x8ABF: code_point = 0xB4CC; break; // HANGUL SYLLABLE TIKEUT YU RIEULSIOS
    case 0x8AC0: code_point = 0xB4CD; break; // HANGUL SYLLABLE TIKEUT YU RIEULTHIEUTH
    case 0x8AC1: code_point = 0xB4CE; break; // HANGUL SYLLABLE TIKEUT YU RIEULPHIEUPH
    case 0x8AC2: code_point = 0xB4CF; break; // HANGUL SYLLABLE TIKEUT YU RIEULHIEUH
    case 0x8AC3: code_point = 0xB4D1; break; // HANGUL SYLLABLE TIKEUT YU PIEUP
    case 0x8AC4: code_point = 0xB4D2; break; // HANGUL SYLLABLE TIKEUT YU PIEUPSIOS
    case 0x8AC5: code_point = 0xB4D3; break; // HANGUL SYLLABLE TIKEUT YU SIOS
    case 0x8AC6: code_point = 0xB4D4; break; // HANGUL SYLLABLE TIKEUT YU SSANGSIOS
    case 0x8AC7: code_point = 0xB4D6; break; // HANGUL SYLLABLE TIKEUT YU CIEUC
    case 0x8AC8: code_point = 0xB4D7; break; // HANGUL SYLLABLE TIKEUT YU CHIEUCH
    case 0x8AC9: code_point = 0xB4D8; break; // HANGUL SYLLABLE TIKEUT YU KHIEUKH
    case 0x8ACA: code_point = 0xB4D9; break; // HANGUL SYLLABLE TIKEUT YU THIEUTH
    case 0x8ACB: code_point = 0xB4DA; break; // HANGUL SYLLABLE TIKEUT YU PHIEUPH
    case 0x8ACC: code_point = 0xB4DB; break; // HANGUL SYLLABLE TIKEUT YU HIEUH
    case 0x8ACD: code_point = 0xB4DE; break; // HANGUL SYLLABLE TIKEUT EU SSANGKIYEOK
    case 0x8ACE: code_point = 0xB4DF; break; // HANGUL SYLLABLE TIKEUT EU KIYEOKSIOS
    case 0x8ACF: code_point = 0xB4E1; break; // HANGUL SYLLABLE TIKEUT EU NIEUNCIEUC
    case 0x8AD0: code_point = 0xB4E2; break; // HANGUL SYLLABLE TIKEUT EU NIEUNHIEUH
    case 0x8AD1: code_point = 0xB4E5; break; // HANGUL SYLLABLE TIKEUT EU RIEULKIYEOK
    case 0x8AD2: code_point = 0xB4E7; break; // HANGUL SYLLABLE TIKEUT EU RIEULPIEUP
    case 0x8AD3: code_point = 0xB4E8; break; // HANGUL SYLLABLE TIKEUT EU RIEULSIOS
    case 0x8AD4: code_point = 0xB4E9; break; // HANGUL SYLLABLE TIKEUT EU RIEULTHIEUTH
    case 0x8AD5: code_point = 0xB4EA; break; // HANGUL SYLLABLE TIKEUT EU RIEULPHIEUPH
    case 0x8AD6: code_point = 0xB4EB; break; // HANGUL SYLLABLE TIKEUT EU RIEULHIEUH
    case 0x8AD7: code_point = 0xB4EE; break; // HANGUL SYLLABLE TIKEUT EU PIEUPSIOS
    case 0x8AD8: code_point = 0xB4F0; break; // HANGUL SYLLABLE TIKEUT EU SSANGSIOS
    case 0x8AD9: code_point = 0xB4F2; break; // HANGUL SYLLABLE TIKEUT EU CIEUC
    case 0x8ADA: code_point = 0xB4F3; break; // HANGUL SYLLABLE TIKEUT EU CHIEUCH
    case 0x8ADB: code_point = 0xB4F4; break; // HANGUL SYLLABLE TIKEUT EU KHIEUKH
    case 0x8ADC: code_point = 0xB4F5; break; // HANGUL SYLLABLE TIKEUT EU THIEUTH
    case 0x8ADD: code_point = 0xB4F6; break; // HANGUL SYLLABLE TIKEUT EU PHIEUPH
    case 0x8ADE: code_point = 0xB4F7; break; // HANGUL SYLLABLE TIKEUT EU HIEUH
    case 0x8ADF: code_point = 0xB4F9; break; // HANGUL SYLLABLE TIKEUT YI KIYEOK
    case 0x8AE0: code_point = 0xB4FA; break; // HANGUL SYLLABLE TIKEUT YI SSANGKIYEOK
    case 0x8AE1: code_point = 0xB4FB; break; // HANGUL SYLLABLE TIKEUT YI KIYEOKSIOS
    case 0x8AE2: code_point = 0xB4FC; break; // HANGUL SYLLABLE TIKEUT YI NIEUN
    case 0x8AE3: code_point = 0xB4FD; break; // HANGUL SYLLABLE TIKEUT YI NIEUNCIEUC
    case 0x8AE4: code_point = 0xB4FE; break; // HANGUL SYLLABLE TIKEUT YI NIEUNHIEUH
    case 0x8AE5: code_point = 0xB4FF; break; // HANGUL SYLLABLE TIKEUT YI TIKEUT
    case 0x8AE6: code_point = 0xB500; break; // HANGUL SYLLABLE TIKEUT YI RIEUL
    case 0x8AE7: code_point = 0xB501; break; // HANGUL SYLLABLE TIKEUT YI RIEULKIYEOK
    case 0x8AE8: code_point = 0xB502; break; // HANGUL SYLLABLE TIKEUT YI RIEULMIEUM
    case 0x8AE9: code_point = 0xB503; break; // HANGUL SYLLABLE TIKEUT YI RIEULPIEUP
    case 0x8AEA: code_point = 0xB504; break; // HANGUL SYLLABLE TIKEUT YI RIEULSIOS
    case 0x8AEB: code_point = 0xB505; break; // HANGUL SYLLABLE TIKEUT YI RIEULTHIEUTH
    case 0x8AEC: code_point = 0xB506; break; // HANGUL SYLLABLE TIKEUT YI RIEULPHIEUPH
    case 0x8AED: code_point = 0xB507; break; // HANGUL SYLLABLE TIKEUT YI RIEULHIEUH
    case 0x8AEE: code_point = 0xB508; break; // HANGUL SYLLABLE TIKEUT YI MIEUM
    case 0x8AEF: code_point = 0xB509; break; // HANGUL SYLLABLE TIKEUT YI PIEUP
    case 0x8AF0: code_point = 0xB50A; break; // HANGUL SYLLABLE TIKEUT YI PIEUPSIOS
    case 0x8AF1: code_point = 0xB50B; break; // HANGUL SYLLABLE TIKEUT YI SIOS
    case 0x8AF2: code_point = 0xB50C; break; // HANGUL SYLLABLE TIKEUT YI SSANGSIOS
    case 0x8AF3: code_point = 0xB50D; break; // HANGUL SYLLABLE TIKEUT YI IEUNG
    case 0x8AF4: code_point = 0xB50E; break; // HANGUL SYLLABLE TIKEUT YI CIEUC
    case 0x8AF5: code_point = 0xB50F; break; // HANGUL SYLLABLE TIKEUT YI CHIEUCH
    case 0x8AF6: code_point = 0xB510; break; // HANGUL SYLLABLE TIKEUT YI KHIEUKH
    case 0x8AF7: code_point = 0xB511; break; // HANGUL SYLLABLE TIKEUT YI THIEUTH
    case 0x8AF8: code_point = 0xB512; break; // HANGUL SYLLABLE TIKEUT YI PHIEUPH
    case 0x8AF9: code_point = 0xB513; break; // HANGUL SYLLABLE TIKEUT YI HIEUH
    case 0x8AFA: code_point = 0xB516; break; // HANGUL SYLLABLE TIKEUT I SSANGKIYEOK
    case 0x8AFB: code_point = 0xB517; break; // HANGUL SYLLABLE TIKEUT I KIYEOKSIOS
    case 0x8AFC: code_point = 0xB519; break; // HANGUL SYLLABLE TIKEUT I NIEUNCIEUC
    case 0x8AFD: code_point = 0xB51A; break; // HANGUL SYLLABLE TIKEUT I NIEUNHIEUH
    case 0x8AFE: code_point = 0xB51D; break; // HANGUL SYLLABLE TIKEUT I RIEULKIYEOK
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x8B(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8B41: code_point = 0xB51E; break; // HANGUL SYLLABLE TIKEUT I RIEULMIEUM
    case 0x8B42: code_point = 0xB51F; break; // HANGUL SYLLABLE TIKEUT I RIEULPIEUP
    case 0x8B43: code_point = 0xB520; break; // HANGUL SYLLABLE TIKEUT I RIEULSIOS
    case 0x8B44: code_point = 0xB521; break; // HANGUL SYLLABLE TIKEUT I RIEULTHIEUTH
    case 0x8B45: code_point = 0xB522; break; // HANGUL SYLLABLE TIKEUT I RIEULPHIEUPH
    case 0x8B46: code_point = 0xB523; break; // HANGUL SYLLABLE TIKEUT I RIEULHIEUH
    case 0x8B47: code_point = 0xB526; break; // HANGUL SYLLABLE TIKEUT I PIEUPSIOS
    case 0x8B48: code_point = 0xB52B; break; // HANGUL SYLLABLE TIKEUT I CHIEUCH
    case 0x8B49: code_point = 0xB52C; break; // HANGUL SYLLABLE TIKEUT I KHIEUKH
    case 0x8B4A: code_point = 0xB52D; break; // HANGUL SYLLABLE TIKEUT I THIEUTH
    case 0x8B4B: code_point = 0xB52E; break; // HANGUL SYLLABLE TIKEUT I PHIEUPH
    case 0x8B4C: code_point = 0xB52F; break; // HANGUL SYLLABLE TIKEUT I HIEUH
    case 0x8B4D: code_point = 0xB532; break; // HANGUL SYLLABLE SSANGTIKEUT A SSANGKIYEOK
    case 0x8B4E: code_point = 0xB533; break; // HANGUL SYLLABLE SSANGTIKEUT A KIYEOKSIOS
    case 0x8B4F: code_point = 0xB535; break; // HANGUL SYLLABLE SSANGTIKEUT A NIEUNCIEUC
    case 0x8B50: code_point = 0xB536; break; // HANGUL SYLLABLE SSANGTIKEUT A NIEUNHIEUH
    case 0x8B51: code_point = 0xB537; break; // HANGUL SYLLABLE SSANGTIKEUT A TIKEUT
    case 0x8B52: code_point = 0xB539; break; // HANGUL SYLLABLE SSANGTIKEUT A RIEULKIYEOK
    case 0x8B53: code_point = 0xB53A; break; // HANGUL SYLLABLE SSANGTIKEUT A RIEULMIEUM
    case 0x8B54: code_point = 0xB53B; break; // HANGUL SYLLABLE SSANGTIKEUT A RIEULPIEUP
    case 0x8B55: code_point = 0xB53C; break; // HANGUL SYLLABLE SSANGTIKEUT A RIEULSIOS
    case 0x8B56: code_point = 0xB53D; break; // HANGUL SYLLABLE SSANGTIKEUT A RIEULTHIEUTH
    case 0x8B57: code_point = 0xB53E; break; // HANGUL SYLLABLE SSANGTIKEUT A RIEULPHIEUPH
    case 0x8B58: code_point = 0xB53F; break; // HANGUL SYLLABLE SSANGTIKEUT A RIEULHIEUH
    case 0x8B59: code_point = 0xB542; break; // HANGUL SYLLABLE SSANGTIKEUT A PIEUPSIOS
    case 0x8B5A: code_point = 0xB546; break; // HANGUL SYLLABLE SSANGTIKEUT A CIEUC
    case 0x8B61: code_point = 0xB547; break; // HANGUL SYLLABLE SSANGTIKEUT A CHIEUCH
    case 0x8B62: code_point = 0xB548; break; // HANGUL SYLLABLE SSANGTIKEUT A KHIEUKH
    case 0x8B63: code_point = 0xB549; break; // HANGUL SYLLABLE SSANGTIKEUT A THIEUTH
    case 0x8B64: code_point = 0xB54A; break; // HANGUL SYLLABLE SSANGTIKEUT A PHIEUPH
    case 0x8B65: code_point = 0xB54E; break; // HANGUL SYLLABLE SSANGTIKEUT AE SSANGKIYEOK
    case 0x8B66: code_point = 0xB54F; break; // HANGUL SYLLABLE SSANGTIKEUT AE KIYEOKSIOS
    case 0x8B67: code_point = 0xB551; break; // HANGUL SYLLABLE SSANGTIKEUT AE NIEUNCIEUC
    case 0x8B68: code_point = 0xB552; break; // HANGUL SYLLABLE SSANGTIKEUT AE NIEUNHIEUH
    case 0x8B69: code_point = 0xB553; break; // HANGUL SYLLABLE SSANGTIKEUT AE TIKEUT
    case 0x8B6A: code_point = 0xB555; break; // HANGUL SYLLABLE SSANGTIKEUT AE RIEULKIYEOK
    case 0x8B6B: code_point = 0xB556; break; // HANGUL SYLLABLE SSANGTIKEUT AE RIEULMIEUM
    case 0x8B6C: code_point = 0xB557; break; // HANGUL SYLLABLE SSANGTIKEUT AE RIEULPIEUP
    case 0x8B6D: code_point = 0xB558; break; // HANGUL SYLLABLE SSANGTIKEUT AE RIEULSIOS
    case 0x8B6E: code_point = 0xB559; break; // HANGUL SYLLABLE SSANGTIKEUT AE RIEULTHIEUTH
    case 0x8B6F: code_point = 0xB55A; break; // HANGUL SYLLABLE SSANGTIKEUT AE RIEULPHIEUPH
    case 0x8B70: code_point = 0xB55B; break; // HANGUL SYLLABLE SSANGTIKEUT AE RIEULHIEUH
    case 0x8B71: code_point = 0xB55E; break; // HANGUL SYLLABLE SSANGTIKEUT AE PIEUPSIOS
    case 0x8B72: code_point = 0xB562; break; // HANGUL SYLLABLE SSANGTIKEUT AE CIEUC
    case 0x8B73: code_point = 0xB563; break; // HANGUL SYLLABLE SSANGTIKEUT AE CHIEUCH
    case 0x8B74: code_point = 0xB564; break; // HANGUL SYLLABLE SSANGTIKEUT AE KHIEUKH
    case 0x8B75: code_point = 0xB565; break; // HANGUL SYLLABLE SSANGTIKEUT AE THIEUTH
    case 0x8B76: code_point = 0xB566; break; // HANGUL SYLLABLE SSANGTIKEUT AE PHIEUPH
    case 0x8B77: code_point = 0xB567; break; // HANGUL SYLLABLE SSANGTIKEUT AE HIEUH
    case 0x8B78: code_point = 0xB568; break; // HANGUL SYLLABLE SSANGTIKEUT YA
    case 0x8B79: code_point = 0xB569; break; // HANGUL SYLLABLE SSANGTIKEUT YA KIYEOK
    case 0x8B7A: code_point = 0xB56A; break; // HANGUL SYLLABLE SSANGTIKEUT YA SSANGKIYEOK
    case 0x8B81: code_point = 0xB56B; break; // HANGUL SYLLABLE SSANGTIKEUT YA KIYEOKSIOS
    case 0x8B82: code_point = 0xB56C; break; // HANGUL SYLLABLE SSANGTIKEUT YA NIEUN
    case 0x8B83: code_point = 0xB56D; break; // HANGUL SYLLABLE SSANGTIKEUT YA NIEUNCIEUC
    case 0x8B84: code_point = 0xB56E; break; // HANGUL SYLLABLE SSANGTIKEUT YA NIEUNHIEUH
    case 0x8B85: code_point = 0xB56F; break; // HANGUL SYLLABLE SSANGTIKEUT YA TIKEUT
    case 0x8B86: code_point = 0xB570; break; // HANGUL SYLLABLE SSANGTIKEUT YA RIEUL
    case 0x8B87: code_point = 0xB571; break; // HANGUL SYLLABLE SSANGTIKEUT YA RIEULKIYEOK
    case 0x8B88: code_point = 0xB572; break; // HANGUL SYLLABLE SSANGTIKEUT YA RIEULMIEUM
    case 0x8B89: code_point = 0xB573; break; // HANGUL SYLLABLE SSANGTIKEUT YA RIEULPIEUP
    case 0x8B8A: code_point = 0xB574; break; // HANGUL SYLLABLE SSANGTIKEUT YA RIEULSIOS
    case 0x8B8B: code_point = 0xB575; break; // HANGUL SYLLABLE SSANGTIKEUT YA RIEULTHIEUTH
    case 0x8B8C: code_point = 0xB576; break; // HANGUL SYLLABLE SSANGTIKEUT YA RIEULPHIEUPH
    case 0x8B8D: code_point = 0xB577; break; // HANGUL SYLLABLE SSANGTIKEUT YA RIEULHIEUH
    case 0x8B8E: code_point = 0xB578; break; // HANGUL SYLLABLE SSANGTIKEUT YA MIEUM
    case 0x8B8F: code_point = 0xB579; break; // HANGUL SYLLABLE SSANGTIKEUT YA PIEUP
    case 0x8B90: code_point = 0xB57A; break; // HANGUL SYLLABLE SSANGTIKEUT YA PIEUPSIOS
    case 0x8B91: code_point = 0xB57B; break; // HANGUL SYLLABLE SSANGTIKEUT YA SIOS
    case 0x8B92: code_point = 0xB57C; break; // HANGUL SYLLABLE SSANGTIKEUT YA SSANGSIOS
    case 0x8B93: code_point = 0xB57D; break; // HANGUL SYLLABLE SSANGTIKEUT YA IEUNG
    case 0x8B94: code_point = 0xB57E; break; // HANGUL SYLLABLE SSANGTIKEUT YA CIEUC
    case 0x8B95: code_point = 0xB57F; break; // HANGUL SYLLABLE SSANGTIKEUT YA CHIEUCH
    case 0x8B96: code_point = 0xB580; break; // HANGUL SYLLABLE SSANGTIKEUT YA KHIEUKH
    case 0x8B97: code_point = 0xB581; break; // HANGUL SYLLABLE SSANGTIKEUT YA THIEUTH
    case 0x8B98: code_point = 0xB582; break; // HANGUL SYLLABLE SSANGTIKEUT YA PHIEUPH
    case 0x8B99: code_point = 0xB583; break; // HANGUL SYLLABLE SSANGTIKEUT YA HIEUH
    case 0x8B9A: code_point = 0xB584; break; // HANGUL SYLLABLE SSANGTIKEUT YAE
    case 0x8B9B: code_point = 0xB585; break; // HANGUL SYLLABLE SSANGTIKEUT YAE KIYEOK
    case 0x8B9C: code_point = 0xB586; break; // HANGUL SYLLABLE SSANGTIKEUT YAE SSANGKIYEOK
    case 0x8B9D: code_point = 0xB587; break; // HANGUL SYLLABLE SSANGTIKEUT YAE KIYEOKSIOS
    case 0x8B9E: code_point = 0xB588; break; // HANGUL SYLLABLE SSANGTIKEUT YAE NIEUN
    case 0x8B9F: code_point = 0xB589; break; // HANGUL SYLLABLE SSANGTIKEUT YAE NIEUNCIEUC
    case 0x8BA0: code_point = 0xB58A; break; // HANGUL SYLLABLE SSANGTIKEUT YAE NIEUNHIEUH
    case 0x8BA1: code_point = 0xB58B; break; // HANGUL SYLLABLE SSANGTIKEUT YAE TIKEUT
    case 0x8BA2: code_point = 0xB58C; break; // HANGUL SYLLABLE SSANGTIKEUT YAE RIEUL
    case 0x8BA3: code_point = 0xB58D; break; // HANGUL SYLLABLE SSANGTIKEUT YAE RIEULKIYEOK
    case 0x8BA4: code_point = 0xB58E; break; // HANGUL SYLLABLE SSANGTIKEUT YAE RIEULMIEUM
    case 0x8BA5: code_point = 0xB58F; break; // HANGUL SYLLABLE SSANGTIKEUT YAE RIEULPIEUP
    case 0x8BA6: code_point = 0xB590; break; // HANGUL SYLLABLE SSANGTIKEUT YAE RIEULSIOS
    case 0x8BA7: code_point = 0xB591; break; // HANGUL SYLLABLE SSANGTIKEUT YAE RIEULTHIEUTH
    case 0x8BA8: code_point = 0xB592; break; // HANGUL SYLLABLE SSANGTIKEUT YAE RIEULPHIEUPH
    case 0x8BA9: code_point = 0xB593; break; // HANGUL SYLLABLE SSANGTIKEUT YAE RIEULHIEUH
    case 0x8BAA: code_point = 0xB594; break; // HANGUL SYLLABLE SSANGTIKEUT YAE MIEUM
    case 0x8BAB: code_point = 0xB595; break; // HANGUL SYLLABLE SSANGTIKEUT YAE PIEUP
    case 0x8BAC: code_point = 0xB596; break; // HANGUL SYLLABLE SSANGTIKEUT YAE PIEUPSIOS
    case 0x8BAD: code_point = 0xB597; break; // HANGUL SYLLABLE SSANGTIKEUT YAE SIOS
    case 0x8BAE: code_point = 0xB598; break; // HANGUL SYLLABLE SSANGTIKEUT YAE SSANGSIOS
    case 0x8BAF: code_point = 0xB599; break; // HANGUL SYLLABLE SSANGTIKEUT YAE IEUNG
    case 0x8BB0: code_point = 0xB59A; break; // HANGUL SYLLABLE SSANGTIKEUT YAE CIEUC
    case 0x8BB1: code_point = 0xB59B; break; // HANGUL SYLLABLE SSANGTIKEUT YAE CHIEUCH
    case 0x8BB2: code_point = 0xB59C; break; // HANGUL SYLLABLE SSANGTIKEUT YAE KHIEUKH
    case 0x8BB3: code_point = 0xB59D; break; // HANGUL SYLLABLE SSANGTIKEUT YAE THIEUTH
    case 0x8BB4: code_point = 0xB59E; break; // HANGUL SYLLABLE SSANGTIKEUT YAE PHIEUPH
    case 0x8BB5: code_point = 0xB59F; break; // HANGUL SYLLABLE SSANGTIKEUT YAE HIEUH
    case 0x8BB6: code_point = 0xB5A2; break; // HANGUL SYLLABLE SSANGTIKEUT EO SSANGKIYEOK
    case 0x8BB7: code_point = 0xB5A3; break; // HANGUL SYLLABLE SSANGTIKEUT EO KIYEOKSIOS
    case 0x8BB8: code_point = 0xB5A5; break; // HANGUL SYLLABLE SSANGTIKEUT EO NIEUNCIEUC
    case 0x8BB9: code_point = 0xB5A6; break; // HANGUL SYLLABLE SSANGTIKEUT EO NIEUNHIEUH
    case 0x8BBA: code_point = 0xB5A7; break; // HANGUL SYLLABLE SSANGTIKEUT EO TIKEUT
    case 0x8BBB: code_point = 0xB5A9; break; // HANGUL SYLLABLE SSANGTIKEUT EO RIEULKIYEOK
    case 0x8BBC: code_point = 0xB5AC; break; // HANGUL SYLLABLE SSANGTIKEUT EO RIEULSIOS
    case 0x8BBD: code_point = 0xB5AD; break; // HANGUL SYLLABLE SSANGTIKEUT EO RIEULTHIEUTH
    case 0x8BBE: code_point = 0xB5AE; break; // HANGUL SYLLABLE SSANGTIKEUT EO RIEULPHIEUPH
    case 0x8BBF: code_point = 0xB5AF; break; // HANGUL SYLLABLE SSANGTIKEUT EO RIEULHIEUH
    case 0x8BC0: code_point = 0xB5B2; break; // HANGUL SYLLABLE SSANGTIKEUT EO PIEUPSIOS
    case 0x8BC1: code_point = 0xB5B6; break; // HANGUL SYLLABLE SSANGTIKEUT EO CIEUC
    case 0x8BC2: code_point = 0xB5B7; break; // HANGUL SYLLABLE SSANGTIKEUT EO CHIEUCH
    case 0x8BC3: code_point = 0xB5B8; break; // HANGUL SYLLABLE SSANGTIKEUT EO KHIEUKH
    case 0x8BC4: code_point = 0xB5B9; break; // HANGUL SYLLABLE SSANGTIKEUT EO THIEUTH
    case 0x8BC5: code_point = 0xB5BA; break; // HANGUL SYLLABLE SSANGTIKEUT EO PHIEUPH
    case 0x8BC6: code_point = 0xB5BE; break; // HANGUL SYLLABLE SSANGTIKEUT E SSANGKIYEOK
    case 0x8BC7: code_point = 0xB5BF; break; // HANGUL SYLLABLE SSANGTIKEUT E KIYEOKSIOS
    case 0x8BC8: code_point = 0xB5C1; break; // HANGUL SYLLABLE SSANGTIKEUT E NIEUNCIEUC
    case 0x8BC9: code_point = 0xB5C2; break; // HANGUL SYLLABLE SSANGTIKEUT E NIEUNHIEUH
    case 0x8BCA: code_point = 0xB5C3; break; // HANGUL SYLLABLE SSANGTIKEUT E TIKEUT
    case 0x8BCB: code_point = 0xB5C5; break; // HANGUL SYLLABLE SSANGTIKEUT E RIEULKIYEOK
    case 0x8BCC: code_point = 0xB5C6; break; // HANGUL SYLLABLE SSANGTIKEUT E RIEULMIEUM
    case 0x8BCD: code_point = 0xB5C7; break; // HANGUL SYLLABLE SSANGTIKEUT E RIEULPIEUP
    case 0x8BCE: code_point = 0xB5C8; break; // HANGUL SYLLABLE SSANGTIKEUT E RIEULSIOS
    case 0x8BCF: code_point = 0xB5C9; break; // HANGUL SYLLABLE SSANGTIKEUT E RIEULTHIEUTH
    case 0x8BD0: code_point = 0xB5CA; break; // HANGUL SYLLABLE SSANGTIKEUT E RIEULPHIEUPH
    case 0x8BD1: code_point = 0xB5CB; break; // HANGUL SYLLABLE SSANGTIKEUT E RIEULHIEUH
    case 0x8BD2: code_point = 0xB5CE; break; // HANGUL SYLLABLE SSANGTIKEUT E PIEUPSIOS
    case 0x8BD3: code_point = 0xB5D2; break; // HANGUL SYLLABLE SSANGTIKEUT E CIEUC
    case 0x8BD4: code_point = 0xB5D3; break; // HANGUL SYLLABLE SSANGTIKEUT E CHIEUCH
    case 0x8BD5: code_point = 0xB5D4; break; // HANGUL SYLLABLE SSANGTIKEUT E KHIEUKH
    case 0x8BD6: code_point = 0xB5D5; break; // HANGUL SYLLABLE SSANGTIKEUT E THIEUTH
    case 0x8BD7: code_point = 0xB5D6; break; // HANGUL SYLLABLE SSANGTIKEUT E PHIEUPH
    case 0x8BD8: code_point = 0xB5D7; break; // HANGUL SYLLABLE SSANGTIKEUT E HIEUH
    case 0x8BD9: code_point = 0xB5D9; break; // HANGUL SYLLABLE SSANGTIKEUT YEO KIYEOK
    case 0x8BDA: code_point = 0xB5DA; break; // HANGUL SYLLABLE SSANGTIKEUT YEO SSANGKIYEOK
    case 0x8BDB: code_point = 0xB5DB; break; // HANGUL SYLLABLE SSANGTIKEUT YEO KIYEOKSIOS
    case 0x8BDC: code_point = 0xB5DC; break; // HANGUL SYLLABLE SSANGTIKEUT YEO NIEUN
    case 0x8BDD: code_point = 0xB5DD; break; // HANGUL SYLLABLE SSANGTIKEUT YEO NIEUNCIEUC
    case 0x8BDE: code_point = 0xB5DE; break; // HANGUL SYLLABLE SSANGTIKEUT YEO NIEUNHIEUH
    case 0x8BDF: code_point = 0xB5DF; break; // HANGUL SYLLABLE SSANGTIKEUT YEO TIKEUT
    case 0x8BE0: code_point = 0xB5E0; break; // HANGUL SYLLABLE SSANGTIKEUT YEO RIEUL
    case 0x8BE1: code_point = 0xB5E1; break; // HANGUL SYLLABLE SSANGTIKEUT YEO RIEULKIYEOK
    case 0x8BE2: code_point = 0xB5E2; break; // HANGUL SYLLABLE SSANGTIKEUT YEO RIEULMIEUM
    case 0x8BE3: code_point = 0xB5E3; break; // HANGUL SYLLABLE SSANGTIKEUT YEO RIEULPIEUP
    case 0x8BE4: code_point = 0xB5E4; break; // HANGUL SYLLABLE SSANGTIKEUT YEO RIEULSIOS
    case 0x8BE5: code_point = 0xB5E5; break; // HANGUL SYLLABLE SSANGTIKEUT YEO RIEULTHIEUTH
    case 0x8BE6: code_point = 0xB5E6; break; // HANGUL SYLLABLE SSANGTIKEUT YEO RIEULPHIEUPH
    case 0x8BE7: code_point = 0xB5E7; break; // HANGUL SYLLABLE SSANGTIKEUT YEO RIEULHIEUH
    case 0x8BE8: code_point = 0xB5E8; break; // HANGUL SYLLABLE SSANGTIKEUT YEO MIEUM
    case 0x8BE9: code_point = 0xB5E9; break; // HANGUL SYLLABLE SSANGTIKEUT YEO PIEUP
    case 0x8BEA: code_point = 0xB5EA; break; // HANGUL SYLLABLE SSANGTIKEUT YEO PIEUPSIOS
    case 0x8BEB: code_point = 0xB5EB; break; // HANGUL SYLLABLE SSANGTIKEUT YEO SIOS
    case 0x8BEC: code_point = 0xB5ED; break; // HANGUL SYLLABLE SSANGTIKEUT YEO IEUNG
    case 0x8BED: code_point = 0xB5EE; break; // HANGUL SYLLABLE SSANGTIKEUT YEO CIEUC
    case 0x8BEE: code_point = 0xB5EF; break; // HANGUL SYLLABLE SSANGTIKEUT YEO CHIEUCH
    case 0x8BEF: code_point = 0xB5F0; break; // HANGUL SYLLABLE SSANGTIKEUT YEO KHIEUKH
    case 0x8BF0: code_point = 0xB5F1; break; // HANGUL SYLLABLE SSANGTIKEUT YEO THIEUTH
    case 0x8BF1: code_point = 0xB5F2; break; // HANGUL SYLLABLE SSANGTIKEUT YEO PHIEUPH
    case 0x8BF2: code_point = 0xB5F3; break; // HANGUL SYLLABLE SSANGTIKEUT YEO HIEUH
    case 0x8BF3: code_point = 0xB5F4; break; // HANGUL SYLLABLE SSANGTIKEUT YE
    case 0x8BF4: code_point = 0xB5F5; break; // HANGUL SYLLABLE SSANGTIKEUT YE KIYEOK
    case 0x8BF5: code_point = 0xB5F6; break; // HANGUL SYLLABLE SSANGTIKEUT YE SSANGKIYEOK
    case 0x8BF6: code_point = 0xB5F7; break; // HANGUL SYLLABLE SSANGTIKEUT YE KIYEOKSIOS
    case 0x8BF7: code_point = 0xB5F8; break; // HANGUL SYLLABLE SSANGTIKEUT YE NIEUN
    case 0x8BF8: code_point = 0xB5F9; break; // HANGUL SYLLABLE SSANGTIKEUT YE NIEUNCIEUC
    case 0x8BF9: code_point = 0xB5FA; break; // HANGUL SYLLABLE SSANGTIKEUT YE NIEUNHIEUH
    case 0x8BFA: code_point = 0xB5FB; break; // HANGUL SYLLABLE SSANGTIKEUT YE TIKEUT
    case 0x8BFB: code_point = 0xB5FC; break; // HANGUL SYLLABLE SSANGTIKEUT YE RIEUL
    case 0x8BFC: code_point = 0xB5FD; break; // HANGUL SYLLABLE SSANGTIKEUT YE RIEULKIYEOK
    case 0x8BFD: code_point = 0xB5FE; break; // HANGUL SYLLABLE SSANGTIKEUT YE RIEULMIEUM
    case 0x8BFE: code_point = 0xB5FF; break; // HANGUL SYLLABLE SSANGTIKEUT YE RIEULPIEUP
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x8C(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8C41: code_point = 0xB600; break; // HANGUL SYLLABLE SSANGTIKEUT YE RIEULSIOS
    case 0x8C42: code_point = 0xB601; break; // HANGUL SYLLABLE SSANGTIKEUT YE RIEULTHIEUTH
    case 0x8C43: code_point = 0xB602; break; // HANGUL SYLLABLE SSANGTIKEUT YE RIEULPHIEUPH
    case 0x8C44: code_point = 0xB603; break; // HANGUL SYLLABLE SSANGTIKEUT YE RIEULHIEUH
    case 0x8C45: code_point = 0xB604; break; // HANGUL SYLLABLE SSANGTIKEUT YE MIEUM
    case 0x8C46: code_point = 0xB605; break; // HANGUL SYLLABLE SSANGTIKEUT YE PIEUP
    case 0x8C47: code_point = 0xB606; break; // HANGUL SYLLABLE SSANGTIKEUT YE PIEUPSIOS
    case 0x8C48: code_point = 0xB607; break; // HANGUL SYLLABLE SSANGTIKEUT YE SIOS
    case 0x8C49: code_point = 0xB608; break; // HANGUL SYLLABLE SSANGTIKEUT YE SSANGSIOS
    case 0x8C4A: code_point = 0xB609; break; // HANGUL SYLLABLE SSANGTIKEUT YE IEUNG
    case 0x8C4B: code_point = 0xB60A; break; // HANGUL SYLLABLE SSANGTIKEUT YE CIEUC
    case 0x8C4C: code_point = 0xB60B; break; // HANGUL SYLLABLE SSANGTIKEUT YE CHIEUCH
    case 0x8C4D: code_point = 0xB60C; break; // HANGUL SYLLABLE SSANGTIKEUT YE KHIEUKH
    case 0x8C4E: code_point = 0xB60D; break; // HANGUL SYLLABLE SSANGTIKEUT YE THIEUTH
    case 0x8C4F: code_point = 0xB60E; break; // HANGUL SYLLABLE SSANGTIKEUT YE PHIEUPH
    case 0x8C50: code_point = 0xB60F; break; // HANGUL SYLLABLE SSANGTIKEUT YE HIEUH
    case 0x8C51: code_point = 0xB612; break; // HANGUL SYLLABLE SSANGTIKEUT O SSANGKIYEOK
    case 0x8C52: code_point = 0xB613; break; // HANGUL SYLLABLE SSANGTIKEUT O KIYEOKSIOS
    case 0x8C53: code_point = 0xB615; break; // HANGUL SYLLABLE SSANGTIKEUT O NIEUNCIEUC
    case 0x8C54: code_point = 0xB616; break; // HANGUL SYLLABLE SSANGTIKEUT O NIEUNHIEUH
    case 0x8C55: code_point = 0xB617; break; // HANGUL SYLLABLE SSANGTIKEUT O TIKEUT
    case 0x8C56: code_point = 0xB619; break; // HANGUL SYLLABLE SSANGTIKEUT O RIEULKIYEOK
    case 0x8C57: code_point = 0xB61A; break; // HANGUL SYLLABLE SSANGTIKEUT O RIEULMIEUM
    case 0x8C58: code_point = 0xB61B; break; // HANGUL SYLLABLE SSANGTIKEUT O RIEULPIEUP
    case 0x8C59: code_point = 0xB61C; break; // HANGUL SYLLABLE SSANGTIKEUT O RIEULSIOS
    case 0x8C5A: code_point = 0xB61D; break; // HANGUL SYLLABLE SSANGTIKEUT O RIEULTHIEUTH
    case 0x8C61: code_point = 0xB61E; break; // HANGUL SYLLABLE SSANGTIKEUT O RIEULPHIEUPH
    case 0x8C62: code_point = 0xB61F; break; // HANGUL SYLLABLE SSANGTIKEUT O RIEULHIEUH
    case 0x8C63: code_point = 0xB620; break; // HANGUL SYLLABLE SSANGTIKEUT O MIEUM
    case 0x8C64: code_point = 0xB621; break; // HANGUL SYLLABLE SSANGTIKEUT O PIEUP
    case 0x8C65: code_point = 0xB622; break; // HANGUL SYLLABLE SSANGTIKEUT O PIEUPSIOS
    case 0x8C66: code_point = 0xB623; break; // HANGUL SYLLABLE SSANGTIKEUT O SIOS
    case 0x8C67: code_point = 0xB624; break; // HANGUL SYLLABLE SSANGTIKEUT O SSANGSIOS
    case 0x8C68: code_point = 0xB626; break; // HANGUL SYLLABLE SSANGTIKEUT O CIEUC
    case 0x8C69: code_point = 0xB627; break; // HANGUL SYLLABLE SSANGTIKEUT O CHIEUCH
    case 0x8C6A: code_point = 0xB628; break; // HANGUL SYLLABLE SSANGTIKEUT O KHIEUKH
    case 0x8C6B: code_point = 0xB629; break; // HANGUL SYLLABLE SSANGTIKEUT O THIEUTH
    case 0x8C6C: code_point = 0xB62A; break; // HANGUL SYLLABLE SSANGTIKEUT O PHIEUPH
    case 0x8C6D: code_point = 0xB62B; break; // HANGUL SYLLABLE SSANGTIKEUT O HIEUH
    case 0x8C6E: code_point = 0xB62D; break; // HANGUL SYLLABLE SSANGTIKEUT WA KIYEOK
    case 0x8C6F: code_point = 0xB62E; break; // HANGUL SYLLABLE SSANGTIKEUT WA SSANGKIYEOK
    case 0x8C70: code_point = 0xB62F; break; // HANGUL SYLLABLE SSANGTIKEUT WA KIYEOKSIOS
    case 0x8C71: code_point = 0xB630; break; // HANGUL SYLLABLE SSANGTIKEUT WA NIEUN
    case 0x8C72: code_point = 0xB631; break; // HANGUL SYLLABLE SSANGTIKEUT WA NIEUNCIEUC
    case 0x8C73: code_point = 0xB632; break; // HANGUL SYLLABLE SSANGTIKEUT WA NIEUNHIEUH
    case 0x8C74: code_point = 0xB633; break; // HANGUL SYLLABLE SSANGTIKEUT WA TIKEUT
    case 0x8C75: code_point = 0xB635; break; // HANGUL SYLLABLE SSANGTIKEUT WA RIEULKIYEOK
    case 0x8C76: code_point = 0xB636; break; // HANGUL SYLLABLE SSANGTIKEUT WA RIEULMIEUM
    case 0x8C77: code_point = 0xB637; break; // HANGUL SYLLABLE SSANGTIKEUT WA RIEULPIEUP
    case 0x8C78: code_point = 0xB638; break; // HANGUL SYLLABLE SSANGTIKEUT WA RIEULSIOS
    case 0x8C79: code_point = 0xB639; break; // HANGUL SYLLABLE SSANGTIKEUT WA RIEULTHIEUTH
    case 0x8C7A: code_point = 0xB63A; break; // HANGUL SYLLABLE SSANGTIKEUT WA RIEULPHIEUPH
    case 0x8C81: code_point = 0xB63B; break; // HANGUL SYLLABLE SSANGTIKEUT WA RIEULHIEUH
    case 0x8C82: code_point = 0xB63C; break; // HANGUL SYLLABLE SSANGTIKEUT WA MIEUM
    case 0x8C83: code_point = 0xB63D; break; // HANGUL SYLLABLE SSANGTIKEUT WA PIEUP
    case 0x8C84: code_point = 0xB63E; break; // HANGUL SYLLABLE SSANGTIKEUT WA PIEUPSIOS
    case 0x8C85: code_point = 0xB63F; break; // HANGUL SYLLABLE SSANGTIKEUT WA SIOS
    case 0x8C86: code_point = 0xB640; break; // HANGUL SYLLABLE SSANGTIKEUT WA SSANGSIOS
    case 0x8C87: code_point = 0xB641; break; // HANGUL SYLLABLE SSANGTIKEUT WA IEUNG
    case 0x8C88: code_point = 0xB642; break; // HANGUL SYLLABLE SSANGTIKEUT WA CIEUC
    case 0x8C89: code_point = 0xB643; break; // HANGUL SYLLABLE SSANGTIKEUT WA CHIEUCH
    case 0x8C8A: code_point = 0xB644; break; // HANGUL SYLLABLE SSANGTIKEUT WA KHIEUKH
    case 0x8C8B: code_point = 0xB645; break; // HANGUL SYLLABLE SSANGTIKEUT WA THIEUTH
    case 0x8C8C: code_point = 0xB646; break; // HANGUL SYLLABLE SSANGTIKEUT WA PHIEUPH
    case 0x8C8D: code_point = 0xB647; break; // HANGUL SYLLABLE SSANGTIKEUT WA HIEUH
    case 0x8C8E: code_point = 0xB649; break; // HANGUL SYLLABLE SSANGTIKEUT WAE KIYEOK
    case 0x8C8F: code_point = 0xB64A; break; // HANGUL SYLLABLE SSANGTIKEUT WAE SSANGKIYEOK
    case 0x8C90: code_point = 0xB64B; break; // HANGUL SYLLABLE SSANGTIKEUT WAE KIYEOKSIOS
    case 0x8C91: code_point = 0xB64C; break; // HANGUL SYLLABLE SSANGTIKEUT WAE NIEUN
    case 0x8C92: code_point = 0xB64D; break; // HANGUL SYLLABLE SSANGTIKEUT WAE NIEUNCIEUC
    case 0x8C93: code_point = 0xB64E; break; // HANGUL SYLLABLE SSANGTIKEUT WAE NIEUNHIEUH
    case 0x8C94: code_point = 0xB64F; break; // HANGUL SYLLABLE SSANGTIKEUT WAE TIKEUT
    case 0x8C95: code_point = 0xB650; break; // HANGUL SYLLABLE SSANGTIKEUT WAE RIEUL
    case 0x8C96: code_point = 0xB651; break; // HANGUL SYLLABLE SSANGTIKEUT WAE RIEULKIYEOK
    case 0x8C97: code_point = 0xB652; break; // HANGUL SYLLABLE SSANGTIKEUT WAE RIEULMIEUM
    case 0x8C98: code_point = 0xB653; break; // HANGUL SYLLABLE SSANGTIKEUT WAE RIEULPIEUP
    case 0x8C99: code_point = 0xB654; break; // HANGUL SYLLABLE SSANGTIKEUT WAE RIEULSIOS
    case 0x8C9A: code_point = 0xB655; break; // HANGUL SYLLABLE SSANGTIKEUT WAE RIEULTHIEUTH
    case 0x8C9B: code_point = 0xB656; break; // HANGUL SYLLABLE SSANGTIKEUT WAE RIEULPHIEUPH
    case 0x8C9C: code_point = 0xB657; break; // HANGUL SYLLABLE SSANGTIKEUT WAE RIEULHIEUH
    case 0x8C9D: code_point = 0xB658; break; // HANGUL SYLLABLE SSANGTIKEUT WAE MIEUM
    case 0x8C9E: code_point = 0xB659; break; // HANGUL SYLLABLE SSANGTIKEUT WAE PIEUP
    case 0x8C9F: code_point = 0xB65A; break; // HANGUL SYLLABLE SSANGTIKEUT WAE PIEUPSIOS
    case 0x8CA0: code_point = 0xB65B; break; // HANGUL SYLLABLE SSANGTIKEUT WAE SIOS
    case 0x8CA1: code_point = 0xB65C; break; // HANGUL SYLLABLE SSANGTIKEUT WAE SSANGSIOS
    case 0x8CA2: code_point = 0xB65D; break; // HANGUL SYLLABLE SSANGTIKEUT WAE IEUNG
    case 0x8CA3: code_point = 0xB65E; break; // HANGUL SYLLABLE SSANGTIKEUT WAE CIEUC
    case 0x8CA4: code_point = 0xB65F; break; // HANGUL SYLLABLE SSANGTIKEUT WAE CHIEUCH
    case 0x8CA5: code_point = 0xB660; break; // HANGUL SYLLABLE SSANGTIKEUT WAE KHIEUKH
    case 0x8CA6: code_point = 0xB661; break; // HANGUL SYLLABLE SSANGTIKEUT WAE THIEUTH
    case 0x8CA7: code_point = 0xB662; break; // HANGUL SYLLABLE SSANGTIKEUT WAE PHIEUPH
    case 0x8CA8: code_point = 0xB663; break; // HANGUL SYLLABLE SSANGTIKEUT WAE HIEUH
    case 0x8CA9: code_point = 0xB665; break; // HANGUL SYLLABLE SSANGTIKEUT OE KIYEOK
    case 0x8CAA: code_point = 0xB666; break; // HANGUL SYLLABLE SSANGTIKEUT OE SSANGKIYEOK
    case 0x8CAB: code_point = 0xB667; break; // HANGUL SYLLABLE SSANGTIKEUT OE KIYEOKSIOS
    case 0x8CAC: code_point = 0xB669; break; // HANGUL SYLLABLE SSANGTIKEUT OE NIEUNCIEUC
    case 0x8CAD: code_point = 0xB66A; break; // HANGUL SYLLABLE SSANGTIKEUT OE NIEUNHIEUH
    case 0x8CAE: code_point = 0xB66B; break; // HANGUL SYLLABLE SSANGTIKEUT OE TIKEUT
    case 0x8CAF: code_point = 0xB66C; break; // HANGUL SYLLABLE SSANGTIKEUT OE RIEUL
    case 0x8CB0: code_point = 0xB66D; break; // HANGUL SYLLABLE SSANGTIKEUT OE RIEULKIYEOK
    case 0x8CB1: code_point = 0xB66E; break; // HANGUL SYLLABLE SSANGTIKEUT OE RIEULMIEUM
    case 0x8CB2: code_point = 0xB66F; break; // HANGUL SYLLABLE SSANGTIKEUT OE RIEULPIEUP
    case 0x8CB3: code_point = 0xB670; break; // HANGUL SYLLABLE SSANGTIKEUT OE RIEULSIOS
    case 0x8CB4: code_point = 0xB671; break; // HANGUL SYLLABLE SSANGTIKEUT OE RIEULTHIEUTH
    case 0x8CB5: code_point = 0xB672; break; // HANGUL SYLLABLE SSANGTIKEUT OE RIEULPHIEUPH
    case 0x8CB6: code_point = 0xB673; break; // HANGUL SYLLABLE SSANGTIKEUT OE RIEULHIEUH
    case 0x8CB7: code_point = 0xB674; break; // HANGUL SYLLABLE SSANGTIKEUT OE MIEUM
    case 0x8CB8: code_point = 0xB675; break; // HANGUL SYLLABLE SSANGTIKEUT OE PIEUP
    case 0x8CB9: code_point = 0xB676; break; // HANGUL SYLLABLE SSANGTIKEUT OE PIEUPSIOS
    case 0x8CBA: code_point = 0xB677; break; // HANGUL SYLLABLE SSANGTIKEUT OE SIOS
    case 0x8CBB: code_point = 0xB678; break; // HANGUL SYLLABLE SSANGTIKEUT OE SSANGSIOS
    case 0x8CBC: code_point = 0xB679; break; // HANGUL SYLLABLE SSANGTIKEUT OE IEUNG
    case 0x8CBD: code_point = 0xB67A; break; // HANGUL SYLLABLE SSANGTIKEUT OE CIEUC
    case 0x8CBE: code_point = 0xB67B; break; // HANGUL SYLLABLE SSANGTIKEUT OE CHIEUCH
    case 0x8CBF: code_point = 0xB67C; break; // HANGUL SYLLABLE SSANGTIKEUT OE KHIEUKH
    case 0x8CC0: code_point = 0xB67D; break; // HANGUL SYLLABLE SSANGTIKEUT OE THIEUTH
    case 0x8CC1: code_point = 0xB67E; break; // HANGUL SYLLABLE SSANGTIKEUT OE PHIEUPH
    case 0x8CC2: code_point = 0xB67F; break; // HANGUL SYLLABLE SSANGTIKEUT OE HIEUH
    case 0x8CC3: code_point = 0xB680; break; // HANGUL SYLLABLE SSANGTIKEUT YO
    case 0x8CC4: code_point = 0xB681; break; // HANGUL SYLLABLE SSANGTIKEUT YO KIYEOK
    case 0x8CC5: code_point = 0xB682; break; // HANGUL SYLLABLE SSANGTIKEUT YO SSANGKIYEOK
    case 0x8CC6: code_point = 0xB683; break; // HANGUL SYLLABLE SSANGTIKEUT YO KIYEOKSIOS
    case 0x8CC7: code_point = 0xB684; break; // HANGUL SYLLABLE SSANGTIKEUT YO NIEUN
    case 0x8CC8: code_point = 0xB685; break; // HANGUL SYLLABLE SSANGTIKEUT YO NIEUNCIEUC
    case 0x8CC9: code_point = 0xB686; break; // HANGUL SYLLABLE SSANGTIKEUT YO NIEUNHIEUH
    case 0x8CCA: code_point = 0xB687; break; // HANGUL SYLLABLE SSANGTIKEUT YO TIKEUT
    case 0x8CCB: code_point = 0xB688; break; // HANGUL SYLLABLE SSANGTIKEUT YO RIEUL
    case 0x8CCC: code_point = 0xB689; break; // HANGUL SYLLABLE SSANGTIKEUT YO RIEULKIYEOK
    case 0x8CCD: code_point = 0xB68A; break; // HANGUL SYLLABLE SSANGTIKEUT YO RIEULMIEUM
    case 0x8CCE: code_point = 0xB68B; break; // HANGUL SYLLABLE SSANGTIKEUT YO RIEULPIEUP
    case 0x8CCF: code_point = 0xB68C; break; // HANGUL SYLLABLE SSANGTIKEUT YO RIEULSIOS
    case 0x8CD0: code_point = 0xB68D; break; // HANGUL SYLLABLE SSANGTIKEUT YO RIEULTHIEUTH
    case 0x8CD1: code_point = 0xB68E; break; // HANGUL SYLLABLE SSANGTIKEUT YO RIEULPHIEUPH
    case 0x8CD2: code_point = 0xB68F; break; // HANGUL SYLLABLE SSANGTIKEUT YO RIEULHIEUH
    case 0x8CD3: code_point = 0xB690; break; // HANGUL SYLLABLE SSANGTIKEUT YO MIEUM
    case 0x8CD4: code_point = 0xB691; break; // HANGUL SYLLABLE SSANGTIKEUT YO PIEUP
    case 0x8CD5: code_point = 0xB692; break; // HANGUL SYLLABLE SSANGTIKEUT YO PIEUPSIOS
    case 0x8CD6: code_point = 0xB693; break; // HANGUL SYLLABLE SSANGTIKEUT YO SIOS
    case 0x8CD7: code_point = 0xB694; break; // HANGUL SYLLABLE SSANGTIKEUT YO SSANGSIOS
    case 0x8CD8: code_point = 0xB695; break; // HANGUL SYLLABLE SSANGTIKEUT YO IEUNG
    case 0x8CD9: code_point = 0xB696; break; // HANGUL SYLLABLE SSANGTIKEUT YO CIEUC
    case 0x8CDA: code_point = 0xB697; break; // HANGUL SYLLABLE SSANGTIKEUT YO CHIEUCH
    case 0x8CDB: code_point = 0xB698; break; // HANGUL SYLLABLE SSANGTIKEUT YO KHIEUKH
    case 0x8CDC: code_point = 0xB699; break; // HANGUL SYLLABLE SSANGTIKEUT YO THIEUTH
    case 0x8CDD: code_point = 0xB69A; break; // HANGUL SYLLABLE SSANGTIKEUT YO PHIEUPH
    case 0x8CDE: code_point = 0xB69B; break; // HANGUL SYLLABLE SSANGTIKEUT YO HIEUH
    case 0x8CDF: code_point = 0xB69E; break; // HANGUL SYLLABLE SSANGTIKEUT U SSANGKIYEOK
    case 0x8CE0: code_point = 0xB69F; break; // HANGUL SYLLABLE SSANGTIKEUT U KIYEOKSIOS
    case 0x8CE1: code_point = 0xB6A1; break; // HANGUL SYLLABLE SSANGTIKEUT U NIEUNCIEUC
    case 0x8CE2: code_point = 0xB6A2; break; // HANGUL SYLLABLE SSANGTIKEUT U NIEUNHIEUH
    case 0x8CE3: code_point = 0xB6A3; break; // HANGUL SYLLABLE SSANGTIKEUT U TIKEUT
    case 0x8CE4: code_point = 0xB6A5; break; // HANGUL SYLLABLE SSANGTIKEUT U RIEULKIYEOK
    case 0x8CE5: code_point = 0xB6A6; break; // HANGUL SYLLABLE SSANGTIKEUT U RIEULMIEUM
    case 0x8CE6: code_point = 0xB6A7; break; // HANGUL SYLLABLE SSANGTIKEUT U RIEULPIEUP
    case 0x8CE7: code_point = 0xB6A8; break; // HANGUL SYLLABLE SSANGTIKEUT U RIEULSIOS
    case 0x8CE8: code_point = 0xB6A9; break; // HANGUL SYLLABLE SSANGTIKEUT U RIEULTHIEUTH
    case 0x8CE9: code_point = 0xB6AA; break; // HANGUL SYLLABLE SSANGTIKEUT U RIEULPHIEUPH
    case 0x8CEA: code_point = 0xB6AD; break; // HANGUL SYLLABLE SSANGTIKEUT U PIEUP
    case 0x8CEB: code_point = 0xB6AE; break; // HANGUL SYLLABLE SSANGTIKEUT U PIEUPSIOS
    case 0x8CEC: code_point = 0xB6AF; break; // HANGUL SYLLABLE SSANGTIKEUT U SIOS
    case 0x8CED: code_point = 0xB6B0; break; // HANGUL SYLLABLE SSANGTIKEUT U SSANGSIOS
    case 0x8CEE: code_point = 0xB6B2; break; // HANGUL SYLLABLE SSANGTIKEUT U CIEUC
    case 0x8CEF: code_point = 0xB6B3; break; // HANGUL SYLLABLE SSANGTIKEUT U CHIEUCH
    case 0x8CF0: code_point = 0xB6B4; break; // HANGUL SYLLABLE SSANGTIKEUT U KHIEUKH
    case 0x8CF1: code_point = 0xB6B5; break; // HANGUL SYLLABLE SSANGTIKEUT U THIEUTH
    case 0x8CF2: code_point = 0xB6B6; break; // HANGUL SYLLABLE SSANGTIKEUT U PHIEUPH
    case 0x8CF3: code_point = 0xB6B7; break; // HANGUL SYLLABLE SSANGTIKEUT U HIEUH
    case 0x8CF4: code_point = 0xB6B8; break; // HANGUL SYLLABLE SSANGTIKEUT WEO
    case 0x8CF5: code_point = 0xB6B9; break; // HANGUL SYLLABLE SSANGTIKEUT WEO KIYEOK
    case 0x8CF6: code_point = 0xB6BA; break; // HANGUL SYLLABLE SSANGTIKEUT WEO SSANGKIYEOK
    case 0x8CF7: code_point = 0xB6BB; break; // HANGUL SYLLABLE SSANGTIKEUT WEO KIYEOKSIOS
    case 0x8CF8: code_point = 0xB6BC; break; // HANGUL SYLLABLE SSANGTIKEUT WEO NIEUN
    case 0x8CF9: code_point = 0xB6BD; break; // HANGUL SYLLABLE SSANGTIKEUT WEO NIEUNCIEUC
    case 0x8CFA: code_point = 0xB6BE; break; // HANGUL SYLLABLE SSANGTIKEUT WEO NIEUNHIEUH
    case 0x8CFB: code_point = 0xB6BF; break; // HANGUL SYLLABLE SSANGTIKEUT WEO TIKEUT
    case 0x8CFC: code_point = 0xB6C0; break; // HANGUL SYLLABLE SSANGTIKEUT WEO RIEUL
    case 0x8CFD: code_point = 0xB6C1; break; // HANGUL SYLLABLE SSANGTIKEUT WEO RIEULKIYEOK
    case 0x8CFE: code_point = 0xB6C2; break; // HANGUL SYLLABLE SSANGTIKEUT WEO RIEULMIEUM
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x8D(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8D41: code_point = 0xB6C3; break; // HANGUL SYLLABLE SSANGTIKEUT WEO RIEULPIEUP
    case 0x8D42: code_point = 0xB6C4; break; // HANGUL SYLLABLE SSANGTIKEUT WEO RIEULSIOS
    case 0x8D43: code_point = 0xB6C5; break; // HANGUL SYLLABLE SSANGTIKEUT WEO RIEULTHIEUTH
    case 0x8D44: code_point = 0xB6C6; break; // HANGUL SYLLABLE SSANGTIKEUT WEO RIEULPHIEUPH
    case 0x8D45: code_point = 0xB6C7; break; // HANGUL SYLLABLE SSANGTIKEUT WEO RIEULHIEUH
    case 0x8D46: code_point = 0xB6C8; break; // HANGUL SYLLABLE SSANGTIKEUT WEO MIEUM
    case 0x8D47: code_point = 0xB6C9; break; // HANGUL SYLLABLE SSANGTIKEUT WEO PIEUP
    case 0x8D48: code_point = 0xB6CA; break; // HANGUL SYLLABLE SSANGTIKEUT WEO PIEUPSIOS
    case 0x8D49: code_point = 0xB6CB; break; // HANGUL SYLLABLE SSANGTIKEUT WEO SIOS
    case 0x8D4A: code_point = 0xB6CC; break; // HANGUL SYLLABLE SSANGTIKEUT WEO SSANGSIOS
    case 0x8D4B: code_point = 0xB6CD; break; // HANGUL SYLLABLE SSANGTIKEUT WEO IEUNG
    case 0x8D4C: code_point = 0xB6CE; break; // HANGUL SYLLABLE SSANGTIKEUT WEO CIEUC
    case 0x8D4D: code_point = 0xB6CF; break; // HANGUL SYLLABLE SSANGTIKEUT WEO CHIEUCH
    case 0x8D4E: code_point = 0xB6D0; break; // HANGUL SYLLABLE SSANGTIKEUT WEO KHIEUKH
    case 0x8D4F: code_point = 0xB6D1; break; // HANGUL SYLLABLE SSANGTIKEUT WEO THIEUTH
    case 0x8D50: code_point = 0xB6D2; break; // HANGUL SYLLABLE SSANGTIKEUT WEO PHIEUPH
    case 0x8D51: code_point = 0xB6D3; break; // HANGUL SYLLABLE SSANGTIKEUT WEO HIEUH
    case 0x8D52: code_point = 0xB6D5; break; // HANGUL SYLLABLE SSANGTIKEUT WE KIYEOK
    case 0x8D53: code_point = 0xB6D6; break; // HANGUL SYLLABLE SSANGTIKEUT WE SSANGKIYEOK
    case 0x8D54: code_point = 0xB6D7; break; // HANGUL SYLLABLE SSANGTIKEUT WE KIYEOKSIOS
    case 0x8D55: code_point = 0xB6D8; break; // HANGUL SYLLABLE SSANGTIKEUT WE NIEUN
    case 0x8D56: code_point = 0xB6D9; break; // HANGUL SYLLABLE SSANGTIKEUT WE NIEUNCIEUC
    case 0x8D57: code_point = 0xB6DA; break; // HANGUL SYLLABLE SSANGTIKEUT WE NIEUNHIEUH
    case 0x8D58: code_point = 0xB6DB; break; // HANGUL SYLLABLE SSANGTIKEUT WE TIKEUT
    case 0x8D59: code_point = 0xB6DC; break; // HANGUL SYLLABLE SSANGTIKEUT WE RIEUL
    case 0x8D5A: code_point = 0xB6DD; break; // HANGUL SYLLABLE SSANGTIKEUT WE RIEULKIYEOK
    case 0x8D61: code_point = 0xB6DE; break; // HANGUL SYLLABLE SSANGTIKEUT WE RIEULMIEUM
    case 0x8D62: code_point = 0xB6DF; break; // HANGUL SYLLABLE SSANGTIKEUT WE RIEULPIEUP
    case 0x8D63: code_point = 0xB6E0; break; // HANGUL SYLLABLE SSANGTIKEUT WE RIEULSIOS
    case 0x8D64: code_point = 0xB6E1; break; // HANGUL SYLLABLE SSANGTIKEUT WE RIEULTHIEUTH
    case 0x8D65: code_point = 0xB6E2; break; // HANGUL SYLLABLE SSANGTIKEUT WE RIEULPHIEUPH
    case 0x8D66: code_point = 0xB6E3; break; // HANGUL SYLLABLE SSANGTIKEUT WE RIEULHIEUH
    case 0x8D67: code_point = 0xB6E4; break; // HANGUL SYLLABLE SSANGTIKEUT WE MIEUM
    case 0x8D68: code_point = 0xB6E5; break; // HANGUL SYLLABLE SSANGTIKEUT WE PIEUP
    case 0x8D69: code_point = 0xB6E6; break; // HANGUL SYLLABLE SSANGTIKEUT WE PIEUPSIOS
    case 0x8D6A: code_point = 0xB6E7; break; // HANGUL SYLLABLE SSANGTIKEUT WE SIOS
    case 0x8D6B: code_point = 0xB6E8; break; // HANGUL SYLLABLE SSANGTIKEUT WE SSANGSIOS
    case 0x8D6C: code_point = 0xB6E9; break; // HANGUL SYLLABLE SSANGTIKEUT WE IEUNG
    case 0x8D6D: code_point = 0xB6EA; break; // HANGUL SYLLABLE SSANGTIKEUT WE CIEUC
    case 0x8D6E: code_point = 0xB6EB; break; // HANGUL SYLLABLE SSANGTIKEUT WE CHIEUCH
    case 0x8D6F: code_point = 0xB6EC; break; // HANGUL SYLLABLE SSANGTIKEUT WE KHIEUKH
    case 0x8D70: code_point = 0xB6ED; break; // HANGUL SYLLABLE SSANGTIKEUT WE THIEUTH
    case 0x8D71: code_point = 0xB6EE; break; // HANGUL SYLLABLE SSANGTIKEUT WE PHIEUPH
    case 0x8D72: code_point = 0xB6EF; break; // HANGUL SYLLABLE SSANGTIKEUT WE HIEUH
    case 0x8D73: code_point = 0xB6F1; break; // HANGUL SYLLABLE SSANGTIKEUT WI KIYEOK
    case 0x8D74: code_point = 0xB6F2; break; // HANGUL SYLLABLE SSANGTIKEUT WI SSANGKIYEOK
    case 0x8D75: code_point = 0xB6F3; break; // HANGUL SYLLABLE SSANGTIKEUT WI KIYEOKSIOS
    case 0x8D76: code_point = 0xB6F5; break; // HANGUL SYLLABLE SSANGTIKEUT WI NIEUNCIEUC
    case 0x8D77: code_point = 0xB6F6; break; // HANGUL SYLLABLE SSANGTIKEUT WI NIEUNHIEUH
    case 0x8D78: code_point = 0xB6F7; break; // HANGUL SYLLABLE SSANGTIKEUT WI TIKEUT
    case 0x8D79: code_point = 0xB6F9; break; // HANGUL SYLLABLE SSANGTIKEUT WI RIEULKIYEOK
    case 0x8D7A: code_point = 0xB6FA; break; // HANGUL SYLLABLE SSANGTIKEUT WI RIEULMIEUM
    case 0x8D81: code_point = 0xB6FB; break; // HANGUL SYLLABLE SSANGTIKEUT WI RIEULPIEUP
    case 0x8D82: code_point = 0xB6FC; break; // HANGUL SYLLABLE SSANGTIKEUT WI RIEULSIOS
    case 0x8D83: code_point = 0xB6FD; break; // HANGUL SYLLABLE SSANGTIKEUT WI RIEULTHIEUTH
    case 0x8D84: code_point = 0xB6FE; break; // HANGUL SYLLABLE SSANGTIKEUT WI RIEULPHIEUPH
    case 0x8D85: code_point = 0xB6FF; break; // HANGUL SYLLABLE SSANGTIKEUT WI RIEULHIEUH
    case 0x8D86: code_point = 0xB702; break; // HANGUL SYLLABLE SSANGTIKEUT WI PIEUPSIOS
    case 0x8D87: code_point = 0xB703; break; // HANGUL SYLLABLE SSANGTIKEUT WI SIOS
    case 0x8D88: code_point = 0xB704; break; // HANGUL SYLLABLE SSANGTIKEUT WI SSANGSIOS
    case 0x8D89: code_point = 0xB706; break; // HANGUL SYLLABLE SSANGTIKEUT WI CIEUC
    case 0x8D8A: code_point = 0xB707; break; // HANGUL SYLLABLE SSANGTIKEUT WI CHIEUCH
    case 0x8D8B: code_point = 0xB708; break; // HANGUL SYLLABLE SSANGTIKEUT WI KHIEUKH
    case 0x8D8C: code_point = 0xB709; break; // HANGUL SYLLABLE SSANGTIKEUT WI THIEUTH
    case 0x8D8D: code_point = 0xB70A; break; // HANGUL SYLLABLE SSANGTIKEUT WI PHIEUPH
    case 0x8D8E: code_point = 0xB70B; break; // HANGUL SYLLABLE SSANGTIKEUT WI HIEUH
    case 0x8D8F: code_point = 0xB70C; break; // HANGUL SYLLABLE SSANGTIKEUT YU
    case 0x8D90: code_point = 0xB70D; break; // HANGUL SYLLABLE SSANGTIKEUT YU KIYEOK
    case 0x8D91: code_point = 0xB70E; break; // HANGUL SYLLABLE SSANGTIKEUT YU SSANGKIYEOK
    case 0x8D92: code_point = 0xB70F; break; // HANGUL SYLLABLE SSANGTIKEUT YU KIYEOKSIOS
    case 0x8D93: code_point = 0xB710; break; // HANGUL SYLLABLE SSANGTIKEUT YU NIEUN
    case 0x8D94: code_point = 0xB711; break; // HANGUL SYLLABLE SSANGTIKEUT YU NIEUNCIEUC
    case 0x8D95: code_point = 0xB712; break; // HANGUL SYLLABLE SSANGTIKEUT YU NIEUNHIEUH
    case 0x8D96: code_point = 0xB713; break; // HANGUL SYLLABLE SSANGTIKEUT YU TIKEUT
    case 0x8D97: code_point = 0xB714; break; // HANGUL SYLLABLE SSANGTIKEUT YU RIEUL
    case 0x8D98: code_point = 0xB715; break; // HANGUL SYLLABLE SSANGTIKEUT YU RIEULKIYEOK
    case 0x8D99: code_point = 0xB716; break; // HANGUL SYLLABLE SSANGTIKEUT YU RIEULMIEUM
    case 0x8D9A: code_point = 0xB717; break; // HANGUL SYLLABLE SSANGTIKEUT YU RIEULPIEUP
    case 0x8D9B: code_point = 0xB718; break; // HANGUL SYLLABLE SSANGTIKEUT YU RIEULSIOS
    case 0x8D9C: code_point = 0xB719; break; // HANGUL SYLLABLE SSANGTIKEUT YU RIEULTHIEUTH
    case 0x8D9D: code_point = 0xB71A; break; // HANGUL SYLLABLE SSANGTIKEUT YU RIEULPHIEUPH
    case 0x8D9E: code_point = 0xB71B; break; // HANGUL SYLLABLE SSANGTIKEUT YU RIEULHIEUH
    case 0x8D9F: code_point = 0xB71C; break; // HANGUL SYLLABLE SSANGTIKEUT YU MIEUM
    case 0x8DA0: code_point = 0xB71D; break; // HANGUL SYLLABLE SSANGTIKEUT YU PIEUP
    case 0x8DA1: code_point = 0xB71E; break; // HANGUL SYLLABLE SSANGTIKEUT YU PIEUPSIOS
    case 0x8DA2: code_point = 0xB71F; break; // HANGUL SYLLABLE SSANGTIKEUT YU SIOS
    case 0x8DA3: code_point = 0xB720; break; // HANGUL SYLLABLE SSANGTIKEUT YU SSANGSIOS
    case 0x8DA4: code_point = 0xB721; break; // HANGUL SYLLABLE SSANGTIKEUT YU IEUNG
    case 0x8DA5: code_point = 0xB722; break; // HANGUL SYLLABLE SSANGTIKEUT YU CIEUC
    case 0x8DA6: code_point = 0xB723; break; // HANGUL SYLLABLE SSANGTIKEUT YU CHIEUCH
    case 0x8DA7: code_point = 0xB724; break; // HANGUL SYLLABLE SSANGTIKEUT YU KHIEUKH
    case 0x8DA8: code_point = 0xB725; break; // HANGUL SYLLABLE SSANGTIKEUT YU THIEUTH
    case 0x8DA9: code_point = 0xB726; break; // HANGUL SYLLABLE SSANGTIKEUT YU PHIEUPH
    case 0x8DAA: code_point = 0xB727; break; // HANGUL SYLLABLE SSANGTIKEUT YU HIEUH
    case 0x8DAB: code_point = 0xB72A; break; // HANGUL SYLLABLE SSANGTIKEUT EU SSANGKIYEOK
    case 0x8DAC: code_point = 0xB72B; break; // HANGUL SYLLABLE SSANGTIKEUT EU KIYEOKSIOS
    case 0x8DAD: code_point = 0xB72D; break; // HANGUL SYLLABLE SSANGTIKEUT EU NIEUNCIEUC
    case 0x8DAE: code_point = 0xB72E; break; // HANGUL SYLLABLE SSANGTIKEUT EU NIEUNHIEUH
    case 0x8DAF: code_point = 0xB731; break; // HANGUL SYLLABLE SSANGTIKEUT EU RIEULKIYEOK
    case 0x8DB0: code_point = 0xB732; break; // HANGUL SYLLABLE SSANGTIKEUT EU RIEULMIEUM
    case 0x8DB1: code_point = 0xB733; break; // HANGUL SYLLABLE SSANGTIKEUT EU RIEULPIEUP
    case 0x8DB2: code_point = 0xB734; break; // HANGUL SYLLABLE SSANGTIKEUT EU RIEULSIOS
    case 0x8DB3: code_point = 0xB735; break; // HANGUL SYLLABLE SSANGTIKEUT EU RIEULTHIEUTH
    case 0x8DB4: code_point = 0xB736; break; // HANGUL SYLLABLE SSANGTIKEUT EU RIEULPHIEUPH
    case 0x8DB5: code_point = 0xB737; break; // HANGUL SYLLABLE SSANGTIKEUT EU RIEULHIEUH
    case 0x8DB6: code_point = 0xB73A; break; // HANGUL SYLLABLE SSANGTIKEUT EU PIEUPSIOS
    case 0x8DB7: code_point = 0xB73C; break; // HANGUL SYLLABLE SSANGTIKEUT EU SSANGSIOS
    case 0x8DB8: code_point = 0xB73D; break; // HANGUL SYLLABLE SSANGTIKEUT EU IEUNG
    case 0x8DB9: code_point = 0xB73E; break; // HANGUL SYLLABLE SSANGTIKEUT EU CIEUC
    case 0x8DBA: code_point = 0xB73F; break; // HANGUL SYLLABLE SSANGTIKEUT EU CHIEUCH
    case 0x8DBB: code_point = 0xB740; break; // HANGUL SYLLABLE SSANGTIKEUT EU KHIEUKH
    case 0x8DBC: code_point = 0xB741; break; // HANGUL SYLLABLE SSANGTIKEUT EU THIEUTH
    case 0x8DBD: code_point = 0xB742; break; // HANGUL SYLLABLE SSANGTIKEUT EU PHIEUPH
    case 0x8DBE: code_point = 0xB743; break; // HANGUL SYLLABLE SSANGTIKEUT EU HIEUH
    case 0x8DBF: code_point = 0xB745; break; // HANGUL SYLLABLE SSANGTIKEUT YI KIYEOK
    case 0x8DC0: code_point = 0xB746; break; // HANGUL SYLLABLE SSANGTIKEUT YI SSANGKIYEOK
    case 0x8DC1: code_point = 0xB747; break; // HANGUL SYLLABLE SSANGTIKEUT YI KIYEOKSIOS
    case 0x8DC2: code_point = 0xB749; break; // HANGUL SYLLABLE SSANGTIKEUT YI NIEUNCIEUC
    case 0x8DC3: code_point = 0xB74A; break; // HANGUL SYLLABLE SSANGTIKEUT YI NIEUNHIEUH
    case 0x8DC4: code_point = 0xB74B; break; // HANGUL SYLLABLE SSANGTIKEUT YI TIKEUT
    case 0x8DC5: code_point = 0xB74D; break; // HANGUL SYLLABLE SSANGTIKEUT YI RIEULKIYEOK
    case 0x8DC6: code_point = 0xB74E; break; // HANGUL SYLLABLE SSANGTIKEUT YI RIEULMIEUM
    case 0x8DC7: code_point = 0xB74F; break; // HANGUL SYLLABLE SSANGTIKEUT YI RIEULPIEUP
    case 0x8DC8: code_point = 0xB750; break; // HANGUL SYLLABLE SSANGTIKEUT YI RIEULSIOS
    case 0x8DC9: code_point = 0xB751; break; // HANGUL SYLLABLE SSANGTIKEUT YI RIEULTHIEUTH
    case 0x8DCA: code_point = 0xB752; break; // HANGUL SYLLABLE SSANGTIKEUT YI RIEULPHIEUPH
    case 0x8DCB: code_point = 0xB753; break; // HANGUL SYLLABLE SSANGTIKEUT YI RIEULHIEUH
    case 0x8DCC: code_point = 0xB756; break; // HANGUL SYLLABLE SSANGTIKEUT YI PIEUPSIOS
    case 0x8DCD: code_point = 0xB757; break; // HANGUL SYLLABLE SSANGTIKEUT YI SIOS
    case 0x8DCE: code_point = 0xB758; break; // HANGUL SYLLABLE SSANGTIKEUT YI SSANGSIOS
    case 0x8DCF: code_point = 0xB759; break; // HANGUL SYLLABLE SSANGTIKEUT YI IEUNG
    case 0x8DD0: code_point = 0xB75A; break; // HANGUL SYLLABLE SSANGTIKEUT YI CIEUC
    case 0x8DD1: code_point = 0xB75B; break; // HANGUL SYLLABLE SSANGTIKEUT YI CHIEUCH
    case 0x8DD2: code_point = 0xB75C; break; // HANGUL SYLLABLE SSANGTIKEUT YI KHIEUKH
    case 0x8DD3: code_point = 0xB75D; break; // HANGUL SYLLABLE SSANGTIKEUT YI THIEUTH
    case 0x8DD4: code_point = 0xB75E; break; // HANGUL SYLLABLE SSANGTIKEUT YI PHIEUPH
    case 0x8DD5: code_point = 0xB75F; break; // HANGUL SYLLABLE SSANGTIKEUT YI HIEUH
    case 0x8DD6: code_point = 0xB761; break; // HANGUL SYLLABLE SSANGTIKEUT I KIYEOK
    case 0x8DD7: code_point = 0xB762; break; // HANGUL SYLLABLE SSANGTIKEUT I SSANGKIYEOK
    case 0x8DD8: code_point = 0xB763; break; // HANGUL SYLLABLE SSANGTIKEUT I KIYEOKSIOS
    case 0x8DD9: code_point = 0xB765; break; // HANGUL SYLLABLE SSANGTIKEUT I NIEUNCIEUC
    case 0x8DDA: code_point = 0xB766; break; // HANGUL SYLLABLE SSANGTIKEUT I NIEUNHIEUH
    case 0x8DDB: code_point = 0xB767; break; // HANGUL SYLLABLE SSANGTIKEUT I TIKEUT
    case 0x8DDC: code_point = 0xB769; break; // HANGUL SYLLABLE SSANGTIKEUT I RIEULKIYEOK
    case 0x8DDD: code_point = 0xB76A; break; // HANGUL SYLLABLE SSANGTIKEUT I RIEULMIEUM
    case 0x8DDE: code_point = 0xB76B; break; // HANGUL SYLLABLE SSANGTIKEUT I RIEULPIEUP
    case 0x8DDF: code_point = 0xB76C; break; // HANGUL SYLLABLE SSANGTIKEUT I RIEULSIOS
    case 0x8DE0: code_point = 0xB76D; break; // HANGUL SYLLABLE SSANGTIKEUT I RIEULTHIEUTH
    case 0x8DE1: code_point = 0xB76E; break; // HANGUL SYLLABLE SSANGTIKEUT I RIEULPHIEUPH
    case 0x8DE2: code_point = 0xB76F; break; // HANGUL SYLLABLE SSANGTIKEUT I RIEULHIEUH
    case 0x8DE3: code_point = 0xB772; break; // HANGUL SYLLABLE SSANGTIKEUT I PIEUPSIOS
    case 0x8DE4: code_point = 0xB774; break; // HANGUL SYLLABLE SSANGTIKEUT I SSANGSIOS
    case 0x8DE5: code_point = 0xB776; break; // HANGUL SYLLABLE SSANGTIKEUT I CIEUC
    case 0x8DE6: code_point = 0xB777; break; // HANGUL SYLLABLE SSANGTIKEUT I CHIEUCH
    case 0x8DE7: code_point = 0xB778; break; // HANGUL SYLLABLE SSANGTIKEUT I KHIEUKH
    case 0x8DE8: code_point = 0xB779; break; // HANGUL SYLLABLE SSANGTIKEUT I THIEUTH
    case 0x8DE9: code_point = 0xB77A; break; // HANGUL SYLLABLE SSANGTIKEUT I PHIEUPH
    case 0x8DEA: code_point = 0xB77B; break; // HANGUL SYLLABLE SSANGTIKEUT I HIEUH
    case 0x8DEB: code_point = 0xB77E; break; // HANGUL SYLLABLE RIEUL A SSANGKIYEOK
    case 0x8DEC: code_point = 0xB77F; break; // HANGUL SYLLABLE RIEUL A KIYEOKSIOS
    case 0x8DED: code_point = 0xB781; break; // HANGUL SYLLABLE RIEUL A NIEUNCIEUC
    case 0x8DEE: code_point = 0xB782; break; // HANGUL SYLLABLE RIEUL A NIEUNHIEUH
    case 0x8DEF: code_point = 0xB783; break; // HANGUL SYLLABLE RIEUL A TIKEUT
    case 0x8DF0: code_point = 0xB785; break; // HANGUL SYLLABLE RIEUL A RIEULKIYEOK
    case 0x8DF1: code_point = 0xB786; break; // HANGUL SYLLABLE RIEUL A RIEULMIEUM
    case 0x8DF2: code_point = 0xB787; break; // HANGUL SYLLABLE RIEUL A RIEULPIEUP
    case 0x8DF3: code_point = 0xB788; break; // HANGUL SYLLABLE RIEUL A RIEULSIOS
    case 0x8DF4: code_point = 0xB789; break; // HANGUL SYLLABLE RIEUL A RIEULTHIEUTH
    case 0x8DF5: code_point = 0xB78A; break; // HANGUL SYLLABLE RIEUL A RIEULPHIEUPH
    case 0x8DF6: code_point = 0xB78B; break; // HANGUL SYLLABLE RIEUL A RIEULHIEUH
    case 0x8DF7: code_point = 0xB78E; break; // HANGUL SYLLABLE RIEUL A PIEUPSIOS
    case 0x8DF8: code_point = 0xB793; break; // HANGUL SYLLABLE RIEUL A CHIEUCH
    case 0x8DF9: code_point = 0xB794; break; // HANGUL SYLLABLE RIEUL A KHIEUKH
    case 0x8DFA: code_point = 0xB795; break; // HANGUL SYLLABLE RIEUL A THIEUTH
    case 0x8DFB: code_point = 0xB79A; break; // HANGUL SYLLABLE RIEUL AE SSANGKIYEOK
    case 0x8DFC: code_point = 0xB79B; break; // HANGUL SYLLABLE RIEUL AE KIYEOKSIOS
    case 0x8DFD: code_point = 0xB79D; break; // HANGUL SYLLABLE RIEUL AE NIEUNCIEUC
    case 0x8DFE: code_point = 0xB79E; break; // HANGUL SYLLABLE RIEUL AE NIEUNHIEUH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x8E(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8E41: code_point = 0xB79F; break; // HANGUL SYLLABLE RIEUL AE TIKEUT
    case 0x8E42: code_point = 0xB7A1; break; // HANGUL SYLLABLE RIEUL AE RIEULKIYEOK
    case 0x8E43: code_point = 0xB7A2; break; // HANGUL SYLLABLE RIEUL AE RIEULMIEUM
    case 0x8E44: code_point = 0xB7A3; break; // HANGUL SYLLABLE RIEUL AE RIEULPIEUP
    case 0x8E45: code_point = 0xB7A4; break; // HANGUL SYLLABLE RIEUL AE RIEULSIOS
    case 0x8E46: code_point = 0xB7A5; break; // HANGUL SYLLABLE RIEUL AE RIEULTHIEUTH
    case 0x8E47: code_point = 0xB7A6; break; // HANGUL SYLLABLE RIEUL AE RIEULPHIEUPH
    case 0x8E48: code_point = 0xB7A7; break; // HANGUL SYLLABLE RIEUL AE RIEULHIEUH
    case 0x8E49: code_point = 0xB7AA; break; // HANGUL SYLLABLE RIEUL AE PIEUPSIOS
    case 0x8E4A: code_point = 0xB7AE; break; // HANGUL SYLLABLE RIEUL AE CIEUC
    case 0x8E4B: code_point = 0xB7AF; break; // HANGUL SYLLABLE RIEUL AE CHIEUCH
    case 0x8E4C: code_point = 0xB7B0; break; // HANGUL SYLLABLE RIEUL AE KHIEUKH
    case 0x8E4D: code_point = 0xB7B1; break; // HANGUL SYLLABLE RIEUL AE THIEUTH
    case 0x8E4E: code_point = 0xB7B2; break; // HANGUL SYLLABLE RIEUL AE PHIEUPH
    case 0x8E4F: code_point = 0xB7B3; break; // HANGUL SYLLABLE RIEUL AE HIEUH
    case 0x8E50: code_point = 0xB7B6; break; // HANGUL SYLLABLE RIEUL YA SSANGKIYEOK
    case 0x8E51: code_point = 0xB7B7; break; // HANGUL SYLLABLE RIEUL YA KIYEOKSIOS
    case 0x8E52: code_point = 0xB7B9; break; // HANGUL SYLLABLE RIEUL YA NIEUNCIEUC
    case 0x8E53: code_point = 0xB7BA; break; // HANGUL SYLLABLE RIEUL YA NIEUNHIEUH
    case 0x8E54: code_point = 0xB7BB; break; // HANGUL SYLLABLE RIEUL YA TIKEUT
    case 0x8E55: code_point = 0xB7BC; break; // HANGUL SYLLABLE RIEUL YA RIEUL
    case 0x8E56: code_point = 0xB7BD; break; // HANGUL SYLLABLE RIEUL YA RIEULKIYEOK
    case 0x8E57: code_point = 0xB7BE; break; // HANGUL SYLLABLE RIEUL YA RIEULMIEUM
    case 0x8E58: code_point = 0xB7BF; break; // HANGUL SYLLABLE RIEUL YA RIEULPIEUP
    case 0x8E59: code_point = 0xB7C0; break; // HANGUL SYLLABLE RIEUL YA RIEULSIOS
    case 0x8E5A: code_point = 0xB7C1; break; // HANGUL SYLLABLE RIEUL YA RIEULTHIEUTH
    case 0x8E61: code_point = 0xB7C2; break; // HANGUL SYLLABLE RIEUL YA RIEULPHIEUPH
    case 0x8E62: code_point = 0xB7C3; break; // HANGUL SYLLABLE RIEUL YA RIEULHIEUH
    case 0x8E63: code_point = 0xB7C4; break; // HANGUL SYLLABLE RIEUL YA MIEUM
    case 0x8E64: code_point = 0xB7C5; break; // HANGUL SYLLABLE RIEUL YA PIEUP
    case 0x8E65: code_point = 0xB7C6; break; // HANGUL SYLLABLE RIEUL YA PIEUPSIOS
    case 0x8E66: code_point = 0xB7C8; break; // HANGUL SYLLABLE RIEUL YA SSANGSIOS
    case 0x8E67: code_point = 0xB7CA; break; // HANGUL SYLLABLE RIEUL YA CIEUC
    case 0x8E68: code_point = 0xB7CB; break; // HANGUL SYLLABLE RIEUL YA CHIEUCH
    case 0x8E69: code_point = 0xB7CC; break; // HANGUL SYLLABLE RIEUL YA KHIEUKH
    case 0x8E6A: code_point = 0xB7CD; break; // HANGUL SYLLABLE RIEUL YA THIEUTH
    case 0x8E6B: code_point = 0xB7CE; break; // HANGUL SYLLABLE RIEUL YA PHIEUPH
    case 0x8E6C: code_point = 0xB7CF; break; // HANGUL SYLLABLE RIEUL YA HIEUH
    case 0x8E6D: code_point = 0xB7D0; break; // HANGUL SYLLABLE RIEUL YAE
    case 0x8E6E: code_point = 0xB7D1; break; // HANGUL SYLLABLE RIEUL YAE KIYEOK
    case 0x8E6F: code_point = 0xB7D2; break; // HANGUL SYLLABLE RIEUL YAE SSANGKIYEOK
    case 0x8E70: code_point = 0xB7D3; break; // HANGUL SYLLABLE RIEUL YAE KIYEOKSIOS
    case 0x8E71: code_point = 0xB7D4; break; // HANGUL SYLLABLE RIEUL YAE NIEUN
    case 0x8E72: code_point = 0xB7D5; break; // HANGUL SYLLABLE RIEUL YAE NIEUNCIEUC
    case 0x8E73: code_point = 0xB7D6; break; // HANGUL SYLLABLE RIEUL YAE NIEUNHIEUH
    case 0x8E74: code_point = 0xB7D7; break; // HANGUL SYLLABLE RIEUL YAE TIKEUT
    case 0x8E75: code_point = 0xB7D8; break; // HANGUL SYLLABLE RIEUL YAE RIEUL
    case 0x8E76: code_point = 0xB7D9; break; // HANGUL SYLLABLE RIEUL YAE RIEULKIYEOK
    case 0x8E77: code_point = 0xB7DA; break; // HANGUL SYLLABLE RIEUL YAE RIEULMIEUM
    case 0x8E78: code_point = 0xB7DB; break; // HANGUL SYLLABLE RIEUL YAE RIEULPIEUP
    case 0x8E79: code_point = 0xB7DC; break; // HANGUL SYLLABLE RIEUL YAE RIEULSIOS
    case 0x8E7A: code_point = 0xB7DD; break; // HANGUL SYLLABLE RIEUL YAE RIEULTHIEUTH
    case 0x8E81: code_point = 0xB7DE; break; // HANGUL SYLLABLE RIEUL YAE RIEULPHIEUPH
    case 0x8E82: code_point = 0xB7DF; break; // HANGUL SYLLABLE RIEUL YAE RIEULHIEUH
    case 0x8E83: code_point = 0xB7E0; break; // HANGUL SYLLABLE RIEUL YAE MIEUM
    case 0x8E84: code_point = 0xB7E1; break; // HANGUL SYLLABLE RIEUL YAE PIEUP
    case 0x8E85: code_point = 0xB7E2; break; // HANGUL SYLLABLE RIEUL YAE PIEUPSIOS
    case 0x8E86: code_point = 0xB7E3; break; // HANGUL SYLLABLE RIEUL YAE SIOS
    case 0x8E87: code_point = 0xB7E4; break; // HANGUL SYLLABLE RIEUL YAE SSANGSIOS
    case 0x8E88: code_point = 0xB7E5; break; // HANGUL SYLLABLE RIEUL YAE IEUNG
    case 0x8E89: code_point = 0xB7E6; break; // HANGUL SYLLABLE RIEUL YAE CIEUC
    case 0x8E8A: code_point = 0xB7E7; break; // HANGUL SYLLABLE RIEUL YAE CHIEUCH
    case 0x8E8B: code_point = 0xB7E8; break; // HANGUL SYLLABLE RIEUL YAE KHIEUKH
    case 0x8E8C: code_point = 0xB7E9; break; // HANGUL SYLLABLE RIEUL YAE THIEUTH
    case 0x8E8D: code_point = 0xB7EA; break; // HANGUL SYLLABLE RIEUL YAE PHIEUPH
    case 0x8E8E: code_point = 0xB7EB; break; // HANGUL SYLLABLE RIEUL YAE HIEUH
    case 0x8E8F: code_point = 0xB7EE; break; // HANGUL SYLLABLE RIEUL EO SSANGKIYEOK
    case 0x8E90: code_point = 0xB7EF; break; // HANGUL SYLLABLE RIEUL EO KIYEOKSIOS
    case 0x8E91: code_point = 0xB7F1; break; // HANGUL SYLLABLE RIEUL EO NIEUNCIEUC
    case 0x8E92: code_point = 0xB7F2; break; // HANGUL SYLLABLE RIEUL EO NIEUNHIEUH
    case 0x8E93: code_point = 0xB7F3; break; // HANGUL SYLLABLE RIEUL EO TIKEUT
    case 0x8E94: code_point = 0xB7F5; break; // HANGUL SYLLABLE RIEUL EO RIEULKIYEOK
    case 0x8E95: code_point = 0xB7F6; break; // HANGUL SYLLABLE RIEUL EO RIEULMIEUM
    case 0x8E96: code_point = 0xB7F7; break; // HANGUL SYLLABLE RIEUL EO RIEULPIEUP
    case 0x8E97: code_point = 0xB7F8; break; // HANGUL SYLLABLE RIEUL EO RIEULSIOS
    case 0x8E98: code_point = 0xB7F9; break; // HANGUL SYLLABLE RIEUL EO RIEULTHIEUTH
    case 0x8E99: code_point = 0xB7FA; break; // HANGUL SYLLABLE RIEUL EO RIEULPHIEUPH
    case 0x8E9A: code_point = 0xB7FB; break; // HANGUL SYLLABLE RIEUL EO RIEULHIEUH
    case 0x8E9B: code_point = 0xB7FE; break; // HANGUL SYLLABLE RIEUL EO PIEUPSIOS
    case 0x8E9C: code_point = 0xB802; break; // HANGUL SYLLABLE RIEUL EO CIEUC
    case 0x8E9D: code_point = 0xB803; break; // HANGUL SYLLABLE RIEUL EO CHIEUCH
    case 0x8E9E: code_point = 0xB804; break; // HANGUL SYLLABLE RIEUL EO KHIEUKH
    case 0x8E9F: code_point = 0xB805; break; // HANGUL SYLLABLE RIEUL EO THIEUTH
    case 0x8EA0: code_point = 0xB806; break; // HANGUL SYLLABLE RIEUL EO PHIEUPH
    case 0x8EA1: code_point = 0xB80A; break; // HANGUL SYLLABLE RIEUL E SSANGKIYEOK
    case 0x8EA2: code_point = 0xB80B; break; // HANGUL SYLLABLE RIEUL E KIYEOKSIOS
    case 0x8EA3: code_point = 0xB80D; break; // HANGUL SYLLABLE RIEUL E NIEUNCIEUC
    case 0x8EA4: code_point = 0xB80E; break; // HANGUL SYLLABLE RIEUL E NIEUNHIEUH
    case 0x8EA5: code_point = 0xB80F; break; // HANGUL SYLLABLE RIEUL E TIKEUT
    case 0x8EA6: code_point = 0xB811; break; // HANGUL SYLLABLE RIEUL E RIEULKIYEOK
    case 0x8EA7: code_point = 0xB812; break; // HANGUL SYLLABLE RIEUL E RIEULMIEUM
    case 0x8EA8: code_point = 0xB813; break; // HANGUL SYLLABLE RIEUL E RIEULPIEUP
    case 0x8EA9: code_point = 0xB814; break; // HANGUL SYLLABLE RIEUL E RIEULSIOS
    case 0x8EAA: code_point = 0xB815; break; // HANGUL SYLLABLE RIEUL E RIEULTHIEUTH
    case 0x8EAB: code_point = 0xB816; break; // HANGUL SYLLABLE RIEUL E RIEULPHIEUPH
    case 0x8EAC: code_point = 0xB817; break; // HANGUL SYLLABLE RIEUL E RIEULHIEUH
    case 0x8EAD: code_point = 0xB81A; break; // HANGUL SYLLABLE RIEUL E PIEUPSIOS
    case 0x8EAE: code_point = 0xB81C; break; // HANGUL SYLLABLE RIEUL E SSANGSIOS
    case 0x8EAF: code_point = 0xB81E; break; // HANGUL SYLLABLE RIEUL E CIEUC
    case 0x8EB0: code_point = 0xB81F; break; // HANGUL SYLLABLE RIEUL E CHIEUCH
    case 0x8EB1: code_point = 0xB820; break; // HANGUL SYLLABLE RIEUL E KHIEUKH
    case 0x8EB2: code_point = 0xB821; break; // HANGUL SYLLABLE RIEUL E THIEUTH
    case 0x8EB3: code_point = 0xB822; break; // HANGUL SYLLABLE RIEUL E PHIEUPH
    case 0x8EB4: code_point = 0xB823; break; // HANGUL SYLLABLE RIEUL E HIEUH
    case 0x8EB5: code_point = 0xB826; break; // HANGUL SYLLABLE RIEUL YEO SSANGKIYEOK
    case 0x8EB6: code_point = 0xB827; break; // HANGUL SYLLABLE RIEUL YEO KIYEOKSIOS
    case 0x8EB7: code_point = 0xB829; break; // HANGUL SYLLABLE RIEUL YEO NIEUNCIEUC
    case 0x8EB8: code_point = 0xB82A; break; // HANGUL SYLLABLE RIEUL YEO NIEUNHIEUH
    case 0x8EB9: code_point = 0xB82B; break; // HANGUL SYLLABLE RIEUL YEO TIKEUT
    case 0x8EBA: code_point = 0xB82D; break; // HANGUL SYLLABLE RIEUL YEO RIEULKIYEOK
    case 0x8EBB: code_point = 0xB82E; break; // HANGUL SYLLABLE RIEUL YEO RIEULMIEUM
    case 0x8EBC: code_point = 0xB82F; break; // HANGUL SYLLABLE RIEUL YEO RIEULPIEUP
    case 0x8EBD: code_point = 0xB830; break; // HANGUL SYLLABLE RIEUL YEO RIEULSIOS
    case 0x8EBE: code_point = 0xB831; break; // HANGUL SYLLABLE RIEUL YEO RIEULTHIEUTH
    case 0x8EBF: code_point = 0xB832; break; // HANGUL SYLLABLE RIEUL YEO RIEULPHIEUPH
    case 0x8EC0: code_point = 0xB833; break; // HANGUL SYLLABLE RIEUL YEO RIEULHIEUH
    case 0x8EC1: code_point = 0xB836; break; // HANGUL SYLLABLE RIEUL YEO PIEUPSIOS
    case 0x8EC2: code_point = 0xB83A; break; // HANGUL SYLLABLE RIEUL YEO CIEUC
    case 0x8EC3: code_point = 0xB83B; break; // HANGUL SYLLABLE RIEUL YEO CHIEUCH
    case 0x8EC4: code_point = 0xB83C; break; // HANGUL SYLLABLE RIEUL YEO KHIEUKH
    case 0x8EC5: code_point = 0xB83D; break; // HANGUL SYLLABLE RIEUL YEO THIEUTH
    case 0x8EC6: code_point = 0xB83E; break; // HANGUL SYLLABLE RIEUL YEO PHIEUPH
    case 0x8EC7: code_point = 0xB83F; break; // HANGUL SYLLABLE RIEUL YEO HIEUH
    case 0x8EC8: code_point = 0xB841; break; // HANGUL SYLLABLE RIEUL YE KIYEOK
    case 0x8EC9: code_point = 0xB842; break; // HANGUL SYLLABLE RIEUL YE SSANGKIYEOK
    case 0x8ECA: code_point = 0xB843; break; // HANGUL SYLLABLE RIEUL YE KIYEOKSIOS
    case 0x8ECB: code_point = 0xB845; break; // HANGUL SYLLABLE RIEUL YE NIEUNCIEUC
    case 0x8ECC: code_point = 0xB846; break; // HANGUL SYLLABLE RIEUL YE NIEUNHIEUH
    case 0x8ECD: code_point = 0xB847; break; // HANGUL SYLLABLE RIEUL YE TIKEUT
    case 0x8ECE: code_point = 0xB848; break; // HANGUL SYLLABLE RIEUL YE RIEUL
    case 0x8ECF: code_point = 0xB849; break; // HANGUL SYLLABLE RIEUL YE RIEULKIYEOK
    case 0x8ED0: code_point = 0xB84A; break; // HANGUL SYLLABLE RIEUL YE RIEULMIEUM
    case 0x8ED1: code_point = 0xB84B; break; // HANGUL SYLLABLE RIEUL YE RIEULPIEUP
    case 0x8ED2: code_point = 0xB84C; break; // HANGUL SYLLABLE RIEUL YE RIEULSIOS
    case 0x8ED3: code_point = 0xB84D; break; // HANGUL SYLLABLE RIEUL YE RIEULTHIEUTH
    case 0x8ED4: code_point = 0xB84E; break; // HANGUL SYLLABLE RIEUL YE RIEULPHIEUPH
    case 0x8ED5: code_point = 0xB84F; break; // HANGUL SYLLABLE RIEUL YE RIEULHIEUH
    case 0x8ED6: code_point = 0xB850; break; // HANGUL SYLLABLE RIEUL YE MIEUM
    case 0x8ED7: code_point = 0xB852; break; // HANGUL SYLLABLE RIEUL YE PIEUPSIOS
    case 0x8ED8: code_point = 0xB854; break; // HANGUL SYLLABLE RIEUL YE SSANGSIOS
    case 0x8ED9: code_point = 0xB855; break; // HANGUL SYLLABLE RIEUL YE IEUNG
    case 0x8EDA: code_point = 0xB856; break; // HANGUL SYLLABLE RIEUL YE CIEUC
    case 0x8EDB: code_point = 0xB857; break; // HANGUL SYLLABLE RIEUL YE CHIEUCH
    case 0x8EDC: code_point = 0xB858; break; // HANGUL SYLLABLE RIEUL YE KHIEUKH
    case 0x8EDD: code_point = 0xB859; break; // HANGUL SYLLABLE RIEUL YE THIEUTH
    case 0x8EDE: code_point = 0xB85A; break; // HANGUL SYLLABLE RIEUL YE PHIEUPH
    case 0x8EDF: code_point = 0xB85B; break; // HANGUL SYLLABLE RIEUL YE HIEUH
    case 0x8EE0: code_point = 0xB85E; break; // HANGUL SYLLABLE RIEUL O SSANGKIYEOK
    case 0x8EE1: code_point = 0xB85F; break; // HANGUL SYLLABLE RIEUL O KIYEOKSIOS
    case 0x8EE2: code_point = 0xB861; break; // HANGUL SYLLABLE RIEUL O NIEUNCIEUC
    case 0x8EE3: code_point = 0xB862; break; // HANGUL SYLLABLE RIEUL O NIEUNHIEUH
    case 0x8EE4: code_point = 0xB863; break; // HANGUL SYLLABLE RIEUL O TIKEUT
    case 0x8EE5: code_point = 0xB865; break; // HANGUL SYLLABLE RIEUL O RIEULKIYEOK
    case 0x8EE6: code_point = 0xB866; break; // HANGUL SYLLABLE RIEUL O RIEULMIEUM
    case 0x8EE7: code_point = 0xB867; break; // HANGUL SYLLABLE RIEUL O RIEULPIEUP
    case 0x8EE8: code_point = 0xB868; break; // HANGUL SYLLABLE RIEUL O RIEULSIOS
    case 0x8EE9: code_point = 0xB869; break; // HANGUL SYLLABLE RIEUL O RIEULTHIEUTH
    case 0x8EEA: code_point = 0xB86A; break; // HANGUL SYLLABLE RIEUL O RIEULPHIEUPH
    case 0x8EEB: code_point = 0xB86B; break; // HANGUL SYLLABLE RIEUL O RIEULHIEUH
    case 0x8EEC: code_point = 0xB86E; break; // HANGUL SYLLABLE RIEUL O PIEUPSIOS
    case 0x8EED: code_point = 0xB870; break; // HANGUL SYLLABLE RIEUL O SSANGSIOS
    case 0x8EEE: code_point = 0xB872; break; // HANGUL SYLLABLE RIEUL O CIEUC
    case 0x8EEF: code_point = 0xB873; break; // HANGUL SYLLABLE RIEUL O CHIEUCH
    case 0x8EF0: code_point = 0xB874; break; // HANGUL SYLLABLE RIEUL O KHIEUKH
    case 0x8EF1: code_point = 0xB875; break; // HANGUL SYLLABLE RIEUL O THIEUTH
    case 0x8EF2: code_point = 0xB876; break; // HANGUL SYLLABLE RIEUL O PHIEUPH
    case 0x8EF3: code_point = 0xB877; break; // HANGUL SYLLABLE RIEUL O HIEUH
    case 0x8EF4: code_point = 0xB879; break; // HANGUL SYLLABLE RIEUL WA KIYEOK
    case 0x8EF5: code_point = 0xB87A; break; // HANGUL SYLLABLE RIEUL WA SSANGKIYEOK
    case 0x8EF6: code_point = 0xB87B; break; // HANGUL SYLLABLE RIEUL WA KIYEOKSIOS
    case 0x8EF7: code_point = 0xB87D; break; // HANGUL SYLLABLE RIEUL WA NIEUNCIEUC
    case 0x8EF8: code_point = 0xB87E; break; // HANGUL SYLLABLE RIEUL WA NIEUNHIEUH
    case 0x8EF9: code_point = 0xB87F; break; // HANGUL SYLLABLE RIEUL WA TIKEUT
    case 0x8EFA: code_point = 0xB880; break; // HANGUL SYLLABLE RIEUL WA RIEUL
    case 0x8EFB: code_point = 0xB881; break; // HANGUL SYLLABLE RIEUL WA RIEULKIYEOK
    case 0x8EFC: code_point = 0xB882; break; // HANGUL SYLLABLE RIEUL WA RIEULMIEUM
    case 0x8EFD: code_point = 0xB883; break; // HANGUL SYLLABLE RIEUL WA RIEULPIEUP
    case 0x8EFE: code_point = 0xB884; break; // HANGUL SYLLABLE RIEUL WA RIEULSIOS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x8F(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x8F41: code_point = 0xB885; break; // HANGUL SYLLABLE RIEUL WA RIEULTHIEUTH
    case 0x8F42: code_point = 0xB886; break; // HANGUL SYLLABLE RIEUL WA RIEULPHIEUPH
    case 0x8F43: code_point = 0xB887; break; // HANGUL SYLLABLE RIEUL WA RIEULHIEUH
    case 0x8F44: code_point = 0xB888; break; // HANGUL SYLLABLE RIEUL WA MIEUM
    case 0x8F45: code_point = 0xB889; break; // HANGUL SYLLABLE RIEUL WA PIEUP
    case 0x8F46: code_point = 0xB88A; break; // HANGUL SYLLABLE RIEUL WA PIEUPSIOS
    case 0x8F47: code_point = 0xB88B; break; // HANGUL SYLLABLE RIEUL WA SIOS
    case 0x8F48: code_point = 0xB88C; break; // HANGUL SYLLABLE RIEUL WA SSANGSIOS
    case 0x8F49: code_point = 0xB88E; break; // HANGUL SYLLABLE RIEUL WA CIEUC
    case 0x8F4A: code_point = 0xB88F; break; // HANGUL SYLLABLE RIEUL WA CHIEUCH
    case 0x8F4B: code_point = 0xB890; break; // HANGUL SYLLABLE RIEUL WA KHIEUKH
    case 0x8F4C: code_point = 0xB891; break; // HANGUL SYLLABLE RIEUL WA THIEUTH
    case 0x8F4D: code_point = 0xB892; break; // HANGUL SYLLABLE RIEUL WA PHIEUPH
    case 0x8F4E: code_point = 0xB893; break; // HANGUL SYLLABLE RIEUL WA HIEUH
    case 0x8F4F: code_point = 0xB894; break; // HANGUL SYLLABLE RIEUL WAE
    case 0x8F50: code_point = 0xB895; break; // HANGUL SYLLABLE RIEUL WAE KIYEOK
    case 0x8F51: code_point = 0xB896; break; // HANGUL SYLLABLE RIEUL WAE SSANGKIYEOK
    case 0x8F52: code_point = 0xB897; break; // HANGUL SYLLABLE RIEUL WAE KIYEOKSIOS
    case 0x8F53: code_point = 0xB898; break; // HANGUL SYLLABLE RIEUL WAE NIEUN
    case 0x8F54: code_point = 0xB899; break; // HANGUL SYLLABLE RIEUL WAE NIEUNCIEUC
    case 0x8F55: code_point = 0xB89A; break; // HANGUL SYLLABLE RIEUL WAE NIEUNHIEUH
    case 0x8F56: code_point = 0xB89B; break; // HANGUL SYLLABLE RIEUL WAE TIKEUT
    case 0x8F57: code_point = 0xB89C; break; // HANGUL SYLLABLE RIEUL WAE RIEUL
    case 0x8F58: code_point = 0xB89D; break; // HANGUL SYLLABLE RIEUL WAE RIEULKIYEOK
    case 0x8F59: code_point = 0xB89E; break; // HANGUL SYLLABLE RIEUL WAE RIEULMIEUM
    case 0x8F5A: code_point = 0xB89F; break; // HANGUL SYLLABLE RIEUL WAE RIEULPIEUP
    case 0x8F61: code_point = 0xB8A0; break; // HANGUL SYLLABLE RIEUL WAE RIEULSIOS
    case 0x8F62: code_point = 0xB8A1; break; // HANGUL SYLLABLE RIEUL WAE RIEULTHIEUTH
    case 0x8F63: code_point = 0xB8A2; break; // HANGUL SYLLABLE RIEUL WAE RIEULPHIEUPH
    case 0x8F64: code_point = 0xB8A3; break; // HANGUL SYLLABLE RIEUL WAE RIEULHIEUH
    case 0x8F65: code_point = 0xB8A4; break; // HANGUL SYLLABLE RIEUL WAE MIEUM
    case 0x8F66: code_point = 0xB8A5; break; // HANGUL SYLLABLE RIEUL WAE PIEUP
    case 0x8F67: code_point = 0xB8A6; break; // HANGUL SYLLABLE RIEUL WAE PIEUPSIOS
    case 0x8F68: code_point = 0xB8A7; break; // HANGUL SYLLABLE RIEUL WAE SIOS
    case 0x8F69: code_point = 0xB8A9; break; // HANGUL SYLLABLE RIEUL WAE IEUNG
    case 0x8F6A: code_point = 0xB8AA; break; // HANGUL SYLLABLE RIEUL WAE CIEUC
    case 0x8F6B: code_point = 0xB8AB; break; // HANGUL SYLLABLE RIEUL WAE CHIEUCH
    case 0x8F6C: code_point = 0xB8AC; break; // HANGUL SYLLABLE RIEUL WAE KHIEUKH
    case 0x8F6D: code_point = 0xB8AD; break; // HANGUL SYLLABLE RIEUL WAE THIEUTH
    case 0x8F6E: code_point = 0xB8AE; break; // HANGUL SYLLABLE RIEUL WAE PHIEUPH
    case 0x8F6F: code_point = 0xB8AF; break; // HANGUL SYLLABLE RIEUL WAE HIEUH
    case 0x8F70: code_point = 0xB8B1; break; // HANGUL SYLLABLE RIEUL OE KIYEOK
    case 0x8F71: code_point = 0xB8B2; break; // HANGUL SYLLABLE RIEUL OE SSANGKIYEOK
    case 0x8F72: code_point = 0xB8B3; break; // HANGUL SYLLABLE RIEUL OE KIYEOKSIOS
    case 0x8F73: code_point = 0xB8B5; break; // HANGUL SYLLABLE RIEUL OE NIEUNCIEUC
    case 0x8F74: code_point = 0xB8B6; break; // HANGUL SYLLABLE RIEUL OE NIEUNHIEUH
    case 0x8F75: code_point = 0xB8B7; break; // HANGUL SYLLABLE RIEUL OE TIKEUT
    case 0x8F76: code_point = 0xB8B9; break; // HANGUL SYLLABLE RIEUL OE RIEULKIYEOK
    case 0x8F77: code_point = 0xB8BA; break; // HANGUL SYLLABLE RIEUL OE RIEULMIEUM
    case 0x8F78: code_point = 0xB8BB; break; // HANGUL SYLLABLE RIEUL OE RIEULPIEUP
    case 0x8F79: code_point = 0xB8BC; break; // HANGUL SYLLABLE RIEUL OE RIEULSIOS
    case 0x8F7A: code_point = 0xB8BD; break; // HANGUL SYLLABLE RIEUL OE RIEULTHIEUTH
    case 0x8F81: code_point = 0xB8BE; break; // HANGUL SYLLABLE RIEUL OE RIEULPHIEUPH
    case 0x8F82: code_point = 0xB8BF; break; // HANGUL SYLLABLE RIEUL OE RIEULHIEUH
    case 0x8F83: code_point = 0xB8C2; break; // HANGUL SYLLABLE RIEUL OE PIEUPSIOS
    case 0x8F84: code_point = 0xB8C4; break; // HANGUL SYLLABLE RIEUL OE SSANGSIOS
    case 0x8F85: code_point = 0xB8C6; break; // HANGUL SYLLABLE RIEUL OE CIEUC
    case 0x8F86: code_point = 0xB8C7; break; // HANGUL SYLLABLE RIEUL OE CHIEUCH
    case 0x8F87: code_point = 0xB8C8; break; // HANGUL SYLLABLE RIEUL OE KHIEUKH
    case 0x8F88: code_point = 0xB8C9; break; // HANGUL SYLLABLE RIEUL OE THIEUTH
    case 0x8F89: code_point = 0xB8CA; break; // HANGUL SYLLABLE RIEUL OE PHIEUPH
    case 0x8F8A: code_point = 0xB8CB; break; // HANGUL SYLLABLE RIEUL OE HIEUH
    case 0x8F8B: code_point = 0xB8CD; break; // HANGUL SYLLABLE RIEUL YO KIYEOK
    case 0x8F8C: code_point = 0xB8CE; break; // HANGUL SYLLABLE RIEUL YO SSANGKIYEOK
    case 0x8F8D: code_point = 0xB8CF; break; // HANGUL SYLLABLE RIEUL YO KIYEOKSIOS
    case 0x8F8E: code_point = 0xB8D1; break; // HANGUL SYLLABLE RIEUL YO NIEUNCIEUC
    case 0x8F8F: code_point = 0xB8D2; break; // HANGUL SYLLABLE RIEUL YO NIEUNHIEUH
    case 0x8F90: code_point = 0xB8D3; break; // HANGUL SYLLABLE RIEUL YO TIKEUT
    case 0x8F91: code_point = 0xB8D5; break; // HANGUL SYLLABLE RIEUL YO RIEULKIYEOK
    case 0x8F92: code_point = 0xB8D6; break; // HANGUL SYLLABLE RIEUL YO RIEULMIEUM
    case 0x8F93: code_point = 0xB8D7; break; // HANGUL SYLLABLE RIEUL YO RIEULPIEUP
    case 0x8F94: code_point = 0xB8D8; break; // HANGUL SYLLABLE RIEUL YO RIEULSIOS
    case 0x8F95: code_point = 0xB8D9; break; // HANGUL SYLLABLE RIEUL YO RIEULTHIEUTH
    case 0x8F96: code_point = 0xB8DA; break; // HANGUL SYLLABLE RIEUL YO RIEULPHIEUPH
    case 0x8F97: code_point = 0xB8DB; break; // HANGUL SYLLABLE RIEUL YO RIEULHIEUH
    case 0x8F98: code_point = 0xB8DC; break; // HANGUL SYLLABLE RIEUL YO MIEUM
    case 0x8F99: code_point = 0xB8DE; break; // HANGUL SYLLABLE RIEUL YO PIEUPSIOS
    case 0x8F9A: code_point = 0xB8E0; break; // HANGUL SYLLABLE RIEUL YO SSANGSIOS
    case 0x8F9B: code_point = 0xB8E2; break; // HANGUL SYLLABLE RIEUL YO CIEUC
    case 0x8F9C: code_point = 0xB8E3; break; // HANGUL SYLLABLE RIEUL YO CHIEUCH
    case 0x8F9D: code_point = 0xB8E4; break; // HANGUL SYLLABLE RIEUL YO KHIEUKH
    case 0x8F9E: code_point = 0xB8E5; break; // HANGUL SYLLABLE RIEUL YO THIEUTH
    case 0x8F9F: code_point = 0xB8E6; break; // HANGUL SYLLABLE RIEUL YO PHIEUPH
    case 0x8FA0: code_point = 0xB8E7; break; // HANGUL SYLLABLE RIEUL YO HIEUH
    case 0x8FA1: code_point = 0xB8EA; break; // HANGUL SYLLABLE RIEUL U SSANGKIYEOK
    case 0x8FA2: code_point = 0xB8EB; break; // HANGUL SYLLABLE RIEUL U KIYEOKSIOS
    case 0x8FA3: code_point = 0xB8ED; break; // HANGUL SYLLABLE RIEUL U NIEUNCIEUC
    case 0x8FA4: code_point = 0xB8EE; break; // HANGUL SYLLABLE RIEUL U NIEUNHIEUH
    case 0x8FA5: code_point = 0xB8EF; break; // HANGUL SYLLABLE RIEUL U TIKEUT
    case 0x8FA6: code_point = 0xB8F1; break; // HANGUL SYLLABLE RIEUL U RIEULKIYEOK
    case 0x8FA7: code_point = 0xB8F2; break; // HANGUL SYLLABLE RIEUL U RIEULMIEUM
    case 0x8FA8: code_point = 0xB8F3; break; // HANGUL SYLLABLE RIEUL U RIEULPIEUP
    case 0x8FA9: code_point = 0xB8F4; break; // HANGUL SYLLABLE RIEUL U RIEULSIOS
    case 0x8FAA: code_point = 0xB8F5; break; // HANGUL SYLLABLE RIEUL U RIEULTHIEUTH
    case 0x8FAB: code_point = 0xB8F6; break; // HANGUL SYLLABLE RIEUL U RIEULPHIEUPH
    case 0x8FAC: code_point = 0xB8F7; break; // HANGUL SYLLABLE RIEUL U RIEULHIEUH
    case 0x8FAD: code_point = 0xB8FA; break; // HANGUL SYLLABLE RIEUL U PIEUPSIOS
    case 0x8FAE: code_point = 0xB8FC; break; // HANGUL SYLLABLE RIEUL U SSANGSIOS
    case 0x8FAF: code_point = 0xB8FE; break; // HANGUL SYLLABLE RIEUL U CIEUC
    case 0x8FB0: code_point = 0xB8FF; break; // HANGUL SYLLABLE RIEUL U CHIEUCH
    case 0x8FB1: code_point = 0xB900; break; // HANGUL SYLLABLE RIEUL U KHIEUKH
    case 0x8FB2: code_point = 0xB901; break; // HANGUL SYLLABLE RIEUL U THIEUTH
    case 0x8FB3: code_point = 0xB902; break; // HANGUL SYLLABLE RIEUL U PHIEUPH
    case 0x8FB4: code_point = 0xB903; break; // HANGUL SYLLABLE RIEUL U HIEUH
    case 0x8FB5: code_point = 0xB905; break; // HANGUL SYLLABLE RIEUL WEO KIYEOK
    case 0x8FB6: code_point = 0xB906; break; // HANGUL SYLLABLE RIEUL WEO SSANGKIYEOK
    case 0x8FB7: code_point = 0xB907; break; // HANGUL SYLLABLE RIEUL WEO KIYEOKSIOS
    case 0x8FB8: code_point = 0xB908; break; // HANGUL SYLLABLE RIEUL WEO NIEUN
    case 0x8FB9: code_point = 0xB909; break; // HANGUL SYLLABLE RIEUL WEO NIEUNCIEUC
    case 0x8FBA: code_point = 0xB90A; break; // HANGUL SYLLABLE RIEUL WEO NIEUNHIEUH
    case 0x8FBB: code_point = 0xB90B; break; // HANGUL SYLLABLE RIEUL WEO TIKEUT
    case 0x8FBC: code_point = 0xB90C; break; // HANGUL SYLLABLE RIEUL WEO RIEUL
    case 0x8FBD: code_point = 0xB90D; break; // HANGUL SYLLABLE RIEUL WEO RIEULKIYEOK
    case 0x8FBE: code_point = 0xB90E; break; // HANGUL SYLLABLE RIEUL WEO RIEULMIEUM
    case 0x8FBF: code_point = 0xB90F; break; // HANGUL SYLLABLE RIEUL WEO RIEULPIEUP
    case 0x8FC0: code_point = 0xB910; break; // HANGUL SYLLABLE RIEUL WEO RIEULSIOS
    case 0x8FC1: code_point = 0xB911; break; // HANGUL SYLLABLE RIEUL WEO RIEULTHIEUTH
    case 0x8FC2: code_point = 0xB912; break; // HANGUL SYLLABLE RIEUL WEO RIEULPHIEUPH
    case 0x8FC3: code_point = 0xB913; break; // HANGUL SYLLABLE RIEUL WEO RIEULHIEUH
    case 0x8FC4: code_point = 0xB914; break; // HANGUL SYLLABLE RIEUL WEO MIEUM
    case 0x8FC5: code_point = 0xB915; break; // HANGUL SYLLABLE RIEUL WEO PIEUP
    case 0x8FC6: code_point = 0xB916; break; // HANGUL SYLLABLE RIEUL WEO PIEUPSIOS
    case 0x8FC7: code_point = 0xB917; break; // HANGUL SYLLABLE RIEUL WEO SIOS
    case 0x8FC8: code_point = 0xB919; break; // HANGUL SYLLABLE RIEUL WEO IEUNG
    case 0x8FC9: code_point = 0xB91A; break; // HANGUL SYLLABLE RIEUL WEO CIEUC
    case 0x8FCA: code_point = 0xB91B; break; // HANGUL SYLLABLE RIEUL WEO CHIEUCH
    case 0x8FCB: code_point = 0xB91C; break; // HANGUL SYLLABLE RIEUL WEO KHIEUKH
    case 0x8FCC: code_point = 0xB91D; break; // HANGUL SYLLABLE RIEUL WEO THIEUTH
    case 0x8FCD: code_point = 0xB91E; break; // HANGUL SYLLABLE RIEUL WEO PHIEUPH
    case 0x8FCE: code_point = 0xB91F; break; // HANGUL SYLLABLE RIEUL WEO HIEUH
    case 0x8FCF: code_point = 0xB921; break; // HANGUL SYLLABLE RIEUL WE KIYEOK
    case 0x8FD0: code_point = 0xB922; break; // HANGUL SYLLABLE RIEUL WE SSANGKIYEOK
    case 0x8FD1: code_point = 0xB923; break; // HANGUL SYLLABLE RIEUL WE KIYEOKSIOS
    case 0x8FD2: code_point = 0xB924; break; // HANGUL SYLLABLE RIEUL WE NIEUN
    case 0x8FD3: code_point = 0xB925; break; // HANGUL SYLLABLE RIEUL WE NIEUNCIEUC
    case 0x8FD4: code_point = 0xB926; break; // HANGUL SYLLABLE RIEUL WE NIEUNHIEUH
    case 0x8FD5: code_point = 0xB927; break; // HANGUL SYLLABLE RIEUL WE TIKEUT
    case 0x8FD6: code_point = 0xB928; break; // HANGUL SYLLABLE RIEUL WE RIEUL
    case 0x8FD7: code_point = 0xB929; break; // HANGUL SYLLABLE RIEUL WE RIEULKIYEOK
    case 0x8FD8: code_point = 0xB92A; break; // HANGUL SYLLABLE RIEUL WE RIEULMIEUM
    case 0x8FD9: code_point = 0xB92B; break; // HANGUL SYLLABLE RIEUL WE RIEULPIEUP
    case 0x8FDA: code_point = 0xB92C; break; // HANGUL SYLLABLE RIEUL WE RIEULSIOS
    case 0x8FDB: code_point = 0xB92D; break; // HANGUL SYLLABLE RIEUL WE RIEULTHIEUTH
    case 0x8FDC: code_point = 0xB92E; break; // HANGUL SYLLABLE RIEUL WE RIEULPHIEUPH
    case 0x8FDD: code_point = 0xB92F; break; // HANGUL SYLLABLE RIEUL WE RIEULHIEUH
    case 0x8FDE: code_point = 0xB930; break; // HANGUL SYLLABLE RIEUL WE MIEUM
    case 0x8FDF: code_point = 0xB931; break; // HANGUL SYLLABLE RIEUL WE PIEUP
    case 0x8FE0: code_point = 0xB932; break; // HANGUL SYLLABLE RIEUL WE PIEUPSIOS
    case 0x8FE1: code_point = 0xB933; break; // HANGUL SYLLABLE RIEUL WE SIOS
    case 0x8FE2: code_point = 0xB934; break; // HANGUL SYLLABLE RIEUL WE SSANGSIOS
    case 0x8FE3: code_point = 0xB935; break; // HANGUL SYLLABLE RIEUL WE IEUNG
    case 0x8FE4: code_point = 0xB936; break; // HANGUL SYLLABLE RIEUL WE CIEUC
    case 0x8FE5: code_point = 0xB937; break; // HANGUL SYLLABLE RIEUL WE CHIEUCH
    case 0x8FE6: code_point = 0xB938; break; // HANGUL SYLLABLE RIEUL WE KHIEUKH
    case 0x8FE7: code_point = 0xB939; break; // HANGUL SYLLABLE RIEUL WE THIEUTH
    case 0x8FE8: code_point = 0xB93A; break; // HANGUL SYLLABLE RIEUL WE PHIEUPH
    case 0x8FE9: code_point = 0xB93B; break; // HANGUL SYLLABLE RIEUL WE HIEUH
    case 0x8FEA: code_point = 0xB93E; break; // HANGUL SYLLABLE RIEUL WI SSANGKIYEOK
    case 0x8FEB: code_point = 0xB93F; break; // HANGUL SYLLABLE RIEUL WI KIYEOKSIOS
    case 0x8FEC: code_point = 0xB941; break; // HANGUL SYLLABLE RIEUL WI NIEUNCIEUC
    case 0x8FED: code_point = 0xB942; break; // HANGUL SYLLABLE RIEUL WI NIEUNHIEUH
    case 0x8FEE: code_point = 0xB943; break; // HANGUL SYLLABLE RIEUL WI TIKEUT
    case 0x8FEF: code_point = 0xB945; break; // HANGUL SYLLABLE RIEUL WI RIEULKIYEOK
    case 0x8FF0: code_point = 0xB946; break; // HANGUL SYLLABLE RIEUL WI RIEULMIEUM
    case 0x8FF1: code_point = 0xB947; break; // HANGUL SYLLABLE RIEUL WI RIEULPIEUP
    case 0x8FF2: code_point = 0xB948; break; // HANGUL SYLLABLE RIEUL WI RIEULSIOS
    case 0x8FF3: code_point = 0xB949; break; // HANGUL SYLLABLE RIEUL WI RIEULTHIEUTH
    case 0x8FF4: code_point = 0xB94A; break; // HANGUL SYLLABLE RIEUL WI RIEULPHIEUPH
    case 0x8FF5: code_point = 0xB94B; break; // HANGUL SYLLABLE RIEUL WI RIEULHIEUH
    case 0x8FF6: code_point = 0xB94D; break; // HANGUL SYLLABLE RIEUL WI PIEUP
    case 0x8FF7: code_point = 0xB94E; break; // HANGUL SYLLABLE RIEUL WI PIEUPSIOS
    case 0x8FF8: code_point = 0xB950; break; // HANGUL SYLLABLE RIEUL WI SSANGSIOS
    case 0x8FF9: code_point = 0xB952; break; // HANGUL SYLLABLE RIEUL WI CIEUC
    case 0x8FFA: code_point = 0xB953; break; // HANGUL SYLLABLE RIEUL WI CHIEUCH
    case 0x8FFB: code_point = 0xB954; break; // HANGUL SYLLABLE RIEUL WI KHIEUKH
    case 0x8FFC: code_point = 0xB955; break; // HANGUL SYLLABLE RIEUL WI THIEUTH
    case 0x8FFD: code_point = 0xB956; break; // HANGUL SYLLABLE RIEUL WI PHIEUPH
    case 0x8FFE: code_point = 0xB957; break; // HANGUL SYLLABLE RIEUL WI HIEUH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x90(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9041: code_point = 0xB95A; break; // HANGUL SYLLABLE RIEUL YU SSANGKIYEOK
    case 0x9042: code_point = 0xB95B; break; // HANGUL SYLLABLE RIEUL YU KIYEOKSIOS
    case 0x9043: code_point = 0xB95D; break; // HANGUL SYLLABLE RIEUL YU NIEUNCIEUC
    case 0x9044: code_point = 0xB95E; break; // HANGUL SYLLABLE RIEUL YU NIEUNHIEUH
    case 0x9045: code_point = 0xB95F; break; // HANGUL SYLLABLE RIEUL YU TIKEUT
    case 0x9046: code_point = 0xB961; break; // HANGUL SYLLABLE RIEUL YU RIEULKIYEOK
    case 0x9047: code_point = 0xB962; break; // HANGUL SYLLABLE RIEUL YU RIEULMIEUM
    case 0x9048: code_point = 0xB963; break; // HANGUL SYLLABLE RIEUL YU RIEULPIEUP
    case 0x9049: code_point = 0xB964; break; // HANGUL SYLLABLE RIEUL YU RIEULSIOS
    case 0x904A: code_point = 0xB965; break; // HANGUL SYLLABLE RIEUL YU RIEULTHIEUTH
    case 0x904B: code_point = 0xB966; break; // HANGUL SYLLABLE RIEUL YU RIEULPHIEUPH
    case 0x904C: code_point = 0xB967; break; // HANGUL SYLLABLE RIEUL YU RIEULHIEUH
    case 0x904D: code_point = 0xB96A; break; // HANGUL SYLLABLE RIEUL YU PIEUPSIOS
    case 0x904E: code_point = 0xB96C; break; // HANGUL SYLLABLE RIEUL YU SSANGSIOS
    case 0x904F: code_point = 0xB96E; break; // HANGUL SYLLABLE RIEUL YU CIEUC
    case 0x9050: code_point = 0xB96F; break; // HANGUL SYLLABLE RIEUL YU CHIEUCH
    case 0x9051: code_point = 0xB970; break; // HANGUL SYLLABLE RIEUL YU KHIEUKH
    case 0x9052: code_point = 0xB971; break; // HANGUL SYLLABLE RIEUL YU THIEUTH
    case 0x9053: code_point = 0xB972; break; // HANGUL SYLLABLE RIEUL YU PHIEUPH
    case 0x9054: code_point = 0xB973; break; // HANGUL SYLLABLE RIEUL YU HIEUH
    case 0x9055: code_point = 0xB976; break; // HANGUL SYLLABLE RIEUL EU SSANGKIYEOK
    case 0x9056: code_point = 0xB977; break; // HANGUL SYLLABLE RIEUL EU KIYEOKSIOS
    case 0x9057: code_point = 0xB979; break; // HANGUL SYLLABLE RIEUL EU NIEUNCIEUC
    case 0x9058: code_point = 0xB97A; break; // HANGUL SYLLABLE RIEUL EU NIEUNHIEUH
    case 0x9059: code_point = 0xB97B; break; // HANGUL SYLLABLE RIEUL EU TIKEUT
    case 0x905A: code_point = 0xB97D; break; // HANGUL SYLLABLE RIEUL EU RIEULKIYEOK
    case 0x9061: code_point = 0xB97E; break; // HANGUL SYLLABLE RIEUL EU RIEULMIEUM
    case 0x9062: code_point = 0xB97F; break; // HANGUL SYLLABLE RIEUL EU RIEULPIEUP
    case 0x9063: code_point = 0xB980; break; // HANGUL SYLLABLE RIEUL EU RIEULSIOS
    case 0x9064: code_point = 0xB981; break; // HANGUL SYLLABLE RIEUL EU RIEULTHIEUTH
    case 0x9065: code_point = 0xB982; break; // HANGUL SYLLABLE RIEUL EU RIEULPHIEUPH
    case 0x9066: code_point = 0xB983; break; // HANGUL SYLLABLE RIEUL EU RIEULHIEUH
    case 0x9067: code_point = 0xB986; break; // HANGUL SYLLABLE RIEUL EU PIEUPSIOS
    case 0x9068: code_point = 0xB988; break; // HANGUL SYLLABLE RIEUL EU SSANGSIOS
    case 0x9069: code_point = 0xB98B; break; // HANGUL SYLLABLE RIEUL EU CHIEUCH
    case 0x906A: code_point = 0xB98C; break; // HANGUL SYLLABLE RIEUL EU KHIEUKH
    case 0x906B: code_point = 0xB98F; break; // HANGUL SYLLABLE RIEUL EU HIEUH
    case 0x906C: code_point = 0xB990; break; // HANGUL SYLLABLE RIEUL YI
    case 0x906D: code_point = 0xB991; break; // HANGUL SYLLABLE RIEUL YI KIYEOK
    case 0x906E: code_point = 0xB992; break; // HANGUL SYLLABLE RIEUL YI SSANGKIYEOK
    case 0x906F: code_point = 0xB993; break; // HANGUL SYLLABLE RIEUL YI KIYEOKSIOS
    case 0x9070: code_point = 0xB994; break; // HANGUL SYLLABLE RIEUL YI NIEUN
    case 0x9071: code_point = 0xB995; break; // HANGUL SYLLABLE RIEUL YI NIEUNCIEUC
    case 0x9072: code_point = 0xB996; break; // HANGUL SYLLABLE RIEUL YI NIEUNHIEUH
    case 0x9073: code_point = 0xB997; break; // HANGUL SYLLABLE RIEUL YI TIKEUT
    case 0x9074: code_point = 0xB998; break; // HANGUL SYLLABLE RIEUL YI RIEUL
    case 0x9075: code_point = 0xB999; break; // HANGUL SYLLABLE RIEUL YI RIEULKIYEOK
    case 0x9076: code_point = 0xB99A; break; // HANGUL SYLLABLE RIEUL YI RIEULMIEUM
    case 0x9077: code_point = 0xB99B; break; // HANGUL SYLLABLE RIEUL YI RIEULPIEUP
    case 0x9078: code_point = 0xB99C; break; // HANGUL SYLLABLE RIEUL YI RIEULSIOS
    case 0x9079: code_point = 0xB99D; break; // HANGUL SYLLABLE RIEUL YI RIEULTHIEUTH
    case 0x907A: code_point = 0xB99E; break; // HANGUL SYLLABLE RIEUL YI RIEULPHIEUPH
    case 0x9081: code_point = 0xB99F; break; // HANGUL SYLLABLE RIEUL YI RIEULHIEUH
    case 0x9082: code_point = 0xB9A0; break; // HANGUL SYLLABLE RIEUL YI MIEUM
    case 0x9083: code_point = 0xB9A1; break; // HANGUL SYLLABLE RIEUL YI PIEUP
    case 0x9084: code_point = 0xB9A2; break; // HANGUL SYLLABLE RIEUL YI PIEUPSIOS
    case 0x9085: code_point = 0xB9A3; break; // HANGUL SYLLABLE RIEUL YI SIOS
    case 0x9086: code_point = 0xB9A4; break; // HANGUL SYLLABLE RIEUL YI SSANGSIOS
    case 0x9087: code_point = 0xB9A5; break; // HANGUL SYLLABLE RIEUL YI IEUNG
    case 0x9088: code_point = 0xB9A6; break; // HANGUL SYLLABLE RIEUL YI CIEUC
    case 0x9089: code_point = 0xB9A7; break; // HANGUL SYLLABLE RIEUL YI CHIEUCH
    case 0x908A: code_point = 0xB9A8; break; // HANGUL SYLLABLE RIEUL YI KHIEUKH
    case 0x908B: code_point = 0xB9A9; break; // HANGUL SYLLABLE RIEUL YI THIEUTH
    case 0x908C: code_point = 0xB9AA; break; // HANGUL SYLLABLE RIEUL YI PHIEUPH
    case 0x908D: code_point = 0xB9AB; break; // HANGUL SYLLABLE RIEUL YI HIEUH
    case 0x908E: code_point = 0xB9AE; break; // HANGUL SYLLABLE RIEUL I SSANGKIYEOK
    case 0x908F: code_point = 0xB9AF; break; // HANGUL SYLLABLE RIEUL I KIYEOKSIOS
    case 0x9090: code_point = 0xB9B1; break; // HANGUL SYLLABLE RIEUL I NIEUNCIEUC
    case 0x9091: code_point = 0xB9B2; break; // HANGUL SYLLABLE RIEUL I NIEUNHIEUH
    case 0x9092: code_point = 0xB9B3; break; // HANGUL SYLLABLE RIEUL I TIKEUT
    case 0x9093: code_point = 0xB9B5; break; // HANGUL SYLLABLE RIEUL I RIEULKIYEOK
    case 0x9094: code_point = 0xB9B6; break; // HANGUL SYLLABLE RIEUL I RIEULMIEUM
    case 0x9095: code_point = 0xB9B7; break; // HANGUL SYLLABLE RIEUL I RIEULPIEUP
    case 0x9096: code_point = 0xB9B8; break; // HANGUL SYLLABLE RIEUL I RIEULSIOS
    case 0x9097: code_point = 0xB9B9; break; // HANGUL SYLLABLE RIEUL I RIEULTHIEUTH
    case 0x9098: code_point = 0xB9BA; break; // HANGUL SYLLABLE RIEUL I RIEULPHIEUPH
    case 0x9099: code_point = 0xB9BB; break; // HANGUL SYLLABLE RIEUL I RIEULHIEUH
    case 0x909A: code_point = 0xB9BE; break; // HANGUL SYLLABLE RIEUL I PIEUPSIOS
    case 0x909B: code_point = 0xB9C0; break; // HANGUL SYLLABLE RIEUL I SSANGSIOS
    case 0x909C: code_point = 0xB9C2; break; // HANGUL SYLLABLE RIEUL I CIEUC
    case 0x909D: code_point = 0xB9C3; break; // HANGUL SYLLABLE RIEUL I CHIEUCH
    case 0x909E: code_point = 0xB9C4; break; // HANGUL SYLLABLE RIEUL I KHIEUKH
    case 0x909F: code_point = 0xB9C5; break; // HANGUL SYLLABLE RIEUL I THIEUTH
    case 0x90A0: code_point = 0xB9C6; break; // HANGUL SYLLABLE RIEUL I PHIEUPH
    case 0x90A1: code_point = 0xB9C7; break; // HANGUL SYLLABLE RIEUL I HIEUH
    case 0x90A2: code_point = 0xB9CA; break; // HANGUL SYLLABLE MIEUM A SSANGKIYEOK
    case 0x90A3: code_point = 0xB9CB; break; // HANGUL SYLLABLE MIEUM A KIYEOKSIOS
    case 0x90A4: code_point = 0xB9CD; break; // HANGUL SYLLABLE MIEUM A NIEUNCIEUC
    case 0x90A5: code_point = 0xB9D3; break; // HANGUL SYLLABLE MIEUM A RIEULPIEUP
    case 0x90A6: code_point = 0xB9D4; break; // HANGUL SYLLABLE MIEUM A RIEULSIOS
    case 0x90A7: code_point = 0xB9D5; break; // HANGUL SYLLABLE MIEUM A RIEULTHIEUTH
    case 0x90A8: code_point = 0xB9D6; break; // HANGUL SYLLABLE MIEUM A RIEULPHIEUPH
    case 0x90A9: code_point = 0xB9D7; break; // HANGUL SYLLABLE MIEUM A RIEULHIEUH
    case 0x90AA: code_point = 0xB9DA; break; // HANGUL SYLLABLE MIEUM A PIEUPSIOS
    case 0x90AB: code_point = 0xB9DC; break; // HANGUL SYLLABLE MIEUM A SSANGSIOS
    case 0x90AC: code_point = 0xB9DF; break; // HANGUL SYLLABLE MIEUM A CHIEUCH
    case 0x90AD: code_point = 0xB9E0; break; // HANGUL SYLLABLE MIEUM A KHIEUKH
    case 0x90AE: code_point = 0xB9E2; break; // HANGUL SYLLABLE MIEUM A PHIEUPH
    case 0x90AF: code_point = 0xB9E6; break; // HANGUL SYLLABLE MIEUM AE SSANGKIYEOK
    case 0x90B0: code_point = 0xB9E7; break; // HANGUL SYLLABLE MIEUM AE KIYEOKSIOS
    case 0x90B1: code_point = 0xB9E9; break; // HANGUL SYLLABLE MIEUM AE NIEUNCIEUC
    case 0x90B2: code_point = 0xB9EA; break; // HANGUL SYLLABLE MIEUM AE NIEUNHIEUH
    case 0x90B3: code_point = 0xB9EB; break; // HANGUL SYLLABLE MIEUM AE TIKEUT
    case 0x90B4: code_point = 0xB9ED; break; // HANGUL SYLLABLE MIEUM AE RIEULKIYEOK
    case 0x90B5: code_point = 0xB9EE; break; // HANGUL SYLLABLE MIEUM AE RIEULMIEUM
    case 0x90B6: code_point = 0xB9EF; break; // HANGUL SYLLABLE MIEUM AE RIEULPIEUP
    case 0x90B7: code_point = 0xB9F0; break; // HANGUL SYLLABLE MIEUM AE RIEULSIOS
    case 0x90B8: code_point = 0xB9F1; break; // HANGUL SYLLABLE MIEUM AE RIEULTHIEUTH
    case 0x90B9: code_point = 0xB9F2; break; // HANGUL SYLLABLE MIEUM AE RIEULPHIEUPH
    case 0x90BA: code_point = 0xB9F3; break; // HANGUL SYLLABLE MIEUM AE RIEULHIEUH
    case 0x90BB: code_point = 0xB9F6; break; // HANGUL SYLLABLE MIEUM AE PIEUPSIOS
    case 0x90BC: code_point = 0xB9FB; break; // HANGUL SYLLABLE MIEUM AE CHIEUCH
    case 0x90BD: code_point = 0xB9FC; break; // HANGUL SYLLABLE MIEUM AE KHIEUKH
    case 0x90BE: code_point = 0xB9FD; break; // HANGUL SYLLABLE MIEUM AE THIEUTH
    case 0x90BF: code_point = 0xB9FE; break; // HANGUL SYLLABLE MIEUM AE PHIEUPH
    case 0x90C0: code_point = 0xB9FF; break; // HANGUL SYLLABLE MIEUM AE HIEUH
    case 0x90C1: code_point = 0xBA02; break; // HANGUL SYLLABLE MIEUM YA SSANGKIYEOK
    case 0x90C2: code_point = 0xBA03; break; // HANGUL SYLLABLE MIEUM YA KIYEOKSIOS
    case 0x90C3: code_point = 0xBA04; break; // HANGUL SYLLABLE MIEUM YA NIEUN
    case 0x90C4: code_point = 0xBA05; break; // HANGUL SYLLABLE MIEUM YA NIEUNCIEUC
    case 0x90C5: code_point = 0xBA06; break; // HANGUL SYLLABLE MIEUM YA NIEUNHIEUH
    case 0x90C6: code_point = 0xBA07; break; // HANGUL SYLLABLE MIEUM YA TIKEUT
    case 0x90C7: code_point = 0xBA09; break; // HANGUL SYLLABLE MIEUM YA RIEULKIYEOK
    case 0x90C8: code_point = 0xBA0A; break; // HANGUL SYLLABLE MIEUM YA RIEULMIEUM
    case 0x90C9: code_point = 0xBA0B; break; // HANGUL SYLLABLE MIEUM YA RIEULPIEUP
    case 0x90CA: code_point = 0xBA0C; break; // HANGUL SYLLABLE MIEUM YA RIEULSIOS
    case 0x90CB: code_point = 0xBA0D; break; // HANGUL SYLLABLE MIEUM YA RIEULTHIEUTH
    case 0x90CC: code_point = 0xBA0E; break; // HANGUL SYLLABLE MIEUM YA RIEULPHIEUPH
    case 0x90CD: code_point = 0xBA0F; break; // HANGUL SYLLABLE MIEUM YA RIEULHIEUH
    case 0x90CE: code_point = 0xBA10; break; // HANGUL SYLLABLE MIEUM YA MIEUM
    case 0x90CF: code_point = 0xBA11; break; // HANGUL SYLLABLE MIEUM YA PIEUP
    case 0x90D0: code_point = 0xBA12; break; // HANGUL SYLLABLE MIEUM YA PIEUPSIOS
    case 0x90D1: code_point = 0xBA13; break; // HANGUL SYLLABLE MIEUM YA SIOS
    case 0x90D2: code_point = 0xBA14; break; // HANGUL SYLLABLE MIEUM YA SSANGSIOS
    case 0x90D3: code_point = 0xBA16; break; // HANGUL SYLLABLE MIEUM YA CIEUC
    case 0x90D4: code_point = 0xBA17; break; // HANGUL SYLLABLE MIEUM YA CHIEUCH
    case 0x90D5: code_point = 0xBA18; break; // HANGUL SYLLABLE MIEUM YA KHIEUKH
    case 0x90D6: code_point = 0xBA19; break; // HANGUL SYLLABLE MIEUM YA THIEUTH
    case 0x90D7: code_point = 0xBA1A; break; // HANGUL SYLLABLE MIEUM YA PHIEUPH
    case 0x90D8: code_point = 0xBA1B; break; // HANGUL SYLLABLE MIEUM YA HIEUH
    case 0x90D9: code_point = 0xBA1C; break; // HANGUL SYLLABLE MIEUM YAE
    case 0x90DA: code_point = 0xBA1D; break; // HANGUL SYLLABLE MIEUM YAE KIYEOK
    case 0x90DB: code_point = 0xBA1E; break; // HANGUL SYLLABLE MIEUM YAE SSANGKIYEOK
    case 0x90DC: code_point = 0xBA1F; break; // HANGUL SYLLABLE MIEUM YAE KIYEOKSIOS
    case 0x90DD: code_point = 0xBA20; break; // HANGUL SYLLABLE MIEUM YAE NIEUN
    case 0x90DE: code_point = 0xBA21; break; // HANGUL SYLLABLE MIEUM YAE NIEUNCIEUC
    case 0x90DF: code_point = 0xBA22; break; // HANGUL SYLLABLE MIEUM YAE NIEUNHIEUH
    case 0x90E0: code_point = 0xBA23; break; // HANGUL SYLLABLE MIEUM YAE TIKEUT
    case 0x90E1: code_point = 0xBA24; break; // HANGUL SYLLABLE MIEUM YAE RIEUL
    case 0x90E2: code_point = 0xBA25; break; // HANGUL SYLLABLE MIEUM YAE RIEULKIYEOK
    case 0x90E3: code_point = 0xBA26; break; // HANGUL SYLLABLE MIEUM YAE RIEULMIEUM
    case 0x90E4: code_point = 0xBA27; break; // HANGUL SYLLABLE MIEUM YAE RIEULPIEUP
    case 0x90E5: code_point = 0xBA28; break; // HANGUL SYLLABLE MIEUM YAE RIEULSIOS
    case 0x90E6: code_point = 0xBA29; break; // HANGUL SYLLABLE MIEUM YAE RIEULTHIEUTH
    case 0x90E7: code_point = 0xBA2A; break; // HANGUL SYLLABLE MIEUM YAE RIEULPHIEUPH
    case 0x90E8: code_point = 0xBA2B; break; // HANGUL SYLLABLE MIEUM YAE RIEULHIEUH
    case 0x90E9: code_point = 0xBA2C; break; // HANGUL SYLLABLE MIEUM YAE MIEUM
    case 0x90EA: code_point = 0xBA2D; break; // HANGUL SYLLABLE MIEUM YAE PIEUP
    case 0x90EB: code_point = 0xBA2E; break; // HANGUL SYLLABLE MIEUM YAE PIEUPSIOS
    case 0x90EC: code_point = 0xBA2F; break; // HANGUL SYLLABLE MIEUM YAE SIOS
    case 0x90ED: code_point = 0xBA30; break; // HANGUL SYLLABLE MIEUM YAE SSANGSIOS
    case 0x90EE: code_point = 0xBA31; break; // HANGUL SYLLABLE MIEUM YAE IEUNG
    case 0x90EF: code_point = 0xBA32; break; // HANGUL SYLLABLE MIEUM YAE CIEUC
    case 0x90F0: code_point = 0xBA33; break; // HANGUL SYLLABLE MIEUM YAE CHIEUCH
    case 0x90F1: code_point = 0xBA34; break; // HANGUL SYLLABLE MIEUM YAE KHIEUKH
    case 0x90F2: code_point = 0xBA35; break; // HANGUL SYLLABLE MIEUM YAE THIEUTH
    case 0x90F3: code_point = 0xBA36; break; // HANGUL SYLLABLE MIEUM YAE PHIEUPH
    case 0x90F4: code_point = 0xBA37; break; // HANGUL SYLLABLE MIEUM YAE HIEUH
    case 0x90F5: code_point = 0xBA3A; break; // HANGUL SYLLABLE MIEUM EO SSANGKIYEOK
    case 0x90F6: code_point = 0xBA3B; break; // HANGUL SYLLABLE MIEUM EO KIYEOKSIOS
    case 0x90F7: code_point = 0xBA3D; break; // HANGUL SYLLABLE MIEUM EO NIEUNCIEUC
    case 0x90F8: code_point = 0xBA3E; break; // HANGUL SYLLABLE MIEUM EO NIEUNHIEUH
    case 0x90F9: code_point = 0xBA3F; break; // HANGUL SYLLABLE MIEUM EO TIKEUT
    case 0x90FA: code_point = 0xBA41; break; // HANGUL SYLLABLE MIEUM EO RIEULKIYEOK
    case 0x90FB: code_point = 0xBA43; break; // HANGUL SYLLABLE MIEUM EO RIEULPIEUP
    case 0x90FC: code_point = 0xBA44; break; // HANGUL SYLLABLE MIEUM EO RIEULSIOS
    case 0x90FD: code_point = 0xBA45; break; // HANGUL SYLLABLE MIEUM EO RIEULTHIEUTH
    case 0x90FE: code_point = 0xBA46; break; // HANGUL SYLLABLE MIEUM EO RIEULPHIEUPH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x91(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9141: code_point = 0xBA47; break; // HANGUL SYLLABLE MIEUM EO RIEULHIEUH
    case 0x9142: code_point = 0xBA4A; break; // HANGUL SYLLABLE MIEUM EO PIEUPSIOS
    case 0x9143: code_point = 0xBA4C; break; // HANGUL SYLLABLE MIEUM EO SSANGSIOS
    case 0x9144: code_point = 0xBA4F; break; // HANGUL SYLLABLE MIEUM EO CHIEUCH
    case 0x9145: code_point = 0xBA50; break; // HANGUL SYLLABLE MIEUM EO KHIEUKH
    case 0x9146: code_point = 0xBA51; break; // HANGUL SYLLABLE MIEUM EO THIEUTH
    case 0x9147: code_point = 0xBA52; break; // HANGUL SYLLABLE MIEUM EO PHIEUPH
    case 0x9148: code_point = 0xBA56; break; // HANGUL SYLLABLE MIEUM E SSANGKIYEOK
    case 0x9149: code_point = 0xBA57; break; // HANGUL SYLLABLE MIEUM E KIYEOKSIOS
    case 0x914A: code_point = 0xBA59; break; // HANGUL SYLLABLE MIEUM E NIEUNCIEUC
    case 0x914B: code_point = 0xBA5A; break; // HANGUL SYLLABLE MIEUM E NIEUNHIEUH
    case 0x914C: code_point = 0xBA5B; break; // HANGUL SYLLABLE MIEUM E TIKEUT
    case 0x914D: code_point = 0xBA5D; break; // HANGUL SYLLABLE MIEUM E RIEULKIYEOK
    case 0x914E: code_point = 0xBA5E; break; // HANGUL SYLLABLE MIEUM E RIEULMIEUM
    case 0x914F: code_point = 0xBA5F; break; // HANGUL SYLLABLE MIEUM E RIEULPIEUP
    case 0x9150: code_point = 0xBA60; break; // HANGUL SYLLABLE MIEUM E RIEULSIOS
    case 0x9151: code_point = 0xBA61; break; // HANGUL SYLLABLE MIEUM E RIEULTHIEUTH
    case 0x9152: code_point = 0xBA62; break; // HANGUL SYLLABLE MIEUM E RIEULPHIEUPH
    case 0x9153: code_point = 0xBA63; break; // HANGUL SYLLABLE MIEUM E RIEULHIEUH
    case 0x9154: code_point = 0xBA66; break; // HANGUL SYLLABLE MIEUM E PIEUPSIOS
    case 0x9155: code_point = 0xBA6A; break; // HANGUL SYLLABLE MIEUM E CIEUC
    case 0x9156: code_point = 0xBA6B; break; // HANGUL SYLLABLE MIEUM E CHIEUCH
    case 0x9157: code_point = 0xBA6C; break; // HANGUL SYLLABLE MIEUM E KHIEUKH
    case 0x9158: code_point = 0xBA6D; break; // HANGUL SYLLABLE MIEUM E THIEUTH
    case 0x9159: code_point = 0xBA6E; break; // HANGUL SYLLABLE MIEUM E PHIEUPH
    case 0x915A: code_point = 0xBA6F; break; // HANGUL SYLLABLE MIEUM E HIEUH
    case 0x9161: code_point = 0xBA72; break; // HANGUL SYLLABLE MIEUM YEO SSANGKIYEOK
    case 0x9162: code_point = 0xBA73; break; // HANGUL SYLLABLE MIEUM YEO KIYEOKSIOS
    case 0x9163: code_point = 0xBA75; break; // HANGUL SYLLABLE MIEUM YEO NIEUNCIEUC
    case 0x9164: code_point = 0xBA76; break; // HANGUL SYLLABLE MIEUM YEO NIEUNHIEUH
    case 0x9165: code_point = 0xBA77; break; // HANGUL SYLLABLE MIEUM YEO TIKEUT
    case 0x9166: code_point = 0xBA79; break; // HANGUL SYLLABLE MIEUM YEO RIEULKIYEOK
    case 0x9167: code_point = 0xBA7A; break; // HANGUL SYLLABLE MIEUM YEO RIEULMIEUM
    case 0x9168: code_point = 0xBA7B; break; // HANGUL SYLLABLE MIEUM YEO RIEULPIEUP
    case 0x9169: code_point = 0xBA7C; break; // HANGUL SYLLABLE MIEUM YEO RIEULSIOS
    case 0x916A: code_point = 0xBA7D; break; // HANGUL SYLLABLE MIEUM YEO RIEULTHIEUTH
    case 0x916B: code_point = 0xBA7E; break; // HANGUL SYLLABLE MIEUM YEO RIEULPHIEUPH
    case 0x916C: code_point = 0xBA7F; break; // HANGUL SYLLABLE MIEUM YEO RIEULHIEUH
    case 0x916D: code_point = 0xBA80; break; // HANGUL SYLLABLE MIEUM YEO MIEUM
    case 0x916E: code_point = 0xBA81; break; // HANGUL SYLLABLE MIEUM YEO PIEUP
    case 0x916F: code_point = 0xBA82; break; // HANGUL SYLLABLE MIEUM YEO PIEUPSIOS
    case 0x9170: code_point = 0xBA86; break; // HANGUL SYLLABLE MIEUM YEO CIEUC
    case 0x9171: code_point = 0xBA88; break; // HANGUL SYLLABLE MIEUM YEO KHIEUKH
    case 0x9172: code_point = 0xBA89; break; // HANGUL SYLLABLE MIEUM YEO THIEUTH
    case 0x9173: code_point = 0xBA8A; break; // HANGUL SYLLABLE MIEUM YEO PHIEUPH
    case 0x9174: code_point = 0xBA8B; break; // HANGUL SYLLABLE MIEUM YEO HIEUH
    case 0x9175: code_point = 0xBA8D; break; // HANGUL SYLLABLE MIEUM YE KIYEOK
    case 0x9176: code_point = 0xBA8E; break; // HANGUL SYLLABLE MIEUM YE SSANGKIYEOK
    case 0x9177: code_point = 0xBA8F; break; // HANGUL SYLLABLE MIEUM YE KIYEOKSIOS
    case 0x9178: code_point = 0xBA90; break; // HANGUL SYLLABLE MIEUM YE NIEUN
    case 0x9179: code_point = 0xBA91; break; // HANGUL SYLLABLE MIEUM YE NIEUNCIEUC
    case 0x917A: code_point = 0xBA92; break; // HANGUL SYLLABLE MIEUM YE NIEUNHIEUH
    case 0x9181: code_point = 0xBA93; break; // HANGUL SYLLABLE MIEUM YE TIKEUT
    case 0x9182: code_point = 0xBA94; break; // HANGUL SYLLABLE MIEUM YE RIEUL
    case 0x9183: code_point = 0xBA95; break; // HANGUL SYLLABLE MIEUM YE RIEULKIYEOK
    case 0x9184: code_point = 0xBA96; break; // HANGUL SYLLABLE MIEUM YE RIEULMIEUM
    case 0x9185: code_point = 0xBA97; break; // HANGUL SYLLABLE MIEUM YE RIEULPIEUP
    case 0x9186: code_point = 0xBA98; break; // HANGUL SYLLABLE MIEUM YE RIEULSIOS
    case 0x9187: code_point = 0xBA99; break; // HANGUL SYLLABLE MIEUM YE RIEULTHIEUTH
    case 0x9188: code_point = 0xBA9A; break; // HANGUL SYLLABLE MIEUM YE RIEULPHIEUPH
    case 0x9189: code_point = 0xBA9B; break; // HANGUL SYLLABLE MIEUM YE RIEULHIEUH
    case 0x918A: code_point = 0xBA9C; break; // HANGUL SYLLABLE MIEUM YE MIEUM
    case 0x918B: code_point = 0xBA9D; break; // HANGUL SYLLABLE MIEUM YE PIEUP
    case 0x918C: code_point = 0xBA9E; break; // HANGUL SYLLABLE MIEUM YE PIEUPSIOS
    case 0x918D: code_point = 0xBA9F; break; // HANGUL SYLLABLE MIEUM YE SIOS
    case 0x918E: code_point = 0xBAA0; break; // HANGUL SYLLABLE MIEUM YE SSANGSIOS
    case 0x918F: code_point = 0xBAA1; break; // HANGUL SYLLABLE MIEUM YE IEUNG
    case 0x9190: code_point = 0xBAA2; break; // HANGUL SYLLABLE MIEUM YE CIEUC
    case 0x9191: code_point = 0xBAA3; break; // HANGUL SYLLABLE MIEUM YE CHIEUCH
    case 0x9192: code_point = 0xBAA4; break; // HANGUL SYLLABLE MIEUM YE KHIEUKH
    case 0x9193: code_point = 0xBAA5; break; // HANGUL SYLLABLE MIEUM YE THIEUTH
    case 0x9194: code_point = 0xBAA6; break; // HANGUL SYLLABLE MIEUM YE PHIEUPH
    case 0x9195: code_point = 0xBAA7; break; // HANGUL SYLLABLE MIEUM YE HIEUH
    case 0x9196: code_point = 0xBAAA; break; // HANGUL SYLLABLE MIEUM O SSANGKIYEOK
    case 0x9197: code_point = 0xBAAD; break; // HANGUL SYLLABLE MIEUM O NIEUNCIEUC
    case 0x9198: code_point = 0xBAAE; break; // HANGUL SYLLABLE MIEUM O NIEUNHIEUH
    case 0x9199: code_point = 0xBAAF; break; // HANGUL SYLLABLE MIEUM O TIKEUT
    case 0x919A: code_point = 0xBAB1; break; // HANGUL SYLLABLE MIEUM O RIEULKIYEOK
    case 0x919B: code_point = 0xBAB3; break; // HANGUL SYLLABLE MIEUM O RIEULPIEUP
    case 0x919C: code_point = 0xBAB4; break; // HANGUL SYLLABLE MIEUM O RIEULSIOS
    case 0x919D: code_point = 0xBAB5; break; // HANGUL SYLLABLE MIEUM O RIEULTHIEUTH
    case 0x919E: code_point = 0xBAB6; break; // HANGUL SYLLABLE MIEUM O RIEULPHIEUPH
    case 0x919F: code_point = 0xBAB7; break; // HANGUL SYLLABLE MIEUM O RIEULHIEUH
    case 0x91A0: code_point = 0xBABA; break; // HANGUL SYLLABLE MIEUM O PIEUPSIOS
    case 0x91A1: code_point = 0xBABC; break; // HANGUL SYLLABLE MIEUM O SSANGSIOS
    case 0x91A2: code_point = 0xBABE; break; // HANGUL SYLLABLE MIEUM O CIEUC
    case 0x91A3: code_point = 0xBABF; break; // HANGUL SYLLABLE MIEUM O CHIEUCH
    case 0x91A4: code_point = 0xBAC0; break; // HANGUL SYLLABLE MIEUM O KHIEUKH
    case 0x91A5: code_point = 0xBAC1; break; // HANGUL SYLLABLE MIEUM O THIEUTH
    case 0x91A6: code_point = 0xBAC2; break; // HANGUL SYLLABLE MIEUM O PHIEUPH
    case 0x91A7: code_point = 0xBAC3; break; // HANGUL SYLLABLE MIEUM O HIEUH
    case 0x91A8: code_point = 0xBAC5; break; // HANGUL SYLLABLE MIEUM WA KIYEOK
    case 0x91A9: code_point = 0xBAC6; break; // HANGUL SYLLABLE MIEUM WA SSANGKIYEOK
    case 0x91AA: code_point = 0xBAC7; break; // HANGUL SYLLABLE MIEUM WA KIYEOKSIOS
    case 0x91AB: code_point = 0xBAC9; break; // HANGUL SYLLABLE MIEUM WA NIEUNCIEUC
    case 0x91AC: code_point = 0xBACA; break; // HANGUL SYLLABLE MIEUM WA NIEUNHIEUH
    case 0x91AD: code_point = 0xBACB; break; // HANGUL SYLLABLE MIEUM WA TIKEUT
    case 0x91AE: code_point = 0xBACC; break; // HANGUL SYLLABLE MIEUM WA RIEUL
    case 0x91AF: code_point = 0xBACD; break; // HANGUL SYLLABLE MIEUM WA RIEULKIYEOK
    case 0x91B0: code_point = 0xBACE; break; // HANGUL SYLLABLE MIEUM WA RIEULMIEUM
    case 0x91B1: code_point = 0xBACF; break; // HANGUL SYLLABLE MIEUM WA RIEULPIEUP
    case 0x91B2: code_point = 0xBAD0; break; // HANGUL SYLLABLE MIEUM WA RIEULSIOS
    case 0x91B3: code_point = 0xBAD1; break; // HANGUL SYLLABLE MIEUM WA RIEULTHIEUTH
    case 0x91B4: code_point = 0xBAD2; break; // HANGUL SYLLABLE MIEUM WA RIEULPHIEUPH
    case 0x91B5: code_point = 0xBAD3; break; // HANGUL SYLLABLE MIEUM WA RIEULHIEUH
    case 0x91B6: code_point = 0xBAD4; break; // HANGUL SYLLABLE MIEUM WA MIEUM
    case 0x91B7: code_point = 0xBAD5; break; // HANGUL SYLLABLE MIEUM WA PIEUP
    case 0x91B8: code_point = 0xBAD6; break; // HANGUL SYLLABLE MIEUM WA PIEUPSIOS
    case 0x91B9: code_point = 0xBAD7; break; // HANGUL SYLLABLE MIEUM WA SIOS
    case 0x91BA: code_point = 0xBADA; break; // HANGUL SYLLABLE MIEUM WA CIEUC
    case 0x91BB: code_point = 0xBADB; break; // HANGUL SYLLABLE MIEUM WA CHIEUCH
    case 0x91BC: code_point = 0xBADC; break; // HANGUL SYLLABLE MIEUM WA KHIEUKH
    case 0x91BD: code_point = 0xBADD; break; // HANGUL SYLLABLE MIEUM WA THIEUTH
    case 0x91BE: code_point = 0xBADE; break; // HANGUL SYLLABLE MIEUM WA PHIEUPH
    case 0x91BF: code_point = 0xBADF; break; // HANGUL SYLLABLE MIEUM WA HIEUH
    case 0x91C0: code_point = 0xBAE0; break; // HANGUL SYLLABLE MIEUM WAE
    case 0x91C1: code_point = 0xBAE1; break; // HANGUL SYLLABLE MIEUM WAE KIYEOK
    case 0x91C2: code_point = 0xBAE2; break; // HANGUL SYLLABLE MIEUM WAE SSANGKIYEOK
    case 0x91C3: code_point = 0xBAE3; break; // HANGUL SYLLABLE MIEUM WAE KIYEOKSIOS
    case 0x91C4: code_point = 0xBAE4; break; // HANGUL SYLLABLE MIEUM WAE NIEUN
    case 0x91C5: code_point = 0xBAE5; break; // HANGUL SYLLABLE MIEUM WAE NIEUNCIEUC
    case 0x91C6: code_point = 0xBAE6; break; // HANGUL SYLLABLE MIEUM WAE NIEUNHIEUH
    case 0x91C7: code_point = 0xBAE7; break; // HANGUL SYLLABLE MIEUM WAE TIKEUT
    case 0x91C8: code_point = 0xBAE8; break; // HANGUL SYLLABLE MIEUM WAE RIEUL
    case 0x91C9: code_point = 0xBAE9; break; // HANGUL SYLLABLE MIEUM WAE RIEULKIYEOK
    case 0x91CA: code_point = 0xBAEA; break; // HANGUL SYLLABLE MIEUM WAE RIEULMIEUM
    case 0x91CB: code_point = 0xBAEB; break; // HANGUL SYLLABLE MIEUM WAE RIEULPIEUP
    case 0x91CC: code_point = 0xBAEC; break; // HANGUL SYLLABLE MIEUM WAE RIEULSIOS
    case 0x91CD: code_point = 0xBAED; break; // HANGUL SYLLABLE MIEUM WAE RIEULTHIEUTH
    case 0x91CE: code_point = 0xBAEE; break; // HANGUL SYLLABLE MIEUM WAE RIEULPHIEUPH
    case 0x91CF: code_point = 0xBAEF; break; // HANGUL SYLLABLE MIEUM WAE RIEULHIEUH
    case 0x91D0: code_point = 0xBAF0; break; // HANGUL SYLLABLE MIEUM WAE MIEUM
    case 0x91D1: code_point = 0xBAF1; break; // HANGUL SYLLABLE MIEUM WAE PIEUP
    case 0x91D2: code_point = 0xBAF2; break; // HANGUL SYLLABLE MIEUM WAE PIEUPSIOS
    case 0x91D3: code_point = 0xBAF3; break; // HANGUL SYLLABLE MIEUM WAE SIOS
    case 0x91D4: code_point = 0xBAF4; break; // HANGUL SYLLABLE MIEUM WAE SSANGSIOS
    case 0x91D5: code_point = 0xBAF5; break; // HANGUL SYLLABLE MIEUM WAE IEUNG
    case 0x91D6: code_point = 0xBAF6; break; // HANGUL SYLLABLE MIEUM WAE CIEUC
    case 0x91D7: code_point = 0xBAF7; break; // HANGUL SYLLABLE MIEUM WAE CHIEUCH
    case 0x91D8: code_point = 0xBAF8; break; // HANGUL SYLLABLE MIEUM WAE KHIEUKH
    case 0x91D9: code_point = 0xBAF9; break; // HANGUL SYLLABLE MIEUM WAE THIEUTH
    case 0x91DA: code_point = 0xBAFA; break; // HANGUL SYLLABLE MIEUM WAE PHIEUPH
    case 0x91DB: code_point = 0xBAFB; break; // HANGUL SYLLABLE MIEUM WAE HIEUH
    case 0x91DC: code_point = 0xBAFD; break; // HANGUL SYLLABLE MIEUM OE KIYEOK
    case 0x91DD: code_point = 0xBAFE; break; // HANGUL SYLLABLE MIEUM OE SSANGKIYEOK
    case 0x91DE: code_point = 0xBAFF; break; // HANGUL SYLLABLE MIEUM OE KIYEOKSIOS
    case 0x91DF: code_point = 0xBB01; break; // HANGUL SYLLABLE MIEUM OE NIEUNCIEUC
    case 0x91E0: code_point = 0xBB02; break; // HANGUL SYLLABLE MIEUM OE NIEUNHIEUH
    case 0x91E1: code_point = 0xBB03; break; // HANGUL SYLLABLE MIEUM OE TIKEUT
    case 0x91E2: code_point = 0xBB05; break; // HANGUL SYLLABLE MIEUM OE RIEULKIYEOK
    case 0x91E3: code_point = 0xBB06; break; // HANGUL SYLLABLE MIEUM OE RIEULMIEUM
    case 0x91E4: code_point = 0xBB07; break; // HANGUL SYLLABLE MIEUM OE RIEULPIEUP
    case 0x91E5: code_point = 0xBB08; break; // HANGUL SYLLABLE MIEUM OE RIEULSIOS
    case 0x91E6: code_point = 0xBB09; break; // HANGUL SYLLABLE MIEUM OE RIEULTHIEUTH
    case 0x91E7: code_point = 0xBB0A; break; // HANGUL SYLLABLE MIEUM OE RIEULPHIEUPH
    case 0x91E8: code_point = 0xBB0B; break; // HANGUL SYLLABLE MIEUM OE RIEULHIEUH
    case 0x91E9: code_point = 0xBB0C; break; // HANGUL SYLLABLE MIEUM OE MIEUM
    case 0x91EA: code_point = 0xBB0E; break; // HANGUL SYLLABLE MIEUM OE PIEUPSIOS
    case 0x91EB: code_point = 0xBB10; break; // HANGUL SYLLABLE MIEUM OE SSANGSIOS
    case 0x91EC: code_point = 0xBB12; break; // HANGUL SYLLABLE MIEUM OE CIEUC
    case 0x91ED: code_point = 0xBB13; break; // HANGUL SYLLABLE MIEUM OE CHIEUCH
    case 0x91EE: code_point = 0xBB14; break; // HANGUL SYLLABLE MIEUM OE KHIEUKH
    case 0x91EF: code_point = 0xBB15; break; // HANGUL SYLLABLE MIEUM OE THIEUTH
    case 0x91F0: code_point = 0xBB16; break; // HANGUL SYLLABLE MIEUM OE PHIEUPH
    case 0x91F1: code_point = 0xBB17; break; // HANGUL SYLLABLE MIEUM OE HIEUH
    case 0x91F2: code_point = 0xBB19; break; // HANGUL SYLLABLE MIEUM YO KIYEOK
    case 0x91F3: code_point = 0xBB1A; break; // HANGUL SYLLABLE MIEUM YO SSANGKIYEOK
    case 0x91F4: code_point = 0xBB1B; break; // HANGUL SYLLABLE MIEUM YO KIYEOKSIOS
    case 0x91F5: code_point = 0xBB1D; break; // HANGUL SYLLABLE MIEUM YO NIEUNCIEUC
    case 0x91F6: code_point = 0xBB1E; break; // HANGUL SYLLABLE MIEUM YO NIEUNHIEUH
    case 0x91F7: code_point = 0xBB1F; break; // HANGUL SYLLABLE MIEUM YO TIKEUT
    case 0x91F8: code_point = 0xBB21; break; // HANGUL SYLLABLE MIEUM YO RIEULKIYEOK
    case 0x91F9: code_point = 0xBB22; break; // HANGUL SYLLABLE MIEUM YO RIEULMIEUM
    case 0x91FA: code_point = 0xBB23; break; // HANGUL SYLLABLE MIEUM YO RIEULPIEUP
    case 0x91FB: code_point = 0xBB24; break; // HANGUL SYLLABLE MIEUM YO RIEULSIOS
    case 0x91FC: code_point = 0xBB25; break; // HANGUL SYLLABLE MIEUM YO RIEULTHIEUTH
    case 0x91FD: code_point = 0xBB26; break; // HANGUL SYLLABLE MIEUM YO RIEULPHIEUPH
    case 0x91FE: code_point = 0xBB27; break; // HANGUL SYLLABLE MIEUM YO RIEULHIEUH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x92(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9241: code_point = 0xBB28; break; // HANGUL SYLLABLE MIEUM YO MIEUM
    case 0x9242: code_point = 0xBB2A; break; // HANGUL SYLLABLE MIEUM YO PIEUPSIOS
    case 0x9243: code_point = 0xBB2C; break; // HANGUL SYLLABLE MIEUM YO SSANGSIOS
    case 0x9244: code_point = 0xBB2D; break; // HANGUL SYLLABLE MIEUM YO IEUNG
    case 0x9245: code_point = 0xBB2E; break; // HANGUL SYLLABLE MIEUM YO CIEUC
    case 0x9246: code_point = 0xBB2F; break; // HANGUL SYLLABLE MIEUM YO CHIEUCH
    case 0x9247: code_point = 0xBB30; break; // HANGUL SYLLABLE MIEUM YO KHIEUKH
    case 0x9248: code_point = 0xBB31; break; // HANGUL SYLLABLE MIEUM YO THIEUTH
    case 0x9249: code_point = 0xBB32; break; // HANGUL SYLLABLE MIEUM YO PHIEUPH
    case 0x924A: code_point = 0xBB33; break; // HANGUL SYLLABLE MIEUM YO HIEUH
    case 0x924B: code_point = 0xBB37; break; // HANGUL SYLLABLE MIEUM U KIYEOKSIOS
    case 0x924C: code_point = 0xBB39; break; // HANGUL SYLLABLE MIEUM U NIEUNCIEUC
    case 0x924D: code_point = 0xBB3A; break; // HANGUL SYLLABLE MIEUM U NIEUNHIEUH
    case 0x924E: code_point = 0xBB3F; break; // HANGUL SYLLABLE MIEUM U RIEULPIEUP
    case 0x924F: code_point = 0xBB40; break; // HANGUL SYLLABLE MIEUM U RIEULSIOS
    case 0x9250: code_point = 0xBB41; break; // HANGUL SYLLABLE MIEUM U RIEULTHIEUTH
    case 0x9251: code_point = 0xBB42; break; // HANGUL SYLLABLE MIEUM U RIEULPHIEUPH
    case 0x9252: code_point = 0xBB43; break; // HANGUL SYLLABLE MIEUM U RIEULHIEUH
    case 0x9253: code_point = 0xBB46; break; // HANGUL SYLLABLE MIEUM U PIEUPSIOS
    case 0x9254: code_point = 0xBB48; break; // HANGUL SYLLABLE MIEUM U SSANGSIOS
    case 0x9255: code_point = 0xBB4A; break; // HANGUL SYLLABLE MIEUM U CIEUC
    case 0x9256: code_point = 0xBB4B; break; // HANGUL SYLLABLE MIEUM U CHIEUCH
    case 0x9257: code_point = 0xBB4C; break; // HANGUL SYLLABLE MIEUM U KHIEUKH
    case 0x9258: code_point = 0xBB4E; break; // HANGUL SYLLABLE MIEUM U PHIEUPH
    case 0x9259: code_point = 0xBB51; break; // HANGUL SYLLABLE MIEUM WEO KIYEOK
    case 0x925A: code_point = 0xBB52; break; // HANGUL SYLLABLE MIEUM WEO SSANGKIYEOK
    case 0x9261: code_point = 0xBB53; break; // HANGUL SYLLABLE MIEUM WEO KIYEOKSIOS
    case 0x9262: code_point = 0xBB55; break; // HANGUL SYLLABLE MIEUM WEO NIEUNCIEUC
    case 0x9263: code_point = 0xBB56; break; // HANGUL SYLLABLE MIEUM WEO NIEUNHIEUH
    case 0x9264: code_point = 0xBB57; break; // HANGUL SYLLABLE MIEUM WEO TIKEUT
    case 0x9265: code_point = 0xBB59; break; // HANGUL SYLLABLE MIEUM WEO RIEULKIYEOK
    case 0x9266: code_point = 0xBB5A; break; // HANGUL SYLLABLE MIEUM WEO RIEULMIEUM
    case 0x9267: code_point = 0xBB5B; break; // HANGUL SYLLABLE MIEUM WEO RIEULPIEUP
    case 0x9268: code_point = 0xBB5C; break; // HANGUL SYLLABLE MIEUM WEO RIEULSIOS
    case 0x9269: code_point = 0xBB5D; break; // HANGUL SYLLABLE MIEUM WEO RIEULTHIEUTH
    case 0x926A: code_point = 0xBB5E; break; // HANGUL SYLLABLE MIEUM WEO RIEULPHIEUPH
    case 0x926B: code_point = 0xBB5F; break; // HANGUL SYLLABLE MIEUM WEO RIEULHIEUH
    case 0x926C: code_point = 0xBB60; break; // HANGUL SYLLABLE MIEUM WEO MIEUM
    case 0x926D: code_point = 0xBB62; break; // HANGUL SYLLABLE MIEUM WEO PIEUPSIOS
    case 0x926E: code_point = 0xBB64; break; // HANGUL SYLLABLE MIEUM WEO SSANGSIOS
    case 0x926F: code_point = 0xBB65; break; // HANGUL SYLLABLE MIEUM WEO IEUNG
    case 0x9270: code_point = 0xBB66; break; // HANGUL SYLLABLE MIEUM WEO CIEUC
    case 0x9271: code_point = 0xBB67; break; // HANGUL SYLLABLE MIEUM WEO CHIEUCH
    case 0x9272: code_point = 0xBB68; break; // HANGUL SYLLABLE MIEUM WEO KHIEUKH
    case 0x9273: code_point = 0xBB69; break; // HANGUL SYLLABLE MIEUM WEO THIEUTH
    case 0x9274: code_point = 0xBB6A; break; // HANGUL SYLLABLE MIEUM WEO PHIEUPH
    case 0x9275: code_point = 0xBB6B; break; // HANGUL SYLLABLE MIEUM WEO HIEUH
    case 0x9276: code_point = 0xBB6D; break; // HANGUL SYLLABLE MIEUM WE KIYEOK
    case 0x9277: code_point = 0xBB6E; break; // HANGUL SYLLABLE MIEUM WE SSANGKIYEOK
    case 0x9278: code_point = 0xBB6F; break; // HANGUL SYLLABLE MIEUM WE KIYEOKSIOS
    case 0x9279: code_point = 0xBB70; break; // HANGUL SYLLABLE MIEUM WE NIEUN
    case 0x927A: code_point = 0xBB71; break; // HANGUL SYLLABLE MIEUM WE NIEUNCIEUC
    case 0x9281: code_point = 0xBB72; break; // HANGUL SYLLABLE MIEUM WE NIEUNHIEUH
    case 0x9282: code_point = 0xBB73; break; // HANGUL SYLLABLE MIEUM WE TIKEUT
    case 0x9283: code_point = 0xBB74; break; // HANGUL SYLLABLE MIEUM WE RIEUL
    case 0x9284: code_point = 0xBB75; break; // HANGUL SYLLABLE MIEUM WE RIEULKIYEOK
    case 0x9285: code_point = 0xBB76; break; // HANGUL SYLLABLE MIEUM WE RIEULMIEUM
    case 0x9286: code_point = 0xBB77; break; // HANGUL SYLLABLE MIEUM WE RIEULPIEUP
    case 0x9287: code_point = 0xBB78; break; // HANGUL SYLLABLE MIEUM WE RIEULSIOS
    case 0x9288: code_point = 0xBB79; break; // HANGUL SYLLABLE MIEUM WE RIEULTHIEUTH
    case 0x9289: code_point = 0xBB7A; break; // HANGUL SYLLABLE MIEUM WE RIEULPHIEUPH
    case 0x928A: code_point = 0xBB7B; break; // HANGUL SYLLABLE MIEUM WE RIEULHIEUH
    case 0x928B: code_point = 0xBB7C; break; // HANGUL SYLLABLE MIEUM WE MIEUM
    case 0x928C: code_point = 0xBB7D; break; // HANGUL SYLLABLE MIEUM WE PIEUP
    case 0x928D: code_point = 0xBB7E; break; // HANGUL SYLLABLE MIEUM WE PIEUPSIOS
    case 0x928E: code_point = 0xBB7F; break; // HANGUL SYLLABLE MIEUM WE SIOS
    case 0x928F: code_point = 0xBB80; break; // HANGUL SYLLABLE MIEUM WE SSANGSIOS
    case 0x9290: code_point = 0xBB81; break; // HANGUL SYLLABLE MIEUM WE IEUNG
    case 0x9291: code_point = 0xBB82; break; // HANGUL SYLLABLE MIEUM WE CIEUC
    case 0x9292: code_point = 0xBB83; break; // HANGUL SYLLABLE MIEUM WE CHIEUCH
    case 0x9293: code_point = 0xBB84; break; // HANGUL SYLLABLE MIEUM WE KHIEUKH
    case 0x9294: code_point = 0xBB85; break; // HANGUL SYLLABLE MIEUM WE THIEUTH
    case 0x9295: code_point = 0xBB86; break; // HANGUL SYLLABLE MIEUM WE PHIEUPH
    case 0x9296: code_point = 0xBB87; break; // HANGUL SYLLABLE MIEUM WE HIEUH
    case 0x9297: code_point = 0xBB89; break; // HANGUL SYLLABLE MIEUM WI KIYEOK
    case 0x9298: code_point = 0xBB8A; break; // HANGUL SYLLABLE MIEUM WI SSANGKIYEOK
    case 0x9299: code_point = 0xBB8B; break; // HANGUL SYLLABLE MIEUM WI KIYEOKSIOS
    case 0x929A: code_point = 0xBB8D; break; // HANGUL SYLLABLE MIEUM WI NIEUNCIEUC
    case 0x929B: code_point = 0xBB8E; break; // HANGUL SYLLABLE MIEUM WI NIEUNHIEUH
    case 0x929C: code_point = 0xBB8F; break; // HANGUL SYLLABLE MIEUM WI TIKEUT
    case 0x929D: code_point = 0xBB91; break; // HANGUL SYLLABLE MIEUM WI RIEULKIYEOK
    case 0x929E: code_point = 0xBB92; break; // HANGUL SYLLABLE MIEUM WI RIEULMIEUM
    case 0x929F: code_point = 0xBB93; break; // HANGUL SYLLABLE MIEUM WI RIEULPIEUP
    case 0x92A0: code_point = 0xBB94; break; // HANGUL SYLLABLE MIEUM WI RIEULSIOS
    case 0x92A1: code_point = 0xBB95; break; // HANGUL SYLLABLE MIEUM WI RIEULTHIEUTH
    case 0x92A2: code_point = 0xBB96; break; // HANGUL SYLLABLE MIEUM WI RIEULPHIEUPH
    case 0x92A3: code_point = 0xBB97; break; // HANGUL SYLLABLE MIEUM WI RIEULHIEUH
    case 0x92A4: code_point = 0xBB98; break; // HANGUL SYLLABLE MIEUM WI MIEUM
    case 0x92A5: code_point = 0xBB99; break; // HANGUL SYLLABLE MIEUM WI PIEUP
    case 0x92A6: code_point = 0xBB9A; break; // HANGUL SYLLABLE MIEUM WI PIEUPSIOS
    case 0x92A7: code_point = 0xBB9B; break; // HANGUL SYLLABLE MIEUM WI SIOS
    case 0x92A8: code_point = 0xBB9C; break; // HANGUL SYLLABLE MIEUM WI SSANGSIOS
    case 0x92A9: code_point = 0xBB9D; break; // HANGUL SYLLABLE MIEUM WI IEUNG
    case 0x92AA: code_point = 0xBB9E; break; // HANGUL SYLLABLE MIEUM WI CIEUC
    case 0x92AB: code_point = 0xBB9F; break; // HANGUL SYLLABLE MIEUM WI CHIEUCH
    case 0x92AC: code_point = 0xBBA0; break; // HANGUL SYLLABLE MIEUM WI KHIEUKH
    case 0x92AD: code_point = 0xBBA1; break; // HANGUL SYLLABLE MIEUM WI THIEUTH
    case 0x92AE: code_point = 0xBBA2; break; // HANGUL SYLLABLE MIEUM WI PHIEUPH
    case 0x92AF: code_point = 0xBBA3; break; // HANGUL SYLLABLE MIEUM WI HIEUH
    case 0x92B0: code_point = 0xBBA5; break; // HANGUL SYLLABLE MIEUM YU KIYEOK
    case 0x92B1: code_point = 0xBBA6; break; // HANGUL SYLLABLE MIEUM YU SSANGKIYEOK
    case 0x92B2: code_point = 0xBBA7; break; // HANGUL SYLLABLE MIEUM YU KIYEOKSIOS
    case 0x92B3: code_point = 0xBBA9; break; // HANGUL SYLLABLE MIEUM YU NIEUNCIEUC
    case 0x92B4: code_point = 0xBBAA; break; // HANGUL SYLLABLE MIEUM YU NIEUNHIEUH
    case 0x92B5: code_point = 0xBBAB; break; // HANGUL SYLLABLE MIEUM YU TIKEUT
    case 0x92B6: code_point = 0xBBAD; break; // HANGUL SYLLABLE MIEUM YU RIEULKIYEOK
    case 0x92B7: code_point = 0xBBAE; break; // HANGUL SYLLABLE MIEUM YU RIEULMIEUM
    case 0x92B8: code_point = 0xBBAF; break; // HANGUL SYLLABLE MIEUM YU RIEULPIEUP
    case 0x92B9: code_point = 0xBBB0; break; // HANGUL SYLLABLE MIEUM YU RIEULSIOS
    case 0x92BA: code_point = 0xBBB1; break; // HANGUL SYLLABLE MIEUM YU RIEULTHIEUTH
    case 0x92BB: code_point = 0xBBB2; break; // HANGUL SYLLABLE MIEUM YU RIEULPHIEUPH
    case 0x92BC: code_point = 0xBBB3; break; // HANGUL SYLLABLE MIEUM YU RIEULHIEUH
    case 0x92BD: code_point = 0xBBB5; break; // HANGUL SYLLABLE MIEUM YU PIEUP
    case 0x92BE: code_point = 0xBBB6; break; // HANGUL SYLLABLE MIEUM YU PIEUPSIOS
    case 0x92BF: code_point = 0xBBB8; break; // HANGUL SYLLABLE MIEUM YU SSANGSIOS
    case 0x92C0: code_point = 0xBBB9; break; // HANGUL SYLLABLE MIEUM YU IEUNG
    case 0x92C1: code_point = 0xBBBA; break; // HANGUL SYLLABLE MIEUM YU CIEUC
    case 0x92C2: code_point = 0xBBBB; break; // HANGUL SYLLABLE MIEUM YU CHIEUCH
    case 0x92C3: code_point = 0xBBBC; break; // HANGUL SYLLABLE MIEUM YU KHIEUKH
    case 0x92C4: code_point = 0xBBBD; break; // HANGUL SYLLABLE MIEUM YU THIEUTH
    case 0x92C5: code_point = 0xBBBE; break; // HANGUL SYLLABLE MIEUM YU PHIEUPH
    case 0x92C6: code_point = 0xBBBF; break; // HANGUL SYLLABLE MIEUM YU HIEUH
    case 0x92C7: code_point = 0xBBC1; break; // HANGUL SYLLABLE MIEUM EU KIYEOK
    case 0x92C8: code_point = 0xBBC2; break; // HANGUL SYLLABLE MIEUM EU SSANGKIYEOK
    case 0x92C9: code_point = 0xBBC3; break; // HANGUL SYLLABLE MIEUM EU KIYEOKSIOS
    case 0x92CA: code_point = 0xBBC5; break; // HANGUL SYLLABLE MIEUM EU NIEUNCIEUC
    case 0x92CB: code_point = 0xBBC6; break; // HANGUL SYLLABLE MIEUM EU NIEUNHIEUH
    case 0x92CC: code_point = 0xBBC7; break; // HANGUL SYLLABLE MIEUM EU TIKEUT
    case 0x92CD: code_point = 0xBBC9; break; // HANGUL SYLLABLE MIEUM EU RIEULKIYEOK
    case 0x92CE: code_point = 0xBBCA; break; // HANGUL SYLLABLE MIEUM EU RIEULMIEUM
    case 0x92CF: code_point = 0xBBCB; break; // HANGUL SYLLABLE MIEUM EU RIEULPIEUP
    case 0x92D0: code_point = 0xBBCC; break; // HANGUL SYLLABLE MIEUM EU RIEULSIOS
    case 0x92D1: code_point = 0xBBCD; break; // HANGUL SYLLABLE MIEUM EU RIEULTHIEUTH
    case 0x92D2: code_point = 0xBBCE; break; // HANGUL SYLLABLE MIEUM EU RIEULPHIEUPH
    case 0x92D3: code_point = 0xBBCF; break; // HANGUL SYLLABLE MIEUM EU RIEULHIEUH
    case 0x92D4: code_point = 0xBBD1; break; // HANGUL SYLLABLE MIEUM EU PIEUP
    case 0x92D5: code_point = 0xBBD2; break; // HANGUL SYLLABLE MIEUM EU PIEUPSIOS
    case 0x92D6: code_point = 0xBBD4; break; // HANGUL SYLLABLE MIEUM EU SSANGSIOS
    case 0x92D7: code_point = 0xBBD5; break; // HANGUL SYLLABLE MIEUM EU IEUNG
    case 0x92D8: code_point = 0xBBD6; break; // HANGUL SYLLABLE MIEUM EU CIEUC
    case 0x92D9: code_point = 0xBBD7; break; // HANGUL SYLLABLE MIEUM EU CHIEUCH
    case 0x92DA: code_point = 0xBBD8; break; // HANGUL SYLLABLE MIEUM EU KHIEUKH
    case 0x92DB: code_point = 0xBBD9; break; // HANGUL SYLLABLE MIEUM EU THIEUTH
    case 0x92DC: code_point = 0xBBDA; break; // HANGUL SYLLABLE MIEUM EU PHIEUPH
    case 0x92DD: code_point = 0xBBDB; break; // HANGUL SYLLABLE MIEUM EU HIEUH
    case 0x92DE: code_point = 0xBBDC; break; // HANGUL SYLLABLE MIEUM YI
    case 0x92DF: code_point = 0xBBDD; break; // HANGUL SYLLABLE MIEUM YI KIYEOK
    case 0x92E0: code_point = 0xBBDE; break; // HANGUL SYLLABLE MIEUM YI SSANGKIYEOK
    case 0x92E1: code_point = 0xBBDF; break; // HANGUL SYLLABLE MIEUM YI KIYEOKSIOS
    case 0x92E2: code_point = 0xBBE0; break; // HANGUL SYLLABLE MIEUM YI NIEUN
    case 0x92E3: code_point = 0xBBE1; break; // HANGUL SYLLABLE MIEUM YI NIEUNCIEUC
    case 0x92E4: code_point = 0xBBE2; break; // HANGUL SYLLABLE MIEUM YI NIEUNHIEUH
    case 0x92E5: code_point = 0xBBE3; break; // HANGUL SYLLABLE MIEUM YI TIKEUT
    case 0x92E6: code_point = 0xBBE4; break; // HANGUL SYLLABLE MIEUM YI RIEUL
    case 0x92E7: code_point = 0xBBE5; break; // HANGUL SYLLABLE MIEUM YI RIEULKIYEOK
    case 0x92E8: code_point = 0xBBE6; break; // HANGUL SYLLABLE MIEUM YI RIEULMIEUM
    case 0x92E9: code_point = 0xBBE7; break; // HANGUL SYLLABLE MIEUM YI RIEULPIEUP
    case 0x92EA: code_point = 0xBBE8; break; // HANGUL SYLLABLE MIEUM YI RIEULSIOS
    case 0x92EB: code_point = 0xBBE9; break; // HANGUL SYLLABLE MIEUM YI RIEULTHIEUTH
    case 0x92EC: code_point = 0xBBEA; break; // HANGUL SYLLABLE MIEUM YI RIEULPHIEUPH
    case 0x92ED: code_point = 0xBBEB; break; // HANGUL SYLLABLE MIEUM YI RIEULHIEUH
    case 0x92EE: code_point = 0xBBEC; break; // HANGUL SYLLABLE MIEUM YI MIEUM
    case 0x92EF: code_point = 0xBBED; break; // HANGUL SYLLABLE MIEUM YI PIEUP
    case 0x92F0: code_point = 0xBBEE; break; // HANGUL SYLLABLE MIEUM YI PIEUPSIOS
    case 0x92F1: code_point = 0xBBEF; break; // HANGUL SYLLABLE MIEUM YI SIOS
    case 0x92F2: code_point = 0xBBF0; break; // HANGUL SYLLABLE MIEUM YI SSANGSIOS
    case 0x92F3: code_point = 0xBBF1; break; // HANGUL SYLLABLE MIEUM YI IEUNG
    case 0x92F4: code_point = 0xBBF2; break; // HANGUL SYLLABLE MIEUM YI CIEUC
    case 0x92F5: code_point = 0xBBF3; break; // HANGUL SYLLABLE MIEUM YI CHIEUCH
    case 0x92F6: code_point = 0xBBF4; break; // HANGUL SYLLABLE MIEUM YI KHIEUKH
    case 0x92F7: code_point = 0xBBF5; break; // HANGUL SYLLABLE MIEUM YI THIEUTH
    case 0x92F8: code_point = 0xBBF6; break; // HANGUL SYLLABLE MIEUM YI PHIEUPH
    case 0x92F9: code_point = 0xBBF7; break; // HANGUL SYLLABLE MIEUM YI HIEUH
    case 0x92FA: code_point = 0xBBFA; break; // HANGUL SYLLABLE MIEUM I SSANGKIYEOK
    case 0x92FB: code_point = 0xBBFB; break; // HANGUL SYLLABLE MIEUM I KIYEOKSIOS
    case 0x92FC: code_point = 0xBBFD; break; // HANGUL SYLLABLE MIEUM I NIEUNCIEUC
    case 0x92FD: code_point = 0xBBFE; break; // HANGUL SYLLABLE MIEUM I NIEUNHIEUH
    case 0x92FE: code_point = 0xBC01; break; // HANGUL SYLLABLE MIEUM I RIEULKIYEOK
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x93(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9341: code_point = 0xBC03; break; // HANGUL SYLLABLE MIEUM I RIEULPIEUP
    case 0x9342: code_point = 0xBC04; break; // HANGUL SYLLABLE MIEUM I RIEULSIOS
    case 0x9343: code_point = 0xBC05; break; // HANGUL SYLLABLE MIEUM I RIEULTHIEUTH
    case 0x9344: code_point = 0xBC06; break; // HANGUL SYLLABLE MIEUM I RIEULPHIEUPH
    case 0x9345: code_point = 0xBC07; break; // HANGUL SYLLABLE MIEUM I RIEULHIEUH
    case 0x9346: code_point = 0xBC0A; break; // HANGUL SYLLABLE MIEUM I PIEUPSIOS
    case 0x9347: code_point = 0xBC0E; break; // HANGUL SYLLABLE MIEUM I CIEUC
    case 0x9348: code_point = 0xBC10; break; // HANGUL SYLLABLE MIEUM I KHIEUKH
    case 0x9349: code_point = 0xBC12; break; // HANGUL SYLLABLE MIEUM I PHIEUPH
    case 0x934A: code_point = 0xBC13; break; // HANGUL SYLLABLE MIEUM I HIEUH
    case 0x934B: code_point = 0xBC19; break; // HANGUL SYLLABLE PIEUP A NIEUNCIEUC
    case 0x934C: code_point = 0xBC1A; break; // HANGUL SYLLABLE PIEUP A NIEUNHIEUH
    case 0x934D: code_point = 0xBC20; break; // HANGUL SYLLABLE PIEUP A RIEULSIOS
    case 0x934E: code_point = 0xBC21; break; // HANGUL SYLLABLE PIEUP A RIEULTHIEUTH
    case 0x934F: code_point = 0xBC22; break; // HANGUL SYLLABLE PIEUP A RIEULPHIEUPH
    case 0x9350: code_point = 0xBC23; break; // HANGUL SYLLABLE PIEUP A RIEULHIEUH
    case 0x9351: code_point = 0xBC26; break; // HANGUL SYLLABLE PIEUP A PIEUPSIOS
    case 0x9352: code_point = 0xBC28; break; // HANGUL SYLLABLE PIEUP A SSANGSIOS
    case 0x9353: code_point = 0xBC2A; break; // HANGUL SYLLABLE PIEUP A CIEUC
    case 0x9354: code_point = 0xBC2B; break; // HANGUL SYLLABLE PIEUP A CHIEUCH
    case 0x9355: code_point = 0xBC2C; break; // HANGUL SYLLABLE PIEUP A KHIEUKH
    case 0x9356: code_point = 0xBC2E; break; // HANGUL SYLLABLE PIEUP A PHIEUPH
    case 0x9357: code_point = 0xBC2F; break; // HANGUL SYLLABLE PIEUP A HIEUH
    case 0x9358: code_point = 0xBC32; break; // HANGUL SYLLABLE PIEUP AE SSANGKIYEOK
    case 0x9359: code_point = 0xBC33; break; // HANGUL SYLLABLE PIEUP AE KIYEOKSIOS
    case 0x935A: code_point = 0xBC35; break; // HANGUL SYLLABLE PIEUP AE NIEUNCIEUC
    case 0x9361: code_point = 0xBC36; break; // HANGUL SYLLABLE PIEUP AE NIEUNHIEUH
    case 0x9362: code_point = 0xBC37; break; // HANGUL SYLLABLE PIEUP AE TIKEUT
    case 0x9363: code_point = 0xBC39; break; // HANGUL SYLLABLE PIEUP AE RIEULKIYEOK
    case 0x9364: code_point = 0xBC3A; break; // HANGUL SYLLABLE PIEUP AE RIEULMIEUM
    case 0x9365: code_point = 0xBC3B; break; // HANGUL SYLLABLE PIEUP AE RIEULPIEUP
    case 0x9366: code_point = 0xBC3C; break; // HANGUL SYLLABLE PIEUP AE RIEULSIOS
    case 0x9367: code_point = 0xBC3D; break; // HANGUL SYLLABLE PIEUP AE RIEULTHIEUTH
    case 0x9368: code_point = 0xBC3E; break; // HANGUL SYLLABLE PIEUP AE RIEULPHIEUPH
    case 0x9369: code_point = 0xBC3F; break; // HANGUL SYLLABLE PIEUP AE RIEULHIEUH
    case 0x936A: code_point = 0xBC42; break; // HANGUL SYLLABLE PIEUP AE PIEUPSIOS
    case 0x936B: code_point = 0xBC46; break; // HANGUL SYLLABLE PIEUP AE CIEUC
    case 0x936C: code_point = 0xBC47; break; // HANGUL SYLLABLE PIEUP AE CHIEUCH
    case 0x936D: code_point = 0xBC48; break; // HANGUL SYLLABLE PIEUP AE KHIEUKH
    case 0x936E: code_point = 0xBC4A; break; // HANGUL SYLLABLE PIEUP AE PHIEUPH
    case 0x936F: code_point = 0xBC4B; break; // HANGUL SYLLABLE PIEUP AE HIEUH
    case 0x9370: code_point = 0xBC4E; break; // HANGUL SYLLABLE PIEUP YA SSANGKIYEOK
    case 0x9371: code_point = 0xBC4F; break; // HANGUL SYLLABLE PIEUP YA KIYEOKSIOS
    case 0x9372: code_point = 0xBC51; break; // HANGUL SYLLABLE PIEUP YA NIEUNCIEUC
    case 0x9373: code_point = 0xBC52; break; // HANGUL SYLLABLE PIEUP YA NIEUNHIEUH
    case 0x9374: code_point = 0xBC53; break; // HANGUL SYLLABLE PIEUP YA TIKEUT
    case 0x9375: code_point = 0xBC54; break; // HANGUL SYLLABLE PIEUP YA RIEUL
    case 0x9376: code_point = 0xBC55; break; // HANGUL SYLLABLE PIEUP YA RIEULKIYEOK
    case 0x9377: code_point = 0xBC56; break; // HANGUL SYLLABLE PIEUP YA RIEULMIEUM
    case 0x9378: code_point = 0xBC57; break; // HANGUL SYLLABLE PIEUP YA RIEULPIEUP
    case 0x9379: code_point = 0xBC58; break; // HANGUL SYLLABLE PIEUP YA RIEULSIOS
    case 0x937A: code_point = 0xBC59; break; // HANGUL SYLLABLE PIEUP YA RIEULTHIEUTH
    case 0x9381: code_point = 0xBC5A; break; // HANGUL SYLLABLE PIEUP YA RIEULPHIEUPH
    case 0x9382: code_point = 0xBC5B; break; // HANGUL SYLLABLE PIEUP YA RIEULHIEUH
    case 0x9383: code_point = 0xBC5C; break; // HANGUL SYLLABLE PIEUP YA MIEUM
    case 0x9384: code_point = 0xBC5E; break; // HANGUL SYLLABLE PIEUP YA PIEUPSIOS
    case 0x9385: code_point = 0xBC5F; break; // HANGUL SYLLABLE PIEUP YA SIOS
    case 0x9386: code_point = 0xBC60; break; // HANGUL SYLLABLE PIEUP YA SSANGSIOS
    case 0x9387: code_point = 0xBC61; break; // HANGUL SYLLABLE PIEUP YA IEUNG
    case 0x9388: code_point = 0xBC62; break; // HANGUL SYLLABLE PIEUP YA CIEUC
    case 0x9389: code_point = 0xBC63; break; // HANGUL SYLLABLE PIEUP YA CHIEUCH
    case 0x938A: code_point = 0xBC64; break; // HANGUL SYLLABLE PIEUP YA KHIEUKH
    case 0x938B: code_point = 0xBC65; break; // HANGUL SYLLABLE PIEUP YA THIEUTH
    case 0x938C: code_point = 0xBC66; break; // HANGUL SYLLABLE PIEUP YA PHIEUPH
    case 0x938D: code_point = 0xBC67; break; // HANGUL SYLLABLE PIEUP YA HIEUH
    case 0x938E: code_point = 0xBC68; break; // HANGUL SYLLABLE PIEUP YAE
    case 0x938F: code_point = 0xBC69; break; // HANGUL SYLLABLE PIEUP YAE KIYEOK
    case 0x9390: code_point = 0xBC6A; break; // HANGUL SYLLABLE PIEUP YAE SSANGKIYEOK
    case 0x9391: code_point = 0xBC6B; break; // HANGUL SYLLABLE PIEUP YAE KIYEOKSIOS
    case 0x9392: code_point = 0xBC6C; break; // HANGUL SYLLABLE PIEUP YAE NIEUN
    case 0x9393: code_point = 0xBC6D; break; // HANGUL SYLLABLE PIEUP YAE NIEUNCIEUC
    case 0x9394: code_point = 0xBC6E; break; // HANGUL SYLLABLE PIEUP YAE NIEUNHIEUH
    case 0x9395: code_point = 0xBC6F; break; // HANGUL SYLLABLE PIEUP YAE TIKEUT
    case 0x9396: code_point = 0xBC70; break; // HANGUL SYLLABLE PIEUP YAE RIEUL
    case 0x9397: code_point = 0xBC71; break; // HANGUL SYLLABLE PIEUP YAE RIEULKIYEOK
    case 0x9398: code_point = 0xBC72; break; // HANGUL SYLLABLE PIEUP YAE RIEULMIEUM
    case 0x9399: code_point = 0xBC73; break; // HANGUL SYLLABLE PIEUP YAE RIEULPIEUP
    case 0x939A: code_point = 0xBC74; break; // HANGUL SYLLABLE PIEUP YAE RIEULSIOS
    case 0x939B: code_point = 0xBC75; break; // HANGUL SYLLABLE PIEUP YAE RIEULTHIEUTH
    case 0x939C: code_point = 0xBC76; break; // HANGUL SYLLABLE PIEUP YAE RIEULPHIEUPH
    case 0x939D: code_point = 0xBC77; break; // HANGUL SYLLABLE PIEUP YAE RIEULHIEUH
    case 0x939E: code_point = 0xBC78; break; // HANGUL SYLLABLE PIEUP YAE MIEUM
    case 0x939F: code_point = 0xBC79; break; // HANGUL SYLLABLE PIEUP YAE PIEUP
    case 0x93A0: code_point = 0xBC7A; break; // HANGUL SYLLABLE PIEUP YAE PIEUPSIOS
    case 0x93A1: code_point = 0xBC7B; break; // HANGUL SYLLABLE PIEUP YAE SIOS
    case 0x93A2: code_point = 0xBC7C; break; // HANGUL SYLLABLE PIEUP YAE SSANGSIOS
    case 0x93A3: code_point = 0xBC7D; break; // HANGUL SYLLABLE PIEUP YAE IEUNG
    case 0x93A4: code_point = 0xBC7E; break; // HANGUL SYLLABLE PIEUP YAE CIEUC
    case 0x93A5: code_point = 0xBC7F; break; // HANGUL SYLLABLE PIEUP YAE CHIEUCH
    case 0x93A6: code_point = 0xBC80; break; // HANGUL SYLLABLE PIEUP YAE KHIEUKH
    case 0x93A7: code_point = 0xBC81; break; // HANGUL SYLLABLE PIEUP YAE THIEUTH
    case 0x93A8: code_point = 0xBC82; break; // HANGUL SYLLABLE PIEUP YAE PHIEUPH
    case 0x93A9: code_point = 0xBC83; break; // HANGUL SYLLABLE PIEUP YAE HIEUH
    case 0x93AA: code_point = 0xBC86; break; // HANGUL SYLLABLE PIEUP EO SSANGKIYEOK
    case 0x93AB: code_point = 0xBC87; break; // HANGUL SYLLABLE PIEUP EO KIYEOKSIOS
    case 0x93AC: code_point = 0xBC89; break; // HANGUL SYLLABLE PIEUP EO NIEUNCIEUC
    case 0x93AD: code_point = 0xBC8A; break; // HANGUL SYLLABLE PIEUP EO NIEUNHIEUH
    case 0x93AE: code_point = 0xBC8D; break; // HANGUL SYLLABLE PIEUP EO RIEULKIYEOK
    case 0x93AF: code_point = 0xBC8F; break; // HANGUL SYLLABLE PIEUP EO RIEULPIEUP
    case 0x93B0: code_point = 0xBC90; break; // HANGUL SYLLABLE PIEUP EO RIEULSIOS
    case 0x93B1: code_point = 0xBC91; break; // HANGUL SYLLABLE PIEUP EO RIEULTHIEUTH
    case 0x93B2: code_point = 0xBC92; break; // HANGUL SYLLABLE PIEUP EO RIEULPHIEUPH
    case 0x93B3: code_point = 0xBC93; break; // HANGUL SYLLABLE PIEUP EO RIEULHIEUH
    case 0x93B4: code_point = 0xBC96; break; // HANGUL SYLLABLE PIEUP EO PIEUPSIOS
    case 0x93B5: code_point = 0xBC98; break; // HANGUL SYLLABLE PIEUP EO SSANGSIOS
    case 0x93B6: code_point = 0xBC9B; break; // HANGUL SYLLABLE PIEUP EO CHIEUCH
    case 0x93B7: code_point = 0xBC9C; break; // HANGUL SYLLABLE PIEUP EO KHIEUKH
    case 0x93B8: code_point = 0xBC9D; break; // HANGUL SYLLABLE PIEUP EO THIEUTH
    case 0x93B9: code_point = 0xBC9E; break; // HANGUL SYLLABLE PIEUP EO PHIEUPH
    case 0x93BA: code_point = 0xBC9F; break; // HANGUL SYLLABLE PIEUP EO HIEUH
    case 0x93BB: code_point = 0xBCA2; break; // HANGUL SYLLABLE PIEUP E SSANGKIYEOK
    case 0x93BC: code_point = 0xBCA3; break; // HANGUL SYLLABLE PIEUP E KIYEOKSIOS
    case 0x93BD: code_point = 0xBCA5; break; // HANGUL SYLLABLE PIEUP E NIEUNCIEUC
    case 0x93BE: code_point = 0xBCA6; break; // HANGUL SYLLABLE PIEUP E NIEUNHIEUH
    case 0x93BF: code_point = 0xBCA9; break; // HANGUL SYLLABLE PIEUP E RIEULKIYEOK
    case 0x93C0: code_point = 0xBCAA; break; // HANGUL SYLLABLE PIEUP E RIEULMIEUM
    case 0x93C1: code_point = 0xBCAB; break; // HANGUL SYLLABLE PIEUP E RIEULPIEUP
    case 0x93C2: code_point = 0xBCAC; break; // HANGUL SYLLABLE PIEUP E RIEULSIOS
    case 0x93C3: code_point = 0xBCAD; break; // HANGUL SYLLABLE PIEUP E RIEULTHIEUTH
    case 0x93C4: code_point = 0xBCAE; break; // HANGUL SYLLABLE PIEUP E RIEULPHIEUPH
    case 0x93C5: code_point = 0xBCAF; break; // HANGUL SYLLABLE PIEUP E RIEULHIEUH
    case 0x93C6: code_point = 0xBCB2; break; // HANGUL SYLLABLE PIEUP E PIEUPSIOS
    case 0x93C7: code_point = 0xBCB6; break; // HANGUL SYLLABLE PIEUP E CIEUC
    case 0x93C8: code_point = 0xBCB7; break; // HANGUL SYLLABLE PIEUP E CHIEUCH
    case 0x93C9: code_point = 0xBCB8; break; // HANGUL SYLLABLE PIEUP E KHIEUKH
    case 0x93CA: code_point = 0xBCB9; break; // HANGUL SYLLABLE PIEUP E THIEUTH
    case 0x93CB: code_point = 0xBCBA; break; // HANGUL SYLLABLE PIEUP E PHIEUPH
    case 0x93CC: code_point = 0xBCBB; break; // HANGUL SYLLABLE PIEUP E HIEUH
    case 0x93CD: code_point = 0xBCBE; break; // HANGUL SYLLABLE PIEUP YEO SSANGKIYEOK
    case 0x93CE: code_point = 0xBCBF; break; // HANGUL SYLLABLE PIEUP YEO KIYEOKSIOS
    case 0x93CF: code_point = 0xBCC1; break; // HANGUL SYLLABLE PIEUP YEO NIEUNCIEUC
    case 0x93D0: code_point = 0xBCC2; break; // HANGUL SYLLABLE PIEUP YEO NIEUNHIEUH
    case 0x93D1: code_point = 0xBCC3; break; // HANGUL SYLLABLE PIEUP YEO TIKEUT
    case 0x93D2: code_point = 0xBCC5; break; // HANGUL SYLLABLE PIEUP YEO RIEULKIYEOK
    case 0x93D3: code_point = 0xBCC6; break; // HANGUL SYLLABLE PIEUP YEO RIEULMIEUM
    case 0x93D4: code_point = 0xBCC7; break; // HANGUL SYLLABLE PIEUP YEO RIEULPIEUP
    case 0x93D5: code_point = 0xBCC8; break; // HANGUL SYLLABLE PIEUP YEO RIEULSIOS
    case 0x93D6: code_point = 0xBCC9; break; // HANGUL SYLLABLE PIEUP YEO RIEULTHIEUTH
    case 0x93D7: code_point = 0xBCCA; break; // HANGUL SYLLABLE PIEUP YEO RIEULPHIEUPH
    case 0x93D8: code_point = 0xBCCB; break; // HANGUL SYLLABLE PIEUP YEO RIEULHIEUH
    case 0x93D9: code_point = 0xBCCC; break; // HANGUL SYLLABLE PIEUP YEO MIEUM
    case 0x93DA: code_point = 0xBCCE; break; // HANGUL SYLLABLE PIEUP YEO PIEUPSIOS
    case 0x93DB: code_point = 0xBCD2; break; // HANGUL SYLLABLE PIEUP YEO CIEUC
    case 0x93DC: code_point = 0xBCD3; break; // HANGUL SYLLABLE PIEUP YEO CHIEUCH
    case 0x93DD: code_point = 0xBCD4; break; // HANGUL SYLLABLE PIEUP YEO KHIEUKH
    case 0x93DE: code_point = 0xBCD6; break; // HANGUL SYLLABLE PIEUP YEO PHIEUPH
    case 0x93DF: code_point = 0xBCD7; break; // HANGUL SYLLABLE PIEUP YEO HIEUH
    case 0x93E0: code_point = 0xBCD9; break; // HANGUL SYLLABLE PIEUP YE KIYEOK
    case 0x93E1: code_point = 0xBCDA; break; // HANGUL SYLLABLE PIEUP YE SSANGKIYEOK
    case 0x93E2: code_point = 0xBCDB; break; // HANGUL SYLLABLE PIEUP YE KIYEOKSIOS
    case 0x93E3: code_point = 0xBCDD; break; // HANGUL SYLLABLE PIEUP YE NIEUNCIEUC
    case 0x93E4: code_point = 0xBCDE; break; // HANGUL SYLLABLE PIEUP YE NIEUNHIEUH
    case 0x93E5: code_point = 0xBCDF; break; // HANGUL SYLLABLE PIEUP YE TIKEUT
    case 0x93E6: code_point = 0xBCE0; break; // HANGUL SYLLABLE PIEUP YE RIEUL
    case 0x93E7: code_point = 0xBCE1; break; // HANGUL SYLLABLE PIEUP YE RIEULKIYEOK
    case 0x93E8: code_point = 0xBCE2; break; // HANGUL SYLLABLE PIEUP YE RIEULMIEUM
    case 0x93E9: code_point = 0xBCE3; break; // HANGUL SYLLABLE PIEUP YE RIEULPIEUP
    case 0x93EA: code_point = 0xBCE4; break; // HANGUL SYLLABLE PIEUP YE RIEULSIOS
    case 0x93EB: code_point = 0xBCE5; break; // HANGUL SYLLABLE PIEUP YE RIEULTHIEUTH
    case 0x93EC: code_point = 0xBCE6; break; // HANGUL SYLLABLE PIEUP YE RIEULPHIEUPH
    case 0x93ED: code_point = 0xBCE7; break; // HANGUL SYLLABLE PIEUP YE RIEULHIEUH
    case 0x93EE: code_point = 0xBCE8; break; // HANGUL SYLLABLE PIEUP YE MIEUM
    case 0x93EF: code_point = 0xBCE9; break; // HANGUL SYLLABLE PIEUP YE PIEUP
    case 0x93F0: code_point = 0xBCEA; break; // HANGUL SYLLABLE PIEUP YE PIEUPSIOS
    case 0x93F1: code_point = 0xBCEB; break; // HANGUL SYLLABLE PIEUP YE SIOS
    case 0x93F2: code_point = 0xBCEC; break; // HANGUL SYLLABLE PIEUP YE SSANGSIOS
    case 0x93F3: code_point = 0xBCED; break; // HANGUL SYLLABLE PIEUP YE IEUNG
    case 0x93F4: code_point = 0xBCEE; break; // HANGUL SYLLABLE PIEUP YE CIEUC
    case 0x93F5: code_point = 0xBCEF; break; // HANGUL SYLLABLE PIEUP YE CHIEUCH
    case 0x93F6: code_point = 0xBCF0; break; // HANGUL SYLLABLE PIEUP YE KHIEUKH
    case 0x93F7: code_point = 0xBCF1; break; // HANGUL SYLLABLE PIEUP YE THIEUTH
    case 0x93F8: code_point = 0xBCF2; break; // HANGUL SYLLABLE PIEUP YE PHIEUPH
    case 0x93F9: code_point = 0xBCF3; break; // HANGUL SYLLABLE PIEUP YE HIEUH
    case 0x93FA: code_point = 0xBCF7; break; // HANGUL SYLLABLE PIEUP O KIYEOKSIOS
    case 0x93FB: code_point = 0xBCF9; break; // HANGUL SYLLABLE PIEUP O NIEUNCIEUC
    case 0x93FC: code_point = 0xBCFA; break; // HANGUL SYLLABLE PIEUP O NIEUNHIEUH
    case 0x93FD: code_point = 0xBCFB; break; // HANGUL SYLLABLE PIEUP O TIKEUT
    case 0x93FE: code_point = 0xBCFD; break; // HANGUL SYLLABLE PIEUP O RIEULKIYEOK
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x94(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9441: code_point = 0xBCFE; break; // HANGUL SYLLABLE PIEUP O RIEULMIEUM
    case 0x9442: code_point = 0xBCFF; break; // HANGUL SYLLABLE PIEUP O RIEULPIEUP
    case 0x9443: code_point = 0xBD00; break; // HANGUL SYLLABLE PIEUP O RIEULSIOS
    case 0x9444: code_point = 0xBD01; break; // HANGUL SYLLABLE PIEUP O RIEULTHIEUTH
    case 0x9445: code_point = 0xBD02; break; // HANGUL SYLLABLE PIEUP O RIEULPHIEUPH
    case 0x9446: code_point = 0xBD03; break; // HANGUL SYLLABLE PIEUP O RIEULHIEUH
    case 0x9447: code_point = 0xBD06; break; // HANGUL SYLLABLE PIEUP O PIEUPSIOS
    case 0x9448: code_point = 0xBD08; break; // HANGUL SYLLABLE PIEUP O SSANGSIOS
    case 0x9449: code_point = 0xBD0A; break; // HANGUL SYLLABLE PIEUP O CIEUC
    case 0x944A: code_point = 0xBD0B; break; // HANGUL SYLLABLE PIEUP O CHIEUCH
    case 0x944B: code_point = 0xBD0C; break; // HANGUL SYLLABLE PIEUP O KHIEUKH
    case 0x944C: code_point = 0xBD0D; break; // HANGUL SYLLABLE PIEUP O THIEUTH
    case 0x944D: code_point = 0xBD0E; break; // HANGUL SYLLABLE PIEUP O PHIEUPH
    case 0x944E: code_point = 0xBD0F; break; // HANGUL SYLLABLE PIEUP O HIEUH
    case 0x944F: code_point = 0xBD11; break; // HANGUL SYLLABLE PIEUP WA KIYEOK
    case 0x9450: code_point = 0xBD12; break; // HANGUL SYLLABLE PIEUP WA SSANGKIYEOK
    case 0x9451: code_point = 0xBD13; break; // HANGUL SYLLABLE PIEUP WA KIYEOKSIOS
    case 0x9452: code_point = 0xBD15; break; // HANGUL SYLLABLE PIEUP WA NIEUNCIEUC
    case 0x9453: code_point = 0xBD16; break; // HANGUL SYLLABLE PIEUP WA NIEUNHIEUH
    case 0x9454: code_point = 0xBD17; break; // HANGUL SYLLABLE PIEUP WA TIKEUT
    case 0x9455: code_point = 0xBD18; break; // HANGUL SYLLABLE PIEUP WA RIEUL
    case 0x9456: code_point = 0xBD19; break; // HANGUL SYLLABLE PIEUP WA RIEULKIYEOK
    case 0x9457: code_point = 0xBD1A; break; // HANGUL SYLLABLE PIEUP WA RIEULMIEUM
    case 0x9458: code_point = 0xBD1B; break; // HANGUL SYLLABLE PIEUP WA RIEULPIEUP
    case 0x9459: code_point = 0xBD1C; break; // HANGUL SYLLABLE PIEUP WA RIEULSIOS
    case 0x945A: code_point = 0xBD1D; break; // HANGUL SYLLABLE PIEUP WA RIEULTHIEUTH
    case 0x9461: code_point = 0xBD1E; break; // HANGUL SYLLABLE PIEUP WA RIEULPHIEUPH
    case 0x9462: code_point = 0xBD1F; break; // HANGUL SYLLABLE PIEUP WA RIEULHIEUH
    case 0x9463: code_point = 0xBD20; break; // HANGUL SYLLABLE PIEUP WA MIEUM
    case 0x9464: code_point = 0xBD21; break; // HANGUL SYLLABLE PIEUP WA PIEUP
    case 0x9465: code_point = 0xBD22; break; // HANGUL SYLLABLE PIEUP WA PIEUPSIOS
    case 0x9466: code_point = 0xBD23; break; // HANGUL SYLLABLE PIEUP WA SIOS
    case 0x9467: code_point = 0xBD25; break; // HANGUL SYLLABLE PIEUP WA IEUNG
    case 0x9468: code_point = 0xBD26; break; // HANGUL SYLLABLE PIEUP WA CIEUC
    case 0x9469: code_point = 0xBD27; break; // HANGUL SYLLABLE PIEUP WA CHIEUCH
    case 0x946A: code_point = 0xBD28; break; // HANGUL SYLLABLE PIEUP WA KHIEUKH
    case 0x946B: code_point = 0xBD29; break; // HANGUL SYLLABLE PIEUP WA THIEUTH
    case 0x946C: code_point = 0xBD2A; break; // HANGUL SYLLABLE PIEUP WA PHIEUPH
    case 0x946D: code_point = 0xBD2B; break; // HANGUL SYLLABLE PIEUP WA HIEUH
    case 0x946E: code_point = 0xBD2D; break; // HANGUL SYLLABLE PIEUP WAE KIYEOK
    case 0x946F: code_point = 0xBD2E; break; // HANGUL SYLLABLE PIEUP WAE SSANGKIYEOK
    case 0x9470: code_point = 0xBD2F; break; // HANGUL SYLLABLE PIEUP WAE KIYEOKSIOS
    case 0x9471: code_point = 0xBD30; break; // HANGUL SYLLABLE PIEUP WAE NIEUN
    case 0x9472: code_point = 0xBD31; break; // HANGUL SYLLABLE PIEUP WAE NIEUNCIEUC
    case 0x9473: code_point = 0xBD32; break; // HANGUL SYLLABLE PIEUP WAE NIEUNHIEUH
    case 0x9474: code_point = 0xBD33; break; // HANGUL SYLLABLE PIEUP WAE TIKEUT
    case 0x9475: code_point = 0xBD34; break; // HANGUL SYLLABLE PIEUP WAE RIEUL
    case 0x9476: code_point = 0xBD35; break; // HANGUL SYLLABLE PIEUP WAE RIEULKIYEOK
    case 0x9477: code_point = 0xBD36; break; // HANGUL SYLLABLE PIEUP WAE RIEULMIEUM
    case 0x9478: code_point = 0xBD37; break; // HANGUL SYLLABLE PIEUP WAE RIEULPIEUP
    case 0x9479: code_point = 0xBD38; break; // HANGUL SYLLABLE PIEUP WAE RIEULSIOS
    case 0x947A: code_point = 0xBD39; break; // HANGUL SYLLABLE PIEUP WAE RIEULTHIEUTH
    case 0x9481: code_point = 0xBD3A; break; // HANGUL SYLLABLE PIEUP WAE RIEULPHIEUPH
    case 0x9482: code_point = 0xBD3B; break; // HANGUL SYLLABLE PIEUP WAE RIEULHIEUH
    case 0x9483: code_point = 0xBD3C; break; // HANGUL SYLLABLE PIEUP WAE MIEUM
    case 0x9484: code_point = 0xBD3D; break; // HANGUL SYLLABLE PIEUP WAE PIEUP
    case 0x9485: code_point = 0xBD3E; break; // HANGUL SYLLABLE PIEUP WAE PIEUPSIOS
    case 0x9486: code_point = 0xBD3F; break; // HANGUL SYLLABLE PIEUP WAE SIOS
    case 0x9487: code_point = 0xBD41; break; // HANGUL SYLLABLE PIEUP WAE IEUNG
    case 0x9488: code_point = 0xBD42; break; // HANGUL SYLLABLE PIEUP WAE CIEUC
    case 0x9489: code_point = 0xBD43; break; // HANGUL SYLLABLE PIEUP WAE CHIEUCH
    case 0x948A: code_point = 0xBD44; break; // HANGUL SYLLABLE PIEUP WAE KHIEUKH
    case 0x948B: code_point = 0xBD45; break; // HANGUL SYLLABLE PIEUP WAE THIEUTH
    case 0x948C: code_point = 0xBD46; break; // HANGUL SYLLABLE PIEUP WAE PHIEUPH
    case 0x948D: code_point = 0xBD47; break; // HANGUL SYLLABLE PIEUP WAE HIEUH
    case 0x948E: code_point = 0xBD4A; break; // HANGUL SYLLABLE PIEUP OE SSANGKIYEOK
    case 0x948F: code_point = 0xBD4B; break; // HANGUL SYLLABLE PIEUP OE KIYEOKSIOS
    case 0x9490: code_point = 0xBD4D; break; // HANGUL SYLLABLE PIEUP OE NIEUNCIEUC
    case 0x9491: code_point = 0xBD4E; break; // HANGUL SYLLABLE PIEUP OE NIEUNHIEUH
    case 0x9492: code_point = 0xBD4F; break; // HANGUL SYLLABLE PIEUP OE TIKEUT
    case 0x9493: code_point = 0xBD51; break; // HANGUL SYLLABLE PIEUP OE RIEULKIYEOK
    case 0x9494: code_point = 0xBD52; break; // HANGUL SYLLABLE PIEUP OE RIEULMIEUM
    case 0x9495: code_point = 0xBD53; break; // HANGUL SYLLABLE PIEUP OE RIEULPIEUP
    case 0x9496: code_point = 0xBD54; break; // HANGUL SYLLABLE PIEUP OE RIEULSIOS
    case 0x9497: code_point = 0xBD55; break; // HANGUL SYLLABLE PIEUP OE RIEULTHIEUTH
    case 0x9498: code_point = 0xBD56; break; // HANGUL SYLLABLE PIEUP OE RIEULPHIEUPH
    case 0x9499: code_point = 0xBD57; break; // HANGUL SYLLABLE PIEUP OE RIEULHIEUH
    case 0x949A: code_point = 0xBD5A; break; // HANGUL SYLLABLE PIEUP OE PIEUPSIOS
    case 0x949B: code_point = 0xBD5B; break; // HANGUL SYLLABLE PIEUP OE SIOS
    case 0x949C: code_point = 0xBD5C; break; // HANGUL SYLLABLE PIEUP OE SSANGSIOS
    case 0x949D: code_point = 0xBD5D; break; // HANGUL SYLLABLE PIEUP OE IEUNG
    case 0x949E: code_point = 0xBD5E; break; // HANGUL SYLLABLE PIEUP OE CIEUC
    case 0x949F: code_point = 0xBD5F; break; // HANGUL SYLLABLE PIEUP OE CHIEUCH
    case 0x94A0: code_point = 0xBD60; break; // HANGUL SYLLABLE PIEUP OE KHIEUKH
    case 0x94A1: code_point = 0xBD61; break; // HANGUL SYLLABLE PIEUP OE THIEUTH
    case 0x94A2: code_point = 0xBD62; break; // HANGUL SYLLABLE PIEUP OE PHIEUPH
    case 0x94A3: code_point = 0xBD63; break; // HANGUL SYLLABLE PIEUP OE HIEUH
    case 0x94A4: code_point = 0xBD65; break; // HANGUL SYLLABLE PIEUP YO KIYEOK
    case 0x94A5: code_point = 0xBD66; break; // HANGUL SYLLABLE PIEUP YO SSANGKIYEOK
    case 0x94A6: code_point = 0xBD67; break; // HANGUL SYLLABLE PIEUP YO KIYEOKSIOS
    case 0x94A7: code_point = 0xBD69; break; // HANGUL SYLLABLE PIEUP YO NIEUNCIEUC
    case 0x94A8: code_point = 0xBD6A; break; // HANGUL SYLLABLE PIEUP YO NIEUNHIEUH
    case 0x94A9: code_point = 0xBD6B; break; // HANGUL SYLLABLE PIEUP YO TIKEUT
    case 0x94AA: code_point = 0xBD6C; break; // HANGUL SYLLABLE PIEUP YO RIEUL
    case 0x94AB: code_point = 0xBD6D; break; // HANGUL SYLLABLE PIEUP YO RIEULKIYEOK
    case 0x94AC: code_point = 0xBD6E; break; // HANGUL SYLLABLE PIEUP YO RIEULMIEUM
    case 0x94AD: code_point = 0xBD6F; break; // HANGUL SYLLABLE PIEUP YO RIEULPIEUP
    case 0x94AE: code_point = 0xBD70; break; // HANGUL SYLLABLE PIEUP YO RIEULSIOS
    case 0x94AF: code_point = 0xBD71; break; // HANGUL SYLLABLE PIEUP YO RIEULTHIEUTH
    case 0x94B0: code_point = 0xBD72; break; // HANGUL SYLLABLE PIEUP YO RIEULPHIEUPH
    case 0x94B1: code_point = 0xBD73; break; // HANGUL SYLLABLE PIEUP YO RIEULHIEUH
    case 0x94B2: code_point = 0xBD74; break; // HANGUL SYLLABLE PIEUP YO MIEUM
    case 0x94B3: code_point = 0xBD75; break; // HANGUL SYLLABLE PIEUP YO PIEUP
    case 0x94B4: code_point = 0xBD76; break; // HANGUL SYLLABLE PIEUP YO PIEUPSIOS
    case 0x94B5: code_point = 0xBD77; break; // HANGUL SYLLABLE PIEUP YO SIOS
    case 0x94B6: code_point = 0xBD78; break; // HANGUL SYLLABLE PIEUP YO SSANGSIOS
    case 0x94B7: code_point = 0xBD79; break; // HANGUL SYLLABLE PIEUP YO IEUNG
    case 0x94B8: code_point = 0xBD7A; break; // HANGUL SYLLABLE PIEUP YO CIEUC
    case 0x94B9: code_point = 0xBD7B; break; // HANGUL SYLLABLE PIEUP YO CHIEUCH
    case 0x94BA: code_point = 0xBD7C; break; // HANGUL SYLLABLE PIEUP YO KHIEUKH
    case 0x94BB: code_point = 0xBD7D; break; // HANGUL SYLLABLE PIEUP YO THIEUTH
    case 0x94BC: code_point = 0xBD7E; break; // HANGUL SYLLABLE PIEUP YO PHIEUPH
    case 0x94BD: code_point = 0xBD7F; break; // HANGUL SYLLABLE PIEUP YO HIEUH
    case 0x94BE: code_point = 0xBD82; break; // HANGUL SYLLABLE PIEUP U SSANGKIYEOK
    case 0x94BF: code_point = 0xBD83; break; // HANGUL SYLLABLE PIEUP U KIYEOKSIOS
    case 0x94C0: code_point = 0xBD85; break; // HANGUL SYLLABLE PIEUP U NIEUNCIEUC
    case 0x94C1: code_point = 0xBD86; break; // HANGUL SYLLABLE PIEUP U NIEUNHIEUH
    case 0x94C2: code_point = 0xBD8B; break; // HANGUL SYLLABLE PIEUP U RIEULPIEUP
    case 0x94C3: code_point = 0xBD8C; break; // HANGUL SYLLABLE PIEUP U RIEULSIOS
    case 0x94C4: code_point = 0xBD8D; break; // HANGUL SYLLABLE PIEUP U RIEULTHIEUTH
    case 0x94C5: code_point = 0xBD8E; break; // HANGUL SYLLABLE PIEUP U RIEULPHIEUPH
    case 0x94C6: code_point = 0xBD8F; break; // HANGUL SYLLABLE PIEUP U RIEULHIEUH
    case 0x94C7: code_point = 0xBD92; break; // HANGUL SYLLABLE PIEUP U PIEUPSIOS
    case 0x94C8: code_point = 0xBD94; break; // HANGUL SYLLABLE PIEUP U SSANGSIOS
    case 0x94C9: code_point = 0xBD96; break; // HANGUL SYLLABLE PIEUP U CIEUC
    case 0x94CA: code_point = 0xBD97; break; // HANGUL SYLLABLE PIEUP U CHIEUCH
    case 0x94CB: code_point = 0xBD98; break; // HANGUL SYLLABLE PIEUP U KHIEUKH
    case 0x94CC: code_point = 0xBD9B; break; // HANGUL SYLLABLE PIEUP U HIEUH
    case 0x94CD: code_point = 0xBD9D; break; // HANGUL SYLLABLE PIEUP WEO KIYEOK
    case 0x94CE: code_point = 0xBD9E; break; // HANGUL SYLLABLE PIEUP WEO SSANGKIYEOK
    case 0x94CF: code_point = 0xBD9F; break; // HANGUL SYLLABLE PIEUP WEO KIYEOKSIOS
    case 0x94D0: code_point = 0xBDA0; break; // HANGUL SYLLABLE PIEUP WEO NIEUN
    case 0x94D1: code_point = 0xBDA1; break; // HANGUL SYLLABLE PIEUP WEO NIEUNCIEUC
    case 0x94D2: code_point = 0xBDA2; break; // HANGUL SYLLABLE PIEUP WEO NIEUNHIEUH
    case 0x94D3: code_point = 0xBDA3; break; // HANGUL SYLLABLE PIEUP WEO TIKEUT
    case 0x94D4: code_point = 0xBDA5; break; // HANGUL SYLLABLE PIEUP WEO RIEULKIYEOK
    case 0x94D5: code_point = 0xBDA6; break; // HANGUL SYLLABLE PIEUP WEO RIEULMIEUM
    case 0x94D6: code_point = 0xBDA7; break; // HANGUL SYLLABLE PIEUP WEO RIEULPIEUP
    case 0x94D7: code_point = 0xBDA8; break; // HANGUL SYLLABLE PIEUP WEO RIEULSIOS
    case 0x94D8: code_point = 0xBDA9; break; // HANGUL SYLLABLE PIEUP WEO RIEULTHIEUTH
    case 0x94D9: code_point = 0xBDAA; break; // HANGUL SYLLABLE PIEUP WEO RIEULPHIEUPH
    case 0x94DA: code_point = 0xBDAB; break; // HANGUL SYLLABLE PIEUP WEO RIEULHIEUH
    case 0x94DB: code_point = 0xBDAC; break; // HANGUL SYLLABLE PIEUP WEO MIEUM
    case 0x94DC: code_point = 0xBDAD; break; // HANGUL SYLLABLE PIEUP WEO PIEUP
    case 0x94DD: code_point = 0xBDAE; break; // HANGUL SYLLABLE PIEUP WEO PIEUPSIOS
    case 0x94DE: code_point = 0xBDAF; break; // HANGUL SYLLABLE PIEUP WEO SIOS
    case 0x94DF: code_point = 0xBDB1; break; // HANGUL SYLLABLE PIEUP WEO IEUNG
    case 0x94E0: code_point = 0xBDB2; break; // HANGUL SYLLABLE PIEUP WEO CIEUC
    case 0x94E1: code_point = 0xBDB3; break; // HANGUL SYLLABLE PIEUP WEO CHIEUCH
    case 0x94E2: code_point = 0xBDB4; break; // HANGUL SYLLABLE PIEUP WEO KHIEUKH
    case 0x94E3: code_point = 0xBDB5; break; // HANGUL SYLLABLE PIEUP WEO THIEUTH
    case 0x94E4: code_point = 0xBDB6; break; // HANGUL SYLLABLE PIEUP WEO PHIEUPH
    case 0x94E5: code_point = 0xBDB7; break; // HANGUL SYLLABLE PIEUP WEO HIEUH
    case 0x94E6: code_point = 0xBDB9; break; // HANGUL SYLLABLE PIEUP WE KIYEOK
    case 0x94E7: code_point = 0xBDBA; break; // HANGUL SYLLABLE PIEUP WE SSANGKIYEOK
    case 0x94E8: code_point = 0xBDBB; break; // HANGUL SYLLABLE PIEUP WE KIYEOKSIOS
    case 0x94E9: code_point = 0xBDBC; break; // HANGUL SYLLABLE PIEUP WE NIEUN
    case 0x94EA: code_point = 0xBDBD; break; // HANGUL SYLLABLE PIEUP WE NIEUNCIEUC
    case 0x94EB: code_point = 0xBDBE; break; // HANGUL SYLLABLE PIEUP WE NIEUNHIEUH
    case 0x94EC: code_point = 0xBDBF; break; // HANGUL SYLLABLE PIEUP WE TIKEUT
    case 0x94ED: code_point = 0xBDC0; break; // HANGUL SYLLABLE PIEUP WE RIEUL
    case 0x94EE: code_point = 0xBDC1; break; // HANGUL SYLLABLE PIEUP WE RIEULKIYEOK
    case 0x94EF: code_point = 0xBDC2; break; // HANGUL SYLLABLE PIEUP WE RIEULMIEUM
    case 0x94F0: code_point = 0xBDC3; break; // HANGUL SYLLABLE PIEUP WE RIEULPIEUP
    case 0x94F1: code_point = 0xBDC4; break; // HANGUL SYLLABLE PIEUP WE RIEULSIOS
    case 0x94F2: code_point = 0xBDC5; break; // HANGUL SYLLABLE PIEUP WE RIEULTHIEUTH
    case 0x94F3: code_point = 0xBDC6; break; // HANGUL SYLLABLE PIEUP WE RIEULPHIEUPH
    case 0x94F4: code_point = 0xBDC7; break; // HANGUL SYLLABLE PIEUP WE RIEULHIEUH
    case 0x94F5: code_point = 0xBDC8; break; // HANGUL SYLLABLE PIEUP WE MIEUM
    case 0x94F6: code_point = 0xBDC9; break; // HANGUL SYLLABLE PIEUP WE PIEUP
    case 0x94F7: code_point = 0xBDCA; break; // HANGUL SYLLABLE PIEUP WE PIEUPSIOS
    case 0x94F8: code_point = 0xBDCB; break; // HANGUL SYLLABLE PIEUP WE SIOS
    case 0x94F9: code_point = 0xBDCC; break; // HANGUL SYLLABLE PIEUP WE SSANGSIOS
    case 0x94FA: code_point = 0xBDCD; break; // HANGUL SYLLABLE PIEUP WE IEUNG
    case 0x94FB: code_point = 0xBDCE; break; // HANGUL SYLLABLE PIEUP WE CIEUC
    case 0x94FC: code_point = 0xBDCF; break; // HANGUL SYLLABLE PIEUP WE CHIEUCH
    case 0x94FD: code_point = 0xBDD0; break; // HANGUL SYLLABLE PIEUP WE KHIEUKH
    case 0x94FE: code_point = 0xBDD1; break; // HANGUL SYLLABLE PIEUP WE THIEUTH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x95(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9541: code_point = 0xBDD2; break; // HANGUL SYLLABLE PIEUP WE PHIEUPH
    case 0x9542: code_point = 0xBDD3; break; // HANGUL SYLLABLE PIEUP WE HIEUH
    case 0x9543: code_point = 0xBDD6; break; // HANGUL SYLLABLE PIEUP WI SSANGKIYEOK
    case 0x9544: code_point = 0xBDD7; break; // HANGUL SYLLABLE PIEUP WI KIYEOKSIOS
    case 0x9545: code_point = 0xBDD9; break; // HANGUL SYLLABLE PIEUP WI NIEUNCIEUC
    case 0x9546: code_point = 0xBDDA; break; // HANGUL SYLLABLE PIEUP WI NIEUNHIEUH
    case 0x9547: code_point = 0xBDDB; break; // HANGUL SYLLABLE PIEUP WI TIKEUT
    case 0x9548: code_point = 0xBDDD; break; // HANGUL SYLLABLE PIEUP WI RIEULKIYEOK
    case 0x9549: code_point = 0xBDDE; break; // HANGUL SYLLABLE PIEUP WI RIEULMIEUM
    case 0x954A: code_point = 0xBDDF; break; // HANGUL SYLLABLE PIEUP WI RIEULPIEUP
    case 0x954B: code_point = 0xBDE0; break; // HANGUL SYLLABLE PIEUP WI RIEULSIOS
    case 0x954C: code_point = 0xBDE1; break; // HANGUL SYLLABLE PIEUP WI RIEULTHIEUTH
    case 0x954D: code_point = 0xBDE2; break; // HANGUL SYLLABLE PIEUP WI RIEULPHIEUPH
    case 0x954E: code_point = 0xBDE3; break; // HANGUL SYLLABLE PIEUP WI RIEULHIEUH
    case 0x954F: code_point = 0xBDE4; break; // HANGUL SYLLABLE PIEUP WI MIEUM
    case 0x9550: code_point = 0xBDE5; break; // HANGUL SYLLABLE PIEUP WI PIEUP
    case 0x9551: code_point = 0xBDE6; break; // HANGUL SYLLABLE PIEUP WI PIEUPSIOS
    case 0x9552: code_point = 0xBDE7; break; // HANGUL SYLLABLE PIEUP WI SIOS
    case 0x9553: code_point = 0xBDE8; break; // HANGUL SYLLABLE PIEUP WI SSANGSIOS
    case 0x9554: code_point = 0xBDEA; break; // HANGUL SYLLABLE PIEUP WI CIEUC
    case 0x9555: code_point = 0xBDEB; break; // HANGUL SYLLABLE PIEUP WI CHIEUCH
    case 0x9556: code_point = 0xBDEC; break; // HANGUL SYLLABLE PIEUP WI KHIEUKH
    case 0x9557: code_point = 0xBDED; break; // HANGUL SYLLABLE PIEUP WI THIEUTH
    case 0x9558: code_point = 0xBDEE; break; // HANGUL SYLLABLE PIEUP WI PHIEUPH
    case 0x9559: code_point = 0xBDEF; break; // HANGUL SYLLABLE PIEUP WI HIEUH
    case 0x955A: code_point = 0xBDF1; break; // HANGUL SYLLABLE PIEUP YU KIYEOK
    case 0x9561: code_point = 0xBDF2; break; // HANGUL SYLLABLE PIEUP YU SSANGKIYEOK
    case 0x9562: code_point = 0xBDF3; break; // HANGUL SYLLABLE PIEUP YU KIYEOKSIOS
    case 0x9563: code_point = 0xBDF5; break; // HANGUL SYLLABLE PIEUP YU NIEUNCIEUC
    case 0x9564: code_point = 0xBDF6; break; // HANGUL SYLLABLE PIEUP YU NIEUNHIEUH
    case 0x9565: code_point = 0xBDF7; break; // HANGUL SYLLABLE PIEUP YU TIKEUT
    case 0x9566: code_point = 0xBDF9; break; // HANGUL SYLLABLE PIEUP YU RIEULKIYEOK
    case 0x9567: code_point = 0xBDFA; break; // HANGUL SYLLABLE PIEUP YU RIEULMIEUM
    case 0x9568: code_point = 0xBDFB; break; // HANGUL SYLLABLE PIEUP YU RIEULPIEUP
    case 0x9569: code_point = 0xBDFC; break; // HANGUL SYLLABLE PIEUP YU RIEULSIOS
    case 0x956A: code_point = 0xBDFD; break; // HANGUL SYLLABLE PIEUP YU RIEULTHIEUTH
    case 0x956B: code_point = 0xBDFE; break; // HANGUL SYLLABLE PIEUP YU RIEULPHIEUPH
    case 0x956C: code_point = 0xBDFF; break; // HANGUL SYLLABLE PIEUP YU RIEULHIEUH
    case 0x956D: code_point = 0xBE01; break; // HANGUL SYLLABLE PIEUP YU PIEUP
    case 0x956E: code_point = 0xBE02; break; // HANGUL SYLLABLE PIEUP YU PIEUPSIOS
    case 0x956F: code_point = 0xBE04; break; // HANGUL SYLLABLE PIEUP YU SSANGSIOS
    case 0x9570: code_point = 0xBE06; break; // HANGUL SYLLABLE PIEUP YU CIEUC
    case 0x9571: code_point = 0xBE07; break; // HANGUL SYLLABLE PIEUP YU CHIEUCH
    case 0x9572: code_point = 0xBE08; break; // HANGUL SYLLABLE PIEUP YU KHIEUKH
    case 0x9573: code_point = 0xBE09; break; // HANGUL SYLLABLE PIEUP YU THIEUTH
    case 0x9574: code_point = 0xBE0A; break; // HANGUL SYLLABLE PIEUP YU PHIEUPH
    case 0x9575: code_point = 0xBE0B; break; // HANGUL SYLLABLE PIEUP YU HIEUH
    case 0x9576: code_point = 0xBE0E; break; // HANGUL SYLLABLE PIEUP EU SSANGKIYEOK
    case 0x9577: code_point = 0xBE0F; break; // HANGUL SYLLABLE PIEUP EU KIYEOKSIOS
    case 0x9578: code_point = 0xBE11; break; // HANGUL SYLLABLE PIEUP EU NIEUNCIEUC
    case 0x9579: code_point = 0xBE12; break; // HANGUL SYLLABLE PIEUP EU NIEUNHIEUH
    case 0x957A: code_point = 0xBE13; break; // HANGUL SYLLABLE PIEUP EU TIKEUT
    case 0x9581: code_point = 0xBE15; break; // HANGUL SYLLABLE PIEUP EU RIEULKIYEOK
    case 0x9582: code_point = 0xBE16; break; // HANGUL SYLLABLE PIEUP EU RIEULMIEUM
    case 0x9583: code_point = 0xBE17; break; // HANGUL SYLLABLE PIEUP EU RIEULPIEUP
    case 0x9584: code_point = 0xBE18; break; // HANGUL SYLLABLE PIEUP EU RIEULSIOS
    case 0x9585: code_point = 0xBE19; break; // HANGUL SYLLABLE PIEUP EU RIEULTHIEUTH
    case 0x9586: code_point = 0xBE1A; break; // HANGUL SYLLABLE PIEUP EU RIEULPHIEUPH
    case 0x9587: code_point = 0xBE1B; break; // HANGUL SYLLABLE PIEUP EU RIEULHIEUH
    case 0x9588: code_point = 0xBE1E; break; // HANGUL SYLLABLE PIEUP EU PIEUPSIOS
    case 0x9589: code_point = 0xBE20; break; // HANGUL SYLLABLE PIEUP EU SSANGSIOS
    case 0x958A: code_point = 0xBE21; break; // HANGUL SYLLABLE PIEUP EU IEUNG
    case 0x958B: code_point = 0xBE22; break; // HANGUL SYLLABLE PIEUP EU CIEUC
    case 0x958C: code_point = 0xBE23; break; // HANGUL SYLLABLE PIEUP EU CHIEUCH
    case 0x958D: code_point = 0xBE24; break; // HANGUL SYLLABLE PIEUP EU KHIEUKH
    case 0x958E: code_point = 0xBE25; break; // HANGUL SYLLABLE PIEUP EU THIEUTH
    case 0x958F: code_point = 0xBE26; break; // HANGUL SYLLABLE PIEUP EU PHIEUPH
    case 0x9590: code_point = 0xBE27; break; // HANGUL SYLLABLE PIEUP EU HIEUH
    case 0x9591: code_point = 0xBE28; break; // HANGUL SYLLABLE PIEUP YI
    case 0x9592: code_point = 0xBE29; break; // HANGUL SYLLABLE PIEUP YI KIYEOK
    case 0x9593: code_point = 0xBE2A; break; // HANGUL SYLLABLE PIEUP YI SSANGKIYEOK
    case 0x9594: code_point = 0xBE2B; break; // HANGUL SYLLABLE PIEUP YI KIYEOKSIOS
    case 0x9595: code_point = 0xBE2C; break; // HANGUL SYLLABLE PIEUP YI NIEUN
    case 0x9596: code_point = 0xBE2D; break; // HANGUL SYLLABLE PIEUP YI NIEUNCIEUC
    case 0x9597: code_point = 0xBE2E; break; // HANGUL SYLLABLE PIEUP YI NIEUNHIEUH
    case 0x9598: code_point = 0xBE2F; break; // HANGUL SYLLABLE PIEUP YI TIKEUT
    case 0x9599: code_point = 0xBE30; break; // HANGUL SYLLABLE PIEUP YI RIEUL
    case 0x959A: code_point = 0xBE31; break; // HANGUL SYLLABLE PIEUP YI RIEULKIYEOK
    case 0x959B: code_point = 0xBE32; break; // HANGUL SYLLABLE PIEUP YI RIEULMIEUM
    case 0x959C: code_point = 0xBE33; break; // HANGUL SYLLABLE PIEUP YI RIEULPIEUP
    case 0x959D: code_point = 0xBE34; break; // HANGUL SYLLABLE PIEUP YI RIEULSIOS
    case 0x959E: code_point = 0xBE35; break; // HANGUL SYLLABLE PIEUP YI RIEULTHIEUTH
    case 0x959F: code_point = 0xBE36; break; // HANGUL SYLLABLE PIEUP YI RIEULPHIEUPH
    case 0x95A0: code_point = 0xBE37; break; // HANGUL SYLLABLE PIEUP YI RIEULHIEUH
    case 0x95A1: code_point = 0xBE38; break; // HANGUL SYLLABLE PIEUP YI MIEUM
    case 0x95A2: code_point = 0xBE39; break; // HANGUL SYLLABLE PIEUP YI PIEUP
    case 0x95A3: code_point = 0xBE3A; break; // HANGUL SYLLABLE PIEUP YI PIEUPSIOS
    case 0x95A4: code_point = 0xBE3B; break; // HANGUL SYLLABLE PIEUP YI SIOS
    case 0x95A5: code_point = 0xBE3C; break; // HANGUL SYLLABLE PIEUP YI SSANGSIOS
    case 0x95A6: code_point = 0xBE3D; break; // HANGUL SYLLABLE PIEUP YI IEUNG
    case 0x95A7: code_point = 0xBE3E; break; // HANGUL SYLLABLE PIEUP YI CIEUC
    case 0x95A8: code_point = 0xBE3F; break; // HANGUL SYLLABLE PIEUP YI CHIEUCH
    case 0x95A9: code_point = 0xBE40; break; // HANGUL SYLLABLE PIEUP YI KHIEUKH
    case 0x95AA: code_point = 0xBE41; break; // HANGUL SYLLABLE PIEUP YI THIEUTH
    case 0x95AB: code_point = 0xBE42; break; // HANGUL SYLLABLE PIEUP YI PHIEUPH
    case 0x95AC: code_point = 0xBE43; break; // HANGUL SYLLABLE PIEUP YI HIEUH
    case 0x95AD: code_point = 0xBE46; break; // HANGUL SYLLABLE PIEUP I SSANGKIYEOK
    case 0x95AE: code_point = 0xBE47; break; // HANGUL SYLLABLE PIEUP I KIYEOKSIOS
    case 0x95AF: code_point = 0xBE49; break; // HANGUL SYLLABLE PIEUP I NIEUNCIEUC
    case 0x95B0: code_point = 0xBE4A; break; // HANGUL SYLLABLE PIEUP I NIEUNHIEUH
    case 0x95B1: code_point = 0xBE4B; break; // HANGUL SYLLABLE PIEUP I TIKEUT
    case 0x95B2: code_point = 0xBE4D; break; // HANGUL SYLLABLE PIEUP I RIEULKIYEOK
    case 0x95B3: code_point = 0xBE4F; break; // HANGUL SYLLABLE PIEUP I RIEULPIEUP
    case 0x95B4: code_point = 0xBE50; break; // HANGUL SYLLABLE PIEUP I RIEULSIOS
    case 0x95B5: code_point = 0xBE51; break; // HANGUL SYLLABLE PIEUP I RIEULTHIEUTH
    case 0x95B6: code_point = 0xBE52; break; // HANGUL SYLLABLE PIEUP I RIEULPHIEUPH
    case 0x95B7: code_point = 0xBE53; break; // HANGUL SYLLABLE PIEUP I RIEULHIEUH
    case 0x95B8: code_point = 0xBE56; break; // HANGUL SYLLABLE PIEUP I PIEUPSIOS
    case 0x95B9: code_point = 0xBE58; break; // HANGUL SYLLABLE PIEUP I SSANGSIOS
    case 0x95BA: code_point = 0xBE5C; break; // HANGUL SYLLABLE PIEUP I KHIEUKH
    case 0x95BB: code_point = 0xBE5D; break; // HANGUL SYLLABLE PIEUP I THIEUTH
    case 0x95BC: code_point = 0xBE5E; break; // HANGUL SYLLABLE PIEUP I PHIEUPH
    case 0x95BD: code_point = 0xBE5F; break; // HANGUL SYLLABLE PIEUP I HIEUH
    case 0x95BE: code_point = 0xBE62; break; // HANGUL SYLLABLE SSANGPIEUP A SSANGKIYEOK
    case 0x95BF: code_point = 0xBE63; break; // HANGUL SYLLABLE SSANGPIEUP A KIYEOKSIOS
    case 0x95C0: code_point = 0xBE65; break; // HANGUL SYLLABLE SSANGPIEUP A NIEUNCIEUC
    case 0x95C1: code_point = 0xBE66; break; // HANGUL SYLLABLE SSANGPIEUP A NIEUNHIEUH
    case 0x95C2: code_point = 0xBE67; break; // HANGUL SYLLABLE SSANGPIEUP A TIKEUT
    case 0x95C3: code_point = 0xBE69; break; // HANGUL SYLLABLE SSANGPIEUP A RIEULKIYEOK
    case 0x95C4: code_point = 0xBE6B; break; // HANGUL SYLLABLE SSANGPIEUP A RIEULPIEUP
    case 0x95C5: code_point = 0xBE6C; break; // HANGUL SYLLABLE SSANGPIEUP A RIEULSIOS
    case 0x95C6: code_point = 0xBE6D; break; // HANGUL SYLLABLE SSANGPIEUP A RIEULTHIEUTH
    case 0x95C7: code_point = 0xBE6E; break; // HANGUL SYLLABLE SSANGPIEUP A RIEULPHIEUPH
    case 0x95C8: code_point = 0xBE6F; break; // HANGUL SYLLABLE SSANGPIEUP A RIEULHIEUH
    case 0x95C9: code_point = 0xBE72; break; // HANGUL SYLLABLE SSANGPIEUP A PIEUPSIOS
    case 0x95CA: code_point = 0xBE76; break; // HANGUL SYLLABLE SSANGPIEUP A CIEUC
    case 0x95CB: code_point = 0xBE77; break; // HANGUL SYLLABLE SSANGPIEUP A CHIEUCH
    case 0x95CC: code_point = 0xBE78; break; // HANGUL SYLLABLE SSANGPIEUP A KHIEUKH
    case 0x95CD: code_point = 0xBE79; break; // HANGUL SYLLABLE SSANGPIEUP A THIEUTH
    case 0x95CE: code_point = 0xBE7A; break; // HANGUL SYLLABLE SSANGPIEUP A PHIEUPH
    case 0x95CF: code_point = 0xBE7E; break; // HANGUL SYLLABLE SSANGPIEUP AE SSANGKIYEOK
    case 0x95D0: code_point = 0xBE7F; break; // HANGUL SYLLABLE SSANGPIEUP AE KIYEOKSIOS
    case 0x95D1: code_point = 0xBE81; break; // HANGUL SYLLABLE SSANGPIEUP AE NIEUNCIEUC
    case 0x95D2: code_point = 0xBE82; break; // HANGUL SYLLABLE SSANGPIEUP AE NIEUNHIEUH
    case 0x95D3: code_point = 0xBE83; break; // HANGUL SYLLABLE SSANGPIEUP AE TIKEUT
    case 0x95D4: code_point = 0xBE85; break; // HANGUL SYLLABLE SSANGPIEUP AE RIEULKIYEOK
    case 0x95D5: code_point = 0xBE86; break; // HANGUL SYLLABLE SSANGPIEUP AE RIEULMIEUM
    case 0x95D6: code_point = 0xBE87; break; // HANGUL SYLLABLE SSANGPIEUP AE RIEULPIEUP
    case 0x95D7: code_point = 0xBE88; break; // HANGUL SYLLABLE SSANGPIEUP AE RIEULSIOS
    case 0x95D8: code_point = 0xBE89; break; // HANGUL SYLLABLE SSANGPIEUP AE RIEULTHIEUTH
    case 0x95D9: code_point = 0xBE8A; break; // HANGUL SYLLABLE SSANGPIEUP AE RIEULPHIEUPH
    case 0x95DA: code_point = 0xBE8B; break; // HANGUL SYLLABLE SSANGPIEUP AE RIEULHIEUH
    case 0x95DB: code_point = 0xBE8E; break; // HANGUL SYLLABLE SSANGPIEUP AE PIEUPSIOS
    case 0x95DC: code_point = 0xBE92; break; // HANGUL SYLLABLE SSANGPIEUP AE CIEUC
    case 0x95DD: code_point = 0xBE93; break; // HANGUL SYLLABLE SSANGPIEUP AE CHIEUCH
    case 0x95DE: code_point = 0xBE94; break; // HANGUL SYLLABLE SSANGPIEUP AE KHIEUKH
    case 0x95DF: code_point = 0xBE95; break; // HANGUL SYLLABLE SSANGPIEUP AE THIEUTH
    case 0x95E0: code_point = 0xBE96; break; // HANGUL SYLLABLE SSANGPIEUP AE PHIEUPH
    case 0x95E1: code_point = 0xBE97; break; // HANGUL SYLLABLE SSANGPIEUP AE HIEUH
    case 0x95E2: code_point = 0xBE9A; break; // HANGUL SYLLABLE SSANGPIEUP YA SSANGKIYEOK
    case 0x95E3: code_point = 0xBE9B; break; // HANGUL SYLLABLE SSANGPIEUP YA KIYEOKSIOS
    case 0x95E4: code_point = 0xBE9C; break; // HANGUL SYLLABLE SSANGPIEUP YA NIEUN
    case 0x95E5: code_point = 0xBE9D; break; // HANGUL SYLLABLE SSANGPIEUP YA NIEUNCIEUC
    case 0x95E6: code_point = 0xBE9E; break; // HANGUL SYLLABLE SSANGPIEUP YA NIEUNHIEUH
    case 0x95E7: code_point = 0xBE9F; break; // HANGUL SYLLABLE SSANGPIEUP YA TIKEUT
    case 0x95E8: code_point = 0xBEA0; break; // HANGUL SYLLABLE SSANGPIEUP YA RIEUL
    case 0x95E9: code_point = 0xBEA1; break; // HANGUL SYLLABLE SSANGPIEUP YA RIEULKIYEOK
    case 0x95EA: code_point = 0xBEA2; break; // HANGUL SYLLABLE SSANGPIEUP YA RIEULMIEUM
    case 0x95EB: code_point = 0xBEA3; break; // HANGUL SYLLABLE SSANGPIEUP YA RIEULPIEUP
    case 0x95EC: code_point = 0xBEA4; break; // HANGUL SYLLABLE SSANGPIEUP YA RIEULSIOS
    case 0x95ED: code_point = 0xBEA5; break; // HANGUL SYLLABLE SSANGPIEUP YA RIEULTHIEUTH
    case 0x95EE: code_point = 0xBEA6; break; // HANGUL SYLLABLE SSANGPIEUP YA RIEULPHIEUPH
    case 0x95EF: code_point = 0xBEA7; break; // HANGUL SYLLABLE SSANGPIEUP YA RIEULHIEUH
    case 0x95F0: code_point = 0xBEA9; break; // HANGUL SYLLABLE SSANGPIEUP YA PIEUP
    case 0x95F1: code_point = 0xBEAA; break; // HANGUL SYLLABLE SSANGPIEUP YA PIEUPSIOS
    case 0x95F2: code_point = 0xBEAB; break; // HANGUL SYLLABLE SSANGPIEUP YA SIOS
    case 0x95F3: code_point = 0xBEAC; break; // HANGUL SYLLABLE SSANGPIEUP YA SSANGSIOS
    case 0x95F4: code_point = 0xBEAD; break; // HANGUL SYLLABLE SSANGPIEUP YA IEUNG
    case 0x95F5: code_point = 0xBEAE; break; // HANGUL SYLLABLE SSANGPIEUP YA CIEUC
    case 0x95F6: code_point = 0xBEAF; break; // HANGUL SYLLABLE SSANGPIEUP YA CHIEUCH
    case 0x95F7: code_point = 0xBEB0; break; // HANGUL SYLLABLE SSANGPIEUP YA KHIEUKH
    case 0x95F8: code_point = 0xBEB1; break; // HANGUL SYLLABLE SSANGPIEUP YA THIEUTH
    case 0x95F9: code_point = 0xBEB2; break; // HANGUL SYLLABLE SSANGPIEUP YA PHIEUPH
    case 0x95FA: code_point = 0xBEB3; break; // HANGUL SYLLABLE SSANGPIEUP YA HIEUH
    case 0x95FB: code_point = 0xBEB4; break; // HANGUL SYLLABLE SSANGPIEUP YAE
    case 0x95FC: code_point = 0xBEB5; break; // HANGUL SYLLABLE SSANGPIEUP YAE KIYEOK
    case 0x95FD: code_point = 0xBEB6; break; // HANGUL SYLLABLE SSANGPIEUP YAE SSANGKIYEOK
    case 0x95FE: code_point = 0xBEB7; break; // HANGUL SYLLABLE SSANGPIEUP YAE KIYEOKSIOS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x96(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9641: code_point = 0xBEB8; break; // HANGUL SYLLABLE SSANGPIEUP YAE NIEUN
    case 0x9642: code_point = 0xBEB9; break; // HANGUL SYLLABLE SSANGPIEUP YAE NIEUNCIEUC
    case 0x9643: code_point = 0xBEBA; break; // HANGUL SYLLABLE SSANGPIEUP YAE NIEUNHIEUH
    case 0x9644: code_point = 0xBEBB; break; // HANGUL SYLLABLE SSANGPIEUP YAE TIKEUT
    case 0x9645: code_point = 0xBEBC; break; // HANGUL SYLLABLE SSANGPIEUP YAE RIEUL
    case 0x9646: code_point = 0xBEBD; break; // HANGUL SYLLABLE SSANGPIEUP YAE RIEULKIYEOK
    case 0x9647: code_point = 0xBEBE; break; // HANGUL SYLLABLE SSANGPIEUP YAE RIEULMIEUM
    case 0x9648: code_point = 0xBEBF; break; // HANGUL SYLLABLE SSANGPIEUP YAE RIEULPIEUP
    case 0x9649: code_point = 0xBEC0; break; // HANGUL SYLLABLE SSANGPIEUP YAE RIEULSIOS
    case 0x964A: code_point = 0xBEC1; break; // HANGUL SYLLABLE SSANGPIEUP YAE RIEULTHIEUTH
    case 0x964B: code_point = 0xBEC2; break; // HANGUL SYLLABLE SSANGPIEUP YAE RIEULPHIEUPH
    case 0x964C: code_point = 0xBEC3; break; // HANGUL SYLLABLE SSANGPIEUP YAE RIEULHIEUH
    case 0x964D: code_point = 0xBEC4; break; // HANGUL SYLLABLE SSANGPIEUP YAE MIEUM
    case 0x964E: code_point = 0xBEC5; break; // HANGUL SYLLABLE SSANGPIEUP YAE PIEUP
    case 0x964F: code_point = 0xBEC6; break; // HANGUL SYLLABLE SSANGPIEUP YAE PIEUPSIOS
    case 0x9650: code_point = 0xBEC7; break; // HANGUL SYLLABLE SSANGPIEUP YAE SIOS
    case 0x9651: code_point = 0xBEC8; break; // HANGUL SYLLABLE SSANGPIEUP YAE SSANGSIOS
    case 0x9652: code_point = 0xBEC9; break; // HANGUL SYLLABLE SSANGPIEUP YAE IEUNG
    case 0x9653: code_point = 0xBECA; break; // HANGUL SYLLABLE SSANGPIEUP YAE CIEUC
    case 0x9654: code_point = 0xBECB; break; // HANGUL SYLLABLE SSANGPIEUP YAE CHIEUCH
    case 0x9655: code_point = 0xBECC; break; // HANGUL SYLLABLE SSANGPIEUP YAE KHIEUKH
    case 0x9656: code_point = 0xBECD; break; // HANGUL SYLLABLE SSANGPIEUP YAE THIEUTH
    case 0x9657: code_point = 0xBECE; break; // HANGUL SYLLABLE SSANGPIEUP YAE PHIEUPH
    case 0x9658: code_point = 0xBECF; break; // HANGUL SYLLABLE SSANGPIEUP YAE HIEUH
    case 0x9659: code_point = 0xBED2; break; // HANGUL SYLLABLE SSANGPIEUP EO SSANGKIYEOK
    case 0x965A: code_point = 0xBED3; break; // HANGUL SYLLABLE SSANGPIEUP EO KIYEOKSIOS
    case 0x9661: code_point = 0xBED5; break; // HANGUL SYLLABLE SSANGPIEUP EO NIEUNCIEUC
    case 0x9662: code_point = 0xBED6; break; // HANGUL SYLLABLE SSANGPIEUP EO NIEUNHIEUH
    case 0x9663: code_point = 0xBED9; break; // HANGUL SYLLABLE SSANGPIEUP EO RIEULKIYEOK
    case 0x9664: code_point = 0xBEDA; break; // HANGUL SYLLABLE SSANGPIEUP EO RIEULMIEUM
    case 0x9665: code_point = 0xBEDB; break; // HANGUL SYLLABLE SSANGPIEUP EO RIEULPIEUP
    case 0x9666: code_point = 0xBEDC; break; // HANGUL SYLLABLE SSANGPIEUP EO RIEULSIOS
    case 0x9667: code_point = 0xBEDD; break; // HANGUL SYLLABLE SSANGPIEUP EO RIEULTHIEUTH
    case 0x9668: code_point = 0xBEDE; break; // HANGUL SYLLABLE SSANGPIEUP EO RIEULPHIEUPH
    case 0x9669: code_point = 0xBEDF; break; // HANGUL SYLLABLE SSANGPIEUP EO RIEULHIEUH
    case 0x966A: code_point = 0xBEE1; break; // HANGUL SYLLABLE SSANGPIEUP EO PIEUP
    case 0x966B: code_point = 0xBEE2; break; // HANGUL SYLLABLE SSANGPIEUP EO PIEUPSIOS
    case 0x966C: code_point = 0xBEE6; break; // HANGUL SYLLABLE SSANGPIEUP EO CIEUC
    case 0x966D: code_point = 0xBEE7; break; // HANGUL SYLLABLE SSANGPIEUP EO CHIEUCH
    case 0x966E: code_point = 0xBEE8; break; // HANGUL SYLLABLE SSANGPIEUP EO KHIEUKH
    case 0x966F: code_point = 0xBEE9; break; // HANGUL SYLLABLE SSANGPIEUP EO THIEUTH
    case 0x9670: code_point = 0xBEEA; break; // HANGUL SYLLABLE SSANGPIEUP EO PHIEUPH
    case 0x9671: code_point = 0xBEEB; break; // HANGUL SYLLABLE SSANGPIEUP EO HIEUH
    case 0x9672: code_point = 0xBEED; break; // HANGUL SYLLABLE SSANGPIEUP E KIYEOK
    case 0x9673: code_point = 0xBEEE; break; // HANGUL SYLLABLE SSANGPIEUP E SSANGKIYEOK
    case 0x9674: code_point = 0xBEEF; break; // HANGUL SYLLABLE SSANGPIEUP E KIYEOKSIOS
    case 0x9675: code_point = 0xBEF0; break; // HANGUL SYLLABLE SSANGPIEUP E NIEUN
    case 0x9676: code_point = 0xBEF1; break; // HANGUL SYLLABLE SSANGPIEUP E NIEUNCIEUC
    case 0x9677: code_point = 0xBEF2; break; // HANGUL SYLLABLE SSANGPIEUP E NIEUNHIEUH
    case 0x9678: code_point = 0xBEF3; break; // HANGUL SYLLABLE SSANGPIEUP E TIKEUT
    case 0x9679: code_point = 0xBEF4; break; // HANGUL SYLLABLE SSANGPIEUP E RIEUL
    case 0x967A: code_point = 0xBEF5; break; // HANGUL SYLLABLE SSANGPIEUP E RIEULKIYEOK
    case 0x9681: code_point = 0xBEF6; break; // HANGUL SYLLABLE SSANGPIEUP E RIEULMIEUM
    case 0x9682: code_point = 0xBEF7; break; // HANGUL SYLLABLE SSANGPIEUP E RIEULPIEUP
    case 0x9683: code_point = 0xBEF8; break; // HANGUL SYLLABLE SSANGPIEUP E RIEULSIOS
    case 0x9684: code_point = 0xBEF9; break; // HANGUL SYLLABLE SSANGPIEUP E RIEULTHIEUTH
    case 0x9685: code_point = 0xBEFA; break; // HANGUL SYLLABLE SSANGPIEUP E RIEULPHIEUPH
    case 0x9686: code_point = 0xBEFB; break; // HANGUL SYLLABLE SSANGPIEUP E RIEULHIEUH
    case 0x9687: code_point = 0xBEFC; break; // HANGUL SYLLABLE SSANGPIEUP E MIEUM
    case 0x9688: code_point = 0xBEFD; break; // HANGUL SYLLABLE SSANGPIEUP E PIEUP
    case 0x9689: code_point = 0xBEFE; break; // HANGUL SYLLABLE SSANGPIEUP E PIEUPSIOS
    case 0x968A: code_point = 0xBEFF; break; // HANGUL SYLLABLE SSANGPIEUP E SIOS
    case 0x968B: code_point = 0xBF00; break; // HANGUL SYLLABLE SSANGPIEUP E SSANGSIOS
    case 0x968C: code_point = 0xBF02; break; // HANGUL SYLLABLE SSANGPIEUP E CIEUC
    case 0x968D: code_point = 0xBF03; break; // HANGUL SYLLABLE SSANGPIEUP E CHIEUCH
    case 0x968E: code_point = 0xBF04; break; // HANGUL SYLLABLE SSANGPIEUP E KHIEUKH
    case 0x968F: code_point = 0xBF05; break; // HANGUL SYLLABLE SSANGPIEUP E THIEUTH
    case 0x9690: code_point = 0xBF06; break; // HANGUL SYLLABLE SSANGPIEUP E PHIEUPH
    case 0x9691: code_point = 0xBF07; break; // HANGUL SYLLABLE SSANGPIEUP E HIEUH
    case 0x9692: code_point = 0xBF0A; break; // HANGUL SYLLABLE SSANGPIEUP YEO SSANGKIYEOK
    case 0x9693: code_point = 0xBF0B; break; // HANGUL SYLLABLE SSANGPIEUP YEO KIYEOKSIOS
    case 0x9694: code_point = 0xBF0C; break; // HANGUL SYLLABLE SSANGPIEUP YEO NIEUN
    case 0x9695: code_point = 0xBF0D; break; // HANGUL SYLLABLE SSANGPIEUP YEO NIEUNCIEUC
    case 0x9696: code_point = 0xBF0E; break; // HANGUL SYLLABLE SSANGPIEUP YEO NIEUNHIEUH
    case 0x9697: code_point = 0xBF0F; break; // HANGUL SYLLABLE SSANGPIEUP YEO TIKEUT
    case 0x9698: code_point = 0xBF10; break; // HANGUL SYLLABLE SSANGPIEUP YEO RIEUL
    case 0x9699: code_point = 0xBF11; break; // HANGUL SYLLABLE SSANGPIEUP YEO RIEULKIYEOK
    case 0x969A: code_point = 0xBF12; break; // HANGUL SYLLABLE SSANGPIEUP YEO RIEULMIEUM
    case 0x969B: code_point = 0xBF13; break; // HANGUL SYLLABLE SSANGPIEUP YEO RIEULPIEUP
    case 0x969C: code_point = 0xBF14; break; // HANGUL SYLLABLE SSANGPIEUP YEO RIEULSIOS
    case 0x969D: code_point = 0xBF15; break; // HANGUL SYLLABLE SSANGPIEUP YEO RIEULTHIEUTH
    case 0x969E: code_point = 0xBF16; break; // HANGUL SYLLABLE SSANGPIEUP YEO RIEULPHIEUPH
    case 0x969F: code_point = 0xBF17; break; // HANGUL SYLLABLE SSANGPIEUP YEO RIEULHIEUH
    case 0x96A0: code_point = 0xBF1A; break; // HANGUL SYLLABLE SSANGPIEUP YEO PIEUPSIOS
    case 0x96A1: code_point = 0xBF1E; break; // HANGUL SYLLABLE SSANGPIEUP YEO CIEUC
    case 0x96A2: code_point = 0xBF1F; break; // HANGUL SYLLABLE SSANGPIEUP YEO CHIEUCH
    case 0x96A3: code_point = 0xBF20; break; // HANGUL SYLLABLE SSANGPIEUP YEO KHIEUKH
    case 0x96A4: code_point = 0xBF21; break; // HANGUL SYLLABLE SSANGPIEUP YEO THIEUTH
    case 0x96A5: code_point = 0xBF22; break; // HANGUL SYLLABLE SSANGPIEUP YEO PHIEUPH
    case 0x96A6: code_point = 0xBF23; break; // HANGUL SYLLABLE SSANGPIEUP YEO HIEUH
    case 0x96A7: code_point = 0xBF24; break; // HANGUL SYLLABLE SSANGPIEUP YE
    case 0x96A8: code_point = 0xBF25; break; // HANGUL SYLLABLE SSANGPIEUP YE KIYEOK
    case 0x96A9: code_point = 0xBF26; break; // HANGUL SYLLABLE SSANGPIEUP YE SSANGKIYEOK
    case 0x96AA: code_point = 0xBF27; break; // HANGUL SYLLABLE SSANGPIEUP YE KIYEOKSIOS
    case 0x96AB: code_point = 0xBF28; break; // HANGUL SYLLABLE SSANGPIEUP YE NIEUN
    case 0x96AC: code_point = 0xBF29; break; // HANGUL SYLLABLE SSANGPIEUP YE NIEUNCIEUC
    case 0x96AD: code_point = 0xBF2A; break; // HANGUL SYLLABLE SSANGPIEUP YE NIEUNHIEUH
    case 0x96AE: code_point = 0xBF2B; break; // HANGUL SYLLABLE SSANGPIEUP YE TIKEUT
    case 0x96AF: code_point = 0xBF2C; break; // HANGUL SYLLABLE SSANGPIEUP YE RIEUL
    case 0x96B0: code_point = 0xBF2D; break; // HANGUL SYLLABLE SSANGPIEUP YE RIEULKIYEOK
    case 0x96B1: code_point = 0xBF2E; break; // HANGUL SYLLABLE SSANGPIEUP YE RIEULMIEUM
    case 0x96B2: code_point = 0xBF2F; break; // HANGUL SYLLABLE SSANGPIEUP YE RIEULPIEUP
    case 0x96B3: code_point = 0xBF30; break; // HANGUL SYLLABLE SSANGPIEUP YE RIEULSIOS
    case 0x96B4: code_point = 0xBF31; break; // HANGUL SYLLABLE SSANGPIEUP YE RIEULTHIEUTH
    case 0x96B5: code_point = 0xBF32; break; // HANGUL SYLLABLE SSANGPIEUP YE RIEULPHIEUPH
    case 0x96B6: code_point = 0xBF33; break; // HANGUL SYLLABLE SSANGPIEUP YE RIEULHIEUH
    case 0x96B7: code_point = 0xBF34; break; // HANGUL SYLLABLE SSANGPIEUP YE MIEUM
    case 0x96B8: code_point = 0xBF35; break; // HANGUL SYLLABLE SSANGPIEUP YE PIEUP
    case 0x96B9: code_point = 0xBF36; break; // HANGUL SYLLABLE SSANGPIEUP YE PIEUPSIOS
    case 0x96BA: code_point = 0xBF37; break; // HANGUL SYLLABLE SSANGPIEUP YE SIOS
    case 0x96BB: code_point = 0xBF38; break; // HANGUL SYLLABLE SSANGPIEUP YE SSANGSIOS
    case 0x96BC: code_point = 0xBF39; break; // HANGUL SYLLABLE SSANGPIEUP YE IEUNG
    case 0x96BD: code_point = 0xBF3A; break; // HANGUL SYLLABLE SSANGPIEUP YE CIEUC
    case 0x96BE: code_point = 0xBF3B; break; // HANGUL SYLLABLE SSANGPIEUP YE CHIEUCH
    case 0x96BF: code_point = 0xBF3C; break; // HANGUL SYLLABLE SSANGPIEUP YE KHIEUKH
    case 0x96C0: code_point = 0xBF3D; break; // HANGUL SYLLABLE SSANGPIEUP YE THIEUTH
    case 0x96C1: code_point = 0xBF3E; break; // HANGUL SYLLABLE SSANGPIEUP YE PHIEUPH
    case 0x96C2: code_point = 0xBF3F; break; // HANGUL SYLLABLE SSANGPIEUP YE HIEUH
    case 0x96C3: code_point = 0xBF42; break; // HANGUL SYLLABLE SSANGPIEUP O SSANGKIYEOK
    case 0x96C4: code_point = 0xBF43; break; // HANGUL SYLLABLE SSANGPIEUP O KIYEOKSIOS
    case 0x96C5: code_point = 0xBF45; break; // HANGUL SYLLABLE SSANGPIEUP O NIEUNCIEUC
    case 0x96C6: code_point = 0xBF46; break; // HANGUL SYLLABLE SSANGPIEUP O NIEUNHIEUH
    case 0x96C7: code_point = 0xBF47; break; // HANGUL SYLLABLE SSANGPIEUP O TIKEUT
    case 0x96C8: code_point = 0xBF49; break; // HANGUL SYLLABLE SSANGPIEUP O RIEULKIYEOK
    case 0x96C9: code_point = 0xBF4A; break; // HANGUL SYLLABLE SSANGPIEUP O RIEULMIEUM
    case 0x96CA: code_point = 0xBF4B; break; // HANGUL SYLLABLE SSANGPIEUP O RIEULPIEUP
    case 0x96CB: code_point = 0xBF4C; break; // HANGUL SYLLABLE SSANGPIEUP O RIEULSIOS
    case 0x96CC: code_point = 0xBF4D; break; // HANGUL SYLLABLE SSANGPIEUP O RIEULTHIEUTH
    case 0x96CD: code_point = 0xBF4E; break; // HANGUL SYLLABLE SSANGPIEUP O RIEULPHIEUPH
    case 0x96CE: code_point = 0xBF4F; break; // HANGUL SYLLABLE SSANGPIEUP O RIEULHIEUH
    case 0x96CF: code_point = 0xBF52; break; // HANGUL SYLLABLE SSANGPIEUP O PIEUPSIOS
    case 0x96D0: code_point = 0xBF53; break; // HANGUL SYLLABLE SSANGPIEUP O SIOS
    case 0x96D1: code_point = 0xBF54; break; // HANGUL SYLLABLE SSANGPIEUP O SSANGSIOS
    case 0x96D2: code_point = 0xBF56; break; // HANGUL SYLLABLE SSANGPIEUP O CIEUC
    case 0x96D3: code_point = 0xBF57; break; // HANGUL SYLLABLE SSANGPIEUP O CHIEUCH
    case 0x96D4: code_point = 0xBF58; break; // HANGUL SYLLABLE SSANGPIEUP O KHIEUKH
    case 0x96D5: code_point = 0xBF59; break; // HANGUL SYLLABLE SSANGPIEUP O THIEUTH
    case 0x96D6: code_point = 0xBF5A; break; // HANGUL SYLLABLE SSANGPIEUP O PHIEUPH
    case 0x96D7: code_point = 0xBF5B; break; // HANGUL SYLLABLE SSANGPIEUP O HIEUH
    case 0x96D8: code_point = 0xBF5C; break; // HANGUL SYLLABLE SSANGPIEUP WA
    case 0x96D9: code_point = 0xBF5D; break; // HANGUL SYLLABLE SSANGPIEUP WA KIYEOK
    case 0x96DA: code_point = 0xBF5E; break; // HANGUL SYLLABLE SSANGPIEUP WA SSANGKIYEOK
    case 0x96DB: code_point = 0xBF5F; break; // HANGUL SYLLABLE SSANGPIEUP WA KIYEOKSIOS
    case 0x96DC: code_point = 0xBF60; break; // HANGUL SYLLABLE SSANGPIEUP WA NIEUN
    case 0x96DD: code_point = 0xBF61; break; // HANGUL SYLLABLE SSANGPIEUP WA NIEUNCIEUC
    case 0x96DE: code_point = 0xBF62; break; // HANGUL SYLLABLE SSANGPIEUP WA NIEUNHIEUH
    case 0x96DF: code_point = 0xBF63; break; // HANGUL SYLLABLE SSANGPIEUP WA TIKEUT
    case 0x96E0: code_point = 0xBF64; break; // HANGUL SYLLABLE SSANGPIEUP WA RIEUL
    case 0x96E1: code_point = 0xBF65; break; // HANGUL SYLLABLE SSANGPIEUP WA RIEULKIYEOK
    case 0x96E2: code_point = 0xBF66; break; // HANGUL SYLLABLE SSANGPIEUP WA RIEULMIEUM
    case 0x96E3: code_point = 0xBF67; break; // HANGUL SYLLABLE SSANGPIEUP WA RIEULPIEUP
    case 0x96E4: code_point = 0xBF68; break; // HANGUL SYLLABLE SSANGPIEUP WA RIEULSIOS
    case 0x96E5: code_point = 0xBF69; break; // HANGUL SYLLABLE SSANGPIEUP WA RIEULTHIEUTH
    case 0x96E6: code_point = 0xBF6A; break; // HANGUL SYLLABLE SSANGPIEUP WA RIEULPHIEUPH
    case 0x96E7: code_point = 0xBF6B; break; // HANGUL SYLLABLE SSANGPIEUP WA RIEULHIEUH
    case 0x96E8: code_point = 0xBF6C; break; // HANGUL SYLLABLE SSANGPIEUP WA MIEUM
    case 0x96E9: code_point = 0xBF6D; break; // HANGUL SYLLABLE SSANGPIEUP WA PIEUP
    case 0x96EA: code_point = 0xBF6E; break; // HANGUL SYLLABLE SSANGPIEUP WA PIEUPSIOS
    case 0x96EB: code_point = 0xBF6F; break; // HANGUL SYLLABLE SSANGPIEUP WA SIOS
    case 0x96EC: code_point = 0xBF70; break; // HANGUL SYLLABLE SSANGPIEUP WA SSANGSIOS
    case 0x96ED: code_point = 0xBF71; break; // HANGUL SYLLABLE SSANGPIEUP WA IEUNG
    case 0x96EE: code_point = 0xBF72; break; // HANGUL SYLLABLE SSANGPIEUP WA CIEUC
    case 0x96EF: code_point = 0xBF73; break; // HANGUL SYLLABLE SSANGPIEUP WA CHIEUCH
    case 0x96F0: code_point = 0xBF74; break; // HANGUL SYLLABLE SSANGPIEUP WA KHIEUKH
    case 0x96F1: code_point = 0xBF75; break; // HANGUL SYLLABLE SSANGPIEUP WA THIEUTH
    case 0x96F2: code_point = 0xBF76; break; // HANGUL SYLLABLE SSANGPIEUP WA PHIEUPH
    case 0x96F3: code_point = 0xBF77; break; // HANGUL SYLLABLE SSANGPIEUP WA HIEUH
    case 0x96F4: code_point = 0xBF78; break; // HANGUL SYLLABLE SSANGPIEUP WAE
    case 0x96F5: code_point = 0xBF79; break; // HANGUL SYLLABLE SSANGPIEUP WAE KIYEOK
    case 0x96F6: code_point = 0xBF7A; break; // HANGUL SYLLABLE SSANGPIEUP WAE SSANGKIYEOK
    case 0x96F7: code_point = 0xBF7B; break; // HANGUL SYLLABLE SSANGPIEUP WAE KIYEOKSIOS
    case 0x96F8: code_point = 0xBF7C; break; // HANGUL SYLLABLE SSANGPIEUP WAE NIEUN
    case 0x96F9: code_point = 0xBF7D; break; // HANGUL SYLLABLE SSANGPIEUP WAE NIEUNCIEUC
    case 0x96FA: code_point = 0xBF7E; break; // HANGUL SYLLABLE SSANGPIEUP WAE NIEUNHIEUH
    case 0x96FB: code_point = 0xBF7F; break; // HANGUL SYLLABLE SSANGPIEUP WAE TIKEUT
    case 0x96FC: code_point = 0xBF80; break; // HANGUL SYLLABLE SSANGPIEUP WAE RIEUL
    case 0x96FD: code_point = 0xBF81; break; // HANGUL SYLLABLE SSANGPIEUP WAE RIEULKIYEOK
    case 0x96FE: code_point = 0xBF82; break; // HANGUL SYLLABLE SSANGPIEUP WAE RIEULMIEUM
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x97(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9741: code_point = 0xBF83; break; // HANGUL SYLLABLE SSANGPIEUP WAE RIEULPIEUP
    case 0x9742: code_point = 0xBF84; break; // HANGUL SYLLABLE SSANGPIEUP WAE RIEULSIOS
    case 0x9743: code_point = 0xBF85; break; // HANGUL SYLLABLE SSANGPIEUP WAE RIEULTHIEUTH
    case 0x9744: code_point = 0xBF86; break; // HANGUL SYLLABLE SSANGPIEUP WAE RIEULPHIEUPH
    case 0x9745: code_point = 0xBF87; break; // HANGUL SYLLABLE SSANGPIEUP WAE RIEULHIEUH
    case 0x9746: code_point = 0xBF88; break; // HANGUL SYLLABLE SSANGPIEUP WAE MIEUM
    case 0x9747: code_point = 0xBF89; break; // HANGUL SYLLABLE SSANGPIEUP WAE PIEUP
    case 0x9748: code_point = 0xBF8A; break; // HANGUL SYLLABLE SSANGPIEUP WAE PIEUPSIOS
    case 0x9749: code_point = 0xBF8B; break; // HANGUL SYLLABLE SSANGPIEUP WAE SIOS
    case 0x974A: code_point = 0xBF8C; break; // HANGUL SYLLABLE SSANGPIEUP WAE SSANGSIOS
    case 0x974B: code_point = 0xBF8D; break; // HANGUL SYLLABLE SSANGPIEUP WAE IEUNG
    case 0x974C: code_point = 0xBF8E; break; // HANGUL SYLLABLE SSANGPIEUP WAE CIEUC
    case 0x974D: code_point = 0xBF8F; break; // HANGUL SYLLABLE SSANGPIEUP WAE CHIEUCH
    case 0x974E: code_point = 0xBF90; break; // HANGUL SYLLABLE SSANGPIEUP WAE KHIEUKH
    case 0x974F: code_point = 0xBF91; break; // HANGUL SYLLABLE SSANGPIEUP WAE THIEUTH
    case 0x9750: code_point = 0xBF92; break; // HANGUL SYLLABLE SSANGPIEUP WAE PHIEUPH
    case 0x9751: code_point = 0xBF93; break; // HANGUL SYLLABLE SSANGPIEUP WAE HIEUH
    case 0x9752: code_point = 0xBF95; break; // HANGUL SYLLABLE SSANGPIEUP OE KIYEOK
    case 0x9753: code_point = 0xBF96; break; // HANGUL SYLLABLE SSANGPIEUP OE SSANGKIYEOK
    case 0x9754: code_point = 0xBF97; break; // HANGUL SYLLABLE SSANGPIEUP OE KIYEOKSIOS
    case 0x9755: code_point = 0xBF98; break; // HANGUL SYLLABLE SSANGPIEUP OE NIEUN
    case 0x9756: code_point = 0xBF99; break; // HANGUL SYLLABLE SSANGPIEUP OE NIEUNCIEUC
    case 0x9757: code_point = 0xBF9A; break; // HANGUL SYLLABLE SSANGPIEUP OE NIEUNHIEUH
    case 0x9758: code_point = 0xBF9B; break; // HANGUL SYLLABLE SSANGPIEUP OE TIKEUT
    case 0x9759: code_point = 0xBF9C; break; // HANGUL SYLLABLE SSANGPIEUP OE RIEUL
    case 0x975A: code_point = 0xBF9D; break; // HANGUL SYLLABLE SSANGPIEUP OE RIEULKIYEOK
    case 0x9761: code_point = 0xBF9E; break; // HANGUL SYLLABLE SSANGPIEUP OE RIEULMIEUM
    case 0x9762: code_point = 0xBF9F; break; // HANGUL SYLLABLE SSANGPIEUP OE RIEULPIEUP
    case 0x9763: code_point = 0xBFA0; break; // HANGUL SYLLABLE SSANGPIEUP OE RIEULSIOS
    case 0x9764: code_point = 0xBFA1; break; // HANGUL SYLLABLE SSANGPIEUP OE RIEULTHIEUTH
    case 0x9765: code_point = 0xBFA2; break; // HANGUL SYLLABLE SSANGPIEUP OE RIEULPHIEUPH
    case 0x9766: code_point = 0xBFA3; break; // HANGUL SYLLABLE SSANGPIEUP OE RIEULHIEUH
    case 0x9767: code_point = 0xBFA4; break; // HANGUL SYLLABLE SSANGPIEUP OE MIEUM
    case 0x9768: code_point = 0xBFA5; break; // HANGUL SYLLABLE SSANGPIEUP OE PIEUP
    case 0x9769: code_point = 0xBFA6; break; // HANGUL SYLLABLE SSANGPIEUP OE PIEUPSIOS
    case 0x976A: code_point = 0xBFA7; break; // HANGUL SYLLABLE SSANGPIEUP OE SIOS
    case 0x976B: code_point = 0xBFA8; break; // HANGUL SYLLABLE SSANGPIEUP OE SSANGSIOS
    case 0x976C: code_point = 0xBFA9; break; // HANGUL SYLLABLE SSANGPIEUP OE IEUNG
    case 0x976D: code_point = 0xBFAA; break; // HANGUL SYLLABLE SSANGPIEUP OE CIEUC
    case 0x976E: code_point = 0xBFAB; break; // HANGUL SYLLABLE SSANGPIEUP OE CHIEUCH
    case 0x976F: code_point = 0xBFAC; break; // HANGUL SYLLABLE SSANGPIEUP OE KHIEUKH
    case 0x9770: code_point = 0xBFAD; break; // HANGUL SYLLABLE SSANGPIEUP OE THIEUTH
    case 0x9771: code_point = 0xBFAE; break; // HANGUL SYLLABLE SSANGPIEUP OE PHIEUPH
    case 0x9772: code_point = 0xBFAF; break; // HANGUL SYLLABLE SSANGPIEUP OE HIEUH
    case 0x9773: code_point = 0xBFB1; break; // HANGUL SYLLABLE SSANGPIEUP YO KIYEOK
    case 0x9774: code_point = 0xBFB2; break; // HANGUL SYLLABLE SSANGPIEUP YO SSANGKIYEOK
    case 0x9775: code_point = 0xBFB3; break; // HANGUL SYLLABLE SSANGPIEUP YO KIYEOKSIOS
    case 0x9776: code_point = 0xBFB4; break; // HANGUL SYLLABLE SSANGPIEUP YO NIEUN
    case 0x9777: code_point = 0xBFB5; break; // HANGUL SYLLABLE SSANGPIEUP YO NIEUNCIEUC
    case 0x9778: code_point = 0xBFB6; break; // HANGUL SYLLABLE SSANGPIEUP YO NIEUNHIEUH
    case 0x9779: code_point = 0xBFB7; break; // HANGUL SYLLABLE SSANGPIEUP YO TIKEUT
    case 0x977A: code_point = 0xBFB8; break; // HANGUL SYLLABLE SSANGPIEUP YO RIEUL
    case 0x9781: code_point = 0xBFB9; break; // HANGUL SYLLABLE SSANGPIEUP YO RIEULKIYEOK
    case 0x9782: code_point = 0xBFBA; break; // HANGUL SYLLABLE SSANGPIEUP YO RIEULMIEUM
    case 0x9783: code_point = 0xBFBB; break; // HANGUL SYLLABLE SSANGPIEUP YO RIEULPIEUP
    case 0x9784: code_point = 0xBFBC; break; // HANGUL SYLLABLE SSANGPIEUP YO RIEULSIOS
    case 0x9785: code_point = 0xBFBD; break; // HANGUL SYLLABLE SSANGPIEUP YO RIEULTHIEUTH
    case 0x9786: code_point = 0xBFBE; break; // HANGUL SYLLABLE SSANGPIEUP YO RIEULPHIEUPH
    case 0x9787: code_point = 0xBFBF; break; // HANGUL SYLLABLE SSANGPIEUP YO RIEULHIEUH
    case 0x9788: code_point = 0xBFC0; break; // HANGUL SYLLABLE SSANGPIEUP YO MIEUM
    case 0x9789: code_point = 0xBFC1; break; // HANGUL SYLLABLE SSANGPIEUP YO PIEUP
    case 0x978A: code_point = 0xBFC2; break; // HANGUL SYLLABLE SSANGPIEUP YO PIEUPSIOS
    case 0x978B: code_point = 0xBFC3; break; // HANGUL SYLLABLE SSANGPIEUP YO SIOS
    case 0x978C: code_point = 0xBFC4; break; // HANGUL SYLLABLE SSANGPIEUP YO SSANGSIOS
    case 0x978D: code_point = 0xBFC6; break; // HANGUL SYLLABLE SSANGPIEUP YO CIEUC
    case 0x978E: code_point = 0xBFC7; break; // HANGUL SYLLABLE SSANGPIEUP YO CHIEUCH
    case 0x978F: code_point = 0xBFC8; break; // HANGUL SYLLABLE SSANGPIEUP YO KHIEUKH
    case 0x9790: code_point = 0xBFC9; break; // HANGUL SYLLABLE SSANGPIEUP YO THIEUTH
    case 0x9791: code_point = 0xBFCA; break; // HANGUL SYLLABLE SSANGPIEUP YO PHIEUPH
    case 0x9792: code_point = 0xBFCB; break; // HANGUL SYLLABLE SSANGPIEUP YO HIEUH
    case 0x9793: code_point = 0xBFCE; break; // HANGUL SYLLABLE SSANGPIEUP U SSANGKIYEOK
    case 0x9794: code_point = 0xBFCF; break; // HANGUL SYLLABLE SSANGPIEUP U KIYEOKSIOS
    case 0x9795: code_point = 0xBFD1; break; // HANGUL SYLLABLE SSANGPIEUP U NIEUNCIEUC
    case 0x9796: code_point = 0xBFD2; break; // HANGUL SYLLABLE SSANGPIEUP U NIEUNHIEUH
    case 0x9797: code_point = 0xBFD3; break; // HANGUL SYLLABLE SSANGPIEUP U TIKEUT
    case 0x9798: code_point = 0xBFD5; break; // HANGUL SYLLABLE SSANGPIEUP U RIEULKIYEOK
    case 0x9799: code_point = 0xBFD6; break; // HANGUL SYLLABLE SSANGPIEUP U RIEULMIEUM
    case 0x979A: code_point = 0xBFD7; break; // HANGUL SYLLABLE SSANGPIEUP U RIEULPIEUP
    case 0x979B: code_point = 0xBFD8; break; // HANGUL SYLLABLE SSANGPIEUP U RIEULSIOS
    case 0x979C: code_point = 0xBFD9; break; // HANGUL SYLLABLE SSANGPIEUP U RIEULTHIEUTH
    case 0x979D: code_point = 0xBFDA; break; // HANGUL SYLLABLE SSANGPIEUP U RIEULPHIEUPH
    case 0x979E: code_point = 0xBFDB; break; // HANGUL SYLLABLE SSANGPIEUP U RIEULHIEUH
    case 0x979F: code_point = 0xBFDD; break; // HANGUL SYLLABLE SSANGPIEUP U PIEUP
    case 0x97A0: code_point = 0xBFDE; break; // HANGUL SYLLABLE SSANGPIEUP U PIEUPSIOS
    case 0x97A1: code_point = 0xBFE0; break; // HANGUL SYLLABLE SSANGPIEUP U SSANGSIOS
    case 0x97A2: code_point = 0xBFE2; break; // HANGUL SYLLABLE SSANGPIEUP U CIEUC
    case 0x97A3: code_point = 0xBFE3; break; // HANGUL SYLLABLE SSANGPIEUP U CHIEUCH
    case 0x97A4: code_point = 0xBFE4; break; // HANGUL SYLLABLE SSANGPIEUP U KHIEUKH
    case 0x97A5: code_point = 0xBFE5; break; // HANGUL SYLLABLE SSANGPIEUP U THIEUTH
    case 0x97A6: code_point = 0xBFE6; break; // HANGUL SYLLABLE SSANGPIEUP U PHIEUPH
    case 0x97A7: code_point = 0xBFE7; break; // HANGUL SYLLABLE SSANGPIEUP U HIEUH
    case 0x97A8: code_point = 0xBFE8; break; // HANGUL SYLLABLE SSANGPIEUP WEO
    case 0x97A9: code_point = 0xBFE9; break; // HANGUL SYLLABLE SSANGPIEUP WEO KIYEOK
    case 0x97AA: code_point = 0xBFEA; break; // HANGUL SYLLABLE SSANGPIEUP WEO SSANGKIYEOK
    case 0x97AB: code_point = 0xBFEB; break; // HANGUL SYLLABLE SSANGPIEUP WEO KIYEOKSIOS
    case 0x97AC: code_point = 0xBFEC; break; // HANGUL SYLLABLE SSANGPIEUP WEO NIEUN
    case 0x97AD: code_point = 0xBFED; break; // HANGUL SYLLABLE SSANGPIEUP WEO NIEUNCIEUC
    case 0x97AE: code_point = 0xBFEE; break; // HANGUL SYLLABLE SSANGPIEUP WEO NIEUNHIEUH
    case 0x97AF: code_point = 0xBFEF; break; // HANGUL SYLLABLE SSANGPIEUP WEO TIKEUT
    case 0x97B0: code_point = 0xBFF0; break; // HANGUL SYLLABLE SSANGPIEUP WEO RIEUL
    case 0x97B1: code_point = 0xBFF1; break; // HANGUL SYLLABLE SSANGPIEUP WEO RIEULKIYEOK
    case 0x97B2: code_point = 0xBFF2; break; // HANGUL SYLLABLE SSANGPIEUP WEO RIEULMIEUM
    case 0x97B3: code_point = 0xBFF3; break; // HANGUL SYLLABLE SSANGPIEUP WEO RIEULPIEUP
    case 0x97B4: code_point = 0xBFF4; break; // HANGUL SYLLABLE SSANGPIEUP WEO RIEULSIOS
    case 0x97B5: code_point = 0xBFF5; break; // HANGUL SYLLABLE SSANGPIEUP WEO RIEULTHIEUTH
    case 0x97B6: code_point = 0xBFF6; break; // HANGUL SYLLABLE SSANGPIEUP WEO RIEULPHIEUPH
    case 0x97B7: code_point = 0xBFF7; break; // HANGUL SYLLABLE SSANGPIEUP WEO RIEULHIEUH
    case 0x97B8: code_point = 0xBFF8; break; // HANGUL SYLLABLE SSANGPIEUP WEO MIEUM
    case 0x97B9: code_point = 0xBFF9; break; // HANGUL SYLLABLE SSANGPIEUP WEO PIEUP
    case 0x97BA: code_point = 0xBFFA; break; // HANGUL SYLLABLE SSANGPIEUP WEO PIEUPSIOS
    case 0x97BB: code_point = 0xBFFB; break; // HANGUL SYLLABLE SSANGPIEUP WEO SIOS
    case 0x97BC: code_point = 0xBFFC; break; // HANGUL SYLLABLE SSANGPIEUP WEO SSANGSIOS
    case 0x97BD: code_point = 0xBFFD; break; // HANGUL SYLLABLE SSANGPIEUP WEO IEUNG
    case 0x97BE: code_point = 0xBFFE; break; // HANGUL SYLLABLE SSANGPIEUP WEO CIEUC
    case 0x97BF: code_point = 0xBFFF; break; // HANGUL SYLLABLE SSANGPIEUP WEO CHIEUCH
    case 0x97C0: code_point = 0xC000; break; // HANGUL SYLLABLE SSANGPIEUP WEO KHIEUKH
    case 0x97C1: code_point = 0xC001; break; // HANGUL SYLLABLE SSANGPIEUP WEO THIEUTH
    case 0x97C2: code_point = 0xC002; break; // HANGUL SYLLABLE SSANGPIEUP WEO PHIEUPH
    case 0x97C3: code_point = 0xC003; break; // HANGUL SYLLABLE SSANGPIEUP WEO HIEUH
    case 0x97C4: code_point = 0xC004; break; // HANGUL SYLLABLE SSANGPIEUP WE
    case 0x97C5: code_point = 0xC005; break; // HANGUL SYLLABLE SSANGPIEUP WE KIYEOK
    case 0x97C6: code_point = 0xC006; break; // HANGUL SYLLABLE SSANGPIEUP WE SSANGKIYEOK
    case 0x97C7: code_point = 0xC007; break; // HANGUL SYLLABLE SSANGPIEUP WE KIYEOKSIOS
    case 0x97C8: code_point = 0xC008; break; // HANGUL SYLLABLE SSANGPIEUP WE NIEUN
    case 0x97C9: code_point = 0xC009; break; // HANGUL SYLLABLE SSANGPIEUP WE NIEUNCIEUC
    case 0x97CA: code_point = 0xC00A; break; // HANGUL SYLLABLE SSANGPIEUP WE NIEUNHIEUH
    case 0x97CB: code_point = 0xC00B; break; // HANGUL SYLLABLE SSANGPIEUP WE TIKEUT
    case 0x97CC: code_point = 0xC00C; break; // HANGUL SYLLABLE SSANGPIEUP WE RIEUL
    case 0x97CD: code_point = 0xC00D; break; // HANGUL SYLLABLE SSANGPIEUP WE RIEULKIYEOK
    case 0x97CE: code_point = 0xC00E; break; // HANGUL SYLLABLE SSANGPIEUP WE RIEULMIEUM
    case 0x97CF: code_point = 0xC00F; break; // HANGUL SYLLABLE SSANGPIEUP WE RIEULPIEUP
    case 0x97D0: code_point = 0xC010; break; // HANGUL SYLLABLE SSANGPIEUP WE RIEULSIOS
    case 0x97D1: code_point = 0xC011; break; // HANGUL SYLLABLE SSANGPIEUP WE RIEULTHIEUTH
    case 0x97D2: code_point = 0xC012; break; // HANGUL SYLLABLE SSANGPIEUP WE RIEULPHIEUPH
    case 0x97D3: code_point = 0xC013; break; // HANGUL SYLLABLE SSANGPIEUP WE RIEULHIEUH
    case 0x97D4: code_point = 0xC014; break; // HANGUL SYLLABLE SSANGPIEUP WE MIEUM
    case 0x97D5: code_point = 0xC015; break; // HANGUL SYLLABLE SSANGPIEUP WE PIEUP
    case 0x97D6: code_point = 0xC016; break; // HANGUL SYLLABLE SSANGPIEUP WE PIEUPSIOS
    case 0x97D7: code_point = 0xC017; break; // HANGUL SYLLABLE SSANGPIEUP WE SIOS
    case 0x97D8: code_point = 0xC018; break; // HANGUL SYLLABLE SSANGPIEUP WE SSANGSIOS
    case 0x97D9: code_point = 0xC019; break; // HANGUL SYLLABLE SSANGPIEUP WE IEUNG
    case 0x97DA: code_point = 0xC01A; break; // HANGUL SYLLABLE SSANGPIEUP WE CIEUC
    case 0x97DB: code_point = 0xC01B; break; // HANGUL SYLLABLE SSANGPIEUP WE CHIEUCH
    case 0x97DC: code_point = 0xC01C; break; // HANGUL SYLLABLE SSANGPIEUP WE KHIEUKH
    case 0x97DD: code_point = 0xC01D; break; // HANGUL SYLLABLE SSANGPIEUP WE THIEUTH
    case 0x97DE: code_point = 0xC01E; break; // HANGUL SYLLABLE SSANGPIEUP WE PHIEUPH
    case 0x97DF: code_point = 0xC01F; break; // HANGUL SYLLABLE SSANGPIEUP WE HIEUH
    case 0x97E0: code_point = 0xC020; break; // HANGUL SYLLABLE SSANGPIEUP WI
    case 0x97E1: code_point = 0xC021; break; // HANGUL SYLLABLE SSANGPIEUP WI KIYEOK
    case 0x97E2: code_point = 0xC022; break; // HANGUL SYLLABLE SSANGPIEUP WI SSANGKIYEOK
    case 0x97E3: code_point = 0xC023; break; // HANGUL SYLLABLE SSANGPIEUP WI KIYEOKSIOS
    case 0x97E4: code_point = 0xC024; break; // HANGUL SYLLABLE SSANGPIEUP WI NIEUN
    case 0x97E5: code_point = 0xC025; break; // HANGUL SYLLABLE SSANGPIEUP WI NIEUNCIEUC
    case 0x97E6: code_point = 0xC026; break; // HANGUL SYLLABLE SSANGPIEUP WI NIEUNHIEUH
    case 0x97E7: code_point = 0xC027; break; // HANGUL SYLLABLE SSANGPIEUP WI TIKEUT
    case 0x97E8: code_point = 0xC028; break; // HANGUL SYLLABLE SSANGPIEUP WI RIEUL
    case 0x97E9: code_point = 0xC029; break; // HANGUL SYLLABLE SSANGPIEUP WI RIEULKIYEOK
    case 0x97EA: code_point = 0xC02A; break; // HANGUL SYLLABLE SSANGPIEUP WI RIEULMIEUM
    case 0x97EB: code_point = 0xC02B; break; // HANGUL SYLLABLE SSANGPIEUP WI RIEULPIEUP
    case 0x97EC: code_point = 0xC02C; break; // HANGUL SYLLABLE SSANGPIEUP WI RIEULSIOS
    case 0x97ED: code_point = 0xC02D; break; // HANGUL SYLLABLE SSANGPIEUP WI RIEULTHIEUTH
    case 0x97EE: code_point = 0xC02E; break; // HANGUL SYLLABLE SSANGPIEUP WI RIEULPHIEUPH
    case 0x97EF: code_point = 0xC02F; break; // HANGUL SYLLABLE SSANGPIEUP WI RIEULHIEUH
    case 0x97F0: code_point = 0xC030; break; // HANGUL SYLLABLE SSANGPIEUP WI MIEUM
    case 0x97F1: code_point = 0xC031; break; // HANGUL SYLLABLE SSANGPIEUP WI PIEUP
    case 0x97F2: code_point = 0xC032; break; // HANGUL SYLLABLE SSANGPIEUP WI PIEUPSIOS
    case 0x97F3: code_point = 0xC033; break; // HANGUL SYLLABLE SSANGPIEUP WI SIOS
    case 0x97F4: code_point = 0xC034; break; // HANGUL SYLLABLE SSANGPIEUP WI SSANGSIOS
    case 0x97F5: code_point = 0xC035; break; // HANGUL SYLLABLE SSANGPIEUP WI IEUNG
    case 0x97F6: code_point = 0xC036; break; // HANGUL SYLLABLE SSANGPIEUP WI CIEUC
    case 0x97F7: code_point = 0xC037; break; // HANGUL SYLLABLE SSANGPIEUP WI CHIEUCH
    case 0x97F8: code_point = 0xC038; break; // HANGUL SYLLABLE SSANGPIEUP WI KHIEUKH
    case 0x97F9: code_point = 0xC039; break; // HANGUL SYLLABLE SSANGPIEUP WI THIEUTH
    case 0x97FA: code_point = 0xC03A; break; // HANGUL SYLLABLE SSANGPIEUP WI PHIEUPH
    case 0x97FB: code_point = 0xC03B; break; // HANGUL SYLLABLE SSANGPIEUP WI HIEUH
    case 0x97FC: code_point = 0xC03D; break; // HANGUL SYLLABLE SSANGPIEUP YU KIYEOK
    case 0x97FD: code_point = 0xC03E; break; // HANGUL SYLLABLE SSANGPIEUP YU SSANGKIYEOK
    case 0x97FE: code_point = 0xC03F; break; // HANGUL SYLLABLE SSANGPIEUP YU KIYEOKSIOS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x98(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9841: code_point = 0xC040; break; // HANGUL SYLLABLE SSANGPIEUP YU NIEUN
    case 0x9842: code_point = 0xC041; break; // HANGUL SYLLABLE SSANGPIEUP YU NIEUNCIEUC
    case 0x9843: code_point = 0xC042; break; // HANGUL SYLLABLE SSANGPIEUP YU NIEUNHIEUH
    case 0x9844: code_point = 0xC043; break; // HANGUL SYLLABLE SSANGPIEUP YU TIKEUT
    case 0x9845: code_point = 0xC044; break; // HANGUL SYLLABLE SSANGPIEUP YU RIEUL
    case 0x9846: code_point = 0xC045; break; // HANGUL SYLLABLE SSANGPIEUP YU RIEULKIYEOK
    case 0x9847: code_point = 0xC046; break; // HANGUL SYLLABLE SSANGPIEUP YU RIEULMIEUM
    case 0x9848: code_point = 0xC047; break; // HANGUL SYLLABLE SSANGPIEUP YU RIEULPIEUP
    case 0x9849: code_point = 0xC048; break; // HANGUL SYLLABLE SSANGPIEUP YU RIEULSIOS
    case 0x984A: code_point = 0xC049; break; // HANGUL SYLLABLE SSANGPIEUP YU RIEULTHIEUTH
    case 0x984B: code_point = 0xC04A; break; // HANGUL SYLLABLE SSANGPIEUP YU RIEULPHIEUPH
    case 0x984C: code_point = 0xC04B; break; // HANGUL SYLLABLE SSANGPIEUP YU RIEULHIEUH
    case 0x984D: code_point = 0xC04C; break; // HANGUL SYLLABLE SSANGPIEUP YU MIEUM
    case 0x984E: code_point = 0xC04D; break; // HANGUL SYLLABLE SSANGPIEUP YU PIEUP
    case 0x984F: code_point = 0xC04E; break; // HANGUL SYLLABLE SSANGPIEUP YU PIEUPSIOS
    case 0x9850: code_point = 0xC04F; break; // HANGUL SYLLABLE SSANGPIEUP YU SIOS
    case 0x9851: code_point = 0xC050; break; // HANGUL SYLLABLE SSANGPIEUP YU SSANGSIOS
    case 0x9852: code_point = 0xC052; break; // HANGUL SYLLABLE SSANGPIEUP YU CIEUC
    case 0x9853: code_point = 0xC053; break; // HANGUL SYLLABLE SSANGPIEUP YU CHIEUCH
    case 0x9854: code_point = 0xC054; break; // HANGUL SYLLABLE SSANGPIEUP YU KHIEUKH
    case 0x9855: code_point = 0xC055; break; // HANGUL SYLLABLE SSANGPIEUP YU THIEUTH
    case 0x9856: code_point = 0xC056; break; // HANGUL SYLLABLE SSANGPIEUP YU PHIEUPH
    case 0x9857: code_point = 0xC057; break; // HANGUL SYLLABLE SSANGPIEUP YU HIEUH
    case 0x9858: code_point = 0xC059; break; // HANGUL SYLLABLE SSANGPIEUP EU KIYEOK
    case 0x9859: code_point = 0xC05A; break; // HANGUL SYLLABLE SSANGPIEUP EU SSANGKIYEOK
    case 0x985A: code_point = 0xC05B; break; // HANGUL SYLLABLE SSANGPIEUP EU KIYEOKSIOS
    case 0x9861: code_point = 0xC05D; break; // HANGUL SYLLABLE SSANGPIEUP EU NIEUNCIEUC
    case 0x9862: code_point = 0xC05E; break; // HANGUL SYLLABLE SSANGPIEUP EU NIEUNHIEUH
    case 0x9863: code_point = 0xC05F; break; // HANGUL SYLLABLE SSANGPIEUP EU TIKEUT
    case 0x9864: code_point = 0xC061; break; // HANGUL SYLLABLE SSANGPIEUP EU RIEULKIYEOK
    case 0x9865: code_point = 0xC062; break; // HANGUL SYLLABLE SSANGPIEUP EU RIEULMIEUM
    case 0x9866: code_point = 0xC063; break; // HANGUL SYLLABLE SSANGPIEUP EU RIEULPIEUP
    case 0x9867: code_point = 0xC064; break; // HANGUL SYLLABLE SSANGPIEUP EU RIEULSIOS
    case 0x9868: code_point = 0xC065; break; // HANGUL SYLLABLE SSANGPIEUP EU RIEULTHIEUTH
    case 0x9869: code_point = 0xC066; break; // HANGUL SYLLABLE SSANGPIEUP EU RIEULPHIEUPH
    case 0x986A: code_point = 0xC067; break; // HANGUL SYLLABLE SSANGPIEUP EU RIEULHIEUH
    case 0x986B: code_point = 0xC06A; break; // HANGUL SYLLABLE SSANGPIEUP EU PIEUPSIOS
    case 0x986C: code_point = 0xC06B; break; // HANGUL SYLLABLE SSANGPIEUP EU SIOS
    case 0x986D: code_point = 0xC06C; break; // HANGUL SYLLABLE SSANGPIEUP EU SSANGSIOS
    case 0x986E: code_point = 0xC06D; break; // HANGUL SYLLABLE SSANGPIEUP EU IEUNG
    case 0x986F: code_point = 0xC06E; break; // HANGUL SYLLABLE SSANGPIEUP EU CIEUC
    case 0x9870: code_point = 0xC06F; break; // HANGUL SYLLABLE SSANGPIEUP EU CHIEUCH
    case 0x9871: code_point = 0xC070; break; // HANGUL SYLLABLE SSANGPIEUP EU KHIEUKH
    case 0x9872: code_point = 0xC071; break; // HANGUL SYLLABLE SSANGPIEUP EU THIEUTH
    case 0x9873: code_point = 0xC072; break; // HANGUL SYLLABLE SSANGPIEUP EU PHIEUPH
    case 0x9874: code_point = 0xC073; break; // HANGUL SYLLABLE SSANGPIEUP EU HIEUH
    case 0x9875: code_point = 0xC074; break; // HANGUL SYLLABLE SSANGPIEUP YI
    case 0x9876: code_point = 0xC075; break; // HANGUL SYLLABLE SSANGPIEUP YI KIYEOK
    case 0x9877: code_point = 0xC076; break; // HANGUL SYLLABLE SSANGPIEUP YI SSANGKIYEOK
    case 0x9878: code_point = 0xC077; break; // HANGUL SYLLABLE SSANGPIEUP YI KIYEOKSIOS
    case 0x9879: code_point = 0xC078; break; // HANGUL SYLLABLE SSANGPIEUP YI NIEUN
    case 0x987A: code_point = 0xC079; break; // HANGUL SYLLABLE SSANGPIEUP YI NIEUNCIEUC
    case 0x9881: code_point = 0xC07A; break; // HANGUL SYLLABLE SSANGPIEUP YI NIEUNHIEUH
    case 0x9882: code_point = 0xC07B; break; // HANGUL SYLLABLE SSANGPIEUP YI TIKEUT
    case 0x9883: code_point = 0xC07C; break; // HANGUL SYLLABLE SSANGPIEUP YI RIEUL
    case 0x9884: code_point = 0xC07D; break; // HANGUL SYLLABLE SSANGPIEUP YI RIEULKIYEOK
    case 0x9885: code_point = 0xC07E; break; // HANGUL SYLLABLE SSANGPIEUP YI RIEULMIEUM
    case 0x9886: code_point = 0xC07F; break; // HANGUL SYLLABLE SSANGPIEUP YI RIEULPIEUP
    case 0x9887: code_point = 0xC080; break; // HANGUL SYLLABLE SSANGPIEUP YI RIEULSIOS
    case 0x9888: code_point = 0xC081; break; // HANGUL SYLLABLE SSANGPIEUP YI RIEULTHIEUTH
    case 0x9889: code_point = 0xC082; break; // HANGUL SYLLABLE SSANGPIEUP YI RIEULPHIEUPH
    case 0x988A: code_point = 0xC083; break; // HANGUL SYLLABLE SSANGPIEUP YI RIEULHIEUH
    case 0x988B: code_point = 0xC084; break; // HANGUL SYLLABLE SSANGPIEUP YI MIEUM
    case 0x988C: code_point = 0xC085; break; // HANGUL SYLLABLE SSANGPIEUP YI PIEUP
    case 0x988D: code_point = 0xC086; break; // HANGUL SYLLABLE SSANGPIEUP YI PIEUPSIOS
    case 0x988E: code_point = 0xC087; break; // HANGUL SYLLABLE SSANGPIEUP YI SIOS
    case 0x988F: code_point = 0xC088; break; // HANGUL SYLLABLE SSANGPIEUP YI SSANGSIOS
    case 0x9890: code_point = 0xC089; break; // HANGUL SYLLABLE SSANGPIEUP YI IEUNG
    case 0x9891: code_point = 0xC08A; break; // HANGUL SYLLABLE SSANGPIEUP YI CIEUC
    case 0x9892: code_point = 0xC08B; break; // HANGUL SYLLABLE SSANGPIEUP YI CHIEUCH
    case 0x9893: code_point = 0xC08C; break; // HANGUL SYLLABLE SSANGPIEUP YI KHIEUKH
    case 0x9894: code_point = 0xC08D; break; // HANGUL SYLLABLE SSANGPIEUP YI THIEUTH
    case 0x9895: code_point = 0xC08E; break; // HANGUL SYLLABLE SSANGPIEUP YI PHIEUPH
    case 0x9896: code_point = 0xC08F; break; // HANGUL SYLLABLE SSANGPIEUP YI HIEUH
    case 0x9897: code_point = 0xC092; break; // HANGUL SYLLABLE SSANGPIEUP I SSANGKIYEOK
    case 0x9898: code_point = 0xC093; break; // HANGUL SYLLABLE SSANGPIEUP I KIYEOKSIOS
    case 0x9899: code_point = 0xC095; break; // HANGUL SYLLABLE SSANGPIEUP I NIEUNCIEUC
    case 0x989A: code_point = 0xC096; break; // HANGUL SYLLABLE SSANGPIEUP I NIEUNHIEUH
    case 0x989B: code_point = 0xC097; break; // HANGUL SYLLABLE SSANGPIEUP I TIKEUT
    case 0x989C: code_point = 0xC099; break; // HANGUL SYLLABLE SSANGPIEUP I RIEULKIYEOK
    case 0x989D: code_point = 0xC09A; break; // HANGUL SYLLABLE SSANGPIEUP I RIEULMIEUM
    case 0x989E: code_point = 0xC09B; break; // HANGUL SYLLABLE SSANGPIEUP I RIEULPIEUP
    case 0x989F: code_point = 0xC09C; break; // HANGUL SYLLABLE SSANGPIEUP I RIEULSIOS
    case 0x98A0: code_point = 0xC09D; break; // HANGUL SYLLABLE SSANGPIEUP I RIEULTHIEUTH
    case 0x98A1: code_point = 0xC09E; break; // HANGUL SYLLABLE SSANGPIEUP I RIEULPHIEUPH
    case 0x98A2: code_point = 0xC09F; break; // HANGUL SYLLABLE SSANGPIEUP I RIEULHIEUH
    case 0x98A3: code_point = 0xC0A2; break; // HANGUL SYLLABLE SSANGPIEUP I PIEUPSIOS
    case 0x98A4: code_point = 0xC0A4; break; // HANGUL SYLLABLE SSANGPIEUP I SSANGSIOS
    case 0x98A5: code_point = 0xC0A6; break; // HANGUL SYLLABLE SSANGPIEUP I CIEUC
    case 0x98A6: code_point = 0xC0A7; break; // HANGUL SYLLABLE SSANGPIEUP I CHIEUCH
    case 0x98A7: code_point = 0xC0A8; break; // HANGUL SYLLABLE SSANGPIEUP I KHIEUKH
    case 0x98A8: code_point = 0xC0A9; break; // HANGUL SYLLABLE SSANGPIEUP I THIEUTH
    case 0x98A9: code_point = 0xC0AA; break; // HANGUL SYLLABLE SSANGPIEUP I PHIEUPH
    case 0x98AA: code_point = 0xC0AB; break; // HANGUL SYLLABLE SSANGPIEUP I HIEUH
    case 0x98AB: code_point = 0xC0AE; break; // HANGUL SYLLABLE SIOS A SSANGKIYEOK
    case 0x98AC: code_point = 0xC0B1; break; // HANGUL SYLLABLE SIOS A NIEUNCIEUC
    case 0x98AD: code_point = 0xC0B2; break; // HANGUL SYLLABLE SIOS A NIEUNHIEUH
    case 0x98AE: code_point = 0xC0B7; break; // HANGUL SYLLABLE SIOS A RIEULPIEUP
    case 0x98AF: code_point = 0xC0B8; break; // HANGUL SYLLABLE SIOS A RIEULSIOS
    case 0x98B0: code_point = 0xC0B9; break; // HANGUL SYLLABLE SIOS A RIEULTHIEUTH
    case 0x98B1: code_point = 0xC0BA; break; // HANGUL SYLLABLE SIOS A RIEULPHIEUPH
    case 0x98B2: code_point = 0xC0BB; break; // HANGUL SYLLABLE SIOS A RIEULHIEUH
    case 0x98B3: code_point = 0xC0BE; break; // HANGUL SYLLABLE SIOS A PIEUPSIOS
    case 0x98B4: code_point = 0xC0C2; break; // HANGUL SYLLABLE SIOS A CIEUC
    case 0x98B5: code_point = 0xC0C3; break; // HANGUL SYLLABLE SIOS A CHIEUCH
    case 0x98B6: code_point = 0xC0C4; break; // HANGUL SYLLABLE SIOS A KHIEUKH
    case 0x98B7: code_point = 0xC0C6; break; // HANGUL SYLLABLE SIOS A PHIEUPH
    case 0x98B8: code_point = 0xC0C7; break; // HANGUL SYLLABLE SIOS A HIEUH
    case 0x98B9: code_point = 0xC0CA; break; // HANGUL SYLLABLE SIOS AE SSANGKIYEOK
    case 0x98BA: code_point = 0xC0CB; break; // HANGUL SYLLABLE SIOS AE KIYEOKSIOS
    case 0x98BB: code_point = 0xC0CD; break; // HANGUL SYLLABLE SIOS AE NIEUNCIEUC
    case 0x98BC: code_point = 0xC0CE; break; // HANGUL SYLLABLE SIOS AE NIEUNHIEUH
    case 0x98BD: code_point = 0xC0CF; break; // HANGUL SYLLABLE SIOS AE TIKEUT
    case 0x98BE: code_point = 0xC0D1; break; // HANGUL SYLLABLE SIOS AE RIEULKIYEOK
    case 0x98BF: code_point = 0xC0D2; break; // HANGUL SYLLABLE SIOS AE RIEULMIEUM
    case 0x98C0: code_point = 0xC0D3; break; // HANGUL SYLLABLE SIOS AE RIEULPIEUP
    case 0x98C1: code_point = 0xC0D4; break; // HANGUL SYLLABLE SIOS AE RIEULSIOS
    case 0x98C2: code_point = 0xC0D5; break; // HANGUL SYLLABLE SIOS AE RIEULTHIEUTH
    case 0x98C3: code_point = 0xC0D6; break; // HANGUL SYLLABLE SIOS AE RIEULPHIEUPH
    case 0x98C4: code_point = 0xC0D7; break; // HANGUL SYLLABLE SIOS AE RIEULHIEUH
    case 0x98C5: code_point = 0xC0DA; break; // HANGUL SYLLABLE SIOS AE PIEUPSIOS
    case 0x98C6: code_point = 0xC0DE; break; // HANGUL SYLLABLE SIOS AE CIEUC
    case 0x98C7: code_point = 0xC0DF; break; // HANGUL SYLLABLE SIOS AE CHIEUCH
    case 0x98C8: code_point = 0xC0E0; break; // HANGUL SYLLABLE SIOS AE KHIEUKH
    case 0x98C9: code_point = 0xC0E1; break; // HANGUL SYLLABLE SIOS AE THIEUTH
    case 0x98CA: code_point = 0xC0E2; break; // HANGUL SYLLABLE SIOS AE PHIEUPH
    case 0x98CB: code_point = 0xC0E3; break; // HANGUL SYLLABLE SIOS AE HIEUH
    case 0x98CC: code_point = 0xC0E6; break; // HANGUL SYLLABLE SIOS YA SSANGKIYEOK
    case 0x98CD: code_point = 0xC0E7; break; // HANGUL SYLLABLE SIOS YA KIYEOKSIOS
    case 0x98CE: code_point = 0xC0E9; break; // HANGUL SYLLABLE SIOS YA NIEUNCIEUC
    case 0x98CF: code_point = 0xC0EA; break; // HANGUL SYLLABLE SIOS YA NIEUNHIEUH
    case 0x98D0: code_point = 0xC0EB; break; // HANGUL SYLLABLE SIOS YA TIKEUT
    case 0x98D1: code_point = 0xC0ED; break; // HANGUL SYLLABLE SIOS YA RIEULKIYEOK
    case 0x98D2: code_point = 0xC0EE; break; // HANGUL SYLLABLE SIOS YA RIEULMIEUM
    case 0x98D3: code_point = 0xC0EF; break; // HANGUL SYLLABLE SIOS YA RIEULPIEUP
    case 0x98D4: code_point = 0xC0F0; break; // HANGUL SYLLABLE SIOS YA RIEULSIOS
    case 0x98D5: code_point = 0xC0F1; break; // HANGUL SYLLABLE SIOS YA RIEULTHIEUTH
    case 0x98D6: code_point = 0xC0F2; break; // HANGUL SYLLABLE SIOS YA RIEULPHIEUPH
    case 0x98D7: code_point = 0xC0F3; break; // HANGUL SYLLABLE SIOS YA RIEULHIEUH
    case 0x98D8: code_point = 0xC0F6; break; // HANGUL SYLLABLE SIOS YA PIEUPSIOS
    case 0x98D9: code_point = 0xC0F8; break; // HANGUL SYLLABLE SIOS YA SSANGSIOS
    case 0x98DA: code_point = 0xC0FA; break; // HANGUL SYLLABLE SIOS YA CIEUC
    case 0x98DB: code_point = 0xC0FB; break; // HANGUL SYLLABLE SIOS YA CHIEUCH
    case 0x98DC: code_point = 0xC0FC; break; // HANGUL SYLLABLE SIOS YA KHIEUKH
    case 0x98DD: code_point = 0xC0FD; break; // HANGUL SYLLABLE SIOS YA THIEUTH
    case 0x98DE: code_point = 0xC0FE; break; // HANGUL SYLLABLE SIOS YA PHIEUPH
    case 0x98DF: code_point = 0xC0FF; break; // HANGUL SYLLABLE SIOS YA HIEUH
    case 0x98E0: code_point = 0xC101; break; // HANGUL SYLLABLE SIOS YAE KIYEOK
    case 0x98E1: code_point = 0xC102; break; // HANGUL SYLLABLE SIOS YAE SSANGKIYEOK
    case 0x98E2: code_point = 0xC103; break; // HANGUL SYLLABLE SIOS YAE KIYEOKSIOS
    case 0x98E3: code_point = 0xC105; break; // HANGUL SYLLABLE SIOS YAE NIEUNCIEUC
    case 0x98E4: code_point = 0xC106; break; // HANGUL SYLLABLE SIOS YAE NIEUNHIEUH
    case 0x98E5: code_point = 0xC107; break; // HANGUL SYLLABLE SIOS YAE TIKEUT
    case 0x98E6: code_point = 0xC109; break; // HANGUL SYLLABLE SIOS YAE RIEULKIYEOK
    case 0x98E7: code_point = 0xC10A; break; // HANGUL SYLLABLE SIOS YAE RIEULMIEUM
    case 0x98E8: code_point = 0xC10B; break; // HANGUL SYLLABLE SIOS YAE RIEULPIEUP
    case 0x98E9: code_point = 0xC10C; break; // HANGUL SYLLABLE SIOS YAE RIEULSIOS
    case 0x98EA: code_point = 0xC10D; break; // HANGUL SYLLABLE SIOS YAE RIEULTHIEUTH
    case 0x98EB: code_point = 0xC10E; break; // HANGUL SYLLABLE SIOS YAE RIEULPHIEUPH
    case 0x98EC: code_point = 0xC10F; break; // HANGUL SYLLABLE SIOS YAE RIEULHIEUH
    case 0x98ED: code_point = 0xC111; break; // HANGUL SYLLABLE SIOS YAE PIEUP
    case 0x98EE: code_point = 0xC112; break; // HANGUL SYLLABLE SIOS YAE PIEUPSIOS
    case 0x98EF: code_point = 0xC113; break; // HANGUL SYLLABLE SIOS YAE SIOS
    case 0x98F0: code_point = 0xC114; break; // HANGUL SYLLABLE SIOS YAE SSANGSIOS
    case 0x98F1: code_point = 0xC116; break; // HANGUL SYLLABLE SIOS YAE CIEUC
    case 0x98F2: code_point = 0xC117; break; // HANGUL SYLLABLE SIOS YAE CHIEUCH
    case 0x98F3: code_point = 0xC118; break; // HANGUL SYLLABLE SIOS YAE KHIEUKH
    case 0x98F4: code_point = 0xC119; break; // HANGUL SYLLABLE SIOS YAE THIEUTH
    case 0x98F5: code_point = 0xC11A; break; // HANGUL SYLLABLE SIOS YAE PHIEUPH
    case 0x98F6: code_point = 0xC11B; break; // HANGUL SYLLABLE SIOS YAE HIEUH
    case 0x98F7: code_point = 0xC121; break; // HANGUL SYLLABLE SIOS EO NIEUNCIEUC
    case 0x98F8: code_point = 0xC122; break; // HANGUL SYLLABLE SIOS EO NIEUNHIEUH
    case 0x98F9: code_point = 0xC125; break; // HANGUL SYLLABLE SIOS EO RIEULKIYEOK
    case 0x98FA: code_point = 0xC128; break; // HANGUL SYLLABLE SIOS EO RIEULSIOS
    case 0x98FB: code_point = 0xC129; break; // HANGUL SYLLABLE SIOS EO RIEULTHIEUTH
    case 0x98FC: code_point = 0xC12A; break; // HANGUL SYLLABLE SIOS EO RIEULPHIEUPH
    case 0x98FD: code_point = 0xC12B; break; // HANGUL SYLLABLE SIOS EO RIEULHIEUH
    case 0x98FE: code_point = 0xC12E; break; // HANGUL SYLLABLE SIOS EO PIEUPSIOS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x99(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9941: code_point = 0xC132; break; // HANGUL SYLLABLE SIOS EO CIEUC
    case 0x9942: code_point = 0xC133; break; // HANGUL SYLLABLE SIOS EO CHIEUCH
    case 0x9943: code_point = 0xC134; break; // HANGUL SYLLABLE SIOS EO KHIEUKH
    case 0x9944: code_point = 0xC135; break; // HANGUL SYLLABLE SIOS EO THIEUTH
    case 0x9945: code_point = 0xC137; break; // HANGUL SYLLABLE SIOS EO HIEUH
    case 0x9946: code_point = 0xC13A; break; // HANGUL SYLLABLE SIOS E SSANGKIYEOK
    case 0x9947: code_point = 0xC13B; break; // HANGUL SYLLABLE SIOS E KIYEOKSIOS
    case 0x9948: code_point = 0xC13D; break; // HANGUL SYLLABLE SIOS E NIEUNCIEUC
    case 0x9949: code_point = 0xC13E; break; // HANGUL SYLLABLE SIOS E NIEUNHIEUH
    case 0x994A: code_point = 0xC13F; break; // HANGUL SYLLABLE SIOS E TIKEUT
    case 0x994B: code_point = 0xC141; break; // HANGUL SYLLABLE SIOS E RIEULKIYEOK
    case 0x994C: code_point = 0xC142; break; // HANGUL SYLLABLE SIOS E RIEULMIEUM
    case 0x994D: code_point = 0xC143; break; // HANGUL SYLLABLE SIOS E RIEULPIEUP
    case 0x994E: code_point = 0xC144; break; // HANGUL SYLLABLE SIOS E RIEULSIOS
    case 0x994F: code_point = 0xC145; break; // HANGUL SYLLABLE SIOS E RIEULTHIEUTH
    case 0x9950: code_point = 0xC146; break; // HANGUL SYLLABLE SIOS E RIEULPHIEUPH
    case 0x9951: code_point = 0xC147; break; // HANGUL SYLLABLE SIOS E RIEULHIEUH
    case 0x9952: code_point = 0xC14A; break; // HANGUL SYLLABLE SIOS E PIEUPSIOS
    case 0x9953: code_point = 0xC14E; break; // HANGUL SYLLABLE SIOS E CIEUC
    case 0x9954: code_point = 0xC14F; break; // HANGUL SYLLABLE SIOS E CHIEUCH
    case 0x9955: code_point = 0xC150; break; // HANGUL SYLLABLE SIOS E KHIEUKH
    case 0x9956: code_point = 0xC151; break; // HANGUL SYLLABLE SIOS E THIEUTH
    case 0x9957: code_point = 0xC152; break; // HANGUL SYLLABLE SIOS E PHIEUPH
    case 0x9958: code_point = 0xC153; break; // HANGUL SYLLABLE SIOS E HIEUH
    case 0x9959: code_point = 0xC156; break; // HANGUL SYLLABLE SIOS YEO SSANGKIYEOK
    case 0x995A: code_point = 0xC157; break; // HANGUL SYLLABLE SIOS YEO KIYEOKSIOS
    case 0x9961: code_point = 0xC159; break; // HANGUL SYLLABLE SIOS YEO NIEUNCIEUC
    case 0x9962: code_point = 0xC15A; break; // HANGUL SYLLABLE SIOS YEO NIEUNHIEUH
    case 0x9963: code_point = 0xC15B; break; // HANGUL SYLLABLE SIOS YEO TIKEUT
    case 0x9964: code_point = 0xC15D; break; // HANGUL SYLLABLE SIOS YEO RIEULKIYEOK
    case 0x9965: code_point = 0xC15E; break; // HANGUL SYLLABLE SIOS YEO RIEULMIEUM
    case 0x9966: code_point = 0xC15F; break; // HANGUL SYLLABLE SIOS YEO RIEULPIEUP
    case 0x9967: code_point = 0xC160; break; // HANGUL SYLLABLE SIOS YEO RIEULSIOS
    case 0x9968: code_point = 0xC161; break; // HANGUL SYLLABLE SIOS YEO RIEULTHIEUTH
    case 0x9969: code_point = 0xC162; break; // HANGUL SYLLABLE SIOS YEO RIEULPHIEUPH
    case 0x996A: code_point = 0xC163; break; // HANGUL SYLLABLE SIOS YEO RIEULHIEUH
    case 0x996B: code_point = 0xC166; break; // HANGUL SYLLABLE SIOS YEO PIEUPSIOS
    case 0x996C: code_point = 0xC16A; break; // HANGUL SYLLABLE SIOS YEO CIEUC
    case 0x996D: code_point = 0xC16B; break; // HANGUL SYLLABLE SIOS YEO CHIEUCH
    case 0x996E: code_point = 0xC16C; break; // HANGUL SYLLABLE SIOS YEO KHIEUKH
    case 0x996F: code_point = 0xC16D; break; // HANGUL SYLLABLE SIOS YEO THIEUTH
    case 0x9970: code_point = 0xC16E; break; // HANGUL SYLLABLE SIOS YEO PHIEUPH
    case 0x9971: code_point = 0xC16F; break; // HANGUL SYLLABLE SIOS YEO HIEUH
    case 0x9972: code_point = 0xC171; break; // HANGUL SYLLABLE SIOS YE KIYEOK
    case 0x9973: code_point = 0xC172; break; // HANGUL SYLLABLE SIOS YE SSANGKIYEOK
    case 0x9974: code_point = 0xC173; break; // HANGUL SYLLABLE SIOS YE KIYEOKSIOS
    case 0x9975: code_point = 0xC175; break; // HANGUL SYLLABLE SIOS YE NIEUNCIEUC
    case 0x9976: code_point = 0xC176; break; // HANGUL SYLLABLE SIOS YE NIEUNHIEUH
    case 0x9977: code_point = 0xC177; break; // HANGUL SYLLABLE SIOS YE TIKEUT
    case 0x9978: code_point = 0xC179; break; // HANGUL SYLLABLE SIOS YE RIEULKIYEOK
    case 0x9979: code_point = 0xC17A; break; // HANGUL SYLLABLE SIOS YE RIEULMIEUM
    case 0x997A: code_point = 0xC17B; break; // HANGUL SYLLABLE SIOS YE RIEULPIEUP
    case 0x9981: code_point = 0xC17C; break; // HANGUL SYLLABLE SIOS YE RIEULSIOS
    case 0x9982: code_point = 0xC17D; break; // HANGUL SYLLABLE SIOS YE RIEULTHIEUTH
    case 0x9983: code_point = 0xC17E; break; // HANGUL SYLLABLE SIOS YE RIEULPHIEUPH
    case 0x9984: code_point = 0xC17F; break; // HANGUL SYLLABLE SIOS YE RIEULHIEUH
    case 0x9985: code_point = 0xC180; break; // HANGUL SYLLABLE SIOS YE MIEUM
    case 0x9986: code_point = 0xC181; break; // HANGUL SYLLABLE SIOS YE PIEUP
    case 0x9987: code_point = 0xC182; break; // HANGUL SYLLABLE SIOS YE PIEUPSIOS
    case 0x9988: code_point = 0xC183; break; // HANGUL SYLLABLE SIOS YE SIOS
    case 0x9989: code_point = 0xC184; break; // HANGUL SYLLABLE SIOS YE SSANGSIOS
    case 0x998A: code_point = 0xC186; break; // HANGUL SYLLABLE SIOS YE CIEUC
    case 0x998B: code_point = 0xC187; break; // HANGUL SYLLABLE SIOS YE CHIEUCH
    case 0x998C: code_point = 0xC188; break; // HANGUL SYLLABLE SIOS YE KHIEUKH
    case 0x998D: code_point = 0xC189; break; // HANGUL SYLLABLE SIOS YE THIEUTH
    case 0x998E: code_point = 0xC18A; break; // HANGUL SYLLABLE SIOS YE PHIEUPH
    case 0x998F: code_point = 0xC18B; break; // HANGUL SYLLABLE SIOS YE HIEUH
    case 0x9990: code_point = 0xC18F; break; // HANGUL SYLLABLE SIOS O KIYEOKSIOS
    case 0x9991: code_point = 0xC191; break; // HANGUL SYLLABLE SIOS O NIEUNCIEUC
    case 0x9992: code_point = 0xC192; break; // HANGUL SYLLABLE SIOS O NIEUNHIEUH
    case 0x9993: code_point = 0xC193; break; // HANGUL SYLLABLE SIOS O TIKEUT
    case 0x9994: code_point = 0xC195; break; // HANGUL SYLLABLE SIOS O RIEULKIYEOK
    case 0x9995: code_point = 0xC197; break; // HANGUL SYLLABLE SIOS O RIEULPIEUP
    case 0x9996: code_point = 0xC198; break; // HANGUL SYLLABLE SIOS O RIEULSIOS
    case 0x9997: code_point = 0xC199; break; // HANGUL SYLLABLE SIOS O RIEULTHIEUTH
    case 0x9998: code_point = 0xC19A; break; // HANGUL SYLLABLE SIOS O RIEULPHIEUPH
    case 0x9999: code_point = 0xC19B; break; // HANGUL SYLLABLE SIOS O RIEULHIEUH
    case 0x999A: code_point = 0xC19E; break; // HANGUL SYLLABLE SIOS O PIEUPSIOS
    case 0x999B: code_point = 0xC1A0; break; // HANGUL SYLLABLE SIOS O SSANGSIOS
    case 0x999C: code_point = 0xC1A2; break; // HANGUL SYLLABLE SIOS O CIEUC
    case 0x999D: code_point = 0xC1A3; break; // HANGUL SYLLABLE SIOS O CHIEUCH
    case 0x999E: code_point = 0xC1A4; break; // HANGUL SYLLABLE SIOS O KHIEUKH
    case 0x999F: code_point = 0xC1A6; break; // HANGUL SYLLABLE SIOS O PHIEUPH
    case 0x99A0: code_point = 0xC1A7; break; // HANGUL SYLLABLE SIOS O HIEUH
    case 0x99A1: code_point = 0xC1AA; break; // HANGUL SYLLABLE SIOS WA SSANGKIYEOK
    case 0x99A2: code_point = 0xC1AB; break; // HANGUL SYLLABLE SIOS WA KIYEOKSIOS
    case 0x99A3: code_point = 0xC1AD; break; // HANGUL SYLLABLE SIOS WA NIEUNCIEUC
    case 0x99A4: code_point = 0xC1AE; break; // HANGUL SYLLABLE SIOS WA NIEUNHIEUH
    case 0x99A5: code_point = 0xC1AF; break; // HANGUL SYLLABLE SIOS WA TIKEUT
    case 0x99A6: code_point = 0xC1B1; break; // HANGUL SYLLABLE SIOS WA RIEULKIYEOK
    case 0x99A7: code_point = 0xC1B2; break; // HANGUL SYLLABLE SIOS WA RIEULMIEUM
    case 0x99A8: code_point = 0xC1B3; break; // HANGUL SYLLABLE SIOS WA RIEULPIEUP
    case 0x99A9: code_point = 0xC1B4; break; // HANGUL SYLLABLE SIOS WA RIEULSIOS
    case 0x99AA: code_point = 0xC1B5; break; // HANGUL SYLLABLE SIOS WA RIEULTHIEUTH
    case 0x99AB: code_point = 0xC1B6; break; // HANGUL SYLLABLE SIOS WA RIEULPHIEUPH
    case 0x99AC: code_point = 0xC1B7; break; // HANGUL SYLLABLE SIOS WA RIEULHIEUH
    case 0x99AD: code_point = 0xC1B8; break; // HANGUL SYLLABLE SIOS WA MIEUM
    case 0x99AE: code_point = 0xC1B9; break; // HANGUL SYLLABLE SIOS WA PIEUP
    case 0x99AF: code_point = 0xC1BA; break; // HANGUL SYLLABLE SIOS WA PIEUPSIOS
    case 0x99B0: code_point = 0xC1BB; break; // HANGUL SYLLABLE SIOS WA SIOS
    case 0x99B1: code_point = 0xC1BC; break; // HANGUL SYLLABLE SIOS WA SSANGSIOS
    case 0x99B2: code_point = 0xC1BE; break; // HANGUL SYLLABLE SIOS WA CIEUC
    case 0x99B3: code_point = 0xC1BF; break; // HANGUL SYLLABLE SIOS WA CHIEUCH
    case 0x99B4: code_point = 0xC1C0; break; // HANGUL SYLLABLE SIOS WA KHIEUKH
    case 0x99B5: code_point = 0xC1C1; break; // HANGUL SYLLABLE SIOS WA THIEUTH
    case 0x99B6: code_point = 0xC1C2; break; // HANGUL SYLLABLE SIOS WA PHIEUPH
    case 0x99B7: code_point = 0xC1C3; break; // HANGUL SYLLABLE SIOS WA HIEUH
    case 0x99B8: code_point = 0xC1C5; break; // HANGUL SYLLABLE SIOS WAE KIYEOK
    case 0x99B9: code_point = 0xC1C6; break; // HANGUL SYLLABLE SIOS WAE SSANGKIYEOK
    case 0x99BA: code_point = 0xC1C7; break; // HANGUL SYLLABLE SIOS WAE KIYEOKSIOS
    case 0x99BB: code_point = 0xC1C9; break; // HANGUL SYLLABLE SIOS WAE NIEUNCIEUC
    case 0x99BC: code_point = 0xC1CA; break; // HANGUL SYLLABLE SIOS WAE NIEUNHIEUH
    case 0x99BD: code_point = 0xC1CB; break; // HANGUL SYLLABLE SIOS WAE TIKEUT
    case 0x99BE: code_point = 0xC1CD; break; // HANGUL SYLLABLE SIOS WAE RIEULKIYEOK
    case 0x99BF: code_point = 0xC1CE; break; // HANGUL SYLLABLE SIOS WAE RIEULMIEUM
    case 0x99C0: code_point = 0xC1CF; break; // HANGUL SYLLABLE SIOS WAE RIEULPIEUP
    case 0x99C1: code_point = 0xC1D0; break; // HANGUL SYLLABLE SIOS WAE RIEULSIOS
    case 0x99C2: code_point = 0xC1D1; break; // HANGUL SYLLABLE SIOS WAE RIEULTHIEUTH
    case 0x99C3: code_point = 0xC1D2; break; // HANGUL SYLLABLE SIOS WAE RIEULPHIEUPH
    case 0x99C4: code_point = 0xC1D3; break; // HANGUL SYLLABLE SIOS WAE RIEULHIEUH
    case 0x99C5: code_point = 0xC1D5; break; // HANGUL SYLLABLE SIOS WAE PIEUP
    case 0x99C6: code_point = 0xC1D6; break; // HANGUL SYLLABLE SIOS WAE PIEUPSIOS
    case 0x99C7: code_point = 0xC1D9; break; // HANGUL SYLLABLE SIOS WAE IEUNG
    case 0x99C8: code_point = 0xC1DA; break; // HANGUL SYLLABLE SIOS WAE CIEUC
    case 0x99C9: code_point = 0xC1DB; break; // HANGUL SYLLABLE SIOS WAE CHIEUCH
    case 0x99CA: code_point = 0xC1DC; break; // HANGUL SYLLABLE SIOS WAE KHIEUKH
    case 0x99CB: code_point = 0xC1DD; break; // HANGUL SYLLABLE SIOS WAE THIEUTH
    case 0x99CC: code_point = 0xC1DE; break; // HANGUL SYLLABLE SIOS WAE PHIEUPH
    case 0x99CD: code_point = 0xC1DF; break; // HANGUL SYLLABLE SIOS WAE HIEUH
    case 0x99CE: code_point = 0xC1E1; break; // HANGUL SYLLABLE SIOS OE KIYEOK
    case 0x99CF: code_point = 0xC1E2; break; // HANGUL SYLLABLE SIOS OE SSANGKIYEOK
    case 0x99D0: code_point = 0xC1E3; break; // HANGUL SYLLABLE SIOS OE KIYEOKSIOS
    case 0x99D1: code_point = 0xC1E5; break; // HANGUL SYLLABLE SIOS OE NIEUNCIEUC
    case 0x99D2: code_point = 0xC1E6; break; // HANGUL SYLLABLE SIOS OE NIEUNHIEUH
    case 0x99D3: code_point = 0xC1E7; break; // HANGUL SYLLABLE SIOS OE TIKEUT
    case 0x99D4: code_point = 0xC1E9; break; // HANGUL SYLLABLE SIOS OE RIEULKIYEOK
    case 0x99D5: code_point = 0xC1EA; break; // HANGUL SYLLABLE SIOS OE RIEULMIEUM
    case 0x99D6: code_point = 0xC1EB; break; // HANGUL SYLLABLE SIOS OE RIEULPIEUP
    case 0x99D7: code_point = 0xC1EC; break; // HANGUL SYLLABLE SIOS OE RIEULSIOS
    case 0x99D8: code_point = 0xC1ED; break; // HANGUL SYLLABLE SIOS OE RIEULTHIEUTH
    case 0x99D9: code_point = 0xC1EE; break; // HANGUL SYLLABLE SIOS OE RIEULPHIEUPH
    case 0x99DA: code_point = 0xC1EF; break; // HANGUL SYLLABLE SIOS OE RIEULHIEUH
    case 0x99DB: code_point = 0xC1F2; break; // HANGUL SYLLABLE SIOS OE PIEUPSIOS
    case 0x99DC: code_point = 0xC1F4; break; // HANGUL SYLLABLE SIOS OE SSANGSIOS
    case 0x99DD: code_point = 0xC1F5; break; // HANGUL SYLLABLE SIOS OE IEUNG
    case 0x99DE: code_point = 0xC1F6; break; // HANGUL SYLLABLE SIOS OE CIEUC
    case 0x99DF: code_point = 0xC1F7; break; // HANGUL SYLLABLE SIOS OE CHIEUCH
    case 0x99E0: code_point = 0xC1F8; break; // HANGUL SYLLABLE SIOS OE KHIEUKH
    case 0x99E1: code_point = 0xC1F9; break; // HANGUL SYLLABLE SIOS OE THIEUTH
    case 0x99E2: code_point = 0xC1FA; break; // HANGUL SYLLABLE SIOS OE PHIEUPH
    case 0x99E3: code_point = 0xC1FB; break; // HANGUL SYLLABLE SIOS OE HIEUH
    case 0x99E4: code_point = 0xC1FE; break; // HANGUL SYLLABLE SIOS YO SSANGKIYEOK
    case 0x99E5: code_point = 0xC1FF; break; // HANGUL SYLLABLE SIOS YO KIYEOKSIOS
    case 0x99E6: code_point = 0xC201; break; // HANGUL SYLLABLE SIOS YO NIEUNCIEUC
    case 0x99E7: code_point = 0xC202; break; // HANGUL SYLLABLE SIOS YO NIEUNHIEUH
    case 0x99E8: code_point = 0xC203; break; // HANGUL SYLLABLE SIOS YO TIKEUT
    case 0x99E9: code_point = 0xC205; break; // HANGUL SYLLABLE SIOS YO RIEULKIYEOK
    case 0x99EA: code_point = 0xC206; break; // HANGUL SYLLABLE SIOS YO RIEULMIEUM
    case 0x99EB: code_point = 0xC207; break; // HANGUL SYLLABLE SIOS YO RIEULPIEUP
    case 0x99EC: code_point = 0xC208; break; // HANGUL SYLLABLE SIOS YO RIEULSIOS
    case 0x99ED: code_point = 0xC209; break; // HANGUL SYLLABLE SIOS YO RIEULTHIEUTH
    case 0x99EE: code_point = 0xC20A; break; // HANGUL SYLLABLE SIOS YO RIEULPHIEUPH
    case 0x99EF: code_point = 0xC20B; break; // HANGUL SYLLABLE SIOS YO RIEULHIEUH
    case 0x99F0: code_point = 0xC20E; break; // HANGUL SYLLABLE SIOS YO PIEUPSIOS
    case 0x99F1: code_point = 0xC210; break; // HANGUL SYLLABLE SIOS YO SSANGSIOS
    case 0x99F2: code_point = 0xC212; break; // HANGUL SYLLABLE SIOS YO CIEUC
    case 0x99F3: code_point = 0xC213; break; // HANGUL SYLLABLE SIOS YO CHIEUCH
    case 0x99F4: code_point = 0xC214; break; // HANGUL SYLLABLE SIOS YO KHIEUKH
    case 0x99F5: code_point = 0xC215; break; // HANGUL SYLLABLE SIOS YO THIEUTH
    case 0x99F6: code_point = 0xC216; break; // HANGUL SYLLABLE SIOS YO PHIEUPH
    case 0x99F7: code_point = 0xC217; break; // HANGUL SYLLABLE SIOS YO HIEUH
    case 0x99F8: code_point = 0xC21A; break; // HANGUL SYLLABLE SIOS U SSANGKIYEOK
    case 0x99F9: code_point = 0xC21B; break; // HANGUL SYLLABLE SIOS U KIYEOKSIOS
    case 0x99FA: code_point = 0xC21D; break; // HANGUL SYLLABLE SIOS U NIEUNCIEUC
    case 0x99FB: code_point = 0xC21E; break; // HANGUL SYLLABLE SIOS U NIEUNHIEUH
    case 0x99FC: code_point = 0xC221; break; // HANGUL SYLLABLE SIOS U RIEULKIYEOK
    case 0x99FD: code_point = 0xC222; break; // HANGUL SYLLABLE SIOS U RIEULMIEUM
    case 0x99FE: code_point = 0xC223; break; // HANGUL SYLLABLE SIOS U RIEULPIEUP
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x9A(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9A41: code_point = 0xC224; break; // HANGUL SYLLABLE SIOS U RIEULSIOS
    case 0x9A42: code_point = 0xC225; break; // HANGUL SYLLABLE SIOS U RIEULTHIEUTH
    case 0x9A43: code_point = 0xC226; break; // HANGUL SYLLABLE SIOS U RIEULPHIEUPH
    case 0x9A44: code_point = 0xC227; break; // HANGUL SYLLABLE SIOS U RIEULHIEUH
    case 0x9A45: code_point = 0xC22A; break; // HANGUL SYLLABLE SIOS U PIEUPSIOS
    case 0x9A46: code_point = 0xC22C; break; // HANGUL SYLLABLE SIOS U SSANGSIOS
    case 0x9A47: code_point = 0xC22E; break; // HANGUL SYLLABLE SIOS U CIEUC
    case 0x9A48: code_point = 0xC230; break; // HANGUL SYLLABLE SIOS U KHIEUKH
    case 0x9A49: code_point = 0xC233; break; // HANGUL SYLLABLE SIOS U HIEUH
    case 0x9A4A: code_point = 0xC235; break; // HANGUL SYLLABLE SIOS WEO KIYEOK
    case 0x9A4B: code_point = 0xC236; break; // HANGUL SYLLABLE SIOS WEO SSANGKIYEOK
    case 0x9A4C: code_point = 0xC237; break; // HANGUL SYLLABLE SIOS WEO KIYEOKSIOS
    case 0x9A4D: code_point = 0xC238; break; // HANGUL SYLLABLE SIOS WEO NIEUN
    case 0x9A4E: code_point = 0xC239; break; // HANGUL SYLLABLE SIOS WEO NIEUNCIEUC
    case 0x9A4F: code_point = 0xC23A; break; // HANGUL SYLLABLE SIOS WEO NIEUNHIEUH
    case 0x9A50: code_point = 0xC23B; break; // HANGUL SYLLABLE SIOS WEO TIKEUT
    case 0x9A51: code_point = 0xC23C; break; // HANGUL SYLLABLE SIOS WEO RIEUL
    case 0x9A52: code_point = 0xC23D; break; // HANGUL SYLLABLE SIOS WEO RIEULKIYEOK
    case 0x9A53: code_point = 0xC23E; break; // HANGUL SYLLABLE SIOS WEO RIEULMIEUM
    case 0x9A54: code_point = 0xC23F; break; // HANGUL SYLLABLE SIOS WEO RIEULPIEUP
    case 0x9A55: code_point = 0xC240; break; // HANGUL SYLLABLE SIOS WEO RIEULSIOS
    case 0x9A56: code_point = 0xC241; break; // HANGUL SYLLABLE SIOS WEO RIEULTHIEUTH
    case 0x9A57: code_point = 0xC242; break; // HANGUL SYLLABLE SIOS WEO RIEULPHIEUPH
    case 0x9A58: code_point = 0xC243; break; // HANGUL SYLLABLE SIOS WEO RIEULHIEUH
    case 0x9A59: code_point = 0xC244; break; // HANGUL SYLLABLE SIOS WEO MIEUM
    case 0x9A5A: code_point = 0xC245; break; // HANGUL SYLLABLE SIOS WEO PIEUP
    case 0x9A61: code_point = 0xC246; break; // HANGUL SYLLABLE SIOS WEO PIEUPSIOS
    case 0x9A62: code_point = 0xC247; break; // HANGUL SYLLABLE SIOS WEO SIOS
    case 0x9A63: code_point = 0xC249; break; // HANGUL SYLLABLE SIOS WEO IEUNG
    case 0x9A64: code_point = 0xC24A; break; // HANGUL SYLLABLE SIOS WEO CIEUC
    case 0x9A65: code_point = 0xC24B; break; // HANGUL SYLLABLE SIOS WEO CHIEUCH
    case 0x9A66: code_point = 0xC24C; break; // HANGUL SYLLABLE SIOS WEO KHIEUKH
    case 0x9A67: code_point = 0xC24D; break; // HANGUL SYLLABLE SIOS WEO THIEUTH
    case 0x9A68: code_point = 0xC24E; break; // HANGUL SYLLABLE SIOS WEO PHIEUPH
    case 0x9A69: code_point = 0xC24F; break; // HANGUL SYLLABLE SIOS WEO HIEUH
    case 0x9A6A: code_point = 0xC252; break; // HANGUL SYLLABLE SIOS WE SSANGKIYEOK
    case 0x9A6B: code_point = 0xC253; break; // HANGUL SYLLABLE SIOS WE KIYEOKSIOS
    case 0x9A6C: code_point = 0xC255; break; // HANGUL SYLLABLE SIOS WE NIEUNCIEUC
    case 0x9A6D: code_point = 0xC256; break; // HANGUL SYLLABLE SIOS WE NIEUNHIEUH
    case 0x9A6E: code_point = 0xC257; break; // HANGUL SYLLABLE SIOS WE TIKEUT
    case 0x9A6F: code_point = 0xC259; break; // HANGUL SYLLABLE SIOS WE RIEULKIYEOK
    case 0x9A70: code_point = 0xC25A; break; // HANGUL SYLLABLE SIOS WE RIEULMIEUM
    case 0x9A71: code_point = 0xC25B; break; // HANGUL SYLLABLE SIOS WE RIEULPIEUP
    case 0x9A72: code_point = 0xC25C; break; // HANGUL SYLLABLE SIOS WE RIEULSIOS
    case 0x9A73: code_point = 0xC25D; break; // HANGUL SYLLABLE SIOS WE RIEULTHIEUTH
    case 0x9A74: code_point = 0xC25E; break; // HANGUL SYLLABLE SIOS WE RIEULPHIEUPH
    case 0x9A75: code_point = 0xC25F; break; // HANGUL SYLLABLE SIOS WE RIEULHIEUH
    case 0x9A76: code_point = 0xC261; break; // HANGUL SYLLABLE SIOS WE PIEUP
    case 0x9A77: code_point = 0xC262; break; // HANGUL SYLLABLE SIOS WE PIEUPSIOS
    case 0x9A78: code_point = 0xC263; break; // HANGUL SYLLABLE SIOS WE SIOS
    case 0x9A79: code_point = 0xC264; break; // HANGUL SYLLABLE SIOS WE SSANGSIOS
    case 0x9A7A: code_point = 0xC266; break; // HANGUL SYLLABLE SIOS WE CIEUC
    case 0x9A81: code_point = 0xC267; break; // HANGUL SYLLABLE SIOS WE CHIEUCH
    case 0x9A82: code_point = 0xC268; break; // HANGUL SYLLABLE SIOS WE KHIEUKH
    case 0x9A83: code_point = 0xC269; break; // HANGUL SYLLABLE SIOS WE THIEUTH
    case 0x9A84: code_point = 0xC26A; break; // HANGUL SYLLABLE SIOS WE PHIEUPH
    case 0x9A85: code_point = 0xC26B; break; // HANGUL SYLLABLE SIOS WE HIEUH
    case 0x9A86: code_point = 0xC26E; break; // HANGUL SYLLABLE SIOS WI SSANGKIYEOK
    case 0x9A87: code_point = 0xC26F; break; // HANGUL SYLLABLE SIOS WI KIYEOKSIOS
    case 0x9A88: code_point = 0xC271; break; // HANGUL SYLLABLE SIOS WI NIEUNCIEUC
    case 0x9A89: code_point = 0xC272; break; // HANGUL SYLLABLE SIOS WI NIEUNHIEUH
    case 0x9A8A: code_point = 0xC273; break; // HANGUL SYLLABLE SIOS WI TIKEUT
    case 0x9A8B: code_point = 0xC275; break; // HANGUL SYLLABLE SIOS WI RIEULKIYEOK
    case 0x9A8C: code_point = 0xC276; break; // HANGUL SYLLABLE SIOS WI RIEULMIEUM
    case 0x9A8D: code_point = 0xC277; break; // HANGUL SYLLABLE SIOS WI RIEULPIEUP
    case 0x9A8E: code_point = 0xC278; break; // HANGUL SYLLABLE SIOS WI RIEULSIOS
    case 0x9A8F: code_point = 0xC279; break; // HANGUL SYLLABLE SIOS WI RIEULTHIEUTH
    case 0x9A90: code_point = 0xC27A; break; // HANGUL SYLLABLE SIOS WI RIEULPHIEUPH
    case 0x9A91: code_point = 0xC27B; break; // HANGUL SYLLABLE SIOS WI RIEULHIEUH
    case 0x9A92: code_point = 0xC27E; break; // HANGUL SYLLABLE SIOS WI PIEUPSIOS
    case 0x9A93: code_point = 0xC280; break; // HANGUL SYLLABLE SIOS WI SSANGSIOS
    case 0x9A94: code_point = 0xC282; break; // HANGUL SYLLABLE SIOS WI CIEUC
    case 0x9A95: code_point = 0xC283; break; // HANGUL SYLLABLE SIOS WI CHIEUCH
    case 0x9A96: code_point = 0xC284; break; // HANGUL SYLLABLE SIOS WI KHIEUKH
    case 0x9A97: code_point = 0xC285; break; // HANGUL SYLLABLE SIOS WI THIEUTH
    case 0x9A98: code_point = 0xC286; break; // HANGUL SYLLABLE SIOS WI PHIEUPH
    case 0x9A99: code_point = 0xC287; break; // HANGUL SYLLABLE SIOS WI HIEUH
    case 0x9A9A: code_point = 0xC28A; break; // HANGUL SYLLABLE SIOS YU SSANGKIYEOK
    case 0x9A9B: code_point = 0xC28B; break; // HANGUL SYLLABLE SIOS YU KIYEOKSIOS
    case 0x9A9C: code_point = 0xC28C; break; // HANGUL SYLLABLE SIOS YU NIEUN
    case 0x9A9D: code_point = 0xC28D; break; // HANGUL SYLLABLE SIOS YU NIEUNCIEUC
    case 0x9A9E: code_point = 0xC28E; break; // HANGUL SYLLABLE SIOS YU NIEUNHIEUH
    case 0x9A9F: code_point = 0xC28F; break; // HANGUL SYLLABLE SIOS YU TIKEUT
    case 0x9AA0: code_point = 0xC291; break; // HANGUL SYLLABLE SIOS YU RIEULKIYEOK
    case 0x9AA1: code_point = 0xC292; break; // HANGUL SYLLABLE SIOS YU RIEULMIEUM
    case 0x9AA2: code_point = 0xC293; break; // HANGUL SYLLABLE SIOS YU RIEULPIEUP
    case 0x9AA3: code_point = 0xC294; break; // HANGUL SYLLABLE SIOS YU RIEULSIOS
    case 0x9AA4: code_point = 0xC295; break; // HANGUL SYLLABLE SIOS YU RIEULTHIEUTH
    case 0x9AA5: code_point = 0xC296; break; // HANGUL SYLLABLE SIOS YU RIEULPHIEUPH
    case 0x9AA6: code_point = 0xC297; break; // HANGUL SYLLABLE SIOS YU RIEULHIEUH
    case 0x9AA7: code_point = 0xC299; break; // HANGUL SYLLABLE SIOS YU PIEUP
    case 0x9AA8: code_point = 0xC29A; break; // HANGUL SYLLABLE SIOS YU PIEUPSIOS
    case 0x9AA9: code_point = 0xC29C; break; // HANGUL SYLLABLE SIOS YU SSANGSIOS
    case 0x9AAA: code_point = 0xC29E; break; // HANGUL SYLLABLE SIOS YU CIEUC
    case 0x9AAB: code_point = 0xC29F; break; // HANGUL SYLLABLE SIOS YU CHIEUCH
    case 0x9AAC: code_point = 0xC2A0; break; // HANGUL SYLLABLE SIOS YU KHIEUKH
    case 0x9AAD: code_point = 0xC2A1; break; // HANGUL SYLLABLE SIOS YU THIEUTH
    case 0x9AAE: code_point = 0xC2A2; break; // HANGUL SYLLABLE SIOS YU PHIEUPH
    case 0x9AAF: code_point = 0xC2A3; break; // HANGUL SYLLABLE SIOS YU HIEUH
    case 0x9AB0: code_point = 0xC2A6; break; // HANGUL SYLLABLE SIOS EU SSANGKIYEOK
    case 0x9AB1: code_point = 0xC2A7; break; // HANGUL SYLLABLE SIOS EU KIYEOKSIOS
    case 0x9AB2: code_point = 0xC2A9; break; // HANGUL SYLLABLE SIOS EU NIEUNCIEUC
    case 0x9AB3: code_point = 0xC2AA; break; // HANGUL SYLLABLE SIOS EU NIEUNHIEUH
    case 0x9AB4: code_point = 0xC2AB; break; // HANGUL SYLLABLE SIOS EU TIKEUT
    case 0x9AB5: code_point = 0xC2AE; break; // HANGUL SYLLABLE SIOS EU RIEULMIEUM
    case 0x9AB6: code_point = 0xC2AF; break; // HANGUL SYLLABLE SIOS EU RIEULPIEUP
    case 0x9AB7: code_point = 0xC2B0; break; // HANGUL SYLLABLE SIOS EU RIEULSIOS
    case 0x9AB8: code_point = 0xC2B1; break; // HANGUL SYLLABLE SIOS EU RIEULTHIEUTH
    case 0x9AB9: code_point = 0xC2B2; break; // HANGUL SYLLABLE SIOS EU RIEULPHIEUPH
    case 0x9ABA: code_point = 0xC2B3; break; // HANGUL SYLLABLE SIOS EU RIEULHIEUH
    case 0x9ABB: code_point = 0xC2B6; break; // HANGUL SYLLABLE SIOS EU PIEUPSIOS
    case 0x9ABC: code_point = 0xC2B8; break; // HANGUL SYLLABLE SIOS EU SSANGSIOS
    case 0x9ABD: code_point = 0xC2BA; break; // HANGUL SYLLABLE SIOS EU CIEUC
    case 0x9ABE: code_point = 0xC2BB; break; // HANGUL SYLLABLE SIOS EU CHIEUCH
    case 0x9ABF: code_point = 0xC2BC; break; // HANGUL SYLLABLE SIOS EU KHIEUKH
    case 0x9AC0: code_point = 0xC2BD; break; // HANGUL SYLLABLE SIOS EU THIEUTH
    case 0x9AC1: code_point = 0xC2BE; break; // HANGUL SYLLABLE SIOS EU PHIEUPH
    case 0x9AC2: code_point = 0xC2BF; break; // HANGUL SYLLABLE SIOS EU HIEUH
    case 0x9AC3: code_point = 0xC2C0; break; // HANGUL SYLLABLE SIOS YI
    case 0x9AC4: code_point = 0xC2C1; break; // HANGUL SYLLABLE SIOS YI KIYEOK
    case 0x9AC5: code_point = 0xC2C2; break; // HANGUL SYLLABLE SIOS YI SSANGKIYEOK
    case 0x9AC6: code_point = 0xC2C3; break; // HANGUL SYLLABLE SIOS YI KIYEOKSIOS
    case 0x9AC7: code_point = 0xC2C4; break; // HANGUL SYLLABLE SIOS YI NIEUN
    case 0x9AC8: code_point = 0xC2C5; break; // HANGUL SYLLABLE SIOS YI NIEUNCIEUC
    case 0x9AC9: code_point = 0xC2C6; break; // HANGUL SYLLABLE SIOS YI NIEUNHIEUH
    case 0x9ACA: code_point = 0xC2C7; break; // HANGUL SYLLABLE SIOS YI TIKEUT
    case 0x9ACB: code_point = 0xC2C8; break; // HANGUL SYLLABLE SIOS YI RIEUL
    case 0x9ACC: code_point = 0xC2C9; break; // HANGUL SYLLABLE SIOS YI RIEULKIYEOK
    case 0x9ACD: code_point = 0xC2CA; break; // HANGUL SYLLABLE SIOS YI RIEULMIEUM
    case 0x9ACE: code_point = 0xC2CB; break; // HANGUL SYLLABLE SIOS YI RIEULPIEUP
    case 0x9ACF: code_point = 0xC2CC; break; // HANGUL SYLLABLE SIOS YI RIEULSIOS
    case 0x9AD0: code_point = 0xC2CD; break; // HANGUL SYLLABLE SIOS YI RIEULTHIEUTH
    case 0x9AD1: code_point = 0xC2CE; break; // HANGUL SYLLABLE SIOS YI RIEULPHIEUPH
    case 0x9AD2: code_point = 0xC2CF; break; // HANGUL SYLLABLE SIOS YI RIEULHIEUH
    case 0x9AD3: code_point = 0xC2D0; break; // HANGUL SYLLABLE SIOS YI MIEUM
    case 0x9AD4: code_point = 0xC2D1; break; // HANGUL SYLLABLE SIOS YI PIEUP
    case 0x9AD5: code_point = 0xC2D2; break; // HANGUL SYLLABLE SIOS YI PIEUPSIOS
    case 0x9AD6: code_point = 0xC2D3; break; // HANGUL SYLLABLE SIOS YI SIOS
    case 0x9AD7: code_point = 0xC2D4; break; // HANGUL SYLLABLE SIOS YI SSANGSIOS
    case 0x9AD8: code_point = 0xC2D5; break; // HANGUL SYLLABLE SIOS YI IEUNG
    case 0x9AD9: code_point = 0xC2D6; break; // HANGUL SYLLABLE SIOS YI CIEUC
    case 0x9ADA: code_point = 0xC2D7; break; // HANGUL SYLLABLE SIOS YI CHIEUCH
    case 0x9ADB: code_point = 0xC2D8; break; // HANGUL SYLLABLE SIOS YI KHIEUKH
    case 0x9ADC: code_point = 0xC2D9; break; // HANGUL SYLLABLE SIOS YI THIEUTH
    case 0x9ADD: code_point = 0xC2DA; break; // HANGUL SYLLABLE SIOS YI PHIEUPH
    case 0x9ADE: code_point = 0xC2DB; break; // HANGUL SYLLABLE SIOS YI HIEUH
    case 0x9ADF: code_point = 0xC2DE; break; // HANGUL SYLLABLE SIOS I SSANGKIYEOK
    case 0x9AE0: code_point = 0xC2DF; break; // HANGUL SYLLABLE SIOS I KIYEOKSIOS
    case 0x9AE1: code_point = 0xC2E1; break; // HANGUL SYLLABLE SIOS I NIEUNCIEUC
    case 0x9AE2: code_point = 0xC2E2; break; // HANGUL SYLLABLE SIOS I NIEUNHIEUH
    case 0x9AE3: code_point = 0xC2E5; break; // HANGUL SYLLABLE SIOS I RIEULKIYEOK
    case 0x9AE4: code_point = 0xC2E6; break; // HANGUL SYLLABLE SIOS I RIEULMIEUM
    case 0x9AE5: code_point = 0xC2E7; break; // HANGUL SYLLABLE SIOS I RIEULPIEUP
    case 0x9AE6: code_point = 0xC2E8; break; // HANGUL SYLLABLE SIOS I RIEULSIOS
    case 0x9AE7: code_point = 0xC2E9; break; // HANGUL SYLLABLE SIOS I RIEULTHIEUTH
    case 0x9AE8: code_point = 0xC2EA; break; // HANGUL SYLLABLE SIOS I RIEULPHIEUPH
    case 0x9AE9: code_point = 0xC2EE; break; // HANGUL SYLLABLE SIOS I PIEUPSIOS
    case 0x9AEA: code_point = 0xC2F0; break; // HANGUL SYLLABLE SIOS I SSANGSIOS
    case 0x9AEB: code_point = 0xC2F2; break; // HANGUL SYLLABLE SIOS I CIEUC
    case 0x9AEC: code_point = 0xC2F3; break; // HANGUL SYLLABLE SIOS I CHIEUCH
    case 0x9AED: code_point = 0xC2F4; break; // HANGUL SYLLABLE SIOS I KHIEUKH
    case 0x9AEE: code_point = 0xC2F5; break; // HANGUL SYLLABLE SIOS I THIEUTH
    case 0x9AEF: code_point = 0xC2F7; break; // HANGUL SYLLABLE SIOS I HIEUH
    case 0x9AF0: code_point = 0xC2FA; break; // HANGUL SYLLABLE SSANGSIOS A SSANGKIYEOK
    case 0x9AF1: code_point = 0xC2FD; break; // HANGUL SYLLABLE SSANGSIOS A NIEUNCIEUC
    case 0x9AF2: code_point = 0xC2FE; break; // HANGUL SYLLABLE SSANGSIOS A NIEUNHIEUH
    case 0x9AF3: code_point = 0xC2FF; break; // HANGUL SYLLABLE SSANGSIOS A TIKEUT
    case 0x9AF4: code_point = 0xC301; break; // HANGUL SYLLABLE SSANGSIOS A RIEULKIYEOK
    case 0x9AF5: code_point = 0xC302; break; // HANGUL SYLLABLE SSANGSIOS A RIEULMIEUM
    case 0x9AF6: code_point = 0xC303; break; // HANGUL SYLLABLE SSANGSIOS A RIEULPIEUP
    case 0x9AF7: code_point = 0xC304; break; // HANGUL SYLLABLE SSANGSIOS A RIEULSIOS
    case 0x9AF8: code_point = 0xC305; break; // HANGUL SYLLABLE SSANGSIOS A RIEULTHIEUTH
    case 0x9AF9: code_point = 0xC306; break; // HANGUL SYLLABLE SSANGSIOS A RIEULPHIEUPH
    case 0x9AFA: code_point = 0xC307; break; // HANGUL SYLLABLE SSANGSIOS A RIEULHIEUH
    case 0x9AFB: code_point = 0xC30A; break; // HANGUL SYLLABLE SSANGSIOS A PIEUPSIOS
    case 0x9AFC: code_point = 0xC30B; break; // HANGUL SYLLABLE SSANGSIOS A SIOS
    case 0x9AFD: code_point = 0xC30E; break; // HANGUL SYLLABLE SSANGSIOS A CIEUC
    case 0x9AFE: code_point = 0xC30F; break; // HANGUL SYLLABLE SSANGSIOS A CHIEUCH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x9B(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9B41: code_point = 0xC310; break; // HANGUL SYLLABLE SSANGSIOS A KHIEUKH
    case 0x9B42: code_point = 0xC311; break; // HANGUL SYLLABLE SSANGSIOS A THIEUTH
    case 0x9B43: code_point = 0xC312; break; // HANGUL SYLLABLE SSANGSIOS A PHIEUPH
    case 0x9B44: code_point = 0xC316; break; // HANGUL SYLLABLE SSANGSIOS AE SSANGKIYEOK
    case 0x9B45: code_point = 0xC317; break; // HANGUL SYLLABLE SSANGSIOS AE KIYEOKSIOS
    case 0x9B46: code_point = 0xC319; break; // HANGUL SYLLABLE SSANGSIOS AE NIEUNCIEUC
    case 0x9B47: code_point = 0xC31A; break; // HANGUL SYLLABLE SSANGSIOS AE NIEUNHIEUH
    case 0x9B48: code_point = 0xC31B; break; // HANGUL SYLLABLE SSANGSIOS AE TIKEUT
    case 0x9B49: code_point = 0xC31D; break; // HANGUL SYLLABLE SSANGSIOS AE RIEULKIYEOK
    case 0x9B4A: code_point = 0xC31E; break; // HANGUL SYLLABLE SSANGSIOS AE RIEULMIEUM
    case 0x9B4B: code_point = 0xC31F; break; // HANGUL SYLLABLE SSANGSIOS AE RIEULPIEUP
    case 0x9B4C: code_point = 0xC320; break; // HANGUL SYLLABLE SSANGSIOS AE RIEULSIOS
    case 0x9B4D: code_point = 0xC321; break; // HANGUL SYLLABLE SSANGSIOS AE RIEULTHIEUTH
    case 0x9B4E: code_point = 0xC322; break; // HANGUL SYLLABLE SSANGSIOS AE RIEULPHIEUPH
    case 0x9B4F: code_point = 0xC323; break; // HANGUL SYLLABLE SSANGSIOS AE RIEULHIEUH
    case 0x9B50: code_point = 0xC326; break; // HANGUL SYLLABLE SSANGSIOS AE PIEUPSIOS
    case 0x9B51: code_point = 0xC327; break; // HANGUL SYLLABLE SSANGSIOS AE SIOS
    case 0x9B52: code_point = 0xC32A; break; // HANGUL SYLLABLE SSANGSIOS AE CIEUC
    case 0x9B53: code_point = 0xC32B; break; // HANGUL SYLLABLE SSANGSIOS AE CHIEUCH
    case 0x9B54: code_point = 0xC32C; break; // HANGUL SYLLABLE SSANGSIOS AE KHIEUKH
    case 0x9B55: code_point = 0xC32D; break; // HANGUL SYLLABLE SSANGSIOS AE THIEUTH
    case 0x9B56: code_point = 0xC32E; break; // HANGUL SYLLABLE SSANGSIOS AE PHIEUPH
    case 0x9B57: code_point = 0xC32F; break; // HANGUL SYLLABLE SSANGSIOS AE HIEUH
    case 0x9B58: code_point = 0xC330; break; // HANGUL SYLLABLE SSANGSIOS YA
    case 0x9B59: code_point = 0xC331; break; // HANGUL SYLLABLE SSANGSIOS YA KIYEOK
    case 0x9B5A: code_point = 0xC332; break; // HANGUL SYLLABLE SSANGSIOS YA SSANGKIYEOK
    case 0x9B61: code_point = 0xC333; break; // HANGUL SYLLABLE SSANGSIOS YA KIYEOKSIOS
    case 0x9B62: code_point = 0xC334; break; // HANGUL SYLLABLE SSANGSIOS YA NIEUN
    case 0x9B63: code_point = 0xC335; break; // HANGUL SYLLABLE SSANGSIOS YA NIEUNCIEUC
    case 0x9B64: code_point = 0xC336; break; // HANGUL SYLLABLE SSANGSIOS YA NIEUNHIEUH
    case 0x9B65: code_point = 0xC337; break; // HANGUL SYLLABLE SSANGSIOS YA TIKEUT
    case 0x9B66: code_point = 0xC338; break; // HANGUL SYLLABLE SSANGSIOS YA RIEUL
    case 0x9B67: code_point = 0xC339; break; // HANGUL SYLLABLE SSANGSIOS YA RIEULKIYEOK
    case 0x9B68: code_point = 0xC33A; break; // HANGUL SYLLABLE SSANGSIOS YA RIEULMIEUM
    case 0x9B69: code_point = 0xC33B; break; // HANGUL SYLLABLE SSANGSIOS YA RIEULPIEUP
    case 0x9B6A: code_point = 0xC33C; break; // HANGUL SYLLABLE SSANGSIOS YA RIEULSIOS
    case 0x9B6B: code_point = 0xC33D; break; // HANGUL SYLLABLE SSANGSIOS YA RIEULTHIEUTH
    case 0x9B6C: code_point = 0xC33E; break; // HANGUL SYLLABLE SSANGSIOS YA RIEULPHIEUPH
    case 0x9B6D: code_point = 0xC33F; break; // HANGUL SYLLABLE SSANGSIOS YA RIEULHIEUH
    case 0x9B6E: code_point = 0xC340; break; // HANGUL SYLLABLE SSANGSIOS YA MIEUM
    case 0x9B6F: code_point = 0xC341; break; // HANGUL SYLLABLE SSANGSIOS YA PIEUP
    case 0x9B70: code_point = 0xC342; break; // HANGUL SYLLABLE SSANGSIOS YA PIEUPSIOS
    case 0x9B71: code_point = 0xC343; break; // HANGUL SYLLABLE SSANGSIOS YA SIOS
    case 0x9B72: code_point = 0xC344; break; // HANGUL SYLLABLE SSANGSIOS YA SSANGSIOS
    case 0x9B73: code_point = 0xC346; break; // HANGUL SYLLABLE SSANGSIOS YA CIEUC
    case 0x9B74: code_point = 0xC347; break; // HANGUL SYLLABLE SSANGSIOS YA CHIEUCH
    case 0x9B75: code_point = 0xC348; break; // HANGUL SYLLABLE SSANGSIOS YA KHIEUKH
    case 0x9B76: code_point = 0xC349; break; // HANGUL SYLLABLE SSANGSIOS YA THIEUTH
    case 0x9B77: code_point = 0xC34A; break; // HANGUL SYLLABLE SSANGSIOS YA PHIEUPH
    case 0x9B78: code_point = 0xC34B; break; // HANGUL SYLLABLE SSANGSIOS YA HIEUH
    case 0x9B79: code_point = 0xC34C; break; // HANGUL SYLLABLE SSANGSIOS YAE
    case 0x9B7A: code_point = 0xC34D; break; // HANGUL SYLLABLE SSANGSIOS YAE KIYEOK
    case 0x9B81: code_point = 0xC34E; break; // HANGUL SYLLABLE SSANGSIOS YAE SSANGKIYEOK
    case 0x9B82: code_point = 0xC34F; break; // HANGUL SYLLABLE SSANGSIOS YAE KIYEOKSIOS
    case 0x9B83: code_point = 0xC350; break; // HANGUL SYLLABLE SSANGSIOS YAE NIEUN
    case 0x9B84: code_point = 0xC351; break; // HANGUL SYLLABLE SSANGSIOS YAE NIEUNCIEUC
    case 0x9B85: code_point = 0xC352; break; // HANGUL SYLLABLE SSANGSIOS YAE NIEUNHIEUH
    case 0x9B86: code_point = 0xC353; break; // HANGUL SYLLABLE SSANGSIOS YAE TIKEUT
    case 0x9B87: code_point = 0xC354; break; // HANGUL SYLLABLE SSANGSIOS YAE RIEUL
    case 0x9B88: code_point = 0xC355; break; // HANGUL SYLLABLE SSANGSIOS YAE RIEULKIYEOK
    case 0x9B89: code_point = 0xC356; break; // HANGUL SYLLABLE SSANGSIOS YAE RIEULMIEUM
    case 0x9B8A: code_point = 0xC357; break; // HANGUL SYLLABLE SSANGSIOS YAE RIEULPIEUP
    case 0x9B8B: code_point = 0xC358; break; // HANGUL SYLLABLE SSANGSIOS YAE RIEULSIOS
    case 0x9B8C: code_point = 0xC359; break; // HANGUL SYLLABLE SSANGSIOS YAE RIEULTHIEUTH
    case 0x9B8D: code_point = 0xC35A; break; // HANGUL SYLLABLE SSANGSIOS YAE RIEULPHIEUPH
    case 0x9B8E: code_point = 0xC35B; break; // HANGUL SYLLABLE SSANGSIOS YAE RIEULHIEUH
    case 0x9B8F: code_point = 0xC35C; break; // HANGUL SYLLABLE SSANGSIOS YAE MIEUM
    case 0x9B90: code_point = 0xC35D; break; // HANGUL SYLLABLE SSANGSIOS YAE PIEUP
    case 0x9B91: code_point = 0xC35E; break; // HANGUL SYLLABLE SSANGSIOS YAE PIEUPSIOS
    case 0x9B92: code_point = 0xC35F; break; // HANGUL SYLLABLE SSANGSIOS YAE SIOS
    case 0x9B93: code_point = 0xC360; break; // HANGUL SYLLABLE SSANGSIOS YAE SSANGSIOS
    case 0x9B94: code_point = 0xC361; break; // HANGUL SYLLABLE SSANGSIOS YAE IEUNG
    case 0x9B95: code_point = 0xC362; break; // HANGUL SYLLABLE SSANGSIOS YAE CIEUC
    case 0x9B96: code_point = 0xC363; break; // HANGUL SYLLABLE SSANGSIOS YAE CHIEUCH
    case 0x9B97: code_point = 0xC364; break; // HANGUL SYLLABLE SSANGSIOS YAE KHIEUKH
    case 0x9B98: code_point = 0xC365; break; // HANGUL SYLLABLE SSANGSIOS YAE THIEUTH
    case 0x9B99: code_point = 0xC366; break; // HANGUL SYLLABLE SSANGSIOS YAE PHIEUPH
    case 0x9B9A: code_point = 0xC367; break; // HANGUL SYLLABLE SSANGSIOS YAE HIEUH
    case 0x9B9B: code_point = 0xC36A; break; // HANGUL SYLLABLE SSANGSIOS EO SSANGKIYEOK
    case 0x9B9C: code_point = 0xC36B; break; // HANGUL SYLLABLE SSANGSIOS EO KIYEOKSIOS
    case 0x9B9D: code_point = 0xC36D; break; // HANGUL SYLLABLE SSANGSIOS EO NIEUNCIEUC
    case 0x9B9E: code_point = 0xC36E; break; // HANGUL SYLLABLE SSANGSIOS EO NIEUNHIEUH
    case 0x9B9F: code_point = 0xC36F; break; // HANGUL SYLLABLE SSANGSIOS EO TIKEUT
    case 0x9BA0: code_point = 0xC371; break; // HANGUL SYLLABLE SSANGSIOS EO RIEULKIYEOK
    case 0x9BA1: code_point = 0xC373; break; // HANGUL SYLLABLE SSANGSIOS EO RIEULPIEUP
    case 0x9BA2: code_point = 0xC374; break; // HANGUL SYLLABLE SSANGSIOS EO RIEULSIOS
    case 0x9BA3: code_point = 0xC375; break; // HANGUL SYLLABLE SSANGSIOS EO RIEULTHIEUTH
    case 0x9BA4: code_point = 0xC376; break; // HANGUL SYLLABLE SSANGSIOS EO RIEULPHIEUPH
    case 0x9BA5: code_point = 0xC377; break; // HANGUL SYLLABLE SSANGSIOS EO RIEULHIEUH
    case 0x9BA6: code_point = 0xC37A; break; // HANGUL SYLLABLE SSANGSIOS EO PIEUPSIOS
    case 0x9BA7: code_point = 0xC37B; break; // HANGUL SYLLABLE SSANGSIOS EO SIOS
    case 0x9BA8: code_point = 0xC37E; break; // HANGUL SYLLABLE SSANGSIOS EO CIEUC
    case 0x9BA9: code_point = 0xC37F; break; // HANGUL SYLLABLE SSANGSIOS EO CHIEUCH
    case 0x9BAA: code_point = 0xC380; break; // HANGUL SYLLABLE SSANGSIOS EO KHIEUKH
    case 0x9BAB: code_point = 0xC381; break; // HANGUL SYLLABLE SSANGSIOS EO THIEUTH
    case 0x9BAC: code_point = 0xC382; break; // HANGUL SYLLABLE SSANGSIOS EO PHIEUPH
    case 0x9BAD: code_point = 0xC383; break; // HANGUL SYLLABLE SSANGSIOS EO HIEUH
    case 0x9BAE: code_point = 0xC385; break; // HANGUL SYLLABLE SSANGSIOS E KIYEOK
    case 0x9BAF: code_point = 0xC386; break; // HANGUL SYLLABLE SSANGSIOS E SSANGKIYEOK
    case 0x9BB0: code_point = 0xC387; break; // HANGUL SYLLABLE SSANGSIOS E KIYEOKSIOS
    case 0x9BB1: code_point = 0xC389; break; // HANGUL SYLLABLE SSANGSIOS E NIEUNCIEUC
    case 0x9BB2: code_point = 0xC38A; break; // HANGUL SYLLABLE SSANGSIOS E NIEUNHIEUH
    case 0x9BB3: code_point = 0xC38B; break; // HANGUL SYLLABLE SSANGSIOS E TIKEUT
    case 0x9BB4: code_point = 0xC38D; break; // HANGUL SYLLABLE SSANGSIOS E RIEULKIYEOK
    case 0x9BB5: code_point = 0xC38E; break; // HANGUL SYLLABLE SSANGSIOS E RIEULMIEUM
    case 0x9BB6: code_point = 0xC38F; break; // HANGUL SYLLABLE SSANGSIOS E RIEULPIEUP
    case 0x9BB7: code_point = 0xC390; break; // HANGUL SYLLABLE SSANGSIOS E RIEULSIOS
    case 0x9BB8: code_point = 0xC391; break; // HANGUL SYLLABLE SSANGSIOS E RIEULTHIEUTH
    case 0x9BB9: code_point = 0xC392; break; // HANGUL SYLLABLE SSANGSIOS E RIEULPHIEUPH
    case 0x9BBA: code_point = 0xC393; break; // HANGUL SYLLABLE SSANGSIOS E RIEULHIEUH
    case 0x9BBB: code_point = 0xC394; break; // HANGUL SYLLABLE SSANGSIOS E MIEUM
    case 0x9BBC: code_point = 0xC395; break; // HANGUL SYLLABLE SSANGSIOS E PIEUP
    case 0x9BBD: code_point = 0xC396; break; // HANGUL SYLLABLE SSANGSIOS E PIEUPSIOS
    case 0x9BBE: code_point = 0xC397; break; // HANGUL SYLLABLE SSANGSIOS E SIOS
    case 0x9BBF: code_point = 0xC398; break; // HANGUL SYLLABLE SSANGSIOS E SSANGSIOS
    case 0x9BC0: code_point = 0xC399; break; // HANGUL SYLLABLE SSANGSIOS E IEUNG
    case 0x9BC1: code_point = 0xC39A; break; // HANGUL SYLLABLE SSANGSIOS E CIEUC
    case 0x9BC2: code_point = 0xC39B; break; // HANGUL SYLLABLE SSANGSIOS E CHIEUCH
    case 0x9BC3: code_point = 0xC39C; break; // HANGUL SYLLABLE SSANGSIOS E KHIEUKH
    case 0x9BC4: code_point = 0xC39D; break; // HANGUL SYLLABLE SSANGSIOS E THIEUTH
    case 0x9BC5: code_point = 0xC39E; break; // HANGUL SYLLABLE SSANGSIOS E PHIEUPH
    case 0x9BC6: code_point = 0xC39F; break; // HANGUL SYLLABLE SSANGSIOS E HIEUH
    case 0x9BC7: code_point = 0xC3A0; break; // HANGUL SYLLABLE SSANGSIOS YEO
    case 0x9BC8: code_point = 0xC3A1; break; // HANGUL SYLLABLE SSANGSIOS YEO KIYEOK
    case 0x9BC9: code_point = 0xC3A2; break; // HANGUL SYLLABLE SSANGSIOS YEO SSANGKIYEOK
    case 0x9BCA: code_point = 0xC3A3; break; // HANGUL SYLLABLE SSANGSIOS YEO KIYEOKSIOS
    case 0x9BCB: code_point = 0xC3A4; break; // HANGUL SYLLABLE SSANGSIOS YEO NIEUN
    case 0x9BCC: code_point = 0xC3A5; break; // HANGUL SYLLABLE SSANGSIOS YEO NIEUNCIEUC
    case 0x9BCD: code_point = 0xC3A6; break; // HANGUL SYLLABLE SSANGSIOS YEO NIEUNHIEUH
    case 0x9BCE: code_point = 0xC3A7; break; // HANGUL SYLLABLE SSANGSIOS YEO TIKEUT
    case 0x9BCF: code_point = 0xC3A8; break; // HANGUL SYLLABLE SSANGSIOS YEO RIEUL
    case 0x9BD0: code_point = 0xC3A9; break; // HANGUL SYLLABLE SSANGSIOS YEO RIEULKIYEOK
    case 0x9BD1: code_point = 0xC3AA; break; // HANGUL SYLLABLE SSANGSIOS YEO RIEULMIEUM
    case 0x9BD2: code_point = 0xC3AB; break; // HANGUL SYLLABLE SSANGSIOS YEO RIEULPIEUP
    case 0x9BD3: code_point = 0xC3AC; break; // HANGUL SYLLABLE SSANGSIOS YEO RIEULSIOS
    case 0x9BD4: code_point = 0xC3AD; break; // HANGUL SYLLABLE SSANGSIOS YEO RIEULTHIEUTH
    case 0x9BD5: code_point = 0xC3AE; break; // HANGUL SYLLABLE SSANGSIOS YEO RIEULPHIEUPH
    case 0x9BD6: code_point = 0xC3AF; break; // HANGUL SYLLABLE SSANGSIOS YEO RIEULHIEUH
    case 0x9BD7: code_point = 0xC3B0; break; // HANGUL SYLLABLE SSANGSIOS YEO MIEUM
    case 0x9BD8: code_point = 0xC3B1; break; // HANGUL SYLLABLE SSANGSIOS YEO PIEUP
    case 0x9BD9: code_point = 0xC3B2; break; // HANGUL SYLLABLE SSANGSIOS YEO PIEUPSIOS
    case 0x9BDA: code_point = 0xC3B3; break; // HANGUL SYLLABLE SSANGSIOS YEO SIOS
    case 0x9BDB: code_point = 0xC3B4; break; // HANGUL SYLLABLE SSANGSIOS YEO SSANGSIOS
    case 0x9BDC: code_point = 0xC3B5; break; // HANGUL SYLLABLE SSANGSIOS YEO IEUNG
    case 0x9BDD: code_point = 0xC3B6; break; // HANGUL SYLLABLE SSANGSIOS YEO CIEUC
    case 0x9BDE: code_point = 0xC3B7; break; // HANGUL SYLLABLE SSANGSIOS YEO CHIEUCH
    case 0x9BDF: code_point = 0xC3B8; break; // HANGUL SYLLABLE SSANGSIOS YEO KHIEUKH
    case 0x9BE0: code_point = 0xC3B9; break; // HANGUL SYLLABLE SSANGSIOS YEO THIEUTH
    case 0x9BE1: code_point = 0xC3BA; break; // HANGUL SYLLABLE SSANGSIOS YEO PHIEUPH
    case 0x9BE2: code_point = 0xC3BB; break; // HANGUL SYLLABLE SSANGSIOS YEO HIEUH
    case 0x9BE3: code_point = 0xC3BC; break; // HANGUL SYLLABLE SSANGSIOS YE
    case 0x9BE4: code_point = 0xC3BD; break; // HANGUL SYLLABLE SSANGSIOS YE KIYEOK
    case 0x9BE5: code_point = 0xC3BE; break; // HANGUL SYLLABLE SSANGSIOS YE SSANGKIYEOK
    case 0x9BE6: code_point = 0xC3BF; break; // HANGUL SYLLABLE SSANGSIOS YE KIYEOKSIOS
    case 0x9BE7: code_point = 0xC3C1; break; // HANGUL SYLLABLE SSANGSIOS YE NIEUNCIEUC
    case 0x9BE8: code_point = 0xC3C2; break; // HANGUL SYLLABLE SSANGSIOS YE NIEUNHIEUH
    case 0x9BE9: code_point = 0xC3C3; break; // HANGUL SYLLABLE SSANGSIOS YE TIKEUT
    case 0x9BEA: code_point = 0xC3C4; break; // HANGUL SYLLABLE SSANGSIOS YE RIEUL
    case 0x9BEB: code_point = 0xC3C5; break; // HANGUL SYLLABLE SSANGSIOS YE RIEULKIYEOK
    case 0x9BEC: code_point = 0xC3C6; break; // HANGUL SYLLABLE SSANGSIOS YE RIEULMIEUM
    case 0x9BED: code_point = 0xC3C7; break; // HANGUL SYLLABLE SSANGSIOS YE RIEULPIEUP
    case 0x9BEE: code_point = 0xC3C8; break; // HANGUL SYLLABLE SSANGSIOS YE RIEULSIOS
    case 0x9BEF: code_point = 0xC3C9; break; // HANGUL SYLLABLE SSANGSIOS YE RIEULTHIEUTH
    case 0x9BF0: code_point = 0xC3CA; break; // HANGUL SYLLABLE SSANGSIOS YE RIEULPHIEUPH
    case 0x9BF1: code_point = 0xC3CB; break; // HANGUL SYLLABLE SSANGSIOS YE RIEULHIEUH
    case 0x9BF2: code_point = 0xC3CC; break; // HANGUL SYLLABLE SSANGSIOS YE MIEUM
    case 0x9BF3: code_point = 0xC3CD; break; // HANGUL SYLLABLE SSANGSIOS YE PIEUP
    case 0x9BF4: code_point = 0xC3CE; break; // HANGUL SYLLABLE SSANGSIOS YE PIEUPSIOS
    case 0x9BF5: code_point = 0xC3CF; break; // HANGUL SYLLABLE SSANGSIOS YE SIOS
    case 0x9BF6: code_point = 0xC3D0; break; // HANGUL SYLLABLE SSANGSIOS YE SSANGSIOS
    case 0x9BF7: code_point = 0xC3D1; break; // HANGUL SYLLABLE SSANGSIOS YE IEUNG
    case 0x9BF8: code_point = 0xC3D2; break; // HANGUL SYLLABLE SSANGSIOS YE CIEUC
    case 0x9BF9: code_point = 0xC3D3; break; // HANGUL SYLLABLE SSANGSIOS YE CHIEUCH
    case 0x9BFA: code_point = 0xC3D4; break; // HANGUL SYLLABLE SSANGSIOS YE KHIEUKH
    case 0x9BFB: code_point = 0xC3D5; break; // HANGUL SYLLABLE SSANGSIOS YE THIEUTH
    case 0x9BFC: code_point = 0xC3D6; break; // HANGUL SYLLABLE SSANGSIOS YE PHIEUPH
    case 0x9BFD: code_point = 0xC3D7; break; // HANGUL SYLLABLE SSANGSIOS YE HIEUH
    case 0x9BFE: code_point = 0xC3DA; break; // HANGUL SYLLABLE SSANGSIOS O SSANGKIYEOK
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x9C(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9C41: code_point = 0xC3DB; break; // HANGUL SYLLABLE SSANGSIOS O KIYEOKSIOS
    case 0x9C42: code_point = 0xC3DD; break; // HANGUL SYLLABLE SSANGSIOS O NIEUNCIEUC
    case 0x9C43: code_point = 0xC3DE; break; // HANGUL SYLLABLE SSANGSIOS O NIEUNHIEUH
    case 0x9C44: code_point = 0xC3E1; break; // HANGUL SYLLABLE SSANGSIOS O RIEULKIYEOK
    case 0x9C45: code_point = 0xC3E3; break; // HANGUL SYLLABLE SSANGSIOS O RIEULPIEUP
    case 0x9C46: code_point = 0xC3E4; break; // HANGUL SYLLABLE SSANGSIOS O RIEULSIOS
    case 0x9C47: code_point = 0xC3E5; break; // HANGUL SYLLABLE SSANGSIOS O RIEULTHIEUTH
    case 0x9C48: code_point = 0xC3E6; break; // HANGUL SYLLABLE SSANGSIOS O RIEULPHIEUPH
    case 0x9C49: code_point = 0xC3E7; break; // HANGUL SYLLABLE SSANGSIOS O RIEULHIEUH
    case 0x9C4A: code_point = 0xC3EA; break; // HANGUL SYLLABLE SSANGSIOS O PIEUPSIOS
    case 0x9C4B: code_point = 0xC3EB; break; // HANGUL SYLLABLE SSANGSIOS O SIOS
    case 0x9C4C: code_point = 0xC3EC; break; // HANGUL SYLLABLE SSANGSIOS O SSANGSIOS
    case 0x9C4D: code_point = 0xC3EE; break; // HANGUL SYLLABLE SSANGSIOS O CIEUC
    case 0x9C4E: code_point = 0xC3EF; break; // HANGUL SYLLABLE SSANGSIOS O CHIEUCH
    case 0x9C4F: code_point = 0xC3F0; break; // HANGUL SYLLABLE SSANGSIOS O KHIEUKH
    case 0x9C50: code_point = 0xC3F1; break; // HANGUL SYLLABLE SSANGSIOS O THIEUTH
    case 0x9C51: code_point = 0xC3F2; break; // HANGUL SYLLABLE SSANGSIOS O PHIEUPH
    case 0x9C52: code_point = 0xC3F3; break; // HANGUL SYLLABLE SSANGSIOS O HIEUH
    case 0x9C53: code_point = 0xC3F6; break; // HANGUL SYLLABLE SSANGSIOS WA SSANGKIYEOK
    case 0x9C54: code_point = 0xC3F7; break; // HANGUL SYLLABLE SSANGSIOS WA KIYEOKSIOS
    case 0x9C55: code_point = 0xC3F9; break; // HANGUL SYLLABLE SSANGSIOS WA NIEUNCIEUC
    case 0x9C56: code_point = 0xC3FA; break; // HANGUL SYLLABLE SSANGSIOS WA NIEUNHIEUH
    case 0x9C57: code_point = 0xC3FB; break; // HANGUL SYLLABLE SSANGSIOS WA TIKEUT
    case 0x9C58: code_point = 0xC3FC; break; // HANGUL SYLLABLE SSANGSIOS WA RIEUL
    case 0x9C59: code_point = 0xC3FD; break; // HANGUL SYLLABLE SSANGSIOS WA RIEULKIYEOK
    case 0x9C5A: code_point = 0xC3FE; break; // HANGUL SYLLABLE SSANGSIOS WA RIEULMIEUM
    case 0x9C61: code_point = 0xC3FF; break; // HANGUL SYLLABLE SSANGSIOS WA RIEULPIEUP
    case 0x9C62: code_point = 0xC400; break; // HANGUL SYLLABLE SSANGSIOS WA RIEULSIOS
    case 0x9C63: code_point = 0xC401; break; // HANGUL SYLLABLE SSANGSIOS WA RIEULTHIEUTH
    case 0x9C64: code_point = 0xC402; break; // HANGUL SYLLABLE SSANGSIOS WA RIEULPHIEUPH
    case 0x9C65: code_point = 0xC403; break; // HANGUL SYLLABLE SSANGSIOS WA RIEULHIEUH
    case 0x9C66: code_point = 0xC404; break; // HANGUL SYLLABLE SSANGSIOS WA MIEUM
    case 0x9C67: code_point = 0xC405; break; // HANGUL SYLLABLE SSANGSIOS WA PIEUP
    case 0x9C68: code_point = 0xC406; break; // HANGUL SYLLABLE SSANGSIOS WA PIEUPSIOS
    case 0x9C69: code_point = 0xC407; break; // HANGUL SYLLABLE SSANGSIOS WA SIOS
    case 0x9C6A: code_point = 0xC409; break; // HANGUL SYLLABLE SSANGSIOS WA IEUNG
    case 0x9C6B: code_point = 0xC40A; break; // HANGUL SYLLABLE SSANGSIOS WA CIEUC
    case 0x9C6C: code_point = 0xC40B; break; // HANGUL SYLLABLE SSANGSIOS WA CHIEUCH
    case 0x9C6D: code_point = 0xC40C; break; // HANGUL SYLLABLE SSANGSIOS WA KHIEUKH
    case 0x9C6E: code_point = 0xC40D; break; // HANGUL SYLLABLE SSANGSIOS WA THIEUTH
    case 0x9C6F: code_point = 0xC40E; break; // HANGUL SYLLABLE SSANGSIOS WA PHIEUPH
    case 0x9C70: code_point = 0xC40F; break; // HANGUL SYLLABLE SSANGSIOS WA HIEUH
    case 0x9C71: code_point = 0xC411; break; // HANGUL SYLLABLE SSANGSIOS WAE KIYEOK
    case 0x9C72: code_point = 0xC412; break; // HANGUL SYLLABLE SSANGSIOS WAE SSANGKIYEOK
    case 0x9C73: code_point = 0xC413; break; // HANGUL SYLLABLE SSANGSIOS WAE KIYEOKSIOS
    case 0x9C74: code_point = 0xC414; break; // HANGUL SYLLABLE SSANGSIOS WAE NIEUN
    case 0x9C75: code_point = 0xC415; break; // HANGUL SYLLABLE SSANGSIOS WAE NIEUNCIEUC
    case 0x9C76: code_point = 0xC416; break; // HANGUL SYLLABLE SSANGSIOS WAE NIEUNHIEUH
    case 0x9C77: code_point = 0xC417; break; // HANGUL SYLLABLE SSANGSIOS WAE TIKEUT
    case 0x9C78: code_point = 0xC418; break; // HANGUL SYLLABLE SSANGSIOS WAE RIEUL
    case 0x9C79: code_point = 0xC419; break; // HANGUL SYLLABLE SSANGSIOS WAE RIEULKIYEOK
    case 0x9C7A: code_point = 0xC41A; break; // HANGUL SYLLABLE SSANGSIOS WAE RIEULMIEUM
    case 0x9C81: code_point = 0xC41B; break; // HANGUL SYLLABLE SSANGSIOS WAE RIEULPIEUP
    case 0x9C82: code_point = 0xC41C; break; // HANGUL SYLLABLE SSANGSIOS WAE RIEULSIOS
    case 0x9C83: code_point = 0xC41D; break; // HANGUL SYLLABLE SSANGSIOS WAE RIEULTHIEUTH
    case 0x9C84: code_point = 0xC41E; break; // HANGUL SYLLABLE SSANGSIOS WAE RIEULPHIEUPH
    case 0x9C85: code_point = 0xC41F; break; // HANGUL SYLLABLE SSANGSIOS WAE RIEULHIEUH
    case 0x9C86: code_point = 0xC420; break; // HANGUL SYLLABLE SSANGSIOS WAE MIEUM
    case 0x9C87: code_point = 0xC421; break; // HANGUL SYLLABLE SSANGSIOS WAE PIEUP
    case 0x9C88: code_point = 0xC422; break; // HANGUL SYLLABLE SSANGSIOS WAE PIEUPSIOS
    case 0x9C89: code_point = 0xC423; break; // HANGUL SYLLABLE SSANGSIOS WAE SIOS
    case 0x9C8A: code_point = 0xC425; break; // HANGUL SYLLABLE SSANGSIOS WAE IEUNG
    case 0x9C8B: code_point = 0xC426; break; // HANGUL SYLLABLE SSANGSIOS WAE CIEUC
    case 0x9C8C: code_point = 0xC427; break; // HANGUL SYLLABLE SSANGSIOS WAE CHIEUCH
    case 0x9C8D: code_point = 0xC428; break; // HANGUL SYLLABLE SSANGSIOS WAE KHIEUKH
    case 0x9C8E: code_point = 0xC429; break; // HANGUL SYLLABLE SSANGSIOS WAE THIEUTH
    case 0x9C8F: code_point = 0xC42A; break; // HANGUL SYLLABLE SSANGSIOS WAE PHIEUPH
    case 0x9C90: code_point = 0xC42B; break; // HANGUL SYLLABLE SSANGSIOS WAE HIEUH
    case 0x9C91: code_point = 0xC42D; break; // HANGUL SYLLABLE SSANGSIOS OE KIYEOK
    case 0x9C92: code_point = 0xC42E; break; // HANGUL SYLLABLE SSANGSIOS OE SSANGKIYEOK
    case 0x9C93: code_point = 0xC42F; break; // HANGUL SYLLABLE SSANGSIOS OE KIYEOKSIOS
    case 0x9C94: code_point = 0xC431; break; // HANGUL SYLLABLE SSANGSIOS OE NIEUNCIEUC
    case 0x9C95: code_point = 0xC432; break; // HANGUL SYLLABLE SSANGSIOS OE NIEUNHIEUH
    case 0x9C96: code_point = 0xC433; break; // HANGUL SYLLABLE SSANGSIOS OE TIKEUT
    case 0x9C97: code_point = 0xC435; break; // HANGUL SYLLABLE SSANGSIOS OE RIEULKIYEOK
    case 0x9C98: code_point = 0xC436; break; // HANGUL SYLLABLE SSANGSIOS OE RIEULMIEUM
    case 0x9C99: code_point = 0xC437; break; // HANGUL SYLLABLE SSANGSIOS OE RIEULPIEUP
    case 0x9C9A: code_point = 0xC438; break; // HANGUL SYLLABLE SSANGSIOS OE RIEULSIOS
    case 0x9C9B: code_point = 0xC439; break; // HANGUL SYLLABLE SSANGSIOS OE RIEULTHIEUTH
    case 0x9C9C: code_point = 0xC43A; break; // HANGUL SYLLABLE SSANGSIOS OE RIEULPHIEUPH
    case 0x9C9D: code_point = 0xC43B; break; // HANGUL SYLLABLE SSANGSIOS OE RIEULHIEUH
    case 0x9C9E: code_point = 0xC43E; break; // HANGUL SYLLABLE SSANGSIOS OE PIEUPSIOS
    case 0x9C9F: code_point = 0xC43F; break; // HANGUL SYLLABLE SSANGSIOS OE SIOS
    case 0x9CA0: code_point = 0xC440; break; // HANGUL SYLLABLE SSANGSIOS OE SSANGSIOS
    case 0x9CA1: code_point = 0xC441; break; // HANGUL SYLLABLE SSANGSIOS OE IEUNG
    case 0x9CA2: code_point = 0xC442; break; // HANGUL SYLLABLE SSANGSIOS OE CIEUC
    case 0x9CA3: code_point = 0xC443; break; // HANGUL SYLLABLE SSANGSIOS OE CHIEUCH
    case 0x9CA4: code_point = 0xC444; break; // HANGUL SYLLABLE SSANGSIOS OE KHIEUKH
    case 0x9CA5: code_point = 0xC445; break; // HANGUL SYLLABLE SSANGSIOS OE THIEUTH
    case 0x9CA6: code_point = 0xC446; break; // HANGUL SYLLABLE SSANGSIOS OE PHIEUPH
    case 0x9CA7: code_point = 0xC447; break; // HANGUL SYLLABLE SSANGSIOS OE HIEUH
    case 0x9CA8: code_point = 0xC449; break; // HANGUL SYLLABLE SSANGSIOS YO KIYEOK
    case 0x9CA9: code_point = 0xC44A; break; // HANGUL SYLLABLE SSANGSIOS YO SSANGKIYEOK
    case 0x9CAA: code_point = 0xC44B; break; // HANGUL SYLLABLE SSANGSIOS YO KIYEOKSIOS
    case 0x9CAB: code_point = 0xC44C; break; // HANGUL SYLLABLE SSANGSIOS YO NIEUN
    case 0x9CAC: code_point = 0xC44D; break; // HANGUL SYLLABLE SSANGSIOS YO NIEUNCIEUC
    case 0x9CAD: code_point = 0xC44E; break; // HANGUL SYLLABLE SSANGSIOS YO NIEUNHIEUH
    case 0x9CAE: code_point = 0xC44F; break; // HANGUL SYLLABLE SSANGSIOS YO TIKEUT
    case 0x9CAF: code_point = 0xC450; break; // HANGUL SYLLABLE SSANGSIOS YO RIEUL
    case 0x9CB0: code_point = 0xC451; break; // HANGUL SYLLABLE SSANGSIOS YO RIEULKIYEOK
    case 0x9CB1: code_point = 0xC452; break; // HANGUL SYLLABLE SSANGSIOS YO RIEULMIEUM
    case 0x9CB2: code_point = 0xC453; break; // HANGUL SYLLABLE SSANGSIOS YO RIEULPIEUP
    case 0x9CB3: code_point = 0xC454; break; // HANGUL SYLLABLE SSANGSIOS YO RIEULSIOS
    case 0x9CB4: code_point = 0xC455; break; // HANGUL SYLLABLE SSANGSIOS YO RIEULTHIEUTH
    case 0x9CB5: code_point = 0xC456; break; // HANGUL SYLLABLE SSANGSIOS YO RIEULPHIEUPH
    case 0x9CB6: code_point = 0xC457; break; // HANGUL SYLLABLE SSANGSIOS YO RIEULHIEUH
    case 0x9CB7: code_point = 0xC458; break; // HANGUL SYLLABLE SSANGSIOS YO MIEUM
    case 0x9CB8: code_point = 0xC459; break; // HANGUL SYLLABLE SSANGSIOS YO PIEUP
    case 0x9CB9: code_point = 0xC45A; break; // HANGUL SYLLABLE SSANGSIOS YO PIEUPSIOS
    case 0x9CBA: code_point = 0xC45B; break; // HANGUL SYLLABLE SSANGSIOS YO SIOS
    case 0x9CBB: code_point = 0xC45C; break; // HANGUL SYLLABLE SSANGSIOS YO SSANGSIOS
    case 0x9CBC: code_point = 0xC45D; break; // HANGUL SYLLABLE SSANGSIOS YO IEUNG
    case 0x9CBD: code_point = 0xC45E; break; // HANGUL SYLLABLE SSANGSIOS YO CIEUC
    case 0x9CBE: code_point = 0xC45F; break; // HANGUL SYLLABLE SSANGSIOS YO CHIEUCH
    case 0x9CBF: code_point = 0xC460; break; // HANGUL SYLLABLE SSANGSIOS YO KHIEUKH
    case 0x9CC0: code_point = 0xC461; break; // HANGUL SYLLABLE SSANGSIOS YO THIEUTH
    case 0x9CC1: code_point = 0xC462; break; // HANGUL SYLLABLE SSANGSIOS YO PHIEUPH
    case 0x9CC2: code_point = 0xC463; break; // HANGUL SYLLABLE SSANGSIOS YO HIEUH
    case 0x9CC3: code_point = 0xC466; break; // HANGUL SYLLABLE SSANGSIOS U SSANGKIYEOK
    case 0x9CC4: code_point = 0xC467; break; // HANGUL SYLLABLE SSANGSIOS U KIYEOKSIOS
    case 0x9CC5: code_point = 0xC469; break; // HANGUL SYLLABLE SSANGSIOS U NIEUNCIEUC
    case 0x9CC6: code_point = 0xC46A; break; // HANGUL SYLLABLE SSANGSIOS U NIEUNHIEUH
    case 0x9CC7: code_point = 0xC46B; break; // HANGUL SYLLABLE SSANGSIOS U TIKEUT
    case 0x9CC8: code_point = 0xC46D; break; // HANGUL SYLLABLE SSANGSIOS U RIEULKIYEOK
    case 0x9CC9: code_point = 0xC46E; break; // HANGUL SYLLABLE SSANGSIOS U RIEULMIEUM
    case 0x9CCA: code_point = 0xC46F; break; // HANGUL SYLLABLE SSANGSIOS U RIEULPIEUP
    case 0x9CCB: code_point = 0xC470; break; // HANGUL SYLLABLE SSANGSIOS U RIEULSIOS
    case 0x9CCC: code_point = 0xC471; break; // HANGUL SYLLABLE SSANGSIOS U RIEULTHIEUTH
    case 0x9CCD: code_point = 0xC472; break; // HANGUL SYLLABLE SSANGSIOS U RIEULPHIEUPH
    case 0x9CCE: code_point = 0xC473; break; // HANGUL SYLLABLE SSANGSIOS U RIEULHIEUH
    case 0x9CCF: code_point = 0xC476; break; // HANGUL SYLLABLE SSANGSIOS U PIEUPSIOS
    case 0x9CD0: code_point = 0xC477; break; // HANGUL SYLLABLE SSANGSIOS U SIOS
    case 0x9CD1: code_point = 0xC478; break; // HANGUL SYLLABLE SSANGSIOS U SSANGSIOS
    case 0x9CD2: code_point = 0xC47A; break; // HANGUL SYLLABLE SSANGSIOS U CIEUC
    case 0x9CD3: code_point = 0xC47B; break; // HANGUL SYLLABLE SSANGSIOS U CHIEUCH
    case 0x9CD4: code_point = 0xC47C; break; // HANGUL SYLLABLE SSANGSIOS U KHIEUKH
    case 0x9CD5: code_point = 0xC47D; break; // HANGUL SYLLABLE SSANGSIOS U THIEUTH
    case 0x9CD6: code_point = 0xC47E; break; // HANGUL SYLLABLE SSANGSIOS U PHIEUPH
    case 0x9CD7: code_point = 0xC47F; break; // HANGUL SYLLABLE SSANGSIOS U HIEUH
    case 0x9CD8: code_point = 0xC481; break; // HANGUL SYLLABLE SSANGSIOS WEO KIYEOK
    case 0x9CD9: code_point = 0xC482; break; // HANGUL SYLLABLE SSANGSIOS WEO SSANGKIYEOK
    case 0x9CDA: code_point = 0xC483; break; // HANGUL SYLLABLE SSANGSIOS WEO KIYEOKSIOS
    case 0x9CDB: code_point = 0xC484; break; // HANGUL SYLLABLE SSANGSIOS WEO NIEUN
    case 0x9CDC: code_point = 0xC485; break; // HANGUL SYLLABLE SSANGSIOS WEO NIEUNCIEUC
    case 0x9CDD: code_point = 0xC486; break; // HANGUL SYLLABLE SSANGSIOS WEO NIEUNHIEUH
    case 0x9CDE: code_point = 0xC487; break; // HANGUL SYLLABLE SSANGSIOS WEO TIKEUT
    case 0x9CDF: code_point = 0xC488; break; // HANGUL SYLLABLE SSANGSIOS WEO RIEUL
    case 0x9CE0: code_point = 0xC489; break; // HANGUL SYLLABLE SSANGSIOS WEO RIEULKIYEOK
    case 0x9CE1: code_point = 0xC48A; break; // HANGUL SYLLABLE SSANGSIOS WEO RIEULMIEUM
    case 0x9CE2: code_point = 0xC48B; break; // HANGUL SYLLABLE SSANGSIOS WEO RIEULPIEUP
    case 0x9CE3: code_point = 0xC48C; break; // HANGUL SYLLABLE SSANGSIOS WEO RIEULSIOS
    case 0x9CE4: code_point = 0xC48D; break; // HANGUL SYLLABLE SSANGSIOS WEO RIEULTHIEUTH
    case 0x9CE5: code_point = 0xC48E; break; // HANGUL SYLLABLE SSANGSIOS WEO RIEULPHIEUPH
    case 0x9CE6: code_point = 0xC48F; break; // HANGUL SYLLABLE SSANGSIOS WEO RIEULHIEUH
    case 0x9CE7: code_point = 0xC490; break; // HANGUL SYLLABLE SSANGSIOS WEO MIEUM
    case 0x9CE8: code_point = 0xC491; break; // HANGUL SYLLABLE SSANGSIOS WEO PIEUP
    case 0x9CE9: code_point = 0xC492; break; // HANGUL SYLLABLE SSANGSIOS WEO PIEUPSIOS
    case 0x9CEA: code_point = 0xC493; break; // HANGUL SYLLABLE SSANGSIOS WEO SIOS
    case 0x9CEB: code_point = 0xC495; break; // HANGUL SYLLABLE SSANGSIOS WEO IEUNG
    case 0x9CEC: code_point = 0xC496; break; // HANGUL SYLLABLE SSANGSIOS WEO CIEUC
    case 0x9CED: code_point = 0xC497; break; // HANGUL SYLLABLE SSANGSIOS WEO CHIEUCH
    case 0x9CEE: code_point = 0xC498; break; // HANGUL SYLLABLE SSANGSIOS WEO KHIEUKH
    case 0x9CEF: code_point = 0xC499; break; // HANGUL SYLLABLE SSANGSIOS WEO THIEUTH
    case 0x9CF0: code_point = 0xC49A; break; // HANGUL SYLLABLE SSANGSIOS WEO PHIEUPH
    case 0x9CF1: code_point = 0xC49B; break; // HANGUL SYLLABLE SSANGSIOS WEO HIEUH
    case 0x9CF2: code_point = 0xC49D; break; // HANGUL SYLLABLE SSANGSIOS WE KIYEOK
    case 0x9CF3: code_point = 0xC49E; break; // HANGUL SYLLABLE SSANGSIOS WE SSANGKIYEOK
    case 0x9CF4: code_point = 0xC49F; break; // HANGUL SYLLABLE SSANGSIOS WE KIYEOKSIOS
    case 0x9CF5: code_point = 0xC4A0; break; // HANGUL SYLLABLE SSANGSIOS WE NIEUN
    case 0x9CF6: code_point = 0xC4A1; break; // HANGUL SYLLABLE SSANGSIOS WE NIEUNCIEUC
    case 0x9CF7: code_point = 0xC4A2; break; // HANGUL SYLLABLE SSANGSIOS WE NIEUNHIEUH
    case 0x9CF8: code_point = 0xC4A3; break; // HANGUL SYLLABLE SSANGSIOS WE TIKEUT
    case 0x9CF9: code_point = 0xC4A4; break; // HANGUL SYLLABLE SSANGSIOS WE RIEUL
    case 0x9CFA: code_point = 0xC4A5; break; // HANGUL SYLLABLE SSANGSIOS WE RIEULKIYEOK
    case 0x9CFB: code_point = 0xC4A6; break; // HANGUL SYLLABLE SSANGSIOS WE RIEULMIEUM
    case 0x9CFC: code_point = 0xC4A7; break; // HANGUL SYLLABLE SSANGSIOS WE RIEULPIEUP
    case 0x9CFD: code_point = 0xC4A8; break; // HANGUL SYLLABLE SSANGSIOS WE RIEULSIOS
    case 0x9CFE: code_point = 0xC4A9; break; // HANGUL SYLLABLE SSANGSIOS WE RIEULTHIEUTH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x9D(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9D41: code_point = 0xC4AA; break; // HANGUL SYLLABLE SSANGSIOS WE RIEULPHIEUPH
    case 0x9D42: code_point = 0xC4AB; break; // HANGUL SYLLABLE SSANGSIOS WE RIEULHIEUH
    case 0x9D43: code_point = 0xC4AC; break; // HANGUL SYLLABLE SSANGSIOS WE MIEUM
    case 0x9D44: code_point = 0xC4AD; break; // HANGUL SYLLABLE SSANGSIOS WE PIEUP
    case 0x9D45: code_point = 0xC4AE; break; // HANGUL SYLLABLE SSANGSIOS WE PIEUPSIOS
    case 0x9D46: code_point = 0xC4AF; break; // HANGUL SYLLABLE SSANGSIOS WE SIOS
    case 0x9D47: code_point = 0xC4B0; break; // HANGUL SYLLABLE SSANGSIOS WE SSANGSIOS
    case 0x9D48: code_point = 0xC4B1; break; // HANGUL SYLLABLE SSANGSIOS WE IEUNG
    case 0x9D49: code_point = 0xC4B2; break; // HANGUL SYLLABLE SSANGSIOS WE CIEUC
    case 0x9D4A: code_point = 0xC4B3; break; // HANGUL SYLLABLE SSANGSIOS WE CHIEUCH
    case 0x9D4B: code_point = 0xC4B4; break; // HANGUL SYLLABLE SSANGSIOS WE KHIEUKH
    case 0x9D4C: code_point = 0xC4B5; break; // HANGUL SYLLABLE SSANGSIOS WE THIEUTH
    case 0x9D4D: code_point = 0xC4B6; break; // HANGUL SYLLABLE SSANGSIOS WE PHIEUPH
    case 0x9D4E: code_point = 0xC4B7; break; // HANGUL SYLLABLE SSANGSIOS WE HIEUH
    case 0x9D4F: code_point = 0xC4B9; break; // HANGUL SYLLABLE SSANGSIOS WI KIYEOK
    case 0x9D50: code_point = 0xC4BA; break; // HANGUL SYLLABLE SSANGSIOS WI SSANGKIYEOK
    case 0x9D51: code_point = 0xC4BB; break; // HANGUL SYLLABLE SSANGSIOS WI KIYEOKSIOS
    case 0x9D52: code_point = 0xC4BD; break; // HANGUL SYLLABLE SSANGSIOS WI NIEUNCIEUC
    case 0x9D53: code_point = 0xC4BE; break; // HANGUL SYLLABLE SSANGSIOS WI NIEUNHIEUH
    case 0x9D54: code_point = 0xC4BF; break; // HANGUL SYLLABLE SSANGSIOS WI TIKEUT
    case 0x9D55: code_point = 0xC4C0; break; // HANGUL SYLLABLE SSANGSIOS WI RIEUL
    case 0x9D56: code_point = 0xC4C1; break; // HANGUL SYLLABLE SSANGSIOS WI RIEULKIYEOK
    case 0x9D57: code_point = 0xC4C2; break; // HANGUL SYLLABLE SSANGSIOS WI RIEULMIEUM
    case 0x9D58: code_point = 0xC4C3; break; // HANGUL SYLLABLE SSANGSIOS WI RIEULPIEUP
    case 0x9D59: code_point = 0xC4C4; break; // HANGUL SYLLABLE SSANGSIOS WI RIEULSIOS
    case 0x9D5A: code_point = 0xC4C5; break; // HANGUL SYLLABLE SSANGSIOS WI RIEULTHIEUTH
    case 0x9D61: code_point = 0xC4C6; break; // HANGUL SYLLABLE SSANGSIOS WI RIEULPHIEUPH
    case 0x9D62: code_point = 0xC4C7; break; // HANGUL SYLLABLE SSANGSIOS WI RIEULHIEUH
    case 0x9D63: code_point = 0xC4C8; break; // HANGUL SYLLABLE SSANGSIOS WI MIEUM
    case 0x9D64: code_point = 0xC4C9; break; // HANGUL SYLLABLE SSANGSIOS WI PIEUP
    case 0x9D65: code_point = 0xC4CA; break; // HANGUL SYLLABLE SSANGSIOS WI PIEUPSIOS
    case 0x9D66: code_point = 0xC4CB; break; // HANGUL SYLLABLE SSANGSIOS WI SIOS
    case 0x9D67: code_point = 0xC4CC; break; // HANGUL SYLLABLE SSANGSIOS WI SSANGSIOS
    case 0x9D68: code_point = 0xC4CD; break; // HANGUL SYLLABLE SSANGSIOS WI IEUNG
    case 0x9D69: code_point = 0xC4CE; break; // HANGUL SYLLABLE SSANGSIOS WI CIEUC
    case 0x9D6A: code_point = 0xC4CF; break; // HANGUL SYLLABLE SSANGSIOS WI CHIEUCH
    case 0x9D6B: code_point = 0xC4D0; break; // HANGUL SYLLABLE SSANGSIOS WI KHIEUKH
    case 0x9D6C: code_point = 0xC4D1; break; // HANGUL SYLLABLE SSANGSIOS WI THIEUTH
    case 0x9D6D: code_point = 0xC4D2; break; // HANGUL SYLLABLE SSANGSIOS WI PHIEUPH
    case 0x9D6E: code_point = 0xC4D3; break; // HANGUL SYLLABLE SSANGSIOS WI HIEUH
    case 0x9D6F: code_point = 0xC4D4; break; // HANGUL SYLLABLE SSANGSIOS YU
    case 0x9D70: code_point = 0xC4D5; break; // HANGUL SYLLABLE SSANGSIOS YU KIYEOK
    case 0x9D71: code_point = 0xC4D6; break; // HANGUL SYLLABLE SSANGSIOS YU SSANGKIYEOK
    case 0x9D72: code_point = 0xC4D7; break; // HANGUL SYLLABLE SSANGSIOS YU KIYEOKSIOS
    case 0x9D73: code_point = 0xC4D8; break; // HANGUL SYLLABLE SSANGSIOS YU NIEUN
    case 0x9D74: code_point = 0xC4D9; break; // HANGUL SYLLABLE SSANGSIOS YU NIEUNCIEUC
    case 0x9D75: code_point = 0xC4DA; break; // HANGUL SYLLABLE SSANGSIOS YU NIEUNHIEUH
    case 0x9D76: code_point = 0xC4DB; break; // HANGUL SYLLABLE SSANGSIOS YU TIKEUT
    case 0x9D77: code_point = 0xC4DC; break; // HANGUL SYLLABLE SSANGSIOS YU RIEUL
    case 0x9D78: code_point = 0xC4DD; break; // HANGUL SYLLABLE SSANGSIOS YU RIEULKIYEOK
    case 0x9D79: code_point = 0xC4DE; break; // HANGUL SYLLABLE SSANGSIOS YU RIEULMIEUM
    case 0x9D7A: code_point = 0xC4DF; break; // HANGUL SYLLABLE SSANGSIOS YU RIEULPIEUP
    case 0x9D81: code_point = 0xC4E0; break; // HANGUL SYLLABLE SSANGSIOS YU RIEULSIOS
    case 0x9D82: code_point = 0xC4E1; break; // HANGUL SYLLABLE SSANGSIOS YU RIEULTHIEUTH
    case 0x9D83: code_point = 0xC4E2; break; // HANGUL SYLLABLE SSANGSIOS YU RIEULPHIEUPH
    case 0x9D84: code_point = 0xC4E3; break; // HANGUL SYLLABLE SSANGSIOS YU RIEULHIEUH
    case 0x9D85: code_point = 0xC4E4; break; // HANGUL SYLLABLE SSANGSIOS YU MIEUM
    case 0x9D86: code_point = 0xC4E5; break; // HANGUL SYLLABLE SSANGSIOS YU PIEUP
    case 0x9D87: code_point = 0xC4E6; break; // HANGUL SYLLABLE SSANGSIOS YU PIEUPSIOS
    case 0x9D88: code_point = 0xC4E7; break; // HANGUL SYLLABLE SSANGSIOS YU SIOS
    case 0x9D89: code_point = 0xC4E8; break; // HANGUL SYLLABLE SSANGSIOS YU SSANGSIOS
    case 0x9D8A: code_point = 0xC4EA; break; // HANGUL SYLLABLE SSANGSIOS YU CIEUC
    case 0x9D8B: code_point = 0xC4EB; break; // HANGUL SYLLABLE SSANGSIOS YU CHIEUCH
    case 0x9D8C: code_point = 0xC4EC; break; // HANGUL SYLLABLE SSANGSIOS YU KHIEUKH
    case 0x9D8D: code_point = 0xC4ED; break; // HANGUL SYLLABLE SSANGSIOS YU THIEUTH
    case 0x9D8E: code_point = 0xC4EE; break; // HANGUL SYLLABLE SSANGSIOS YU PHIEUPH
    case 0x9D8F: code_point = 0xC4EF; break; // HANGUL SYLLABLE SSANGSIOS YU HIEUH
    case 0x9D90: code_point = 0xC4F2; break; // HANGUL SYLLABLE SSANGSIOS EU SSANGKIYEOK
    case 0x9D91: code_point = 0xC4F3; break; // HANGUL SYLLABLE SSANGSIOS EU KIYEOKSIOS
    case 0x9D92: code_point = 0xC4F5; break; // HANGUL SYLLABLE SSANGSIOS EU NIEUNCIEUC
    case 0x9D93: code_point = 0xC4F6; break; // HANGUL SYLLABLE SSANGSIOS EU NIEUNHIEUH
    case 0x9D94: code_point = 0xC4F7; break; // HANGUL SYLLABLE SSANGSIOS EU TIKEUT
    case 0x9D95: code_point = 0xC4F9; break; // HANGUL SYLLABLE SSANGSIOS EU RIEULKIYEOK
    case 0x9D96: code_point = 0xC4FB; break; // HANGUL SYLLABLE SSANGSIOS EU RIEULPIEUP
    case 0x9D97: code_point = 0xC4FC; break; // HANGUL SYLLABLE SSANGSIOS EU RIEULSIOS
    case 0x9D98: code_point = 0xC4FD; break; // HANGUL SYLLABLE SSANGSIOS EU RIEULTHIEUTH
    case 0x9D99: code_point = 0xC4FE; break; // HANGUL SYLLABLE SSANGSIOS EU RIEULPHIEUPH
    case 0x9D9A: code_point = 0xC502; break; // HANGUL SYLLABLE SSANGSIOS EU PIEUPSIOS
    case 0x9D9B: code_point = 0xC503; break; // HANGUL SYLLABLE SSANGSIOS EU SIOS
    case 0x9D9C: code_point = 0xC504; break; // HANGUL SYLLABLE SSANGSIOS EU SSANGSIOS
    case 0x9D9D: code_point = 0xC505; break; // HANGUL SYLLABLE SSANGSIOS EU IEUNG
    case 0x9D9E: code_point = 0xC506; break; // HANGUL SYLLABLE SSANGSIOS EU CIEUC
    case 0x9D9F: code_point = 0xC507; break; // HANGUL SYLLABLE SSANGSIOS EU CHIEUCH
    case 0x9DA0: code_point = 0xC508; break; // HANGUL SYLLABLE SSANGSIOS EU KHIEUKH
    case 0x9DA1: code_point = 0xC509; break; // HANGUL SYLLABLE SSANGSIOS EU THIEUTH
    case 0x9DA2: code_point = 0xC50A; break; // HANGUL SYLLABLE SSANGSIOS EU PHIEUPH
    case 0x9DA3: code_point = 0xC50B; break; // HANGUL SYLLABLE SSANGSIOS EU HIEUH
    case 0x9DA4: code_point = 0xC50D; break; // HANGUL SYLLABLE SSANGSIOS YI KIYEOK
    case 0x9DA5: code_point = 0xC50E; break; // HANGUL SYLLABLE SSANGSIOS YI SSANGKIYEOK
    case 0x9DA6: code_point = 0xC50F; break; // HANGUL SYLLABLE SSANGSIOS YI KIYEOKSIOS
    case 0x9DA7: code_point = 0xC511; break; // HANGUL SYLLABLE SSANGSIOS YI NIEUNCIEUC
    case 0x9DA8: code_point = 0xC512; break; // HANGUL SYLLABLE SSANGSIOS YI NIEUNHIEUH
    case 0x9DA9: code_point = 0xC513; break; // HANGUL SYLLABLE SSANGSIOS YI TIKEUT
    case 0x9DAA: code_point = 0xC515; break; // HANGUL SYLLABLE SSANGSIOS YI RIEULKIYEOK
    case 0x9DAB: code_point = 0xC516; break; // HANGUL SYLLABLE SSANGSIOS YI RIEULMIEUM
    case 0x9DAC: code_point = 0xC517; break; // HANGUL SYLLABLE SSANGSIOS YI RIEULPIEUP
    case 0x9DAD: code_point = 0xC518; break; // HANGUL SYLLABLE SSANGSIOS YI RIEULSIOS
    case 0x9DAE: code_point = 0xC519; break; // HANGUL SYLLABLE SSANGSIOS YI RIEULTHIEUTH
    case 0x9DAF: code_point = 0xC51A; break; // HANGUL SYLLABLE SSANGSIOS YI RIEULPHIEUPH
    case 0x9DB0: code_point = 0xC51B; break; // HANGUL SYLLABLE SSANGSIOS YI RIEULHIEUH
    case 0x9DB1: code_point = 0xC51D; break; // HANGUL SYLLABLE SSANGSIOS YI PIEUP
    case 0x9DB2: code_point = 0xC51E; break; // HANGUL SYLLABLE SSANGSIOS YI PIEUPSIOS
    case 0x9DB3: code_point = 0xC51F; break; // HANGUL SYLLABLE SSANGSIOS YI SIOS
    case 0x9DB4: code_point = 0xC520; break; // HANGUL SYLLABLE SSANGSIOS YI SSANGSIOS
    case 0x9DB5: code_point = 0xC521; break; // HANGUL SYLLABLE SSANGSIOS YI IEUNG
    case 0x9DB6: code_point = 0xC522; break; // HANGUL SYLLABLE SSANGSIOS YI CIEUC
    case 0x9DB7: code_point = 0xC523; break; // HANGUL SYLLABLE SSANGSIOS YI CHIEUCH
    case 0x9DB8: code_point = 0xC524; break; // HANGUL SYLLABLE SSANGSIOS YI KHIEUKH
    case 0x9DB9: code_point = 0xC525; break; // HANGUL SYLLABLE SSANGSIOS YI THIEUTH
    case 0x9DBA: code_point = 0xC526; break; // HANGUL SYLLABLE SSANGSIOS YI PHIEUPH
    case 0x9DBB: code_point = 0xC527; break; // HANGUL SYLLABLE SSANGSIOS YI HIEUH
    case 0x9DBC: code_point = 0xC52A; break; // HANGUL SYLLABLE SSANGSIOS I SSANGKIYEOK
    case 0x9DBD: code_point = 0xC52B; break; // HANGUL SYLLABLE SSANGSIOS I KIYEOKSIOS
    case 0x9DBE: code_point = 0xC52D; break; // HANGUL SYLLABLE SSANGSIOS I NIEUNCIEUC
    case 0x9DBF: code_point = 0xC52E; break; // HANGUL SYLLABLE SSANGSIOS I NIEUNHIEUH
    case 0x9DC0: code_point = 0xC52F; break; // HANGUL SYLLABLE SSANGSIOS I TIKEUT
    case 0x9DC1: code_point = 0xC531; break; // HANGUL SYLLABLE SSANGSIOS I RIEULKIYEOK
    case 0x9DC2: code_point = 0xC532; break; // HANGUL SYLLABLE SSANGSIOS I RIEULMIEUM
    case 0x9DC3: code_point = 0xC533; break; // HANGUL SYLLABLE SSANGSIOS I RIEULPIEUP
    case 0x9DC4: code_point = 0xC534; break; // HANGUL SYLLABLE SSANGSIOS I RIEULSIOS
    case 0x9DC5: code_point = 0xC535; break; // HANGUL SYLLABLE SSANGSIOS I RIEULTHIEUTH
    case 0x9DC6: code_point = 0xC536; break; // HANGUL SYLLABLE SSANGSIOS I RIEULPHIEUPH
    case 0x9DC7: code_point = 0xC537; break; // HANGUL SYLLABLE SSANGSIOS I RIEULHIEUH
    case 0x9DC8: code_point = 0xC53A; break; // HANGUL SYLLABLE SSANGSIOS I PIEUPSIOS
    case 0x9DC9: code_point = 0xC53C; break; // HANGUL SYLLABLE SSANGSIOS I SSANGSIOS
    case 0x9DCA: code_point = 0xC53E; break; // HANGUL SYLLABLE SSANGSIOS I CIEUC
    case 0x9DCB: code_point = 0xC53F; break; // HANGUL SYLLABLE SSANGSIOS I CHIEUCH
    case 0x9DCC: code_point = 0xC540; break; // HANGUL SYLLABLE SSANGSIOS I KHIEUKH
    case 0x9DCD: code_point = 0xC541; break; // HANGUL SYLLABLE SSANGSIOS I THIEUTH
    case 0x9DCE: code_point = 0xC542; break; // HANGUL SYLLABLE SSANGSIOS I PHIEUPH
    case 0x9DCF: code_point = 0xC543; break; // HANGUL SYLLABLE SSANGSIOS I HIEUH
    case 0x9DD0: code_point = 0xC546; break; // HANGUL SYLLABLE IEUNG A SSANGKIYEOK
    case 0x9DD1: code_point = 0xC547; break; // HANGUL SYLLABLE IEUNG A KIYEOKSIOS
    case 0x9DD2: code_point = 0xC54B; break; // HANGUL SYLLABLE IEUNG A TIKEUT
    case 0x9DD3: code_point = 0xC54F; break; // HANGUL SYLLABLE IEUNG A RIEULPIEUP
    case 0x9DD4: code_point = 0xC550; break; // HANGUL SYLLABLE IEUNG A RIEULSIOS
    case 0x9DD5: code_point = 0xC551; break; // HANGUL SYLLABLE IEUNG A RIEULTHIEUTH
    case 0x9DD6: code_point = 0xC552; break; // HANGUL SYLLABLE IEUNG A RIEULPHIEUPH
    case 0x9DD7: code_point = 0xC556; break; // HANGUL SYLLABLE IEUNG A PIEUPSIOS
    case 0x9DD8: code_point = 0xC55A; break; // HANGUL SYLLABLE IEUNG A CIEUC
    case 0x9DD9: code_point = 0xC55B; break; // HANGUL SYLLABLE IEUNG A CHIEUCH
    case 0x9DDA: code_point = 0xC55C; break; // HANGUL SYLLABLE IEUNG A KHIEUKH
    case 0x9DDB: code_point = 0xC55F; break; // HANGUL SYLLABLE IEUNG A HIEUH
    case 0x9DDC: code_point = 0xC562; break; // HANGUL SYLLABLE IEUNG AE SSANGKIYEOK
    case 0x9DDD: code_point = 0xC563; break; // HANGUL SYLLABLE IEUNG AE KIYEOKSIOS
    case 0x9DDE: code_point = 0xC565; break; // HANGUL SYLLABLE IEUNG AE NIEUNCIEUC
    case 0x9DDF: code_point = 0xC566; break; // HANGUL SYLLABLE IEUNG AE NIEUNHIEUH
    case 0x9DE0: code_point = 0xC567; break; // HANGUL SYLLABLE IEUNG AE TIKEUT
    case 0x9DE1: code_point = 0xC569; break; // HANGUL SYLLABLE IEUNG AE RIEULKIYEOK
    case 0x9DE2: code_point = 0xC56A; break; // HANGUL SYLLABLE IEUNG AE RIEULMIEUM
    case 0x9DE3: code_point = 0xC56B; break; // HANGUL SYLLABLE IEUNG AE RIEULPIEUP
    case 0x9DE4: code_point = 0xC56C; break; // HANGUL SYLLABLE IEUNG AE RIEULSIOS
    case 0x9DE5: code_point = 0xC56D; break; // HANGUL SYLLABLE IEUNG AE RIEULTHIEUTH
    case 0x9DE6: code_point = 0xC56E; break; // HANGUL SYLLABLE IEUNG AE RIEULPHIEUPH
    case 0x9DE7: code_point = 0xC56F; break; // HANGUL SYLLABLE IEUNG AE RIEULHIEUH
    case 0x9DE8: code_point = 0xC572; break; // HANGUL SYLLABLE IEUNG AE PIEUPSIOS
    case 0x9DE9: code_point = 0xC576; break; // HANGUL SYLLABLE IEUNG AE CIEUC
    case 0x9DEA: code_point = 0xC577; break; // HANGUL SYLLABLE IEUNG AE CHIEUCH
    case 0x9DEB: code_point = 0xC578; break; // HANGUL SYLLABLE IEUNG AE KHIEUKH
    case 0x9DEC: code_point = 0xC579; break; // HANGUL SYLLABLE IEUNG AE THIEUTH
    case 0x9DED: code_point = 0xC57A; break; // HANGUL SYLLABLE IEUNG AE PHIEUPH
    case 0x9DEE: code_point = 0xC57B; break; // HANGUL SYLLABLE IEUNG AE HIEUH
    case 0x9DEF: code_point = 0xC57E; break; // HANGUL SYLLABLE IEUNG YA SSANGKIYEOK
    case 0x9DF0: code_point = 0xC57F; break; // HANGUL SYLLABLE IEUNG YA KIYEOKSIOS
    case 0x9DF1: code_point = 0xC581; break; // HANGUL SYLLABLE IEUNG YA NIEUNCIEUC
    case 0x9DF2: code_point = 0xC582; break; // HANGUL SYLLABLE IEUNG YA NIEUNHIEUH
    case 0x9DF3: code_point = 0xC583; break; // HANGUL SYLLABLE IEUNG YA TIKEUT
    case 0x9DF4: code_point = 0xC585; break; // HANGUL SYLLABLE IEUNG YA RIEULKIYEOK
    case 0x9DF5: code_point = 0xC586; break; // HANGUL SYLLABLE IEUNG YA RIEULMIEUM
    case 0x9DF6: code_point = 0xC588; break; // HANGUL SYLLABLE IEUNG YA RIEULSIOS
    case 0x9DF7: code_point = 0xC589; break; // HANGUL SYLLABLE IEUNG YA RIEULTHIEUTH
    case 0x9DF8: code_point = 0xC58A; break; // HANGUL SYLLABLE IEUNG YA RIEULPHIEUPH
    case 0x9DF9: code_point = 0xC58B; break; // HANGUL SYLLABLE IEUNG YA RIEULHIEUH
    case 0x9DFA: code_point = 0xC58E; break; // HANGUL SYLLABLE IEUNG YA PIEUPSIOS
    case 0x9DFB: code_point = 0xC590; break; // HANGUL SYLLABLE IEUNG YA SSANGSIOS
    case 0x9DFC: code_point = 0xC592; break; // HANGUL SYLLABLE IEUNG YA CIEUC
    case 0x9DFD: code_point = 0xC593; break; // HANGUL SYLLABLE IEUNG YA CHIEUCH
    case 0x9DFE: code_point = 0xC594; break; // HANGUL SYLLABLE IEUNG YA KHIEUKH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x9E(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9E41: code_point = 0xC596; break; // HANGUL SYLLABLE IEUNG YA PHIEUPH
    case 0x9E42: code_point = 0xC599; break; // HANGUL SYLLABLE IEUNG YAE KIYEOK
    case 0x9E43: code_point = 0xC59A; break; // HANGUL SYLLABLE IEUNG YAE SSANGKIYEOK
    case 0x9E44: code_point = 0xC59B; break; // HANGUL SYLLABLE IEUNG YAE KIYEOKSIOS
    case 0x9E45: code_point = 0xC59D; break; // HANGUL SYLLABLE IEUNG YAE NIEUNCIEUC
    case 0x9E46: code_point = 0xC59E; break; // HANGUL SYLLABLE IEUNG YAE NIEUNHIEUH
    case 0x9E47: code_point = 0xC59F; break; // HANGUL SYLLABLE IEUNG YAE TIKEUT
    case 0x9E48: code_point = 0xC5A1; break; // HANGUL SYLLABLE IEUNG YAE RIEULKIYEOK
    case 0x9E49: code_point = 0xC5A2; break; // HANGUL SYLLABLE IEUNG YAE RIEULMIEUM
    case 0x9E4A: code_point = 0xC5A3; break; // HANGUL SYLLABLE IEUNG YAE RIEULPIEUP
    case 0x9E4B: code_point = 0xC5A4; break; // HANGUL SYLLABLE IEUNG YAE RIEULSIOS
    case 0x9E4C: code_point = 0xC5A5; break; // HANGUL SYLLABLE IEUNG YAE RIEULTHIEUTH
    case 0x9E4D: code_point = 0xC5A6; break; // HANGUL SYLLABLE IEUNG YAE RIEULPHIEUPH
    case 0x9E4E: code_point = 0xC5A7; break; // HANGUL SYLLABLE IEUNG YAE RIEULHIEUH
    case 0x9E4F: code_point = 0xC5A8; break; // HANGUL SYLLABLE IEUNG YAE MIEUM
    case 0x9E50: code_point = 0xC5AA; break; // HANGUL SYLLABLE IEUNG YAE PIEUPSIOS
    case 0x9E51: code_point = 0xC5AB; break; // HANGUL SYLLABLE IEUNG YAE SIOS
    case 0x9E52: code_point = 0xC5AC; break; // HANGUL SYLLABLE IEUNG YAE SSANGSIOS
    case 0x9E53: code_point = 0xC5AD; break; // HANGUL SYLLABLE IEUNG YAE IEUNG
    case 0x9E54: code_point = 0xC5AE; break; // HANGUL SYLLABLE IEUNG YAE CIEUC
    case 0x9E55: code_point = 0xC5AF; break; // HANGUL SYLLABLE IEUNG YAE CHIEUCH
    case 0x9E56: code_point = 0xC5B0; break; // HANGUL SYLLABLE IEUNG YAE KHIEUKH
    case 0x9E57: code_point = 0xC5B1; break; // HANGUL SYLLABLE IEUNG YAE THIEUTH
    case 0x9E58: code_point = 0xC5B2; break; // HANGUL SYLLABLE IEUNG YAE PHIEUPH
    case 0x9E59: code_point = 0xC5B3; break; // HANGUL SYLLABLE IEUNG YAE HIEUH
    case 0x9E5A: code_point = 0xC5B6; break; // HANGUL SYLLABLE IEUNG EO SSANGKIYEOK
    case 0x9E61: code_point = 0xC5B7; break; // HANGUL SYLLABLE IEUNG EO KIYEOKSIOS
    case 0x9E62: code_point = 0xC5BA; break; // HANGUL SYLLABLE IEUNG EO NIEUNHIEUH
    case 0x9E63: code_point = 0xC5BF; break; // HANGUL SYLLABLE IEUNG EO RIEULPIEUP
    case 0x9E64: code_point = 0xC5C0; break; // HANGUL SYLLABLE IEUNG EO RIEULSIOS
    case 0x9E65: code_point = 0xC5C1; break; // HANGUL SYLLABLE IEUNG EO RIEULTHIEUTH
    case 0x9E66: code_point = 0xC5C2; break; // HANGUL SYLLABLE IEUNG EO RIEULPHIEUPH
    case 0x9E67: code_point = 0xC5C3; break; // HANGUL SYLLABLE IEUNG EO RIEULHIEUH
    case 0x9E68: code_point = 0xC5CB; break; // HANGUL SYLLABLE IEUNG EO CHIEUCH
    case 0x9E69: code_point = 0xC5CD; break; // HANGUL SYLLABLE IEUNG EO THIEUTH
    case 0x9E6A: code_point = 0xC5CF; break; // HANGUL SYLLABLE IEUNG EO HIEUH
    case 0x9E6B: code_point = 0xC5D2; break; // HANGUL SYLLABLE IEUNG E SSANGKIYEOK
    case 0x9E6C: code_point = 0xC5D3; break; // HANGUL SYLLABLE IEUNG E KIYEOKSIOS
    case 0x9E6D: code_point = 0xC5D5; break; // HANGUL SYLLABLE IEUNG E NIEUNCIEUC
    case 0x9E6E: code_point = 0xC5D6; break; // HANGUL SYLLABLE IEUNG E NIEUNHIEUH
    case 0x9E6F: code_point = 0xC5D7; break; // HANGUL SYLLABLE IEUNG E TIKEUT
    case 0x9E70: code_point = 0xC5D9; break; // HANGUL SYLLABLE IEUNG E RIEULKIYEOK
    case 0x9E71: code_point = 0xC5DA; break; // HANGUL SYLLABLE IEUNG E RIEULMIEUM
    case 0x9E72: code_point = 0xC5DB; break; // HANGUL SYLLABLE IEUNG E RIEULPIEUP
    case 0x9E73: code_point = 0xC5DC; break; // HANGUL SYLLABLE IEUNG E RIEULSIOS
    case 0x9E74: code_point = 0xC5DD; break; // HANGUL SYLLABLE IEUNG E RIEULTHIEUTH
    case 0x9E75: code_point = 0xC5DE; break; // HANGUL SYLLABLE IEUNG E RIEULPHIEUPH
    case 0x9E76: code_point = 0xC5DF; break; // HANGUL SYLLABLE IEUNG E RIEULHIEUH
    case 0x9E77: code_point = 0xC5E2; break; // HANGUL SYLLABLE IEUNG E PIEUPSIOS
    case 0x9E78: code_point = 0xC5E4; break; // HANGUL SYLLABLE IEUNG E SSANGSIOS
    case 0x9E79: code_point = 0xC5E6; break; // HANGUL SYLLABLE IEUNG E CIEUC
    case 0x9E7A: code_point = 0xC5E7; break; // HANGUL SYLLABLE IEUNG E CHIEUCH
    case 0x9E81: code_point = 0xC5E8; break; // HANGUL SYLLABLE IEUNG E KHIEUKH
    case 0x9E82: code_point = 0xC5E9; break; // HANGUL SYLLABLE IEUNG E THIEUTH
    case 0x9E83: code_point = 0xC5EA; break; // HANGUL SYLLABLE IEUNG E PHIEUPH
    case 0x9E84: code_point = 0xC5EB; break; // HANGUL SYLLABLE IEUNG E HIEUH
    case 0x9E85: code_point = 0xC5EF; break; // HANGUL SYLLABLE IEUNG YEO KIYEOKSIOS
    case 0x9E86: code_point = 0xC5F1; break; // HANGUL SYLLABLE IEUNG YEO NIEUNCIEUC
    case 0x9E87: code_point = 0xC5F2; break; // HANGUL SYLLABLE IEUNG YEO NIEUNHIEUH
    case 0x9E88: code_point = 0xC5F3; break; // HANGUL SYLLABLE IEUNG YEO TIKEUT
    case 0x9E89: code_point = 0xC5F5; break; // HANGUL SYLLABLE IEUNG YEO RIEULKIYEOK
    case 0x9E8A: code_point = 0xC5F8; break; // HANGUL SYLLABLE IEUNG YEO RIEULSIOS
    case 0x9E8B: code_point = 0xC5F9; break; // HANGUL SYLLABLE IEUNG YEO RIEULTHIEUTH
    case 0x9E8C: code_point = 0xC5FA; break; // HANGUL SYLLABLE IEUNG YEO RIEULPHIEUPH
    case 0x9E8D: code_point = 0xC5FB; break; // HANGUL SYLLABLE IEUNG YEO RIEULHIEUH
    case 0x9E8E: code_point = 0xC602; break; // HANGUL SYLLABLE IEUNG YEO CIEUC
    case 0x9E8F: code_point = 0xC603; break; // HANGUL SYLLABLE IEUNG YEO CHIEUCH
    case 0x9E90: code_point = 0xC604; break; // HANGUL SYLLABLE IEUNG YEO KHIEUKH
    case 0x9E91: code_point = 0xC609; break; // HANGUL SYLLABLE IEUNG YE KIYEOK
    case 0x9E92: code_point = 0xC60A; break; // HANGUL SYLLABLE IEUNG YE SSANGKIYEOK
    case 0x9E93: code_point = 0xC60B; break; // HANGUL SYLLABLE IEUNG YE KIYEOKSIOS
    case 0x9E94: code_point = 0xC60D; break; // HANGUL SYLLABLE IEUNG YE NIEUNCIEUC
    case 0x9E95: code_point = 0xC60E; break; // HANGUL SYLLABLE IEUNG YE NIEUNHIEUH
    case 0x9E96: code_point = 0xC60F; break; // HANGUL SYLLABLE IEUNG YE TIKEUT
    case 0x9E97: code_point = 0xC611; break; // HANGUL SYLLABLE IEUNG YE RIEULKIYEOK
    case 0x9E98: code_point = 0xC612; break; // HANGUL SYLLABLE IEUNG YE RIEULMIEUM
    case 0x9E99: code_point = 0xC613; break; // HANGUL SYLLABLE IEUNG YE RIEULPIEUP
    case 0x9E9A: code_point = 0xC614; break; // HANGUL SYLLABLE IEUNG YE RIEULSIOS
    case 0x9E9B: code_point = 0xC615; break; // HANGUL SYLLABLE IEUNG YE RIEULTHIEUTH
    case 0x9E9C: code_point = 0xC616; break; // HANGUL SYLLABLE IEUNG YE RIEULPHIEUPH
    case 0x9E9D: code_point = 0xC617; break; // HANGUL SYLLABLE IEUNG YE RIEULHIEUH
    case 0x9E9E: code_point = 0xC61A; break; // HANGUL SYLLABLE IEUNG YE PIEUPSIOS
    case 0x9E9F: code_point = 0xC61D; break; // HANGUL SYLLABLE IEUNG YE IEUNG
    case 0x9EA0: code_point = 0xC61E; break; // HANGUL SYLLABLE IEUNG YE CIEUC
    case 0x9EA1: code_point = 0xC61F; break; // HANGUL SYLLABLE IEUNG YE CHIEUCH
    case 0x9EA2: code_point = 0xC620; break; // HANGUL SYLLABLE IEUNG YE KHIEUKH
    case 0x9EA3: code_point = 0xC621; break; // HANGUL SYLLABLE IEUNG YE THIEUTH
    case 0x9EA4: code_point = 0xC622; break; // HANGUL SYLLABLE IEUNG YE PHIEUPH
    case 0x9EA5: code_point = 0xC623; break; // HANGUL SYLLABLE IEUNG YE HIEUH
    case 0x9EA6: code_point = 0xC626; break; // HANGUL SYLLABLE IEUNG O SSANGKIYEOK
    case 0x9EA7: code_point = 0xC627; break; // HANGUL SYLLABLE IEUNG O KIYEOKSIOS
    case 0x9EA8: code_point = 0xC629; break; // HANGUL SYLLABLE IEUNG O NIEUNCIEUC
    case 0x9EA9: code_point = 0xC62A; break; // HANGUL SYLLABLE IEUNG O NIEUNHIEUH
    case 0x9EAA: code_point = 0xC62B; break; // HANGUL SYLLABLE IEUNG O TIKEUT
    case 0x9EAB: code_point = 0xC62F; break; // HANGUL SYLLABLE IEUNG O RIEULPIEUP
    case 0x9EAC: code_point = 0xC631; break; // HANGUL SYLLABLE IEUNG O RIEULTHIEUTH
    case 0x9EAD: code_point = 0xC632; break; // HANGUL SYLLABLE IEUNG O RIEULPHIEUPH
    case 0x9EAE: code_point = 0xC636; break; // HANGUL SYLLABLE IEUNG O PIEUPSIOS
    case 0x9EAF: code_point = 0xC638; break; // HANGUL SYLLABLE IEUNG O SSANGSIOS
    case 0x9EB0: code_point = 0xC63A; break; // HANGUL SYLLABLE IEUNG O CIEUC
    case 0x9EB1: code_point = 0xC63C; break; // HANGUL SYLLABLE IEUNG O KHIEUKH
    case 0x9EB2: code_point = 0xC63D; break; // HANGUL SYLLABLE IEUNG O THIEUTH
    case 0x9EB3: code_point = 0xC63E; break; // HANGUL SYLLABLE IEUNG O PHIEUPH
    case 0x9EB4: code_point = 0xC63F; break; // HANGUL SYLLABLE IEUNG O HIEUH
    case 0x9EB5: code_point = 0xC642; break; // HANGUL SYLLABLE IEUNG WA SSANGKIYEOK
    case 0x9EB6: code_point = 0xC643; break; // HANGUL SYLLABLE IEUNG WA KIYEOKSIOS
    case 0x9EB7: code_point = 0xC645; break; // HANGUL SYLLABLE IEUNG WA NIEUNCIEUC
    case 0x9EB8: code_point = 0xC646; break; // HANGUL SYLLABLE IEUNG WA NIEUNHIEUH
    case 0x9EB9: code_point = 0xC647; break; // HANGUL SYLLABLE IEUNG WA TIKEUT
    case 0x9EBA: code_point = 0xC649; break; // HANGUL SYLLABLE IEUNG WA RIEULKIYEOK
    case 0x9EBB: code_point = 0xC64A; break; // HANGUL SYLLABLE IEUNG WA RIEULMIEUM
    case 0x9EBC: code_point = 0xC64B; break; // HANGUL SYLLABLE IEUNG WA RIEULPIEUP
    case 0x9EBD: code_point = 0xC64C; break; // HANGUL SYLLABLE IEUNG WA RIEULSIOS
    case 0x9EBE: code_point = 0xC64D; break; // HANGUL SYLLABLE IEUNG WA RIEULTHIEUTH
    case 0x9EBF: code_point = 0xC64E; break; // HANGUL SYLLABLE IEUNG WA RIEULPHIEUPH
    case 0x9EC0: code_point = 0xC64F; break; // HANGUL SYLLABLE IEUNG WA RIEULHIEUH
    case 0x9EC1: code_point = 0xC652; break; // HANGUL SYLLABLE IEUNG WA PIEUPSIOS
    case 0x9EC2: code_point = 0xC656; break; // HANGUL SYLLABLE IEUNG WA CIEUC
    case 0x9EC3: code_point = 0xC657; break; // HANGUL SYLLABLE IEUNG WA CHIEUCH
    case 0x9EC4: code_point = 0xC658; break; // HANGUL SYLLABLE IEUNG WA KHIEUKH
    case 0x9EC5: code_point = 0xC659; break; // HANGUL SYLLABLE IEUNG WA THIEUTH
    case 0x9EC6: code_point = 0xC65A; break; // HANGUL SYLLABLE IEUNG WA PHIEUPH
    case 0x9EC7: code_point = 0xC65B; break; // HANGUL SYLLABLE IEUNG WA HIEUH
    case 0x9EC8: code_point = 0xC65E; break; // HANGUL SYLLABLE IEUNG WAE SSANGKIYEOK
    case 0x9EC9: code_point = 0xC65F; break; // HANGUL SYLLABLE IEUNG WAE KIYEOKSIOS
    case 0x9ECA: code_point = 0xC661; break; // HANGUL SYLLABLE IEUNG WAE NIEUNCIEUC
    case 0x9ECB: code_point = 0xC662; break; // HANGUL SYLLABLE IEUNG WAE NIEUNHIEUH
    case 0x9ECC: code_point = 0xC663; break; // HANGUL SYLLABLE IEUNG WAE TIKEUT
    case 0x9ECD: code_point = 0xC664; break; // HANGUL SYLLABLE IEUNG WAE RIEUL
    case 0x9ECE: code_point = 0xC665; break; // HANGUL SYLLABLE IEUNG WAE RIEULKIYEOK
    case 0x9ECF: code_point = 0xC666; break; // HANGUL SYLLABLE IEUNG WAE RIEULMIEUM
    case 0x9ED0: code_point = 0xC667; break; // HANGUL SYLLABLE IEUNG WAE RIEULPIEUP
    case 0x9ED1: code_point = 0xC668; break; // HANGUL SYLLABLE IEUNG WAE RIEULSIOS
    case 0x9ED2: code_point = 0xC669; break; // HANGUL SYLLABLE IEUNG WAE RIEULTHIEUTH
    case 0x9ED3: code_point = 0xC66A; break; // HANGUL SYLLABLE IEUNG WAE RIEULPHIEUPH
    case 0x9ED4: code_point = 0xC66B; break; // HANGUL SYLLABLE IEUNG WAE RIEULHIEUH
    case 0x9ED5: code_point = 0xC66D; break; // HANGUL SYLLABLE IEUNG WAE PIEUP
    case 0x9ED6: code_point = 0xC66E; break; // HANGUL SYLLABLE IEUNG WAE PIEUPSIOS
    case 0x9ED7: code_point = 0xC670; break; // HANGUL SYLLABLE IEUNG WAE SSANGSIOS
    case 0x9ED8: code_point = 0xC672; break; // HANGUL SYLLABLE IEUNG WAE CIEUC
    case 0x9ED9: code_point = 0xC673; break; // HANGUL SYLLABLE IEUNG WAE CHIEUCH
    case 0x9EDA: code_point = 0xC674; break; // HANGUL SYLLABLE IEUNG WAE KHIEUKH
    case 0x9EDB: code_point = 0xC675; break; // HANGUL SYLLABLE IEUNG WAE THIEUTH
    case 0x9EDC: code_point = 0xC676; break; // HANGUL SYLLABLE IEUNG WAE PHIEUPH
    case 0x9EDD: code_point = 0xC677; break; // HANGUL SYLLABLE IEUNG WAE HIEUH
    case 0x9EDE: code_point = 0xC67A; break; // HANGUL SYLLABLE IEUNG OE SSANGKIYEOK
    case 0x9EDF: code_point = 0xC67B; break; // HANGUL SYLLABLE IEUNG OE KIYEOKSIOS
    case 0x9EE0: code_point = 0xC67D; break; // HANGUL SYLLABLE IEUNG OE NIEUNCIEUC
    case 0x9EE1: code_point = 0xC67E; break; // HANGUL SYLLABLE IEUNG OE NIEUNHIEUH
    case 0x9EE2: code_point = 0xC67F; break; // HANGUL SYLLABLE IEUNG OE TIKEUT
    case 0x9EE3: code_point = 0xC681; break; // HANGUL SYLLABLE IEUNG OE RIEULKIYEOK
    case 0x9EE4: code_point = 0xC682; break; // HANGUL SYLLABLE IEUNG OE RIEULMIEUM
    case 0x9EE5: code_point = 0xC683; break; // HANGUL SYLLABLE IEUNG OE RIEULPIEUP
    case 0x9EE6: code_point = 0xC684; break; // HANGUL SYLLABLE IEUNG OE RIEULSIOS
    case 0x9EE7: code_point = 0xC685; break; // HANGUL SYLLABLE IEUNG OE RIEULTHIEUTH
    case 0x9EE8: code_point = 0xC686; break; // HANGUL SYLLABLE IEUNG OE RIEULPHIEUPH
    case 0x9EE9: code_point = 0xC687; break; // HANGUL SYLLABLE IEUNG OE RIEULHIEUH
    case 0x9EEA: code_point = 0xC68A; break; // HANGUL SYLLABLE IEUNG OE PIEUPSIOS
    case 0x9EEB: code_point = 0xC68C; break; // HANGUL SYLLABLE IEUNG OE SSANGSIOS
    case 0x9EEC: code_point = 0xC68E; break; // HANGUL SYLLABLE IEUNG OE CIEUC
    case 0x9EED: code_point = 0xC68F; break; // HANGUL SYLLABLE IEUNG OE CHIEUCH
    case 0x9EEE: code_point = 0xC690; break; // HANGUL SYLLABLE IEUNG OE KHIEUKH
    case 0x9EEF: code_point = 0xC691; break; // HANGUL SYLLABLE IEUNG OE THIEUTH
    case 0x9EF0: code_point = 0xC692; break; // HANGUL SYLLABLE IEUNG OE PHIEUPH
    case 0x9EF1: code_point = 0xC693; break; // HANGUL SYLLABLE IEUNG OE HIEUH
    case 0x9EF2: code_point = 0xC696; break; // HANGUL SYLLABLE IEUNG YO SSANGKIYEOK
    case 0x9EF3: code_point = 0xC697; break; // HANGUL SYLLABLE IEUNG YO KIYEOKSIOS
    case 0x9EF4: code_point = 0xC699; break; // HANGUL SYLLABLE IEUNG YO NIEUNCIEUC
    case 0x9EF5: code_point = 0xC69A; break; // HANGUL SYLLABLE IEUNG YO NIEUNHIEUH
    case 0x9EF6: code_point = 0xC69B; break; // HANGUL SYLLABLE IEUNG YO TIKEUT
    case 0x9EF7: code_point = 0xC69D; break; // HANGUL SYLLABLE IEUNG YO RIEULKIYEOK
    case 0x9EF8: code_point = 0xC69E; break; // HANGUL SYLLABLE IEUNG YO RIEULMIEUM
    case 0x9EF9: code_point = 0xC69F; break; // HANGUL SYLLABLE IEUNG YO RIEULPIEUP
    case 0x9EFA: code_point = 0xC6A0; break; // HANGUL SYLLABLE IEUNG YO RIEULSIOS
    case 0x9EFB: code_point = 0xC6A1; break; // HANGUL SYLLABLE IEUNG YO RIEULTHIEUTH
    case 0x9EFC: code_point = 0xC6A2; break; // HANGUL SYLLABLE IEUNG YO RIEULPHIEUPH
    case 0x9EFD: code_point = 0xC6A3; break; // HANGUL SYLLABLE IEUNG YO RIEULHIEUH
    case 0x9EFE: code_point = 0xC6A6; break; // HANGUL SYLLABLE IEUNG YO PIEUPSIOS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0x9F(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0x9F41: code_point = 0xC6A8; break; // HANGUL SYLLABLE IEUNG YO SSANGSIOS
    case 0x9F42: code_point = 0xC6AA; break; // HANGUL SYLLABLE IEUNG YO CIEUC
    case 0x9F43: code_point = 0xC6AB; break; // HANGUL SYLLABLE IEUNG YO CHIEUCH
    case 0x9F44: code_point = 0xC6AC; break; // HANGUL SYLLABLE IEUNG YO KHIEUKH
    case 0x9F45: code_point = 0xC6AD; break; // HANGUL SYLLABLE IEUNG YO THIEUTH
    case 0x9F46: code_point = 0xC6AE; break; // HANGUL SYLLABLE IEUNG YO PHIEUPH
    case 0x9F47: code_point = 0xC6AF; break; // HANGUL SYLLABLE IEUNG YO HIEUH
    case 0x9F48: code_point = 0xC6B2; break; // HANGUL SYLLABLE IEUNG U SSANGKIYEOK
    case 0x9F49: code_point = 0xC6B3; break; // HANGUL SYLLABLE IEUNG U KIYEOKSIOS
    case 0x9F4A: code_point = 0xC6B5; break; // HANGUL SYLLABLE IEUNG U NIEUNCIEUC
    case 0x9F4B: code_point = 0xC6B6; break; // HANGUL SYLLABLE IEUNG U NIEUNHIEUH
    case 0x9F4C: code_point = 0xC6B7; break; // HANGUL SYLLABLE IEUNG U TIKEUT
    case 0x9F4D: code_point = 0xC6BB; break; // HANGUL SYLLABLE IEUNG U RIEULPIEUP
    case 0x9F4E: code_point = 0xC6BC; break; // HANGUL SYLLABLE IEUNG U RIEULSIOS
    case 0x9F4F: code_point = 0xC6BD; break; // HANGUL SYLLABLE IEUNG U RIEULTHIEUTH
    case 0x9F50: code_point = 0xC6BE; break; // HANGUL SYLLABLE IEUNG U RIEULPHIEUPH
    case 0x9F51: code_point = 0xC6BF; break; // HANGUL SYLLABLE IEUNG U RIEULHIEUH
    case 0x9F52: code_point = 0xC6C2; break; // HANGUL SYLLABLE IEUNG U PIEUPSIOS
    case 0x9F53: code_point = 0xC6C4; break; // HANGUL SYLLABLE IEUNG U SSANGSIOS
    case 0x9F54: code_point = 0xC6C6; break; // HANGUL SYLLABLE IEUNG U CIEUC
    case 0x9F55: code_point = 0xC6C7; break; // HANGUL SYLLABLE IEUNG U CHIEUCH
    case 0x9F56: code_point = 0xC6C8; break; // HANGUL SYLLABLE IEUNG U KHIEUKH
    case 0x9F57: code_point = 0xC6C9; break; // HANGUL SYLLABLE IEUNG U THIEUTH
    case 0x9F58: code_point = 0xC6CA; break; // HANGUL SYLLABLE IEUNG U PHIEUPH
    case 0x9F59: code_point = 0xC6CB; break; // HANGUL SYLLABLE IEUNG U HIEUH
    case 0x9F5A: code_point = 0xC6CE; break; // HANGUL SYLLABLE IEUNG WEO SSANGKIYEOK
    case 0x9F61: code_point = 0xC6CF; break; // HANGUL SYLLABLE IEUNG WEO KIYEOKSIOS
    case 0x9F62: code_point = 0xC6D1; break; // HANGUL SYLLABLE IEUNG WEO NIEUNCIEUC
    case 0x9F63: code_point = 0xC6D2; break; // HANGUL SYLLABLE IEUNG WEO NIEUNHIEUH
    case 0x9F64: code_point = 0xC6D3; break; // HANGUL SYLLABLE IEUNG WEO TIKEUT
    case 0x9F65: code_point = 0xC6D5; break; // HANGUL SYLLABLE IEUNG WEO RIEULKIYEOK
    case 0x9F66: code_point = 0xC6D6; break; // HANGUL SYLLABLE IEUNG WEO RIEULMIEUM
    case 0x9F67: code_point = 0xC6D7; break; // HANGUL SYLLABLE IEUNG WEO RIEULPIEUP
    case 0x9F68: code_point = 0xC6D8; break; // HANGUL SYLLABLE IEUNG WEO RIEULSIOS
    case 0x9F69: code_point = 0xC6D9; break; // HANGUL SYLLABLE IEUNG WEO RIEULTHIEUTH
    case 0x9F6A: code_point = 0xC6DA; break; // HANGUL SYLLABLE IEUNG WEO RIEULPHIEUPH
    case 0x9F6B: code_point = 0xC6DB; break; // HANGUL SYLLABLE IEUNG WEO RIEULHIEUH
    case 0x9F6C: code_point = 0xC6DE; break; // HANGUL SYLLABLE IEUNG WEO PIEUPSIOS
    case 0x9F6D: code_point = 0xC6DF; break; // HANGUL SYLLABLE IEUNG WEO SIOS
    case 0x9F6E: code_point = 0xC6E2; break; // HANGUL SYLLABLE IEUNG WEO CIEUC
    case 0x9F6F: code_point = 0xC6E3; break; // HANGUL SYLLABLE IEUNG WEO CHIEUCH
    case 0x9F70: code_point = 0xC6E4; break; // HANGUL SYLLABLE IEUNG WEO KHIEUKH
    case 0x9F71: code_point = 0xC6E5; break; // HANGUL SYLLABLE IEUNG WEO THIEUTH
    case 0x9F72: code_point = 0xC6E6; break; // HANGUL SYLLABLE IEUNG WEO PHIEUPH
    case 0x9F73: code_point = 0xC6E7; break; // HANGUL SYLLABLE IEUNG WEO HIEUH
    case 0x9F74: code_point = 0xC6EA; break; // HANGUL SYLLABLE IEUNG WE SSANGKIYEOK
    case 0x9F75: code_point = 0xC6EB; break; // HANGUL SYLLABLE IEUNG WE KIYEOKSIOS
    case 0x9F76: code_point = 0xC6ED; break; // HANGUL SYLLABLE IEUNG WE NIEUNCIEUC
    case 0x9F77: code_point = 0xC6EE; break; // HANGUL SYLLABLE IEUNG WE NIEUNHIEUH
    case 0x9F78: code_point = 0xC6EF; break; // HANGUL SYLLABLE IEUNG WE TIKEUT
    case 0x9F79: code_point = 0xC6F1; break; // HANGUL SYLLABLE IEUNG WE RIEULKIYEOK
    case 0x9F7A: code_point = 0xC6F2; break; // HANGUL SYLLABLE IEUNG WE RIEULMIEUM
    case 0x9F81: code_point = 0xC6F3; break; // HANGUL SYLLABLE IEUNG WE RIEULPIEUP
    case 0x9F82: code_point = 0xC6F4; break; // HANGUL SYLLABLE IEUNG WE RIEULSIOS
    case 0x9F83: code_point = 0xC6F5; break; // HANGUL SYLLABLE IEUNG WE RIEULTHIEUTH
    case 0x9F84: code_point = 0xC6F6; break; // HANGUL SYLLABLE IEUNG WE RIEULPHIEUPH
    case 0x9F85: code_point = 0xC6F7; break; // HANGUL SYLLABLE IEUNG WE RIEULHIEUH
    case 0x9F86: code_point = 0xC6FA; break; // HANGUL SYLLABLE IEUNG WE PIEUPSIOS
    case 0x9F87: code_point = 0xC6FB; break; // HANGUL SYLLABLE IEUNG WE SIOS
    case 0x9F88: code_point = 0xC6FC; break; // HANGUL SYLLABLE IEUNG WE SSANGSIOS
    case 0x9F89: code_point = 0xC6FE; break; // HANGUL SYLLABLE IEUNG WE CIEUC
    case 0x9F8A: code_point = 0xC6FF; break; // HANGUL SYLLABLE IEUNG WE CHIEUCH
    case 0x9F8B: code_point = 0xC700; break; // HANGUL SYLLABLE IEUNG WE KHIEUKH
    case 0x9F8C: code_point = 0xC701; break; // HANGUL SYLLABLE IEUNG WE THIEUTH
    case 0x9F8D: code_point = 0xC702; break; // HANGUL SYLLABLE IEUNG WE PHIEUPH
    case 0x9F8E: code_point = 0xC703; break; // HANGUL SYLLABLE IEUNG WE HIEUH
    case 0x9F8F: code_point = 0xC706; break; // HANGUL SYLLABLE IEUNG WI SSANGKIYEOK
    case 0x9F90: code_point = 0xC707; break; // HANGUL SYLLABLE IEUNG WI KIYEOKSIOS
    case 0x9F91: code_point = 0xC709; break; // HANGUL SYLLABLE IEUNG WI NIEUNCIEUC
    case 0x9F92: code_point = 0xC70A; break; // HANGUL SYLLABLE IEUNG WI NIEUNHIEUH
    case 0x9F93: code_point = 0xC70B; break; // HANGUL SYLLABLE IEUNG WI TIKEUT
    case 0x9F94: code_point = 0xC70D; break; // HANGUL SYLLABLE IEUNG WI RIEULKIYEOK
    case 0x9F95: code_point = 0xC70E; break; // HANGUL SYLLABLE IEUNG WI RIEULMIEUM
    case 0x9F96: code_point = 0xC70F; break; // HANGUL SYLLABLE IEUNG WI RIEULPIEUP
    case 0x9F97: code_point = 0xC710; break; // HANGUL SYLLABLE IEUNG WI RIEULSIOS
    case 0x9F98: code_point = 0xC711; break; // HANGUL SYLLABLE IEUNG WI RIEULTHIEUTH
    case 0x9F99: code_point = 0xC712; break; // HANGUL SYLLABLE IEUNG WI RIEULPHIEUPH
    case 0x9F9A: code_point = 0xC713; break; // HANGUL SYLLABLE IEUNG WI RIEULHIEUH
    case 0x9F9B: code_point = 0xC716; break; // HANGUL SYLLABLE IEUNG WI PIEUPSIOS
    case 0x9F9C: code_point = 0xC718; break; // HANGUL SYLLABLE IEUNG WI SSANGSIOS
    case 0x9F9D: code_point = 0xC71A; break; // HANGUL SYLLABLE IEUNG WI CIEUC
    case 0x9F9E: code_point = 0xC71B; break; // HANGUL SYLLABLE IEUNG WI CHIEUCH
    case 0x9F9F: code_point = 0xC71C; break; // HANGUL SYLLABLE IEUNG WI KHIEUKH
    case 0x9FA0: code_point = 0xC71D; break; // HANGUL SYLLABLE IEUNG WI THIEUTH
    case 0x9FA1: code_point = 0xC71E; break; // HANGUL SYLLABLE IEUNG WI PHIEUPH
    case 0x9FA2: code_point = 0xC71F; break; // HANGUL SYLLABLE IEUNG WI HIEUH
    case 0x9FA3: code_point = 0xC722; break; // HANGUL SYLLABLE IEUNG YU SSANGKIYEOK
    case 0x9FA4: code_point = 0xC723; break; // HANGUL SYLLABLE IEUNG YU KIYEOKSIOS
    case 0x9FA5: code_point = 0xC725; break; // HANGUL SYLLABLE IEUNG YU NIEUNCIEUC
    case 0x9FA6: code_point = 0xC726; break; // HANGUL SYLLABLE IEUNG YU NIEUNHIEUH
    case 0x9FA7: code_point = 0xC727; break; // HANGUL SYLLABLE IEUNG YU TIKEUT
    case 0x9FA8: code_point = 0xC729; break; // HANGUL SYLLABLE IEUNG YU RIEULKIYEOK
    case 0x9FA9: code_point = 0xC72A; break; // HANGUL SYLLABLE IEUNG YU RIEULMIEUM
    case 0x9FAA: code_point = 0xC72B; break; // HANGUL SYLLABLE IEUNG YU RIEULPIEUP
    case 0x9FAB: code_point = 0xC72C; break; // HANGUL SYLLABLE IEUNG YU RIEULSIOS
    case 0x9FAC: code_point = 0xC72D; break; // HANGUL SYLLABLE IEUNG YU RIEULTHIEUTH
    case 0x9FAD: code_point = 0xC72E; break; // HANGUL SYLLABLE IEUNG YU RIEULPHIEUPH
    case 0x9FAE: code_point = 0xC72F; break; // HANGUL SYLLABLE IEUNG YU RIEULHIEUH
    case 0x9FAF: code_point = 0xC732; break; // HANGUL SYLLABLE IEUNG YU PIEUPSIOS
    case 0x9FB0: code_point = 0xC734; break; // HANGUL SYLLABLE IEUNG YU SSANGSIOS
    case 0x9FB1: code_point = 0xC736; break; // HANGUL SYLLABLE IEUNG YU CIEUC
    case 0x9FB2: code_point = 0xC738; break; // HANGUL SYLLABLE IEUNG YU KHIEUKH
    case 0x9FB3: code_point = 0xC739; break; // HANGUL SYLLABLE IEUNG YU THIEUTH
    case 0x9FB4: code_point = 0xC73A; break; // HANGUL SYLLABLE IEUNG YU PHIEUPH
    case 0x9FB5: code_point = 0xC73B; break; // HANGUL SYLLABLE IEUNG YU HIEUH
    case 0x9FB6: code_point = 0xC73E; break; // HANGUL SYLLABLE IEUNG EU SSANGKIYEOK
    case 0x9FB7: code_point = 0xC73F; break; // HANGUL SYLLABLE IEUNG EU KIYEOKSIOS
    case 0x9FB8: code_point = 0xC741; break; // HANGUL SYLLABLE IEUNG EU NIEUNCIEUC
    case 0x9FB9: code_point = 0xC742; break; // HANGUL SYLLABLE IEUNG EU NIEUNHIEUH
    case 0x9FBA: code_point = 0xC743; break; // HANGUL SYLLABLE IEUNG EU TIKEUT
    case 0x9FBB: code_point = 0xC745; break; // HANGUL SYLLABLE IEUNG EU RIEULKIYEOK
    case 0x9FBC: code_point = 0xC746; break; // HANGUL SYLLABLE IEUNG EU RIEULMIEUM
    case 0x9FBD: code_point = 0xC747; break; // HANGUL SYLLABLE IEUNG EU RIEULPIEUP
    case 0x9FBE: code_point = 0xC748; break; // HANGUL SYLLABLE IEUNG EU RIEULSIOS
    case 0x9FBF: code_point = 0xC749; break; // HANGUL SYLLABLE IEUNG EU RIEULTHIEUTH
    case 0x9FC0: code_point = 0xC74B; break; // HANGUL SYLLABLE IEUNG EU RIEULHIEUH
    case 0x9FC1: code_point = 0xC74E; break; // HANGUL SYLLABLE IEUNG EU PIEUPSIOS
    case 0x9FC2: code_point = 0xC750; break; // HANGUL SYLLABLE IEUNG EU SSANGSIOS
    case 0x9FC3: code_point = 0xC759; break; // HANGUL SYLLABLE IEUNG YI KIYEOK
    case 0x9FC4: code_point = 0xC75A; break; // HANGUL SYLLABLE IEUNG YI SSANGKIYEOK
    case 0x9FC5: code_point = 0xC75B; break; // HANGUL SYLLABLE IEUNG YI KIYEOKSIOS
    case 0x9FC6: code_point = 0xC75D; break; // HANGUL SYLLABLE IEUNG YI NIEUNCIEUC
    case 0x9FC7: code_point = 0xC75E; break; // HANGUL SYLLABLE IEUNG YI NIEUNHIEUH
    case 0x9FC8: code_point = 0xC75F; break; // HANGUL SYLLABLE IEUNG YI TIKEUT
    case 0x9FC9: code_point = 0xC761; break; // HANGUL SYLLABLE IEUNG YI RIEULKIYEOK
    case 0x9FCA: code_point = 0xC762; break; // HANGUL SYLLABLE IEUNG YI RIEULMIEUM
    case 0x9FCB: code_point = 0xC763; break; // HANGUL SYLLABLE IEUNG YI RIEULPIEUP
    case 0x9FCC: code_point = 0xC764; break; // HANGUL SYLLABLE IEUNG YI RIEULSIOS
    case 0x9FCD: code_point = 0xC765; break; // HANGUL SYLLABLE IEUNG YI RIEULTHIEUTH
    case 0x9FCE: code_point = 0xC766; break; // HANGUL SYLLABLE IEUNG YI RIEULPHIEUPH
    case 0x9FCF: code_point = 0xC767; break; // HANGUL SYLLABLE IEUNG YI RIEULHIEUH
    case 0x9FD0: code_point = 0xC769; break; // HANGUL SYLLABLE IEUNG YI PIEUP
    case 0x9FD1: code_point = 0xC76A; break; // HANGUL SYLLABLE IEUNG YI PIEUPSIOS
    case 0x9FD2: code_point = 0xC76C; break; // HANGUL SYLLABLE IEUNG YI SSANGSIOS
    case 0x9FD3: code_point = 0xC76D; break; // HANGUL SYLLABLE IEUNG YI IEUNG
    case 0x9FD4: code_point = 0xC76E; break; // HANGUL SYLLABLE IEUNG YI CIEUC
    case 0x9FD5: code_point = 0xC76F; break; // HANGUL SYLLABLE IEUNG YI CHIEUCH
    case 0x9FD6: code_point = 0xC770; break; // HANGUL SYLLABLE IEUNG YI KHIEUKH
    case 0x9FD7: code_point = 0xC771; break; // HANGUL SYLLABLE IEUNG YI THIEUTH
    case 0x9FD8: code_point = 0xC772; break; // HANGUL SYLLABLE IEUNG YI PHIEUPH
    case 0x9FD9: code_point = 0xC773; break; // HANGUL SYLLABLE IEUNG YI HIEUH
    case 0x9FDA: code_point = 0xC776; break; // HANGUL SYLLABLE IEUNG I SSANGKIYEOK
    case 0x9FDB: code_point = 0xC777; break; // HANGUL SYLLABLE IEUNG I KIYEOKSIOS
    case 0x9FDC: code_point = 0xC779; break; // HANGUL SYLLABLE IEUNG I NIEUNCIEUC
    case 0x9FDD: code_point = 0xC77A; break; // HANGUL SYLLABLE IEUNG I NIEUNHIEUH
    case 0x9FDE: code_point = 0xC77B; break; // HANGUL SYLLABLE IEUNG I TIKEUT
    case 0x9FDF: code_point = 0xC77F; break; // HANGUL SYLLABLE IEUNG I RIEULPIEUP
    case 0x9FE0: code_point = 0xC780; break; // HANGUL SYLLABLE IEUNG I RIEULSIOS
    case 0x9FE1: code_point = 0xC781; break; // HANGUL SYLLABLE IEUNG I RIEULTHIEUTH
    case 0x9FE2: code_point = 0xC782; break; // HANGUL SYLLABLE IEUNG I RIEULPHIEUPH
    case 0x9FE3: code_point = 0xC786; break; // HANGUL SYLLABLE IEUNG I PIEUPSIOS
    case 0x9FE4: code_point = 0xC78B; break; // HANGUL SYLLABLE IEUNG I CHIEUCH
    case 0x9FE5: code_point = 0xC78C; break; // HANGUL SYLLABLE IEUNG I KHIEUKH
    case 0x9FE6: code_point = 0xC78D; break; // HANGUL SYLLABLE IEUNG I THIEUTH
    case 0x9FE7: code_point = 0xC78F; break; // HANGUL SYLLABLE IEUNG I HIEUH
    case 0x9FE8: code_point = 0xC792; break; // HANGUL SYLLABLE CIEUC A SSANGKIYEOK
    case 0x9FE9: code_point = 0xC793; break; // HANGUL SYLLABLE CIEUC A KIYEOKSIOS
    case 0x9FEA: code_point = 0xC795; break; // HANGUL SYLLABLE CIEUC A NIEUNCIEUC
    case 0x9FEB: code_point = 0xC799; break; // HANGUL SYLLABLE CIEUC A RIEULKIYEOK
    case 0x9FEC: code_point = 0xC79B; break; // HANGUL SYLLABLE CIEUC A RIEULPIEUP
    case 0x9FED: code_point = 0xC79C; break; // HANGUL SYLLABLE CIEUC A RIEULSIOS
    case 0x9FEE: code_point = 0xC79D; break; // HANGUL SYLLABLE CIEUC A RIEULTHIEUTH
    case 0x9FEF: code_point = 0xC79E; break; // HANGUL SYLLABLE CIEUC A RIEULPHIEUPH
    case 0x9FF0: code_point = 0xC79F; break; // HANGUL SYLLABLE CIEUC A RIEULHIEUH
    case 0x9FF1: code_point = 0xC7A2; break; // HANGUL SYLLABLE CIEUC A PIEUPSIOS
    case 0x9FF2: code_point = 0xC7A7; break; // HANGUL SYLLABLE CIEUC A CHIEUCH
    case 0x9FF3: code_point = 0xC7A8; break; // HANGUL SYLLABLE CIEUC A KHIEUKH
    case 0x9FF4: code_point = 0xC7A9; break; // HANGUL SYLLABLE CIEUC A THIEUTH
    case 0x9FF5: code_point = 0xC7AA; break; // HANGUL SYLLABLE CIEUC A PHIEUPH
    case 0x9FF6: code_point = 0xC7AB; break; // HANGUL SYLLABLE CIEUC A HIEUH
    case 0x9FF7: code_point = 0xC7AE; break; // HANGUL SYLLABLE CIEUC AE SSANGKIYEOK
    case 0x9FF8: code_point = 0xC7AF; break; // HANGUL SYLLABLE CIEUC AE KIYEOKSIOS
    case 0x9FF9: code_point = 0xC7B1; break; // HANGUL SYLLABLE CIEUC AE NIEUNCIEUC
    case 0x9FFA: code_point = 0xC7B2; break; // HANGUL SYLLABLE CIEUC AE NIEUNHIEUH
    case 0x9FFB: code_point = 0xC7B3; break; // HANGUL SYLLABLE CIEUC AE TIKEUT
    case 0x9FFC: code_point = 0xC7B5; break; // HANGUL SYLLABLE CIEUC AE RIEULKIYEOK
    case 0x9FFD: code_point = 0xC7B6; break; // HANGUL SYLLABLE CIEUC AE RIEULMIEUM
    case 0x9FFE: code_point = 0xC7B7; break; // HANGUL SYLLABLE CIEUC AE RIEULPIEUP
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA0(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA041: code_point = 0xC7B8; break; // HANGUL SYLLABLE CIEUC AE RIEULSIOS
    case 0xA042: code_point = 0xC7B9; break; // HANGUL SYLLABLE CIEUC AE RIEULTHIEUTH
    case 0xA043: code_point = 0xC7BA; break; // HANGUL SYLLABLE CIEUC AE RIEULPHIEUPH
    case 0xA044: code_point = 0xC7BB; break; // HANGUL SYLLABLE CIEUC AE RIEULHIEUH
    case 0xA045: code_point = 0xC7BE; break; // HANGUL SYLLABLE CIEUC AE PIEUPSIOS
    case 0xA046: code_point = 0xC7C2; break; // HANGUL SYLLABLE CIEUC AE CIEUC
    case 0xA047: code_point = 0xC7C3; break; // HANGUL SYLLABLE CIEUC AE CHIEUCH
    case 0xA048: code_point = 0xC7C4; break; // HANGUL SYLLABLE CIEUC AE KHIEUKH
    case 0xA049: code_point = 0xC7C5; break; // HANGUL SYLLABLE CIEUC AE THIEUTH
    case 0xA04A: code_point = 0xC7C6; break; // HANGUL SYLLABLE CIEUC AE PHIEUPH
    case 0xA04B: code_point = 0xC7C7; break; // HANGUL SYLLABLE CIEUC AE HIEUH
    case 0xA04C: code_point = 0xC7CA; break; // HANGUL SYLLABLE CIEUC YA SSANGKIYEOK
    case 0xA04D: code_point = 0xC7CB; break; // HANGUL SYLLABLE CIEUC YA KIYEOKSIOS
    case 0xA04E: code_point = 0xC7CD; break; // HANGUL SYLLABLE CIEUC YA NIEUNCIEUC
    case 0xA04F: code_point = 0xC7CF; break; // HANGUL SYLLABLE CIEUC YA TIKEUT
    case 0xA050: code_point = 0xC7D1; break; // HANGUL SYLLABLE CIEUC YA RIEULKIYEOK
    case 0xA051: code_point = 0xC7D2; break; // HANGUL SYLLABLE CIEUC YA RIEULMIEUM
    case 0xA052: code_point = 0xC7D3; break; // HANGUL SYLLABLE CIEUC YA RIEULPIEUP
    case 0xA053: code_point = 0xC7D4; break; // HANGUL SYLLABLE CIEUC YA RIEULSIOS
    case 0xA054: code_point = 0xC7D5; break; // HANGUL SYLLABLE CIEUC YA RIEULTHIEUTH
    case 0xA055: code_point = 0xC7D6; break; // HANGUL SYLLABLE CIEUC YA RIEULPHIEUPH
    case 0xA056: code_point = 0xC7D7; break; // HANGUL SYLLABLE CIEUC YA RIEULHIEUH
    case 0xA057: code_point = 0xC7D9; break; // HANGUL SYLLABLE CIEUC YA PIEUP
    case 0xA058: code_point = 0xC7DA; break; // HANGUL SYLLABLE CIEUC YA PIEUPSIOS
    case 0xA059: code_point = 0xC7DB; break; // HANGUL SYLLABLE CIEUC YA SIOS
    case 0xA05A: code_point = 0xC7DC; break; // HANGUL SYLLABLE CIEUC YA SSANGSIOS
    case 0xA061: code_point = 0xC7DE; break; // HANGUL SYLLABLE CIEUC YA CIEUC
    case 0xA062: code_point = 0xC7DF; break; // HANGUL SYLLABLE CIEUC YA CHIEUCH
    case 0xA063: code_point = 0xC7E0; break; // HANGUL SYLLABLE CIEUC YA KHIEUKH
    case 0xA064: code_point = 0xC7E1; break; // HANGUL SYLLABLE CIEUC YA THIEUTH
    case 0xA065: code_point = 0xC7E2; break; // HANGUL SYLLABLE CIEUC YA PHIEUPH
    case 0xA066: code_point = 0xC7E3; break; // HANGUL SYLLABLE CIEUC YA HIEUH
    case 0xA067: code_point = 0xC7E5; break; // HANGUL SYLLABLE CIEUC YAE KIYEOK
    case 0xA068: code_point = 0xC7E6; break; // HANGUL SYLLABLE CIEUC YAE SSANGKIYEOK
    case 0xA069: code_point = 0xC7E7; break; // HANGUL SYLLABLE CIEUC YAE KIYEOKSIOS
    case 0xA06A: code_point = 0xC7E9; break; // HANGUL SYLLABLE CIEUC YAE NIEUNCIEUC
    case 0xA06B: code_point = 0xC7EA; break; // HANGUL SYLLABLE CIEUC YAE NIEUNHIEUH
    case 0xA06C: code_point = 0xC7EB; break; // HANGUL SYLLABLE CIEUC YAE TIKEUT
    case 0xA06D: code_point = 0xC7ED; break; // HANGUL SYLLABLE CIEUC YAE RIEULKIYEOK
    case 0xA06E: code_point = 0xC7EE; break; // HANGUL SYLLABLE CIEUC YAE RIEULMIEUM
    case 0xA06F: code_point = 0xC7EF; break; // HANGUL SYLLABLE CIEUC YAE RIEULPIEUP
    case 0xA070: code_point = 0xC7F0; break; // HANGUL SYLLABLE CIEUC YAE RIEULSIOS
    case 0xA071: code_point = 0xC7F1; break; // HANGUL SYLLABLE CIEUC YAE RIEULTHIEUTH
    case 0xA072: code_point = 0xC7F2; break; // HANGUL SYLLABLE CIEUC YAE RIEULPHIEUPH
    case 0xA073: code_point = 0xC7F3; break; // HANGUL SYLLABLE CIEUC YAE RIEULHIEUH
    case 0xA074: code_point = 0xC7F4; break; // HANGUL SYLLABLE CIEUC YAE MIEUM
    case 0xA075: code_point = 0xC7F5; break; // HANGUL SYLLABLE CIEUC YAE PIEUP
    case 0xA076: code_point = 0xC7F6; break; // HANGUL SYLLABLE CIEUC YAE PIEUPSIOS
    case 0xA077: code_point = 0xC7F7; break; // HANGUL SYLLABLE CIEUC YAE SIOS
    case 0xA078: code_point = 0xC7F8; break; // HANGUL SYLLABLE CIEUC YAE SSANGSIOS
    case 0xA079: code_point = 0xC7F9; break; // HANGUL SYLLABLE CIEUC YAE IEUNG
    case 0xA07A: code_point = 0xC7FA; break; // HANGUL SYLLABLE CIEUC YAE CIEUC
    case 0xA081: code_point = 0xC7FB; break; // HANGUL SYLLABLE CIEUC YAE CHIEUCH
    case 0xA082: code_point = 0xC7FC; break; // HANGUL SYLLABLE CIEUC YAE KHIEUKH
    case 0xA083: code_point = 0xC7FD; break; // HANGUL SYLLABLE CIEUC YAE THIEUTH
    case 0xA084: code_point = 0xC7FE; break; // HANGUL SYLLABLE CIEUC YAE PHIEUPH
    case 0xA085: code_point = 0xC7FF; break; // HANGUL SYLLABLE CIEUC YAE HIEUH
    case 0xA086: code_point = 0xC802; break; // HANGUL SYLLABLE CIEUC EO SSANGKIYEOK
    case 0xA087: code_point = 0xC803; break; // HANGUL SYLLABLE CIEUC EO KIYEOKSIOS
    case 0xA088: code_point = 0xC805; break; // HANGUL SYLLABLE CIEUC EO NIEUNCIEUC
    case 0xA089: code_point = 0xC806; break; // HANGUL SYLLABLE CIEUC EO NIEUNHIEUH
    case 0xA08A: code_point = 0xC807; break; // HANGUL SYLLABLE CIEUC EO TIKEUT
    case 0xA08B: code_point = 0xC809; break; // HANGUL SYLLABLE CIEUC EO RIEULKIYEOK
    case 0xA08C: code_point = 0xC80B; break; // HANGUL SYLLABLE CIEUC EO RIEULPIEUP
    case 0xA08D: code_point = 0xC80C; break; // HANGUL SYLLABLE CIEUC EO RIEULSIOS
    case 0xA08E: code_point = 0xC80D; break; // HANGUL SYLLABLE CIEUC EO RIEULTHIEUTH
    case 0xA08F: code_point = 0xC80E; break; // HANGUL SYLLABLE CIEUC EO RIEULPHIEUPH
    case 0xA090: code_point = 0xC80F; break; // HANGUL SYLLABLE CIEUC EO RIEULHIEUH
    case 0xA091: code_point = 0xC812; break; // HANGUL SYLLABLE CIEUC EO PIEUPSIOS
    case 0xA092: code_point = 0xC814; break; // HANGUL SYLLABLE CIEUC EO SSANGSIOS
    case 0xA093: code_point = 0xC817; break; // HANGUL SYLLABLE CIEUC EO CHIEUCH
    case 0xA094: code_point = 0xC818; break; // HANGUL SYLLABLE CIEUC EO KHIEUKH
    case 0xA095: code_point = 0xC819; break; // HANGUL SYLLABLE CIEUC EO THIEUTH
    case 0xA096: code_point = 0xC81A; break; // HANGUL SYLLABLE CIEUC EO PHIEUPH
    case 0xA097: code_point = 0xC81B; break; // HANGUL SYLLABLE CIEUC EO HIEUH
    case 0xA098: code_point = 0xC81E; break; // HANGUL SYLLABLE CIEUC E SSANGKIYEOK
    case 0xA099: code_point = 0xC81F; break; // HANGUL SYLLABLE CIEUC E KIYEOKSIOS
    case 0xA09A: code_point = 0xC821; break; // HANGUL SYLLABLE CIEUC E NIEUNCIEUC
    case 0xA09B: code_point = 0xC822; break; // HANGUL SYLLABLE CIEUC E NIEUNHIEUH
    case 0xA09C: code_point = 0xC823; break; // HANGUL SYLLABLE CIEUC E TIKEUT
    case 0xA09D: code_point = 0xC825; break; // HANGUL SYLLABLE CIEUC E RIEULKIYEOK
    case 0xA09E: code_point = 0xC826; break; // HANGUL SYLLABLE CIEUC E RIEULMIEUM
    case 0xA09F: code_point = 0xC827; break; // HANGUL SYLLABLE CIEUC E RIEULPIEUP
    case 0xA0A0: code_point = 0xC828; break; // HANGUL SYLLABLE CIEUC E RIEULSIOS
    case 0xA0A1: code_point = 0xC829; break; // HANGUL SYLLABLE CIEUC E RIEULTHIEUTH
    case 0xA0A2: code_point = 0xC82A; break; // HANGUL SYLLABLE CIEUC E RIEULPHIEUPH
    case 0xA0A3: code_point = 0xC82B; break; // HANGUL SYLLABLE CIEUC E RIEULHIEUH
    case 0xA0A4: code_point = 0xC82E; break; // HANGUL SYLLABLE CIEUC E PIEUPSIOS
    case 0xA0A5: code_point = 0xC830; break; // HANGUL SYLLABLE CIEUC E SSANGSIOS
    case 0xA0A6: code_point = 0xC832; break; // HANGUL SYLLABLE CIEUC E CIEUC
    case 0xA0A7: code_point = 0xC833; break; // HANGUL SYLLABLE CIEUC E CHIEUCH
    case 0xA0A8: code_point = 0xC834; break; // HANGUL SYLLABLE CIEUC E KHIEUKH
    case 0xA0A9: code_point = 0xC835; break; // HANGUL SYLLABLE CIEUC E THIEUTH
    case 0xA0AA: code_point = 0xC836; break; // HANGUL SYLLABLE CIEUC E PHIEUPH
    case 0xA0AB: code_point = 0xC837; break; // HANGUL SYLLABLE CIEUC E HIEUH
    case 0xA0AC: code_point = 0xC839; break; // HANGUL SYLLABLE CIEUC YEO KIYEOK
    case 0xA0AD: code_point = 0xC83A; break; // HANGUL SYLLABLE CIEUC YEO SSANGKIYEOK
    case 0xA0AE: code_point = 0xC83B; break; // HANGUL SYLLABLE CIEUC YEO KIYEOKSIOS
    case 0xA0AF: code_point = 0xC83D; break; // HANGUL SYLLABLE CIEUC YEO NIEUNCIEUC
    case 0xA0B0: code_point = 0xC83E; break; // HANGUL SYLLABLE CIEUC YEO NIEUNHIEUH
    case 0xA0B1: code_point = 0xC83F; break; // HANGUL SYLLABLE CIEUC YEO TIKEUT
    case 0xA0B2: code_point = 0xC841; break; // HANGUL SYLLABLE CIEUC YEO RIEULKIYEOK
    case 0xA0B3: code_point = 0xC842; break; // HANGUL SYLLABLE CIEUC YEO RIEULMIEUM
    case 0xA0B4: code_point = 0xC843; break; // HANGUL SYLLABLE CIEUC YEO RIEULPIEUP
    case 0xA0B5: code_point = 0xC844; break; // HANGUL SYLLABLE CIEUC YEO RIEULSIOS
    case 0xA0B6: code_point = 0xC845; break; // HANGUL SYLLABLE CIEUC YEO RIEULTHIEUTH
    case 0xA0B7: code_point = 0xC846; break; // HANGUL SYLLABLE CIEUC YEO RIEULPHIEUPH
    case 0xA0B8: code_point = 0xC847; break; // HANGUL SYLLABLE CIEUC YEO RIEULHIEUH
    case 0xA0B9: code_point = 0xC84A; break; // HANGUL SYLLABLE CIEUC YEO PIEUPSIOS
    case 0xA0BA: code_point = 0xC84B; break; // HANGUL SYLLABLE CIEUC YEO SIOS
    case 0xA0BB: code_point = 0xC84E; break; // HANGUL SYLLABLE CIEUC YEO CIEUC
    case 0xA0BC: code_point = 0xC84F; break; // HANGUL SYLLABLE CIEUC YEO CHIEUCH
    case 0xA0BD: code_point = 0xC850; break; // HANGUL SYLLABLE CIEUC YEO KHIEUKH
    case 0xA0BE: code_point = 0xC851; break; // HANGUL SYLLABLE CIEUC YEO THIEUTH
    case 0xA0BF: code_point = 0xC852; break; // HANGUL SYLLABLE CIEUC YEO PHIEUPH
    case 0xA0C0: code_point = 0xC853; break; // HANGUL SYLLABLE CIEUC YEO HIEUH
    case 0xA0C1: code_point = 0xC855; break; // HANGUL SYLLABLE CIEUC YE KIYEOK
    case 0xA0C2: code_point = 0xC856; break; // HANGUL SYLLABLE CIEUC YE SSANGKIYEOK
    case 0xA0C3: code_point = 0xC857; break; // HANGUL SYLLABLE CIEUC YE KIYEOKSIOS
    case 0xA0C4: code_point = 0xC858; break; // HANGUL SYLLABLE CIEUC YE NIEUN
    case 0xA0C5: code_point = 0xC859; break; // HANGUL SYLLABLE CIEUC YE NIEUNCIEUC
    case 0xA0C6: code_point = 0xC85A; break; // HANGUL SYLLABLE CIEUC YE NIEUNHIEUH
    case 0xA0C7: code_point = 0xC85B; break; // HANGUL SYLLABLE CIEUC YE TIKEUT
    case 0xA0C8: code_point = 0xC85C; break; // HANGUL SYLLABLE CIEUC YE RIEUL
    case 0xA0C9: code_point = 0xC85D; break; // HANGUL SYLLABLE CIEUC YE RIEULKIYEOK
    case 0xA0CA: code_point = 0xC85E; break; // HANGUL SYLLABLE CIEUC YE RIEULMIEUM
    case 0xA0CB: code_point = 0xC85F; break; // HANGUL SYLLABLE CIEUC YE RIEULPIEUP
    case 0xA0CC: code_point = 0xC860; break; // HANGUL SYLLABLE CIEUC YE RIEULSIOS
    case 0xA0CD: code_point = 0xC861; break; // HANGUL SYLLABLE CIEUC YE RIEULTHIEUTH
    case 0xA0CE: code_point = 0xC862; break; // HANGUL SYLLABLE CIEUC YE RIEULPHIEUPH
    case 0xA0CF: code_point = 0xC863; break; // HANGUL SYLLABLE CIEUC YE RIEULHIEUH
    case 0xA0D0: code_point = 0xC864; break; // HANGUL SYLLABLE CIEUC YE MIEUM
    case 0xA0D1: code_point = 0xC865; break; // HANGUL SYLLABLE CIEUC YE PIEUP
    case 0xA0D2: code_point = 0xC866; break; // HANGUL SYLLABLE CIEUC YE PIEUPSIOS
    case 0xA0D3: code_point = 0xC867; break; // HANGUL SYLLABLE CIEUC YE SIOS
    case 0xA0D4: code_point = 0xC868; break; // HANGUL SYLLABLE CIEUC YE SSANGSIOS
    case 0xA0D5: code_point = 0xC869; break; // HANGUL SYLLABLE CIEUC YE IEUNG
    case 0xA0D6: code_point = 0xC86A; break; // HANGUL SYLLABLE CIEUC YE CIEUC
    case 0xA0D7: code_point = 0xC86B; break; // HANGUL SYLLABLE CIEUC YE CHIEUCH
    case 0xA0D8: code_point = 0xC86C; break; // HANGUL SYLLABLE CIEUC YE KHIEUKH
    case 0xA0D9: code_point = 0xC86D; break; // HANGUL SYLLABLE CIEUC YE THIEUTH
    case 0xA0DA: code_point = 0xC86E; break; // HANGUL SYLLABLE CIEUC YE PHIEUPH
    case 0xA0DB: code_point = 0xC86F; break; // HANGUL SYLLABLE CIEUC YE HIEUH
    case 0xA0DC: code_point = 0xC872; break; // HANGUL SYLLABLE CIEUC O SSANGKIYEOK
    case 0xA0DD: code_point = 0xC873; break; // HANGUL SYLLABLE CIEUC O KIYEOKSIOS
    case 0xA0DE: code_point = 0xC875; break; // HANGUL SYLLABLE CIEUC O NIEUNCIEUC
    case 0xA0DF: code_point = 0xC876; break; // HANGUL SYLLABLE CIEUC O NIEUNHIEUH
    case 0xA0E0: code_point = 0xC877; break; // HANGUL SYLLABLE CIEUC O TIKEUT
    case 0xA0E1: code_point = 0xC879; break; // HANGUL SYLLABLE CIEUC O RIEULKIYEOK
    case 0xA0E2: code_point = 0xC87B; break; // HANGUL SYLLABLE CIEUC O RIEULPIEUP
    case 0xA0E3: code_point = 0xC87C; break; // HANGUL SYLLABLE CIEUC O RIEULSIOS
    case 0xA0E4: code_point = 0xC87D; break; // HANGUL SYLLABLE CIEUC O RIEULTHIEUTH
    case 0xA0E5: code_point = 0xC87E; break; // HANGUL SYLLABLE CIEUC O RIEULPHIEUPH
    case 0xA0E6: code_point = 0xC87F; break; // HANGUL SYLLABLE CIEUC O RIEULHIEUH
    case 0xA0E7: code_point = 0xC882; break; // HANGUL SYLLABLE CIEUC O PIEUPSIOS
    case 0xA0E8: code_point = 0xC884; break; // HANGUL SYLLABLE CIEUC O SSANGSIOS
    case 0xA0E9: code_point = 0xC888; break; // HANGUL SYLLABLE CIEUC O KHIEUKH
    case 0xA0EA: code_point = 0xC889; break; // HANGUL SYLLABLE CIEUC O THIEUTH
    case 0xA0EB: code_point = 0xC88A; break; // HANGUL SYLLABLE CIEUC O PHIEUPH
    case 0xA0EC: code_point = 0xC88E; break; // HANGUL SYLLABLE CIEUC WA SSANGKIYEOK
    case 0xA0ED: code_point = 0xC88F; break; // HANGUL SYLLABLE CIEUC WA KIYEOKSIOS
    case 0xA0EE: code_point = 0xC890; break; // HANGUL SYLLABLE CIEUC WA NIEUN
    case 0xA0EF: code_point = 0xC891; break; // HANGUL SYLLABLE CIEUC WA NIEUNCIEUC
    case 0xA0F0: code_point = 0xC892; break; // HANGUL SYLLABLE CIEUC WA NIEUNHIEUH
    case 0xA0F1: code_point = 0xC893; break; // HANGUL SYLLABLE CIEUC WA TIKEUT
    case 0xA0F2: code_point = 0xC895; break; // HANGUL SYLLABLE CIEUC WA RIEULKIYEOK
    case 0xA0F3: code_point = 0xC896; break; // HANGUL SYLLABLE CIEUC WA RIEULMIEUM
    case 0xA0F4: code_point = 0xC897; break; // HANGUL SYLLABLE CIEUC WA RIEULPIEUP
    case 0xA0F5: code_point = 0xC898; break; // HANGUL SYLLABLE CIEUC WA RIEULSIOS
    case 0xA0F6: code_point = 0xC899; break; // HANGUL SYLLABLE CIEUC WA RIEULTHIEUTH
    case 0xA0F7: code_point = 0xC89A; break; // HANGUL SYLLABLE CIEUC WA RIEULPHIEUPH
    case 0xA0F8: code_point = 0xC89B; break; // HANGUL SYLLABLE CIEUC WA RIEULHIEUH
    case 0xA0F9: code_point = 0xC89C; break; // HANGUL SYLLABLE CIEUC WA MIEUM
    case 0xA0FA: code_point = 0xC89E; break; // HANGUL SYLLABLE CIEUC WA PIEUPSIOS
    case 0xA0FB: code_point = 0xC8A0; break; // HANGUL SYLLABLE CIEUC WA SSANGSIOS
    case 0xA0FC: code_point = 0xC8A2; break; // HANGUL SYLLABLE CIEUC WA CIEUC
    case 0xA0FD: code_point = 0xC8A3; break; // HANGUL SYLLABLE CIEUC WA CHIEUCH
    case 0xA0FE: code_point = 0xC8A4; break; // HANGUL SYLLABLE CIEUC WA KHIEUKH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA1(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA141: code_point = 0xC8A5; break; // HANGUL SYLLABLE CIEUC WA THIEUTH
    case 0xA142: code_point = 0xC8A6; break; // HANGUL SYLLABLE CIEUC WA PHIEUPH
    case 0xA143: code_point = 0xC8A7; break; // HANGUL SYLLABLE CIEUC WA HIEUH
    case 0xA144: code_point = 0xC8A9; break; // HANGUL SYLLABLE CIEUC WAE KIYEOK
    case 0xA145: code_point = 0xC8AA; break; // HANGUL SYLLABLE CIEUC WAE SSANGKIYEOK
    case 0xA146: code_point = 0xC8AB; break; // HANGUL SYLLABLE CIEUC WAE KIYEOKSIOS
    case 0xA147: code_point = 0xC8AC; break; // HANGUL SYLLABLE CIEUC WAE NIEUN
    case 0xA148: code_point = 0xC8AD; break; // HANGUL SYLLABLE CIEUC WAE NIEUNCIEUC
    case 0xA149: code_point = 0xC8AE; break; // HANGUL SYLLABLE CIEUC WAE NIEUNHIEUH
    case 0xA14A: code_point = 0xC8AF; break; // HANGUL SYLLABLE CIEUC WAE TIKEUT
    case 0xA14B: code_point = 0xC8B0; break; // HANGUL SYLLABLE CIEUC WAE RIEUL
    case 0xA14C: code_point = 0xC8B1; break; // HANGUL SYLLABLE CIEUC WAE RIEULKIYEOK
    case 0xA14D: code_point = 0xC8B2; break; // HANGUL SYLLABLE CIEUC WAE RIEULMIEUM
    case 0xA14E: code_point = 0xC8B3; break; // HANGUL SYLLABLE CIEUC WAE RIEULPIEUP
    case 0xA14F: code_point = 0xC8B4; break; // HANGUL SYLLABLE CIEUC WAE RIEULSIOS
    case 0xA150: code_point = 0xC8B5; break; // HANGUL SYLLABLE CIEUC WAE RIEULTHIEUTH
    case 0xA151: code_point = 0xC8B6; break; // HANGUL SYLLABLE CIEUC WAE RIEULPHIEUPH
    case 0xA152: code_point = 0xC8B7; break; // HANGUL SYLLABLE CIEUC WAE RIEULHIEUH
    case 0xA153: code_point = 0xC8B8; break; // HANGUL SYLLABLE CIEUC WAE MIEUM
    case 0xA154: code_point = 0xC8B9; break; // HANGUL SYLLABLE CIEUC WAE PIEUP
    case 0xA155: code_point = 0xC8BA; break; // HANGUL SYLLABLE CIEUC WAE PIEUPSIOS
    case 0xA156: code_point = 0xC8BB; break; // HANGUL SYLLABLE CIEUC WAE SIOS
    case 0xA157: code_point = 0xC8BE; break; // HANGUL SYLLABLE CIEUC WAE CIEUC
    case 0xA158: code_point = 0xC8BF; break; // HANGUL SYLLABLE CIEUC WAE CHIEUCH
    case 0xA159: code_point = 0xC8C0; break; // HANGUL SYLLABLE CIEUC WAE KHIEUKH
    case 0xA15A: code_point = 0xC8C1; break; // HANGUL SYLLABLE CIEUC WAE THIEUTH
    case 0xA161: code_point = 0xC8C2; break; // HANGUL SYLLABLE CIEUC WAE PHIEUPH
    case 0xA162: code_point = 0xC8C3; break; // HANGUL SYLLABLE CIEUC WAE HIEUH
    case 0xA163: code_point = 0xC8C5; break; // HANGUL SYLLABLE CIEUC OE KIYEOK
    case 0xA164: code_point = 0xC8C6; break; // HANGUL SYLLABLE CIEUC OE SSANGKIYEOK
    case 0xA165: code_point = 0xC8C7; break; // HANGUL SYLLABLE CIEUC OE KIYEOKSIOS
    case 0xA166: code_point = 0xC8C9; break; // HANGUL SYLLABLE CIEUC OE NIEUNCIEUC
    case 0xA167: code_point = 0xC8CA; break; // HANGUL SYLLABLE CIEUC OE NIEUNHIEUH
    case 0xA168: code_point = 0xC8CB; break; // HANGUL SYLLABLE CIEUC OE TIKEUT
    case 0xA169: code_point = 0xC8CD; break; // HANGUL SYLLABLE CIEUC OE RIEULKIYEOK
    case 0xA16A: code_point = 0xC8CE; break; // HANGUL SYLLABLE CIEUC OE RIEULMIEUM
    case 0xA16B: code_point = 0xC8CF; break; // HANGUL SYLLABLE CIEUC OE RIEULPIEUP
    case 0xA16C: code_point = 0xC8D0; break; // HANGUL SYLLABLE CIEUC OE RIEULSIOS
    case 0xA16D: code_point = 0xC8D1; break; // HANGUL SYLLABLE CIEUC OE RIEULTHIEUTH
    case 0xA16E: code_point = 0xC8D2; break; // HANGUL SYLLABLE CIEUC OE RIEULPHIEUPH
    case 0xA16F: code_point = 0xC8D3; break; // HANGUL SYLLABLE CIEUC OE RIEULHIEUH
    case 0xA170: code_point = 0xC8D6; break; // HANGUL SYLLABLE CIEUC OE PIEUPSIOS
    case 0xA171: code_point = 0xC8D8; break; // HANGUL SYLLABLE CIEUC OE SSANGSIOS
    case 0xA172: code_point = 0xC8DA; break; // HANGUL SYLLABLE CIEUC OE CIEUC
    case 0xA173: code_point = 0xC8DB; break; // HANGUL SYLLABLE CIEUC OE CHIEUCH
    case 0xA174: code_point = 0xC8DC; break; // HANGUL SYLLABLE CIEUC OE KHIEUKH
    case 0xA175: code_point = 0xC8DD; break; // HANGUL SYLLABLE CIEUC OE THIEUTH
    case 0xA176: code_point = 0xC8DE; break; // HANGUL SYLLABLE CIEUC OE PHIEUPH
    case 0xA177: code_point = 0xC8DF; break; // HANGUL SYLLABLE CIEUC OE HIEUH
    case 0xA178: code_point = 0xC8E2; break; // HANGUL SYLLABLE CIEUC YO SSANGKIYEOK
    case 0xA179: code_point = 0xC8E3; break; // HANGUL SYLLABLE CIEUC YO KIYEOKSIOS
    case 0xA17A: code_point = 0xC8E5; break; // HANGUL SYLLABLE CIEUC YO NIEUNCIEUC
    case 0xA181: code_point = 0xC8E6; break; // HANGUL SYLLABLE CIEUC YO NIEUNHIEUH
    case 0xA182: code_point = 0xC8E7; break; // HANGUL SYLLABLE CIEUC YO TIKEUT
    case 0xA183: code_point = 0xC8E8; break; // HANGUL SYLLABLE CIEUC YO RIEUL
    case 0xA184: code_point = 0xC8E9; break; // HANGUL SYLLABLE CIEUC YO RIEULKIYEOK
    case 0xA185: code_point = 0xC8EA; break; // HANGUL SYLLABLE CIEUC YO RIEULMIEUM
    case 0xA186: code_point = 0xC8EB; break; // HANGUL SYLLABLE CIEUC YO RIEULPIEUP
    case 0xA187: code_point = 0xC8EC; break; // HANGUL SYLLABLE CIEUC YO RIEULSIOS
    case 0xA188: code_point = 0xC8ED; break; // HANGUL SYLLABLE CIEUC YO RIEULTHIEUTH
    case 0xA189: code_point = 0xC8EE; break; // HANGUL SYLLABLE CIEUC YO RIEULPHIEUPH
    case 0xA18A: code_point = 0xC8EF; break; // HANGUL SYLLABLE CIEUC YO RIEULHIEUH
    case 0xA18B: code_point = 0xC8F0; break; // HANGUL SYLLABLE CIEUC YO MIEUM
    case 0xA18C: code_point = 0xC8F1; break; // HANGUL SYLLABLE CIEUC YO PIEUP
    case 0xA18D: code_point = 0xC8F2; break; // HANGUL SYLLABLE CIEUC YO PIEUPSIOS
    case 0xA18E: code_point = 0xC8F3; break; // HANGUL SYLLABLE CIEUC YO SIOS
    case 0xA18F: code_point = 0xC8F4; break; // HANGUL SYLLABLE CIEUC YO SSANGSIOS
    case 0xA190: code_point = 0xC8F6; break; // HANGUL SYLLABLE CIEUC YO CIEUC
    case 0xA191: code_point = 0xC8F7; break; // HANGUL SYLLABLE CIEUC YO CHIEUCH
    case 0xA192: code_point = 0xC8F8; break; // HANGUL SYLLABLE CIEUC YO KHIEUKH
    case 0xA193: code_point = 0xC8F9; break; // HANGUL SYLLABLE CIEUC YO THIEUTH
    case 0xA194: code_point = 0xC8FA; break; // HANGUL SYLLABLE CIEUC YO PHIEUPH
    case 0xA195: code_point = 0xC8FB; break; // HANGUL SYLLABLE CIEUC YO HIEUH
    case 0xA196: code_point = 0xC8FE; break; // HANGUL SYLLABLE CIEUC U SSANGKIYEOK
    case 0xA197: code_point = 0xC8FF; break; // HANGUL SYLLABLE CIEUC U KIYEOKSIOS
    case 0xA198: code_point = 0xC901; break; // HANGUL SYLLABLE CIEUC U NIEUNCIEUC
    case 0xA199: code_point = 0xC902; break; // HANGUL SYLLABLE CIEUC U NIEUNHIEUH
    case 0xA19A: code_point = 0xC903; break; // HANGUL SYLLABLE CIEUC U TIKEUT
    case 0xA19B: code_point = 0xC907; break; // HANGUL SYLLABLE CIEUC U RIEULPIEUP
    case 0xA19C: code_point = 0xC908; break; // HANGUL SYLLABLE CIEUC U RIEULSIOS
    case 0xA19D: code_point = 0xC909; break; // HANGUL SYLLABLE CIEUC U RIEULTHIEUTH
    case 0xA19E: code_point = 0xC90A; break; // HANGUL SYLLABLE CIEUC U RIEULPHIEUPH
    case 0xA19F: code_point = 0xC90B; break; // HANGUL SYLLABLE CIEUC U RIEULHIEUH
    case 0xA1A0: code_point = 0xC90E; break; // HANGUL SYLLABLE CIEUC U PIEUPSIOS
    case 0xA1A1: code_point = 0x3000; break; // IDEOGRAPHIC SPACE
    case 0xA1A2: code_point = 0x3001; break; // IDEOGRAPHIC COMMA
    case 0xA1A3: code_point = 0x3002; break; // IDEOGRAPHIC FULL STOP
    case 0xA1A4: code_point = 0x00B7; break; // MIDDLE DOT
    case 0xA1A5: code_point = 0x2025; break; // TWO DOT LEADER
    case 0xA1A6: code_point = 0x2026; break; // HORIZONTAL ELLIPSIS
    case 0xA1A7: code_point = 0x00A8; break; // DIAERESIS
    case 0xA1A8: code_point = 0x3003; break; // DITTO MARK
    case 0xA1A9: code_point = 0x00AD; break; // SOFT HYPHEN
    case 0xA1AA: code_point = 0x2015; break; // HORIZONTAL BAR
    case 0xA1AB: code_point = 0x2225; break; // PARALLEL TO
    case 0xA1AC: code_point = 0xFF3C; break; // FULLWIDTH REVERSE SOLIDUS
    case 0xA1AD: code_point = 0x223C; break; // TILDE OPERATOR
    case 0xA1AE: code_point = 0x2018; break; // LEFT SINGLE QUOTATION MARK
    case 0xA1AF: code_point = 0x2019; break; // RIGHT SINGLE QUOTATION MARK
    case 0xA1B0: code_point = 0x201C; break; // LEFT DOUBLE QUOTATION MARK
    case 0xA1B1: code_point = 0x201D; break; // RIGHT DOUBLE QUOTATION MARK
    case 0xA1B2: code_point = 0x3014; break; // LEFT TORTOISE SHELL BRACKET
    case 0xA1B3: code_point = 0x3015; break; // RIGHT TORTOISE SHELL BRACKET
    case 0xA1B4: code_point = 0x3008; break; // LEFT ANGLE BRACKET
    case 0xA1B5: code_point = 0x3009; break; // RIGHT ANGLE BRACKET
    case 0xA1B6: code_point = 0x300A; break; // LEFT DOUBLE ANGLE BRACKET
    case 0xA1B7: code_point = 0x300B; break; // RIGHT DOUBLE ANGLE BRACKET
    case 0xA1B8: code_point = 0x300C; break; // LEFT CORNER BRACKET
    case 0xA1B9: code_point = 0x300D; break; // RIGHT CORNER BRACKET
    case 0xA1BA: code_point = 0x300E; break; // LEFT WHITE CORNER BRACKET
    case 0xA1BB: code_point = 0x300F; break; // RIGHT WHITE CORNER BRACKET
    case 0xA1BC: code_point = 0x3010; break; // LEFT BLACK LENTICULAR BRACKET
    case 0xA1BD: code_point = 0x3011; break; // RIGHT BLACK LENTICULAR BRACKET
    case 0xA1BE: code_point = 0x00B1; break; // PLUS-MINUS SIGN
    case 0xA1BF: code_point = 0x00D7; break; // MULTIPLICATION SIGN
    case 0xA1C0: code_point = 0x00F7; break; // DIVISION SIGN
    case 0xA1C1: code_point = 0x2260; break; // NOT EQUAL TO
    case 0xA1C2: code_point = 0x2264; break; // LESS-THAN OR EQUAL TO
    case 0xA1C3: code_point = 0x2265; break; // GREATER-THAN OR EQUAL TO
    case 0xA1C4: code_point = 0x221E; break; // INFINITY
    case 0xA1C5: code_point = 0x2234; break; // THEREFORE
    case 0xA1C6: code_point = 0x00B0; break; // DEGREE SIGN
    case 0xA1C7: code_point = 0x2032; break; // PRIME
    case 0xA1C8: code_point = 0x2033; break; // DOUBLE PRIME
    case 0xA1C9: code_point = 0x2103; break; // DEGREE CELSIUS
    case 0xA1CA: code_point = 0x212B; break; // ANGSTROM SIGN
    case 0xA1CB: code_point = 0xFFE0; break; // FULLWIDTH CENT SIGN
    case 0xA1CC: code_point = 0xFFE1; break; // FULLWIDTH POUND SIGN
    case 0xA1CD: code_point = 0xFFE5; break; // FULLWIDTH YEN SIGN
    case 0xA1CE: code_point = 0x2642; break; // MALE SIGN
    case 0xA1CF: code_point = 0x2640; break; // FEMALE SIGN
    case 0xA1D0: code_point = 0x2220; break; // ANGLE
    case 0xA1D1: code_point = 0x22A5; break; // UP TACK
    case 0xA1D2: code_point = 0x2312; break; // ARC
    case 0xA1D3: code_point = 0x2202; break; // PARTIAL DIFFERENTIAL
    case 0xA1D4: code_point = 0x2207; break; // NABLA
    case 0xA1D5: code_point = 0x2261; break; // IDENTICAL TO
    case 0xA1D6: code_point = 0x2252; break; // APPROXIMATELY EQUAL TO OR THE IMAGE OF
    case 0xA1D7: code_point = 0x00A7; break; // SECTION SIGN
    case 0xA1D8: code_point = 0x203B; break; // REFERENCE MARK
    case 0xA1D9: code_point = 0x2606; break; // WHITE STAR
    case 0xA1DA: code_point = 0x2605; break; // BLACK STAR
    case 0xA1DB: code_point = 0x25CB; break; // WHITE CIRCLE
    case 0xA1DC: code_point = 0x25CF; break; // BLACK CIRCLE
    case 0xA1DD: code_point = 0x25CE; break; // BULLSEYE
    case 0xA1DE: code_point = 0x25C7; break; // WHITE DIAMOND
    case 0xA1DF: code_point = 0x25C6; break; // BLACK DIAMOND
    case 0xA1E0: code_point = 0x25A1; break; // WHITE SQUARE
    case 0xA1E1: code_point = 0x25A0; break; // BLACK SQUARE
    case 0xA1E2: code_point = 0x25B3; break; // WHITE UP-POINTING TRIANGLE
    case 0xA1E3: code_point = 0x25B2; break; // BLACK UP-POINTING TRIANGLE
    case 0xA1E4: code_point = 0x25BD; break; // WHITE DOWN-POINTING TRIANGLE
    case 0xA1E5: code_point = 0x25BC; break; // BLACK DOWN-POINTING TRIANGLE
    case 0xA1E6: code_point = 0x2192; break; // RIGHTWARDS ARROW
    case 0xA1E7: code_point = 0x2190; break; // LEFTWARDS ARROW
    case 0xA1E8: code_point = 0x2191; break; // UPWARDS ARROW
    case 0xA1E9: code_point = 0x2193; break; // DOWNWARDS ARROW
    case 0xA1EA: code_point = 0x2194; break; // LEFT RIGHT ARROW
    case 0xA1EB: code_point = 0x3013; break; // GETA MARK
    case 0xA1EC: code_point = 0x226A; break; // MUCH LESS-THAN
    case 0xA1ED: code_point = 0x226B; break; // MUCH GREATER-THAN
    case 0xA1EE: code_point = 0x221A; break; // SQUARE ROOT
    case 0xA1EF: code_point = 0x223D; break; // REVERSED TILDE
    case 0xA1F0: code_point = 0x221D; break; // PROPORTIONAL TO
    case 0xA1F1: code_point = 0x2235; break; // BECAUSE
    case 0xA1F2: code_point = 0x222B; break; // INTEGRAL
    case 0xA1F3: code_point = 0x222C; break; // DOUBLE INTEGRAL
    case 0xA1F4: code_point = 0x2208; break; // ELEMENT OF
    case 0xA1F5: code_point = 0x220B; break; // CONTAINS AS MEMBER
    case 0xA1F6: code_point = 0x2286; break; // SUBSET OF OR EQUAL TO
    case 0xA1F7: code_point = 0x2287; break; // SUPERSET OF OR EQUAL TO
    case 0xA1F8: code_point = 0x2282; break; // SUBSET OF
    case 0xA1F9: code_point = 0x2283; break; // SUPERSET OF
    case 0xA1FA: code_point = 0x222A; break; // UNION
    case 0xA1FB: code_point = 0x2229; break; // INTERSECTION
    case 0xA1FC: code_point = 0x2227; break; // LOGICAL AND
    case 0xA1FD: code_point = 0x2228; break; // LOGICAL OR
    case 0xA1FE: code_point = 0xFFE2; break; // FULLWIDTH NOT SIGN
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA2(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA241: code_point = 0xC910; break; // HANGUL SYLLABLE CIEUC U SSANGSIOS
    case 0xA242: code_point = 0xC912; break; // HANGUL SYLLABLE CIEUC U CIEUC
    case 0xA243: code_point = 0xC913; break; // HANGUL SYLLABLE CIEUC U CHIEUCH
    case 0xA244: code_point = 0xC914; break; // HANGUL SYLLABLE CIEUC U KHIEUKH
    case 0xA245: code_point = 0xC915; break; // HANGUL SYLLABLE CIEUC U THIEUTH
    case 0xA246: code_point = 0xC916; break; // HANGUL SYLLABLE CIEUC U PHIEUPH
    case 0xA247: code_point = 0xC917; break; // HANGUL SYLLABLE CIEUC U HIEUH
    case 0xA248: code_point = 0xC919; break; // HANGUL SYLLABLE CIEUC WEO KIYEOK
    case 0xA249: code_point = 0xC91A; break; // HANGUL SYLLABLE CIEUC WEO SSANGKIYEOK
    case 0xA24A: code_point = 0xC91B; break; // HANGUL SYLLABLE CIEUC WEO KIYEOKSIOS
    case 0xA24B: code_point = 0xC91C; break; // HANGUL SYLLABLE CIEUC WEO NIEUN
    case 0xA24C: code_point = 0xC91D; break; // HANGUL SYLLABLE CIEUC WEO NIEUNCIEUC
    case 0xA24D: code_point = 0xC91E; break; // HANGUL SYLLABLE CIEUC WEO NIEUNHIEUH
    case 0xA24E: code_point = 0xC91F; break; // HANGUL SYLLABLE CIEUC WEO TIKEUT
    case 0xA24F: code_point = 0xC920; break; // HANGUL SYLLABLE CIEUC WEO RIEUL
    case 0xA250: code_point = 0xC921; break; // HANGUL SYLLABLE CIEUC WEO RIEULKIYEOK
    case 0xA251: code_point = 0xC922; break; // HANGUL SYLLABLE CIEUC WEO RIEULMIEUM
    case 0xA252: code_point = 0xC923; break; // HANGUL SYLLABLE CIEUC WEO RIEULPIEUP
    case 0xA253: code_point = 0xC924; break; // HANGUL SYLLABLE CIEUC WEO RIEULSIOS
    case 0xA254: code_point = 0xC925; break; // HANGUL SYLLABLE CIEUC WEO RIEULTHIEUTH
    case 0xA255: code_point = 0xC926; break; // HANGUL SYLLABLE CIEUC WEO RIEULPHIEUPH
    case 0xA256: code_point = 0xC927; break; // HANGUL SYLLABLE CIEUC WEO RIEULHIEUH
    case 0xA257: code_point = 0xC928; break; // HANGUL SYLLABLE CIEUC WEO MIEUM
    case 0xA258: code_point = 0xC929; break; // HANGUL SYLLABLE CIEUC WEO PIEUP
    case 0xA259: code_point = 0xC92A; break; // HANGUL SYLLABLE CIEUC WEO PIEUPSIOS
    case 0xA25A: code_point = 0xC92B; break; // HANGUL SYLLABLE CIEUC WEO SIOS
    case 0xA261: code_point = 0xC92D; break; // HANGUL SYLLABLE CIEUC WEO IEUNG
    case 0xA262: code_point = 0xC92E; break; // HANGUL SYLLABLE CIEUC WEO CIEUC
    case 0xA263: code_point = 0xC92F; break; // HANGUL SYLLABLE CIEUC WEO CHIEUCH
    case 0xA264: code_point = 0xC930; break; // HANGUL SYLLABLE CIEUC WEO KHIEUKH
    case 0xA265: code_point = 0xC931; break; // HANGUL SYLLABLE CIEUC WEO THIEUTH
    case 0xA266: code_point = 0xC932; break; // HANGUL SYLLABLE CIEUC WEO PHIEUPH
    case 0xA267: code_point = 0xC933; break; // HANGUL SYLLABLE CIEUC WEO HIEUH
    case 0xA268: code_point = 0xC935; break; // HANGUL SYLLABLE CIEUC WE KIYEOK
    case 0xA269: code_point = 0xC936; break; // HANGUL SYLLABLE CIEUC WE SSANGKIYEOK
    case 0xA26A: code_point = 0xC937; break; // HANGUL SYLLABLE CIEUC WE KIYEOKSIOS
    case 0xA26B: code_point = 0xC938; break; // HANGUL SYLLABLE CIEUC WE NIEUN
    case 0xA26C: code_point = 0xC939; break; // HANGUL SYLLABLE CIEUC WE NIEUNCIEUC
    case 0xA26D: code_point = 0xC93A; break; // HANGUL SYLLABLE CIEUC WE NIEUNHIEUH
    case 0xA26E: code_point = 0xC93B; break; // HANGUL SYLLABLE CIEUC WE TIKEUT
    case 0xA26F: code_point = 0xC93C; break; // HANGUL SYLLABLE CIEUC WE RIEUL
    case 0xA270: code_point = 0xC93D; break; // HANGUL SYLLABLE CIEUC WE RIEULKIYEOK
    case 0xA271: code_point = 0xC93E; break; // HANGUL SYLLABLE CIEUC WE RIEULMIEUM
    case 0xA272: code_point = 0xC93F; break; // HANGUL SYLLABLE CIEUC WE RIEULPIEUP
    case 0xA273: code_point = 0xC940; break; // HANGUL SYLLABLE CIEUC WE RIEULSIOS
    case 0xA274: code_point = 0xC941; break; // HANGUL SYLLABLE CIEUC WE RIEULTHIEUTH
    case 0xA275: code_point = 0xC942; break; // HANGUL SYLLABLE CIEUC WE RIEULPHIEUPH
    case 0xA276: code_point = 0xC943; break; // HANGUL SYLLABLE CIEUC WE RIEULHIEUH
    case 0xA277: code_point = 0xC944; break; // HANGUL SYLLABLE CIEUC WE MIEUM
    case 0xA278: code_point = 0xC945; break; // HANGUL SYLLABLE CIEUC WE PIEUP
    case 0xA279: code_point = 0xC946; break; // HANGUL SYLLABLE CIEUC WE PIEUPSIOS
    case 0xA27A: code_point = 0xC947; break; // HANGUL SYLLABLE CIEUC WE SIOS
    case 0xA281: code_point = 0xC948; break; // HANGUL SYLLABLE CIEUC WE SSANGSIOS
    case 0xA282: code_point = 0xC949; break; // HANGUL SYLLABLE CIEUC WE IEUNG
    case 0xA283: code_point = 0xC94A; break; // HANGUL SYLLABLE CIEUC WE CIEUC
    case 0xA284: code_point = 0xC94B; break; // HANGUL SYLLABLE CIEUC WE CHIEUCH
    case 0xA285: code_point = 0xC94C; break; // HANGUL SYLLABLE CIEUC WE KHIEUKH
    case 0xA286: code_point = 0xC94D; break; // HANGUL SYLLABLE CIEUC WE THIEUTH
    case 0xA287: code_point = 0xC94E; break; // HANGUL SYLLABLE CIEUC WE PHIEUPH
    case 0xA288: code_point = 0xC94F; break; // HANGUL SYLLABLE CIEUC WE HIEUH
    case 0xA289: code_point = 0xC952; break; // HANGUL SYLLABLE CIEUC WI SSANGKIYEOK
    case 0xA28A: code_point = 0xC953; break; // HANGUL SYLLABLE CIEUC WI KIYEOKSIOS
    case 0xA28B: code_point = 0xC955; break; // HANGUL SYLLABLE CIEUC WI NIEUNCIEUC
    case 0xA28C: code_point = 0xC956; break; // HANGUL SYLLABLE CIEUC WI NIEUNHIEUH
    case 0xA28D: code_point = 0xC957; break; // HANGUL SYLLABLE CIEUC WI TIKEUT
    case 0xA28E: code_point = 0xC959; break; // HANGUL SYLLABLE CIEUC WI RIEULKIYEOK
    case 0xA28F: code_point = 0xC95A; break; // HANGUL SYLLABLE CIEUC WI RIEULMIEUM
    case 0xA290: code_point = 0xC95B; break; // HANGUL SYLLABLE CIEUC WI RIEULPIEUP
    case 0xA291: code_point = 0xC95C; break; // HANGUL SYLLABLE CIEUC WI RIEULSIOS
    case 0xA292: code_point = 0xC95D; break; // HANGUL SYLLABLE CIEUC WI RIEULTHIEUTH
    case 0xA293: code_point = 0xC95E; break; // HANGUL SYLLABLE CIEUC WI RIEULPHIEUPH
    case 0xA294: code_point = 0xC95F; break; // HANGUL SYLLABLE CIEUC WI RIEULHIEUH
    case 0xA295: code_point = 0xC962; break; // HANGUL SYLLABLE CIEUC WI PIEUPSIOS
    case 0xA296: code_point = 0xC964; break; // HANGUL SYLLABLE CIEUC WI SSANGSIOS
    case 0xA297: code_point = 0xC965; break; // HANGUL SYLLABLE CIEUC WI IEUNG
    case 0xA298: code_point = 0xC966; break; // HANGUL SYLLABLE CIEUC WI CIEUC
    case 0xA299: code_point = 0xC967; break; // HANGUL SYLLABLE CIEUC WI CHIEUCH
    case 0xA29A: code_point = 0xC968; break; // HANGUL SYLLABLE CIEUC WI KHIEUKH
    case 0xA29B: code_point = 0xC969; break; // HANGUL SYLLABLE CIEUC WI THIEUTH
    case 0xA29C: code_point = 0xC96A; break; // HANGUL SYLLABLE CIEUC WI PHIEUPH
    case 0xA29D: code_point = 0xC96B; break; // HANGUL SYLLABLE CIEUC WI HIEUH
    case 0xA29E: code_point = 0xC96D; break; // HANGUL SYLLABLE CIEUC YU KIYEOK
    case 0xA29F: code_point = 0xC96E; break; // HANGUL SYLLABLE CIEUC YU SSANGKIYEOK
    case 0xA2A0: code_point = 0xC96F; break; // HANGUL SYLLABLE CIEUC YU KIYEOKSIOS
    case 0xA2A1: code_point = 0x21D2; break; // RIGHTWARDS DOUBLE ARROW
    case 0xA2A2: code_point = 0x21D4; break; // LEFT RIGHT DOUBLE ARROW
    case 0xA2A3: code_point = 0x2200; break; // FOR ALL
    case 0xA2A4: code_point = 0x2203; break; // THERE EXISTS
    case 0xA2A5: code_point = 0x00B4; break; // ACUTE ACCENT
    case 0xA2A6: code_point = 0xFF5E; break; // FULLWIDTH TILDE
    case 0xA2A7: code_point = 0x02C7; break; // CARON
    case 0xA2A8: code_point = 0x02D8; break; // BREVE
    case 0xA2A9: code_point = 0x02DD; break; // DOUBLE ACUTE ACCENT
    case 0xA2AA: code_point = 0x02DA; break; // RING ABOVE
    case 0xA2AB: code_point = 0x02D9; break; // DOT ABOVE
    case 0xA2AC: code_point = 0x00B8; break; // CEDILLA
    case 0xA2AD: code_point = 0x02DB; break; // OGONEK
    case 0xA2AE: code_point = 0x00A1; break; // INVERTED EXCLAMATION MARK
    case 0xA2AF: code_point = 0x00BF; break; // INVERTED QUESTION MARK
    case 0xA2B0: code_point = 0x02D0; break; // MODIFIER LETTER TRIANGULAR COLON
    case 0xA2B1: code_point = 0x222E; break; // CONTOUR INTEGRAL
    case 0xA2B2: code_point = 0x2211; break; // N-ARY SUMMATION
    case 0xA2B3: code_point = 0x220F; break; // N-ARY PRODUCT
    case 0xA2B4: code_point = 0x00A4; break; // CURRENCY SIGN
    case 0xA2B5: code_point = 0x2109; break; // DEGREE FAHRENHEIT
    case 0xA2B6: code_point = 0x2030; break; // PER MILLE SIGN
    case 0xA2B7: code_point = 0x25C1; break; // WHITE LEFT-POINTING TRIANGLE
    case 0xA2B8: code_point = 0x25C0; break; // BLACK LEFT-POINTING TRIANGLE
    case 0xA2B9: code_point = 0x25B7; break; // WHITE RIGHT-POINTING TRIANGLE
    case 0xA2BA: code_point = 0x25B6; break; // BLACK RIGHT-POINTING TRIANGLE
    case 0xA2BB: code_point = 0x2664; break; // WHITE SPADE SUIT
    case 0xA2BC: code_point = 0x2660; break; // BLACK SPADE SUIT
    case 0xA2BD: code_point = 0x2661; break; // WHITE HEART SUIT
    case 0xA2BE: code_point = 0x2665; break; // BLACK HEART SUIT
    case 0xA2BF: code_point = 0x2667; break; // WHITE CLUB SUIT
    case 0xA2C0: code_point = 0x2663; break; // BLACK CLUB SUIT
    case 0xA2C1: code_point = 0x2299; break; // CIRCLED DOT OPERATOR
    case 0xA2C2: code_point = 0x25C8; break; // WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
    case 0xA2C3: code_point = 0x25A3; break; // WHITE SQUARE CONTAINING BLACK SMALL SQUARE
    case 0xA2C4: code_point = 0x25D0; break; // CIRCLE WITH LEFT HALF BLACK
    case 0xA2C5: code_point = 0x25D1; break; // CIRCLE WITH RIGHT HALF BLACK
    case 0xA2C6: code_point = 0x2592; break; // MEDIUM SHADE
    case 0xA2C7: code_point = 0x25A4; break; // SQUARE WITH HORIZONTAL FILL
    case 0xA2C8: code_point = 0x25A5; break; // SQUARE WITH VERTICAL FILL
    case 0xA2C9: code_point = 0x25A8; break; // SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
    case 0xA2CA: code_point = 0x25A7; break; // SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
    case 0xA2CB: code_point = 0x25A6; break; // SQUARE WITH ORTHOGONAL CROSSHATCH FILL
    case 0xA2CC: code_point = 0x25A9; break; // SQUARE WITH DIAGONAL CROSSHATCH FILL
    case 0xA2CD: code_point = 0x2668; break; // HOT SPRINGS
    case 0xA2CE: code_point = 0x260F; break; // WHITE TELEPHONE
    case 0xA2CF: code_point = 0x260E; break; // BLACK TELEPHONE
    case 0xA2D0: code_point = 0x261C; break; // WHITE LEFT POINTING INDEX
    case 0xA2D1: code_point = 0x261E; break; // WHITE RIGHT POINTING INDEX
    case 0xA2D2: code_point = 0x00B6; break; // PILCROW SIGN
    case 0xA2D3: code_point = 0x2020; break; // DAGGER
    case 0xA2D4: code_point = 0x2021; break; // DOUBLE DAGGER
    case 0xA2D5: code_point = 0x2195; break; // UP DOWN ARROW
    case 0xA2D6: code_point = 0x2197; break; // NORTH EAST ARROW
    case 0xA2D7: code_point = 0x2199; break; // SOUTH WEST ARROW
    case 0xA2D8: code_point = 0x2196; break; // NORTH WEST ARROW
    case 0xA2D9: code_point = 0x2198; break; // SOUTH EAST ARROW
    case 0xA2DA: code_point = 0x266D; break; // MUSIC FLAT SIGN
    case 0xA2DB: code_point = 0x2669; break; // QUARTER NOTE
    case 0xA2DC: code_point = 0x266A; break; // EIGHTH NOTE
    case 0xA2DD: code_point = 0x266C; break; // BEAMED SIXTEENTH NOTES
    case 0xA2DE: code_point = 0x327F; break; // KOREAN STANDARD SYMBOL
    case 0xA2DF: code_point = 0x321C; break; // PARENTHESIZED HANGUL CIEUC U
    case 0xA2E0: code_point = 0x2116; break; // NUMERO SIGN
    case 0xA2E1: code_point = 0x33C7; break; // SQUARE CO
    case 0xA2E2: code_point = 0x2122; break; // TRADE MARK SIGN
    case 0xA2E3: code_point = 0x33C2; break; // SQUARE AM
    case 0xA2E4: code_point = 0x33D8; break; // SQUARE PM
    case 0xA2E5: code_point = 0x2121; break; // TELEPHONE SIGN
    case 0xA2E6: code_point = 0x20AC; break; // EURO SIGN
    case 0xA2E7: code_point = 0x00AE; break; // REGISTERED SIGN
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA3(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA341: code_point = 0xC971; break; // HANGUL SYLLABLE CIEUC YU NIEUNCIEUC
    case 0xA342: code_point = 0xC972; break; // HANGUL SYLLABLE CIEUC YU NIEUNHIEUH
    case 0xA343: code_point = 0xC973; break; // HANGUL SYLLABLE CIEUC YU TIKEUT
    case 0xA344: code_point = 0xC975; break; // HANGUL SYLLABLE CIEUC YU RIEULKIYEOK
    case 0xA345: code_point = 0xC976; break; // HANGUL SYLLABLE CIEUC YU RIEULMIEUM
    case 0xA346: code_point = 0xC977; break; // HANGUL SYLLABLE CIEUC YU RIEULPIEUP
    case 0xA347: code_point = 0xC978; break; // HANGUL SYLLABLE CIEUC YU RIEULSIOS
    case 0xA348: code_point = 0xC979; break; // HANGUL SYLLABLE CIEUC YU RIEULTHIEUTH
    case 0xA349: code_point = 0xC97A; break; // HANGUL SYLLABLE CIEUC YU RIEULPHIEUPH
    case 0xA34A: code_point = 0xC97B; break; // HANGUL SYLLABLE CIEUC YU RIEULHIEUH
    case 0xA34B: code_point = 0xC97D; break; // HANGUL SYLLABLE CIEUC YU PIEUP
    case 0xA34C: code_point = 0xC97E; break; // HANGUL SYLLABLE CIEUC YU PIEUPSIOS
    case 0xA34D: code_point = 0xC97F; break; // HANGUL SYLLABLE CIEUC YU SIOS
    case 0xA34E: code_point = 0xC980; break; // HANGUL SYLLABLE CIEUC YU SSANGSIOS
    case 0xA34F: code_point = 0xC981; break; // HANGUL SYLLABLE CIEUC YU IEUNG
    case 0xA350: code_point = 0xC982; break; // HANGUL SYLLABLE CIEUC YU CIEUC
    case 0xA351: code_point = 0xC983; break; // HANGUL SYLLABLE CIEUC YU CHIEUCH
    case 0xA352: code_point = 0xC984; break; // HANGUL SYLLABLE CIEUC YU KHIEUKH
    case 0xA353: code_point = 0xC985; break; // HANGUL SYLLABLE CIEUC YU THIEUTH
    case 0xA354: code_point = 0xC986; break; // HANGUL SYLLABLE CIEUC YU PHIEUPH
    case 0xA355: code_point = 0xC987; break; // HANGUL SYLLABLE CIEUC YU HIEUH
    case 0xA356: code_point = 0xC98A; break; // HANGUL SYLLABLE CIEUC EU SSANGKIYEOK
    case 0xA357: code_point = 0xC98B; break; // HANGUL SYLLABLE CIEUC EU KIYEOKSIOS
    case 0xA358: code_point = 0xC98D; break; // HANGUL SYLLABLE CIEUC EU NIEUNCIEUC
    case 0xA359: code_point = 0xC98E; break; // HANGUL SYLLABLE CIEUC EU NIEUNHIEUH
    case 0xA35A: code_point = 0xC98F; break; // HANGUL SYLLABLE CIEUC EU TIKEUT
    case 0xA361: code_point = 0xC991; break; // HANGUL SYLLABLE CIEUC EU RIEULKIYEOK
    case 0xA362: code_point = 0xC992; break; // HANGUL SYLLABLE CIEUC EU RIEULMIEUM
    case 0xA363: code_point = 0xC993; break; // HANGUL SYLLABLE CIEUC EU RIEULPIEUP
    case 0xA364: code_point = 0xC994; break; // HANGUL SYLLABLE CIEUC EU RIEULSIOS
    case 0xA365: code_point = 0xC995; break; // HANGUL SYLLABLE CIEUC EU RIEULTHIEUTH
    case 0xA366: code_point = 0xC996; break; // HANGUL SYLLABLE CIEUC EU RIEULPHIEUPH
    case 0xA367: code_point = 0xC997; break; // HANGUL SYLLABLE CIEUC EU RIEULHIEUH
    case 0xA368: code_point = 0xC99A; break; // HANGUL SYLLABLE CIEUC EU PIEUPSIOS
    case 0xA369: code_point = 0xC99C; break; // HANGUL SYLLABLE CIEUC EU SSANGSIOS
    case 0xA36A: code_point = 0xC99E; break; // HANGUL SYLLABLE CIEUC EU CIEUC
    case 0xA36B: code_point = 0xC99F; break; // HANGUL SYLLABLE CIEUC EU CHIEUCH
    case 0xA36C: code_point = 0xC9A0; break; // HANGUL SYLLABLE CIEUC EU KHIEUKH
    case 0xA36D: code_point = 0xC9A1; break; // HANGUL SYLLABLE CIEUC EU THIEUTH
    case 0xA36E: code_point = 0xC9A2; break; // HANGUL SYLLABLE CIEUC EU PHIEUPH
    case 0xA36F: code_point = 0xC9A3; break; // HANGUL SYLLABLE CIEUC EU HIEUH
    case 0xA370: code_point = 0xC9A4; break; // HANGUL SYLLABLE CIEUC YI
    case 0xA371: code_point = 0xC9A5; break; // HANGUL SYLLABLE CIEUC YI KIYEOK
    case 0xA372: code_point = 0xC9A6; break; // HANGUL SYLLABLE CIEUC YI SSANGKIYEOK
    case 0xA373: code_point = 0xC9A7; break; // HANGUL SYLLABLE CIEUC YI KIYEOKSIOS
    case 0xA374: code_point = 0xC9A8; break; // HANGUL SYLLABLE CIEUC YI NIEUN
    case 0xA375: code_point = 0xC9A9; break; // HANGUL SYLLABLE CIEUC YI NIEUNCIEUC
    case 0xA376: code_point = 0xC9AA; break; // HANGUL SYLLABLE CIEUC YI NIEUNHIEUH
    case 0xA377: code_point = 0xC9AB; break; // HANGUL SYLLABLE CIEUC YI TIKEUT
    case 0xA378: code_point = 0xC9AC; break; // HANGUL SYLLABLE CIEUC YI RIEUL
    case 0xA379: code_point = 0xC9AD; break; // HANGUL SYLLABLE CIEUC YI RIEULKIYEOK
    case 0xA37A: code_point = 0xC9AE; break; // HANGUL SYLLABLE CIEUC YI RIEULMIEUM
    case 0xA381: code_point = 0xC9AF; break; // HANGUL SYLLABLE CIEUC YI RIEULPIEUP
    case 0xA382: code_point = 0xC9B0; break; // HANGUL SYLLABLE CIEUC YI RIEULSIOS
    case 0xA383: code_point = 0xC9B1; break; // HANGUL SYLLABLE CIEUC YI RIEULTHIEUTH
    case 0xA384: code_point = 0xC9B2; break; // HANGUL SYLLABLE CIEUC YI RIEULPHIEUPH
    case 0xA385: code_point = 0xC9B3; break; // HANGUL SYLLABLE CIEUC YI RIEULHIEUH
    case 0xA386: code_point = 0xC9B4; break; // HANGUL SYLLABLE CIEUC YI MIEUM
    case 0xA387: code_point = 0xC9B5; break; // HANGUL SYLLABLE CIEUC YI PIEUP
    case 0xA388: code_point = 0xC9B6; break; // HANGUL SYLLABLE CIEUC YI PIEUPSIOS
    case 0xA389: code_point = 0xC9B7; break; // HANGUL SYLLABLE CIEUC YI SIOS
    case 0xA38A: code_point = 0xC9B8; break; // HANGUL SYLLABLE CIEUC YI SSANGSIOS
    case 0xA38B: code_point = 0xC9B9; break; // HANGUL SYLLABLE CIEUC YI IEUNG
    case 0xA38C: code_point = 0xC9BA; break; // HANGUL SYLLABLE CIEUC YI CIEUC
    case 0xA38D: code_point = 0xC9BB; break; // HANGUL SYLLABLE CIEUC YI CHIEUCH
    case 0xA38E: code_point = 0xC9BC; break; // HANGUL SYLLABLE CIEUC YI KHIEUKH
    case 0xA38F: code_point = 0xC9BD; break; // HANGUL SYLLABLE CIEUC YI THIEUTH
    case 0xA390: code_point = 0xC9BE; break; // HANGUL SYLLABLE CIEUC YI PHIEUPH
    case 0xA391: code_point = 0xC9BF; break; // HANGUL SYLLABLE CIEUC YI HIEUH
    case 0xA392: code_point = 0xC9C2; break; // HANGUL SYLLABLE CIEUC I SSANGKIYEOK
    case 0xA393: code_point = 0xC9C3; break; // HANGUL SYLLABLE CIEUC I KIYEOKSIOS
    case 0xA394: code_point = 0xC9C5; break; // HANGUL SYLLABLE CIEUC I NIEUNCIEUC
    case 0xA395: code_point = 0xC9C6; break; // HANGUL SYLLABLE CIEUC I NIEUNHIEUH
    case 0xA396: code_point = 0xC9C9; break; // HANGUL SYLLABLE CIEUC I RIEULKIYEOK
    case 0xA397: code_point = 0xC9CB; break; // HANGUL SYLLABLE CIEUC I RIEULPIEUP
    case 0xA398: code_point = 0xC9CC; break; // HANGUL SYLLABLE CIEUC I RIEULSIOS
    case 0xA399: code_point = 0xC9CD; break; // HANGUL SYLLABLE CIEUC I RIEULTHIEUTH
    case 0xA39A: code_point = 0xC9CE; break; // HANGUL SYLLABLE CIEUC I RIEULPHIEUPH
    case 0xA39B: code_point = 0xC9CF; break; // HANGUL SYLLABLE CIEUC I RIEULHIEUH
    case 0xA39C: code_point = 0xC9D2; break; // HANGUL SYLLABLE CIEUC I PIEUPSIOS
    case 0xA39D: code_point = 0xC9D4; break; // HANGUL SYLLABLE CIEUC I SSANGSIOS
    case 0xA39E: code_point = 0xC9D7; break; // HANGUL SYLLABLE CIEUC I CHIEUCH
    case 0xA39F: code_point = 0xC9D8; break; // HANGUL SYLLABLE CIEUC I KHIEUKH
    case 0xA3A0: code_point = 0xC9DB; break; // HANGUL SYLLABLE CIEUC I HIEUH
    case 0xA3A1: code_point = 0xFF01; break; // FULLWIDTH EXCLAMATION MARK
    case 0xA3A2: code_point = 0xFF02; break; // FULLWIDTH QUOTATION MARK
    case 0xA3A3: code_point = 0xFF03; break; // FULLWIDTH NUMBER SIGN
    case 0xA3A4: code_point = 0xFF04; break; // FULLWIDTH DOLLAR SIGN
    case 0xA3A5: code_point = 0xFF05; break; // FULLWIDTH PERCENT SIGN
    case 0xA3A6: code_point = 0xFF06; break; // FULLWIDTH AMPERSAND
    case 0xA3A7: code_point = 0xFF07; break; // FULLWIDTH APOSTROPHE
    case 0xA3A8: code_point = 0xFF08; break; // FULLWIDTH LEFT PARENTHESIS
    case 0xA3A9: code_point = 0xFF09; break; // FULLWIDTH RIGHT PARENTHESIS
    case 0xA3AA: code_point = 0xFF0A; break; // FULLWIDTH ASTERISK
    case 0xA3AB: code_point = 0xFF0B; break; // FULLWIDTH PLUS SIGN
    case 0xA3AC: code_point = 0xFF0C; break; // FULLWIDTH COMMA
    case 0xA3AD: code_point = 0xFF0D; break; // FULLWIDTH HYPHEN-MINUS
    case 0xA3AE: code_point = 0xFF0E; break; // FULLWIDTH FULL STOP
    case 0xA3AF: code_point = 0xFF0F; break; // FULLWIDTH SOLIDUS
    case 0xA3B0: code_point = 0xFF10; break; // FULLWIDTH DIGIT ZERO
    case 0xA3B1: code_point = 0xFF11; break; // FULLWIDTH DIGIT ONE
    case 0xA3B2: code_point = 0xFF12; break; // FULLWIDTH DIGIT TWO
    case 0xA3B3: code_point = 0xFF13; break; // FULLWIDTH DIGIT THREE
    case 0xA3B4: code_point = 0xFF14; break; // FULLWIDTH DIGIT FOUR
    case 0xA3B5: code_point = 0xFF15; break; // FULLWIDTH DIGIT FIVE
    case 0xA3B6: code_point = 0xFF16; break; // FULLWIDTH DIGIT SIX
    case 0xA3B7: code_point = 0xFF17; break; // FULLWIDTH DIGIT SEVEN
    case 0xA3B8: code_point = 0xFF18; break; // FULLWIDTH DIGIT EIGHT
    case 0xA3B9: code_point = 0xFF19; break; // FULLWIDTH DIGIT NINE
    case 0xA3BA: code_point = 0xFF1A; break; // FULLWIDTH COLON
    case 0xA3BB: code_point = 0xFF1B; break; // FULLWIDTH SEMICOLON
    case 0xA3BC: code_point = 0xFF1C; break; // FULLWIDTH LESS-THAN SIGN
    case 0xA3BD: code_point = 0xFF1D; break; // FULLWIDTH EQUALS SIGN
    case 0xA3BE: code_point = 0xFF1E; break; // FULLWIDTH GREATER-THAN SIGN
    case 0xA3BF: code_point = 0xFF1F; break; // FULLWIDTH QUESTION MARK
    case 0xA3C0: code_point = 0xFF20; break; // FULLWIDTH COMMERCIAL AT
    case 0xA3C1: code_point = 0xFF21; break; // FULLWIDTH LATIN CAPITAL LETTER A
    case 0xA3C2: code_point = 0xFF22; break; // FULLWIDTH LATIN CAPITAL LETTER B
    case 0xA3C3: code_point = 0xFF23; break; // FULLWIDTH LATIN CAPITAL LETTER C
    case 0xA3C4: code_point = 0xFF24; break; // FULLWIDTH LATIN CAPITAL LETTER D
    case 0xA3C5: code_point = 0xFF25; break; // FULLWIDTH LATIN CAPITAL LETTER E
    case 0xA3C6: code_point = 0xFF26; break; // FULLWIDTH LATIN CAPITAL LETTER F
    case 0xA3C7: code_point = 0xFF27; break; // FULLWIDTH LATIN CAPITAL LETTER G
    case 0xA3C8: code_point = 0xFF28; break; // FULLWIDTH LATIN CAPITAL LETTER H
    case 0xA3C9: code_point = 0xFF29; break; // FULLWIDTH LATIN CAPITAL LETTER I
    case 0xA3CA: code_point = 0xFF2A; break; // FULLWIDTH LATIN CAPITAL LETTER J
    case 0xA3CB: code_point = 0xFF2B; break; // FULLWIDTH LATIN CAPITAL LETTER K
    case 0xA3CC: code_point = 0xFF2C; break; // FULLWIDTH LATIN CAPITAL LETTER L
    case 0xA3CD: code_point = 0xFF2D; break; // FULLWIDTH LATIN CAPITAL LETTER M
    case 0xA3CE: code_point = 0xFF2E; break; // FULLWIDTH LATIN CAPITAL LETTER N
    case 0xA3CF: code_point = 0xFF2F; break; // FULLWIDTH LATIN CAPITAL LETTER O
    case 0xA3D0: code_point = 0xFF30; break; // FULLWIDTH LATIN CAPITAL LETTER P
    case 0xA3D1: code_point = 0xFF31; break; // FULLWIDTH LATIN CAPITAL LETTER Q
    case 0xA3D2: code_point = 0xFF32; break; // FULLWIDTH LATIN CAPITAL LETTER R
    case 0xA3D3: code_point = 0xFF33; break; // FULLWIDTH LATIN CAPITAL LETTER S
    case 0xA3D4: code_point = 0xFF34; break; // FULLWIDTH LATIN CAPITAL LETTER T
    case 0xA3D5: code_point = 0xFF35; break; // FULLWIDTH LATIN CAPITAL LETTER U
    case 0xA3D6: code_point = 0xFF36; break; // FULLWIDTH LATIN CAPITAL LETTER V
    case 0xA3D7: code_point = 0xFF37; break; // FULLWIDTH LATIN CAPITAL LETTER W
    case 0xA3D8: code_point = 0xFF38; break; // FULLWIDTH LATIN CAPITAL LETTER X
    case 0xA3D9: code_point = 0xFF39; break; // FULLWIDTH LATIN CAPITAL LETTER Y
    case 0xA3DA: code_point = 0xFF3A; break; // FULLWIDTH LATIN CAPITAL LETTER Z
    case 0xA3DB: code_point = 0xFF3B; break; // FULLWIDTH LEFT SQUARE BRACKET
    case 0xA3DC: code_point = 0xFFE6; break; // FULLWIDTH WON SIGN
    case 0xA3DD: code_point = 0xFF3D; break; // FULLWIDTH RIGHT SQUARE BRACKET
    case 0xA3DE: code_point = 0xFF3E; break; // FULLWIDTH CIRCUMFLEX ACCENT
    case 0xA3DF: code_point = 0xFF3F; break; // FULLWIDTH LOW LINE
    case 0xA3E0: code_point = 0xFF40; break; // FULLWIDTH GRAVE ACCENT
    case 0xA3E1: code_point = 0xFF41; break; // FULLWIDTH LATIN SMALL LETTER A
    case 0xA3E2: code_point = 0xFF42; break; // FULLWIDTH LATIN SMALL LETTER B
    case 0xA3E3: code_point = 0xFF43; break; // FULLWIDTH LATIN SMALL LETTER C
    case 0xA3E4: code_point = 0xFF44; break; // FULLWIDTH LATIN SMALL LETTER D
    case 0xA3E5: code_point = 0xFF45; break; // FULLWIDTH LATIN SMALL LETTER E
    case 0xA3E6: code_point = 0xFF46; break; // FULLWIDTH LATIN SMALL LETTER F
    case 0xA3E7: code_point = 0xFF47; break; // FULLWIDTH LATIN SMALL LETTER G
    case 0xA3E8: code_point = 0xFF48; break; // FULLWIDTH LATIN SMALL LETTER H
    case 0xA3E9: code_point = 0xFF49; break; // FULLWIDTH LATIN SMALL LETTER I
    case 0xA3EA: code_point = 0xFF4A; break; // FULLWIDTH LATIN SMALL LETTER J
    case 0xA3EB: code_point = 0xFF4B; break; // FULLWIDTH LATIN SMALL LETTER K
    case 0xA3EC: code_point = 0xFF4C; break; // FULLWIDTH LATIN SMALL LETTER L
    case 0xA3ED: code_point = 0xFF4D; break; // FULLWIDTH LATIN SMALL LETTER M
    case 0xA3EE: code_point = 0xFF4E; break; // FULLWIDTH LATIN SMALL LETTER N
    case 0xA3EF: code_point = 0xFF4F; break; // FULLWIDTH LATIN SMALL LETTER O
    case 0xA3F0: code_point = 0xFF50; break; // FULLWIDTH LATIN SMALL LETTER P
    case 0xA3F1: code_point = 0xFF51; break; // FULLWIDTH LATIN SMALL LETTER Q
    case 0xA3F2: code_point = 0xFF52; break; // FULLWIDTH LATIN SMALL LETTER R
    case 0xA3F3: code_point = 0xFF53; break; // FULLWIDTH LATIN SMALL LETTER S
    case 0xA3F4: code_point = 0xFF54; break; // FULLWIDTH LATIN SMALL LETTER T
    case 0xA3F5: code_point = 0xFF55; break; // FULLWIDTH LATIN SMALL LETTER U
    case 0xA3F6: code_point = 0xFF56; break; // FULLWIDTH LATIN SMALL LETTER V
    case 0xA3F7: code_point = 0xFF57; break; // FULLWIDTH LATIN SMALL LETTER W
    case 0xA3F8: code_point = 0xFF58; break; // FULLWIDTH LATIN SMALL LETTER X
    case 0xA3F9: code_point = 0xFF59; break; // FULLWIDTH LATIN SMALL LETTER Y
    case 0xA3FA: code_point = 0xFF5A; break; // FULLWIDTH LATIN SMALL LETTER Z
    case 0xA3FB: code_point = 0xFF5B; break; // FULLWIDTH LEFT CURLY BRACKET
    case 0xA3FC: code_point = 0xFF5C; break; // FULLWIDTH VERTICAL LINE
    case 0xA3FD: code_point = 0xFF5D; break; // FULLWIDTH RIGHT CURLY BRACKET
    case 0xA3FE: code_point = 0xFFE3; break; // FULLWIDTH MACRON
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA4(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA441: code_point = 0xC9DE; break; // HANGUL SYLLABLE SSANGCIEUC A SSANGKIYEOK
    case 0xA442: code_point = 0xC9DF; break; // HANGUL SYLLABLE SSANGCIEUC A KIYEOKSIOS
    case 0xA443: code_point = 0xC9E1; break; // HANGUL SYLLABLE SSANGCIEUC A NIEUNCIEUC
    case 0xA444: code_point = 0xC9E3; break; // HANGUL SYLLABLE SSANGCIEUC A TIKEUT
    case 0xA445: code_point = 0xC9E5; break; // HANGUL SYLLABLE SSANGCIEUC A RIEULKIYEOK
    case 0xA446: code_point = 0xC9E6; break; // HANGUL SYLLABLE SSANGCIEUC A RIEULMIEUM
    case 0xA447: code_point = 0xC9E8; break; // HANGUL SYLLABLE SSANGCIEUC A RIEULSIOS
    case 0xA448: code_point = 0xC9E9; break; // HANGUL SYLLABLE SSANGCIEUC A RIEULTHIEUTH
    case 0xA449: code_point = 0xC9EA; break; // HANGUL SYLLABLE SSANGCIEUC A RIEULPHIEUPH
    case 0xA44A: code_point = 0xC9EB; break; // HANGUL SYLLABLE SSANGCIEUC A RIEULHIEUH
    case 0xA44B: code_point = 0xC9EE; break; // HANGUL SYLLABLE SSANGCIEUC A PIEUPSIOS
    case 0xA44C: code_point = 0xC9F2; break; // HANGUL SYLLABLE SSANGCIEUC A CIEUC
    case 0xA44D: code_point = 0xC9F3; break; // HANGUL SYLLABLE SSANGCIEUC A CHIEUCH
    case 0xA44E: code_point = 0xC9F4; break; // HANGUL SYLLABLE SSANGCIEUC A KHIEUKH
    case 0xA44F: code_point = 0xC9F5; break; // HANGUL SYLLABLE SSANGCIEUC A THIEUTH
    case 0xA450: code_point = 0xC9F6; break; // HANGUL SYLLABLE SSANGCIEUC A PHIEUPH
    case 0xA451: code_point = 0xC9F7; break; // HANGUL SYLLABLE SSANGCIEUC A HIEUH
    case 0xA452: code_point = 0xC9FA; break; // HANGUL SYLLABLE SSANGCIEUC AE SSANGKIYEOK
    case 0xA453: code_point = 0xC9FB; break; // HANGUL SYLLABLE SSANGCIEUC AE KIYEOKSIOS
    case 0xA454: code_point = 0xC9FD; break; // HANGUL SYLLABLE SSANGCIEUC AE NIEUNCIEUC
    case 0xA455: code_point = 0xC9FE; break; // HANGUL SYLLABLE SSANGCIEUC AE NIEUNHIEUH
    case 0xA456: code_point = 0xC9FF; break; // HANGUL SYLLABLE SSANGCIEUC AE TIKEUT
    case 0xA457: code_point = 0xCA01; break; // HANGUL SYLLABLE SSANGCIEUC AE RIEULKIYEOK
    case 0xA458: code_point = 0xCA02; break; // HANGUL SYLLABLE SSANGCIEUC AE RIEULMIEUM
    case 0xA459: code_point = 0xCA03; break; // HANGUL SYLLABLE SSANGCIEUC AE RIEULPIEUP
    case 0xA45A: code_point = 0xCA04; break; // HANGUL SYLLABLE SSANGCIEUC AE RIEULSIOS
    case 0xA461: code_point = 0xCA05; break; // HANGUL SYLLABLE SSANGCIEUC AE RIEULTHIEUTH
    case 0xA462: code_point = 0xCA06; break; // HANGUL SYLLABLE SSANGCIEUC AE RIEULPHIEUPH
    case 0xA463: code_point = 0xCA07; break; // HANGUL SYLLABLE SSANGCIEUC AE RIEULHIEUH
    case 0xA464: code_point = 0xCA0A; break; // HANGUL SYLLABLE SSANGCIEUC AE PIEUPSIOS
    case 0xA465: code_point = 0xCA0E; break; // HANGUL SYLLABLE SSANGCIEUC AE CIEUC
    case 0xA466: code_point = 0xCA0F; break; // HANGUL SYLLABLE SSANGCIEUC AE CHIEUCH
    case 0xA467: code_point = 0xCA10; break; // HANGUL SYLLABLE SSANGCIEUC AE KHIEUKH
    case 0xA468: code_point = 0xCA11; break; // HANGUL SYLLABLE SSANGCIEUC AE THIEUTH
    case 0xA469: code_point = 0xCA12; break; // HANGUL SYLLABLE SSANGCIEUC AE PHIEUPH
    case 0xA46A: code_point = 0xCA13; break; // HANGUL SYLLABLE SSANGCIEUC AE HIEUH
    case 0xA46B: code_point = 0xCA15; break; // HANGUL SYLLABLE SSANGCIEUC YA KIYEOK
    case 0xA46C: code_point = 0xCA16; break; // HANGUL SYLLABLE SSANGCIEUC YA SSANGKIYEOK
    case 0xA46D: code_point = 0xCA17; break; // HANGUL SYLLABLE SSANGCIEUC YA KIYEOKSIOS
    case 0xA46E: code_point = 0xCA19; break; // HANGUL SYLLABLE SSANGCIEUC YA NIEUNCIEUC
    case 0xA46F: code_point = 0xCA1A; break; // HANGUL SYLLABLE SSANGCIEUC YA NIEUNHIEUH
    case 0xA470: code_point = 0xCA1B; break; // HANGUL SYLLABLE SSANGCIEUC YA TIKEUT
    case 0xA471: code_point = 0xCA1C; break; // HANGUL SYLLABLE SSANGCIEUC YA RIEUL
    case 0xA472: code_point = 0xCA1D; break; // HANGUL SYLLABLE SSANGCIEUC YA RIEULKIYEOK
    case 0xA473: code_point = 0xCA1E; break; // HANGUL SYLLABLE SSANGCIEUC YA RIEULMIEUM
    case 0xA474: code_point = 0xCA1F; break; // HANGUL SYLLABLE SSANGCIEUC YA RIEULPIEUP
    case 0xA475: code_point = 0xCA20; break; // HANGUL SYLLABLE SSANGCIEUC YA RIEULSIOS
    case 0xA476: code_point = 0xCA21; break; // HANGUL SYLLABLE SSANGCIEUC YA RIEULTHIEUTH
    case 0xA477: code_point = 0xCA22; break; // HANGUL SYLLABLE SSANGCIEUC YA RIEULPHIEUPH
    case 0xA478: code_point = 0xCA23; break; // HANGUL SYLLABLE SSANGCIEUC YA RIEULHIEUH
    case 0xA479: code_point = 0xCA24; break; // HANGUL SYLLABLE SSANGCIEUC YA MIEUM
    case 0xA47A: code_point = 0xCA25; break; // HANGUL SYLLABLE SSANGCIEUC YA PIEUP
    case 0xA481: code_point = 0xCA26; break; // HANGUL SYLLABLE SSANGCIEUC YA PIEUPSIOS
    case 0xA482: code_point = 0xCA27; break; // HANGUL SYLLABLE SSANGCIEUC YA SIOS
    case 0xA483: code_point = 0xCA28; break; // HANGUL SYLLABLE SSANGCIEUC YA SSANGSIOS
    case 0xA484: code_point = 0xCA2A; break; // HANGUL SYLLABLE SSANGCIEUC YA CIEUC
    case 0xA485: code_point = 0xCA2B; break; // HANGUL SYLLABLE SSANGCIEUC YA CHIEUCH
    case 0xA486: code_point = 0xCA2C; break; // HANGUL SYLLABLE SSANGCIEUC YA KHIEUKH
    case 0xA487: code_point = 0xCA2D; break; // HANGUL SYLLABLE SSANGCIEUC YA THIEUTH
    case 0xA488: code_point = 0xCA2E; break; // HANGUL SYLLABLE SSANGCIEUC YA PHIEUPH
    case 0xA489: code_point = 0xCA2F; break; // HANGUL SYLLABLE SSANGCIEUC YA HIEUH
    case 0xA48A: code_point = 0xCA30; break; // HANGUL SYLLABLE SSANGCIEUC YAE
    case 0xA48B: code_point = 0xCA31; break; // HANGUL SYLLABLE SSANGCIEUC YAE KIYEOK
    case 0xA48C: code_point = 0xCA32; break; // HANGUL SYLLABLE SSANGCIEUC YAE SSANGKIYEOK
    case 0xA48D: code_point = 0xCA33; break; // HANGUL SYLLABLE SSANGCIEUC YAE KIYEOKSIOS
    case 0xA48E: code_point = 0xCA34; break; // HANGUL SYLLABLE SSANGCIEUC YAE NIEUN
    case 0xA48F: code_point = 0xCA35; break; // HANGUL SYLLABLE SSANGCIEUC YAE NIEUNCIEUC
    case 0xA490: code_point = 0xCA36; break; // HANGUL SYLLABLE SSANGCIEUC YAE NIEUNHIEUH
    case 0xA491: code_point = 0xCA37; break; // HANGUL SYLLABLE SSANGCIEUC YAE TIKEUT
    case 0xA492: code_point = 0xCA38; break; // HANGUL SYLLABLE SSANGCIEUC YAE RIEUL
    case 0xA493: code_point = 0xCA39; break; // HANGUL SYLLABLE SSANGCIEUC YAE RIEULKIYEOK
    case 0xA494: code_point = 0xCA3A; break; // HANGUL SYLLABLE SSANGCIEUC YAE RIEULMIEUM
    case 0xA495: code_point = 0xCA3B; break; // HANGUL SYLLABLE SSANGCIEUC YAE RIEULPIEUP
    case 0xA496: code_point = 0xCA3C; break; // HANGUL SYLLABLE SSANGCIEUC YAE RIEULSIOS
    case 0xA497: code_point = 0xCA3D; break; // HANGUL SYLLABLE SSANGCIEUC YAE RIEULTHIEUTH
    case 0xA498: code_point = 0xCA3E; break; // HANGUL SYLLABLE SSANGCIEUC YAE RIEULPHIEUPH
    case 0xA499: code_point = 0xCA3F; break; // HANGUL SYLLABLE SSANGCIEUC YAE RIEULHIEUH
    case 0xA49A: code_point = 0xCA40; break; // HANGUL SYLLABLE SSANGCIEUC YAE MIEUM
    case 0xA49B: code_point = 0xCA41; break; // HANGUL SYLLABLE SSANGCIEUC YAE PIEUP
    case 0xA49C: code_point = 0xCA42; break; // HANGUL SYLLABLE SSANGCIEUC YAE PIEUPSIOS
    case 0xA49D: code_point = 0xCA43; break; // HANGUL SYLLABLE SSANGCIEUC YAE SIOS
    case 0xA49E: code_point = 0xCA44; break; // HANGUL SYLLABLE SSANGCIEUC YAE SSANGSIOS
    case 0xA49F: code_point = 0xCA45; break; // HANGUL SYLLABLE SSANGCIEUC YAE IEUNG
    case 0xA4A0: code_point = 0xCA46; break; // HANGUL SYLLABLE SSANGCIEUC YAE CIEUC
    case 0xA4A1: code_point = 0x3131; break; // HANGUL LETTER KIYEOK
    case 0xA4A2: code_point = 0x3132; break; // HANGUL LETTER SSANGKIYEOK
    case 0xA4A3: code_point = 0x3133; break; // HANGUL LETTER KIYEOK-SIOS
    case 0xA4A4: code_point = 0x3134; break; // HANGUL LETTER NIEUN
    case 0xA4A5: code_point = 0x3135; break; // HANGUL LETTER NIEUN-CIEUC
    case 0xA4A6: code_point = 0x3136; break; // HANGUL LETTER NIEUN-HIEUH
    case 0xA4A7: code_point = 0x3137; break; // HANGUL LETTER TIKEUT
    case 0xA4A8: code_point = 0x3138; break; // HANGUL LETTER SSANGTIKEUT
    case 0xA4A9: code_point = 0x3139; break; // HANGUL LETTER RIEUL
    case 0xA4AA: code_point = 0x313A; break; // HANGUL LETTER RIEUL-KIYEOK
    case 0xA4AB: code_point = 0x313B; break; // HANGUL LETTER RIEUL-MIEUM
    case 0xA4AC: code_point = 0x313C; break; // HANGUL LETTER RIEUL-PIEUP
    case 0xA4AD: code_point = 0x313D; break; // HANGUL LETTER RIEUL-SIOS
    case 0xA4AE: code_point = 0x313E; break; // HANGUL LETTER RIEUL-THIEUTH
    case 0xA4AF: code_point = 0x313F; break; // HANGUL LETTER RIEUL-PHIEUPH
    case 0xA4B0: code_point = 0x3140; break; // HANGUL LETTER RIEUL-HIEUH
    case 0xA4B1: code_point = 0x3141; break; // HANGUL LETTER MIEUM
    case 0xA4B2: code_point = 0x3142; break; // HANGUL LETTER PIEUP
    case 0xA4B3: code_point = 0x3143; break; // HANGUL LETTER SSANGPIEUP
    case 0xA4B4: code_point = 0x3144; break; // HANGUL LETTER PIEUP-SIOS
    case 0xA4B5: code_point = 0x3145; break; // HANGUL LETTER SIOS
    case 0xA4B6: code_point = 0x3146; break; // HANGUL LETTER SSANGSIOS
    case 0xA4B7: code_point = 0x3147; break; // HANGUL LETTER IEUNG
    case 0xA4B8: code_point = 0x3148; break; // HANGUL LETTER CIEUC
    case 0xA4B9: code_point = 0x3149; break; // HANGUL LETTER SSANGCIEUC
    case 0xA4BA: code_point = 0x314A; break; // HANGUL LETTER CHIEUCH
    case 0xA4BB: code_point = 0x314B; break; // HANGUL LETTER KHIEUKH
    case 0xA4BC: code_point = 0x314C; break; // HANGUL LETTER THIEUTH
    case 0xA4BD: code_point = 0x314D; break; // HANGUL LETTER PHIEUPH
    case 0xA4BE: code_point = 0x314E; break; // HANGUL LETTER HIEUH
    case 0xA4BF: code_point = 0x314F; break; // HANGUL LETTER A
    case 0xA4C0: code_point = 0x3150; break; // HANGUL LETTER AE
    case 0xA4C1: code_point = 0x3151; break; // HANGUL LETTER YA
    case 0xA4C2: code_point = 0x3152; break; // HANGUL LETTER YAE
    case 0xA4C3: code_point = 0x3153; break; // HANGUL LETTER EO
    case 0xA4C4: code_point = 0x3154; break; // HANGUL LETTER E
    case 0xA4C5: code_point = 0x3155; break; // HANGUL LETTER YEO
    case 0xA4C6: code_point = 0x3156; break; // HANGUL LETTER YE
    case 0xA4C7: code_point = 0x3157; break; // HANGUL LETTER O
    case 0xA4C8: code_point = 0x3158; break; // HANGUL LETTER WA
    case 0xA4C9: code_point = 0x3159; break; // HANGUL LETTER WAE
    case 0xA4CA: code_point = 0x315A; break; // HANGUL LETTER OE
    case 0xA4CB: code_point = 0x315B; break; // HANGUL LETTER YO
    case 0xA4CC: code_point = 0x315C; break; // HANGUL LETTER U
    case 0xA4CD: code_point = 0x315D; break; // HANGUL LETTER WEO
    case 0xA4CE: code_point = 0x315E; break; // HANGUL LETTER WE
    case 0xA4CF: code_point = 0x315F; break; // HANGUL LETTER WI
    case 0xA4D0: code_point = 0x3160; break; // HANGUL LETTER YU
    case 0xA4D1: code_point = 0x3161; break; // HANGUL LETTER EU
    case 0xA4D2: code_point = 0x3162; break; // HANGUL LETTER YI
    case 0xA4D3: code_point = 0x3163; break; // HANGUL LETTER I
    case 0xA4D4: code_point = 0x3164; break; // HANGUL FILLER
    case 0xA4D5: code_point = 0x3165; break; // HANGUL LETTER SSANGNIEUN
    case 0xA4D6: code_point = 0x3166; break; // HANGUL LETTER NIEUN-TIKEUT
    case 0xA4D7: code_point = 0x3167; break; // HANGUL LETTER NIEUN-SIOS
    case 0xA4D8: code_point = 0x3168; break; // HANGUL LETTER NIEUN-PANSIOS
    case 0xA4D9: code_point = 0x3169; break; // HANGUL LETTER RIEUL-KIYEOK-SIOS
    case 0xA4DA: code_point = 0x316A; break; // HANGUL LETTER RIEUL-TIKEUT
    case 0xA4DB: code_point = 0x316B; break; // HANGUL LETTER RIEUL-PIEUP-SIOS
    case 0xA4DC: code_point = 0x316C; break; // HANGUL LETTER RIEUL-PANSIOS
    case 0xA4DD: code_point = 0x316D; break; // HANGUL LETTER RIEUL-YEORINHIEUH
    case 0xA4DE: code_point = 0x316E; break; // HANGUL LETTER MIEUM-PIEUP
    case 0xA4DF: code_point = 0x316F; break; // HANGUL LETTER MIEUM-SIOS
    case 0xA4E0: code_point = 0x3170; break; // HANGUL LETTER MIEUM-PANSIOS
    case 0xA4E1: code_point = 0x3171; break; // HANGUL LETTER KAPYEOUNMIEUM
    case 0xA4E2: code_point = 0x3172; break; // HANGUL LETTER PIEUP-KIYEOK
    case 0xA4E3: code_point = 0x3173; break; // HANGUL LETTER PIEUP-TIKEUT
    case 0xA4E4: code_point = 0x3174; break; // HANGUL LETTER PIEUP-SIOS-KIYEOK
    case 0xA4E5: code_point = 0x3175; break; // HANGUL LETTER PIEUP-SIOS-TIKEUT
    case 0xA4E6: code_point = 0x3176; break; // HANGUL LETTER PIEUP-CIEUC
    case 0xA4E7: code_point = 0x3177; break; // HANGUL LETTER PIEUP-THIEUTH
    case 0xA4E8: code_point = 0x3178; break; // HANGUL LETTER KAPYEOUNPIEUP
    case 0xA4E9: code_point = 0x3179; break; // HANGUL LETTER KAPYEOUNSSANGPIEUP
    case 0xA4EA: code_point = 0x317A; break; // HANGUL LETTER SIOS-KIYEOK
    case 0xA4EB: code_point = 0x317B; break; // HANGUL LETTER SIOS-NIEUN
    case 0xA4EC: code_point = 0x317C; break; // HANGUL LETTER SIOS-TIKEUT
    case 0xA4ED: code_point = 0x317D; break; // HANGUL LETTER SIOS-PIEUP
    case 0xA4EE: code_point = 0x317E; break; // HANGUL LETTER SIOS-CIEUC
    case 0xA4EF: code_point = 0x317F; break; // HANGUL LETTER PANSIOS
    case 0xA4F0: code_point = 0x3180; break; // HANGUL LETTER SSANGIEUNG
    case 0xA4F1: code_point = 0x3181; break; // HANGUL LETTER YESIEUNG
    case 0xA4F2: code_point = 0x3182; break; // HANGUL LETTER YESIEUNG-SIOS
    case 0xA4F3: code_point = 0x3183; break; // HANGUL LETTER YESIEUNG-PANSIOS
    case 0xA4F4: code_point = 0x3184; break; // HANGUL LETTER KAPYEOUNPHIEUPH
    case 0xA4F5: code_point = 0x3185; break; // HANGUL LETTER SSANGHIEUH
    case 0xA4F6: code_point = 0x3186; break; // HANGUL LETTER YEORINHIEUH
    case 0xA4F7: code_point = 0x3187; break; // HANGUL LETTER YO-YA
    case 0xA4F8: code_point = 0x3188; break; // HANGUL LETTER YO-YAE
    case 0xA4F9: code_point = 0x3189; break; // HANGUL LETTER YO-I
    case 0xA4FA: code_point = 0x318A; break; // HANGUL LETTER YU-YEO
    case 0xA4FB: code_point = 0x318B; break; // HANGUL LETTER YU-YE
    case 0xA4FC: code_point = 0x318C; break; // HANGUL LETTER YU-I
    case 0xA4FD: code_point = 0x318D; break; // HANGUL LETTER ARAEA
    case 0xA4FE: code_point = 0x318E; break; // HANGUL LETTER ARAEAE
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA5(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA541: code_point = 0xCA47; break; // HANGUL SYLLABLE SSANGCIEUC YAE CHIEUCH
    case 0xA542: code_point = 0xCA48; break; // HANGUL SYLLABLE SSANGCIEUC YAE KHIEUKH
    case 0xA543: code_point = 0xCA49; break; // HANGUL SYLLABLE SSANGCIEUC YAE THIEUTH
    case 0xA544: code_point = 0xCA4A; break; // HANGUL SYLLABLE SSANGCIEUC YAE PHIEUPH
    case 0xA545: code_point = 0xCA4B; break; // HANGUL SYLLABLE SSANGCIEUC YAE HIEUH
    case 0xA546: code_point = 0xCA4E; break; // HANGUL SYLLABLE SSANGCIEUC EO SSANGKIYEOK
    case 0xA547: code_point = 0xCA4F; break; // HANGUL SYLLABLE SSANGCIEUC EO KIYEOKSIOS
    case 0xA548: code_point = 0xCA51; break; // HANGUL SYLLABLE SSANGCIEUC EO NIEUNCIEUC
    case 0xA549: code_point = 0xCA52; break; // HANGUL SYLLABLE SSANGCIEUC EO NIEUNHIEUH
    case 0xA54A: code_point = 0xCA53; break; // HANGUL SYLLABLE SSANGCIEUC EO TIKEUT
    case 0xA54B: code_point = 0xCA55; break; // HANGUL SYLLABLE SSANGCIEUC EO RIEULKIYEOK
    case 0xA54C: code_point = 0xCA56; break; // HANGUL SYLLABLE SSANGCIEUC EO RIEULMIEUM
    case 0xA54D: code_point = 0xCA57; break; // HANGUL SYLLABLE SSANGCIEUC EO RIEULPIEUP
    case 0xA54E: code_point = 0xCA58; break; // HANGUL SYLLABLE SSANGCIEUC EO RIEULSIOS
    case 0xA54F: code_point = 0xCA59; break; // HANGUL SYLLABLE SSANGCIEUC EO RIEULTHIEUTH
    case 0xA550: code_point = 0xCA5A; break; // HANGUL SYLLABLE SSANGCIEUC EO RIEULPHIEUPH
    case 0xA551: code_point = 0xCA5B; break; // HANGUL SYLLABLE SSANGCIEUC EO RIEULHIEUH
    case 0xA552: code_point = 0xCA5E; break; // HANGUL SYLLABLE SSANGCIEUC EO PIEUPSIOS
    case 0xA553: code_point = 0xCA62; break; // HANGUL SYLLABLE SSANGCIEUC EO CIEUC
    case 0xA554: code_point = 0xCA63; break; // HANGUL SYLLABLE SSANGCIEUC EO CHIEUCH
    case 0xA555: code_point = 0xCA64; break; // HANGUL SYLLABLE SSANGCIEUC EO KHIEUKH
    case 0xA556: code_point = 0xCA65; break; // HANGUL SYLLABLE SSANGCIEUC EO THIEUTH
    case 0xA557: code_point = 0xCA66; break; // HANGUL SYLLABLE SSANGCIEUC EO PHIEUPH
    case 0xA558: code_point = 0xCA67; break; // HANGUL SYLLABLE SSANGCIEUC EO HIEUH
    case 0xA559: code_point = 0xCA69; break; // HANGUL SYLLABLE SSANGCIEUC E KIYEOK
    case 0xA55A: code_point = 0xCA6A; break; // HANGUL SYLLABLE SSANGCIEUC E SSANGKIYEOK
    case 0xA561: code_point = 0xCA6B; break; // HANGUL SYLLABLE SSANGCIEUC E KIYEOKSIOS
    case 0xA562: code_point = 0xCA6C; break; // HANGUL SYLLABLE SSANGCIEUC E NIEUN
    case 0xA563: code_point = 0xCA6D; break; // HANGUL SYLLABLE SSANGCIEUC E NIEUNCIEUC
    case 0xA564: code_point = 0xCA6E; break; // HANGUL SYLLABLE SSANGCIEUC E NIEUNHIEUH
    case 0xA565: code_point = 0xCA6F; break; // HANGUL SYLLABLE SSANGCIEUC E TIKEUT
    case 0xA566: code_point = 0xCA70; break; // HANGUL SYLLABLE SSANGCIEUC E RIEUL
    case 0xA567: code_point = 0xCA71; break; // HANGUL SYLLABLE SSANGCIEUC E RIEULKIYEOK
    case 0xA568: code_point = 0xCA72; break; // HANGUL SYLLABLE SSANGCIEUC E RIEULMIEUM
    case 0xA569: code_point = 0xCA73; break; // HANGUL SYLLABLE SSANGCIEUC E RIEULPIEUP
    case 0xA56A: code_point = 0xCA74; break; // HANGUL SYLLABLE SSANGCIEUC E RIEULSIOS
    case 0xA56B: code_point = 0xCA75; break; // HANGUL SYLLABLE SSANGCIEUC E RIEULTHIEUTH
    case 0xA56C: code_point = 0xCA76; break; // HANGUL SYLLABLE SSANGCIEUC E RIEULPHIEUPH
    case 0xA56D: code_point = 0xCA77; break; // HANGUL SYLLABLE SSANGCIEUC E RIEULHIEUH
    case 0xA56E: code_point = 0xCA78; break; // HANGUL SYLLABLE SSANGCIEUC E MIEUM
    case 0xA56F: code_point = 0xCA79; break; // HANGUL SYLLABLE SSANGCIEUC E PIEUP
    case 0xA570: code_point = 0xCA7A; break; // HANGUL SYLLABLE SSANGCIEUC E PIEUPSIOS
    case 0xA571: code_point = 0xCA7B; break; // HANGUL SYLLABLE SSANGCIEUC E SIOS
    case 0xA572: code_point = 0xCA7C; break; // HANGUL SYLLABLE SSANGCIEUC E SSANGSIOS
    case 0xA573: code_point = 0xCA7E; break; // HANGUL SYLLABLE SSANGCIEUC E CIEUC
    case 0xA574: code_point = 0xCA7F; break; // HANGUL SYLLABLE SSANGCIEUC E CHIEUCH
    case 0xA575: code_point = 0xCA80; break; // HANGUL SYLLABLE SSANGCIEUC E KHIEUKH
    case 0xA576: code_point = 0xCA81; break; // HANGUL SYLLABLE SSANGCIEUC E THIEUTH
    case 0xA577: code_point = 0xCA82; break; // HANGUL SYLLABLE SSANGCIEUC E PHIEUPH
    case 0xA578: code_point = 0xCA83; break; // HANGUL SYLLABLE SSANGCIEUC E HIEUH
    case 0xA579: code_point = 0xCA85; break; // HANGUL SYLLABLE SSANGCIEUC YEO KIYEOK
    case 0xA57A: code_point = 0xCA86; break; // HANGUL SYLLABLE SSANGCIEUC YEO SSANGKIYEOK
    case 0xA581: code_point = 0xCA87; break; // HANGUL SYLLABLE SSANGCIEUC YEO KIYEOKSIOS
    case 0xA582: code_point = 0xCA88; break; // HANGUL SYLLABLE SSANGCIEUC YEO NIEUN
    case 0xA583: code_point = 0xCA89; break; // HANGUL SYLLABLE SSANGCIEUC YEO NIEUNCIEUC
    case 0xA584: code_point = 0xCA8A; break; // HANGUL SYLLABLE SSANGCIEUC YEO NIEUNHIEUH
    case 0xA585: code_point = 0xCA8B; break; // HANGUL SYLLABLE SSANGCIEUC YEO TIKEUT
    case 0xA586: code_point = 0xCA8C; break; // HANGUL SYLLABLE SSANGCIEUC YEO RIEUL
    case 0xA587: code_point = 0xCA8D; break; // HANGUL SYLLABLE SSANGCIEUC YEO RIEULKIYEOK
    case 0xA588: code_point = 0xCA8E; break; // HANGUL SYLLABLE SSANGCIEUC YEO RIEULMIEUM
    case 0xA589: code_point = 0xCA8F; break; // HANGUL SYLLABLE SSANGCIEUC YEO RIEULPIEUP
    case 0xA58A: code_point = 0xCA90; break; // HANGUL SYLLABLE SSANGCIEUC YEO RIEULSIOS
    case 0xA58B: code_point = 0xCA91; break; // HANGUL SYLLABLE SSANGCIEUC YEO RIEULTHIEUTH
    case 0xA58C: code_point = 0xCA92; break; // HANGUL SYLLABLE SSANGCIEUC YEO RIEULPHIEUPH
    case 0xA58D: code_point = 0xCA93; break; // HANGUL SYLLABLE SSANGCIEUC YEO RIEULHIEUH
    case 0xA58E: code_point = 0xCA94; break; // HANGUL SYLLABLE SSANGCIEUC YEO MIEUM
    case 0xA58F: code_point = 0xCA95; break; // HANGUL SYLLABLE SSANGCIEUC YEO PIEUP
    case 0xA590: code_point = 0xCA96; break; // HANGUL SYLLABLE SSANGCIEUC YEO PIEUPSIOS
    case 0xA591: code_point = 0xCA97; break; // HANGUL SYLLABLE SSANGCIEUC YEO SIOS
    case 0xA592: code_point = 0xCA99; break; // HANGUL SYLLABLE SSANGCIEUC YEO IEUNG
    case 0xA593: code_point = 0xCA9A; break; // HANGUL SYLLABLE SSANGCIEUC YEO CIEUC
    case 0xA594: code_point = 0xCA9B; break; // HANGUL SYLLABLE SSANGCIEUC YEO CHIEUCH
    case 0xA595: code_point = 0xCA9C; break; // HANGUL SYLLABLE SSANGCIEUC YEO KHIEUKH
    case 0xA596: code_point = 0xCA9D; break; // HANGUL SYLLABLE SSANGCIEUC YEO THIEUTH
    case 0xA597: code_point = 0xCA9E; break; // HANGUL SYLLABLE SSANGCIEUC YEO PHIEUPH
    case 0xA598: code_point = 0xCA9F; break; // HANGUL SYLLABLE SSANGCIEUC YEO HIEUH
    case 0xA599: code_point = 0xCAA0; break; // HANGUL SYLLABLE SSANGCIEUC YE
    case 0xA59A: code_point = 0xCAA1; break; // HANGUL SYLLABLE SSANGCIEUC YE KIYEOK
    case 0xA59B: code_point = 0xCAA2; break; // HANGUL SYLLABLE SSANGCIEUC YE SSANGKIYEOK
    case 0xA59C: code_point = 0xCAA3; break; // HANGUL SYLLABLE SSANGCIEUC YE KIYEOKSIOS
    case 0xA59D: code_point = 0xCAA4; break; // HANGUL SYLLABLE SSANGCIEUC YE NIEUN
    case 0xA59E: code_point = 0xCAA5; break; // HANGUL SYLLABLE SSANGCIEUC YE NIEUNCIEUC
    case 0xA59F: code_point = 0xCAA6; break; // HANGUL SYLLABLE SSANGCIEUC YE NIEUNHIEUH
    case 0xA5A0: code_point = 0xCAA7; break; // HANGUL SYLLABLE SSANGCIEUC YE TIKEUT
    case 0xA5A1: code_point = 0x2170; break; // SMALL ROMAN NUMERAL ONE
    case 0xA5A2: code_point = 0x2171; break; // SMALL ROMAN NUMERAL TWO
    case 0xA5A3: code_point = 0x2172; break; // SMALL ROMAN NUMERAL THREE
    case 0xA5A4: code_point = 0x2173; break; // SMALL ROMAN NUMERAL FOUR
    case 0xA5A5: code_point = 0x2174; break; // SMALL ROMAN NUMERAL FIVE
    case 0xA5A6: code_point = 0x2175; break; // SMALL ROMAN NUMERAL SIX
    case 0xA5A7: code_point = 0x2176; break; // SMALL ROMAN NUMERAL SEVEN
    case 0xA5A8: code_point = 0x2177; break; // SMALL ROMAN NUMERAL EIGHT
    case 0xA5A9: code_point = 0x2178; break; // SMALL ROMAN NUMERAL NINE
    case 0xA5AA: code_point = 0x2179; break; // SMALL ROMAN NUMERAL TEN
    case 0xA5B0: code_point = 0x2160; break; // ROMAN NUMERAL ONE
    case 0xA5B1: code_point = 0x2161; break; // ROMAN NUMERAL TWO
    case 0xA5B2: code_point = 0x2162; break; // ROMAN NUMERAL THREE
    case 0xA5B3: code_point = 0x2163; break; // ROMAN NUMERAL FOUR
    case 0xA5B4: code_point = 0x2164; break; // ROMAN NUMERAL FIVE
    case 0xA5B5: code_point = 0x2165; break; // ROMAN NUMERAL SIX
    case 0xA5B6: code_point = 0x2166; break; // ROMAN NUMERAL SEVEN
    case 0xA5B7: code_point = 0x2167; break; // ROMAN NUMERAL EIGHT
    case 0xA5B8: code_point = 0x2168; break; // ROMAN NUMERAL NINE
    case 0xA5B9: code_point = 0x2169; break; // ROMAN NUMERAL TEN
    case 0xA5C1: code_point = 0x0391; break; // GREEK CAPITAL LETTER ALPHA
    case 0xA5C2: code_point = 0x0392; break; // GREEK CAPITAL LETTER BETA
    case 0xA5C3: code_point = 0x0393; break; // GREEK CAPITAL LETTER GAMMA
    case 0xA5C4: code_point = 0x0394; break; // GREEK CAPITAL LETTER DELTA
    case 0xA5C5: code_point = 0x0395; break; // GREEK CAPITAL LETTER EPSILON
    case 0xA5C6: code_point = 0x0396; break; // GREEK CAPITAL LETTER ZETA
    case 0xA5C7: code_point = 0x0397; break; // GREEK CAPITAL LETTER ETA
    case 0xA5C8: code_point = 0x0398; break; // GREEK CAPITAL LETTER THETA
    case 0xA5C9: code_point = 0x0399; break; // GREEK CAPITAL LETTER IOTA
    case 0xA5CA: code_point = 0x039A; break; // GREEK CAPITAL LETTER KAPPA
    case 0xA5CB: code_point = 0x039B; break; // GREEK CAPITAL LETTER LAMDA
    case 0xA5CC: code_point = 0x039C; break; // GREEK CAPITAL LETTER MU
    case 0xA5CD: code_point = 0x039D; break; // GREEK CAPITAL LETTER NU
    case 0xA5CE: code_point = 0x039E; break; // GREEK CAPITAL LETTER XI
    case 0xA5CF: code_point = 0x039F; break; // GREEK CAPITAL LETTER OMICRON
    case 0xA5D0: code_point = 0x03A0; break; // GREEK CAPITAL LETTER PI
    case 0xA5D1: code_point = 0x03A1; break; // GREEK CAPITAL LETTER RHO
    case 0xA5D2: code_point = 0x03A3; break; // GREEK CAPITAL LETTER SIGMA
    case 0xA5D3: code_point = 0x03A4; break; // GREEK CAPITAL LETTER TAU
    case 0xA5D4: code_point = 0x03A5; break; // GREEK CAPITAL LETTER UPSILON
    case 0xA5D5: code_point = 0x03A6; break; // GREEK CAPITAL LETTER PHI
    case 0xA5D6: code_point = 0x03A7; break; // GREEK CAPITAL LETTER CHI
    case 0xA5D7: code_point = 0x03A8; break; // GREEK CAPITAL LETTER PSI
    case 0xA5D8: code_point = 0x03A9; break; // GREEK CAPITAL LETTER OMEGA
    case 0xA5E1: code_point = 0x03B1; break; // GREEK SMALL LETTER ALPHA
    case 0xA5E2: code_point = 0x03B2; break; // GREEK SMALL LETTER BETA
    case 0xA5E3: code_point = 0x03B3; break; // GREEK SMALL LETTER GAMMA
    case 0xA5E4: code_point = 0x03B4; break; // GREEK SMALL LETTER DELTA
    case 0xA5E5: code_point = 0x03B5; break; // GREEK SMALL LETTER EPSILON
    case 0xA5E6: code_point = 0x03B6; break; // GREEK SMALL LETTER ZETA
    case 0xA5E7: code_point = 0x03B7; break; // GREEK SMALL LETTER ETA
    case 0xA5E8: code_point = 0x03B8; break; // GREEK SMALL LETTER THETA
    case 0xA5E9: code_point = 0x03B9; break; // GREEK SMALL LETTER IOTA
    case 0xA5EA: code_point = 0x03BA; break; // GREEK SMALL LETTER KAPPA
    case 0xA5EB: code_point = 0x03BB; break; // GREEK SMALL LETTER LAMDA
    case 0xA5EC: code_point = 0x03BC; break; // GREEK SMALL LETTER MU
    case 0xA5ED: code_point = 0x03BD; break; // GREEK SMALL LETTER NU
    case 0xA5EE: code_point = 0x03BE; break; // GREEK SMALL LETTER XI
    case 0xA5EF: code_point = 0x03BF; break; // GREEK SMALL LETTER OMICRON
    case 0xA5F0: code_point = 0x03C0; break; // GREEK SMALL LETTER PI
    case 0xA5F1: code_point = 0x03C1; break; // GREEK SMALL LETTER RHO
    case 0xA5F2: code_point = 0x03C3; break; // GREEK SMALL LETTER SIGMA
    case 0xA5F3: code_point = 0x03C4; break; // GREEK SMALL LETTER TAU
    case 0xA5F4: code_point = 0x03C5; break; // GREEK SMALL LETTER UPSILON
    case 0xA5F5: code_point = 0x03C6; break; // GREEK SMALL LETTER PHI
    case 0xA5F6: code_point = 0x03C7; break; // GREEK SMALL LETTER CHI
    case 0xA5F7: code_point = 0x03C8; break; // GREEK SMALL LETTER PSI
    case 0xA5F8: code_point = 0x03C9; break; // GREEK SMALL LETTER OMEGA
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA6(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA641: code_point = 0xCAA8; break; // HANGUL SYLLABLE SSANGCIEUC YE RIEUL
    case 0xA642: code_point = 0xCAA9; break; // HANGUL SYLLABLE SSANGCIEUC YE RIEULKIYEOK
    case 0xA643: code_point = 0xCAAA; break; // HANGUL SYLLABLE SSANGCIEUC YE RIEULMIEUM
    case 0xA644: code_point = 0xCAAB; break; // HANGUL SYLLABLE SSANGCIEUC YE RIEULPIEUP
    case 0xA645: code_point = 0xCAAC; break; // HANGUL SYLLABLE SSANGCIEUC YE RIEULSIOS
    case 0xA646: code_point = 0xCAAD; break; // HANGUL SYLLABLE SSANGCIEUC YE RIEULTHIEUTH
    case 0xA647: code_point = 0xCAAE; break; // HANGUL SYLLABLE SSANGCIEUC YE RIEULPHIEUPH
    case 0xA648: code_point = 0xCAAF; break; // HANGUL SYLLABLE SSANGCIEUC YE RIEULHIEUH
    case 0xA649: code_point = 0xCAB0; break; // HANGUL SYLLABLE SSANGCIEUC YE MIEUM
    case 0xA64A: code_point = 0xCAB1; break; // HANGUL SYLLABLE SSANGCIEUC YE PIEUP
    case 0xA64B: code_point = 0xCAB2; break; // HANGUL SYLLABLE SSANGCIEUC YE PIEUPSIOS
    case 0xA64C: code_point = 0xCAB3; break; // HANGUL SYLLABLE SSANGCIEUC YE SIOS
    case 0xA64D: code_point = 0xCAB4; break; // HANGUL SYLLABLE SSANGCIEUC YE SSANGSIOS
    case 0xA64E: code_point = 0xCAB5; break; // HANGUL SYLLABLE SSANGCIEUC YE IEUNG
    case 0xA64F: code_point = 0xCAB6; break; // HANGUL SYLLABLE SSANGCIEUC YE CIEUC
    case 0xA650: code_point = 0xCAB7; break; // HANGUL SYLLABLE SSANGCIEUC YE CHIEUCH
    case 0xA651: code_point = 0xCAB8; break; // HANGUL SYLLABLE SSANGCIEUC YE KHIEUKH
    case 0xA652: code_point = 0xCAB9; break; // HANGUL SYLLABLE SSANGCIEUC YE THIEUTH
    case 0xA653: code_point = 0xCABA; break; // HANGUL SYLLABLE SSANGCIEUC YE PHIEUPH
    case 0xA654: code_point = 0xCABB; break; // HANGUL SYLLABLE SSANGCIEUC YE HIEUH
    case 0xA655: code_point = 0xCABE; break; // HANGUL SYLLABLE SSANGCIEUC O SSANGKIYEOK
    case 0xA656: code_point = 0xCABF; break; // HANGUL SYLLABLE SSANGCIEUC O KIYEOKSIOS
    case 0xA657: code_point = 0xCAC1; break; // HANGUL SYLLABLE SSANGCIEUC O NIEUNCIEUC
    case 0xA658: code_point = 0xCAC2; break; // HANGUL SYLLABLE SSANGCIEUC O NIEUNHIEUH
    case 0xA659: code_point = 0xCAC3; break; // HANGUL SYLLABLE SSANGCIEUC O TIKEUT
    case 0xA65A: code_point = 0xCAC5; break; // HANGUL SYLLABLE SSANGCIEUC O RIEULKIYEOK
    case 0xA661: code_point = 0xCAC6; break; // HANGUL SYLLABLE SSANGCIEUC O RIEULMIEUM
    case 0xA662: code_point = 0xCAC7; break; // HANGUL SYLLABLE SSANGCIEUC O RIEULPIEUP
    case 0xA663: code_point = 0xCAC8; break; // HANGUL SYLLABLE SSANGCIEUC O RIEULSIOS
    case 0xA664: code_point = 0xCAC9; break; // HANGUL SYLLABLE SSANGCIEUC O RIEULTHIEUTH
    case 0xA665: code_point = 0xCACA; break; // HANGUL SYLLABLE SSANGCIEUC O RIEULPHIEUPH
    case 0xA666: code_point = 0xCACB; break; // HANGUL SYLLABLE SSANGCIEUC O RIEULHIEUH
    case 0xA667: code_point = 0xCACE; break; // HANGUL SYLLABLE SSANGCIEUC O PIEUPSIOS
    case 0xA668: code_point = 0xCAD0; break; // HANGUL SYLLABLE SSANGCIEUC O SSANGSIOS
    case 0xA669: code_point = 0xCAD2; break; // HANGUL SYLLABLE SSANGCIEUC O CIEUC
    case 0xA66A: code_point = 0xCAD4; break; // HANGUL SYLLABLE SSANGCIEUC O KHIEUKH
    case 0xA66B: code_point = 0xCAD5; break; // HANGUL SYLLABLE SSANGCIEUC O THIEUTH
    case 0xA66C: code_point = 0xCAD6; break; // HANGUL SYLLABLE SSANGCIEUC O PHIEUPH
    case 0xA66D: code_point = 0xCAD7; break; // HANGUL SYLLABLE SSANGCIEUC O HIEUH
    case 0xA66E: code_point = 0xCADA; break; // HANGUL SYLLABLE SSANGCIEUC WA SSANGKIYEOK
    case 0xA66F: code_point = 0xCADB; break; // HANGUL SYLLABLE SSANGCIEUC WA KIYEOKSIOS
    case 0xA670: code_point = 0xCADC; break; // HANGUL SYLLABLE SSANGCIEUC WA NIEUN
    case 0xA671: code_point = 0xCADD; break; // HANGUL SYLLABLE SSANGCIEUC WA NIEUNCIEUC
    case 0xA672: code_point = 0xCADE; break; // HANGUL SYLLABLE SSANGCIEUC WA NIEUNHIEUH
    case 0xA673: code_point = 0xCADF; break; // HANGUL SYLLABLE SSANGCIEUC WA TIKEUT
    case 0xA674: code_point = 0xCAE1; break; // HANGUL SYLLABLE SSANGCIEUC WA RIEULKIYEOK
    case 0xA675: code_point = 0xCAE2; break; // HANGUL SYLLABLE SSANGCIEUC WA RIEULMIEUM
    case 0xA676: code_point = 0xCAE3; break; // HANGUL SYLLABLE SSANGCIEUC WA RIEULPIEUP
    case 0xA677: code_point = 0xCAE4; break; // HANGUL SYLLABLE SSANGCIEUC WA RIEULSIOS
    case 0xA678: code_point = 0xCAE5; break; // HANGUL SYLLABLE SSANGCIEUC WA RIEULTHIEUTH
    case 0xA679: code_point = 0xCAE6; break; // HANGUL SYLLABLE SSANGCIEUC WA RIEULPHIEUPH
    case 0xA67A: code_point = 0xCAE7; break; // HANGUL SYLLABLE SSANGCIEUC WA RIEULHIEUH
    case 0xA681: code_point = 0xCAE8; break; // HANGUL SYLLABLE SSANGCIEUC WA MIEUM
    case 0xA682: code_point = 0xCAE9; break; // HANGUL SYLLABLE SSANGCIEUC WA PIEUP
    case 0xA683: code_point = 0xCAEA; break; // HANGUL SYLLABLE SSANGCIEUC WA PIEUPSIOS
    case 0xA684: code_point = 0xCAEB; break; // HANGUL SYLLABLE SSANGCIEUC WA SIOS
    case 0xA685: code_point = 0xCAED; break; // HANGUL SYLLABLE SSANGCIEUC WA IEUNG
    case 0xA686: code_point = 0xCAEE; break; // HANGUL SYLLABLE SSANGCIEUC WA CIEUC
    case 0xA687: code_point = 0xCAEF; break; // HANGUL SYLLABLE SSANGCIEUC WA CHIEUCH
    case 0xA688: code_point = 0xCAF0; break; // HANGUL SYLLABLE SSANGCIEUC WA KHIEUKH
    case 0xA689: code_point = 0xCAF1; break; // HANGUL SYLLABLE SSANGCIEUC WA THIEUTH
    case 0xA68A: code_point = 0xCAF2; break; // HANGUL SYLLABLE SSANGCIEUC WA PHIEUPH
    case 0xA68B: code_point = 0xCAF3; break; // HANGUL SYLLABLE SSANGCIEUC WA HIEUH
    case 0xA68C: code_point = 0xCAF5; break; // HANGUL SYLLABLE SSANGCIEUC WAE KIYEOK
    case 0xA68D: code_point = 0xCAF6; break; // HANGUL SYLLABLE SSANGCIEUC WAE SSANGKIYEOK
    case 0xA68E: code_point = 0xCAF7; break; // HANGUL SYLLABLE SSANGCIEUC WAE KIYEOKSIOS
    case 0xA68F: code_point = 0xCAF8; break; // HANGUL SYLLABLE SSANGCIEUC WAE NIEUN
    case 0xA690: code_point = 0xCAF9; break; // HANGUL SYLLABLE SSANGCIEUC WAE NIEUNCIEUC
    case 0xA691: code_point = 0xCAFA; break; // HANGUL SYLLABLE SSANGCIEUC WAE NIEUNHIEUH
    case 0xA692: code_point = 0xCAFB; break; // HANGUL SYLLABLE SSANGCIEUC WAE TIKEUT
    case 0xA693: code_point = 0xCAFC; break; // HANGUL SYLLABLE SSANGCIEUC WAE RIEUL
    case 0xA694: code_point = 0xCAFD; break; // HANGUL SYLLABLE SSANGCIEUC WAE RIEULKIYEOK
    case 0xA695: code_point = 0xCAFE; break; // HANGUL SYLLABLE SSANGCIEUC WAE RIEULMIEUM
    case 0xA696: code_point = 0xCAFF; break; // HANGUL SYLLABLE SSANGCIEUC WAE RIEULPIEUP
    case 0xA697: code_point = 0xCB00; break; // HANGUL SYLLABLE SSANGCIEUC WAE RIEULSIOS
    case 0xA698: code_point = 0xCB01; break; // HANGUL SYLLABLE SSANGCIEUC WAE RIEULTHIEUTH
    case 0xA699: code_point = 0xCB02; break; // HANGUL SYLLABLE SSANGCIEUC WAE RIEULPHIEUPH
    case 0xA69A: code_point = 0xCB03; break; // HANGUL SYLLABLE SSANGCIEUC WAE RIEULHIEUH
    case 0xA69B: code_point = 0xCB04; break; // HANGUL SYLLABLE SSANGCIEUC WAE MIEUM
    case 0xA69C: code_point = 0xCB05; break; // HANGUL SYLLABLE SSANGCIEUC WAE PIEUP
    case 0xA69D: code_point = 0xCB06; break; // HANGUL SYLLABLE SSANGCIEUC WAE PIEUPSIOS
    case 0xA69E: code_point = 0xCB07; break; // HANGUL SYLLABLE SSANGCIEUC WAE SIOS
    case 0xA69F: code_point = 0xCB09; break; // HANGUL SYLLABLE SSANGCIEUC WAE IEUNG
    case 0xA6A0: code_point = 0xCB0A; break; // HANGUL SYLLABLE SSANGCIEUC WAE CIEUC
    case 0xA6A1: code_point = 0x2500; break; // BOX DRAWINGS LIGHT HORIZONTAL
    case 0xA6A2: code_point = 0x2502; break; // BOX DRAWINGS LIGHT VERTICAL
    case 0xA6A3: code_point = 0x250C; break; // BOX DRAWINGS LIGHT DOWN AND RIGHT
    case 0xA6A4: code_point = 0x2510; break; // BOX DRAWINGS LIGHT DOWN AND LEFT
    case 0xA6A5: code_point = 0x2518; break; // BOX DRAWINGS LIGHT UP AND LEFT
    case 0xA6A6: code_point = 0x2514; break; // BOX DRAWINGS LIGHT UP AND RIGHT
    case 0xA6A7: code_point = 0x251C; break; // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
    case 0xA6A8: code_point = 0x252C; break; // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
    case 0xA6A9: code_point = 0x2524; break; // BOX DRAWINGS LIGHT VERTICAL AND LEFT
    case 0xA6AA: code_point = 0x2534; break; // BOX DRAWINGS LIGHT UP AND HORIZONTAL
    case 0xA6AB: code_point = 0x253C; break; // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
    case 0xA6AC: code_point = 0x2501; break; // BOX DRAWINGS HEAVY HORIZONTAL
    case 0xA6AD: code_point = 0x2503; break; // BOX DRAWINGS HEAVY VERTICAL
    case 0xA6AE: code_point = 0x250F; break; // BOX DRAWINGS HEAVY DOWN AND RIGHT
    case 0xA6AF: code_point = 0x2513; break; // BOX DRAWINGS HEAVY DOWN AND LEFT
    case 0xA6B0: code_point = 0x251B; break; // BOX DRAWINGS HEAVY UP AND LEFT
    case 0xA6B1: code_point = 0x2517; break; // BOX DRAWINGS HEAVY UP AND RIGHT
    case 0xA6B2: code_point = 0x2523; break; // BOX DRAWINGS HEAVY VERTICAL AND RIGHT
    case 0xA6B3: code_point = 0x2533; break; // BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
    case 0xA6B4: code_point = 0x252B; break; // BOX DRAWINGS HEAVY VERTICAL AND LEFT
    case 0xA6B5: code_point = 0x253B; break; // BOX DRAWINGS HEAVY UP AND HORIZONTAL
    case 0xA6B6: code_point = 0x254B; break; // BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
    case 0xA6B7: code_point = 0x2520; break; // BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
    case 0xA6B8: code_point = 0x252F; break; // BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
    case 0xA6B9: code_point = 0x2528; break; // BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
    case 0xA6BA: code_point = 0x2537; break; // BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
    case 0xA6BB: code_point = 0x253F; break; // BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
    case 0xA6BC: code_point = 0x251D; break; // BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
    case 0xA6BD: code_point = 0x2530; break; // BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
    case 0xA6BE: code_point = 0x2525; break; // BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
    case 0xA6BF: code_point = 0x2538; break; // BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
    case 0xA6C0: code_point = 0x2542; break; // BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
    case 0xA6C1: code_point = 0x2512; break; // BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
    case 0xA6C2: code_point = 0x2511; break; // BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
    case 0xA6C3: code_point = 0x251A; break; // BOX DRAWINGS UP HEAVY AND LEFT LIGHT
    case 0xA6C4: code_point = 0x2519; break; // BOX DRAWINGS UP LIGHT AND LEFT HEAVY
    case 0xA6C5: code_point = 0x2516; break; // BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
    case 0xA6C6: code_point = 0x2515; break; // BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
    case 0xA6C7: code_point = 0x250E; break; // BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
    case 0xA6C8: code_point = 0x250D; break; // BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
    case 0xA6C9: code_point = 0x251E; break; // BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
    case 0xA6CA: code_point = 0x251F; break; // BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
    case 0xA6CB: code_point = 0x2521; break; // BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
    case 0xA6CC: code_point = 0x2522; break; // BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
    case 0xA6CD: code_point = 0x2526; break; // BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
    case 0xA6CE: code_point = 0x2527; break; // BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
    case 0xA6CF: code_point = 0x2529; break; // BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
    case 0xA6D0: code_point = 0x252A; break; // BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
    case 0xA6D1: code_point = 0x252D; break; // BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
    case 0xA6D2: code_point = 0x252E; break; // BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
    case 0xA6D3: code_point = 0x2531; break; // BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
    case 0xA6D4: code_point = 0x2532; break; // BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
    case 0xA6D5: code_point = 0x2535; break; // BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
    case 0xA6D6: code_point = 0x2536; break; // BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
    case 0xA6D7: code_point = 0x2539; break; // BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
    case 0xA6D8: code_point = 0x253A; break; // BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
    case 0xA6D9: code_point = 0x253D; break; // BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
    case 0xA6DA: code_point = 0x253E; break; // BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
    case 0xA6DB: code_point = 0x2540; break; // BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
    case 0xA6DC: code_point = 0x2541; break; // BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
    case 0xA6DD: code_point = 0x2543; break; // BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
    case 0xA6DE: code_point = 0x2544; break; // BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
    case 0xA6DF: code_point = 0x2545; break; // BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
    case 0xA6E0: code_point = 0x2546; break; // BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
    case 0xA6E1: code_point = 0x2547; break; // BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
    case 0xA6E2: code_point = 0x2548; break; // BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
    case 0xA6E3: code_point = 0x2549; break; // BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
    case 0xA6E4: code_point = 0x254A; break; // BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA7(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA741: code_point = 0xCB0B; break; // HANGUL SYLLABLE SSANGCIEUC WAE CHIEUCH
    case 0xA742: code_point = 0xCB0C; break; // HANGUL SYLLABLE SSANGCIEUC WAE KHIEUKH
    case 0xA743: code_point = 0xCB0D; break; // HANGUL SYLLABLE SSANGCIEUC WAE THIEUTH
    case 0xA744: code_point = 0xCB0E; break; // HANGUL SYLLABLE SSANGCIEUC WAE PHIEUPH
    case 0xA745: code_point = 0xCB0F; break; // HANGUL SYLLABLE SSANGCIEUC WAE HIEUH
    case 0xA746: code_point = 0xCB11; break; // HANGUL SYLLABLE SSANGCIEUC OE KIYEOK
    case 0xA747: code_point = 0xCB12; break; // HANGUL SYLLABLE SSANGCIEUC OE SSANGKIYEOK
    case 0xA748: code_point = 0xCB13; break; // HANGUL SYLLABLE SSANGCIEUC OE KIYEOKSIOS
    case 0xA749: code_point = 0xCB15; break; // HANGUL SYLLABLE SSANGCIEUC OE NIEUNCIEUC
    case 0xA74A: code_point = 0xCB16; break; // HANGUL SYLLABLE SSANGCIEUC OE NIEUNHIEUH
    case 0xA74B: code_point = 0xCB17; break; // HANGUL SYLLABLE SSANGCIEUC OE TIKEUT
    case 0xA74C: code_point = 0xCB19; break; // HANGUL SYLLABLE SSANGCIEUC OE RIEULKIYEOK
    case 0xA74D: code_point = 0xCB1A; break; // HANGUL SYLLABLE SSANGCIEUC OE RIEULMIEUM
    case 0xA74E: code_point = 0xCB1B; break; // HANGUL SYLLABLE SSANGCIEUC OE RIEULPIEUP
    case 0xA74F: code_point = 0xCB1C; break; // HANGUL SYLLABLE SSANGCIEUC OE RIEULSIOS
    case 0xA750: code_point = 0xCB1D; break; // HANGUL SYLLABLE SSANGCIEUC OE RIEULTHIEUTH
    case 0xA751: code_point = 0xCB1E; break; // HANGUL SYLLABLE SSANGCIEUC OE RIEULPHIEUPH
    case 0xA752: code_point = 0xCB1F; break; // HANGUL SYLLABLE SSANGCIEUC OE RIEULHIEUH
    case 0xA753: code_point = 0xCB22; break; // HANGUL SYLLABLE SSANGCIEUC OE PIEUPSIOS
    case 0xA754: code_point = 0xCB23; break; // HANGUL SYLLABLE SSANGCIEUC OE SIOS
    case 0xA755: code_point = 0xCB24; break; // HANGUL SYLLABLE SSANGCIEUC OE SSANGSIOS
    case 0xA756: code_point = 0xCB25; break; // HANGUL SYLLABLE SSANGCIEUC OE IEUNG
    case 0xA757: code_point = 0xCB26; break; // HANGUL SYLLABLE SSANGCIEUC OE CIEUC
    case 0xA758: code_point = 0xCB27; break; // HANGUL SYLLABLE SSANGCIEUC OE CHIEUCH
    case 0xA759: code_point = 0xCB28; break; // HANGUL SYLLABLE SSANGCIEUC OE KHIEUKH
    case 0xA75A: code_point = 0xCB29; break; // HANGUL SYLLABLE SSANGCIEUC OE THIEUTH
    case 0xA761: code_point = 0xCB2A; break; // HANGUL SYLLABLE SSANGCIEUC OE PHIEUPH
    case 0xA762: code_point = 0xCB2B; break; // HANGUL SYLLABLE SSANGCIEUC OE HIEUH
    case 0xA763: code_point = 0xCB2C; break; // HANGUL SYLLABLE SSANGCIEUC YO
    case 0xA764: code_point = 0xCB2D; break; // HANGUL SYLLABLE SSANGCIEUC YO KIYEOK
    case 0xA765: code_point = 0xCB2E; break; // HANGUL SYLLABLE SSANGCIEUC YO SSANGKIYEOK
    case 0xA766: code_point = 0xCB2F; break; // HANGUL SYLLABLE SSANGCIEUC YO KIYEOKSIOS
    case 0xA767: code_point = 0xCB30; break; // HANGUL SYLLABLE SSANGCIEUC YO NIEUN
    case 0xA768: code_point = 0xCB31; break; // HANGUL SYLLABLE SSANGCIEUC YO NIEUNCIEUC
    case 0xA769: code_point = 0xCB32; break; // HANGUL SYLLABLE SSANGCIEUC YO NIEUNHIEUH
    case 0xA76A: code_point = 0xCB33; break; // HANGUL SYLLABLE SSANGCIEUC YO TIKEUT
    case 0xA76B: code_point = 0xCB34; break; // HANGUL SYLLABLE SSANGCIEUC YO RIEUL
    case 0xA76C: code_point = 0xCB35; break; // HANGUL SYLLABLE SSANGCIEUC YO RIEULKIYEOK
    case 0xA76D: code_point = 0xCB36; break; // HANGUL SYLLABLE SSANGCIEUC YO RIEULMIEUM
    case 0xA76E: code_point = 0xCB37; break; // HANGUL SYLLABLE SSANGCIEUC YO RIEULPIEUP
    case 0xA76F: code_point = 0xCB38; break; // HANGUL SYLLABLE SSANGCIEUC YO RIEULSIOS
    case 0xA770: code_point = 0xCB39; break; // HANGUL SYLLABLE SSANGCIEUC YO RIEULTHIEUTH
    case 0xA771: code_point = 0xCB3A; break; // HANGUL SYLLABLE SSANGCIEUC YO RIEULPHIEUPH
    case 0xA772: code_point = 0xCB3B; break; // HANGUL SYLLABLE SSANGCIEUC YO RIEULHIEUH
    case 0xA773: code_point = 0xCB3C; break; // HANGUL SYLLABLE SSANGCIEUC YO MIEUM
    case 0xA774: code_point = 0xCB3D; break; // HANGUL SYLLABLE SSANGCIEUC YO PIEUP
    case 0xA775: code_point = 0xCB3E; break; // HANGUL SYLLABLE SSANGCIEUC YO PIEUPSIOS
    case 0xA776: code_point = 0xCB3F; break; // HANGUL SYLLABLE SSANGCIEUC YO SIOS
    case 0xA777: code_point = 0xCB40; break; // HANGUL SYLLABLE SSANGCIEUC YO SSANGSIOS
    case 0xA778: code_point = 0xCB42; break; // HANGUL SYLLABLE SSANGCIEUC YO CIEUC
    case 0xA779: code_point = 0xCB43; break; // HANGUL SYLLABLE SSANGCIEUC YO CHIEUCH
    case 0xA77A: code_point = 0xCB44; break; // HANGUL SYLLABLE SSANGCIEUC YO KHIEUKH
    case 0xA781: code_point = 0xCB45; break; // HANGUL SYLLABLE SSANGCIEUC YO THIEUTH
    case 0xA782: code_point = 0xCB46; break; // HANGUL SYLLABLE SSANGCIEUC YO PHIEUPH
    case 0xA783: code_point = 0xCB47; break; // HANGUL SYLLABLE SSANGCIEUC YO HIEUH
    case 0xA784: code_point = 0xCB4A; break; // HANGUL SYLLABLE SSANGCIEUC U SSANGKIYEOK
    case 0xA785: code_point = 0xCB4B; break; // HANGUL SYLLABLE SSANGCIEUC U KIYEOKSIOS
    case 0xA786: code_point = 0xCB4D; break; // HANGUL SYLLABLE SSANGCIEUC U NIEUNCIEUC
    case 0xA787: code_point = 0xCB4E; break; // HANGUL SYLLABLE SSANGCIEUC U NIEUNHIEUH
    case 0xA788: code_point = 0xCB4F; break; // HANGUL SYLLABLE SSANGCIEUC U TIKEUT
    case 0xA789: code_point = 0xCB51; break; // HANGUL SYLLABLE SSANGCIEUC U RIEULKIYEOK
    case 0xA78A: code_point = 0xCB52; break; // HANGUL SYLLABLE SSANGCIEUC U RIEULMIEUM
    case 0xA78B: code_point = 0xCB53; break; // HANGUL SYLLABLE SSANGCIEUC U RIEULPIEUP
    case 0xA78C: code_point = 0xCB54; break; // HANGUL SYLLABLE SSANGCIEUC U RIEULSIOS
    case 0xA78D: code_point = 0xCB55; break; // HANGUL SYLLABLE SSANGCIEUC U RIEULTHIEUTH
    case 0xA78E: code_point = 0xCB56; break; // HANGUL SYLLABLE SSANGCIEUC U RIEULPHIEUPH
    case 0xA78F: code_point = 0xCB57; break; // HANGUL SYLLABLE SSANGCIEUC U RIEULHIEUH
    case 0xA790: code_point = 0xCB5A; break; // HANGUL SYLLABLE SSANGCIEUC U PIEUPSIOS
    case 0xA791: code_point = 0xCB5B; break; // HANGUL SYLLABLE SSANGCIEUC U SIOS
    case 0xA792: code_point = 0xCB5C; break; // HANGUL SYLLABLE SSANGCIEUC U SSANGSIOS
    case 0xA793: code_point = 0xCB5E; break; // HANGUL SYLLABLE SSANGCIEUC U CIEUC
    case 0xA794: code_point = 0xCB5F; break; // HANGUL SYLLABLE SSANGCIEUC U CHIEUCH
    case 0xA795: code_point = 0xCB60; break; // HANGUL SYLLABLE SSANGCIEUC U KHIEUKH
    case 0xA796: code_point = 0xCB61; break; // HANGUL SYLLABLE SSANGCIEUC U THIEUTH
    case 0xA797: code_point = 0xCB62; break; // HANGUL SYLLABLE SSANGCIEUC U PHIEUPH
    case 0xA798: code_point = 0xCB63; break; // HANGUL SYLLABLE SSANGCIEUC U HIEUH
    case 0xA799: code_point = 0xCB65; break; // HANGUL SYLLABLE SSANGCIEUC WEO KIYEOK
    case 0xA79A: code_point = 0xCB66; break; // HANGUL SYLLABLE SSANGCIEUC WEO SSANGKIYEOK
    case 0xA79B: code_point = 0xCB67; break; // HANGUL SYLLABLE SSANGCIEUC WEO KIYEOKSIOS
    case 0xA79C: code_point = 0xCB68; break; // HANGUL SYLLABLE SSANGCIEUC WEO NIEUN
    case 0xA79D: code_point = 0xCB69; break; // HANGUL SYLLABLE SSANGCIEUC WEO NIEUNCIEUC
    case 0xA79E: code_point = 0xCB6A; break; // HANGUL SYLLABLE SSANGCIEUC WEO NIEUNHIEUH
    case 0xA79F: code_point = 0xCB6B; break; // HANGUL SYLLABLE SSANGCIEUC WEO TIKEUT
    case 0xA7A0: code_point = 0xCB6C; break; // HANGUL SYLLABLE SSANGCIEUC WEO RIEUL
    case 0xA7A1: code_point = 0x3395; break; // SQUARE MU L
    case 0xA7A2: code_point = 0x3396; break; // SQUARE ML
    case 0xA7A3: code_point = 0x3397; break; // SQUARE DL
    case 0xA7A4: code_point = 0x2113; break; // SCRIPT SMALL L
    case 0xA7A5: code_point = 0x3398; break; // SQUARE KL
    case 0xA7A6: code_point = 0x33C4; break; // SQUARE CC
    case 0xA7A7: code_point = 0x33A3; break; // SQUARE MM CUBED
    case 0xA7A8: code_point = 0x33A4; break; // SQUARE CM CUBED
    case 0xA7A9: code_point = 0x33A5; break; // SQUARE M CUBED
    case 0xA7AA: code_point = 0x33A6; break; // SQUARE KM CUBED
    case 0xA7AB: code_point = 0x3399; break; // SQUARE FM
    case 0xA7AC: code_point = 0x339A; break; // SQUARE NM
    case 0xA7AD: code_point = 0x339B; break; // SQUARE MU M
    case 0xA7AE: code_point = 0x339C; break; // SQUARE MM
    case 0xA7AF: code_point = 0x339D; break; // SQUARE CM
    case 0xA7B0: code_point = 0x339E; break; // SQUARE KM
    case 0xA7B1: code_point = 0x339F; break; // SQUARE MM SQUARED
    case 0xA7B2: code_point = 0x33A0; break; // SQUARE CM SQUARED
    case 0xA7B3: code_point = 0x33A1; break; // SQUARE M SQUARED
    case 0xA7B4: code_point = 0x33A2; break; // SQUARE KM SQUARED
    case 0xA7B5: code_point = 0x33CA; break; // SQUARE HA
    case 0xA7B6: code_point = 0x338D; break; // SQUARE MU G
    case 0xA7B7: code_point = 0x338E; break; // SQUARE MG
    case 0xA7B8: code_point = 0x338F; break; // SQUARE KG
    case 0xA7B9: code_point = 0x33CF; break; // SQUARE KT
    case 0xA7BA: code_point = 0x3388; break; // SQUARE CAL
    case 0xA7BB: code_point = 0x3389; break; // SQUARE KCAL
    case 0xA7BC: code_point = 0x33C8; break; // SQUARE DB
    case 0xA7BD: code_point = 0x33A7; break; // SQUARE M OVER S
    case 0xA7BE: code_point = 0x33A8; break; // SQUARE M OVER S SQUARED
    case 0xA7BF: code_point = 0x33B0; break; // SQUARE PS
    case 0xA7C0: code_point = 0x33B1; break; // SQUARE NS
    case 0xA7C1: code_point = 0x33B2; break; // SQUARE MU S
    case 0xA7C2: code_point = 0x33B3; break; // SQUARE MS
    case 0xA7C3: code_point = 0x33B4; break; // SQUARE PV
    case 0xA7C4: code_point = 0x33B5; break; // SQUARE NV
    case 0xA7C5: code_point = 0x33B6; break; // SQUARE MU V
    case 0xA7C6: code_point = 0x33B7; break; // SQUARE MV
    case 0xA7C7: code_point = 0x33B8; break; // SQUARE KV
    case 0xA7C8: code_point = 0x33B9; break; // SQUARE MV MEGA
    case 0xA7C9: code_point = 0x3380; break; // SQUARE PA AMPS
    case 0xA7CA: code_point = 0x3381; break; // SQUARE NA
    case 0xA7CB: code_point = 0x3382; break; // SQUARE MU A
    case 0xA7CC: code_point = 0x3383; break; // SQUARE MA
    case 0xA7CD: code_point = 0x3384; break; // SQUARE KA
    case 0xA7CE: code_point = 0x33BA; break; // SQUARE PW
    case 0xA7CF: code_point = 0x33BB; break; // SQUARE NW
    case 0xA7D0: code_point = 0x33BC; break; // SQUARE MU W
    case 0xA7D1: code_point = 0x33BD; break; // SQUARE MW
    case 0xA7D2: code_point = 0x33BE; break; // SQUARE KW
    case 0xA7D3: code_point = 0x33BF; break; // SQUARE MW MEGA
    case 0xA7D4: code_point = 0x3390; break; // SQUARE HZ
    case 0xA7D5: code_point = 0x3391; break; // SQUARE KHZ
    case 0xA7D6: code_point = 0x3392; break; // SQUARE MHZ
    case 0xA7D7: code_point = 0x3393; break; // SQUARE GHZ
    case 0xA7D8: code_point = 0x3394; break; // SQUARE THZ
    case 0xA7D9: code_point = 0x2126; break; // OHM SIGN
    case 0xA7DA: code_point = 0x33C0; break; // SQUARE K OHM
    case 0xA7DB: code_point = 0x33C1; break; // SQUARE M OHM
    case 0xA7DC: code_point = 0x338A; break; // SQUARE PF
    case 0xA7DD: code_point = 0x338B; break; // SQUARE NF
    case 0xA7DE: code_point = 0x338C; break; // SQUARE MU F
    case 0xA7DF: code_point = 0x33D6; break; // SQUARE MOL
    case 0xA7E0: code_point = 0x33C5; break; // SQUARE CD
    case 0xA7E1: code_point = 0x33AD; break; // SQUARE RAD
    case 0xA7E2: code_point = 0x33AE; break; // SQUARE RAD OVER S
    case 0xA7E3: code_point = 0x33AF; break; // SQUARE RAD OVER S SQUARED
    case 0xA7E4: code_point = 0x33DB; break; // SQUARE SR
    case 0xA7E5: code_point = 0x33A9; break; // SQUARE PA
    case 0xA7E6: code_point = 0x33AA; break; // SQUARE KPA
    case 0xA7E7: code_point = 0x33AB; break; // SQUARE MPA
    case 0xA7E8: code_point = 0x33AC; break; // SQUARE GPA
    case 0xA7E9: code_point = 0x33DD; break; // SQUARE WB
    case 0xA7EA: code_point = 0x33D0; break; // SQUARE LM
    case 0xA7EB: code_point = 0x33D3; break; // SQUARE LX
    case 0xA7EC: code_point = 0x33C3; break; // SQUARE BQ
    case 0xA7ED: code_point = 0x33C9; break; // SQUARE GY
    case 0xA7EE: code_point = 0x33DC; break; // SQUARE SV
    case 0xA7EF: code_point = 0x33C6; break; // SQUARE C OVER KG
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA8(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA841: code_point = 0xCB6D; break; // HANGUL SYLLABLE SSANGCIEUC WEO RIEULKIYEOK
    case 0xA842: code_point = 0xCB6E; break; // HANGUL SYLLABLE SSANGCIEUC WEO RIEULMIEUM
    case 0xA843: code_point = 0xCB6F; break; // HANGUL SYLLABLE SSANGCIEUC WEO RIEULPIEUP
    case 0xA844: code_point = 0xCB70; break; // HANGUL SYLLABLE SSANGCIEUC WEO RIEULSIOS
    case 0xA845: code_point = 0xCB71; break; // HANGUL SYLLABLE SSANGCIEUC WEO RIEULTHIEUTH
    case 0xA846: code_point = 0xCB72; break; // HANGUL SYLLABLE SSANGCIEUC WEO RIEULPHIEUPH
    case 0xA847: code_point = 0xCB73; break; // HANGUL SYLLABLE SSANGCIEUC WEO RIEULHIEUH
    case 0xA848: code_point = 0xCB74; break; // HANGUL SYLLABLE SSANGCIEUC WEO MIEUM
    case 0xA849: code_point = 0xCB75; break; // HANGUL SYLLABLE SSANGCIEUC WEO PIEUP
    case 0xA84A: code_point = 0xCB76; break; // HANGUL SYLLABLE SSANGCIEUC WEO PIEUPSIOS
    case 0xA84B: code_point = 0xCB77; break; // HANGUL SYLLABLE SSANGCIEUC WEO SIOS
    case 0xA84C: code_point = 0xCB7A; break; // HANGUL SYLLABLE SSANGCIEUC WEO CIEUC
    case 0xA84D: code_point = 0xCB7B; break; // HANGUL SYLLABLE SSANGCIEUC WEO CHIEUCH
    case 0xA84E: code_point = 0xCB7C; break; // HANGUL SYLLABLE SSANGCIEUC WEO KHIEUKH
    case 0xA84F: code_point = 0xCB7D; break; // HANGUL SYLLABLE SSANGCIEUC WEO THIEUTH
    case 0xA850: code_point = 0xCB7E; break; // HANGUL SYLLABLE SSANGCIEUC WEO PHIEUPH
    case 0xA851: code_point = 0xCB7F; break; // HANGUL SYLLABLE SSANGCIEUC WEO HIEUH
    case 0xA852: code_point = 0xCB80; break; // HANGUL SYLLABLE SSANGCIEUC WE
    case 0xA853: code_point = 0xCB81; break; // HANGUL SYLLABLE SSANGCIEUC WE KIYEOK
    case 0xA854: code_point = 0xCB82; break; // HANGUL SYLLABLE SSANGCIEUC WE SSANGKIYEOK
    case 0xA855: code_point = 0xCB83; break; // HANGUL SYLLABLE SSANGCIEUC WE KIYEOKSIOS
    case 0xA856: code_point = 0xCB84; break; // HANGUL SYLLABLE SSANGCIEUC WE NIEUN
    case 0xA857: code_point = 0xCB85; break; // HANGUL SYLLABLE SSANGCIEUC WE NIEUNCIEUC
    case 0xA858: code_point = 0xCB86; break; // HANGUL SYLLABLE SSANGCIEUC WE NIEUNHIEUH
    case 0xA859: code_point = 0xCB87; break; // HANGUL SYLLABLE SSANGCIEUC WE TIKEUT
    case 0xA85A: code_point = 0xCB88; break; // HANGUL SYLLABLE SSANGCIEUC WE RIEUL
    case 0xA861: code_point = 0xCB89; break; // HANGUL SYLLABLE SSANGCIEUC WE RIEULKIYEOK
    case 0xA862: code_point = 0xCB8A; break; // HANGUL SYLLABLE SSANGCIEUC WE RIEULMIEUM
    case 0xA863: code_point = 0xCB8B; break; // HANGUL SYLLABLE SSANGCIEUC WE RIEULPIEUP
    case 0xA864: code_point = 0xCB8C; break; // HANGUL SYLLABLE SSANGCIEUC WE RIEULSIOS
    case 0xA865: code_point = 0xCB8D; break; // HANGUL SYLLABLE SSANGCIEUC WE RIEULTHIEUTH
    case 0xA866: code_point = 0xCB8E; break; // HANGUL SYLLABLE SSANGCIEUC WE RIEULPHIEUPH
    case 0xA867: code_point = 0xCB8F; break; // HANGUL SYLLABLE SSANGCIEUC WE RIEULHIEUH
    case 0xA868: code_point = 0xCB90; break; // HANGUL SYLLABLE SSANGCIEUC WE MIEUM
    case 0xA869: code_point = 0xCB91; break; // HANGUL SYLLABLE SSANGCIEUC WE PIEUP
    case 0xA86A: code_point = 0xCB92; break; // HANGUL SYLLABLE SSANGCIEUC WE PIEUPSIOS
    case 0xA86B: code_point = 0xCB93; break; // HANGUL SYLLABLE SSANGCIEUC WE SIOS
    case 0xA86C: code_point = 0xCB94; break; // HANGUL SYLLABLE SSANGCIEUC WE SSANGSIOS
    case 0xA86D: code_point = 0xCB95; break; // HANGUL SYLLABLE SSANGCIEUC WE IEUNG
    case 0xA86E: code_point = 0xCB96; break; // HANGUL SYLLABLE SSANGCIEUC WE CIEUC
    case 0xA86F: code_point = 0xCB97; break; // HANGUL SYLLABLE SSANGCIEUC WE CHIEUCH
    case 0xA870: code_point = 0xCB98; break; // HANGUL SYLLABLE SSANGCIEUC WE KHIEUKH
    case 0xA871: code_point = 0xCB99; break; // HANGUL SYLLABLE SSANGCIEUC WE THIEUTH
    case 0xA872: code_point = 0xCB9A; break; // HANGUL SYLLABLE SSANGCIEUC WE PHIEUPH
    case 0xA873: code_point = 0xCB9B; break; // HANGUL SYLLABLE SSANGCIEUC WE HIEUH
    case 0xA874: code_point = 0xCB9D; break; // HANGUL SYLLABLE SSANGCIEUC WI KIYEOK
    case 0xA875: code_point = 0xCB9E; break; // HANGUL SYLLABLE SSANGCIEUC WI SSANGKIYEOK
    case 0xA876: code_point = 0xCB9F; break; // HANGUL SYLLABLE SSANGCIEUC WI KIYEOKSIOS
    case 0xA877: code_point = 0xCBA0; break; // HANGUL SYLLABLE SSANGCIEUC WI NIEUN
    case 0xA878: code_point = 0xCBA1; break; // HANGUL SYLLABLE SSANGCIEUC WI NIEUNCIEUC
    case 0xA879: code_point = 0xCBA2; break; // HANGUL SYLLABLE SSANGCIEUC WI NIEUNHIEUH
    case 0xA87A: code_point = 0xCBA3; break; // HANGUL SYLLABLE SSANGCIEUC WI TIKEUT
    case 0xA881: code_point = 0xCBA4; break; // HANGUL SYLLABLE SSANGCIEUC WI RIEUL
    case 0xA882: code_point = 0xCBA5; break; // HANGUL SYLLABLE SSANGCIEUC WI RIEULKIYEOK
    case 0xA883: code_point = 0xCBA6; break; // HANGUL SYLLABLE SSANGCIEUC WI RIEULMIEUM
    case 0xA884: code_point = 0xCBA7; break; // HANGUL SYLLABLE SSANGCIEUC WI RIEULPIEUP
    case 0xA885: code_point = 0xCBA8; break; // HANGUL SYLLABLE SSANGCIEUC WI RIEULSIOS
    case 0xA886: code_point = 0xCBA9; break; // HANGUL SYLLABLE SSANGCIEUC WI RIEULTHIEUTH
    case 0xA887: code_point = 0xCBAA; break; // HANGUL SYLLABLE SSANGCIEUC WI RIEULPHIEUPH
    case 0xA888: code_point = 0xCBAB; break; // HANGUL SYLLABLE SSANGCIEUC WI RIEULHIEUH
    case 0xA889: code_point = 0xCBAC; break; // HANGUL SYLLABLE SSANGCIEUC WI MIEUM
    case 0xA88A: code_point = 0xCBAD; break; // HANGUL SYLLABLE SSANGCIEUC WI PIEUP
    case 0xA88B: code_point = 0xCBAE; break; // HANGUL SYLLABLE SSANGCIEUC WI PIEUPSIOS
    case 0xA88C: code_point = 0xCBAF; break; // HANGUL SYLLABLE SSANGCIEUC WI SIOS
    case 0xA88D: code_point = 0xCBB0; break; // HANGUL SYLLABLE SSANGCIEUC WI SSANGSIOS
    case 0xA88E: code_point = 0xCBB1; break; // HANGUL SYLLABLE SSANGCIEUC WI IEUNG
    case 0xA88F: code_point = 0xCBB2; break; // HANGUL SYLLABLE SSANGCIEUC WI CIEUC
    case 0xA890: code_point = 0xCBB3; break; // HANGUL SYLLABLE SSANGCIEUC WI CHIEUCH
    case 0xA891: code_point = 0xCBB4; break; // HANGUL SYLLABLE SSANGCIEUC WI KHIEUKH
    case 0xA892: code_point = 0xCBB5; break; // HANGUL SYLLABLE SSANGCIEUC WI THIEUTH
    case 0xA893: code_point = 0xCBB6; break; // HANGUL SYLLABLE SSANGCIEUC WI PHIEUPH
    case 0xA894: code_point = 0xCBB7; break; // HANGUL SYLLABLE SSANGCIEUC WI HIEUH
    case 0xA895: code_point = 0xCBB9; break; // HANGUL SYLLABLE SSANGCIEUC YU KIYEOK
    case 0xA896: code_point = 0xCBBA; break; // HANGUL SYLLABLE SSANGCIEUC YU SSANGKIYEOK
    case 0xA897: code_point = 0xCBBB; break; // HANGUL SYLLABLE SSANGCIEUC YU KIYEOKSIOS
    case 0xA898: code_point = 0xCBBC; break; // HANGUL SYLLABLE SSANGCIEUC YU NIEUN
    case 0xA899: code_point = 0xCBBD; break; // HANGUL SYLLABLE SSANGCIEUC YU NIEUNCIEUC
    case 0xA89A: code_point = 0xCBBE; break; // HANGUL SYLLABLE SSANGCIEUC YU NIEUNHIEUH
    case 0xA89B: code_point = 0xCBBF; break; // HANGUL SYLLABLE SSANGCIEUC YU TIKEUT
    case 0xA89C: code_point = 0xCBC0; break; // HANGUL SYLLABLE SSANGCIEUC YU RIEUL
    case 0xA89D: code_point = 0xCBC1; break; // HANGUL SYLLABLE SSANGCIEUC YU RIEULKIYEOK
    case 0xA89E: code_point = 0xCBC2; break; // HANGUL SYLLABLE SSANGCIEUC YU RIEULMIEUM
    case 0xA89F: code_point = 0xCBC3; break; // HANGUL SYLLABLE SSANGCIEUC YU RIEULPIEUP
    case 0xA8A0: code_point = 0xCBC4; break; // HANGUL SYLLABLE SSANGCIEUC YU RIEULSIOS
    case 0xA8A1: code_point = 0x00C6; break; // LATIN CAPITAL LETTER AE
    case 0xA8A2: code_point = 0x00D0; break; // LATIN CAPITAL LETTER ETH
    case 0xA8A3: code_point = 0x00AA; break; // FEMININE ORDINAL INDICATOR
    case 0xA8A4: code_point = 0x0126; break; // LATIN CAPITAL LETTER H WITH STROKE
    case 0xA8A6: code_point = 0x0132; break; // LATIN CAPITAL LIGATURE IJ
    case 0xA8A8: code_point = 0x013F; break; // LATIN CAPITAL LETTER L WITH MIDDLE DOT
    case 0xA8A9: code_point = 0x0141; break; // LATIN CAPITAL LETTER L WITH STROKE
    case 0xA8AA: code_point = 0x00D8; break; // LATIN CAPITAL LETTER O WITH STROKE
    case 0xA8AB: code_point = 0x0152; break; // LATIN CAPITAL LIGATURE OE
    case 0xA8AC: code_point = 0x00BA; break; // MASCULINE ORDINAL INDICATOR
    case 0xA8AD: code_point = 0x00DE; break; // LATIN CAPITAL LETTER THORN
    case 0xA8AE: code_point = 0x0166; break; // LATIN CAPITAL LETTER T WITH STROKE
    case 0xA8AF: code_point = 0x014A; break; // LATIN CAPITAL LETTER ENG
    case 0xA8B1: code_point = 0x3260; break; // CIRCLED HANGUL KIYEOK
    case 0xA8B2: code_point = 0x3261; break; // CIRCLED HANGUL NIEUN
    case 0xA8B3: code_point = 0x3262; break; // CIRCLED HANGUL TIKEUT
    case 0xA8B4: code_point = 0x3263; break; // CIRCLED HANGUL RIEUL
    case 0xA8B5: code_point = 0x3264; break; // CIRCLED HANGUL MIEUM
    case 0xA8B6: code_point = 0x3265; break; // CIRCLED HANGUL PIEUP
    case 0xA8B7: code_point = 0x3266; break; // CIRCLED HANGUL SIOS
    case 0xA8B8: code_point = 0x3267; break; // CIRCLED HANGUL IEUNG
    case 0xA8B9: code_point = 0x3268; break; // CIRCLED HANGUL CIEUC
    case 0xA8BA: code_point = 0x3269; break; // CIRCLED HANGUL CHIEUCH
    case 0xA8BB: code_point = 0x326A; break; // CIRCLED HANGUL KHIEUKH
    case 0xA8BC: code_point = 0x326B; break; // CIRCLED HANGUL THIEUTH
    case 0xA8BD: code_point = 0x326C; break; // CIRCLED HANGUL PHIEUPH
    case 0xA8BE: code_point = 0x326D; break; // CIRCLED HANGUL HIEUH
    case 0xA8BF: code_point = 0x326E; break; // CIRCLED HANGUL KIYEOK A
    case 0xA8C0: code_point = 0x326F; break; // CIRCLED HANGUL NIEUN A
    case 0xA8C1: code_point = 0x3270; break; // CIRCLED HANGUL TIKEUT A
    case 0xA8C2: code_point = 0x3271; break; // CIRCLED HANGUL RIEUL A
    case 0xA8C3: code_point = 0x3272; break; // CIRCLED HANGUL MIEUM A
    case 0xA8C4: code_point = 0x3273; break; // CIRCLED HANGUL PIEUP A
    case 0xA8C5: code_point = 0x3274; break; // CIRCLED HANGUL SIOS A
    case 0xA8C6: code_point = 0x3275; break; // CIRCLED HANGUL IEUNG A
    case 0xA8C7: code_point = 0x3276; break; // CIRCLED HANGUL CIEUC A
    case 0xA8C8: code_point = 0x3277; break; // CIRCLED HANGUL CHIEUCH A
    case 0xA8C9: code_point = 0x3278; break; // CIRCLED HANGUL KHIEUKH A
    case 0xA8CA: code_point = 0x3279; break; // CIRCLED HANGUL THIEUTH A
    case 0xA8CB: code_point = 0x327A; break; // CIRCLED HANGUL PHIEUPH A
    case 0xA8CC: code_point = 0x327B; break; // CIRCLED HANGUL HIEUH A
    case 0xA8CD: code_point = 0x24D0; break; // CIRCLED LATIN SMALL LETTER A
    case 0xA8CE: code_point = 0x24D1; break; // CIRCLED LATIN SMALL LETTER B
    case 0xA8CF: code_point = 0x24D2; break; // CIRCLED LATIN SMALL LETTER C
    case 0xA8D0: code_point = 0x24D3; break; // CIRCLED LATIN SMALL LETTER D
    case 0xA8D1: code_point = 0x24D4; break; // CIRCLED LATIN SMALL LETTER E
    case 0xA8D2: code_point = 0x24D5; break; // CIRCLED LATIN SMALL LETTER F
    case 0xA8D3: code_point = 0x24D6; break; // CIRCLED LATIN SMALL LETTER G
    case 0xA8D4: code_point = 0x24D7; break; // CIRCLED LATIN SMALL LETTER H
    case 0xA8D5: code_point = 0x24D8; break; // CIRCLED LATIN SMALL LETTER I
    case 0xA8D6: code_point = 0x24D9; break; // CIRCLED LATIN SMALL LETTER J
    case 0xA8D7: code_point = 0x24DA; break; // CIRCLED LATIN SMALL LETTER K
    case 0xA8D8: code_point = 0x24DB; break; // CIRCLED LATIN SMALL LETTER L
    case 0xA8D9: code_point = 0x24DC; break; // CIRCLED LATIN SMALL LETTER M
    case 0xA8DA: code_point = 0x24DD; break; // CIRCLED LATIN SMALL LETTER N
    case 0xA8DB: code_point = 0x24DE; break; // CIRCLED LATIN SMALL LETTER O
    case 0xA8DC: code_point = 0x24DF; break; // CIRCLED LATIN SMALL LETTER P
    case 0xA8DD: code_point = 0x24E0; break; // CIRCLED LATIN SMALL LETTER Q
    case 0xA8DE: code_point = 0x24E1; break; // CIRCLED LATIN SMALL LETTER R
    case 0xA8DF: code_point = 0x24E2; break; // CIRCLED LATIN SMALL LETTER S
    case 0xA8E0: code_point = 0x24E3; break; // CIRCLED LATIN SMALL LETTER T
    case 0xA8E1: code_point = 0x24E4; break; // CIRCLED LATIN SMALL LETTER U
    case 0xA8E2: code_point = 0x24E5; break; // CIRCLED LATIN SMALL LETTER V
    case 0xA8E3: code_point = 0x24E6; break; // CIRCLED LATIN SMALL LETTER W
    case 0xA8E4: code_point = 0x24E7; break; // CIRCLED LATIN SMALL LETTER X
    case 0xA8E5: code_point = 0x24E8; break; // CIRCLED LATIN SMALL LETTER Y
    case 0xA8E6: code_point = 0x24E9; break; // CIRCLED LATIN SMALL LETTER Z
    case 0xA8E7: code_point = 0x2460; break; // CIRCLED DIGIT ONE
    case 0xA8E8: code_point = 0x2461; break; // CIRCLED DIGIT TWO
    case 0xA8E9: code_point = 0x2462; break; // CIRCLED DIGIT THREE
    case 0xA8EA: code_point = 0x2463; break; // CIRCLED DIGIT FOUR
    case 0xA8EB: code_point = 0x2464; break; // CIRCLED DIGIT FIVE
    case 0xA8EC: code_point = 0x2465; break; // CIRCLED DIGIT SIX
    case 0xA8ED: code_point = 0x2466; break; // CIRCLED DIGIT SEVEN
    case 0xA8EE: code_point = 0x2467; break; // CIRCLED DIGIT EIGHT
    case 0xA8EF: code_point = 0x2468; break; // CIRCLED DIGIT NINE
    case 0xA8F0: code_point = 0x2469; break; // CIRCLED NUMBER TEN
    case 0xA8F1: code_point = 0x246A; break; // CIRCLED NUMBER ELEVEN
    case 0xA8F2: code_point = 0x246B; break; // CIRCLED NUMBER TWELVE
    case 0xA8F3: code_point = 0x246C; break; // CIRCLED NUMBER THIRTEEN
    case 0xA8F4: code_point = 0x246D; break; // CIRCLED NUMBER FOURTEEN
    case 0xA8F5: code_point = 0x246E; break; // CIRCLED NUMBER FIFTEEN
    case 0xA8F6: code_point = 0x00BD; break; // VULGAR FRACTION ONE HALF
    case 0xA8F7: code_point = 0x2153; break; // VULGAR FRACTION ONE THIRD
    case 0xA8F8: code_point = 0x2154; break; // VULGAR FRACTION TWO THIRDS
    case 0xA8F9: code_point = 0x00BC; break; // VULGAR FRACTION ONE QUARTER
    case 0xA8FA: code_point = 0x00BE; break; // VULGAR FRACTION THREE QUARTERS
    case 0xA8FB: code_point = 0x215B; break; // VULGAR FRACTION ONE EIGHTH
    case 0xA8FC: code_point = 0x215C; break; // VULGAR FRACTION THREE EIGHTHS
    case 0xA8FD: code_point = 0x215D; break; // VULGAR FRACTION FIVE EIGHTHS
    case 0xA8FE: code_point = 0x215E; break; // VULGAR FRACTION SEVEN EIGHTHS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xA9(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xA941: code_point = 0xCBC5; break; // HANGUL SYLLABLE SSANGCIEUC YU RIEULTHIEUTH
    case 0xA942: code_point = 0xCBC6; break; // HANGUL SYLLABLE SSANGCIEUC YU RIEULPHIEUPH
    case 0xA943: code_point = 0xCBC7; break; // HANGUL SYLLABLE SSANGCIEUC YU RIEULHIEUH
    case 0xA944: code_point = 0xCBC8; break; // HANGUL SYLLABLE SSANGCIEUC YU MIEUM
    case 0xA945: code_point = 0xCBC9; break; // HANGUL SYLLABLE SSANGCIEUC YU PIEUP
    case 0xA946: code_point = 0xCBCA; break; // HANGUL SYLLABLE SSANGCIEUC YU PIEUPSIOS
    case 0xA947: code_point = 0xCBCB; break; // HANGUL SYLLABLE SSANGCIEUC YU SIOS
    case 0xA948: code_point = 0xCBCC; break; // HANGUL SYLLABLE SSANGCIEUC YU SSANGSIOS
    case 0xA949: code_point = 0xCBCD; break; // HANGUL SYLLABLE SSANGCIEUC YU IEUNG
    case 0xA94A: code_point = 0xCBCE; break; // HANGUL SYLLABLE SSANGCIEUC YU CIEUC
    case 0xA94B: code_point = 0xCBCF; break; // HANGUL SYLLABLE SSANGCIEUC YU CHIEUCH
    case 0xA94C: code_point = 0xCBD0; break; // HANGUL SYLLABLE SSANGCIEUC YU KHIEUKH
    case 0xA94D: code_point = 0xCBD1; break; // HANGUL SYLLABLE SSANGCIEUC YU THIEUTH
    case 0xA94E: code_point = 0xCBD2; break; // HANGUL SYLLABLE SSANGCIEUC YU PHIEUPH
    case 0xA94F: code_point = 0xCBD3; break; // HANGUL SYLLABLE SSANGCIEUC YU HIEUH
    case 0xA950: code_point = 0xCBD5; break; // HANGUL SYLLABLE SSANGCIEUC EU KIYEOK
    case 0xA951: code_point = 0xCBD6; break; // HANGUL SYLLABLE SSANGCIEUC EU SSANGKIYEOK
    case 0xA952: code_point = 0xCBD7; break; // HANGUL SYLLABLE SSANGCIEUC EU KIYEOKSIOS
    case 0xA953: code_point = 0xCBD8; break; // HANGUL SYLLABLE SSANGCIEUC EU NIEUN
    case 0xA954: code_point = 0xCBD9; break; // HANGUL SYLLABLE SSANGCIEUC EU NIEUNCIEUC
    case 0xA955: code_point = 0xCBDA; break; // HANGUL SYLLABLE SSANGCIEUC EU NIEUNHIEUH
    case 0xA956: code_point = 0xCBDB; break; // HANGUL SYLLABLE SSANGCIEUC EU TIKEUT
    case 0xA957: code_point = 0xCBDC; break; // HANGUL SYLLABLE SSANGCIEUC EU RIEUL
    case 0xA958: code_point = 0xCBDD; break; // HANGUL SYLLABLE SSANGCIEUC EU RIEULKIYEOK
    case 0xA959: code_point = 0xCBDE; break; // HANGUL SYLLABLE SSANGCIEUC EU RIEULMIEUM
    case 0xA95A: code_point = 0xCBDF; break; // HANGUL SYLLABLE SSANGCIEUC EU RIEULPIEUP
    case 0xA961: code_point = 0xCBE0; break; // HANGUL SYLLABLE SSANGCIEUC EU RIEULSIOS
    case 0xA962: code_point = 0xCBE1; break; // HANGUL SYLLABLE SSANGCIEUC EU RIEULTHIEUTH
    case 0xA963: code_point = 0xCBE2; break; // HANGUL SYLLABLE SSANGCIEUC EU RIEULPHIEUPH
    case 0xA964: code_point = 0xCBE3; break; // HANGUL SYLLABLE SSANGCIEUC EU RIEULHIEUH
    case 0xA965: code_point = 0xCBE5; break; // HANGUL SYLLABLE SSANGCIEUC EU PIEUP
    case 0xA966: code_point = 0xCBE6; break; // HANGUL SYLLABLE SSANGCIEUC EU PIEUPSIOS
    case 0xA967: code_point = 0xCBE8; break; // HANGUL SYLLABLE SSANGCIEUC EU SSANGSIOS
    case 0xA968: code_point = 0xCBEA; break; // HANGUL SYLLABLE SSANGCIEUC EU CIEUC
    case 0xA969: code_point = 0xCBEB; break; // HANGUL SYLLABLE SSANGCIEUC EU CHIEUCH
    case 0xA96A: code_point = 0xCBEC; break; // HANGUL SYLLABLE SSANGCIEUC EU KHIEUKH
    case 0xA96B: code_point = 0xCBED; break; // HANGUL SYLLABLE SSANGCIEUC EU THIEUTH
    case 0xA96C: code_point = 0xCBEE; break; // HANGUL SYLLABLE SSANGCIEUC EU PHIEUPH
    case 0xA96D: code_point = 0xCBEF; break; // HANGUL SYLLABLE SSANGCIEUC EU HIEUH
    case 0xA96E: code_point = 0xCBF0; break; // HANGUL SYLLABLE SSANGCIEUC YI
    case 0xA96F: code_point = 0xCBF1; break; // HANGUL SYLLABLE SSANGCIEUC YI KIYEOK
    case 0xA970: code_point = 0xCBF2; break; // HANGUL SYLLABLE SSANGCIEUC YI SSANGKIYEOK
    case 0xA971: code_point = 0xCBF3; break; // HANGUL SYLLABLE SSANGCIEUC YI KIYEOKSIOS
    case 0xA972: code_point = 0xCBF4; break; // HANGUL SYLLABLE SSANGCIEUC YI NIEUN
    case 0xA973: code_point = 0xCBF5; break; // HANGUL SYLLABLE SSANGCIEUC YI NIEUNCIEUC
    case 0xA974: code_point = 0xCBF6; break; // HANGUL SYLLABLE SSANGCIEUC YI NIEUNHIEUH
    case 0xA975: code_point = 0xCBF7; break; // HANGUL SYLLABLE SSANGCIEUC YI TIKEUT
    case 0xA976: code_point = 0xCBF8; break; // HANGUL SYLLABLE SSANGCIEUC YI RIEUL
    case 0xA977: code_point = 0xCBF9; break; // HANGUL SYLLABLE SSANGCIEUC YI RIEULKIYEOK
    case 0xA978: code_point = 0xCBFA; break; // HANGUL SYLLABLE SSANGCIEUC YI RIEULMIEUM
    case 0xA979: code_point = 0xCBFB; break; // HANGUL SYLLABLE SSANGCIEUC YI RIEULPIEUP
    case 0xA97A: code_point = 0xCBFC; break; // HANGUL SYLLABLE SSANGCIEUC YI RIEULSIOS
    case 0xA981: code_point = 0xCBFD; break; // HANGUL SYLLABLE SSANGCIEUC YI RIEULTHIEUTH
    case 0xA982: code_point = 0xCBFE; break; // HANGUL SYLLABLE SSANGCIEUC YI RIEULPHIEUPH
    case 0xA983: code_point = 0xCBFF; break; // HANGUL SYLLABLE SSANGCIEUC YI RIEULHIEUH
    case 0xA984: code_point = 0xCC00; break; // HANGUL SYLLABLE SSANGCIEUC YI MIEUM
    case 0xA985: code_point = 0xCC01; break; // HANGUL SYLLABLE SSANGCIEUC YI PIEUP
    case 0xA986: code_point = 0xCC02; break; // HANGUL SYLLABLE SSANGCIEUC YI PIEUPSIOS
    case 0xA987: code_point = 0xCC03; break; // HANGUL SYLLABLE SSANGCIEUC YI SIOS
    case 0xA988: code_point = 0xCC04; break; // HANGUL SYLLABLE SSANGCIEUC YI SSANGSIOS
    case 0xA989: code_point = 0xCC05; break; // HANGUL SYLLABLE SSANGCIEUC YI IEUNG
    case 0xA98A: code_point = 0xCC06; break; // HANGUL SYLLABLE SSANGCIEUC YI CIEUC
    case 0xA98B: code_point = 0xCC07; break; // HANGUL SYLLABLE SSANGCIEUC YI CHIEUCH
    case 0xA98C: code_point = 0xCC08; break; // HANGUL SYLLABLE SSANGCIEUC YI KHIEUKH
    case 0xA98D: code_point = 0xCC09; break; // HANGUL SYLLABLE SSANGCIEUC YI THIEUTH
    case 0xA98E: code_point = 0xCC0A; break; // HANGUL SYLLABLE SSANGCIEUC YI PHIEUPH
    case 0xA98F: code_point = 0xCC0B; break; // HANGUL SYLLABLE SSANGCIEUC YI HIEUH
    case 0xA990: code_point = 0xCC0E; break; // HANGUL SYLLABLE SSANGCIEUC I SSANGKIYEOK
    case 0xA991: code_point = 0xCC0F; break; // HANGUL SYLLABLE SSANGCIEUC I KIYEOKSIOS
    case 0xA992: code_point = 0xCC11; break; // HANGUL SYLLABLE SSANGCIEUC I NIEUNCIEUC
    case 0xA993: code_point = 0xCC12; break; // HANGUL SYLLABLE SSANGCIEUC I NIEUNHIEUH
    case 0xA994: code_point = 0xCC13; break; // HANGUL SYLLABLE SSANGCIEUC I TIKEUT
    case 0xA995: code_point = 0xCC15; break; // HANGUL SYLLABLE SSANGCIEUC I RIEULKIYEOK
    case 0xA996: code_point = 0xCC16; break; // HANGUL SYLLABLE SSANGCIEUC I RIEULMIEUM
    case 0xA997: code_point = 0xCC17; break; // HANGUL SYLLABLE SSANGCIEUC I RIEULPIEUP
    case 0xA998: code_point = 0xCC18; break; // HANGUL SYLLABLE SSANGCIEUC I RIEULSIOS
    case 0xA999: code_point = 0xCC19; break; // HANGUL SYLLABLE SSANGCIEUC I RIEULTHIEUTH
    case 0xA99A: code_point = 0xCC1A; break; // HANGUL SYLLABLE SSANGCIEUC I RIEULPHIEUPH
    case 0xA99B: code_point = 0xCC1B; break; // HANGUL SYLLABLE SSANGCIEUC I RIEULHIEUH
    case 0xA99C: code_point = 0xCC1E; break; // HANGUL SYLLABLE SSANGCIEUC I PIEUPSIOS
    case 0xA99D: code_point = 0xCC1F; break; // HANGUL SYLLABLE SSANGCIEUC I SIOS
    case 0xA99E: code_point = 0xCC20; break; // HANGUL SYLLABLE SSANGCIEUC I SSANGSIOS
    case 0xA99F: code_point = 0xCC23; break; // HANGUL SYLLABLE SSANGCIEUC I CHIEUCH
    case 0xA9A0: code_point = 0xCC24; break; // HANGUL SYLLABLE SSANGCIEUC I KHIEUKH
    case 0xA9A1: code_point = 0x00E6; break; // LATIN SMALL LETTER AE
    case 0xA9A2: code_point = 0x0111; break; // LATIN SMALL LETTER D WITH STROKE
    case 0xA9A3: code_point = 0x00F0; break; // LATIN SMALL LETTER ETH
    case 0xA9A4: code_point = 0x0127; break; // LATIN SMALL LETTER H WITH STROKE
    case 0xA9A5: code_point = 0x0131; break; // LATIN SMALL LETTER DOTLESS I
    case 0xA9A6: code_point = 0x0133; break; // LATIN SMALL LIGATURE IJ
    case 0xA9A7: code_point = 0x0138; break; // LATIN SMALL LETTER KRA
    case 0xA9A8: code_point = 0x0140; break; // LATIN SMALL LETTER L WITH MIDDLE DOT
    case 0xA9A9: code_point = 0x0142; break; // LATIN SMALL LETTER L WITH STROKE
    case 0xA9AA: code_point = 0x00F8; break; // LATIN SMALL LETTER O WITH STROKE
    case 0xA9AB: code_point = 0x0153; break; // LATIN SMALL LIGATURE OE
    case 0xA9AC: code_point = 0x00DF; break; // LATIN SMALL LETTER SHARP S
    case 0xA9AD: code_point = 0x00FE; break; // LATIN SMALL LETTER THORN
    case 0xA9AE: code_point = 0x0167; break; // LATIN SMALL LETTER T WITH STROKE
    case 0xA9AF: code_point = 0x014B; break; // LATIN SMALL LETTER ENG
    case 0xA9B0: code_point = 0x0149; break; // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
    case 0xA9B1: code_point = 0x3200; break; // PARENTHESIZED HANGUL KIYEOK
    case 0xA9B2: code_point = 0x3201; break; // PARENTHESIZED HANGUL NIEUN
    case 0xA9B3: code_point = 0x3202; break; // PARENTHESIZED HANGUL TIKEUT
    case 0xA9B4: code_point = 0x3203; break; // PARENTHESIZED HANGUL RIEUL
    case 0xA9B5: code_point = 0x3204; break; // PARENTHESIZED HANGUL MIEUM
    case 0xA9B6: code_point = 0x3205; break; // PARENTHESIZED HANGUL PIEUP
    case 0xA9B7: code_point = 0x3206; break; // PARENTHESIZED HANGUL SIOS
    case 0xA9B8: code_point = 0x3207; break; // PARENTHESIZED HANGUL IEUNG
    case 0xA9B9: code_point = 0x3208; break; // PARENTHESIZED HANGUL CIEUC
    case 0xA9BA: code_point = 0x3209; break; // PARENTHESIZED HANGUL CHIEUCH
    case 0xA9BB: code_point = 0x320A; break; // PARENTHESIZED HANGUL KHIEUKH
    case 0xA9BC: code_point = 0x320B; break; // PARENTHESIZED HANGUL THIEUTH
    case 0xA9BD: code_point = 0x320C; break; // PARENTHESIZED HANGUL PHIEUPH
    case 0xA9BE: code_point = 0x320D; break; // PARENTHESIZED HANGUL HIEUH
    case 0xA9BF: code_point = 0x320E; break; // PARENTHESIZED HANGUL KIYEOK A
    case 0xA9C0: code_point = 0x320F; break; // PARENTHESIZED HANGUL NIEUN A
    case 0xA9C1: code_point = 0x3210; break; // PARENTHESIZED HANGUL TIKEUT A
    case 0xA9C2: code_point = 0x3211; break; // PARENTHESIZED HANGUL RIEUL A
    case 0xA9C3: code_point = 0x3212; break; // PARENTHESIZED HANGUL MIEUM A
    case 0xA9C4: code_point = 0x3213; break; // PARENTHESIZED HANGUL PIEUP A
    case 0xA9C5: code_point = 0x3214; break; // PARENTHESIZED HANGUL SIOS A
    case 0xA9C6: code_point = 0x3215; break; // PARENTHESIZED HANGUL IEUNG A
    case 0xA9C7: code_point = 0x3216; break; // PARENTHESIZED HANGUL CIEUC A
    case 0xA9C8: code_point = 0x3217; break; // PARENTHESIZED HANGUL CHIEUCH A
    case 0xA9C9: code_point = 0x3218; break; // PARENTHESIZED HANGUL KHIEUKH A
    case 0xA9CA: code_point = 0x3219; break; // PARENTHESIZED HANGUL THIEUTH A
    case 0xA9CB: code_point = 0x321A; break; // PARENTHESIZED HANGUL PHIEUPH A
    case 0xA9CC: code_point = 0x321B; break; // PARENTHESIZED HANGUL HIEUH A
    case 0xA9CD: code_point = 0x249C; break; // PARENTHESIZED LATIN SMALL LETTER A
    case 0xA9CE: code_point = 0x249D; break; // PARENTHESIZED LATIN SMALL LETTER B
    case 0xA9CF: code_point = 0x249E; break; // PARENTHESIZED LATIN SMALL LETTER C
    case 0xA9D0: code_point = 0x249F; break; // PARENTHESIZED LATIN SMALL LETTER D
    case 0xA9D1: code_point = 0x24A0; break; // PARENTHESIZED LATIN SMALL LETTER E
    case 0xA9D2: code_point = 0x24A1; break; // PARENTHESIZED LATIN SMALL LETTER F
    case 0xA9D3: code_point = 0x24A2; break; // PARENTHESIZED LATIN SMALL LETTER G
    case 0xA9D4: code_point = 0x24A3; break; // PARENTHESIZED LATIN SMALL LETTER H
    case 0xA9D5: code_point = 0x24A4; break; // PARENTHESIZED LATIN SMALL LETTER I
    case 0xA9D6: code_point = 0x24A5; break; // PARENTHESIZED LATIN SMALL LETTER J
    case 0xA9D7: code_point = 0x24A6; break; // PARENTHESIZED LATIN SMALL LETTER K
    case 0xA9D8: code_point = 0x24A7; break; // PARENTHESIZED LATIN SMALL LETTER L
    case 0xA9D9: code_point = 0x24A8; break; // PARENTHESIZED LATIN SMALL LETTER M
    case 0xA9DA: code_point = 0x24A9; break; // PARENTHESIZED LATIN SMALL LETTER N
    case 0xA9DB: code_point = 0x24AA; break; // PARENTHESIZED LATIN SMALL LETTER O
    case 0xA9DC: code_point = 0x24AB; break; // PARENTHESIZED LATIN SMALL LETTER P
    case 0xA9DD: code_point = 0x24AC; break; // PARENTHESIZED LATIN SMALL LETTER Q
    case 0xA9DE: code_point = 0x24AD; break; // PARENTHESIZED LATIN SMALL LETTER R
    case 0xA9DF: code_point = 0x24AE; break; // PARENTHESIZED LATIN SMALL LETTER S
    case 0xA9E0: code_point = 0x24AF; break; // PARENTHESIZED LATIN SMALL LETTER T
    case 0xA9E1: code_point = 0x24B0; break; // PARENTHESIZED LATIN SMALL LETTER U
    case 0xA9E2: code_point = 0x24B1; break; // PARENTHESIZED LATIN SMALL LETTER V
    case 0xA9E3: code_point = 0x24B2; break; // PARENTHESIZED LATIN SMALL LETTER W
    case 0xA9E4: code_point = 0x24B3; break; // PARENTHESIZED LATIN SMALL LETTER X
    case 0xA9E5: code_point = 0x24B4; break; // PARENTHESIZED LATIN SMALL LETTER Y
    case 0xA9E6: code_point = 0x24B5; break; // PARENTHESIZED LATIN SMALL LETTER Z
    case 0xA9E7: code_point = 0x2474; break; // PARENTHESIZED DIGIT ONE
    case 0xA9E8: code_point = 0x2475; break; // PARENTHESIZED DIGIT TWO
    case 0xA9E9: code_point = 0x2476; break; // PARENTHESIZED DIGIT THREE
    case 0xA9EA: code_point = 0x2477; break; // PARENTHESIZED DIGIT FOUR
    case 0xA9EB: code_point = 0x2478; break; // PARENTHESIZED DIGIT FIVE
    case 0xA9EC: code_point = 0x2479; break; // PARENTHESIZED DIGIT SIX
    case 0xA9ED: code_point = 0x247A; break; // PARENTHESIZED DIGIT SEVEN
    case 0xA9EE: code_point = 0x247B; break; // PARENTHESIZED DIGIT EIGHT
    case 0xA9EF: code_point = 0x247C; break; // PARENTHESIZED DIGIT NINE
    case 0xA9F0: code_point = 0x247D; break; // PARENTHESIZED NUMBER TEN
    case 0xA9F1: code_point = 0x247E; break; // PARENTHESIZED NUMBER ELEVEN
    case 0xA9F2: code_point = 0x247F; break; // PARENTHESIZED NUMBER TWELVE
    case 0xA9F3: code_point = 0x2480; break; // PARENTHESIZED NUMBER THIRTEEN
    case 0xA9F4: code_point = 0x2481; break; // PARENTHESIZED NUMBER FOURTEEN
    case 0xA9F5: code_point = 0x2482; break; // PARENTHESIZED NUMBER FIFTEEN
    case 0xA9F6: code_point = 0x00B9; break; // SUPERSCRIPT ONE
    case 0xA9F7: code_point = 0x00B2; break; // SUPERSCRIPT TWO
    case 0xA9F8: code_point = 0x00B3; break; // SUPERSCRIPT THREE
    case 0xA9F9: code_point = 0x2074; break; // SUPERSCRIPT FOUR
    case 0xA9FA: code_point = 0x207F; break; // SUPERSCRIPT LATIN SMALL LETTER N
    case 0xA9FB: code_point = 0x2081; break; // SUBSCRIPT ONE
    case 0xA9FC: code_point = 0x2082; break; // SUBSCRIPT TWO
    case 0xA9FD: code_point = 0x2083; break; // SUBSCRIPT THREE
    case 0xA9FE: code_point = 0x2084; break; // SUBSCRIPT FOUR
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xAA(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xAA41: code_point = 0xCC25; break; // HANGUL SYLLABLE SSANGCIEUC I THIEUTH
    case 0xAA42: code_point = 0xCC26; break; // HANGUL SYLLABLE SSANGCIEUC I PHIEUPH
    case 0xAA43: code_point = 0xCC2A; break; // HANGUL SYLLABLE CHIEUCH A SSANGKIYEOK
    case 0xAA44: code_point = 0xCC2B; break; // HANGUL SYLLABLE CHIEUCH A KIYEOKSIOS
    case 0xAA45: code_point = 0xCC2D; break; // HANGUL SYLLABLE CHIEUCH A NIEUNCIEUC
    case 0xAA46: code_point = 0xCC2F; break; // HANGUL SYLLABLE CHIEUCH A TIKEUT
    case 0xAA47: code_point = 0xCC31; break; // HANGUL SYLLABLE CHIEUCH A RIEULKIYEOK
    case 0xAA48: code_point = 0xCC32; break; // HANGUL SYLLABLE CHIEUCH A RIEULMIEUM
    case 0xAA49: code_point = 0xCC33; break; // HANGUL SYLLABLE CHIEUCH A RIEULPIEUP
    case 0xAA4A: code_point = 0xCC34; break; // HANGUL SYLLABLE CHIEUCH A RIEULSIOS
    case 0xAA4B: code_point = 0xCC35; break; // HANGUL SYLLABLE CHIEUCH A RIEULTHIEUTH
    case 0xAA4C: code_point = 0xCC36; break; // HANGUL SYLLABLE CHIEUCH A RIEULPHIEUPH
    case 0xAA4D: code_point = 0xCC37; break; // HANGUL SYLLABLE CHIEUCH A RIEULHIEUH
    case 0xAA4E: code_point = 0xCC3A; break; // HANGUL SYLLABLE CHIEUCH A PIEUPSIOS
    case 0xAA4F: code_point = 0xCC3F; break; // HANGUL SYLLABLE CHIEUCH A CHIEUCH
    case 0xAA50: code_point = 0xCC40; break; // HANGUL SYLLABLE CHIEUCH A KHIEUKH
    case 0xAA51: code_point = 0xCC41; break; // HANGUL SYLLABLE CHIEUCH A THIEUTH
    case 0xAA52: code_point = 0xCC42; break; // HANGUL SYLLABLE CHIEUCH A PHIEUPH
    case 0xAA53: code_point = 0xCC43; break; // HANGUL SYLLABLE CHIEUCH A HIEUH
    case 0xAA54: code_point = 0xCC46; break; // HANGUL SYLLABLE CHIEUCH AE SSANGKIYEOK
    case 0xAA55: code_point = 0xCC47; break; // HANGUL SYLLABLE CHIEUCH AE KIYEOKSIOS
    case 0xAA56: code_point = 0xCC49; break; // HANGUL SYLLABLE CHIEUCH AE NIEUNCIEUC
    case 0xAA57: code_point = 0xCC4A; break; // HANGUL SYLLABLE CHIEUCH AE NIEUNHIEUH
    case 0xAA58: code_point = 0xCC4B; break; // HANGUL SYLLABLE CHIEUCH AE TIKEUT
    case 0xAA59: code_point = 0xCC4D; break; // HANGUL SYLLABLE CHIEUCH AE RIEULKIYEOK
    case 0xAA5A: code_point = 0xCC4E; break; // HANGUL SYLLABLE CHIEUCH AE RIEULMIEUM
    case 0xAA61: code_point = 0xCC4F; break; // HANGUL SYLLABLE CHIEUCH AE RIEULPIEUP
    case 0xAA62: code_point = 0xCC50; break; // HANGUL SYLLABLE CHIEUCH AE RIEULSIOS
    case 0xAA63: code_point = 0xCC51; break; // HANGUL SYLLABLE CHIEUCH AE RIEULTHIEUTH
    case 0xAA64: code_point = 0xCC52; break; // HANGUL SYLLABLE CHIEUCH AE RIEULPHIEUPH
    case 0xAA65: code_point = 0xCC53; break; // HANGUL SYLLABLE CHIEUCH AE RIEULHIEUH
    case 0xAA66: code_point = 0xCC56; break; // HANGUL SYLLABLE CHIEUCH AE PIEUPSIOS
    case 0xAA67: code_point = 0xCC5A; break; // HANGUL SYLLABLE CHIEUCH AE CIEUC
    case 0xAA68: code_point = 0xCC5B; break; // HANGUL SYLLABLE CHIEUCH AE CHIEUCH
    case 0xAA69: code_point = 0xCC5C; break; // HANGUL SYLLABLE CHIEUCH AE KHIEUKH
    case 0xAA6A: code_point = 0xCC5D; break; // HANGUL SYLLABLE CHIEUCH AE THIEUTH
    case 0xAA6B: code_point = 0xCC5E; break; // HANGUL SYLLABLE CHIEUCH AE PHIEUPH
    case 0xAA6C: code_point = 0xCC5F; break; // HANGUL SYLLABLE CHIEUCH AE HIEUH
    case 0xAA6D: code_point = 0xCC61; break; // HANGUL SYLLABLE CHIEUCH YA KIYEOK
    case 0xAA6E: code_point = 0xCC62; break; // HANGUL SYLLABLE CHIEUCH YA SSANGKIYEOK
    case 0xAA6F: code_point = 0xCC63; break; // HANGUL SYLLABLE CHIEUCH YA KIYEOKSIOS
    case 0xAA70: code_point = 0xCC65; break; // HANGUL SYLLABLE CHIEUCH YA NIEUNCIEUC
    case 0xAA71: code_point = 0xCC67; break; // HANGUL SYLLABLE CHIEUCH YA TIKEUT
    case 0xAA72: code_point = 0xCC69; break; // HANGUL SYLLABLE CHIEUCH YA RIEULKIYEOK
    case 0xAA73: code_point = 0xCC6A; break; // HANGUL SYLLABLE CHIEUCH YA RIEULMIEUM
    case 0xAA74: code_point = 0xCC6B; break; // HANGUL SYLLABLE CHIEUCH YA RIEULPIEUP
    case 0xAA75: code_point = 0xCC6C; break; // HANGUL SYLLABLE CHIEUCH YA RIEULSIOS
    case 0xAA76: code_point = 0xCC6D; break; // HANGUL SYLLABLE CHIEUCH YA RIEULTHIEUTH
    case 0xAA77: code_point = 0xCC6E; break; // HANGUL SYLLABLE CHIEUCH YA RIEULPHIEUPH
    case 0xAA78: code_point = 0xCC6F; break; // HANGUL SYLLABLE CHIEUCH YA RIEULHIEUH
    case 0xAA79: code_point = 0xCC71; break; // HANGUL SYLLABLE CHIEUCH YA PIEUP
    case 0xAA7A: code_point = 0xCC72; break; // HANGUL SYLLABLE CHIEUCH YA PIEUPSIOS
    case 0xAA81: code_point = 0xCC73; break; // HANGUL SYLLABLE CHIEUCH YA SIOS
    case 0xAA82: code_point = 0xCC74; break; // HANGUL SYLLABLE CHIEUCH YA SSANGSIOS
    case 0xAA83: code_point = 0xCC76; break; // HANGUL SYLLABLE CHIEUCH YA CIEUC
    case 0xAA84: code_point = 0xCC77; break; // HANGUL SYLLABLE CHIEUCH YA CHIEUCH
    case 0xAA85: code_point = 0xCC78; break; // HANGUL SYLLABLE CHIEUCH YA KHIEUKH
    case 0xAA86: code_point = 0xCC79; break; // HANGUL SYLLABLE CHIEUCH YA THIEUTH
    case 0xAA87: code_point = 0xCC7A; break; // HANGUL SYLLABLE CHIEUCH YA PHIEUPH
    case 0xAA88: code_point = 0xCC7B; break; // HANGUL SYLLABLE CHIEUCH YA HIEUH
    case 0xAA89: code_point = 0xCC7C; break; // HANGUL SYLLABLE CHIEUCH YAE
    case 0xAA8A: code_point = 0xCC7D; break; // HANGUL SYLLABLE CHIEUCH YAE KIYEOK
    case 0xAA8B: code_point = 0xCC7E; break; // HANGUL SYLLABLE CHIEUCH YAE SSANGKIYEOK
    case 0xAA8C: code_point = 0xCC7F; break; // HANGUL SYLLABLE CHIEUCH YAE KIYEOKSIOS
    case 0xAA8D: code_point = 0xCC80; break; // HANGUL SYLLABLE CHIEUCH YAE NIEUN
    case 0xAA8E: code_point = 0xCC81; break; // HANGUL SYLLABLE CHIEUCH YAE NIEUNCIEUC
    case 0xAA8F: code_point = 0xCC82; break; // HANGUL SYLLABLE CHIEUCH YAE NIEUNHIEUH
    case 0xAA90: code_point = 0xCC83; break; // HANGUL SYLLABLE CHIEUCH YAE TIKEUT
    case 0xAA91: code_point = 0xCC84; break; // HANGUL SYLLABLE CHIEUCH YAE RIEUL
    case 0xAA92: code_point = 0xCC85; break; // HANGUL SYLLABLE CHIEUCH YAE RIEULKIYEOK
    case 0xAA93: code_point = 0xCC86; break; // HANGUL SYLLABLE CHIEUCH YAE RIEULMIEUM
    case 0xAA94: code_point = 0xCC87; break; // HANGUL SYLLABLE CHIEUCH YAE RIEULPIEUP
    case 0xAA95: code_point = 0xCC88; break; // HANGUL SYLLABLE CHIEUCH YAE RIEULSIOS
    case 0xAA96: code_point = 0xCC89; break; // HANGUL SYLLABLE CHIEUCH YAE RIEULTHIEUTH
    case 0xAA97: code_point = 0xCC8A; break; // HANGUL SYLLABLE CHIEUCH YAE RIEULPHIEUPH
    case 0xAA98: code_point = 0xCC8B; break; // HANGUL SYLLABLE CHIEUCH YAE RIEULHIEUH
    case 0xAA99: code_point = 0xCC8C; break; // HANGUL SYLLABLE CHIEUCH YAE MIEUM
    case 0xAA9A: code_point = 0xCC8D; break; // HANGUL SYLLABLE CHIEUCH YAE PIEUP
    case 0xAA9B: code_point = 0xCC8E; break; // HANGUL SYLLABLE CHIEUCH YAE PIEUPSIOS
    case 0xAA9C: code_point = 0xCC8F; break; // HANGUL SYLLABLE CHIEUCH YAE SIOS
    case 0xAA9D: code_point = 0xCC90; break; // HANGUL SYLLABLE CHIEUCH YAE SSANGSIOS
    case 0xAA9E: code_point = 0xCC91; break; // HANGUL SYLLABLE CHIEUCH YAE IEUNG
    case 0xAA9F: code_point = 0xCC92; break; // HANGUL SYLLABLE CHIEUCH YAE CIEUC
    case 0xAAA0: code_point = 0xCC93; break; // HANGUL SYLLABLE CHIEUCH YAE CHIEUCH
    case 0xAAA1: code_point = 0x3041; break; // HIRAGANA LETTER SMALL A
    case 0xAAA2: code_point = 0x3042; break; // HIRAGANA LETTER A
    case 0xAAA3: code_point = 0x3043; break; // HIRAGANA LETTER SMALL I
    case 0xAAA4: code_point = 0x3044; break; // HIRAGANA LETTER I
    case 0xAAA5: code_point = 0x3045; break; // HIRAGANA LETTER SMALL U
    case 0xAAA6: code_point = 0x3046; break; // HIRAGANA LETTER U
    case 0xAAA7: code_point = 0x3047; break; // HIRAGANA LETTER SMALL E
    case 0xAAA8: code_point = 0x3048; break; // HIRAGANA LETTER E
    case 0xAAA9: code_point = 0x3049; break; // HIRAGANA LETTER SMALL O
    case 0xAAAA: code_point = 0x304A; break; // HIRAGANA LETTER O
    case 0xAAAB: code_point = 0x304B; break; // HIRAGANA LETTER KA
    case 0xAAAC: code_point = 0x304C; break; // HIRAGANA LETTER GA
    case 0xAAAD: code_point = 0x304D; break; // HIRAGANA LETTER KI
    case 0xAAAE: code_point = 0x304E; break; // HIRAGANA LETTER GI
    case 0xAAAF: code_point = 0x304F; break; // HIRAGANA LETTER KU
    case 0xAAB0: code_point = 0x3050; break; // HIRAGANA LETTER GU
    case 0xAAB1: code_point = 0x3051; break; // HIRAGANA LETTER KE
    case 0xAAB2: code_point = 0x3052; break; // HIRAGANA LETTER GE
    case 0xAAB3: code_point = 0x3053; break; // HIRAGANA LETTER KO
    case 0xAAB4: code_point = 0x3054; break; // HIRAGANA LETTER GO
    case 0xAAB5: code_point = 0x3055; break; // HIRAGANA LETTER SA
    case 0xAAB6: code_point = 0x3056; break; // HIRAGANA LETTER ZA
    case 0xAAB7: code_point = 0x3057; break; // HIRAGANA LETTER SI
    case 0xAAB8: code_point = 0x3058; break; // HIRAGANA LETTER ZI
    case 0xAAB9: code_point = 0x3059; break; // HIRAGANA LETTER SU
    case 0xAABA: code_point = 0x305A; break; // HIRAGANA LETTER ZU
    case 0xAABB: code_point = 0x305B; break; // HIRAGANA LETTER SE
    case 0xAABC: code_point = 0x305C; break; // HIRAGANA LETTER ZE
    case 0xAABD: code_point = 0x305D; break; // HIRAGANA LETTER SO
    case 0xAABE: code_point = 0x305E; break; // HIRAGANA LETTER ZO
    case 0xAABF: code_point = 0x305F; break; // HIRAGANA LETTER TA
    case 0xAAC0: code_point = 0x3060; break; // HIRAGANA LETTER DA
    case 0xAAC1: code_point = 0x3061; break; // HIRAGANA LETTER TI
    case 0xAAC2: code_point = 0x3062; break; // HIRAGANA LETTER DI
    case 0xAAC3: code_point = 0x3063; break; // HIRAGANA LETTER SMALL TU
    case 0xAAC4: code_point = 0x3064; break; // HIRAGANA LETTER TU
    case 0xAAC5: code_point = 0x3065; break; // HIRAGANA LETTER DU
    case 0xAAC6: code_point = 0x3066; break; // HIRAGANA LETTER TE
    case 0xAAC7: code_point = 0x3067; break; // HIRAGANA LETTER DE
    case 0xAAC8: code_point = 0x3068; break; // HIRAGANA LETTER TO
    case 0xAAC9: code_point = 0x3069; break; // HIRAGANA LETTER DO
    case 0xAACA: code_point = 0x306A; break; // HIRAGANA LETTER NA
    case 0xAACB: code_point = 0x306B; break; // HIRAGANA LETTER NI
    case 0xAACC: code_point = 0x306C; break; // HIRAGANA LETTER NU
    case 0xAACD: code_point = 0x306D; break; // HIRAGANA LETTER NE
    case 0xAACE: code_point = 0x306E; break; // HIRAGANA LETTER NO
    case 0xAACF: code_point = 0x306F; break; // HIRAGANA LETTER HA
    case 0xAAD0: code_point = 0x3070; break; // HIRAGANA LETTER BA
    case 0xAAD1: code_point = 0x3071; break; // HIRAGANA LETTER PA
    case 0xAAD2: code_point = 0x3072; break; // HIRAGANA LETTER HI
    case 0xAAD3: code_point = 0x3073; break; // HIRAGANA LETTER BI
    case 0xAAD4: code_point = 0x3074; break; // HIRAGANA LETTER PI
    case 0xAAD5: code_point = 0x3075; break; // HIRAGANA LETTER HU
    case 0xAAD6: code_point = 0x3076; break; // HIRAGANA LETTER BU
    case 0xAAD7: code_point = 0x3077; break; // HIRAGANA LETTER PU
    case 0xAAD8: code_point = 0x3078; break; // HIRAGANA LETTER HE
    case 0xAAD9: code_point = 0x3079; break; // HIRAGANA LETTER BE
    case 0xAADA: code_point = 0x307A; break; // HIRAGANA LETTER PE
    case 0xAADB: code_point = 0x307B; break; // HIRAGANA LETTER HO
    case 0xAADC: code_point = 0x307C; break; // HIRAGANA LETTER BO
    case 0xAADD: code_point = 0x307D; break; // HIRAGANA LETTER PO
    case 0xAADE: code_point = 0x307E; break; // HIRAGANA LETTER MA
    case 0xAADF: code_point = 0x307F; break; // HIRAGANA LETTER MI
    case 0xAAE0: code_point = 0x3080; break; // HIRAGANA LETTER MU
    case 0xAAE1: code_point = 0x3081; break; // HIRAGANA LETTER ME
    case 0xAAE2: code_point = 0x3082; break; // HIRAGANA LETTER MO
    case 0xAAE3: code_point = 0x3083; break; // HIRAGANA LETTER SMALL YA
    case 0xAAE4: code_point = 0x3084; break; // HIRAGANA LETTER YA
    case 0xAAE5: code_point = 0x3085; break; // HIRAGANA LETTER SMALL YU
    case 0xAAE6: code_point = 0x3086; break; // HIRAGANA LETTER YU
    case 0xAAE7: code_point = 0x3087; break; // HIRAGANA LETTER SMALL YO
    case 0xAAE8: code_point = 0x3088; break; // HIRAGANA LETTER YO
    case 0xAAE9: code_point = 0x3089; break; // HIRAGANA LETTER RA
    case 0xAAEA: code_point = 0x308A; break; // HIRAGANA LETTER RI
    case 0xAAEB: code_point = 0x308B; break; // HIRAGANA LETTER RU
    case 0xAAEC: code_point = 0x308C; break; // HIRAGANA LETTER RE
    case 0xAAED: code_point = 0x308D; break; // HIRAGANA LETTER RO
    case 0xAAEE: code_point = 0x308E; break; // HIRAGANA LETTER SMALL WA
    case 0xAAEF: code_point = 0x308F; break; // HIRAGANA LETTER WA
    case 0xAAF0: code_point = 0x3090; break; // HIRAGANA LETTER WI
    case 0xAAF1: code_point = 0x3091; break; // HIRAGANA LETTER WE
    case 0xAAF2: code_point = 0x3092; break; // HIRAGANA LETTER WO
    case 0xAAF3: code_point = 0x3093; break; // HIRAGANA LETTER N
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xAB(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xAB41: code_point = 0xCC94; break; // HANGUL SYLLABLE CHIEUCH YAE KHIEUKH
    case 0xAB42: code_point = 0xCC95; break; // HANGUL SYLLABLE CHIEUCH YAE THIEUTH
    case 0xAB43: code_point = 0xCC96; break; // HANGUL SYLLABLE CHIEUCH YAE PHIEUPH
    case 0xAB44: code_point = 0xCC97; break; // HANGUL SYLLABLE CHIEUCH YAE HIEUH
    case 0xAB45: code_point = 0xCC9A; break; // HANGUL SYLLABLE CHIEUCH EO SSANGKIYEOK
    case 0xAB46: code_point = 0xCC9B; break; // HANGUL SYLLABLE CHIEUCH EO KIYEOKSIOS
    case 0xAB47: code_point = 0xCC9D; break; // HANGUL SYLLABLE CHIEUCH EO NIEUNCIEUC
    case 0xAB48: code_point = 0xCC9E; break; // HANGUL SYLLABLE CHIEUCH EO NIEUNHIEUH
    case 0xAB49: code_point = 0xCC9F; break; // HANGUL SYLLABLE CHIEUCH EO TIKEUT
    case 0xAB4A: code_point = 0xCCA1; break; // HANGUL SYLLABLE CHIEUCH EO RIEULKIYEOK
    case 0xAB4B: code_point = 0xCCA2; break; // HANGUL SYLLABLE CHIEUCH EO RIEULMIEUM
    case 0xAB4C: code_point = 0xCCA3; break; // HANGUL SYLLABLE CHIEUCH EO RIEULPIEUP
    case 0xAB4D: code_point = 0xCCA4; break; // HANGUL SYLLABLE CHIEUCH EO RIEULSIOS
    case 0xAB4E: code_point = 0xCCA5; break; // HANGUL SYLLABLE CHIEUCH EO RIEULTHIEUTH
    case 0xAB4F: code_point = 0xCCA6; break; // HANGUL SYLLABLE CHIEUCH EO RIEULPHIEUPH
    case 0xAB50: code_point = 0xCCA7; break; // HANGUL SYLLABLE CHIEUCH EO RIEULHIEUH
    case 0xAB51: code_point = 0xCCAA; break; // HANGUL SYLLABLE CHIEUCH EO PIEUPSIOS
    case 0xAB52: code_point = 0xCCAE; break; // HANGUL SYLLABLE CHIEUCH EO CIEUC
    case 0xAB53: code_point = 0xCCAF; break; // HANGUL SYLLABLE CHIEUCH EO CHIEUCH
    case 0xAB54: code_point = 0xCCB0; break; // HANGUL SYLLABLE CHIEUCH EO KHIEUKH
    case 0xAB55: code_point = 0xCCB1; break; // HANGUL SYLLABLE CHIEUCH EO THIEUTH
    case 0xAB56: code_point = 0xCCB2; break; // HANGUL SYLLABLE CHIEUCH EO PHIEUPH
    case 0xAB57: code_point = 0xCCB3; break; // HANGUL SYLLABLE CHIEUCH EO HIEUH
    case 0xAB58: code_point = 0xCCB6; break; // HANGUL SYLLABLE CHIEUCH E SSANGKIYEOK
    case 0xAB59: code_point = 0xCCB7; break; // HANGUL SYLLABLE CHIEUCH E KIYEOKSIOS
    case 0xAB5A: code_point = 0xCCB9; break; // HANGUL SYLLABLE CHIEUCH E NIEUNCIEUC
    case 0xAB61: code_point = 0xCCBA; break; // HANGUL SYLLABLE CHIEUCH E NIEUNHIEUH
    case 0xAB62: code_point = 0xCCBB; break; // HANGUL SYLLABLE CHIEUCH E TIKEUT
    case 0xAB63: code_point = 0xCCBD; break; // HANGUL SYLLABLE CHIEUCH E RIEULKIYEOK
    case 0xAB64: code_point = 0xCCBE; break; // HANGUL SYLLABLE CHIEUCH E RIEULMIEUM
    case 0xAB65: code_point = 0xCCBF; break; // HANGUL SYLLABLE CHIEUCH E RIEULPIEUP
    case 0xAB66: code_point = 0xCCC0; break; // HANGUL SYLLABLE CHIEUCH E RIEULSIOS
    case 0xAB67: code_point = 0xCCC1; break; // HANGUL SYLLABLE CHIEUCH E RIEULTHIEUTH
    case 0xAB68: code_point = 0xCCC2; break; // HANGUL SYLLABLE CHIEUCH E RIEULPHIEUPH
    case 0xAB69: code_point = 0xCCC3; break; // HANGUL SYLLABLE CHIEUCH E RIEULHIEUH
    case 0xAB6A: code_point = 0xCCC6; break; // HANGUL SYLLABLE CHIEUCH E PIEUPSIOS
    case 0xAB6B: code_point = 0xCCC8; break; // HANGUL SYLLABLE CHIEUCH E SSANGSIOS
    case 0xAB6C: code_point = 0xCCCA; break; // HANGUL SYLLABLE CHIEUCH E CIEUC
    case 0xAB6D: code_point = 0xCCCB; break; // HANGUL SYLLABLE CHIEUCH E CHIEUCH
    case 0xAB6E: code_point = 0xCCCC; break; // HANGUL SYLLABLE CHIEUCH E KHIEUKH
    case 0xAB6F: code_point = 0xCCCD; break; // HANGUL SYLLABLE CHIEUCH E THIEUTH
    case 0xAB70: code_point = 0xCCCE; break; // HANGUL SYLLABLE CHIEUCH E PHIEUPH
    case 0xAB71: code_point = 0xCCCF; break; // HANGUL SYLLABLE CHIEUCH E HIEUH
    case 0xAB72: code_point = 0xCCD1; break; // HANGUL SYLLABLE CHIEUCH YEO KIYEOK
    case 0xAB73: code_point = 0xCCD2; break; // HANGUL SYLLABLE CHIEUCH YEO SSANGKIYEOK
    case 0xAB74: code_point = 0xCCD3; break; // HANGUL SYLLABLE CHIEUCH YEO KIYEOKSIOS
    case 0xAB75: code_point = 0xCCD5; break; // HANGUL SYLLABLE CHIEUCH YEO NIEUNCIEUC
    case 0xAB76: code_point = 0xCCD6; break; // HANGUL SYLLABLE CHIEUCH YEO NIEUNHIEUH
    case 0xAB77: code_point = 0xCCD7; break; // HANGUL SYLLABLE CHIEUCH YEO TIKEUT
    case 0xAB78: code_point = 0xCCD8; break; // HANGUL SYLLABLE CHIEUCH YEO RIEUL
    case 0xAB79: code_point = 0xCCD9; break; // HANGUL SYLLABLE CHIEUCH YEO RIEULKIYEOK
    case 0xAB7A: code_point = 0xCCDA; break; // HANGUL SYLLABLE CHIEUCH YEO RIEULMIEUM
    case 0xAB81: code_point = 0xCCDB; break; // HANGUL SYLLABLE CHIEUCH YEO RIEULPIEUP
    case 0xAB82: code_point = 0xCCDC; break; // HANGUL SYLLABLE CHIEUCH YEO RIEULSIOS
    case 0xAB83: code_point = 0xCCDD; break; // HANGUL SYLLABLE CHIEUCH YEO RIEULTHIEUTH
    case 0xAB84: code_point = 0xCCDE; break; // HANGUL SYLLABLE CHIEUCH YEO RIEULPHIEUPH
    case 0xAB85: code_point = 0xCCDF; break; // HANGUL SYLLABLE CHIEUCH YEO RIEULHIEUH
    case 0xAB86: code_point = 0xCCE0; break; // HANGUL SYLLABLE CHIEUCH YEO MIEUM
    case 0xAB87: code_point = 0xCCE1; break; // HANGUL SYLLABLE CHIEUCH YEO PIEUP
    case 0xAB88: code_point = 0xCCE2; break; // HANGUL SYLLABLE CHIEUCH YEO PIEUPSIOS
    case 0xAB89: code_point = 0xCCE3; break; // HANGUL SYLLABLE CHIEUCH YEO SIOS
    case 0xAB8A: code_point = 0xCCE5; break; // HANGUL SYLLABLE CHIEUCH YEO IEUNG
    case 0xAB8B: code_point = 0xCCE6; break; // HANGUL SYLLABLE CHIEUCH YEO CIEUC
    case 0xAB8C: code_point = 0xCCE7; break; // HANGUL SYLLABLE CHIEUCH YEO CHIEUCH
    case 0xAB8D: code_point = 0xCCE8; break; // HANGUL SYLLABLE CHIEUCH YEO KHIEUKH
    case 0xAB8E: code_point = 0xCCE9; break; // HANGUL SYLLABLE CHIEUCH YEO THIEUTH
    case 0xAB8F: code_point = 0xCCEA; break; // HANGUL SYLLABLE CHIEUCH YEO PHIEUPH
    case 0xAB90: code_point = 0xCCEB; break; // HANGUL SYLLABLE CHIEUCH YEO HIEUH
    case 0xAB91: code_point = 0xCCED; break; // HANGUL SYLLABLE CHIEUCH YE KIYEOK
    case 0xAB92: code_point = 0xCCEE; break; // HANGUL SYLLABLE CHIEUCH YE SSANGKIYEOK
    case 0xAB93: code_point = 0xCCEF; break; // HANGUL SYLLABLE CHIEUCH YE KIYEOKSIOS
    case 0xAB94: code_point = 0xCCF1; break; // HANGUL SYLLABLE CHIEUCH YE NIEUNCIEUC
    case 0xAB95: code_point = 0xCCF2; break; // HANGUL SYLLABLE CHIEUCH YE NIEUNHIEUH
    case 0xAB96: code_point = 0xCCF3; break; // HANGUL SYLLABLE CHIEUCH YE TIKEUT
    case 0xAB97: code_point = 0xCCF4; break; // HANGUL SYLLABLE CHIEUCH YE RIEUL
    case 0xAB98: code_point = 0xCCF5; break; // HANGUL SYLLABLE CHIEUCH YE RIEULKIYEOK
    case 0xAB99: code_point = 0xCCF6; break; // HANGUL SYLLABLE CHIEUCH YE RIEULMIEUM
    case 0xAB9A: code_point = 0xCCF7; break; // HANGUL SYLLABLE CHIEUCH YE RIEULPIEUP
    case 0xAB9B: code_point = 0xCCF8; break; // HANGUL SYLLABLE CHIEUCH YE RIEULSIOS
    case 0xAB9C: code_point = 0xCCF9; break; // HANGUL SYLLABLE CHIEUCH YE RIEULTHIEUTH
    case 0xAB9D: code_point = 0xCCFA; break; // HANGUL SYLLABLE CHIEUCH YE RIEULPHIEUPH
    case 0xAB9E: code_point = 0xCCFB; break; // HANGUL SYLLABLE CHIEUCH YE RIEULHIEUH
    case 0xAB9F: code_point = 0xCCFC; break; // HANGUL SYLLABLE CHIEUCH YE MIEUM
    case 0xABA0: code_point = 0xCCFD; break; // HANGUL SYLLABLE CHIEUCH YE PIEUP
    case 0xABA1: code_point = 0x30A1; break; // KATAKANA LETTER SMALL A
    case 0xABA2: code_point = 0x30A2; break; // KATAKANA LETTER A
    case 0xABA3: code_point = 0x30A3; break; // KATAKANA LETTER SMALL I
    case 0xABA4: code_point = 0x30A4; break; // KATAKANA LETTER I
    case 0xABA5: code_point = 0x30A5; break; // KATAKANA LETTER SMALL U
    case 0xABA6: code_point = 0x30A6; break; // KATAKANA LETTER U
    case 0xABA7: code_point = 0x30A7; break; // KATAKANA LETTER SMALL E
    case 0xABA8: code_point = 0x30A8; break; // KATAKANA LETTER E
    case 0xABA9: code_point = 0x30A9; break; // KATAKANA LETTER SMALL O
    case 0xABAA: code_point = 0x30AA; break; // KATAKANA LETTER O
    case 0xABAB: code_point = 0x30AB; break; // KATAKANA LETTER KA
    case 0xABAC: code_point = 0x30AC; break; // KATAKANA LETTER GA
    case 0xABAD: code_point = 0x30AD; break; // KATAKANA LETTER KI
    case 0xABAE: code_point = 0x30AE; break; // KATAKANA LETTER GI
    case 0xABAF: code_point = 0x30AF; break; // KATAKANA LETTER KU
    case 0xABB0: code_point = 0x30B0; break; // KATAKANA LETTER GU
    case 0xABB1: code_point = 0x30B1; break; // KATAKANA LETTER KE
    case 0xABB2: code_point = 0x30B2; break; // KATAKANA LETTER GE
    case 0xABB3: code_point = 0x30B3; break; // KATAKANA LETTER KO
    case 0xABB4: code_point = 0x30B4; break; // KATAKANA LETTER GO
    case 0xABB5: code_point = 0x30B5; break; // KATAKANA LETTER SA
    case 0xABB6: code_point = 0x30B6; break; // KATAKANA LETTER ZA
    case 0xABB7: code_point = 0x30B7; break; // KATAKANA LETTER SI
    case 0xABB8: code_point = 0x30B8; break; // KATAKANA LETTER ZI
    case 0xABB9: code_point = 0x30B9; break; // KATAKANA LETTER SU
    case 0xABBA: code_point = 0x30BA; break; // KATAKANA LETTER ZU
    case 0xABBB: code_point = 0x30BB; break; // KATAKANA LETTER SE
    case 0xABBC: code_point = 0x30BC; break; // KATAKANA LETTER ZE
    case 0xABBD: code_point = 0x30BD; break; // KATAKANA LETTER SO
    case 0xABBE: code_point = 0x30BE; break; // KATAKANA LETTER ZO
    case 0xABBF: code_point = 0x30BF; break; // KATAKANA LETTER TA
    case 0xABC0: code_point = 0x30C0; break; // KATAKANA LETTER DA
    case 0xABC1: code_point = 0x30C1; break; // KATAKANA LETTER TI
    case 0xABC2: code_point = 0x30C2; break; // KATAKANA LETTER DI
    case 0xABC3: code_point = 0x30C3; break; // KATAKANA LETTER SMALL TU
    case 0xABC4: code_point = 0x30C4; break; // KATAKANA LETTER TU
    case 0xABC5: code_point = 0x30C5; break; // KATAKANA LETTER DU
    case 0xABC6: code_point = 0x30C6; break; // KATAKANA LETTER TE
    case 0xABC7: code_point = 0x30C7; break; // KATAKANA LETTER DE
    case 0xABC8: code_point = 0x30C8; break; // KATAKANA LETTER TO
    case 0xABC9: code_point = 0x30C9; break; // KATAKANA LETTER DO
    case 0xABCA: code_point = 0x30CA; break; // KATAKANA LETTER NA
    case 0xABCB: code_point = 0x30CB; break; // KATAKANA LETTER NI
    case 0xABCC: code_point = 0x30CC; break; // KATAKANA LETTER NU
    case 0xABCD: code_point = 0x30CD; break; // KATAKANA LETTER NE
    case 0xABCE: code_point = 0x30CE; break; // KATAKANA LETTER NO
    case 0xABCF: code_point = 0x30CF; break; // KATAKANA LETTER HA
    case 0xABD0: code_point = 0x30D0; break; // KATAKANA LETTER BA
    case 0xABD1: code_point = 0x30D1; break; // KATAKANA LETTER PA
    case 0xABD2: code_point = 0x30D2; break; // KATAKANA LETTER HI
    case 0xABD3: code_point = 0x30D3; break; // KATAKANA LETTER BI
    case 0xABD4: code_point = 0x30D4; break; // KATAKANA LETTER PI
    case 0xABD5: code_point = 0x30D5; break; // KATAKANA LETTER HU
    case 0xABD6: code_point = 0x30D6; break; // KATAKANA LETTER BU
    case 0xABD7: code_point = 0x30D7; break; // KATAKANA LETTER PU
    case 0xABD8: code_point = 0x30D8; break; // KATAKANA LETTER HE
    case 0xABD9: code_point = 0x30D9; break; // KATAKANA LETTER BE
    case 0xABDA: code_point = 0x30DA; break; // KATAKANA LETTER PE
    case 0xABDB: code_point = 0x30DB; break; // KATAKANA LETTER HO
    case 0xABDC: code_point = 0x30DC; break; // KATAKANA LETTER BO
    case 0xABDD: code_point = 0x30DD; break; // KATAKANA LETTER PO
    case 0xABDE: code_point = 0x30DE; break; // KATAKANA LETTER MA
    case 0xABDF: code_point = 0x30DF; break; // KATAKANA LETTER MI
    case 0xABE0: code_point = 0x30E0; break; // KATAKANA LETTER MU
    case 0xABE1: code_point = 0x30E1; break; // KATAKANA LETTER ME
    case 0xABE2: code_point = 0x30E2; break; // KATAKANA LETTER MO
    case 0xABE3: code_point = 0x30E3; break; // KATAKANA LETTER SMALL YA
    case 0xABE4: code_point = 0x30E4; break; // KATAKANA LETTER YA
    case 0xABE5: code_point = 0x30E5; break; // KATAKANA LETTER SMALL YU
    case 0xABE6: code_point = 0x30E6; break; // KATAKANA LETTER YU
    case 0xABE7: code_point = 0x30E7; break; // KATAKANA LETTER SMALL YO
    case 0xABE8: code_point = 0x30E8; break; // KATAKANA LETTER YO
    case 0xABE9: code_point = 0x30E9; break; // KATAKANA LETTER RA
    case 0xABEA: code_point = 0x30EA; break; // KATAKANA LETTER RI
    case 0xABEB: code_point = 0x30EB; break; // KATAKANA LETTER RU
    case 0xABEC: code_point = 0x30EC; break; // KATAKANA LETTER RE
    case 0xABED: code_point = 0x30ED; break; // KATAKANA LETTER RO
    case 0xABEE: code_point = 0x30EE; break; // KATAKANA LETTER SMALL WA
    case 0xABEF: code_point = 0x30EF; break; // KATAKANA LETTER WA
    case 0xABF0: code_point = 0x30F0; break; // KATAKANA LETTER WI
    case 0xABF1: code_point = 0x30F1; break; // KATAKANA LETTER WE
    case 0xABF2: code_point = 0x30F2; break; // KATAKANA LETTER WO
    case 0xABF3: code_point = 0x30F3; break; // KATAKANA LETTER N
    case 0xABF4: code_point = 0x30F4; break; // KATAKANA LETTER VU
    case 0xABF5: code_point = 0x30F5; break; // KATAKANA LETTER SMALL KA
    case 0xABF6: code_point = 0x30F6; break; // KATAKANA LETTER SMALL KE
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xAC(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xAC41: code_point = 0xCCFE; break; // HANGUL SYLLABLE CHIEUCH YE PIEUPSIOS
    case 0xAC42: code_point = 0xCCFF; break; // HANGUL SYLLABLE CHIEUCH YE SIOS
    case 0xAC43: code_point = 0xCD00; break; // HANGUL SYLLABLE CHIEUCH YE SSANGSIOS
    case 0xAC44: code_point = 0xCD02; break; // HANGUL SYLLABLE CHIEUCH YE CIEUC
    case 0xAC45: code_point = 0xCD03; break; // HANGUL SYLLABLE CHIEUCH YE CHIEUCH
    case 0xAC46: code_point = 0xCD04; break; // HANGUL SYLLABLE CHIEUCH YE KHIEUKH
    case 0xAC47: code_point = 0xCD05; break; // HANGUL SYLLABLE CHIEUCH YE THIEUTH
    case 0xAC48: code_point = 0xCD06; break; // HANGUL SYLLABLE CHIEUCH YE PHIEUPH
    case 0xAC49: code_point = 0xCD07; break; // HANGUL SYLLABLE CHIEUCH YE HIEUH
    case 0xAC4A: code_point = 0xCD0A; break; // HANGUL SYLLABLE CHIEUCH O SSANGKIYEOK
    case 0xAC4B: code_point = 0xCD0B; break; // HANGUL SYLLABLE CHIEUCH O KIYEOKSIOS
    case 0xAC4C: code_point = 0xCD0D; break; // HANGUL SYLLABLE CHIEUCH O NIEUNCIEUC
    case 0xAC4D: code_point = 0xCD0E; break; // HANGUL SYLLABLE CHIEUCH O NIEUNHIEUH
    case 0xAC4E: code_point = 0xCD0F; break; // HANGUL SYLLABLE CHIEUCH O TIKEUT
    case 0xAC4F: code_point = 0xCD11; break; // HANGUL SYLLABLE CHIEUCH O RIEULKIYEOK
    case 0xAC50: code_point = 0xCD12; break; // HANGUL SYLLABLE CHIEUCH O RIEULMIEUM
    case 0xAC51: code_point = 0xCD13; break; // HANGUL SYLLABLE CHIEUCH O RIEULPIEUP
    case 0xAC52: code_point = 0xCD14; break; // HANGUL SYLLABLE CHIEUCH O RIEULSIOS
    case 0xAC53: code_point = 0xCD15; break; // HANGUL SYLLABLE CHIEUCH O RIEULTHIEUTH
    case 0xAC54: code_point = 0xCD16; break; // HANGUL SYLLABLE CHIEUCH O RIEULPHIEUPH
    case 0xAC55: code_point = 0xCD17; break; // HANGUL SYLLABLE CHIEUCH O RIEULHIEUH
    case 0xAC56: code_point = 0xCD1A; break; // HANGUL SYLLABLE CHIEUCH O PIEUPSIOS
    case 0xAC57: code_point = 0xCD1C; break; // HANGUL SYLLABLE CHIEUCH O SSANGSIOS
    case 0xAC58: code_point = 0xCD1E; break; // HANGUL SYLLABLE CHIEUCH O CIEUC
    case 0xAC59: code_point = 0xCD1F; break; // HANGUL SYLLABLE CHIEUCH O CHIEUCH
    case 0xAC5A: code_point = 0xCD20; break; // HANGUL SYLLABLE CHIEUCH O KHIEUKH
    case 0xAC61: code_point = 0xCD21; break; // HANGUL SYLLABLE CHIEUCH O THIEUTH
    case 0xAC62: code_point = 0xCD22; break; // HANGUL SYLLABLE CHIEUCH O PHIEUPH
    case 0xAC63: code_point = 0xCD23; break; // HANGUL SYLLABLE CHIEUCH O HIEUH
    case 0xAC64: code_point = 0xCD25; break; // HANGUL SYLLABLE CHIEUCH WA KIYEOK
    case 0xAC65: code_point = 0xCD26; break; // HANGUL SYLLABLE CHIEUCH WA SSANGKIYEOK
    case 0xAC66: code_point = 0xCD27; break; // HANGUL SYLLABLE CHIEUCH WA KIYEOKSIOS
    case 0xAC67: code_point = 0xCD29; break; // HANGUL SYLLABLE CHIEUCH WA NIEUNCIEUC
    case 0xAC68: code_point = 0xCD2A; break; // HANGUL SYLLABLE CHIEUCH WA NIEUNHIEUH
    case 0xAC69: code_point = 0xCD2B; break; // HANGUL SYLLABLE CHIEUCH WA TIKEUT
    case 0xAC6A: code_point = 0xCD2D; break; // HANGUL SYLLABLE CHIEUCH WA RIEULKIYEOK
    case 0xAC6B: code_point = 0xCD2E; break; // HANGUL SYLLABLE CHIEUCH WA RIEULMIEUM
    case 0xAC6C: code_point = 0xCD2F; break; // HANGUL SYLLABLE CHIEUCH WA RIEULPIEUP
    case 0xAC6D: code_point = 0xCD30; break; // HANGUL SYLLABLE CHIEUCH WA RIEULSIOS
    case 0xAC6E: code_point = 0xCD31; break; // HANGUL SYLLABLE CHIEUCH WA RIEULTHIEUTH
    case 0xAC6F: code_point = 0xCD32; break; // HANGUL SYLLABLE CHIEUCH WA RIEULPHIEUPH
    case 0xAC70: code_point = 0xCD33; break; // HANGUL SYLLABLE CHIEUCH WA RIEULHIEUH
    case 0xAC71: code_point = 0xCD34; break; // HANGUL SYLLABLE CHIEUCH WA MIEUM
    case 0xAC72: code_point = 0xCD35; break; // HANGUL SYLLABLE CHIEUCH WA PIEUP
    case 0xAC73: code_point = 0xCD36; break; // HANGUL SYLLABLE CHIEUCH WA PIEUPSIOS
    case 0xAC74: code_point = 0xCD37; break; // HANGUL SYLLABLE CHIEUCH WA SIOS
    case 0xAC75: code_point = 0xCD38; break; // HANGUL SYLLABLE CHIEUCH WA SSANGSIOS
    case 0xAC76: code_point = 0xCD3A; break; // HANGUL SYLLABLE CHIEUCH WA CIEUC
    case 0xAC77: code_point = 0xCD3B; break; // HANGUL SYLLABLE CHIEUCH WA CHIEUCH
    case 0xAC78: code_point = 0xCD3C; break; // HANGUL SYLLABLE CHIEUCH WA KHIEUKH
    case 0xAC79: code_point = 0xCD3D; break; // HANGUL SYLLABLE CHIEUCH WA THIEUTH
    case 0xAC7A: code_point = 0xCD3E; break; // HANGUL SYLLABLE CHIEUCH WA PHIEUPH
    case 0xAC81: code_point = 0xCD3F; break; // HANGUL SYLLABLE CHIEUCH WA HIEUH
    case 0xAC82: code_point = 0xCD40; break; // HANGUL SYLLABLE CHIEUCH WAE
    case 0xAC83: code_point = 0xCD41; break; // HANGUL SYLLABLE CHIEUCH WAE KIYEOK
    case 0xAC84: code_point = 0xCD42; break; // HANGUL SYLLABLE CHIEUCH WAE SSANGKIYEOK
    case 0xAC85: code_point = 0xCD43; break; // HANGUL SYLLABLE CHIEUCH WAE KIYEOKSIOS
    case 0xAC86: code_point = 0xCD44; break; // HANGUL SYLLABLE CHIEUCH WAE NIEUN
    case 0xAC87: code_point = 0xCD45; break; // HANGUL SYLLABLE CHIEUCH WAE NIEUNCIEUC
    case 0xAC88: code_point = 0xCD46; break; // HANGUL SYLLABLE CHIEUCH WAE NIEUNHIEUH
    case 0xAC89: code_point = 0xCD47; break; // HANGUL SYLLABLE CHIEUCH WAE TIKEUT
    case 0xAC8A: code_point = 0xCD48; break; // HANGUL SYLLABLE CHIEUCH WAE RIEUL
    case 0xAC8B: code_point = 0xCD49; break; // HANGUL SYLLABLE CHIEUCH WAE RIEULKIYEOK
    case 0xAC8C: code_point = 0xCD4A; break; // HANGUL SYLLABLE CHIEUCH WAE RIEULMIEUM
    case 0xAC8D: code_point = 0xCD4B; break; // HANGUL SYLLABLE CHIEUCH WAE RIEULPIEUP
    case 0xAC8E: code_point = 0xCD4C; break; // HANGUL SYLLABLE CHIEUCH WAE RIEULSIOS
    case 0xAC8F: code_point = 0xCD4D; break; // HANGUL SYLLABLE CHIEUCH WAE RIEULTHIEUTH
    case 0xAC90: code_point = 0xCD4E; break; // HANGUL SYLLABLE CHIEUCH WAE RIEULPHIEUPH
    case 0xAC91: code_point = 0xCD4F; break; // HANGUL SYLLABLE CHIEUCH WAE RIEULHIEUH
    case 0xAC92: code_point = 0xCD50; break; // HANGUL SYLLABLE CHIEUCH WAE MIEUM
    case 0xAC93: code_point = 0xCD51; break; // HANGUL SYLLABLE CHIEUCH WAE PIEUP
    case 0xAC94: code_point = 0xCD52; break; // HANGUL SYLLABLE CHIEUCH WAE PIEUPSIOS
    case 0xAC95: code_point = 0xCD53; break; // HANGUL SYLLABLE CHIEUCH WAE SIOS
    case 0xAC96: code_point = 0xCD54; break; // HANGUL SYLLABLE CHIEUCH WAE SSANGSIOS
    case 0xAC97: code_point = 0xCD55; break; // HANGUL SYLLABLE CHIEUCH WAE IEUNG
    case 0xAC98: code_point = 0xCD56; break; // HANGUL SYLLABLE CHIEUCH WAE CIEUC
    case 0xAC99: code_point = 0xCD57; break; // HANGUL SYLLABLE CHIEUCH WAE CHIEUCH
    case 0xAC9A: code_point = 0xCD58; break; // HANGUL SYLLABLE CHIEUCH WAE KHIEUKH
    case 0xAC9B: code_point = 0xCD59; break; // HANGUL SYLLABLE CHIEUCH WAE THIEUTH
    case 0xAC9C: code_point = 0xCD5A; break; // HANGUL SYLLABLE CHIEUCH WAE PHIEUPH
    case 0xAC9D: code_point = 0xCD5B; break; // HANGUL SYLLABLE CHIEUCH WAE HIEUH
    case 0xAC9E: code_point = 0xCD5D; break; // HANGUL SYLLABLE CHIEUCH OE KIYEOK
    case 0xAC9F: code_point = 0xCD5E; break; // HANGUL SYLLABLE CHIEUCH OE SSANGKIYEOK
    case 0xACA0: code_point = 0xCD5F; break; // HANGUL SYLLABLE CHIEUCH OE KIYEOKSIOS
    case 0xACA1: code_point = 0x0410; break; // CYRILLIC CAPITAL LETTER A
    case 0xACA2: code_point = 0x0411; break; // CYRILLIC CAPITAL LETTER BE
    case 0xACA3: code_point = 0x0412; break; // CYRILLIC CAPITAL LETTER VE
    case 0xACA4: code_point = 0x0413; break; // CYRILLIC CAPITAL LETTER GHE
    case 0xACA5: code_point = 0x0414; break; // CYRILLIC CAPITAL LETTER DE
    case 0xACA6: code_point = 0x0415; break; // CYRILLIC CAPITAL LETTER IE
    case 0xACA7: code_point = 0x0401; break; // CYRILLIC CAPITAL LETTER IO
    case 0xACA8: code_point = 0x0416; break; // CYRILLIC CAPITAL LETTER ZHE
    case 0xACA9: code_point = 0x0417; break; // CYRILLIC CAPITAL LETTER ZE
    case 0xACAA: code_point = 0x0418; break; // CYRILLIC CAPITAL LETTER I
    case 0xACAB: code_point = 0x0419; break; // CYRILLIC CAPITAL LETTER SHORT I
    case 0xACAC: code_point = 0x041A; break; // CYRILLIC CAPITAL LETTER KA
    case 0xACAD: code_point = 0x041B; break; // CYRILLIC CAPITAL LETTER EL
    case 0xACAE: code_point = 0x041C; break; // CYRILLIC CAPITAL LETTER EM
    case 0xACAF: code_point = 0x041D; break; // CYRILLIC CAPITAL LETTER EN
    case 0xACB0: code_point = 0x041E; break; // CYRILLIC CAPITAL LETTER O
    case 0xACB1: code_point = 0x041F; break; // CYRILLIC CAPITAL LETTER PE
    case 0xACB2: code_point = 0x0420; break; // CYRILLIC CAPITAL LETTER ER
    case 0xACB3: code_point = 0x0421; break; // CYRILLIC CAPITAL LETTER ES
    case 0xACB4: code_point = 0x0422; break; // CYRILLIC CAPITAL LETTER TE
    case 0xACB5: code_point = 0x0423; break; // CYRILLIC CAPITAL LETTER U
    case 0xACB6: code_point = 0x0424; break; // CYRILLIC CAPITAL LETTER EF
    case 0xACB7: code_point = 0x0425; break; // CYRILLIC CAPITAL LETTER HA
    case 0xACB8: code_point = 0x0426; break; // CYRILLIC CAPITAL LETTER TSE
    case 0xACB9: code_point = 0x0427; break; // CYRILLIC CAPITAL LETTER CHE
    case 0xACBA: code_point = 0x0428; break; // CYRILLIC CAPITAL LETTER SHA
    case 0xACBB: code_point = 0x0429; break; // CYRILLIC CAPITAL LETTER SHCHA
    case 0xACBC: code_point = 0x042A; break; // CYRILLIC CAPITAL LETTER HARD SIGN
    case 0xACBD: code_point = 0x042B; break; // CYRILLIC CAPITAL LETTER YERU
    case 0xACBE: code_point = 0x042C; break; // CYRILLIC CAPITAL LETTER SOFT SIGN
    case 0xACBF: code_point = 0x042D; break; // CYRILLIC CAPITAL LETTER E
    case 0xACC0: code_point = 0x042E; break; // CYRILLIC CAPITAL LETTER YU
    case 0xACC1: code_point = 0x042F; break; // CYRILLIC CAPITAL LETTER YA
    case 0xACD1: code_point = 0x0430; break; // CYRILLIC SMALL LETTER A
    case 0xACD2: code_point = 0x0431; break; // CYRILLIC SMALL LETTER BE
    case 0xACD3: code_point = 0x0432; break; // CYRILLIC SMALL LETTER VE
    case 0xACD4: code_point = 0x0433; break; // CYRILLIC SMALL LETTER GHE
    case 0xACD5: code_point = 0x0434; break; // CYRILLIC SMALL LETTER DE
    case 0xACD6: code_point = 0x0435; break; // CYRILLIC SMALL LETTER IE
    case 0xACD7: code_point = 0x0451; break; // CYRILLIC SMALL LETTER IO
    case 0xACD8: code_point = 0x0436; break; // CYRILLIC SMALL LETTER ZHE
    case 0xACD9: code_point = 0x0437; break; // CYRILLIC SMALL LETTER ZE
    case 0xACDA: code_point = 0x0438; break; // CYRILLIC SMALL LETTER I
    case 0xACDB: code_point = 0x0439; break; // CYRILLIC SMALL LETTER SHORT I
    case 0xACDC: code_point = 0x043A; break; // CYRILLIC SMALL LETTER KA
    case 0xACDD: code_point = 0x043B; break; // CYRILLIC SMALL LETTER EL
    case 0xACDE: code_point = 0x043C; break; // CYRILLIC SMALL LETTER EM
    case 0xACDF: code_point = 0x043D; break; // CYRILLIC SMALL LETTER EN
    case 0xACE0: code_point = 0x043E; break; // CYRILLIC SMALL LETTER O
    case 0xACE1: code_point = 0x043F; break; // CYRILLIC SMALL LETTER PE
    case 0xACE2: code_point = 0x0440; break; // CYRILLIC SMALL LETTER ER
    case 0xACE3: code_point = 0x0441; break; // CYRILLIC SMALL LETTER ES
    case 0xACE4: code_point = 0x0442; break; // CYRILLIC SMALL LETTER TE
    case 0xACE5: code_point = 0x0443; break; // CYRILLIC SMALL LETTER U
    case 0xACE6: code_point = 0x0444; break; // CYRILLIC SMALL LETTER EF
    case 0xACE7: code_point = 0x0445; break; // CYRILLIC SMALL LETTER HA
    case 0xACE8: code_point = 0x0446; break; // CYRILLIC SMALL LETTER TSE
    case 0xACE9: code_point = 0x0447; break; // CYRILLIC SMALL LETTER CHE
    case 0xACEA: code_point = 0x0448; break; // CYRILLIC SMALL LETTER SHA
    case 0xACEB: code_point = 0x0449; break; // CYRILLIC SMALL LETTER SHCHA
    case 0xACEC: code_point = 0x044A; break; // CYRILLIC SMALL LETTER HARD SIGN
    case 0xACED: code_point = 0x044B; break; // CYRILLIC SMALL LETTER YERU
    case 0xACEE: code_point = 0x044C; break; // CYRILLIC SMALL LETTER SOFT SIGN
    case 0xACEF: code_point = 0x044D; break; // CYRILLIC SMALL LETTER E
    case 0xACF0: code_point = 0x044E; break; // CYRILLIC SMALL LETTER YU
    case 0xACF1: code_point = 0x044F; break; // CYRILLIC SMALL LETTER YA
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xAD(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xAD41: code_point = 0xCD61; break; // HANGUL SYLLABLE CHIEUCH OE NIEUNCIEUC
    case 0xAD42: code_point = 0xCD62; break; // HANGUL SYLLABLE CHIEUCH OE NIEUNHIEUH
    case 0xAD43: code_point = 0xCD63; break; // HANGUL SYLLABLE CHIEUCH OE TIKEUT
    case 0xAD44: code_point = 0xCD65; break; // HANGUL SYLLABLE CHIEUCH OE RIEULKIYEOK
    case 0xAD45: code_point = 0xCD66; break; // HANGUL SYLLABLE CHIEUCH OE RIEULMIEUM
    case 0xAD46: code_point = 0xCD67; break; // HANGUL SYLLABLE CHIEUCH OE RIEULPIEUP
    case 0xAD47: code_point = 0xCD68; break; // HANGUL SYLLABLE CHIEUCH OE RIEULSIOS
    case 0xAD48: code_point = 0xCD69; break; // HANGUL SYLLABLE CHIEUCH OE RIEULTHIEUTH
    case 0xAD49: code_point = 0xCD6A; break; // HANGUL SYLLABLE CHIEUCH OE RIEULPHIEUPH
    case 0xAD4A: code_point = 0xCD6B; break; // HANGUL SYLLABLE CHIEUCH OE RIEULHIEUH
    case 0xAD4B: code_point = 0xCD6E; break; // HANGUL SYLLABLE CHIEUCH OE PIEUPSIOS
    case 0xAD4C: code_point = 0xCD70; break; // HANGUL SYLLABLE CHIEUCH OE SSANGSIOS
    case 0xAD4D: code_point = 0xCD72; break; // HANGUL SYLLABLE CHIEUCH OE CIEUC
    case 0xAD4E: code_point = 0xCD73; break; // HANGUL SYLLABLE CHIEUCH OE CHIEUCH
    case 0xAD4F: code_point = 0xCD74; break; // HANGUL SYLLABLE CHIEUCH OE KHIEUKH
    case 0xAD50: code_point = 0xCD75; break; // HANGUL SYLLABLE CHIEUCH OE THIEUTH
    case 0xAD51: code_point = 0xCD76; break; // HANGUL SYLLABLE CHIEUCH OE PHIEUPH
    case 0xAD52: code_point = 0xCD77; break; // HANGUL SYLLABLE CHIEUCH OE HIEUH
    case 0xAD53: code_point = 0xCD79; break; // HANGUL SYLLABLE CHIEUCH YO KIYEOK
    case 0xAD54: code_point = 0xCD7A; break; // HANGUL SYLLABLE CHIEUCH YO SSANGKIYEOK
    case 0xAD55: code_point = 0xCD7B; break; // HANGUL SYLLABLE CHIEUCH YO KIYEOKSIOS
    case 0xAD56: code_point = 0xCD7C; break; // HANGUL SYLLABLE CHIEUCH YO NIEUN
    case 0xAD57: code_point = 0xCD7D; break; // HANGUL SYLLABLE CHIEUCH YO NIEUNCIEUC
    case 0xAD58: code_point = 0xCD7E; break; // HANGUL SYLLABLE CHIEUCH YO NIEUNHIEUH
    case 0xAD59: code_point = 0xCD7F; break; // HANGUL SYLLABLE CHIEUCH YO TIKEUT
    case 0xAD5A: code_point = 0xCD80; break; // HANGUL SYLLABLE CHIEUCH YO RIEUL
    case 0xAD61: code_point = 0xCD81; break; // HANGUL SYLLABLE CHIEUCH YO RIEULKIYEOK
    case 0xAD62: code_point = 0xCD82; break; // HANGUL SYLLABLE CHIEUCH YO RIEULMIEUM
    case 0xAD63: code_point = 0xCD83; break; // HANGUL SYLLABLE CHIEUCH YO RIEULPIEUP
    case 0xAD64: code_point = 0xCD84; break; // HANGUL SYLLABLE CHIEUCH YO RIEULSIOS
    case 0xAD65: code_point = 0xCD85; break; // HANGUL SYLLABLE CHIEUCH YO RIEULTHIEUTH
    case 0xAD66: code_point = 0xCD86; break; // HANGUL SYLLABLE CHIEUCH YO RIEULPHIEUPH
    case 0xAD67: code_point = 0xCD87; break; // HANGUL SYLLABLE CHIEUCH YO RIEULHIEUH
    case 0xAD68: code_point = 0xCD89; break; // HANGUL SYLLABLE CHIEUCH YO PIEUP
    case 0xAD69: code_point = 0xCD8A; break; // HANGUL SYLLABLE CHIEUCH YO PIEUPSIOS
    case 0xAD6A: code_point = 0xCD8B; break; // HANGUL SYLLABLE CHIEUCH YO SIOS
    case 0xAD6B: code_point = 0xCD8C; break; // HANGUL SYLLABLE CHIEUCH YO SSANGSIOS
    case 0xAD6C: code_point = 0xCD8D; break; // HANGUL SYLLABLE CHIEUCH YO IEUNG
    case 0xAD6D: code_point = 0xCD8E; break; // HANGUL SYLLABLE CHIEUCH YO CIEUC
    case 0xAD6E: code_point = 0xCD8F; break; // HANGUL SYLLABLE CHIEUCH YO CHIEUCH
    case 0xAD6F: code_point = 0xCD90; break; // HANGUL SYLLABLE CHIEUCH YO KHIEUKH
    case 0xAD70: code_point = 0xCD91; break; // HANGUL SYLLABLE CHIEUCH YO THIEUTH
    case 0xAD71: code_point = 0xCD92; break; // HANGUL SYLLABLE CHIEUCH YO PHIEUPH
    case 0xAD72: code_point = 0xCD93; break; // HANGUL SYLLABLE CHIEUCH YO HIEUH
    case 0xAD73: code_point = 0xCD96; break; // HANGUL SYLLABLE CHIEUCH U SSANGKIYEOK
    case 0xAD74: code_point = 0xCD97; break; // HANGUL SYLLABLE CHIEUCH U KIYEOKSIOS
    case 0xAD75: code_point = 0xCD99; break; // HANGUL SYLLABLE CHIEUCH U NIEUNCIEUC
    case 0xAD76: code_point = 0xCD9A; break; // HANGUL SYLLABLE CHIEUCH U NIEUNHIEUH
    case 0xAD77: code_point = 0xCD9B; break; // HANGUL SYLLABLE CHIEUCH U TIKEUT
    case 0xAD78: code_point = 0xCD9D; break; // HANGUL SYLLABLE CHIEUCH U RIEULKIYEOK
    case 0xAD79: code_point = 0xCD9E; break; // HANGUL SYLLABLE CHIEUCH U RIEULMIEUM
    case 0xAD7A: code_point = 0xCD9F; break; // HANGUL SYLLABLE CHIEUCH U RIEULPIEUP
    case 0xAD81: code_point = 0xCDA0; break; // HANGUL SYLLABLE CHIEUCH U RIEULSIOS
    case 0xAD82: code_point = 0xCDA1; break; // HANGUL SYLLABLE CHIEUCH U RIEULTHIEUTH
    case 0xAD83: code_point = 0xCDA2; break; // HANGUL SYLLABLE CHIEUCH U RIEULPHIEUPH
    case 0xAD84: code_point = 0xCDA3; break; // HANGUL SYLLABLE CHIEUCH U RIEULHIEUH
    case 0xAD85: code_point = 0xCDA6; break; // HANGUL SYLLABLE CHIEUCH U PIEUPSIOS
    case 0xAD86: code_point = 0xCDA8; break; // HANGUL SYLLABLE CHIEUCH U SSANGSIOS
    case 0xAD87: code_point = 0xCDAA; break; // HANGUL SYLLABLE CHIEUCH U CIEUC
    case 0xAD88: code_point = 0xCDAB; break; // HANGUL SYLLABLE CHIEUCH U CHIEUCH
    case 0xAD89: code_point = 0xCDAC; break; // HANGUL SYLLABLE CHIEUCH U KHIEUKH
    case 0xAD8A: code_point = 0xCDAD; break; // HANGUL SYLLABLE CHIEUCH U THIEUTH
    case 0xAD8B: code_point = 0xCDAE; break; // HANGUL SYLLABLE CHIEUCH U PHIEUPH
    case 0xAD8C: code_point = 0xCDAF; break; // HANGUL SYLLABLE CHIEUCH U HIEUH
    case 0xAD8D: code_point = 0xCDB1; break; // HANGUL SYLLABLE CHIEUCH WEO KIYEOK
    case 0xAD8E: code_point = 0xCDB2; break; // HANGUL SYLLABLE CHIEUCH WEO SSANGKIYEOK
    case 0xAD8F: code_point = 0xCDB3; break; // HANGUL SYLLABLE CHIEUCH WEO KIYEOKSIOS
    case 0xAD90: code_point = 0xCDB4; break; // HANGUL SYLLABLE CHIEUCH WEO NIEUN
    case 0xAD91: code_point = 0xCDB5; break; // HANGUL SYLLABLE CHIEUCH WEO NIEUNCIEUC
    case 0xAD92: code_point = 0xCDB6; break; // HANGUL SYLLABLE CHIEUCH WEO NIEUNHIEUH
    case 0xAD93: code_point = 0xCDB7; break; // HANGUL SYLLABLE CHIEUCH WEO TIKEUT
    case 0xAD94: code_point = 0xCDB8; break; // HANGUL SYLLABLE CHIEUCH WEO RIEUL
    case 0xAD95: code_point = 0xCDB9; break; // HANGUL SYLLABLE CHIEUCH WEO RIEULKIYEOK
    case 0xAD96: code_point = 0xCDBA; break; // HANGUL SYLLABLE CHIEUCH WEO RIEULMIEUM
    case 0xAD97: code_point = 0xCDBB; break; // HANGUL SYLLABLE CHIEUCH WEO RIEULPIEUP
    case 0xAD98: code_point = 0xCDBC; break; // HANGUL SYLLABLE CHIEUCH WEO RIEULSIOS
    case 0xAD99: code_point = 0xCDBD; break; // HANGUL SYLLABLE CHIEUCH WEO RIEULTHIEUTH
    case 0xAD9A: code_point = 0xCDBE; break; // HANGUL SYLLABLE CHIEUCH WEO RIEULPHIEUPH
    case 0xAD9B: code_point = 0xCDBF; break; // HANGUL SYLLABLE CHIEUCH WEO RIEULHIEUH
    case 0xAD9C: code_point = 0xCDC0; break; // HANGUL SYLLABLE CHIEUCH WEO MIEUM
    case 0xAD9D: code_point = 0xCDC1; break; // HANGUL SYLLABLE CHIEUCH WEO PIEUP
    case 0xAD9E: code_point = 0xCDC2; break; // HANGUL SYLLABLE CHIEUCH WEO PIEUPSIOS
    case 0xAD9F: code_point = 0xCDC3; break; // HANGUL SYLLABLE CHIEUCH WEO SIOS
    case 0xADA0: code_point = 0xCDC5; break; // HANGUL SYLLABLE CHIEUCH WEO IEUNG
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xAE(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xAE41: code_point = 0xCDC6; break; // HANGUL SYLLABLE CHIEUCH WEO CIEUC
    case 0xAE42: code_point = 0xCDC7; break; // HANGUL SYLLABLE CHIEUCH WEO CHIEUCH
    case 0xAE43: code_point = 0xCDC8; break; // HANGUL SYLLABLE CHIEUCH WEO KHIEUKH
    case 0xAE44: code_point = 0xCDC9; break; // HANGUL SYLLABLE CHIEUCH WEO THIEUTH
    case 0xAE45: code_point = 0xCDCA; break; // HANGUL SYLLABLE CHIEUCH WEO PHIEUPH
    case 0xAE46: code_point = 0xCDCB; break; // HANGUL SYLLABLE CHIEUCH WEO HIEUH
    case 0xAE47: code_point = 0xCDCD; break; // HANGUL SYLLABLE CHIEUCH WE KIYEOK
    case 0xAE48: code_point = 0xCDCE; break; // HANGUL SYLLABLE CHIEUCH WE SSANGKIYEOK
    case 0xAE49: code_point = 0xCDCF; break; // HANGUL SYLLABLE CHIEUCH WE KIYEOKSIOS
    case 0xAE4A: code_point = 0xCDD1; break; // HANGUL SYLLABLE CHIEUCH WE NIEUNCIEUC
    case 0xAE4B: code_point = 0xCDD2; break; // HANGUL SYLLABLE CHIEUCH WE NIEUNHIEUH
    case 0xAE4C: code_point = 0xCDD3; break; // HANGUL SYLLABLE CHIEUCH WE TIKEUT
    case 0xAE4D: code_point = 0xCDD4; break; // HANGUL SYLLABLE CHIEUCH WE RIEUL
    case 0xAE4E: code_point = 0xCDD5; break; // HANGUL SYLLABLE CHIEUCH WE RIEULKIYEOK
    case 0xAE4F: code_point = 0xCDD6; break; // HANGUL SYLLABLE CHIEUCH WE RIEULMIEUM
    case 0xAE50: code_point = 0xCDD7; break; // HANGUL SYLLABLE CHIEUCH WE RIEULPIEUP
    case 0xAE51: code_point = 0xCDD8; break; // HANGUL SYLLABLE CHIEUCH WE RIEULSIOS
    case 0xAE52: code_point = 0xCDD9; break; // HANGUL SYLLABLE CHIEUCH WE RIEULTHIEUTH
    case 0xAE53: code_point = 0xCDDA; break; // HANGUL SYLLABLE CHIEUCH WE RIEULPHIEUPH
    case 0xAE54: code_point = 0xCDDB; break; // HANGUL SYLLABLE CHIEUCH WE RIEULHIEUH
    case 0xAE55: code_point = 0xCDDC; break; // HANGUL SYLLABLE CHIEUCH WE MIEUM
    case 0xAE56: code_point = 0xCDDD; break; // HANGUL SYLLABLE CHIEUCH WE PIEUP
    case 0xAE57: code_point = 0xCDDE; break; // HANGUL SYLLABLE CHIEUCH WE PIEUPSIOS
    case 0xAE58: code_point = 0xCDDF; break; // HANGUL SYLLABLE CHIEUCH WE SIOS
    case 0xAE59: code_point = 0xCDE0; break; // HANGUL SYLLABLE CHIEUCH WE SSANGSIOS
    case 0xAE5A: code_point = 0xCDE1; break; // HANGUL SYLLABLE CHIEUCH WE IEUNG
    case 0xAE61: code_point = 0xCDE2; break; // HANGUL SYLLABLE CHIEUCH WE CIEUC
    case 0xAE62: code_point = 0xCDE3; break; // HANGUL SYLLABLE CHIEUCH WE CHIEUCH
    case 0xAE63: code_point = 0xCDE4; break; // HANGUL SYLLABLE CHIEUCH WE KHIEUKH
    case 0xAE64: code_point = 0xCDE5; break; // HANGUL SYLLABLE CHIEUCH WE THIEUTH
    case 0xAE65: code_point = 0xCDE6; break; // HANGUL SYLLABLE CHIEUCH WE PHIEUPH
    case 0xAE66: code_point = 0xCDE7; break; // HANGUL SYLLABLE CHIEUCH WE HIEUH
    case 0xAE67: code_point = 0xCDE9; break; // HANGUL SYLLABLE CHIEUCH WI KIYEOK
    case 0xAE68: code_point = 0xCDEA; break; // HANGUL SYLLABLE CHIEUCH WI SSANGKIYEOK
    case 0xAE69: code_point = 0xCDEB; break; // HANGUL SYLLABLE CHIEUCH WI KIYEOKSIOS
    case 0xAE6A: code_point = 0xCDED; break; // HANGUL SYLLABLE CHIEUCH WI NIEUNCIEUC
    case 0xAE6B: code_point = 0xCDEE; break; // HANGUL SYLLABLE CHIEUCH WI NIEUNHIEUH
    case 0xAE6C: code_point = 0xCDEF; break; // HANGUL SYLLABLE CHIEUCH WI TIKEUT
    case 0xAE6D: code_point = 0xCDF1; break; // HANGUL SYLLABLE CHIEUCH WI RIEULKIYEOK
    case 0xAE6E: code_point = 0xCDF2; break; // HANGUL SYLLABLE CHIEUCH WI RIEULMIEUM
    case 0xAE6F: code_point = 0xCDF3; break; // HANGUL SYLLABLE CHIEUCH WI RIEULPIEUP
    case 0xAE70: code_point = 0xCDF4; break; // HANGUL SYLLABLE CHIEUCH WI RIEULSIOS
    case 0xAE71: code_point = 0xCDF5; break; // HANGUL SYLLABLE CHIEUCH WI RIEULTHIEUTH
    case 0xAE72: code_point = 0xCDF6; break; // HANGUL SYLLABLE CHIEUCH WI RIEULPHIEUPH
    case 0xAE73: code_point = 0xCDF7; break; // HANGUL SYLLABLE CHIEUCH WI RIEULHIEUH
    case 0xAE74: code_point = 0xCDFA; break; // HANGUL SYLLABLE CHIEUCH WI PIEUPSIOS
    case 0xAE75: code_point = 0xCDFC; break; // HANGUL SYLLABLE CHIEUCH WI SSANGSIOS
    case 0xAE76: code_point = 0xCDFE; break; // HANGUL SYLLABLE CHIEUCH WI CIEUC
    case 0xAE77: code_point = 0xCDFF; break; // HANGUL SYLLABLE CHIEUCH WI CHIEUCH
    case 0xAE78: code_point = 0xCE00; break; // HANGUL SYLLABLE CHIEUCH WI KHIEUKH
    case 0xAE79: code_point = 0xCE01; break; // HANGUL SYLLABLE CHIEUCH WI THIEUTH
    case 0xAE7A: code_point = 0xCE02; break; // HANGUL SYLLABLE CHIEUCH WI PHIEUPH
    case 0xAE81: code_point = 0xCE03; break; // HANGUL SYLLABLE CHIEUCH WI HIEUH
    case 0xAE82: code_point = 0xCE05; break; // HANGUL SYLLABLE CHIEUCH YU KIYEOK
    case 0xAE83: code_point = 0xCE06; break; // HANGUL SYLLABLE CHIEUCH YU SSANGKIYEOK
    case 0xAE84: code_point = 0xCE07; break; // HANGUL SYLLABLE CHIEUCH YU KIYEOKSIOS
    case 0xAE85: code_point = 0xCE09; break; // HANGUL SYLLABLE CHIEUCH YU NIEUNCIEUC
    case 0xAE86: code_point = 0xCE0A; break; // HANGUL SYLLABLE CHIEUCH YU NIEUNHIEUH
    case 0xAE87: code_point = 0xCE0B; break; // HANGUL SYLLABLE CHIEUCH YU TIKEUT
    case 0xAE88: code_point = 0xCE0D; break; // HANGUL SYLLABLE CHIEUCH YU RIEULKIYEOK
    case 0xAE89: code_point = 0xCE0E; break; // HANGUL SYLLABLE CHIEUCH YU RIEULMIEUM
    case 0xAE8A: code_point = 0xCE0F; break; // HANGUL SYLLABLE CHIEUCH YU RIEULPIEUP
    case 0xAE8B: code_point = 0xCE10; break; // HANGUL SYLLABLE CHIEUCH YU RIEULSIOS
    case 0xAE8C: code_point = 0xCE11; break; // HANGUL SYLLABLE CHIEUCH YU RIEULTHIEUTH
    case 0xAE8D: code_point = 0xCE12; break; // HANGUL SYLLABLE CHIEUCH YU RIEULPHIEUPH
    case 0xAE8E: code_point = 0xCE13; break; // HANGUL SYLLABLE CHIEUCH YU RIEULHIEUH
    case 0xAE8F: code_point = 0xCE15; break; // HANGUL SYLLABLE CHIEUCH YU PIEUP
    case 0xAE90: code_point = 0xCE16; break; // HANGUL SYLLABLE CHIEUCH YU PIEUPSIOS
    case 0xAE91: code_point = 0xCE17; break; // HANGUL SYLLABLE CHIEUCH YU SIOS
    case 0xAE92: code_point = 0xCE18; break; // HANGUL SYLLABLE CHIEUCH YU SSANGSIOS
    case 0xAE93: code_point = 0xCE1A; break; // HANGUL SYLLABLE CHIEUCH YU CIEUC
    case 0xAE94: code_point = 0xCE1B; break; // HANGUL SYLLABLE CHIEUCH YU CHIEUCH
    case 0xAE95: code_point = 0xCE1C; break; // HANGUL SYLLABLE CHIEUCH YU KHIEUKH
    case 0xAE96: code_point = 0xCE1D; break; // HANGUL SYLLABLE CHIEUCH YU THIEUTH
    case 0xAE97: code_point = 0xCE1E; break; // HANGUL SYLLABLE CHIEUCH YU PHIEUPH
    case 0xAE98: code_point = 0xCE1F; break; // HANGUL SYLLABLE CHIEUCH YU HIEUH
    case 0xAE99: code_point = 0xCE22; break; // HANGUL SYLLABLE CHIEUCH EU SSANGKIYEOK
    case 0xAE9A: code_point = 0xCE23; break; // HANGUL SYLLABLE CHIEUCH EU KIYEOKSIOS
    case 0xAE9B: code_point = 0xCE25; break; // HANGUL SYLLABLE CHIEUCH EU NIEUNCIEUC
    case 0xAE9C: code_point = 0xCE26; break; // HANGUL SYLLABLE CHIEUCH EU NIEUNHIEUH
    case 0xAE9D: code_point = 0xCE27; break; // HANGUL SYLLABLE CHIEUCH EU TIKEUT
    case 0xAE9E: code_point = 0xCE29; break; // HANGUL SYLLABLE CHIEUCH EU RIEULKIYEOK
    case 0xAE9F: code_point = 0xCE2A; break; // HANGUL SYLLABLE CHIEUCH EU RIEULMIEUM
    case 0xAEA0: code_point = 0xCE2B; break; // HANGUL SYLLABLE CHIEUCH EU RIEULPIEUP
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xAF(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xAF41: code_point = 0xCE2C; break; // HANGUL SYLLABLE CHIEUCH EU RIEULSIOS
    case 0xAF42: code_point = 0xCE2D; break; // HANGUL SYLLABLE CHIEUCH EU RIEULTHIEUTH
    case 0xAF43: code_point = 0xCE2E; break; // HANGUL SYLLABLE CHIEUCH EU RIEULPHIEUPH
    case 0xAF44: code_point = 0xCE2F; break; // HANGUL SYLLABLE CHIEUCH EU RIEULHIEUH
    case 0xAF45: code_point = 0xCE32; break; // HANGUL SYLLABLE CHIEUCH EU PIEUPSIOS
    case 0xAF46: code_point = 0xCE34; break; // HANGUL SYLLABLE CHIEUCH EU SSANGSIOS
    case 0xAF47: code_point = 0xCE36; break; // HANGUL SYLLABLE CHIEUCH EU CIEUC
    case 0xAF48: code_point = 0xCE37; break; // HANGUL SYLLABLE CHIEUCH EU CHIEUCH
    case 0xAF49: code_point = 0xCE38; break; // HANGUL SYLLABLE CHIEUCH EU KHIEUKH
    case 0xAF4A: code_point = 0xCE39; break; // HANGUL SYLLABLE CHIEUCH EU THIEUTH
    case 0xAF4B: code_point = 0xCE3A; break; // HANGUL SYLLABLE CHIEUCH EU PHIEUPH
    case 0xAF4C: code_point = 0xCE3B; break; // HANGUL SYLLABLE CHIEUCH EU HIEUH
    case 0xAF4D: code_point = 0xCE3C; break; // HANGUL SYLLABLE CHIEUCH YI
    case 0xAF4E: code_point = 0xCE3D; break; // HANGUL SYLLABLE CHIEUCH YI KIYEOK
    case 0xAF4F: code_point = 0xCE3E; break; // HANGUL SYLLABLE CHIEUCH YI SSANGKIYEOK
    case 0xAF50: code_point = 0xCE3F; break; // HANGUL SYLLABLE CHIEUCH YI KIYEOKSIOS
    case 0xAF51: code_point = 0xCE40; break; // HANGUL SYLLABLE CHIEUCH YI NIEUN
    case 0xAF52: code_point = 0xCE41; break; // HANGUL SYLLABLE CHIEUCH YI NIEUNCIEUC
    case 0xAF53: code_point = 0xCE42; break; // HANGUL SYLLABLE CHIEUCH YI NIEUNHIEUH
    case 0xAF54: code_point = 0xCE43; break; // HANGUL SYLLABLE CHIEUCH YI TIKEUT
    case 0xAF55: code_point = 0xCE44; break; // HANGUL SYLLABLE CHIEUCH YI RIEUL
    case 0xAF56: code_point = 0xCE45; break; // HANGUL SYLLABLE CHIEUCH YI RIEULKIYEOK
    case 0xAF57: code_point = 0xCE46; break; // HANGUL SYLLABLE CHIEUCH YI RIEULMIEUM
    case 0xAF58: code_point = 0xCE47; break; // HANGUL SYLLABLE CHIEUCH YI RIEULPIEUP
    case 0xAF59: code_point = 0xCE48; break; // HANGUL SYLLABLE CHIEUCH YI RIEULSIOS
    case 0xAF5A: code_point = 0xCE49; break; // HANGUL SYLLABLE CHIEUCH YI RIEULTHIEUTH
    case 0xAF61: code_point = 0xCE4A; break; // HANGUL SYLLABLE CHIEUCH YI RIEULPHIEUPH
    case 0xAF62: code_point = 0xCE4B; break; // HANGUL SYLLABLE CHIEUCH YI RIEULHIEUH
    case 0xAF63: code_point = 0xCE4C; break; // HANGUL SYLLABLE CHIEUCH YI MIEUM
    case 0xAF64: code_point = 0xCE4D; break; // HANGUL SYLLABLE CHIEUCH YI PIEUP
    case 0xAF65: code_point = 0xCE4E; break; // HANGUL SYLLABLE CHIEUCH YI PIEUPSIOS
    case 0xAF66: code_point = 0xCE4F; break; // HANGUL SYLLABLE CHIEUCH YI SIOS
    case 0xAF67: code_point = 0xCE50; break; // HANGUL SYLLABLE CHIEUCH YI SSANGSIOS
    case 0xAF68: code_point = 0xCE51; break; // HANGUL SYLLABLE CHIEUCH YI IEUNG
    case 0xAF69: code_point = 0xCE52; break; // HANGUL SYLLABLE CHIEUCH YI CIEUC
    case 0xAF6A: code_point = 0xCE53; break; // HANGUL SYLLABLE CHIEUCH YI CHIEUCH
    case 0xAF6B: code_point = 0xCE54; break; // HANGUL SYLLABLE CHIEUCH YI KHIEUKH
    case 0xAF6C: code_point = 0xCE55; break; // HANGUL SYLLABLE CHIEUCH YI THIEUTH
    case 0xAF6D: code_point = 0xCE56; break; // HANGUL SYLLABLE CHIEUCH YI PHIEUPH
    case 0xAF6E: code_point = 0xCE57; break; // HANGUL SYLLABLE CHIEUCH YI HIEUH
    case 0xAF6F: code_point = 0xCE5A; break; // HANGUL SYLLABLE CHIEUCH I SSANGKIYEOK
    case 0xAF70: code_point = 0xCE5B; break; // HANGUL SYLLABLE CHIEUCH I KIYEOKSIOS
    case 0xAF71: code_point = 0xCE5D; break; // HANGUL SYLLABLE CHIEUCH I NIEUNCIEUC
    case 0xAF72: code_point = 0xCE5E; break; // HANGUL SYLLABLE CHIEUCH I NIEUNHIEUH
    case 0xAF73: code_point = 0xCE62; break; // HANGUL SYLLABLE CHIEUCH I RIEULMIEUM
    case 0xAF74: code_point = 0xCE63; break; // HANGUL SYLLABLE CHIEUCH I RIEULPIEUP
    case 0xAF75: code_point = 0xCE64; break; // HANGUL SYLLABLE CHIEUCH I RIEULSIOS
    case 0xAF76: code_point = 0xCE65; break; // HANGUL SYLLABLE CHIEUCH I RIEULTHIEUTH
    case 0xAF77: code_point = 0xCE66; break; // HANGUL SYLLABLE CHIEUCH I RIEULPHIEUPH
    case 0xAF78: code_point = 0xCE67; break; // HANGUL SYLLABLE CHIEUCH I RIEULHIEUH
    case 0xAF79: code_point = 0xCE6A; break; // HANGUL SYLLABLE CHIEUCH I PIEUPSIOS
    case 0xAF7A: code_point = 0xCE6C; break; // HANGUL SYLLABLE CHIEUCH I SSANGSIOS
    case 0xAF81: code_point = 0xCE6E; break; // HANGUL SYLLABLE CHIEUCH I CIEUC
    case 0xAF82: code_point = 0xCE6F; break; // HANGUL SYLLABLE CHIEUCH I CHIEUCH
    case 0xAF83: code_point = 0xCE70; break; // HANGUL SYLLABLE CHIEUCH I KHIEUKH
    case 0xAF84: code_point = 0xCE71; break; // HANGUL SYLLABLE CHIEUCH I THIEUTH
    case 0xAF85: code_point = 0xCE72; break; // HANGUL SYLLABLE CHIEUCH I PHIEUPH
    case 0xAF86: code_point = 0xCE73; break; // HANGUL SYLLABLE CHIEUCH I HIEUH
    case 0xAF87: code_point = 0xCE76; break; // HANGUL SYLLABLE KHIEUKH A SSANGKIYEOK
    case 0xAF88: code_point = 0xCE77; break; // HANGUL SYLLABLE KHIEUKH A KIYEOKSIOS
    case 0xAF89: code_point = 0xCE79; break; // HANGUL SYLLABLE KHIEUKH A NIEUNCIEUC
    case 0xAF8A: code_point = 0xCE7A; break; // HANGUL SYLLABLE KHIEUKH A NIEUNHIEUH
    case 0xAF8B: code_point = 0xCE7B; break; // HANGUL SYLLABLE KHIEUKH A TIKEUT
    case 0xAF8C: code_point = 0xCE7D; break; // HANGUL SYLLABLE KHIEUKH A RIEULKIYEOK
    case 0xAF8D: code_point = 0xCE7E; break; // HANGUL SYLLABLE KHIEUKH A RIEULMIEUM
    case 0xAF8E: code_point = 0xCE7F; break; // HANGUL SYLLABLE KHIEUKH A RIEULPIEUP
    case 0xAF8F: code_point = 0xCE80; break; // HANGUL SYLLABLE KHIEUKH A RIEULSIOS
    case 0xAF90: code_point = 0xCE81; break; // HANGUL SYLLABLE KHIEUKH A RIEULTHIEUTH
    case 0xAF91: code_point = 0xCE82; break; // HANGUL SYLLABLE KHIEUKH A RIEULPHIEUPH
    case 0xAF92: code_point = 0xCE83; break; // HANGUL SYLLABLE KHIEUKH A RIEULHIEUH
    case 0xAF93: code_point = 0xCE86; break; // HANGUL SYLLABLE KHIEUKH A PIEUPSIOS
    case 0xAF94: code_point = 0xCE88; break; // HANGUL SYLLABLE KHIEUKH A SSANGSIOS
    case 0xAF95: code_point = 0xCE8A; break; // HANGUL SYLLABLE KHIEUKH A CIEUC
    case 0xAF96: code_point = 0xCE8B; break; // HANGUL SYLLABLE KHIEUKH A CHIEUCH
    case 0xAF97: code_point = 0xCE8C; break; // HANGUL SYLLABLE KHIEUKH A KHIEUKH
    case 0xAF98: code_point = 0xCE8D; break; // HANGUL SYLLABLE KHIEUKH A THIEUTH
    case 0xAF99: code_point = 0xCE8E; break; // HANGUL SYLLABLE KHIEUKH A PHIEUPH
    case 0xAF9A: code_point = 0xCE8F; break; // HANGUL SYLLABLE KHIEUKH A HIEUH
    case 0xAF9B: code_point = 0xCE92; break; // HANGUL SYLLABLE KHIEUKH AE SSANGKIYEOK
    case 0xAF9C: code_point = 0xCE93; break; // HANGUL SYLLABLE KHIEUKH AE KIYEOKSIOS
    case 0xAF9D: code_point = 0xCE95; break; // HANGUL SYLLABLE KHIEUKH AE NIEUNCIEUC
    case 0xAF9E: code_point = 0xCE96; break; // HANGUL SYLLABLE KHIEUKH AE NIEUNHIEUH
    case 0xAF9F: code_point = 0xCE97; break; // HANGUL SYLLABLE KHIEUKH AE TIKEUT
    case 0xAFA0: code_point = 0xCE99; break; // HANGUL SYLLABLE KHIEUKH AE RIEULKIYEOK
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB0(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB041: code_point = 0xCE9A; break; // HANGUL SYLLABLE KHIEUKH AE RIEULMIEUM
    case 0xB042: code_point = 0xCE9B; break; // HANGUL SYLLABLE KHIEUKH AE RIEULPIEUP
    case 0xB043: code_point = 0xCE9C; break; // HANGUL SYLLABLE KHIEUKH AE RIEULSIOS
    case 0xB044: code_point = 0xCE9D; break; // HANGUL SYLLABLE KHIEUKH AE RIEULTHIEUTH
    case 0xB045: code_point = 0xCE9E; break; // HANGUL SYLLABLE KHIEUKH AE RIEULPHIEUPH
    case 0xB046: code_point = 0xCE9F; break; // HANGUL SYLLABLE KHIEUKH AE RIEULHIEUH
    case 0xB047: code_point = 0xCEA2; break; // HANGUL SYLLABLE KHIEUKH AE PIEUPSIOS
    case 0xB048: code_point = 0xCEA6; break; // HANGUL SYLLABLE KHIEUKH AE CIEUC
    case 0xB049: code_point = 0xCEA7; break; // HANGUL SYLLABLE KHIEUKH AE CHIEUCH
    case 0xB04A: code_point = 0xCEA8; break; // HANGUL SYLLABLE KHIEUKH AE KHIEUKH
    case 0xB04B: code_point = 0xCEA9; break; // HANGUL SYLLABLE KHIEUKH AE THIEUTH
    case 0xB04C: code_point = 0xCEAA; break; // HANGUL SYLLABLE KHIEUKH AE PHIEUPH
    case 0xB04D: code_point = 0xCEAB; break; // HANGUL SYLLABLE KHIEUKH AE HIEUH
    case 0xB04E: code_point = 0xCEAE; break; // HANGUL SYLLABLE KHIEUKH YA SSANGKIYEOK
    case 0xB04F: code_point = 0xCEAF; break; // HANGUL SYLLABLE KHIEUKH YA KIYEOKSIOS
    case 0xB050: code_point = 0xCEB0; break; // HANGUL SYLLABLE KHIEUKH YA NIEUN
    case 0xB051: code_point = 0xCEB1; break; // HANGUL SYLLABLE KHIEUKH YA NIEUNCIEUC
    case 0xB052: code_point = 0xCEB2; break; // HANGUL SYLLABLE KHIEUKH YA NIEUNHIEUH
    case 0xB053: code_point = 0xCEB3; break; // HANGUL SYLLABLE KHIEUKH YA TIKEUT
    case 0xB054: code_point = 0xCEB4; break; // HANGUL SYLLABLE KHIEUKH YA RIEUL
    case 0xB055: code_point = 0xCEB5; break; // HANGUL SYLLABLE KHIEUKH YA RIEULKIYEOK
    case 0xB056: code_point = 0xCEB6; break; // HANGUL SYLLABLE KHIEUKH YA RIEULMIEUM
    case 0xB057: code_point = 0xCEB7; break; // HANGUL SYLLABLE KHIEUKH YA RIEULPIEUP
    case 0xB058: code_point = 0xCEB8; break; // HANGUL SYLLABLE KHIEUKH YA RIEULSIOS
    case 0xB059: code_point = 0xCEB9; break; // HANGUL SYLLABLE KHIEUKH YA RIEULTHIEUTH
    case 0xB05A: code_point = 0xCEBA; break; // HANGUL SYLLABLE KHIEUKH YA RIEULPHIEUPH
    case 0xB061: code_point = 0xCEBB; break; // HANGUL SYLLABLE KHIEUKH YA RIEULHIEUH
    case 0xB062: code_point = 0xCEBC; break; // HANGUL SYLLABLE KHIEUKH YA MIEUM
    case 0xB063: code_point = 0xCEBD; break; // HANGUL SYLLABLE KHIEUKH YA PIEUP
    case 0xB064: code_point = 0xCEBE; break; // HANGUL SYLLABLE KHIEUKH YA PIEUPSIOS
    case 0xB065: code_point = 0xCEBF; break; // HANGUL SYLLABLE KHIEUKH YA SIOS
    case 0xB066: code_point = 0xCEC0; break; // HANGUL SYLLABLE KHIEUKH YA SSANGSIOS
    case 0xB067: code_point = 0xCEC2; break; // HANGUL SYLLABLE KHIEUKH YA CIEUC
    case 0xB068: code_point = 0xCEC3; break; // HANGUL SYLLABLE KHIEUKH YA CHIEUCH
    case 0xB069: code_point = 0xCEC4; break; // HANGUL SYLLABLE KHIEUKH YA KHIEUKH
    case 0xB06A: code_point = 0xCEC5; break; // HANGUL SYLLABLE KHIEUKH YA THIEUTH
    case 0xB06B: code_point = 0xCEC6; break; // HANGUL SYLLABLE KHIEUKH YA PHIEUPH
    case 0xB06C: code_point = 0xCEC7; break; // HANGUL SYLLABLE KHIEUKH YA HIEUH
    case 0xB06D: code_point = 0xCEC8; break; // HANGUL SYLLABLE KHIEUKH YAE
    case 0xB06E: code_point = 0xCEC9; break; // HANGUL SYLLABLE KHIEUKH YAE KIYEOK
    case 0xB06F: code_point = 0xCECA; break; // HANGUL SYLLABLE KHIEUKH YAE SSANGKIYEOK
    case 0xB070: code_point = 0xCECB; break; // HANGUL SYLLABLE KHIEUKH YAE KIYEOKSIOS
    case 0xB071: code_point = 0xCECC; break; // HANGUL SYLLABLE KHIEUKH YAE NIEUN
    case 0xB072: code_point = 0xCECD; break; // HANGUL SYLLABLE KHIEUKH YAE NIEUNCIEUC
    case 0xB073: code_point = 0xCECE; break; // HANGUL SYLLABLE KHIEUKH YAE NIEUNHIEUH
    case 0xB074: code_point = 0xCECF; break; // HANGUL SYLLABLE KHIEUKH YAE TIKEUT
    case 0xB075: code_point = 0xCED0; break; // HANGUL SYLLABLE KHIEUKH YAE RIEUL
    case 0xB076: code_point = 0xCED1; break; // HANGUL SYLLABLE KHIEUKH YAE RIEULKIYEOK
    case 0xB077: code_point = 0xCED2; break; // HANGUL SYLLABLE KHIEUKH YAE RIEULMIEUM
    case 0xB078: code_point = 0xCED3; break; // HANGUL SYLLABLE KHIEUKH YAE RIEULPIEUP
    case 0xB079: code_point = 0xCED4; break; // HANGUL SYLLABLE KHIEUKH YAE RIEULSIOS
    case 0xB07A: code_point = 0xCED5; break; // HANGUL SYLLABLE KHIEUKH YAE RIEULTHIEUTH
    case 0xB081: code_point = 0xCED6; break; // HANGUL SYLLABLE KHIEUKH YAE RIEULPHIEUPH
    case 0xB082: code_point = 0xCED7; break; // HANGUL SYLLABLE KHIEUKH YAE RIEULHIEUH
    case 0xB083: code_point = 0xCED8; break; // HANGUL SYLLABLE KHIEUKH YAE MIEUM
    case 0xB084: code_point = 0xCED9; break; // HANGUL SYLLABLE KHIEUKH YAE PIEUP
    case 0xB085: code_point = 0xCEDA; break; // HANGUL SYLLABLE KHIEUKH YAE PIEUPSIOS
    case 0xB086: code_point = 0xCEDB; break; // HANGUL SYLLABLE KHIEUKH YAE SIOS
    case 0xB087: code_point = 0xCEDC; break; // HANGUL SYLLABLE KHIEUKH YAE SSANGSIOS
    case 0xB088: code_point = 0xCEDD; break; // HANGUL SYLLABLE KHIEUKH YAE IEUNG
    case 0xB089: code_point = 0xCEDE; break; // HANGUL SYLLABLE KHIEUKH YAE CIEUC
    case 0xB08A: code_point = 0xCEDF; break; // HANGUL SYLLABLE KHIEUKH YAE CHIEUCH
    case 0xB08B: code_point = 0xCEE0; break; // HANGUL SYLLABLE KHIEUKH YAE KHIEUKH
    case 0xB08C: code_point = 0xCEE1; break; // HANGUL SYLLABLE KHIEUKH YAE THIEUTH
    case 0xB08D: code_point = 0xCEE2; break; // HANGUL SYLLABLE KHIEUKH YAE PHIEUPH
    case 0xB08E: code_point = 0xCEE3; break; // HANGUL SYLLABLE KHIEUKH YAE HIEUH
    case 0xB08F: code_point = 0xCEE6; break; // HANGUL SYLLABLE KHIEUKH EO SSANGKIYEOK
    case 0xB090: code_point = 0xCEE7; break; // HANGUL SYLLABLE KHIEUKH EO KIYEOKSIOS
    case 0xB091: code_point = 0xCEE9; break; // HANGUL SYLLABLE KHIEUKH EO NIEUNCIEUC
    case 0xB092: code_point = 0xCEEA; break; // HANGUL SYLLABLE KHIEUKH EO NIEUNHIEUH
    case 0xB093: code_point = 0xCEED; break; // HANGUL SYLLABLE KHIEUKH EO RIEULKIYEOK
    case 0xB094: code_point = 0xCEEE; break; // HANGUL SYLLABLE KHIEUKH EO RIEULMIEUM
    case 0xB095: code_point = 0xCEEF; break; // HANGUL SYLLABLE KHIEUKH EO RIEULPIEUP
    case 0xB096: code_point = 0xCEF0; break; // HANGUL SYLLABLE KHIEUKH EO RIEULSIOS
    case 0xB097: code_point = 0xCEF1; break; // HANGUL SYLLABLE KHIEUKH EO RIEULTHIEUTH
    case 0xB098: code_point = 0xCEF2; break; // HANGUL SYLLABLE KHIEUKH EO RIEULPHIEUPH
    case 0xB099: code_point = 0xCEF3; break; // HANGUL SYLLABLE KHIEUKH EO RIEULHIEUH
    case 0xB09A: code_point = 0xCEF6; break; // HANGUL SYLLABLE KHIEUKH EO PIEUPSIOS
    case 0xB09B: code_point = 0xCEFA; break; // HANGUL SYLLABLE KHIEUKH EO CIEUC
    case 0xB09C: code_point = 0xCEFB; break; // HANGUL SYLLABLE KHIEUKH EO CHIEUCH
    case 0xB09D: code_point = 0xCEFC; break; // HANGUL SYLLABLE KHIEUKH EO KHIEUKH
    case 0xB09E: code_point = 0xCEFD; break; // HANGUL SYLLABLE KHIEUKH EO THIEUTH
    case 0xB09F: code_point = 0xCEFE; break; // HANGUL SYLLABLE KHIEUKH EO PHIEUPH
    case 0xB0A0: code_point = 0xCEFF; break; // HANGUL SYLLABLE KHIEUKH EO HIEUH
    case 0xB0A1: code_point = 0xAC00; break; // HANGUL SYLLABLE KIYEOK A
    case 0xB0A2: code_point = 0xAC01; break; // HANGUL SYLLABLE KIYEOK A KIYEOK
    case 0xB0A3: code_point = 0xAC04; break; // HANGUL SYLLABLE KIYEOK A NIEUN
    case 0xB0A4: code_point = 0xAC07; break; // HANGUL SYLLABLE KIYEOK A TIKEUT
    case 0xB0A5: code_point = 0xAC08; break; // HANGUL SYLLABLE KIYEOK A RIEUL
    case 0xB0A6: code_point = 0xAC09; break; // HANGUL SYLLABLE KIYEOK A RIEULKIYEOK
    case 0xB0A7: code_point = 0xAC0A; break; // HANGUL SYLLABLE KIYEOK A RIEULMIEUM
    case 0xB0A8: code_point = 0xAC10; break; // HANGUL SYLLABLE KIYEOK A MIEUM
    case 0xB0A9: code_point = 0xAC11; break; // HANGUL SYLLABLE KIYEOK A PIEUP
    case 0xB0AA: code_point = 0xAC12; break; // HANGUL SYLLABLE KIYEOK A PIEUPSIOS
    case 0xB0AB: code_point = 0xAC13; break; // HANGUL SYLLABLE KIYEOK A SIOS
    case 0xB0AC: code_point = 0xAC14; break; // HANGUL SYLLABLE KIYEOK A SSANGSIOS
    case 0xB0AD: code_point = 0xAC15; break; // HANGUL SYLLABLE KIYEOK A IEUNG
    case 0xB0AE: code_point = 0xAC16; break; // HANGUL SYLLABLE KIYEOK A CIEUC
    case 0xB0AF: code_point = 0xAC17; break; // HANGUL SYLLABLE KIYEOK A CHIEUCH
    case 0xB0B0: code_point = 0xAC19; break; // HANGUL SYLLABLE KIYEOK A THIEUTH
    case 0xB0B1: code_point = 0xAC1A; break; // HANGUL SYLLABLE KIYEOK A PHIEUPH
    case 0xB0B2: code_point = 0xAC1B; break; // HANGUL SYLLABLE KIYEOK A HIEUH
    case 0xB0B3: code_point = 0xAC1C; break; // HANGUL SYLLABLE KIYEOK AE
    case 0xB0B4: code_point = 0xAC1D; break; // HANGUL SYLLABLE KIYEOK AE KIYEOK
    case 0xB0B5: code_point = 0xAC20; break; // HANGUL SYLLABLE KIYEOK AE NIEUN
    case 0xB0B6: code_point = 0xAC24; break; // HANGUL SYLLABLE KIYEOK AE RIEUL
    case 0xB0B7: code_point = 0xAC2C; break; // HANGUL SYLLABLE KIYEOK AE MIEUM
    case 0xB0B8: code_point = 0xAC2D; break; // HANGUL SYLLABLE KIYEOK AE PIEUP
    case 0xB0B9: code_point = 0xAC2F; break; // HANGUL SYLLABLE KIYEOK AE SIOS
    case 0xB0BA: code_point = 0xAC30; break; // HANGUL SYLLABLE KIYEOK AE SSANGSIOS
    case 0xB0BB: code_point = 0xAC31; break; // HANGUL SYLLABLE KIYEOK AE IEUNG
    case 0xB0BC: code_point = 0xAC38; break; // HANGUL SYLLABLE KIYEOK YA
    case 0xB0BD: code_point = 0xAC39; break; // HANGUL SYLLABLE KIYEOK YA KIYEOK
    case 0xB0BE: code_point = 0xAC3C; break; // HANGUL SYLLABLE KIYEOK YA NIEUN
    case 0xB0BF: code_point = 0xAC40; break; // HANGUL SYLLABLE KIYEOK YA RIEUL
    case 0xB0C0: code_point = 0xAC4B; break; // HANGUL SYLLABLE KIYEOK YA SIOS
    case 0xB0C1: code_point = 0xAC4D; break; // HANGUL SYLLABLE KIYEOK YA IEUNG
    case 0xB0C2: code_point = 0xAC54; break; // HANGUL SYLLABLE KIYEOK YAE
    case 0xB0C3: code_point = 0xAC58; break; // HANGUL SYLLABLE KIYEOK YAE NIEUN
    case 0xB0C4: code_point = 0xAC5C; break; // HANGUL SYLLABLE KIYEOK YAE RIEUL
    case 0xB0C5: code_point = 0xAC70; break; // HANGUL SYLLABLE KIYEOK EO
    case 0xB0C6: code_point = 0xAC71; break; // HANGUL SYLLABLE KIYEOK EO KIYEOK
    case 0xB0C7: code_point = 0xAC74; break; // HANGUL SYLLABLE KIYEOK EO NIEUN
    case 0xB0C8: code_point = 0xAC77; break; // HANGUL SYLLABLE KIYEOK EO TIKEUT
    case 0xB0C9: code_point = 0xAC78; break; // HANGUL SYLLABLE KIYEOK EO RIEUL
    case 0xB0CA: code_point = 0xAC7A; break; // HANGUL SYLLABLE KIYEOK EO RIEULMIEUM
    case 0xB0CB: code_point = 0xAC80; break; // HANGUL SYLLABLE KIYEOK EO MIEUM
    case 0xB0CC: code_point = 0xAC81; break; // HANGUL SYLLABLE KIYEOK EO PIEUP
    case 0xB0CD: code_point = 0xAC83; break; // HANGUL SYLLABLE KIYEOK EO SIOS
    case 0xB0CE: code_point = 0xAC84; break; // HANGUL SYLLABLE KIYEOK EO SSANGSIOS
    case 0xB0CF: code_point = 0xAC85; break; // HANGUL SYLLABLE KIYEOK EO IEUNG
    case 0xB0D0: code_point = 0xAC86; break; // HANGUL SYLLABLE KIYEOK EO CIEUC
    case 0xB0D1: code_point = 0xAC89; break; // HANGUL SYLLABLE KIYEOK EO THIEUTH
    case 0xB0D2: code_point = 0xAC8A; break; // HANGUL SYLLABLE KIYEOK EO PHIEUPH
    case 0xB0D3: code_point = 0xAC8B; break; // HANGUL SYLLABLE KIYEOK EO HIEUH
    case 0xB0D4: code_point = 0xAC8C; break; // HANGUL SYLLABLE KIYEOK E
    case 0xB0D5: code_point = 0xAC90; break; // HANGUL SYLLABLE KIYEOK E NIEUN
    case 0xB0D6: code_point = 0xAC94; break; // HANGUL SYLLABLE KIYEOK E RIEUL
    case 0xB0D7: code_point = 0xAC9C; break; // HANGUL SYLLABLE KIYEOK E MIEUM
    case 0xB0D8: code_point = 0xAC9D; break; // HANGUL SYLLABLE KIYEOK E PIEUP
    case 0xB0D9: code_point = 0xAC9F; break; // HANGUL SYLLABLE KIYEOK E SIOS
    case 0xB0DA: code_point = 0xACA0; break; // HANGUL SYLLABLE KIYEOK E SSANGSIOS
    case 0xB0DB: code_point = 0xACA1; break; // HANGUL SYLLABLE KIYEOK E IEUNG
    case 0xB0DC: code_point = 0xACA8; break; // HANGUL SYLLABLE KIYEOK YEO
    case 0xB0DD: code_point = 0xACA9; break; // HANGUL SYLLABLE KIYEOK YEO KIYEOK
    case 0xB0DE: code_point = 0xACAA; break; // HANGUL SYLLABLE KIYEOK YEO SSANGKIYEOK
    case 0xB0DF: code_point = 0xACAC; break; // HANGUL SYLLABLE KIYEOK YEO NIEUN
    case 0xB0E0: code_point = 0xACAF; break; // HANGUL SYLLABLE KIYEOK YEO TIKEUT
    case 0xB0E1: code_point = 0xACB0; break; // HANGUL SYLLABLE KIYEOK YEO RIEUL
    case 0xB0E2: code_point = 0xACB8; break; // HANGUL SYLLABLE KIYEOK YEO MIEUM
    case 0xB0E3: code_point = 0xACB9; break; // HANGUL SYLLABLE KIYEOK YEO PIEUP
    case 0xB0E4: code_point = 0xACBB; break; // HANGUL SYLLABLE KIYEOK YEO SIOS
    case 0xB0E5: code_point = 0xACBC; break; // HANGUL SYLLABLE KIYEOK YEO SSANGSIOS
    case 0xB0E6: code_point = 0xACBD; break; // HANGUL SYLLABLE KIYEOK YEO IEUNG
    case 0xB0E7: code_point = 0xACC1; break; // HANGUL SYLLABLE KIYEOK YEO THIEUTH
    case 0xB0E8: code_point = 0xACC4; break; // HANGUL SYLLABLE KIYEOK YE
    case 0xB0E9: code_point = 0xACC8; break; // HANGUL SYLLABLE KIYEOK YE NIEUN
    case 0xB0EA: code_point = 0xACCC; break; // HANGUL SYLLABLE KIYEOK YE RIEUL
    case 0xB0EB: code_point = 0xACD5; break; // HANGUL SYLLABLE KIYEOK YE PIEUP
    case 0xB0EC: code_point = 0xACD7; break; // HANGUL SYLLABLE KIYEOK YE SIOS
    case 0xB0ED: code_point = 0xACE0; break; // HANGUL SYLLABLE KIYEOK O
    case 0xB0EE: code_point = 0xACE1; break; // HANGUL SYLLABLE KIYEOK O KIYEOK
    case 0xB0EF: code_point = 0xACE4; break; // HANGUL SYLLABLE KIYEOK O NIEUN
    case 0xB0F0: code_point = 0xACE7; break; // HANGUL SYLLABLE KIYEOK O TIKEUT
    case 0xB0F1: code_point = 0xACE8; break; // HANGUL SYLLABLE KIYEOK O RIEUL
    case 0xB0F2: code_point = 0xACEA; break; // HANGUL SYLLABLE KIYEOK O RIEULMIEUM
    case 0xB0F3: code_point = 0xACEC; break; // HANGUL SYLLABLE KIYEOK O RIEULSIOS
    case 0xB0F4: code_point = 0xACEF; break; // HANGUL SYLLABLE KIYEOK O RIEULHIEUH
    case 0xB0F5: code_point = 0xACF0; break; // HANGUL SYLLABLE KIYEOK O MIEUM
    case 0xB0F6: code_point = 0xACF1; break; // HANGUL SYLLABLE KIYEOK O PIEUP
    case 0xB0F7: code_point = 0xACF3; break; // HANGUL SYLLABLE KIYEOK O SIOS
    case 0xB0F8: code_point = 0xACF5; break; // HANGUL SYLLABLE KIYEOK O IEUNG
    case 0xB0F9: code_point = 0xACF6; break; // HANGUL SYLLABLE KIYEOK O CIEUC
    case 0xB0FA: code_point = 0xACFC; break; // HANGUL SYLLABLE KIYEOK WA
    case 0xB0FB: code_point = 0xACFD; break; // HANGUL SYLLABLE KIYEOK WA KIYEOK
    case 0xB0FC: code_point = 0xAD00; break; // HANGUL SYLLABLE KIYEOK WA NIEUN
    case 0xB0FD: code_point = 0xAD04; break; // HANGUL SYLLABLE KIYEOK WA RIEUL
    case 0xB0FE: code_point = 0xAD06; break; // HANGUL SYLLABLE KIYEOK WA RIEULMIEUM
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB1(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB141: code_point = 0xCF02; break; // HANGUL SYLLABLE KHIEUKH E SSANGKIYEOK
    case 0xB142: code_point = 0xCF03; break; // HANGUL SYLLABLE KHIEUKH E KIYEOKSIOS
    case 0xB143: code_point = 0xCF05; break; // HANGUL SYLLABLE KHIEUKH E NIEUNCIEUC
    case 0xB144: code_point = 0xCF06; break; // HANGUL SYLLABLE KHIEUKH E NIEUNHIEUH
    case 0xB145: code_point = 0xCF07; break; // HANGUL SYLLABLE KHIEUKH E TIKEUT
    case 0xB146: code_point = 0xCF09; break; // HANGUL SYLLABLE KHIEUKH E RIEULKIYEOK
    case 0xB147: code_point = 0xCF0A; break; // HANGUL SYLLABLE KHIEUKH E RIEULMIEUM
    case 0xB148: code_point = 0xCF0B; break; // HANGUL SYLLABLE KHIEUKH E RIEULPIEUP
    case 0xB149: code_point = 0xCF0C; break; // HANGUL SYLLABLE KHIEUKH E RIEULSIOS
    case 0xB14A: code_point = 0xCF0D; break; // HANGUL SYLLABLE KHIEUKH E RIEULTHIEUTH
    case 0xB14B: code_point = 0xCF0E; break; // HANGUL SYLLABLE KHIEUKH E RIEULPHIEUPH
    case 0xB14C: code_point = 0xCF0F; break; // HANGUL SYLLABLE KHIEUKH E RIEULHIEUH
    case 0xB14D: code_point = 0xCF12; break; // HANGUL SYLLABLE KHIEUKH E PIEUPSIOS
    case 0xB14E: code_point = 0xCF14; break; // HANGUL SYLLABLE KHIEUKH E SSANGSIOS
    case 0xB14F: code_point = 0xCF16; break; // HANGUL SYLLABLE KHIEUKH E CIEUC
    case 0xB150: code_point = 0xCF17; break; // HANGUL SYLLABLE KHIEUKH E CHIEUCH
    case 0xB151: code_point = 0xCF18; break; // HANGUL SYLLABLE KHIEUKH E KHIEUKH
    case 0xB152: code_point = 0xCF19; break; // HANGUL SYLLABLE KHIEUKH E THIEUTH
    case 0xB153: code_point = 0xCF1A; break; // HANGUL SYLLABLE KHIEUKH E PHIEUPH
    case 0xB154: code_point = 0xCF1B; break; // HANGUL SYLLABLE KHIEUKH E HIEUH
    case 0xB155: code_point = 0xCF1D; break; // HANGUL SYLLABLE KHIEUKH YEO KIYEOK
    case 0xB156: code_point = 0xCF1E; break; // HANGUL SYLLABLE KHIEUKH YEO SSANGKIYEOK
    case 0xB157: code_point = 0xCF1F; break; // HANGUL SYLLABLE KHIEUKH YEO KIYEOKSIOS
    case 0xB158: code_point = 0xCF21; break; // HANGUL SYLLABLE KHIEUKH YEO NIEUNCIEUC
    case 0xB159: code_point = 0xCF22; break; // HANGUL SYLLABLE KHIEUKH YEO NIEUNHIEUH
    case 0xB15A: code_point = 0xCF23; break; // HANGUL SYLLABLE KHIEUKH YEO TIKEUT
    case 0xB161: code_point = 0xCF25; break; // HANGUL SYLLABLE KHIEUKH YEO RIEULKIYEOK
    case 0xB162: code_point = 0xCF26; break; // HANGUL SYLLABLE KHIEUKH YEO RIEULMIEUM
    case 0xB163: code_point = 0xCF27; break; // HANGUL SYLLABLE KHIEUKH YEO RIEULPIEUP
    case 0xB164: code_point = 0xCF28; break; // HANGUL SYLLABLE KHIEUKH YEO RIEULSIOS
    case 0xB165: code_point = 0xCF29; break; // HANGUL SYLLABLE KHIEUKH YEO RIEULTHIEUTH
    case 0xB166: code_point = 0xCF2A; break; // HANGUL SYLLABLE KHIEUKH YEO RIEULPHIEUPH
    case 0xB167: code_point = 0xCF2B; break; // HANGUL SYLLABLE KHIEUKH YEO RIEULHIEUH
    case 0xB168: code_point = 0xCF2E; break; // HANGUL SYLLABLE KHIEUKH YEO PIEUPSIOS
    case 0xB169: code_point = 0xCF32; break; // HANGUL SYLLABLE KHIEUKH YEO CIEUC
    case 0xB16A: code_point = 0xCF33; break; // HANGUL SYLLABLE KHIEUKH YEO CHIEUCH
    case 0xB16B: code_point = 0xCF34; break; // HANGUL SYLLABLE KHIEUKH YEO KHIEUKH
    case 0xB16C: code_point = 0xCF35; break; // HANGUL SYLLABLE KHIEUKH YEO THIEUTH
    case 0xB16D: code_point = 0xCF36; break; // HANGUL SYLLABLE KHIEUKH YEO PHIEUPH
    case 0xB16E: code_point = 0xCF37; break; // HANGUL SYLLABLE KHIEUKH YEO HIEUH
    case 0xB16F: code_point = 0xCF39; break; // HANGUL SYLLABLE KHIEUKH YE KIYEOK
    case 0xB170: code_point = 0xCF3A; break; // HANGUL SYLLABLE KHIEUKH YE SSANGKIYEOK
    case 0xB171: code_point = 0xCF3B; break; // HANGUL SYLLABLE KHIEUKH YE KIYEOKSIOS
    case 0xB172: code_point = 0xCF3C; break; // HANGUL SYLLABLE KHIEUKH YE NIEUN
    case 0xB173: code_point = 0xCF3D; break; // HANGUL SYLLABLE KHIEUKH YE NIEUNCIEUC
    case 0xB174: code_point = 0xCF3E; break; // HANGUL SYLLABLE KHIEUKH YE NIEUNHIEUH
    case 0xB175: code_point = 0xCF3F; break; // HANGUL SYLLABLE KHIEUKH YE TIKEUT
    case 0xB176: code_point = 0xCF40; break; // HANGUL SYLLABLE KHIEUKH YE RIEUL
    case 0xB177: code_point = 0xCF41; break; // HANGUL SYLLABLE KHIEUKH YE RIEULKIYEOK
    case 0xB178: code_point = 0xCF42; break; // HANGUL SYLLABLE KHIEUKH YE RIEULMIEUM
    case 0xB179: code_point = 0xCF43; break; // HANGUL SYLLABLE KHIEUKH YE RIEULPIEUP
    case 0xB17A: code_point = 0xCF44; break; // HANGUL SYLLABLE KHIEUKH YE RIEULSIOS
    case 0xB181: code_point = 0xCF45; break; // HANGUL SYLLABLE KHIEUKH YE RIEULTHIEUTH
    case 0xB182: code_point = 0xCF46; break; // HANGUL SYLLABLE KHIEUKH YE RIEULPHIEUPH
    case 0xB183: code_point = 0xCF47; break; // HANGUL SYLLABLE KHIEUKH YE RIEULHIEUH
    case 0xB184: code_point = 0xCF48; break; // HANGUL SYLLABLE KHIEUKH YE MIEUM
    case 0xB185: code_point = 0xCF49; break; // HANGUL SYLLABLE KHIEUKH YE PIEUP
    case 0xB186: code_point = 0xCF4A; break; // HANGUL SYLLABLE KHIEUKH YE PIEUPSIOS
    case 0xB187: code_point = 0xCF4B; break; // HANGUL SYLLABLE KHIEUKH YE SIOS
    case 0xB188: code_point = 0xCF4C; break; // HANGUL SYLLABLE KHIEUKH YE SSANGSIOS
    case 0xB189: code_point = 0xCF4D; break; // HANGUL SYLLABLE KHIEUKH YE IEUNG
    case 0xB18A: code_point = 0xCF4E; break; // HANGUL SYLLABLE KHIEUKH YE CIEUC
    case 0xB18B: code_point = 0xCF4F; break; // HANGUL SYLLABLE KHIEUKH YE CHIEUCH
    case 0xB18C: code_point = 0xCF50; break; // HANGUL SYLLABLE KHIEUKH YE KHIEUKH
    case 0xB18D: code_point = 0xCF51; break; // HANGUL SYLLABLE KHIEUKH YE THIEUTH
    case 0xB18E: code_point = 0xCF52; break; // HANGUL SYLLABLE KHIEUKH YE PHIEUPH
    case 0xB18F: code_point = 0xCF53; break; // HANGUL SYLLABLE KHIEUKH YE HIEUH
    case 0xB190: code_point = 0xCF56; break; // HANGUL SYLLABLE KHIEUKH O SSANGKIYEOK
    case 0xB191: code_point = 0xCF57; break; // HANGUL SYLLABLE KHIEUKH O KIYEOKSIOS
    case 0xB192: code_point = 0xCF59; break; // HANGUL SYLLABLE KHIEUKH O NIEUNCIEUC
    case 0xB193: code_point = 0xCF5A; break; // HANGUL SYLLABLE KHIEUKH O NIEUNHIEUH
    case 0xB194: code_point = 0xCF5B; break; // HANGUL SYLLABLE KHIEUKH O TIKEUT
    case 0xB195: code_point = 0xCF5D; break; // HANGUL SYLLABLE KHIEUKH O RIEULKIYEOK
    case 0xB196: code_point = 0xCF5E; break; // HANGUL SYLLABLE KHIEUKH O RIEULMIEUM
    case 0xB197: code_point = 0xCF5F; break; // HANGUL SYLLABLE KHIEUKH O RIEULPIEUP
    case 0xB198: code_point = 0xCF60; break; // HANGUL SYLLABLE KHIEUKH O RIEULSIOS
    case 0xB199: code_point = 0xCF61; break; // HANGUL SYLLABLE KHIEUKH O RIEULTHIEUTH
    case 0xB19A: code_point = 0xCF62; break; // HANGUL SYLLABLE KHIEUKH O RIEULPHIEUPH
    case 0xB19B: code_point = 0xCF63; break; // HANGUL SYLLABLE KHIEUKH O RIEULHIEUH
    case 0xB19C: code_point = 0xCF66; break; // HANGUL SYLLABLE KHIEUKH O PIEUPSIOS
    case 0xB19D: code_point = 0xCF68; break; // HANGUL SYLLABLE KHIEUKH O SSANGSIOS
    case 0xB19E: code_point = 0xCF6A; break; // HANGUL SYLLABLE KHIEUKH O CIEUC
    case 0xB19F: code_point = 0xCF6B; break; // HANGUL SYLLABLE KHIEUKH O CHIEUCH
    case 0xB1A0: code_point = 0xCF6C; break; // HANGUL SYLLABLE KHIEUKH O KHIEUKH
    case 0xB1A1: code_point = 0xAD0C; break; // HANGUL SYLLABLE KIYEOK WA MIEUM
    case 0xB1A2: code_point = 0xAD0D; break; // HANGUL SYLLABLE KIYEOK WA PIEUP
    case 0xB1A3: code_point = 0xAD0F; break; // HANGUL SYLLABLE KIYEOK WA SIOS
    case 0xB1A4: code_point = 0xAD11; break; // HANGUL SYLLABLE KIYEOK WA IEUNG
    case 0xB1A5: code_point = 0xAD18; break; // HANGUL SYLLABLE KIYEOK WAE
    case 0xB1A6: code_point = 0xAD1C; break; // HANGUL SYLLABLE KIYEOK WAE NIEUN
    case 0xB1A7: code_point = 0xAD20; break; // HANGUL SYLLABLE KIYEOK WAE RIEUL
    case 0xB1A8: code_point = 0xAD29; break; // HANGUL SYLLABLE KIYEOK WAE PIEUP
    case 0xB1A9: code_point = 0xAD2C; break; // HANGUL SYLLABLE KIYEOK WAE SSANGSIOS
    case 0xB1AA: code_point = 0xAD2D; break; // HANGUL SYLLABLE KIYEOK WAE IEUNG
    case 0xB1AB: code_point = 0xAD34; break; // HANGUL SYLLABLE KIYEOK OE
    case 0xB1AC: code_point = 0xAD35; break; // HANGUL SYLLABLE KIYEOK OE KIYEOK
    case 0xB1AD: code_point = 0xAD38; break; // HANGUL SYLLABLE KIYEOK OE NIEUN
    case 0xB1AE: code_point = 0xAD3C; break; // HANGUL SYLLABLE KIYEOK OE RIEUL
    case 0xB1AF: code_point = 0xAD44; break; // HANGUL SYLLABLE KIYEOK OE MIEUM
    case 0xB1B0: code_point = 0xAD45; break; // HANGUL SYLLABLE KIYEOK OE PIEUP
    case 0xB1B1: code_point = 0xAD47; break; // HANGUL SYLLABLE KIYEOK OE SIOS
    case 0xB1B2: code_point = 0xAD49; break; // HANGUL SYLLABLE KIYEOK OE IEUNG
    case 0xB1B3: code_point = 0xAD50; break; // HANGUL SYLLABLE KIYEOK YO
    case 0xB1B4: code_point = 0xAD54; break; // HANGUL SYLLABLE KIYEOK YO NIEUN
    case 0xB1B5: code_point = 0xAD58; break; // HANGUL SYLLABLE KIYEOK YO RIEUL
    case 0xB1B6: code_point = 0xAD61; break; // HANGUL SYLLABLE KIYEOK YO PIEUP
    case 0xB1B7: code_point = 0xAD63; break; // HANGUL SYLLABLE KIYEOK YO SIOS
    case 0xB1B8: code_point = 0xAD6C; break; // HANGUL SYLLABLE KIYEOK U
    case 0xB1B9: code_point = 0xAD6D; break; // HANGUL SYLLABLE KIYEOK U KIYEOK
    case 0xB1BA: code_point = 0xAD70; break; // HANGUL SYLLABLE KIYEOK U NIEUN
    case 0xB1BB: code_point = 0xAD73; break; // HANGUL SYLLABLE KIYEOK U TIKEUT
    case 0xB1BC: code_point = 0xAD74; break; // HANGUL SYLLABLE KIYEOK U RIEUL
    case 0xB1BD: code_point = 0xAD75; break; // HANGUL SYLLABLE KIYEOK U RIEULKIYEOK
    case 0xB1BE: code_point = 0xAD76; break; // HANGUL SYLLABLE KIYEOK U RIEULMIEUM
    case 0xB1BF: code_point = 0xAD7B; break; // HANGUL SYLLABLE KIYEOK U RIEULHIEUH
    case 0xB1C0: code_point = 0xAD7C; break; // HANGUL SYLLABLE KIYEOK U MIEUM
    case 0xB1C1: code_point = 0xAD7D; break; // HANGUL SYLLABLE KIYEOK U PIEUP
    case 0xB1C2: code_point = 0xAD7F; break; // HANGUL SYLLABLE KIYEOK U SIOS
    case 0xB1C3: code_point = 0xAD81; break; // HANGUL SYLLABLE KIYEOK U IEUNG
    case 0xB1C4: code_point = 0xAD82; break; // HANGUL SYLLABLE KIYEOK U CIEUC
    case 0xB1C5: code_point = 0xAD88; break; // HANGUL SYLLABLE KIYEOK WEO
    case 0xB1C6: code_point = 0xAD89; break; // HANGUL SYLLABLE KIYEOK WEO KIYEOK
    case 0xB1C7: code_point = 0xAD8C; break; // HANGUL SYLLABLE KIYEOK WEO NIEUN
    case 0xB1C8: code_point = 0xAD90; break; // HANGUL SYLLABLE KIYEOK WEO RIEUL
    case 0xB1C9: code_point = 0xAD9C; break; // HANGUL SYLLABLE KIYEOK WEO SSANGSIOS
    case 0xB1CA: code_point = 0xAD9D; break; // HANGUL SYLLABLE KIYEOK WEO IEUNG
    case 0xB1CB: code_point = 0xADA4; break; // HANGUL SYLLABLE KIYEOK WE
    case 0xB1CC: code_point = 0xADB7; break; // HANGUL SYLLABLE KIYEOK WE SIOS
    case 0xB1CD: code_point = 0xADC0; break; // HANGUL SYLLABLE KIYEOK WI
    case 0xB1CE: code_point = 0xADC1; break; // HANGUL SYLLABLE KIYEOK WI KIYEOK
    case 0xB1CF: code_point = 0xADC4; break; // HANGUL SYLLABLE KIYEOK WI NIEUN
    case 0xB1D0: code_point = 0xADC8; break; // HANGUL SYLLABLE KIYEOK WI RIEUL
    case 0xB1D1: code_point = 0xADD0; break; // HANGUL SYLLABLE KIYEOK WI MIEUM
    case 0xB1D2: code_point = 0xADD1; break; // HANGUL SYLLABLE KIYEOK WI PIEUP
    case 0xB1D3: code_point = 0xADD3; break; // HANGUL SYLLABLE KIYEOK WI SIOS
    case 0xB1D4: code_point = 0xADDC; break; // HANGUL SYLLABLE KIYEOK YU
    case 0xB1D5: code_point = 0xADE0; break; // HANGUL SYLLABLE KIYEOK YU NIEUN
    case 0xB1D6: code_point = 0xADE4; break; // HANGUL SYLLABLE KIYEOK YU RIEUL
    case 0xB1D7: code_point = 0xADF8; break; // HANGUL SYLLABLE KIYEOK EU
    case 0xB1D8: code_point = 0xADF9; break; // HANGUL SYLLABLE KIYEOK EU KIYEOK
    case 0xB1D9: code_point = 0xADFC; break; // HANGUL SYLLABLE KIYEOK EU NIEUN
    case 0xB1DA: code_point = 0xADFF; break; // HANGUL SYLLABLE KIYEOK EU TIKEUT
    case 0xB1DB: code_point = 0xAE00; break; // HANGUL SYLLABLE KIYEOK EU RIEUL
    case 0xB1DC: code_point = 0xAE01; break; // HANGUL SYLLABLE KIYEOK EU RIEULKIYEOK
    case 0xB1DD: code_point = 0xAE08; break; // HANGUL SYLLABLE KIYEOK EU MIEUM
    case 0xB1DE: code_point = 0xAE09; break; // HANGUL SYLLABLE KIYEOK EU PIEUP
    case 0xB1DF: code_point = 0xAE0B; break; // HANGUL SYLLABLE KIYEOK EU SIOS
    case 0xB1E0: code_point = 0xAE0D; break; // HANGUL SYLLABLE KIYEOK EU IEUNG
    case 0xB1E1: code_point = 0xAE14; break; // HANGUL SYLLABLE KIYEOK YI
    case 0xB1E2: code_point = 0xAE30; break; // HANGUL SYLLABLE KIYEOK I
    case 0xB1E3: code_point = 0xAE31; break; // HANGUL SYLLABLE KIYEOK I KIYEOK
    case 0xB1E4: code_point = 0xAE34; break; // HANGUL SYLLABLE KIYEOK I NIEUN
    case 0xB1E5: code_point = 0xAE37; break; // HANGUL SYLLABLE KIYEOK I TIKEUT
    case 0xB1E6: code_point = 0xAE38; break; // HANGUL SYLLABLE KIYEOK I RIEUL
    case 0xB1E7: code_point = 0xAE3A; break; // HANGUL SYLLABLE KIYEOK I RIEULMIEUM
    case 0xB1E8: code_point = 0xAE40; break; // HANGUL SYLLABLE KIYEOK I MIEUM
    case 0xB1E9: code_point = 0xAE41; break; // HANGUL SYLLABLE KIYEOK I PIEUP
    case 0xB1EA: code_point = 0xAE43; break; // HANGUL SYLLABLE KIYEOK I SIOS
    case 0xB1EB: code_point = 0xAE45; break; // HANGUL SYLLABLE KIYEOK I IEUNG
    case 0xB1EC: code_point = 0xAE46; break; // HANGUL SYLLABLE KIYEOK I CIEUC
    case 0xB1ED: code_point = 0xAE4A; break; // HANGUL SYLLABLE KIYEOK I PHIEUPH
    case 0xB1EE: code_point = 0xAE4C; break; // HANGUL SYLLABLE SSANGKIYEOK A
    case 0xB1EF: code_point = 0xAE4D; break; // HANGUL SYLLABLE SSANGKIYEOK A KIYEOK
    case 0xB1F0: code_point = 0xAE4E; break; // HANGUL SYLLABLE SSANGKIYEOK A SSANGKIYEOK
    case 0xB1F1: code_point = 0xAE50; break; // HANGUL SYLLABLE SSANGKIYEOK A NIEUN
    case 0xB1F2: code_point = 0xAE54; break; // HANGUL SYLLABLE SSANGKIYEOK A RIEUL
    case 0xB1F3: code_point = 0xAE56; break; // HANGUL SYLLABLE SSANGKIYEOK A RIEULMIEUM
    case 0xB1F4: code_point = 0xAE5C; break; // HANGUL SYLLABLE SSANGKIYEOK A MIEUM
    case 0xB1F5: code_point = 0xAE5D; break; // HANGUL SYLLABLE SSANGKIYEOK A PIEUP
    case 0xB1F6: code_point = 0xAE5F; break; // HANGUL SYLLABLE SSANGKIYEOK A SIOS
    case 0xB1F7: code_point = 0xAE60; break; // HANGUL SYLLABLE SSANGKIYEOK A SSANGSIOS
    case 0xB1F8: code_point = 0xAE61; break; // HANGUL SYLLABLE SSANGKIYEOK A IEUNG
    case 0xB1F9: code_point = 0xAE65; break; // HANGUL SYLLABLE SSANGKIYEOK A THIEUTH
    case 0xB1FA: code_point = 0xAE68; break; // HANGUL SYLLABLE SSANGKIYEOK AE
    case 0xB1FB: code_point = 0xAE69; break; // HANGUL SYLLABLE SSANGKIYEOK AE KIYEOK
    case 0xB1FC: code_point = 0xAE6C; break; // HANGUL SYLLABLE SSANGKIYEOK AE NIEUN
    case 0xB1FD: code_point = 0xAE70; break; // HANGUL SYLLABLE SSANGKIYEOK AE RIEUL
    case 0xB1FE: code_point = 0xAE78; break; // HANGUL SYLLABLE SSANGKIYEOK AE MIEUM
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB2(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB241: code_point = 0xCF6D; break; // HANGUL SYLLABLE KHIEUKH O THIEUTH
    case 0xB242: code_point = 0xCF6E; break; // HANGUL SYLLABLE KHIEUKH O PHIEUPH
    case 0xB243: code_point = 0xCF6F; break; // HANGUL SYLLABLE KHIEUKH O HIEUH
    case 0xB244: code_point = 0xCF72; break; // HANGUL SYLLABLE KHIEUKH WA SSANGKIYEOK
    case 0xB245: code_point = 0xCF73; break; // HANGUL SYLLABLE KHIEUKH WA KIYEOKSIOS
    case 0xB246: code_point = 0xCF75; break; // HANGUL SYLLABLE KHIEUKH WA NIEUNCIEUC
    case 0xB247: code_point = 0xCF76; break; // HANGUL SYLLABLE KHIEUKH WA NIEUNHIEUH
    case 0xB248: code_point = 0xCF77; break; // HANGUL SYLLABLE KHIEUKH WA TIKEUT
    case 0xB249: code_point = 0xCF79; break; // HANGUL SYLLABLE KHIEUKH WA RIEULKIYEOK
    case 0xB24A: code_point = 0xCF7A; break; // HANGUL SYLLABLE KHIEUKH WA RIEULMIEUM
    case 0xB24B: code_point = 0xCF7B; break; // HANGUL SYLLABLE KHIEUKH WA RIEULPIEUP
    case 0xB24C: code_point = 0xCF7C; break; // HANGUL SYLLABLE KHIEUKH WA RIEULSIOS
    case 0xB24D: code_point = 0xCF7D; break; // HANGUL SYLLABLE KHIEUKH WA RIEULTHIEUTH
    case 0xB24E: code_point = 0xCF7E; break; // HANGUL SYLLABLE KHIEUKH WA RIEULPHIEUPH
    case 0xB24F: code_point = 0xCF7F; break; // HANGUL SYLLABLE KHIEUKH WA RIEULHIEUH
    case 0xB250: code_point = 0xCF81; break; // HANGUL SYLLABLE KHIEUKH WA PIEUP
    case 0xB251: code_point = 0xCF82; break; // HANGUL SYLLABLE KHIEUKH WA PIEUPSIOS
    case 0xB252: code_point = 0xCF83; break; // HANGUL SYLLABLE KHIEUKH WA SIOS
    case 0xB253: code_point = 0xCF84; break; // HANGUL SYLLABLE KHIEUKH WA SSANGSIOS
    case 0xB254: code_point = 0xCF86; break; // HANGUL SYLLABLE KHIEUKH WA CIEUC
    case 0xB255: code_point = 0xCF87; break; // HANGUL SYLLABLE KHIEUKH WA CHIEUCH
    case 0xB256: code_point = 0xCF88; break; // HANGUL SYLLABLE KHIEUKH WA KHIEUKH
    case 0xB257: code_point = 0xCF89; break; // HANGUL SYLLABLE KHIEUKH WA THIEUTH
    case 0xB258: code_point = 0xCF8A; break; // HANGUL SYLLABLE KHIEUKH WA PHIEUPH
    case 0xB259: code_point = 0xCF8B; break; // HANGUL SYLLABLE KHIEUKH WA HIEUH
    case 0xB25A: code_point = 0xCF8D; break; // HANGUL SYLLABLE KHIEUKH WAE KIYEOK
    case 0xB261: code_point = 0xCF8E; break; // HANGUL SYLLABLE KHIEUKH WAE SSANGKIYEOK
    case 0xB262: code_point = 0xCF8F; break; // HANGUL SYLLABLE KHIEUKH WAE KIYEOKSIOS
    case 0xB263: code_point = 0xCF90; break; // HANGUL SYLLABLE KHIEUKH WAE NIEUN
    case 0xB264: code_point = 0xCF91; break; // HANGUL SYLLABLE KHIEUKH WAE NIEUNCIEUC
    case 0xB265: code_point = 0xCF92; break; // HANGUL SYLLABLE KHIEUKH WAE NIEUNHIEUH
    case 0xB266: code_point = 0xCF93; break; // HANGUL SYLLABLE KHIEUKH WAE TIKEUT
    case 0xB267: code_point = 0xCF94; break; // HANGUL SYLLABLE KHIEUKH WAE RIEUL
    case 0xB268: code_point = 0xCF95; break; // HANGUL SYLLABLE KHIEUKH WAE RIEULKIYEOK
    case 0xB269: code_point = 0xCF96; break; // HANGUL SYLLABLE KHIEUKH WAE RIEULMIEUM
    case 0xB26A: code_point = 0xCF97; break; // HANGUL SYLLABLE KHIEUKH WAE RIEULPIEUP
    case 0xB26B: code_point = 0xCF98; break; // HANGUL SYLLABLE KHIEUKH WAE RIEULSIOS
    case 0xB26C: code_point = 0xCF99; break; // HANGUL SYLLABLE KHIEUKH WAE RIEULTHIEUTH
    case 0xB26D: code_point = 0xCF9A; break; // HANGUL SYLLABLE KHIEUKH WAE RIEULPHIEUPH
    case 0xB26E: code_point = 0xCF9B; break; // HANGUL SYLLABLE KHIEUKH WAE RIEULHIEUH
    case 0xB26F: code_point = 0xCF9C; break; // HANGUL SYLLABLE KHIEUKH WAE MIEUM
    case 0xB270: code_point = 0xCF9D; break; // HANGUL SYLLABLE KHIEUKH WAE PIEUP
    case 0xB271: code_point = 0xCF9E; break; // HANGUL SYLLABLE KHIEUKH WAE PIEUPSIOS
    case 0xB272: code_point = 0xCF9F; break; // HANGUL SYLLABLE KHIEUKH WAE SIOS
    case 0xB273: code_point = 0xCFA0; break; // HANGUL SYLLABLE KHIEUKH WAE SSANGSIOS
    case 0xB274: code_point = 0xCFA2; break; // HANGUL SYLLABLE KHIEUKH WAE CIEUC
    case 0xB275: code_point = 0xCFA3; break; // HANGUL SYLLABLE KHIEUKH WAE CHIEUCH
    case 0xB276: code_point = 0xCFA4; break; // HANGUL SYLLABLE KHIEUKH WAE KHIEUKH
    case 0xB277: code_point = 0xCFA5; break; // HANGUL SYLLABLE KHIEUKH WAE THIEUTH
    case 0xB278: code_point = 0xCFA6; break; // HANGUL SYLLABLE KHIEUKH WAE PHIEUPH
    case 0xB279: code_point = 0xCFA7; break; // HANGUL SYLLABLE KHIEUKH WAE HIEUH
    case 0xB27A: code_point = 0xCFA9; break; // HANGUL SYLLABLE KHIEUKH OE KIYEOK
    case 0xB281: code_point = 0xCFAA; break; // HANGUL SYLLABLE KHIEUKH OE SSANGKIYEOK
    case 0xB282: code_point = 0xCFAB; break; // HANGUL SYLLABLE KHIEUKH OE KIYEOKSIOS
    case 0xB283: code_point = 0xCFAC; break; // HANGUL SYLLABLE KHIEUKH OE NIEUN
    case 0xB284: code_point = 0xCFAD; break; // HANGUL SYLLABLE KHIEUKH OE NIEUNCIEUC
    case 0xB285: code_point = 0xCFAE; break; // HANGUL SYLLABLE KHIEUKH OE NIEUNHIEUH
    case 0xB286: code_point = 0xCFAF; break; // HANGUL SYLLABLE KHIEUKH OE TIKEUT
    case 0xB287: code_point = 0xCFB1; break; // HANGUL SYLLABLE KHIEUKH OE RIEULKIYEOK
    case 0xB288: code_point = 0xCFB2; break; // HANGUL SYLLABLE KHIEUKH OE RIEULMIEUM
    case 0xB289: code_point = 0xCFB3; break; // HANGUL SYLLABLE KHIEUKH OE RIEULPIEUP
    case 0xB28A: code_point = 0xCFB4; break; // HANGUL SYLLABLE KHIEUKH OE RIEULSIOS
    case 0xB28B: code_point = 0xCFB5; break; // HANGUL SYLLABLE KHIEUKH OE RIEULTHIEUTH
    case 0xB28C: code_point = 0xCFB6; break; // HANGUL SYLLABLE KHIEUKH OE RIEULPHIEUPH
    case 0xB28D: code_point = 0xCFB7; break; // HANGUL SYLLABLE KHIEUKH OE RIEULHIEUH
    case 0xB28E: code_point = 0xCFB8; break; // HANGUL SYLLABLE KHIEUKH OE MIEUM
    case 0xB28F: code_point = 0xCFB9; break; // HANGUL SYLLABLE KHIEUKH OE PIEUP
    case 0xB290: code_point = 0xCFBA; break; // HANGUL SYLLABLE KHIEUKH OE PIEUPSIOS
    case 0xB291: code_point = 0xCFBB; break; // HANGUL SYLLABLE KHIEUKH OE SIOS
    case 0xB292: code_point = 0xCFBC; break; // HANGUL SYLLABLE KHIEUKH OE SSANGSIOS
    case 0xB293: code_point = 0xCFBD; break; // HANGUL SYLLABLE KHIEUKH OE IEUNG
    case 0xB294: code_point = 0xCFBE; break; // HANGUL SYLLABLE KHIEUKH OE CIEUC
    case 0xB295: code_point = 0xCFBF; break; // HANGUL SYLLABLE KHIEUKH OE CHIEUCH
    case 0xB296: code_point = 0xCFC0; break; // HANGUL SYLLABLE KHIEUKH OE KHIEUKH
    case 0xB297: code_point = 0xCFC1; break; // HANGUL SYLLABLE KHIEUKH OE THIEUTH
    case 0xB298: code_point = 0xCFC2; break; // HANGUL SYLLABLE KHIEUKH OE PHIEUPH
    case 0xB299: code_point = 0xCFC3; break; // HANGUL SYLLABLE KHIEUKH OE HIEUH
    case 0xB29A: code_point = 0xCFC5; break; // HANGUL SYLLABLE KHIEUKH YO KIYEOK
    case 0xB29B: code_point = 0xCFC6; break; // HANGUL SYLLABLE KHIEUKH YO SSANGKIYEOK
    case 0xB29C: code_point = 0xCFC7; break; // HANGUL SYLLABLE KHIEUKH YO KIYEOKSIOS
    case 0xB29D: code_point = 0xCFC8; break; // HANGUL SYLLABLE KHIEUKH YO NIEUN
    case 0xB29E: code_point = 0xCFC9; break; // HANGUL SYLLABLE KHIEUKH YO NIEUNCIEUC
    case 0xB29F: code_point = 0xCFCA; break; // HANGUL SYLLABLE KHIEUKH YO NIEUNHIEUH
    case 0xB2A0: code_point = 0xCFCB; break; // HANGUL SYLLABLE KHIEUKH YO TIKEUT
    case 0xB2A1: code_point = 0xAE79; break; // HANGUL SYLLABLE SSANGKIYEOK AE PIEUP
    case 0xB2A2: code_point = 0xAE7B; break; // HANGUL SYLLABLE SSANGKIYEOK AE SIOS
    case 0xB2A3: code_point = 0xAE7C; break; // HANGUL SYLLABLE SSANGKIYEOK AE SSANGSIOS
    case 0xB2A4: code_point = 0xAE7D; break; // HANGUL SYLLABLE SSANGKIYEOK AE IEUNG
    case 0xB2A5: code_point = 0xAE84; break; // HANGUL SYLLABLE SSANGKIYEOK YA
    case 0xB2A6: code_point = 0xAE85; break; // HANGUL SYLLABLE SSANGKIYEOK YA KIYEOK
    case 0xB2A7: code_point = 0xAE8C; break; // HANGUL SYLLABLE SSANGKIYEOK YA RIEUL
    case 0xB2A8: code_point = 0xAEBC; break; // HANGUL SYLLABLE SSANGKIYEOK EO
    case 0xB2A9: code_point = 0xAEBD; break; // HANGUL SYLLABLE SSANGKIYEOK EO KIYEOK
    case 0xB2AA: code_point = 0xAEBE; break; // HANGUL SYLLABLE SSANGKIYEOK EO SSANGKIYEOK
    case 0xB2AB: code_point = 0xAEC0; break; // HANGUL SYLLABLE SSANGKIYEOK EO NIEUN
    case 0xB2AC: code_point = 0xAEC4; break; // HANGUL SYLLABLE SSANGKIYEOK EO RIEUL
    case 0xB2AD: code_point = 0xAECC; break; // HANGUL SYLLABLE SSANGKIYEOK EO MIEUM
    case 0xB2AE: code_point = 0xAECD; break; // HANGUL SYLLABLE SSANGKIYEOK EO PIEUP
    case 0xB2AF: code_point = 0xAECF; break; // HANGUL SYLLABLE SSANGKIYEOK EO SIOS
    case 0xB2B0: code_point = 0xAED0; break; // HANGUL SYLLABLE SSANGKIYEOK EO SSANGSIOS
    case 0xB2B1: code_point = 0xAED1; break; // HANGUL SYLLABLE SSANGKIYEOK EO IEUNG
    case 0xB2B2: code_point = 0xAED8; break; // HANGUL SYLLABLE SSANGKIYEOK E
    case 0xB2B3: code_point = 0xAED9; break; // HANGUL SYLLABLE SSANGKIYEOK E KIYEOK
    case 0xB2B4: code_point = 0xAEDC; break; // HANGUL SYLLABLE SSANGKIYEOK E NIEUN
    case 0xB2B5: code_point = 0xAEE8; break; // HANGUL SYLLABLE SSANGKIYEOK E MIEUM
    case 0xB2B6: code_point = 0xAEEB; break; // HANGUL SYLLABLE SSANGKIYEOK E SIOS
    case 0xB2B7: code_point = 0xAEED; break; // HANGUL SYLLABLE SSANGKIYEOK E IEUNG
    case 0xB2B8: code_point = 0xAEF4; break; // HANGUL SYLLABLE SSANGKIYEOK YEO
    case 0xB2B9: code_point = 0xAEF8; break; // HANGUL SYLLABLE SSANGKIYEOK YEO NIEUN
    case 0xB2BA: code_point = 0xAEFC; break; // HANGUL SYLLABLE SSANGKIYEOK YEO RIEUL
    case 0xB2BB: code_point = 0xAF07; break; // HANGUL SYLLABLE SSANGKIYEOK YEO SIOS
    case 0xB2BC: code_point = 0xAF08; break; // HANGUL SYLLABLE SSANGKIYEOK YEO SSANGSIOS
    case 0xB2BD: code_point = 0xAF0D; break; // HANGUL SYLLABLE SSANGKIYEOK YEO THIEUTH
    case 0xB2BE: code_point = 0xAF10; break; // HANGUL SYLLABLE SSANGKIYEOK YE
    case 0xB2BF: code_point = 0xAF2C; break; // HANGUL SYLLABLE SSANGKIYEOK O
    case 0xB2C0: code_point = 0xAF2D; break; // HANGUL SYLLABLE SSANGKIYEOK O KIYEOK
    case 0xB2C1: code_point = 0xAF30; break; // HANGUL SYLLABLE SSANGKIYEOK O NIEUN
    case 0xB2C2: code_point = 0xAF32; break; // HANGUL SYLLABLE SSANGKIYEOK O NIEUNHIEUH
    case 0xB2C3: code_point = 0xAF34; break; // HANGUL SYLLABLE SSANGKIYEOK O RIEUL
    case 0xB2C4: code_point = 0xAF3C; break; // HANGUL SYLLABLE SSANGKIYEOK O MIEUM
    case 0xB2C5: code_point = 0xAF3D; break; // HANGUL SYLLABLE SSANGKIYEOK O PIEUP
    case 0xB2C6: code_point = 0xAF3F; break; // HANGUL SYLLABLE SSANGKIYEOK O SIOS
    case 0xB2C7: code_point = 0xAF41; break; // HANGUL SYLLABLE SSANGKIYEOK O IEUNG
    case 0xB2C8: code_point = 0xAF42; break; // HANGUL SYLLABLE SSANGKIYEOK O CIEUC
    case 0xB2C9: code_point = 0xAF43; break; // HANGUL SYLLABLE SSANGKIYEOK O CHIEUCH
    case 0xB2CA: code_point = 0xAF48; break; // HANGUL SYLLABLE SSANGKIYEOK WA
    case 0xB2CB: code_point = 0xAF49; break; // HANGUL SYLLABLE SSANGKIYEOK WA KIYEOK
    case 0xB2CC: code_point = 0xAF50; break; // HANGUL SYLLABLE SSANGKIYEOK WA RIEUL
    case 0xB2CD: code_point = 0xAF5C; break; // HANGUL SYLLABLE SSANGKIYEOK WA SSANGSIOS
    case 0xB2CE: code_point = 0xAF5D; break; // HANGUL SYLLABLE SSANGKIYEOK WA IEUNG
    case 0xB2CF: code_point = 0xAF64; break; // HANGUL SYLLABLE SSANGKIYEOK WAE
    case 0xB2D0: code_point = 0xAF65; break; // HANGUL SYLLABLE SSANGKIYEOK WAE KIYEOK
    case 0xB2D1: code_point = 0xAF79; break; // HANGUL SYLLABLE SSANGKIYEOK WAE IEUNG
    case 0xB2D2: code_point = 0xAF80; break; // HANGUL SYLLABLE SSANGKIYEOK OE
    case 0xB2D3: code_point = 0xAF84; break; // HANGUL SYLLABLE SSANGKIYEOK OE NIEUN
    case 0xB2D4: code_point = 0xAF88; break; // HANGUL SYLLABLE SSANGKIYEOK OE RIEUL
    case 0xB2D5: code_point = 0xAF90; break; // HANGUL SYLLABLE SSANGKIYEOK OE MIEUM
    case 0xB2D6: code_point = 0xAF91; break; // HANGUL SYLLABLE SSANGKIYEOK OE PIEUP
    case 0xB2D7: code_point = 0xAF95; break; // HANGUL SYLLABLE SSANGKIYEOK OE IEUNG
    case 0xB2D8: code_point = 0xAF9C; break; // HANGUL SYLLABLE SSANGKIYEOK YO
    case 0xB2D9: code_point = 0xAFB8; break; // HANGUL SYLLABLE SSANGKIYEOK U
    case 0xB2DA: code_point = 0xAFB9; break; // HANGUL SYLLABLE SSANGKIYEOK U KIYEOK
    case 0xB2DB: code_point = 0xAFBC; break; // HANGUL SYLLABLE SSANGKIYEOK U NIEUN
    case 0xB2DC: code_point = 0xAFC0; break; // HANGUL SYLLABLE SSANGKIYEOK U RIEUL
    case 0xB2DD: code_point = 0xAFC7; break; // HANGUL SYLLABLE SSANGKIYEOK U RIEULHIEUH
    case 0xB2DE: code_point = 0xAFC8; break; // HANGUL SYLLABLE SSANGKIYEOK U MIEUM
    case 0xB2DF: code_point = 0xAFC9; break; // HANGUL SYLLABLE SSANGKIYEOK U PIEUP
    case 0xB2E0: code_point = 0xAFCB; break; // HANGUL SYLLABLE SSANGKIYEOK U SIOS
    case 0xB2E1: code_point = 0xAFCD; break; // HANGUL SYLLABLE SSANGKIYEOK U IEUNG
    case 0xB2E2: code_point = 0xAFCE; break; // HANGUL SYLLABLE SSANGKIYEOK U CIEUC
    case 0xB2E3: code_point = 0xAFD4; break; // HANGUL SYLLABLE SSANGKIYEOK WEO
    case 0xB2E4: code_point = 0xAFDC; break; // HANGUL SYLLABLE SSANGKIYEOK WEO RIEUL
    case 0xB2E5: code_point = 0xAFE8; break; // HANGUL SYLLABLE SSANGKIYEOK WEO SSANGSIOS
    case 0xB2E6: code_point = 0xAFE9; break; // HANGUL SYLLABLE SSANGKIYEOK WEO IEUNG
    case 0xB2E7: code_point = 0xAFF0; break; // HANGUL SYLLABLE SSANGKIYEOK WE
    case 0xB2E8: code_point = 0xAFF1; break; // HANGUL SYLLABLE SSANGKIYEOK WE KIYEOK
    case 0xB2E9: code_point = 0xAFF4; break; // HANGUL SYLLABLE SSANGKIYEOK WE NIEUN
    case 0xB2EA: code_point = 0xAFF8; break; // HANGUL SYLLABLE SSANGKIYEOK WE RIEUL
    case 0xB2EB: code_point = 0xB000; break; // HANGUL SYLLABLE SSANGKIYEOK WE MIEUM
    case 0xB2EC: code_point = 0xB001; break; // HANGUL SYLLABLE SSANGKIYEOK WE PIEUP
    case 0xB2ED: code_point = 0xB004; break; // HANGUL SYLLABLE SSANGKIYEOK WE SSANGSIOS
    case 0xB2EE: code_point = 0xB00C; break; // HANGUL SYLLABLE SSANGKIYEOK WI
    case 0xB2EF: code_point = 0xB010; break; // HANGUL SYLLABLE SSANGKIYEOK WI NIEUN
    case 0xB2F0: code_point = 0xB014; break; // HANGUL SYLLABLE SSANGKIYEOK WI RIEUL
    case 0xB2F1: code_point = 0xB01C; break; // HANGUL SYLLABLE SSANGKIYEOK WI MIEUM
    case 0xB2F2: code_point = 0xB01D; break; // HANGUL SYLLABLE SSANGKIYEOK WI PIEUP
    case 0xB2F3: code_point = 0xB028; break; // HANGUL SYLLABLE SSANGKIYEOK YU
    case 0xB2F4: code_point = 0xB044; break; // HANGUL SYLLABLE SSANGKIYEOK EU
    case 0xB2F5: code_point = 0xB045; break; // HANGUL SYLLABLE SSANGKIYEOK EU KIYEOK
    case 0xB2F6: code_point = 0xB048; break; // HANGUL SYLLABLE SSANGKIYEOK EU NIEUN
    case 0xB2F7: code_point = 0xB04A; break; // HANGUL SYLLABLE SSANGKIYEOK EU NIEUNHIEUH
    case 0xB2F8: code_point = 0xB04C; break; // HANGUL SYLLABLE SSANGKIYEOK EU RIEUL
    case 0xB2F9: code_point = 0xB04E; break; // HANGUL SYLLABLE SSANGKIYEOK EU RIEULMIEUM
    case 0xB2FA: code_point = 0xB053; break; // HANGUL SYLLABLE SSANGKIYEOK EU RIEULHIEUH
    case 0xB2FB: code_point = 0xB054; break; // HANGUL SYLLABLE SSANGKIYEOK EU MIEUM
    case 0xB2FC: code_point = 0xB055; break; // HANGUL SYLLABLE SSANGKIYEOK EU PIEUP
    case 0xB2FD: code_point = 0xB057; break; // HANGUL SYLLABLE SSANGKIYEOK EU SIOS
    case 0xB2FE: code_point = 0xB059; break; // HANGUL SYLLABLE SSANGKIYEOK EU IEUNG
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB3(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB341: code_point = 0xCFCC; break; // HANGUL SYLLABLE KHIEUKH YO RIEUL
    case 0xB342: code_point = 0xCFCD; break; // HANGUL SYLLABLE KHIEUKH YO RIEULKIYEOK
    case 0xB343: code_point = 0xCFCE; break; // HANGUL SYLLABLE KHIEUKH YO RIEULMIEUM
    case 0xB344: code_point = 0xCFCF; break; // HANGUL SYLLABLE KHIEUKH YO RIEULPIEUP
    case 0xB345: code_point = 0xCFD0; break; // HANGUL SYLLABLE KHIEUKH YO RIEULSIOS
    case 0xB346: code_point = 0xCFD1; break; // HANGUL SYLLABLE KHIEUKH YO RIEULTHIEUTH
    case 0xB347: code_point = 0xCFD2; break; // HANGUL SYLLABLE KHIEUKH YO RIEULPHIEUPH
    case 0xB348: code_point = 0xCFD3; break; // HANGUL SYLLABLE KHIEUKH YO RIEULHIEUH
    case 0xB349: code_point = 0xCFD4; break; // HANGUL SYLLABLE KHIEUKH YO MIEUM
    case 0xB34A: code_point = 0xCFD5; break; // HANGUL SYLLABLE KHIEUKH YO PIEUP
    case 0xB34B: code_point = 0xCFD6; break; // HANGUL SYLLABLE KHIEUKH YO PIEUPSIOS
    case 0xB34C: code_point = 0xCFD7; break; // HANGUL SYLLABLE KHIEUKH YO SIOS
    case 0xB34D: code_point = 0xCFD8; break; // HANGUL SYLLABLE KHIEUKH YO SSANGSIOS
    case 0xB34E: code_point = 0xCFD9; break; // HANGUL SYLLABLE KHIEUKH YO IEUNG
    case 0xB34F: code_point = 0xCFDA; break; // HANGUL SYLLABLE KHIEUKH YO CIEUC
    case 0xB350: code_point = 0xCFDB; break; // HANGUL SYLLABLE KHIEUKH YO CHIEUCH
    case 0xB351: code_point = 0xCFDC; break; // HANGUL SYLLABLE KHIEUKH YO KHIEUKH
    case 0xB352: code_point = 0xCFDD; break; // HANGUL SYLLABLE KHIEUKH YO THIEUTH
    case 0xB353: code_point = 0xCFDE; break; // HANGUL SYLLABLE KHIEUKH YO PHIEUPH
    case 0xB354: code_point = 0xCFDF; break; // HANGUL SYLLABLE KHIEUKH YO HIEUH
    case 0xB355: code_point = 0xCFE2; break; // HANGUL SYLLABLE KHIEUKH U SSANGKIYEOK
    case 0xB356: code_point = 0xCFE3; break; // HANGUL SYLLABLE KHIEUKH U KIYEOKSIOS
    case 0xB357: code_point = 0xCFE5; break; // HANGUL SYLLABLE KHIEUKH U NIEUNCIEUC
    case 0xB358: code_point = 0xCFE6; break; // HANGUL SYLLABLE KHIEUKH U NIEUNHIEUH
    case 0xB359: code_point = 0xCFE7; break; // HANGUL SYLLABLE KHIEUKH U TIKEUT
    case 0xB35A: code_point = 0xCFE9; break; // HANGUL SYLLABLE KHIEUKH U RIEULKIYEOK
    case 0xB361: code_point = 0xCFEA; break; // HANGUL SYLLABLE KHIEUKH U RIEULMIEUM
    case 0xB362: code_point = 0xCFEB; break; // HANGUL SYLLABLE KHIEUKH U RIEULPIEUP
    case 0xB363: code_point = 0xCFEC; break; // HANGUL SYLLABLE KHIEUKH U RIEULSIOS
    case 0xB364: code_point = 0xCFED; break; // HANGUL SYLLABLE KHIEUKH U RIEULTHIEUTH
    case 0xB365: code_point = 0xCFEE; break; // HANGUL SYLLABLE KHIEUKH U RIEULPHIEUPH
    case 0xB366: code_point = 0xCFEF; break; // HANGUL SYLLABLE KHIEUKH U RIEULHIEUH
    case 0xB367: code_point = 0xCFF2; break; // HANGUL SYLLABLE KHIEUKH U PIEUPSIOS
    case 0xB368: code_point = 0xCFF4; break; // HANGUL SYLLABLE KHIEUKH U SSANGSIOS
    case 0xB369: code_point = 0xCFF6; break; // HANGUL SYLLABLE KHIEUKH U CIEUC
    case 0xB36A: code_point = 0xCFF7; break; // HANGUL SYLLABLE KHIEUKH U CHIEUCH
    case 0xB36B: code_point = 0xCFF8; break; // HANGUL SYLLABLE KHIEUKH U KHIEUKH
    case 0xB36C: code_point = 0xCFF9; break; // HANGUL SYLLABLE KHIEUKH U THIEUTH
    case 0xB36D: code_point = 0xCFFA; break; // HANGUL SYLLABLE KHIEUKH U PHIEUPH
    case 0xB36E: code_point = 0xCFFB; break; // HANGUL SYLLABLE KHIEUKH U HIEUH
    case 0xB36F: code_point = 0xCFFD; break; // HANGUL SYLLABLE KHIEUKH WEO KIYEOK
    case 0xB370: code_point = 0xCFFE; break; // HANGUL SYLLABLE KHIEUKH WEO SSANGKIYEOK
    case 0xB371: code_point = 0xCFFF; break; // HANGUL SYLLABLE KHIEUKH WEO KIYEOKSIOS
    case 0xB372: code_point = 0xD001; break; // HANGUL SYLLABLE KHIEUKH WEO NIEUNCIEUC
    case 0xB373: code_point = 0xD002; break; // HANGUL SYLLABLE KHIEUKH WEO NIEUNHIEUH
    case 0xB374: code_point = 0xD003; break; // HANGUL SYLLABLE KHIEUKH WEO TIKEUT
    case 0xB375: code_point = 0xD005; break; // HANGUL SYLLABLE KHIEUKH WEO RIEULKIYEOK
    case 0xB376: code_point = 0xD006; break; // HANGUL SYLLABLE KHIEUKH WEO RIEULMIEUM
    case 0xB377: code_point = 0xD007; break; // HANGUL SYLLABLE KHIEUKH WEO RIEULPIEUP
    case 0xB378: code_point = 0xD008; break; // HANGUL SYLLABLE KHIEUKH WEO RIEULSIOS
    case 0xB379: code_point = 0xD009; break; // HANGUL SYLLABLE KHIEUKH WEO RIEULTHIEUTH
    case 0xB37A: code_point = 0xD00A; break; // HANGUL SYLLABLE KHIEUKH WEO RIEULPHIEUPH
    case 0xB381: code_point = 0xD00B; break; // HANGUL SYLLABLE KHIEUKH WEO RIEULHIEUH
    case 0xB382: code_point = 0xD00C; break; // HANGUL SYLLABLE KHIEUKH WEO MIEUM
    case 0xB383: code_point = 0xD00D; break; // HANGUL SYLLABLE KHIEUKH WEO PIEUP
    case 0xB384: code_point = 0xD00E; break; // HANGUL SYLLABLE KHIEUKH WEO PIEUPSIOS
    case 0xB385: code_point = 0xD00F; break; // HANGUL SYLLABLE KHIEUKH WEO SIOS
    case 0xB386: code_point = 0xD010; break; // HANGUL SYLLABLE KHIEUKH WEO SSANGSIOS
    case 0xB387: code_point = 0xD012; break; // HANGUL SYLLABLE KHIEUKH WEO CIEUC
    case 0xB388: code_point = 0xD013; break; // HANGUL SYLLABLE KHIEUKH WEO CHIEUCH
    case 0xB389: code_point = 0xD014; break; // HANGUL SYLLABLE KHIEUKH WEO KHIEUKH
    case 0xB38A: code_point = 0xD015; break; // HANGUL SYLLABLE KHIEUKH WEO THIEUTH
    case 0xB38B: code_point = 0xD016; break; // HANGUL SYLLABLE KHIEUKH WEO PHIEUPH
    case 0xB38C: code_point = 0xD017; break; // HANGUL SYLLABLE KHIEUKH WEO HIEUH
    case 0xB38D: code_point = 0xD019; break; // HANGUL SYLLABLE KHIEUKH WE KIYEOK
    case 0xB38E: code_point = 0xD01A; break; // HANGUL SYLLABLE KHIEUKH WE SSANGKIYEOK
    case 0xB38F: code_point = 0xD01B; break; // HANGUL SYLLABLE KHIEUKH WE KIYEOKSIOS
    case 0xB390: code_point = 0xD01C; break; // HANGUL SYLLABLE KHIEUKH WE NIEUN
    case 0xB391: code_point = 0xD01D; break; // HANGUL SYLLABLE KHIEUKH WE NIEUNCIEUC
    case 0xB392: code_point = 0xD01E; break; // HANGUL SYLLABLE KHIEUKH WE NIEUNHIEUH
    case 0xB393: code_point = 0xD01F; break; // HANGUL SYLLABLE KHIEUKH WE TIKEUT
    case 0xB394: code_point = 0xD020; break; // HANGUL SYLLABLE KHIEUKH WE RIEUL
    case 0xB395: code_point = 0xD021; break; // HANGUL SYLLABLE KHIEUKH WE RIEULKIYEOK
    case 0xB396: code_point = 0xD022; break; // HANGUL SYLLABLE KHIEUKH WE RIEULMIEUM
    case 0xB397: code_point = 0xD023; break; // HANGUL SYLLABLE KHIEUKH WE RIEULPIEUP
    case 0xB398: code_point = 0xD024; break; // HANGUL SYLLABLE KHIEUKH WE RIEULSIOS
    case 0xB399: code_point = 0xD025; break; // HANGUL SYLLABLE KHIEUKH WE RIEULTHIEUTH
    case 0xB39A: code_point = 0xD026; break; // HANGUL SYLLABLE KHIEUKH WE RIEULPHIEUPH
    case 0xB39B: code_point = 0xD027; break; // HANGUL SYLLABLE KHIEUKH WE RIEULHIEUH
    case 0xB39C: code_point = 0xD028; break; // HANGUL SYLLABLE KHIEUKH WE MIEUM
    case 0xB39D: code_point = 0xD029; break; // HANGUL SYLLABLE KHIEUKH WE PIEUP
    case 0xB39E: code_point = 0xD02A; break; // HANGUL SYLLABLE KHIEUKH WE PIEUPSIOS
    case 0xB39F: code_point = 0xD02B; break; // HANGUL SYLLABLE KHIEUKH WE SIOS
    case 0xB3A0: code_point = 0xD02C; break; // HANGUL SYLLABLE KHIEUKH WE SSANGSIOS
    case 0xB3A1: code_point = 0xB05D; break; // HANGUL SYLLABLE SSANGKIYEOK EU THIEUTH
    case 0xB3A2: code_point = 0xB07C; break; // HANGUL SYLLABLE SSANGKIYEOK I
    case 0xB3A3: code_point = 0xB07D; break; // HANGUL SYLLABLE SSANGKIYEOK I KIYEOK
    case 0xB3A4: code_point = 0xB080; break; // HANGUL SYLLABLE SSANGKIYEOK I NIEUN
    case 0xB3A5: code_point = 0xB084; break; // HANGUL SYLLABLE SSANGKIYEOK I RIEUL
    case 0xB3A6: code_point = 0xB08C; break; // HANGUL SYLLABLE SSANGKIYEOK I MIEUM
    case 0xB3A7: code_point = 0xB08D; break; // HANGUL SYLLABLE SSANGKIYEOK I PIEUP
    case 0xB3A8: code_point = 0xB08F; break; // HANGUL SYLLABLE SSANGKIYEOK I SIOS
    case 0xB3A9: code_point = 0xB091; break; // HANGUL SYLLABLE SSANGKIYEOK I IEUNG
    case 0xB3AA: code_point = 0xB098; break; // HANGUL SYLLABLE NIEUN A
    case 0xB3AB: code_point = 0xB099; break; // HANGUL SYLLABLE NIEUN A KIYEOK
    case 0xB3AC: code_point = 0xB09A; break; // HANGUL SYLLABLE NIEUN A SSANGKIYEOK
    case 0xB3AD: code_point = 0xB09C; break; // HANGUL SYLLABLE NIEUN A NIEUN
    case 0xB3AE: code_point = 0xB09F; break; // HANGUL SYLLABLE NIEUN A TIKEUT
    case 0xB3AF: code_point = 0xB0A0; break; // HANGUL SYLLABLE NIEUN A RIEUL
    case 0xB3B0: code_point = 0xB0A1; break; // HANGUL SYLLABLE NIEUN A RIEULKIYEOK
    case 0xB3B1: code_point = 0xB0A2; break; // HANGUL SYLLABLE NIEUN A RIEULMIEUM
    case 0xB3B2: code_point = 0xB0A8; break; // HANGUL SYLLABLE NIEUN A MIEUM
    case 0xB3B3: code_point = 0xB0A9; break; // HANGUL SYLLABLE NIEUN A PIEUP
    case 0xB3B4: code_point = 0xB0AB; break; // HANGUL SYLLABLE NIEUN A SIOS
    case 0xB3B5: code_point = 0xB0AC; break; // HANGUL SYLLABLE NIEUN A SSANGSIOS
    case 0xB3B6: code_point = 0xB0AD; break; // HANGUL SYLLABLE NIEUN A IEUNG
    case 0xB3B7: code_point = 0xB0AE; break; // HANGUL SYLLABLE NIEUN A CIEUC
    case 0xB3B8: code_point = 0xB0AF; break; // HANGUL SYLLABLE NIEUN A CHIEUCH
    case 0xB3B9: code_point = 0xB0B1; break; // HANGUL SYLLABLE NIEUN A THIEUTH
    case 0xB3BA: code_point = 0xB0B3; break; // HANGUL SYLLABLE NIEUN A HIEUH
    case 0xB3BB: code_point = 0xB0B4; break; // HANGUL SYLLABLE NIEUN AE
    case 0xB3BC: code_point = 0xB0B5; break; // HANGUL SYLLABLE NIEUN AE KIYEOK
    case 0xB3BD: code_point = 0xB0B8; break; // HANGUL SYLLABLE NIEUN AE NIEUN
    case 0xB3BE: code_point = 0xB0BC; break; // HANGUL SYLLABLE NIEUN AE RIEUL
    case 0xB3BF: code_point = 0xB0C4; break; // HANGUL SYLLABLE NIEUN AE MIEUM
    case 0xB3C0: code_point = 0xB0C5; break; // HANGUL SYLLABLE NIEUN AE PIEUP
    case 0xB3C1: code_point = 0xB0C7; break; // HANGUL SYLLABLE NIEUN AE SIOS
    case 0xB3C2: code_point = 0xB0C8; break; // HANGUL SYLLABLE NIEUN AE SSANGSIOS
    case 0xB3C3: code_point = 0xB0C9; break; // HANGUL SYLLABLE NIEUN AE IEUNG
    case 0xB3C4: code_point = 0xB0D0; break; // HANGUL SYLLABLE NIEUN YA
    case 0xB3C5: code_point = 0xB0D1; break; // HANGUL SYLLABLE NIEUN YA KIYEOK
    case 0xB3C6: code_point = 0xB0D4; break; // HANGUL SYLLABLE NIEUN YA NIEUN
    case 0xB3C7: code_point = 0xB0D8; break; // HANGUL SYLLABLE NIEUN YA RIEUL
    case 0xB3C8: code_point = 0xB0E0; break; // HANGUL SYLLABLE NIEUN YA MIEUM
    case 0xB3C9: code_point = 0xB0E5; break; // HANGUL SYLLABLE NIEUN YA IEUNG
    case 0xB3CA: code_point = 0xB108; break; // HANGUL SYLLABLE NIEUN EO
    case 0xB3CB: code_point = 0xB109; break; // HANGUL SYLLABLE NIEUN EO KIYEOK
    case 0xB3CC: code_point = 0xB10B; break; // HANGUL SYLLABLE NIEUN EO KIYEOKSIOS
    case 0xB3CD: code_point = 0xB10C; break; // HANGUL SYLLABLE NIEUN EO NIEUN
    case 0xB3CE: code_point = 0xB110; break; // HANGUL SYLLABLE NIEUN EO RIEUL
    case 0xB3CF: code_point = 0xB112; break; // HANGUL SYLLABLE NIEUN EO RIEULMIEUM
    case 0xB3D0: code_point = 0xB113; break; // HANGUL SYLLABLE NIEUN EO RIEULPIEUP
    case 0xB3D1: code_point = 0xB118; break; // HANGUL SYLLABLE NIEUN EO MIEUM
    case 0xB3D2: code_point = 0xB119; break; // HANGUL SYLLABLE NIEUN EO PIEUP
    case 0xB3D3: code_point = 0xB11B; break; // HANGUL SYLLABLE NIEUN EO SIOS
    case 0xB3D4: code_point = 0xB11C; break; // HANGUL SYLLABLE NIEUN EO SSANGSIOS
    case 0xB3D5: code_point = 0xB11D; break; // HANGUL SYLLABLE NIEUN EO IEUNG
    case 0xB3D6: code_point = 0xB123; break; // HANGUL SYLLABLE NIEUN EO HIEUH
    case 0xB3D7: code_point = 0xB124; break; // HANGUL SYLLABLE NIEUN E
    case 0xB3D8: code_point = 0xB125; break; // HANGUL SYLLABLE NIEUN E KIYEOK
    case 0xB3D9: code_point = 0xB128; break; // HANGUL SYLLABLE NIEUN E NIEUN
    case 0xB3DA: code_point = 0xB12C; break; // HANGUL SYLLABLE NIEUN E RIEUL
    case 0xB3DB: code_point = 0xB134; break; // HANGUL SYLLABLE NIEUN E MIEUM
    case 0xB3DC: code_point = 0xB135; break; // HANGUL SYLLABLE NIEUN E PIEUP
    case 0xB3DD: code_point = 0xB137; break; // HANGUL SYLLABLE NIEUN E SIOS
    case 0xB3DE: code_point = 0xB138; break; // HANGUL SYLLABLE NIEUN E SSANGSIOS
    case 0xB3DF: code_point = 0xB139; break; // HANGUL SYLLABLE NIEUN E IEUNG
    case 0xB3E0: code_point = 0xB140; break; // HANGUL SYLLABLE NIEUN YEO
    case 0xB3E1: code_point = 0xB141; break; // HANGUL SYLLABLE NIEUN YEO KIYEOK
    case 0xB3E2: code_point = 0xB144; break; // HANGUL SYLLABLE NIEUN YEO NIEUN
    case 0xB3E3: code_point = 0xB148; break; // HANGUL SYLLABLE NIEUN YEO RIEUL
    case 0xB3E4: code_point = 0xB150; break; // HANGUL SYLLABLE NIEUN YEO MIEUM
    case 0xB3E5: code_point = 0xB151; break; // HANGUL SYLLABLE NIEUN YEO PIEUP
    case 0xB3E6: code_point = 0xB154; break; // HANGUL SYLLABLE NIEUN YEO SSANGSIOS
    case 0xB3E7: code_point = 0xB155; break; // HANGUL SYLLABLE NIEUN YEO IEUNG
    case 0xB3E8: code_point = 0xB158; break; // HANGUL SYLLABLE NIEUN YEO KHIEUKH
    case 0xB3E9: code_point = 0xB15C; break; // HANGUL SYLLABLE NIEUN YE
    case 0xB3EA: code_point = 0xB160; break; // HANGUL SYLLABLE NIEUN YE NIEUN
    case 0xB3EB: code_point = 0xB178; break; // HANGUL SYLLABLE NIEUN O
    case 0xB3EC: code_point = 0xB179; break; // HANGUL SYLLABLE NIEUN O KIYEOK
    case 0xB3ED: code_point = 0xB17C; break; // HANGUL SYLLABLE NIEUN O NIEUN
    case 0xB3EE: code_point = 0xB180; break; // HANGUL SYLLABLE NIEUN O RIEUL
    case 0xB3EF: code_point = 0xB182; break; // HANGUL SYLLABLE NIEUN O RIEULMIEUM
    case 0xB3F0: code_point = 0xB188; break; // HANGUL SYLLABLE NIEUN O MIEUM
    case 0xB3F1: code_point = 0xB189; break; // HANGUL SYLLABLE NIEUN O PIEUP
    case 0xB3F2: code_point = 0xB18B; break; // HANGUL SYLLABLE NIEUN O SIOS
    case 0xB3F3: code_point = 0xB18D; break; // HANGUL SYLLABLE NIEUN O IEUNG
    case 0xB3F4: code_point = 0xB192; break; // HANGUL SYLLABLE NIEUN O PHIEUPH
    case 0xB3F5: code_point = 0xB193; break; // HANGUL SYLLABLE NIEUN O HIEUH
    case 0xB3F6: code_point = 0xB194; break; // HANGUL SYLLABLE NIEUN WA
    case 0xB3F7: code_point = 0xB198; break; // HANGUL SYLLABLE NIEUN WA NIEUN
    case 0xB3F8: code_point = 0xB19C; break; // HANGUL SYLLABLE NIEUN WA RIEUL
    case 0xB3F9: code_point = 0xB1A8; break; // HANGUL SYLLABLE NIEUN WA SSANGSIOS
    case 0xB3FA: code_point = 0xB1CC; break; // HANGUL SYLLABLE NIEUN OE
    case 0xB3FB: code_point = 0xB1D0; break; // HANGUL SYLLABLE NIEUN OE NIEUN
    case 0xB3FC: code_point = 0xB1D4; break; // HANGUL SYLLABLE NIEUN OE RIEUL
    case 0xB3FD: code_point = 0xB1DC; break; // HANGUL SYLLABLE NIEUN OE MIEUM
    case 0xB3FE: code_point = 0xB1DD; break; // HANGUL SYLLABLE NIEUN OE PIEUP
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB4(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB441: code_point = 0xD02E; break; // HANGUL SYLLABLE KHIEUKH WE CIEUC
    case 0xB442: code_point = 0xD02F; break; // HANGUL SYLLABLE KHIEUKH WE CHIEUCH
    case 0xB443: code_point = 0xD030; break; // HANGUL SYLLABLE KHIEUKH WE KHIEUKH
    case 0xB444: code_point = 0xD031; break; // HANGUL SYLLABLE KHIEUKH WE THIEUTH
    case 0xB445: code_point = 0xD032; break; // HANGUL SYLLABLE KHIEUKH WE PHIEUPH
    case 0xB446: code_point = 0xD033; break; // HANGUL SYLLABLE KHIEUKH WE HIEUH
    case 0xB447: code_point = 0xD036; break; // HANGUL SYLLABLE KHIEUKH WI SSANGKIYEOK
    case 0xB448: code_point = 0xD037; break; // HANGUL SYLLABLE KHIEUKH WI KIYEOKSIOS
    case 0xB449: code_point = 0xD039; break; // HANGUL SYLLABLE KHIEUKH WI NIEUNCIEUC
    case 0xB44A: code_point = 0xD03A; break; // HANGUL SYLLABLE KHIEUKH WI NIEUNHIEUH
    case 0xB44B: code_point = 0xD03B; break; // HANGUL SYLLABLE KHIEUKH WI TIKEUT
    case 0xB44C: code_point = 0xD03D; break; // HANGUL SYLLABLE KHIEUKH WI RIEULKIYEOK
    case 0xB44D: code_point = 0xD03E; break; // HANGUL SYLLABLE KHIEUKH WI RIEULMIEUM
    case 0xB44E: code_point = 0xD03F; break; // HANGUL SYLLABLE KHIEUKH WI RIEULPIEUP
    case 0xB44F: code_point = 0xD040; break; // HANGUL SYLLABLE KHIEUKH WI RIEULSIOS
    case 0xB450: code_point = 0xD041; break; // HANGUL SYLLABLE KHIEUKH WI RIEULTHIEUTH
    case 0xB451: code_point = 0xD042; break; // HANGUL SYLLABLE KHIEUKH WI RIEULPHIEUPH
    case 0xB452: code_point = 0xD043; break; // HANGUL SYLLABLE KHIEUKH WI RIEULHIEUH
    case 0xB453: code_point = 0xD046; break; // HANGUL SYLLABLE KHIEUKH WI PIEUPSIOS
    case 0xB454: code_point = 0xD048; break; // HANGUL SYLLABLE KHIEUKH WI SSANGSIOS
    case 0xB455: code_point = 0xD04A; break; // HANGUL SYLLABLE KHIEUKH WI CIEUC
    case 0xB456: code_point = 0xD04B; break; // HANGUL SYLLABLE KHIEUKH WI CHIEUCH
    case 0xB457: code_point = 0xD04C; break; // HANGUL SYLLABLE KHIEUKH WI KHIEUKH
    case 0xB458: code_point = 0xD04D; break; // HANGUL SYLLABLE KHIEUKH WI THIEUTH
    case 0xB459: code_point = 0xD04E; break; // HANGUL SYLLABLE KHIEUKH WI PHIEUPH
    case 0xB45A: code_point = 0xD04F; break; // HANGUL SYLLABLE KHIEUKH WI HIEUH
    case 0xB461: code_point = 0xD051; break; // HANGUL SYLLABLE KHIEUKH YU KIYEOK
    case 0xB462: code_point = 0xD052; break; // HANGUL SYLLABLE KHIEUKH YU SSANGKIYEOK
    case 0xB463: code_point = 0xD053; break; // HANGUL SYLLABLE KHIEUKH YU KIYEOKSIOS
    case 0xB464: code_point = 0xD055; break; // HANGUL SYLLABLE KHIEUKH YU NIEUNCIEUC
    case 0xB465: code_point = 0xD056; break; // HANGUL SYLLABLE KHIEUKH YU NIEUNHIEUH
    case 0xB466: code_point = 0xD057; break; // HANGUL SYLLABLE KHIEUKH YU TIKEUT
    case 0xB467: code_point = 0xD059; break; // HANGUL SYLLABLE KHIEUKH YU RIEULKIYEOK
    case 0xB468: code_point = 0xD05A; break; // HANGUL SYLLABLE KHIEUKH YU RIEULMIEUM
    case 0xB469: code_point = 0xD05B; break; // HANGUL SYLLABLE KHIEUKH YU RIEULPIEUP
    case 0xB46A: code_point = 0xD05C; break; // HANGUL SYLLABLE KHIEUKH YU RIEULSIOS
    case 0xB46B: code_point = 0xD05D; break; // HANGUL SYLLABLE KHIEUKH YU RIEULTHIEUTH
    case 0xB46C: code_point = 0xD05E; break; // HANGUL SYLLABLE KHIEUKH YU RIEULPHIEUPH
    case 0xB46D: code_point = 0xD05F; break; // HANGUL SYLLABLE KHIEUKH YU RIEULHIEUH
    case 0xB46E: code_point = 0xD061; break; // HANGUL SYLLABLE KHIEUKH YU PIEUP
    case 0xB46F: code_point = 0xD062; break; // HANGUL SYLLABLE KHIEUKH YU PIEUPSIOS
    case 0xB470: code_point = 0xD063; break; // HANGUL SYLLABLE KHIEUKH YU SIOS
    case 0xB471: code_point = 0xD064; break; // HANGUL SYLLABLE KHIEUKH YU SSANGSIOS
    case 0xB472: code_point = 0xD065; break; // HANGUL SYLLABLE KHIEUKH YU IEUNG
    case 0xB473: code_point = 0xD066; break; // HANGUL SYLLABLE KHIEUKH YU CIEUC
    case 0xB474: code_point = 0xD067; break; // HANGUL SYLLABLE KHIEUKH YU CHIEUCH
    case 0xB475: code_point = 0xD068; break; // HANGUL SYLLABLE KHIEUKH YU KHIEUKH
    case 0xB476: code_point = 0xD069; break; // HANGUL SYLLABLE KHIEUKH YU THIEUTH
    case 0xB477: code_point = 0xD06A; break; // HANGUL SYLLABLE KHIEUKH YU PHIEUPH
    case 0xB478: code_point = 0xD06B; break; // HANGUL SYLLABLE KHIEUKH YU HIEUH
    case 0xB479: code_point = 0xD06E; break; // HANGUL SYLLABLE KHIEUKH EU SSANGKIYEOK
    case 0xB47A: code_point = 0xD06F; break; // HANGUL SYLLABLE KHIEUKH EU KIYEOKSIOS
    case 0xB481: code_point = 0xD071; break; // HANGUL SYLLABLE KHIEUKH EU NIEUNCIEUC
    case 0xB482: code_point = 0xD072; break; // HANGUL SYLLABLE KHIEUKH EU NIEUNHIEUH
    case 0xB483: code_point = 0xD073; break; // HANGUL SYLLABLE KHIEUKH EU TIKEUT
    case 0xB484: code_point = 0xD075; break; // HANGUL SYLLABLE KHIEUKH EU RIEULKIYEOK
    case 0xB485: code_point = 0xD076; break; // HANGUL SYLLABLE KHIEUKH EU RIEULMIEUM
    case 0xB486: code_point = 0xD077; break; // HANGUL SYLLABLE KHIEUKH EU RIEULPIEUP
    case 0xB487: code_point = 0xD078; break; // HANGUL SYLLABLE KHIEUKH EU RIEULSIOS
    case 0xB488: code_point = 0xD079; break; // HANGUL SYLLABLE KHIEUKH EU RIEULTHIEUTH
    case 0xB489: code_point = 0xD07A; break; // HANGUL SYLLABLE KHIEUKH EU RIEULPHIEUPH
    case 0xB48A: code_point = 0xD07B; break; // HANGUL SYLLABLE KHIEUKH EU RIEULHIEUH
    case 0xB48B: code_point = 0xD07E; break; // HANGUL SYLLABLE KHIEUKH EU PIEUPSIOS
    case 0xB48C: code_point = 0xD07F; break; // HANGUL SYLLABLE KHIEUKH EU SIOS
    case 0xB48D: code_point = 0xD080; break; // HANGUL SYLLABLE KHIEUKH EU SSANGSIOS
    case 0xB48E: code_point = 0xD082; break; // HANGUL SYLLABLE KHIEUKH EU CIEUC
    case 0xB48F: code_point = 0xD083; break; // HANGUL SYLLABLE KHIEUKH EU CHIEUCH
    case 0xB490: code_point = 0xD084; break; // HANGUL SYLLABLE KHIEUKH EU KHIEUKH
    case 0xB491: code_point = 0xD085; break; // HANGUL SYLLABLE KHIEUKH EU THIEUTH
    case 0xB492: code_point = 0xD086; break; // HANGUL SYLLABLE KHIEUKH EU PHIEUPH
    case 0xB493: code_point = 0xD087; break; // HANGUL SYLLABLE KHIEUKH EU HIEUH
    case 0xB494: code_point = 0xD088; break; // HANGUL SYLLABLE KHIEUKH YI
    case 0xB495: code_point = 0xD089; break; // HANGUL SYLLABLE KHIEUKH YI KIYEOK
    case 0xB496: code_point = 0xD08A; break; // HANGUL SYLLABLE KHIEUKH YI SSANGKIYEOK
    case 0xB497: code_point = 0xD08B; break; // HANGUL SYLLABLE KHIEUKH YI KIYEOKSIOS
    case 0xB498: code_point = 0xD08C; break; // HANGUL SYLLABLE KHIEUKH YI NIEUN
    case 0xB499: code_point = 0xD08D; break; // HANGUL SYLLABLE KHIEUKH YI NIEUNCIEUC
    case 0xB49A: code_point = 0xD08E; break; // HANGUL SYLLABLE KHIEUKH YI NIEUNHIEUH
    case 0xB49B: code_point = 0xD08F; break; // HANGUL SYLLABLE KHIEUKH YI TIKEUT
    case 0xB49C: code_point = 0xD090; break; // HANGUL SYLLABLE KHIEUKH YI RIEUL
    case 0xB49D: code_point = 0xD091; break; // HANGUL SYLLABLE KHIEUKH YI RIEULKIYEOK
    case 0xB49E: code_point = 0xD092; break; // HANGUL SYLLABLE KHIEUKH YI RIEULMIEUM
    case 0xB49F: code_point = 0xD093; break; // HANGUL SYLLABLE KHIEUKH YI RIEULPIEUP
    case 0xB4A0: code_point = 0xD094; break; // HANGUL SYLLABLE KHIEUKH YI RIEULSIOS
    case 0xB4A1: code_point = 0xB1DF; break; // HANGUL SYLLABLE NIEUN OE SIOS
    case 0xB4A2: code_point = 0xB1E8; break; // HANGUL SYLLABLE NIEUN YO
    case 0xB4A3: code_point = 0xB1E9; break; // HANGUL SYLLABLE NIEUN YO KIYEOK
    case 0xB4A4: code_point = 0xB1EC; break; // HANGUL SYLLABLE NIEUN YO NIEUN
    case 0xB4A5: code_point = 0xB1F0; break; // HANGUL SYLLABLE NIEUN YO RIEUL
    case 0xB4A6: code_point = 0xB1F9; break; // HANGUL SYLLABLE NIEUN YO PIEUP
    case 0xB4A7: code_point = 0xB1FB; break; // HANGUL SYLLABLE NIEUN YO SIOS
    case 0xB4A8: code_point = 0xB1FD; break; // HANGUL SYLLABLE NIEUN YO IEUNG
    case 0xB4A9: code_point = 0xB204; break; // HANGUL SYLLABLE NIEUN U
    case 0xB4AA: code_point = 0xB205; break; // HANGUL SYLLABLE NIEUN U KIYEOK
    case 0xB4AB: code_point = 0xB208; break; // HANGUL SYLLABLE NIEUN U NIEUN
    case 0xB4AC: code_point = 0xB20B; break; // HANGUL SYLLABLE NIEUN U TIKEUT
    case 0xB4AD: code_point = 0xB20C; break; // HANGUL SYLLABLE NIEUN U RIEUL
    case 0xB4AE: code_point = 0xB214; break; // HANGUL SYLLABLE NIEUN U MIEUM
    case 0xB4AF: code_point = 0xB215; break; // HANGUL SYLLABLE NIEUN U PIEUP
    case 0xB4B0: code_point = 0xB217; break; // HANGUL SYLLABLE NIEUN U SIOS
    case 0xB4B1: code_point = 0xB219; break; // HANGUL SYLLABLE NIEUN U IEUNG
    case 0xB4B2: code_point = 0xB220; break; // HANGUL SYLLABLE NIEUN WEO
    case 0xB4B3: code_point = 0xB234; break; // HANGUL SYLLABLE NIEUN WEO SSANGSIOS
    case 0xB4B4: code_point = 0xB23C; break; // HANGUL SYLLABLE NIEUN WE
    case 0xB4B5: code_point = 0xB258; break; // HANGUL SYLLABLE NIEUN WI
    case 0xB4B6: code_point = 0xB25C; break; // HANGUL SYLLABLE NIEUN WI NIEUN
    case 0xB4B7: code_point = 0xB260; break; // HANGUL SYLLABLE NIEUN WI RIEUL
    case 0xB4B8: code_point = 0xB268; break; // HANGUL SYLLABLE NIEUN WI MIEUM
    case 0xB4B9: code_point = 0xB269; break; // HANGUL SYLLABLE NIEUN WI PIEUP
    case 0xB4BA: code_point = 0xB274; break; // HANGUL SYLLABLE NIEUN YU
    case 0xB4BB: code_point = 0xB275; break; // HANGUL SYLLABLE NIEUN YU KIYEOK
    case 0xB4BC: code_point = 0xB27C; break; // HANGUL SYLLABLE NIEUN YU RIEUL
    case 0xB4BD: code_point = 0xB284; break; // HANGUL SYLLABLE NIEUN YU MIEUM
    case 0xB4BE: code_point = 0xB285; break; // HANGUL SYLLABLE NIEUN YU PIEUP
    case 0xB4BF: code_point = 0xB289; break; // HANGUL SYLLABLE NIEUN YU IEUNG
    case 0xB4C0: code_point = 0xB290; break; // HANGUL SYLLABLE NIEUN EU
    case 0xB4C1: code_point = 0xB291; break; // HANGUL SYLLABLE NIEUN EU KIYEOK
    case 0xB4C2: code_point = 0xB294; break; // HANGUL SYLLABLE NIEUN EU NIEUN
    case 0xB4C3: code_point = 0xB298; break; // HANGUL SYLLABLE NIEUN EU RIEUL
    case 0xB4C4: code_point = 0xB299; break; // HANGUL SYLLABLE NIEUN EU RIEULKIYEOK
    case 0xB4C5: code_point = 0xB29A; break; // HANGUL SYLLABLE NIEUN EU RIEULMIEUM
    case 0xB4C6: code_point = 0xB2A0; break; // HANGUL SYLLABLE NIEUN EU MIEUM
    case 0xB4C7: code_point = 0xB2A1; break; // HANGUL SYLLABLE NIEUN EU PIEUP
    case 0xB4C8: code_point = 0xB2A3; break; // HANGUL SYLLABLE NIEUN EU SIOS
    case 0xB4C9: code_point = 0xB2A5; break; // HANGUL SYLLABLE NIEUN EU IEUNG
    case 0xB4CA: code_point = 0xB2A6; break; // HANGUL SYLLABLE NIEUN EU CIEUC
    case 0xB4CB: code_point = 0xB2AA; break; // HANGUL SYLLABLE NIEUN EU PHIEUPH
    case 0xB4CC: code_point = 0xB2AC; break; // HANGUL SYLLABLE NIEUN YI
    case 0xB4CD: code_point = 0xB2B0; break; // HANGUL SYLLABLE NIEUN YI NIEUN
    case 0xB4CE: code_point = 0xB2B4; break; // HANGUL SYLLABLE NIEUN YI RIEUL
    case 0xB4CF: code_point = 0xB2C8; break; // HANGUL SYLLABLE NIEUN I
    case 0xB4D0: code_point = 0xB2C9; break; // HANGUL SYLLABLE NIEUN I KIYEOK
    case 0xB4D1: code_point = 0xB2CC; break; // HANGUL SYLLABLE NIEUN I NIEUN
    case 0xB4D2: code_point = 0xB2D0; break; // HANGUL SYLLABLE NIEUN I RIEUL
    case 0xB4D3: code_point = 0xB2D2; break; // HANGUL SYLLABLE NIEUN I RIEULMIEUM
    case 0xB4D4: code_point = 0xB2D8; break; // HANGUL SYLLABLE NIEUN I MIEUM
    case 0xB4D5: code_point = 0xB2D9; break; // HANGUL SYLLABLE NIEUN I PIEUP
    case 0xB4D6: code_point = 0xB2DB; break; // HANGUL SYLLABLE NIEUN I SIOS
    case 0xB4D7: code_point = 0xB2DD; break; // HANGUL SYLLABLE NIEUN I IEUNG
    case 0xB4D8: code_point = 0xB2E2; break; // HANGUL SYLLABLE NIEUN I PHIEUPH
    case 0xB4D9: code_point = 0xB2E4; break; // HANGUL SYLLABLE TIKEUT A
    case 0xB4DA: code_point = 0xB2E5; break; // HANGUL SYLLABLE TIKEUT A KIYEOK
    case 0xB4DB: code_point = 0xB2E6; break; // HANGUL SYLLABLE TIKEUT A SSANGKIYEOK
    case 0xB4DC: code_point = 0xB2E8; break; // HANGUL SYLLABLE TIKEUT A NIEUN
    case 0xB4DD: code_point = 0xB2EB; break; // HANGUL SYLLABLE TIKEUT A TIKEUT
    case 0xB4DE: code_point = 0xB2EC; break; // HANGUL SYLLABLE TIKEUT A RIEUL
    case 0xB4DF: code_point = 0xB2ED; break; // HANGUL SYLLABLE TIKEUT A RIEULKIYEOK
    case 0xB4E0: code_point = 0xB2EE; break; // HANGUL SYLLABLE TIKEUT A RIEULMIEUM
    case 0xB4E1: code_point = 0xB2EF; break; // HANGUL SYLLABLE TIKEUT A RIEULPIEUP
    case 0xB4E2: code_point = 0xB2F3; break; // HANGUL SYLLABLE TIKEUT A RIEULHIEUH
    case 0xB4E3: code_point = 0xB2F4; break; // HANGUL SYLLABLE TIKEUT A MIEUM
    case 0xB4E4: code_point = 0xB2F5; break; // HANGUL SYLLABLE TIKEUT A PIEUP
    case 0xB4E5: code_point = 0xB2F7; break; // HANGUL SYLLABLE TIKEUT A SIOS
    case 0xB4E6: code_point = 0xB2F8; break; // HANGUL SYLLABLE TIKEUT A SSANGSIOS
    case 0xB4E7: code_point = 0xB2F9; break; // HANGUL SYLLABLE TIKEUT A IEUNG
    case 0xB4E8: code_point = 0xB2FA; break; // HANGUL SYLLABLE TIKEUT A CIEUC
    case 0xB4E9: code_point = 0xB2FB; break; // HANGUL SYLLABLE TIKEUT A CHIEUCH
    case 0xB4EA: code_point = 0xB2FF; break; // HANGUL SYLLABLE TIKEUT A HIEUH
    case 0xB4EB: code_point = 0xB300; break; // HANGUL SYLLABLE TIKEUT AE
    case 0xB4EC: code_point = 0xB301; break; // HANGUL SYLLABLE TIKEUT AE KIYEOK
    case 0xB4ED: code_point = 0xB304; break; // HANGUL SYLLABLE TIKEUT AE NIEUN
    case 0xB4EE: code_point = 0xB308; break; // HANGUL SYLLABLE TIKEUT AE RIEUL
    case 0xB4EF: code_point = 0xB310; break; // HANGUL SYLLABLE TIKEUT AE MIEUM
    case 0xB4F0: code_point = 0xB311; break; // HANGUL SYLLABLE TIKEUT AE PIEUP
    case 0xB4F1: code_point = 0xB313; break; // HANGUL SYLLABLE TIKEUT AE SIOS
    case 0xB4F2: code_point = 0xB314; break; // HANGUL SYLLABLE TIKEUT AE SSANGSIOS
    case 0xB4F3: code_point = 0xB315; break; // HANGUL SYLLABLE TIKEUT AE IEUNG
    case 0xB4F4: code_point = 0xB31C; break; // HANGUL SYLLABLE TIKEUT YA
    case 0xB4F5: code_point = 0xB354; break; // HANGUL SYLLABLE TIKEUT EO
    case 0xB4F6: code_point = 0xB355; break; // HANGUL SYLLABLE TIKEUT EO KIYEOK
    case 0xB4F7: code_point = 0xB356; break; // HANGUL SYLLABLE TIKEUT EO SSANGKIYEOK
    case 0xB4F8: code_point = 0xB358; break; // HANGUL SYLLABLE TIKEUT EO NIEUN
    case 0xB4F9: code_point = 0xB35B; break; // HANGUL SYLLABLE TIKEUT EO TIKEUT
    case 0xB4FA: code_point = 0xB35C; break; // HANGUL SYLLABLE TIKEUT EO RIEUL
    case 0xB4FB: code_point = 0xB35E; break; // HANGUL SYLLABLE TIKEUT EO RIEULMIEUM
    case 0xB4FC: code_point = 0xB35F; break; // HANGUL SYLLABLE TIKEUT EO RIEULPIEUP
    case 0xB4FD: code_point = 0xB364; break; // HANGUL SYLLABLE TIKEUT EO MIEUM
    case 0xB4FE: code_point = 0xB365; break; // HANGUL SYLLABLE TIKEUT EO PIEUP
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB5(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB541: code_point = 0xD095; break; // HANGUL SYLLABLE KHIEUKH YI RIEULTHIEUTH
    case 0xB542: code_point = 0xD096; break; // HANGUL SYLLABLE KHIEUKH YI RIEULPHIEUPH
    case 0xB543: code_point = 0xD097; break; // HANGUL SYLLABLE KHIEUKH YI RIEULHIEUH
    case 0xB544: code_point = 0xD098; break; // HANGUL SYLLABLE KHIEUKH YI MIEUM
    case 0xB545: code_point = 0xD099; break; // HANGUL SYLLABLE KHIEUKH YI PIEUP
    case 0xB546: code_point = 0xD09A; break; // HANGUL SYLLABLE KHIEUKH YI PIEUPSIOS
    case 0xB547: code_point = 0xD09B; break; // HANGUL SYLLABLE KHIEUKH YI SIOS
    case 0xB548: code_point = 0xD09C; break; // HANGUL SYLLABLE KHIEUKH YI SSANGSIOS
    case 0xB549: code_point = 0xD09D; break; // HANGUL SYLLABLE KHIEUKH YI IEUNG
    case 0xB54A: code_point = 0xD09E; break; // HANGUL SYLLABLE KHIEUKH YI CIEUC
    case 0xB54B: code_point = 0xD09F; break; // HANGUL SYLLABLE KHIEUKH YI CHIEUCH
    case 0xB54C: code_point = 0xD0A0; break; // HANGUL SYLLABLE KHIEUKH YI KHIEUKH
    case 0xB54D: code_point = 0xD0A1; break; // HANGUL SYLLABLE KHIEUKH YI THIEUTH
    case 0xB54E: code_point = 0xD0A2; break; // HANGUL SYLLABLE KHIEUKH YI PHIEUPH
    case 0xB54F: code_point = 0xD0A3; break; // HANGUL SYLLABLE KHIEUKH YI HIEUH
    case 0xB550: code_point = 0xD0A6; break; // HANGUL SYLLABLE KHIEUKH I SSANGKIYEOK
    case 0xB551: code_point = 0xD0A7; break; // HANGUL SYLLABLE KHIEUKH I KIYEOKSIOS
    case 0xB552: code_point = 0xD0A9; break; // HANGUL SYLLABLE KHIEUKH I NIEUNCIEUC
    case 0xB553: code_point = 0xD0AA; break; // HANGUL SYLLABLE KHIEUKH I NIEUNHIEUH
    case 0xB554: code_point = 0xD0AB; break; // HANGUL SYLLABLE KHIEUKH I TIKEUT
    case 0xB555: code_point = 0xD0AD; break; // HANGUL SYLLABLE KHIEUKH I RIEULKIYEOK
    case 0xB556: code_point = 0xD0AE; break; // HANGUL SYLLABLE KHIEUKH I RIEULMIEUM
    case 0xB557: code_point = 0xD0AF; break; // HANGUL SYLLABLE KHIEUKH I RIEULPIEUP
    case 0xB558: code_point = 0xD0B0; break; // HANGUL SYLLABLE KHIEUKH I RIEULSIOS
    case 0xB559: code_point = 0xD0B1; break; // HANGUL SYLLABLE KHIEUKH I RIEULTHIEUTH
    case 0xB55A: code_point = 0xD0B2; break; // HANGUL SYLLABLE KHIEUKH I RIEULPHIEUPH
    case 0xB561: code_point = 0xD0B3; break; // HANGUL SYLLABLE KHIEUKH I RIEULHIEUH
    case 0xB562: code_point = 0xD0B6; break; // HANGUL SYLLABLE KHIEUKH I PIEUPSIOS
    case 0xB563: code_point = 0xD0B8; break; // HANGUL SYLLABLE KHIEUKH I SSANGSIOS
    case 0xB564: code_point = 0xD0BA; break; // HANGUL SYLLABLE KHIEUKH I CIEUC
    case 0xB565: code_point = 0xD0BB; break; // HANGUL SYLLABLE KHIEUKH I CHIEUCH
    case 0xB566: code_point = 0xD0BC; break; // HANGUL SYLLABLE KHIEUKH I KHIEUKH
    case 0xB567: code_point = 0xD0BD; break; // HANGUL SYLLABLE KHIEUKH I THIEUTH
    case 0xB568: code_point = 0xD0BE; break; // HANGUL SYLLABLE KHIEUKH I PHIEUPH
    case 0xB569: code_point = 0xD0BF; break; // HANGUL SYLLABLE KHIEUKH I HIEUH
    case 0xB56A: code_point = 0xD0C2; break; // HANGUL SYLLABLE THIEUTH A SSANGKIYEOK
    case 0xB56B: code_point = 0xD0C3; break; // HANGUL SYLLABLE THIEUTH A KIYEOKSIOS
    case 0xB56C: code_point = 0xD0C5; break; // HANGUL SYLLABLE THIEUTH A NIEUNCIEUC
    case 0xB56D: code_point = 0xD0C6; break; // HANGUL SYLLABLE THIEUTH A NIEUNHIEUH
    case 0xB56E: code_point = 0xD0C7; break; // HANGUL SYLLABLE THIEUTH A TIKEUT
    case 0xB56F: code_point = 0xD0CA; break; // HANGUL SYLLABLE THIEUTH A RIEULMIEUM
    case 0xB570: code_point = 0xD0CB; break; // HANGUL SYLLABLE THIEUTH A RIEULPIEUP
    case 0xB571: code_point = 0xD0CC; break; // HANGUL SYLLABLE THIEUTH A RIEULSIOS
    case 0xB572: code_point = 0xD0CD; break; // HANGUL SYLLABLE THIEUTH A RIEULTHIEUTH
    case 0xB573: code_point = 0xD0CE; break; // HANGUL SYLLABLE THIEUTH A RIEULPHIEUPH
    case 0xB574: code_point = 0xD0CF; break; // HANGUL SYLLABLE THIEUTH A RIEULHIEUH
    case 0xB575: code_point = 0xD0D2; break; // HANGUL SYLLABLE THIEUTH A PIEUPSIOS
    case 0xB576: code_point = 0xD0D6; break; // HANGUL SYLLABLE THIEUTH A CIEUC
    case 0xB577: code_point = 0xD0D7; break; // HANGUL SYLLABLE THIEUTH A CHIEUCH
    case 0xB578: code_point = 0xD0D8; break; // HANGUL SYLLABLE THIEUTH A KHIEUKH
    case 0xB579: code_point = 0xD0D9; break; // HANGUL SYLLABLE THIEUTH A THIEUTH
    case 0xB57A: code_point = 0xD0DA; break; // HANGUL SYLLABLE THIEUTH A PHIEUPH
    case 0xB581: code_point = 0xD0DB; break; // HANGUL SYLLABLE THIEUTH A HIEUH
    case 0xB582: code_point = 0xD0DE; break; // HANGUL SYLLABLE THIEUTH AE SSANGKIYEOK
    case 0xB583: code_point = 0xD0DF; break; // HANGUL SYLLABLE THIEUTH AE KIYEOKSIOS
    case 0xB584: code_point = 0xD0E1; break; // HANGUL SYLLABLE THIEUTH AE NIEUNCIEUC
    case 0xB585: code_point = 0xD0E2; break; // HANGUL SYLLABLE THIEUTH AE NIEUNHIEUH
    case 0xB586: code_point = 0xD0E3; break; // HANGUL SYLLABLE THIEUTH AE TIKEUT
    case 0xB587: code_point = 0xD0E5; break; // HANGUL SYLLABLE THIEUTH AE RIEULKIYEOK
    case 0xB588: code_point = 0xD0E6; break; // HANGUL SYLLABLE THIEUTH AE RIEULMIEUM
    case 0xB589: code_point = 0xD0E7; break; // HANGUL SYLLABLE THIEUTH AE RIEULPIEUP
    case 0xB58A: code_point = 0xD0E8; break; // HANGUL SYLLABLE THIEUTH AE RIEULSIOS
    case 0xB58B: code_point = 0xD0E9; break; // HANGUL SYLLABLE THIEUTH AE RIEULTHIEUTH
    case 0xB58C: code_point = 0xD0EA; break; // HANGUL SYLLABLE THIEUTH AE RIEULPHIEUPH
    case 0xB58D: code_point = 0xD0EB; break; // HANGUL SYLLABLE THIEUTH AE RIEULHIEUH
    case 0xB58E: code_point = 0xD0EE; break; // HANGUL SYLLABLE THIEUTH AE PIEUPSIOS
    case 0xB58F: code_point = 0xD0F2; break; // HANGUL SYLLABLE THIEUTH AE CIEUC
    case 0xB590: code_point = 0xD0F3; break; // HANGUL SYLLABLE THIEUTH AE CHIEUCH
    case 0xB591: code_point = 0xD0F4; break; // HANGUL SYLLABLE THIEUTH AE KHIEUKH
    case 0xB592: code_point = 0xD0F5; break; // HANGUL SYLLABLE THIEUTH AE THIEUTH
    case 0xB593: code_point = 0xD0F6; break; // HANGUL SYLLABLE THIEUTH AE PHIEUPH
    case 0xB594: code_point = 0xD0F7; break; // HANGUL SYLLABLE THIEUTH AE HIEUH
    case 0xB595: code_point = 0xD0F9; break; // HANGUL SYLLABLE THIEUTH YA KIYEOK
    case 0xB596: code_point = 0xD0FA; break; // HANGUL SYLLABLE THIEUTH YA SSANGKIYEOK
    case 0xB597: code_point = 0xD0FB; break; // HANGUL SYLLABLE THIEUTH YA KIYEOKSIOS
    case 0xB598: code_point = 0xD0FC; break; // HANGUL SYLLABLE THIEUTH YA NIEUN
    case 0xB599: code_point = 0xD0FD; break; // HANGUL SYLLABLE THIEUTH YA NIEUNCIEUC
    case 0xB59A: code_point = 0xD0FE; break; // HANGUL SYLLABLE THIEUTH YA NIEUNHIEUH
    case 0xB59B: code_point = 0xD0FF; break; // HANGUL SYLLABLE THIEUTH YA TIKEUT
    case 0xB59C: code_point = 0xD100; break; // HANGUL SYLLABLE THIEUTH YA RIEUL
    case 0xB59D: code_point = 0xD101; break; // HANGUL SYLLABLE THIEUTH YA RIEULKIYEOK
    case 0xB59E: code_point = 0xD102; break; // HANGUL SYLLABLE THIEUTH YA RIEULMIEUM
    case 0xB59F: code_point = 0xD103; break; // HANGUL SYLLABLE THIEUTH YA RIEULPIEUP
    case 0xB5A0: code_point = 0xD104; break; // HANGUL SYLLABLE THIEUTH YA RIEULSIOS
    case 0xB5A1: code_point = 0xB367; break; // HANGUL SYLLABLE TIKEUT EO SIOS
    case 0xB5A2: code_point = 0xB369; break; // HANGUL SYLLABLE TIKEUT EO IEUNG
    case 0xB5A3: code_point = 0xB36B; break; // HANGUL SYLLABLE TIKEUT EO CHIEUCH
    case 0xB5A4: code_point = 0xB36E; break; // HANGUL SYLLABLE TIKEUT EO PHIEUPH
    case 0xB5A5: code_point = 0xB370; break; // HANGUL SYLLABLE TIKEUT E
    case 0xB5A6: code_point = 0xB371; break; // HANGUL SYLLABLE TIKEUT E KIYEOK
    case 0xB5A7: code_point = 0xB374; break; // HANGUL SYLLABLE TIKEUT E NIEUN
    case 0xB5A8: code_point = 0xB378; break; // HANGUL SYLLABLE TIKEUT E RIEUL
    case 0xB5A9: code_point = 0xB380; break; // HANGUL SYLLABLE TIKEUT E MIEUM
    case 0xB5AA: code_point = 0xB381; break; // HANGUL SYLLABLE TIKEUT E PIEUP
    case 0xB5AB: code_point = 0xB383; break; // HANGUL SYLLABLE TIKEUT E SIOS
    case 0xB5AC: code_point = 0xB384; break; // HANGUL SYLLABLE TIKEUT E SSANGSIOS
    case 0xB5AD: code_point = 0xB385; break; // HANGUL SYLLABLE TIKEUT E IEUNG
    case 0xB5AE: code_point = 0xB38C; break; // HANGUL SYLLABLE TIKEUT YEO
    case 0xB5AF: code_point = 0xB390; break; // HANGUL SYLLABLE TIKEUT YEO NIEUN
    case 0xB5B0: code_point = 0xB394; break; // HANGUL SYLLABLE TIKEUT YEO RIEUL
    case 0xB5B1: code_point = 0xB3A0; break; // HANGUL SYLLABLE TIKEUT YEO SSANGSIOS
    case 0xB5B2: code_point = 0xB3A1; break; // HANGUL SYLLABLE TIKEUT YEO IEUNG
    case 0xB5B3: code_point = 0xB3A8; break; // HANGUL SYLLABLE TIKEUT YE
    case 0xB5B4: code_point = 0xB3AC; break; // HANGUL SYLLABLE TIKEUT YE NIEUN
    case 0xB5B5: code_point = 0xB3C4; break; // HANGUL SYLLABLE TIKEUT O
    case 0xB5B6: code_point = 0xB3C5; break; // HANGUL SYLLABLE TIKEUT O KIYEOK
    case 0xB5B7: code_point = 0xB3C8; break; // HANGUL SYLLABLE TIKEUT O NIEUN
    case 0xB5B8: code_point = 0xB3CB; break; // HANGUL SYLLABLE TIKEUT O TIKEUT
    case 0xB5B9: code_point = 0xB3CC; break; // HANGUL SYLLABLE TIKEUT O RIEUL
    case 0xB5BA: code_point = 0xB3CE; break; // HANGUL SYLLABLE TIKEUT O RIEULMIEUM
    case 0xB5BB: code_point = 0xB3D0; break; // HANGUL SYLLABLE TIKEUT O RIEULSIOS
    case 0xB5BC: code_point = 0xB3D4; break; // HANGUL SYLLABLE TIKEUT O MIEUM
    case 0xB5BD: code_point = 0xB3D5; break; // HANGUL SYLLABLE TIKEUT O PIEUP
    case 0xB5BE: code_point = 0xB3D7; break; // HANGUL SYLLABLE TIKEUT O SIOS
    case 0xB5BF: code_point = 0xB3D9; break; // HANGUL SYLLABLE TIKEUT O IEUNG
    case 0xB5C0: code_point = 0xB3DB; break; // HANGUL SYLLABLE TIKEUT O CHIEUCH
    case 0xB5C1: code_point = 0xB3DD; break; // HANGUL SYLLABLE TIKEUT O THIEUTH
    case 0xB5C2: code_point = 0xB3E0; break; // HANGUL SYLLABLE TIKEUT WA
    case 0xB5C3: code_point = 0xB3E4; break; // HANGUL SYLLABLE TIKEUT WA NIEUN
    case 0xB5C4: code_point = 0xB3E8; break; // HANGUL SYLLABLE TIKEUT WA RIEUL
    case 0xB5C5: code_point = 0xB3FC; break; // HANGUL SYLLABLE TIKEUT WAE
    case 0xB5C6: code_point = 0xB410; break; // HANGUL SYLLABLE TIKEUT WAE SSANGSIOS
    case 0xB5C7: code_point = 0xB418; break; // HANGUL SYLLABLE TIKEUT OE
    case 0xB5C8: code_point = 0xB41C; break; // HANGUL SYLLABLE TIKEUT OE NIEUN
    case 0xB5C9: code_point = 0xB420; break; // HANGUL SYLLABLE TIKEUT OE RIEUL
    case 0xB5CA: code_point = 0xB428; break; // HANGUL SYLLABLE TIKEUT OE MIEUM
    case 0xB5CB: code_point = 0xB429; break; // HANGUL SYLLABLE TIKEUT OE PIEUP
    case 0xB5CC: code_point = 0xB42B; break; // HANGUL SYLLABLE TIKEUT OE SIOS
    case 0xB5CD: code_point = 0xB434; break; // HANGUL SYLLABLE TIKEUT YO
    case 0xB5CE: code_point = 0xB450; break; // HANGUL SYLLABLE TIKEUT U
    case 0xB5CF: code_point = 0xB451; break; // HANGUL SYLLABLE TIKEUT U KIYEOK
    case 0xB5D0: code_point = 0xB454; break; // HANGUL SYLLABLE TIKEUT U NIEUN
    case 0xB5D1: code_point = 0xB458; break; // HANGUL SYLLABLE TIKEUT U RIEUL
    case 0xB5D2: code_point = 0xB460; break; // HANGUL SYLLABLE TIKEUT U MIEUM
    case 0xB5D3: code_point = 0xB461; break; // HANGUL SYLLABLE TIKEUT U PIEUP
    case 0xB5D4: code_point = 0xB463; break; // HANGUL SYLLABLE TIKEUT U SIOS
    case 0xB5D5: code_point = 0xB465; break; // HANGUL SYLLABLE TIKEUT U IEUNG
    case 0xB5D6: code_point = 0xB46C; break; // HANGUL SYLLABLE TIKEUT WEO
    case 0xB5D7: code_point = 0xB480; break; // HANGUL SYLLABLE TIKEUT WEO SSANGSIOS
    case 0xB5D8: code_point = 0xB488; break; // HANGUL SYLLABLE TIKEUT WE
    case 0xB5D9: code_point = 0xB49D; break; // HANGUL SYLLABLE TIKEUT WE IEUNG
    case 0xB5DA: code_point = 0xB4A4; break; // HANGUL SYLLABLE TIKEUT WI
    case 0xB5DB: code_point = 0xB4A8; break; // HANGUL SYLLABLE TIKEUT WI NIEUN
    case 0xB5DC: code_point = 0xB4AC; break; // HANGUL SYLLABLE TIKEUT WI RIEUL
    case 0xB5DD: code_point = 0xB4B5; break; // HANGUL SYLLABLE TIKEUT WI PIEUP
    case 0xB5DE: code_point = 0xB4B7; break; // HANGUL SYLLABLE TIKEUT WI SIOS
    case 0xB5DF: code_point = 0xB4B9; break; // HANGUL SYLLABLE TIKEUT WI IEUNG
    case 0xB5E0: code_point = 0xB4C0; break; // HANGUL SYLLABLE TIKEUT YU
    case 0xB5E1: code_point = 0xB4C4; break; // HANGUL SYLLABLE TIKEUT YU NIEUN
    case 0xB5E2: code_point = 0xB4C8; break; // HANGUL SYLLABLE TIKEUT YU RIEUL
    case 0xB5E3: code_point = 0xB4D0; break; // HANGUL SYLLABLE TIKEUT YU MIEUM
    case 0xB5E4: code_point = 0xB4D5; break; // HANGUL SYLLABLE TIKEUT YU IEUNG
    case 0xB5E5: code_point = 0xB4DC; break; // HANGUL SYLLABLE TIKEUT EU
    case 0xB5E6: code_point = 0xB4DD; break; // HANGUL SYLLABLE TIKEUT EU KIYEOK
    case 0xB5E7: code_point = 0xB4E0; break; // HANGUL SYLLABLE TIKEUT EU NIEUN
    case 0xB5E8: code_point = 0xB4E3; break; // HANGUL SYLLABLE TIKEUT EU TIKEUT
    case 0xB5E9: code_point = 0xB4E4; break; // HANGUL SYLLABLE TIKEUT EU RIEUL
    case 0xB5EA: code_point = 0xB4E6; break; // HANGUL SYLLABLE TIKEUT EU RIEULMIEUM
    case 0xB5EB: code_point = 0xB4EC; break; // HANGUL SYLLABLE TIKEUT EU MIEUM
    case 0xB5EC: code_point = 0xB4ED; break; // HANGUL SYLLABLE TIKEUT EU PIEUP
    case 0xB5ED: code_point = 0xB4EF; break; // HANGUL SYLLABLE TIKEUT EU SIOS
    case 0xB5EE: code_point = 0xB4F1; break; // HANGUL SYLLABLE TIKEUT EU IEUNG
    case 0xB5EF: code_point = 0xB4F8; break; // HANGUL SYLLABLE TIKEUT YI
    case 0xB5F0: code_point = 0xB514; break; // HANGUL SYLLABLE TIKEUT I
    case 0xB5F1: code_point = 0xB515; break; // HANGUL SYLLABLE TIKEUT I KIYEOK
    case 0xB5F2: code_point = 0xB518; break; // HANGUL SYLLABLE TIKEUT I NIEUN
    case 0xB5F3: code_point = 0xB51B; break; // HANGUL SYLLABLE TIKEUT I TIKEUT
    case 0xB5F4: code_point = 0xB51C; break; // HANGUL SYLLABLE TIKEUT I RIEUL
    case 0xB5F5: code_point = 0xB524; break; // HANGUL SYLLABLE TIKEUT I MIEUM
    case 0xB5F6: code_point = 0xB525; break; // HANGUL SYLLABLE TIKEUT I PIEUP
    case 0xB5F7: code_point = 0xB527; break; // HANGUL SYLLABLE TIKEUT I SIOS
    case 0xB5F8: code_point = 0xB528; break; // HANGUL SYLLABLE TIKEUT I SSANGSIOS
    case 0xB5F9: code_point = 0xB529; break; // HANGUL SYLLABLE TIKEUT I IEUNG
    case 0xB5FA: code_point = 0xB52A; break; // HANGUL SYLLABLE TIKEUT I CIEUC
    case 0xB5FB: code_point = 0xB530; break; // HANGUL SYLLABLE SSANGTIKEUT A
    case 0xB5FC: code_point = 0xB531; break; // HANGUL SYLLABLE SSANGTIKEUT A KIYEOK
    case 0xB5FD: code_point = 0xB534; break; // HANGUL SYLLABLE SSANGTIKEUT A NIEUN
    case 0xB5FE: code_point = 0xB538; break; // HANGUL SYLLABLE SSANGTIKEUT A RIEUL
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB6(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB641: code_point = 0xD105; break; // HANGUL SYLLABLE THIEUTH YA RIEULTHIEUTH
    case 0xB642: code_point = 0xD106; break; // HANGUL SYLLABLE THIEUTH YA RIEULPHIEUPH
    case 0xB643: code_point = 0xD107; break; // HANGUL SYLLABLE THIEUTH YA RIEULHIEUH
    case 0xB644: code_point = 0xD108; break; // HANGUL SYLLABLE THIEUTH YA MIEUM
    case 0xB645: code_point = 0xD109; break; // HANGUL SYLLABLE THIEUTH YA PIEUP
    case 0xB646: code_point = 0xD10A; break; // HANGUL SYLLABLE THIEUTH YA PIEUPSIOS
    case 0xB647: code_point = 0xD10B; break; // HANGUL SYLLABLE THIEUTH YA SIOS
    case 0xB648: code_point = 0xD10C; break; // HANGUL SYLLABLE THIEUTH YA SSANGSIOS
    case 0xB649: code_point = 0xD10E; break; // HANGUL SYLLABLE THIEUTH YA CIEUC
    case 0xB64A: code_point = 0xD10F; break; // HANGUL SYLLABLE THIEUTH YA CHIEUCH
    case 0xB64B: code_point = 0xD110; break; // HANGUL SYLLABLE THIEUTH YA KHIEUKH
    case 0xB64C: code_point = 0xD111; break; // HANGUL SYLLABLE THIEUTH YA THIEUTH
    case 0xB64D: code_point = 0xD112; break; // HANGUL SYLLABLE THIEUTH YA PHIEUPH
    case 0xB64E: code_point = 0xD113; break; // HANGUL SYLLABLE THIEUTH YA HIEUH
    case 0xB64F: code_point = 0xD114; break; // HANGUL SYLLABLE THIEUTH YAE
    case 0xB650: code_point = 0xD115; break; // HANGUL SYLLABLE THIEUTH YAE KIYEOK
    case 0xB651: code_point = 0xD116; break; // HANGUL SYLLABLE THIEUTH YAE SSANGKIYEOK
    case 0xB652: code_point = 0xD117; break; // HANGUL SYLLABLE THIEUTH YAE KIYEOKSIOS
    case 0xB653: code_point = 0xD118; break; // HANGUL SYLLABLE THIEUTH YAE NIEUN
    case 0xB654: code_point = 0xD119; break; // HANGUL SYLLABLE THIEUTH YAE NIEUNCIEUC
    case 0xB655: code_point = 0xD11A; break; // HANGUL SYLLABLE THIEUTH YAE NIEUNHIEUH
    case 0xB656: code_point = 0xD11B; break; // HANGUL SYLLABLE THIEUTH YAE TIKEUT
    case 0xB657: code_point = 0xD11C; break; // HANGUL SYLLABLE THIEUTH YAE RIEUL
    case 0xB658: code_point = 0xD11D; break; // HANGUL SYLLABLE THIEUTH YAE RIEULKIYEOK
    case 0xB659: code_point = 0xD11E; break; // HANGUL SYLLABLE THIEUTH YAE RIEULMIEUM
    case 0xB65A: code_point = 0xD11F; break; // HANGUL SYLLABLE THIEUTH YAE RIEULPIEUP
    case 0xB661: code_point = 0xD120; break; // HANGUL SYLLABLE THIEUTH YAE RIEULSIOS
    case 0xB662: code_point = 0xD121; break; // HANGUL SYLLABLE THIEUTH YAE RIEULTHIEUTH
    case 0xB663: code_point = 0xD122; break; // HANGUL SYLLABLE THIEUTH YAE RIEULPHIEUPH
    case 0xB664: code_point = 0xD123; break; // HANGUL SYLLABLE THIEUTH YAE RIEULHIEUH
    case 0xB665: code_point = 0xD124; break; // HANGUL SYLLABLE THIEUTH YAE MIEUM
    case 0xB666: code_point = 0xD125; break; // HANGUL SYLLABLE THIEUTH YAE PIEUP
    case 0xB667: code_point = 0xD126; break; // HANGUL SYLLABLE THIEUTH YAE PIEUPSIOS
    case 0xB668: code_point = 0xD127; break; // HANGUL SYLLABLE THIEUTH YAE SIOS
    case 0xB669: code_point = 0xD128; break; // HANGUL SYLLABLE THIEUTH YAE SSANGSIOS
    case 0xB66A: code_point = 0xD129; break; // HANGUL SYLLABLE THIEUTH YAE IEUNG
    case 0xB66B: code_point = 0xD12A; break; // HANGUL SYLLABLE THIEUTH YAE CIEUC
    case 0xB66C: code_point = 0xD12B; break; // HANGUL SYLLABLE THIEUTH YAE CHIEUCH
    case 0xB66D: code_point = 0xD12C; break; // HANGUL SYLLABLE THIEUTH YAE KHIEUKH
    case 0xB66E: code_point = 0xD12D; break; // HANGUL SYLLABLE THIEUTH YAE THIEUTH
    case 0xB66F: code_point = 0xD12E; break; // HANGUL SYLLABLE THIEUTH YAE PHIEUPH
    case 0xB670: code_point = 0xD12F; break; // HANGUL SYLLABLE THIEUTH YAE HIEUH
    case 0xB671: code_point = 0xD132; break; // HANGUL SYLLABLE THIEUTH EO SSANGKIYEOK
    case 0xB672: code_point = 0xD133; break; // HANGUL SYLLABLE THIEUTH EO KIYEOKSIOS
    case 0xB673: code_point = 0xD135; break; // HANGUL SYLLABLE THIEUTH EO NIEUNCIEUC
    case 0xB674: code_point = 0xD136; break; // HANGUL SYLLABLE THIEUTH EO NIEUNHIEUH
    case 0xB675: code_point = 0xD137; break; // HANGUL SYLLABLE THIEUTH EO TIKEUT
    case 0xB676: code_point = 0xD139; break; // HANGUL SYLLABLE THIEUTH EO RIEULKIYEOK
    case 0xB677: code_point = 0xD13B; break; // HANGUL SYLLABLE THIEUTH EO RIEULPIEUP
    case 0xB678: code_point = 0xD13C; break; // HANGUL SYLLABLE THIEUTH EO RIEULSIOS
    case 0xB679: code_point = 0xD13D; break; // HANGUL SYLLABLE THIEUTH EO RIEULTHIEUTH
    case 0xB67A: code_point = 0xD13E; break; // HANGUL SYLLABLE THIEUTH EO RIEULPHIEUPH
    case 0xB681: code_point = 0xD13F; break; // HANGUL SYLLABLE THIEUTH EO RIEULHIEUH
    case 0xB682: code_point = 0xD142; break; // HANGUL SYLLABLE THIEUTH EO PIEUPSIOS
    case 0xB683: code_point = 0xD146; break; // HANGUL SYLLABLE THIEUTH EO CIEUC
    case 0xB684: code_point = 0xD147; break; // HANGUL SYLLABLE THIEUTH EO CHIEUCH
    case 0xB685: code_point = 0xD148; break; // HANGUL SYLLABLE THIEUTH EO KHIEUKH
    case 0xB686: code_point = 0xD149; break; // HANGUL SYLLABLE THIEUTH EO THIEUTH
    case 0xB687: code_point = 0xD14A; break; // HANGUL SYLLABLE THIEUTH EO PHIEUPH
    case 0xB688: code_point = 0xD14B; break; // HANGUL SYLLABLE THIEUTH EO HIEUH
    case 0xB689: code_point = 0xD14E; break; // HANGUL SYLLABLE THIEUTH E SSANGKIYEOK
    case 0xB68A: code_point = 0xD14F; break; // HANGUL SYLLABLE THIEUTH E KIYEOKSIOS
    case 0xB68B: code_point = 0xD151; break; // HANGUL SYLLABLE THIEUTH E NIEUNCIEUC
    case 0xB68C: code_point = 0xD152; break; // HANGUL SYLLABLE THIEUTH E NIEUNHIEUH
    case 0xB68D: code_point = 0xD153; break; // HANGUL SYLLABLE THIEUTH E TIKEUT
    case 0xB68E: code_point = 0xD155; break; // HANGUL SYLLABLE THIEUTH E RIEULKIYEOK
    case 0xB68F: code_point = 0xD156; break; // HANGUL SYLLABLE THIEUTH E RIEULMIEUM
    case 0xB690: code_point = 0xD157; break; // HANGUL SYLLABLE THIEUTH E RIEULPIEUP
    case 0xB691: code_point = 0xD158; break; // HANGUL SYLLABLE THIEUTH E RIEULSIOS
    case 0xB692: code_point = 0xD159; break; // HANGUL SYLLABLE THIEUTH E RIEULTHIEUTH
    case 0xB693: code_point = 0xD15A; break; // HANGUL SYLLABLE THIEUTH E RIEULPHIEUPH
    case 0xB694: code_point = 0xD15B; break; // HANGUL SYLLABLE THIEUTH E RIEULHIEUH
    case 0xB695: code_point = 0xD15E; break; // HANGUL SYLLABLE THIEUTH E PIEUPSIOS
    case 0xB696: code_point = 0xD160; break; // HANGUL SYLLABLE THIEUTH E SSANGSIOS
    case 0xB697: code_point = 0xD162; break; // HANGUL SYLLABLE THIEUTH E CIEUC
    case 0xB698: code_point = 0xD163; break; // HANGUL SYLLABLE THIEUTH E CHIEUCH
    case 0xB699: code_point = 0xD164; break; // HANGUL SYLLABLE THIEUTH E KHIEUKH
    case 0xB69A: code_point = 0xD165; break; // HANGUL SYLLABLE THIEUTH E THIEUTH
    case 0xB69B: code_point = 0xD166; break; // HANGUL SYLLABLE THIEUTH E PHIEUPH
    case 0xB69C: code_point = 0xD167; break; // HANGUL SYLLABLE THIEUTH E HIEUH
    case 0xB69D: code_point = 0xD169; break; // HANGUL SYLLABLE THIEUTH YEO KIYEOK
    case 0xB69E: code_point = 0xD16A; break; // HANGUL SYLLABLE THIEUTH YEO SSANGKIYEOK
    case 0xB69F: code_point = 0xD16B; break; // HANGUL SYLLABLE THIEUTH YEO KIYEOKSIOS
    case 0xB6A0: code_point = 0xD16D; break; // HANGUL SYLLABLE THIEUTH YEO NIEUNCIEUC
    case 0xB6A1: code_point = 0xB540; break; // HANGUL SYLLABLE SSANGTIKEUT A MIEUM
    case 0xB6A2: code_point = 0xB541; break; // HANGUL SYLLABLE SSANGTIKEUT A PIEUP
    case 0xB6A3: code_point = 0xB543; break; // HANGUL SYLLABLE SSANGTIKEUT A SIOS
    case 0xB6A4: code_point = 0xB544; break; // HANGUL SYLLABLE SSANGTIKEUT A SSANGSIOS
    case 0xB6A5: code_point = 0xB545; break; // HANGUL SYLLABLE SSANGTIKEUT A IEUNG
    case 0xB6A6: code_point = 0xB54B; break; // HANGUL SYLLABLE SSANGTIKEUT A HIEUH
    case 0xB6A7: code_point = 0xB54C; break; // HANGUL SYLLABLE SSANGTIKEUT AE
    case 0xB6A8: code_point = 0xB54D; break; // HANGUL SYLLABLE SSANGTIKEUT AE KIYEOK
    case 0xB6A9: code_point = 0xB550; break; // HANGUL SYLLABLE SSANGTIKEUT AE NIEUN
    case 0xB6AA: code_point = 0xB554; break; // HANGUL SYLLABLE SSANGTIKEUT AE RIEUL
    case 0xB6AB: code_point = 0xB55C; break; // HANGUL SYLLABLE SSANGTIKEUT AE MIEUM
    case 0xB6AC: code_point = 0xB55D; break; // HANGUL SYLLABLE SSANGTIKEUT AE PIEUP
    case 0xB6AD: code_point = 0xB55F; break; // HANGUL SYLLABLE SSANGTIKEUT AE SIOS
    case 0xB6AE: code_point = 0xB560; break; // HANGUL SYLLABLE SSANGTIKEUT AE SSANGSIOS
    case 0xB6AF: code_point = 0xB561; break; // HANGUL SYLLABLE SSANGTIKEUT AE IEUNG
    case 0xB6B0: code_point = 0xB5A0; break; // HANGUL SYLLABLE SSANGTIKEUT EO
    case 0xB6B1: code_point = 0xB5A1; break; // HANGUL SYLLABLE SSANGTIKEUT EO KIYEOK
    case 0xB6B2: code_point = 0xB5A4; break; // HANGUL SYLLABLE SSANGTIKEUT EO NIEUN
    case 0xB6B3: code_point = 0xB5A8; break; // HANGUL SYLLABLE SSANGTIKEUT EO RIEUL
    case 0xB6B4: code_point = 0xB5AA; break; // HANGUL SYLLABLE SSANGTIKEUT EO RIEULMIEUM
    case 0xB6B5: code_point = 0xB5AB; break; // HANGUL SYLLABLE SSANGTIKEUT EO RIEULPIEUP
    case 0xB6B6: code_point = 0xB5B0; break; // HANGUL SYLLABLE SSANGTIKEUT EO MIEUM
    case 0xB6B7: code_point = 0xB5B1; break; // HANGUL SYLLABLE SSANGTIKEUT EO PIEUP
    case 0xB6B8: code_point = 0xB5B3; break; // HANGUL SYLLABLE SSANGTIKEUT EO SIOS
    case 0xB6B9: code_point = 0xB5B4; break; // HANGUL SYLLABLE SSANGTIKEUT EO SSANGSIOS
    case 0xB6BA: code_point = 0xB5B5; break; // HANGUL SYLLABLE SSANGTIKEUT EO IEUNG
    case 0xB6BB: code_point = 0xB5BB; break; // HANGUL SYLLABLE SSANGTIKEUT EO HIEUH
    case 0xB6BC: code_point = 0xB5BC; break; // HANGUL SYLLABLE SSANGTIKEUT E
    case 0xB6BD: code_point = 0xB5BD; break; // HANGUL SYLLABLE SSANGTIKEUT E KIYEOK
    case 0xB6BE: code_point = 0xB5C0; break; // HANGUL SYLLABLE SSANGTIKEUT E NIEUN
    case 0xB6BF: code_point = 0xB5C4; break; // HANGUL SYLLABLE SSANGTIKEUT E RIEUL
    case 0xB6C0: code_point = 0xB5CC; break; // HANGUL SYLLABLE SSANGTIKEUT E MIEUM
    case 0xB6C1: code_point = 0xB5CD; break; // HANGUL SYLLABLE SSANGTIKEUT E PIEUP
    case 0xB6C2: code_point = 0xB5CF; break; // HANGUL SYLLABLE SSANGTIKEUT E SIOS
    case 0xB6C3: code_point = 0xB5D0; break; // HANGUL SYLLABLE SSANGTIKEUT E SSANGSIOS
    case 0xB6C4: code_point = 0xB5D1; break; // HANGUL SYLLABLE SSANGTIKEUT E IEUNG
    case 0xB6C5: code_point = 0xB5D8; break; // HANGUL SYLLABLE SSANGTIKEUT YEO
    case 0xB6C6: code_point = 0xB5EC; break; // HANGUL SYLLABLE SSANGTIKEUT YEO SSANGSIOS
    case 0xB6C7: code_point = 0xB610; break; // HANGUL SYLLABLE SSANGTIKEUT O
    case 0xB6C8: code_point = 0xB611; break; // HANGUL SYLLABLE SSANGTIKEUT O KIYEOK
    case 0xB6C9: code_point = 0xB614; break; // HANGUL SYLLABLE SSANGTIKEUT O NIEUN
    case 0xB6CA: code_point = 0xB618; break; // HANGUL SYLLABLE SSANGTIKEUT O RIEUL
    case 0xB6CB: code_point = 0xB625; break; // HANGUL SYLLABLE SSANGTIKEUT O IEUNG
    case 0xB6CC: code_point = 0xB62C; break; // HANGUL SYLLABLE SSANGTIKEUT WA
    case 0xB6CD: code_point = 0xB634; break; // HANGUL SYLLABLE SSANGTIKEUT WA RIEUL
    case 0xB6CE: code_point = 0xB648; break; // HANGUL SYLLABLE SSANGTIKEUT WAE
    case 0xB6CF: code_point = 0xB664; break; // HANGUL SYLLABLE SSANGTIKEUT OE
    case 0xB6D0: code_point = 0xB668; break; // HANGUL SYLLABLE SSANGTIKEUT OE NIEUN
    case 0xB6D1: code_point = 0xB69C; break; // HANGUL SYLLABLE SSANGTIKEUT U
    case 0xB6D2: code_point = 0xB69D; break; // HANGUL SYLLABLE SSANGTIKEUT U KIYEOK
    case 0xB6D3: code_point = 0xB6A0; break; // HANGUL SYLLABLE SSANGTIKEUT U NIEUN
    case 0xB6D4: code_point = 0xB6A4; break; // HANGUL SYLLABLE SSANGTIKEUT U RIEUL
    case 0xB6D5: code_point = 0xB6AB; break; // HANGUL SYLLABLE SSANGTIKEUT U RIEULHIEUH
    case 0xB6D6: code_point = 0xB6AC; break; // HANGUL SYLLABLE SSANGTIKEUT U MIEUM
    case 0xB6D7: code_point = 0xB6B1; break; // HANGUL SYLLABLE SSANGTIKEUT U IEUNG
    case 0xB6D8: code_point = 0xB6D4; break; // HANGUL SYLLABLE SSANGTIKEUT WE
    case 0xB6D9: code_point = 0xB6F0; break; // HANGUL SYLLABLE SSANGTIKEUT WI
    case 0xB6DA: code_point = 0xB6F4; break; // HANGUL SYLLABLE SSANGTIKEUT WI NIEUN
    case 0xB6DB: code_point = 0xB6F8; break; // HANGUL SYLLABLE SSANGTIKEUT WI RIEUL
    case 0xB6DC: code_point = 0xB700; break; // HANGUL SYLLABLE SSANGTIKEUT WI MIEUM
    case 0xB6DD: code_point = 0xB701; break; // HANGUL SYLLABLE SSANGTIKEUT WI PIEUP
    case 0xB6DE: code_point = 0xB705; break; // HANGUL SYLLABLE SSANGTIKEUT WI IEUNG
    case 0xB6DF: code_point = 0xB728; break; // HANGUL SYLLABLE SSANGTIKEUT EU
    case 0xB6E0: code_point = 0xB729; break; // HANGUL SYLLABLE SSANGTIKEUT EU KIYEOK
    case 0xB6E1: code_point = 0xB72C; break; // HANGUL SYLLABLE SSANGTIKEUT EU NIEUN
    case 0xB6E2: code_point = 0xB72F; break; // HANGUL SYLLABLE SSANGTIKEUT EU TIKEUT
    case 0xB6E3: code_point = 0xB730; break; // HANGUL SYLLABLE SSANGTIKEUT EU RIEUL
    case 0xB6E4: code_point = 0xB738; break; // HANGUL SYLLABLE SSANGTIKEUT EU MIEUM
    case 0xB6E5: code_point = 0xB739; break; // HANGUL SYLLABLE SSANGTIKEUT EU PIEUP
    case 0xB6E6: code_point = 0xB73B; break; // HANGUL SYLLABLE SSANGTIKEUT EU SIOS
    case 0xB6E7: code_point = 0xB744; break; // HANGUL SYLLABLE SSANGTIKEUT YI
    case 0xB6E8: code_point = 0xB748; break; // HANGUL SYLLABLE SSANGTIKEUT YI NIEUN
    case 0xB6E9: code_point = 0xB74C; break; // HANGUL SYLLABLE SSANGTIKEUT YI RIEUL
    case 0xB6EA: code_point = 0xB754; break; // HANGUL SYLLABLE SSANGTIKEUT YI MIEUM
    case 0xB6EB: code_point = 0xB755; break; // HANGUL SYLLABLE SSANGTIKEUT YI PIEUP
    case 0xB6EC: code_point = 0xB760; break; // HANGUL SYLLABLE SSANGTIKEUT I
    case 0xB6ED: code_point = 0xB764; break; // HANGUL SYLLABLE SSANGTIKEUT I NIEUN
    case 0xB6EE: code_point = 0xB768; break; // HANGUL SYLLABLE SSANGTIKEUT I RIEUL
    case 0xB6EF: code_point = 0xB770; break; // HANGUL SYLLABLE SSANGTIKEUT I MIEUM
    case 0xB6F0: code_point = 0xB771; break; // HANGUL SYLLABLE SSANGTIKEUT I PIEUP
    case 0xB6F1: code_point = 0xB773; break; // HANGUL SYLLABLE SSANGTIKEUT I SIOS
    case 0xB6F2: code_point = 0xB775; break; // HANGUL SYLLABLE SSANGTIKEUT I IEUNG
    case 0xB6F3: code_point = 0xB77C; break; // HANGUL SYLLABLE RIEUL A
    case 0xB6F4: code_point = 0xB77D; break; // HANGUL SYLLABLE RIEUL A KIYEOK
    case 0xB6F5: code_point = 0xB780; break; // HANGUL SYLLABLE RIEUL A NIEUN
    case 0xB6F6: code_point = 0xB784; break; // HANGUL SYLLABLE RIEUL A RIEUL
    case 0xB6F7: code_point = 0xB78C; break; // HANGUL SYLLABLE RIEUL A MIEUM
    case 0xB6F8: code_point = 0xB78D; break; // HANGUL SYLLABLE RIEUL A PIEUP
    case 0xB6F9: code_point = 0xB78F; break; // HANGUL SYLLABLE RIEUL A SIOS
    case 0xB6FA: code_point = 0xB790; break; // HANGUL SYLLABLE RIEUL A SSANGSIOS
    case 0xB6FB: code_point = 0xB791; break; // HANGUL SYLLABLE RIEUL A IEUNG
    case 0xB6FC: code_point = 0xB792; break; // HANGUL SYLLABLE RIEUL A CIEUC
    case 0xB6FD: code_point = 0xB796; break; // HANGUL SYLLABLE RIEUL A PHIEUPH
    case 0xB6FE: code_point = 0xB797; break; // HANGUL SYLLABLE RIEUL A HIEUH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB7(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB741: code_point = 0xD16E; break; // HANGUL SYLLABLE THIEUTH YEO NIEUNHIEUH
    case 0xB742: code_point = 0xD16F; break; // HANGUL SYLLABLE THIEUTH YEO TIKEUT
    case 0xB743: code_point = 0xD170; break; // HANGUL SYLLABLE THIEUTH YEO RIEUL
    case 0xB744: code_point = 0xD171; break; // HANGUL SYLLABLE THIEUTH YEO RIEULKIYEOK
    case 0xB745: code_point = 0xD172; break; // HANGUL SYLLABLE THIEUTH YEO RIEULMIEUM
    case 0xB746: code_point = 0xD173; break; // HANGUL SYLLABLE THIEUTH YEO RIEULPIEUP
    case 0xB747: code_point = 0xD174; break; // HANGUL SYLLABLE THIEUTH YEO RIEULSIOS
    case 0xB748: code_point = 0xD175; break; // HANGUL SYLLABLE THIEUTH YEO RIEULTHIEUTH
    case 0xB749: code_point = 0xD176; break; // HANGUL SYLLABLE THIEUTH YEO RIEULPHIEUPH
    case 0xB74A: code_point = 0xD177; break; // HANGUL SYLLABLE THIEUTH YEO RIEULHIEUH
    case 0xB74B: code_point = 0xD178; break; // HANGUL SYLLABLE THIEUTH YEO MIEUM
    case 0xB74C: code_point = 0xD179; break; // HANGUL SYLLABLE THIEUTH YEO PIEUP
    case 0xB74D: code_point = 0xD17A; break; // HANGUL SYLLABLE THIEUTH YEO PIEUPSIOS
    case 0xB74E: code_point = 0xD17B; break; // HANGUL SYLLABLE THIEUTH YEO SIOS
    case 0xB74F: code_point = 0xD17D; break; // HANGUL SYLLABLE THIEUTH YEO IEUNG
    case 0xB750: code_point = 0xD17E; break; // HANGUL SYLLABLE THIEUTH YEO CIEUC
    case 0xB751: code_point = 0xD17F; break; // HANGUL SYLLABLE THIEUTH YEO CHIEUCH
    case 0xB752: code_point = 0xD180; break; // HANGUL SYLLABLE THIEUTH YEO KHIEUKH
    case 0xB753: code_point = 0xD181; break; // HANGUL SYLLABLE THIEUTH YEO THIEUTH
    case 0xB754: code_point = 0xD182; break; // HANGUL SYLLABLE THIEUTH YEO PHIEUPH
    case 0xB755: code_point = 0xD183; break; // HANGUL SYLLABLE THIEUTH YEO HIEUH
    case 0xB756: code_point = 0xD185; break; // HANGUL SYLLABLE THIEUTH YE KIYEOK
    case 0xB757: code_point = 0xD186; break; // HANGUL SYLLABLE THIEUTH YE SSANGKIYEOK
    case 0xB758: code_point = 0xD187; break; // HANGUL SYLLABLE THIEUTH YE KIYEOKSIOS
    case 0xB759: code_point = 0xD189; break; // HANGUL SYLLABLE THIEUTH YE NIEUNCIEUC
    case 0xB75A: code_point = 0xD18A; break; // HANGUL SYLLABLE THIEUTH YE NIEUNHIEUH
    case 0xB761: code_point = 0xD18B; break; // HANGUL SYLLABLE THIEUTH YE TIKEUT
    case 0xB762: code_point = 0xD18C; break; // HANGUL SYLLABLE THIEUTH YE RIEUL
    case 0xB763: code_point = 0xD18D; break; // HANGUL SYLLABLE THIEUTH YE RIEULKIYEOK
    case 0xB764: code_point = 0xD18E; break; // HANGUL SYLLABLE THIEUTH YE RIEULMIEUM
    case 0xB765: code_point = 0xD18F; break; // HANGUL SYLLABLE THIEUTH YE RIEULPIEUP
    case 0xB766: code_point = 0xD190; break; // HANGUL SYLLABLE THIEUTH YE RIEULSIOS
    case 0xB767: code_point = 0xD191; break; // HANGUL SYLLABLE THIEUTH YE RIEULTHIEUTH
    case 0xB768: code_point = 0xD192; break; // HANGUL SYLLABLE THIEUTH YE RIEULPHIEUPH
    case 0xB769: code_point = 0xD193; break; // HANGUL SYLLABLE THIEUTH YE RIEULHIEUH
    case 0xB76A: code_point = 0xD194; break; // HANGUL SYLLABLE THIEUTH YE MIEUM
    case 0xB76B: code_point = 0xD195; break; // HANGUL SYLLABLE THIEUTH YE PIEUP
    case 0xB76C: code_point = 0xD196; break; // HANGUL SYLLABLE THIEUTH YE PIEUPSIOS
    case 0xB76D: code_point = 0xD197; break; // HANGUL SYLLABLE THIEUTH YE SIOS
    case 0xB76E: code_point = 0xD198; break; // HANGUL SYLLABLE THIEUTH YE SSANGSIOS
    case 0xB76F: code_point = 0xD199; break; // HANGUL SYLLABLE THIEUTH YE IEUNG
    case 0xB770: code_point = 0xD19A; break; // HANGUL SYLLABLE THIEUTH YE CIEUC
    case 0xB771: code_point = 0xD19B; break; // HANGUL SYLLABLE THIEUTH YE CHIEUCH
    case 0xB772: code_point = 0xD19C; break; // HANGUL SYLLABLE THIEUTH YE KHIEUKH
    case 0xB773: code_point = 0xD19D; break; // HANGUL SYLLABLE THIEUTH YE THIEUTH
    case 0xB774: code_point = 0xD19E; break; // HANGUL SYLLABLE THIEUTH YE PHIEUPH
    case 0xB775: code_point = 0xD19F; break; // HANGUL SYLLABLE THIEUTH YE HIEUH
    case 0xB776: code_point = 0xD1A2; break; // HANGUL SYLLABLE THIEUTH O SSANGKIYEOK
    case 0xB777: code_point = 0xD1A3; break; // HANGUL SYLLABLE THIEUTH O KIYEOKSIOS
    case 0xB778: code_point = 0xD1A5; break; // HANGUL SYLLABLE THIEUTH O NIEUNCIEUC
    case 0xB779: code_point = 0xD1A6; break; // HANGUL SYLLABLE THIEUTH O NIEUNHIEUH
    case 0xB77A: code_point = 0xD1A7; break; // HANGUL SYLLABLE THIEUTH O TIKEUT
    case 0xB781: code_point = 0xD1A9; break; // HANGUL SYLLABLE THIEUTH O RIEULKIYEOK
    case 0xB782: code_point = 0xD1AA; break; // HANGUL SYLLABLE THIEUTH O RIEULMIEUM
    case 0xB783: code_point = 0xD1AB; break; // HANGUL SYLLABLE THIEUTH O RIEULPIEUP
    case 0xB784: code_point = 0xD1AC; break; // HANGUL SYLLABLE THIEUTH O RIEULSIOS
    case 0xB785: code_point = 0xD1AD; break; // HANGUL SYLLABLE THIEUTH O RIEULTHIEUTH
    case 0xB786: code_point = 0xD1AE; break; // HANGUL SYLLABLE THIEUTH O RIEULPHIEUPH
    case 0xB787: code_point = 0xD1AF; break; // HANGUL SYLLABLE THIEUTH O RIEULHIEUH
    case 0xB788: code_point = 0xD1B2; break; // HANGUL SYLLABLE THIEUTH O PIEUPSIOS
    case 0xB789: code_point = 0xD1B4; break; // HANGUL SYLLABLE THIEUTH O SSANGSIOS
    case 0xB78A: code_point = 0xD1B6; break; // HANGUL SYLLABLE THIEUTH O CIEUC
    case 0xB78B: code_point = 0xD1B7; break; // HANGUL SYLLABLE THIEUTH O CHIEUCH
    case 0xB78C: code_point = 0xD1B8; break; // HANGUL SYLLABLE THIEUTH O KHIEUKH
    case 0xB78D: code_point = 0xD1B9; break; // HANGUL SYLLABLE THIEUTH O THIEUTH
    case 0xB78E: code_point = 0xD1BB; break; // HANGUL SYLLABLE THIEUTH O HIEUH
    case 0xB78F: code_point = 0xD1BD; break; // HANGUL SYLLABLE THIEUTH WA KIYEOK
    case 0xB790: code_point = 0xD1BE; break; // HANGUL SYLLABLE THIEUTH WA SSANGKIYEOK
    case 0xB791: code_point = 0xD1BF; break; // HANGUL SYLLABLE THIEUTH WA KIYEOKSIOS
    case 0xB792: code_point = 0xD1C1; break; // HANGUL SYLLABLE THIEUTH WA NIEUNCIEUC
    case 0xB793: code_point = 0xD1C2; break; // HANGUL SYLLABLE THIEUTH WA NIEUNHIEUH
    case 0xB794: code_point = 0xD1C3; break; // HANGUL SYLLABLE THIEUTH WA TIKEUT
    case 0xB795: code_point = 0xD1C4; break; // HANGUL SYLLABLE THIEUTH WA RIEUL
    case 0xB796: code_point = 0xD1C5; break; // HANGUL SYLLABLE THIEUTH WA RIEULKIYEOK
    case 0xB797: code_point = 0xD1C6; break; // HANGUL SYLLABLE THIEUTH WA RIEULMIEUM
    case 0xB798: code_point = 0xD1C7; break; // HANGUL SYLLABLE THIEUTH WA RIEULPIEUP
    case 0xB799: code_point = 0xD1C8; break; // HANGUL SYLLABLE THIEUTH WA RIEULSIOS
    case 0xB79A: code_point = 0xD1C9; break; // HANGUL SYLLABLE THIEUTH WA RIEULTHIEUTH
    case 0xB79B: code_point = 0xD1CA; break; // HANGUL SYLLABLE THIEUTH WA RIEULPHIEUPH
    case 0xB79C: code_point = 0xD1CB; break; // HANGUL SYLLABLE THIEUTH WA RIEULHIEUH
    case 0xB79D: code_point = 0xD1CC; break; // HANGUL SYLLABLE THIEUTH WA MIEUM
    case 0xB79E: code_point = 0xD1CD; break; // HANGUL SYLLABLE THIEUTH WA PIEUP
    case 0xB79F: code_point = 0xD1CE; break; // HANGUL SYLLABLE THIEUTH WA PIEUPSIOS
    case 0xB7A0: code_point = 0xD1CF; break; // HANGUL SYLLABLE THIEUTH WA SIOS
    case 0xB7A1: code_point = 0xB798; break; // HANGUL SYLLABLE RIEUL AE
    case 0xB7A2: code_point = 0xB799; break; // HANGUL SYLLABLE RIEUL AE KIYEOK
    case 0xB7A3: code_point = 0xB79C; break; // HANGUL SYLLABLE RIEUL AE NIEUN
    case 0xB7A4: code_point = 0xB7A0; break; // HANGUL SYLLABLE RIEUL AE RIEUL
    case 0xB7A5: code_point = 0xB7A8; break; // HANGUL SYLLABLE RIEUL AE MIEUM
    case 0xB7A6: code_point = 0xB7A9; break; // HANGUL SYLLABLE RIEUL AE PIEUP
    case 0xB7A7: code_point = 0xB7AB; break; // HANGUL SYLLABLE RIEUL AE SIOS
    case 0xB7A8: code_point = 0xB7AC; break; // HANGUL SYLLABLE RIEUL AE SSANGSIOS
    case 0xB7A9: code_point = 0xB7AD; break; // HANGUL SYLLABLE RIEUL AE IEUNG
    case 0xB7AA: code_point = 0xB7B4; break; // HANGUL SYLLABLE RIEUL YA
    case 0xB7AB: code_point = 0xB7B5; break; // HANGUL SYLLABLE RIEUL YA KIYEOK
    case 0xB7AC: code_point = 0xB7B8; break; // HANGUL SYLLABLE RIEUL YA NIEUN
    case 0xB7AD: code_point = 0xB7C7; break; // HANGUL SYLLABLE RIEUL YA SIOS
    case 0xB7AE: code_point = 0xB7C9; break; // HANGUL SYLLABLE RIEUL YA IEUNG
    case 0xB7AF: code_point = 0xB7EC; break; // HANGUL SYLLABLE RIEUL EO
    case 0xB7B0: code_point = 0xB7ED; break; // HANGUL SYLLABLE RIEUL EO KIYEOK
    case 0xB7B1: code_point = 0xB7F0; break; // HANGUL SYLLABLE RIEUL EO NIEUN
    case 0xB7B2: code_point = 0xB7F4; break; // HANGUL SYLLABLE RIEUL EO RIEUL
    case 0xB7B3: code_point = 0xB7FC; break; // HANGUL SYLLABLE RIEUL EO MIEUM
    case 0xB7B4: code_point = 0xB7FD; break; // HANGUL SYLLABLE RIEUL EO PIEUP
    case 0xB7B5: code_point = 0xB7FF; break; // HANGUL SYLLABLE RIEUL EO SIOS
    case 0xB7B6: code_point = 0xB800; break; // HANGUL SYLLABLE RIEUL EO SSANGSIOS
    case 0xB7B7: code_point = 0xB801; break; // HANGUL SYLLABLE RIEUL EO IEUNG
    case 0xB7B8: code_point = 0xB807; break; // HANGUL SYLLABLE RIEUL EO HIEUH
    case 0xB7B9: code_point = 0xB808; break; // HANGUL SYLLABLE RIEUL E
    case 0xB7BA: code_point = 0xB809; break; // HANGUL SYLLABLE RIEUL E KIYEOK
    case 0xB7BB: code_point = 0xB80C; break; // HANGUL SYLLABLE RIEUL E NIEUN
    case 0xB7BC: code_point = 0xB810; break; // HANGUL SYLLABLE RIEUL E RIEUL
    case 0xB7BD: code_point = 0xB818; break; // HANGUL SYLLABLE RIEUL E MIEUM
    case 0xB7BE: code_point = 0xB819; break; // HANGUL SYLLABLE RIEUL E PIEUP
    case 0xB7BF: code_point = 0xB81B; break; // HANGUL SYLLABLE RIEUL E SIOS
    case 0xB7C0: code_point = 0xB81D; break; // HANGUL SYLLABLE RIEUL E IEUNG
    case 0xB7C1: code_point = 0xB824; break; // HANGUL SYLLABLE RIEUL YEO
    case 0xB7C2: code_point = 0xB825; break; // HANGUL SYLLABLE RIEUL YEO KIYEOK
    case 0xB7C3: code_point = 0xB828; break; // HANGUL SYLLABLE RIEUL YEO NIEUN
    case 0xB7C4: code_point = 0xB82C; break; // HANGUL SYLLABLE RIEUL YEO RIEUL
    case 0xB7C5: code_point = 0xB834; break; // HANGUL SYLLABLE RIEUL YEO MIEUM
    case 0xB7C6: code_point = 0xB835; break; // HANGUL SYLLABLE RIEUL YEO PIEUP
    case 0xB7C7: code_point = 0xB837; break; // HANGUL SYLLABLE RIEUL YEO SIOS
    case 0xB7C8: code_point = 0xB838; break; // HANGUL SYLLABLE RIEUL YEO SSANGSIOS
    case 0xB7C9: code_point = 0xB839; break; // HANGUL SYLLABLE RIEUL YEO IEUNG
    case 0xB7CA: code_point = 0xB840; break; // HANGUL SYLLABLE RIEUL YE
    case 0xB7CB: code_point = 0xB844; break; // HANGUL SYLLABLE RIEUL YE NIEUN
    case 0xB7CC: code_point = 0xB851; break; // HANGUL SYLLABLE RIEUL YE PIEUP
    case 0xB7CD: code_point = 0xB853; break; // HANGUL SYLLABLE RIEUL YE SIOS
    case 0xB7CE: code_point = 0xB85C; break; // HANGUL SYLLABLE RIEUL O
    case 0xB7CF: code_point = 0xB85D; break; // HANGUL SYLLABLE RIEUL O KIYEOK
    case 0xB7D0: code_point = 0xB860; break; // HANGUL SYLLABLE RIEUL O NIEUN
    case 0xB7D1: code_point = 0xB864; break; // HANGUL SYLLABLE RIEUL O RIEUL
    case 0xB7D2: code_point = 0xB86C; break; // HANGUL SYLLABLE RIEUL O MIEUM
    case 0xB7D3: code_point = 0xB86D; break; // HANGUL SYLLABLE RIEUL O PIEUP
    case 0xB7D4: code_point = 0xB86F; break; // HANGUL SYLLABLE RIEUL O SIOS
    case 0xB7D5: code_point = 0xB871; break; // HANGUL SYLLABLE RIEUL O IEUNG
    case 0xB7D6: code_point = 0xB878; break; // HANGUL SYLLABLE RIEUL WA
    case 0xB7D7: code_point = 0xB87C; break; // HANGUL SYLLABLE RIEUL WA NIEUN
    case 0xB7D8: code_point = 0xB88D; break; // HANGUL SYLLABLE RIEUL WA IEUNG
    case 0xB7D9: code_point = 0xB8A8; break; // HANGUL SYLLABLE RIEUL WAE SSANGSIOS
    case 0xB7DA: code_point = 0xB8B0; break; // HANGUL SYLLABLE RIEUL OE
    case 0xB7DB: code_point = 0xB8B4; break; // HANGUL SYLLABLE RIEUL OE NIEUN
    case 0xB7DC: code_point = 0xB8B8; break; // HANGUL SYLLABLE RIEUL OE RIEUL
    case 0xB7DD: code_point = 0xB8C0; break; // HANGUL SYLLABLE RIEUL OE MIEUM
    case 0xB7DE: code_point = 0xB8C1; break; // HANGUL SYLLABLE RIEUL OE PIEUP
    case 0xB7DF: code_point = 0xB8C3; break; // HANGUL SYLLABLE RIEUL OE SIOS
    case 0xB7E0: code_point = 0xB8C5; break; // HANGUL SYLLABLE RIEUL OE IEUNG
    case 0xB7E1: code_point = 0xB8CC; break; // HANGUL SYLLABLE RIEUL YO
    case 0xB7E2: code_point = 0xB8D0; break; // HANGUL SYLLABLE RIEUL YO NIEUN
    case 0xB7E3: code_point = 0xB8D4; break; // HANGUL SYLLABLE RIEUL YO RIEUL
    case 0xB7E4: code_point = 0xB8DD; break; // HANGUL SYLLABLE RIEUL YO PIEUP
    case 0xB7E5: code_point = 0xB8DF; break; // HANGUL SYLLABLE RIEUL YO SIOS
    case 0xB7E6: code_point = 0xB8E1; break; // HANGUL SYLLABLE RIEUL YO IEUNG
    case 0xB7E7: code_point = 0xB8E8; break; // HANGUL SYLLABLE RIEUL U
    case 0xB7E8: code_point = 0xB8E9; break; // HANGUL SYLLABLE RIEUL U KIYEOK
    case 0xB7E9: code_point = 0xB8EC; break; // HANGUL SYLLABLE RIEUL U NIEUN
    case 0xB7EA: code_point = 0xB8F0; break; // HANGUL SYLLABLE RIEUL U RIEUL
    case 0xB7EB: code_point = 0xB8F8; break; // HANGUL SYLLABLE RIEUL U MIEUM
    case 0xB7EC: code_point = 0xB8F9; break; // HANGUL SYLLABLE RIEUL U PIEUP
    case 0xB7ED: code_point = 0xB8FB; break; // HANGUL SYLLABLE RIEUL U SIOS
    case 0xB7EE: code_point = 0xB8FD; break; // HANGUL SYLLABLE RIEUL U IEUNG
    case 0xB7EF: code_point = 0xB904; break; // HANGUL SYLLABLE RIEUL WEO
    case 0xB7F0: code_point = 0xB918; break; // HANGUL SYLLABLE RIEUL WEO SSANGSIOS
    case 0xB7F1: code_point = 0xB920; break; // HANGUL SYLLABLE RIEUL WE
    case 0xB7F2: code_point = 0xB93C; break; // HANGUL SYLLABLE RIEUL WI
    case 0xB7F3: code_point = 0xB93D; break; // HANGUL SYLLABLE RIEUL WI KIYEOK
    case 0xB7F4: code_point = 0xB940; break; // HANGUL SYLLABLE RIEUL WI NIEUN
    case 0xB7F5: code_point = 0xB944; break; // HANGUL SYLLABLE RIEUL WI RIEUL
    case 0xB7F6: code_point = 0xB94C; break; // HANGUL SYLLABLE RIEUL WI MIEUM
    case 0xB7F7: code_point = 0xB94F; break; // HANGUL SYLLABLE RIEUL WI SIOS
    case 0xB7F8: code_point = 0xB951; break; // HANGUL SYLLABLE RIEUL WI IEUNG
    case 0xB7F9: code_point = 0xB958; break; // HANGUL SYLLABLE RIEUL YU
    case 0xB7FA: code_point = 0xB959; break; // HANGUL SYLLABLE RIEUL YU KIYEOK
    case 0xB7FB: code_point = 0xB95C; break; // HANGUL SYLLABLE RIEUL YU NIEUN
    case 0xB7FC: code_point = 0xB960; break; // HANGUL SYLLABLE RIEUL YU RIEUL
    case 0xB7FD: code_point = 0xB968; break; // HANGUL SYLLABLE RIEUL YU MIEUM
    case 0xB7FE: code_point = 0xB969; break; // HANGUL SYLLABLE RIEUL YU PIEUP
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB8(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB841: code_point = 0xD1D0; break; // HANGUL SYLLABLE THIEUTH WA SSANGSIOS
    case 0xB842: code_point = 0xD1D1; break; // HANGUL SYLLABLE THIEUTH WA IEUNG
    case 0xB843: code_point = 0xD1D2; break; // HANGUL SYLLABLE THIEUTH WA CIEUC
    case 0xB844: code_point = 0xD1D3; break; // HANGUL SYLLABLE THIEUTH WA CHIEUCH
    case 0xB845: code_point = 0xD1D4; break; // HANGUL SYLLABLE THIEUTH WA KHIEUKH
    case 0xB846: code_point = 0xD1D5; break; // HANGUL SYLLABLE THIEUTH WA THIEUTH
    case 0xB847: code_point = 0xD1D6; break; // HANGUL SYLLABLE THIEUTH WA PHIEUPH
    case 0xB848: code_point = 0xD1D7; break; // HANGUL SYLLABLE THIEUTH WA HIEUH
    case 0xB849: code_point = 0xD1D9; break; // HANGUL SYLLABLE THIEUTH WAE KIYEOK
    case 0xB84A: code_point = 0xD1DA; break; // HANGUL SYLLABLE THIEUTH WAE SSANGKIYEOK
    case 0xB84B: code_point = 0xD1DB; break; // HANGUL SYLLABLE THIEUTH WAE KIYEOKSIOS
    case 0xB84C: code_point = 0xD1DC; break; // HANGUL SYLLABLE THIEUTH WAE NIEUN
    case 0xB84D: code_point = 0xD1DD; break; // HANGUL SYLLABLE THIEUTH WAE NIEUNCIEUC
    case 0xB84E: code_point = 0xD1DE; break; // HANGUL SYLLABLE THIEUTH WAE NIEUNHIEUH
    case 0xB84F: code_point = 0xD1DF; break; // HANGUL SYLLABLE THIEUTH WAE TIKEUT
    case 0xB850: code_point = 0xD1E0; break; // HANGUL SYLLABLE THIEUTH WAE RIEUL
    case 0xB851: code_point = 0xD1E1; break; // HANGUL SYLLABLE THIEUTH WAE RIEULKIYEOK
    case 0xB852: code_point = 0xD1E2; break; // HANGUL SYLLABLE THIEUTH WAE RIEULMIEUM
    case 0xB853: code_point = 0xD1E3; break; // HANGUL SYLLABLE THIEUTH WAE RIEULPIEUP
    case 0xB854: code_point = 0xD1E4; break; // HANGUL SYLLABLE THIEUTH WAE RIEULSIOS
    case 0xB855: code_point = 0xD1E5; break; // HANGUL SYLLABLE THIEUTH WAE RIEULTHIEUTH
    case 0xB856: code_point = 0xD1E6; break; // HANGUL SYLLABLE THIEUTH WAE RIEULPHIEUPH
    case 0xB857: code_point = 0xD1E7; break; // HANGUL SYLLABLE THIEUTH WAE RIEULHIEUH
    case 0xB858: code_point = 0xD1E8; break; // HANGUL SYLLABLE THIEUTH WAE MIEUM
    case 0xB859: code_point = 0xD1E9; break; // HANGUL SYLLABLE THIEUTH WAE PIEUP
    case 0xB85A: code_point = 0xD1EA; break; // HANGUL SYLLABLE THIEUTH WAE PIEUPSIOS
    case 0xB861: code_point = 0xD1EB; break; // HANGUL SYLLABLE THIEUTH WAE SIOS
    case 0xB862: code_point = 0xD1EC; break; // HANGUL SYLLABLE THIEUTH WAE SSANGSIOS
    case 0xB863: code_point = 0xD1ED; break; // HANGUL SYLLABLE THIEUTH WAE IEUNG
    case 0xB864: code_point = 0xD1EE; break; // HANGUL SYLLABLE THIEUTH WAE CIEUC
    case 0xB865: code_point = 0xD1EF; break; // HANGUL SYLLABLE THIEUTH WAE CHIEUCH
    case 0xB866: code_point = 0xD1F0; break; // HANGUL SYLLABLE THIEUTH WAE KHIEUKH
    case 0xB867: code_point = 0xD1F1; break; // HANGUL SYLLABLE THIEUTH WAE THIEUTH
    case 0xB868: code_point = 0xD1F2; break; // HANGUL SYLLABLE THIEUTH WAE PHIEUPH
    case 0xB869: code_point = 0xD1F3; break; // HANGUL SYLLABLE THIEUTH WAE HIEUH
    case 0xB86A: code_point = 0xD1F5; break; // HANGUL SYLLABLE THIEUTH OE KIYEOK
    case 0xB86B: code_point = 0xD1F6; break; // HANGUL SYLLABLE THIEUTH OE SSANGKIYEOK
    case 0xB86C: code_point = 0xD1F7; break; // HANGUL SYLLABLE THIEUTH OE KIYEOKSIOS
    case 0xB86D: code_point = 0xD1F9; break; // HANGUL SYLLABLE THIEUTH OE NIEUNCIEUC
    case 0xB86E: code_point = 0xD1FA; break; // HANGUL SYLLABLE THIEUTH OE NIEUNHIEUH
    case 0xB86F: code_point = 0xD1FB; break; // HANGUL SYLLABLE THIEUTH OE TIKEUT
    case 0xB870: code_point = 0xD1FC; break; // HANGUL SYLLABLE THIEUTH OE RIEUL
    case 0xB871: code_point = 0xD1FD; break; // HANGUL SYLLABLE THIEUTH OE RIEULKIYEOK
    case 0xB872: code_point = 0xD1FE; break; // HANGUL SYLLABLE THIEUTH OE RIEULMIEUM
    case 0xB873: code_point = 0xD1FF; break; // HANGUL SYLLABLE THIEUTH OE RIEULPIEUP
    case 0xB874: code_point = 0xD200; break; // HANGUL SYLLABLE THIEUTH OE RIEULSIOS
    case 0xB875: code_point = 0xD201; break; // HANGUL SYLLABLE THIEUTH OE RIEULTHIEUTH
    case 0xB876: code_point = 0xD202; break; // HANGUL SYLLABLE THIEUTH OE RIEULPHIEUPH
    case 0xB877: code_point = 0xD203; break; // HANGUL SYLLABLE THIEUTH OE RIEULHIEUH
    case 0xB878: code_point = 0xD204; break; // HANGUL SYLLABLE THIEUTH OE MIEUM
    case 0xB879: code_point = 0xD205; break; // HANGUL SYLLABLE THIEUTH OE PIEUP
    case 0xB87A: code_point = 0xD206; break; // HANGUL SYLLABLE THIEUTH OE PIEUPSIOS
    case 0xB881: code_point = 0xD208; break; // HANGUL SYLLABLE THIEUTH OE SSANGSIOS
    case 0xB882: code_point = 0xD20A; break; // HANGUL SYLLABLE THIEUTH OE CIEUC
    case 0xB883: code_point = 0xD20B; break; // HANGUL SYLLABLE THIEUTH OE CHIEUCH
    case 0xB884: code_point = 0xD20C; break; // HANGUL SYLLABLE THIEUTH OE KHIEUKH
    case 0xB885: code_point = 0xD20D; break; // HANGUL SYLLABLE THIEUTH OE THIEUTH
    case 0xB886: code_point = 0xD20E; break; // HANGUL SYLLABLE THIEUTH OE PHIEUPH
    case 0xB887: code_point = 0xD20F; break; // HANGUL SYLLABLE THIEUTH OE HIEUH
    case 0xB888: code_point = 0xD211; break; // HANGUL SYLLABLE THIEUTH YO KIYEOK
    case 0xB889: code_point = 0xD212; break; // HANGUL SYLLABLE THIEUTH YO SSANGKIYEOK
    case 0xB88A: code_point = 0xD213; break; // HANGUL SYLLABLE THIEUTH YO KIYEOKSIOS
    case 0xB88B: code_point = 0xD214; break; // HANGUL SYLLABLE THIEUTH YO NIEUN
    case 0xB88C: code_point = 0xD215; break; // HANGUL SYLLABLE THIEUTH YO NIEUNCIEUC
    case 0xB88D: code_point = 0xD216; break; // HANGUL SYLLABLE THIEUTH YO NIEUNHIEUH
    case 0xB88E: code_point = 0xD217; break; // HANGUL SYLLABLE THIEUTH YO TIKEUT
    case 0xB88F: code_point = 0xD218; break; // HANGUL SYLLABLE THIEUTH YO RIEUL
    case 0xB890: code_point = 0xD219; break; // HANGUL SYLLABLE THIEUTH YO RIEULKIYEOK
    case 0xB891: code_point = 0xD21A; break; // HANGUL SYLLABLE THIEUTH YO RIEULMIEUM
    case 0xB892: code_point = 0xD21B; break; // HANGUL SYLLABLE THIEUTH YO RIEULPIEUP
    case 0xB893: code_point = 0xD21C; break; // HANGUL SYLLABLE THIEUTH YO RIEULSIOS
    case 0xB894: code_point = 0xD21D; break; // HANGUL SYLLABLE THIEUTH YO RIEULTHIEUTH
    case 0xB895: code_point = 0xD21E; break; // HANGUL SYLLABLE THIEUTH YO RIEULPHIEUPH
    case 0xB896: code_point = 0xD21F; break; // HANGUL SYLLABLE THIEUTH YO RIEULHIEUH
    case 0xB897: code_point = 0xD220; break; // HANGUL SYLLABLE THIEUTH YO MIEUM
    case 0xB898: code_point = 0xD221; break; // HANGUL SYLLABLE THIEUTH YO PIEUP
    case 0xB899: code_point = 0xD222; break; // HANGUL SYLLABLE THIEUTH YO PIEUPSIOS
    case 0xB89A: code_point = 0xD223; break; // HANGUL SYLLABLE THIEUTH YO SIOS
    case 0xB89B: code_point = 0xD224; break; // HANGUL SYLLABLE THIEUTH YO SSANGSIOS
    case 0xB89C: code_point = 0xD225; break; // HANGUL SYLLABLE THIEUTH YO IEUNG
    case 0xB89D: code_point = 0xD226; break; // HANGUL SYLLABLE THIEUTH YO CIEUC
    case 0xB89E: code_point = 0xD227; break; // HANGUL SYLLABLE THIEUTH YO CHIEUCH
    case 0xB89F: code_point = 0xD228; break; // HANGUL SYLLABLE THIEUTH YO KHIEUKH
    case 0xB8A0: code_point = 0xD229; break; // HANGUL SYLLABLE THIEUTH YO THIEUTH
    case 0xB8A1: code_point = 0xB96B; break; // HANGUL SYLLABLE RIEUL YU SIOS
    case 0xB8A2: code_point = 0xB96D; break; // HANGUL SYLLABLE RIEUL YU IEUNG
    case 0xB8A3: code_point = 0xB974; break; // HANGUL SYLLABLE RIEUL EU
    case 0xB8A4: code_point = 0xB975; break; // HANGUL SYLLABLE RIEUL EU KIYEOK
    case 0xB8A5: code_point = 0xB978; break; // HANGUL SYLLABLE RIEUL EU NIEUN
    case 0xB8A6: code_point = 0xB97C; break; // HANGUL SYLLABLE RIEUL EU RIEUL
    case 0xB8A7: code_point = 0xB984; break; // HANGUL SYLLABLE RIEUL EU MIEUM
    case 0xB8A8: code_point = 0xB985; break; // HANGUL SYLLABLE RIEUL EU PIEUP
    case 0xB8A9: code_point = 0xB987; break; // HANGUL SYLLABLE RIEUL EU SIOS
    case 0xB8AA: code_point = 0xB989; break; // HANGUL SYLLABLE RIEUL EU IEUNG
    case 0xB8AB: code_point = 0xB98A; break; // HANGUL SYLLABLE RIEUL EU CIEUC
    case 0xB8AC: code_point = 0xB98D; break; // HANGUL SYLLABLE RIEUL EU THIEUTH
    case 0xB8AD: code_point = 0xB98E; break; // HANGUL SYLLABLE RIEUL EU PHIEUPH
    case 0xB8AE: code_point = 0xB9AC; break; // HANGUL SYLLABLE RIEUL I
    case 0xB8AF: code_point = 0xB9AD; break; // HANGUL SYLLABLE RIEUL I KIYEOK
    case 0xB8B0: code_point = 0xB9B0; break; // HANGUL SYLLABLE RIEUL I NIEUN
    case 0xB8B1: code_point = 0xB9B4; break; // HANGUL SYLLABLE RIEUL I RIEUL
    case 0xB8B2: code_point = 0xB9BC; break; // HANGUL SYLLABLE RIEUL I MIEUM
    case 0xB8B3: code_point = 0xB9BD; break; // HANGUL SYLLABLE RIEUL I PIEUP
    case 0xB8B4: code_point = 0xB9BF; break; // HANGUL SYLLABLE RIEUL I SIOS
    case 0xB8B5: code_point = 0xB9C1; break; // HANGUL SYLLABLE RIEUL I IEUNG
    case 0xB8B6: code_point = 0xB9C8; break; // HANGUL SYLLABLE MIEUM A
    case 0xB8B7: code_point = 0xB9C9; break; // HANGUL SYLLABLE MIEUM A KIYEOK
    case 0xB8B8: code_point = 0xB9CC; break; // HANGUL SYLLABLE MIEUM A NIEUN
    case 0xB8B9: code_point = 0xB9CE; break; // HANGUL SYLLABLE MIEUM A NIEUNHIEUH
    case 0xB8BA: code_point = 0xB9CF; break; // HANGUL SYLLABLE MIEUM A TIKEUT
    case 0xB8BB: code_point = 0xB9D0; break; // HANGUL SYLLABLE MIEUM A RIEUL
    case 0xB8BC: code_point = 0xB9D1; break; // HANGUL SYLLABLE MIEUM A RIEULKIYEOK
    case 0xB8BD: code_point = 0xB9D2; break; // HANGUL SYLLABLE MIEUM A RIEULMIEUM
    case 0xB8BE: code_point = 0xB9D8; break; // HANGUL SYLLABLE MIEUM A MIEUM
    case 0xB8BF: code_point = 0xB9D9; break; // HANGUL SYLLABLE MIEUM A PIEUP
    case 0xB8C0: code_point = 0xB9DB; break; // HANGUL SYLLABLE MIEUM A SIOS
    case 0xB8C1: code_point = 0xB9DD; break; // HANGUL SYLLABLE MIEUM A IEUNG
    case 0xB8C2: code_point = 0xB9DE; break; // HANGUL SYLLABLE MIEUM A CIEUC
    case 0xB8C3: code_point = 0xB9E1; break; // HANGUL SYLLABLE MIEUM A THIEUTH
    case 0xB8C4: code_point = 0xB9E3; break; // HANGUL SYLLABLE MIEUM A HIEUH
    case 0xB8C5: code_point = 0xB9E4; break; // HANGUL SYLLABLE MIEUM AE
    case 0xB8C6: code_point = 0xB9E5; break; // HANGUL SYLLABLE MIEUM AE KIYEOK
    case 0xB8C7: code_point = 0xB9E8; break; // HANGUL SYLLABLE MIEUM AE NIEUN
    case 0xB8C8: code_point = 0xB9EC; break; // HANGUL SYLLABLE MIEUM AE RIEUL
    case 0xB8C9: code_point = 0xB9F4; break; // HANGUL SYLLABLE MIEUM AE MIEUM
    case 0xB8CA: code_point = 0xB9F5; break; // HANGUL SYLLABLE MIEUM AE PIEUP
    case 0xB8CB: code_point = 0xB9F7; break; // HANGUL SYLLABLE MIEUM AE SIOS
    case 0xB8CC: code_point = 0xB9F8; break; // HANGUL SYLLABLE MIEUM AE SSANGSIOS
    case 0xB8CD: code_point = 0xB9F9; break; // HANGUL SYLLABLE MIEUM AE IEUNG
    case 0xB8CE: code_point = 0xB9FA; break; // HANGUL SYLLABLE MIEUM AE CIEUC
    case 0xB8CF: code_point = 0xBA00; break; // HANGUL SYLLABLE MIEUM YA
    case 0xB8D0: code_point = 0xBA01; break; // HANGUL SYLLABLE MIEUM YA KIYEOK
    case 0xB8D1: code_point = 0xBA08; break; // HANGUL SYLLABLE MIEUM YA RIEUL
    case 0xB8D2: code_point = 0xBA15; break; // HANGUL SYLLABLE MIEUM YA IEUNG
    case 0xB8D3: code_point = 0xBA38; break; // HANGUL SYLLABLE MIEUM EO
    case 0xB8D4: code_point = 0xBA39; break; // HANGUL SYLLABLE MIEUM EO KIYEOK
    case 0xB8D5: code_point = 0xBA3C; break; // HANGUL SYLLABLE MIEUM EO NIEUN
    case 0xB8D6: code_point = 0xBA40; break; // HANGUL SYLLABLE MIEUM EO RIEUL
    case 0xB8D7: code_point = 0xBA42; break; // HANGUL SYLLABLE MIEUM EO RIEULMIEUM
    case 0xB8D8: code_point = 0xBA48; break; // HANGUL SYLLABLE MIEUM EO MIEUM
    case 0xB8D9: code_point = 0xBA49; break; // HANGUL SYLLABLE MIEUM EO PIEUP
    case 0xB8DA: code_point = 0xBA4B; break; // HANGUL SYLLABLE MIEUM EO SIOS
    case 0xB8DB: code_point = 0xBA4D; break; // HANGUL SYLLABLE MIEUM EO IEUNG
    case 0xB8DC: code_point = 0xBA4E; break; // HANGUL SYLLABLE MIEUM EO CIEUC
    case 0xB8DD: code_point = 0xBA53; break; // HANGUL SYLLABLE MIEUM EO HIEUH
    case 0xB8DE: code_point = 0xBA54; break; // HANGUL SYLLABLE MIEUM E
    case 0xB8DF: code_point = 0xBA55; break; // HANGUL SYLLABLE MIEUM E KIYEOK
    case 0xB8E0: code_point = 0xBA58; break; // HANGUL SYLLABLE MIEUM E NIEUN
    case 0xB8E1: code_point = 0xBA5C; break; // HANGUL SYLLABLE MIEUM E RIEUL
    case 0xB8E2: code_point = 0xBA64; break; // HANGUL SYLLABLE MIEUM E MIEUM
    case 0xB8E3: code_point = 0xBA65; break; // HANGUL SYLLABLE MIEUM E PIEUP
    case 0xB8E4: code_point = 0xBA67; break; // HANGUL SYLLABLE MIEUM E SIOS
    case 0xB8E5: code_point = 0xBA68; break; // HANGUL SYLLABLE MIEUM E SSANGSIOS
    case 0xB8E6: code_point = 0xBA69; break; // HANGUL SYLLABLE MIEUM E IEUNG
    case 0xB8E7: code_point = 0xBA70; break; // HANGUL SYLLABLE MIEUM YEO
    case 0xB8E8: code_point = 0xBA71; break; // HANGUL SYLLABLE MIEUM YEO KIYEOK
    case 0xB8E9: code_point = 0xBA74; break; // HANGUL SYLLABLE MIEUM YEO NIEUN
    case 0xB8EA: code_point = 0xBA78; break; // HANGUL SYLLABLE MIEUM YEO RIEUL
    case 0xB8EB: code_point = 0xBA83; break; // HANGUL SYLLABLE MIEUM YEO SIOS
    case 0xB8EC: code_point = 0xBA84; break; // HANGUL SYLLABLE MIEUM YEO SSANGSIOS
    case 0xB8ED: code_point = 0xBA85; break; // HANGUL SYLLABLE MIEUM YEO IEUNG
    case 0xB8EE: code_point = 0xBA87; break; // HANGUL SYLLABLE MIEUM YEO CHIEUCH
    case 0xB8EF: code_point = 0xBA8C; break; // HANGUL SYLLABLE MIEUM YE
    case 0xB8F0: code_point = 0xBAA8; break; // HANGUL SYLLABLE MIEUM O
    case 0xB8F1: code_point = 0xBAA9; break; // HANGUL SYLLABLE MIEUM O KIYEOK
    case 0xB8F2: code_point = 0xBAAB; break; // HANGUL SYLLABLE MIEUM O KIYEOKSIOS
    case 0xB8F3: code_point = 0xBAAC; break; // HANGUL SYLLABLE MIEUM O NIEUN
    case 0xB8F4: code_point = 0xBAB0; break; // HANGUL SYLLABLE MIEUM O RIEUL
    case 0xB8F5: code_point = 0xBAB2; break; // HANGUL SYLLABLE MIEUM O RIEULMIEUM
    case 0xB8F6: code_point = 0xBAB8; break; // HANGUL SYLLABLE MIEUM O MIEUM
    case 0xB8F7: code_point = 0xBAB9; break; // HANGUL SYLLABLE MIEUM O PIEUP
    case 0xB8F8: code_point = 0xBABB; break; // HANGUL SYLLABLE MIEUM O SIOS
    case 0xB8F9: code_point = 0xBABD; break; // HANGUL SYLLABLE MIEUM O IEUNG
    case 0xB8FA: code_point = 0xBAC4; break; // HANGUL SYLLABLE MIEUM WA
    case 0xB8FB: code_point = 0xBAC8; break; // HANGUL SYLLABLE MIEUM WA NIEUN
    case 0xB8FC: code_point = 0xBAD8; break; // HANGUL SYLLABLE MIEUM WA SSANGSIOS
    case 0xB8FD: code_point = 0xBAD9; break; // HANGUL SYLLABLE MIEUM WA IEUNG
    case 0xB8FE: code_point = 0xBAFC; break; // HANGUL SYLLABLE MIEUM OE
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xB9(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xB941: code_point = 0xD22A; break; // HANGUL SYLLABLE THIEUTH YO PHIEUPH
    case 0xB942: code_point = 0xD22B; break; // HANGUL SYLLABLE THIEUTH YO HIEUH
    case 0xB943: code_point = 0xD22E; break; // HANGUL SYLLABLE THIEUTH U SSANGKIYEOK
    case 0xB944: code_point = 0xD22F; break; // HANGUL SYLLABLE THIEUTH U KIYEOKSIOS
    case 0xB945: code_point = 0xD231; break; // HANGUL SYLLABLE THIEUTH U NIEUNCIEUC
    case 0xB946: code_point = 0xD232; break; // HANGUL SYLLABLE THIEUTH U NIEUNHIEUH
    case 0xB947: code_point = 0xD233; break; // HANGUL SYLLABLE THIEUTH U TIKEUT
    case 0xB948: code_point = 0xD235; break; // HANGUL SYLLABLE THIEUTH U RIEULKIYEOK
    case 0xB949: code_point = 0xD236; break; // HANGUL SYLLABLE THIEUTH U RIEULMIEUM
    case 0xB94A: code_point = 0xD237; break; // HANGUL SYLLABLE THIEUTH U RIEULPIEUP
    case 0xB94B: code_point = 0xD238; break; // HANGUL SYLLABLE THIEUTH U RIEULSIOS
    case 0xB94C: code_point = 0xD239; break; // HANGUL SYLLABLE THIEUTH U RIEULTHIEUTH
    case 0xB94D: code_point = 0xD23A; break; // HANGUL SYLLABLE THIEUTH U RIEULPHIEUPH
    case 0xB94E: code_point = 0xD23B; break; // HANGUL SYLLABLE THIEUTH U RIEULHIEUH
    case 0xB94F: code_point = 0xD23E; break; // HANGUL SYLLABLE THIEUTH U PIEUPSIOS
    case 0xB950: code_point = 0xD240; break; // HANGUL SYLLABLE THIEUTH U SSANGSIOS
    case 0xB951: code_point = 0xD242; break; // HANGUL SYLLABLE THIEUTH U CIEUC
    case 0xB952: code_point = 0xD243; break; // HANGUL SYLLABLE THIEUTH U CHIEUCH
    case 0xB953: code_point = 0xD244; break; // HANGUL SYLLABLE THIEUTH U KHIEUKH
    case 0xB954: code_point = 0xD245; break; // HANGUL SYLLABLE THIEUTH U THIEUTH
    case 0xB955: code_point = 0xD246; break; // HANGUL SYLLABLE THIEUTH U PHIEUPH
    case 0xB956: code_point = 0xD247; break; // HANGUL SYLLABLE THIEUTH U HIEUH
    case 0xB957: code_point = 0xD249; break; // HANGUL SYLLABLE THIEUTH WEO KIYEOK
    case 0xB958: code_point = 0xD24A; break; // HANGUL SYLLABLE THIEUTH WEO SSANGKIYEOK
    case 0xB959: code_point = 0xD24B; break; // HANGUL SYLLABLE THIEUTH WEO KIYEOKSIOS
    case 0xB95A: code_point = 0xD24C; break; // HANGUL SYLLABLE THIEUTH WEO NIEUN
    case 0xB961: code_point = 0xD24D; break; // HANGUL SYLLABLE THIEUTH WEO NIEUNCIEUC
    case 0xB962: code_point = 0xD24E; break; // HANGUL SYLLABLE THIEUTH WEO NIEUNHIEUH
    case 0xB963: code_point = 0xD24F; break; // HANGUL SYLLABLE THIEUTH WEO TIKEUT
    case 0xB964: code_point = 0xD250; break; // HANGUL SYLLABLE THIEUTH WEO RIEUL
    case 0xB965: code_point = 0xD251; break; // HANGUL SYLLABLE THIEUTH WEO RIEULKIYEOK
    case 0xB966: code_point = 0xD252; break; // HANGUL SYLLABLE THIEUTH WEO RIEULMIEUM
    case 0xB967: code_point = 0xD253; break; // HANGUL SYLLABLE THIEUTH WEO RIEULPIEUP
    case 0xB968: code_point = 0xD254; break; // HANGUL SYLLABLE THIEUTH WEO RIEULSIOS
    case 0xB969: code_point = 0xD255; break; // HANGUL SYLLABLE THIEUTH WEO RIEULTHIEUTH
    case 0xB96A: code_point = 0xD256; break; // HANGUL SYLLABLE THIEUTH WEO RIEULPHIEUPH
    case 0xB96B: code_point = 0xD257; break; // HANGUL SYLLABLE THIEUTH WEO RIEULHIEUH
    case 0xB96C: code_point = 0xD258; break; // HANGUL SYLLABLE THIEUTH WEO MIEUM
    case 0xB96D: code_point = 0xD259; break; // HANGUL SYLLABLE THIEUTH WEO PIEUP
    case 0xB96E: code_point = 0xD25A; break; // HANGUL SYLLABLE THIEUTH WEO PIEUPSIOS
    case 0xB96F: code_point = 0xD25B; break; // HANGUL SYLLABLE THIEUTH WEO SIOS
    case 0xB970: code_point = 0xD25D; break; // HANGUL SYLLABLE THIEUTH WEO IEUNG
    case 0xB971: code_point = 0xD25E; break; // HANGUL SYLLABLE THIEUTH WEO CIEUC
    case 0xB972: code_point = 0xD25F; break; // HANGUL SYLLABLE THIEUTH WEO CHIEUCH
    case 0xB973: code_point = 0xD260; break; // HANGUL SYLLABLE THIEUTH WEO KHIEUKH
    case 0xB974: code_point = 0xD261; break; // HANGUL SYLLABLE THIEUTH WEO THIEUTH
    case 0xB975: code_point = 0xD262; break; // HANGUL SYLLABLE THIEUTH WEO PHIEUPH
    case 0xB976: code_point = 0xD263; break; // HANGUL SYLLABLE THIEUTH WEO HIEUH
    case 0xB977: code_point = 0xD265; break; // HANGUL SYLLABLE THIEUTH WE KIYEOK
    case 0xB978: code_point = 0xD266; break; // HANGUL SYLLABLE THIEUTH WE SSANGKIYEOK
    case 0xB979: code_point = 0xD267; break; // HANGUL SYLLABLE THIEUTH WE KIYEOKSIOS
    case 0xB97A: code_point = 0xD268; break; // HANGUL SYLLABLE THIEUTH WE NIEUN
    case 0xB981: code_point = 0xD269; break; // HANGUL SYLLABLE THIEUTH WE NIEUNCIEUC
    case 0xB982: code_point = 0xD26A; break; // HANGUL SYLLABLE THIEUTH WE NIEUNHIEUH
    case 0xB983: code_point = 0xD26B; break; // HANGUL SYLLABLE THIEUTH WE TIKEUT
    case 0xB984: code_point = 0xD26C; break; // HANGUL SYLLABLE THIEUTH WE RIEUL
    case 0xB985: code_point = 0xD26D; break; // HANGUL SYLLABLE THIEUTH WE RIEULKIYEOK
    case 0xB986: code_point = 0xD26E; break; // HANGUL SYLLABLE THIEUTH WE RIEULMIEUM
    case 0xB987: code_point = 0xD26F; break; // HANGUL SYLLABLE THIEUTH WE RIEULPIEUP
    case 0xB988: code_point = 0xD270; break; // HANGUL SYLLABLE THIEUTH WE RIEULSIOS
    case 0xB989: code_point = 0xD271; break; // HANGUL SYLLABLE THIEUTH WE RIEULTHIEUTH
    case 0xB98A: code_point = 0xD272; break; // HANGUL SYLLABLE THIEUTH WE RIEULPHIEUPH
    case 0xB98B: code_point = 0xD273; break; // HANGUL SYLLABLE THIEUTH WE RIEULHIEUH
    case 0xB98C: code_point = 0xD274; break; // HANGUL SYLLABLE THIEUTH WE MIEUM
    case 0xB98D: code_point = 0xD275; break; // HANGUL SYLLABLE THIEUTH WE PIEUP
    case 0xB98E: code_point = 0xD276; break; // HANGUL SYLLABLE THIEUTH WE PIEUPSIOS
    case 0xB98F: code_point = 0xD277; break; // HANGUL SYLLABLE THIEUTH WE SIOS
    case 0xB990: code_point = 0xD278; break; // HANGUL SYLLABLE THIEUTH WE SSANGSIOS
    case 0xB991: code_point = 0xD279; break; // HANGUL SYLLABLE THIEUTH WE IEUNG
    case 0xB992: code_point = 0xD27A; break; // HANGUL SYLLABLE THIEUTH WE CIEUC
    case 0xB993: code_point = 0xD27B; break; // HANGUL SYLLABLE THIEUTH WE CHIEUCH
    case 0xB994: code_point = 0xD27C; break; // HANGUL SYLLABLE THIEUTH WE KHIEUKH
    case 0xB995: code_point = 0xD27D; break; // HANGUL SYLLABLE THIEUTH WE THIEUTH
    case 0xB996: code_point = 0xD27E; break; // HANGUL SYLLABLE THIEUTH WE PHIEUPH
    case 0xB997: code_point = 0xD27F; break; // HANGUL SYLLABLE THIEUTH WE HIEUH
    case 0xB998: code_point = 0xD282; break; // HANGUL SYLLABLE THIEUTH WI SSANGKIYEOK
    case 0xB999: code_point = 0xD283; break; // HANGUL SYLLABLE THIEUTH WI KIYEOKSIOS
    case 0xB99A: code_point = 0xD285; break; // HANGUL SYLLABLE THIEUTH WI NIEUNCIEUC
    case 0xB99B: code_point = 0xD286; break; // HANGUL SYLLABLE THIEUTH WI NIEUNHIEUH
    case 0xB99C: code_point = 0xD287; break; // HANGUL SYLLABLE THIEUTH WI TIKEUT
    case 0xB99D: code_point = 0xD289; break; // HANGUL SYLLABLE THIEUTH WI RIEULKIYEOK
    case 0xB99E: code_point = 0xD28A; break; // HANGUL SYLLABLE THIEUTH WI RIEULMIEUM
    case 0xB99F: code_point = 0xD28B; break; // HANGUL SYLLABLE THIEUTH WI RIEULPIEUP
    case 0xB9A0: code_point = 0xD28C; break; // HANGUL SYLLABLE THIEUTH WI RIEULSIOS
    case 0xB9A1: code_point = 0xBB00; break; // HANGUL SYLLABLE MIEUM OE NIEUN
    case 0xB9A2: code_point = 0xBB04; break; // HANGUL SYLLABLE MIEUM OE RIEUL
    case 0xB9A3: code_point = 0xBB0D; break; // HANGUL SYLLABLE MIEUM OE PIEUP
    case 0xB9A4: code_point = 0xBB0F; break; // HANGUL SYLLABLE MIEUM OE SIOS
    case 0xB9A5: code_point = 0xBB11; break; // HANGUL SYLLABLE MIEUM OE IEUNG
    case 0xB9A6: code_point = 0xBB18; break; // HANGUL SYLLABLE MIEUM YO
    case 0xB9A7: code_point = 0xBB1C; break; // HANGUL SYLLABLE MIEUM YO NIEUN
    case 0xB9A8: code_point = 0xBB20; break; // HANGUL SYLLABLE MIEUM YO RIEUL
    case 0xB9A9: code_point = 0xBB29; break; // HANGUL SYLLABLE MIEUM YO PIEUP
    case 0xB9AA: code_point = 0xBB2B; break; // HANGUL SYLLABLE MIEUM YO SIOS
    case 0xB9AB: code_point = 0xBB34; break; // HANGUL SYLLABLE MIEUM U
    case 0xB9AC: code_point = 0xBB35; break; // HANGUL SYLLABLE MIEUM U KIYEOK
    case 0xB9AD: code_point = 0xBB36; break; // HANGUL SYLLABLE MIEUM U SSANGKIYEOK
    case 0xB9AE: code_point = 0xBB38; break; // HANGUL SYLLABLE MIEUM U NIEUN
    case 0xB9AF: code_point = 0xBB3B; break; // HANGUL SYLLABLE MIEUM U TIKEUT
    case 0xB9B0: code_point = 0xBB3C; break; // HANGUL SYLLABLE MIEUM U RIEUL
    case 0xB9B1: code_point = 0xBB3D; break; // HANGUL SYLLABLE MIEUM U RIEULKIYEOK
    case 0xB9B2: code_point = 0xBB3E; break; // HANGUL SYLLABLE MIEUM U RIEULMIEUM
    case 0xB9B3: code_point = 0xBB44; break; // HANGUL SYLLABLE MIEUM U MIEUM
    case 0xB9B4: code_point = 0xBB45; break; // HANGUL SYLLABLE MIEUM U PIEUP
    case 0xB9B5: code_point = 0xBB47; break; // HANGUL SYLLABLE MIEUM U SIOS
    case 0xB9B6: code_point = 0xBB49; break; // HANGUL SYLLABLE MIEUM U IEUNG
    case 0xB9B7: code_point = 0xBB4D; break; // HANGUL SYLLABLE MIEUM U THIEUTH
    case 0xB9B8: code_point = 0xBB4F; break; // HANGUL SYLLABLE MIEUM U HIEUH
    case 0xB9B9: code_point = 0xBB50; break; // HANGUL SYLLABLE MIEUM WEO
    case 0xB9BA: code_point = 0xBB54; break; // HANGUL SYLLABLE MIEUM WEO NIEUN
    case 0xB9BB: code_point = 0xBB58; break; // HANGUL SYLLABLE MIEUM WEO RIEUL
    case 0xB9BC: code_point = 0xBB61; break; // HANGUL SYLLABLE MIEUM WEO PIEUP
    case 0xB9BD: code_point = 0xBB63; break; // HANGUL SYLLABLE MIEUM WEO SIOS
    case 0xB9BE: code_point = 0xBB6C; break; // HANGUL SYLLABLE MIEUM WE
    case 0xB9BF: code_point = 0xBB88; break; // HANGUL SYLLABLE MIEUM WI
    case 0xB9C0: code_point = 0xBB8C; break; // HANGUL SYLLABLE MIEUM WI NIEUN
    case 0xB9C1: code_point = 0xBB90; break; // HANGUL SYLLABLE MIEUM WI RIEUL
    case 0xB9C2: code_point = 0xBBA4; break; // HANGUL SYLLABLE MIEUM YU
    case 0xB9C3: code_point = 0xBBA8; break; // HANGUL SYLLABLE MIEUM YU NIEUN
    case 0xB9C4: code_point = 0xBBAC; break; // HANGUL SYLLABLE MIEUM YU RIEUL
    case 0xB9C5: code_point = 0xBBB4; break; // HANGUL SYLLABLE MIEUM YU MIEUM
    case 0xB9C6: code_point = 0xBBB7; break; // HANGUL SYLLABLE MIEUM YU SIOS
    case 0xB9C7: code_point = 0xBBC0; break; // HANGUL SYLLABLE MIEUM EU
    case 0xB9C8: code_point = 0xBBC4; break; // HANGUL SYLLABLE MIEUM EU NIEUN
    case 0xB9C9: code_point = 0xBBC8; break; // HANGUL SYLLABLE MIEUM EU RIEUL
    case 0xB9CA: code_point = 0xBBD0; break; // HANGUL SYLLABLE MIEUM EU MIEUM
    case 0xB9CB: code_point = 0xBBD3; break; // HANGUL SYLLABLE MIEUM EU SIOS
    case 0xB9CC: code_point = 0xBBF8; break; // HANGUL SYLLABLE MIEUM I
    case 0xB9CD: code_point = 0xBBF9; break; // HANGUL SYLLABLE MIEUM I KIYEOK
    case 0xB9CE: code_point = 0xBBFC; break; // HANGUL SYLLABLE MIEUM I NIEUN
    case 0xB9CF: code_point = 0xBBFF; break; // HANGUL SYLLABLE MIEUM I TIKEUT
    case 0xB9D0: code_point = 0xBC00; break; // HANGUL SYLLABLE MIEUM I RIEUL
    case 0xB9D1: code_point = 0xBC02; break; // HANGUL SYLLABLE MIEUM I RIEULMIEUM
    case 0xB9D2: code_point = 0xBC08; break; // HANGUL SYLLABLE MIEUM I MIEUM
    case 0xB9D3: code_point = 0xBC09; break; // HANGUL SYLLABLE MIEUM I PIEUP
    case 0xB9D4: code_point = 0xBC0B; break; // HANGUL SYLLABLE MIEUM I SIOS
    case 0xB9D5: code_point = 0xBC0C; break; // HANGUL SYLLABLE MIEUM I SSANGSIOS
    case 0xB9D6: code_point = 0xBC0D; break; // HANGUL SYLLABLE MIEUM I IEUNG
    case 0xB9D7: code_point = 0xBC0F; break; // HANGUL SYLLABLE MIEUM I CHIEUCH
    case 0xB9D8: code_point = 0xBC11; break; // HANGUL SYLLABLE MIEUM I THIEUTH
    case 0xB9D9: code_point = 0xBC14; break; // HANGUL SYLLABLE PIEUP A
    case 0xB9DA: code_point = 0xBC15; break; // HANGUL SYLLABLE PIEUP A KIYEOK
    case 0xB9DB: code_point = 0xBC16; break; // HANGUL SYLLABLE PIEUP A SSANGKIYEOK
    case 0xB9DC: code_point = 0xBC17; break; // HANGUL SYLLABLE PIEUP A KIYEOKSIOS
    case 0xB9DD: code_point = 0xBC18; break; // HANGUL SYLLABLE PIEUP A NIEUN
    case 0xB9DE: code_point = 0xBC1B; break; // HANGUL SYLLABLE PIEUP A TIKEUT
    case 0xB9DF: code_point = 0xBC1C; break; // HANGUL SYLLABLE PIEUP A RIEUL
    case 0xB9E0: code_point = 0xBC1D; break; // HANGUL SYLLABLE PIEUP A RIEULKIYEOK
    case 0xB9E1: code_point = 0xBC1E; break; // HANGUL SYLLABLE PIEUP A RIEULMIEUM
    case 0xB9E2: code_point = 0xBC1F; break; // HANGUL SYLLABLE PIEUP A RIEULPIEUP
    case 0xB9E3: code_point = 0xBC24; break; // HANGUL SYLLABLE PIEUP A MIEUM
    case 0xB9E4: code_point = 0xBC25; break; // HANGUL SYLLABLE PIEUP A PIEUP
    case 0xB9E5: code_point = 0xBC27; break; // HANGUL SYLLABLE PIEUP A SIOS
    case 0xB9E6: code_point = 0xBC29; break; // HANGUL SYLLABLE PIEUP A IEUNG
    case 0xB9E7: code_point = 0xBC2D; break; // HANGUL SYLLABLE PIEUP A THIEUTH
    case 0xB9E8: code_point = 0xBC30; break; // HANGUL SYLLABLE PIEUP AE
    case 0xB9E9: code_point = 0xBC31; break; // HANGUL SYLLABLE PIEUP AE KIYEOK
    case 0xB9EA: code_point = 0xBC34; break; // HANGUL SYLLABLE PIEUP AE NIEUN
    case 0xB9EB: code_point = 0xBC38; break; // HANGUL SYLLABLE PIEUP AE RIEUL
    case 0xB9EC: code_point = 0xBC40; break; // HANGUL SYLLABLE PIEUP AE MIEUM
    case 0xB9ED: code_point = 0xBC41; break; // HANGUL SYLLABLE PIEUP AE PIEUP
    case 0xB9EE: code_point = 0xBC43; break; // HANGUL SYLLABLE PIEUP AE SIOS
    case 0xB9EF: code_point = 0xBC44; break; // HANGUL SYLLABLE PIEUP AE SSANGSIOS
    case 0xB9F0: code_point = 0xBC45; break; // HANGUL SYLLABLE PIEUP AE IEUNG
    case 0xB9F1: code_point = 0xBC49; break; // HANGUL SYLLABLE PIEUP AE THIEUTH
    case 0xB9F2: code_point = 0xBC4C; break; // HANGUL SYLLABLE PIEUP YA
    case 0xB9F3: code_point = 0xBC4D; break; // HANGUL SYLLABLE PIEUP YA KIYEOK
    case 0xB9F4: code_point = 0xBC50; break; // HANGUL SYLLABLE PIEUP YA NIEUN
    case 0xB9F5: code_point = 0xBC5D; break; // HANGUL SYLLABLE PIEUP YA PIEUP
    case 0xB9F6: code_point = 0xBC84; break; // HANGUL SYLLABLE PIEUP EO
    case 0xB9F7: code_point = 0xBC85; break; // HANGUL SYLLABLE PIEUP EO KIYEOK
    case 0xB9F8: code_point = 0xBC88; break; // HANGUL SYLLABLE PIEUP EO NIEUN
    case 0xB9F9: code_point = 0xBC8B; break; // HANGUL SYLLABLE PIEUP EO TIKEUT
    case 0xB9FA: code_point = 0xBC8C; break; // HANGUL SYLLABLE PIEUP EO RIEUL
    case 0xB9FB: code_point = 0xBC8E; break; // HANGUL SYLLABLE PIEUP EO RIEULMIEUM
    case 0xB9FC: code_point = 0xBC94; break; // HANGUL SYLLABLE PIEUP EO MIEUM
    case 0xB9FD: code_point = 0xBC95; break; // HANGUL SYLLABLE PIEUP EO PIEUP
    case 0xB9FE: code_point = 0xBC97; break; // HANGUL SYLLABLE PIEUP EO SIOS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xBA(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xBA41: code_point = 0xD28D; break; // HANGUL SYLLABLE THIEUTH WI RIEULTHIEUTH
    case 0xBA42: code_point = 0xD28E; break; // HANGUL SYLLABLE THIEUTH WI RIEULPHIEUPH
    case 0xBA43: code_point = 0xD28F; break; // HANGUL SYLLABLE THIEUTH WI RIEULHIEUH
    case 0xBA44: code_point = 0xD292; break; // HANGUL SYLLABLE THIEUTH WI PIEUPSIOS
    case 0xBA45: code_point = 0xD293; break; // HANGUL SYLLABLE THIEUTH WI SIOS
    case 0xBA46: code_point = 0xD294; break; // HANGUL SYLLABLE THIEUTH WI SSANGSIOS
    case 0xBA47: code_point = 0xD296; break; // HANGUL SYLLABLE THIEUTH WI CIEUC
    case 0xBA48: code_point = 0xD297; break; // HANGUL SYLLABLE THIEUTH WI CHIEUCH
    case 0xBA49: code_point = 0xD298; break; // HANGUL SYLLABLE THIEUTH WI KHIEUKH
    case 0xBA4A: code_point = 0xD299; break; // HANGUL SYLLABLE THIEUTH WI THIEUTH
    case 0xBA4B: code_point = 0xD29A; break; // HANGUL SYLLABLE THIEUTH WI PHIEUPH
    case 0xBA4C: code_point = 0xD29B; break; // HANGUL SYLLABLE THIEUTH WI HIEUH
    case 0xBA4D: code_point = 0xD29D; break; // HANGUL SYLLABLE THIEUTH YU KIYEOK
    case 0xBA4E: code_point = 0xD29E; break; // HANGUL SYLLABLE THIEUTH YU SSANGKIYEOK
    case 0xBA4F: code_point = 0xD29F; break; // HANGUL SYLLABLE THIEUTH YU KIYEOKSIOS
    case 0xBA50: code_point = 0xD2A1; break; // HANGUL SYLLABLE THIEUTH YU NIEUNCIEUC
    case 0xBA51: code_point = 0xD2A2; break; // HANGUL SYLLABLE THIEUTH YU NIEUNHIEUH
    case 0xBA52: code_point = 0xD2A3; break; // HANGUL SYLLABLE THIEUTH YU TIKEUT
    case 0xBA53: code_point = 0xD2A5; break; // HANGUL SYLLABLE THIEUTH YU RIEULKIYEOK
    case 0xBA54: code_point = 0xD2A6; break; // HANGUL SYLLABLE THIEUTH YU RIEULMIEUM
    case 0xBA55: code_point = 0xD2A7; break; // HANGUL SYLLABLE THIEUTH YU RIEULPIEUP
    case 0xBA56: code_point = 0xD2A8; break; // HANGUL SYLLABLE THIEUTH YU RIEULSIOS
    case 0xBA57: code_point = 0xD2A9; break; // HANGUL SYLLABLE THIEUTH YU RIEULTHIEUTH
    case 0xBA58: code_point = 0xD2AA; break; // HANGUL SYLLABLE THIEUTH YU RIEULPHIEUPH
    case 0xBA59: code_point = 0xD2AB; break; // HANGUL SYLLABLE THIEUTH YU RIEULHIEUH
    case 0xBA5A: code_point = 0xD2AD; break; // HANGUL SYLLABLE THIEUTH YU PIEUP
    case 0xBA61: code_point = 0xD2AE; break; // HANGUL SYLLABLE THIEUTH YU PIEUPSIOS
    case 0xBA62: code_point = 0xD2AF; break; // HANGUL SYLLABLE THIEUTH YU SIOS
    case 0xBA63: code_point = 0xD2B0; break; // HANGUL SYLLABLE THIEUTH YU SSANGSIOS
    case 0xBA64: code_point = 0xD2B2; break; // HANGUL SYLLABLE THIEUTH YU CIEUC
    case 0xBA65: code_point = 0xD2B3; break; // HANGUL SYLLABLE THIEUTH YU CHIEUCH
    case 0xBA66: code_point = 0xD2B4; break; // HANGUL SYLLABLE THIEUTH YU KHIEUKH
    case 0xBA67: code_point = 0xD2B5; break; // HANGUL SYLLABLE THIEUTH YU THIEUTH
    case 0xBA68: code_point = 0xD2B6; break; // HANGUL SYLLABLE THIEUTH YU PHIEUPH
    case 0xBA69: code_point = 0xD2B7; break; // HANGUL SYLLABLE THIEUTH YU HIEUH
    case 0xBA6A: code_point = 0xD2BA; break; // HANGUL SYLLABLE THIEUTH EU SSANGKIYEOK
    case 0xBA6B: code_point = 0xD2BB; break; // HANGUL SYLLABLE THIEUTH EU KIYEOKSIOS
    case 0xBA6C: code_point = 0xD2BD; break; // HANGUL SYLLABLE THIEUTH EU NIEUNCIEUC
    case 0xBA6D: code_point = 0xD2BE; break; // HANGUL SYLLABLE THIEUTH EU NIEUNHIEUH
    case 0xBA6E: code_point = 0xD2C1; break; // HANGUL SYLLABLE THIEUTH EU RIEULKIYEOK
    case 0xBA6F: code_point = 0xD2C3; break; // HANGUL SYLLABLE THIEUTH EU RIEULPIEUP
    case 0xBA70: code_point = 0xD2C4; break; // HANGUL SYLLABLE THIEUTH EU RIEULSIOS
    case 0xBA71: code_point = 0xD2C5; break; // HANGUL SYLLABLE THIEUTH EU RIEULTHIEUTH
    case 0xBA72: code_point = 0xD2C6; break; // HANGUL SYLLABLE THIEUTH EU RIEULPHIEUPH
    case 0xBA73: code_point = 0xD2C7; break; // HANGUL SYLLABLE THIEUTH EU RIEULHIEUH
    case 0xBA74: code_point = 0xD2CA; break; // HANGUL SYLLABLE THIEUTH EU PIEUPSIOS
    case 0xBA75: code_point = 0xD2CC; break; // HANGUL SYLLABLE THIEUTH EU SSANGSIOS
    case 0xBA76: code_point = 0xD2CD; break; // HANGUL SYLLABLE THIEUTH EU IEUNG
    case 0xBA77: code_point = 0xD2CE; break; // HANGUL SYLLABLE THIEUTH EU CIEUC
    case 0xBA78: code_point = 0xD2CF; break; // HANGUL SYLLABLE THIEUTH EU CHIEUCH
    case 0xBA79: code_point = 0xD2D0; break; // HANGUL SYLLABLE THIEUTH EU KHIEUKH
    case 0xBA7A: code_point = 0xD2D1; break; // HANGUL SYLLABLE THIEUTH EU THIEUTH
    case 0xBA81: code_point = 0xD2D2; break; // HANGUL SYLLABLE THIEUTH EU PHIEUPH
    case 0xBA82: code_point = 0xD2D3; break; // HANGUL SYLLABLE THIEUTH EU HIEUH
    case 0xBA83: code_point = 0xD2D5; break; // HANGUL SYLLABLE THIEUTH YI KIYEOK
    case 0xBA84: code_point = 0xD2D6; break; // HANGUL SYLLABLE THIEUTH YI SSANGKIYEOK
    case 0xBA85: code_point = 0xD2D7; break; // HANGUL SYLLABLE THIEUTH YI KIYEOKSIOS
    case 0xBA86: code_point = 0xD2D9; break; // HANGUL SYLLABLE THIEUTH YI NIEUNCIEUC
    case 0xBA87: code_point = 0xD2DA; break; // HANGUL SYLLABLE THIEUTH YI NIEUNHIEUH
    case 0xBA88: code_point = 0xD2DB; break; // HANGUL SYLLABLE THIEUTH YI TIKEUT
    case 0xBA89: code_point = 0xD2DD; break; // HANGUL SYLLABLE THIEUTH YI RIEULKIYEOK
    case 0xBA8A: code_point = 0xD2DE; break; // HANGUL SYLLABLE THIEUTH YI RIEULMIEUM
    case 0xBA8B: code_point = 0xD2DF; break; // HANGUL SYLLABLE THIEUTH YI RIEULPIEUP
    case 0xBA8C: code_point = 0xD2E0; break; // HANGUL SYLLABLE THIEUTH YI RIEULSIOS
    case 0xBA8D: code_point = 0xD2E1; break; // HANGUL SYLLABLE THIEUTH YI RIEULTHIEUTH
    case 0xBA8E: code_point = 0xD2E2; break; // HANGUL SYLLABLE THIEUTH YI RIEULPHIEUPH
    case 0xBA8F: code_point = 0xD2E3; break; // HANGUL SYLLABLE THIEUTH YI RIEULHIEUH
    case 0xBA90: code_point = 0xD2E6; break; // HANGUL SYLLABLE THIEUTH YI PIEUPSIOS
    case 0xBA91: code_point = 0xD2E7; break; // HANGUL SYLLABLE THIEUTH YI SIOS
    case 0xBA92: code_point = 0xD2E8; break; // HANGUL SYLLABLE THIEUTH YI SSANGSIOS
    case 0xBA93: code_point = 0xD2E9; break; // HANGUL SYLLABLE THIEUTH YI IEUNG
    case 0xBA94: code_point = 0xD2EA; break; // HANGUL SYLLABLE THIEUTH YI CIEUC
    case 0xBA95: code_point = 0xD2EB; break; // HANGUL SYLLABLE THIEUTH YI CHIEUCH
    case 0xBA96: code_point = 0xD2EC; break; // HANGUL SYLLABLE THIEUTH YI KHIEUKH
    case 0xBA97: code_point = 0xD2ED; break; // HANGUL SYLLABLE THIEUTH YI THIEUTH
    case 0xBA98: code_point = 0xD2EE; break; // HANGUL SYLLABLE THIEUTH YI PHIEUPH
    case 0xBA99: code_point = 0xD2EF; break; // HANGUL SYLLABLE THIEUTH YI HIEUH
    case 0xBA9A: code_point = 0xD2F2; break; // HANGUL SYLLABLE THIEUTH I SSANGKIYEOK
    case 0xBA9B: code_point = 0xD2F3; break; // HANGUL SYLLABLE THIEUTH I KIYEOKSIOS
    case 0xBA9C: code_point = 0xD2F5; break; // HANGUL SYLLABLE THIEUTH I NIEUNCIEUC
    case 0xBA9D: code_point = 0xD2F6; break; // HANGUL SYLLABLE THIEUTH I NIEUNHIEUH
    case 0xBA9E: code_point = 0xD2F7; break; // HANGUL SYLLABLE THIEUTH I TIKEUT
    case 0xBA9F: code_point = 0xD2F9; break; // HANGUL SYLLABLE THIEUTH I RIEULKIYEOK
    case 0xBAA0: code_point = 0xD2FA; break; // HANGUL SYLLABLE THIEUTH I RIEULMIEUM
    case 0xBAA1: code_point = 0xBC99; break; // HANGUL SYLLABLE PIEUP EO IEUNG
    case 0xBAA2: code_point = 0xBC9A; break; // HANGUL SYLLABLE PIEUP EO CIEUC
    case 0xBAA3: code_point = 0xBCA0; break; // HANGUL SYLLABLE PIEUP E
    case 0xBAA4: code_point = 0xBCA1; break; // HANGUL SYLLABLE PIEUP E KIYEOK
    case 0xBAA5: code_point = 0xBCA4; break; // HANGUL SYLLABLE PIEUP E NIEUN
    case 0xBAA6: code_point = 0xBCA7; break; // HANGUL SYLLABLE PIEUP E TIKEUT
    case 0xBAA7: code_point = 0xBCA8; break; // HANGUL SYLLABLE PIEUP E RIEUL
    case 0xBAA8: code_point = 0xBCB0; break; // HANGUL SYLLABLE PIEUP E MIEUM
    case 0xBAA9: code_point = 0xBCB1; break; // HANGUL SYLLABLE PIEUP E PIEUP
    case 0xBAAA: code_point = 0xBCB3; break; // HANGUL SYLLABLE PIEUP E SIOS
    case 0xBAAB: code_point = 0xBCB4; break; // HANGUL SYLLABLE PIEUP E SSANGSIOS
    case 0xBAAC: code_point = 0xBCB5; break; // HANGUL SYLLABLE PIEUP E IEUNG
    case 0xBAAD: code_point = 0xBCBC; break; // HANGUL SYLLABLE PIEUP YEO
    case 0xBAAE: code_point = 0xBCBD; break; // HANGUL SYLLABLE PIEUP YEO KIYEOK
    case 0xBAAF: code_point = 0xBCC0; break; // HANGUL SYLLABLE PIEUP YEO NIEUN
    case 0xBAB0: code_point = 0xBCC4; break; // HANGUL SYLLABLE PIEUP YEO RIEUL
    case 0xBAB1: code_point = 0xBCCD; break; // HANGUL SYLLABLE PIEUP YEO PIEUP
    case 0xBAB2: code_point = 0xBCCF; break; // HANGUL SYLLABLE PIEUP YEO SIOS
    case 0xBAB3: code_point = 0xBCD0; break; // HANGUL SYLLABLE PIEUP YEO SSANGSIOS
    case 0xBAB4: code_point = 0xBCD1; break; // HANGUL SYLLABLE PIEUP YEO IEUNG
    case 0xBAB5: code_point = 0xBCD5; break; // HANGUL SYLLABLE PIEUP YEO THIEUTH
    case 0xBAB6: code_point = 0xBCD8; break; // HANGUL SYLLABLE PIEUP YE
    case 0xBAB7: code_point = 0xBCDC; break; // HANGUL SYLLABLE PIEUP YE NIEUN
    case 0xBAB8: code_point = 0xBCF4; break; // HANGUL SYLLABLE PIEUP O
    case 0xBAB9: code_point = 0xBCF5; break; // HANGUL SYLLABLE PIEUP O KIYEOK
    case 0xBABA: code_point = 0xBCF6; break; // HANGUL SYLLABLE PIEUP O SSANGKIYEOK
    case 0xBABB: code_point = 0xBCF8; break; // HANGUL SYLLABLE PIEUP O NIEUN
    case 0xBABC: code_point = 0xBCFC; break; // HANGUL SYLLABLE PIEUP O RIEUL
    case 0xBABD: code_point = 0xBD04; break; // HANGUL SYLLABLE PIEUP O MIEUM
    case 0xBABE: code_point = 0xBD05; break; // HANGUL SYLLABLE PIEUP O PIEUP
    case 0xBABF: code_point = 0xBD07; break; // HANGUL SYLLABLE PIEUP O SIOS
    case 0xBAC0: code_point = 0xBD09; break; // HANGUL SYLLABLE PIEUP O IEUNG
    case 0xBAC1: code_point = 0xBD10; break; // HANGUL SYLLABLE PIEUP WA
    case 0xBAC2: code_point = 0xBD14; break; // HANGUL SYLLABLE PIEUP WA NIEUN
    case 0xBAC3: code_point = 0xBD24; break; // HANGUL SYLLABLE PIEUP WA SSANGSIOS
    case 0xBAC4: code_point = 0xBD2C; break; // HANGUL SYLLABLE PIEUP WAE
    case 0xBAC5: code_point = 0xBD40; break; // HANGUL SYLLABLE PIEUP WAE SSANGSIOS
    case 0xBAC6: code_point = 0xBD48; break; // HANGUL SYLLABLE PIEUP OE
    case 0xBAC7: code_point = 0xBD49; break; // HANGUL SYLLABLE PIEUP OE KIYEOK
    case 0xBAC8: code_point = 0xBD4C; break; // HANGUL SYLLABLE PIEUP OE NIEUN
    case 0xBAC9: code_point = 0xBD50; break; // HANGUL SYLLABLE PIEUP OE RIEUL
    case 0xBACA: code_point = 0xBD58; break; // HANGUL SYLLABLE PIEUP OE MIEUM
    case 0xBACB: code_point = 0xBD59; break; // HANGUL SYLLABLE PIEUP OE PIEUP
    case 0xBACC: code_point = 0xBD64; break; // HANGUL SYLLABLE PIEUP YO
    case 0xBACD: code_point = 0xBD68; break; // HANGUL SYLLABLE PIEUP YO NIEUN
    case 0xBACE: code_point = 0xBD80; break; // HANGUL SYLLABLE PIEUP U
    case 0xBACF: code_point = 0xBD81; break; // HANGUL SYLLABLE PIEUP U KIYEOK
    case 0xBAD0: code_point = 0xBD84; break; // HANGUL SYLLABLE PIEUP U NIEUN
    case 0xBAD1: code_point = 0xBD87; break; // HANGUL SYLLABLE PIEUP U TIKEUT
    case 0xBAD2: code_point = 0xBD88; break; // HANGUL SYLLABLE PIEUP U RIEUL
    case 0xBAD3: code_point = 0xBD89; break; // HANGUL SYLLABLE PIEUP U RIEULKIYEOK
    case 0xBAD4: code_point = 0xBD8A; break; // HANGUL SYLLABLE PIEUP U RIEULMIEUM
    case 0xBAD5: code_point = 0xBD90; break; // HANGUL SYLLABLE PIEUP U MIEUM
    case 0xBAD6: code_point = 0xBD91; break; // HANGUL SYLLABLE PIEUP U PIEUP
    case 0xBAD7: code_point = 0xBD93; break; // HANGUL SYLLABLE PIEUP U SIOS
    case 0xBAD8: code_point = 0xBD95; break; // HANGUL SYLLABLE PIEUP U IEUNG
    case 0xBAD9: code_point = 0xBD99; break; // HANGUL SYLLABLE PIEUP U THIEUTH
    case 0xBADA: code_point = 0xBD9A; break; // HANGUL SYLLABLE PIEUP U PHIEUPH
    case 0xBADB: code_point = 0xBD9C; break; // HANGUL SYLLABLE PIEUP WEO
    case 0xBADC: code_point = 0xBDA4; break; // HANGUL SYLLABLE PIEUP WEO RIEUL
    case 0xBADD: code_point = 0xBDB0; break; // HANGUL SYLLABLE PIEUP WEO SSANGSIOS
    case 0xBADE: code_point = 0xBDB8; break; // HANGUL SYLLABLE PIEUP WE
    case 0xBADF: code_point = 0xBDD4; break; // HANGUL SYLLABLE PIEUP WI
    case 0xBAE0: code_point = 0xBDD5; break; // HANGUL SYLLABLE PIEUP WI KIYEOK
    case 0xBAE1: code_point = 0xBDD8; break; // HANGUL SYLLABLE PIEUP WI NIEUN
    case 0xBAE2: code_point = 0xBDDC; break; // HANGUL SYLLABLE PIEUP WI RIEUL
    case 0xBAE3: code_point = 0xBDE9; break; // HANGUL SYLLABLE PIEUP WI IEUNG
    case 0xBAE4: code_point = 0xBDF0; break; // HANGUL SYLLABLE PIEUP YU
    case 0xBAE5: code_point = 0xBDF4; break; // HANGUL SYLLABLE PIEUP YU NIEUN
    case 0xBAE6: code_point = 0xBDF8; break; // HANGUL SYLLABLE PIEUP YU RIEUL
    case 0xBAE7: code_point = 0xBE00; break; // HANGUL SYLLABLE PIEUP YU MIEUM
    case 0xBAE8: code_point = 0xBE03; break; // HANGUL SYLLABLE PIEUP YU SIOS
    case 0xBAE9: code_point = 0xBE05; break; // HANGUL SYLLABLE PIEUP YU IEUNG
    case 0xBAEA: code_point = 0xBE0C; break; // HANGUL SYLLABLE PIEUP EU
    case 0xBAEB: code_point = 0xBE0D; break; // HANGUL SYLLABLE PIEUP EU KIYEOK
    case 0xBAEC: code_point = 0xBE10; break; // HANGUL SYLLABLE PIEUP EU NIEUN
    case 0xBAED: code_point = 0xBE14; break; // HANGUL SYLLABLE PIEUP EU RIEUL
    case 0xBAEE: code_point = 0xBE1C; break; // HANGUL SYLLABLE PIEUP EU MIEUM
    case 0xBAEF: code_point = 0xBE1D; break; // HANGUL SYLLABLE PIEUP EU PIEUP
    case 0xBAF0: code_point = 0xBE1F; break; // HANGUL SYLLABLE PIEUP EU SIOS
    case 0xBAF1: code_point = 0xBE44; break; // HANGUL SYLLABLE PIEUP I
    case 0xBAF2: code_point = 0xBE45; break; // HANGUL SYLLABLE PIEUP I KIYEOK
    case 0xBAF3: code_point = 0xBE48; break; // HANGUL SYLLABLE PIEUP I NIEUN
    case 0xBAF4: code_point = 0xBE4C; break; // HANGUL SYLLABLE PIEUP I RIEUL
    case 0xBAF5: code_point = 0xBE4E; break; // HANGUL SYLLABLE PIEUP I RIEULMIEUM
    case 0xBAF6: code_point = 0xBE54; break; // HANGUL SYLLABLE PIEUP I MIEUM
    case 0xBAF7: code_point = 0xBE55; break; // HANGUL SYLLABLE PIEUP I PIEUP
    case 0xBAF8: code_point = 0xBE57; break; // HANGUL SYLLABLE PIEUP I SIOS
    case 0xBAF9: code_point = 0xBE59; break; // HANGUL SYLLABLE PIEUP I IEUNG
    case 0xBAFA: code_point = 0xBE5A; break; // HANGUL SYLLABLE PIEUP I CIEUC
    case 0xBAFB: code_point = 0xBE5B; break; // HANGUL SYLLABLE PIEUP I CHIEUCH
    case 0xBAFC: code_point = 0xBE60; break; // HANGUL SYLLABLE SSANGPIEUP A
    case 0xBAFD: code_point = 0xBE61; break; // HANGUL SYLLABLE SSANGPIEUP A KIYEOK
    case 0xBAFE: code_point = 0xBE64; break; // HANGUL SYLLABLE SSANGPIEUP A NIEUN
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xBB(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xBB41: code_point = 0xD2FB; break; // HANGUL SYLLABLE THIEUTH I RIEULPIEUP
    case 0xBB42: code_point = 0xD2FC; break; // HANGUL SYLLABLE THIEUTH I RIEULSIOS
    case 0xBB43: code_point = 0xD2FD; break; // HANGUL SYLLABLE THIEUTH I RIEULTHIEUTH
    case 0xBB44: code_point = 0xD2FE; break; // HANGUL SYLLABLE THIEUTH I RIEULPHIEUPH
    case 0xBB45: code_point = 0xD2FF; break; // HANGUL SYLLABLE THIEUTH I RIEULHIEUH
    case 0xBB46: code_point = 0xD302; break; // HANGUL SYLLABLE THIEUTH I PIEUPSIOS
    case 0xBB47: code_point = 0xD304; break; // HANGUL SYLLABLE THIEUTH I SSANGSIOS
    case 0xBB48: code_point = 0xD306; break; // HANGUL SYLLABLE THIEUTH I CIEUC
    case 0xBB49: code_point = 0xD307; break; // HANGUL SYLLABLE THIEUTH I CHIEUCH
    case 0xBB4A: code_point = 0xD308; break; // HANGUL SYLLABLE THIEUTH I KHIEUKH
    case 0xBB4B: code_point = 0xD309; break; // HANGUL SYLLABLE THIEUTH I THIEUTH
    case 0xBB4C: code_point = 0xD30A; break; // HANGUL SYLLABLE THIEUTH I PHIEUPH
    case 0xBB4D: code_point = 0xD30B; break; // HANGUL SYLLABLE THIEUTH I HIEUH
    case 0xBB4E: code_point = 0xD30F; break; // HANGUL SYLLABLE PHIEUPH A KIYEOKSIOS
    case 0xBB4F: code_point = 0xD311; break; // HANGUL SYLLABLE PHIEUPH A NIEUNCIEUC
    case 0xBB50: code_point = 0xD312; break; // HANGUL SYLLABLE PHIEUPH A NIEUNHIEUH
    case 0xBB51: code_point = 0xD313; break; // HANGUL SYLLABLE PHIEUPH A TIKEUT
    case 0xBB52: code_point = 0xD315; break; // HANGUL SYLLABLE PHIEUPH A RIEULKIYEOK
    case 0xBB53: code_point = 0xD317; break; // HANGUL SYLLABLE PHIEUPH A RIEULPIEUP
    case 0xBB54: code_point = 0xD318; break; // HANGUL SYLLABLE PHIEUPH A RIEULSIOS
    case 0xBB55: code_point = 0xD319; break; // HANGUL SYLLABLE PHIEUPH A RIEULTHIEUTH
    case 0xBB56: code_point = 0xD31A; break; // HANGUL SYLLABLE PHIEUPH A RIEULPHIEUPH
    case 0xBB57: code_point = 0xD31B; break; // HANGUL SYLLABLE PHIEUPH A RIEULHIEUH
    case 0xBB58: code_point = 0xD31E; break; // HANGUL SYLLABLE PHIEUPH A PIEUPSIOS
    case 0xBB59: code_point = 0xD322; break; // HANGUL SYLLABLE PHIEUPH A CIEUC
    case 0xBB5A: code_point = 0xD323; break; // HANGUL SYLLABLE PHIEUPH A CHIEUCH
    case 0xBB61: code_point = 0xD324; break; // HANGUL SYLLABLE PHIEUPH A KHIEUKH
    case 0xBB62: code_point = 0xD326; break; // HANGUL SYLLABLE PHIEUPH A PHIEUPH
    case 0xBB63: code_point = 0xD327; break; // HANGUL SYLLABLE PHIEUPH A HIEUH
    case 0xBB64: code_point = 0xD32A; break; // HANGUL SYLLABLE PHIEUPH AE SSANGKIYEOK
    case 0xBB65: code_point = 0xD32B; break; // HANGUL SYLLABLE PHIEUPH AE KIYEOKSIOS
    case 0xBB66: code_point = 0xD32D; break; // HANGUL SYLLABLE PHIEUPH AE NIEUNCIEUC
    case 0xBB67: code_point = 0xD32E; break; // HANGUL SYLLABLE PHIEUPH AE NIEUNHIEUH
    case 0xBB68: code_point = 0xD32F; break; // HANGUL SYLLABLE PHIEUPH AE TIKEUT
    case 0xBB69: code_point = 0xD331; break; // HANGUL SYLLABLE PHIEUPH AE RIEULKIYEOK
    case 0xBB6A: code_point = 0xD332; break; // HANGUL SYLLABLE PHIEUPH AE RIEULMIEUM
    case 0xBB6B: code_point = 0xD333; break; // HANGUL SYLLABLE PHIEUPH AE RIEULPIEUP
    case 0xBB6C: code_point = 0xD334; break; // HANGUL SYLLABLE PHIEUPH AE RIEULSIOS
    case 0xBB6D: code_point = 0xD335; break; // HANGUL SYLLABLE PHIEUPH AE RIEULTHIEUTH
    case 0xBB6E: code_point = 0xD336; break; // HANGUL SYLLABLE PHIEUPH AE RIEULPHIEUPH
    case 0xBB6F: code_point = 0xD337; break; // HANGUL SYLLABLE PHIEUPH AE RIEULHIEUH
    case 0xBB70: code_point = 0xD33A; break; // HANGUL SYLLABLE PHIEUPH AE PIEUPSIOS
    case 0xBB71: code_point = 0xD33E; break; // HANGUL SYLLABLE PHIEUPH AE CIEUC
    case 0xBB72: code_point = 0xD33F; break; // HANGUL SYLLABLE PHIEUPH AE CHIEUCH
    case 0xBB73: code_point = 0xD340; break; // HANGUL SYLLABLE PHIEUPH AE KHIEUKH
    case 0xBB74: code_point = 0xD341; break; // HANGUL SYLLABLE PHIEUPH AE THIEUTH
    case 0xBB75: code_point = 0xD342; break; // HANGUL SYLLABLE PHIEUPH AE PHIEUPH
    case 0xBB76: code_point = 0xD343; break; // HANGUL SYLLABLE PHIEUPH AE HIEUH
    case 0xBB77: code_point = 0xD346; break; // HANGUL SYLLABLE PHIEUPH YA SSANGKIYEOK
    case 0xBB78: code_point = 0xD347; break; // HANGUL SYLLABLE PHIEUPH YA KIYEOKSIOS
    case 0xBB79: code_point = 0xD348; break; // HANGUL SYLLABLE PHIEUPH YA NIEUN
    case 0xBB7A: code_point = 0xD349; break; // HANGUL SYLLABLE PHIEUPH YA NIEUNCIEUC
    case 0xBB81: code_point = 0xD34A; break; // HANGUL SYLLABLE PHIEUPH YA NIEUNHIEUH
    case 0xBB82: code_point = 0xD34B; break; // HANGUL SYLLABLE PHIEUPH YA TIKEUT
    case 0xBB83: code_point = 0xD34C; break; // HANGUL SYLLABLE PHIEUPH YA RIEUL
    case 0xBB84: code_point = 0xD34D; break; // HANGUL SYLLABLE PHIEUPH YA RIEULKIYEOK
    case 0xBB85: code_point = 0xD34E; break; // HANGUL SYLLABLE PHIEUPH YA RIEULMIEUM
    case 0xBB86: code_point = 0xD34F; break; // HANGUL SYLLABLE PHIEUPH YA RIEULPIEUP
    case 0xBB87: code_point = 0xD350; break; // HANGUL SYLLABLE PHIEUPH YA RIEULSIOS
    case 0xBB88: code_point = 0xD351; break; // HANGUL SYLLABLE PHIEUPH YA RIEULTHIEUTH
    case 0xBB89: code_point = 0xD352; break; // HANGUL SYLLABLE PHIEUPH YA RIEULPHIEUPH
    case 0xBB8A: code_point = 0xD353; break; // HANGUL SYLLABLE PHIEUPH YA RIEULHIEUH
    case 0xBB8B: code_point = 0xD354; break; // HANGUL SYLLABLE PHIEUPH YA MIEUM
    case 0xBB8C: code_point = 0xD355; break; // HANGUL SYLLABLE PHIEUPH YA PIEUP
    case 0xBB8D: code_point = 0xD356; break; // HANGUL SYLLABLE PHIEUPH YA PIEUPSIOS
    case 0xBB8E: code_point = 0xD357; break; // HANGUL SYLLABLE PHIEUPH YA SIOS
    case 0xBB8F: code_point = 0xD358; break; // HANGUL SYLLABLE PHIEUPH YA SSANGSIOS
    case 0xBB90: code_point = 0xD359; break; // HANGUL SYLLABLE PHIEUPH YA IEUNG
    case 0xBB91: code_point = 0xD35A; break; // HANGUL SYLLABLE PHIEUPH YA CIEUC
    case 0xBB92: code_point = 0xD35B; break; // HANGUL SYLLABLE PHIEUPH YA CHIEUCH
    case 0xBB93: code_point = 0xD35C; break; // HANGUL SYLLABLE PHIEUPH YA KHIEUKH
    case 0xBB94: code_point = 0xD35D; break; // HANGUL SYLLABLE PHIEUPH YA THIEUTH
    case 0xBB95: code_point = 0xD35E; break; // HANGUL SYLLABLE PHIEUPH YA PHIEUPH
    case 0xBB96: code_point = 0xD35F; break; // HANGUL SYLLABLE PHIEUPH YA HIEUH
    case 0xBB97: code_point = 0xD360; break; // HANGUL SYLLABLE PHIEUPH YAE
    case 0xBB98: code_point = 0xD361; break; // HANGUL SYLLABLE PHIEUPH YAE KIYEOK
    case 0xBB99: code_point = 0xD362; break; // HANGUL SYLLABLE PHIEUPH YAE SSANGKIYEOK
    case 0xBB9A: code_point = 0xD363; break; // HANGUL SYLLABLE PHIEUPH YAE KIYEOKSIOS
    case 0xBB9B: code_point = 0xD364; break; // HANGUL SYLLABLE PHIEUPH YAE NIEUN
    case 0xBB9C: code_point = 0xD365; break; // HANGUL SYLLABLE PHIEUPH YAE NIEUNCIEUC
    case 0xBB9D: code_point = 0xD366; break; // HANGUL SYLLABLE PHIEUPH YAE NIEUNHIEUH
    case 0xBB9E: code_point = 0xD367; break; // HANGUL SYLLABLE PHIEUPH YAE TIKEUT
    case 0xBB9F: code_point = 0xD368; break; // HANGUL SYLLABLE PHIEUPH YAE RIEUL
    case 0xBBA0: code_point = 0xD369; break; // HANGUL SYLLABLE PHIEUPH YAE RIEULKIYEOK
    case 0xBBA1: code_point = 0xBE68; break; // HANGUL SYLLABLE SSANGPIEUP A RIEUL
    case 0xBBA2: code_point = 0xBE6A; break; // HANGUL SYLLABLE SSANGPIEUP A RIEULMIEUM
    case 0xBBA3: code_point = 0xBE70; break; // HANGUL SYLLABLE SSANGPIEUP A MIEUM
    case 0xBBA4: code_point = 0xBE71; break; // HANGUL SYLLABLE SSANGPIEUP A PIEUP
    case 0xBBA5: code_point = 0xBE73; break; // HANGUL SYLLABLE SSANGPIEUP A SIOS
    case 0xBBA6: code_point = 0xBE74; break; // HANGUL SYLLABLE SSANGPIEUP A SSANGSIOS
    case 0xBBA7: code_point = 0xBE75; break; // HANGUL SYLLABLE SSANGPIEUP A IEUNG
    case 0xBBA8: code_point = 0xBE7B; break; // HANGUL SYLLABLE SSANGPIEUP A HIEUH
    case 0xBBA9: code_point = 0xBE7C; break; // HANGUL SYLLABLE SSANGPIEUP AE
    case 0xBBAA: code_point = 0xBE7D; break; // HANGUL SYLLABLE SSANGPIEUP AE KIYEOK
    case 0xBBAB: code_point = 0xBE80; break; // HANGUL SYLLABLE SSANGPIEUP AE NIEUN
    case 0xBBAC: code_point = 0xBE84; break; // HANGUL SYLLABLE SSANGPIEUP AE RIEUL
    case 0xBBAD: code_point = 0xBE8C; break; // HANGUL SYLLABLE SSANGPIEUP AE MIEUM
    case 0xBBAE: code_point = 0xBE8D; break; // HANGUL SYLLABLE SSANGPIEUP AE PIEUP
    case 0xBBAF: code_point = 0xBE8F; break; // HANGUL SYLLABLE SSANGPIEUP AE SIOS
    case 0xBBB0: code_point = 0xBE90; break; // HANGUL SYLLABLE SSANGPIEUP AE SSANGSIOS
    case 0xBBB1: code_point = 0xBE91; break; // HANGUL SYLLABLE SSANGPIEUP AE IEUNG
    case 0xBBB2: code_point = 0xBE98; break; // HANGUL SYLLABLE SSANGPIEUP YA
    case 0xBBB3: code_point = 0xBE99; break; // HANGUL SYLLABLE SSANGPIEUP YA KIYEOK
    case 0xBBB4: code_point = 0xBEA8; break; // HANGUL SYLLABLE SSANGPIEUP YA MIEUM
    case 0xBBB5: code_point = 0xBED0; break; // HANGUL SYLLABLE SSANGPIEUP EO
    case 0xBBB6: code_point = 0xBED1; break; // HANGUL SYLLABLE SSANGPIEUP EO KIYEOK
    case 0xBBB7: code_point = 0xBED4; break; // HANGUL SYLLABLE SSANGPIEUP EO NIEUN
    case 0xBBB8: code_point = 0xBED7; break; // HANGUL SYLLABLE SSANGPIEUP EO TIKEUT
    case 0xBBB9: code_point = 0xBED8; break; // HANGUL SYLLABLE SSANGPIEUP EO RIEUL
    case 0xBBBA: code_point = 0xBEE0; break; // HANGUL SYLLABLE SSANGPIEUP EO MIEUM
    case 0xBBBB: code_point = 0xBEE3; break; // HANGUL SYLLABLE SSANGPIEUP EO SIOS
    case 0xBBBC: code_point = 0xBEE4; break; // HANGUL SYLLABLE SSANGPIEUP EO SSANGSIOS
    case 0xBBBD: code_point = 0xBEE5; break; // HANGUL SYLLABLE SSANGPIEUP EO IEUNG
    case 0xBBBE: code_point = 0xBEEC; break; // HANGUL SYLLABLE SSANGPIEUP E
    case 0xBBBF: code_point = 0xBF01; break; // HANGUL SYLLABLE SSANGPIEUP E IEUNG
    case 0xBBC0: code_point = 0xBF08; break; // HANGUL SYLLABLE SSANGPIEUP YEO
    case 0xBBC1: code_point = 0xBF09; break; // HANGUL SYLLABLE SSANGPIEUP YEO KIYEOK
    case 0xBBC2: code_point = 0xBF18; break; // HANGUL SYLLABLE SSANGPIEUP YEO MIEUM
    case 0xBBC3: code_point = 0xBF19; break; // HANGUL SYLLABLE SSANGPIEUP YEO PIEUP
    case 0xBBC4: code_point = 0xBF1B; break; // HANGUL SYLLABLE SSANGPIEUP YEO SIOS
    case 0xBBC5: code_point = 0xBF1C; break; // HANGUL SYLLABLE SSANGPIEUP YEO SSANGSIOS
    case 0xBBC6: code_point = 0xBF1D; break; // HANGUL SYLLABLE SSANGPIEUP YEO IEUNG
    case 0xBBC7: code_point = 0xBF40; break; // HANGUL SYLLABLE SSANGPIEUP O
    case 0xBBC8: code_point = 0xBF41; break; // HANGUL SYLLABLE SSANGPIEUP O KIYEOK
    case 0xBBC9: code_point = 0xBF44; break; // HANGUL SYLLABLE SSANGPIEUP O NIEUN
    case 0xBBCA: code_point = 0xBF48; break; // HANGUL SYLLABLE SSANGPIEUP O RIEUL
    case 0xBBCB: code_point = 0xBF50; break; // HANGUL SYLLABLE SSANGPIEUP O MIEUM
    case 0xBBCC: code_point = 0xBF51; break; // HANGUL SYLLABLE SSANGPIEUP O PIEUP
    case 0xBBCD: code_point = 0xBF55; break; // HANGUL SYLLABLE SSANGPIEUP O IEUNG
    case 0xBBCE: code_point = 0xBF94; break; // HANGUL SYLLABLE SSANGPIEUP OE
    case 0xBBCF: code_point = 0xBFB0; break; // HANGUL SYLLABLE SSANGPIEUP YO
    case 0xBBD0: code_point = 0xBFC5; break; // HANGUL SYLLABLE SSANGPIEUP YO IEUNG
    case 0xBBD1: code_point = 0xBFCC; break; // HANGUL SYLLABLE SSANGPIEUP U
    case 0xBBD2: code_point = 0xBFCD; break; // HANGUL SYLLABLE SSANGPIEUP U KIYEOK
    case 0xBBD3: code_point = 0xBFD0; break; // HANGUL SYLLABLE SSANGPIEUP U NIEUN
    case 0xBBD4: code_point = 0xBFD4; break; // HANGUL SYLLABLE SSANGPIEUP U RIEUL
    case 0xBBD5: code_point = 0xBFDC; break; // HANGUL SYLLABLE SSANGPIEUP U MIEUM
    case 0xBBD6: code_point = 0xBFDF; break; // HANGUL SYLLABLE SSANGPIEUP U SIOS
    case 0xBBD7: code_point = 0xBFE1; break; // HANGUL SYLLABLE SSANGPIEUP U IEUNG
    case 0xBBD8: code_point = 0xC03C; break; // HANGUL SYLLABLE SSANGPIEUP YU
    case 0xBBD9: code_point = 0xC051; break; // HANGUL SYLLABLE SSANGPIEUP YU IEUNG
    case 0xBBDA: code_point = 0xC058; break; // HANGUL SYLLABLE SSANGPIEUP EU
    case 0xBBDB: code_point = 0xC05C; break; // HANGUL SYLLABLE SSANGPIEUP EU NIEUN
    case 0xBBDC: code_point = 0xC060; break; // HANGUL SYLLABLE SSANGPIEUP EU RIEUL
    case 0xBBDD: code_point = 0xC068; break; // HANGUL SYLLABLE SSANGPIEUP EU MIEUM
    case 0xBBDE: code_point = 0xC069; break; // HANGUL SYLLABLE SSANGPIEUP EU PIEUP
    case 0xBBDF: code_point = 0xC090; break; // HANGUL SYLLABLE SSANGPIEUP I
    case 0xBBE0: code_point = 0xC091; break; // HANGUL SYLLABLE SSANGPIEUP I KIYEOK
    case 0xBBE1: code_point = 0xC094; break; // HANGUL SYLLABLE SSANGPIEUP I NIEUN
    case 0xBBE2: code_point = 0xC098; break; // HANGUL SYLLABLE SSANGPIEUP I RIEUL
    case 0xBBE3: code_point = 0xC0A0; break; // HANGUL SYLLABLE SSANGPIEUP I MIEUM
    case 0xBBE4: code_point = 0xC0A1; break; // HANGUL SYLLABLE SSANGPIEUP I PIEUP
    case 0xBBE5: code_point = 0xC0A3; break; // HANGUL SYLLABLE SSANGPIEUP I SIOS
    case 0xBBE6: code_point = 0xC0A5; break; // HANGUL SYLLABLE SSANGPIEUP I IEUNG
    case 0xBBE7: code_point = 0xC0AC; break; // HANGUL SYLLABLE SIOS A
    case 0xBBE8: code_point = 0xC0AD; break; // HANGUL SYLLABLE SIOS A KIYEOK
    case 0xBBE9: code_point = 0xC0AF; break; // HANGUL SYLLABLE SIOS A KIYEOKSIOS
    case 0xBBEA: code_point = 0xC0B0; break; // HANGUL SYLLABLE SIOS A NIEUN
    case 0xBBEB: code_point = 0xC0B3; break; // HANGUL SYLLABLE SIOS A TIKEUT
    case 0xBBEC: code_point = 0xC0B4; break; // HANGUL SYLLABLE SIOS A RIEUL
    case 0xBBED: code_point = 0xC0B5; break; // HANGUL SYLLABLE SIOS A RIEULKIYEOK
    case 0xBBEE: code_point = 0xC0B6; break; // HANGUL SYLLABLE SIOS A RIEULMIEUM
    case 0xBBEF: code_point = 0xC0BC; break; // HANGUL SYLLABLE SIOS A MIEUM
    case 0xBBF0: code_point = 0xC0BD; break; // HANGUL SYLLABLE SIOS A PIEUP
    case 0xBBF1: code_point = 0xC0BF; break; // HANGUL SYLLABLE SIOS A SIOS
    case 0xBBF2: code_point = 0xC0C0; break; // HANGUL SYLLABLE SIOS A SSANGSIOS
    case 0xBBF3: code_point = 0xC0C1; break; // HANGUL SYLLABLE SIOS A IEUNG
    case 0xBBF4: code_point = 0xC0C5; break; // HANGUL SYLLABLE SIOS A THIEUTH
    case 0xBBF5: code_point = 0xC0C8; break; // HANGUL SYLLABLE SIOS AE
    case 0xBBF6: code_point = 0xC0C9; break; // HANGUL SYLLABLE SIOS AE KIYEOK
    case 0xBBF7: code_point = 0xC0CC; break; // HANGUL SYLLABLE SIOS AE NIEUN
    case 0xBBF8: code_point = 0xC0D0; break; // HANGUL SYLLABLE SIOS AE RIEUL
    case 0xBBF9: code_point = 0xC0D8; break; // HANGUL SYLLABLE SIOS AE MIEUM
    case 0xBBFA: code_point = 0xC0D9; break; // HANGUL SYLLABLE SIOS AE PIEUP
    case 0xBBFB: code_point = 0xC0DB; break; // HANGUL SYLLABLE SIOS AE SIOS
    case 0xBBFC: code_point = 0xC0DC; break; // HANGUL SYLLABLE SIOS AE SSANGSIOS
    case 0xBBFD: code_point = 0xC0DD; break; // HANGUL SYLLABLE SIOS AE IEUNG
    case 0xBBFE: code_point = 0xC0E4; break; // HANGUL SYLLABLE SIOS YA
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xBC(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xBC41: code_point = 0xD36A; break; // HANGUL SYLLABLE PHIEUPH YAE RIEULMIEUM
    case 0xBC42: code_point = 0xD36B; break; // HANGUL SYLLABLE PHIEUPH YAE RIEULPIEUP
    case 0xBC43: code_point = 0xD36C; break; // HANGUL SYLLABLE PHIEUPH YAE RIEULSIOS
    case 0xBC44: code_point = 0xD36D; break; // HANGUL SYLLABLE PHIEUPH YAE RIEULTHIEUTH
    case 0xBC45: code_point = 0xD36E; break; // HANGUL SYLLABLE PHIEUPH YAE RIEULPHIEUPH
    case 0xBC46: code_point = 0xD36F; break; // HANGUL SYLLABLE PHIEUPH YAE RIEULHIEUH
    case 0xBC47: code_point = 0xD370; break; // HANGUL SYLLABLE PHIEUPH YAE MIEUM
    case 0xBC48: code_point = 0xD371; break; // HANGUL SYLLABLE PHIEUPH YAE PIEUP
    case 0xBC49: code_point = 0xD372; break; // HANGUL SYLLABLE PHIEUPH YAE PIEUPSIOS
    case 0xBC4A: code_point = 0xD373; break; // HANGUL SYLLABLE PHIEUPH YAE SIOS
    case 0xBC4B: code_point = 0xD374; break; // HANGUL SYLLABLE PHIEUPH YAE SSANGSIOS
    case 0xBC4C: code_point = 0xD375; break; // HANGUL SYLLABLE PHIEUPH YAE IEUNG
    case 0xBC4D: code_point = 0xD376; break; // HANGUL SYLLABLE PHIEUPH YAE CIEUC
    case 0xBC4E: code_point = 0xD377; break; // HANGUL SYLLABLE PHIEUPH YAE CHIEUCH
    case 0xBC4F: code_point = 0xD378; break; // HANGUL SYLLABLE PHIEUPH YAE KHIEUKH
    case 0xBC50: code_point = 0xD379; break; // HANGUL SYLLABLE PHIEUPH YAE THIEUTH
    case 0xBC51: code_point = 0xD37A; break; // HANGUL SYLLABLE PHIEUPH YAE PHIEUPH
    case 0xBC52: code_point = 0xD37B; break; // HANGUL SYLLABLE PHIEUPH YAE HIEUH
    case 0xBC53: code_point = 0xD37E; break; // HANGUL SYLLABLE PHIEUPH EO SSANGKIYEOK
    case 0xBC54: code_point = 0xD37F; break; // HANGUL SYLLABLE PHIEUPH EO KIYEOKSIOS
    case 0xBC55: code_point = 0xD381; break; // HANGUL SYLLABLE PHIEUPH EO NIEUNCIEUC
    case 0xBC56: code_point = 0xD382; break; // HANGUL SYLLABLE PHIEUPH EO NIEUNHIEUH
    case 0xBC57: code_point = 0xD383; break; // HANGUL SYLLABLE PHIEUPH EO TIKEUT
    case 0xBC58: code_point = 0xD385; break; // HANGUL SYLLABLE PHIEUPH EO RIEULKIYEOK
    case 0xBC59: code_point = 0xD386; break; // HANGUL SYLLABLE PHIEUPH EO RIEULMIEUM
    case 0xBC5A: code_point = 0xD387; break; // HANGUL SYLLABLE PHIEUPH EO RIEULPIEUP
    case 0xBC61: code_point = 0xD388; break; // HANGUL SYLLABLE PHIEUPH EO RIEULSIOS
    case 0xBC62: code_point = 0xD389; break; // HANGUL SYLLABLE PHIEUPH EO RIEULTHIEUTH
    case 0xBC63: code_point = 0xD38A; break; // HANGUL SYLLABLE PHIEUPH EO RIEULPHIEUPH
    case 0xBC64: code_point = 0xD38B; break; // HANGUL SYLLABLE PHIEUPH EO RIEULHIEUH
    case 0xBC65: code_point = 0xD38E; break; // HANGUL SYLLABLE PHIEUPH EO PIEUPSIOS
    case 0xBC66: code_point = 0xD392; break; // HANGUL SYLLABLE PHIEUPH EO CIEUC
    case 0xBC67: code_point = 0xD393; break; // HANGUL SYLLABLE PHIEUPH EO CHIEUCH
    case 0xBC68: code_point = 0xD394; break; // HANGUL SYLLABLE PHIEUPH EO KHIEUKH
    case 0xBC69: code_point = 0xD395; break; // HANGUL SYLLABLE PHIEUPH EO THIEUTH
    case 0xBC6A: code_point = 0xD396; break; // HANGUL SYLLABLE PHIEUPH EO PHIEUPH
    case 0xBC6B: code_point = 0xD397; break; // HANGUL SYLLABLE PHIEUPH EO HIEUH
    case 0xBC6C: code_point = 0xD39A; break; // HANGUL SYLLABLE PHIEUPH E SSANGKIYEOK
    case 0xBC6D: code_point = 0xD39B; break; // HANGUL SYLLABLE PHIEUPH E KIYEOKSIOS
    case 0xBC6E: code_point = 0xD39D; break; // HANGUL SYLLABLE PHIEUPH E NIEUNCIEUC
    case 0xBC6F: code_point = 0xD39E; break; // HANGUL SYLLABLE PHIEUPH E NIEUNHIEUH
    case 0xBC70: code_point = 0xD39F; break; // HANGUL SYLLABLE PHIEUPH E TIKEUT
    case 0xBC71: code_point = 0xD3A1; break; // HANGUL SYLLABLE PHIEUPH E RIEULKIYEOK
    case 0xBC72: code_point = 0xD3A2; break; // HANGUL SYLLABLE PHIEUPH E RIEULMIEUM
    case 0xBC73: code_point = 0xD3A3; break; // HANGUL SYLLABLE PHIEUPH E RIEULPIEUP
    case 0xBC74: code_point = 0xD3A4; break; // HANGUL SYLLABLE PHIEUPH E RIEULSIOS
    case 0xBC75: code_point = 0xD3A5; break; // HANGUL SYLLABLE PHIEUPH E RIEULTHIEUTH
    case 0xBC76: code_point = 0xD3A6; break; // HANGUL SYLLABLE PHIEUPH E RIEULPHIEUPH
    case 0xBC77: code_point = 0xD3A7; break; // HANGUL SYLLABLE PHIEUPH E RIEULHIEUH
    case 0xBC78: code_point = 0xD3AA; break; // HANGUL SYLLABLE PHIEUPH E PIEUPSIOS
    case 0xBC79: code_point = 0xD3AC; break; // HANGUL SYLLABLE PHIEUPH E SSANGSIOS
    case 0xBC7A: code_point = 0xD3AE; break; // HANGUL SYLLABLE PHIEUPH E CIEUC
    case 0xBC81: code_point = 0xD3AF; break; // HANGUL SYLLABLE PHIEUPH E CHIEUCH
    case 0xBC82: code_point = 0xD3B0; break; // HANGUL SYLLABLE PHIEUPH E KHIEUKH
    case 0xBC83: code_point = 0xD3B1; break; // HANGUL SYLLABLE PHIEUPH E THIEUTH
    case 0xBC84: code_point = 0xD3B2; break; // HANGUL SYLLABLE PHIEUPH E PHIEUPH
    case 0xBC85: code_point = 0xD3B3; break; // HANGUL SYLLABLE PHIEUPH E HIEUH
    case 0xBC86: code_point = 0xD3B5; break; // HANGUL SYLLABLE PHIEUPH YEO KIYEOK
    case 0xBC87: code_point = 0xD3B6; break; // HANGUL SYLLABLE PHIEUPH YEO SSANGKIYEOK
    case 0xBC88: code_point = 0xD3B7; break; // HANGUL SYLLABLE PHIEUPH YEO KIYEOKSIOS
    case 0xBC89: code_point = 0xD3B9; break; // HANGUL SYLLABLE PHIEUPH YEO NIEUNCIEUC
    case 0xBC8A: code_point = 0xD3BA; break; // HANGUL SYLLABLE PHIEUPH YEO NIEUNHIEUH
    case 0xBC8B: code_point = 0xD3BB; break; // HANGUL SYLLABLE PHIEUPH YEO TIKEUT
    case 0xBC8C: code_point = 0xD3BD; break; // HANGUL SYLLABLE PHIEUPH YEO RIEULKIYEOK
    case 0xBC8D: code_point = 0xD3BE; break; // HANGUL SYLLABLE PHIEUPH YEO RIEULMIEUM
    case 0xBC8E: code_point = 0xD3BF; break; // HANGUL SYLLABLE PHIEUPH YEO RIEULPIEUP
    case 0xBC8F: code_point = 0xD3C0; break; // HANGUL SYLLABLE PHIEUPH YEO RIEULSIOS
    case 0xBC90: code_point = 0xD3C1; break; // HANGUL SYLLABLE PHIEUPH YEO RIEULTHIEUTH
    case 0xBC91: code_point = 0xD3C2; break; // HANGUL SYLLABLE PHIEUPH YEO RIEULPHIEUPH
    case 0xBC92: code_point = 0xD3C3; break; // HANGUL SYLLABLE PHIEUPH YEO RIEULHIEUH
    case 0xBC93: code_point = 0xD3C6; break; // HANGUL SYLLABLE PHIEUPH YEO PIEUPSIOS
    case 0xBC94: code_point = 0xD3C7; break; // HANGUL SYLLABLE PHIEUPH YEO SIOS
    case 0xBC95: code_point = 0xD3CA; break; // HANGUL SYLLABLE PHIEUPH YEO CIEUC
    case 0xBC96: code_point = 0xD3CB; break; // HANGUL SYLLABLE PHIEUPH YEO CHIEUCH
    case 0xBC97: code_point = 0xD3CC; break; // HANGUL SYLLABLE PHIEUPH YEO KHIEUKH
    case 0xBC98: code_point = 0xD3CD; break; // HANGUL SYLLABLE PHIEUPH YEO THIEUTH
    case 0xBC99: code_point = 0xD3CE; break; // HANGUL SYLLABLE PHIEUPH YEO PHIEUPH
    case 0xBC9A: code_point = 0xD3CF; break; // HANGUL SYLLABLE PHIEUPH YEO HIEUH
    case 0xBC9B: code_point = 0xD3D1; break; // HANGUL SYLLABLE PHIEUPH YE KIYEOK
    case 0xBC9C: code_point = 0xD3D2; break; // HANGUL SYLLABLE PHIEUPH YE SSANGKIYEOK
    case 0xBC9D: code_point = 0xD3D3; break; // HANGUL SYLLABLE PHIEUPH YE KIYEOKSIOS
    case 0xBC9E: code_point = 0xD3D4; break; // HANGUL SYLLABLE PHIEUPH YE NIEUN
    case 0xBC9F: code_point = 0xD3D5; break; // HANGUL SYLLABLE PHIEUPH YE NIEUNCIEUC
    case 0xBCA0: code_point = 0xD3D6; break; // HANGUL SYLLABLE PHIEUPH YE NIEUNHIEUH
    case 0xBCA1: code_point = 0xC0E5; break; // HANGUL SYLLABLE SIOS YA KIYEOK
    case 0xBCA2: code_point = 0xC0E8; break; // HANGUL SYLLABLE SIOS YA NIEUN
    case 0xBCA3: code_point = 0xC0EC; break; // HANGUL SYLLABLE SIOS YA RIEUL
    case 0xBCA4: code_point = 0xC0F4; break; // HANGUL SYLLABLE SIOS YA MIEUM
    case 0xBCA5: code_point = 0xC0F5; break; // HANGUL SYLLABLE SIOS YA PIEUP
    case 0xBCA6: code_point = 0xC0F7; break; // HANGUL SYLLABLE SIOS YA SIOS
    case 0xBCA7: code_point = 0xC0F9; break; // HANGUL SYLLABLE SIOS YA IEUNG
    case 0xBCA8: code_point = 0xC100; break; // HANGUL SYLLABLE SIOS YAE
    case 0xBCA9: code_point = 0xC104; break; // HANGUL SYLLABLE SIOS YAE NIEUN
    case 0xBCAA: code_point = 0xC108; break; // HANGUL SYLLABLE SIOS YAE RIEUL
    case 0xBCAB: code_point = 0xC110; break; // HANGUL SYLLABLE SIOS YAE MIEUM
    case 0xBCAC: code_point = 0xC115; break; // HANGUL SYLLABLE SIOS YAE IEUNG
    case 0xBCAD: code_point = 0xC11C; break; // HANGUL SYLLABLE SIOS EO
    case 0xBCAE: code_point = 0xC11D; break; // HANGUL SYLLABLE SIOS EO KIYEOK
    case 0xBCAF: code_point = 0xC11E; break; // HANGUL SYLLABLE SIOS EO SSANGKIYEOK
    case 0xBCB0: code_point = 0xC11F; break; // HANGUL SYLLABLE SIOS EO KIYEOKSIOS
    case 0xBCB1: code_point = 0xC120; break; // HANGUL SYLLABLE SIOS EO NIEUN
    case 0xBCB2: code_point = 0xC123; break; // HANGUL SYLLABLE SIOS EO TIKEUT
    case 0xBCB3: code_point = 0xC124; break; // HANGUL SYLLABLE SIOS EO RIEUL
    case 0xBCB4: code_point = 0xC126; break; // HANGUL SYLLABLE SIOS EO RIEULMIEUM
    case 0xBCB5: code_point = 0xC127; break; // HANGUL SYLLABLE SIOS EO RIEULPIEUP
    case 0xBCB6: code_point = 0xC12C; break; // HANGUL SYLLABLE SIOS EO MIEUM
    case 0xBCB7: code_point = 0xC12D; break; // HANGUL SYLLABLE SIOS EO PIEUP
    case 0xBCB8: code_point = 0xC12F; break; // HANGUL SYLLABLE SIOS EO SIOS
    case 0xBCB9: code_point = 0xC130; break; // HANGUL SYLLABLE SIOS EO SSANGSIOS
    case 0xBCBA: code_point = 0xC131; break; // HANGUL SYLLABLE SIOS EO IEUNG
    case 0xBCBB: code_point = 0xC136; break; // HANGUL SYLLABLE SIOS EO PHIEUPH
    case 0xBCBC: code_point = 0xC138; break; // HANGUL SYLLABLE SIOS E
    case 0xBCBD: code_point = 0xC139; break; // HANGUL SYLLABLE SIOS E KIYEOK
    case 0xBCBE: code_point = 0xC13C; break; // HANGUL SYLLABLE SIOS E NIEUN
    case 0xBCBF: code_point = 0xC140; break; // HANGUL SYLLABLE SIOS E RIEUL
    case 0xBCC0: code_point = 0xC148; break; // HANGUL SYLLABLE SIOS E MIEUM
    case 0xBCC1: code_point = 0xC149; break; // HANGUL SYLLABLE SIOS E PIEUP
    case 0xBCC2: code_point = 0xC14B; break; // HANGUL SYLLABLE SIOS E SIOS
    case 0xBCC3: code_point = 0xC14C; break; // HANGUL SYLLABLE SIOS E SSANGSIOS
    case 0xBCC4: code_point = 0xC14D; break; // HANGUL SYLLABLE SIOS E IEUNG
    case 0xBCC5: code_point = 0xC154; break; // HANGUL SYLLABLE SIOS YEO
    case 0xBCC6: code_point = 0xC155; break; // HANGUL SYLLABLE SIOS YEO KIYEOK
    case 0xBCC7: code_point = 0xC158; break; // HANGUL SYLLABLE SIOS YEO NIEUN
    case 0xBCC8: code_point = 0xC15C; break; // HANGUL SYLLABLE SIOS YEO RIEUL
    case 0xBCC9: code_point = 0xC164; break; // HANGUL SYLLABLE SIOS YEO MIEUM
    case 0xBCCA: code_point = 0xC165; break; // HANGUL SYLLABLE SIOS YEO PIEUP
    case 0xBCCB: code_point = 0xC167; break; // HANGUL SYLLABLE SIOS YEO SIOS
    case 0xBCCC: code_point = 0xC168; break; // HANGUL SYLLABLE SIOS YEO SSANGSIOS
    case 0xBCCD: code_point = 0xC169; break; // HANGUL SYLLABLE SIOS YEO IEUNG
    case 0xBCCE: code_point = 0xC170; break; // HANGUL SYLLABLE SIOS YE
    case 0xBCCF: code_point = 0xC174; break; // HANGUL SYLLABLE SIOS YE NIEUN
    case 0xBCD0: code_point = 0xC178; break; // HANGUL SYLLABLE SIOS YE RIEUL
    case 0xBCD1: code_point = 0xC185; break; // HANGUL SYLLABLE SIOS YE IEUNG
    case 0xBCD2: code_point = 0xC18C; break; // HANGUL SYLLABLE SIOS O
    case 0xBCD3: code_point = 0xC18D; break; // HANGUL SYLLABLE SIOS O KIYEOK
    case 0xBCD4: code_point = 0xC18E; break; // HANGUL SYLLABLE SIOS O SSANGKIYEOK
    case 0xBCD5: code_point = 0xC190; break; // HANGUL SYLLABLE SIOS O NIEUN
    case 0xBCD6: code_point = 0xC194; break; // HANGUL SYLLABLE SIOS O RIEUL
    case 0xBCD7: code_point = 0xC196; break; // HANGUL SYLLABLE SIOS O RIEULMIEUM
    case 0xBCD8: code_point = 0xC19C; break; // HANGUL SYLLABLE SIOS O MIEUM
    case 0xBCD9: code_point = 0xC19D; break; // HANGUL SYLLABLE SIOS O PIEUP
    case 0xBCDA: code_point = 0xC19F; break; // HANGUL SYLLABLE SIOS O SIOS
    case 0xBCDB: code_point = 0xC1A1; break; // HANGUL SYLLABLE SIOS O IEUNG
    case 0xBCDC: code_point = 0xC1A5; break; // HANGUL SYLLABLE SIOS O THIEUTH
    case 0xBCDD: code_point = 0xC1A8; break; // HANGUL SYLLABLE SIOS WA
    case 0xBCDE: code_point = 0xC1A9; break; // HANGUL SYLLABLE SIOS WA KIYEOK
    case 0xBCDF: code_point = 0xC1AC; break; // HANGUL SYLLABLE SIOS WA NIEUN
    case 0xBCE0: code_point = 0xC1B0; break; // HANGUL SYLLABLE SIOS WA RIEUL
    case 0xBCE1: code_point = 0xC1BD; break; // HANGUL SYLLABLE SIOS WA IEUNG
    case 0xBCE2: code_point = 0xC1C4; break; // HANGUL SYLLABLE SIOS WAE
    case 0xBCE3: code_point = 0xC1C8; break; // HANGUL SYLLABLE SIOS WAE NIEUN
    case 0xBCE4: code_point = 0xC1CC; break; // HANGUL SYLLABLE SIOS WAE RIEUL
    case 0xBCE5: code_point = 0xC1D4; break; // HANGUL SYLLABLE SIOS WAE MIEUM
    case 0xBCE6: code_point = 0xC1D7; break; // HANGUL SYLLABLE SIOS WAE SIOS
    case 0xBCE7: code_point = 0xC1D8; break; // HANGUL SYLLABLE SIOS WAE SSANGSIOS
    case 0xBCE8: code_point = 0xC1E0; break; // HANGUL SYLLABLE SIOS OE
    case 0xBCE9: code_point = 0xC1E4; break; // HANGUL SYLLABLE SIOS OE NIEUN
    case 0xBCEA: code_point = 0xC1E8; break; // HANGUL SYLLABLE SIOS OE RIEUL
    case 0xBCEB: code_point = 0xC1F0; break; // HANGUL SYLLABLE SIOS OE MIEUM
    case 0xBCEC: code_point = 0xC1F1; break; // HANGUL SYLLABLE SIOS OE PIEUP
    case 0xBCED: code_point = 0xC1F3; break; // HANGUL SYLLABLE SIOS OE SIOS
    case 0xBCEE: code_point = 0xC1FC; break; // HANGUL SYLLABLE SIOS YO
    case 0xBCEF: code_point = 0xC1FD; break; // HANGUL SYLLABLE SIOS YO KIYEOK
    case 0xBCF0: code_point = 0xC200; break; // HANGUL SYLLABLE SIOS YO NIEUN
    case 0xBCF1: code_point = 0xC204; break; // HANGUL SYLLABLE SIOS YO RIEUL
    case 0xBCF2: code_point = 0xC20C; break; // HANGUL SYLLABLE SIOS YO MIEUM
    case 0xBCF3: code_point = 0xC20D; break; // HANGUL SYLLABLE SIOS YO PIEUP
    case 0xBCF4: code_point = 0xC20F; break; // HANGUL SYLLABLE SIOS YO SIOS
    case 0xBCF5: code_point = 0xC211; break; // HANGUL SYLLABLE SIOS YO IEUNG
    case 0xBCF6: code_point = 0xC218; break; // HANGUL SYLLABLE SIOS U
    case 0xBCF7: code_point = 0xC219; break; // HANGUL SYLLABLE SIOS U KIYEOK
    case 0xBCF8: code_point = 0xC21C; break; // HANGUL SYLLABLE SIOS U NIEUN
    case 0xBCF9: code_point = 0xC21F; break; // HANGUL SYLLABLE SIOS U TIKEUT
    case 0xBCFA: code_point = 0xC220; break; // HANGUL SYLLABLE SIOS U RIEUL
    case 0xBCFB: code_point = 0xC228; break; // HANGUL SYLLABLE SIOS U MIEUM
    case 0xBCFC: code_point = 0xC229; break; // HANGUL SYLLABLE SIOS U PIEUP
    case 0xBCFD: code_point = 0xC22B; break; // HANGUL SYLLABLE SIOS U SIOS
    case 0xBCFE: code_point = 0xC22D; break; // HANGUL SYLLABLE SIOS U IEUNG
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xBD(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xBD41: code_point = 0xD3D7; break; // HANGUL SYLLABLE PHIEUPH YE TIKEUT
    case 0xBD42: code_point = 0xD3D9; break; // HANGUL SYLLABLE PHIEUPH YE RIEULKIYEOK
    case 0xBD43: code_point = 0xD3DA; break; // HANGUL SYLLABLE PHIEUPH YE RIEULMIEUM
    case 0xBD44: code_point = 0xD3DB; break; // HANGUL SYLLABLE PHIEUPH YE RIEULPIEUP
    case 0xBD45: code_point = 0xD3DC; break; // HANGUL SYLLABLE PHIEUPH YE RIEULSIOS
    case 0xBD46: code_point = 0xD3DD; break; // HANGUL SYLLABLE PHIEUPH YE RIEULTHIEUTH
    case 0xBD47: code_point = 0xD3DE; break; // HANGUL SYLLABLE PHIEUPH YE RIEULPHIEUPH
    case 0xBD48: code_point = 0xD3DF; break; // HANGUL SYLLABLE PHIEUPH YE RIEULHIEUH
    case 0xBD49: code_point = 0xD3E0; break; // HANGUL SYLLABLE PHIEUPH YE MIEUM
    case 0xBD4A: code_point = 0xD3E2; break; // HANGUL SYLLABLE PHIEUPH YE PIEUPSIOS
    case 0xBD4B: code_point = 0xD3E4; break; // HANGUL SYLLABLE PHIEUPH YE SSANGSIOS
    case 0xBD4C: code_point = 0xD3E5; break; // HANGUL SYLLABLE PHIEUPH YE IEUNG
    case 0xBD4D: code_point = 0xD3E6; break; // HANGUL SYLLABLE PHIEUPH YE CIEUC
    case 0xBD4E: code_point = 0xD3E7; break; // HANGUL SYLLABLE PHIEUPH YE CHIEUCH
    case 0xBD4F: code_point = 0xD3E8; break; // HANGUL SYLLABLE PHIEUPH YE KHIEUKH
    case 0xBD50: code_point = 0xD3E9; break; // HANGUL SYLLABLE PHIEUPH YE THIEUTH
    case 0xBD51: code_point = 0xD3EA; break; // HANGUL SYLLABLE PHIEUPH YE PHIEUPH
    case 0xBD52: code_point = 0xD3EB; break; // HANGUL SYLLABLE PHIEUPH YE HIEUH
    case 0xBD53: code_point = 0xD3EE; break; // HANGUL SYLLABLE PHIEUPH O SSANGKIYEOK
    case 0xBD54: code_point = 0xD3EF; break; // HANGUL SYLLABLE PHIEUPH O KIYEOKSIOS
    case 0xBD55: code_point = 0xD3F1; break; // HANGUL SYLLABLE PHIEUPH O NIEUNCIEUC
    case 0xBD56: code_point = 0xD3F2; break; // HANGUL SYLLABLE PHIEUPH O NIEUNHIEUH
    case 0xBD57: code_point = 0xD3F3; break; // HANGUL SYLLABLE PHIEUPH O TIKEUT
    case 0xBD58: code_point = 0xD3F5; break; // HANGUL SYLLABLE PHIEUPH O RIEULKIYEOK
    case 0xBD59: code_point = 0xD3F6; break; // HANGUL SYLLABLE PHIEUPH O RIEULMIEUM
    case 0xBD5A: code_point = 0xD3F7; break; // HANGUL SYLLABLE PHIEUPH O RIEULPIEUP
    case 0xBD61: code_point = 0xD3F8; break; // HANGUL SYLLABLE PHIEUPH O RIEULSIOS
    case 0xBD62: code_point = 0xD3F9; break; // HANGUL SYLLABLE PHIEUPH O RIEULTHIEUTH
    case 0xBD63: code_point = 0xD3FA; break; // HANGUL SYLLABLE PHIEUPH O RIEULPHIEUPH
    case 0xBD64: code_point = 0xD3FB; break; // HANGUL SYLLABLE PHIEUPH O RIEULHIEUH
    case 0xBD65: code_point = 0xD3FE; break; // HANGUL SYLLABLE PHIEUPH O PIEUPSIOS
    case 0xBD66: code_point = 0xD400; break; // HANGUL SYLLABLE PHIEUPH O SSANGSIOS
    case 0xBD67: code_point = 0xD402; break; // HANGUL SYLLABLE PHIEUPH O CIEUC
    case 0xBD68: code_point = 0xD403; break; // HANGUL SYLLABLE PHIEUPH O CHIEUCH
    case 0xBD69: code_point = 0xD404; break; // HANGUL SYLLABLE PHIEUPH O KHIEUKH
    case 0xBD6A: code_point = 0xD405; break; // HANGUL SYLLABLE PHIEUPH O THIEUTH
    case 0xBD6B: code_point = 0xD406; break; // HANGUL SYLLABLE PHIEUPH O PHIEUPH
    case 0xBD6C: code_point = 0xD407; break; // HANGUL SYLLABLE PHIEUPH O HIEUH
    case 0xBD6D: code_point = 0xD409; break; // HANGUL SYLLABLE PHIEUPH WA KIYEOK
    case 0xBD6E: code_point = 0xD40A; break; // HANGUL SYLLABLE PHIEUPH WA SSANGKIYEOK
    case 0xBD6F: code_point = 0xD40B; break; // HANGUL SYLLABLE PHIEUPH WA KIYEOKSIOS
    case 0xBD70: code_point = 0xD40C; break; // HANGUL SYLLABLE PHIEUPH WA NIEUN
    case 0xBD71: code_point = 0xD40D; break; // HANGUL SYLLABLE PHIEUPH WA NIEUNCIEUC
    case 0xBD72: code_point = 0xD40E; break; // HANGUL SYLLABLE PHIEUPH WA NIEUNHIEUH
    case 0xBD73: code_point = 0xD40F; break; // HANGUL SYLLABLE PHIEUPH WA TIKEUT
    case 0xBD74: code_point = 0xD410; break; // HANGUL SYLLABLE PHIEUPH WA RIEUL
    case 0xBD75: code_point = 0xD411; break; // HANGUL SYLLABLE PHIEUPH WA RIEULKIYEOK
    case 0xBD76: code_point = 0xD412; break; // HANGUL SYLLABLE PHIEUPH WA RIEULMIEUM
    case 0xBD77: code_point = 0xD413; break; // HANGUL SYLLABLE PHIEUPH WA RIEULPIEUP
    case 0xBD78: code_point = 0xD414; break; // HANGUL SYLLABLE PHIEUPH WA RIEULSIOS
    case 0xBD79: code_point = 0xD415; break; // HANGUL SYLLABLE PHIEUPH WA RIEULTHIEUTH
    case 0xBD7A: code_point = 0xD416; break; // HANGUL SYLLABLE PHIEUPH WA RIEULPHIEUPH
    case 0xBD81: code_point = 0xD417; break; // HANGUL SYLLABLE PHIEUPH WA RIEULHIEUH
    case 0xBD82: code_point = 0xD418; break; // HANGUL SYLLABLE PHIEUPH WA MIEUM
    case 0xBD83: code_point = 0xD419; break; // HANGUL SYLLABLE PHIEUPH WA PIEUP
    case 0xBD84: code_point = 0xD41A; break; // HANGUL SYLLABLE PHIEUPH WA PIEUPSIOS
    case 0xBD85: code_point = 0xD41B; break; // HANGUL SYLLABLE PHIEUPH WA SIOS
    case 0xBD86: code_point = 0xD41C; break; // HANGUL SYLLABLE PHIEUPH WA SSANGSIOS
    case 0xBD87: code_point = 0xD41E; break; // HANGUL SYLLABLE PHIEUPH WA CIEUC
    case 0xBD88: code_point = 0xD41F; break; // HANGUL SYLLABLE PHIEUPH WA CHIEUCH
    case 0xBD89: code_point = 0xD420; break; // HANGUL SYLLABLE PHIEUPH WA KHIEUKH
    case 0xBD8A: code_point = 0xD421; break; // HANGUL SYLLABLE PHIEUPH WA THIEUTH
    case 0xBD8B: code_point = 0xD422; break; // HANGUL SYLLABLE PHIEUPH WA PHIEUPH
    case 0xBD8C: code_point = 0xD423; break; // HANGUL SYLLABLE PHIEUPH WA HIEUH
    case 0xBD8D: code_point = 0xD424; break; // HANGUL SYLLABLE PHIEUPH WAE
    case 0xBD8E: code_point = 0xD425; break; // HANGUL SYLLABLE PHIEUPH WAE KIYEOK
    case 0xBD8F: code_point = 0xD426; break; // HANGUL SYLLABLE PHIEUPH WAE SSANGKIYEOK
    case 0xBD90: code_point = 0xD427; break; // HANGUL SYLLABLE PHIEUPH WAE KIYEOKSIOS
    case 0xBD91: code_point = 0xD428; break; // HANGUL SYLLABLE PHIEUPH WAE NIEUN
    case 0xBD92: code_point = 0xD429; break; // HANGUL SYLLABLE PHIEUPH WAE NIEUNCIEUC
    case 0xBD93: code_point = 0xD42A; break; // HANGUL SYLLABLE PHIEUPH WAE NIEUNHIEUH
    case 0xBD94: code_point = 0xD42B; break; // HANGUL SYLLABLE PHIEUPH WAE TIKEUT
    case 0xBD95: code_point = 0xD42C; break; // HANGUL SYLLABLE PHIEUPH WAE RIEUL
    case 0xBD96: code_point = 0xD42D; break; // HANGUL SYLLABLE PHIEUPH WAE RIEULKIYEOK
    case 0xBD97: code_point = 0xD42E; break; // HANGUL SYLLABLE PHIEUPH WAE RIEULMIEUM
    case 0xBD98: code_point = 0xD42F; break; // HANGUL SYLLABLE PHIEUPH WAE RIEULPIEUP
    case 0xBD99: code_point = 0xD430; break; // HANGUL SYLLABLE PHIEUPH WAE RIEULSIOS
    case 0xBD9A: code_point = 0xD431; break; // HANGUL SYLLABLE PHIEUPH WAE RIEULTHIEUTH
    case 0xBD9B: code_point = 0xD432; break; // HANGUL SYLLABLE PHIEUPH WAE RIEULPHIEUPH
    case 0xBD9C: code_point = 0xD433; break; // HANGUL SYLLABLE PHIEUPH WAE RIEULHIEUH
    case 0xBD9D: code_point = 0xD434; break; // HANGUL SYLLABLE PHIEUPH WAE MIEUM
    case 0xBD9E: code_point = 0xD435; break; // HANGUL SYLLABLE PHIEUPH WAE PIEUP
    case 0xBD9F: code_point = 0xD436; break; // HANGUL SYLLABLE PHIEUPH WAE PIEUPSIOS
    case 0xBDA0: code_point = 0xD437; break; // HANGUL SYLLABLE PHIEUPH WAE SIOS
    case 0xBDA1: code_point = 0xC22F; break; // HANGUL SYLLABLE SIOS U CHIEUCH
    case 0xBDA2: code_point = 0xC231; break; // HANGUL SYLLABLE SIOS U THIEUTH
    case 0xBDA3: code_point = 0xC232; break; // HANGUL SYLLABLE SIOS U PHIEUPH
    case 0xBDA4: code_point = 0xC234; break; // HANGUL SYLLABLE SIOS WEO
    case 0xBDA5: code_point = 0xC248; break; // HANGUL SYLLABLE SIOS WEO SSANGSIOS
    case 0xBDA6: code_point = 0xC250; break; // HANGUL SYLLABLE SIOS WE
    case 0xBDA7: code_point = 0xC251; break; // HANGUL SYLLABLE SIOS WE KIYEOK
    case 0xBDA8: code_point = 0xC254; break; // HANGUL SYLLABLE SIOS WE NIEUN
    case 0xBDA9: code_point = 0xC258; break; // HANGUL SYLLABLE SIOS WE RIEUL
    case 0xBDAA: code_point = 0xC260; break; // HANGUL SYLLABLE SIOS WE MIEUM
    case 0xBDAB: code_point = 0xC265; break; // HANGUL SYLLABLE SIOS WE IEUNG
    case 0xBDAC: code_point = 0xC26C; break; // HANGUL SYLLABLE SIOS WI
    case 0xBDAD: code_point = 0xC26D; break; // HANGUL SYLLABLE SIOS WI KIYEOK
    case 0xBDAE: code_point = 0xC270; break; // HANGUL SYLLABLE SIOS WI NIEUN
    case 0xBDAF: code_point = 0xC274; break; // HANGUL SYLLABLE SIOS WI RIEUL
    case 0xBDB0: code_point = 0xC27C; break; // HANGUL SYLLABLE SIOS WI MIEUM
    case 0xBDB1: code_point = 0xC27D; break; // HANGUL SYLLABLE SIOS WI PIEUP
    case 0xBDB2: code_point = 0xC27F; break; // HANGUL SYLLABLE SIOS WI SIOS
    case 0xBDB3: code_point = 0xC281; break; // HANGUL SYLLABLE SIOS WI IEUNG
    case 0xBDB4: code_point = 0xC288; break; // HANGUL SYLLABLE SIOS YU
    case 0xBDB5: code_point = 0xC289; break; // HANGUL SYLLABLE SIOS YU KIYEOK
    case 0xBDB6: code_point = 0xC290; break; // HANGUL SYLLABLE SIOS YU RIEUL
    case 0xBDB7: code_point = 0xC298; break; // HANGUL SYLLABLE SIOS YU MIEUM
    case 0xBDB8: code_point = 0xC29B; break; // HANGUL SYLLABLE SIOS YU SIOS
    case 0xBDB9: code_point = 0xC29D; break; // HANGUL SYLLABLE SIOS YU IEUNG
    case 0xBDBA: code_point = 0xC2A4; break; // HANGUL SYLLABLE SIOS EU
    case 0xBDBB: code_point = 0xC2A5; break; // HANGUL SYLLABLE SIOS EU KIYEOK
    case 0xBDBC: code_point = 0xC2A8; break; // HANGUL SYLLABLE SIOS EU NIEUN
    case 0xBDBD: code_point = 0xC2AC; break; // HANGUL SYLLABLE SIOS EU RIEUL
    case 0xBDBE: code_point = 0xC2AD; break; // HANGUL SYLLABLE SIOS EU RIEULKIYEOK
    case 0xBDBF: code_point = 0xC2B4; break; // HANGUL SYLLABLE SIOS EU MIEUM
    case 0xBDC0: code_point = 0xC2B5; break; // HANGUL SYLLABLE SIOS EU PIEUP
    case 0xBDC1: code_point = 0xC2B7; break; // HANGUL SYLLABLE SIOS EU SIOS
    case 0xBDC2: code_point = 0xC2B9; break; // HANGUL SYLLABLE SIOS EU IEUNG
    case 0xBDC3: code_point = 0xC2DC; break; // HANGUL SYLLABLE SIOS I
    case 0xBDC4: code_point = 0xC2DD; break; // HANGUL SYLLABLE SIOS I KIYEOK
    case 0xBDC5: code_point = 0xC2E0; break; // HANGUL SYLLABLE SIOS I NIEUN
    case 0xBDC6: code_point = 0xC2E3; break; // HANGUL SYLLABLE SIOS I TIKEUT
    case 0xBDC7: code_point = 0xC2E4; break; // HANGUL SYLLABLE SIOS I RIEUL
    case 0xBDC8: code_point = 0xC2EB; break; // HANGUL SYLLABLE SIOS I RIEULHIEUH
    case 0xBDC9: code_point = 0xC2EC; break; // HANGUL SYLLABLE SIOS I MIEUM
    case 0xBDCA: code_point = 0xC2ED; break; // HANGUL SYLLABLE SIOS I PIEUP
    case 0xBDCB: code_point = 0xC2EF; break; // HANGUL SYLLABLE SIOS I SIOS
    case 0xBDCC: code_point = 0xC2F1; break; // HANGUL SYLLABLE SIOS I IEUNG
    case 0xBDCD: code_point = 0xC2F6; break; // HANGUL SYLLABLE SIOS I PHIEUPH
    case 0xBDCE: code_point = 0xC2F8; break; // HANGUL SYLLABLE SSANGSIOS A
    case 0xBDCF: code_point = 0xC2F9; break; // HANGUL SYLLABLE SSANGSIOS A KIYEOK
    case 0xBDD0: code_point = 0xC2FB; break; // HANGUL SYLLABLE SSANGSIOS A KIYEOKSIOS
    case 0xBDD1: code_point = 0xC2FC; break; // HANGUL SYLLABLE SSANGSIOS A NIEUN
    case 0xBDD2: code_point = 0xC300; break; // HANGUL SYLLABLE SSANGSIOS A RIEUL
    case 0xBDD3: code_point = 0xC308; break; // HANGUL SYLLABLE SSANGSIOS A MIEUM
    case 0xBDD4: code_point = 0xC309; break; // HANGUL SYLLABLE SSANGSIOS A PIEUP
    case 0xBDD5: code_point = 0xC30C; break; // HANGUL SYLLABLE SSANGSIOS A SSANGSIOS
    case 0xBDD6: code_point = 0xC30D; break; // HANGUL SYLLABLE SSANGSIOS A IEUNG
    case 0xBDD7: code_point = 0xC313; break; // HANGUL SYLLABLE SSANGSIOS A HIEUH
    case 0xBDD8: code_point = 0xC314; break; // HANGUL SYLLABLE SSANGSIOS AE
    case 0xBDD9: code_point = 0xC315; break; // HANGUL SYLLABLE SSANGSIOS AE KIYEOK
    case 0xBDDA: code_point = 0xC318; break; // HANGUL SYLLABLE SSANGSIOS AE NIEUN
    case 0xBDDB: code_point = 0xC31C; break; // HANGUL SYLLABLE SSANGSIOS AE RIEUL
    case 0xBDDC: code_point = 0xC324; break; // HANGUL SYLLABLE SSANGSIOS AE MIEUM
    case 0xBDDD: code_point = 0xC325; break; // HANGUL SYLLABLE SSANGSIOS AE PIEUP
    case 0xBDDE: code_point = 0xC328; break; // HANGUL SYLLABLE SSANGSIOS AE SSANGSIOS
    case 0xBDDF: code_point = 0xC329; break; // HANGUL SYLLABLE SSANGSIOS AE IEUNG
    case 0xBDE0: code_point = 0xC345; break; // HANGUL SYLLABLE SSANGSIOS YA IEUNG
    case 0xBDE1: code_point = 0xC368; break; // HANGUL SYLLABLE SSANGSIOS EO
    case 0xBDE2: code_point = 0xC369; break; // HANGUL SYLLABLE SSANGSIOS EO KIYEOK
    case 0xBDE3: code_point = 0xC36C; break; // HANGUL SYLLABLE SSANGSIOS EO NIEUN
    case 0xBDE4: code_point = 0xC370; break; // HANGUL SYLLABLE SSANGSIOS EO RIEUL
    case 0xBDE5: code_point = 0xC372; break; // HANGUL SYLLABLE SSANGSIOS EO RIEULMIEUM
    case 0xBDE6: code_point = 0xC378; break; // HANGUL SYLLABLE SSANGSIOS EO MIEUM
    case 0xBDE7: code_point = 0xC379; break; // HANGUL SYLLABLE SSANGSIOS EO PIEUP
    case 0xBDE8: code_point = 0xC37C; break; // HANGUL SYLLABLE SSANGSIOS EO SSANGSIOS
    case 0xBDE9: code_point = 0xC37D; break; // HANGUL SYLLABLE SSANGSIOS EO IEUNG
    case 0xBDEA: code_point = 0xC384; break; // HANGUL SYLLABLE SSANGSIOS E
    case 0xBDEB: code_point = 0xC388; break; // HANGUL SYLLABLE SSANGSIOS E NIEUN
    case 0xBDEC: code_point = 0xC38C; break; // HANGUL SYLLABLE SSANGSIOS E RIEUL
    case 0xBDED: code_point = 0xC3C0; break; // HANGUL SYLLABLE SSANGSIOS YE NIEUN
    case 0xBDEE: code_point = 0xC3D8; break; // HANGUL SYLLABLE SSANGSIOS O
    case 0xBDEF: code_point = 0xC3D9; break; // HANGUL SYLLABLE SSANGSIOS O KIYEOK
    case 0xBDF0: code_point = 0xC3DC; break; // HANGUL SYLLABLE SSANGSIOS O NIEUN
    case 0xBDF1: code_point = 0xC3DF; break; // HANGUL SYLLABLE SSANGSIOS O TIKEUT
    case 0xBDF2: code_point = 0xC3E0; break; // HANGUL SYLLABLE SSANGSIOS O RIEUL
    case 0xBDF3: code_point = 0xC3E2; break; // HANGUL SYLLABLE SSANGSIOS O RIEULMIEUM
    case 0xBDF4: code_point = 0xC3E8; break; // HANGUL SYLLABLE SSANGSIOS O MIEUM
    case 0xBDF5: code_point = 0xC3E9; break; // HANGUL SYLLABLE SSANGSIOS O PIEUP
    case 0xBDF6: code_point = 0xC3ED; break; // HANGUL SYLLABLE SSANGSIOS O IEUNG
    case 0xBDF7: code_point = 0xC3F4; break; // HANGUL SYLLABLE SSANGSIOS WA
    case 0xBDF8: code_point = 0xC3F5; break; // HANGUL SYLLABLE SSANGSIOS WA KIYEOK
    case 0xBDF9: code_point = 0xC3F8; break; // HANGUL SYLLABLE SSANGSIOS WA NIEUN
    case 0xBDFA: code_point = 0xC408; break; // HANGUL SYLLABLE SSANGSIOS WA SSANGSIOS
    case 0xBDFB: code_point = 0xC410; break; // HANGUL SYLLABLE SSANGSIOS WAE
    case 0xBDFC: code_point = 0xC424; break; // HANGUL SYLLABLE SSANGSIOS WAE SSANGSIOS
    case 0xBDFD: code_point = 0xC42C; break; // HANGUL SYLLABLE SSANGSIOS OE
    case 0xBDFE: code_point = 0xC430; break; // HANGUL SYLLABLE SSANGSIOS OE NIEUN
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xBE(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xBE41: code_point = 0xD438; break; // HANGUL SYLLABLE PHIEUPH WAE SSANGSIOS
    case 0xBE42: code_point = 0xD439; break; // HANGUL SYLLABLE PHIEUPH WAE IEUNG
    case 0xBE43: code_point = 0xD43A; break; // HANGUL SYLLABLE PHIEUPH WAE CIEUC
    case 0xBE44: code_point = 0xD43B; break; // HANGUL SYLLABLE PHIEUPH WAE CHIEUCH
    case 0xBE45: code_point = 0xD43C; break; // HANGUL SYLLABLE PHIEUPH WAE KHIEUKH
    case 0xBE46: code_point = 0xD43D; break; // HANGUL SYLLABLE PHIEUPH WAE THIEUTH
    case 0xBE47: code_point = 0xD43E; break; // HANGUL SYLLABLE PHIEUPH WAE PHIEUPH
    case 0xBE48: code_point = 0xD43F; break; // HANGUL SYLLABLE PHIEUPH WAE HIEUH
    case 0xBE49: code_point = 0xD441; break; // HANGUL SYLLABLE PHIEUPH OE KIYEOK
    case 0xBE4A: code_point = 0xD442; break; // HANGUL SYLLABLE PHIEUPH OE SSANGKIYEOK
    case 0xBE4B: code_point = 0xD443; break; // HANGUL SYLLABLE PHIEUPH OE KIYEOKSIOS
    case 0xBE4C: code_point = 0xD445; break; // HANGUL SYLLABLE PHIEUPH OE NIEUNCIEUC
    case 0xBE4D: code_point = 0xD446; break; // HANGUL SYLLABLE PHIEUPH OE NIEUNHIEUH
    case 0xBE4E: code_point = 0xD447; break; // HANGUL SYLLABLE PHIEUPH OE TIKEUT
    case 0xBE4F: code_point = 0xD448; break; // HANGUL SYLLABLE PHIEUPH OE RIEUL
    case 0xBE50: code_point = 0xD449; break; // HANGUL SYLLABLE PHIEUPH OE RIEULKIYEOK
    case 0xBE51: code_point = 0xD44A; break; // HANGUL SYLLABLE PHIEUPH OE RIEULMIEUM
    case 0xBE52: code_point = 0xD44B; break; // HANGUL SYLLABLE PHIEUPH OE RIEULPIEUP
    case 0xBE53: code_point = 0xD44C; break; // HANGUL SYLLABLE PHIEUPH OE RIEULSIOS
    case 0xBE54: code_point = 0xD44D; break; // HANGUL SYLLABLE PHIEUPH OE RIEULTHIEUTH
    case 0xBE55: code_point = 0xD44E; break; // HANGUL SYLLABLE PHIEUPH OE RIEULPHIEUPH
    case 0xBE56: code_point = 0xD44F; break; // HANGUL SYLLABLE PHIEUPH OE RIEULHIEUH
    case 0xBE57: code_point = 0xD450; break; // HANGUL SYLLABLE PHIEUPH OE MIEUM
    case 0xBE58: code_point = 0xD451; break; // HANGUL SYLLABLE PHIEUPH OE PIEUP
    case 0xBE59: code_point = 0xD452; break; // HANGUL SYLLABLE PHIEUPH OE PIEUPSIOS
    case 0xBE5A: code_point = 0xD453; break; // HANGUL SYLLABLE PHIEUPH OE SIOS
    case 0xBE61: code_point = 0xD454; break; // HANGUL SYLLABLE PHIEUPH OE SSANGSIOS
    case 0xBE62: code_point = 0xD455; break; // HANGUL SYLLABLE PHIEUPH OE IEUNG
    case 0xBE63: code_point = 0xD456; break; // HANGUL SYLLABLE PHIEUPH OE CIEUC
    case 0xBE64: code_point = 0xD457; break; // HANGUL SYLLABLE PHIEUPH OE CHIEUCH
    case 0xBE65: code_point = 0xD458; break; // HANGUL SYLLABLE PHIEUPH OE KHIEUKH
    case 0xBE66: code_point = 0xD459; break; // HANGUL SYLLABLE PHIEUPH OE THIEUTH
    case 0xBE67: code_point = 0xD45A; break; // HANGUL SYLLABLE PHIEUPH OE PHIEUPH
    case 0xBE68: code_point = 0xD45B; break; // HANGUL SYLLABLE PHIEUPH OE HIEUH
    case 0xBE69: code_point = 0xD45D; break; // HANGUL SYLLABLE PHIEUPH YO KIYEOK
    case 0xBE6A: code_point = 0xD45E; break; // HANGUL SYLLABLE PHIEUPH YO SSANGKIYEOK
    case 0xBE6B: code_point = 0xD45F; break; // HANGUL SYLLABLE PHIEUPH YO KIYEOKSIOS
    case 0xBE6C: code_point = 0xD461; break; // HANGUL SYLLABLE PHIEUPH YO NIEUNCIEUC
    case 0xBE6D: code_point = 0xD462; break; // HANGUL SYLLABLE PHIEUPH YO NIEUNHIEUH
    case 0xBE6E: code_point = 0xD463; break; // HANGUL SYLLABLE PHIEUPH YO TIKEUT
    case 0xBE6F: code_point = 0xD465; break; // HANGUL SYLLABLE PHIEUPH YO RIEULKIYEOK
    case 0xBE70: code_point = 0xD466; break; // HANGUL SYLLABLE PHIEUPH YO RIEULMIEUM
    case 0xBE71: code_point = 0xD467; break; // HANGUL SYLLABLE PHIEUPH YO RIEULPIEUP
    case 0xBE72: code_point = 0xD468; break; // HANGUL SYLLABLE PHIEUPH YO RIEULSIOS
    case 0xBE73: code_point = 0xD469; break; // HANGUL SYLLABLE PHIEUPH YO RIEULTHIEUTH
    case 0xBE74: code_point = 0xD46A; break; // HANGUL SYLLABLE PHIEUPH YO RIEULPHIEUPH
    case 0xBE75: code_point = 0xD46B; break; // HANGUL SYLLABLE PHIEUPH YO RIEULHIEUH
    case 0xBE76: code_point = 0xD46C; break; // HANGUL SYLLABLE PHIEUPH YO MIEUM
    case 0xBE77: code_point = 0xD46E; break; // HANGUL SYLLABLE PHIEUPH YO PIEUPSIOS
    case 0xBE78: code_point = 0xD470; break; // HANGUL SYLLABLE PHIEUPH YO SSANGSIOS
    case 0xBE79: code_point = 0xD471; break; // HANGUL SYLLABLE PHIEUPH YO IEUNG
    case 0xBE7A: code_point = 0xD472; break; // HANGUL SYLLABLE PHIEUPH YO CIEUC
    case 0xBE81: code_point = 0xD473; break; // HANGUL SYLLABLE PHIEUPH YO CHIEUCH
    case 0xBE82: code_point = 0xD474; break; // HANGUL SYLLABLE PHIEUPH YO KHIEUKH
    case 0xBE83: code_point = 0xD475; break; // HANGUL SYLLABLE PHIEUPH YO THIEUTH
    case 0xBE84: code_point = 0xD476; break; // HANGUL SYLLABLE PHIEUPH YO PHIEUPH
    case 0xBE85: code_point = 0xD477; break; // HANGUL SYLLABLE PHIEUPH YO HIEUH
    case 0xBE86: code_point = 0xD47A; break; // HANGUL SYLLABLE PHIEUPH U SSANGKIYEOK
    case 0xBE87: code_point = 0xD47B; break; // HANGUL SYLLABLE PHIEUPH U KIYEOKSIOS
    case 0xBE88: code_point = 0xD47D; break; // HANGUL SYLLABLE PHIEUPH U NIEUNCIEUC
    case 0xBE89: code_point = 0xD47E; break; // HANGUL SYLLABLE PHIEUPH U NIEUNHIEUH
    case 0xBE8A: code_point = 0xD481; break; // HANGUL SYLLABLE PHIEUPH U RIEULKIYEOK
    case 0xBE8B: code_point = 0xD483; break; // HANGUL SYLLABLE PHIEUPH U RIEULPIEUP
    case 0xBE8C: code_point = 0xD484; break; // HANGUL SYLLABLE PHIEUPH U RIEULSIOS
    case 0xBE8D: code_point = 0xD485; break; // HANGUL SYLLABLE PHIEUPH U RIEULTHIEUTH
    case 0xBE8E: code_point = 0xD486; break; // HANGUL SYLLABLE PHIEUPH U RIEULPHIEUPH
    case 0xBE8F: code_point = 0xD487; break; // HANGUL SYLLABLE PHIEUPH U RIEULHIEUH
    case 0xBE90: code_point = 0xD48A; break; // HANGUL SYLLABLE PHIEUPH U PIEUPSIOS
    case 0xBE91: code_point = 0xD48C; break; // HANGUL SYLLABLE PHIEUPH U SSANGSIOS
    case 0xBE92: code_point = 0xD48E; break; // HANGUL SYLLABLE PHIEUPH U CIEUC
    case 0xBE93: code_point = 0xD48F; break; // HANGUL SYLLABLE PHIEUPH U CHIEUCH
    case 0xBE94: code_point = 0xD490; break; // HANGUL SYLLABLE PHIEUPH U KHIEUKH
    case 0xBE95: code_point = 0xD491; break; // HANGUL SYLLABLE PHIEUPH U THIEUTH
    case 0xBE96: code_point = 0xD492; break; // HANGUL SYLLABLE PHIEUPH U PHIEUPH
    case 0xBE97: code_point = 0xD493; break; // HANGUL SYLLABLE PHIEUPH U HIEUH
    case 0xBE98: code_point = 0xD495; break; // HANGUL SYLLABLE PHIEUPH WEO KIYEOK
    case 0xBE99: code_point = 0xD496; break; // HANGUL SYLLABLE PHIEUPH WEO SSANGKIYEOK
    case 0xBE9A: code_point = 0xD497; break; // HANGUL SYLLABLE PHIEUPH WEO KIYEOKSIOS
    case 0xBE9B: code_point = 0xD498; break; // HANGUL SYLLABLE PHIEUPH WEO NIEUN
    case 0xBE9C: code_point = 0xD499; break; // HANGUL SYLLABLE PHIEUPH WEO NIEUNCIEUC
    case 0xBE9D: code_point = 0xD49A; break; // HANGUL SYLLABLE PHIEUPH WEO NIEUNHIEUH
    case 0xBE9E: code_point = 0xD49B; break; // HANGUL SYLLABLE PHIEUPH WEO TIKEUT
    case 0xBE9F: code_point = 0xD49C; break; // HANGUL SYLLABLE PHIEUPH WEO RIEUL
    case 0xBEA0: code_point = 0xD49D; break; // HANGUL SYLLABLE PHIEUPH WEO RIEULKIYEOK
    case 0xBEA1: code_point = 0xC434; break; // HANGUL SYLLABLE SSANGSIOS OE RIEUL
    case 0xBEA2: code_point = 0xC43C; break; // HANGUL SYLLABLE SSANGSIOS OE MIEUM
    case 0xBEA3: code_point = 0xC43D; break; // HANGUL SYLLABLE SSANGSIOS OE PIEUP
    case 0xBEA4: code_point = 0xC448; break; // HANGUL SYLLABLE SSANGSIOS YO
    case 0xBEA5: code_point = 0xC464; break; // HANGUL SYLLABLE SSANGSIOS U
    case 0xBEA6: code_point = 0xC465; break; // HANGUL SYLLABLE SSANGSIOS U KIYEOK
    case 0xBEA7: code_point = 0xC468; break; // HANGUL SYLLABLE SSANGSIOS U NIEUN
    case 0xBEA8: code_point = 0xC46C; break; // HANGUL SYLLABLE SSANGSIOS U RIEUL
    case 0xBEA9: code_point = 0xC474; break; // HANGUL SYLLABLE SSANGSIOS U MIEUM
    case 0xBEAA: code_point = 0xC475; break; // HANGUL SYLLABLE SSANGSIOS U PIEUP
    case 0xBEAB: code_point = 0xC479; break; // HANGUL SYLLABLE SSANGSIOS U IEUNG
    case 0xBEAC: code_point = 0xC480; break; // HANGUL SYLLABLE SSANGSIOS WEO
    case 0xBEAD: code_point = 0xC494; break; // HANGUL SYLLABLE SSANGSIOS WEO SSANGSIOS
    case 0xBEAE: code_point = 0xC49C; break; // HANGUL SYLLABLE SSANGSIOS WE
    case 0xBEAF: code_point = 0xC4B8; break; // HANGUL SYLLABLE SSANGSIOS WI
    case 0xBEB0: code_point = 0xC4BC; break; // HANGUL SYLLABLE SSANGSIOS WI NIEUN
    case 0xBEB1: code_point = 0xC4E9; break; // HANGUL SYLLABLE SSANGSIOS YU IEUNG
    case 0xBEB2: code_point = 0xC4F0; break; // HANGUL SYLLABLE SSANGSIOS EU
    case 0xBEB3: code_point = 0xC4F1; break; // HANGUL SYLLABLE SSANGSIOS EU KIYEOK
    case 0xBEB4: code_point = 0xC4F4; break; // HANGUL SYLLABLE SSANGSIOS EU NIEUN
    case 0xBEB5: code_point = 0xC4F8; break; // HANGUL SYLLABLE SSANGSIOS EU RIEUL
    case 0xBEB6: code_point = 0xC4FA; break; // HANGUL SYLLABLE SSANGSIOS EU RIEULMIEUM
    case 0xBEB7: code_point = 0xC4FF; break; // HANGUL SYLLABLE SSANGSIOS EU RIEULHIEUH
    case 0xBEB8: code_point = 0xC500; break; // HANGUL SYLLABLE SSANGSIOS EU MIEUM
    case 0xBEB9: code_point = 0xC501; break; // HANGUL SYLLABLE SSANGSIOS EU PIEUP
    case 0xBEBA: code_point = 0xC50C; break; // HANGUL SYLLABLE SSANGSIOS YI
    case 0xBEBB: code_point = 0xC510; break; // HANGUL SYLLABLE SSANGSIOS YI NIEUN
    case 0xBEBC: code_point = 0xC514; break; // HANGUL SYLLABLE SSANGSIOS YI RIEUL
    case 0xBEBD: code_point = 0xC51C; break; // HANGUL SYLLABLE SSANGSIOS YI MIEUM
    case 0xBEBE: code_point = 0xC528; break; // HANGUL SYLLABLE SSANGSIOS I
    case 0xBEBF: code_point = 0xC529; break; // HANGUL SYLLABLE SSANGSIOS I KIYEOK
    case 0xBEC0: code_point = 0xC52C; break; // HANGUL SYLLABLE SSANGSIOS I NIEUN
    case 0xBEC1: code_point = 0xC530; break; // HANGUL SYLLABLE SSANGSIOS I RIEUL
    case 0xBEC2: code_point = 0xC538; break; // HANGUL SYLLABLE SSANGSIOS I MIEUM
    case 0xBEC3: code_point = 0xC539; break; // HANGUL SYLLABLE SSANGSIOS I PIEUP
    case 0xBEC4: code_point = 0xC53B; break; // HANGUL SYLLABLE SSANGSIOS I SIOS
    case 0xBEC5: code_point = 0xC53D; break; // HANGUL SYLLABLE SSANGSIOS I IEUNG
    case 0xBEC6: code_point = 0xC544; break; // HANGUL SYLLABLE IEUNG A
    case 0xBEC7: code_point = 0xC545; break; // HANGUL SYLLABLE IEUNG A KIYEOK
    case 0xBEC8: code_point = 0xC548; break; // HANGUL SYLLABLE IEUNG A NIEUN
    case 0xBEC9: code_point = 0xC549; break; // HANGUL SYLLABLE IEUNG A NIEUNCIEUC
    case 0xBECA: code_point = 0xC54A; break; // HANGUL SYLLABLE IEUNG A NIEUNHIEUH
    case 0xBECB: code_point = 0xC54C; break; // HANGUL SYLLABLE IEUNG A RIEUL
    case 0xBECC: code_point = 0xC54D; break; // HANGUL SYLLABLE IEUNG A RIEULKIYEOK
    case 0xBECD: code_point = 0xC54E; break; // HANGUL SYLLABLE IEUNG A RIEULMIEUM
    case 0xBECE: code_point = 0xC553; break; // HANGUL SYLLABLE IEUNG A RIEULHIEUH
    case 0xBECF: code_point = 0xC554; break; // HANGUL SYLLABLE IEUNG A MIEUM
    case 0xBED0: code_point = 0xC555; break; // HANGUL SYLLABLE IEUNG A PIEUP
    case 0xBED1: code_point = 0xC557; break; // HANGUL SYLLABLE IEUNG A SIOS
    case 0xBED2: code_point = 0xC558; break; // HANGUL SYLLABLE IEUNG A SSANGSIOS
    case 0xBED3: code_point = 0xC559; break; // HANGUL SYLLABLE IEUNG A IEUNG
    case 0xBED4: code_point = 0xC55D; break; // HANGUL SYLLABLE IEUNG A THIEUTH
    case 0xBED5: code_point = 0xC55E; break; // HANGUL SYLLABLE IEUNG A PHIEUPH
    case 0xBED6: code_point = 0xC560; break; // HANGUL SYLLABLE IEUNG AE
    case 0xBED7: code_point = 0xC561; break; // HANGUL SYLLABLE IEUNG AE KIYEOK
    case 0xBED8: code_point = 0xC564; break; // HANGUL SYLLABLE IEUNG AE NIEUN
    case 0xBED9: code_point = 0xC568; break; // HANGUL SYLLABLE IEUNG AE RIEUL
    case 0xBEDA: code_point = 0xC570; break; // HANGUL SYLLABLE IEUNG AE MIEUM
    case 0xBEDB: code_point = 0xC571; break; // HANGUL SYLLABLE IEUNG AE PIEUP
    case 0xBEDC: code_point = 0xC573; break; // HANGUL SYLLABLE IEUNG AE SIOS
    case 0xBEDD: code_point = 0xC574; break; // HANGUL SYLLABLE IEUNG AE SSANGSIOS
    case 0xBEDE: code_point = 0xC575; break; // HANGUL SYLLABLE IEUNG AE IEUNG
    case 0xBEDF: code_point = 0xC57C; break; // HANGUL SYLLABLE IEUNG YA
    case 0xBEE0: code_point = 0xC57D; break; // HANGUL SYLLABLE IEUNG YA KIYEOK
    case 0xBEE1: code_point = 0xC580; break; // HANGUL SYLLABLE IEUNG YA NIEUN
    case 0xBEE2: code_point = 0xC584; break; // HANGUL SYLLABLE IEUNG YA RIEUL
    case 0xBEE3: code_point = 0xC587; break; // HANGUL SYLLABLE IEUNG YA RIEULPIEUP
    case 0xBEE4: code_point = 0xC58C; break; // HANGUL SYLLABLE IEUNG YA MIEUM
    case 0xBEE5: code_point = 0xC58D; break; // HANGUL SYLLABLE IEUNG YA PIEUP
    case 0xBEE6: code_point = 0xC58F; break; // HANGUL SYLLABLE IEUNG YA SIOS
    case 0xBEE7: code_point = 0xC591; break; // HANGUL SYLLABLE IEUNG YA IEUNG
    case 0xBEE8: code_point = 0xC595; break; // HANGUL SYLLABLE IEUNG YA THIEUTH
    case 0xBEE9: code_point = 0xC597; break; // HANGUL SYLLABLE IEUNG YA HIEUH
    case 0xBEEA: code_point = 0xC598; break; // HANGUL SYLLABLE IEUNG YAE
    case 0xBEEB: code_point = 0xC59C; break; // HANGUL SYLLABLE IEUNG YAE NIEUN
    case 0xBEEC: code_point = 0xC5A0; break; // HANGUL SYLLABLE IEUNG YAE RIEUL
    case 0xBEED: code_point = 0xC5A9; break; // HANGUL SYLLABLE IEUNG YAE PIEUP
    case 0xBEEE: code_point = 0xC5B4; break; // HANGUL SYLLABLE IEUNG EO
    case 0xBEEF: code_point = 0xC5B5; break; // HANGUL SYLLABLE IEUNG EO KIYEOK
    case 0xBEF0: code_point = 0xC5B8; break; // HANGUL SYLLABLE IEUNG EO NIEUN
    case 0xBEF1: code_point = 0xC5B9; break; // HANGUL SYLLABLE IEUNG EO NIEUNCIEUC
    case 0xBEF2: code_point = 0xC5BB; break; // HANGUL SYLLABLE IEUNG EO TIKEUT
    case 0xBEF3: code_point = 0xC5BC; break; // HANGUL SYLLABLE IEUNG EO RIEUL
    case 0xBEF4: code_point = 0xC5BD; break; // HANGUL SYLLABLE IEUNG EO RIEULKIYEOK
    case 0xBEF5: code_point = 0xC5BE; break; // HANGUL SYLLABLE IEUNG EO RIEULMIEUM
    case 0xBEF6: code_point = 0xC5C4; break; // HANGUL SYLLABLE IEUNG EO MIEUM
    case 0xBEF7: code_point = 0xC5C5; break; // HANGUL SYLLABLE IEUNG EO PIEUP
    case 0xBEF8: code_point = 0xC5C6; break; // HANGUL SYLLABLE IEUNG EO PIEUPSIOS
    case 0xBEF9: code_point = 0xC5C7; break; // HANGUL SYLLABLE IEUNG EO SIOS
    case 0xBEFA: code_point = 0xC5C8; break; // HANGUL SYLLABLE IEUNG EO SSANGSIOS
    case 0xBEFB: code_point = 0xC5C9; break; // HANGUL SYLLABLE IEUNG EO IEUNG
    case 0xBEFC: code_point = 0xC5CA; break; // HANGUL SYLLABLE IEUNG EO CIEUC
    case 0xBEFD: code_point = 0xC5CC; break; // HANGUL SYLLABLE IEUNG EO KHIEUKH
    case 0xBEFE: code_point = 0xC5CE; break; // HANGUL SYLLABLE IEUNG EO PHIEUPH
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xBF(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xBF41: code_point = 0xD49E; break; // HANGUL SYLLABLE PHIEUPH WEO RIEULMIEUM
    case 0xBF42: code_point = 0xD49F; break; // HANGUL SYLLABLE PHIEUPH WEO RIEULPIEUP
    case 0xBF43: code_point = 0xD4A0; break; // HANGUL SYLLABLE PHIEUPH WEO RIEULSIOS
    case 0xBF44: code_point = 0xD4A1; break; // HANGUL SYLLABLE PHIEUPH WEO RIEULTHIEUTH
    case 0xBF45: code_point = 0xD4A2; break; // HANGUL SYLLABLE PHIEUPH WEO RIEULPHIEUPH
    case 0xBF46: code_point = 0xD4A3; break; // HANGUL SYLLABLE PHIEUPH WEO RIEULHIEUH
    case 0xBF47: code_point = 0xD4A4; break; // HANGUL SYLLABLE PHIEUPH WEO MIEUM
    case 0xBF48: code_point = 0xD4A5; break; // HANGUL SYLLABLE PHIEUPH WEO PIEUP
    case 0xBF49: code_point = 0xD4A6; break; // HANGUL SYLLABLE PHIEUPH WEO PIEUPSIOS
    case 0xBF4A: code_point = 0xD4A7; break; // HANGUL SYLLABLE PHIEUPH WEO SIOS
    case 0xBF4B: code_point = 0xD4A8; break; // HANGUL SYLLABLE PHIEUPH WEO SSANGSIOS
    case 0xBF4C: code_point = 0xD4AA; break; // HANGUL SYLLABLE PHIEUPH WEO CIEUC
    case 0xBF4D: code_point = 0xD4AB; break; // HANGUL SYLLABLE PHIEUPH WEO CHIEUCH
    case 0xBF4E: code_point = 0xD4AC; break; // HANGUL SYLLABLE PHIEUPH WEO KHIEUKH
    case 0xBF4F: code_point = 0xD4AD; break; // HANGUL SYLLABLE PHIEUPH WEO THIEUTH
    case 0xBF50: code_point = 0xD4AE; break; // HANGUL SYLLABLE PHIEUPH WEO PHIEUPH
    case 0xBF51: code_point = 0xD4AF; break; // HANGUL SYLLABLE PHIEUPH WEO HIEUH
    case 0xBF52: code_point = 0xD4B0; break; // HANGUL SYLLABLE PHIEUPH WE
    case 0xBF53: code_point = 0xD4B1; break; // HANGUL SYLLABLE PHIEUPH WE KIYEOK
    case 0xBF54: code_point = 0xD4B2; break; // HANGUL SYLLABLE PHIEUPH WE SSANGKIYEOK
    case 0xBF55: code_point = 0xD4B3; break; // HANGUL SYLLABLE PHIEUPH WE KIYEOKSIOS
    case 0xBF56: code_point = 0xD4B4; break; // HANGUL SYLLABLE PHIEUPH WE NIEUN
    case 0xBF57: code_point = 0xD4B5; break; // HANGUL SYLLABLE PHIEUPH WE NIEUNCIEUC
    case 0xBF58: code_point = 0xD4B6; break; // HANGUL SYLLABLE PHIEUPH WE NIEUNHIEUH
    case 0xBF59: code_point = 0xD4B7; break; // HANGUL SYLLABLE PHIEUPH WE TIKEUT
    case 0xBF5A: code_point = 0xD4B8; break; // HANGUL SYLLABLE PHIEUPH WE RIEUL
    case 0xBF61: code_point = 0xD4B9; break; // HANGUL SYLLABLE PHIEUPH WE RIEULKIYEOK
    case 0xBF62: code_point = 0xD4BA; break; // HANGUL SYLLABLE PHIEUPH WE RIEULMIEUM
    case 0xBF63: code_point = 0xD4BB; break; // HANGUL SYLLABLE PHIEUPH WE RIEULPIEUP
    case 0xBF64: code_point = 0xD4BC; break; // HANGUL SYLLABLE PHIEUPH WE RIEULSIOS
    case 0xBF65: code_point = 0xD4BD; break; // HANGUL SYLLABLE PHIEUPH WE RIEULTHIEUTH
    case 0xBF66: code_point = 0xD4BE; break; // HANGUL SYLLABLE PHIEUPH WE RIEULPHIEUPH
    case 0xBF67: code_point = 0xD4BF; break; // HANGUL SYLLABLE PHIEUPH WE RIEULHIEUH
    case 0xBF68: code_point = 0xD4C0; break; // HANGUL SYLLABLE PHIEUPH WE MIEUM
    case 0xBF69: code_point = 0xD4C1; break; // HANGUL SYLLABLE PHIEUPH WE PIEUP
    case 0xBF6A: code_point = 0xD4C2; break; // HANGUL SYLLABLE PHIEUPH WE PIEUPSIOS
    case 0xBF6B: code_point = 0xD4C3; break; // HANGUL SYLLABLE PHIEUPH WE SIOS
    case 0xBF6C: code_point = 0xD4C4; break; // HANGUL SYLLABLE PHIEUPH WE SSANGSIOS
    case 0xBF6D: code_point = 0xD4C5; break; // HANGUL SYLLABLE PHIEUPH WE IEUNG
    case 0xBF6E: code_point = 0xD4C6; break; // HANGUL SYLLABLE PHIEUPH WE CIEUC
    case 0xBF6F: code_point = 0xD4C7; break; // HANGUL SYLLABLE PHIEUPH WE CHIEUCH
    case 0xBF70: code_point = 0xD4C8; break; // HANGUL SYLLABLE PHIEUPH WE KHIEUKH
    case 0xBF71: code_point = 0xD4C9; break; // HANGUL SYLLABLE PHIEUPH WE THIEUTH
    case 0xBF72: code_point = 0xD4CA; break; // HANGUL SYLLABLE PHIEUPH WE PHIEUPH
    case 0xBF73: code_point = 0xD4CB; break; // HANGUL SYLLABLE PHIEUPH WE HIEUH
    case 0xBF74: code_point = 0xD4CD; break; // HANGUL SYLLABLE PHIEUPH WI KIYEOK
    case 0xBF75: code_point = 0xD4CE; break; // HANGUL SYLLABLE PHIEUPH WI SSANGKIYEOK
    case 0xBF76: code_point = 0xD4CF; break; // HANGUL SYLLABLE PHIEUPH WI KIYEOKSIOS
    case 0xBF77: code_point = 0xD4D1; break; // HANGUL SYLLABLE PHIEUPH WI NIEUNCIEUC
    case 0xBF78: code_point = 0xD4D2; break; // HANGUL SYLLABLE PHIEUPH WI NIEUNHIEUH
    case 0xBF79: code_point = 0xD4D3; break; // HANGUL SYLLABLE PHIEUPH WI TIKEUT
    case 0xBF7A: code_point = 0xD4D5; break; // HANGUL SYLLABLE PHIEUPH WI RIEULKIYEOK
    case 0xBF81: code_point = 0xD4D6; break; // HANGUL SYLLABLE PHIEUPH WI RIEULMIEUM
    case 0xBF82: code_point = 0xD4D7; break; // HANGUL SYLLABLE PHIEUPH WI RIEULPIEUP
    case 0xBF83: code_point = 0xD4D8; break; // HANGUL SYLLABLE PHIEUPH WI RIEULSIOS
    case 0xBF84: code_point = 0xD4D9; break; // HANGUL SYLLABLE PHIEUPH WI RIEULTHIEUTH
    case 0xBF85: code_point = 0xD4DA; break; // HANGUL SYLLABLE PHIEUPH WI RIEULPHIEUPH
    case 0xBF86: code_point = 0xD4DB; break; // HANGUL SYLLABLE PHIEUPH WI RIEULHIEUH
    case 0xBF87: code_point = 0xD4DD; break; // HANGUL SYLLABLE PHIEUPH WI PIEUP
    case 0xBF88: code_point = 0xD4DE; break; // HANGUL SYLLABLE PHIEUPH WI PIEUPSIOS
    case 0xBF89: code_point = 0xD4E0; break; // HANGUL SYLLABLE PHIEUPH WI SSANGSIOS
    case 0xBF8A: code_point = 0xD4E1; break; // HANGUL SYLLABLE PHIEUPH WI IEUNG
    case 0xBF8B: code_point = 0xD4E2; break; // HANGUL SYLLABLE PHIEUPH WI CIEUC
    case 0xBF8C: code_point = 0xD4E3; break; // HANGUL SYLLABLE PHIEUPH WI CHIEUCH
    case 0xBF8D: code_point = 0xD4E4; break; // HANGUL SYLLABLE PHIEUPH WI KHIEUKH
    case 0xBF8E: code_point = 0xD4E5; break; // HANGUL SYLLABLE PHIEUPH WI THIEUTH
    case 0xBF8F: code_point = 0xD4E6; break; // HANGUL SYLLABLE PHIEUPH WI PHIEUPH
    case 0xBF90: code_point = 0xD4E7; break; // HANGUL SYLLABLE PHIEUPH WI HIEUH
    case 0xBF91: code_point = 0xD4E9; break; // HANGUL SYLLABLE PHIEUPH YU KIYEOK
    case 0xBF92: code_point = 0xD4EA; break; // HANGUL SYLLABLE PHIEUPH YU SSANGKIYEOK
    case 0xBF93: code_point = 0xD4EB; break; // HANGUL SYLLABLE PHIEUPH YU KIYEOKSIOS
    case 0xBF94: code_point = 0xD4ED; break; // HANGUL SYLLABLE PHIEUPH YU NIEUNCIEUC
    case 0xBF95: code_point = 0xD4EE; break; // HANGUL SYLLABLE PHIEUPH YU NIEUNHIEUH
    case 0xBF96: code_point = 0xD4EF; break; // HANGUL SYLLABLE PHIEUPH YU TIKEUT
    case 0xBF97: code_point = 0xD4F1; break; // HANGUL SYLLABLE PHIEUPH YU RIEULKIYEOK
    case 0xBF98: code_point = 0xD4F2; break; // HANGUL SYLLABLE PHIEUPH YU RIEULMIEUM
    case 0xBF99: code_point = 0xD4F3; break; // HANGUL SYLLABLE PHIEUPH YU RIEULPIEUP
    case 0xBF9A: code_point = 0xD4F4; break; // HANGUL SYLLABLE PHIEUPH YU RIEULSIOS
    case 0xBF9B: code_point = 0xD4F5; break; // HANGUL SYLLABLE PHIEUPH YU RIEULTHIEUTH
    case 0xBF9C: code_point = 0xD4F6; break; // HANGUL SYLLABLE PHIEUPH YU RIEULPHIEUPH
    case 0xBF9D: code_point = 0xD4F7; break; // HANGUL SYLLABLE PHIEUPH YU RIEULHIEUH
    case 0xBF9E: code_point = 0xD4F9; break; // HANGUL SYLLABLE PHIEUPH YU PIEUP
    case 0xBF9F: code_point = 0xD4FA; break; // HANGUL SYLLABLE PHIEUPH YU PIEUPSIOS
    case 0xBFA0: code_point = 0xD4FC; break; // HANGUL SYLLABLE PHIEUPH YU SSANGSIOS
    case 0xBFA1: code_point = 0xC5D0; break; // HANGUL SYLLABLE IEUNG E
    case 0xBFA2: code_point = 0xC5D1; break; // HANGUL SYLLABLE IEUNG E KIYEOK
    case 0xBFA3: code_point = 0xC5D4; break; // HANGUL SYLLABLE IEUNG E NIEUN
    case 0xBFA4: code_point = 0xC5D8; break; // HANGUL SYLLABLE IEUNG E RIEUL
    case 0xBFA5: code_point = 0xC5E0; break; // HANGUL SYLLABLE IEUNG E MIEUM
    case 0xBFA6: code_point = 0xC5E1; break; // HANGUL SYLLABLE IEUNG E PIEUP
    case 0xBFA7: code_point = 0xC5E3; break; // HANGUL SYLLABLE IEUNG E SIOS
    case 0xBFA8: code_point = 0xC5E5; break; // HANGUL SYLLABLE IEUNG E IEUNG
    case 0xBFA9: code_point = 0xC5EC; break; // HANGUL SYLLABLE IEUNG YEO
    case 0xBFAA: code_point = 0xC5ED; break; // HANGUL SYLLABLE IEUNG YEO KIYEOK
    case 0xBFAB: code_point = 0xC5EE; break; // HANGUL SYLLABLE IEUNG YEO SSANGKIYEOK
    case 0xBFAC: code_point = 0xC5F0; break; // HANGUL SYLLABLE IEUNG YEO NIEUN
    case 0xBFAD: code_point = 0xC5F4; break; // HANGUL SYLLABLE IEUNG YEO RIEUL
    case 0xBFAE: code_point = 0xC5F6; break; // HANGUL SYLLABLE IEUNG YEO RIEULMIEUM
    case 0xBFAF: code_point = 0xC5F7; break; // HANGUL SYLLABLE IEUNG YEO RIEULPIEUP
    case 0xBFB0: code_point = 0xC5FC; break; // HANGUL SYLLABLE IEUNG YEO MIEUM
    case 0xBFB1: code_point = 0xC5FD; break; // HANGUL SYLLABLE IEUNG YEO PIEUP
    case 0xBFB2: code_point = 0xC5FE; break; // HANGUL SYLLABLE IEUNG YEO PIEUPSIOS
    case 0xBFB3: code_point = 0xC5FF; break; // HANGUL SYLLABLE IEUNG YEO SIOS
    case 0xBFB4: code_point = 0xC600; break; // HANGUL SYLLABLE IEUNG YEO SSANGSIOS
    case 0xBFB5: code_point = 0xC601; break; // HANGUL SYLLABLE IEUNG YEO IEUNG
    case 0xBFB6: code_point = 0xC605; break; // HANGUL SYLLABLE IEUNG YEO THIEUTH
    case 0xBFB7: code_point = 0xC606; break; // HANGUL SYLLABLE IEUNG YEO PHIEUPH
    case 0xBFB8: code_point = 0xC607; break; // HANGUL SYLLABLE IEUNG YEO HIEUH
    case 0xBFB9: code_point = 0xC608; break; // HANGUL SYLLABLE IEUNG YE
    case 0xBFBA: code_point = 0xC60C; break; // HANGUL SYLLABLE IEUNG YE NIEUN
    case 0xBFBB: code_point = 0xC610; break; // HANGUL SYLLABLE IEUNG YE RIEUL
    case 0xBFBC: code_point = 0xC618; break; // HANGUL SYLLABLE IEUNG YE MIEUM
    case 0xBFBD: code_point = 0xC619; break; // HANGUL SYLLABLE IEUNG YE PIEUP
    case 0xBFBE: code_point = 0xC61B; break; // HANGUL SYLLABLE IEUNG YE SIOS
    case 0xBFBF: code_point = 0xC61C; break; // HANGUL SYLLABLE IEUNG YE SSANGSIOS
    case 0xBFC0: code_point = 0xC624; break; // HANGUL SYLLABLE IEUNG O
    case 0xBFC1: code_point = 0xC625; break; // HANGUL SYLLABLE IEUNG O KIYEOK
    case 0xBFC2: code_point = 0xC628; break; // HANGUL SYLLABLE IEUNG O NIEUN
    case 0xBFC3: code_point = 0xC62C; break; // HANGUL SYLLABLE IEUNG O RIEUL
    case 0xBFC4: code_point = 0xC62D; break; // HANGUL SYLLABLE IEUNG O RIEULKIYEOK
    case 0xBFC5: code_point = 0xC62E; break; // HANGUL SYLLABLE IEUNG O RIEULMIEUM
    case 0xBFC6: code_point = 0xC630; break; // HANGUL SYLLABLE IEUNG O RIEULSIOS
    case 0xBFC7: code_point = 0xC633; break; // HANGUL SYLLABLE IEUNG O RIEULHIEUH
    case 0xBFC8: code_point = 0xC634; break; // HANGUL SYLLABLE IEUNG O MIEUM
    case 0xBFC9: code_point = 0xC635; break; // HANGUL SYLLABLE IEUNG O PIEUP
    case 0xBFCA: code_point = 0xC637; break; // HANGUL SYLLABLE IEUNG O SIOS
    case 0xBFCB: code_point = 0xC639; break; // HANGUL SYLLABLE IEUNG O IEUNG
    case 0xBFCC: code_point = 0xC63B; break; // HANGUL SYLLABLE IEUNG O CHIEUCH
    case 0xBFCD: code_point = 0xC640; break; // HANGUL SYLLABLE IEUNG WA
    case 0xBFCE: code_point = 0xC641; break; // HANGUL SYLLABLE IEUNG WA KIYEOK
    case 0xBFCF: code_point = 0xC644; break; // HANGUL SYLLABLE IEUNG WA NIEUN
    case 0xBFD0: code_point = 0xC648; break; // HANGUL SYLLABLE IEUNG WA RIEUL
    case 0xBFD1: code_point = 0xC650; break; // HANGUL SYLLABLE IEUNG WA MIEUM
    case 0xBFD2: code_point = 0xC651; break; // HANGUL SYLLABLE IEUNG WA PIEUP
    case 0xBFD3: code_point = 0xC653; break; // HANGUL SYLLABLE IEUNG WA SIOS
    case 0xBFD4: code_point = 0xC654; break; // HANGUL SYLLABLE IEUNG WA SSANGSIOS
    case 0xBFD5: code_point = 0xC655; break; // HANGUL SYLLABLE IEUNG WA IEUNG
    case 0xBFD6: code_point = 0xC65C; break; // HANGUL SYLLABLE IEUNG WAE
    case 0xBFD7: code_point = 0xC65D; break; // HANGUL SYLLABLE IEUNG WAE KIYEOK
    case 0xBFD8: code_point = 0xC660; break; // HANGUL SYLLABLE IEUNG WAE NIEUN
    case 0xBFD9: code_point = 0xC66C; break; // HANGUL SYLLABLE IEUNG WAE MIEUM
    case 0xBFDA: code_point = 0xC66F; break; // HANGUL SYLLABLE IEUNG WAE SIOS
    case 0xBFDB: code_point = 0xC671; break; // HANGUL SYLLABLE IEUNG WAE IEUNG
    case 0xBFDC: code_point = 0xC678; break; // HANGUL SYLLABLE IEUNG OE
    case 0xBFDD: code_point = 0xC679; break; // HANGUL SYLLABLE IEUNG OE KIYEOK
    case 0xBFDE: code_point = 0xC67C; break; // HANGUL SYLLABLE IEUNG OE NIEUN
    case 0xBFDF: code_point = 0xC680; break; // HANGUL SYLLABLE IEUNG OE RIEUL
    case 0xBFE0: code_point = 0xC688; break; // HANGUL SYLLABLE IEUNG OE MIEUM
    case 0xBFE1: code_point = 0xC689; break; // HANGUL SYLLABLE IEUNG OE PIEUP
    case 0xBFE2: code_point = 0xC68B; break; // HANGUL SYLLABLE IEUNG OE SIOS
    case 0xBFE3: code_point = 0xC68D; break; // HANGUL SYLLABLE IEUNG OE IEUNG
    case 0xBFE4: code_point = 0xC694; break; // HANGUL SYLLABLE IEUNG YO
    case 0xBFE5: code_point = 0xC695; break; // HANGUL SYLLABLE IEUNG YO KIYEOK
    case 0xBFE6: code_point = 0xC698; break; // HANGUL SYLLABLE IEUNG YO NIEUN
    case 0xBFE7: code_point = 0xC69C; break; // HANGUL SYLLABLE IEUNG YO RIEUL
    case 0xBFE8: code_point = 0xC6A4; break; // HANGUL SYLLABLE IEUNG YO MIEUM
    case 0xBFE9: code_point = 0xC6A5; break; // HANGUL SYLLABLE IEUNG YO PIEUP
    case 0xBFEA: code_point = 0xC6A7; break; // HANGUL SYLLABLE IEUNG YO SIOS
    case 0xBFEB: code_point = 0xC6A9; break; // HANGUL SYLLABLE IEUNG YO IEUNG
    case 0xBFEC: code_point = 0xC6B0; break; // HANGUL SYLLABLE IEUNG U
    case 0xBFED: code_point = 0xC6B1; break; // HANGUL SYLLABLE IEUNG U KIYEOK
    case 0xBFEE: code_point = 0xC6B4; break; // HANGUL SYLLABLE IEUNG U NIEUN
    case 0xBFEF: code_point = 0xC6B8; break; // HANGUL SYLLABLE IEUNG U RIEUL
    case 0xBFF0: code_point = 0xC6B9; break; // HANGUL SYLLABLE IEUNG U RIEULKIYEOK
    case 0xBFF1: code_point = 0xC6BA; break; // HANGUL SYLLABLE IEUNG U RIEULMIEUM
    case 0xBFF2: code_point = 0xC6C0; break; // HANGUL SYLLABLE IEUNG U MIEUM
    case 0xBFF3: code_point = 0xC6C1; break; // HANGUL SYLLABLE IEUNG U PIEUP
    case 0xBFF4: code_point = 0xC6C3; break; // HANGUL SYLLABLE IEUNG U SIOS
    case 0xBFF5: code_point = 0xC6C5; break; // HANGUL SYLLABLE IEUNG U IEUNG
    case 0xBFF6: code_point = 0xC6CC; break; // HANGUL SYLLABLE IEUNG WEO
    case 0xBFF7: code_point = 0xC6CD; break; // HANGUL SYLLABLE IEUNG WEO KIYEOK
    case 0xBFF8: code_point = 0xC6D0; break; // HANGUL SYLLABLE IEUNG WEO NIEUN
    case 0xBFF9: code_point = 0xC6D4; break; // HANGUL SYLLABLE IEUNG WEO RIEUL
    case 0xBFFA: code_point = 0xC6DC; break; // HANGUL SYLLABLE IEUNG WEO MIEUM
    case 0xBFFB: code_point = 0xC6DD; break; // HANGUL SYLLABLE IEUNG WEO PIEUP
    case 0xBFFC: code_point = 0xC6E0; break; // HANGUL SYLLABLE IEUNG WEO SSANGSIOS
    case 0xBFFD: code_point = 0xC6E1; break; // HANGUL SYLLABLE IEUNG WEO IEUNG
    case 0xBFFE: code_point = 0xC6E8; break; // HANGUL SYLLABLE IEUNG WE
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xC0(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xC041: code_point = 0xD4FE; break; // HANGUL SYLLABLE PHIEUPH YU CIEUC
    case 0xC042: code_point = 0xD4FF; break; // HANGUL SYLLABLE PHIEUPH YU CHIEUCH
    case 0xC043: code_point = 0xD500; break; // HANGUL SYLLABLE PHIEUPH YU KHIEUKH
    case 0xC044: code_point = 0xD501; break; // HANGUL SYLLABLE PHIEUPH YU THIEUTH
    case 0xC045: code_point = 0xD502; break; // HANGUL SYLLABLE PHIEUPH YU PHIEUPH
    case 0xC046: code_point = 0xD503; break; // HANGUL SYLLABLE PHIEUPH YU HIEUH
    case 0xC047: code_point = 0xD505; break; // HANGUL SYLLABLE PHIEUPH EU KIYEOK
    case 0xC048: code_point = 0xD506; break; // HANGUL SYLLABLE PHIEUPH EU SSANGKIYEOK
    case 0xC049: code_point = 0xD507; break; // HANGUL SYLLABLE PHIEUPH EU KIYEOKSIOS
    case 0xC04A: code_point = 0xD509; break; // HANGUL SYLLABLE PHIEUPH EU NIEUNCIEUC
    case 0xC04B: code_point = 0xD50A; break; // HANGUL SYLLABLE PHIEUPH EU NIEUNHIEUH
    case 0xC04C: code_point = 0xD50B; break; // HANGUL SYLLABLE PHIEUPH EU TIKEUT
    case 0xC04D: code_point = 0xD50D; break; // HANGUL SYLLABLE PHIEUPH EU RIEULKIYEOK
    case 0xC04E: code_point = 0xD50E; break; // HANGUL SYLLABLE PHIEUPH EU RIEULMIEUM
    case 0xC04F: code_point = 0xD50F; break; // HANGUL SYLLABLE PHIEUPH EU RIEULPIEUP
    case 0xC050: code_point = 0xD510; break; // HANGUL SYLLABLE PHIEUPH EU RIEULSIOS
    case 0xC051: code_point = 0xD511; break; // HANGUL SYLLABLE PHIEUPH EU RIEULTHIEUTH
    case 0xC052: code_point = 0xD512; break; // HANGUL SYLLABLE PHIEUPH EU RIEULPHIEUPH
    case 0xC053: code_point = 0xD513; break; // HANGUL SYLLABLE PHIEUPH EU RIEULHIEUH
    case 0xC054: code_point = 0xD516; break; // HANGUL SYLLABLE PHIEUPH EU PIEUPSIOS
    case 0xC055: code_point = 0xD518; break; // HANGUL SYLLABLE PHIEUPH EU SSANGSIOS
    case 0xC056: code_point = 0xD519; break; // HANGUL SYLLABLE PHIEUPH EU IEUNG
    case 0xC057: code_point = 0xD51A; break; // HANGUL SYLLABLE PHIEUPH EU CIEUC
    case 0xC058: code_point = 0xD51B; break; // HANGUL SYLLABLE PHIEUPH EU CHIEUCH
    case 0xC059: code_point = 0xD51C; break; // HANGUL SYLLABLE PHIEUPH EU KHIEUKH
    case 0xC05A: code_point = 0xD51D; break; // HANGUL SYLLABLE PHIEUPH EU THIEUTH
    case 0xC061: code_point = 0xD51E; break; // HANGUL SYLLABLE PHIEUPH EU PHIEUPH
    case 0xC062: code_point = 0xD51F; break; // HANGUL SYLLABLE PHIEUPH EU HIEUH
    case 0xC063: code_point = 0xD520; break; // HANGUL SYLLABLE PHIEUPH YI
    case 0xC064: code_point = 0xD521; break; // HANGUL SYLLABLE PHIEUPH YI KIYEOK
    case 0xC065: code_point = 0xD522; break; // HANGUL SYLLABLE PHIEUPH YI SSANGKIYEOK
    case 0xC066: code_point = 0xD523; break; // HANGUL SYLLABLE PHIEUPH YI KIYEOKSIOS
    case 0xC067: code_point = 0xD524; break; // HANGUL SYLLABLE PHIEUPH YI NIEUN
    case 0xC068: code_point = 0xD525; break; // HANGUL SYLLABLE PHIEUPH YI NIEUNCIEUC
    case 0xC069: code_point = 0xD526; break; // HANGUL SYLLABLE PHIEUPH YI NIEUNHIEUH
    case 0xC06A: code_point = 0xD527; break; // HANGUL SYLLABLE PHIEUPH YI TIKEUT
    case 0xC06B: code_point = 0xD528; break; // HANGUL SYLLABLE PHIEUPH YI RIEUL
    case 0xC06C: code_point = 0xD529; break; // HANGUL SYLLABLE PHIEUPH YI RIEULKIYEOK
    case 0xC06D: code_point = 0xD52A; break; // HANGUL SYLLABLE PHIEUPH YI RIEULMIEUM
    case 0xC06E: code_point = 0xD52B; break; // HANGUL SYLLABLE PHIEUPH YI RIEULPIEUP
    case 0xC06F: code_point = 0xD52C; break; // HANGUL SYLLABLE PHIEUPH YI RIEULSIOS
    case 0xC070: code_point = 0xD52D; break; // HANGUL SYLLABLE PHIEUPH YI RIEULTHIEUTH
    case 0xC071: code_point = 0xD52E; break; // HANGUL SYLLABLE PHIEUPH YI RIEULPHIEUPH
    case 0xC072: code_point = 0xD52F; break; // HANGUL SYLLABLE PHIEUPH YI RIEULHIEUH
    case 0xC073: code_point = 0xD530; break; // HANGUL SYLLABLE PHIEUPH YI MIEUM
    case 0xC074: code_point = 0xD531; break; // HANGUL SYLLABLE PHIEUPH YI PIEUP
    case 0xC075: code_point = 0xD532; break; // HANGUL SYLLABLE PHIEUPH YI PIEUPSIOS
    case 0xC076: code_point = 0xD533; break; // HANGUL SYLLABLE PHIEUPH YI SIOS
    case 0xC077: code_point = 0xD534; break; // HANGUL SYLLABLE PHIEUPH YI SSANGSIOS
    case 0xC078: code_point = 0xD535; break; // HANGUL SYLLABLE PHIEUPH YI IEUNG
    case 0xC079: code_point = 0xD536; break; // HANGUL SYLLABLE PHIEUPH YI CIEUC
    case 0xC07A: code_point = 0xD537; break; // HANGUL SYLLABLE PHIEUPH YI CHIEUCH
    case 0xC081: code_point = 0xD538; break; // HANGUL SYLLABLE PHIEUPH YI KHIEUKH
    case 0xC082: code_point = 0xD539; break; // HANGUL SYLLABLE PHIEUPH YI THIEUTH
    case 0xC083: code_point = 0xD53A; break; // HANGUL SYLLABLE PHIEUPH YI PHIEUPH
    case 0xC084: code_point = 0xD53B; break; // HANGUL SYLLABLE PHIEUPH YI HIEUH
    case 0xC085: code_point = 0xD53E; break; // HANGUL SYLLABLE PHIEUPH I SSANGKIYEOK
    case 0xC086: code_point = 0xD53F; break; // HANGUL SYLLABLE PHIEUPH I KIYEOKSIOS
    case 0xC087: code_point = 0xD541; break; // HANGUL SYLLABLE PHIEUPH I NIEUNCIEUC
    case 0xC088: code_point = 0xD542; break; // HANGUL SYLLABLE PHIEUPH I NIEUNHIEUH
    case 0xC089: code_point = 0xD543; break; // HANGUL SYLLABLE PHIEUPH I TIKEUT
    case 0xC08A: code_point = 0xD545; break; // HANGUL SYLLABLE PHIEUPH I RIEULKIYEOK
    case 0xC08B: code_point = 0xD546; break; // HANGUL SYLLABLE PHIEUPH I RIEULMIEUM
    case 0xC08C: code_point = 0xD547; break; // HANGUL SYLLABLE PHIEUPH I RIEULPIEUP
    case 0xC08D: code_point = 0xD548; break; // HANGUL SYLLABLE PHIEUPH I RIEULSIOS
    case 0xC08E: code_point = 0xD549; break; // HANGUL SYLLABLE PHIEUPH I RIEULTHIEUTH
    case 0xC08F: code_point = 0xD54A; break; // HANGUL SYLLABLE PHIEUPH I RIEULPHIEUPH
    case 0xC090: code_point = 0xD54B; break; // HANGUL SYLLABLE PHIEUPH I RIEULHIEUH
    case 0xC091: code_point = 0xD54E; break; // HANGUL SYLLABLE PHIEUPH I PIEUPSIOS
    case 0xC092: code_point = 0xD550; break; // HANGUL SYLLABLE PHIEUPH I SSANGSIOS
    case 0xC093: code_point = 0xD552; break; // HANGUL SYLLABLE PHIEUPH I CIEUC
    case 0xC094: code_point = 0xD553; break; // HANGUL SYLLABLE PHIEUPH I CHIEUCH
    case 0xC095: code_point = 0xD554; break; // HANGUL SYLLABLE PHIEUPH I KHIEUKH
    case 0xC096: code_point = 0xD555; break; // HANGUL SYLLABLE PHIEUPH I THIEUTH
    case 0xC097: code_point = 0xD556; break; // HANGUL SYLLABLE PHIEUPH I PHIEUPH
    case 0xC098: code_point = 0xD557; break; // HANGUL SYLLABLE PHIEUPH I HIEUH
    case 0xC099: code_point = 0xD55A; break; // HANGUL SYLLABLE HIEUH A SSANGKIYEOK
    case 0xC09A: code_point = 0xD55B; break; // HANGUL SYLLABLE HIEUH A KIYEOKSIOS
    case 0xC09B: code_point = 0xD55D; break; // HANGUL SYLLABLE HIEUH A NIEUNCIEUC
    case 0xC09C: code_point = 0xD55E; break; // HANGUL SYLLABLE HIEUH A NIEUNHIEUH
    case 0xC09D: code_point = 0xD55F; break; // HANGUL SYLLABLE HIEUH A TIKEUT
    case 0xC09E: code_point = 0xD561; break; // HANGUL SYLLABLE HIEUH A RIEULKIYEOK
    case 0xC09F: code_point = 0xD562; break; // HANGUL SYLLABLE HIEUH A RIEULMIEUM
    case 0xC0A0: code_point = 0xD563; break; // HANGUL SYLLABLE HIEUH A RIEULPIEUP
    case 0xC0A1: code_point = 0xC6E9; break; // HANGUL SYLLABLE IEUNG WE KIYEOK
    case 0xC0A2: code_point = 0xC6EC; break; // HANGUL SYLLABLE IEUNG WE NIEUN
    case 0xC0A3: code_point = 0xC6F0; break; // HANGUL SYLLABLE IEUNG WE RIEUL
    case 0xC0A4: code_point = 0xC6F8; break; // HANGUL SYLLABLE IEUNG WE MIEUM
    case 0xC0A5: code_point = 0xC6F9; break; // HANGUL SYLLABLE IEUNG WE PIEUP
    case 0xC0A6: code_point = 0xC6FD; break; // HANGUL SYLLABLE IEUNG WE IEUNG
    case 0xC0A7: code_point = 0xC704; break; // HANGUL SYLLABLE IEUNG WI
    case 0xC0A8: code_point = 0xC705; break; // HANGUL SYLLABLE IEUNG WI KIYEOK
    case 0xC0A9: code_point = 0xC708; break; // HANGUL SYLLABLE IEUNG WI NIEUN
    case 0xC0AA: code_point = 0xC70C; break; // HANGUL SYLLABLE IEUNG WI RIEUL
    case 0xC0AB: code_point = 0xC714; break; // HANGUL SYLLABLE IEUNG WI MIEUM
    case 0xC0AC: code_point = 0xC715; break; // HANGUL SYLLABLE IEUNG WI PIEUP
    case 0xC0AD: code_point = 0xC717; break; // HANGUL SYLLABLE IEUNG WI SIOS
    case 0xC0AE: code_point = 0xC719; break; // HANGUL SYLLABLE IEUNG WI IEUNG
    case 0xC0AF: code_point = 0xC720; break; // HANGUL SYLLABLE IEUNG YU
    case 0xC0B0: code_point = 0xC721; break; // HANGUL SYLLABLE IEUNG YU KIYEOK
    case 0xC0B1: code_point = 0xC724; break; // HANGUL SYLLABLE IEUNG YU NIEUN
    case 0xC0B2: code_point = 0xC728; break; // HANGUL SYLLABLE IEUNG YU RIEUL
    case 0xC0B3: code_point = 0xC730; break; // HANGUL SYLLABLE IEUNG YU MIEUM
    case 0xC0B4: code_point = 0xC731; break; // HANGUL SYLLABLE IEUNG YU PIEUP
    case 0xC0B5: code_point = 0xC733; break; // HANGUL SYLLABLE IEUNG YU SIOS
    case 0xC0B6: code_point = 0xC735; break; // HANGUL SYLLABLE IEUNG YU IEUNG
    case 0xC0B7: code_point = 0xC737; break; // HANGUL SYLLABLE IEUNG YU CHIEUCH
    case 0xC0B8: code_point = 0xC73C; break; // HANGUL SYLLABLE IEUNG EU
    case 0xC0B9: code_point = 0xC73D; break; // HANGUL SYLLABLE IEUNG EU KIYEOK
    case 0xC0BA: code_point = 0xC740; break; // HANGUL SYLLABLE IEUNG EU NIEUN
    case 0xC0BB: code_point = 0xC744; break; // HANGUL SYLLABLE IEUNG EU RIEUL
    case 0xC0BC: code_point = 0xC74A; break; // HANGUL SYLLABLE IEUNG EU RIEULPHIEUPH
    case 0xC0BD: code_point = 0xC74C; break; // HANGUL SYLLABLE IEUNG EU MIEUM
    case 0xC0BE: code_point = 0xC74D; break; // HANGUL SYLLABLE IEUNG EU PIEUP
    case 0xC0BF: code_point = 0xC74F; break; // HANGUL SYLLABLE IEUNG EU SIOS
    case 0xC0C0: code_point = 0xC751; break; // HANGUL SYLLABLE IEUNG EU IEUNG
    case 0xC0C1: code_point = 0xC752; break; // HANGUL SYLLABLE IEUNG EU CIEUC
    case 0xC0C2: code_point = 0xC753; break; // HANGUL SYLLABLE IEUNG EU CHIEUCH
    case 0xC0C3: code_point = 0xC754; break; // HANGUL SYLLABLE IEUNG EU KHIEUKH
    case 0xC0C4: code_point = 0xC755; break; // HANGUL SYLLABLE IEUNG EU THIEUTH
    case 0xC0C5: code_point = 0xC756; break; // HANGUL SYLLABLE IEUNG EU PHIEUPH
    case 0xC0C6: code_point = 0xC757; break; // HANGUL SYLLABLE IEUNG EU HIEUH
    case 0xC0C7: code_point = 0xC758; break; // HANGUL SYLLABLE IEUNG YI
    case 0xC0C8: code_point = 0xC75C; break; // HANGUL SYLLABLE IEUNG YI NIEUN
    case 0xC0C9: code_point = 0xC760; break; // HANGUL SYLLABLE IEUNG YI RIEUL
    case 0xC0CA: code_point = 0xC768; break; // HANGUL SYLLABLE IEUNG YI MIEUM
    case 0xC0CB: code_point = 0xC76B; break; // HANGUL SYLLABLE IEUNG YI SIOS
    case 0xC0CC: code_point = 0xC774; break; // HANGUL SYLLABLE IEUNG I
    case 0xC0CD: code_point = 0xC775; break; // HANGUL SYLLABLE IEUNG I KIYEOK
    case 0xC0CE: code_point = 0xC778; break; // HANGUL SYLLABLE IEUNG I NIEUN
    case 0xC0CF: code_point = 0xC77C; break; // HANGUL SYLLABLE IEUNG I RIEUL
    case 0xC0D0: code_point = 0xC77D; break; // HANGUL SYLLABLE IEUNG I RIEULKIYEOK
    case 0xC0D1: code_point = 0xC77E; break; // HANGUL SYLLABLE IEUNG I RIEULMIEUM
    case 0xC0D2: code_point = 0xC783; break; // HANGUL SYLLABLE IEUNG I RIEULHIEUH
    case 0xC0D3: code_point = 0xC784; break; // HANGUL SYLLABLE IEUNG I MIEUM
    case 0xC0D4: code_point = 0xC785; break; // HANGUL SYLLABLE IEUNG I PIEUP
    case 0xC0D5: code_point = 0xC787; break; // HANGUL SYLLABLE IEUNG I SIOS
    case 0xC0D6: code_point = 0xC788; break; // HANGUL SYLLABLE IEUNG I SSANGSIOS
    case 0xC0D7: code_point = 0xC789; break; // HANGUL SYLLABLE IEUNG I IEUNG
    case 0xC0D8: code_point = 0xC78A; break; // HANGUL SYLLABLE IEUNG I CIEUC
    case 0xC0D9: code_point = 0xC78E; break; // HANGUL SYLLABLE IEUNG I PHIEUPH
    case 0xC0DA: code_point = 0xC790; break; // HANGUL SYLLABLE CIEUC A
    case 0xC0DB: code_point = 0xC791; break; // HANGUL SYLLABLE CIEUC A KIYEOK
    case 0xC0DC: code_point = 0xC794; break; // HANGUL SYLLABLE CIEUC A NIEUN
    case 0xC0DD: code_point = 0xC796; break; // HANGUL SYLLABLE CIEUC A NIEUNHIEUH
    case 0xC0DE: code_point = 0xC797; break; // HANGUL SYLLABLE CIEUC A TIKEUT
    case 0xC0DF: code_point = 0xC798; break; // HANGUL SYLLABLE CIEUC A RIEUL
    case 0xC0E0: code_point = 0xC79A; break; // HANGUL SYLLABLE CIEUC A RIEULMIEUM
    case 0xC0E1: code_point = 0xC7A0; break; // HANGUL SYLLABLE CIEUC A MIEUM
    case 0xC0E2: code_point = 0xC7A1; break; // HANGUL SYLLABLE CIEUC A PIEUP
    case 0xC0E3: code_point = 0xC7A3; break; // HANGUL SYLLABLE CIEUC A SIOS
    case 0xC0E4: code_point = 0xC7A4; break; // HANGUL SYLLABLE CIEUC A SSANGSIOS
    case 0xC0E5: code_point = 0xC7A5; break; // HANGUL SYLLABLE CIEUC A IEUNG
    case 0xC0E6: code_point = 0xC7A6; break; // HANGUL SYLLABLE CIEUC A CIEUC
    case 0xC0E7: code_point = 0xC7AC; break; // HANGUL SYLLABLE CIEUC AE
    case 0xC0E8: code_point = 0xC7AD; break; // HANGUL SYLLABLE CIEUC AE KIYEOK
    case 0xC0E9: code_point = 0xC7B0; break; // HANGUL SYLLABLE CIEUC AE NIEUN
    case 0xC0EA: code_point = 0xC7B4; break; // HANGUL SYLLABLE CIEUC AE RIEUL
    case 0xC0EB: code_point = 0xC7BC; break; // HANGUL SYLLABLE CIEUC AE MIEUM
    case 0xC0EC: code_point = 0xC7BD; break; // HANGUL SYLLABLE CIEUC AE PIEUP
    case 0xC0ED: code_point = 0xC7BF; break; // HANGUL SYLLABLE CIEUC AE SIOS
    case 0xC0EE: code_point = 0xC7C0; break; // HANGUL SYLLABLE CIEUC AE SSANGSIOS
    case 0xC0EF: code_point = 0xC7C1; break; // HANGUL SYLLABLE CIEUC AE IEUNG
    case 0xC0F0: code_point = 0xC7C8; break; // HANGUL SYLLABLE CIEUC YA
    case 0xC0F1: code_point = 0xC7C9; break; // HANGUL SYLLABLE CIEUC YA KIYEOK
    case 0xC0F2: code_point = 0xC7CC; break; // HANGUL SYLLABLE CIEUC YA NIEUN
    case 0xC0F3: code_point = 0xC7CE; break; // HANGUL SYLLABLE CIEUC YA NIEUNHIEUH
    case 0xC0F4: code_point = 0xC7D0; break; // HANGUL SYLLABLE CIEUC YA RIEUL
    case 0xC0F5: code_point = 0xC7D8; break; // HANGUL SYLLABLE CIEUC YA MIEUM
    case 0xC0F6: code_point = 0xC7DD; break; // HANGUL SYLLABLE CIEUC YA IEUNG
    case 0xC0F7: code_point = 0xC7E4; break; // HANGUL SYLLABLE CIEUC YAE
    case 0xC0F8: code_point = 0xC7E8; break; // HANGUL SYLLABLE CIEUC YAE NIEUN
    case 0xC0F9: code_point = 0xC7EC; break; // HANGUL SYLLABLE CIEUC YAE RIEUL
    case 0xC0FA: code_point = 0xC800; break; // HANGUL SYLLABLE CIEUC EO
    case 0xC0FB: code_point = 0xC801; break; // HANGUL SYLLABLE CIEUC EO KIYEOK
    case 0xC0FC: code_point = 0xC804; break; // HANGUL SYLLABLE CIEUC EO NIEUN
    case 0xC0FD: code_point = 0xC808; break; // HANGUL SYLLABLE CIEUC EO RIEUL
    case 0xC0FE: code_point = 0xC80A; break; // HANGUL SYLLABLE CIEUC EO RIEULMIEUM
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xC1(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xC141: code_point = 0xD564; break; // HANGUL SYLLABLE HIEUH A RIEULSIOS
    case 0xC142: code_point = 0xD566; break; // HANGUL SYLLABLE HIEUH A RIEULPHIEUPH
    case 0xC143: code_point = 0xD567; break; // HANGUL SYLLABLE HIEUH A RIEULHIEUH
    case 0xC144: code_point = 0xD56A; break; // HANGUL SYLLABLE HIEUH A PIEUPSIOS
    case 0xC145: code_point = 0xD56C; break; // HANGUL SYLLABLE HIEUH A SSANGSIOS
    case 0xC146: code_point = 0xD56E; break; // HANGUL SYLLABLE HIEUH A CIEUC
    case 0xC147: code_point = 0xD56F; break; // HANGUL SYLLABLE HIEUH A CHIEUCH
    case 0xC148: code_point = 0xD570; break; // HANGUL SYLLABLE HIEUH A KHIEUKH
    case 0xC149: code_point = 0xD571; break; // HANGUL SYLLABLE HIEUH A THIEUTH
    case 0xC14A: code_point = 0xD572; break; // HANGUL SYLLABLE HIEUH A PHIEUPH
    case 0xC14B: code_point = 0xD573; break; // HANGUL SYLLABLE HIEUH A HIEUH
    case 0xC14C: code_point = 0xD576; break; // HANGUL SYLLABLE HIEUH AE SSANGKIYEOK
    case 0xC14D: code_point = 0xD577; break; // HANGUL SYLLABLE HIEUH AE KIYEOKSIOS
    case 0xC14E: code_point = 0xD579; break; // HANGUL SYLLABLE HIEUH AE NIEUNCIEUC
    case 0xC14F: code_point = 0xD57A; break; // HANGUL SYLLABLE HIEUH AE NIEUNHIEUH
    case 0xC150: code_point = 0xD57B; break; // HANGUL SYLLABLE HIEUH AE TIKEUT
    case 0xC151: code_point = 0xD57D; break; // HANGUL SYLLABLE HIEUH AE RIEULKIYEOK
    case 0xC152: code_point = 0xD57E; break; // HANGUL SYLLABLE HIEUH AE RIEULMIEUM
    case 0xC153: code_point = 0xD57F; break; // HANGUL SYLLABLE HIEUH AE RIEULPIEUP
    case 0xC154: code_point = 0xD580; break; // HANGUL SYLLABLE HIEUH AE RIEULSIOS
    case 0xC155: code_point = 0xD581; break; // HANGUL SYLLABLE HIEUH AE RIEULTHIEUTH
    case 0xC156: code_point = 0xD582; break; // HANGUL SYLLABLE HIEUH AE RIEULPHIEUPH
    case 0xC157: code_point = 0xD583; break; // HANGUL SYLLABLE HIEUH AE RIEULHIEUH
    case 0xC158: code_point = 0xD586; break; // HANGUL SYLLABLE HIEUH AE PIEUPSIOS
    case 0xC159: code_point = 0xD58A; break; // HANGUL SYLLABLE HIEUH AE CIEUC
    case 0xC15A: code_point = 0xD58B; break; // HANGUL SYLLABLE HIEUH AE CHIEUCH
    case 0xC161: code_point = 0xD58C; break; // HANGUL SYLLABLE HIEUH AE KHIEUKH
    case 0xC162: code_point = 0xD58D; break; // HANGUL SYLLABLE HIEUH AE THIEUTH
    case 0xC163: code_point = 0xD58E; break; // HANGUL SYLLABLE HIEUH AE PHIEUPH
    case 0xC164: code_point = 0xD58F; break; // HANGUL SYLLABLE HIEUH AE HIEUH
    case 0xC165: code_point = 0xD591; break; // HANGUL SYLLABLE HIEUH YA KIYEOK
    case 0xC166: code_point = 0xD592; break; // HANGUL SYLLABLE HIEUH YA SSANGKIYEOK
    case 0xC167: code_point = 0xD593; break; // HANGUL SYLLABLE HIEUH YA KIYEOKSIOS
    case 0xC168: code_point = 0xD594; break; // HANGUL SYLLABLE HIEUH YA NIEUN
    case 0xC169: code_point = 0xD595; break; // HANGUL SYLLABLE HIEUH YA NIEUNCIEUC
    case 0xC16A: code_point = 0xD596; break; // HANGUL SYLLABLE HIEUH YA NIEUNHIEUH
    case 0xC16B: code_point = 0xD597; break; // HANGUL SYLLABLE HIEUH YA TIKEUT
    case 0xC16C: code_point = 0xD598; break; // HANGUL SYLLABLE HIEUH YA RIEUL
    case 0xC16D: code_point = 0xD599; break; // HANGUL SYLLABLE HIEUH YA RIEULKIYEOK
    case 0xC16E: code_point = 0xD59A; break; // HANGUL SYLLABLE HIEUH YA RIEULMIEUM
    case 0xC16F: code_point = 0xD59B; break; // HANGUL SYLLABLE HIEUH YA RIEULPIEUP
    case 0xC170: code_point = 0xD59C; break; // HANGUL SYLLABLE HIEUH YA RIEULSIOS
    case 0xC171: code_point = 0xD59D; break; // HANGUL SYLLABLE HIEUH YA RIEULTHIEUTH
    case 0xC172: code_point = 0xD59E; break; // HANGUL SYLLABLE HIEUH YA RIEULPHIEUPH
    case 0xC173: code_point = 0xD59F; break; // HANGUL SYLLABLE HIEUH YA RIEULHIEUH
    case 0xC174: code_point = 0xD5A0; break; // HANGUL SYLLABLE HIEUH YA MIEUM
    case 0xC175: code_point = 0xD5A1; break; // HANGUL SYLLABLE HIEUH YA PIEUP
    case 0xC176: code_point = 0xD5A2; break; // HANGUL SYLLABLE HIEUH YA PIEUPSIOS
    case 0xC177: code_point = 0xD5A3; break; // HANGUL SYLLABLE HIEUH YA SIOS
    case 0xC178: code_point = 0xD5A4; break; // HANGUL SYLLABLE HIEUH YA SSANGSIOS
    case 0xC179: code_point = 0xD5A6; break; // HANGUL SYLLABLE HIEUH YA CIEUC
    case 0xC17A: code_point = 0xD5A7; break; // HANGUL SYLLABLE HIEUH YA CHIEUCH
    case 0xC181: code_point = 0xD5A8; break; // HANGUL SYLLABLE HIEUH YA KHIEUKH
    case 0xC182: code_point = 0xD5A9; break; // HANGUL SYLLABLE HIEUH YA THIEUTH
    case 0xC183: code_point = 0xD5AA; break; // HANGUL SYLLABLE HIEUH YA PHIEUPH
    case 0xC184: code_point = 0xD5AB; break; // HANGUL SYLLABLE HIEUH YA HIEUH
    case 0xC185: code_point = 0xD5AC; break; // HANGUL SYLLABLE HIEUH YAE
    case 0xC186: code_point = 0xD5AD; break; // HANGUL SYLLABLE HIEUH YAE KIYEOK
    case 0xC187: code_point = 0xD5AE; break; // HANGUL SYLLABLE HIEUH YAE SSANGKIYEOK
    case 0xC188: code_point = 0xD5AF; break; // HANGUL SYLLABLE HIEUH YAE KIYEOKSIOS
    case 0xC189: code_point = 0xD5B0; break; // HANGUL SYLLABLE HIEUH YAE NIEUN
    case 0xC18A: code_point = 0xD5B1; break; // HANGUL SYLLABLE HIEUH YAE NIEUNCIEUC
    case 0xC18B: code_point = 0xD5B2; break; // HANGUL SYLLABLE HIEUH YAE NIEUNHIEUH
    case 0xC18C: code_point = 0xD5B3; break; // HANGUL SYLLABLE HIEUH YAE TIKEUT
    case 0xC18D: code_point = 0xD5B4; break; // HANGUL SYLLABLE HIEUH YAE RIEUL
    case 0xC18E: code_point = 0xD5B5; break; // HANGUL SYLLABLE HIEUH YAE RIEULKIYEOK
    case 0xC18F: code_point = 0xD5B6; break; // HANGUL SYLLABLE HIEUH YAE RIEULMIEUM
    case 0xC190: code_point = 0xD5B7; break; // HANGUL SYLLABLE HIEUH YAE RIEULPIEUP
    case 0xC191: code_point = 0xD5B8; break; // HANGUL SYLLABLE HIEUH YAE RIEULSIOS
    case 0xC192: code_point = 0xD5B9; break; // HANGUL SYLLABLE HIEUH YAE RIEULTHIEUTH
    case 0xC193: code_point = 0xD5BA; break; // HANGUL SYLLABLE HIEUH YAE RIEULPHIEUPH
    case 0xC194: code_point = 0xD5BB; break; // HANGUL SYLLABLE HIEUH YAE RIEULHIEUH
    case 0xC195: code_point = 0xD5BC; break; // HANGUL SYLLABLE HIEUH YAE MIEUM
    case 0xC196: code_point = 0xD5BD; break; // HANGUL SYLLABLE HIEUH YAE PIEUP
    case 0xC197: code_point = 0xD5BE; break; // HANGUL SYLLABLE HIEUH YAE PIEUPSIOS
    case 0xC198: code_point = 0xD5BF; break; // HANGUL SYLLABLE HIEUH YAE SIOS
    case 0xC199: code_point = 0xD5C0; break; // HANGUL SYLLABLE HIEUH YAE SSANGSIOS
    case 0xC19A: code_point = 0xD5C1; break; // HANGUL SYLLABLE HIEUH YAE IEUNG
    case 0xC19B: code_point = 0xD5C2; break; // HANGUL SYLLABLE HIEUH YAE CIEUC
    case 0xC19C: code_point = 0xD5C3; break; // HANGUL SYLLABLE HIEUH YAE CHIEUCH
    case 0xC19D: code_point = 0xD5C4; break; // HANGUL SYLLABLE HIEUH YAE KHIEUKH
    case 0xC19E: code_point = 0xD5C5; break; // HANGUL SYLLABLE HIEUH YAE THIEUTH
    case 0xC19F: code_point = 0xD5C6; break; // HANGUL SYLLABLE HIEUH YAE PHIEUPH
    case 0xC1A0: code_point = 0xD5C7; break; // HANGUL SYLLABLE HIEUH YAE HIEUH
    case 0xC1A1: code_point = 0xC810; break; // HANGUL SYLLABLE CIEUC EO MIEUM
    case 0xC1A2: code_point = 0xC811; break; // HANGUL SYLLABLE CIEUC EO PIEUP
    case 0xC1A3: code_point = 0xC813; break; // HANGUL SYLLABLE CIEUC EO SIOS
    case 0xC1A4: code_point = 0xC815; break; // HANGUL SYLLABLE CIEUC EO IEUNG
    case 0xC1A5: code_point = 0xC816; break; // HANGUL SYLLABLE CIEUC EO CIEUC
    case 0xC1A6: code_point = 0xC81C; break; // HANGUL SYLLABLE CIEUC E
    case 0xC1A7: code_point = 0xC81D; break; // HANGUL SYLLABLE CIEUC E KIYEOK
    case 0xC1A8: code_point = 0xC820; break; // HANGUL SYLLABLE CIEUC E NIEUN
    case 0xC1A9: code_point = 0xC824; break; // HANGUL SYLLABLE CIEUC E RIEUL
    case 0xC1AA: code_point = 0xC82C; break; // HANGUL SYLLABLE CIEUC E MIEUM
    case 0xC1AB: code_point = 0xC82D; break; // HANGUL SYLLABLE CIEUC E PIEUP
    case 0xC1AC: code_point = 0xC82F; break; // HANGUL SYLLABLE CIEUC E SIOS
    case 0xC1AD: code_point = 0xC831; break; // HANGUL SYLLABLE CIEUC E IEUNG
    case 0xC1AE: code_point = 0xC838; break; // HANGUL SYLLABLE CIEUC YEO
    case 0xC1AF: code_point = 0xC83C; break; // HANGUL SYLLABLE CIEUC YEO NIEUN
    case 0xC1B0: code_point = 0xC840; break; // HANGUL SYLLABLE CIEUC YEO RIEUL
    case 0xC1B1: code_point = 0xC848; break; // HANGUL SYLLABLE CIEUC YEO MIEUM
    case 0xC1B2: code_point = 0xC849; break; // HANGUL SYLLABLE CIEUC YEO PIEUP
    case 0xC1B3: code_point = 0xC84C; break; // HANGUL SYLLABLE CIEUC YEO SSANGSIOS
    case 0xC1B4: code_point = 0xC84D; break; // HANGUL SYLLABLE CIEUC YEO IEUNG
    case 0xC1B5: code_point = 0xC854; break; // HANGUL SYLLABLE CIEUC YE
    case 0xC1B6: code_point = 0xC870; break; // HANGUL SYLLABLE CIEUC O
    case 0xC1B7: code_point = 0xC871; break; // HANGUL SYLLABLE CIEUC O KIYEOK
    case 0xC1B8: code_point = 0xC874; break; // HANGUL SYLLABLE CIEUC O NIEUN
    case 0xC1B9: code_point = 0xC878; break; // HANGUL SYLLABLE CIEUC O RIEUL
    case 0xC1BA: code_point = 0xC87A; break; // HANGUL SYLLABLE CIEUC O RIEULMIEUM
    case 0xC1BB: code_point = 0xC880; break; // HANGUL SYLLABLE CIEUC O MIEUM
    case 0xC1BC: code_point = 0xC881; break; // HANGUL SYLLABLE CIEUC O PIEUP
    case 0xC1BD: code_point = 0xC883; break; // HANGUL SYLLABLE CIEUC O SIOS
    case 0xC1BE: code_point = 0xC885; break; // HANGUL SYLLABLE CIEUC O IEUNG
    case 0xC1BF: code_point = 0xC886; break; // HANGUL SYLLABLE CIEUC O CIEUC
    case 0xC1C0: code_point = 0xC887; break; // HANGUL SYLLABLE CIEUC O CHIEUCH
    case 0xC1C1: code_point = 0xC88B; break; // HANGUL SYLLABLE CIEUC O HIEUH
    case 0xC1C2: code_point = 0xC88C; break; // HANGUL SYLLABLE CIEUC WA
    case 0xC1C3: code_point = 0xC88D; break; // HANGUL SYLLABLE CIEUC WA KIYEOK
    case 0xC1C4: code_point = 0xC894; break; // HANGUL SYLLABLE CIEUC WA RIEUL
    case 0xC1C5: code_point = 0xC89D; break; // HANGUL SYLLABLE CIEUC WA PIEUP
    case 0xC1C6: code_point = 0xC89F; break; // HANGUL SYLLABLE CIEUC WA SIOS
    case 0xC1C7: code_point = 0xC8A1; break; // HANGUL SYLLABLE CIEUC WA IEUNG
    case 0xC1C8: code_point = 0xC8A8; break; // HANGUL SYLLABLE CIEUC WAE
    case 0xC1C9: code_point = 0xC8BC; break; // HANGUL SYLLABLE CIEUC WAE SSANGSIOS
    case 0xC1CA: code_point = 0xC8BD; break; // HANGUL SYLLABLE CIEUC WAE IEUNG
    case 0xC1CB: code_point = 0xC8C4; break; // HANGUL SYLLABLE CIEUC OE
    case 0xC1CC: code_point = 0xC8C8; break; // HANGUL SYLLABLE CIEUC OE NIEUN
    case 0xC1CD: code_point = 0xC8CC; break; // HANGUL SYLLABLE CIEUC OE RIEUL
    case 0xC1CE: code_point = 0xC8D4; break; // HANGUL SYLLABLE CIEUC OE MIEUM
    case 0xC1CF: code_point = 0xC8D5; break; // HANGUL SYLLABLE CIEUC OE PIEUP
    case 0xC1D0: code_point = 0xC8D7; break; // HANGUL SYLLABLE CIEUC OE SIOS
    case 0xC1D1: code_point = 0xC8D9; break; // HANGUL SYLLABLE CIEUC OE IEUNG
    case 0xC1D2: code_point = 0xC8E0; break; // HANGUL SYLLABLE CIEUC YO
    case 0xC1D3: code_point = 0xC8E1; break; // HANGUL SYLLABLE CIEUC YO KIYEOK
    case 0xC1D4: code_point = 0xC8E4; break; // HANGUL SYLLABLE CIEUC YO NIEUN
    case 0xC1D5: code_point = 0xC8F5; break; // HANGUL SYLLABLE CIEUC YO IEUNG
    case 0xC1D6: code_point = 0xC8FC; break; // HANGUL SYLLABLE CIEUC U
    case 0xC1D7: code_point = 0xC8FD; break; // HANGUL SYLLABLE CIEUC U KIYEOK
    case 0xC1D8: code_point = 0xC900; break; // HANGUL SYLLABLE CIEUC U NIEUN
    case 0xC1D9: code_point = 0xC904; break; // HANGUL SYLLABLE CIEUC U RIEUL
    case 0xC1DA: code_point = 0xC905; break; // HANGUL SYLLABLE CIEUC U RIEULKIYEOK
    case 0xC1DB: code_point = 0xC906; break; // HANGUL SYLLABLE CIEUC U RIEULMIEUM
    case 0xC1DC: code_point = 0xC90C; break; // HANGUL SYLLABLE CIEUC U MIEUM
    case 0xC1DD: code_point = 0xC90D; break; // HANGUL SYLLABLE CIEUC U PIEUP
    case 0xC1DE: code_point = 0xC90F; break; // HANGUL SYLLABLE CIEUC U SIOS
    case 0xC1DF: code_point = 0xC911; break; // HANGUL SYLLABLE CIEUC U IEUNG
    case 0xC1E0: code_point = 0xC918; break; // HANGUL SYLLABLE CIEUC WEO
    case 0xC1E1: code_point = 0xC92C; break; // HANGUL SYLLABLE CIEUC WEO SSANGSIOS
    case 0xC1E2: code_point = 0xC934; break; // HANGUL SYLLABLE CIEUC WE
    case 0xC1E3: code_point = 0xC950; break; // HANGUL SYLLABLE CIEUC WI
    case 0xC1E4: code_point = 0xC951; break; // HANGUL SYLLABLE CIEUC WI KIYEOK
    case 0xC1E5: code_point = 0xC954; break; // HANGUL SYLLABLE CIEUC WI NIEUN
    case 0xC1E6: code_point = 0xC958; break; // HANGUL SYLLABLE CIEUC WI RIEUL
    case 0xC1E7: code_point = 0xC960; break; // HANGUL SYLLABLE CIEUC WI MIEUM
    case 0xC1E8: code_point = 0xC961; break; // HANGUL SYLLABLE CIEUC WI PIEUP
    case 0xC1E9: code_point = 0xC963; break; // HANGUL SYLLABLE CIEUC WI SIOS
    case 0xC1EA: code_point = 0xC96C; break; // HANGUL SYLLABLE CIEUC YU
    case 0xC1EB: code_point = 0xC970; break; // HANGUL SYLLABLE CIEUC YU NIEUN
    case 0xC1EC: code_point = 0xC974; break; // HANGUL SYLLABLE CIEUC YU RIEUL
    case 0xC1ED: code_point = 0xC97C; break; // HANGUL SYLLABLE CIEUC YU MIEUM
    case 0xC1EE: code_point = 0xC988; break; // HANGUL SYLLABLE CIEUC EU
    case 0xC1EF: code_point = 0xC989; break; // HANGUL SYLLABLE CIEUC EU KIYEOK
    case 0xC1F0: code_point = 0xC98C; break; // HANGUL SYLLABLE CIEUC EU NIEUN
    case 0xC1F1: code_point = 0xC990; break; // HANGUL SYLLABLE CIEUC EU RIEUL
    case 0xC1F2: code_point = 0xC998; break; // HANGUL SYLLABLE CIEUC EU MIEUM
    case 0xC1F3: code_point = 0xC999; break; // HANGUL SYLLABLE CIEUC EU PIEUP
    case 0xC1F4: code_point = 0xC99B; break; // HANGUL SYLLABLE CIEUC EU SIOS
    case 0xC1F5: code_point = 0xC99D; break; // HANGUL SYLLABLE CIEUC EU IEUNG
    case 0xC1F6: code_point = 0xC9C0; break; // HANGUL SYLLABLE CIEUC I
    case 0xC1F7: code_point = 0xC9C1; break; // HANGUL SYLLABLE CIEUC I KIYEOK
    case 0xC1F8: code_point = 0xC9C4; break; // HANGUL SYLLABLE CIEUC I NIEUN
    case 0xC1F9: code_point = 0xC9C7; break; // HANGUL SYLLABLE CIEUC I TIKEUT
    case 0xC1FA: code_point = 0xC9C8; break; // HANGUL SYLLABLE CIEUC I RIEUL
    case 0xC1FB: code_point = 0xC9CA; break; // HANGUL SYLLABLE CIEUC I RIEULMIEUM
    case 0xC1FC: code_point = 0xC9D0; break; // HANGUL SYLLABLE CIEUC I MIEUM
    case 0xC1FD: code_point = 0xC9D1; break; // HANGUL SYLLABLE CIEUC I PIEUP
    case 0xC1FE: code_point = 0xC9D3; break; // HANGUL SYLLABLE CIEUC I SIOS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xC2(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xC241: code_point = 0xD5CA; break; // HANGUL SYLLABLE HIEUH EO SSANGKIYEOK
    case 0xC242: code_point = 0xD5CB; break; // HANGUL SYLLABLE HIEUH EO KIYEOKSIOS
    case 0xC243: code_point = 0xD5CD; break; // HANGUL SYLLABLE HIEUH EO NIEUNCIEUC
    case 0xC244: code_point = 0xD5CE; break; // HANGUL SYLLABLE HIEUH EO NIEUNHIEUH
    case 0xC245: code_point = 0xD5CF; break; // HANGUL SYLLABLE HIEUH EO TIKEUT
    case 0xC246: code_point = 0xD5D1; break; // HANGUL SYLLABLE HIEUH EO RIEULKIYEOK
    case 0xC247: code_point = 0xD5D3; break; // HANGUL SYLLABLE HIEUH EO RIEULPIEUP
    case 0xC248: code_point = 0xD5D4; break; // HANGUL SYLLABLE HIEUH EO RIEULSIOS
    case 0xC249: code_point = 0xD5D5; break; // HANGUL SYLLABLE HIEUH EO RIEULTHIEUTH
    case 0xC24A: code_point = 0xD5D6; break; // HANGUL SYLLABLE HIEUH EO RIEULPHIEUPH
    case 0xC24B: code_point = 0xD5D7; break; // HANGUL SYLLABLE HIEUH EO RIEULHIEUH
    case 0xC24C: code_point = 0xD5DA; break; // HANGUL SYLLABLE HIEUH EO PIEUPSIOS
    case 0xC24D: code_point = 0xD5DC; break; // HANGUL SYLLABLE HIEUH EO SSANGSIOS
    case 0xC24E: code_point = 0xD5DE; break; // HANGUL SYLLABLE HIEUH EO CIEUC
    case 0xC24F: code_point = 0xD5DF; break; // HANGUL SYLLABLE HIEUH EO CHIEUCH
    case 0xC250: code_point = 0xD5E0; break; // HANGUL SYLLABLE HIEUH EO KHIEUKH
    case 0xC251: code_point = 0xD5E1; break; // HANGUL SYLLABLE HIEUH EO THIEUTH
    case 0xC252: code_point = 0xD5E2; break; // HANGUL SYLLABLE HIEUH EO PHIEUPH
    case 0xC253: code_point = 0xD5E3; break; // HANGUL SYLLABLE HIEUH EO HIEUH
    case 0xC254: code_point = 0xD5E6; break; // HANGUL SYLLABLE HIEUH E SSANGKIYEOK
    case 0xC255: code_point = 0xD5E7; break; // HANGUL SYLLABLE HIEUH E KIYEOKSIOS
    case 0xC256: code_point = 0xD5E9; break; // HANGUL SYLLABLE HIEUH E NIEUNCIEUC
    case 0xC257: code_point = 0xD5EA; break; // HANGUL SYLLABLE HIEUH E NIEUNHIEUH
    case 0xC258: code_point = 0xD5EB; break; // HANGUL SYLLABLE HIEUH E TIKEUT
    case 0xC259: code_point = 0xD5ED; break; // HANGUL SYLLABLE HIEUH E RIEULKIYEOK
    case 0xC25A: code_point = 0xD5EE; break; // HANGUL SYLLABLE HIEUH E RIEULMIEUM
    case 0xC261: code_point = 0xD5EF; break; // HANGUL SYLLABLE HIEUH E RIEULPIEUP
    case 0xC262: code_point = 0xD5F0; break; // HANGUL SYLLABLE HIEUH E RIEULSIOS
    case 0xC263: code_point = 0xD5F1; break; // HANGUL SYLLABLE HIEUH E RIEULTHIEUTH
    case 0xC264: code_point = 0xD5F2; break; // HANGUL SYLLABLE HIEUH E RIEULPHIEUPH
    case 0xC265: code_point = 0xD5F3; break; // HANGUL SYLLABLE HIEUH E RIEULHIEUH
    case 0xC266: code_point = 0xD5F6; break; // HANGUL SYLLABLE HIEUH E PIEUPSIOS
    case 0xC267: code_point = 0xD5F8; break; // HANGUL SYLLABLE HIEUH E SSANGSIOS
    case 0xC268: code_point = 0xD5FA; break; // HANGUL SYLLABLE HIEUH E CIEUC
    case 0xC269: code_point = 0xD5FB; break; // HANGUL SYLLABLE HIEUH E CHIEUCH
    case 0xC26A: code_point = 0xD5FC; break; // HANGUL SYLLABLE HIEUH E KHIEUKH
    case 0xC26B: code_point = 0xD5FD; break; // HANGUL SYLLABLE HIEUH E THIEUTH
    case 0xC26C: code_point = 0xD5FE; break; // HANGUL SYLLABLE HIEUH E PHIEUPH
    case 0xC26D: code_point = 0xD5FF; break; // HANGUL SYLLABLE HIEUH E HIEUH
    case 0xC26E: code_point = 0xD602; break; // HANGUL SYLLABLE HIEUH YEO SSANGKIYEOK
    case 0xC26F: code_point = 0xD603; break; // HANGUL SYLLABLE HIEUH YEO KIYEOKSIOS
    case 0xC270: code_point = 0xD605; break; // HANGUL SYLLABLE HIEUH YEO NIEUNCIEUC
    case 0xC271: code_point = 0xD606; break; // HANGUL SYLLABLE HIEUH YEO NIEUNHIEUH
    case 0xC272: code_point = 0xD607; break; // HANGUL SYLLABLE HIEUH YEO TIKEUT
    case 0xC273: code_point = 0xD609; break; // HANGUL SYLLABLE HIEUH YEO RIEULKIYEOK
    case 0xC274: code_point = 0xD60A; break; // HANGUL SYLLABLE HIEUH YEO RIEULMIEUM
    case 0xC275: code_point = 0xD60B; break; // HANGUL SYLLABLE HIEUH YEO RIEULPIEUP
    case 0xC276: code_point = 0xD60C; break; // HANGUL SYLLABLE HIEUH YEO RIEULSIOS
    case 0xC277: code_point = 0xD60D; break; // HANGUL SYLLABLE HIEUH YEO RIEULTHIEUTH
    case 0xC278: code_point = 0xD60E; break; // HANGUL SYLLABLE HIEUH YEO RIEULPHIEUPH
    case 0xC279: code_point = 0xD60F; break; // HANGUL SYLLABLE HIEUH YEO RIEULHIEUH
    case 0xC27A: code_point = 0xD612; break; // HANGUL SYLLABLE HIEUH YEO PIEUPSIOS
    case 0xC281: code_point = 0xD616; break; // HANGUL SYLLABLE HIEUH YEO CIEUC
    case 0xC282: code_point = 0xD617; break; // HANGUL SYLLABLE HIEUH YEO CHIEUCH
    case 0xC283: code_point = 0xD618; break; // HANGUL SYLLABLE HIEUH YEO KHIEUKH
    case 0xC284: code_point = 0xD619; break; // HANGUL SYLLABLE HIEUH YEO THIEUTH
    case 0xC285: code_point = 0xD61A; break; // HANGUL SYLLABLE HIEUH YEO PHIEUPH
    case 0xC286: code_point = 0xD61B; break; // HANGUL SYLLABLE HIEUH YEO HIEUH
    case 0xC287: code_point = 0xD61D; break; // HANGUL SYLLABLE HIEUH YE KIYEOK
    case 0xC288: code_point = 0xD61E; break; // HANGUL SYLLABLE HIEUH YE SSANGKIYEOK
    case 0xC289: code_point = 0xD61F; break; // HANGUL SYLLABLE HIEUH YE KIYEOKSIOS
    case 0xC28A: code_point = 0xD621; break; // HANGUL SYLLABLE HIEUH YE NIEUNCIEUC
    case 0xC28B: code_point = 0xD622; break; // HANGUL SYLLABLE HIEUH YE NIEUNHIEUH
    case 0xC28C: code_point = 0xD623; break; // HANGUL SYLLABLE HIEUH YE TIKEUT
    case 0xC28D: code_point = 0xD625; break; // HANGUL SYLLABLE HIEUH YE RIEULKIYEOK
    case 0xC28E: code_point = 0xD626; break; // HANGUL SYLLABLE HIEUH YE RIEULMIEUM
    case 0xC28F: code_point = 0xD627; break; // HANGUL SYLLABLE HIEUH YE RIEULPIEUP
    case 0xC290: code_point = 0xD628; break; // HANGUL SYLLABLE HIEUH YE RIEULSIOS
    case 0xC291: code_point = 0xD629; break; // HANGUL SYLLABLE HIEUH YE RIEULTHIEUTH
    case 0xC292: code_point = 0xD62A; break; // HANGUL SYLLABLE HIEUH YE RIEULPHIEUPH
    case 0xC293: code_point = 0xD62B; break; // HANGUL SYLLABLE HIEUH YE RIEULHIEUH
    case 0xC294: code_point = 0xD62C; break; // HANGUL SYLLABLE HIEUH YE MIEUM
    case 0xC295: code_point = 0xD62E; break; // HANGUL SYLLABLE HIEUH YE PIEUPSIOS
    case 0xC296: code_point = 0xD62F; break; // HANGUL SYLLABLE HIEUH YE SIOS
    case 0xC297: code_point = 0xD630; break; // HANGUL SYLLABLE HIEUH YE SSANGSIOS
    case 0xC298: code_point = 0xD631; break; // HANGUL SYLLABLE HIEUH YE IEUNG
    case 0xC299: code_point = 0xD632; break; // HANGUL SYLLABLE HIEUH YE CIEUC
    case 0xC29A: code_point = 0xD633; break; // HANGUL SYLLABLE HIEUH YE CHIEUCH
    case 0xC29B: code_point = 0xD634; break; // HANGUL SYLLABLE HIEUH YE KHIEUKH
    case 0xC29C: code_point = 0xD635; break; // HANGUL SYLLABLE HIEUH YE THIEUTH
    case 0xC29D: code_point = 0xD636; break; // HANGUL SYLLABLE HIEUH YE PHIEUPH
    case 0xC29E: code_point = 0xD637; break; // HANGUL SYLLABLE HIEUH YE HIEUH
    case 0xC29F: code_point = 0xD63A; break; // HANGUL SYLLABLE HIEUH O SSANGKIYEOK
    case 0xC2A0: code_point = 0xD63B; break; // HANGUL SYLLABLE HIEUH O KIYEOKSIOS
    case 0xC2A1: code_point = 0xC9D5; break; // HANGUL SYLLABLE CIEUC I IEUNG
    case 0xC2A2: code_point = 0xC9D6; break; // HANGUL SYLLABLE CIEUC I CIEUC
    case 0xC2A3: code_point = 0xC9D9; break; // HANGUL SYLLABLE CIEUC I THIEUTH
    case 0xC2A4: code_point = 0xC9DA; break; // HANGUL SYLLABLE CIEUC I PHIEUPH
    case 0xC2A5: code_point = 0xC9DC; break; // HANGUL SYLLABLE SSANGCIEUC A
    case 0xC2A6: code_point = 0xC9DD; break; // HANGUL SYLLABLE SSANGCIEUC A KIYEOK
    case 0xC2A7: code_point = 0xC9E0; break; // HANGUL SYLLABLE SSANGCIEUC A NIEUN
    case 0xC2A8: code_point = 0xC9E2; break; // HANGUL SYLLABLE SSANGCIEUC A NIEUNHIEUH
    case 0xC2A9: code_point = 0xC9E4; break; // HANGUL SYLLABLE SSANGCIEUC A RIEUL
    case 0xC2AA: code_point = 0xC9E7; break; // HANGUL SYLLABLE SSANGCIEUC A RIEULPIEUP
    case 0xC2AB: code_point = 0xC9EC; break; // HANGUL SYLLABLE SSANGCIEUC A MIEUM
    case 0xC2AC: code_point = 0xC9ED; break; // HANGUL SYLLABLE SSANGCIEUC A PIEUP
    case 0xC2AD: code_point = 0xC9EF; break; // HANGUL SYLLABLE SSANGCIEUC A SIOS
    case 0xC2AE: code_point = 0xC9F0; break; // HANGUL SYLLABLE SSANGCIEUC A SSANGSIOS
    case 0xC2AF: code_point = 0xC9F1; break; // HANGUL SYLLABLE SSANGCIEUC A IEUNG
    case 0xC2B0: code_point = 0xC9F8; break; // HANGUL SYLLABLE SSANGCIEUC AE
    case 0xC2B1: code_point = 0xC9F9; break; // HANGUL SYLLABLE SSANGCIEUC AE KIYEOK
    case 0xC2B2: code_point = 0xC9FC; break; // HANGUL SYLLABLE SSANGCIEUC AE NIEUN
    case 0xC2B3: code_point = 0xCA00; break; // HANGUL SYLLABLE SSANGCIEUC AE RIEUL
    case 0xC2B4: code_point = 0xCA08; break; // HANGUL SYLLABLE SSANGCIEUC AE MIEUM
    case 0xC2B5: code_point = 0xCA09; break; // HANGUL SYLLABLE SSANGCIEUC AE PIEUP
    case 0xC2B6: code_point = 0xCA0B; break; // HANGUL SYLLABLE SSANGCIEUC AE SIOS
    case 0xC2B7: code_point = 0xCA0C; break; // HANGUL SYLLABLE SSANGCIEUC AE SSANGSIOS
    case 0xC2B8: code_point = 0xCA0D; break; // HANGUL SYLLABLE SSANGCIEUC AE IEUNG
    case 0xC2B9: code_point = 0xCA14; break; // HANGUL SYLLABLE SSANGCIEUC YA
    case 0xC2BA: code_point = 0xCA18; break; // HANGUL SYLLABLE SSANGCIEUC YA NIEUN
    case 0xC2BB: code_point = 0xCA29; break; // HANGUL SYLLABLE SSANGCIEUC YA IEUNG
    case 0xC2BC: code_point = 0xCA4C; break; // HANGUL SYLLABLE SSANGCIEUC EO
    case 0xC2BD: code_point = 0xCA4D; break; // HANGUL SYLLABLE SSANGCIEUC EO KIYEOK
    case 0xC2BE: code_point = 0xCA50; break; // HANGUL SYLLABLE SSANGCIEUC EO NIEUN
    case 0xC2BF: code_point = 0xCA54; break; // HANGUL SYLLABLE SSANGCIEUC EO RIEUL
    case 0xC2C0: code_point = 0xCA5C; break; // HANGUL SYLLABLE SSANGCIEUC EO MIEUM
    case 0xC2C1: code_point = 0xCA5D; break; // HANGUL SYLLABLE SSANGCIEUC EO PIEUP
    case 0xC2C2: code_point = 0xCA5F; break; // HANGUL SYLLABLE SSANGCIEUC EO SIOS
    case 0xC2C3: code_point = 0xCA60; break; // HANGUL SYLLABLE SSANGCIEUC EO SSANGSIOS
    case 0xC2C4: code_point = 0xCA61; break; // HANGUL SYLLABLE SSANGCIEUC EO IEUNG
    case 0xC2C5: code_point = 0xCA68; break; // HANGUL SYLLABLE SSANGCIEUC E
    case 0xC2C6: code_point = 0xCA7D; break; // HANGUL SYLLABLE SSANGCIEUC E IEUNG
    case 0xC2C7: code_point = 0xCA84; break; // HANGUL SYLLABLE SSANGCIEUC YEO
    case 0xC2C8: code_point = 0xCA98; break; // HANGUL SYLLABLE SSANGCIEUC YEO SSANGSIOS
    case 0xC2C9: code_point = 0xCABC; break; // HANGUL SYLLABLE SSANGCIEUC O
    case 0xC2CA: code_point = 0xCABD; break; // HANGUL SYLLABLE SSANGCIEUC O KIYEOK
    case 0xC2CB: code_point = 0xCAC0; break; // HANGUL SYLLABLE SSANGCIEUC O NIEUN
    case 0xC2CC: code_point = 0xCAC4; break; // HANGUL SYLLABLE SSANGCIEUC O RIEUL
    case 0xC2CD: code_point = 0xCACC; break; // HANGUL SYLLABLE SSANGCIEUC O MIEUM
    case 0xC2CE: code_point = 0xCACD; break; // HANGUL SYLLABLE SSANGCIEUC O PIEUP
    case 0xC2CF: code_point = 0xCACF; break; // HANGUL SYLLABLE SSANGCIEUC O SIOS
    case 0xC2D0: code_point = 0xCAD1; break; // HANGUL SYLLABLE SSANGCIEUC O IEUNG
    case 0xC2D1: code_point = 0xCAD3; break; // HANGUL SYLLABLE SSANGCIEUC O CHIEUCH
    case 0xC2D2: code_point = 0xCAD8; break; // HANGUL SYLLABLE SSANGCIEUC WA
    case 0xC2D3: code_point = 0xCAD9; break; // HANGUL SYLLABLE SSANGCIEUC WA KIYEOK
    case 0xC2D4: code_point = 0xCAE0; break; // HANGUL SYLLABLE SSANGCIEUC WA RIEUL
    case 0xC2D5: code_point = 0xCAEC; break; // HANGUL SYLLABLE SSANGCIEUC WA SSANGSIOS
    case 0xC2D6: code_point = 0xCAF4; break; // HANGUL SYLLABLE SSANGCIEUC WAE
    case 0xC2D7: code_point = 0xCB08; break; // HANGUL SYLLABLE SSANGCIEUC WAE SSANGSIOS
    case 0xC2D8: code_point = 0xCB10; break; // HANGUL SYLLABLE SSANGCIEUC OE
    case 0xC2D9: code_point = 0xCB14; break; // HANGUL SYLLABLE SSANGCIEUC OE NIEUN
    case 0xC2DA: code_point = 0xCB18; break; // HANGUL SYLLABLE SSANGCIEUC OE RIEUL
    case 0xC2DB: code_point = 0xCB20; break; // HANGUL SYLLABLE SSANGCIEUC OE MIEUM
    case 0xC2DC: code_point = 0xCB21; break; // HANGUL SYLLABLE SSANGCIEUC OE PIEUP
    case 0xC2DD: code_point = 0xCB41; break; // HANGUL SYLLABLE SSANGCIEUC YO IEUNG
    case 0xC2DE: code_point = 0xCB48; break; // HANGUL SYLLABLE SSANGCIEUC U
    case 0xC2DF: code_point = 0xCB49; break; // HANGUL SYLLABLE SSANGCIEUC U KIYEOK
    case 0xC2E0: code_point = 0xCB4C; break; // HANGUL SYLLABLE SSANGCIEUC U NIEUN
    case 0xC2E1: code_point = 0xCB50; break; // HANGUL SYLLABLE SSANGCIEUC U RIEUL
    case 0xC2E2: code_point = 0xCB58; break; // HANGUL SYLLABLE SSANGCIEUC U MIEUM
    case 0xC2E3: code_point = 0xCB59; break; // HANGUL SYLLABLE SSANGCIEUC U PIEUP
    case 0xC2E4: code_point = 0xCB5D; break; // HANGUL SYLLABLE SSANGCIEUC U IEUNG
    case 0xC2E5: code_point = 0xCB64; break; // HANGUL SYLLABLE SSANGCIEUC WEO
    case 0xC2E6: code_point = 0xCB78; break; // HANGUL SYLLABLE SSANGCIEUC WEO SSANGSIOS
    case 0xC2E7: code_point = 0xCB79; break; // HANGUL SYLLABLE SSANGCIEUC WEO IEUNG
    case 0xC2E8: code_point = 0xCB9C; break; // HANGUL SYLLABLE SSANGCIEUC WI
    case 0xC2E9: code_point = 0xCBB8; break; // HANGUL SYLLABLE SSANGCIEUC YU
    case 0xC2EA: code_point = 0xCBD4; break; // HANGUL SYLLABLE SSANGCIEUC EU
    case 0xC2EB: code_point = 0xCBE4; break; // HANGUL SYLLABLE SSANGCIEUC EU MIEUM
    case 0xC2EC: code_point = 0xCBE7; break; // HANGUL SYLLABLE SSANGCIEUC EU SIOS
    case 0xC2ED: code_point = 0xCBE9; break; // HANGUL SYLLABLE SSANGCIEUC EU IEUNG
    case 0xC2EE: code_point = 0xCC0C; break; // HANGUL SYLLABLE SSANGCIEUC I
    case 0xC2EF: code_point = 0xCC0D; break; // HANGUL SYLLABLE SSANGCIEUC I KIYEOK
    case 0xC2F0: code_point = 0xCC10; break; // HANGUL SYLLABLE SSANGCIEUC I NIEUN
    case 0xC2F1: code_point = 0xCC14; break; // HANGUL SYLLABLE SSANGCIEUC I RIEUL
    case 0xC2F2: code_point = 0xCC1C; break; // HANGUL SYLLABLE SSANGCIEUC I MIEUM
    case 0xC2F3: code_point = 0xCC1D; break; // HANGUL SYLLABLE SSANGCIEUC I PIEUP
    case 0xC2F4: code_point = 0xCC21; break; // HANGUL SYLLABLE SSANGCIEUC I IEUNG
    case 0xC2F5: code_point = 0xCC22; break; // HANGUL SYLLABLE SSANGCIEUC I CIEUC
    case 0xC2F6: code_point = 0xCC27; break; // HANGUL SYLLABLE SSANGCIEUC I HIEUH
    case 0xC2F7: code_point = 0xCC28; break; // HANGUL SYLLABLE CHIEUCH A
    case 0xC2F8: code_point = 0xCC29; break; // HANGUL SYLLABLE CHIEUCH A KIYEOK
    case 0xC2F9: code_point = 0xCC2C; break; // HANGUL SYLLABLE CHIEUCH A NIEUN
    case 0xC2FA: code_point = 0xCC2E; break; // HANGUL SYLLABLE CHIEUCH A NIEUNHIEUH
    case 0xC2FB: code_point = 0xCC30; break; // HANGUL SYLLABLE CHIEUCH A RIEUL
    case 0xC2FC: code_point = 0xCC38; break; // HANGUL SYLLABLE CHIEUCH A MIEUM
    case 0xC2FD: code_point = 0xCC39; break; // HANGUL SYLLABLE CHIEUCH A PIEUP
    case 0xC2FE: code_point = 0xCC3B; break; // HANGUL SYLLABLE CHIEUCH A SIOS
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xC3(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xC341: code_point = 0xD63D; break; // HANGUL SYLLABLE HIEUH O NIEUNCIEUC
    case 0xC342: code_point = 0xD63E; break; // HANGUL SYLLABLE HIEUH O NIEUNHIEUH
    case 0xC343: code_point = 0xD63F; break; // HANGUL SYLLABLE HIEUH O TIKEUT
    case 0xC344: code_point = 0xD641; break; // HANGUL SYLLABLE HIEUH O RIEULKIYEOK
    case 0xC345: code_point = 0xD642; break; // HANGUL SYLLABLE HIEUH O RIEULMIEUM
    case 0xC346: code_point = 0xD643; break; // HANGUL SYLLABLE HIEUH O RIEULPIEUP
    case 0xC347: code_point = 0xD644; break; // HANGUL SYLLABLE HIEUH O RIEULSIOS
    case 0xC348: code_point = 0xD646; break; // HANGUL SYLLABLE HIEUH O RIEULPHIEUPH
    case 0xC349: code_point = 0xD647; break; // HANGUL SYLLABLE HIEUH O RIEULHIEUH
    case 0xC34A: code_point = 0xD64A; break; // HANGUL SYLLABLE HIEUH O PIEUPSIOS
    case 0xC34B: code_point = 0xD64C; break; // HANGUL SYLLABLE HIEUH O SSANGSIOS
    case 0xC34C: code_point = 0xD64E; break; // HANGUL SYLLABLE HIEUH O CIEUC
    case 0xC34D: code_point = 0xD64F; break; // HANGUL SYLLABLE HIEUH O CHIEUCH
    case 0xC34E: code_point = 0xD650; break; // HANGUL SYLLABLE HIEUH O KHIEUKH
    case 0xC34F: code_point = 0xD652; break; // HANGUL SYLLABLE HIEUH O PHIEUPH
    case 0xC350: code_point = 0xD653; break; // HANGUL SYLLABLE HIEUH O HIEUH
    case 0xC351: code_point = 0xD656; break; // HANGUL SYLLABLE HIEUH WA SSANGKIYEOK
    case 0xC352: code_point = 0xD657; break; // HANGUL SYLLABLE HIEUH WA KIYEOKSIOS
    case 0xC353: code_point = 0xD659; break; // HANGUL SYLLABLE HIEUH WA NIEUNCIEUC
    case 0xC354: code_point = 0xD65A; break; // HANGUL SYLLABLE HIEUH WA NIEUNHIEUH
    case 0xC355: code_point = 0xD65B; break; // HANGUL SYLLABLE HIEUH WA TIKEUT
    case 0xC356: code_point = 0xD65D; break; // HANGUL SYLLABLE HIEUH WA RIEULKIYEOK
    case 0xC357: code_point = 0xD65E; break; // HANGUL SYLLABLE HIEUH WA RIEULMIEUM
    case 0xC358: code_point = 0xD65F; break; // HANGUL SYLLABLE HIEUH WA RIEULPIEUP
    case 0xC359: code_point = 0xD660; break; // HANGUL SYLLABLE HIEUH WA RIEULSIOS
    case 0xC35A: code_point = 0xD661; break; // HANGUL SYLLABLE HIEUH WA RIEULTHIEUTH
    case 0xC361: code_point = 0xD662; break; // HANGUL SYLLABLE HIEUH WA RIEULPHIEUPH
    case 0xC362: code_point = 0xD663; break; // HANGUL SYLLABLE HIEUH WA RIEULHIEUH
    case 0xC363: code_point = 0xD664; break; // HANGUL SYLLABLE HIEUH WA MIEUM
    case 0xC364: code_point = 0xD665; break; // HANGUL SYLLABLE HIEUH WA PIEUP
    case 0xC365: code_point = 0xD666; break; // HANGUL SYLLABLE HIEUH WA PIEUPSIOS
    case 0xC366: code_point = 0xD668; break; // HANGUL SYLLABLE HIEUH WA SSANGSIOS
    case 0xC367: code_point = 0xD66A; break; // HANGUL SYLLABLE HIEUH WA CIEUC
    case 0xC368: code_point = 0xD66B; break; // HANGUL SYLLABLE HIEUH WA CHIEUCH
    case 0xC369: code_point = 0xD66C; break; // HANGUL SYLLABLE HIEUH WA KHIEUKH
    case 0xC36A: code_point = 0xD66D; break; // HANGUL SYLLABLE HIEUH WA THIEUTH
    case 0xC36B: code_point = 0xD66E; break; // HANGUL SYLLABLE HIEUH WA PHIEUPH
    case 0xC36C: code_point = 0xD66F; break; // HANGUL SYLLABLE HIEUH WA HIEUH
    case 0xC36D: code_point = 0xD672; break; // HANGUL SYLLABLE HIEUH WAE SSANGKIYEOK
    case 0xC36E: code_point = 0xD673; break; // HANGUL SYLLABLE HIEUH WAE KIYEOKSIOS
    case 0xC36F: code_point = 0xD675; break; // HANGUL SYLLABLE HIEUH WAE NIEUNCIEUC
    case 0xC370: code_point = 0xD676; break; // HANGUL SYLLABLE HIEUH WAE NIEUNHIEUH
    case 0xC371: code_point = 0xD677; break; // HANGUL SYLLABLE HIEUH WAE TIKEUT
    case 0xC372: code_point = 0xD678; break; // HANGUL SYLLABLE HIEUH WAE RIEUL
    case 0xC373: code_point = 0xD679; break; // HANGUL SYLLABLE HIEUH WAE RIEULKIYEOK
    case 0xC374: code_point = 0xD67A; break; // HANGUL SYLLABLE HIEUH WAE RIEULMIEUM
    case 0xC375: code_point = 0xD67B; break; // HANGUL SYLLABLE HIEUH WAE RIEULPIEUP
    case 0xC376: code_point = 0xD67C; break; // HANGUL SYLLABLE HIEUH WAE RIEULSIOS
    case 0xC377: code_point = 0xD67D; break; // HANGUL SYLLABLE HIEUH WAE RIEULTHIEUTH
    case 0xC378: code_point = 0xD67E; break; // HANGUL SYLLABLE HIEUH WAE RIEULPHIEUPH
    case 0xC379: code_point = 0xD67F; break; // HANGUL SYLLABLE HIEUH WAE RIEULHIEUH
    case 0xC37A: code_point = 0xD680; break; // HANGUL SYLLABLE HIEUH WAE MIEUM
    case 0xC381: code_point = 0xD681; break; // HANGUL SYLLABLE HIEUH WAE PIEUP
    case 0xC382: code_point = 0xD682; break; // HANGUL SYLLABLE HIEUH WAE PIEUPSIOS
    case 0xC383: code_point = 0xD684; break; // HANGUL SYLLABLE HIEUH WAE SSANGSIOS
    case 0xC384: code_point = 0xD686; break; // HANGUL SYLLABLE HIEUH WAE CIEUC
    case 0xC385: code_point = 0xD687; break; // HANGUL SYLLABLE HIEUH WAE CHIEUCH
    case 0xC386: code_point = 0xD688; break; // HANGUL SYLLABLE HIEUH WAE KHIEUKH
    case 0xC387: code_point = 0xD689; break; // HANGUL SYLLABLE HIEUH WAE THIEUTH
    case 0xC388: code_point = 0xD68A; break; // HANGUL SYLLABLE HIEUH WAE PHIEUPH
    case 0xC389: code_point = 0xD68B; break; // HANGUL SYLLABLE HIEUH WAE HIEUH
    case 0xC38A: code_point = 0xD68E; break; // HANGUL SYLLABLE HIEUH OE SSANGKIYEOK
    case 0xC38B: code_point = 0xD68F; break; // HANGUL SYLLABLE HIEUH OE KIYEOKSIOS
    case 0xC38C: code_point = 0xD691; break; // HANGUL SYLLABLE HIEUH OE NIEUNCIEUC
    case 0xC38D: code_point = 0xD692; break; // HANGUL SYLLABLE HIEUH OE NIEUNHIEUH
    case 0xC38E: code_point = 0xD693; break; // HANGUL SYLLABLE HIEUH OE TIKEUT
    case 0xC38F: code_point = 0xD695; break; // HANGUL SYLLABLE HIEUH OE RIEULKIYEOK
    case 0xC390: code_point = 0xD696; break; // HANGUL SYLLABLE HIEUH OE RIEULMIEUM
    case 0xC391: code_point = 0xD697; break; // HANGUL SYLLABLE HIEUH OE RIEULPIEUP
    case 0xC392: code_point = 0xD698; break; // HANGUL SYLLABLE HIEUH OE RIEULSIOS
    case 0xC393: code_point = 0xD699; break; // HANGUL SYLLABLE HIEUH OE RIEULTHIEUTH
    case 0xC394: code_point = 0xD69A; break; // HANGUL SYLLABLE HIEUH OE RIEULPHIEUPH
    case 0xC395: code_point = 0xD69B; break; // HANGUL SYLLABLE HIEUH OE RIEULHIEUH
    case 0xC396: code_point = 0xD69C; break; // HANGUL SYLLABLE HIEUH OE MIEUM
    case 0xC397: code_point = 0xD69E; break; // HANGUL SYLLABLE HIEUH OE PIEUPSIOS
    case 0xC398: code_point = 0xD6A0; break; // HANGUL SYLLABLE HIEUH OE SSANGSIOS
    case 0xC399: code_point = 0xD6A2; break; // HANGUL SYLLABLE HIEUH OE CIEUC
    case 0xC39A: code_point = 0xD6A3; break; // HANGUL SYLLABLE HIEUH OE CHIEUCH
    case 0xC39B: code_point = 0xD6A4; break; // HANGUL SYLLABLE HIEUH OE KHIEUKH
    case 0xC39C: code_point = 0xD6A5; break; // HANGUL SYLLABLE HIEUH OE THIEUTH
    case 0xC39D: code_point = 0xD6A6; break; // HANGUL SYLLABLE HIEUH OE PHIEUPH
    case 0xC39E: code_point = 0xD6A7; break; // HANGUL SYLLABLE HIEUH OE HIEUH
    case 0xC39F: code_point = 0xD6A9; break; // HANGUL SYLLABLE HIEUH YO KIYEOK
    case 0xC3A0: code_point = 0xD6AA; break; // HANGUL SYLLABLE HIEUH YO SSANGKIYEOK
    case 0xC3A1: code_point = 0xCC3C; break; // HANGUL SYLLABLE CHIEUCH A SSANGSIOS
    case 0xC3A2: code_point = 0xCC3D; break; // HANGUL SYLLABLE CHIEUCH A IEUNG
    case 0xC3A3: code_point = 0xCC3E; break; // HANGUL SYLLABLE CHIEUCH A CIEUC
    case 0xC3A4: code_point = 0xCC44; break; // HANGUL SYLLABLE CHIEUCH AE
    case 0xC3A5: code_point = 0xCC45; break; // HANGUL SYLLABLE CHIEUCH AE KIYEOK
    case 0xC3A6: code_point = 0xCC48; break; // HANGUL SYLLABLE CHIEUCH AE NIEUN
    case 0xC3A7: code_point = 0xCC4C; break; // HANGUL SYLLABLE CHIEUCH AE RIEUL
    case 0xC3A8: code_point = 0xCC54; break; // HANGUL SYLLABLE CHIEUCH AE MIEUM
    case 0xC3A9: code_point = 0xCC55; break; // HANGUL SYLLABLE CHIEUCH AE PIEUP
    case 0xC3AA: code_point = 0xCC57; break; // HANGUL SYLLABLE CHIEUCH AE SIOS
    case 0xC3AB: code_point = 0xCC58; break; // HANGUL SYLLABLE CHIEUCH AE SSANGSIOS
    case 0xC3AC: code_point = 0xCC59; break; // HANGUL SYLLABLE CHIEUCH AE IEUNG
    case 0xC3AD: code_point = 0xCC60; break; // HANGUL SYLLABLE CHIEUCH YA
    case 0xC3AE: code_point = 0xCC64; break; // HANGUL SYLLABLE CHIEUCH YA NIEUN
    case 0xC3AF: code_point = 0xCC66; break; // HANGUL SYLLABLE CHIEUCH YA NIEUNHIEUH
    case 0xC3B0: code_point = 0xCC68; break; // HANGUL SYLLABLE CHIEUCH YA RIEUL
    case 0xC3B1: code_point = 0xCC70; break; // HANGUL SYLLABLE CHIEUCH YA MIEUM
    case 0xC3B2: code_point = 0xCC75; break; // HANGUL SYLLABLE CHIEUCH YA IEUNG
    case 0xC3B3: code_point = 0xCC98; break; // HANGUL SYLLABLE CHIEUCH EO
    case 0xC3B4: code_point = 0xCC99; break; // HANGUL SYLLABLE CHIEUCH EO KIYEOK
    case 0xC3B5: code_point = 0xCC9C; break; // HANGUL SYLLABLE CHIEUCH EO NIEUN
    case 0xC3B6: code_point = 0xCCA0; break; // HANGUL SYLLABLE CHIEUCH EO RIEUL
    case 0xC3B7: code_point = 0xCCA8; break; // HANGUL SYLLABLE CHIEUCH EO MIEUM
    case 0xC3B8: code_point = 0xCCA9; break; // HANGUL SYLLABLE CHIEUCH EO PIEUP
    case 0xC3B9: code_point = 0xCCAB; break; // HANGUL SYLLABLE CHIEUCH EO SIOS
    case 0xC3BA: code_point = 0xCCAC; break; // HANGUL SYLLABLE CHIEUCH EO SSANGSIOS
    case 0xC3BB: code_point = 0xCCAD; break; // HANGUL SYLLABLE CHIEUCH EO IEUNG
    case 0xC3BC: code_point = 0xCCB4; break; // HANGUL SYLLABLE CHIEUCH E
    case 0xC3BD: code_point = 0xCCB5; break; // HANGUL SYLLABLE CHIEUCH E KIYEOK
    case 0xC3BE: code_point = 0xCCB8; break; // HANGUL SYLLABLE CHIEUCH E NIEUN
    case 0xC3BF: code_point = 0xCCBC; break; // HANGUL SYLLABLE CHIEUCH E RIEUL
    case 0xC3C0: code_point = 0xCCC4; break; // HANGUL SYLLABLE CHIEUCH E MIEUM
    case 0xC3C1: code_point = 0xCCC5; break; // HANGUL SYLLABLE CHIEUCH E PIEUP
    case 0xC3C2: code_point = 0xCCC7; break; // HANGUL SYLLABLE CHIEUCH E SIOS
    case 0xC3C3: code_point = 0xCCC9; break; // HANGUL SYLLABLE CHIEUCH E IEUNG
    case 0xC3C4: code_point = 0xCCD0; break; // HANGUL SYLLABLE CHIEUCH YEO
    case 0xC3C5: code_point = 0xCCD4; break; // HANGUL SYLLABLE CHIEUCH YEO NIEUN
    case 0xC3C6: code_point = 0xCCE4; break; // HANGUL SYLLABLE CHIEUCH YEO SSANGSIOS
    case 0xC3C7: code_point = 0xCCEC; break; // HANGUL SYLLABLE CHIEUCH YE
    case 0xC3C8: code_point = 0xCCF0; break; // HANGUL SYLLABLE CHIEUCH YE NIEUN
    case 0xC3C9: code_point = 0xCD01; break; // HANGUL SYLLABLE CHIEUCH YE IEUNG
    case 0xC3CA: code_point = 0xCD08; break; // HANGUL SYLLABLE CHIEUCH O
    case 0xC3CB: code_point = 0xCD09; break; // HANGUL SYLLABLE CHIEUCH O KIYEOK
    case 0xC3CC: code_point = 0xCD0C; break; // HANGUL SYLLABLE CHIEUCH O NIEUN
    case 0xC3CD: code_point = 0xCD10; break; // HANGUL SYLLABLE CHIEUCH O RIEUL
    case 0xC3CE: code_point = 0xCD18; break; // HANGUL SYLLABLE CHIEUCH O MIEUM
    case 0xC3CF: code_point = 0xCD19; break; // HANGUL SYLLABLE CHIEUCH O PIEUP
    case 0xC3D0: code_point = 0xCD1B; break; // HANGUL SYLLABLE CHIEUCH O SIOS
    case 0xC3D1: code_point = 0xCD1D; break; // HANGUL SYLLABLE CHIEUCH O IEUNG
    case 0xC3D2: code_point = 0xCD24; break; // HANGUL SYLLABLE CHIEUCH WA
    case 0xC3D3: code_point = 0xCD28; break; // HANGUL SYLLABLE CHIEUCH WA NIEUN
    case 0xC3D4: code_point = 0xCD2C; break; // HANGUL SYLLABLE CHIEUCH WA RIEUL
    case 0xC3D5: code_point = 0xCD39; break; // HANGUL SYLLABLE CHIEUCH WA IEUNG
    case 0xC3D6: code_point = 0xCD5C; break; // HANGUL SYLLABLE CHIEUCH OE
    case 0xC3D7: code_point = 0xCD60; break; // HANGUL SYLLABLE CHIEUCH OE NIEUN
    case 0xC3D8: code_point = 0xCD64; break; // HANGUL SYLLABLE CHIEUCH OE RIEUL
    case 0xC3D9: code_point = 0xCD6C; break; // HANGUL SYLLABLE CHIEUCH OE MIEUM
    case 0xC3DA: code_point = 0xCD6D; break; // HANGUL SYLLABLE CHIEUCH OE PIEUP
    case 0xC3DB: code_point = 0xCD6F; break; // HANGUL SYLLABLE CHIEUCH OE SIOS
    case 0xC3DC: code_point = 0xCD71; break; // HANGUL SYLLABLE CHIEUCH OE IEUNG
    case 0xC3DD: code_point = 0xCD78; break; // HANGUL SYLLABLE CHIEUCH YO
    case 0xC3DE: code_point = 0xCD88; break; // HANGUL SYLLABLE CHIEUCH YO MIEUM
    case 0xC3DF: code_point = 0xCD94; break; // HANGUL SYLLABLE CHIEUCH U
    case 0xC3E0: code_point = 0xCD95; break; // HANGUL SYLLABLE CHIEUCH U KIYEOK
    case 0xC3E1: code_point = 0xCD98; break; // HANGUL SYLLABLE CHIEUCH U NIEUN
    case 0xC3E2: code_point = 0xCD9C; break; // HANGUL SYLLABLE CHIEUCH U RIEUL
    case 0xC3E3: code_point = 0xCDA4; break; // HANGUL SYLLABLE CHIEUCH U MIEUM
    case 0xC3E4: code_point = 0xCDA5; break; // HANGUL SYLLABLE CHIEUCH U PIEUP
    case 0xC3E5: code_point = 0xCDA7; break; // HANGUL SYLLABLE CHIEUCH U SIOS
    case 0xC3E6: code_point = 0xCDA9; break; // HANGUL SYLLABLE CHIEUCH U IEUNG
    case 0xC3E7: code_point = 0xCDB0; break; // HANGUL SYLLABLE CHIEUCH WEO
    case 0xC3E8: code_point = 0xCDC4; break; // HANGUL SYLLABLE CHIEUCH WEO SSANGSIOS
    case 0xC3E9: code_point = 0xCDCC; break; // HANGUL SYLLABLE CHIEUCH WE
    case 0xC3EA: code_point = 0xCDD0; break; // HANGUL SYLLABLE CHIEUCH WE NIEUN
    case 0xC3EB: code_point = 0xCDE8; break; // HANGUL SYLLABLE CHIEUCH WI
    case 0xC3EC: code_point = 0xCDEC; break; // HANGUL SYLLABLE CHIEUCH WI NIEUN
    case 0xC3ED: code_point = 0xCDF0; break; // HANGUL SYLLABLE CHIEUCH WI RIEUL
    case 0xC3EE: code_point = 0xCDF8; break; // HANGUL SYLLABLE CHIEUCH WI MIEUM
    case 0xC3EF: code_point = 0xCDF9; break; // HANGUL SYLLABLE CHIEUCH WI PIEUP
    case 0xC3F0: code_point = 0xCDFB; break; // HANGUL SYLLABLE CHIEUCH WI SIOS
    case 0xC3F1: code_point = 0xCDFD; break; // HANGUL SYLLABLE CHIEUCH WI IEUNG
    case 0xC3F2: code_point = 0xCE04; break; // HANGUL SYLLABLE CHIEUCH YU
    case 0xC3F3: code_point = 0xCE08; break; // HANGUL SYLLABLE CHIEUCH YU NIEUN
    case 0xC3F4: code_point = 0xCE0C; break; // HANGUL SYLLABLE CHIEUCH YU RIEUL
    case 0xC3F5: code_point = 0xCE14; break; // HANGUL SYLLABLE CHIEUCH YU MIEUM
    case 0xC3F6: code_point = 0xCE19; break; // HANGUL SYLLABLE CHIEUCH YU IEUNG
    case 0xC3F7: code_point = 0xCE20; break; // HANGUL SYLLABLE CHIEUCH EU
    case 0xC3F8: code_point = 0xCE21; break; // HANGUL SYLLABLE CHIEUCH EU KIYEOK
    case 0xC3F9: code_point = 0xCE24; break; // HANGUL SYLLABLE CHIEUCH EU NIEUN
    case 0xC3FA: code_point = 0xCE28; break; // HANGUL SYLLABLE CHIEUCH EU RIEUL
    case 0xC3FB: code_point = 0xCE30; break; // HANGUL SYLLABLE CHIEUCH EU MIEUM
    case 0xC3FC: code_point = 0xCE31; break; // HANGUL SYLLABLE CHIEUCH EU PIEUP
    case 0xC3FD: code_point = 0xCE33; break; // HANGUL SYLLABLE CHIEUCH EU SIOS
    case 0xC3FE: code_point = 0xCE35; break; // HANGUL SYLLABLE CHIEUCH EU IEUNG
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xC4(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xC441: code_point = 0xD6AB; break; // HANGUL SYLLABLE HIEUH YO KIYEOKSIOS
    case 0xC442: code_point = 0xD6AD; break; // HANGUL SYLLABLE HIEUH YO NIEUNCIEUC
    case 0xC443: code_point = 0xD6AE; break; // HANGUL SYLLABLE HIEUH YO NIEUNHIEUH
    case 0xC444: code_point = 0xD6AF; break; // HANGUL SYLLABLE HIEUH YO TIKEUT
    case 0xC445: code_point = 0xD6B1; break; // HANGUL SYLLABLE HIEUH YO RIEULKIYEOK
    case 0xC446: code_point = 0xD6B2; break; // HANGUL SYLLABLE HIEUH YO RIEULMIEUM
    case 0xC447: code_point = 0xD6B3; break; // HANGUL SYLLABLE HIEUH YO RIEULPIEUP
    case 0xC448: code_point = 0xD6B4; break; // HANGUL SYLLABLE HIEUH YO RIEULSIOS
    case 0xC449: code_point = 0xD6B5; break; // HANGUL SYLLABLE HIEUH YO RIEULTHIEUTH
    case 0xC44A: code_point = 0xD6B6; break; // HANGUL SYLLABLE HIEUH YO RIEULPHIEUPH
    case 0xC44B: code_point = 0xD6B7; break; // HANGUL SYLLABLE HIEUH YO RIEULHIEUH
    case 0xC44C: code_point = 0xD6B8; break; // HANGUL SYLLABLE HIEUH YO MIEUM
    case 0xC44D: code_point = 0xD6BA; break; // HANGUL SYLLABLE HIEUH YO PIEUPSIOS
    case 0xC44E: code_point = 0xD6BC; break; // HANGUL SYLLABLE HIEUH YO SSANGSIOS
    case 0xC44F: code_point = 0xD6BD; break; // HANGUL SYLLABLE HIEUH YO IEUNG
    case 0xC450: code_point = 0xD6BE; break; // HANGUL SYLLABLE HIEUH YO CIEUC
    case 0xC451: code_point = 0xD6BF; break; // HANGUL SYLLABLE HIEUH YO CHIEUCH
    case 0xC452: code_point = 0xD6C0; break; // HANGUL SYLLABLE HIEUH YO KHIEUKH
    case 0xC453: code_point = 0xD6C1; break; // HANGUL SYLLABLE HIEUH YO THIEUTH
    case 0xC454: code_point = 0xD6C2; break; // HANGUL SYLLABLE HIEUH YO PHIEUPH
    case 0xC455: code_point = 0xD6C3; break; // HANGUL SYLLABLE HIEUH YO HIEUH
    case 0xC456: code_point = 0xD6C6; break; // HANGUL SYLLABLE HIEUH U SSANGKIYEOK
    case 0xC457: code_point = 0xD6C7; break; // HANGUL SYLLABLE HIEUH U KIYEOKSIOS
    case 0xC458: code_point = 0xD6C9; break; // HANGUL SYLLABLE HIEUH U NIEUNCIEUC
    case 0xC459: code_point = 0xD6CA; break; // HANGUL SYLLABLE HIEUH U NIEUNHIEUH
    case 0xC45A: code_point = 0xD6CB; break; // HANGUL SYLLABLE HIEUH U TIKEUT
    case 0xC461: code_point = 0xD6CD; break; // HANGUL SYLLABLE HIEUH U RIEULKIYEOK
    case 0xC462: code_point = 0xD6CE; break; // HANGUL SYLLABLE HIEUH U RIEULMIEUM
    case 0xC463: code_point = 0xD6CF; break; // HANGUL SYLLABLE HIEUH U RIEULPIEUP
    case 0xC464: code_point = 0xD6D0; break; // HANGUL SYLLABLE HIEUH U RIEULSIOS
    case 0xC465: code_point = 0xD6D2; break; // HANGUL SYLLABLE HIEUH U RIEULPHIEUPH
    case 0xC466: code_point = 0xD6D3; break; // HANGUL SYLLABLE HIEUH U RIEULHIEUH
    case 0xC467: code_point = 0xD6D5; break; // HANGUL SYLLABLE HIEUH U PIEUP
    case 0xC468: code_point = 0xD6D6; break; // HANGUL SYLLABLE HIEUH U PIEUPSIOS
    case 0xC469: code_point = 0xD6D8; break; // HANGUL SYLLABLE HIEUH U SSANGSIOS
    case 0xC46A: code_point = 0xD6DA; break; // HANGUL SYLLABLE HIEUH U CIEUC
    case 0xC46B: code_point = 0xD6DB; break; // HANGUL SYLLABLE HIEUH U CHIEUCH
    case 0xC46C: code_point = 0xD6DC; break; // HANGUL SYLLABLE HIEUH U KHIEUKH
    case 0xC46D: code_point = 0xD6DD; break; // HANGUL SYLLABLE HIEUH U THIEUTH
    case 0xC46E: code_point = 0xD6DE; break; // HANGUL SYLLABLE HIEUH U PHIEUPH
    case 0xC46F: code_point = 0xD6DF; break; // HANGUL SYLLABLE HIEUH U HIEUH
    case 0xC470: code_point = 0xD6E1; break; // HANGUL SYLLABLE HIEUH WEO KIYEOK
    case 0xC471: code_point = 0xD6E2; break; // HANGUL SYLLABLE HIEUH WEO SSANGKIYEOK
    case 0xC472: code_point = 0xD6E3; break; // HANGUL SYLLABLE HIEUH WEO KIYEOKSIOS
    case 0xC473: code_point = 0xD6E5; break; // HANGUL SYLLABLE HIEUH WEO NIEUNCIEUC
    case 0xC474: code_point = 0xD6E6; break; // HANGUL SYLLABLE HIEUH WEO NIEUNHIEUH
    case 0xC475: code_point = 0xD6E7; break; // HANGUL SYLLABLE HIEUH WEO TIKEUT
    case 0xC476: code_point = 0xD6E9; break; // HANGUL SYLLABLE HIEUH WEO RIEULKIYEOK
    case 0xC477: code_point = 0xD6EA; break; // HANGUL SYLLABLE HIEUH WEO RIEULMIEUM
    case 0xC478: code_point = 0xD6EB; break; // HANGUL SYLLABLE HIEUH WEO RIEULPIEUP
    case 0xC479: code_point = 0xD6EC; break; // HANGUL SYLLABLE HIEUH WEO RIEULSIOS
    case 0xC47A: code_point = 0xD6ED; break; // HANGUL SYLLABLE HIEUH WEO RIEULTHIEUTH
    case 0xC481: code_point = 0xD6EE; break; // HANGUL SYLLABLE HIEUH WEO RIEULPHIEUPH
    case 0xC482: code_point = 0xD6EF; break; // HANGUL SYLLABLE HIEUH WEO RIEULHIEUH
    case 0xC483: code_point = 0xD6F1; break; // HANGUL SYLLABLE HIEUH WEO PIEUP
    case 0xC484: code_point = 0xD6F2; break; // HANGUL SYLLABLE HIEUH WEO PIEUPSIOS
    case 0xC485: code_point = 0xD6F3; break; // HANGUL SYLLABLE HIEUH WEO SIOS
    case 0xC486: code_point = 0xD6F4; break; // HANGUL SYLLABLE HIEUH WEO SSANGSIOS
    case 0xC487: code_point = 0xD6F6; break; // HANGUL SYLLABLE HIEUH WEO CIEUC
    case 0xC488: code_point = 0xD6F7; break; // HANGUL SYLLABLE HIEUH WEO CHIEUCH
    case 0xC489: code_point = 0xD6F8; break; // HANGUL SYLLABLE HIEUH WEO KHIEUKH
    case 0xC48A: code_point = 0xD6F9; break; // HANGUL SYLLABLE HIEUH WEO THIEUTH
    case 0xC48B: code_point = 0xD6FA; break; // HANGUL SYLLABLE HIEUH WEO PHIEUPH
    case 0xC48C: code_point = 0xD6FB; break; // HANGUL SYLLABLE HIEUH WEO HIEUH
    case 0xC48D: code_point = 0xD6FE; break; // HANGUL SYLLABLE HIEUH WE SSANGKIYEOK
    case 0xC48E: code_point = 0xD6FF; break; // HANGUL SYLLABLE HIEUH WE KIYEOKSIOS
    case 0xC48F: code_point = 0xD701; break; // HANGUL SYLLABLE HIEUH WE NIEUNCIEUC
    case 0xC490: code_point = 0xD702; break; // HANGUL SYLLABLE HIEUH WE NIEUNHIEUH
    case 0xC491: code_point = 0xD703; break; // HANGUL SYLLABLE HIEUH WE TIKEUT
    case 0xC492: code_point = 0xD705; break; // HANGUL SYLLABLE HIEUH WE RIEULKIYEOK
    case 0xC493: code_point = 0xD706; break; // HANGUL SYLLABLE HIEUH WE RIEULMIEUM
    case 0xC494: code_point = 0xD707; break; // HANGUL SYLLABLE HIEUH WE RIEULPIEUP
    case 0xC495: code_point = 0xD708; break; // HANGUL SYLLABLE HIEUH WE RIEULSIOS
    case 0xC496: code_point = 0xD709; break; // HANGUL SYLLABLE HIEUH WE RIEULTHIEUTH
    case 0xC497: code_point = 0xD70A; break; // HANGUL SYLLABLE HIEUH WE RIEULPHIEUPH
    case 0xC498: code_point = 0xD70B; break; // HANGUL SYLLABLE HIEUH WE RIEULHIEUH
    case 0xC499: code_point = 0xD70C; break; // HANGUL SYLLABLE HIEUH WE MIEUM
    case 0xC49A: code_point = 0xD70D; break; // HANGUL SYLLABLE HIEUH WE PIEUP
    case 0xC49B: code_point = 0xD70E; break; // HANGUL SYLLABLE HIEUH WE PIEUPSIOS
    case 0xC49C: code_point = 0xD70F; break; // HANGUL SYLLABLE HIEUH WE SIOS
    case 0xC49D: code_point = 0xD710; break; // HANGUL SYLLABLE HIEUH WE SSANGSIOS
    case 0xC49E: code_point = 0xD712; break; // HANGUL SYLLABLE HIEUH WE CIEUC
    case 0xC49F: code_point = 0xD713; break; // HANGUL SYLLABLE HIEUH WE CHIEUCH
    case 0xC4A0: code_point = 0xD714; break; // HANGUL SYLLABLE HIEUH WE KHIEUKH
    case 0xC4A1: code_point = 0xCE58; break; // HANGUL SYLLABLE CHIEUCH I
    case 0xC4A2: code_point = 0xCE59; break; // HANGUL SYLLABLE CHIEUCH I KIYEOK
    case 0xC4A3: code_point = 0xCE5C; break; // HANGUL SYLLABLE CHIEUCH I NIEUN
    case 0xC4A4: code_point = 0xCE5F; break; // HANGUL SYLLABLE CHIEUCH I TIKEUT
    case 0xC4A5: code_point = 0xCE60; break; // HANGUL SYLLABLE CHIEUCH I RIEUL
    case 0xC4A6: code_point = 0xCE61; break; // HANGUL SYLLABLE CHIEUCH I RIEULKIYEOK
    case 0xC4A7: code_point = 0xCE68; break; // HANGUL SYLLABLE CHIEUCH I MIEUM
    case 0xC4A8: code_point = 0xCE69; break; // HANGUL SYLLABLE CHIEUCH I PIEUP
    case 0xC4A9: code_point = 0xCE6B; break; // HANGUL SYLLABLE CHIEUCH I SIOS
    case 0xC4AA: code_point = 0xCE6D; break; // HANGUL SYLLABLE CHIEUCH I IEUNG
    case 0xC4AB: code_point = 0xCE74; break; // HANGUL SYLLABLE KHIEUKH A
    case 0xC4AC: code_point = 0xCE75; break; // HANGUL SYLLABLE KHIEUKH A KIYEOK
    case 0xC4AD: code_point = 0xCE78; break; // HANGUL SYLLABLE KHIEUKH A NIEUN
    case 0xC4AE: code_point = 0xCE7C; break; // HANGUL SYLLABLE KHIEUKH A RIEUL
    case 0xC4AF: code_point = 0xCE84; break; // HANGUL SYLLABLE KHIEUKH A MIEUM
    case 0xC4B0: code_point = 0xCE85; break; // HANGUL SYLLABLE KHIEUKH A PIEUP
    case 0xC4B1: code_point = 0xCE87; break; // HANGUL SYLLABLE KHIEUKH A SIOS
    case 0xC4B2: code_point = 0xCE89; break; // HANGUL SYLLABLE KHIEUKH A IEUNG
    case 0xC4B3: code_point = 0xCE90; break; // HANGUL SYLLABLE KHIEUKH AE
    case 0xC4B4: code_point = 0xCE91; break; // HANGUL SYLLABLE KHIEUKH AE KIYEOK
    case 0xC4B5: code_point = 0xCE94; break; // HANGUL SYLLABLE KHIEUKH AE NIEUN
    case 0xC4B6: code_point = 0xCE98; break; // HANGUL SYLLABLE KHIEUKH AE RIEUL
    case 0xC4B7: code_point = 0xCEA0; break; // HANGUL SYLLABLE KHIEUKH AE MIEUM
    case 0xC4B8: code_point = 0xCEA1; break; // HANGUL SYLLABLE KHIEUKH AE PIEUP
    case 0xC4B9: code_point = 0xCEA3; break; // HANGUL SYLLABLE KHIEUKH AE SIOS
    case 0xC4BA: code_point = 0xCEA4; break; // HANGUL SYLLABLE KHIEUKH AE SSANGSIOS
    case 0xC4BB: code_point = 0xCEA5; break; // HANGUL SYLLABLE KHIEUKH AE IEUNG
    case 0xC4BC: code_point = 0xCEAC; break; // HANGUL SYLLABLE KHIEUKH YA
    case 0xC4BD: code_point = 0xCEAD; break; // HANGUL SYLLABLE KHIEUKH YA KIYEOK
    case 0xC4BE: code_point = 0xCEC1; break; // HANGUL SYLLABLE KHIEUKH YA IEUNG
    case 0xC4BF: code_point = 0xCEE4; break; // HANGUL SYLLABLE KHIEUKH EO
    case 0xC4C0: code_point = 0xCEE5; break; // HANGUL SYLLABLE KHIEUKH EO KIYEOK
    case 0xC4C1: code_point = 0xCEE8; break; // HANGUL SYLLABLE KHIEUKH EO NIEUN
    case 0xC4C2: code_point = 0xCEEB; break; // HANGUL SYLLABLE KHIEUKH EO TIKEUT
    case 0xC4C3: code_point = 0xCEEC; break; // HANGUL SYLLABLE KHIEUKH EO RIEUL
    case 0xC4C4: code_point = 0xCEF4; break; // HANGUL SYLLABLE KHIEUKH EO MIEUM
    case 0xC4C5: code_point = 0xCEF5; break; // HANGUL SYLLABLE KHIEUKH EO PIEUP
    case 0xC4C6: code_point = 0xCEF7; break; // HANGUL SYLLABLE KHIEUKH EO SIOS
    case 0xC4C7: code_point = 0xCEF8; break; // HANGUL SYLLABLE KHIEUKH EO SSANGSIOS
    case 0xC4C8: code_point = 0xCEF9; break; // HANGUL SYLLABLE KHIEUKH EO IEUNG
    case 0xC4C9: code_point = 0xCF00; break; // HANGUL SYLLABLE KHIEUKH E
    case 0xC4CA: code_point = 0xCF01; break; // HANGUL SYLLABLE KHIEUKH E KIYEOK
    case 0xC4CB: code_point = 0xCF04; break; // HANGUL SYLLABLE KHIEUKH E NIEUN
    case 0xC4CC: code_point = 0xCF08; break; // HANGUL SYLLABLE KHIEUKH E RIEUL
    case 0xC4CD: code_point = 0xCF10; break; // HANGUL SYLLABLE KHIEUKH E MIEUM
    case 0xC4CE: code_point = 0xCF11; break; // HANGUL SYLLABLE KHIEUKH E PIEUP
    case 0xC4CF: code_point = 0xCF13; break; // HANGUL SYLLABLE KHIEUKH E SIOS
    case 0xC4D0: code_point = 0xCF15; break; // HANGUL SYLLABLE KHIEUKH E IEUNG
    case 0xC4D1: code_point = 0xCF1C; break; // HANGUL SYLLABLE KHIEUKH YEO
    case 0xC4D2: code_point = 0xCF20; break; // HANGUL SYLLABLE KHIEUKH YEO NIEUN
    case 0xC4D3: code_point = 0xCF24; break; // HANGUL SYLLABLE KHIEUKH YEO RIEUL
    case 0xC4D4: code_point = 0xCF2C; break; // HANGUL SYLLABLE KHIEUKH YEO MIEUM
    case 0xC4D5: code_point = 0xCF2D; break; // HANGUL SYLLABLE KHIEUKH YEO PIEUP
    case 0xC4D6: code_point = 0xCF2F; break; // HANGUL SYLLABLE KHIEUKH YEO SIOS
    case 0xC4D7: code_point = 0xCF30; break; // HANGUL SYLLABLE KHIEUKH YEO SSANGSIOS
    case 0xC4D8: code_point = 0xCF31; break; // HANGUL SYLLABLE KHIEUKH YEO IEUNG
    case 0xC4D9: code_point = 0xCF38; break; // HANGUL SYLLABLE KHIEUKH YE
    case 0xC4DA: code_point = 0xCF54; break; // HANGUL SYLLABLE KHIEUKH O
    case 0xC4DB: code_point = 0xCF55; break; // HANGUL SYLLABLE KHIEUKH O KIYEOK
    case 0xC4DC: code_point = 0xCF58; break; // HANGUL SYLLABLE KHIEUKH O NIEUN
    case 0xC4DD: code_point = 0xCF5C; break; // HANGUL SYLLABLE KHIEUKH O RIEUL
    case 0xC4DE: code_point = 0xCF64; break; // HANGUL SYLLABLE KHIEUKH O MIEUM
    case 0xC4DF: code_point = 0xCF65; break; // HANGUL SYLLABLE KHIEUKH O PIEUP
    case 0xC4E0: code_point = 0xCF67; break; // HANGUL SYLLABLE KHIEUKH O SIOS
    case 0xC4E1: code_point = 0xCF69; break; // HANGUL SYLLABLE KHIEUKH O IEUNG
    case 0xC4E2: code_point = 0xCF70; break; // HANGUL SYLLABLE KHIEUKH WA
    case 0xC4E3: code_point = 0xCF71; break; // HANGUL SYLLABLE KHIEUKH WA KIYEOK
    case 0xC4E4: code_point = 0xCF74; break; // HANGUL SYLLABLE KHIEUKH WA NIEUN
    case 0xC4E5: code_point = 0xCF78; break; // HANGUL SYLLABLE KHIEUKH WA RIEUL
    case 0xC4E6: code_point = 0xCF80; break; // HANGUL SYLLABLE KHIEUKH WA MIEUM
    case 0xC4E7: code_point = 0xCF85; break; // HANGUL SYLLABLE KHIEUKH WA IEUNG
    case 0xC4E8: code_point = 0xCF8C; break; // HANGUL SYLLABLE KHIEUKH WAE
    case 0xC4E9: code_point = 0xCFA1; break; // HANGUL SYLLABLE KHIEUKH WAE IEUNG
    case 0xC4EA: code_point = 0xCFA8; break; // HANGUL SYLLABLE KHIEUKH OE
    case 0xC4EB: code_point = 0xCFB0; break; // HANGUL SYLLABLE KHIEUKH OE RIEUL
    case 0xC4EC: code_point = 0xCFC4; break; // HANGUL SYLLABLE KHIEUKH YO
    case 0xC4ED: code_point = 0xCFE0; break; // HANGUL SYLLABLE KHIEUKH U
    case 0xC4EE: code_point = 0xCFE1; break; // HANGUL SYLLABLE KHIEUKH U KIYEOK
    case 0xC4EF: code_point = 0xCFE4; break; // HANGUL SYLLABLE KHIEUKH U NIEUN
    case 0xC4F0: code_point = 0xCFE8; break; // HANGUL SYLLABLE KHIEUKH U RIEUL
    case 0xC4F1: code_point = 0xCFF0; break; // HANGUL SYLLABLE KHIEUKH U MIEUM
    case 0xC4F2: code_point = 0xCFF1; break; // HANGUL SYLLABLE KHIEUKH U PIEUP
    case 0xC4F3: code_point = 0xCFF3; break; // HANGUL SYLLABLE KHIEUKH U SIOS
    case 0xC4F4: code_point = 0xCFF5; break; // HANGUL SYLLABLE KHIEUKH U IEUNG
    case 0xC4F5: code_point = 0xCFFC; break; // HANGUL SYLLABLE KHIEUKH WEO
    case 0xC4F6: code_point = 0xD000; break; // HANGUL SYLLABLE KHIEUKH WEO NIEUN
    case 0xC4F7: code_point = 0xD004; break; // HANGUL SYLLABLE KHIEUKH WEO RIEUL
    case 0xC4F8: code_point = 0xD011; break; // HANGUL SYLLABLE KHIEUKH WEO IEUNG
    case 0xC4F9: code_point = 0xD018; break; // HANGUL SYLLABLE KHIEUKH WE
    case 0xC4FA: code_point = 0xD02D; break; // HANGUL SYLLABLE KHIEUKH WE IEUNG
    case 0xC4FB: code_point = 0xD034; break; // HANGUL SYLLABLE KHIEUKH WI
    case 0xC4FC: code_point = 0xD035; break; // HANGUL SYLLABLE KHIEUKH WI KIYEOK
    case 0xC4FD: code_point = 0xD038; break; // HANGUL SYLLABLE KHIEUKH WI NIEUN
    case 0xC4FE: code_point = 0xD03C; break; // HANGUL SYLLABLE KHIEUKH WI RIEUL
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage949ToUnicode_0xC5(
  ON__UINT32 code_page_949_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_949_character_value)
  {
    case 0xC541: code_point = 0xD715; break; // HANGUL SYLLABLE HIEUH WE THIEUTH
    case 0xC542: code_point = 0xD716; break; // HANGUL SYLLABLE HIEUH WE PHIEUPH
    case 0xC543: code_point = 0xD717; break; // HANGUL SYLLABLE HIEUH WE HIEUH
    case 0xC544: code_point = 0xD71A; break; // HANGUL SYLLABLE HIEUH WI SSANGKIYEOK
    case 0xC545: code_point = 0xD71B; break; // HANGUL SYLLABLE HIEUH WI KIYEOKSIOS
    case 0xC546: code_point = 0xD71D; break; // HANGUL SYLLABLE HIEUH WI NIEUNCIEUC
    case 0xC547: code_point = 0xD71E; break; // HANGUL SYLLABLE HIEUH WI NIEUNHIEUH
    case 0xC548: code_point = 0xD71F; break; // HANGUL SYLLABLE HIEUH WI TIKEUT
    case 0xC549: code_point = 0xD721; break; // HANGUL SYLLABLE HIEUH WI RIEULKIYEOK
    case 0xC54A: code_point = 0xD722; break; // HANGUL SYLLABLE HIEUH WI RIEULMIEUM
    case 0xC54B: code_point = 0xD723; break; // HANGUL SYLLABLE HIEUH WI RIEULPIEUP
    case 0xC54C: code_point = 0xD724; break; // HANGUL SYLLABLE HIEUH WI RIEULSIOS
    case 0xC54D: code_point = 0xD725; break; // HANGUL SYLLABLE HIEUH WI RIEULTHIEUTH
    case 0xC54E: code_point = 0xD726; break; // HANGUL SYLLABLE HIEUH WI RIEULPHIEUPH
    case 0xC54F: code_point = 0xD727; break; // HANGUL SYLLABLE HIEUH WI RIEULHIEUH
    case 0xC550: code_point = 0xD72A; break; // HANGUL SYLLABLE HIEUH WI PIEUPSIOS
    case 0xC551: code_point = 0xD72C; break; // HANGUL SYLLABLE HIEUH WI SSANGSIOS
    case 0xC552: code_point = 0xD72E; break; // HANGUL SYLLABLE HIEUH WI CIEUC
    case 0xC553: code_point = 0xD72F; break; // HANGUL SYLLABLE HIEUH WI CHIEUCH
    case 0xC554: code_point = 0xD730; break; // HANGUL SYLLABLE HIEUH WI KHIEUKH
    case 0xC555: code_point = 0xD731; break; // HANGUL SYLLABLE HIEUH WI THIEUTH
    case 0xC556: code_point = 0xD732; break; // HANGUL SYLLABLE HIEUH WI PHIEUPH
    case 0xC557: code_point = 0xD733; break; // HANGUL SYLLABLE HIEUH WI HIEUH
    case 0xC558: code_point = 0xD736; break; // HANGUL SYLLABLE HIEUH YU SSANGKIYEOK
    case 0xC559: code_point = 0xD737; break; // HANGUL SYLLABLE HIEUH YU KIYEOKSIOS
    case 0xC55A: code_point = 0xD739; break; // HANGUL SYLLABLE HIEUH YU NIEUNCIEUC
    case 0xC561: code_point = 0xD73A; break; // HANGUL SYLLABLE HIEUH YU NIEUNHIEUH
    case 0xC562: code_point = 0xD73B; break; // HANGUL SYLLABLE HIEUH YU TIKEUT
    case 0xC563: code_point = 0xD73D; break; // HANGUL SYLLABLE HIEUH YU RIEULKIYEOK
    case 0xC564: code_point = 0xD73E; break; // HANGUL SYLLABLE HIEUH YU RIEULMIEUM
    case 0xC565: code_point = 0xD73F; break; // HANGUL SYLLABLE HIEUH YU RIEULPIEUP
    case 0xC566: code_point = 0xD740; break; // HANGUL SYLLABLE HIEUH YU RIEULSIOS
    case 0xC567: code_point = 0xD741; break; // HANGUL SYLLABLE HIEUH YU RIEULTHIEUTH
    case 0xC568: code_point = 0xD742; break; // HANGUL SYLLABLE HIEUH YU RIEULPHIEUPH
    case 0xC569: code_point = 0xD743; break; // HANGUL SYLLABLE HIEUH YU RIEULHIEUH
    case 0xC56A: code_point = 0xD745; break; // HANGUL SYLLABLE HIEUH YU PIEUP
    case 0xC56B: code_point = 0xD746; break; // HANGUL SYLLABLE HIEUH YU PIEUPSIOS
    case 0xC56C: code_point = 0xD748; break; // HANGUL SYLLABLE HIEUH YU SSANGSIOS
    case 0xC56D: code_point = 0xD74A; break; // HANGUL SYLLABLE HIEUH YU CIEUC
    case 0xC56E: code_point = 0xD74B; break; // HANGUL SYLLABLE HIEUH YU CHIEUCH
    case 0xC56F: code_point = 0xD74C; break; // HANGUL SYLLABLE HIEUH YU KHIEUKH
    case 0xC570: code_point = 0xD74D; break; // HANGUL SYLLABLE HIEUH YU THIEUTH
    case 0xC571: code_point = 0xD74E; break; // HANGUL SYLLABLE HIEUH YU PHIEUPH
    case 0xC572: code_point = 0xD74F; break; // HANGUL SYLLABLE HIEUH YU HIEUH
    case 0xC573: code_point = 0xD752; break; // HANGUL SYLLABLE HIEUH EU SSANGKIYEOK
    case 0xC574: code_point = 0xD753; break; // HANGUL SYLLABLE HIEUH EU KIYEOKSIOS
    case 0xC575: code_point = 0xD755; break; // HANGUL SYLLABLE HIEUH EU NIEUNCIEUC
    case 0xC576: code_point = 0xD75A; break; // HANGUL SYLLABLE HIEUH EU RIEULMIEUM
    case 0xC577: code_point = 0xD75B; break; // HANGUL SYLLABLE HIEUH EU RIEULPIEUP
    case 0xC578: code_point = 0xD75C; break; // HANGUL SYLLABLE HIEUH EU RIEULSIOS
    case 0xC579: code_point = 0xD75D; break; // HANGUL SYLLABLE HIEUH EU RIEULTHIEUTH
    case 0xC57A: code_point = 0xD75E; break; // HANGUL SYLLABLE HIEUH EU RIEULPHIEUPH
    case 0xC581: code_point = 0xD75F; break; // HANGUL SYLLABLE HIEUH EU RIEULHIEUH
    case 0xC582: code_point = 0xD762; break; // HANGUL SYLLABLE HIEUH EU PIEUPSIOS
    case 0xC583: code_point = 0xD764; break; // HANGUL SYLLABLE HIEUH EU SSANGSIOS
    case 0xC584: code_point = 0xD766; break; // HANGUL SYLLABLE HIEUH EU CIEUC
    case 0xC585: code_point = 0xD767; break; // HANGUL SYLLABLE HIEUH EU CHIEUCH
    case 0xC586: code_point = 0xD768; break; // HANGUL SYLLABLE HIEUH EU KHIEUKH
    case 0xC587: code_point = 0xD76A; break; // HANGUL SYLLABLE HIEUH EU PHIEUPH
    case 0xC588: code_point = 0xD76B; break; // HANGUL SYLLABLE HIEUH EU HIEUH
    case 0xC589: code_point = 0xD76D; break; // HANGUL SYLLABLE HIEUH YI KIYEOK
    case 0xC58A: code_point = 0xD76E; break; // HANGUL SYLLABLE HIEUH YI SSANGKIYEOK
    case 0xC58B: code_point = 0xD76F; break; // HANGUL SYLLABLE HIEUH YI KIYEOKSIOS
  