"""
List of TTY ASCII configuration commands for Septentrio Mosaic X5
"""

SBF_TTY_COMMANDS = {
    "eccf": ("exeCopyConfigFile", "Execute Copy Config File"),
    "eecm": ("exeEchoMessage", "Execute Echo Message"),
    "efpt": ("exeFTPPushTest", "Execute FTP Push Test"),
    "efup": ("exeFTPUpgrade", "Execute FTP Upgrade"),
    "emd": ("exeManageDisk", "Execute Manage Disk"),
    "enoc": ("exeNMEAOnce", "Execute NMEA Once"),
    "epwm": ("exePowerMode", "Execute Power Mode"),
    "era": ("exeRegisteredApplications", "Execute Registered Applications"),
    "erf": ("exeRemoveFile", "Execute Remove File"),
    "ernf": ("exeResetNavFilter", "Execute Reset Nav Filter"),
    "erst": ("exeResetReceiver", "Execute Reset Receiver"),
    "esoc": ("exeSBFOnce", "Execute SBF Once"),
    "gal": ("getAntennaLocation", "Get Antenna Location"),
    "gam": ("getAGCMode", "Get Automatic Gain Control Mode"),
    "gao": ("getAntennaOffset", "Get Antenna Offset"),
    "gbbs": ("getBBSamplingMode", "Get Baseband Sampling Mode"),
    "gc2f": ("getCMRv2Formatting", "Get CMRv2 Formatting"),
    "gc2i": ("getCMRv2Interval", "Get CMRv2 Interval"),
    "gc2m": ("getCMRv2Message2", "Get CMRv2 Message2"),
    "gc2o": ("getCMRv2Output", "Get CMRv2 Output"),
    "gc2u": ("getCMRv2Usage", "Get CMRv2 Usage"),
    "gca": ("getChannelAllocation", "Get Channel Allocation"),
    "gccf": ("getCopyConfigFile", "Get Copy Config File"),
    "gcco": ("getCalibCommonDelay", "Get Calibration Common Delay"),
    "gcda": ("getCrossDomainWebAccess", "Get Cross Domain Web Access"),
    "gcia": ("getCheckInternetAvailability", "Get Check Internet Availability"),
    "gcm": ("getCN0Mask", "Get CN0 (Signal to Noise Ratio) Mask"),
    "gcs": ("getCOMSettings", "Get COM Settings"),
    "gcsi": ("getCalibSignalDelay", "Get Calibration Signal Delay"),
    "gcst": ("getClockSyncThreshold", "Get Clock Sync Threshold"),
    "gdal": ("getDefaultAccessLevel", "Get Default Access Level"),
    "gdca": ("getDiffCorrMaxAge", "Get Differential Correction Max Age"),
    "gdcm": ("getDaisyChainMode", "Get Daisy Chain Mode"),
    "gdcu": ("getDiffCorrUsage", "Get Differential Correction Usage"),
    "gdds": ("getDynamicDNS", "Get Dynamic DNS"),
    "gdfa": ("getDiskFullAction", "Get Disk Full Action"),
    "gdio": ("getDataInOut", "Get Data In Out"),
    "gecm": ("getEchoMessage", "Get Echo Message"),
    "gem": ("getElevationMask", "Get Elevation Mask"),
    "gep": ("getEventParameters", "Get Event Parameters"),
    "geth": ("getEthernetMode", "Get Ethernet Mode"),
    "gfn": ("getFileNaming", "Get File Naming"),
    "gfno": ("getGlobalFileNamingOptions", "Get Global File Naming Options"),
    "gfpr": ("getFTPPushRINEX", "Get FTP Push RINEX"),
    "gfps": ("getFTPPushSBF", "Get FTP Push SBF"),
    "gfpt": ("getFTPPushTest", "Get FTP Push Test"),
    "gfup": ("getFTPUpgrade", "Get FTP Upgrade"),
    "gga": ("getGNSSAttitude", "Get GNSS Attitude"),
    "ggd": ("getGeodeticDatum", "Get Geodetic Datum"),
    "ggpf": ("getGPIOFunctionality", "Get GPIO Functionality"),
    "ggu": ("getGeoidUndulation", "Get Geoid Undulation"),
    "ghm": ("getHealthMask", "Get Health Mask"),
    "ghs": ("getHttpsSettings", "Get Https Settings"),
    "gim": ("getIonosphereModel", "Get Ionosphere Model"),
    "gipf": ("getIPFiltering", "Get IP Filtering"),
    "gipk": ("getIPKeepAlive", "Get IP Keep Alive"),
    "gipp": ("getIPPortSettings", "Get IP Port Settings"),
    "gips": ("getIPSettings", "Get IP Settings"),
    "girs": ("getIPReceiveSettings", "Get IP Receive Settings"),
    "giss": ("getIPServerSettings", "Get IP Server Settings"),
    "glbb": ("getLBandBeams", "Get L Band Beams"),
    "glco": ("getLocalCoordOperation", "Get Local Coord Operation"),
    "glcs": ("getLBandCustomServiceID", "Get L Band Custom Service ID"),
    "glm": ("getLEDMode", "Get LED Mode"),
    "glnd": ("getLBandNTRIPDelivery", "Get L Band NTRIP Delivery"),
    "glsm": ("getLBandSelectMode", "Get L Band Select Mode"),
    "gmd": ("getManageDisk", "Get Manage Disk"),
    "gmm": ("getMultipathMitigation", "Get Multipath Mitigation"),
    "gmp": ("getMarkerParameters", "Get Marker Parameters"),
    "gmpf": ("getNtripCasterMPFormat", "Get NTRIP Caster MP Format"),
    "gmrf": ("getMeas3MaxRefInterval", "Get Meas3 Max Ref Interval"),
    "gmth": (
        "getENHTransfoHorizontal",
        "Get Easting, Northing, Height Transform Horizontal",
    ),
    "gmtv": (
        "getENHTransfoVertical",
        "Get Easting, Northing, Height Transform Vertical",
    ),
    "gmv": ("getMagneticVariance", "Get Magnetic Variance"),
    "gnc": ("getNtpClient", "Get Ntp Client"),
    "gncs": ("getNtripCasterSettings", "Get NTRIP Caster Settings"),
    "gncu": ("getNtripCasterUsers", "Get NTRIP Caster Users"),
    "gnf": ("getNotchFiltering", "Get Notch Filtering"),
    "gnmp": ("getNtripCasterMountPoints", "Get NTRIP Caster Mount Points"),
    "gno": ("getNMEAOutput", "Get NMEA Output"),
    "gnoc": ("getNMEAOnce", "Get NMEA Once"),
    "gnp": ("getNMEAPrecision", "Get NMEA Precision"),
    "gnrc": ("getNetworkRTKConfig", "Get Network RTK Config"),
    "gnt": ("getSignalTracking", "Get Signal Tracking"),
    "gnti": ("getNMEATalkerID", "Get NMEA Talker ID"),
    "gntp": ("getNTPServer", "Get NTP Server"),
    "gnts": ("getNtripSettings", "Get NTRIP Settings"),
    "gntt": ("getNtripTlsSettings", "Get NTRIP TLS Settings"),
    "gnu": ("getSignalUsage", "Get Signal Usage"),
    "gnv": ("getNMEAVersion", "Get NMEA Version"),
    "goc": ("getObserverComment", "Get Observer Comment"),
    "gop": ("getObserverParameters", "Get Observer Parameters"),
    "gopk": (
        "getGalOSNMAPublicKeys",
        "Get Galileo Open Service Navigation Message Authentication Public Keys",
    ),
    "gou": (
        "getGalOSNMAUsage",
        "Get Galileo Open Service Navigation Message Authentication Usage",
    ),
    "gp2p": ("getPointToPoint", "Get Point To Point"),
    "gpe": ("getPeriodicEcho", "Get Periodic Echo"),
    "gpfw": ("getPortFirewall", "Get Port Firewall"),
    "gpm": ("getPVTMode", "Get PVT Mode"),
    "gpps": ("getPPSParameters", "Get PPS Parameters"),
    "gptp": ("getPTPServer", "Get PTP Server"),
    "gpwm": ("getPowerMode", "Get Power Mode"),
    "gr2b": ("getRTCMv2IntervalObs", "Get RTCMv2 Interval Observation"),
    "gr2c": ("getRTCMv2Compatibility", "Get RTCMv2 Compatibility"),
    "gr2f": ("getRTCMv2Formatting", "Get RTCMv2 Formatting"),
    "gr2h": ("getRTCMv2EphemerisHoldoff", "Get RTCMv2 Ephemeris Holdoff"),
    "gr2i": ("getRTCMv2Interval", "Get RTCMv2 Interval"),
    "gr2m": ("getRTCMv2Message16", "Get RTCMv2 Message 16"),
    "gr2o": ("getRTCMv2Output", "Get RTCMv2 Output"),
    "gr2u": ("getRTCMv2Usage", "Get RTCMv2 Usage"),
    "gr3d": ("getRTCMv3Delay", "Get RTCMv3 Delay"),
    "gr3f": ("getRTCMv3Formatting", "Get RTCMv3 Formatting"),
    "gr3i": ("getRTCMv3Interval", "Get RTCMv3 Interval"),
    "gr3m": ("getRTCMv3Message1029", "Get RTCMv3 Message 1029"),
    "gr3o": ("getRTCMv3Output", "Get RTCMv3 Output"),
    "gr3t": ("getRTCMv3CRSTransfo", "Get RTCMv3 CRS Transform"),
    "gr3u": ("getRTCMv3Usage", "Get RTCMv3 Usage"),
    "gra": ("getRegisteredApplications", "Get Registered Applications"),
    "grc": ("getReceiverCapabilities", "Get Receiver Capabilities"),
    "grd": ("getReceiverDynamics", "Get Receiver Dynamics"),
    "grf": ("getRemoveFile", "Get Remove File"),
    "gri": ("getReceiverInterface", "Get Receiver Interface"),
    "grl": ("getRAIMLevels", "Get Receiver Autonomous Integrity Monitoring Levels"),
    "grnf": ("getResetNavFilter", "Get Reset Nav Filter"),
    "grst": ("getResetReceiver", "Get Reset Receiver"),
    "grxl": ("getRINEXLogging", "Get RINEX Logging"),
    "gsbc": ("getSBASCorrections", "Get SBAS Corrections"),
    "gsgp": ("getSBFGroups", "Get SBF Groups"),
    "gsi": ("getSmoothingInterval", "Get Smoothing Interval"),
    "gso": ("getSBFOutput", "Get SBF Output"),
    "gsoc": ("getSBFOnce", "Get SBF Once"),
    "gspc": ("getStaticPosCartesian", "Get Static Position Cartesian"),
    "gspg": ("getStaticPosGeodetic", "Get Static Position Geodetic"),
    "gst": ("getSatelliteTracking", "Get Satellite Tracking"),
    "gsu": ("getSatelliteUsage", "Get Satellite Usage"),
    "gtlp": ("getTrackingLoopParameters", "Get Tracking Loop Parameters"),
    "gtm": ("getTroposphereModel", "Get Troposphere Model"),
    "gto": ("getAttitudeOffset", "Get Attitude Offset"),
    "gtp": ("getTroposphereParameters", "Get Troposphere Parameters"),
    "gts": ("getTimingSystem", "Get Timing System"),
    "gtss": ("getTimeSyncSource", "Get Time Sync Source"),
    "gual": ("getUserAccessLevel", "Get User Access Level"),
    "gud": ("getUserDatum", "Get User Datum"),
    "gudv": ("getUserDatumVel", "Get User Datum Vel"),
    "gue": ("getUserEllipsoid", "Get User Ellipsoid"),
    "guia": ("getUSBInternetAccess", "Get USB Internet Access"),
    "guoc": ("getUMSDOnConnect", "Get USB Mass-storage Device On Connect"),
    "gwbi": ("getWBIMitigation", "Get Wideband Interference Mitigation"),
    "help": ("lstCommandHelp", "List Command Help"),
    "lai": ("lstAntennaInfo", "List Antenna Info"),
    "lcf": ("lstConfigFile", "List Config File"),
    "lcu": ("lstCurrentUser", "List Current User"),
    "ldi": ("lstDiskInfo", "List Disk Info"),
    "lif": ("lstInternalFile", "List Internal File"),
    "llbb": ("lstLBandBeams", "List L Band Beams"),
    "llc": ("lstLocalCoordOperations", "List Local Coord Operations"),
    "lmd": ("lstMIBDescription", "List MIB Description"),
    "lnst": ("lstNTRIPSourceTable", "List NTRIP Source Table"),
    "login": ("login", "login"),
    "logout": ("logout", "logout"),
    "lopk": (
        "lstGalOSNMAPublicKeys",
        "List Galileo Open Service Navigation Message Authentication Public Keys",
    ),
    "lrf": ("lstRecordedFile", "List Recorded File"),
    "sal": ("setAntennaLocation", "Set Antenna Location"),
    "sam": ("setAGCMode", "Set Automatic Gain Control Mode"),
    "sao": ("setAntennaOffset", "Set Antenna Offset"),
    "sbbs": ("setBBSamplingMode", "Set Baseband Sampling Mode"),
    "sc2f": ("setCMRv2Formatting", "Set CMRv2 Formatting"),
    "sc2i": ("setCMRv2Interval", "Set CMRv2 Interval"),
    "sc2m": ("setCMRv2Message2", "Set CMRv2 Message2"),
    "sc2o": ("setCMRv2Output", "Set CMRv2 Output"),
    "sc2u": ("setCMRv2Usage", "Set CMRv2 Usage"),
    "sca": ("setChannelAllocation", "Set Channel Allocation"),
    "scco": ("setCalibCommonDelay", "Set Calibration Common Delay"),
    "scda": ("setCrossDomainWebAccess", "Set Cross Domain Web Access"),
    "scia": ("setCheckInternetAvailability", "Set Check Internet Availability"),
    "scm": ("setCN0Mask", "Set CN0 (Signal to Noise Ratio) Mask"),
    "scs": ("setCOMSettings", "Set COM Settings"),
    "scsi": ("setCalibSignalDelay", "Set Calibration Signal Delay"),
    "scst": ("setClockSyncThreshold", "Set Clock Sync Threshold"),
    "sdal": ("setDefaultAccessLevel", "Set Default Access Level"),
    "sdca": ("setDiffCorrMaxAge", "Set Differential Correction Max Age"),
    "sdcm": ("setDaisyChainMode", "Set Daisy Chain Mode"),
    "sdcu": ("setDiffCorrUsage", "Set Differential Correction Usage"),
    "sdds": ("setDynamicDNS", "Set Dynamic DNS"),
    "sdfa": ("setDiskFullAction", "Set Disk Full Action"),
    "sdio": ("setDataInOut", "Set Data In Out"),
    "sem": ("setElevationMask", "Set Elevation Mask"),
    "sep": ("setEventParameters", "Set Event Parameters"),
    "seth": ("setEthernetMode", "Set Ethernet Mode"),
    "sfn": ("setFileNaming", "Set File Naming"),
    "sfno": ("setGlobalFileNamingOptions", "Set Global File Naming Options"),
    "sfpr": ("setFTPPushRINEX", "Set FTP Push RINEX"),
    "sfps": ("setFTPPushSBF", "Set FTP Push SBF"),
    "sga": ("setGNSSAttitude", "Set GNSS Attitude"),
    "sgd": ("setGeodeticDatum", "Set Geodetic Datum"),
    "sgpf": ("setGPIOFunctionality", "Set GPIO Functionality"),
    "sgu": ("setGeoidUndulation", "Set Geoid Undulation"),
    "shm": ("setHealthMask", "Set Health Mask"),
    "shs": ("setHttpsSettings", "Set Https Settings"),
    "sim": ("setIonosphereModel", "Set Ionosphere Model"),
    "sipf": ("setIPFiltering", "Set IP Filtering"),
    "sipk": ("setIPKeepAlive", "Set IP Keep Alive"),
    "sipp": ("setIPPortSettings", "Set IP Port Settings"),
    "sips": ("setIPSettings", "Set IP Settings"),
    "sirs": ("setIPReceiveSettings", "Set IP Receive Settings"),
    "siss": ("setIPServerSettings", "Set IP Server Settings"),
    "slbb": ("setLBandBeams", "Set L Band Beams"),
    "slco": ("setLocalCoordOperation", "Set Local Coord Operation"),
    "slcs": ("setLBandCustomServiceID", "Set L Band Custom Service ID"),
    "slm": ("setLEDMode", "Set LED Mode"),
    "slnd": ("setLBandNTRIPDelivery", "Set L Band NTRIP Delivery"),
    "slsm": ("setLBandSelectMode", "Set L Band Select Mode"),
    "smm": ("setMultipathMitigation", "Set Multipath Mitigation"),
    "smp": ("setMarkerParameters", "Set Marker Parameters"),
    "smpf": ("setNtripCasterMPFormat", "Set NTRIP Caster MP Format"),
    "smrf": ("setMeas3MaxRefInterval", "Set Meas3 Max Ref Interval"),
    "smth": (
        "setENHTransfoHorizontal",
        "Set Easting, Northing, Height Transform Horizontal",
    ),
    "smtv": (
        "setENHTransfoVertical",
        "Set Easting, Northing, Height Transform Vertical",
    ),
    "smv": ("setMagneticVariance", "Set Magnetic Variance"),
    "snc": ("setNtpClient", "Set Ntp Client"),
    "sncs": ("setNtripCasterSettings", "Set NTRIP Caster Settings"),
    "sncu": ("setNtripCasterUsers", "Set NTRIP Caster Users"),
    "snf": ("setNotchFiltering", "Set Notch Filtering"),
    "snmp": ("setNtripCasterMountPoints", "Set NTRIP Caster Mount Points"),
    "sno": ("setNMEAOutput", "Set NMEA Output"),
    "snp": ("setNMEAPrecision", "Set NMEA Precision"),
    "snrc": ("setNetworkRTKConfig", "Set Network RTK Config"),
    "snt": ("setSignalTracking", "Set Signal Tracking"),
    "snti": ("setNMEATalkerID", "Set NMEA Talker ID"),
    "sntp": ("setNTPServer", "Set NTP Server"),
    "snts": ("setNtripSettings", "Set NTRIP Settings"),
    "sntt": ("setNtripTlsSettings", "Set NTRIP Tls Settings"),
    "snu": ("setSignalUsage", "Set Signal Usage"),
    "snv": ("setNMEAVersion", "Set NMEA Version"),
    "soc": ("setObserverComment", "Set Observer Comment"),
    "sop": ("setObserverParameters", "Set Observer Parameters"),
    "sopk": (
        "setGalOSNMAPublicKeys",
        "Set Galileo Open Service Navigation Message Authentication Public Keys",
    ),
    "sou": (
        "setGalOSNMAUsage",
        "Set Galileo Open Service Navigation Message Authentication Usage",
    ),
    "sp2p": ("setPointToPoint", "Set Point To Point"),
    "spe": ("setPeriodicEcho", "Set Periodic Echo"),
    "spfw": ("setPortFirewall", "Set Port Firewall"),
    "spm": ("setPVTMode", "Set PVT Mode"),
    "spps": ("setPPSParameters", "Set PPS Parameters"),
    "sptp": ("setPTPServer", "Set PTP Server"),
    "sr2b": ("setRTCMv2IntervalObs", "Set RTCMv2 Interval Observation"),
    "sr2c": ("setRTCMv2Compatibility", "Set RTCMv2 Compatibility"),
    "sr2f": ("setRTCMv2Formatting", "Set RTCMv2 Formatting"),
    "sr2h": ("setRTCMv2EphemerisHoldoff", "Set RTCMv2 Ephemeris Holdoff"),
    "sr2i": ("setRTCMv2Interval", "Set RTCMv2 Interval"),
    "sr2m": ("setRTCMv2Message16", "Set RTCMv2 Message 16"),
    "sr2o": ("setRTCMv2Output", "Set RTCMv2 Output"),
    "sr2u": ("setRTCMv2Usage", "Set RTCMv2 Usage"),
    "sr3d": ("setRTCMv3Delay", "Set RTCMv3 Delay"),
    "sr3f": ("setRTCMv3Formatting", "Set RTCMv3 Formatting"),
    "sr3i": ("setRTCMv3Interval", "Set RTCMv3 Interval"),
    "sr3m": ("setRTCMv3Message1029", "Set RTCMv3 Message 1029"),
    "sr3o": ("setRTCMv3Output", "Set RTCMv3 Output"),
    "sr3t": ("setRTCMv3CRSTransfo", "Set RTCMv3 CRS Transform"),
    "sr3u": ("setRTCMv3Usage", "Set RTCMv3 Usage"),
    "srd": ("setReceiverDynamics", "Set Receiver Dynamics"),
    "srl": ("setRAIMLevels", "Set Receiver Autonomous Integrity Monitoring Levels"),
    "srxl": ("setRINEXLogging", "Set RINEX Logging"),
    "ssbc": ("setSBASCorrections", "Set SBAS Corrections"),
    "ssgp": ("setSBFGroups", "Set SBF Groups"),
    "ssi": ("setSmoothingInterval", "Set Smoothing Interval"),
    "sso": ("setSBFOutput", "Set SBF Output"),
    "sspc": ("setStaticPosCartesian", "Set Static Position Cartesian"),
    "sspg": ("setStaticPosGeodetic", "Set Static Position Geodetic"),
    "sst": ("setSatelliteTracking", "Set Satellite Tracking"),
    "ssu": ("setSatelliteUsage", "Set Satellite Usage"),
    "stlp": ("setTrackingLoopParameters", "Set Tracking Loop Parameters"),
    "stm": ("setTroposphereModel", "Set Troposphere Model"),
    "sto": ("setAttitudeOffset", "Set Attitude Offset"),
    "stp": ("setTroposphereParameters", "Set Troposphere Parameters"),
    "sts": ("setTimingSystem", "Set Timing System"),
    "stss": ("setTimeSyncSource", "Set Time Sync Source"),
    "sual": ("setUserAccessLevel", "Set User Access Level"),
    "sud": ("setUserDatum", "Set User Datum"),
    "sudv": ("setUserDatumVel", "Set User Datum Vel"),
    "sue": ("setUserEllipsoid", "Set User Ellipsoid"),
    "suia": ("setUSBInternetAccess", "Set USB Internet Access"),
    "suoc": ("setUMSDOnConnect", "Set USB Mass-storage Device On Connect"),
    "swbi": ("setWBIMitigation", "Set Wideband Interference Mitigation"),
}
"""
Septentrio Mosaic X5 - TTY ASCII Configuration commands
shortform: (longform, description)
"""
