int    CreateData(char *display) ;
void   DestroyData(void) ;

void   SetDefaultWindowStatus(int win_no) ;

void   SetWindowStatus(int win_no,
		       int w_width, int w_height, int color_type,
		       double r, double g, double b, double scr_distance,
		       double s_width, double s_height, long event_mask,
		       int resize_mode) ;

void   SetWindowOrigin(int win_no, int win_gravity) ;
void   SetWindowSizeHintsByGeometry(int win_no, char *geometry, char *defgeom);
void   SetWindowPosition(int win_no, int position_x, int position_y) ;
void   SetWindowSize(int win_no, int w_width, int w_height) ;
void   XYRateByChangedSize(int win_no) ;
void   SetScreenSize(int win_no, double s_width, double s_height) ;
void   SetScreenDistance(int win_no, double scr_distance) ;
void   SetColorType(int win_no, int color_type,
		    double r, double g, double b) ;
void   SetEventMask(int win_no, long event_mask) ;
void   SetResizeMode(int win_no, int resize_mode) ;
void   SetNumberOfRGB(int win_no, int r, int g, int b) ;

void   ChangeWindowStatus(int win_no,
			  int w_width,int w_height, int color_type,
			  double r, double g, double b, double scr_distance,
			  double s_width, double s_height, long event_mask,
			  int resize_mdoe) ;

void   ChangeWindowPosition(int win_no, int position_x, int position_y) ;
void   ChangeWindowSize(int win_no, int w_width, int w_height) ;
void   ChangeColorType(int win_no, int color_type,
		       double r, double g, double b) ;
void   ChangeEventMask(int win_no, long event_mask) ;
void   ChangeTitleName(int win_no, char *name) ;

void   EventOfWindowConfig(int clear_queue_switch, int flush_switch) ;
int    PressureEvents(void) ;
int    ClearEventsQueue(void) ;

int    WindowConfig(XConfigureEvent *event) ;
void   WindowExpose(XExposeEvent *event, int event2_flag) ;
void   WindowReparent(XReparentEvent *event) ;

void   SetupWindow(int win_no, char *name) ;

void   ClearPixmap(int win_no) ;
void   AllocTitleName(int win_no, char *name) ;
void   InputKeybordMatrix(void) ;

void   CreateNewColormap(int win_no) ;
void   SetColorCells(int win_no) ;
void   SetColorCellsTD(int win_no) ;
void   SetColorCells8RGB(int win_no) ;
void   SetColorCells8SCALE(int win_no) ;
void   SetColorCellsLRGB(int win_no) ;
void   SetColorCellsLSCALE(int win_no) ;
/*
void   SetColorCells24(int win_no) ;
void   SetColorCells16(int win_no) ;
*/

unsigned long GetPixelByRGB(Color cl, int win_no) ;

void   CloseWindow(int win_no) ;

void   CalculateSinCos(SinCos *sincos, double degree) ;
void   Revolve2D(double *x, double *y, double degree) ;
void   Revolve2DBySinCos(double *x, double *y, SinCos sincos) ;
void   RevolvePointByAngle(Point *point, Angle angle) ;
void   RevolvePointByReverseAngle(Point *point, Angle angle) ;

void   MoveToParent(int obj_no) ;
void   MoveChildrenToI(int obj_no) ;

/*
void   AddPoint(Point *point, Point o_point) ;
void   SubPoint(Point *point, Point o_point) ;
void   ScalingPoint(Point *p, Point scale) ;
*/

void   AmpersandAngleOnObjectByAngle(Locate *l, Angle *o_angle) ;
void   AmpersandAngleByAngle(Angle *angle, Angle *o_angle) ;
void   AmpersandAngleOnParentByAngle(Angle *angle, Angle *o_angle) ;

void   AmpersandAngleByRL(Angle *angle, double rl) ;
void   AmpersandAngleByFR(Angle *angle, double fr) ;
void   AmpersandAngleByLR(Angle *angle, double lr) ;

void   CalculateNewDownVectorOfDir_Vec(Dir_Vec *dir) ;
void   VectorToAngle(Angle *angle, Dir_Vec dir) ;
void   NormalizeAngle(Angle *angle) ;

void   DivideMovedAngle(Angle *a, Angle o, Angle r) ;
void   LimitMovedAngle(Angle *a, Angle o, Angle l) ;

int    CreateNewObject(int chr_no, Locate locate) ;
int    CreateObject(int chr_no, int p_obj, Locate locate,
		    int n, int min_obj, int nm_obj) ;
int    CreateChildren(int obj_no, int n) ;
int    CreateChildByChr_Tbl(int obj_no, int n, int r_count) ;

int    SearchNullObject(void) ;
int    SearchNullChar(void) ;

void   ObjectPointToWorldPointByObjectLocate(Point *point, Locate *locate) ;

void   CalculateCenterOfGravityOfPolygon(Point *c_of_gravity,
					 Display_Work *dw, Polygon *pn) ;
void   CalculateVectorOfPointToPoint(Point *v, Point *p1, Point *p2) ;
void   CalculateUnitNormalVectorOfPolygon(Point *n_vector, Display_Work *dw,
					  Polygon *pn, double order_of_tops) ;
void   CalculateNormalVectorBy2Vectors(Point *n_vector, Point *p1, Point *p2) ;
void   UnitVector(Point *v) ;

double Shading(Point *l, Point *n) ;
double HighLight(Point *e, Point *l, Point *n, double m_exp) ;
double HighLight2(Point *e, Point *l, Point *n, double m_exp) ;

void   ReflectVector(Point *r, Point *v, Point *n) ;
void   AddVector(Point *v1, Point *v2) ;

int    HiddenSurface(Point *e, Point *n) ;

void   CalculateScreenXYBy3DPoint(Scr_XY *scr_xy, Point *p, W_Status *x_win) ;
void   ResizeScreenXY(Scr_XY *scr_xy, int win_no) ;
void   DisplayObjects(int eye_no, int lgt_no, int win_no) ;
void   CreateScreenWork(int win_no) ;
void   DrawWindowByScreenWork(int win_no) ;

void   QuickSort(int n, int no[], Scr_Pol a[]) ;
void   InsertionSort(int n, int no[], Scr_Pol a[]) ;

void   ChangePointByMatrix(Point *p, double mat[4][4]) ;
void   MultiMatrix4X4(double a[4][4], double b[4][4]) ;
void   AmpersandMatrix4X4(double a[4][4], double b[4][4]) ;

void   GetMatrixForRevolveRLByAngle(double mat[4][4], Angle *angle) ;
void   GetMatrixForRevolveFRByAngle(double mat[4][4], Angle *angle) ;
void   GetMatrixForRevolveLRByAngle(double mat[4][4], Angle *angle) ;
void   GetMatrixForMoveByPoint(double mat[4][4], Point *p) ;
void   GetMatrixForScaling(double mat[4][4], Point *s) ;
void   GetMatrixForObjectToParentByLocate(double mat[4][4], Locate *locate) ;
void   GetMatrixForParentToObjectByLocate(double mat[4][4], Locate *locate) ;
void   GetMatrixForCreateChr_Tbl(double mat[4][4], Locate *locate) ;

int    SearchNextDescendant(int obj_no, int instance_id) ;
int    IfInstanceBelongToClass(int obj_no, int class_id) ;
int    IfInstanceDescendant(int obj_no, int instance_id) ;

void   MoveC(int instance_id,int class_id, Point v) ;
void   RevolveC(int instance_id, int class_id, Angle v) ;
void   RevolveAndMoveC(int instance_id, int class_id, Locate v) ;
void   MoveOnParentC(int instance_id, int class_id, Point v) ;
void   RevolveOnParentC(int instance_id, int class_id, Angle v) ;
void   LockOnObjectC(int instance_id, int class_id,
		     int o_obj, Angle rate, Angle limit) ;
void   ScalingC(int instance_id, int class_id,
		Point s, int relative_switch) ;

void   SetDisplaySwitchC(int instance_id, int class_id,
			 int display_switch) ;
void   SetYonClippingC(int instance_id, int class_id,
		       double yon_clipping) ;
void   SetColorRateC(int instance_id, int class_id,
		     int color_rate) ;
void   DestroyObject(int obj_no) ;



void   Move(int obj_no, Point v) ;
void   Revolve(int obj_no, Angle v) ;
void   RevolveAndMove(int obj_no, Locate v) ;

void   MoveOnParent(int obj_no, Point v) ;
void   RevolveOnParent(int obj_no, Angle v) ;

void   LockOnObject(int obj_no, int o_obj,
		    Angle rate, Angle limit) ;

void   IndependentFromParent(int obj_no) ;

void   Scaling(int obj_no, Point s, int relative_switch) ;

void   SetPointOnParent(int obj_no, Point p) ;
void   SetPointOnWorld(int obj_no, Point p) ;
void   SetAngleOnParent(int obj_no, Angle a) ;

void   SetDisplaySwitch(int obj_no, int display_switch) ;
void   SetYonClipping(int obj_no, double yon_clipping) ;
void   SetColorRate(int obj_no, double color_rate) ;
void   SetColor2(int obj_no, Color color) ;

int    GetInstanceID(int instance_id, int class_id) ;
int    GetInstanceIDs(int instance_id, int class_id,
		      int nm_ids, int *ids) ;
int    GetInstanceIDsOfChildren(int obj_no, int nm_ids, int *ids) ;

Point  GetPointOnParent(int obj_no) ;
Point  GetPointOnWorld(int obj_no) ;
Angle  GetAngleOnParent(int obj_no) ;
Angle  GetAngleOnWorld(int obj_no) ;
Point  GetPointToObjectOnWorld(int obj_no, int o_obj) ;
Point  GetPointToObjectOnParent(int obj_no, int o_obj) ;

int    GetDisplaySwitch(int obj_no) ;
double GetYonClipping(int obj_no) ;
double GetColorRate(int obj_no) ;
int    GetNumberOfChildren(int obj_no) ;

void   SetLightStatus(int lgt_no, Color cl, Color back,
		      Point vector, double air_shading) ;
void   SetLightVector(int lgt_no, Point vec) ;
void   SetLightAngle(int lgt_no, Angle angle) ;
void   SetLightLevel(int lgt_no, Color cl) ;
void   SetAmbientLevel(int lgt_no, Color cl) ;
void   SetBackColor(int lgt_no, Color cl) ;
void   SetAirShading(int lgt_no, double air_shading) ;
void   SetLightAndAmbientLevel(int lgt_no, Color cl) ;
void   CopyLightStatus(int lgt_no, int o_lgt) ;

Point  GetPoint(double x, double y, double z) ;
Angle  GetAngle(double rl, double fr, double lr) ;
Point  GetScale(double s_xyz) ;
Locate GetLocate(double x, double y, double z,
		 double rl, double fr, double lr,
		 double sx, double sy, double sz) ;
Color  GetColor(double r, double g, double b) ;
Color  GetColorByName(char *name) ;
Color_Data GetColor_Data(double r, double g, double b,
			 double mr, double mg, double mb, double mrr_exp) ;
Color_Data GetColor_DataByColor(Color cl, int strct) ;
Color_Data GetColor_DataByName(char *name, int strct) ;

void   ReversePolygon(TP_Data *tp, int pol_no, int reverse) ;

int    CreateNewClass(void) ;
int    CreateClassOfSphere(Locate l, int nu, int nv,
			   Color_Data color_data, Color_Data color_data2,
			   int transparent_switch, int check) ;
int    CreateClassOfPillar(Locate l, int nu, int nv,
			   Color_Data color_data, Color_Data color_data2,
			   int transparent_switch, int check) ;
int    CreateClassOfCone(Locate l, int nu, int nv,
			 Color_Data color_data, Color_Data color_data2,
			 int transparent_switch, int check) ;
int    CreateClassByTP_Data(TP_Data *tp_data) ;
int    CreateClassOfNone(void) ;
int    CreateClassOfCircles(int nm_circles,
			    Color *colors, double *r) ;
int    CreateClassOfGatheringCircles(int nm_circles,
				     Color *colors, double *r,
				     int nm_gathering, Locate *l) ;

int    CreateClassHaveChild(int base_id, int child_id,
			    Locate l, int inheritance_mode) ;
int    CreateClassHaveChildren(int base_id,
			       int nm_children, int *children_id,
			       Locate *l, int inheritance_mode) ;
int    CreateClassOfAdding(int nm_classes, int *ids, Locate *l) ;

int    CreateClassLocate(int base_id,
			 Locate l, int inheritance_mode) ;
int    CreateClassScale(int base_id,
			Point s, int inheritance_mode) ;
int    CreateClassMove(int base_id,Point p,int inheritance_mode) ;
int    CreateClassRevolve(int base_id,
			  Angle a, int inheritance_mode) ;
int    CreateClassColoring(int base_id, int nm_color_datas,
			   Color_Data *s_cd, Color_Data *o_cd) ;
int    CopyClass(int base_id) ;

void   SetColor2OfClass(int id, Color color2) ;
