#define Pow(d, n)   (n == 0 ? 1 : pow(d, n))
#define Rand(d)     ((double)rand() / (double)RAND_MAX * (d))

#define Rad(d)      ((d) * PI / 180.0)
#define Deg(r)      ((r) * 180.0 / PI)

#define Sin(d)      (sin(Rad((d))))
#define Cos(d)      (cos(Rad((d))))
#define Atan2(y, x) (Deg(atan2((y), (x))))

#define Abs(n)      ((n) >= 0 ? (n) : -(n))
#define Sgn(n)      ((n) > 0 ? 1 : ((n) < 0 ? -1 : 0))
#define VAbs(v)     (sqrt((v).x * (v).x + (v).y * (v).y + (v).z * (v).z))

#define AddPoint(p1, p2) \
{ \
    (p1)->x += (p2).x ; \
    (p1)->y += (p2).y ; \
    (p1)->z += (p2).z ; \
}

#define SubPoint(p1, p2) \
{ \
    (p1)->x -= (p2).x ; \
    (p1)->y -= (p2).y ; \
    (p1)->z -= (p2).z ; \
}

#define ScalingPoint(p1, p2) \
{ \
    (p1)->x *= (p2).x ; \
    (p1)->y *= (p2).y ; \
    (p1)->z *= (p2).z ; \
}

#define ReverseLocate(l) \
{ \
    (l)->point.x = - (l)->point.x ; \
    (l)->point.y = - (l)->point.y ; \
    (l)->point.z = - (l)->point.z ; \
    (l)->angle.rl = - (l)->angle.rl ; \
    (l)->angle.fr = - (l)->angle.fr ; \
    (l)->angle.lr = - (l)->angle.lr ; \
    (l)->scale.x = 1.0 / (l)->scale.x ; \
    (l)->scale.y = 1.0 / (l)->scale.y ; \
    (l)->scale.z = 1.0 / (l)->scale.z ; \
}

#define CopyMatrix4X4(m1, m2) \
{ \
    int     i, j ; \
    for (i = 0 ; i < 4 ; i ++) \
        for (j = 0 ; j < 4 ; j ++) \
            (m1)[i][j] = (m2)[i][j] ; \
}

#define Cmp_C(c1, c2) \
    ((c1).r == (c2).r && \
     (c1).g == (c2).g && \
     (c1).b == (c2).b)

#define Cmp_CD(cd1, cd2) \
    (Cmp_C((cd1).rnd, (cd2).rnd) && \
     Cmp_C((cd1).mrr, (cd2).mrr) && \
     (cd1).mrr_exponent == (cd2).mrr_exponent)

#define IsKeyPressed(data, code) \
    (1 & (data->x_objs.key_vector[(code) / 8] >> ((code) & 7)))

#define WindowWidth(win_no) \
    (X.win[win_no].size.width)

#define WindowHeight(win_no) \
    (X.win[win_no].size.height)

#define MUL_RED     (XW.p_nm_red    - 0.001)
#define MUL_GREEN   (XW.p_nm_green  - 0.001)
#define MUL_BLUE    (XW.p_nm_blue   - 0.001)
#define MUL_COLORS  (XW.p_nm_colors - 0.001)

#define G_GREEN                 (XW.p_nm_red * XW.p_nm_blue)
#define G_RED                   (XW.p_nm_blue)

#define X       data->x_objs
#define XW      X.win[win_no]

#define OBJ     data->obj[obj_no]
#define P_OBJ   data->obj[p_obj]
#define C_OBJ   data->obj[child_obj]
#define DST     data->d_status
