.\"    This file is part of pload - a program to monitor ppp activity for X
.\"    Copyright (C) 1999-2000  Matt Smith <mdsmith@engr.utk.edu>
.\"
.\"    This program is free software; you can redistribute it and/or modify
.\"    it under the terms of the GNU General Public License as published by
.\"    the Free Software Foundation; either version 2 of the License, or
.\"    (at your option) any later version.
.\"
.\"    This program is distributed in the hope that it will be useful,
.\"    but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"    GNU General Public License for more details.
.\"
.\"    You should have received a copy of the GNU General Public License
.\"    along with this program; if not, write to the Free Software
.\"    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH PLOAD 1 "" "January 2000"

.SH NAME
pload \- display ppp throughput statistics in an X window

.SH SYNOPSIS
.ta 6n
\fBpload\fP	[-\fItoolkitoption\fP ...] [-minscale \fIn\fP] [-indiv \fIn\fP]
[-outdiv \fIn\fP] [-logscale] [-jumpscroll \fIn\fP] 
[-update \fIn\fP] [-in] [-out] [-horiz] [-nolabel] [-nochart] [-average \fIn\fP] 
[-device \fIX\fP] [-hl \fIcolor\fP] [-incolor \fIcolor\fP] 
[-outcolor \fIcolor\fP] [-noproc] [-ncmsg \fImessage\fP]
[-iformat \fIfmt\fP] [-oformat \fIfmt\fP] 

.SH DESCRIPTION
The \fBpload\fP program displays information about network interface (ppp) statistics.
Additionally, for Linux 2.2 it can display statistics for any interface that
reports to /proc/net/dev .

.SH OPTIONS
.PP
\fBPload\fP accepts all of the standard X Toolkit command line options (see \fIX(1)\fP).
The order of the options in unimportant. Additionally, \fBpload\fP accepts
the following options:
.PP

.TP 8
.B \-minscale \fIn\fP
The minscale option sets the minimum integer number of scale lines to display.  The 
number of divisions will not go below the number specified.  The default is 1.

.TP 8
.B \-indiv \fIn\fP
Show  dividing lines for a rate of \fIn\fP bytes per second for received data.  The 
default is to show a line every 1024 bytes per second (1 k/s).

.TP 8
.B \-outdiv \fIn\fP
Show  dividing lines for a rate of \fIn\fP bytes per second for sent data.  The 
default is to show a line every 1024 bytes per second (1 k/s).

.TP 8
.B \-logscale
The logscale option enables graphing the base 10 logarithm of the rates. This is
most useful for high bandwith devices like ethernet. The -indiv and -outdiv options
interact with this option: a scale line will be drawn for 10*div, 100*div,
1000*div, ... bytes. The default is to graph linearly.

.TP 8
.B \-jumpscroll \fIn\fP
This option sets number of pixels to shift to the left when the graph
reaches the right edge of the window.  Smooth scrolling is achieved by the default
setting of 1.

.TP 8
.B \-update \fIn\fP
The displayed charts are updated every integer \fIn\fP seconds.  The default is to
update every 1 seconds.

.TP 8
.B \-in
Only show the chart for received data.

.TP 8
.B \-out
Only show the chart for sent data.  Default action is to show both charts.

.TP 8
.B \-horiz
Display side by side.  Default is to display vertically.

.TP 8
.B \-nolabel
This option suppresses the normal display of the total bytes and current rate label.

.TP 8
.B \-nochart
Don't show the charts.  If -nolabel is not set, pload will only show the text
labels.  If -nolabel and -nochart are set, pload won't do anything.

.TP 8
.B \-average \fIn\fP
Average or smooth over \fIn\fP number of samples in the calculations of the current
rates for the displayed graphs.  The default is to average over 10 points.  For a more
instantaneous response this can be set to 1.

.TP 8
.B \-device \fIX\fP
Monitor this device.  The default is ppp0.

.TP 8
.B \-hl \fIcolor\fP
This option specifies the color of the scale lines.

.TP 8
.B \-incolor \fIcolor\fP
Set the foreground color for the inbound chart to \fIcolor\fP.  The
default is red.

.TP 8
.B \-outcolor \fIcolor\fP
Set the foreground color for the outbound chart to \fIcolor\fP.  The
default is darkgreen.

.TP 8
.B \-fg \fIcolor\fP
Set the form foreground color to \fIcolor\fP.

.TP 8
.B \-bg \fIcolor\fP
Set the background color to \fIcolor\fP.

.TP 8
.B \-fn \fIfontspec\fP
Set the label font to \fIfontspec\fP.

.TP 8
.B \-noproc
This option is only valid for Linux >=2.2.  It disables the default usage of the
proc filesystem for gathering device statistics.  The more portable ioctl()
method is used instead. When -noproc is specified only ppp stats can be read.

.TP 8
.B \-ncmsg \fImessage\fP
Display \fImessage\fP in the labels when offline. The default is "No Connection".

.TP 8
.B \-iformat \fIfmt\fP
Use string \fIfmt\fP for the inbound label. The \fIfmt\fP string will be displayed
literally with the special tags %t %r and %M expanding to the interface total, current
rate, and maximum rate respectively. The default is "%t %r in".

.TP 8
.B \-oformat \fIfmt\fP
Same as \fI-iformat\fP but for out bound data. The default is "%t %r out".



.SH RESOURCES
All of the options available above and more can be set using the resources
of the widgets in \fBpload\fP.  The following can be added to a user .Xdefaults
or system wide Pload.ad file.  Additional customisation can be accomplished
by examining the running executable with \fIeditres(1)\fP.
.sp
.ta 0.2i 3.5i
.nf
	Pload*update		:	1
	Pload*ichart.foreground	:	red
	Pload*ichart.jumpScroll	:	1
	Pload*ochart.foreground	:	darkgreen
	Pload*ochart.jumpScroll	:	1
	Pload*topform*borderWidth	:	0
	Pload*topform*font	:	fixed
	Pload.geometry		:	180x200
	Pload*showIn		:	True
	Pload*showOut		:	True
	Pload*device		:	ppp0
	Pload*showLabel		:	True
	Pload*showChart		:	True
	Pload*averagePoints	:	10
	Pload*inDiv		:	1024
	Pload*outDiv		:	1024
	Pload*logScale		:	False
	Pload*horiz		:	False
	Pload*useProc		:	True
	Pload*noConnectMsg	:	No Connection
	Pload*inFormat		:	%t %r in
	Pload*outFormat		:	%t %r out


.SH SEE ALSO
pppstats(8), xload(1), X(1), editres(1)

.SH BUGS
Resizing doesn't work right under icewm and kwm with opaque resize turned on.  
The labels flash. Totals seem to wrap at ULONG_MAX.

.SH COPYRIGHT
Copyright (C) 1999,2000 Matt Smith

.SH AUTHOR
Pload was written by Matt Smith <mdsmith@engr.utk.edu> with ideas and help from
Christian Bauer,
Scott Berg,
David Brownlee,
Mathieu Clabaut,
Todd Larason,
and 
Roland Smith.
