/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.general;

import com.sshtools.j2ssh.SshClient;
import edu.harvard.mgh.purcell.gCLINE.data.RunCommand;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class GCFileChooser {
    private static Logger logger = Logger.getLogger(GCFileChooser.class);
    private JFrame parent;
    private JDialog parent2;
    public String fileName;
    private JDialog remotePicker;
    private JFileChooser localPicker;
    private Vector<FileChoosenListener> allListeners;
    private boolean onlyLocal;
    private boolean onlyDir;
    private SshClient conn;
    private String currentDir;
    private JList fileList;
    private JTextField remotePicks;
    private boolean dirSelected = false;
    private DefaultListModel editableList;

    private void initalize(FileFilter f) {
        this.allListeners = new Vector();
        if (!this.onlyLocal) {
            if (this.currentDir.endsWith("/")) {
                this.currentDir = this.currentDir.substring(0, this.currentDir.length() - 1);
            }
            logger.info("[intalize(FileFilter)]onlyLocal is FALSE");
            this.remotePicks = new JTextField(30);
            this.remotePicks.setText(this.currentDir);
            this.remotePicker = this.parent != null ? new JDialog((Frame)this.parent, "Open Remote File") : new JDialog((Dialog)this.parent2, "Open Remote File");
            this.remotePicker.getRootPane().setLayout(new BoxLayout(this.remotePicker.getRootPane(), 3));
            this.remotePicker.getRootPane().add(this.createFileList());
            this.remotePicker.getRootPane().add(this.createButton());
        } else {
            logger.info("[initalize(FileFilter)] onlyLocal is TRUE");
            this.localPicker = new JFileChooser();
            this.localPicker.setCurrentDirectory(new File(this.currentDir));
            if (f != null) {
                this.localPicker.setFileFilter(f);
            }
            if (this.onlyDir) {
                this.localPicker.setFileSelectionMode(1);
            }
        }
    }

    public GCFileChooser(JFrame p, FileFilter f, boolean pickLocal, boolean pickDirectory, SshClient c, String startDir) {
        this.currentDir = startDir;
        this.conn = c;
        this.onlyLocal = pickLocal;
        this.onlyDir = pickDirectory;
        this.parent = p;
        this.initalize(f);
    }

    public GCFileChooser(JDialog p, FileFilter f, boolean pickLocal, boolean pickDirectory, SshClient c, String startDir) {
        this.currentDir = startDir;
        this.conn = c;
        this.onlyLocal = pickLocal;
        this.onlyDir = pickDirectory;
        this.parent2 = p;
        this.initalize(f);
    }

    public void showChooser() {
        if (!this.onlyLocal) {
            this.remotePicker.pack();
            this.remotePicker.setVisible(true);
        } else {
            int returnVal = this.parent != null ? this.localPicker.showOpenDialog(this.parent) : this.localPicker.showOpenDialog(this.parent2);
            if (returnVal == 0) {
                this.fileName = this.localPicker.getSelectedFile().getAbsolutePath();
                logger.info("(showChooser()) Picked filename: " + this.fileName);
                FileChoosenEvent openEvent = new FileChoosenEvent(this);
                for (FileChoosenListener f : this.allListeners) {
                    f.fileChoosenOccures(openEvent);
                }
            }
        }
    }

    private void createContent(DefaultListModel editableList) {
        editableList.removeAllElements();
        if (this.conn == null) {
            return;
        }
        RunCommand getFiles = new RunCommand("ls -FL " + this.currentDir, this.conn);
        getFiles.run();
        Vector<String> files = getFiles.outputLines;
        for (String file : files) {
            editableList.addElement(file);
        }
    }

    private JScrollPane createFileList() {
        this.editableList = new DefaultListModel();
        this.createContent(this.editableList);
        this.fileList = new JList(this.editableList);
        this.fileList.setSelectionMode(1);
        this.fileList.setLayoutOrientation(0);
        this.fileList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && GCFileChooser.this.dirSelected) {
                    GCFileChooser.this.currentDir = GCFileChooser.this.remotePicks.getText();
                    GCFileChooser.this.createContent(GCFileChooser.this.editableList);
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                String name = (String)GCFileChooser.this.fileList.getSelectedValue();
                if (name == null) {
                    return;
                }
                if (name.endsWith("/")) {
                    GCFileChooser.this.dirSelected = true;
                }
                if (name.endsWith("/") || name.endsWith("@") || name.endsWith("*") || name.endsWith("=") || name.endsWith("%") || name.endsWith("|")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (GCFileChooser.this.currentDir.equals("")) {
                    GCFileChooser.this.remotePicks.setText(name);
                } else if (GCFileChooser.this.currentDir.endsWith("/")) {
                    GCFileChooser.this.remotePicks.setText(String.valueOf(GCFileChooser.this.currentDir) + name);
                } else {
                    GCFileChooser.this.remotePicks.setText(String.valueOf(GCFileChooser.this.currentDir) + "/" + name);
                }
            }
        });
        this.fileList.ensureIndexIsVisible(0);
        return new JScrollPane(this.fileList);
    }

    private JPanel createButton() {
        JPanel ans = new JPanel();
        JButton back = new JButton("Back");
        back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GCFileChooser.this.currentDir.equals("/")) {
                    return;
                }
                logger.info("[back.actionListener] current dir: " + GCFileChooser.this.currentDir);
                String newDir = GCFileChooser.this.currentDir.replaceFirst("[^/]+$", "");
                logger.info("[back.actionListener] newDir: " + newDir);
                if (newDir.equals(GCFileChooser.this.currentDir)) {
                    RunCommand getFiles = new RunCommand("pwd " + GCFileChooser.this.currentDir, GCFileChooser.this.conn);
                    getFiles.run();
                    Vector<String> fullName = getFiles.outputLines;
                    newDir = fullName.get(0);
                    logger.info("[back.actionListener] full name: " + newDir);
                    newDir = newDir.replaceFirst("/[^/]+$", "");
                    logger.info("[back.actionListener] newDir: " + newDir);
                }
                GCFileChooser.this.currentDir = newDir;
                GCFileChooser.this.remotePicks.setText(GCFileChooser.this.currentDir);
                GCFileChooser.this.createContent(GCFileChooser.this.editableList);
            }
        });
        ans.add(back);
        ans.add(this.remotePicks);
        JButton ok = new JButton("Open");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GCFileChooser.this.dirSelected && GCFileChooser.this.onlyDir || !GCFileChooser.this.dirSelected || !GCFileChooser.this.onlyDir) {
                    GCFileChooser.this.fileName = GCFileChooser.this.remotePicks.getText();
                    FileChoosenEvent openEvent = new FileChoosenEvent(GCFileChooser.this);
                    for (FileChoosenListener f : GCFileChooser.this.allListeners) {
                        f.fileChoosenOccures(openEvent);
                    }
                    GCFileChooser.this.remotePicker.dispose();
                } else if (GCFileChooser.this.dirSelected) {
                    GCFileChooser.this.currentDir = GCFileChooser.this.remotePicks.getText();
                    GCFileChooser.this.createContent(GCFileChooser.this.editableList);
                }
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GCFileChooser.this.remotePicker.dispose();
            }
        });
        ans.add(ok);
        ans.add(cancel);
        return ans;
    }

    public void addFileChoosenListener(FileChoosenListener listener) {
        this.allListeners.add(listener);
    }

    public void removeFileChoosenListener(FileChoosenListener listener) {
        this.allListeners.remove(listener);
    }

    public static interface FileChoosenListener
    extends EventListener {
        public void fileChoosenOccures(FileChoosenEvent var1);
    }

    public class FileChoosenEvent
    extends EventObject {
        public FileChoosenEvent(Object source) {
            super(source);
        }
    }
}

