/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE;

import com.sshtools.j2ssh.ScpClient;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

class TransfureFiles
implements Runnable {
    private static Logger logger = Logger.getLogger(TransfureFiles.class);
    private Record data;
    private String localFolder;
    protected String[] remoteFiles;
    private String remoteFolder;
    protected String[] localFiles;
    private boolean ignore;

    public void run() {
        logger.info("[run()] Starting transfure");
        ScpClient scp = null;
        if (this.data == null || this.data.getConn() == null) {
            logger.error("[run()] the connection is null, no file transfured");
            return;
        }
        try {
            scp = this.data.getConn().openScpClient();
        }
        catch (IOException e) {
            logger.error("Error trying open connection to download file.");
            this.data.connect();
            return;
        }
        if (this.localFolder != null) {
            String allremote = "";
            String[] stringArray = this.remoteFiles;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String temp = stringArray[n];
                allremote = "[" + temp + "] ";
                ++n;
            }
            logger.info("Download [" + allremote + "] to [" + this.localFolder + "].");
            try {
                scp.get(this.localFolder, this.remoteFiles, false);
            }
            catch (IOException e1) {
                if (!this.ignore) {
                    this.data.frame.messanger.createError("Can not download files. Possible  connection failure.", "run()@TransfureFiles");
                    logger.error("[run()] Error dialog pop's up due to download failure");
                }
                logger.error("Error trying download " + allremote + " to [" + this.localFolder + "].");
            }
            logger.info("End download");
        } else if (this.remoteFolder != null) {
            String alllocal = "";
            String[] stringArray = this.localFiles;
            int n = 0;
            int n3 = stringArray.length;
            while (n < n3) {
                String temp = stringArray[n];
                alllocal = "[" + temp + "] ";
                ++n;
            }
            logger.info("Upload [" + alllocal + "] to [" + this.remoteFolder + "].");
            try {
                scp.put(this.localFiles, this.remoteFolder, false);
            }
            catch (IOException e1) {
                if (!this.ignore) {
                    this.data.frame.messanger.createError("Can not upload files. Possible  connection failure.", "run()@TransfureFiles");
                }
                logger.error("Error trying upload " + alllocal + " to [" + this.remoteFolder + "].");
            }
            logger.info("End upload");
        }
    }

    public TransfureFiles(Record d, boolean ignoreFailure, File givenLocalFolder, String[] givenRemoteFiles) {
        this.data = d;
        this.localFolder = givenLocalFolder.getAbsolutePath();
        this.remoteFiles = givenRemoteFiles;
        this.ignore = ignoreFailure;
    }

    public TransfureFiles(Record d, boolean ignoreFailure, String givenRemoteFolder, File[] givenLocalFiles) {
        this.data = d;
        this.remoteFolder = givenRemoteFolder;
        this.localFiles = new String[givenLocalFiles.length];
        int i = 0;
        while (i < givenLocalFiles.length) {
            this.localFiles[i] = givenLocalFiles[i].getAbsolutePath();
            ++i;
        }
        this.ignore = ignoreFailure;
    }
}

