/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE;

import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class DeleteOpDialog
extends JDialog {
    private JCheckBox[] operations;
    private Vector<JCheckBox> outfiles;
    private Vector<JCheckBox> infiles;
    private Record data;
    ActionListener deleteFileOp = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            if (!DeleteOpDialog.this.data.isRemote()) {
                File temp;
                for (JCheckBox tempBox : DeleteOpDialog.this.outfiles) {
                    if (tempBox == null || !tempBox.isSelected() || (temp = new File(DeleteOpDialog.this.data.getLocalFolder(), tempBox.getText())).delete()) continue;
                    ((DeleteOpDialog)DeleteOpDialog.this).data.frame.messanger.createError("Failed deletion of [" + tempBox.getText() + "] You will need to manually check the" + "deletion of " + "this file.", "deleteFileOp@DeleteOpDialog.java");
                }
                for (JCheckBox tempBox : DeleteOpDialog.this.infiles) {
                    if (!tempBox.isSelected() || (temp = new File(DeleteOpDialog.this.data.getLocalFolder(), tempBox.getText())).delete()) continue;
                    ((DeleteOpDialog)DeleteOpDialog.this).data.frame.messanger.createError("Failed deletion of [" + tempBox.getText() + "] You will need to manually check the" + "deletion of " + "this file.", "deleteFileOp@DeleteOpDialog.java");
                }
            }
            int i = 0;
            while (i < DeleteOpDialog.this.operations.length) {
                if (DeleteOpDialog.this.operations[i].isSelected()) {
                    DeleteOpDialog.this.data.removeOperation(DeleteOpDialog.this.operations[i].getText());
                }
                ++i;
            }
            DeleteOpDialog.this.dispose();
        }
    };

    private JPanel createOpPanel(String[] opNames) {
        JPanel ans = new JPanel();
        ans.setLayout(new BoxLayout(ans, 3));
        ans.setBorder(new TitledBorder("Operations to Delete"));
        int numOps = opNames.length;
        this.operations = new JCheckBox[numOps];
        int i = 0;
        while (i < numOps) {
            this.operations[i] = new JCheckBox(opNames[i]);
            this.operations[i].setSelected(true);
            ans.add(this.operations[i]);
            ++i;
        }
        return ans;
    }

    private JPanel createFilePanel(String[] opNames, boolean inFiles, String flagExt) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        if (inFiles) {
            panel.setBorder(new TitledBorder("Input files to Delete"));
        } else {
            panel.setBorder(new TitledBorder("Output files to Delete"));
        }
        HashSet<String> files = new HashSet<String>();
        Vector<Object> temp = new Vector();
        int i = 0;
        while (i < opNames.length) {
            temp = inFiles ? this.data.getOp(opNames[i]).getInputFiles() : this.data.getOp(opNames[i]).getOutputFiles();
            for (FileInfo fileInfo : temp) {
                files.add(fileInfo.toString());
            }
            if (!inFiles && new File(this.data.getLocalFolder(), String.valueOf(opNames[i]) + flagExt).exists()) {
                files.add(String.valueOf(opNames[i]) + flagExt);
            }
            ++i;
        }
        if (inFiles) {
            this.infiles = new Vector();
        } else {
            this.outfiles = new Vector();
        }
        for (String file : files) {
            JCheckBox tempBox = new JCheckBox(file);
            if (inFiles) {
                this.infiles.add(tempBox);
            } else {
                this.outfiles.add(tempBox);
                tempBox.setSelected(true);
            }
            panel.add(tempBox);
        }
        return panel;
    }

    private JPanel createButtonsPanel() {
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("Delete Selection");
        ok.addActionListener(this.deleteFileOp);
        buttonPanel.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeleteOpDialog.this.dispose();
            }
        });
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    public DeleteOpDialog(StartFrame givenFrame, Record d, String[] opNames, String flagExt) {
        super((Frame)givenFrame, "Delete Operations");
        this.data = d;
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(new JScrollPane(this.createOpPanel(opNames)));
        if (!this.data.isRemote()) {
            this.getContentPane().add(new JScrollPane(this.createFilePanel(opNames, true, flagExt)));
            this.getContentPane().add(new JScrollPane(this.createFilePanel(opNames, false, flagExt)));
        }
        this.getContentPane().add(this.createButtonsPanel());
        this.pack();
        this.setVisible(true);
    }
}

