/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelDataWindow {
    private static Log log = LogFactory.getLog(ChannelDataWindow.class);
    long windowSpace = 0L;

    public synchronized long getWindowSpace() {
        return this.windowSpace;
    }

    public synchronized long consumeWindowSpace(int count) {
        if (this.windowSpace < (long)count) {
            this.waitForWindowSpace(count);
        }
        this.windowSpace -= (long)count;
        return this.windowSpace;
    }

    public synchronized void increaseWindowSpace(long count) {
        if (log.isDebugEnabled()) {
            log.debug("Increasing window space by " + String.valueOf(count));
        }
        this.windowSpace += count;
        this.notifyAll();
    }

    public synchronized void waitForWindowSpace(int minimum) {
        if (log.isDebugEnabled()) {
            log.debug("Waiting for " + String.valueOf(minimum) + " bytes of window space");
        }
        while (this.windowSpace < (long)minimum) {
            try {
                this.wait(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

