/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.KeyConstraints;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;

class SshAgentAddKey
extends SubsystemMessage {
    public static final int SSH_AGENT_ADD_KEY = 202;
    SshPrivateKey prvkey;
    SshPublicKey pubkey;
    String description;
    KeyConstraints constraints;

    public SshAgentAddKey() {
        super(202);
    }

    public SshAgentAddKey(SshPrivateKey prvkey, SshPublicKey pubkey, String description, KeyConstraints constraints) {
        super(202);
        this.prvkey = prvkey;
        this.pubkey = pubkey;
        this.description = description;
        this.constraints = constraints;
    }

    public SshPrivateKey getPrivateKey() {
        return this.prvkey;
    }

    public SshPublicKey getPublicKey() {
        return this.pubkey;
    }

    public String getDescription() {
        return this.description;
    }

    public KeyConstraints getKeyConstraints() {
        return this.constraints;
    }

    public String getMessageName() {
        return "SSH_AGENT_ADD_KEY";
    }

    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        try {
            baw.writeBinaryString(this.prvkey.getEncoded());
            baw.writeBinaryString(this.pubkey.getEncoded());
            baw.writeString(this.description);
            baw.write(this.constraints.toByteArray());
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }

    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        try {
            this.prvkey = SshKeyPairFactory.decodePrivateKey(bar.readBinaryString());
            this.pubkey = SshKeyPairFactory.decodePublicKey(bar.readBinaryString());
            this.description = bar.readString();
            this.constraints = new KeyConstraints(bar);
        }
        catch (IOException ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }
}

