/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.hosts;

import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DialogKnownHostsKeyVerification
extends AbstractKnownHostsKeyVerification {
    Component parent;
    private boolean verificationEnabled = true;

    public DialogKnownHostsKeyVerification(Component parent) throws InvalidHostFileException {
        super(new File(System.getProperty("user.home"), ".ssh" + File.separator + "known_hosts").getAbsolutePath());
        this.parent = parent;
    }

    public DialogKnownHostsKeyVerification(Component parent, String hostFileName) throws InvalidHostFileException {
        super(hostFileName);
        this.parent = parent;
    }

    public void setVerificationEnabled(boolean enabled) {
        this.verificationEnabled = this.verificationEnabled;
    }

    public void onDeniedHost(final String host) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(DialogKnownHostsKeyVerification.this.parent, "Access to '" + host + "' is denied.\n" + "Verify the access granted/denied in the allowed hosts file.", "Remote Host Authentication", 0);
                    }
                });
            }
        }
        catch (InvocationTargetException ite) {
            throw new TransportProtocolException("Invocation Exception: " + ite.getMessage());
        }
        catch (InterruptedException ie) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    public void onHostKeyMismatch(final String host, final SshPublicKey recorded, final SshPublicKey actual) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Object[] options = DialogKnownHostsKeyVerification.this.getOptions();
                        int res = JOptionPane.showOptionDialog(DialogKnownHostsKeyVerification.this.parent, "The host '" + host + "' has provided a different host key.\nThe host key" + " fingerprint provided is '" + actual.getFingerprint() + "'.\n" + "The allowed host key fingerprint is " + recorded.getFingerprint() + ".\nDo you want to allow this host?", "Remote host authentication", 1, 3, null, options, options[0]);
                        try {
                            if (options.length == 3 && res == 0) {
                                DialogKnownHostsKeyVerification.this.allowHost(host, actual, true);
                            } else if (options.length == 2 && res == 0 || options.length == 3 && res == 1) {
                                DialogKnownHostsKeyVerification.this.allowHost(host, actual, false);
                            }
                        }
                        catch (InvalidHostFileException e) {
                            DialogKnownHostsKeyVerification.this.showExceptionMessage(e);
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException ite) {
            throw new TransportProtocolException("Invocation Exception: " + ite.getMessage());
        }
        catch (InterruptedException ie) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    public void onUnknownHost(final String host, final SshPublicKey key) throws TransportProtocolException {
        try {
            if (this.verificationEnabled) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Object[] options = DialogKnownHostsKeyVerification.this.getOptions();
                        int res = JOptionPane.showOptionDialog(DialogKnownHostsKeyVerification.this.parent, "The host '" + host + "' is unknown. The host key" + " fingerprint is\n'" + key.getFingerprint() + "'.\nDo you want to allow this host?", "Remote host authentication", 1, 3, null, options, options[0]);
                        try {
                            if (options.length == 3 && res == 0) {
                                DialogKnownHostsKeyVerification.this.allowHost(host, key, true);
                            } else if (options.length == 2 && res == 0 || options.length == 3 && res == 1) {
                                DialogKnownHostsKeyVerification.this.allowHost(host, key, false);
                            }
                        }
                        catch (InvalidHostFileException e) {
                            DialogKnownHostsKeyVerification.this.showExceptionMessage(e);
                        }
                    }
                });
            }
        }
        catch (InvocationTargetException ite) {
            throw new TransportProtocolException("Invocation Exception: " + ite.getMessage());
        }
        catch (InterruptedException ie) {
            throw new TransportProtocolException("SwingUtilities thread interrupted!");
        }
    }

    private String[] getOptions() {
        String[] stringArray;
        if (this.isHostFileWriteable()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "Always";
            stringArray2[1] = "Yes";
            stringArray = stringArray2;
            stringArray2[2] = "No";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "Yes";
            stringArray = stringArray3;
            stringArray3[1] = "No";
        }
        return stringArray;
    }

    private void showExceptionMessage(Exception e) {
        JOptionPane.showMessageDialog(this.parent, "An unexpected error occured!\n\n" + e.getMessage(), "Host Verification", 0);
    }
}

