PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;

DROP TABLE IF EXISTS `ph_select`;
CREATE TABLE `ph_select` (
    `sel_id` INTEGER PRIMARY KEY AUTOINCREMENT,
    `sel_name` varchar(16) NOT NULL,
    `sel_text` varchar(100) DEFAULT NULL
);

INSERT INTO `ph_select` (`sel_id`, `sel_name`, `sel_text`) VALUES
    (1, 'Sun', 'The one and only'),
    (2, 'Mercury', 'Cold and hot'),
    (3, 'Venus', 'Yeah baby she''s got it'),
    (4, 'Earth', 'Home'),
    (5, 'Mars', 'The God of War'),
    (6, 'Jupiter', NULL),
    (7, 'Saturn', 'A car'),
    (8, 'Uranus', 'Loads of jokes for this one');

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `id` INTEGER PRIMARY KEY AUTOINCREMENT,
  `document_id` int(3) NOT NULL,
  `customer_id` char(15) NOT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(70) NOT NULL,
  `instructions` varchar(100) DEFAULT NULL,
  `status` char(1) NOT NULL,
  `birth_date` date DEFAULT '1970-01-01',
  `credit_line` decimal(16,2) DEFAULT '0',
  `created_at` datetime NOT NULL,
  `created_at_user_id` int(10) DEFAULT '0'
);
CREATE INDEX customers_document_id_idx ON customers (`document_id`);
CREATE INDEX customers_customer_id_idx ON customers (`customer_id`);
CREATE INDEX customers_credit_line_idx ON customers (`credit_line`);
CREATE INDEX customers_status_idx ON customers (`status`);

DROP TABLE IF EXISTS `m2m_parts`;
CREATE TABLE `m2m_parts` (
  `id` INTEGER PRIMARY KEY AUTOINCREMENT,
  `name` varchar(70) NOT NULL
);

DROP TABLE IF EXISTS `m2m_robots`;
CREATE TABLE `m2m_robots` (
  `id` INTEGER PRIMARY KEY AUTOINCREMENT,
  `name` varchar(70) NOT NULL
);

DROP TABLE IF EXISTS `m2m_robots_parts`;
CREATE TABLE `m2m_robots_parts` (
  `robots_id` INTEGER NOT NULL,
  `parts_id` INTEGER NOT NULL,
  PRIMARY KEY (`robots_id`, `parts_id`)
);

DROP TABLE IF EXISTS `parts`;
CREATE TABLE `parts` (
  `id` INTEGER NOT NULL PRIMARY KEY,
  `name` varchar(70) NOT NULL
);
INSERT INTO "parts" VALUES(1,'Head');
INSERT INTO "parts" VALUES(2,'Body');
INSERT INTO "parts" VALUES(3,'Arms');
INSERT INTO "parts" VALUES(4,'Legs');
INSERT INTO "parts" VALUES(5,'CPU');

DROP TABLE IF EXISTS `personas`;
CREATE TABLE `personas` (
  `cedula` char(15) NOT NULL,
  `tipo_documento_id` int(3) NOT NULL,
  `nombres` varchar(100) NOT NULL DEFAULT '',
  `telefono` varchar(20) DEFAULT NULL,
  `direccion` varchar(100) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT '1970-01-01',
  `ciudad_id` int(10) DEFAULT '0',
  `creado_at` date DEFAULT NULL,
  `cupo` decimal(16,2) NOT NULL,
  `estado` character(1) NOT NULL,
  PRIMARY KEY (`cedula`)
);
INSERT INTO "personas" VALUES('1',3,'HUANG ZHENGQUIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-18',6930,'I');
INSERT INTO "personas" VALUES('100',1,'USME FERNANDEZ JUAN GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-04-15',439480,'A');
INSERT INTO "personas" VALUES('1003',8,'SINMON PEREZ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-25',468610,'A');
INSERT INTO "personas" VALUES('1009',8,'ARCINIEGAS Y VILLAMIZAR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-08-12',967680,'A');
INSERT INTO "personas" VALUES('101',1,'CRANE DE NARVAEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-06-09',790540,'A');
INSERT INTO "personas" VALUES('1011',8,'EL EVENTO','191821112','CRA 25 CALLE 100','596@terra.com.co','2011-02-03',127591,'2011-05-24',820390,'A');
INSERT INTO "personas" VALUES('1020',7,'OSPINA YOLANDA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-02',222970,'A');
INSERT INTO "personas" VALUES('1025',7,'CHEMIPLAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-08',918670,'A');
INSERT INTO "personas" VALUES('1034',1,'TAXI FILMS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-09-01',962580,'A');
INSERT INTO "personas" VALUES('104',1,'CASTELLANOS JIMENEZ NOE','191821112','CRA 25 CALLE 100','127@yahoo.es','2011-02-03',127591,'2011-10-05',95230,'A');
INSERT INTO "personas" VALUES('1046',3,'JACQUET PIERRE MICHEL ALAIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',263489,'2011-07-23',90810,'A');
INSERT INTO "personas" VALUES('1048',5,'SPOERER VELEZ CARLOS JORGE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-02-03',184920,'A');
INSERT INTO "personas" VALUES('1049',3,'SIDNEI DA SILVA LUIZ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117630,'2011-07-02',850180,'A');
INSERT INTO "personas" VALUES('105',1,'HERRERA SEQUERA ALVARO FRANCISCO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-26',77390,'A');
INSERT INTO "personas" VALUES('1050',3,'CAVALCANTI YUE CARLA HANLI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-31',696130,'A');
INSERT INTO "personas" VALUES('1052',1,'BARRETO RIVAS ELKIN MARTIN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',131508,'2011-09-19',562160,'A');
INSERT INTO "personas" VALUES('1053',3,'WANDERLEY ANTONIO ERNESTO THOME','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150617,'2011-01-31',20490,'A');
INSERT INTO "personas" VALUES('1054',3,'HE SHAN','191821112','CRA 25 CALLE 100','715@yahoo.es','2011-02-03',132958,'2010-10-05',415970,'A');
INSERT INTO "personas" VALUES('1055',3,'ZHRNG XIM','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-05',18380,'A');
INSERT INTO "personas" VALUES('1057',3,'NICKEL GEB. STUTZ KARIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-10-08',164850,'A');
INSERT INTO "personas" VALUES('1058',1,'VELEZ PAREJA IGNACIO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132775,'2011-06-24',292250,'A');
INSERT INTO "personas" VALUES('1059',3,'GURKE RALF ERNST','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',287570,'2011-06-15',966700,'A');
INSERT INTO "personas" VALUES('106',1,'ESTRADA LONDONO JUAN SIMON','191821112','CRA 25 CALLE 100','8@terra.com.co','2011-02-03',128579,'2011-03-09',101260,'A');
INSERT INTO "personas" VALUES('1060',1,'MEDRANO BARRIOS WILSON','191821112','CRA 25 CALLE 100','479@facebook.com','2011-02-03',132775,'2011-06-18',956740,'A');
INSERT INTO "personas" VALUES('1061',1,'GERDTS PORTO HANS EDUARDO','191821112','CRA 25 CALLE 100','140@gmail.com','2011-02-03',127591,'2011-05-09',883590,'A');
INSERT INTO "personas" VALUES('1062',1,'BORGE VISBAL JORGE FIDEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132775,'2011-07-14',547750,'A');
INSERT INTO "personas" VALUES('1063',3,'GUTIERREZ JOSELYN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-06',87960,'A');
INSERT INTO "personas" VALUES('1064',4,'OVIEDO PINZON MARYI YULEY','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127538,'2011-04-21',796560,'A');
INSERT INTO "personas" VALUES('1065',1,'VILORA SILVA OMAR ESTEBAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2010-06-09',718910,'A');
INSERT INTO "personas" VALUES('1066',3,'AGUIAR ROMAN RODRIGO HUMBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126674,'2011-06-28',204890,'A');
INSERT INTO "personas" VALUES('1067',1,'GOMEZ AGAMEZ ADOLFO DEL CRISTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',131105,'2011-06-15',867730,'A');
INSERT INTO "personas" VALUES('1068',3,'GARRIDO CECILIA','191821112','CRA 25 CALLE 100','973@yahoo.com.mx','2011-02-03',118777,'2010-08-16',723980,'A');
INSERT INTO "personas" VALUES('1069',1,'JIMENEZ MANJARRES DAVID RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132775,'2010-12-17',16680,'A');
INSERT INTO "personas" VALUES('107',1,'ARANGUREN TEJADA JORGE ENRIQUE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-16',274110,'A');
INSERT INTO "personas" VALUES('1070',3,'OYARZUN TEJEDA ANDRES FERNANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-26',911490,'A');
INSERT INTO "personas" VALUES('1071',3,'MARIN BUCK RAFAEL ENRIQUE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126180,'2011-05-04',507400,'A');
INSERT INTO "personas" VALUES('1072',3,'VARGAS JOSE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126674,'2011-07-28',802540,'A');
INSERT INTO "personas" VALUES('1073',3,'JUEZ JAIRALA JOSE ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',126180,'2010-04-09',490510,'A');
INSERT INTO "personas" VALUES('1074',1,'APONTE PENSO HERNAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132879,'2011-05-27',44900,'A');
INSERT INTO "personas" VALUES('1075',1,'PINERES BUSTILLO ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',126916,'2008-10-29',752980,'A');
INSERT INTO "personas" VALUES('1076',1,'OTERA OMA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-04-29',630210,'A');
INSERT INTO "personas" VALUES('1077',3,'CONTRERAS CHINCHILLA JUAN DOMINGO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',139844,'2011-06-21',892110,'A');
INSERT INTO "personas" VALUES('1078',1,'GAMBA LAURENCIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-09-15',569940,'A');
INSERT INTO "personas" VALUES('108',1,'MUNOZ ARANGO JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-01',66770,'A');
INSERT INTO "personas" VALUES('1080',1,'PRADA ABAUZA CARLOS AUGUSTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-11-15',156870,'A');
INSERT INTO "personas" VALUES('1081',1,'PAOLA CAROLINA PINTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-27',264350,'A');
INSERT INTO "personas" VALUES('1082',1,'PALOMINO HERNANDEZ GERMAN JAVIER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2011-03-22',851120,'A');
INSERT INTO "personas" VALUES('1084',1,'URIBE DANIEL ALBERTO','191821112','CRA 25 CALLE 100','602@hotmail.es','2011-02-03',127591,'2011-09-07',759470,'A');
INSERT INTO "personas" VALUES('1085',1,'ARGUELLO CALDERON ARMANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-24',409660,'A');
INSERT INTO "personas" VALUES('1087',1,'CARVAJAL HERNANDEZ CHRISTIAN ARMANDO','191821112','CRA 25 CALLE 100','296@yahoo.es','2011-02-03',159432,'2011-06-03',620410,'A');
INSERT INTO "personas" VALUES('1088',1,'CASTRO BLANCO MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',150512,'2009-10-08',792400,'A');
INSERT INTO "personas" VALUES('1089',1,'RIBEROS GUTIERREZ GUSTAVO ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-01-27',100800,'A');
INSERT INTO "personas" VALUES('109',1,'BELTRAN MARIA LUZ DARY','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-06',511510,'A');
INSERT INTO "personas" VALUES('1091',4,'ORTIZ ORTIZ BENIGNO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127538,'2011-08-05',331540,'A');
INSERT INTO "personas" VALUES('1092',3,'JOHN CHRISTOPHER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-08',277320,'A');
INSERT INTO "personas" VALUES('1093',1,'PARRA VILLAREAL MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',129499,'2011-08-23',391980,'A');
INSERT INTO "personas" VALUES('1094',1,'BESGA RODRIGUEZ JUAN JAVIER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127300,'2011-09-23',127960,'A');
INSERT INTO "personas" VALUES('1095',1,'ZAPATA MEZA EDGAR FERNANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',129499,'2011-05-19',463840,'A');
INSERT INTO "personas" VALUES('1096',3,'CORNEJO BRAVO MARCO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2010-11-08',935340,'A');
INSERT INTO "personas" VALUES('CELL3944',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('1099',1,'GARCIA PORRAS FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-14',243360,'A');
INSERT INTO "personas" VALUES('11',1,'HERNANDEZ PARDO ARMANDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-31',197540,'A');
INSERT INTO "personas" VALUES('110',1,'VANEGAS JULIAN ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-06',357260,'A');
INSERT INTO "personas" VALUES('1101',1,'QUINTERO BURBANO GABRIEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',129499,'2011-08-20',57420,'A');
INSERT INTO "personas" VALUES('1102',1,'BOHORQUEZ AFANADOR CHRISTIAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-19',214610,'A');
INSERT INTO "personas" VALUES('1103',1,'MORA VARGAS JULIO ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-29',900790,'A');
INSERT INTO "personas" VALUES('1104',1,'PINEDA JORGE ARMANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-21',860110,'A');
INSERT INTO "personas" VALUES('1105',1,'TORO CEBALLOS GONZALO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',129499,'2011-08-18',598180,'A');
INSERT INTO "personas" VALUES('1106',1,'SCHENIDER TORRES JAIME','191821112','CRA 25 CALLE 100','85@yahoo.com.mx','2011-02-03',127799,'2011-08-11',410590,'A');
INSERT INTO "personas" VALUES('1107',1,'RUEDA VILLAMIZAR JAIME','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-11-15',258410,'A');
INSERT INTO "personas" VALUES('1108',1,'RUEDA VILLAMIZAR RICARDO JAIME','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',129499,'2011-03-22',60260,'A');
INSERT INTO "personas" VALUES('1109',1,'GOMEZ RODRIGUEZ HERNANDO ARTURO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-06-02',526080,'A');
INSERT INTO "personas" VALUES('111',1,'FRANCISCO EDUARDO JAIME BOTERO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-09-09',251770,'A');
INSERT INTO "personas" VALUES('1110',1,'HERNANDEZ MENDEZ EDGAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',129499,'2011-03-22',449610,'A');
INSERT INTO "personas" VALUES('1113',1,'LEON HERNANDEZ OSCAR','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',129499,'2011-03-21',992090,'A');
INSERT INTO "personas" VALUES('1114',1,'LIZARAZO CARRENO HUGO ARCENIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',133535,'2010-12-10',959490,'A');
INSERT INTO "personas" VALUES('1115',1,'LIAN BARRERA GABRIEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-05-30',821170,'A');
INSERT INTO "personas" VALUES('1117',3,'TELLEZ BEZAN FRANCISCO JAVIER ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117002,'2011-08-21',673430,'A');
INSERT INTO "personas" VALUES('1118',1,'FUENTES ARIZA DIEGO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-09',684970,'A');
INSERT INTO "personas" VALUES('1119',1,'MOLINA M. ROBINSON','191821112','CRA 25 CALLE 100','728@hotmail.com','2011-02-03',129447,'2010-09-19',404580,'A');
INSERT INTO "personas" VALUES('112',1,'PATINO PINTO ARIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-10-06',187050,'A');
INSERT INTO "personas" VALUES('1120',1,'ORTIZ DURAN BENIGNO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127538,'2011-08-05',967970,'A');
INSERT INTO "personas" VALUES('1121',1,'CARVAJAL ALMEIDA LUIS RAUL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',129499,'2011-06-22',626140,'A');
INSERT INTO "personas" VALUES('1122',1,'TORRES QUIROGA EDWIN SILVESTRE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',129447,'2011-08-17',226780,'A');
INSERT INTO "personas" VALUES('1123',1,'VIVIESCAS JAIMES ALVARO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-10',255480,'A');
INSERT INTO "personas" VALUES('1124',1,'MARTINEZ RUEDA JAVIER EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',129447,'2011-06-23',597040,'A');
INSERT INTO "personas" VALUES('1125',1,'ANAYA FLORES JORGE ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',129499,'2011-06-04',218790,'A');
INSERT INTO "personas" VALUES('1126',3,'TORRES MARTINEZ ANTONIO JESUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2010-09-02',302820,'A');
INSERT INTO "personas" VALUES('1127',3,'CACHO LEVISIER JOSE MANUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',153276,'2009-06-25',857720,'A');
INSERT INTO "personas" VALUES('1129',3,'ULLOA VALDIVIESO CRISTIAN ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-06-02',327570,'A');
INSERT INTO "personas" VALUES('113',1,'HIGUERA CALA JAIME ENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-27',179950,'A');
INSERT INTO "personas" VALUES('1130',1,'ARCINIEGAS WILLIAM','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126892,'2011-08-05',497420,'A');
INSERT INTO "personas" VALUES('1131',1,'BAZA ACUNA JAVIER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',129447,'2010-12-10',504410,'A');
INSERT INTO "personas" VALUES('1132',3,'BUIRA ROS CARLOS MARIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-04-27',29750,'A');
INSERT INTO "personas" VALUES('1133',1,'RODRIGUEZ JAIME','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',129447,'2011-06-10',635560,'A');
INSERT INTO "personas" VALUES('1134',1,'QUIROGA PEREZ NELSON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',129447,'2011-05-18',88520,'A');
INSERT INTO "personas" VALUES('1135',1,'TATIANA AYALA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127122,'2011-07-01',535920,'A');
INSERT INTO "personas" VALUES('1136',1,'OSORIO BENEDETTI FABIAN AUGUSTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132775,'2010-10-23',414060,'A');
INSERT INTO "personas" VALUES('1139',1,'CELIS PINTO ARMANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2009-02-25',964970,'A');
INSERT INTO "personas" VALUES('114',1,'VALDERRAMA CUERVO JOSE IGNACIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-02',338590,'A');
INSERT INTO "personas" VALUES('1140',1,'ORTIZ ARENAS JUAN MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',129499,'2009-10-21',613300,'A');
INSERT INTO "personas" VALUES('1141',1,'VALDIVIESO ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',134022,'2009-01-13',171590,'A');
INSERT INTO "personas" VALUES('1144',1,'LOPEZ CASTILLO NELSON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',129499,'2010-09-09',823110,'A');
INSERT INTO "personas" VALUES('1145',1,'CAVELIER LUIS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',126916,'2008-11-29',389220,'A');
INSERT INTO "personas" VALUES('1146',1,'CAVELIER OTOYA LUIS EDURDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126916,'2010-05-25',476770,'A');
INSERT INTO "personas" VALUES('1147',1,'GARCIA RUEDA JUAN CARLOS','191821112','CRA 25 CALLE 100','111@yahoo.es','2011-02-03',133535,'2010-09-12',216190,'A');
INSERT INTO "personas" VALUES('1148',1,'LADINO GOMEZ OMAR ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-02',650640,'A');
INSERT INTO "personas" VALUES('1149',1,'CARRENO ORTIZ OSCAR JAVIER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-15',604630,'A');
INSERT INTO "personas" VALUES('115',1,'NARDEI BONILLO BRUNO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-16',153110,'A');
INSERT INTO "personas" VALUES('1150',1,'MONTOYA BOZZI MAURICIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',129499,'2011-05-12',71240,'A');
INSERT INTO "personas" VALUES('1152',1,'LORA RICHARD JAVIER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-09-15',497700,'A');
INSERT INTO "personas" VALUES('1153',1,'SILVA PINZON MARCO ANTONIO','191821112','CRA 25 CALLE 100','915@hotmail.es','2011-02-03',127591,'2011-06-15',861670,'A');
INSERT INTO "personas" VALUES('1154',3,'GEORGE J A KHALILIEH','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-20',815260,'A');
INSERT INTO "personas" VALUES('1155',3,'CHACON MARIN CARLOS MANUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-07-26',491280,'A');
INSERT INTO "personas" VALUES('1156',3,'OCHOA CHEHAB XAVIER ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',126180,'2011-06-13',10630,'A');
INSERT INTO "personas" VALUES('1157',3,'ARAYA GARRI GABRIEL ALEXIS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-09-19',579320,'A');
INSERT INTO "personas" VALUES('1158',3,'MACCHI ARIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116366,'2010-04-12',864690,'A');
INSERT INTO "personas" VALUES('116',1,'GONZALEZ FANDINO JAIME EDUARDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-10',749800,'A');
INSERT INTO "personas" VALUES('1160',1,'CAVALIER LUIS EDUARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',126916,'2009-08-27',333390,'A');
INSERT INTO "personas" VALUES('CELL396',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('1161',3,'DOMINGUEZ DE OBREGON ILEANA DEL CARMEN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',139844,'2011-03-06',910490,'A');
INSERT INTO "personas" VALUES('1162',2,'FALASCA CLAUDIO ARIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116511,'2011-07-10',552280,'A');
INSERT INTO "personas" VALUES('1163',3,'MUTABARUKA PATRICK','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131352,'2011-03-22',29940,'A');
INSERT INTO "personas" VALUES('1164',1,'DOMINGUEZ ATENCIA JIMMY CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-07-22',492860,'A');
INSERT INTO "personas" VALUES('1165',4,'LLANO GONZALEZ ALBERTO MARIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127300,'2010-08-21',374490,'A');
INSERT INTO "personas" VALUES('1166',3,'LOPEZ ROLDAN JOSE MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-07-31',393860,'A');
INSERT INTO "personas" VALUES('1167',1,'GUTIERREZ DE PINERES JALILIE ARISTIDES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2010-12-09',845810,'A');
INSERT INTO "personas" VALUES('1168',1,'HEYMANS PIERRE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2010-11-08',47470,'A');
INSERT INTO "personas" VALUES('1169',1,'BOTERO OSORIO RUBEN DARIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2009-05-27',699940,'A');
INSERT INTO "personas" VALUES('1170',3,'GARNHAM POBLETE ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',116396,'2011-03-27',357270,'A');
INSERT INTO "personas" VALUES('1172',1,'DAJUD DURAN JOSE RODRIGO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2009-12-02',360910,'A');
INSERT INTO "personas" VALUES('1173',1,'MARTINEZ MERCADO PEDRO PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-07-25',744930,'A');
INSERT INTO "personas" VALUES('1174',1,'GARCIA AMADOR ANDRES EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2011-05-19',641930,'A');
INSERT INTO "personas" VALUES('1176',1,'VARGAS VARELA LUIS GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',131568,'2011-08-30',948410,'A');
INSERT INTO "personas" VALUES('1178',1,'GUTIERRES DE PINERES ARISTIDES','191821112','CRA 25 CALLE 100','217@hotmail.com','2011-02-03',133535,'2011-05-10',242490,'A');
INSERT INTO "personas" VALUES('1179',3,'LEIZAOLA POZO JIMENA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132958,'2011-08-01',759800,'A');
INSERT INTO "personas" VALUES('118',1,'FERNANDEZ VELOSO PEDRO HERNANDO','191821112','CRA 25 CALLE 100','452@hotmail.es','2011-02-03',128662,'2010-08-06',198830,'A');
INSERT INTO "personas" VALUES('1180',3,'MARINO PAOLO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-12-24',71520,'A');
INSERT INTO "personas" VALUES('1181',1,'MOLINA VIZCAINO GUSTAVO JORGE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-04-28',78220,'A');
INSERT INTO "personas" VALUES('1182',3,'MEDEL GARCIA FABIAN RODRIGO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-04-25',176540,'A');
INSERT INTO "personas" VALUES('1183',1,'LESMES ARIAS RUBEN DARIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-09-09',648020,'A');
INSERT INTO "personas" VALUES('1184',1,'ALCALA MARTINEZ ALFREDO ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132775,'2010-07-23',710470,'A');
INSERT INTO "personas" VALUES('1186',1,'LLAMAS FOLIACO LUIS ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-07',910210,'A');
INSERT INTO "personas" VALUES('1187',1,'GUARDO DEL RIO LIBARDO FARID','191821112','CRA 25 CALLE 100','73@yahoo.com.mx','2011-02-03',128662,'2011-09-01',726050,'A');
INSERT INTO "personas" VALUES('1188',3,'JEFFREY ARTHUR DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',115724,'2011-03-21',899630,'A');
INSERT INTO "personas" VALUES('1189',1,'DAHL VELEZ JULIANA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',126916,'2011-05-23',320020,'A');
INSERT INTO "personas" VALUES('119',3,'WALESKA DE LIMA ALMEIDA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-05-09',125240,'A');
INSERT INTO "personas" VALUES('1190',3,'LUIS JOSE MANUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2008-04-04',901210,'A');
INSERT INTO "personas" VALUES('1192',1,'AZUERO VALENTINA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-14',26310,'A');
INSERT INTO "personas" VALUES('1193',1,'MARQUEZ GALINDO MAURICIO JAVIER','191821112','CRA 25 CALLE 100','729@yahoo.es','2011-02-03',131105,'2011-05-13',493560,'A');
INSERT INTO "personas" VALUES('1195',1,'NIETO FRANCO JUAN FELIPE','191821112','CRA 25 CALLE 100','707@yahoo.com','2011-02-03',127591,'2011-07-30',463790,'A');
INSERT INTO "personas" VALUES('1196',3,'ESTEVES JOAQUIM LUIS FERNANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-04-05',152270,'A');
INSERT INTO "personas" VALUES('1197',4,'BARRERO KAREN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-12',369990,'A');
INSERT INTO "personas" VALUES('1198',1,'CORRALES GUZMAN DELIO ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127689,'2011-08-03',393120,'A');
INSERT INTO "personas" VALUES('1199',1,'CUELLAR TOCO EDGAR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127531,'2011-09-20',855640,'A');
INSERT INTO "personas" VALUES('12',1,'MARIN PRIETO FREDY NELSON ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-23',641210,'A');
INSERT INTO "personas" VALUES('120',1,'LOPEZ JARAMILLO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2009-04-17',29680,'A');
INSERT INTO "personas" VALUES('1200',3,'SCHULTER ACHIM','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',291002,'2010-05-21',98860,'A');
INSERT INTO "personas" VALUES('1201',3,'HOWELL LAURENCE ADRIAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',286785,'2011-05-22',927350,'A');
INSERT INTO "personas" VALUES('1202',3,'ALCAZAR ESCARATE JAIME PATRICIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117002,'2011-08-25',340160,'A');
INSERT INTO "personas" VALUES('1203',3,'HIDALGO FUENZALIDA GABRIEL RAUL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-05-03',918780,'A');
INSERT INTO "personas" VALUES('1206',1,'VANEGAS HENAO ORLANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-27',832910,'A');
INSERT INTO "personas" VALUES('1207',1,'PENARANDA ARIAS RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-19',832710,'A');
INSERT INTO "personas" VALUES('1209',1,'LEZAMA CERVERA JUAN CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132775,'2011-09-14',825980,'A');
INSERT INTO "personas" VALUES('121',1,'PULIDO JIMENEZ OSCAR HUMBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-29',772700,'A');
INSERT INTO "personas" VALUES('1211',1,'TRUJILLO BOCANEGRA HAROL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127538,'2011-05-27',199260,'A');
INSERT INTO "personas" VALUES('1212',1,'ALVAREZ TORRES MARIO RICARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-08-15',589960,'A');
INSERT INTO "personas" VALUES('1213',1,'CORRALES VARON BELMER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-26',352030,'A');
INSERT INTO "personas" VALUES('1214',3,'CUEVAS RODRIGUEZ MANUELA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-30',990250,'A');
INSERT INTO "personas" VALUES('1216',1,'LOPEZ EDICSON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-31',505210,'A');
INSERT INTO "personas" VALUES('1217',3,'GARCIA PALOMARES JUAN JAVIER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-07-31',840440,'A');
INSERT INTO "personas" VALUES('1218',1,'ARCINIEGAS NARANJO RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127492,'2010-12-17',686610,'A');
INSERT INTO "personas" VALUES('122',1,'GONZALEZ RIANO LEONARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128031,'2011-08-05',774450,'A');
INSERT INTO "personas" VALUES('1220',1,'GARCIA GUTIERREZ WILLIAM','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-06-20',498680,'A');
INSERT INTO "personas" VALUES('1221',3,'GOMEZ DE ALONSO ANGELA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-27',758300,'A');
INSERT INTO "personas" VALUES('1222',1,'MEDINA QUIROGA JAMES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127538,'2011-01-16',295480,'A');
INSERT INTO "personas" VALUES('1224',1,'ARCILA CORREA JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-03-20',125900,'A');
INSERT INTO "personas" VALUES('1225',1,'QUIJANO REYES CARLOS ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127538,'2010-04-08',22100,'A');
INSERT INTO "personas" VALUES('157',1,'ORTIZ RIOS ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-12',365330,'A');
INSERT INTO "personas" VALUES('1226',1,'VARGAS GALLEGO JAIRO ALONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2009-07-30',732820,'A');
INSERT INTO "personas" VALUES('1228',3,'NAPANGA MIRENGHI MARTIN','191821112','CRA 25 CALLE 100','153@yahoo.es','2011-02-03',132958,'2011-02-08',790400,'A');
INSERT INTO "personas" VALUES('123',1,'LAMUS CASTELLANOS ANDRES RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-11',554160,'A');
INSERT INTO "personas" VALUES('1230',1,'RIVEROS PINEROS JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127492,'2011-09-25',422220,'A');
INSERT INTO "personas" VALUES('1231',3,'ESSER JUAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127327,'2011-04-01',635060,'A');
INSERT INTO "personas" VALUES('1232',3,'DOMINGUEZ MORA MAURICIO ALFREDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-22',908630,'A');
INSERT INTO "personas" VALUES('1233',3,'MOLINA FERNANDEZ FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-05-28',637990,'A');
INSERT INTO "personas" VALUES('1234',3,'BELLO DANIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',196234,'2010-09-04',464040,'A');
INSERT INTO "personas" VALUES('1235',3,'BENADAVA GUEVARA DAVID ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-05-18',406240,'A');
INSERT INTO "personas" VALUES('1236',3,'RODRIGUEZ MATOS ROBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-03-22',639070,'A');
INSERT INTO "personas" VALUES('1237',3,'TAPIA ALARCON PATRICIO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2010-07-06',976620,'A');
INSERT INTO "personas" VALUES('1239',3,'VERCHERE ALFONSO CHRISTIAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117002,'2010-08-23',899600,'A');
INSERT INTO "personas" VALUES('1241',1,'ESPINEL LUIS FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128206,'2009-03-09',302860,'A');
INSERT INTO "personas" VALUES('1242',3,'VERGARA FERREIRA PATRICIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-10-03',713310,'A');
INSERT INTO "personas" VALUES('1243',3,'ZUMARRAGA SIRVENT CRSTINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-08-24',657950,'A');
INSERT INTO "personas" VALUES('1244',4,'ESCORCIA VASQUEZ TOMAS','191821112','CRA 25 CALLE 100','354@yahoo.com.mx','2011-02-03',128662,'2011-04-01',149830,'A');
INSERT INTO "personas" VALUES('1245',4,'PARAMO CUENCA KELLY LORENA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127492,'2011-05-04',775300,'A');
INSERT INTO "personas" VALUES('1246',4,'PEREZ LOPEZ VERONICA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-07-11',426990,'A');
INSERT INTO "personas" VALUES('1247',4,'CHAPARRO RODRIGUEZ DANIELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-10-08',809070,'A');
INSERT INTO "personas" VALUES('1249',4,'DIAZ MARTINEZ MARIA CAROLINA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2011-05-30',394740,'A');
INSERT INTO "personas" VALUES('125',1,'CALDON RODRIGUEZ JAIME ARIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126968,'2011-07-29',574780,'A');
INSERT INTO "personas" VALUES('1250',4,'PINEDA VASQUEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2010-09-03',680540,'A');
INSERT INTO "personas" VALUES('1251',5,'MATIZ URIBE ANGELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-12-25',218470,'A');
INSERT INTO "personas" VALUES('1253',1,'ZAMUDIO RICAURTE JAIRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126892,'2011-08-05',598160,'A');
INSERT INTO "personas" VALUES('1254',1,'ALJURE FRANCISCO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-07-21',838660,'A');
INSERT INTO "personas" VALUES('1255',3,'ARMESTO AIRA ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',196234,'2011-01-29',398840,'A');
INSERT INTO "personas" VALUES('1257',1,'POTES GUEVARA JAIRO MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127858,'2011-03-17',194580,'A');
INSERT INTO "personas" VALUES('1258',1,'BURBANO QUIROGA RAFAEL','191821112','CRA 25 CALLE 100','767@facebook.com','2011-02-03',127591,'2011-04-07',538220,'A');
INSERT INTO "personas" VALUES('1259',1,'CARDONA GOMEZ JAVIR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-03-16',107380,'A');
INSERT INTO "personas" VALUES('126',1,'PULIDO PARDO GUIDO IVAN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-10-05',531550,'A');
INSERT INTO "personas" VALUES('1260',1,'LOPERA LEDESMA PABLO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-09-19',922240,'A');
INSERT INTO "personas" VALUES('1263',1,'TRIBIN BARRIGA JUAN MANUEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2011-09-02',525330,'A');
INSERT INTO "personas" VALUES('1264',1,'NAVIA LOPEZ ANDRES FELIPE ','191821112','CRA 25 CALLE 100','353@hotmail.es','2011-02-03',127300,'2011-07-15',591190,'A');
INSERT INTO "personas" VALUES('1265',1,'CARDONA GOMEZ FABIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2010-11-18',379940,'A');
INSERT INTO "personas" VALUES('1266',1,'ESCARRIA VILLEGAS ANDRES JULIAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-08-19',126160,'A');
INSERT INTO "personas" VALUES('1268',1,'CASTRO HERNANDEZ ALVARO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2011-03-25',76260,'A');
INSERT INTO "personas" VALUES('127',1,'RODRIGUEZ RODRIGUEZ GIOVANI FRANCISCO','191821112','CRA 25 CALLE 100','662@hotmail.es','2011-02-03',127591,'2011-09-29',933390,'A');
INSERT INTO "personas" VALUES('1270',1,'LEAL HERNANDEZ MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-24',313610,'A');
INSERT INTO "personas" VALUES('1272',1,'ORTIZ CARDONA WILLIAM ENRIQUE','191821112','CRA 25 CALLE 100','914@hotmail.com','2011-02-03',128662,'2011-09-13',272150,'A');
INSERT INTO "personas" VALUES('1273',1,'ROMERO VAN GOMPEL HERNAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-09-07',832960,'A');
INSERT INTO "personas" VALUES('1274',1,'BERMUDEZ LONDONO JHON FREDY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127300,'2011-08-29',348380,'A');
INSERT INTO "personas" VALUES('1275',1,'URREA ALVAREZ NICOLAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-01',242980,'A');
INSERT INTO "personas" VALUES('1276',1,'VALENCIA LLANOS RODRIGO AUGUSTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-04-11',169790,'A');
INSERT INTO "personas" VALUES('1277',1,'PAZ VALENCIA GUILLERMO ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127300,'2011-08-05',120020,'A');
INSERT INTO "personas" VALUES('1278',1,'MONROY CORREDOR GERARDO ALONSO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2011-06-25',90700,'A');
INSERT INTO "personas" VALUES('1279',1,'RIOS MEDINA JAVIER ERMINSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-09-12',93440,'A');
INSERT INTO "personas" VALUES('128',1,'GALLEGO GUZMAN MARIO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-06-25',72290,'A');
INSERT INTO "personas" VALUES('1280',1,'GARCIA OSCAR EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127662,'2011-09-30',195090,'A');
INSERT INTO "personas" VALUES('1282',1,'MURILLO PESELLIN GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-06-15',890530,'A');
INSERT INTO "personas" VALUES('1284',1,'DIAZ ALVAREZ JOHNY','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2011-06-25',164130,'A');
INSERT INTO "personas" VALUES('1285',1,'GARCES BELTRAN RAUL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2011-08-11',719220,'A');
INSERT INTO "personas" VALUES('1286',1,'MATERON POVEDA LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-25',103710,'A');
INSERT INTO "personas" VALUES('1287',1,'VALENCIA ALEXANDER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-10-23',360880,'A');
INSERT INTO "personas" VALUES('1288',1,'PENA AGUDELO JOSE RAMON','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',134022,'2011-05-25',493280,'A');
INSERT INTO "personas" VALUES('1289',1,'CORREA NUNEZ JORGE ALEXANDER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-08-18',383750,'A');
INSERT INTO "personas" VALUES('129',1,'ALVAREZ RODRIGUEZ IVAN RICARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2008-01-28',561290,'A');
INSERT INTO "personas" VALUES('1291',1,'BEJARANO ROSERO FREDDY ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-10-09',43400,'A');
INSERT INTO "personas" VALUES('1292',1,'CASTILLO BARRIOS GUSTAVO ADOLFO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2011-06-17',900180,'A');
INSERT INTO "personas" VALUES('CELL401',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('1296',1,'GALVEZ GUTIERREZ JUAN PABLO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2010-03-28',807090,'A');
INSERT INTO "personas" VALUES('1297',3,'CRUZ GARCIA MILTON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',139844,'2011-03-21',75630,'A');
INSERT INTO "personas" VALUES('1298',1,'VILLEGAS GUTIERREZ JOSE RICARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-11',956860,'A');
INSERT INTO "personas" VALUES('13',1,'VACA MURCIA JESUS ALFREDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-04',613430,'A');
INSERT INTO "personas" VALUES('1301',3,'BOTTI ALFONSO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',231989,'2011-04-04',910640,'A');
INSERT INTO "personas" VALUES('1302',3,'COTINO HUESO LORENZO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-02-02',803450,'A');
INSERT INTO "personas" VALUES('1304',3,'NESPOLI MANTOVANI LUIZ CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-04-18',16230,'A');
INSERT INTO "personas" VALUES('1307',4,'AVILA GIL PAULA ANDREA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-19',711110,'A');
INSERT INTO "personas" VALUES('1308',4,'VALLEJO PINEDA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-08-12',323490,'A');
INSERT INTO "personas" VALUES('1312',1,'ROMERO OSCAR EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-17',642460,'A');
INSERT INTO "personas" VALUES('1314',3,'LULLIES CONSTANZE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',245206,'2010-06-03',154970,'A');
INSERT INTO "personas" VALUES('1315',1,'CHAPARRO GUTIERREZ JORGE ADRIANO','191821112','CRA 25 CALLE 100','284@hotmail.es','2011-02-03',127591,'2010-12-02',325440,'A');
INSERT INTO "personas" VALUES('1316',1,'BARRANTES DISI RICARDO JOSE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132879,'2011-07-18',162270,'A');
INSERT INTO "personas" VALUES('1317',3,'VERDES GAGO JOSE ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2010-03-10',835060,'A');
INSERT INTO "personas" VALUES('1319',3,'MARTIN MARTINEZ GUSTAVO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2010-05-26',937220,'A');
INSERT INTO "personas" VALUES('1320',3,'MOTTURA MASSIMO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2008-11-10',620640,'A');
INSERT INTO "personas" VALUES('1321',3,'RUSSELL TIMOTHY JAMES','191821112','CRA 25 CALLE 100','502@hotmail.es','2011-02-03',145135,'2010-04-16',291560,'A');
INSERT INTO "personas" VALUES('1322',3,'JAIN TARSEM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',190393,'2011-05-31',595890,'A');
INSERT INTO "personas" VALUES('1323',3,'ORTEGA CEVALLOS JULIETA ELIZABETH','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-30',104760,'A');
INSERT INTO "personas" VALUES('1324',3,'MULLER PICHAIDA ANDRES FELIPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-05-17',736130,'A');
INSERT INTO "personas" VALUES('1325',3,'ALVEAR TELLEZ JULIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-01-23',366390,'A');
INSERT INTO "personas" VALUES('1327',3,'MOYA LATORRE MARCELA CAROLINA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-05-17',18520,'A');
INSERT INTO "personas" VALUES('1328',3,'LAMA ZAROR RODRIGO IGNACIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2010-10-27',221990,'A');
INSERT INTO "personas" VALUES('1329',3,'HERNANDEZ CIFUENTES MAURICE JEANETTE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',139844,'2011-06-22',54410,'A');
INSERT INTO "personas" VALUES('133',1,'CORDOBA HOYOS JUAN PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-20',966820,'A');
INSERT INTO "personas" VALUES('1330',2,'HOCHKOFLER NOEMI CONSUELO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-27',606070,'A');
INSERT INTO "personas" VALUES('1331',4,'RAMIREZ BARRERO DANIELA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',154563,'2011-04-18',867120,'A');
INSERT INTO "personas" VALUES('1332',4,'DE LEON DURANGO RICARDO JOSE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131105,'2011-09-08',517400,'A');
INSERT INTO "personas" VALUES('1333',4,'RODRIGUEZ MACIAS IVAN MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',129447,'2011-05-23',985620,'A');
INSERT INTO "personas" VALUES('1334',4,'GUTIERREZ DE PINERES YANET MARIA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',133535,'2011-06-16',375890,'A');
INSERT INTO "personas" VALUES('1335',4,'GUTIERREZ DE PINERES YANET MARIA GABRIELA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-06-16',922600,'A');
INSERT INTO "personas" VALUES('1336',4,'CABRALES BECHARA JOSE MARIA','191821112','CRA 25 CALLE 100','708@hotmail.com','2011-02-03',131105,'2011-05-13',485330,'A');
INSERT INTO "personas" VALUES('1337',4,'MEJIA TOBON LUIS DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127662,'2011-08-05',658860,'A');
INSERT INTO "personas" VALUES('1338',3,'OROS NERCELLES CRISTIAN ANDRE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',144215,'2011-04-26',838310,'A');
INSERT INTO "personas" VALUES('1339',3,'MORENO BRAVO CAROLINA ANDREA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',190393,'2010-12-08',214950,'A');
INSERT INTO "personas" VALUES('134',1,'GONZALEZ LOPEZ DANIEL ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-08',178580,'A');
INSERT INTO "personas" VALUES('1340',3,'FERNANDEZ GARRIDO MARCELO FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-07-08',559820,'A');
INSERT INTO "personas" VALUES('1342',3,'SUMEGI IMRE ZOLTAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-16',91750,'A');
INSERT INTO "personas" VALUES('1343',3,'CALDERON FLANDEZ SERGIO','191821112','CRA 25 CALLE 100','108@hotmail.com','2011-02-03',117002,'2010-12-12',996030,'A');
INSERT INTO "personas" VALUES('1345',3,'CARBONELL ATCHUGARRY GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',116366,'2010-04-12',536390,'A');
INSERT INTO "personas" VALUES('1346',3,'MONTEALEGRE AGUILAR FEDERICO ','191821112','CRA 25 CALLE 100','448@yahoo.es','2011-02-03',132165,'2011-08-08',567260,'A');
INSERT INTO "personas" VALUES('1347',1,'HERNANDEZ MANCHEGO CARLOS JULIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-04-28',227130,'A');
INSERT INTO "personas" VALUES('1348',1,'ARENAS ZARATE FERNEY ARNULFO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127963,'2011-03-26',433860,'A');
INSERT INTO "personas" VALUES('1349',3,'DELFIM DINIZ PASSOS PINHEIRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',110784,'2010-04-17',487930,'A');
INSERT INTO "personas" VALUES('135',1,'GARCIA SIMBAQUEBA RUBEN DARIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-25',992420,'A');
INSERT INTO "personas" VALUES('1350',3,'BRAUN VALENZUELA FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-29',138050,'A');
INSERT INTO "personas" VALUES('1351',3,'LEVIN FIORELLI ANDRES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',116366,'2011-04-10',226470,'A');
INSERT INTO "personas" VALUES('1353',3,'BALTODANO ESQUIVEL LAURA CRISTINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132165,'2011-08-01',911660,'A');
INSERT INTO "personas" VALUES('1354',4,'ESCOBAR  YEPES ANDREA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-19',403630,'A');
INSERT INTO "personas" VALUES('1356',1,'GAGELI OSORIO ALEJANDRO','191821112','CRA 25 CALLE 100','228@yahoo.com.mx','2011-02-03',128662,'2011-07-14',205070,'A');
INSERT INTO "personas" VALUES('1357',3,'CABAL ALVAREZ RUBEN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-08-14',175770,'A');
INSERT INTO "personas" VALUES('1359',4,'HUERFANO JUAN DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-04',790970,'A');
INSERT INTO "personas" VALUES('136',1,'OSORIO RAMIREZ LEONARDO','191821112','CRA 25 CALLE 100','686@yahoo.es','2011-02-03',128662,'2010-05-14',426380,'A');
INSERT INTO "personas" VALUES('1360',4,'RAMON GARCIA MARIA PAULA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-01',163890,'A');
INSERT INTO "personas" VALUES('1362',30,'ALVAREZ CLAVIO CARLA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127203,'2011-04-18',741020,'A');
INSERT INTO "personas" VALUES('1363',3,'SERRA DURAN GERARDO ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-08-03',365490,'A');
INSERT INTO "personas" VALUES('1364',3,'NORIEGA VALVERDE SILVIA MARCELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132775,'2011-02-27',604370,'A');
INSERT INTO "personas" VALUES('1366',1,'JARAMILLO LOPEZ ALEJANDRO','191821112','CRA 25 CALLE 100','269@terra.com.co','2011-02-03',127559,'2010-11-08',813800,'A');
INSERT INTO "personas" VALUES('1367',1,'MAZO ROLDAN CARLOS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-05-04',292880,'A');
INSERT INTO "personas" VALUES('1368',1,'MURIEL ARCILA MAURICIO HERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-29',22970,'A');
INSERT INTO "personas" VALUES('1369',1,'RAMIREZ CARLOS FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-14',236230,'A');
INSERT INTO "personas" VALUES('137',1,'LUNA PEREZ JUAN PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',126881,'2011-08-05',154640,'A');
INSERT INTO "personas" VALUES('1370',1,'GARCIA GRAJALES PEDRO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128166,'2011-10-09',112230,'A');
INSERT INTO "personas" VALUES('1372',3,'GARCIA ESCOBAR ANA MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2011-03-29',925670,'A');
INSERT INTO "personas" VALUES('1373',3,'ALVES DIAS CARLOS AUGUSTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-07',70940,'A');
INSERT INTO "personas" VALUES('1374',3,'MATTOS CHRISTIANE GARCIA CID','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',183024,'2010-08-25',577700,'A');
INSERT INTO "personas" VALUES('1376',1,'CARVAJAL ROJAS ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-10',645240,'A');
INSERT INTO "personas" VALUES('1377',3,'MADARIAGA CADIZ CLAUDIO CRISTIAN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2011-10-04',199200,'A');
INSERT INTO "personas" VALUES('1379',3,'MARIN YANEZ ALICIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-02-20',703870,'A');
INSERT INTO "personas" VALUES('138',1,'DIAZ AVENDANO MARCELO IVAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-22',494080,'A');
INSERT INTO "personas" VALUES('1381',3,'COSTA VILLEGAS LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117002,'2011-08-21',580670,'A');
INSERT INTO "personas" VALUES('1382',3,'DAZA PEREZ JOSE LUIS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',122035,'2009-02-23',888000,'A');
INSERT INTO "personas" VALUES('1385',4,'RIVEROS ARIAS MARIA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127492,'2011-09-26',35710,'A');
INSERT INTO "personas" VALUES('1386',30,'TORO GIRALDO MATEO','191821112','CRA 25 CALLE 100','433@yahoo.com.mx','2011-02-03',127591,'2011-07-17',700730,'A');
INSERT INTO "personas" VALUES('1387',4,'ROJAS YARA LAURA DANIELA MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-31',396530,'A');
INSERT INTO "personas" VALUES('1388',3,'GALLEGO RODRIGO MARIA PILAR','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2009-04-19',880450,'A');
INSERT INTO "personas" VALUES('1389',1,'PANTOJA VELASQUEZ JOSE ARMANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127300,'2011-08-05',212660,'A');
INSERT INTO "personas" VALUES('139',1,'FRANCO GOMEZ HERNÁN EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-01-19',6450,'A');
INSERT INTO "personas" VALUES('1390',3,'VAN DEN BORNE KEES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2010-01-28',421930,'A');
INSERT INTO "personas" VALUES('1391',3,'MONDRAGON FLORES JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-08-22',471700,'A');
INSERT INTO "personas" VALUES('1392',3,'BAGELLA MICHELE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-07-27',92720,'A');
INSERT INTO "personas" VALUES('1393',3,'BISTIANCIC MACHADO ANA INES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',116366,'2010-08-02',48490,'A');
INSERT INTO "personas" VALUES('1394',3,'BANADOS ORTIZ MARIA PILAR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-08-25',964280,'A');
INSERT INTO "personas" VALUES('1395',1,'CHINDOY CHINDOY HERNANDO','191821112','CRA 25 CALLE 100','107@terra.com.co','2011-02-03',126892,'2011-08-25',675920,'A');
INSERT INTO "personas" VALUES('1396',3,'SOTO NUNEZ ANDRES ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-10-02',486760,'A');
INSERT INTO "personas" VALUES('1397',1,'DELGADO MARTINEZ LORGE ELIAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-23',406040,'A');
INSERT INTO "personas" VALUES('1398',1,'LEON GUEVARA JAVIER ANIBAL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',126892,'2011-09-08',569930,'A');
INSERT INTO "personas" VALUES('1399',1,'ZARAMA BASTIDAS LUIS GABRIEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126892,'2011-08-05',631540,'A');
INSERT INTO "personas" VALUES('14',1,'MAGUIN HENNSSEY LUIS FERNANDO','191821112','CRA 25 CALLE 100','714@gmail.com','2011-02-03',127591,'2011-07-11',143540,'A');
INSERT INTO "personas" VALUES('140',1,'CARRANZA CUY ALEXANDER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-25',550010,'A');
INSERT INTO "personas" VALUES('1401',3,'REYNA CASTORENA JOSE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',189815,'2011-08-29',344970,'A');
INSERT INTO "personas" VALUES('1402',1,'GFALLO BOTERO SERGIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-07-14',381100,'A');
INSERT INTO "personas" VALUES('1403',1,'ARANGO ARAQUE JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-05-04',870590,'A');
INSERT INTO "personas" VALUES('1404',3,'LASSNER NORBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118942,'2010-02-28',209650,'A');
INSERT INTO "personas" VALUES('1405',1,'DURANGO MARIN HECTOR LEON','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'1970-02-02',436480,'A');
INSERT INTO "personas" VALUES('1407',1,'FRANCO CASTANO DIEGO MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-06-28',457770,'A');
INSERT INTO "personas" VALUES('1408',1,'HERNANDEZ SERGIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-05-29',628550,'A');
INSERT INTO "personas" VALUES('1409',1,'CASTANO DUQUE CARLOS HUGO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-03-23',769410,'A');
INSERT INTO "personas" VALUES('141',1,'CHAMORRO CHEDRAUI SERGIO ALBERTO','191821112','CRA 25 CALLE 100','922@yahoo.com.mx','2011-02-03',127591,'2011-05-07',730720,'A');
INSERT INTO "personas" VALUES('1411',1,'RAMIREZ MONTOYA ADAMO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-04-13',498880,'A');
INSERT INTO "personas" VALUES('1412',1,'GONZALEZ BENJUMEA OSCAR HUMBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-11-01',610150,'A');
INSERT INTO "personas" VALUES('1413',1,'ARANGO ACEVEDO WALTER ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-10-07',554090,'A');
INSERT INTO "personas" VALUES('1414',1,'ARANGO GALLO HUMBERTO LEON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-02-25',940010,'A');
INSERT INTO "personas" VALUES('1415',1,'VELASQUEZ LUIS GONZALO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-07-06',37760,'A');
INSERT INTO "personas" VALUES('1416',1,'MIRA AGUILAR FRANCISCO ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-30',368790,'A');
INSERT INTO "personas" VALUES('1417',1,'RIVERA ARISTIZABAL CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-03-02',730670,'A');
INSERT INTO "personas" VALUES('1418',1,'ARISTIZABAL ROLDAN ANDRES RICARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-02',546960,'A');
INSERT INTO "personas" VALUES('142',1,'LOPEZ ZULETA MAURICIO ALEXANDER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-01',3550,'A');
INSERT INTO "personas" VALUES('1420',1,'ESCORCIA ARAMBURO JUAN MARIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-04-01',73100,'A');
INSERT INTO "personas" VALUES('1421',1,'CORREA PARRA RICARDO ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-08-05',737110,'A');
INSERT INTO "personas" VALUES('1422',1,'RESTREPO NARANJO DANIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-09-15',466240,'A');
INSERT INTO "personas" VALUES('1423',1,'VELASQUEZ CARLOS JUAN','191821112','CRA 25 CALLE 100','123@yahoo.com','2011-02-03',128662,'2010-06-09',119880,'A');
INSERT INTO "personas" VALUES('1424',1,'MACIA GONZALEZ ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2010-11-12',200690,'A');
INSERT INTO "personas" VALUES('1425',1,'BERRIO MEJIA HELBER ANTONIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2010-06-04',643800,'A');
INSERT INTO "personas" VALUES('1427',1,'GOMEZ GUTIERREZ CARLOS ARIEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-09-08',153320,'A');
INSERT INTO "personas" VALUES('1428',1,'RESTREPO LOPEZ JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-12',915770,'A');
INSERT INTO "personas" VALUES('CELL4012',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('1429',1,'BARTH TOBAR LUIS FERNANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-02-23',118900,'A');
INSERT INTO "personas" VALUES('143',1,'MUNERA BEDIYA JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-09-21',825600,'A');
INSERT INTO "personas" VALUES('1430',1,'JIMENEZ VELEZ ANDRES EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-02-26',847160,'A');
INSERT INTO "personas" VALUES('1431',1,'TAKAHASHI GAVIRIA NICOLAS KEIICHIRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-13',879120,'A');
INSERT INTO "personas" VALUES('1432',1,'ESCOBAR JARAMILLO ESTEBAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2010-06-10',854110,'A');
INSERT INTO "personas" VALUES('1433',1,'PALACIO NAVARRO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-08-18',633200,'A');
INSERT INTO "personas" VALUES('1434',1,'LONDONO MUNOZ ADOLFO LEON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-09-14',603670,'A');
INSERT INTO "personas" VALUES('1435',1,'PULGARIN JAIME ANDRES','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2009-11-01',118730,'A');
INSERT INTO "personas" VALUES('1436',1,'FERRERA ZULUAGA LUIS FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-07-10',782630,'A');
INSERT INTO "personas" VALUES('1437',1,'VASQUEZ VELEZ HABACUC','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-27',557000,'A');
INSERT INTO "personas" VALUES('1438',1,'HENAO PALOMINO DIEGO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2009-05-06',437080,'A');
INSERT INTO "personas" VALUES('1439',1,'HURTADO URIBE JUAN GONZALO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-01-11',514400,'A');
INSERT INTO "personas" VALUES('144',1,'ALDANA RODOLFO AUGUSTO','191821112','CRA 25 CALLE 100','838@yahoo.es','2011-02-03',127591,'2011-08-07',117350,'A');
INSERT INTO "personas" VALUES('1441',1,'URIBE DANIEL ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2010-11-19',760610,'A');
INSERT INTO "personas" VALUES('1442',1,'PINEDA GALIANO JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-07-29',20770,'A');
INSERT INTO "personas" VALUES('1443',1,'DUQUE BETANCOURT FABIO LEON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-11-26',822030,'A');
INSERT INTO "personas" VALUES('1444',1,'JARAMILLO TORO HERNAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-04-27',47830,'A');
INSERT INTO "personas" VALUES('145',1,'VASQUEZ ZAPATA JUAN CARLOS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-09',109940,'A');
INSERT INTO "personas" VALUES('1450',1,'TOBON FRANCO MARCO ANTONIO','191821112','CRA 25 CALLE 100','545@facebook.com','2011-02-03',127591,'2011-05-03',889540,'A');
INSERT INTO "personas" VALUES('1454',1,'LOTERO PAVAS CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-05-28',646750,'A');
INSERT INTO "personas" VALUES('1455',1,'ESTRADA HENAO JAVIER ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128569,'2009-09-07',215460,'A');
INSERT INTO "personas" VALUES('1456',1,'VALDERRAMA MAXIMILIANO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-23',137030,'A');
INSERT INTO "personas" VALUES('1457',3,'ESTRADA ALVAREZ GONZALO ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',154903,'2011-05-02',38790,'A');
INSERT INTO "personas" VALUES('1458',1,'PAUCAR VALLEJO JAIRO ALONSO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-10-15',782860,'A');
INSERT INTO "personas" VALUES('1459',1,'RESTREPO GIRALDO JHON DARIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-04-04',797930,'A');
INSERT INTO "personas" VALUES('146',1,'BAQUERO FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2010-03-03',197650,'A');
INSERT INTO "personas" VALUES('1460',1,'RESTREPO DOMINGUEZ GUSTAVO ADOLFO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2009-05-18',641050,'A');
INSERT INTO "personas" VALUES('1461',1,'YANOVICH JACKY','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-08-21',811470,'A');
INSERT INTO "personas" VALUES('1462',1,'HINCAPIE ROLDAN JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-08-27',134200,'A');
INSERT INTO "personas" VALUES('1463',3,'ZEA JORGE OLIVER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',150699,'2011-03-12',236610,'A');
INSERT INTO "personas" VALUES('1464',1,'OSCAR MAURICIO ECHAVARRIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-11-24',780440,'A');
INSERT INTO "personas" VALUES('1465',1,'COSSIO GIL JOSE ALEXANDER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-10-01',192380,'A');
INSERT INTO "personas" VALUES('1466',1,'GOMEZ CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-03-01',620580,'A');
INSERT INTO "personas" VALUES('1467',1,'VILLALOBOS OCHOA ANDRES GABRIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-08-18',525740,'A');
INSERT INTO "personas" VALUES('1470',1,'GARCIA GONZALEZ DAVID DARIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-09-17',986990,'A');
INSERT INTO "personas" VALUES('1471',1,'RAMIREZ RESTREPO ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-04-03',162250,'A');
INSERT INTO "personas" VALUES('1472',1,'VASQUEZ GUTIERREZ JUAN ANDRES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-05',850280,'A');
INSERT INTO "personas" VALUES('1474',1,'ESCOBAR ARANGO DAVID','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-11-01',272460,'A');
INSERT INTO "personas" VALUES('1475',1,'MEJIA TORO JUAN DAVID','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-05-02',68320,'A');
INSERT INTO "personas" VALUES('1477',1,'ESCOBAR GOMEZ JUAN MANUEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127848,'2011-05-15',416150,'A');
INSERT INTO "personas" VALUES('1478',1,'BETANCUR WILSON','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2008-02-09',508060,'A');
INSERT INTO "personas" VALUES('1479',3,'ROMERO ARRAU GONZALO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-10',291880,'A');
INSERT INTO "personas" VALUES('148',1,'REINA MORENO MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-08',699240,'A');
INSERT INTO "personas" VALUES('1480',1,'CASTANO OSORIO JORGE ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127662,'2011-09-20',935200,'A');
INSERT INTO "personas" VALUES('1482',1,'LOPEZ LOPERA ROBINSON FREDY','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-09-02',196280,'A');
INSERT INTO "personas" VALUES('1484',1,'HERNAN DARIO RENDON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-03-18',312520,'A');
INSERT INTO "personas" VALUES('1485',1,'MARTINEZ ARBOLEDA MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2010-11-03',821760,'A');
INSERT INTO "personas" VALUES('1486',1,'RODRIGUEZ MORA CARLOS MORA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-09-16',171270,'A');
INSERT INTO "personas" VALUES('1487',1,'PENAGOS VASQUEZ JOSE DOMINGO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-09-06',391080,'A');
INSERT INTO "personas" VALUES('1488',1,'UERRA MEJIA DIEGO LEON','191821112','CRA 25 CALLE 100','704@hotmail.com','2011-02-03',144086,'2011-08-06',441570,'A');
INSERT INTO "personas" VALUES('1491',1,'QUINTERO GUTIERREZ ABEL PASTOR','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2009-11-16',138100,'A');
INSERT INTO "personas" VALUES('1492',1,'ALARCON YEPES IVAN DARIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',150699,'2010-05-03',145330,'A');
INSERT INTO "personas" VALUES('1494',1,'HERNANDEZ VALLEJO ANDRES MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-09',125770,'A');
INSERT INTO "personas" VALUES('1495',1,'MONTOYA MORENO LUIS MIGUEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-11-09',691770,'A');
INSERT INTO "personas" VALUES('1497',1,'BARRERA CARLOS ANDRES','191821112','CRA 25 CALLE 100','62@yahoo.es','2011-02-03',127591,'2010-08-24',332550,'A');
INSERT INTO "personas" VALUES('1498',1,'ARROYAVE FERNANDEZ PABLO EMILIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-05-12',418030,'A');
INSERT INTO "personas" VALUES('1499',1,'GOMEZ ANGEL FELIPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-05-03',92480,'A');
INSERT INTO "personas" VALUES('15',1,'AMSILI COHEN JOSEPH','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-07',877400,'A');
INSERT INTO "personas" VALUES('CELL411',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('150',3,'ARDILA GUTIERREZ DANIEL MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-12',506760,'A');
INSERT INTO "personas" VALUES('1500',1,'GONZALEZ DUQUE PABLO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-04-13',208330,'A');
INSERT INTO "personas" VALUES('1502',1,'MEJIA BUSTAMANTE JUAN FELIPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-08-09',196000,'A');
INSERT INTO "personas" VALUES('1506',1,'SUAREZ MONTOYA JUAN PABLO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128569,'2011-09-13',368250,'A');
INSERT INTO "personas" VALUES('1508',1,'ALVAREZ GONZALEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-02-15',355190,'A');
INSERT INTO "personas" VALUES('1509',1,'NIETO CORREA ANDRES FELIPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-03-31',899980,'A');
INSERT INTO "personas" VALUES('1511',1,'HERNANDEZ GRANADOS JHONATHAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-08-30',471720,'A');
INSERT INTO "personas" VALUES('1512',1,'CARDONA ALVAREZ DEIBY','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2010-10-05',55590,'A');
INSERT INTO "personas" VALUES('1513',1,'TORRES MARULANDA JUAN ESTEBAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-10-20',862820,'A');
INSERT INTO "personas" VALUES('1514',1,'RAMIREZ RAMIREZ JHON JAIRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-05-11',147310,'A');
INSERT INTO "personas" VALUES('1515',1,'MONDRAGON TORO NICOLAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-01-19',148100,'A');
INSERT INTO "personas" VALUES('1517',3,'SUIDA DIETER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2008-07-21',48580,'A');
INSERT INTO "personas" VALUES('1518',3,'LEFTWICH ANDREW PAUL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',211610,'2011-06-07',347170,'A');
INSERT INTO "personas" VALUES('1519',3,'RENTON ANDREW GEORGE PATRICK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2010-12-11',590120,'A');
INSERT INTO "personas" VALUES('152',1,'BUSTOS MONZON CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-22',335160,'A');
INSERT INTO "personas" VALUES('1521',3,'JOSE CUSTODIO DO ALTISSIMO NETONETO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',119814,'2011-04-28',775000,'A');
INSERT INTO "personas" VALUES('1522',3,'GUARACI FRANCO DE PAIVA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',119167,'2011-04-28',147770,'A');
INSERT INTO "personas" VALUES('1525',4,'MORENO TENORIO MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-20',888750,'A');
INSERT INTO "personas" VALUES('1527',1,'VELASQUEZ HERNANDEZ JHON EDUARSON','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-07-19',161270,'A');
INSERT INTO "personas" VALUES('1528',4,'VANEGAS ALEJANDRA','191821112','CRA 25 CALLE 100','185@yahoo.com','2011-02-03',127591,'2011-06-20',109830,'A');
INSERT INTO "personas" VALUES('1529',3,'BARBABE CLAIRE LAURENCE ANNICK','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-04',65330,'A');
INSERT INTO "personas" VALUES('153',1,'GONZALEZ TORREZ MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-01',762560,'A');
INSERT INTO "personas" VALUES('1530',3,'COREA MARTINEZ GUILLERMO JOSE ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',135360,'2011-09-25',997190,'A');
INSERT INTO "personas" VALUES('1531',3,'PACHECO RODRIGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117002,'2010-03-08',789960,'A');
INSERT INTO "personas" VALUES('1532',3,'WELCH RICHARD WILLIAM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',190393,'2010-10-04',958210,'A');
INSERT INTO "personas" VALUES('1533',3,'FOREMAN CAROLYN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',107159,'2011-05-23',421200,'A');
INSERT INTO "personas" VALUES('1535',3,'ZAGAL SOTO CLAUDIA PAZ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2008-05-16',893130,'A');
INSERT INTO "personas" VALUES('1536',3,'ZAGAL SOTO CLAUDIA PAZ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-10-08',771600,'A');
INSERT INTO "personas" VALUES('1538',3,'BLANCO RODRIGUEZ JUAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',197162,'2011-04-02',578250,'A');
INSERT INTO "personas" VALUES('154',1,'HENDEZ PUERTO JAVIER ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-25',807310,'A');
INSERT INTO "personas" VALUES('1540',3,'CONTRERAS BRAIN JAVIER ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-02-22',42420,'A');
INSERT INTO "personas" VALUES('1541',3,'RONDON HERNANDEZ MARYLIN DEL CARMEN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-09-29',145780,'A');
INSERT INTO "personas" VALUES('1542',3,'ELJURI RAMIREZ EMIRA ELIZABETH','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132958,'2010-10-13',601670,'A');
INSERT INTO "personas" VALUES('1544',3,'REYES LE ROY TOMAS FRANCISCO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2009-06-24',49990,'A');
INSERT INTO "personas" VALUES('1545',3,'GHETEA GAMUZ JENNY','191821112','CRA 25 CALLE 100','675@gmail.com','2011-02-03',150699,'2010-05-29',536940,'A');
INSERT INTO "personas" VALUES('1546',3,'DUARTE GONZALEZ ROONEY ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-06-20',534720,'A');
INSERT INTO "personas" VALUES('1548',3,'BIZOT PHILIPPE PIERRE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',263813,'2011-03-02',709760,'A');
INSERT INTO "personas" VALUES('1549',3,'PELUFFO RUBIO GUILLERMO JUAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',116366,'2011-05-09',360470,'A');
INSERT INTO "personas" VALUES('1550',3,'AGLIATI YERKOVIC CAROLINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2010-06-01',673040,'A');
INSERT INTO "personas" VALUES('1551',3,'SEPULVEDA LEDEZMA HENRY CORNELIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-08-15',283810,'A');
INSERT INTO "personas" VALUES('1552',3,'CABRERA CARMINE JAIME FRANCO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2008-11-30',399940,'A');
INSERT INTO "personas" VALUES('1553',3,'ZINNO PENA ALVARO ANTONIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116366,'2010-08-02',148270,'A');
INSERT INTO "personas" VALUES('1554',3,'ROMERO BUCCICARDI JUAN CRISTOBAL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-08-01',541530,'A');
INSERT INTO "personas" VALUES('1555',3,'FEFERKORN ABRAHAM','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',159312,'2011-06-12',262840,'A');
INSERT INTO "personas" VALUES('1556',3,'MASSE CATESSON CAROLINE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131272,'2011-06-12',689600,'A');
INSERT INTO "personas" VALUES('1557',3,'CATESSON ALEXANDRA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',131272,'2011-06-12',659470,'A');
INSERT INTO "personas" VALUES('1558',3,'FUENTES HERNANDEZ RICARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-18',228540,'A');
INSERT INTO "personas" VALUES('1559',3,'GUEVARA MENJIVAR WILSON ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-18',164310,'A');
INSERT INTO "personas" VALUES('1560',3,'DANOWSKI NICOLAS JAMES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-02',135920,'A');
INSERT INTO "personas" VALUES('1561',3,'CASTRO VELASQUEZ ISMAEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',121318,'2011-07-31',186670,'A');
INSERT INTO "personas" VALUES('1562',3,'RODRIGUEZ CORNEJO CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-18',525590,'A');
INSERT INTO "personas" VALUES('1563',3,'VANIA CAROLINA FLORES AVILA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-18',67950,'A');
INSERT INTO "personas" VALUES('1564',3,'ARMERO RAMOS OSCAR ALEXANDER','191821112','CRA 25 CALLE 100','414@hotmail.com','2011-02-03',127591,'2011-09-18',762950,'A');
INSERT INTO "personas" VALUES('1565',3,'ORELLANA MARTINEZ JUAN CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-18',610930,'A');
INSERT INTO "personas" VALUES('1566',3,'BRATT BABONNEAU CARLOS MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-09-14',765800,'A');
INSERT INTO "personas" VALUES('1567',3,'YANES FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150728,'2011-04-12',996200,'A');
INSERT INTO "personas" VALUES('1568',3,'ANGULO TAMAYO SEBASTIAN GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126674,'2011-05-19',683600,'A');
INSERT INTO "personas" VALUES('1569',3,'HENRIQUEZ JOSE LUIS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',138329,'2011-08-15',429390,'A');
INSERT INTO "personas" VALUES('CELL4137',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('1570',3,'GARCIA VILLARROEL RAUL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',126189,'2011-06-12',96140,'A');
INSERT INTO "personas" VALUES('1571',3,'SOLA HERNANDEZ JOSE FRANCISCO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-09-25',192530,'A');
INSERT INTO "personas" VALUES('1572',3,'PEREZ PASTOR OSWALDO MAGARREY','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126674,'2011-05-25',674260,'A');
INSERT INTO "personas" VALUES('1573',3,'MICHAN QUINONES FRANCISCO JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-06-21',793680,'A');
INSERT INTO "personas" VALUES('1574',3,'GARCIA ARANDA OSCAR DAVID','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-08-15',945620,'A');
INSERT INTO "personas" VALUES('1575',3,'GARCIA RIBAS JORDI','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-07-10',347070,'A');
INSERT INTO "personas" VALUES('1576',3,'GALVAN ROMERO MARIA INMACULADA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-09-14',898480,'A');
INSERT INTO "personas" VALUES('1577',3,'BOSH MOLINAS JUAN JOSE ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',198576,'2011-08-22',451190,'A');
INSERT INTO "personas" VALUES('1578',3,'MARTIN TENA JOSE MARIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-04-24',560520,'A');
INSERT INTO "personas" VALUES('1579',3,'HAWKINS ROBERT JAMES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-12',449010,'A');
INSERT INTO "personas" VALUES('1580',3,'GHERARDI ALEJANDRO EMILIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',180063,'2010-11-15',563500,'A');
INSERT INTO "personas" VALUES('1581',3,'TELLO JUAN EDUARDO','191821112','CRA 25 CALLE 100','192@hotmail.com','2011-02-03',138329,'2011-05-01',470460,'A');
INSERT INTO "personas" VALUES('1583',3,'GUZMAN VALDIVIA CINTIA TATIANA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',199862,'2011-04-06',897580,'A');
INSERT INTO "personas" VALUES('1584',3,'STUBBS MERCEDES CARMEN JOSEFINA DEL MILAGRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',199862,'2011-04-06',502510,'A');
INSERT INTO "personas" VALUES('1585',3,'QUINTEIRO GORIS JOSE ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-17',819840,'A');
INSERT INTO "personas" VALUES('1587',3,'RIVAS LORIA PRISCILLA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',205636,'2011-05-01',498720,'A');
INSERT INTO "personas" VALUES('1588',3,'DE LA TORRE AUGUSTO PATRICIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',20404,'2011-08-31',718670,'A');
INSERT INTO "personas" VALUES('159',1,'ALDANA PATINO NORMAN ALEXANDER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2009-10-10',201500,'A');
INSERT INTO "personas" VALUES('1590',3,'TORRES VILLAR ROBERTO ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-08-10',329950,'A');
INSERT INTO "personas" VALUES('1591',3,'PETRULLI CARMELO MORENO','191821112','CRA 25 CALLE 100','883@yahoo.com.mx','2011-02-03',127591,'2011-06-20',358180,'A');
INSERT INTO "personas" VALUES('1592',3,'MUSCO ENZO FRANCESCO GIUSEPPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-04',801050,'A');
INSERT INTO "personas" VALUES('1593',3,'RONCUZZI CLAUDIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127134,'2011-10-02',930700,'A');
INSERT INTO "personas" VALUES('1594',3,'VELANI FRANCESCA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',199862,'2011-08-22',250360,'A');
INSERT INTO "personas" VALUES('1596',3,'BENARROCH ASSOR DAVID ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-10-06',547310,'A');
INSERT INTO "personas" VALUES('1597',3,'FLO VILLASECA ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-05-27',357520,'A');
INSERT INTO "personas" VALUES('1598',3,'FONT RIBAS ANTONI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',196117,'2011-09-21',145660,'A');
INSERT INTO "personas" VALUES('1599',3,'LOPEZ BARAHONA MONICA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2011-08-03',655740,'A');
INSERT INTO "personas" VALUES('16',1,'FLOREZ PEREZ GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132572,'2011-03-30',956370,'A');
INSERT INTO "personas" VALUES('160',1,'GIRALDO MENDIVELSO MARTIN EDISSON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-14',429010,'A');
INSERT INTO "personas" VALUES('1600',3,'SCATTIATI ALDO ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',215245,'2011-07-10',841730,'A');
INSERT INTO "personas" VALUES('1601',3,'MARONE CARLO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',101179,'2011-06-14',241420,'A');
INSERT INTO "personas" VALUES('1602',3,'CHUVASHEVA ELENA ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',190393,'2011-08-21',681900,'A');
INSERT INTO "personas" VALUES('1603',3,'GIGLIO FRANCISCO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',122035,'2011-09-19',685250,'A');
INSERT INTO "personas" VALUES('1604',3,'JUSTO AMATE AGUSTIN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',174598,'2011-05-16',380560,'A');
INSERT INTO "personas" VALUES('1605',3,'GUARDABASSI FABIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',281044,'2011-07-26',847060,'A');
INSERT INTO "personas" VALUES('1606',3,'CALABRETTA FRAMCESCO ANTONIO MARIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',199862,'2011-08-22',93590,'A');
INSERT INTO "personas" VALUES('1607',3,'TARTARINI MASSIMO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',196234,'2011-05-10',926800,'A');
INSERT INTO "personas" VALUES('1608',3,'BOTTI GIAIME','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',231989,'2011-04-04',353210,'A');
INSERT INTO "personas" VALUES('1610',3,'PILERI ANDREA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',205040,'2011-09-01',868590,'A');
INSERT INTO "personas" VALUES('1612',3,'MARTIN GRACIA LUIS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-07-27',324320,'A');
INSERT INTO "personas" VALUES('1613',3,'GRACIA MARTIN LUIS','191821112','CRA 25 CALLE 100','579@facebook.com','2011-02-03',198248,'2011-08-24',463560,'A');
INSERT INTO "personas" VALUES('1614',3,'SERRAT SESE JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',196234,'2011-05-16',344840,'A');
INSERT INTO "personas" VALUES('1615',3,'DEL LAGO AMPELIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-06-29',333510,'A');
INSERT INTO "personas" VALUES('1616',3,'PERUGORRIA RODRIGUEZ JORGE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',148511,'2011-06-06',633040,'A');
INSERT INTO "personas" VALUES('1617',3,'GIRAL CALVO IGNACIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-09-19',164670,'A');
INSERT INTO "personas" VALUES('1618',3,'ALONSO CEBRIAN JOSE MARIA','191821112','CRA 25 CALLE 100','253@terra.com.co','2011-02-03',188640,'2011-03-23',924240,'A');
INSERT INTO "personas" VALUES('162',1,'ARIZA PINEDA JOHN ALEXANDER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-11-27',415710,'A');
INSERT INTO "personas" VALUES('1620',3,'OLMEDO CARDENETE DOMINGO MIGUEL','191821112','CRA 25 CALLE 100','608@terra.com.co','2011-02-03',135397,'2011-09-03',863200,'A');
INSERT INTO "personas" VALUES('1622',3,'GIMENEZ BALDRES ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',182860,'2011-05-12',82660,'A');
INSERT INTO "personas" VALUES('1623',3,'NUNEZ MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-05-23',609950,'A');
INSERT INTO "personas" VALUES('1624',3,'PENATE CASTRO WENCESLAO LORENZO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',153607,'2011-09-13',801750,'A');
INSERT INTO "personas" VALUES('1626',3,'ESCODA MIGUEL JOAN JOSEP','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-07-18',489310,'A');
INSERT INTO "personas" VALUES('1628',3,'ESTRADA CAPILLA ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-07-26',81180,'A');
INSERT INTO "personas" VALUES('163',1,'PERDOMO LOPEZ ANDRES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-05',456910,'A');
INSERT INTO "personas" VALUES('1630',3,'SUBIRAIS MARIANA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',196234,'2011-09-08',138700,'A');
INSERT INTO "personas" VALUES('1632',3,'ENSENAT VELASCO JAIME LUIS','191821112','CRA 25 CALLE 100','687@gmail.com','2011-02-03',188640,'2011-04-12',904560,'A');
INSERT INTO "personas" VALUES('1633',3,'DIEZ POLANCO CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-05-24',530410,'A');
INSERT INTO "personas" VALUES('1636',3,'CUADRA ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-09-04',688400,'A');
INSERT INTO "personas" VALUES('1637',3,'UBRIC MUNOZ RAUL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',98790,'2011-05-30',139830,'A');
INSERT INTO "personas" VALUES('CELL4159',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('1638',3,'NEDDERMANN GUJO RICARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-07-31',633990,'A');
INSERT INTO "personas" VALUES('1639',3,'RENEDO ZALBA JAIME','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-03-13',750430,'A');
INSERT INTO "personas" VALUES('164',1,'JIMENEZ PADILLA JOHAN MARCEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-05',37430,'A');
INSERT INTO "personas" VALUES('1640',3,'FERNANDEZ MORENO DAVID','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-05-28',850180,'A');
INSERT INTO "personas" VALUES('1641',3,'VERGARA SERRANO JUAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-06-30',999620,'A');
INSERT INTO "personas" VALUES('1642',3,'MARTINEZ HUESO LUCAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',182860,'2011-06-29',447570,'A');
INSERT INTO "personas" VALUES('1643',3,'FRANCO POBLET JUAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',196234,'2011-10-03',238990,'A');
INSERT INTO "personas" VALUES('1644',3,'MORA HIDALGO MIGUEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-06',852250,'A');
INSERT INTO "personas" VALUES('1645',3,'GARCIA COSO EMILIANO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-09-14',544260,'A');
INSERT INTO "personas" VALUES('1646',3,'GIMENO ESCRIG ENRIQUE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',180124,'2011-09-20',164580,'A');
INSERT INTO "personas" VALUES('1647',3,'MORCILLO LOPEZ RAMON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127538,'2011-04-16',190090,'A');
INSERT INTO "personas" VALUES('1648',3,'RUBIO BONET MANUEL','191821112','CRA 25 CALLE 100','252@facebook.com','2011-02-03',196234,'2011-05-25',456740,'A');
INSERT INTO "personas" VALUES('1649',3,'PRADO ABUIN FERNANDO ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-07-16',713400,'A');
INSERT INTO "personas" VALUES('165',1,'RAMIREZ PALMA LUIS FELIPE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-10',816420,'A');
INSERT INTO "personas" VALUES('1650',3,'DE VEGA PUJOL GEMA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-08-01',196780,'A');
INSERT INTO "personas" VALUES('1651',3,'IBARGUEN ALFREDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2010-12-03',843720,'A');
INSERT INTO "personas" VALUES('1652',3,'IBARGUEN ALFREDO','191821112','CRA 25 CALLE 100','856@hotmail.com','2011-02-03',188640,'2011-06-18',628250,'A');
INSERT INTO "personas" VALUES('1654',3,'MATELLANES RODRIGUEZ NURIA PILAR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-10-05',165770,'A');
INSERT INTO "personas" VALUES('1656',3,'VIDAURRAZAGA GUISOLA JUAN ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2011-08-08',495320,'A');
INSERT INTO "personas" VALUES('1658',3,'GOMEZ ULLATE MARIA ELENA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-04-12',919090,'A');
INSERT INTO "personas" VALUES('1659',3,'ALCAIDE ALONSO JUAN MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-05-02',152430,'A');
INSERT INTO "personas" VALUES('166',1,'TUSTANOSKI RODOLFO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-12-03',969790,'A');
INSERT INTO "personas" VALUES('1660',3,'LARROY GARCIA CRISTINA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-09-14',4900,'A');
INSERT INTO "personas" VALUES('1661',3,'FERNANDEZ POYATO ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-09-10',567180,'A');
INSERT INTO "personas" VALUES('1662',3,'TREVEJO PARDO JULIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-25',821200,'A');
INSERT INTO "personas" VALUES('1663',3,'GORGA CASSINELLI VICTOR DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-05-30',404490,'A');
INSERT INTO "personas" VALUES('1664',3,'MORUECO GONZALEZ JOSE ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-10-09',558820,'A');
INSERT INTO "personas" VALUES('1665',3,'IRURETA FERNANDEZ PEDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',214283,'2011-09-14',580650,'A');
INSERT INTO "personas" VALUES('1667',3,'TREVEJO PARDO JUAN ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-25',392020,'A');
INSERT INTO "personas" VALUES('1668',3,'BOCOS NUNEZ MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',196234,'2011-10-08',279710,'A');
INSERT INTO "personas" VALUES('1669',3,'LUIS CASTILLO JOSE AGUSTIN','191821112','CRA 25 CALLE 100','557@hotmail.es','2011-02-03',168202,'2011-06-16',222500,'A');
INSERT INTO "personas" VALUES('167',1,'HURTADO BELALCAZAR JOHN JADY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127300,'2011-08-17',399710,'A');
INSERT INTO "personas" VALUES('1670',3,'REDONDO GUTIERREZ EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-09-14',273350,'A');
INSERT INTO "personas" VALUES('1671',3,'MADARIAGA ALONSO RAMON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2011-07-26',699240,'A');
INSERT INTO "personas" VALUES('1673',3,'REY GONZALEZ LUIS JAVIER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-07-26',283190,'A');
INSERT INTO "personas" VALUES('1676',3,'PEREZ ESTER ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-10-03',274900,'A');
INSERT INTO "personas" VALUES('1677',3,'GOMEZ-GRACIA HUERTA ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-09-22',112260,'A');
INSERT INTO "personas" VALUES('1678',3,'DAMASO PUENTE DIEGO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-05-25',736600,'A');
INSERT INTO "personas" VALUES('168',1,'JUAN PABLO MARTINEZ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-08-15',89160,'A');
INSERT INTO "personas" VALUES('1680',3,'DIEZ GONZALEZ LUIS MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-05-17',521280,'A');
INSERT INTO "personas" VALUES('1681',3,'LOPEZ LOPEZ JOSE LUIS','191821112','CRA 25 CALLE 100','853@yahoo.com','2011-02-03',196234,'2010-12-13',567760,'A');
INSERT INTO "personas" VALUES('1682',3,'MIRO LINARES FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133442,'2011-09-03',274930,'A');
INSERT INTO "personas" VALUES('1683',3,'ROCA PINTADO MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-05-16',671410,'A');
INSERT INTO "personas" VALUES('1684',3,'GARCIA BARTOLOME HORACIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-09-29',532220,'A');
INSERT INTO "personas" VALUES('1686',3,'BALMASEDA DE AHUMADA DIEZ JUAN LUIS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',168202,'2011-04-13',637860,'A');
INSERT INTO "personas" VALUES('1687',3,'FERNANDEZ IMAZ FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-04-10',248580,'A');
INSERT INTO "personas" VALUES('1688',3,'ELIAS CASTELLS FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-05-19',329300,'A');
INSERT INTO "personas" VALUES('1689',3,'ANIDO DIAZ DANIEL','191821112','CRA 25 CALLE 100','491@gmail.com','2011-02-03',188640,'2011-04-04',900780,'A');
INSERT INTO "personas" VALUES('1691',3,'GATELL ARIMONT MARIA CRISTINA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',196234,'2011-09-17',877700,'A');
INSERT INTO "personas" VALUES('1692',3,'RIVERA MUNOZ ADONI','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',211705,'2011-04-05',840470,'A');
INSERT INTO "personas" VALUES('1693',3,'LUNA LOPEZ ALICIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-10-01',569270,'A');
INSERT INTO "personas" VALUES('1695',3,'HAMMOND ANN ELIZABETH','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118021,'2011-05-17',916770,'A');
INSERT INTO "personas" VALUES('1698',3,'RODRIGUEZ PARAJA MARIA CRISTINA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-07-15',649080,'A');
INSERT INTO "personas" VALUES('1699',3,'RUIZ DIAZ JOSE IGNACIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-06-24',359540,'A');
INSERT INTO "personas" VALUES('17',1,'SUAREZ CUEVAS FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',129499,'2011-08-31',149640,'A');
INSERT INTO "personas" VALUES('170',1,'MARROQUIN AVILA FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-04',965840,'A');
INSERT INTO "personas" VALUES('1700',3,'BACCHELLI ORTEGA JOSE MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',126180,'2011-06-07',850450,'A');
INSERT INTO "personas" VALUES('1701',3,'IGLESIAS JOSE IGNACIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2010-09-14',173630,'A');
INSERT INTO "personas" VALUES('1702',3,'GUTIEZ CUEVAS JULIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2010-09-07',316800,'A');
INSERT INTO "personas" VALUES('CELL4183',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('1704',3,'CALDEIRO ZAMORA JESUS CARMELO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-05-09',365230,'A');
INSERT INTO "personas" VALUES('1705',3,'ARBONA ABASCAL MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-02-27',636760,'A');
INSERT INTO "personas" VALUES('1706',3,'COHEN AMAR MOISES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196766,'2011-05-20',88120,'A');
INSERT INTO "personas" VALUES('1708',3,'FERNANDEZ COBOS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2010-11-09',387220,'A');
INSERT INTO "personas" VALUES('1709',3,'CANAL VIVES JOAQUIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',196234,'2011-09-27',345150,'A');
INSERT INTO "personas" VALUES('171',1,'LADINO MORENO JAVIER ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-25',89230,'A');
INSERT INTO "personas" VALUES('1710',5,'GARCIA BERTRAND HECTOR','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-04-07',564100,'A');
INSERT INTO "personas" VALUES('1711',1,'CONSTANZA MARIN ESCOBAR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127799,'2011-03-24',785060,'A');
INSERT INTO "personas" VALUES('1712',1,'NUNEZ BATALLA FAUSTINO JORGE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-26',232970,'A');
INSERT INTO "personas" VALUES('1713',3,'VILORA LAZARO ERICK MARTIN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-26',809690,'A');
INSERT INTO "personas" VALUES('1715',3,'ELLIOT EDWARD JAMES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-26',318660,'A');
INSERT INTO "personas" VALUES('1716',3,'ALCALDE ORTENO MAURICIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117002,'2011-07-23',544650,'A');
INSERT INTO "personas" VALUES('1717',3,'CIARAVELLA STEFANO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',231989,'2011-06-13',767260,'A');
INSERT INTO "personas" VALUES('1718',3,'URRA GONZALEZ PEDRO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-05-02',202370,'A');
INSERT INTO "personas" VALUES('172',1,'GUERRERO ERNESTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-15',548610,'A');
INSERT INTO "personas" VALUES('1720',3,'JIMENEZ RODRIGUEZ ANNET','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-05-25',943140,'A');
INSERT INTO "personas" VALUES('1721',3,'LESCAY CASTELLANOS ARNALDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-09-14',585570,'A');
INSERT INTO "personas" VALUES('1722',3,'OCHOA AGUILAR ELIADES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-25',98410,'A');
INSERT INTO "personas" VALUES('1723',3,'RODRIGUEZ NUNES JOSE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-25',735340,'A');
INSERT INTO "personas" VALUES('1724',3,'OCHOA BUSTAMANTE ELIADES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-25',381480,'A');
INSERT INTO "personas" VALUES('1725',3,'MARTINEZ NIEVES JOSE ANGEL','191821112','CRA 25 CALLE 100','919@yahoo.es','2011-02-03',127591,'2011-05-25',701360,'A');
INSERT INTO "personas" VALUES('1727',3,'DRAGONI ALAIN ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-25',707850,'A');
INSERT INTO "personas" VALUES('1728',3,'FERNANDEZ LOPEZ MARCOS ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-25',452090,'A');
INSERT INTO "personas" VALUES('1729',3,'MATURELL ROMERO JORGE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-25',136880,'A');
INSERT INTO "personas" VALUES('173',1,'RUIZ CEBALLOS ALEXANDER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-04',475380,'A');
INSERT INTO "personas" VALUES('1730',3,'LARA CASTELLANO LENNIS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-25',328150,'A');
INSERT INTO "personas" VALUES('1731',3,'GRAHAM CRISTOPHER DRAKE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',203079,'2011-06-27',230120,'A');
INSERT INTO "personas" VALUES('1732',3,'TORRE LUCA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-05-11',166120,'A');
INSERT INTO "personas" VALUES('1733',3,'OCHOA HIDALGO EGLIS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-25',140250,'A');
INSERT INTO "personas" VALUES('1734',3,'LOURERIO DELACROIX FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116511,'2011-09-28',202900,'A');
INSERT INTO "personas" VALUES('1736',3,'LEVIN FIORELLI ANDRES','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',116366,'2011-08-07',360110,'A');
INSERT INTO "personas" VALUES('1739',3,'BERRY R ALBERT','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',216125,'2011-08-16',22170,'A');
INSERT INTO "personas" VALUES('174',1,'NIETO PARRA SEBASTIAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-05-11',731040,'A');
INSERT INTO "personas" VALUES('1740',3,'MARSHALL ROBERT SHEPARD','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',150159,'2011-03-09',62860,'A');
INSERT INTO "personas" VALUES('1741',3,'HENANDEZ ROY CHRISTOPHER JOHN PATRICK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',179614,'2011-09-26',247780,'A');
INSERT INTO "personas" VALUES('1742',3,'LANDRY GUILLAUME','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',232263,'2011-04-27',50330,'A');
INSERT INTO "personas" VALUES('1743',3,'VUCETIC ZELJKO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',232263,'2011-07-25',508320,'A');
INSERT INTO "personas" VALUES('1744',3,'DE JUANA CELASCO MARIA DEL CARMEN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-04-16',390620,'A');
INSERT INTO "personas" VALUES('1745',3,'LABONTE RONALD','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',269033,'2011-09-28',428120,'A');
INSERT INTO "personas" VALUES('1746',3,'NEWMAN PHILIP MARK','191821112','CRA 25 CALLE 100','557@gmail.com','2011-02-03',231373,'2011-07-25',968750,'A');
INSERT INTO "personas" VALUES('1747',3,'GRENIER MARIE PIERRE ','191821112','CRA 25 CALLE 100','409@facebook.com','2011-02-03',244158,'2011-07-03',559370,'A');
INSERT INTO "personas" VALUES('1749',3,'SHINDER GARY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',244158,'2011-07-25',775000,'A');
INSERT INTO "personas" VALUES('175',3,'GALLEGOS BASTIDAS CARLOS EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133211,'2011-08-10',229090,'A');
INSERT INTO "personas" VALUES('1750',3,'LOPEZ DE GOICOCHEA ZABALA FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-09-13',203120,'A');
INSERT INTO "personas" VALUES('1751',3,'CORRAL BELLON MANUEL','191821112','CRA 25 CALLE 100','538@yahoo.com','2011-02-03',177443,'2011-05-02',690610,'A');
INSERT INTO "personas" VALUES('1752',3,'DE SOLA SOLVAS JUAN ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-10-02',843700,'A');
INSERT INTO "personas" VALUES('1753',3,'GARCIA ALCALA DIAZ REGANON EVA MARIA','191821112','CRA 25 CALLE 100','398@yahoo.com','2011-02-03',118777,'2010-03-15',146680,'A');
INSERT INTO "personas" VALUES('1754',3,'BIELA VILIAM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132958,'2011-08-16',202290,'A');
INSERT INTO "personas" VALUES('1755',3,'GUIOT CANO JUAN PATRICK','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',232263,'2011-05-23',571390,'A');
INSERT INTO "personas" VALUES('1756',3,'JIMENEZ DIAZ LUIS MIGUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-03-27',250100,'A');
INSERT INTO "personas" VALUES('1757',3,'FOX ELEANORE MAE','191821112','CRA 25 CALLE 100','117@yahoo.com','2011-02-03',190393,'2011-05-04',536340,'A');
INSERT INTO "personas" VALUES('1758',3,'TANG VAN SON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2011-05-07',931400,'A');
INSERT INTO "personas" VALUES('1759',3,'SUTTON PETER RONALD','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',281673,'2011-06-01',47960,'A');
INSERT INTO "personas" VALUES('176',1,'GOMEZ IVAN','191821112','CRA 25 CALLE 100','438@yahoo.com.mx','2011-02-03',127591,'2008-04-09',952310,'A');
INSERT INTO "personas" VALUES('1762',3,'STOODY MATTHEW FRANCIS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-21',84320,'A');
INSERT INTO "personas" VALUES('1763',3,'SEIX MASO ARNAU','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',150699,'2011-05-24',168880,'A');
INSERT INTO "personas" VALUES('1764',3,'FERNANDEZ REDEL RAQUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-09-14',591440,'A');
INSERT INTO "personas" VALUES('1765',3,'PORCAR DESCALS VICENNTE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',176745,'2011-04-24',450580,'A');
INSERT INTO "personas" VALUES('1766',3,'PEREZ DE VILLEGAS TRILLO FIGUEROA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',196234,'2011-05-17',478560,'A');
INSERT INTO "personas" VALUES('CELL4198',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('1767',3,'CELDRAN DEGANO ANGEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',196234,'2011-05-17',41040,'A');
INSERT INTO "personas" VALUES('1768',3,'TERRAGO MARI FERRAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-09-30',769550,'A');
INSERT INTO "personas" VALUES('1769',3,'SZUCHOVSZKY GERGELY','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',250256,'2011-05-23',724630,'A');
INSERT INTO "personas" VALUES('177',1,'SEBASTIAN TORO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127443,'2011-07-14',74270,'A');
INSERT INTO "personas" VALUES('1771',3,'TORIBIO JOSE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',226612,'2011-09-04',398570,'A');
INSERT INTO "personas" VALUES('1772',3,'JOSE LUIS BAQUERA PEIRONCELLY','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2010-10-19',49360,'A');
INSERT INTO "personas" VALUES('1773',3,'MADARIAGA VILLANUEVA MIGUEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-04-12',51090,'A');
INSERT INTO "personas" VALUES('1774',3,'VILLENA BORREGO ANTONIO','191821112','CRA 25 CALLE 100','830@terra.com.co','2011-02-03',188640,'2011-07-19',107400,'A');
INSERT INTO "personas" VALUES('1776',3,'VILAR VILLALBA JOSE LUIS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',180124,'2011-09-20',596330,'A');
INSERT INTO "personas" VALUES('1777',3,'CAGIGAL ORTIZ MACARENA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',214283,'2011-09-14',830530,'A');
INSERT INTO "personas" VALUES('1778',3,'KORBA ATTILA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',250256,'2011-09-27',363650,'A');
INSERT INTO "personas" VALUES('1779',3,'KORBA-ELIAS BARBARA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',250256,'2011-09-27',326670,'A');
INSERT INTO "personas" VALUES('178',1,'AMSILI COHEN HANAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-08-29',514450,'A');
INSERT INTO "personas" VALUES('1780',3,'PINDADO GOMEZ JESUS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',189053,'2011-04-26',542400,'A');
INSERT INTO "personas" VALUES('1781',3,'IBARRONDO GOMEZ GRACIA ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-09-21',731990,'A');
INSERT INTO "personas" VALUES('1782',3,'MUNGUIRA GONZALEZ JUAN JULIAN','191821112','CRA 25 CALLE 100','54@hotmail.es','2011-02-03',188640,'2011-09-06',32730,'A');
INSERT INTO "personas" VALUES('1784',3,'LANDMAN PIETER MARINUS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',294861,'2011-09-22',740260,'A');
INSERT INTO "personas" VALUES('1789',3,'SUAREZ AINARA ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-05-17',503470,'A');
INSERT INTO "personas" VALUES('179',1,'CARO JUNCO GUIOVANNY','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-03',349420,'A');
INSERT INTO "personas" VALUES('1790',3,'MARTINEZ CHACON JOSE JOAQUIN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-05-20',592220,'A');
INSERT INTO "personas" VALUES('1792',3,'MENDEZ DEL RION LUCIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',120639,'2011-06-16',476910,'A');
INSERT INTO "personas" VALUES('1793',3,'VERHULST LAMBERTUS  CORNELIA FRANCISCUS ALPHONSUS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',295420,'2011-07-04',32410,'A');
INSERT INTO "personas" VALUES('1794',3,'YANEZ YAGUE JESUS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-07-10',731290,'A');
INSERT INTO "personas" VALUES('1796',3,'GOMEZ ZORRILLA AMATE JOSE MARIOA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2011-07-12',602380,'A');
INSERT INTO "personas" VALUES('1797',3,'LAIZ MORENO ENEKO','191821112','CRA 25 CALLE 100','219@gmail.com','2011-02-03',127591,'2011-08-05',334150,'A');
INSERT INTO "personas" VALUES('1798',3,'MORODO RUIZ RUBEN DAVID','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-09-14',863620,'A');
INSERT INTO "personas" VALUES('18',1,'GARZON VARGAS GUILLERMO FEDERICO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-29',879110,'A');
INSERT INTO "personas" VALUES('1800',3,'ALFARO FAUS MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-09-14',987410,'A');
INSERT INTO "personas" VALUES('1801',3,'MORRALLA VALLVERDU ENRIC','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',194601,'2011-07-18',990070,'A');
INSERT INTO "personas" VALUES('1802',3,'BALBASTRE TEJEDOR JUAN VICENTE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',182860,'2011-08-24',988120,'A');
INSERT INTO "personas" VALUES('1803',3,'MINGO REIZ FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2010-03-24',970400,'A');
INSERT INTO "personas" VALUES('1804',3,'IRURETA FERNANDEZ JOSE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',214283,'2011-09-10',887630,'A');
INSERT INTO "personas" VALUES('1807',3,'NEBRO MELLADO JOSE JUAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',168996,'2011-08-15',278540,'A');
INSERT INTO "personas" VALUES('1808',3,'ALBERQUILLA OJEDA JOSE DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-09-27',477070,'A');
INSERT INTO "personas" VALUES('1809',3,'BUENDIA NORTE MARIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',131401,'2011-07-08',549720,'A');
INSERT INTO "personas" VALUES('181',1,'CASTELLANOS FLORES RODRIGO ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-18',970470,'A');
INSERT INTO "personas" VALUES('1811',3,'HILBERT ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',196234,'2011-09-08',937830,'A');
INSERT INTO "personas" VALUES('1812',3,'GONZALES PINTO COTERILLO ADOLFO LORENZO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',214283,'2011-09-10',736970,'A');
INSERT INTO "personas" VALUES('1813',3,'ARQUES ALVAREZ JOSE RICARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-04-04',871360,'A');
INSERT INTO "personas" VALUES('1817',3,'CLAUSELL LOW ROBERTO EMILIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132775,'2011-09-28',348770,'A');
INSERT INTO "personas" VALUES('1818',3,'BELICHON MARTINEZ JESUS ALVARO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-04-12',327010,'A');
INSERT INTO "personas" VALUES('182',1,'GUZMAN NIETO JOSE MARIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-20',241130,'A');
INSERT INTO "personas" VALUES('1821',3,'LINATI DE PUIG JORGE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',196234,'2011-05-18',47210,'A');
INSERT INTO "personas" VALUES('1823',3,'SINBARRERA ROMA ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',196234,'2011-09-08',598380,'A');
INSERT INTO "personas" VALUES('1826',2,'JUANES GARATE BRUNO ','191821112','CRA 25 CALLE 100','301@gmail.com','2011-02-03',118777,'2011-08-21',877650,'A');
INSERT INTO "personas" VALUES('1827',3,'BOLOS GIMENO ROGELIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',200247,'2010-11-28',555470,'A');
INSERT INTO "personas" VALUES('1828',3,'ZABALA ASTIGARRAGA JOSE MARIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2011-09-20',144410,'A');
INSERT INTO "personas" VALUES('1831',3,'MAPELLI CAFFARENA BORJA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',172381,'2011-09-04',58200,'A');
INSERT INTO "personas" VALUES('1833',3,'LARMONIE LESLIE MARTIN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-30',604840,'A');
INSERT INTO "personas" VALUES('1834',3,'WILLEMS ROBERT-JAN MICHAEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',288531,'2011-09-05',756530,'A');
INSERT INTO "personas" VALUES('1835',3,'ANJEMA LAURENS JAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-08-29',968140,'A');
INSERT INTO "personas" VALUES('1836',3,'VERHULST HENRICUS LAMBERTUS MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',295420,'2011-04-03',571100,'A');
INSERT INTO "personas" VALUES('1837',3,'PIERROT JOZEF MARIE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',288733,'2011-05-18',951100,'A');
INSERT INTO "personas" VALUES('1838',3,'EIKELBOOM HIDDE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-02',42210,'A');
INSERT INTO "personas" VALUES('1839',3,'TAMBINI GOMEZ DE MUNG','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',180063,'2011-04-24',357740,'A');
INSERT INTO "personas" VALUES('1840',3,'MAGANA PEREZ GERARDO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',135360,'2011-09-28',662060,'A');
INSERT INTO "personas" VALUES('1841',3,'COURTOISIE BEYHAUT RAFAEL JUAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',116366,'2011-09-05',237070,'A');
INSERT INTO "personas" VALUES('1842',3,'ROJAS BENJAMIN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-13',199170,'A');
INSERT INTO "personas" VALUES('1843',3,'GARCIA VICENTE EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',150699,'2011-08-10',284650,'A');
INSERT INTO "personas" VALUES('CELL4291',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('1844',3,'CESTTI LOPEZ RAFAEL GUSTAVO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',144215,'2011-09-27',825750,'A');
INSERT INTO "personas" VALUES('1845',3,'URTECHO LOPEZ ARMANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',139272,'2011-09-28',274800,'A');
INSERT INTO "personas" VALUES('1846',3,'SEGURA ESPINOZA ARMANDO SEBASTIAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',135360,'2011-09-28',896730,'A');
INSERT INTO "personas" VALUES('1847',3,'GONZALEZ VEGA LUIS PASTOR','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',135360,'2011-05-18',659240,'A');
INSERT INTO "personas" VALUES('185',1,'AYALA CARDENAS NELSON MAURICIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-25',855960,'A');
INSERT INTO "personas" VALUES('1850',3,'ROTZINGER ROA KLAUS ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',116366,'2011-09-12',444250,'A');
INSERT INTO "personas" VALUES('1851',3,'FRANCO DE LEON SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',116366,'2011-04-26',63840,'A');
INSERT INTO "personas" VALUES('1852',3,'RIVAS GAGNONI LUIS ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',135360,'2011-05-18',986440,'A');
INSERT INTO "personas" VALUES('1853',3,'BARRETO VELASQUEZ JOEL FERNANDO','191821112','CRA 25 CALLE 100','104@hotmail.es','2011-02-03',116511,'2011-04-27',740670,'A');
INSERT INTO "personas" VALUES('1854',3,'SEVILLA AMAYA ORLANDO','191821112','CRA 25 CALLE 100','264@yahoo.com','2011-02-03',136995,'2011-05-18',744020,'A');
INSERT INTO "personas" VALUES('1855',3,'VALFRE BRALICH ELEONORA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',116366,'2011-06-06',498080,'A');
INSERT INTO "personas" VALUES('1857',3,'URDANETA DIAMANTES DIEGO ANDRES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-09-23',797590,'A');
INSERT INTO "personas" VALUES('1858',3,'RAMIREZ ALVARADO ROBERT JESUS','191821112','CRA 25 CALLE 100','290@yahoo.com.mx','2011-02-03',127591,'2011-09-18',212850,'A');
INSERT INTO "personas" VALUES('1859',3,'GUTTNER DENNIS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-25',671470,'A');
INSERT INTO "personas" VALUES('186',1,'CARRASCO SUESCUN ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-15',36620,'A');
INSERT INTO "personas" VALUES('1861',3,'HEGEMANN JOACHIM','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-25',579710,'A');
INSERT INTO "personas" VALUES('1862',3,'MALCHER INGO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',292243,'2011-06-23',742060,'A');
INSERT INTO "personas" VALUES('1864',3,'HOFFMEISTER MALTE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128206,'2011-09-06',629770,'A');
INSERT INTO "personas" VALUES('1865',3,'BOHME ALEXANDRA LUCE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-14',235260,'A');
INSERT INTO "personas" VALUES('1866',3,'HAMMAN FRANK THOMAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-13',286980,'A');
INSERT INTO "personas" VALUES('1867',3,'GOPPERT MARKUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-09-05',729150,'A');
INSERT INTO "personas" VALUES('1868',3,'BISCARO CAROLINA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-09-16',784790,'A');
INSERT INTO "personas" VALUES('1869',3,'MASCHAT SEBASTIAN STEPHAN ANDREAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-02-03',736520,'A');
INSERT INTO "personas" VALUES('1870',3,'WALTHER DANIEL CLAUS PETER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-24',328220,'A');
INSERT INTO "personas" VALUES('1871',3,'NENTWIG DANIEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',289697,'2011-02-03',431550,'A');
INSERT INTO "personas" VALUES('1872',3,'KARUTZ ALEX','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127662,'2011-03-17',173090,'A');
INSERT INTO "personas" VALUES('1875',3,'KAY KUNNE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',289697,'2011-03-18',961400,'A');
INSERT INTO "personas" VALUES('1876',2,'SCHLUMPF IVANA PATRICIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',245206,'2011-03-28',802690,'A');
INSERT INTO "personas" VALUES('1877',3,'RODRIGUEZ BUSTILLO CONSUELO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',139067,'2011-03-21',129280,'A');
INSERT INTO "personas" VALUES('1878',1,'REHWALDT RICHARD ULRICH','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',289697,'2009-10-25',238320,'A');
INSERT INTO "personas" VALUES('1880',3,'FONSECA BEHRENS MANUELA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150699,'2011-08-18',303810,'A');
INSERT INTO "personas" VALUES('1881',3,'VOGEL MIRKO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-09',107790,'A');
INSERT INTO "personas" VALUES('1882',3,'WU WEI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',289697,'2011-03-04',627520,'A');
INSERT INTO "personas" VALUES('1884',3,'KADOLSKY ANKE SIGRID','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',289697,'2010-10-07',188560,'A');
INSERT INTO "personas" VALUES('1885',3,'PFLUCKER PLENGE CARLOS HERNAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',239124,'2011-08-15',500140,'A');
INSERT INTO "personas" VALUES('1886',3,'PENA LAGOS MELENIA PATRICIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-18',935020,'A');
INSERT INTO "personas" VALUES('1887',3,'CALVANO MARCO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2011-05-02',174690,'A');
INSERT INTO "personas" VALUES('1888',3,'KUHLEN LOTHAR WILHELM','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',289232,'2011-08-30',68390,'A');
INSERT INTO "personas" VALUES('1889',3,'QUIJANO RICO SOFIA VICTORIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',221939,'2011-06-13',817890,'A');
INSERT INTO "personas" VALUES('189',1,'GOMEZ TRUJILLO SERGIO ANDRES','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-17',985980,'A');
INSERT INTO "personas" VALUES('1890',3,'SCHILBERZ KARIN','191821112','CRA 25 CALLE 100','405@facebook.com','2011-02-03',287570,'2011-06-23',884260,'A');
INSERT INTO "personas" VALUES('1891',3,'SCHILBERZ SOPHIE CAHRLOTTE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',287570,'2011-06-23',967640,'A');
INSERT INTO "personas" VALUES('1892',3,'MOLINA MOLINA MILAGRO DE SUYAPA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',139844,'2011-07-26',185410,'A');
INSERT INTO "personas" VALUES('1893',3,'BARRIENTOS ESCALANTE RAFAEL ALVARO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',139067,'2011-05-18',24110,'A');
INSERT INTO "personas" VALUES('1895',3,'ENGELS FRANZBERNARD','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',292243,'2011-07-01',749430,'A');
INSERT INTO "personas" VALUES('1896',3,'FRIEDHOFF SVEN WILHEM','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',289697,'2010-10-31',54090,'A');
INSERT INTO "personas" VALUES('1897',3,'BARTELS CHRISTIAN JOHAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2011-07-25',22160,'A');
INSERT INTO "personas" VALUES('1898',3,'NILS REMMEL','191821112','CRA 25 CALLE 100','214@gmail.com','2011-02-03',256231,'2011-08-05',948530,'A');
INSERT INTO "personas" VALUES('1899',3,'DR SCHEIBE MATTHIAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',252431,'2011-09-26',676150,'A');
INSERT INTO "personas" VALUES('19',1,'RIANO ROMERO ALBERTO ELIAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-12-14',946630,'A');
INSERT INTO "personas" VALUES('190',1,'LLOREDA ORTIZ FELIPE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-12-20',30860,'A');
INSERT INTO "personas" VALUES('1900',3,'CARRASCO CATERIANO PEDRO','191821112','CRA 25 CALLE 100','255@hotmail.com','2011-02-03',286578,'2011-05-02',535180,'A');
INSERT INTO "personas" VALUES('1901',3,'ROSENBER DIRK PETER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-29',647450,'A');
INSERT INTO "personas" VALUES('1902',3,'LAUBACH JOHANNES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',289697,'2011-05-01',631720,'A');
INSERT INTO "personas" VALUES('1904',3,'GRUND STEFAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',256231,'2011-08-05',185990,'A');
INSERT INTO "personas" VALUES('1905',3,'GRUND BEATE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',256231,'2011-08-05',281280,'A');
INSERT INTO "personas" VALUES('1906',3,'CORZO PAULA MIRIANA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',180063,'2011-08-02',848400,'A');
INSERT INTO "personas" VALUES('1907',3,'OESTERHAUS CORNELIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',256231,'2011-03-16',398170,'A');
INSERT INTO "personas" VALUES('1908',1,'JUAN SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127300,'2011-05-12',445660,'A');
INSERT INTO "personas" VALUES('1909',3,'VAN ZIJL CHRISTIAN ANDREAS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',286785,'2011-09-24',33800,'A');
INSERT INTO "personas" VALUES('191',1,'CASTANEDA CABALLERO JUAN MANUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-28',196370,'A');
INSERT INTO "personas" VALUES('1910',3,'LORZA RUIZ MYRIAM ESPERANZA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-29',831990,'A');
INSERT INTO "personas" VALUES('192',1,'ZEA EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-09',889270,'A');
INSERT INTO "personas" VALUES('193',1,'VELEZ VICTOR MANUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-10-22',857250,'A');
INSERT INTO "personas" VALUES('194',1,'ARCINIEGAS GOMEZ ISMAEL','191821112','CRA 25 CALLE 100','937@hotmail.com','2011-02-03',127591,'2011-05-18',618450,'A');
INSERT INTO "personas" VALUES('195',1,'LINAREZ PEDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-12',520470,'A');
INSERT INTO "personas" VALUES('1952',3,'BERND ERNST HEINZ SCHUNEMANN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',255673,'2011-09-04',796820,'A');
INSERT INTO "personas" VALUES('1953',3,'BUCHNER RICHARD ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-17',808430,'A');
INSERT INTO "personas" VALUES('1954',3,'CHO YONG BEOM','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',173192,'2011-02-07',651670,'A');
INSERT INTO "personas" VALUES('1955',3,'BERNECKER WALTER LUDWIG','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',256231,'2011-04-03',833080,'A');
INSERT INTO "personas" VALUES('1956',3,'SCHIERENBECK THOMAS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',256231,'2011-05-03',210380,'A');
INSERT INTO "personas" VALUES('1957',3,'STEGMANN WOLF DIETER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-08-27',552650,'A');
INSERT INTO "personas" VALUES('1958',3,'LEBAGE GONZALEZ VALENTINA CECILIA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',131272,'2011-07-29',132130,'A');
INSERT INTO "personas" VALUES('1959',3,'CABRERA MACCHI JOSE ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',180063,'2011-08-02',2700,'A');
INSERT INTO "personas" VALUES('196',1,'OTERO BERNAL ALVARO ERNESTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-04-29',747030,'A');
INSERT INTO "personas" VALUES('1960',3,'KOO BONKI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-15',617110,'A');
INSERT INTO "personas" VALUES('1961',3,'JODJAHN DE CARVALHO BEIRAL FLAVIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-07-05',77460,'A');
INSERT INTO "personas" VALUES('1963',3,'VIEIRA ROCHA MARQUES ELIANE TEREZINHA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118402,'2011-09-13',447430,'A');
INSERT INTO "personas" VALUES('1965',3,'KELLEN CRISTINA GATTI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',126180,'2011-07-01',804020,'A');
INSERT INTO "personas" VALUES('1966',3,'CHAVEZ MARLON TENORIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',120773,'2011-07-25',132310,'A');
INSERT INTO "personas" VALUES('1967',3,'SERGIO COZZI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',125750,'2011-08-28',249500,'A');
INSERT INTO "personas" VALUES('1968',3,'REZENDE LIMA JOSE MARCIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-08-23',850570,'A');
INSERT INTO "personas" VALUES('1969',3,'RAMOS PEDRO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118942,'2011-08-03',504330,'A');
INSERT INTO "personas" VALUES('1972',3,'ADAMS THOMAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118942,'2011-08-11',774000,'A');
INSERT INTO "personas" VALUES('1973',3,'WALESKA NUCINI BOGO ANDREA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-23',859690,'A');
INSERT INTO "personas" VALUES('1974',3,'GERMANO PAULO BUNN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118439,'2011-08-30',976440,'A');
INSERT INTO "personas" VALUES('1975',3,'CALDEIRA FILHO RUBENS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118942,'2011-07-18',303120,'A');
INSERT INTO "personas" VALUES('1976',3,'JOSE CUSTODIO DO ALTISSIMO NETONETO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',119814,'2011-09-08',586290,'A');
INSERT INTO "personas" VALUES('1977',3,'GAMAS MARIA CRISTINA ALVES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-09-19',22070,'A');
INSERT INTO "personas" VALUES('1979',3,'PORTO WEBER FERREIRA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-07',691340,'A');
INSERT INTO "personas" VALUES('1980',3,'FONSECA LAURO PINTO','191821112','CRA 25 CALLE 100','104@hotmail.es','2011-02-03',127591,'2011-08-16',402140,'A');
INSERT INTO "personas" VALUES('1981',3,'DUARTE ELENA CECILIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-06-15',936710,'A');
INSERT INTO "personas" VALUES('1983',3,'CECHINEL CRISTIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118942,'2011-06-12',575530,'A');
INSERT INTO "personas" VALUES('1984',3,'BATISTA PINHERO JOAO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-04-25',446250,'A');
INSERT INTO "personas" VALUES('1987',1,'ISRAEL JOSE MAXWELL','191821112','CRA 25 CALLE 100','936@gmail.com','2011-02-03',125894,'2011-07-04',408350,'A');
INSERT INTO "personas" VALUES('1988',3,'BATISTA CARVALHO RODRIGO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118864,'2011-09-19',488410,'A');
INSERT INTO "personas" VALUES('1989',3,'RENO DA SILVEIRA EDNEIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118867,'2011-05-03',216990,'A');
INSERT INTO "personas" VALUES('199',1,'BASTO CORREA FERNANDO ANTONIO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-21',616860,'A');
INSERT INTO "personas" VALUES('1990',3,'SEIDLER KOHNERT G TEIXEIRA CHRISTINA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',119814,'2011-08-23',619730,'A');
INSERT INTO "personas" VALUES('1992',3,'GUIMARAES COSTA LEONARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-04-20',379090,'A');
INSERT INTO "personas" VALUES('1993',3,'BOTTA RODRIGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118777,'2011-09-16',552510,'A');
INSERT INTO "personas" VALUES('1994',3,'ARAUJO DA SILVA MARCELO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',125666,'2011-08-03',625260,'A');
INSERT INTO "personas" VALUES('1995',3,'DA SILVA FELIPE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118864,'2011-04-14',468760,'A');
INSERT INTO "personas" VALUES('1996',3,'MANFIO RODRIGUEZ FERNANDO','191821112','CRA 25 CALLE 100','974@yahoo.com','2011-02-03',118777,'2011-03-23',468040,'A');
INSERT INTO "personas" VALUES('1997',3,'NEIVA MORENO DE SOUZA CRISTIANE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-09-24',933900,'A');
INSERT INTO "personas" VALUES('2',3,'CHEEVER MICHAEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-04',560090,'I');
INSERT INTO "personas" VALUES('2000',3,'ROCHA GUSTAVO ADRIANO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118288,'2011-07-25',830340,'A');
INSERT INTO "personas" VALUES('2001',3,'DE ANDRADE CARVALHO VIRGINIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-08-11',575760,'A');
INSERT INTO "personas" VALUES('2002',3,'CAVALCANTI PIERECK GUILHERME','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',180063,'2011-08-01',387770,'A');
INSERT INTO "personas" VALUES('2004',3,'HOEGEMANN RAMOS CARLOS FERNANDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-04',894550,'A');
INSERT INTO "personas" VALUES('201',1,'LUIS FERNANDO AREVALO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-17',156730,'A');
INSERT INTO "personas" VALUES('2010',3,'GOMES BUCHALA JORGE FERNANDO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-09-23',314800,'A');
INSERT INTO "personas" VALUES('2011',3,'MARTINS SIMAIKA CATIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-06-01',155020,'A');
INSERT INTO "personas" VALUES('2012',3,'MONICA CASECA BUENO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-05-16',830710,'A');
INSERT INTO "personas" VALUES('2013',3,'ALBERTAL MARCELO ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118000,'2010-09-10',688480,'A');
INSERT INTO "personas" VALUES('2015',3,'GOMES CANTARELLI JAIRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118761,'2011-01-11',685940,'A');
INSERT INTO "personas" VALUES('2016',3,'CADETTI GARBELLINI ENILICE CRISTINA ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-11',578870,'A');
INSERT INTO "personas" VALUES('2017',3,'SPIELKAMP KLAUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',150699,'2011-03-28',836540,'A');
INSERT INTO "personas" VALUES('2019',3,'GARES HENRI PHILIPPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',135190,'2011-04-05',720730,'A');
INSERT INTO "personas" VALUES('CELL4308',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('202',1,'LUCIO CHAUSTRE ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-19',179240,'A');
INSERT INTO "personas" VALUES('2023',3,'GRECO DE RESENDELUIZ ALFREDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',119814,'2011-04-25',647940,'A');
INSERT INTO "personas" VALUES('2024',3,'CORTINA EVANDRO JOAO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118922,'2011-05-12',153970,'A');
INSERT INTO "personas" VALUES('2026',3,'BASQUES MOURA GERALDO CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',119814,'2011-09-07',668250,'A');
INSERT INTO "personas" VALUES('2027',3,'DA SILVA VALDECIR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-23',863150,'A');
INSERT INTO "personas" VALUES('2028',3,'CHI MOW YUNG IVAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-21',311000,'A');
INSERT INTO "personas" VALUES('2029',3,'YUNG MYRA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-21',965570,'A');
INSERT INTO "personas" VALUES('2030',3,'MARTINS RAMALHO PATRICIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-03-23',894830,'A');
INSERT INTO "personas" VALUES('2031',3,'DE LEMOS RIBEIRO GILBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118951,'2011-07-29',577430,'A');
INSERT INTO "personas" VALUES('2032',3,'AIROLDI CLAUDIO','191821112','CRA 25 CALLE 100','973@terra.com.co','2011-02-03',127591,'2011-09-28',202650,'A');
INSERT INTO "personas" VALUES('2033',3,'ARRUDA MENDES HEILMANN IONE TEREZA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',120773,'2011-09-07',280990,'A');
INSERT INTO "personas" VALUES('2034',3,'TAVARES DE CARVALHO EDUARDO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118942,'2011-08-03',796980,'A');
INSERT INTO "personas" VALUES('2036',3,'FERNANDES ALARCON RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-08-28',318730,'A');
INSERT INTO "personas" VALUES('2037',3,'SUCHODOLKI SERGIO GUSMAO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',190393,'2011-07-13',167870,'A');
INSERT INTO "personas" VALUES('2039',3,'ESTEVES MARCAL MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-02-24',912100,'A');
INSERT INTO "personas" VALUES('2040',3,'CORSI LUIZ ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-03-25',911080,'A');
INSERT INTO "personas" VALUES('2041',3,'LOPEZ MONICA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118795,'2011-05-03',819090,'A');
INSERT INTO "personas" VALUES('2042',3,'QUINTANILHA LUIS CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-16',362230,'A');
INSERT INTO "personas" VALUES('2043',3,'DE CARLI BRUNO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-05-03',353890,'A');
INSERT INTO "personas" VALUES('2045',3,'MARINO FRANCA MARILIA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-07-04',352060,'A');
INSERT INTO "personas" VALUES('2048',3,'VOIGT ALPHONSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118439,'2010-11-22',384150,'A');
INSERT INTO "personas" VALUES('2049',3,'ALENCAR ARIMA TATIANA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-05-23',408590,'A');
INSERT INTO "personas" VALUES('2050',3,'LINIS DE ALMEIDA NEILSON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',125666,'2011-08-03',890480,'A');
INSERT INTO "personas" VALUES('2051',3,'PINHEIRO DE CASTRO BENETI','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2011-08-09',226640,'A');
INSERT INTO "personas" VALUES('2052',3,'ALVES DO LAGO HELMANN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118942,'2011-08-01',461770,'A');
INSERT INTO "personas" VALUES('2053',3,'OLIVO MARCO ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-22',628900,'A');
INSERT INTO "personas" VALUES('2054',3,'WILLIAM DOMINGUES SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118085,'2011-08-23',759220,'A');
INSERT INTO "personas" VALUES('2055',3,'DE SOUZA MENEZES KLEBER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-04-25',909400,'A');
INSERT INTO "personas" VALUES('2056',3,'CABRAL NEIDE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-16',269340,'A');
INSERT INTO "personas" VALUES('2057',3,'RODRIGUES RENATO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-06-15',618500,'A');
INSERT INTO "personas" VALUES('2058',3,'SPADALE PEDRO JORGE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-08-03',284490,'A');
INSERT INTO "personas" VALUES('2059',3,'MARTINS DE ALMEIDA GUSTAVO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-09-28',566920,'A');
INSERT INTO "personas" VALUES('206',1,'TORRES HEBER MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-01-29',643210,'A');
INSERT INTO "personas" VALUES('2060',3,'IKUNO CELINA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-06-08',981170,'A');
INSERT INTO "personas" VALUES('2061',3,'DAL BELLO FABIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',129499,'2011-08-20',205050,'A');
INSERT INTO "personas" VALUES('2062',3,'BENATES ADRIANA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-23',81770,'A');
INSERT INTO "personas" VALUES('2063',3,'CARDOSO ALEXANDRE ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-23',793690,'A');
INSERT INTO "personas" VALUES('2064',3,'ZANIOLO DE SOUZA CARLOS HENRIQUE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-09-19',723130,'A');
INSERT INTO "personas" VALUES('2065',3,'DA SILVA LUIZ SIDNEI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-03-30',234590,'A');
INSERT INTO "personas" VALUES('2066',3,'RUFATO DE SOUZA LUIZ FERNANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-08-29',3560,'A');
INSERT INTO "personas" VALUES('2067',3,'DE MEDEIROS LUCIANA','191821112','CRA 25 CALLE 100','994@yahoo.com.mx','2011-02-03',118777,'2011-09-10',314020,'A');
INSERT INTO "personas" VALUES('2068',3,'WOLFF PIAZERA DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118255,'2011-06-15',559430,'A');
INSERT INTO "personas" VALUES('2069',3,'DA SILVA FORTUNA MARINA CLAUDIA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2011-09-23',855100,'A');
INSERT INTO "personas" VALUES('2070',3,'PEREIRA BORGES LUCILA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',120773,'2011-07-26',597210,'A');
INSERT INTO "personas" VALUES('2072',3,'PORROZZI DE ALMEIDA RENATO','191821112','CRA 25 CALLE 100','812@hotmail.es','2011-02-03',127591,'2011-06-13',312120,'A');
INSERT INTO "personas" VALUES('2073',3,'KALICHSZTEINN RICARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-03-23',298330,'A');
INSERT INTO "personas" VALUES('2074',3,'OCCHIALINI GUIMARAES ANA PAULA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118777,'2011-08-03',555310,'A');
INSERT INTO "personas" VALUES('2075',3,'MAZZUCO FONTES LUIZ ROBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-05-23',881570,'A');
INSERT INTO "personas" VALUES('2078',3,'TRAN DINH VAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-05-07',98560,'A');
INSERT INTO "personas" VALUES('2079',3,'NGUYEN THI LE YEN','191821112','CRA 25 CALLE 100','249@yahoo.com.mx','2011-02-03',132958,'2011-05-07',298200,'A');
INSERT INTO "personas" VALUES('208',1,'GOMEZ GONZALEZ JORGE MARIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-12',889010,'A');
INSERT INTO "personas" VALUES('2080',3,'MILA DE LA ROCA JOHANA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2011-01-26',195350,'A');
INSERT INTO "personas" VALUES('2081',3,'RODRIGUEZ DE FLORES LOURDES MARIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-16',82120,'A');
INSERT INTO "personas" VALUES('2082',3,'FLORES PEREZ FRANCISCO GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-23',824550,'A');
INSERT INTO "personas" VALUES('2083',3,'FRAGACHAN BETANCOUT FRANCISCO JO SE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-07-04',876400,'A');
INSERT INTO "personas" VALUES('2084',3,'GAFARO MOLINA CARLOS JULIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-03-22',908370,'A');
INSERT INTO "personas" VALUES('2085',3,'CACERES REYES JORGEANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-08-11',912630,'A');
INSERT INTO "personas" VALUES('2086',3,'ALVAREZ RODRIGUEZ VICTOR ROGELIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132958,'2011-05-23',838040,'A');
INSERT INTO "personas" VALUES('2087',3,'GARCES ALVARADO JHAGEIMA JOSEFINA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132958,'2011-04-29',452320,'A');
INSERT INTO "personas" VALUES('CELL4324',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('2089',3,'FAVREAU CHOLLET JEAN PIERRE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132554,'2011-05-27',380470,'A');
INSERT INTO "personas" VALUES('209',1,'CRUZ RODRIGEZ CARLOS ANDRES','191821112','CRA 25 CALLE 100','316@hotmail.es','2011-02-03',127591,'2011-06-28',953870,'A');
INSERT INTO "personas" VALUES('2090',3,'GARAY LLUCH URBI ALAIN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-03-13',659870,'A');
INSERT INTO "personas" VALUES('2091',3,'LETICIA LETICIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-07',157950,'A');
INSERT INTO "personas" VALUES('2092',3,'VELASQUEZ RODULFO RAMON ARISTIDES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-09-23',810140,'A');
INSERT INTO "personas" VALUES('2093',3,'PEREZ EDGAR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-06',576850,'A');
INSERT INTO "personas" VALUES('2094',3,'PEREZ MARIELA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-07',453840,'A');
INSERT INTO "personas" VALUES('2095',3,'PETRUZZI MANGIARANO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132958,'2011-03-27',538650,'A');
INSERT INTO "personas" VALUES('2096',3,'LINARES GORI RICARDO RAMON','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-12',331730,'A');
INSERT INTO "personas" VALUES('2097',3,'LAIRET OLIVEROS CAROLINE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-09-25',42680,'A');
INSERT INTO "personas" VALUES('2099',3,'JIMENEZ GARCIA FERNANDO JOSE','191821112','CRA 25 CALLE 100','78@hotmail.es','2011-02-03',132958,'2011-07-21',963110,'A');
INSERT INTO "personas" VALUES('21',1,'RUBIO ESCOBAR RUBEN DARIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-05-21',639240,'A');
INSERT INTO "personas" VALUES('2100',3,'ZABALA MILAGROS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-20',160860,'A');
INSERT INTO "personas" VALUES('2101',3,'VASQUEZ CRUZ NICOLEDANIELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132958,'2011-07-31',914990,'A');
INSERT INTO "personas" VALUES('2102',3,'REYES FIGUERA RAMON ALEXANDER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',126674,'2011-04-03',92340,'A');
INSERT INTO "personas" VALUES('2104',3,'RAMIREZ JIMENEZ MARYLIN CAROLINA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132958,'2011-06-14',306760,'A');
INSERT INTO "personas" VALUES('2105',3,'TELLES GUILLEN INNA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-09-07',383520,'A');
INSERT INTO "personas" VALUES('2106',3,'ALVAREZ CARMEN MARINA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-07-20',997340,'A');
INSERT INTO "personas" VALUES('2107',3,'MARTINEZ YRIGOYEN NABUCODONOSOR','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-07-21',836110,'A');
INSERT INTO "personas" VALUES('2108',5,'FERNANDEZ RUIZ IGNACIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-01',188530,'A');
INSERT INTO "personas" VALUES('211',1,'RIVEROS GARCIA JORGE IVAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-01',650050,'A');
INSERT INTO "personas" VALUES('2110',3,'CACERES REYES JORGE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2011-08-08',606030,'A');
INSERT INTO "personas" VALUES('2111',3,'GELFI MARCOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',199862,'2011-05-17',727190,'A');
INSERT INTO "personas" VALUES('2112',3,'CERDA CASTILLO CARMEN GLORIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-08-21',817870,'A');
INSERT INTO "personas" VALUES('2113',3,'RANGEL FERNANDEZ LEONARDO JOSE','191821112','CRA 25 CALLE 100','856@hotmail.com','2011-02-03',133211,'2011-05-16',907750,'A');
INSERT INTO "personas" VALUES('2114',3,'ROTHSCHILD VARGAS MICHAEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132165,'2011-02-05',85170,'A');
INSERT INTO "personas" VALUES('2115',3,'RUIZ GRATEROL INGRID JOHANNA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132958,'2011-05-16',702600,'A');
INSERT INTO "personas" VALUES('2116',2,'DEARMAS ALBERTO FERNANDO ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-07-19',257500,'A');
INSERT INTO "personas" VALUES('2117',3,'BOSCAN ARRIETA ERICK HUMBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-07-12',179680,'A');
INSERT INTO "personas" VALUES('2118',3,'GUILLEN DE TELLES NENCY JOSEFINA','191821112','CRA 25 CALLE 100','56@facebook.com','2011-02-03',132958,'2011-09-07',125900,'A');
INSERT INTO "personas" VALUES('212',1,'BUSTAMANTE BUSTAMANTE CARLOS ENRIQUE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-26',943260,'A');
INSERT INTO "personas" VALUES('2120',2,'MARK ANTHONY STUART','191821112','CRA 25 CALLE 100','661@terra.com.co','2011-02-03',127591,'2011-06-26',74600,'A');
INSERT INTO "personas" VALUES('2122',3,'SCOCOZZA GIOVANNA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',190526,'2011-09-23',284220,'A');
INSERT INTO "personas" VALUES('2125',3,'CHAVES MOLINA JULIO FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132165,'2011-09-22',295360,'A');
INSERT INTO "personas" VALUES('2127',3,'BERNARDES DE SOUZA TONIATI VIRGINIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-30',565090,'A');
INSERT INTO "personas" VALUES('2129',2,'BRIAN DAVIS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-19',78460,'A');
INSERT INTO "personas" VALUES('213',1,'PAREJO CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-11',766120,'A');
INSERT INTO "personas" VALUES('2131',3,'DE OLIVEIRA LOPES REGINALDO LAZARO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-10-05',404910,'A');
INSERT INTO "personas" VALUES('2132',3,'DE MELO MING AZEVEDO PAULO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-10-05',440370,'A');
INSERT INTO "personas" VALUES('2137',3,'SILVA JORGE ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-10-05',230570,'A');
INSERT INTO "personas" VALUES('214',1,'CADENA RICARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-08',840,'A');
INSERT INTO "personas" VALUES('2142',3,'VIEIRA VEIGA PEDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-30',85330,'A');
INSERT INTO "personas" VALUES('2144',3,'ESCRIBANO LEONARDA DEL VALLE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2011-03-24',941440,'A');
INSERT INTO "personas" VALUES('2145',3,'RODRIGUEZ MENENDEZ BERNARDO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',148511,'2011-08-02',588740,'A');
INSERT INTO "personas" VALUES('2146',3,'GONZALEZ COURET DANIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',148511,'2011-08-09',119380,'A');
INSERT INTO "personas" VALUES('2147',3,'GARCIA SOTO WILLIAM','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',135360,'2011-05-18',830660,'A');
INSERT INTO "personas" VALUES('2148',3,'MENESES ORELLANA RICARDO TOMAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132165,'2011-06-13',795200,'A');
INSERT INTO "personas" VALUES('2149',3,'GUEVARA JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-27',483990,'A');
INSERT INTO "personas" VALUES('215',1,'BELTRAN PINZON JUAN CARLO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-08',705860,'A');
INSERT INTO "personas" VALUES('2151',2,'LLANES GARRIDO JAVIER ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-30',719750,'A');
INSERT INTO "personas" VALUES('2152',3,'CHAVARRIA CHAVES RAFAEL ADRIAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132165,'2011-09-20',495720,'A');
INSERT INTO "personas" VALUES('2153',2,'MILBERT ANDREASPETER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-10',319370,'A');
INSERT INTO "personas" VALUES('2154',2,'GOMEZ SILVA LOZANO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127300,'2011-05-30',109670,'A');
INSERT INTO "personas" VALUES('2156',3,'WINTON ROBERT DOUGLAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',115551,'2011-08-08',622290,'A');
INSERT INTO "personas" VALUES('2157',2,'ROMERO PINA MANUEL GUSTAVO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-05-05',340650,'A');
INSERT INTO "personas" VALUES('2158',3,'KARWALSKI MATTHEW REECE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117229,'2011-08-29',836380,'A');
INSERT INTO "personas" VALUES('2159',2,'KIM JUNG SIK ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-08',159950,'A');
INSERT INTO "personas" VALUES('216',1,'MARTINEZ VALBUENA JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-25',526750,'A');
INSERT INTO "personas" VALUES('2160',3,'AGAR ROBERT ALEXANDER','191821112','CRA 25 CALLE 100','81@hotmail.es','2011-02-03',116862,'2011-06-11',290620,'A');
INSERT INTO "personas" VALUES('2161',3,'IGLESIAS EDGAR ALEXIS','191821112','CRA 25 CALLE 100','645@facebook.com','2011-02-03',131272,'2011-04-04',973240,'A');
INSERT INTO "personas" VALUES('2163',2,'NOAIN MORENO CECILIA KARIM ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-22',51950,'A');
INSERT INTO "personas" VALUES('2164',2,'FIGUEROA HEBEL ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-26',276760,'A');
INSERT INTO "personas" VALUES('2166',5,'FRANDBERG DAN RICHARD VERNER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',134022,'2011-04-06',309480,'A');
INSERT INTO "personas" VALUES('2168',2,'CONTRERAS LILLO EDUARDO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-27',389320,'A');
INSERT INTO "personas" VALUES('2169',2,'BLANCO VALLE RICARDO ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-07-13',355950,'A');
INSERT INTO "personas" VALUES('2171',2,'BELTRAN ZAVALA JIMI ALFONSO MIGUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',126674,'2011-08-22',991000,'A');
INSERT INTO "personas" VALUES('2172',2,'RAMIRO OREGUI JOSE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2011-04-27',119700,'A');
INSERT INTO "personas" VALUES('2175',2,'FENG PUYO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',302172,'2011-10-07',965660,'A');
INSERT INTO "personas" VALUES('2176',3,'CLERICI GUIDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',116366,'2011-08-30',522970,'A');
INSERT INTO "personas" VALUES('2177',1,'SEIJAS GUNTER LUIS MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-02',717890,'A');
INSERT INTO "personas" VALUES('2178',2,'SHOSHANI MOSHE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-13',20520,'A');
INSERT INTO "personas" VALUES('218',3,'HUCHICHALEO ARSENDIGA FRANCISCA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-05',690,'A');
INSERT INTO "personas" VALUES('2181',2,'DOMINGO BARTOLOME LUIS FERNANDO','191821112','CRA 25 CALLE 100','173@terra.com.co','2011-02-03',127591,'2011-04-18',569030,'A');
INSERT INTO "personas" VALUES('2182',3,'GONZALEZ RIJO JOSE ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-10-02',795610,'A');
INSERT INTO "personas" VALUES('2183',2,'ANDROVICH MORENO LIZETH LILIAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127300,'2011-10-10',270970,'A');
INSERT INTO "personas" VALUES('2184',2,'ARREAZA LUGO JESUS ALFREDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-08',968030,'A');
INSERT INTO "personas" VALUES('2185',2,'NAVEDA CANELON KATHERINE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132775,'2011-09-14',27250,'A');
INSERT INTO "personas" VALUES('2189',2,'LUGO BEHRENS DENISE SOFIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-08',253980,'A');
INSERT INTO "personas" VALUES('2190',2,'ERICA ROSE MOLDENHAUVER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-25',175480,'A');
INSERT INTO "personas" VALUES('2192',2,'SOLORZANO GARCIA ANDREINA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-25',50790,'A');
INSERT INTO "personas" VALUES('2193',3,'DE LA COSTE MARIA CAROLINA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-26',907640,'A');
INSERT INTO "personas" VALUES('2194',2,'MARTINEZ DIAZ JUAN JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-08',385810,'A');
INSERT INTO "personas" VALUES('2195',2,'GALARRAGA ECHEVERRIA DAYEN ALI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-13',206150,'A');
INSERT INTO "personas" VALUES('2196',2,'GUTIERREZ RAMIREZ HECTOR JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133211,'2011-06-07',873330,'A');
INSERT INTO "personas" VALUES('2197',2,'LOPEZ GONZALEZ SILVIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127662,'2011-09-01',748170,'A');
INSERT INTO "personas" VALUES('2198',2,'SEGARES LUTZ JOSE IGNACIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-07',120880,'A');
INSERT INTO "personas" VALUES('2199',2,'NADER MARTIN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127538,'2011-08-12',359880,'A');
INSERT INTO "personas" VALUES('22',1,'CARDOZO AMAYA JORGE HUMBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-25',908720,'A');
INSERT INTO "personas" VALUES('2200',3,'NATERA BERMUDEZ OSWALDO JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-10-18',436740,'A');
INSERT INTO "personas" VALUES('2201',2,'COSTA RICARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',150699,'2011-09-01',104090,'A');
INSERT INTO "personas" VALUES('2202',5,'GRUNDY VALENZUELA ALAN PATRICK','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-08',210230,'A');
INSERT INTO "personas" VALUES('2203',2,'MONTENEGRO DANIEL ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-26',738890,'A');
INSERT INTO "personas" VALUES('2204',2,'TAMAI BUNGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-24',63730,'A');
INSERT INTO "personas" VALUES('2205',5,'VINHAS FORTUNA EDSON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2011-09-23',102010,'A');
INSERT INTO "personas" VALUES('2206',2,'RUIZ ERBS MARIO ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-07-19',318860,'A');
INSERT INTO "personas" VALUES('2207',2,'VENTURA TINEO MARCEL ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-08',288240,'A');
INSERT INTO "personas" VALUES('2210',2,'RAMIREZ GUZMAN RICARDO JAIME','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-28',338740,'A');
INSERT INTO "personas" VALUES('2211',2,'STERNBERG GABRIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132958,'2011-09-04',18070,'A');
INSERT INTO "personas" VALUES('2212',2,'MARTELLO ALEJOS ROGER ADOLFO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127443,'2011-06-20',74120,'A');
INSERT INTO "personas" VALUES('2213',2,'CASTANEDA RAFAEL ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-25',316410,'A');
INSERT INTO "personas" VALUES('2214',2,'LIMON MARTINEZ WILBERT DE JESUS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128904,'2011-09-19',359690,'A');
INSERT INTO "personas" VALUES('2215',2,'PEREZ HERNANDEZ MONICA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133211,'2011-05-23',849240,'A');
INSERT INTO "personas" VALUES('2216',2,'AWAD LOBATO RICARDO SEBASTIAN','191821112','CRA 25 CALLE 100','853@hotmail.com','2011-02-03',127591,'2011-04-12',167100,'A');
INSERT INTO "personas" VALUES('2217',2,'CEPEDA VANEGAS ENDER ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-08-22',287770,'A');
INSERT INTO "personas" VALUES('2218',2,'PEREZ CHIQUIN HECTOR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132572,'2011-04-13',937580,'A');
INSERT INTO "personas" VALUES('2220',5,'FRANCO DELGADILLO RONALD FERNANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132775,'2011-09-16',310190,'A');
INSERT INTO "personas" VALUES('2222',2,'ALCAIDE ALONSO JUAN MIGUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-05-02',455360,'A');
INSERT INTO "personas" VALUES('2223',3,'BROWNING BENJAMIN MARK','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-09',45230,'A');
INSERT INTO "personas" VALUES('2225',3,'HARWOO BENJAMIN JOEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-09',164620,'A');
INSERT INTO "personas" VALUES('2226',3,'HOEY TIMOTHY ROSS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-09',242910,'A');
INSERT INTO "personas" VALUES('2227',3,'FERGUSON GARRY','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-28',720700,'A');
INSERT INTO "personas" VALUES('2228',3,' NORMAN NEVILLE ROBERT','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',288493,'2011-06-29',874750,'A');
INSERT INTO "personas" VALUES('2229',3,'KUK HYUN CHAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-03-22',211660,'A');
INSERT INTO "personas" VALUES('223',1,'PINZON PLAZA MARCOS VINICIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-22',856300,'A');
INSERT INTO "personas" VALUES('2230',3,'SLIPAK NATALIA ANDREA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-07-27',434070,'A');
INSERT INTO "personas" VALUES('2231',3,'BONELLI MASSIMO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',170601,'2011-07-11',535340,'A');
INSERT INTO "personas" VALUES('2233',3,'VUYLSTEKE ALEXANDER ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',284647,'2011-09-11',266530,'A');
INSERT INTO "personas" VALUES('2234',3,'DRESSE ALAIN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',284272,'2011-04-19',209100,'A');
INSERT INTO "personas" VALUES('2235',3,'PAIRON JEAN LOUIS MARIE RAIMOND','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',284272,'2011-03-03',245940,'A');
INSERT INTO "personas" VALUES('2236',3,'DEVIANE ACHIM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',284272,'2010-11-14',602370,'A');
INSERT INTO "personas" VALUES('2239',3,'DE CANNIERE LOUIS GEORFES HELE MARIE-JOZEF','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',285511,'2011-09-11',993540,'A');
INSERT INTO "personas" VALUES('2240',1,'ERGO ROBERT','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-28',278270,'A');
INSERT INTO "personas" VALUES('2241',3,'MYRTES RODRIGUEZ MORGANA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-09-18',410740,'A');
INSERT INTO "personas" VALUES('2242',3,'BRECHBUEHL   HANSRUDOLF','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',249059,'2011-07-27',218900,'A');
INSERT INTO "personas" VALUES('2243',3,'IVANA SCHLUMPF','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',245206,'2011-04-08',862270,'A');
INSERT INTO "personas" VALUES('2244',3,'JESSICA JACCART','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',189512,'2011-08-28',654640,'A');
INSERT INTO "personas" VALUES('2246',3,'PAUSELLI MARIANO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',210050,'2011-09-26',468090,'A');
INSERT INTO "personas" VALUES('2247',3,'VOLONTEIRO RICCARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-04-13',281230,'A');
INSERT INTO "personas" VALUES('2248',3,'HOFFMANN ALVIR ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',120773,'2011-08-23',1900,'A');
INSERT INTO "personas" VALUES('2249',3,'MANTOVANI DANIEL FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-08-09',165820,'A');
INSERT INTO "personas" VALUES('225',1,'DUARTE RUEDA JAVIER ALEXANDER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-29',293110,'A');
INSERT INTO "personas" VALUES('2250',3,'LIMA DA COSTA BRENO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-03-23',823370,'A');
INSERT INTO "personas" VALUES('2251',3,'TAMBORIN MACIEL MAGALI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-23',619420,'A');
INSERT INTO "personas" VALUES('2252',3,'BELLO DE MUORA BIANCA','191821112','CRA 25 CALLE 100','969@gmail.com','2011-02-03',118942,'2011-08-03',626970,'A');
INSERT INTO "personas" VALUES('2253',3,'VINHAS FORTUNA PIETRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2011-09-23',276600,'A');
INSERT INTO "personas" VALUES('2255',3,'BLUMENTHAL JAIRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117630,'2011-07-20',680590,'A');
INSERT INTO "personas" VALUES('2256',3,'DOS REIS FILHO ELPIDIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',120773,'2011-08-07',896720,'A');
INSERT INTO "personas" VALUES('2257',3,'COIMBRA CARDOSO MUNARI FERNANDA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-09',441830,'A');
INSERT INTO "personas" VALUES('2258',3,'LAZANHA FLAVIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118942,'2011-06-14',519000,'A');
INSERT INTO "personas" VALUES('2259',3,'LAZANHA FLAVIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-06-14',269480,'A');
INSERT INTO "personas" VALUES('226',1,'HUERFANO FLOREZ JOHN FAVER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-29',148340,'A');
INSERT INTO "personas" VALUES('2260',3,'JOVETTA EDILSON','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118941,'2011-09-19',790430,'A');
INSERT INTO "personas" VALUES('2261',3,'DE OLIVEIRA ANDRE RICARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2011-07-25',143680,'A');
INSERT INTO "personas" VALUES('2263',3,'MUNDO TEIXEIRA CARVALHO SILVIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118864,'2011-09-19',304670,'A');
INSERT INTO "personas" VALUES('2264',3,'FERREIRA CINTRA ADRIANO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-04-08',481910,'A');
INSERT INTO "personas" VALUES('2265',3,'AUGUSTO DE OLIVEIRA MARCOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118685,'2011-08-09',495530,'A');
INSERT INTO "personas" VALUES('2266',3,'CHEN ROBERTO LUIZ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-03-15',31920,'A');
INSERT INTO "personas" VALUES('2268',3,'WROBLESKI DIENSTMANN RAQUEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117630,'2011-05-15',269320,'A');
INSERT INTO "personas" VALUES('2269',3,'MALAGOLA GEDERSON','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118864,'2011-05-30',327540,'A');
INSERT INTO "personas" VALUES('227',1,'LOPEZ ESCOBAR CARLOS ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-06',862360,'A');
INSERT INTO "personas" VALUES('2271',3,'GOMES EVANDRO HENRIQUE','191821112','CRA 25 CALLE 100','199@hotmail.es','2011-02-03',118777,'2011-03-24',166100,'A');
INSERT INTO "personas" VALUES('2273',3,'LANDEIRA FERNANDEZ JESUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-21',207990,'A');
INSERT INTO "personas" VALUES('2274',3,'ROSSI RENATO','191821112','CRA 25 CALLE 100','791@hotmail.es','2011-02-03',118777,'2011-09-19',16170,'A');
INSERT INTO "personas" VALUES('2275',3,'CALMON RANGEL PATRICIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-23',456890,'A');
INSERT INTO "personas" VALUES('2277',3,'CIFU NETO ROQUE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-04-27',808940,'A');
INSERT INTO "personas" VALUES('2278',3,'GONCALVES PRETO FRANCISCO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118942,'2011-07-25',336930,'A');
INSERT INTO "personas" VALUES('2279',3,'JORGE JUNIOR ROBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-05-09',257840,'A');
INSERT INTO "personas" VALUES('2281',3,'ELENCIUC DEMETRIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-04-20',618510,'A');
INSERT INTO "personas" VALUES('2283',3,'CUNHA MENDEZ RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',119855,'2011-07-18',431190,'A');
INSERT INTO "personas" VALUES('2286',3,'DIAZ LENICE APARECIDA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-05-03',977840,'A');
INSERT INTO "personas" VALUES('2288',3,'DE CARVALHO SIGEL TATIANA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118777,'2011-07-04',123920,'A');
INSERT INTO "personas" VALUES('229',1,'GALARZA GIRALDO SERGIO ALDEMAR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-09-17',746930,'A');
INSERT INTO "personas" VALUES('2290',3,'ACHOA MORANDI BORGUES SIBELE MARIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118777,'2011-09-12',553890,'A');
INSERT INTO "personas" VALUES('2291',3,'EPAMINONDAS DE ALMEIDA DELIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-09-22',14080,'A');
INSERT INTO "personas" VALUES('2293',3,'REIS CASTRO SHANA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-08-03',1430,'A');
INSERT INTO "personas" VALUES('2294',3,'BERNARDES JUNIOR ARMANDO','191821112','CRA 25 CALLE 100','678@gmail.com','2011-02-03',127591,'2011-08-30',780930,'A');
INSERT INTO "personas" VALUES('2295',3,'LEMOS DE SOUZA AGUIAR SERGIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-10-03',900370,'A');
INSERT INTO "personas" VALUES('2296',3,'CARVALHO ADAMS KARIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118942,'2011-08-11',159040,'A');
INSERT INTO "personas" VALUES('2297',3,'GALLINA SILVANA BRASILEIRA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-23',94110,'A');
INSERT INTO "personas" VALUES('23',1,'COLMENARES PEDREROS EDUARDO ADOLFO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-02',625870,'A');
INSERT INTO "personas" VALUES('2300',3,'TAVEIRA DE SIQUEIRA TANIA APARECIDA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-24',443910,'A');
INSERT INTO "personas" VALUES('2301',3,'DA SIVA LIMA ANDRE LUIS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-23',165020,'A');
INSERT INTO "personas" VALUES('2302',3,'GALVAO GUSTAVO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-09-12',493370,'A');
INSERT INTO "personas" VALUES('2303',3,'DA COSTA CRUZ GABRIELA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-07-27',971800,'A');
INSERT INTO "personas" VALUES('2304',3,'BERNHARD GOTTFRIED RABER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-04-30',378870,'A');
INSERT INTO "personas" VALUES('2306',3,'ALDANA URIBE PABLO AXEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-05-08',758160,'A');
INSERT INTO "personas" VALUES('2308',3,'FLORES ALONSO EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-04-26',995310,'A');
INSERT INTO "personas" VALUES('CELL4330',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('2309',3,'MADRIGAL MIER Y TERAN LUIS FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-02-23',414650,'A');
INSERT INTO "personas" VALUES('231',1,'ZAPATA CEBALLOS JUAN MANUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127662,'2011-08-16',430320,'A');
INSERT INTO "personas" VALUES('2310',3,'GONZALEZ ALVARO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-05-19',87330,'A');
INSERT INTO "personas" VALUES('2313',3,'MONTES PORTO ANDREA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-09-01',929180,'A');
INSERT INTO "personas" VALUES('2314',3,'ROCHA SUSUNAGA SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2010-10-18',541540,'A');
INSERT INTO "personas" VALUES('2315',3,'VASQUEZ CALERO FEDERICO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-22',920160,'A');
INSERT INTO "personas" VALUES('2317',3,'GONZALEZ FERNANDEZ YUSSEN ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-26',120530,'A');
INSERT INTO "personas" VALUES('2319',3,'ATTIAS WENGROWSKY DAVID','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150581,'2011-09-07',8580,'A');
INSERT INTO "personas" VALUES('232',1,'OSPINA ABUCHAIBE ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-07-14',748960,'A');
INSERT INTO "personas" VALUES('2320',3,'EFRON TOPOROVSKY INES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',116511,'2011-07-15',20810,'A');
INSERT INTO "personas" VALUES('2321',3,'LUNA PLA DARIO','191821112','CRA 25 CALLE 100','95@terra.com.co','2011-02-03',145135,'2011-09-07',78320,'A');
INSERT INTO "personas" VALUES('2322',1,'VAZQUEZ DANIELA','191821112','CRA 25 CALLE 100','190@gmail.com','2011-02-03',145135,'2011-05-19',329170,'A');
INSERT INTO "personas" VALUES('2323',3,'BALBI BALBI JUAN DE DIOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-08-23',410880,'A');
INSERT INTO "personas" VALUES('2324',3,'MARROQUIN FERNANDEZ GELACIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-03-23',66880,'A');
INSERT INTO "personas" VALUES('2325',3,'VAZQUEZ ZAVALA ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-04-11',101770,'A');
INSERT INTO "personas" VALUES('2326',3,'SOTO MARTINEZ MARIA ELENA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-23',308200,'A');
INSERT INTO "personas" VALUES('2328',3,'HERNANDEZ MURILLO RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-08-22',253830,'A');
INSERT INTO "personas" VALUES('233',1,'HADDAD LINERO YEBRAIL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',130608,'2010-06-17',453830,'A');
INSERT INTO "personas" VALUES('2330',3,'TERMINEL HERNANDEZ DANIELA PATRICIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',190393,'2011-08-15',48940,'A');
INSERT INTO "personas" VALUES('2331',3,'MIJARES FERNANDEZ MAGDALENA GUADALUPE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-07-31',558440,'A');
INSERT INTO "personas" VALUES('2332',3,'GONZALEZ LUNA CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',146258,'2011-04-26',645400,'A');
INSERT INTO "personas" VALUES('2333',3,'DIAZ TORREJON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-05-03',551690,'A');
INSERT INTO "personas" VALUES('2335',3,'PADILLA GUTIERREZ JESUS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',456120,'A');
INSERT INTO "personas" VALUES('2336',3,'TORRES CORONA JORGE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-04-11',813900,'A');
INSERT INTO "personas" VALUES('2337',3,'CASTRO RAMSES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',150581,'2011-07-04',701120,'A');
INSERT INTO "personas" VALUES('2338',3,'APARICIO VALLEJO RUSSELL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-03-16',63890,'A');
INSERT INTO "personas" VALUES('2339',3,'ALBOR FERNANDEZ LUIS ARTURO','191821112','CRA 25 CALLE 100','574@gmail.com','2011-02-03',147467,'2011-05-09',216110,'A');
INSERT INTO "personas" VALUES('234',1,'DOMINGUEZ GOMEZ JUAN CARLOS','191821112','CRA 25 CALLE 100','942@hotmail.com','2011-02-03',127591,'2010-08-22',22260,'A');
INSERT INTO "personas" VALUES('2342',3,'REY ALEJANDRO','191821112','CRA 25 CALLE 100','110@facebook.com','2011-02-03',127591,'2011-03-04',313330,'A');
INSERT INTO "personas" VALUES('2343',3,'MENDOZA GONZALES ADRIANA','191821112','CRA 25 CALLE 100','295@yahoo.com','2011-02-03',127591,'2011-03-23',178720,'A');
INSERT INTO "personas" VALUES('2344',3,'RODRIGUEZ SEGOVIA JESUS ALONSO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-07-26',953590,'A');
INSERT INTO "personas" VALUES('2345',3,'GONZALEZ PELAEZ EDUARDO DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-26',231790,'A');
INSERT INTO "personas" VALUES('2347',3,'VILLEDA GARCIA DAVID','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',144939,'2011-05-29',795600,'A');
INSERT INTO "personas" VALUES('2348',3,'FERRER BURGES EMILIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-04-11',83430,'A');
INSERT INTO "personas" VALUES('2349',3,'NARRO ROBLES LUIS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-03-16',30330,'A');
INSERT INTO "personas" VALUES('2350',3,'ZALDIVAR UGALDE CARLOS IGNACIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-06-19',901380,'A');
INSERT INTO "personas" VALUES('2351',3,'VARGAS RODRIGUEZ VALENTE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',146258,'2011-04-26',415910,'A');
INSERT INTO "personas" VALUES('2354',3,'DEL PIERO FRANCISCO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-09',19890,'A');
INSERT INTO "personas" VALUES('2355',3,'VILLAREAL ANA CRISTINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-23',211810,'A');
INSERT INTO "personas" VALUES('2356',3,'GARRIDO FERRAN JORGE ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-22',999370,'A');
INSERT INTO "personas" VALUES('2357',3,'PEREZ PRECIADO EDMUNDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-22',361450,'A');
INSERT INTO "personas" VALUES('2358',3,'AGUIRRE VIGNAU DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150581,'2011-08-21',809110,'A');
INSERT INTO "personas" VALUES('2359',3,'LOPEZ SESMA TOMAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',146258,'2011-09-14',961200,'A');
INSERT INTO "personas" VALUES('236',1,'VENTO BETANCOURT LUIS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-03-19',682230,'A');
INSERT INTO "personas" VALUES('2360',3,'BERNAL MALDONADO GUILLERMO JAVIER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-09-19',378670,'A');
INSERT INTO "personas" VALUES('2361',3,'GUZMAN DELGADO ALFREDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-22',9770,'A');
INSERT INTO "personas" VALUES('2362',3,'GUZMAN DELGADO MARTIN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',912850,'A');
INSERT INTO "personas" VALUES('2363',3,'GUSMAND ELGADO JORGE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-22',534910,'A');
INSERT INTO "personas" VALUES('2364',3,'RENDON BUICK JORGE JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-26',936010,'A');
INSERT INTO "personas" VALUES('2365',3,'HERNANDEZ HERNANDEZ HERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-22',75340,'A');
INSERT INTO "personas" VALUES('2366',3,'ALVAREZ PAZ PEDRO RAFAEL ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-01-02',568650,'A');
INSERT INTO "personas" VALUES('2367',3,'MIJARES DE LA BARREDA FERNANDA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-07-31',617240,'A');
INSERT INTO "personas" VALUES('2368',3,'MARTINEZ LOPEZ MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-08-24',380250,'A');
INSERT INTO "personas" VALUES('2369',3,'GAYTAN MILLAN YANERI','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-23',49520,'A');
INSERT INTO "personas" VALUES('237',1,'BARGUIL ASSIS DAVID ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117460,'2009-09-03',161770,'A');
INSERT INTO "personas" VALUES('2370',3,'DURAN HEREDIA FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-04-15',106850,'A');
INSERT INTO "personas" VALUES('2371',3,'SEGURA MIJARES CRISTOBAL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-31',385700,'A');
INSERT INTO "personas" VALUES('2372',3,'TEPOS VALTIERRA ERIK ARTURO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116345,'2011-09-01',607930,'A');
INSERT INTO "personas" VALUES('2373',3,'RODRIGUEZ AGUILAR EDMUNDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-05-04',882570,'A');
INSERT INTO "personas" VALUES('2374',3,'MYSLABODSKI MICHAEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-03-08',589060,'A');
INSERT INTO "personas" VALUES('2375',3,'HERNANDEZ MIRELES JATNIEL ELIOENAI','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-26',297600,'A');
INSERT INTO "personas" VALUES('2376',3,'SNELL FERNANDEZ SYNTYHA ROCIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',720830,'A');
INSERT INTO "personas" VALUES('2378',3,'HERNANDEZ EIVET AARON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-26',394200,'A');
INSERT INTO "personas" VALUES('2379',3,'LOPEZ GARZA JAIME','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-22',837000,'A');
INSERT INTO "personas" VALUES('238',1,'GARCIA PINO CARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-10',762140,'A');
INSERT INTO "personas" VALUES('2381',3,'TOSCANO ESTRADA RUBEN ENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-22',500940,'A');
INSERT INTO "personas" VALUES('2382',3,'RAMIREZ HUDSON ROGER SILVESTER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-22',497550,'A');
INSERT INTO "personas" VALUES('2383',3,'RAMOS JUAN ANTONIO','191821112','CRA 25 CALLE 100','362@yahoo.es','2011-02-03',127591,'2011-08-22',984940,'A');
INSERT INTO "personas" VALUES('2384',3,'CORTES CERVANTES ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-04-11',432020,'A');
INSERT INTO "personas" VALUES('2385',3,'POZOS ESQUIVEL DAVID','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-09-27',205310,'A');
INSERT INTO "personas" VALUES('2387',3,'ESTRADA AGUIRRE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-22',36470,'A');
INSERT INTO "personas" VALUES('2388',3,'GARCIA RAMIREZ RAMON','191821112','CRA 25 CALLE 100','177@yahoo.es','2011-02-03',127591,'2011-08-22',990910,'A');
INSERT INTO "personas" VALUES('2389',3,'PRUD HOMME GARCIA CUBAS XAVIER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-05-18',845140,'A');
INSERT INTO "personas" VALUES('239',1,'PINZON ARDILA GUSTAVO ALFONSO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-01',325400,'A');
INSERT INTO "personas" VALUES('2390',3,'ELIZABETH OCHOA ROJAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-05-21',252950,'A');
INSERT INTO "personas" VALUES('2391',3,'MEZA ALVAREZ JOSE ALBERTO','191821112','CRA 25 CALLE 100','646@terra.com.co','2011-02-03',144939,'2011-05-09',729340,'A');
INSERT INTO "personas" VALUES('2392',3,'HERRERA REYES RENATO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2010-02-28',887860,'A');
INSERT INTO "personas" VALUES('2393',3,'MURILLO GARIBAY GILBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-08-20',251280,'A');
INSERT INTO "personas" VALUES('2394',3,'GARCIA JIMENEZ CARLOS MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-10-09',592830,'A');
INSERT INTO "personas" VALUES('2395',3,'GUAGNELLI MARTINEZ BLANCA MONICA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145184,'2010-10-05',210320,'A');
INSERT INTO "personas" VALUES('2397',3,'GARCIA CISNEROS RAUL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-07-04',734530,'A');
INSERT INTO "personas" VALUES('2398',3,'MIRANDA ROMO FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',853340,'A');
INSERT INTO "personas" VALUES('24',1,'ARREGOCES GARZON NELSON ORLANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127783,'2011-08-12',403190,'A');
INSERT INTO "personas" VALUES('240',1,'ARCINIEGAS GOMEZ ALBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-18',340590,'A');
INSERT INTO "personas" VALUES('2400',3,'HERRERA ABARCA EDUARDO VICENTE ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-22',755620,'A');
INSERT INTO "personas" VALUES('2403',3,'CASTRO MONCAYO LUIS ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-07-29',617260,'A');
INSERT INTO "personas" VALUES('2404',3,'GUZMAN DELGADO OSBALDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-22',56250,'A');
INSERT INTO "personas" VALUES('2405',3,'GARCIA LOPEZ DAVID','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-22',429500,'A');
INSERT INTO "personas" VALUES('2406',3,'JIMENEZ GAMEZ RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',245206,'2011-03-23',978720,'A');
INSERT INTO "personas" VALUES('2407',3,'BECERRA MARTINEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-08-23',605130,'A');
INSERT INTO "personas" VALUES('2408',3,'GARCIA MARTINEZ BERNARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-22',89480,'A');
INSERT INTO "personas" VALUES('2409',3,'URRUTIA RAYAS BALTAZAR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-22',632020,'A');
INSERT INTO "personas" VALUES('241',1,'MEDINA AGUILA NESTOR EDUARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-09',726730,'A');
INSERT INTO "personas" VALUES('2411',3,'VERGARA MENDOZAVICTOR HUGO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-06-15',562230,'A');
INSERT INTO "personas" VALUES('2412',3,'MENDOZA MEDINA JORGE IGNACIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-22',136170,'A');
INSERT INTO "personas" VALUES('2413',3,'CORONADO CASTILLO HUGO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',147529,'2011-05-09',994160,'A');
INSERT INTO "personas" VALUES('2414',3,'GONZALEZ SOTO DELIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-03-23',562280,'A');
INSERT INTO "personas" VALUES('2415',3,'HERNANDEZ FLORES STEPHANIE REYNA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-23',828940,'A');
INSERT INTO "personas" VALUES('2416',3,'ABRAJAN GUERRERO MARIA DE LOS ANGELES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-03-23',457860,'A');
INSERT INTO "personas" VALUES('2417',3,'HERNANDEZ LOERA ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-23',802490,'A');
INSERT INTO "personas" VALUES('2418',3,'TARIN LOPEZ JOSE CARMEN','191821112','CRA 25 CALLE 100','117@gmail.com','2011-02-03',127591,'2011-03-23',638870,'A');
INSERT INTO "personas" VALUES('242',1,'JULIO NARVAEZ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-05',611890,'A');
INSERT INTO "personas" VALUES('2420',3,'BATTA MARQUEZ VICTOR ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-08-23',17820,'A');
INSERT INTO "personas" VALUES('2423',3,'GONZALEZ REYES JUAN JOSE','191821112','CRA 25 CALLE 100','55@yahoo.es','2011-02-03',127591,'2011-07-26',758070,'A');
INSERT INTO "personas" VALUES('2425',3,'ALVAREZ RODRIGUEZ HIRAM RAMSES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-23',847420,'A');
INSERT INTO "personas" VALUES('2426',3,'FEMATT HERNANDEZ JESUS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-03-23',164130,'A');
INSERT INTO "personas" VALUES('2427',3,'GUTIERRES ORTEGA FRANCISCO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',278410,'A');
INSERT INTO "personas" VALUES('2428',3,'JIMENEZ DIAZ JUAN JORGE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-13',899650,'A');
INSERT INTO "personas" VALUES('2429',3,'VILLANUEVA PEREZ MIGUEL ANGEL','191821112','CRA 25 CALLE 100','656@yahoo.es','2011-02-03',150449,'2011-03-23',663000,'A');
INSERT INTO "personas" VALUES('243',1,'GOMEZ REYES ANDRES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',126674,'2009-12-20',879240,'A');
INSERT INTO "personas" VALUES('2430',3,'CERON GOMEZ JOEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-03-21',616070,'A');
INSERT INTO "personas" VALUES('2431',3,'LOPEZ LINALDI DEMETRIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-05-09',91360,'A');
INSERT INTO "personas" VALUES('2432',3,'JOSEPH NATHAN PEDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-02',608580,'A');
INSERT INTO "personas" VALUES('2433',3,'CARRENO PULIDO RUBEN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',147242,'2011-06-19',768810,'A');
INSERT INTO "personas" VALUES('2434',3,'AREVALO MERCADO CARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-06-12',18320,'A');
INSERT INTO "personas" VALUES('2436',3,'RAMIREZ QUEZADA ERIKA BELEM','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-03',870930,'A');
INSERT INTO "personas" VALUES('2438',3,'TATTO PRIETO MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-05-19',382740,'A');
INSERT INTO "personas" VALUES('2439',3,'LOPEZ AYALA LUIS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-10-08',916370,'A');
INSERT INTO "personas" VALUES('244',1,'DEVIS EDGAR JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-10-08',560540,'A');
INSERT INTO "personas" VALUES('2440',3,'HERNANDEZ TOVAR JORGE ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',144991,'2011-10-02',433650,'A');
INSERT INTO "personas" VALUES('2441',3,'COLLIARD LOPEZ PETER GEORGE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-09',419120,'A');
INSERT INTO "personas" VALUES('2442',3,'FLORES CHALA GARY','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-22',794670,'A');
INSERT INTO "personas" VALUES('2443',3,'FANDINO MUNOZ ZAMIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-19',715970,'A');
INSERT INTO "personas" VALUES('2444',3,'BARROSO VARGAS DIEGO ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-26',195840,'A');
INSERT INTO "personas" VALUES('2446',3,'CRUZ RAMIREZ JUAN PEDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-07-14',569050,'A');
INSERT INTO "personas" VALUES('2447',3,'TIJERINA ACOSTA SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-26',351280,'A');
INSERT INTO "personas" VALUES('2449',3,'JASSO BARRERA CARLOS GUSTAVO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-08-24',192560,'A');
INSERT INTO "personas" VALUES('245',1,'LENCHIG KALEDA SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-09-02',165000,'A');
INSERT INTO "personas" VALUES('2450',3,'GARRIDO PATRON VICTOR','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-09-27',814970,'A');
INSERT INTO "personas" VALUES('2451',3,'VELASQUEZ GUERRERO RUBEN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-20',497150,'A');
INSERT INTO "personas" VALUES('2452',3,'CHOI SUNGKYU','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',209494,'2011-08-16',40860,'A');
INSERT INTO "personas" VALUES('2453',3,'CONTRERAS LOPEZ SERGIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-08-05',712830,'A');
INSERT INTO "personas" VALUES('2454',3,'CHAVEZ BATAA OSCAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',150699,'2011-06-14',441590,'A');
INSERT INTO "personas" VALUES('2455',3,'LEE JONG HYUN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131272,'2011-10-10',69460,'A');
INSERT INTO "personas" VALUES('2456',3,'MEDINA PADILLA CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',146589,'2011-04-20',22530,'A');
INSERT INTO "personas" VALUES('2457',3,'FLORES CUEVAS DOTNARA LUZ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-05-17',904260,'A');
INSERT INTO "personas" VALUES('2458',3,'LIU YONGCHAO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-10-09',453710,'A');
INSERT INTO "personas" VALUES('2459',3,'CASTRO FERNANDES PORTOCARRERO JOSE MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',195892,'2011-06-14',555790,'A');
INSERT INTO "personas" VALUES('246',1,'YAMHURE FONSECAN ERNESTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-10-03',143350,'A');
INSERT INTO "personas" VALUES('2460',3,'DUAN WEI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-06-22',417820,'A');
INSERT INTO "personas" VALUES('2461',3,'ZHU XUTAO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-18',421740,'A');
INSERT INTO "personas" VALUES('2462',3,'MEI SHUANNIU','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-10-09',855240,'A');
INSERT INTO "personas" VALUES('2464',3,'VEGA VACA LUIS ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-06-08',489110,'A');
INSERT INTO "personas" VALUES('2465',3,'TANG YUMING','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',147578,'2011-03-26',412660,'A');
INSERT INTO "personas" VALUES('2466',3,'VILLEDA GARCIA DAVID','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',144939,'2011-06-07',595990,'A');
INSERT INTO "personas" VALUES('2467',3,'GARCIA GARZA BLANCA ARMIDA','191821112','CRA 25 CALLE 100','927@hotmail.com','2011-02-03',145135,'2011-05-20',741940,'A');
INSERT INTO "personas" VALUES('2468',3,'HERNANDEZ MARTINEZ EMILIO JOAQUIN','191821112','CRA 25 CALLE 100','356@facebook.com','2011-02-03',145135,'2011-06-16',921740,'A');
INSERT INTO "personas" VALUES('2469',3,'WANG FAN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',185363,'2011-08-20',382860,'A');
INSERT INTO "personas" VALUES('247',1,'ROJAS RODRIGUEZ ALVARO HERNAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-09',221760,'A');
INSERT INTO "personas" VALUES('2470',3,'WANG FEI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-10-09',149100,'A');
INSERT INTO "personas" VALUES('2471',3,'BERNAL MALDONADO GUILLERMO JAVIER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118777,'2011-07-26',596900,'A');
INSERT INTO "personas" VALUES('2472',3,'GUTIERREZ GOMEZ ARTURO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145184,'2011-07-24',537210,'A');
INSERT INTO "personas" VALUES('2474',3,'LAN TYANYE ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-23',865050,'A');
INSERT INTO "personas" VALUES('2475',3,'LAN SHUZHEN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-23',639240,'A');
INSERT INTO "personas" VALUES('2476',3,'RODRIGUEZ GONZALEZ CARLOS ARTURO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',144616,'2011-08-09',601050,'A');
INSERT INTO "personas" VALUES('2477',3,'HAIBO NI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-20',87540,'A');
INSERT INTO "personas" VALUES('2479',3,'RUIZ RODRIGUEZ GRACIELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-05-20',910130,'A');
INSERT INTO "personas" VALUES('248',1,'GONZALEZ RODRIGUEZ ANDRES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-03',678750,'A');
INSERT INTO "personas" VALUES('2480',3,'OROZCO MACIAS NORMA LETICIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-09-20',647010,'A');
INSERT INTO "personas" VALUES('2481',3,'MEZA ALVAREZ JOSE ALBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',144939,'2011-06-07',504670,'A');
INSERT INTO "personas" VALUES('2482',3,'RODRIGUEZ FIGUEROA RODRIGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',146308,'2011-04-27',582290,'A');
INSERT INTO "personas" VALUES('2483',3,'CARREON GUERRA ANA CECILIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',110709,'2011-05-27',397440,'A');
INSERT INTO "personas" VALUES('2484',3,'BOTELHO BARRETO CARLOS JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',195892,'2011-08-02',240350,'A');
INSERT INTO "personas" VALUES('2485',3,'CORONADO CASTILLO HUGO','191821112','CRA 25 CALLE 100','209@yahoo.com.mx','2011-02-03',147529,'2011-06-07',9420,'A');
INSERT INTO "personas" VALUES('2486',3,'DE FUENTES GARZA MARCELO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-18',326030,'A');
INSERT INTO "personas" VALUES('2487',3,'GONZALEZ DUHART GUTIERREZ HORACIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-17',601920,'A');
INSERT INTO "personas" VALUES('2488',3,'LOPEZ LINALDI DEMETRIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-06-07',31500,'A');
INSERT INTO "personas" VALUES('2489',3,'CASTRO MONCAYO JOSE LUIS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-06-15',351720,'A');
INSERT INTO "personas" VALUES('249',1,'CASTRO RIBEROS JULIAN ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-23',728470,'A');
INSERT INTO "personas" VALUES('2490',3,'SERRALDE LOPEZ MARIA GUADALUPE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-25',664120,'A');
INSERT INTO "personas" VALUES('2491',3,'GARRIDO PATRON VICTOR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-09-29',265450,'A');
INSERT INTO "personas" VALUES('2492',3,'BRAUN JUAN NICOLAS ANTONIE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-28',334880,'A');
INSERT INTO "personas" VALUES('2493',3,'BANKA RAHUL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',141138,'2011-05-02',878070,'A');
INSERT INTO "personas" VALUES('2494',1,'GARCIA MARTINEZ MARIA VIRGINIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-17',385690,'A');
INSERT INTO "personas" VALUES('2495',1,'MARIA VIRGINIA','191821112','CRA 25 CALLE 100','298@yahoo.com.mx','2011-02-03',127591,'2011-04-16',294220,'A');
INSERT INTO "personas" VALUES('2496',3,'GOMEZ ZENDEJAS MARIA ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145184,'2011-06-06',314060,'A');
INSERT INTO "personas" VALUES('2498',3,'MENDEZ MARTINEZ RAUL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-07-10',496040,'A');
INSERT INTO "personas" VALUES('2623',3,'ZAFIROPOULO ANA I','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-25',98170,'A');
INSERT INTO "personas" VALUES('2499',3,'CARREON GUERRA ANA CECILIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-29',417240,'A');
INSERT INTO "personas" VALUES('2501',3,'OLIVAR ARIAS ISMAEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-06-06',738850,'A');
INSERT INTO "personas" VALUES('2502',3,'ABOUMRAD NASTA EMILE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-07-26',899890,'A');
INSERT INTO "personas" VALUES('2503',3,'RODRIGUEZ JIMENEZ ROBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-05-03',282900,'A');
INSERT INTO "personas" VALUES('2504',3,'ESTADOS UNIDOS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-07-27',714840,'A');
INSERT INTO "personas" VALUES('2505',3,'SOTO MUNOZ MARCO GREGORIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-26',725480,'A');
INSERT INTO "personas" VALUES('2506',3,'GARCIA MONTER ANA OTILIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-10-05',482880,'A');
INSERT INTO "personas" VALUES('2507',3,'THIRUKONDA VIGNESH','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',126180,'2011-05-02',237950,'A');
INSERT INTO "personas" VALUES('2508',3,'RAMIREZ REATIAGA LYDA YOANA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',150699,'2011-06-26',741120,'A');
INSERT INTO "personas" VALUES('2509',3,'SEPULVEDA RODRIGUEZ JESUS ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-26',991730,'A');
INSERT INTO "personas" VALUES('251',1,'MEJIA PIZANO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-10',845000,'A');
INSERT INTO "personas" VALUES('2510',3,'FRANCISCO MARIA DIAS COSTA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',179111,'2011-07-12',735330,'A');
INSERT INTO "personas" VALUES('2511',3,'TEIXEIRA REGO DE OLIVEIRA TIAGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',179111,'2011-06-14',701430,'A');
INSERT INTO "personas" VALUES('2512',3,'PHILLIP JAMES','191821112','CRA 25 CALLE 100','766@terra.com.co','2011-02-03',127591,'2011-09-28',301150,'A');
INSERT INTO "personas" VALUES('2513',3,'ERXLEBEN ROBERT','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',216125,'2011-04-13',401460,'A');
INSERT INTO "personas" VALUES('2514',3,'HUGHES  CONNORRICHARD','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2011-06-22',103880,'A');
INSERT INTO "personas" VALUES('2515',3,'LEBLANC MICHAEL PAUL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',216125,'2011-08-09',314990,'A');
INSERT INTO "personas" VALUES('2517',3,'DEVINE CHRISTOPHER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2011-06-22',371560,'A');
INSERT INTO "personas" VALUES('2518',3,'WONG BRIAN TEK FUNG','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126885,'2011-09-22',67910,'A');
INSERT INTO "personas" VALUES('2519',3,'BIDWALA IRFAN A','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',154811,'2011-03-28',224840,'A');
INSERT INTO "personas" VALUES('252',1,'JIMENEZ LARRARTE JUAN GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-01',406770,'A');
INSERT INTO "personas" VALUES('2520',3,'LEE HO YIN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',147578,'2011-08-29',920470,'A');
INSERT INTO "personas" VALUES('2521',3,'DE MOURA MARTINS NUNO ALEXANDRE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196094,'2011-10-09',927850,'A');
INSERT INTO "personas" VALUES('2522',3,'DA COSTA GOMES CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',179111,'2011-08-10',877850,'A');
INSERT INTO "personas" VALUES('2523',3,'HOOGWAERTS PAUL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-02-11',605690,'A');
INSERT INTO "personas" VALUES('2524',3,'LOPES MARQUES LUIS JOSE MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118942,'2011-09-20',394910,'A');
INSERT INTO "personas" VALUES('2525',3,'CORREIA CAVACO JOSE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',178728,'2011-10-09',157470,'A');
INSERT INTO "personas" VALUES('2526',3,'HALL JOHN WILLIAM','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-09',602620,'A');
INSERT INTO "personas" VALUES('2527',3,'KNIGHT MARTIN GYLES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',113550,'2011-08-29',540670,'A');
INSERT INTO "personas" VALUES('2528',3,'HINDS THMAS TRISTAN PELLEW','191821112','CRA 25 CALLE 100','337@yahoo.es','2011-02-03',116862,'2011-08-23',895500,'A');
INSERT INTO "personas" VALUES('2529',3,'CARTON ALAN JOHN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-07-31',855510,'A');
INSERT INTO "personas" VALUES('253',1,'AZCUENAGA RAMIREZ NICOLAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',298472,'2011-05-10',498840,'A');
INSERT INTO "personas" VALUES('2530',3,'GHIM CHEOLL HO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-27',591060,'A');
INSERT INTO "personas" VALUES('2531',3,'PHILLIPS NADIA SULLIVAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-28',388750,'A');
INSERT INTO "personas" VALUES('2532',3,'CHANG KUKHYUN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-03-22',170560,'A');
INSERT INTO "personas" VALUES('2533',3,'KANG SEOUNGHYUN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',173192,'2011-08-24',686540,'A');
INSERT INTO "personas" VALUES('2534',3,'CHUNG BYANG HOON','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',125744,'2011-03-14',921030,'A');
INSERT INTO "personas" VALUES('2535',3,'SHIN MIN CHUL ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',173192,'2011-08-24',545510,'A');
INSERT INTO "personas" VALUES('2536',3,'CHOI JIN SUNG','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-15',964490,'A');
INSERT INTO "personas" VALUES('2537',3,'CHOI SUNGMIN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-27',185910,'A');
INSERT INTO "personas" VALUES('2538',3,'PARK JAESER ','191821112','CRA 25 CALLE 100','525@terra.com.co','2011-02-03',127591,'2011-09-03',36090,'A');
INSERT INTO "personas" VALUES('2539',3,'KIM DAE HOON ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',173192,'2011-08-24',622700,'A');
INSERT INTO "personas" VALUES('254',1,'AVENDANO PABON ROLANDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-05-12',273900,'A');
INSERT INTO "personas" VALUES('2540',3,'LYNN MARIA CRISTINA NORMA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',116862,'2011-09-21',5220,'A');
INSERT INTO "personas" VALUES('2541',3,'KIM CHINIL JULIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',147578,'2011-08-27',158030,'A');
INSERT INTO "personas" VALUES('2543',3,'HALL JOHN WILLIAM','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-09',398290,'A');
INSERT INTO "personas" VALUES('2544',3,'YOSUKE PERDOMO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',165600,'2011-07-26',668040,'A');
INSERT INTO "personas" VALUES('2546',3,'AKAGI KAZAHIKO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-26',722510,'A');
INSERT INTO "personas" VALUES('2547',3,'NELSON JONATHAN GARY','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-09',176570,'A');
INSERT INTO "personas" VALUES('2548',3,'DUONG HOP BA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',116862,'2011-09-14',715310,'A');
INSERT INTO "personas" VALUES('2549',3,'CHAO-VILLEGAS NIKOLE TUK HING','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',180063,'2011-04-05',46830,'A');
INSERT INTO "personas" VALUES('255',1,'CORREA ALVARO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-27',872990,'A');
INSERT INTO "personas" VALUES('2551',3,'APPELS LAURENT BERNHARD','191821112','CRA 25 CALLE 100','891@hotmail.es','2011-02-03',135190,'2011-08-16',300620,'A');
INSERT INTO "personas" VALUES('2552',3,'PLAISIER ERIK JAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',289294,'2011-05-23',238440,'A');
INSERT INTO "personas" VALUES('2553',3,'BLOK HENDRIK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',288552,'2011-03-27',290350,'A');
INSERT INTO "personas" VALUES('2554',3,'NETTE ANNA STERRE','191821112','CRA 25 CALLE 100','621@yahoo.com.mx','2011-02-03',185363,'2011-07-30',736400,'A');
INSERT INTO "personas" VALUES('2555',3,'FRIELING HANS ERIC','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',107469,'2011-07-31',810990,'A');
INSERT INTO "personas" VALUES('2556',3,'RUTTE CORNELIA JANTINE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',143579,'2011-03-30',845710,'A');
INSERT INTO "personas" VALUES('2557',3,'WALRAVEN PIETER PAUL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',289294,'2011-07-29',795620,'A');
INSERT INTO "personas" VALUES('2558',3,'TREBES LAURENS JOHANNES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-11-22',440940,'A');
INSERT INTO "personas" VALUES('2559',3,'KROESE  ROLANDWILLEBRORDUSMARIA','191821112','CRA 25 CALLE 100','188@facebook.com','2011-02-03',110643,'2011-06-09',817860,'A');
INSERT INTO "personas" VALUES('256',1,'FARIAS GARCIA REINI','191821112','CRA 25 CALLE 100','615@hotmail.com','2011-02-03',127591,'2011-03-05',543220,'A');
INSERT INTO "personas" VALUES('2560',3,'VAN DER HEIDE HENDRIK','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',291042,'2011-09-04',766460,'A');
INSERT INTO "personas" VALUES('2561',3,'VAN DEN BERG DONAR ALEXANDER GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',190393,'2011-07-13',378720,'A');
INSERT INTO "personas" VALUES('2562',3,'GODEFRIDUS JOHANNES ROPS ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127622,'2011-10-02',594240,'A');
INSERT INTO "personas" VALUES('2564',3,'WAT YOK YIENG','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',287095,'2011-03-22',392370,'A');
INSERT INTO "personas" VALUES('2565',3,'BUIS JACOBUS NICOLAAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-20',456810,'A');
INSERT INTO "personas" VALUES('2567',3,'CHIPPER FRANCIUSCUS NICOLAAS ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',291599,'2011-07-28',164300,'A');
INSERT INTO "personas" VALUES('2568',3,'ONNO ROUKENS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-11-28',500670,'A');
INSERT INTO "personas" VALUES('2569',3,'PETRUS MARCELLINUS STEPHANUS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150699,'2011-06-25',10430,'A');
INSERT INTO "personas" VALUES('2571',3,'VAN VOLLENHOVEN IVO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-08',719370,'A');
INSERT INTO "personas" VALUES('2572',3,'LAMBOOIJ BART','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-09-20',946480,'A');
INSERT INTO "personas" VALUES('2573',3,'LANSER MARIANA PAULINE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',289294,'2011-04-09',574270,'A');
INSERT INTO "personas" VALUES('2575',3,'KLERKEN JOHANNES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',286101,'2011-05-24',436840,'A');
INSERT INTO "personas" VALUES('2576',3,'KRAS JACOBUS NICOLAAS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',289294,'2011-09-26',88410,'A');
INSERT INTO "personas" VALUES('2577',3,'FUCHS MICHAEL JOSEPH','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',185363,'2011-07-30',131530,'A');
INSERT INTO "personas" VALUES('2578',3,'BIJVANK ERIK JAN WILLEM','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-11',392410,'A');
INSERT INTO "personas" VALUES('2579',3,'SCHMIDT FRANC ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',106742,'2011-09-11',567470,'A');
INSERT INTO "personas" VALUES('258',1,'SOTO GONZALEZ FRANCISCO LAZARO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',116511,'2011-05-07',856050,'A');
INSERT INTO "personas" VALUES('2580',3,'VAN DER KOOIJ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',291277,'2011-07-10',660130,'A');
INSERT INTO "personas" VALUES('2581',2,'KRIS ANDRE GEORGES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-07-26',598240,'A');
INSERT INTO "personas" VALUES('2582',3,'HARDING LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',263813,'2011-05-08',10820,'A');
INSERT INTO "personas" VALUES('2583',3,'ROLLI GUY JEAN ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-05-31',259370,'A');
INSERT INTO "personas" VALUES('2584',3,'NIETO PARRA SEBASTIAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',263813,'2011-07-04',264400,'A');
INSERT INTO "personas" VALUES('2585',3,'LASTRA CHAVEZ PABLO ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',126674,'2011-05-25',543890,'A');
INSERT INTO "personas" VALUES('2586',1,'ZAIDA MAYERLY','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-05-05',926250,'A');
INSERT INTO "personas" VALUES('2587',1,'OSWALDO SOLORZANO CONTRERAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-28',999590,'A');
INSERT INTO "personas" VALUES('2588',3,'ZHOU XUAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-18',219200,'A');
INSERT INTO "personas" VALUES('2589',3,'HUANG ZHENGQUN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-18',97230,'A');
INSERT INTO "personas" VALUES('259',1,'GALARZA NARANJO JAIME RENE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-18',988830,'A');
INSERT INTO "personas" VALUES('2590',3,'HUANG ZHENQUIN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-18',828560,'A');
INSERT INTO "personas" VALUES('2591',3,'WEIDEN MULLER AMURER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-29',851110,'A');
INSERT INTO "personas" VALUES('2593',3,'OESTERHAUS CORNELIA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',256231,'2011-03-29',295960,'A');
INSERT INTO "personas" VALUES('2594',3,'RINTALAHTI JUHA HENRIK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-23',170220,'A');
INSERT INTO "personas" VALUES('2597',3,'VERWIJNEN JONAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',289697,'2011-02-03',638040,'A');
INSERT INTO "personas" VALUES('2598',3,'SHAW ROBERT','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',157414,'2011-07-10',273550,'A');
INSERT INTO "personas" VALUES('2599',3,'MAKINEN TIMO JUHANI','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',196234,'2011-09-13',453600,'A');
INSERT INTO "personas" VALUES('260',1,'RIVERA CANON JOSE EDWARD','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127538,'2011-09-19',375990,'A');
INSERT INTO "personas" VALUES('2600',3,'HONKANIEMI ARTO OLAVI','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',301387,'2011-09-06',447380,'A');
INSERT INTO "personas" VALUES('2601',3,'DAGG JAMIE MICHAEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',216125,'2011-08-09',876080,'A');
INSERT INTO "personas" VALUES('2602',3,'BOLAND PATRICK CHARLES ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',216125,'2011-09-14',38260,'A');
INSERT INTO "personas" VALUES('2603',2,'ZULEYKA JERRYS RIVERA MENDOZA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',150347,'2011-03-27',563050,'A');
INSERT INTO "personas" VALUES('2604',3,'DELGADO SEQUIRA FERRAO JOSE PEDRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188228,'2011-08-16',700460,'A');
INSERT INTO "personas" VALUES('2605',3,'YORRO LORA EDGAR MANUEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127689,'2011-06-17',813180,'A');
INSERT INTO "personas" VALUES('2606',3,'CARRASCO RODRIGUEZQCARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127689,'2011-06-17',964520,'A');
INSERT INTO "personas" VALUES('2607',30,'ORJUELA VELASQUEZ JULIANA MARIA','191821112','CRA 25 CALLE 100','372@terra.com.co','2011-02-03',132775,'2011-09-01',383070,'A');
INSERT INTO "personas" VALUES('2608',3,'DUQUE DUTRA LUIS EDUARDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-07-12',21780,'A');
INSERT INTO "personas" VALUES('261',1,'MURCIA MARQUEZ NESTOR JAVIER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-19',913480,'A');
INSERT INTO "personas" VALUES('2610',3,'NGUYEN HUU KHUONG','191821112','CRA 25 CALLE 100','457@facebook.com','2011-02-03',132958,'2011-05-07',733120,'A');
INSERT INTO "personas" VALUES('2611',3,'NGUYEN VAN LAP','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-05-07',786510,'A');
INSERT INTO "personas" VALUES('2612',3,'PHAM HUU THU','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-05-07',733200,'A');
INSERT INTO "personas" VALUES('2613',3,'DANG MING CUONG','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2011-05-07',306460,'A');
INSERT INTO "personas" VALUES('2614',3,'VU THI HONG HANH','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-05-07',332710,'A');
INSERT INTO "personas" VALUES('2615',3,'CHAU TANG LANG','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-05-07',744190,'A');
INSERT INTO "personas" VALUES('2616',3,'CHU BAN THING','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2011-05-07',722800,'A');
INSERT INTO "personas" VALUES('2617',3,'NGUYEN QUANG THU','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-05-07',381420,'A');
INSERT INTO "personas" VALUES('2618',3,'TRAN THI KIM OANH','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-05-07',738690,'A');
INSERT INTO "personas" VALUES('2619',3,'NGUYEN VAN VINH','191821112','CRA 25 CALLE 100','422@yahoo.com.mx','2011-02-03',132958,'2011-05-07',549210,'A');
INSERT INTO "personas" VALUES('262',1,'ABDULAZIS ELNESER KHALED','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-27',439430,'A');
INSERT INTO "personas" VALUES('2620',3,'NGUYEN XUAN VY','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132958,'2011-05-07',529950,'A');
INSERT INTO "personas" VALUES('2621',3,'HA MANH HOA','191821112','CRA 25 CALLE 100','439@gmail.com','2011-02-03',132958,'2011-05-07',2160,'A');
INSERT INTO "personas" VALUES('2622',3,'ZAFIROPOULO STEVEN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-25',420930,'A');
INSERT INTO "personas" VALUES('2624',3,'TEMIGTERRA MASSIMILIANO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',210050,'2011-09-26',228070,'A');
INSERT INTO "personas" VALUES('2625',3,'CASSES TRINDADE HELGIO HENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118402,'2011-09-13',845850,'A');
INSERT INTO "personas" VALUES('2626',3,'ASCOLI MASTROENI MARCO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',120773,'2011-09-07',545010,'A');
INSERT INTO "personas" VALUES('2627',3,'MONTEIRO SOARES MARCOS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',120773,'2011-07-18',187530,'A');
INSERT INTO "personas" VALUES('2629',3,'HALL ALVARO AUGUSTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',120773,'2011-08-02',950450,'A');
INSERT INTO "personas" VALUES('2631',3,'ANDRADE CATUNDA RAFAEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',120773,'2011-08-23',370860,'A');
INSERT INTO "personas" VALUES('2632',3,'MAGALHAES MAYRA ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118767,'2011-08-23',320960,'A');
INSERT INTO "personas" VALUES('2633',3,'SPREAFICO MIRIAM ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118587,'2011-08-23',492220,'A');
INSERT INTO "personas" VALUES('2634',3,'GOMES FERREIRA HELIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',125812,'2011-08-23',498220,'A');
INSERT INTO "personas" VALUES('2635',3,'FERNANDES SENNA PIRES SERGIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-10-05',14460,'A');
INSERT INTO "personas" VALUES('2636',3,'BALESTRO FLORIANO FABIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',120773,'2011-08-24',577630,'A');
INSERT INTO "personas" VALUES('2637',3,'CABANA DE QUEIROZ ANDRADE ALAXANDRE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-23',844780,'A');
INSERT INTO "personas" VALUES('2638',3,'DALBOSCO CARLA','191821112','CRA 25 CALLE 100','380@yahoo.com.mx','2011-02-03',127591,'2011-06-30',491010,'A');
INSERT INTO "personas" VALUES('264',1,'ROMERO MONTOYA NICOLAY ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-13',965220,'A');
INSERT INTO "personas" VALUES('2640',3,'BILLINI CRUZ RICARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',144215,'2011-03-27',130530,'A');
INSERT INTO "personas" VALUES('2641',3,'VASQUES ARIAS DAVID','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',144509,'2011-08-19',890500,'A');
INSERT INTO "personas" VALUES('2642',3,'ROJAS VOLQUEZ GLADYS MICHELLE','191821112','CRA 25 CALLE 100','852@gmail.com','2011-02-03',144215,'2011-07-25',60930,'A');
INSERT INTO "personas" VALUES('2643',3,'LLANEZA GIL JUAN RAFAELMO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',144215,'2011-07-08',633120,'A');
INSERT INTO "personas" VALUES('2646',3,'AVILA PEROZO IANKEL JACOB','191821112','CRA 25 CALLE 100','318@hotmail.com','2011-02-03',144215,'2011-09-03',125600,'A');
INSERT INTO "personas" VALUES('2647',3,'REGULAR EDUARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-19',583540,'A');
INSERT INTO "personas" VALUES('2648',3,'CORONADO BATISTA JOSE ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-19',540910,'A');
INSERT INTO "personas" VALUES('2649',3,'OLIVIER JOSE VICTOR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',144509,'2011-08-19',953910,'A');
INSERT INTO "personas" VALUES('2650',3,'YOO HOE TAEK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-08-25',146820,'A');
INSERT INTO "personas" VALUES('266',1,'CUECA RODRIGUEZ CARLOS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-22',384280,'A');
INSERT INTO "personas" VALUES('267',1,'NIETO ALVARADO ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2008-04-28',553450,'A');
INSERT INTO "personas" VALUES('269',1,'LEAL HOLGUIN FRANCISCO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-25',411700,'A');
INSERT INTO "personas" VALUES('27',1,'MORENO MORENO CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2009-09-15',995620,'A');
INSERT INTO "personas" VALUES('270',1,'CANO IBANES JUAN FELIPE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-03',215260,'A');
INSERT INTO "personas" VALUES('271',1,'RESTREPO HERRAN ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132775,'2011-04-18',841220,'A');
INSERT INTO "personas" VALUES('272',3,'RIOS FRANCISCO JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',199862,'2011-03-24',560300,'A');
INSERT INTO "personas" VALUES('273',1,'MADERO LORENZANA NICOLAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-03',277850,'A');
INSERT INTO "personas" VALUES('274',1,'GOMEZ GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-09-24',708350,'A');
INSERT INTO "personas" VALUES('275',1,'CONSUEGRA ARENAS ANDRES MAURICIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-09',708210,'A');
INSERT INTO "personas" VALUES('276',1,'HURTADO ROJAS NICOLAS','191821112','CRA 25 CALLE 100','463@yahoo.com.mx','2011-02-03',127591,'2011-09-07',416000,'A');
INSERT INTO "personas" VALUES('277',1,'MURCIA BAQUERO MARCO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-02',955370,'A');
INSERT INTO "personas" VALUES('2773',3,'TAKUBO KAORI','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',165753,'2011-05-12',872390,'A');
INSERT INTO "personas" VALUES('2774',3,'OKADA MAKOTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',165753,'2011-06-19',921480,'A');
INSERT INTO "personas" VALUES('2775',3,'TAKEDA AKIO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',21062,'2011-06-19',990250,'A');
INSERT INTO "personas" VALUES('2776',3,'KOIKE WATARU ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',165753,'2011-06-19',186800,'A');
INSERT INTO "personas" VALUES('2777',3,'KUBO SHINEI','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',165753,'2011-02-13',963230,'A');
INSERT INTO "personas" VALUES('2778',3,'KANNO YONEZO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',165600,'2011-07-26',255770,'A');
INSERT INTO "personas" VALUES('278',3,'PARENT ELOIDE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',267980,'2011-05-01',528840,'A');
INSERT INTO "personas" VALUES('2781',3,'SUNADA MINORU ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',165753,'2011-06-19',724450,'A');
INSERT INTO "personas" VALUES('2782',3,'INOUE KASUYA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-22',87150,'A');
INSERT INTO "personas" VALUES('2783',3,'OTAKE NOBUTOSHI','191821112','CRA 25 CALLE 100','208@facebook.com','2011-02-03',127591,'2011-06-11',262380,'A');
INSERT INTO "personas" VALUES('2784',3,'MOTOI KEN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',165753,'2011-06-19',50470,'A');
INSERT INTO "personas" VALUES('2785',3,'TANAKA KIYOTAKA ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',165753,'2011-06-19',465210,'A');
INSERT INTO "personas" VALUES('2787',3,'YUMIKOPERDOMO','191821112','CRA 25 CALLE 100','600@yahoo.es','2011-02-03',165600,'2011-07-26',477550,'A');
INSERT INTO "personas" VALUES('2788',3,'FUKUSHIMA KENZO','191821112','CRA 25 CALLE 100','599@gmail.com','2011-02-03',156960,'2011-05-30',863860,'A');
INSERT INTO "personas" VALUES('2789',3,'GELGIN LEVENT NURI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-26',886630,'A');
INSERT INTO "personas" VALUES('279',1,'AVIATUR S. A.','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-02',778110,'A');
INSERT INTO "personas" VALUES('2791',3,'GELGIN ENIS ENRE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-26',547940,'A');
INSERT INTO "personas" VALUES('2792',3,'PAZ SOTO LUBRASCA MARIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',143954,'2011-06-27',215000,'A');
INSERT INTO "personas" VALUES('2794',3,'MOURAD TAOUFIKI','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-13',511000,'A');
INSERT INTO "personas" VALUES('2796',3,'DASTUS ALAIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',218656,'2011-05-29',774010,'A');
INSERT INTO "personas" VALUES('2797',3,'MCDONALD MICHAEL LORNE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',269033,'2011-07-19',85820,'A');
INSERT INTO "personas" VALUES('2799',3,'KLESO MICHAEL QUENTIN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2011-07-26',277950,'A');
INSERT INTO "personas" VALUES('28',1,'GONZALEZ ACUNA EDGAR MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-19',531710,'A');
INSERT INTO "personas" VALUES('280',3,'NEME KARIM CHAIBAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',135967,'2010-05-02',304040,'A');
INSERT INTO "personas" VALUES('2800',3,'CLERK CHARLES ALEXANDER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',244158,'2011-07-26',68490,'A');
INSERT INTO "personas" VALUES('CELL3673',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('2801',3,'BURRIS MAURICE STEWARD','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-27',508600,'A');
INSERT INTO "personas" VALUES('2802',1,'PINCHEN CLAIRE ELAINE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',216125,'2011-04-13',337530,'A');
INSERT INTO "personas" VALUES('2803',3,'LETTNER EVA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',231224,'2011-09-20',161860,'A');
INSERT INTO "personas" VALUES('2804',3,'CANUEL LUCIE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',146258,'2011-09-20',796710,'A');
INSERT INTO "personas" VALUES('2805',3,'IGLESIAS CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',216125,'2011-08-02',497980,'A');
INSERT INTO "personas" VALUES('2806',3,'PAQUIN JEAN FRANCOIS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2011-03-27',99760,'A');
INSERT INTO "personas" VALUES('2807',3,'FOURNIER DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',228688,'2011-05-19',4860,'A');
INSERT INTO "personas" VALUES('2808',3,'BILODEAU MARTIN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-13',725030,'A');
INSERT INTO "personas" VALUES('2809',3,'KELLNER PETER WILLIAM','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',130757,'2011-07-24',610570,'A');
INSERT INTO "personas" VALUES('2810',3,'ZAZULAK INGRID ROSEMARIE','191821112','CRA 25 CALLE 100','683@facebook.com','2011-02-03',240550,'2011-09-11',877770,'A');
INSERT INTO "personas" VALUES('2811',3,'RUCCI JHON MARIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',285188,'2011-05-10',557130,'A');
INSERT INTO "personas" VALUES('2813',3,'JONCAS MARC','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',33265,'2011-03-21',90360,'A');
INSERT INTO "personas" VALUES('2814',3,'DUCHARME ERICK','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-03-29',994750,'A');
INSERT INTO "personas" VALUES('2816',3,'BAILLOD THOMAS DAVID ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',239124,'2010-10-20',529130,'A');
INSERT INTO "personas" VALUES('2817',3,'MARTINEZ SORIA JOSE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',289697,'2011-09-06',537630,'A');
INSERT INTO "personas" VALUES('2818',3,'TAMARA RABER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-30',100750,'A');
INSERT INTO "personas" VALUES('2819',3,'BURGI VINCENT EMANUEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',245206,'2011-04-20',890860,'A');
INSERT INTO "personas" VALUES('282',1,'HUESPED ASISTENTE A LA CONVENCION DE LA DIAN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2009-06-24',17160,'A');
INSERT INTO "personas" VALUES('2820',3,'ROBLES TORRALBA IVAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',238949,'2011-05-16',152030,'A');
INSERT INTO "personas" VALUES('2821',3,'CONSUEGRA MARIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-06',87600,'A');
INSERT INTO "personas" VALUES('2822',3,'CELMA ADROVER LAIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',190393,'2011-03-23',981880,'A');
INSERT INTO "personas" VALUES('2823',3,'ALVAREZ JUAN PABLO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-06-20',646610,'A');
INSERT INTO "personas" VALUES('2824',3,'VARGAS WOODROFFE FRANCISCO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',157414,'2011-06-22',287410,'A');
INSERT INTO "personas" VALUES('2825',3,'GARCIA GUILLEN VICENTE LUIS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',144215,'2011-08-19',497230,'A');
INSERT INTO "personas" VALUES('2826',3,'GOMEZ GARCIA DIAMANTES PATRICIA MARIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',286785,'2011-09-22',623930,'A');
INSERT INTO "personas" VALUES('2827',3,'PEREZ IGLESIAS BIBIANA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-09-30',627940,'A');
INSERT INTO "personas" VALUES('2830',3,'VILLALONGA MORENES MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',169679,'2011-05-29',474910,'A');
INSERT INTO "personas" VALUES('2831',3,'REY LOPEZ DAVID','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',150699,'2011-08-03',7380,'A');
INSERT INTO "personas" VALUES('2832',3,'HOYO APARICIO JESUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',116511,'2011-09-19',612180,'A');
INSERT INTO "personas" VALUES('2836',3,'GOMEZ GARCIA LOPEZ CARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',150699,'2011-09-21',277540,'A');
INSERT INTO "personas" VALUES('2839',3,'GALIMERTI MARCO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',235197,'2011-08-28',156870,'A');
INSERT INTO "personas" VALUES('2840',3,'BAROZZI GIUSEPE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',231989,'2011-05-25',609500,'A');
INSERT INTO "personas" VALUES('2841',3,'MARIAN RENATO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-12',576900,'A');
INSERT INTO "personas" VALUES('2842',3,'FAENZA CARLO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126180,'2011-05-19',55990,'A');
INSERT INTO "personas" VALUES('2843',3,'PESOLILLO CARMINE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',203162,'2011-06-26',549230,'A');
INSERT INTO "personas" VALUES('2844',3,'CHIODI FRANCESCO MARIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',199862,'2011-09-10',578210,'A');
INSERT INTO "personas" VALUES('2845',3,'RUTA MARIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-06-19',243350,'A');
INSERT INTO "personas" VALUES('2846',3,'BAZZONI MARINO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',101518,'2011-05-03',482140,'A');
INSERT INTO "personas" VALUES('2848',3,'LAGASIO LEONARDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',231989,'2011-05-04',956670,'A');
INSERT INTO "personas" VALUES('2849',3,'VIERA DA CUNHA PAULO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',190393,'2011-04-05',741520,'A');
INSERT INTO "personas" VALUES('2850',3,'DAL BEN DENIS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',116511,'2011-05-26',837590,'A');
INSERT INTO "personas" VALUES('2851',3,'GIANELLI HERIBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',233927,'2011-05-01',963400,'A');
INSERT INTO "personas" VALUES('2852',3,'JUSTINO DA SILVA DJAMIR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-08',304200,'A');
INSERT INTO "personas" VALUES('2853',3,'DIPASQUUALE GAETANO','191821112','CRA 25 CALLE 100','574@terra.com.co','2011-02-03',172888,'2011-07-11',630830,'A');
INSERT INTO "personas" VALUES('2855',3,'CURI MAURO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',199862,'2011-06-19',315160,'A');
INSERT INTO "personas" VALUES('2856',3,'DI DIO MARCO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-20',851210,'A');
INSERT INTO "personas" VALUES('2857',3,'ROBERTI MENDONCA CAIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-11',310580,'A');
INSERT INTO "personas" VALUES('2859',3,'RAMOS MORENO DE SOUZA ANDRE ','191821112','CRA 25 CALLE 100','133@facebook.com','2011-02-03',118777,'2011-09-24',64540,'A');
INSERT INTO "personas" VALUES('286',8,'INEXMODA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-06-21',50150,'A');
INSERT INTO "personas" VALUES('2860',3,'JODJAHN DE CARVALHO FLAVIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2011-06-27',324950,'A');
INSERT INTO "personas" VALUES('2862',3,'LAGASIO LEONARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',231989,'2011-07-04',180760,'A');
INSERT INTO "personas" VALUES('2863',3,'MOON SUNG RIUL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-08',610440,'A');
INSERT INTO "personas" VALUES('2865',3,'VAIDYANATHAN VIKRAM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-11',718220,'A');
INSERT INTO "personas" VALUES('2866',3,'NARAYANASWAMY RAMSUNDAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',73079,'2011-10-02',61390,'A');
INSERT INTO "personas" VALUES('2867',3,'VADADA VENKATA RAMESH KUMAR','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-10',152300,'A');
INSERT INTO "personas" VALUES('2868',3,'RAMA KRISHNAN ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-10',577300,'A');
INSERT INTO "personas" VALUES('2869',3,'JALAN PRASHANT','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',122035,'2011-05-02',429600,'A');
INSERT INTO "personas" VALUES('2871',3,'CHANDRASEKAR VENKAT','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',112862,'2011-06-27',791800,'A');
INSERT INTO "personas" VALUES('2872',3,'CUMBAKONAM SWAMINATHAN SUBRAMANIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-11',710650,'A');
INSERT INTO "personas" VALUES('288',8,'BCD TRAVEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-23',645390,'A');
INSERT INTO "personas" VALUES('289',3,'EMBAJADA ARGENTINA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'1970-02-02',749440,'A');
INSERT INTO "personas" VALUES('CELL3789',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('290',3,'EMBAJADA DE BRASIL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-11-16',811030,'A');
INSERT INTO "personas" VALUES('293',8,'ONU','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-09-19',584810,'A');
INSERT INTO "personas" VALUES('299',1,'BLANDON GUZMAN JHON JAIRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-01-13',201740,'A');
INSERT INTO "personas" VALUES('304',3,'COHEN DANIEL DYLAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',286785,'2010-11-17',184850,'A');
INSERT INTO "personas" VALUES('306',1,'CINDU ANDINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2009-06-11',899230,'A');
INSERT INTO "personas" VALUES('31',1,'GARRIDO LEONARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127662,'2010-09-12',801450,'A');
INSERT INTO "personas" VALUES('310',3,'CORPORACION CLUB EL NOGAL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2010-08-27',918760,'A');
INSERT INTO "personas" VALUES('314',3,'CHAWLA AARON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-08',295840,'A');
INSERT INTO "personas" VALUES('317',3,'BAKER HUGHES','191821112','CRA 25 CALLE 100','694@hotmail.com','2011-02-03',127591,'2011-04-03',211990,'A');
INSERT INTO "personas" VALUES('32',1,'PAEZ SEGURA JOSE ANTONIO','191821112','CRA 25 CALLE 100','675@gmail.com','2011-02-03',129447,'2011-08-22',717340,'A');
INSERT INTO "personas" VALUES('320',1,'MORENO PAEZ FREDDY ALEXANDER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-31',971670,'A');
INSERT INTO "personas" VALUES('322',1,'CALDERON CARDOZO GASTON EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-10-05',990640,'A');
INSERT INTO "personas" VALUES('324',1,'ARCHILA MERA ALFREDOMANUEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-22',77200,'A');
INSERT INTO "personas" VALUES('326',1,'MUNOZ AVILA HERNEY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-11-10',550920,'A');
INSERT INTO "personas" VALUES('327',1,'CHAPARRO CUBILLOS FABIAN ANDRES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-15',685080,'A');
INSERT INTO "personas" VALUES('329',1,'GOMEZ LOPEZ JUAN SEBASTIAN','191821112','CRA 25 CALLE 100','970@yahoo.com','2011-02-03',127591,'2011-03-20',808070,'A');
INSERT INTO "personas" VALUES('33',1,'MARTINEZ MARINO HENRY HERNAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-04-20',182370,'A');
INSERT INTO "personas" VALUES('330',3,'MAPSTONE NAOMI LEA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',122035,'2010-02-21',722380,'A');
INSERT INTO "personas" VALUES('332',3,'ROSSI BURRI NELLY','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132165,'2010-05-10',771210,'A');
INSERT INTO "personas" VALUES('333',1,'AVELLANEDA OVIEDO JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-25',293060,'A');
INSERT INTO "personas" VALUES('334',1,'SUZA FLOREZ JUAN PABLO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-13',151650,'A');
INSERT INTO "personas" VALUES('335',1,'ESGUERRA ALVARO ANDRES','191821112','CRA 25 CALLE 100','11@facebook.com','2011-02-03',127591,'2011-09-10',879080,'A');
INSERT INTO "personas" VALUES('337',3,'DE LA HARPE MARTIN CARAPET WALTER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-27',64960,'A');
INSERT INTO "personas" VALUES('339',1,'HERNANDEZ ACOSTA SERGIO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',129499,'2011-06-22',322570,'A');
INSERT INTO "personas" VALUES('340',3,'ZARAMA DE LA ESPRIELLA MIGUEL PATRICIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-27',102360,'A');
INSERT INTO "personas" VALUES('342',1,'CABRERA VASQUEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-01',413440,'A');
INSERT INTO "personas" VALUES('343',3,'RICHARDSON BEN MARRIS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',286785,'2010-05-18',434890,'A');
INSERT INTO "personas" VALUES('344',1,'OLARTE PINZON MIGUEL FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-30',934140,'A');
INSERT INTO "personas" VALUES('345',1,'SOLER SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-04-20',366020,'A');
INSERT INTO "personas" VALUES('346',1,'PRIETO JUAN ESTEBAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-07-12',27690,'A');
INSERT INTO "personas" VALUES('349',1,'BARRERO VELASCO DAVID','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-01',472850,'A');
INSERT INTO "personas" VALUES('35',1,'VELASQUEZ RAMOS JUAN MANUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-13',251940,'A');
INSERT INTO "personas" VALUES('350',1,'RANGEL GARCIA SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-03-20',7880,'A');
INSERT INTO "personas" VALUES('353',1,'ALVAREZ ACEVEDO JOHN FREDDY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-16',540070,'A');
INSERT INTO "personas" VALUES('354',1,'VILLAMARIN HOME WILMAR ALFREDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-19',458810,'A');
INSERT INTO "personas" VALUES('355',3,'SLUCHIN NAAMAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',263813,'2010-12-01',673830,'A');
INSERT INTO "personas" VALUES('357',1,'BULLA BERNAL LUIS ERNESTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-14',942160,'A');
INSERT INTO "personas" VALUES('358',1,'BRACCIA AVILA GIANCARLO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-01',732620,'A');
INSERT INTO "personas" VALUES('359',1,'RODRIGUEZ PINTO RAUL DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-24',836600,'A');
INSERT INTO "personas" VALUES('36',1,'MALDONADO ALVAREZ JAIRO ASDRUBAL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127300,'2011-06-19',980270,'A');
INSERT INTO "personas" VALUES('362',1,'POMBO POLANCO JUAN BERNARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-18',124130,'A');
INSERT INTO "personas" VALUES('363',1,'CARDENAS SUAREZ CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127662,'2011-09-01',372920,'A');
INSERT INTO "personas" VALUES('364',1,'RIVERA MAZO JOSE DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-06-10',492220,'A');
INSERT INTO "personas" VALUES('365',1,'LEDERMAN CORDIKI JONATHAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-12-03',342340,'A');
INSERT INTO "personas" VALUES('367',1,'BARRERA MARTINEZ LUIS CARLOS','191821112','CRA 25 CALLE 100','35@yahoo.com.mx','2011-02-03',127591,'2011-05-24',148130,'A');
INSERT INTO "personas" VALUES('368',1,'SEPULVEDA RAMIREZ DANIEL MARCELO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-31',35560,'A');
INSERT INTO "personas" VALUES('369',1,'QUINTERO DIAZ WILSON ASDRUBAL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-24',733430,'A');
INSERT INTO "personas" VALUES('37',1,'RESTREPO SUAREZ HENRY BERNARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2011-07-25',145540,'A');
INSERT INTO "personas" VALUES('370',1,'ROJAS YARA WILLMAR ARLEY','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-12-03',560450,'A');
INSERT INTO "personas" VALUES('371',3,'CARVER LOUISE EMILY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',286785,'2010-10-07',601980,'A');
INSERT INTO "personas" VALUES('372',3,'VINCENT DAVID','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',286785,'2011-03-06',328540,'A');
INSERT INTO "personas" VALUES('374',1,'GONZALEZ DELGADO MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-08-18',198260,'A');
INSERT INTO "personas" VALUES('375',1,'PAEZ SIMON','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-25',480970,'A');
INSERT INTO "personas" VALUES('376',1,'CADOSCH DELMAR ELIE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-10-07',810080,'A');
INSERT INTO "personas" VALUES('377',1,'HERRERA VASQUEZ DANIEL EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-06-30',607460,'A');
INSERT INTO "personas" VALUES('378',1,'CORREAL ROJAS RONALD','191821112','CRA 25 CALLE 100','269@facebook.com','2011-02-03',127591,'2011-07-16',607080,'A');
INSERT INTO "personas" VALUES('379',1,'VOIDONNIKOLAS MUNOS PANAGIOTIS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-27',213010,'A');
INSERT INTO "personas" VALUES('38',1,'CANAL ROJAS MAURICIO HERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-05-29',786900,'A');
INSERT INTO "personas" VALUES('CELL3514',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('380',1,'DIAZ ECHEVERRI JUAN DAVID ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-20',243800,'A');
INSERT INTO "personas" VALUES('381',1,'CIFUENTES MARIN HERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-26',579960,'A');
INSERT INTO "personas" VALUES('382',3,'PAXTON LUCINDA HARRIET','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',107159,'2011-05-23',168420,'A');
INSERT INTO "personas" VALUES('384',3,'POYNTON BRIAN GEORGE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',286785,'2011-03-20',5790,'A');
INSERT INTO "personas" VALUES('385',3,'TERMIGNONI ADRIANO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-01-14',722320,'A');
INSERT INTO "personas" VALUES('386',3,'CARDWELL PAULA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-02-17',594230,'A');
INSERT INTO "personas" VALUES('389',1,'FONCECA MARTINEZ MIGUEL ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-25',778680,'A');
INSERT INTO "personas" VALUES('39',1,'GARCIA SUAREZ WILLIAM ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-25',497880,'A');
INSERT INTO "personas" VALUES('390',1,'GUERRERO NELSON','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-12-03',178650,'A');
INSERT INTO "personas" VALUES('391',1,'VICTORIA PENA FERNANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-22',557200,'A');
INSERT INTO "personas" VALUES('392',1,'VAN HISSENHOVEN FERRERO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-13',250060,'A');
INSERT INTO "personas" VALUES('393',1,'CACERES ORDUZ JUAN GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-28',578690,'A');
INSERT INTO "personas" VALUES('394',1,'QUINTERO ALVARO FELIPE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-17',143270,'A');
INSERT INTO "personas" VALUES('395',1,'ANZOLA PEREZ CARLOSDAVID','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-04',980300,'A');
INSERT INTO "personas" VALUES('397',1,'LLOREDA ORTIZ CARLOS JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-27',417470,'A');
INSERT INTO "personas" VALUES('398',1,'GONZALES LONDONO SEBASTIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-06-19',672310,'A');
INSERT INTO "personas" VALUES('4',1,'LONDONO DOMINGUEZ ERNESTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-05',324610,'A');
INSERT INTO "personas" VALUES('40',1,'MORENO ANGULO ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-01',128690,'A');
INSERT INTO "personas" VALUES('400',8,'TRANSELCA .A','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-04-14',528930,'A');
INSERT INTO "personas" VALUES('403',1,'VERGARA MURILLO JUAN FERNANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-04',42900,'A');
INSERT INTO "personas" VALUES('405',1,'CAPERA CAPERA HARRINSON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127799,'2011-06-12',961000,'A');
INSERT INTO "personas" VALUES('407',1,'MORENO MORA WILLIAM EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-22',872780,'A');
INSERT INTO "personas" VALUES('408',1,'HIGUERA ROA NICOLAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-03-28',910430,'A');
INSERT INTO "personas" VALUES('409',1,'FORERO CASTILLO OSCAR ALEJANDRO','191821112','CRA 25 CALLE 100','988@terra.com.co','2011-02-03',127591,'2011-07-23',933810,'A');
INSERT INTO "personas" VALUES('410',1,'LOPEZ MURCIA JULIAN DANIEL','191821112','CRA 25 CALLE 100','399@facebook.com','2011-02-03',127591,'2011-08-08',937790,'A');
INSERT INTO "personas" VALUES('411',1,'ALZATE JOHN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-09-09',887490,'A');
INSERT INTO "personas" VALUES('412',1,'GONZALES GONZALES ORLANDO ANDREY','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-30',624080,'A');
INSERT INTO "personas" VALUES('413',1,'ESCOLANO VALENTIN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-05',457930,'A');
INSERT INTO "personas" VALUES('414',1,'JARAMILLO RODRIGUEZ JUAN CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-12',417420,'A');
INSERT INTO "personas" VALUES('415',1,'GARCIA MUNOZ DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-10-02',713300,'A');
INSERT INTO "personas" VALUES('416',1,'PINEROS ARENAS JUAN DAVID','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-10-17',314260,'A');
INSERT INTO "personas" VALUES('417',1,'ORTIZ ARROYAVE ANDRES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-05-21',431370,'A');
INSERT INTO "personas" VALUES('418',1,'BAYONA BARRIENTOS JEAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-12',214090,'A');
INSERT INTO "personas" VALUES('419',1,'AGUDELO VASQUEZ JUAN FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-08-30',776360,'A');
INSERT INTO "personas" VALUES('420',1,'CALLE DANIEL CJ PRODUCCIONES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-11-04',239500,'A');
INSERT INTO "personas" VALUES('422',1,'CANO BETANCUR ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-08-20',623620,'A');
INSERT INTO "personas" VALUES('423',1,'CALDAS BARRETO LUZ MIREYA','191821112','CRA 25 CALLE 100','991@facebook.com','2011-02-03',127591,'2011-05-22',512840,'A');
INSERT INTO "personas" VALUES('424',1,'SIMBAQUEBA JOSE ERNESTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-25',693320,'A');
INSERT INTO "personas" VALUES('425',1,'DE SILVESTRE CALERO LUIS GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-18',928110,'A');
INSERT INTO "personas" VALUES('426',1,'ZORRO PERALTA YEZID','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-25',560560,'A');
INSERT INTO "personas" VALUES('428',1,'SUAREZ OIDOR DARWIN LEONARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131272,'2011-09-05',410650,'A');
INSERT INTO "personas" VALUES('429',1,'GIRAL CARRILLO LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-04-13',997850,'A');
INSERT INTO "personas" VALUES('43',1,'MARULANDA VALENCIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-17',365550,'A');
INSERT INTO "personas" VALUES('430',1,'CORDOBA GARCES JUAN PABLO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-18',757320,'A');
INSERT INTO "personas" VALUES('431',1,'ARIAS TAMAYO DIEGO MAURICIO','191821112','CRA 25 CALLE 100','36@yahoo.com','2011-02-03',127591,'2011-09-05',793050,'A');
INSERT INTO "personas" VALUES('432',1,'EICHMANN PERRET MARC WILLY','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-22',693270,'A');
INSERT INTO "personas" VALUES('433',1,'DIAZ DANIEL ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2008-09-18',87200,'A');
INSERT INTO "personas" VALUES('435',1,'FACCINI GONZALEZ HERMANN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2009-01-08',519420,'A');
INSERT INTO "personas" VALUES('436',1,'URIBE DUQUE FELIPE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-28',528470,'A');
INSERT INTO "personas" VALUES('437',1,'TAVERA GAONA GABREL LEAL','191821112','CRA 25 CALLE 100','280@terra.com.co','2011-02-03',127591,'2011-04-28',84120,'A');
INSERT INTO "personas" VALUES('438',1,'ORDONEZ PARIS FERNANDO MAURICIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-09-26',835170,'A');
INSERT INTO "personas" VALUES('439',1,'VILLEGAS ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-19',923520,'A');
INSERT INTO "personas" VALUES('44',1,'MARTINEZ PEDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-08-13',738750,'A');
INSERT INTO "personas" VALUES('440',1,'MARTINEZ RUEDA JUAN CARLOS','191821112','CRA 25 CALLE 100','805@hotmail.es','2011-02-03',127591,'2011-04-07',112050,'A');
INSERT INTO "personas" VALUES('441',1,'ROLDAN JUAN CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-05-25',789720,'A');
INSERT INTO "personas" VALUES('442',1,'PEREZ BRANDWAYN ELIYAU MOISES','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-10-20',612450,'A');
INSERT INTO "personas" VALUES('443',1,'VALLEJO TORO JUAN DIEGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128579,'2011-08-16',693080,'A');
INSERT INTO "personas" VALUES('444',1,'TORRES CABRERA EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-03-19',628070,'A');
INSERT INTO "personas" VALUES('445',1,'MERINO MEJIA GERMAN ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-28',61100,'A');
INSERT INTO "personas" VALUES('447',1,'GOMEZ GOMEZ JUAN CARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-08',923070,'A');
INSERT INTO "personas" VALUES('448',1,'RAUSCH CHEHEBAR STEVEN JOSEPH','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-09-27',351540,'A');
INSERT INTO "personas" VALUES('449',1,'RESTREPO TRUCCO ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-28',988500,'A');
INSERT INTO "personas" VALUES('45',1,'GUTIERREZ JARAMILLO CARLOS MARIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150699,'2011-08-22',597090,'A');
INSERT INTO "personas" VALUES('450',1,'GOLDSTEIN VAIDA ELI JACK','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-11',887860,'A');
INSERT INTO "personas" VALUES('451',1,'OLEA PINEDA EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-10',473800,'A');
INSERT INTO "personas" VALUES('452',1,'JORGE OROZCO','191821112','CRA 25 CALLE 100','503@hotmail.es','2011-02-03',127591,'2011-06-02',705410,'A');
INSERT INTO "personas" VALUES('454',1,'DE LA TORRE GOMEZ GERMAN ERNESTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-03-03',411990,'A');
INSERT INTO "personas" VALUES('456',1,'MADERO ARIAS JUAN PABLO','191821112','CRA 25 CALLE 100','452@hotmail.es','2011-02-03',127591,'2011-08-22',479090,'A');
INSERT INTO "personas" VALUES('457',1,'GOMEZ MACHUCA ALVARO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-08-12',166430,'A');
INSERT INTO "personas" VALUES('458',1,'MENDIETA TOBON DANIEL RICARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-08',394880,'A');
INSERT INTO "personas" VALUES('459',1,'VILLADIEGO CORTINA JAVIER TOMAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-26',475110,'A');
INSERT INTO "personas" VALUES('46',1,'FERRUCHO ARCINIEGAS JUAN CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-06',769220,'A');
INSERT INTO "personas" VALUES('460',1,'DERESER HARTUNG ERNESTO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-12-25',190900,'A');
INSERT INTO "personas" VALUES('461',1,'RAMIREZ PENA ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-06-25',529190,'A');
INSERT INTO "personas" VALUES('463',1,'IREGUI REYES LUIS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-07',778590,'A');
INSERT INTO "personas" VALUES('464',1,'PINTO GOMEZ MAURICIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132775,'2010-06-24',673270,'A');
INSERT INTO "personas" VALUES('465',1,'RAMIREZ RAMIREZ FERNANDO ALONSO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127799,'2011-10-01',30570,'A');
INSERT INTO "personas" VALUES('466',1,'BERRIDO TRUJILLO JORGE HENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132775,'2011-10-06',133040,'A');
INSERT INTO "personas" VALUES('467',1,'RIVERA CARVAJAL RAFAEL HUMBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-20',573500,'A');
INSERT INTO "personas" VALUES('468',3,'FLOREZ PUENTES IVAN ALFONSO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-08',468380,'A');
INSERT INTO "personas" VALUES('469',1,'BALLESTEROS FLOREZ IVAN DARIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-06-02',621410,'A');
INSERT INTO "personas" VALUES('47',1,'MARIN FLOREZ OMAR EDUARDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-30',54840,'A');
INSERT INTO "personas" VALUES('470',1,'RODRIGO PENA HERRERA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',237734,'2011-10-04',701890,'A');
INSERT INTO "personas" VALUES('471',1,'RODRIGUEZ SILVA ROGELIO','191821112','CRA 25 CALLE 100','163@gmail.com','2011-02-03',127591,'2011-05-26',645210,'A');
INSERT INTO "personas" VALUES('473',1,'VASQUEZ VELANDIA JUAN GABRIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-05-04',666330,'A');
INSERT INTO "personas" VALUES('474',1,'ROBLEDO JAIME','191821112','CRA 25 CALLE 100','409@yahoo.com','2011-02-03',127591,'2011-05-31',970480,'A');
INSERT INTO "personas" VALUES('475',1,'GRIMBERG DIAZ PHILIP','191821112','CRA 25 CALLE 100','723@yahoo.com','2011-02-03',127591,'2011-03-30',853430,'A');
INSERT INTO "personas" VALUES('476',1,'CHAUSTRE GARCIA JUAN PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-26',355670,'A');
INSERT INTO "personas" VALUES('477',1,'GOMEZ FLOREZ IGNASIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-09-14',218090,'A');
INSERT INTO "personas" VALUES('478',1,'LUIS ALBERTO CABRERA PUENTES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2011-05-26',23420,'A');
INSERT INTO "personas" VALUES('479',1,'MARTINEZ ZAPATA JUAN CARLOS','191821112','CRA 25 CALLE 100','234@gmail.com','2011-02-03',127122,'2011-07-01',462840,'A');
INSERT INTO "personas" VALUES('48',1,'PARRA IBANEZ FABIAN ERNESTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-02-01',966520,'A');
INSERT INTO "personas" VALUES('480',3,'WESTERBERG JAN RICKARD','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',300701,'2011-02-01',243940,'A');
INSERT INTO "personas" VALUES('484',1,'RODRIGUEZ VILLALOBOS EDGAR FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-19',860320,'A');
INSERT INTO "personas" VALUES('486',1,'NAVARRO REYES DIEGO FELIPE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-01',530150,'A');
INSERT INTO "personas" VALUES('487',1,'NOGUERA RICAURTE ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-01-21',384100,'A');
INSERT INTO "personas" VALUES('488',1,'RUIZ VEJARANO CARLOS DANIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-27',330030,'A');
INSERT INTO "personas" VALUES('489',1,'CORREA PEREZ ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-12-14',497860,'A');
INSERT INTO "personas" VALUES('49',1,'FLOREZ PEREZ RUBIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-23',668090,'A');
INSERT INTO "personas" VALUES('490',1,'REYES GOMEZ LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-26',499210,'A');
INSERT INTO "personas" VALUES('491',3,'BERNAL LEON ALBERTO JOSE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',150699,'2011-03-29',2470,'A');
INSERT INTO "personas" VALUES('492',1,'FELIPE JARAMILLO CARO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2009-10-31',514700,'A');
INSERT INTO "personas" VALUES('493',1,'GOMEZ PARRA GERMAN DARIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-01-29',566100,'A');
INSERT INTO "personas" VALUES('494',1,'VALLEJO RAMIREZ CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-13',286390,'A');
INSERT INTO "personas" VALUES('495',1,'DIAZ LONDONO HUGO MARIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-06',733670,'A');
INSERT INTO "personas" VALUES('496',3,'VAN BAKERGEM RONALD JAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2008-11-05',809190,'A');
INSERT INTO "personas" VALUES('497',1,'MENDEZ RAMIREZ JOSE LEONARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-10',844920,'A');
INSERT INTO "personas" VALUES('498',3,'QUI TANILLA HENRIQUEZ PAUL ANTONIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-10',797030,'A');
INSERT INTO "personas" VALUES('499',3,'PELEATO FLOREAL','191821112','CRA 25 CALLE 100','531@hotmail.com','2011-02-03',188640,'2011-04-23',450370,'A');
INSERT INTO "personas" VALUES('50',1,'SILVA GUZMAN MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-03-24',440890,'A');
INSERT INTO "personas" VALUES('502',3,'LEO ULF GORAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',300701,'2010-07-26',181840,'A');
INSERT INTO "personas" VALUES('503',3,'KARLSSON DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',300701,'2011-07-22',50680,'A');
INSERT INTO "personas" VALUES('504',1,'JIMENEZ JANER ALEJANDRO','191821112','CRA 25 CALLE 100','889@hotmail.es','2011-02-03',203272,'2011-08-29',707880,'A');
INSERT INTO "personas" VALUES('506',1,'PABON OCHOA ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-14',813050,'A');
INSERT INTO "personas" VALUES('507',1,'ACHURY CADENA CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-26',903240,'A');
INSERT INTO "personas" VALUES('508',1,'ECHEVERRY GARZON SEBASTIN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-23',77050,'A');
INSERT INTO "personas" VALUES('509',1,'PINEROS PENA LUIS CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-29',675550,'A');
INSERT INTO "personas" VALUES('CELL3562',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('51',1,'CAICEDO URREA JAIME ORLANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2011-08-17',200160,'A');
INSERT INTO "personas" VALUES('CELL3795',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('510',1,'MARTINEZ MARTINEZ LUIS EDUARDO','191821112','CRA 25 CALLE 100','586@facebook.com','2011-02-03',127591,'2010-08-28',146600,'A');
INSERT INTO "personas" VALUES('511',1,'MOLANO PENA JESUS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-02-05',706320,'A');
INSERT INTO "personas" VALUES('512',3,'RUDOLPHY FONTAINE ANDRES','191821112','CRA 25 CALLE 100','492@yahoo.com','2011-02-03',117002,'2011-04-12',91820,'A');
INSERT INTO "personas" VALUES('513',1,'NEIRA CHAVARRO JOHN JAIRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-12',340120,'A');
INSERT INTO "personas" VALUES('514',3,'MENDEZ VILLALOBOS ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-03-25',425160,'A');
INSERT INTO "personas" VALUES('515',3,'HERNANDEZ OLIVA JOSE DE LA CRUZ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-03-25',105440,'A');
INSERT INTO "personas" VALUES('518',3,'JANCO NICOLAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-15',955830,'A');
INSERT INTO "personas" VALUES('52',1,'TAPIA MUNOZ JAIRO RICARDO','191821112','CRA 25 CALLE 100','920@hotmail.es','2011-02-03',127591,'2011-10-05',678130,'A');
INSERT INTO "personas" VALUES('520',1,'ALVARADO JAVIER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-26',895550,'A');
INSERT INTO "personas" VALUES('521',1,'HUERFANO SOTO JONATHAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-30',619910,'A');
INSERT INTO "personas" VALUES('522',1,'HUERFANO SOTO JONATHAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-04',412900,'A');
INSERT INTO "personas" VALUES('523',1,'RODRIGEZ GOMEZ WILMAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-14',204790,'A');
INSERT INTO "personas" VALUES('525',1,'ARROYO BAPTISTE DIEGO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-04-09',311810,'A');
INSERT INTO "personas" VALUES('526',1,'PULECIO BOEK DANIEL','191821112','CRA 25 CALLE 100','718@gmail.com','2011-02-03',127591,'2011-08-12',203350,'A');
INSERT INTO "personas" VALUES('527',1,'ESLAVA VELEZ SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-10-08',81300,'A');
INSERT INTO "personas" VALUES('528',1,'CASTRO FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-05-06',796470,'A');
INSERT INTO "personas" VALUES('53',1,'HINCAPIE MARTINEZ RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127573,'2011-09-26',790180,'A');
INSERT INTO "personas" VALUES('530',1,'ZORRILLA PUJANA NICOLAS','191821112','CRA 25 CALLE 100','312@yahoo.es','2011-02-03',127591,'2011-06-06',302750,'A');
INSERT INTO "personas" VALUES('531',1,'ZORRILLA PUJANA NICOLAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-06',298440,'A');
INSERT INTO "personas" VALUES('532',1,'PRETEL ARTEAGA MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-09',583980,'A');
INSERT INTO "personas" VALUES('533',1,'RAMOS VERGARA HUMBERTO CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',131105,'2010-05-13',24560,'A');
INSERT INTO "personas" VALUES('534',1,'BONILLA PINEROS DIEGO FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-20',370880,'A');
INSERT INTO "personas" VALUES('535',1,'BELTRAN TRIVINO JULIAN DAVID','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-11-06',780710,'A');
INSERT INTO "personas" VALUES('536',3,'BLOD ULF FREDERICK EDWARD','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-06',790900,'A');
INSERT INTO "personas" VALUES('537',1,'VANEGAS OROZCO SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-11-10',612400,'A');
INSERT INTO "personas" VALUES('538',3,'ORUE VALLE MONICA CECILIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',97885,'2011-09-15',689270,'A');
INSERT INTO "personas" VALUES('539',1,'AGUDELO BEDOYA ANDRES JOSE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-05-24',609160,'A');
INSERT INTO "personas" VALUES('54',1,'DE HOYOS TRESPALACIOS MAURICIO ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-04-21',916500,'A');
INSERT INTO "personas" VALUES('540',3,'HEIJKENSKJOLD PER JESPER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-04-06',977980,'A');
INSERT INTO "personas" VALUES('541',3,'GONZALEZ ALVARADO LUIS RAUL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-08-27',62430,'A');
INSERT INTO "personas" VALUES('543',1,'GRUPO SURAMERICA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-08-24',703760,'A');
INSERT INTO "personas" VALUES('545',1,'CORPORACION CONTEXTO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-09-08',809570,'A');
INSERT INTO "personas" VALUES('546',3,'LUNDIN JOHAN ERIK ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-29',895330,'A');
INSERT INTO "personas" VALUES('548',3,'VEGERANO JOSE ','191821112','CRA 25 CALLE 100','221@facebook.com','2011-02-03',190393,'2011-06-05',553780,'A');
INSERT INTO "personas" VALUES('549',3,'SERRANO MADRID CLAUDIA INES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-07-27',625060,'A');
INSERT INTO "personas" VALUES('55',1,'TAFUR GOMEZ ALEXANDER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2010-09-12',211980,'A');
INSERT INTO "personas" VALUES('550',1,'MARTINEZ ACEVEDO MAURICIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-10-06',463920,'A');
INSERT INTO "personas" VALUES('551',1,'GONZALEZ MORENO PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-07-21',444450,'A');
INSERT INTO "personas" VALUES('552',1,'MEJIA ROJAS ANDRES FELIPE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-08-02',830470,'A');
INSERT INTO "personas" VALUES('553',3,'RODRIGUEZ ANTHONY HANSEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-16',819000,'A');
INSERT INTO "personas" VALUES('554',1,'ABUCHAIBE ANNICCHRICO JOSE ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-31',603610,'A');
INSERT INTO "personas" VALUES('555',3,'MOYES KIMBERLY','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-08',561020,'A');
INSERT INTO "personas" VALUES('556',3,'MONTINI MARIO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118942,'2010-03-16',994280,'A');
INSERT INTO "personas" VALUES('557',3,'HOGBERG DANIEL TOBIAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-15',288350,'A');
INSERT INTO "personas" VALUES('559',1,'OROZCO PFEIZER MARTIN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-10-07',429520,'A');
INSERT INTO "personas" VALUES('56',1,'NARINO ROJAS GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-27',310390,'A');
INSERT INTO "personas" VALUES('560',1,'GARCIA MONTOYA ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-06-02',770840,'A');
INSERT INTO "personas" VALUES('562',1,'VELASQUEZ PALACIO MANUEL ORLANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-06-23',515670,'A');
INSERT INTO "personas" VALUES('563',1,'GALLEGO PEREZ DIEGO ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-04-14',881460,'A');
INSERT INTO "personas" VALUES('564',1,'RUEDA URREGO JUAN ESTEBAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-05-04',860270,'A');
INSERT INTO "personas" VALUES('565',1,'RESTREPO DEL TORO MAURICIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-10',656960,'A');
INSERT INTO "personas" VALUES('567',1,'TORO VALENCIA FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-08-04',549090,'A');
INSERT INTO "personas" VALUES('568',1,'VILLEGAS LUIS ALFONSO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-02',633490,'A');
INSERT INTO "personas" VALUES('569',3,'RIDSTROM CHRISTER ANDERS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',300701,'2011-09-06',520150,'A');
INSERT INTO "personas" VALUES('57',1,'TOVAR ARANGO JOHN JAIME','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127662,'2010-07-03',916010,'A');
INSERT INTO "personas" VALUES('570',3,'SHEPHERD DAVID','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2008-05-11',700280,'A');
INSERT INTO "personas" VALUES('573',3,'BENGTSSON JOHAN ANDREAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-06',196830,'A');
INSERT INTO "personas" VALUES('574',3,'PERSSON HANS JONAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-09',172340,'A');
INSERT INTO "personas" VALUES('575',3,'SYNNEBY BJORN ERIK','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-15',271210,'A');
INSERT INTO "personas" VALUES('CELL381',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('577',3,'COHEN PAUL KIRTAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-25',381490,'A');
INSERT INTO "personas" VALUES('578',3,'ROMERO BRAVO FERNANDO EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-08-21',390360,'A');
INSERT INTO "personas" VALUES('579',3,'GUTHRIE ROBERT DEAN','191821112','CRA 25 CALLE 100','794@gmail.com','2011-02-03',161705,'2010-07-20',807350,'A');
INSERT INTO "personas" VALUES('58',1,'TORRES ESCOBAR JAIRO ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-06-17',648860,'A');
INSERT INTO "personas" VALUES('580',3,'ROCASERMENO MONTENEGRO MARIO JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',139844,'2010-12-01',865650,'A');
INSERT INTO "personas" VALUES('581',1,'COCK JORGE EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-08-19',906210,'A');
INSERT INTO "personas" VALUES('582',3,'REISS ANDREAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-01-31',934120,'A');
INSERT INTO "personas" VALUES('584',3,'ECHEVERRIA CASTILLO GERMAN FRANCISCO','191821112','CRA 25 CALLE 100','982@yahoo.com','2011-02-03',139844,'2011-07-20',957370,'A');
INSERT INTO "personas" VALUES('585',3,'BRANDT CARLOS GUSTAVO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-10',931030,'A');
INSERT INTO "personas" VALUES('586',3,'VEGA NUNEZ GILBERTO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-14',783010,'A');
INSERT INTO "personas" VALUES('587',1,'BEJAR MUNOZ JORDI','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',196234,'2010-10-08',121990,'A');
INSERT INTO "personas" VALUES('588',3,'WADSO KERSTIN ELIZABETH','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-17',260890,'A');
INSERT INTO "personas" VALUES('59',1,'RAMOS FORERO JAVIER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-20',496300,'A');
INSERT INTO "personas" VALUES('590',1,'RODRIGUEZ BETANCOURT JAVIER AUGUSTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127538,'2011-05-23',909850,'A');
INSERT INTO "personas" VALUES('592',1,'ARBOLEDA HALABY RODRIGO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',150699,'2009-02-03',939170,'A');
INSERT INTO "personas" VALUES('593',1,'CURE CURE CARLOS ALFREDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-07-11',494600,'A');
INSERT INTO "personas" VALUES('594',3,'VIDELA PEREZ OSCAR EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-07-13',655510,'A');
INSERT INTO "personas" VALUES('595',1,'GONZALEZ GAVIRIA NESTOR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2009-09-28',793760,'A');
INSERT INTO "personas" VALUES('596',3,'IZQUIERDO DELGADO DIONISIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2009-09-24',2250,'A');
INSERT INTO "personas" VALUES('597',1,'MORENO DAIRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127300,'2011-06-14',629990,'A');
INSERT INTO "personas" VALUES('598',1,'RESTREPO FERNNDEZ SOTO JOSE MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-08-31',143210,'A');
INSERT INTO "personas" VALUES('599',3,'YERYES VERGARA MARIA SOLEDAD','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-10-11',826060,'A');
INSERT INTO "personas" VALUES('6',1,'GUZMAN ESCOBAR JOSE VICENTE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-10',26390,'A');
INSERT INTO "personas" VALUES('60',1,'ELEJALDE ESCOBAR TOMAS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-11-09',534910,'A');
INSERT INTO "personas" VALUES('601',1,'ESCAF ESCAF WILLIAM MIGUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',150699,'2011-07-26',25190,'A');
INSERT INTO "personas" VALUES('602',1,'CEBALLOS ZULUAGA JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-05-03',23920,'A');
INSERT INTO "personas" VALUES('603',1,'OLIVELLA GUERRERO RAFAEL ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',134022,'2010-06-23',44040,'A');
INSERT INTO "personas" VALUES('604',1,'ESCOBAR GALLO CARLOS HUGO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-08-09',148420,'A');
INSERT INTO "personas" VALUES('605',1,'ESCORCIA RAMIREZ EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128569,'2011-04-01',609990,'A');
INSERT INTO "personas" VALUES('606',1,'MELGAREJO MORENO PAULA ANDREA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-05',604700,'A');
INSERT INTO "personas" VALUES('607',1,'TOBON CALLE CARLOS GUILLERMO','191821112','CRA 25 CALLE 100','689@hotmail.es','2011-02-03',128662,'2011-03-16',193510,'A');
INSERT INTO "personas" VALUES('608',3,'TREVINO NOPHAL SILVANO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',110709,'2011-05-27',153470,'A');
INSERT INTO "personas" VALUES('609',1,'CARDER VELEZ EDWIN JOHN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-09-04',186830,'A');
INSERT INTO "personas" VALUES('61',1,'GASCA DAZA VICTOR HERNANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-09',185660,'A');
INSERT INTO "personas" VALUES('610',3,'DAVIS JOHN BRADLEY','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-04-06',473740,'A');
INSERT INTO "personas" VALUES('611',1,'BAQUERO SLDARRIAGA ALVARO ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-09-15',808210,'A');
INSERT INTO "personas" VALUES('612',3,'SERRACIN ARAUZ YANIRA YAMILET','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',131272,'2011-06-09',619820,'A');
INSERT INTO "personas" VALUES('613',1,'MORA SOTO ALVARO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-09-20',674450,'A');
INSERT INTO "personas" VALUES('614',1,'SUAREZ RODRIGUEZ HERNANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-03-29',512820,'A');
INSERT INTO "personas" VALUES('616',1,'BAQUERO GARCIA JORGE LUIS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2010-07-14',165160,'A');
INSERT INTO "personas" VALUES('617',3,'ABADI MADURO MOISES SIMON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',131272,'2009-03-31',203640,'A');
INSERT INTO "personas" VALUES('62',3,'FLOWER LYNDON BRUCE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',231373,'2011-05-16',323560,'A');
INSERT INTO "personas" VALUES('624',8,'OLARTE LEONARDO','191821112','CRA 25 CALLE 100','6@hotmail.com','2011-02-03',127591,'2011-06-03',219790,'A');
INSERT INTO "personas" VALUES('63',1,'RUBIO CORTES OSCAR','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-04-28',60830,'A');
INSERT INTO "personas" VALUES('630',5,'PROEXPORT','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2010-08-12',708320,'A');
INSERT INTO "personas" VALUES('632',8,'SUPER COFFEE ','191821112','CRA 25 CALLE 100','792@hotmail.es','2011-02-03',127591,'2011-08-30',306460,'A');
INSERT INTO "personas" VALUES('636',8,'NOGAL ASESORIAS FINANCIERAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-04-07',752150,'A');
INSERT INTO "personas" VALUES('64',1,'GUERRA MARTINEZ MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-24',333480,'A');
INSERT INTO "personas" VALUES('645',8,'GIZ - PROFIS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-31',566330,'A');
INSERT INTO "personas" VALUES('652',3,'QBE DEL ISTMO COMPANIA DE REASEGUROS ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-14',932190,'A');
INSERT INTO "personas" VALUES('655',3,'CORP. CENTRO DE ESTUDIOS DE DERECHO JUSTICIA Y SOCIEDAD','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-05-04',440370,'A');
INSERT INTO "personas" VALUES('659',3,'GOOD YEAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2010-09-24',993830,'A');
INSERT INTO "personas" VALUES('660',3,'ARCINIEGAS Y VILLAMIZAR','191821112','CRA 25 CALLE 100','258@yahoo.com','2011-02-03',127591,'2010-12-02',787450,'A');
INSERT INTO "personas" VALUES('67',1,'LOPEZ HOYOS JUAN DIEGO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127662,'2010-04-13',665230,'A');
INSERT INTO "personas" VALUES('670',8,'APPLUS NORCONTROL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2011-09-06',83210,'A');
INSERT INTO "personas" VALUES('672',3,'KERLL SEBASTIAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',287273,'2010-12-19',501610,'A');
INSERT INTO "personas" VALUES('673',1,'RESTREPO MOLINA RAMIRO ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',144215,'2010-12-18',457290,'A');
INSERT INTO "personas" VALUES('674',1,'PEREZ GIL JOSE IGNACIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-08-18',781610,'A');
INSERT INTO "personas" VALUES('CELL3840',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('676',1,'GARCIA LONDONO FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-08-23',336160,'A');
INSERT INTO "personas" VALUES('677',3,'RIJLAARSDAM KARIN AN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-07-03',72210,'A');
INSERT INTO "personas" VALUES('679',1,'LIZCANO MONTEALEGRE ARNULFO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127203,'2011-02-01',546170,'A');
INSERT INTO "personas" VALUES('68',1,'MARTINEZ SILVA EDGAR','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-29',54250,'A');
INSERT INTO "personas" VALUES('680',3,'OLIVARI MAYER PATRICIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',122642,'2011-08-01',673170,'A');
INSERT INTO "personas" VALUES('682',3,'CHEVALIER FRANCK PIERRE CHARLES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',263813,'2010-12-01',617280,'A');
INSERT INTO "personas" VALUES('683',3,'NG WAI WING ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126909,'2011-06-14',904310,'A');
INSERT INTO "personas" VALUES('684',3,'MULLER DOMINGUEZ CARLOS ANDRES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-22',669700,'A');
INSERT INTO "personas" VALUES('685',3,'MOSQUEDA DOMNGUEZ ANGEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-04-08',635580,'A');
INSERT INTO "personas" VALUES('686',3,'LARREGUI MARIN LEON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-08',168800,'A');
INSERT INTO "personas" VALUES('687',3,'VARGAS VERGARA ALEJANDRO BRAULIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',159245,'2011-09-14',937260,'A');
INSERT INTO "personas" VALUES('688',3,'SKINNER LYNN  CHERYL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-12',179890,'A');
INSERT INTO "personas" VALUES('689',1,'URIBE CORREA LEONARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2010-07-29',87680,'A');
INSERT INTO "personas" VALUES('690',1,'TAMAYO JARAMILLO FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-11-10',898730,'A');
INSERT INTO "personas" VALUES('691',3,'MOTABAN DE BORGES PAULA ELENA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132958,'2010-09-24',230610,'A');
INSERT INTO "personas" VALUES('692',5,'FERNANDEZ NALDA JOSE MANUEL ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-06-28',456850,'A');
INSERT INTO "personas" VALUES('693',1,'GOMEZ RESTREPO JUAN FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-06-28',592420,'A');
INSERT INTO "personas" VALUES('694',1,'CARDENAS TAMAYO JOSE JAIME','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-08-08',591550,'A');
INSERT INTO "personas" VALUES('696',1,'RESTREPO ARANGO ALEJANDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-03-31',127820,'A');
INSERT INTO "personas" VALUES('697',1,'ROCABADO PASTRANA ROBERT JAVIER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127443,'2011-08-13',97600,'A');
INSERT INTO "personas" VALUES('698',3,'JARVINEN JOONAS JORI KRISTIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',196234,'2011-05-29',104560,'A');
INSERT INTO "personas" VALUES('699',1,'MORENO PEREZ HERNAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-08-30',230000,'A');
INSERT INTO "personas" VALUES('7',1,'PUYANA RAMOS GUILLERMO ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-08-27',331830,'A');
INSERT INTO "personas" VALUES('70',1,'GALINDO MANZANO JAVIER FRANCISCO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-31',214890,'A');
INSERT INTO "personas" VALUES('701',1,'ROMERO PEREZ ARCESIO JOSE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132775,'2011-07-13',491650,'A');
INSERT INTO "personas" VALUES('703',1,'CHAPARRO AGUDELO LEONARDO VIRGILIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-05-04',271320,'A');
INSERT INTO "personas" VALUES('704',5,'VASQUEZ YANIS MARIA DEL PILAR','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-10-13',508820,'A');
INSERT INTO "personas" VALUES('705',3,'BARBERO JOSE ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',116511,'2010-09-13',730170,'A');
INSERT INTO "personas" VALUES('706',1,'CARMONA HERNANDEZ MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-11-08',124380,'A');
INSERT INTO "personas" VALUES('707',1,'PEREZ SUAREZ JORGE ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132775,'2011-09-14',431370,'A');
INSERT INTO "personas" VALUES('708',1,'ROJAS JORGE MARIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',130135,'2011-04-01',783740,'A');
INSERT INTO "personas" VALUES('71',1,'DIAZ JUAN PABLO/JULES JAVIER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-10-01',247860,'A');
INSERT INTO "personas" VALUES('711',3,'CATALDO CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',116773,'2011-06-06',984810,'A');
INSERT INTO "personas" VALUES('716',5,'MACIAS PIZARRO PATRICIO ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-06-07',376260,'A');
INSERT INTO "personas" VALUES('717',1,'RENDON MAYA DAVID ALEXANDER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',130273,'2010-07-25',332310,'A');
INSERT INTO "personas" VALUES('718',3,'DE HILDEBRAND E GRISI FILHO CELSO CLAUDIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-11',532740,'A');
INSERT INTO "personas" VALUES('719',3,'ALLIEL FACUSSE JULIO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-06-20',666800,'A');
INSERT INTO "personas" VALUES('72',1,'LOPEZ ROJAS VICTOR DANIEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-11',594640,'A');
INSERT INTO "personas" VALUES('720',3,'CHEMELLO JIMENEZ GAETANO ALBERTO FRANCISCO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132958,'2010-06-23',735760,'A');
INSERT INTO "personas" VALUES('721',3,'GARCIA BEZANILLA RODOLFO EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-04-12',678420,'A');
INSERT INTO "personas" VALUES('722',1,'ARIAS EDWIN','191821112','CRA 25 CALLE 100','13@terra.com.co','2011-02-03',127492,'2008-04-24',184800,'A');
INSERT INTO "personas" VALUES('723',3,'SOHN JANG WON','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-06-07',888750,'A');
INSERT INTO "personas" VALUES('724',3,'WILHELM GIOVINE JAIME ROBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',115263,'2011-09-20',889340,'A');
INSERT INTO "personas" VALUES('726',3,'CASTILLERO DANIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',131272,'2011-05-13',234270,'A');
INSERT INTO "personas" VALUES('727',3,'PORTUGAL LANGHORST MAX GUILLERMO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-13',829960,'A');
INSERT INTO "personas" VALUES('729',3,'ALFONSO HERRANZ AGUSTIN ALFONSO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-07-21',745060,'A');
INSERT INTO "personas" VALUES('73',1,'DAVILA MENDEZ OSCAR DIEGO','191821112','CRA 25 CALLE 100','991@yahoo.com.mx','2011-02-03',128569,'2011-08-31',229630,'A');
INSERT INTO "personas" VALUES('730',3,'ALFONSO HERRANZ AGUSTIN CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2010-03-31',384360,'A');
INSERT INTO "personas" VALUES('731',1,'NOGUERA RAMIREZ CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-14',686610,'A');
INSERT INTO "personas" VALUES('732',1,'ACOSTA PERALTA FABIAN ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',134030,'2011-06-21',279960,'A');
INSERT INTO "personas" VALUES('733',3,'MAC LEAN PINA PEDRO SEGUNDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-05-23',339980,'A');
INSERT INTO "personas" VALUES('734',1,'LEON ARCOS ALEX','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2011-05-04',860020,'A');
INSERT INTO "personas" VALUES('736',3,'LAMARCA GARCIA GERMAN JULIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-04-29',820700,'A');
INSERT INTO "personas" VALUES('737',1,'PORTO VELASQUEZ LUIS MIGUEL','191821112','CRA 25 CALLE 100','321@hotmail.es','2011-02-03',133535,'2011-08-17',263060,'A');
INSERT INTO "personas" VALUES('738',1,'BUENAVENTURA MEDINA ERICK WILSON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',133535,'2011-09-18',853180,'A');
INSERT INTO "personas" VALUES('739',1,'LEVY ARRAZOLA RALPH MARC','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2011-09-27',476720,'A');
INSERT INTO "personas" VALUES('CELL3614',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('74',1,'RAMIREZ SORA EDISON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-03',364220,'A');
INSERT INTO "personas" VALUES('740',3,'MOON HYUNSIK ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',173192,'2011-05-15',824080,'A');
INSERT INTO "personas" VALUES('741',3,'LHUILLIER TRONCOSO GASTON MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-09-07',690230,'A');
INSERT INTO "personas" VALUES('742',3,'UNDURRAGA PELLEGRINI GONZALO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2010-11-21',978900,'A');
INSERT INTO "personas" VALUES('743',1,'SOLANO TRIBIN NICOLAS SIMON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',134022,'2011-03-16',823800,'A');
INSERT INTO "personas" VALUES('744',1,'NOGUERA BENAVIDES JACOBO ALONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-06',182300,'A');
INSERT INTO "personas" VALUES('745',1,'GARCIA LEON MARCO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2008-04-16',440110,'A');
INSERT INTO "personas" VALUES('746',1,'EMILIANI ROJAS ALEXANDER ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-09-12',653640,'A');
INSERT INTO "personas" VALUES('748',1,'CARRENO POULSEN HELGEN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-06',778370,'A');
INSERT INTO "personas" VALUES('749',1,'ALVARADO FANDINO ANDRES EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2008-11-05',48280,'A');
INSERT INTO "personas" VALUES('750',1,'DIAZ GRANADOS JUAN PABLO.','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-01-12',906290,'A');
INSERT INTO "personas" VALUES('751',1,'OVALLE BETANCOURT ALBERTO JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',134022,'2011-08-14',386620,'A');
INSERT INTO "personas" VALUES('752',3,'GUTIERREZ VERGARA JOSE MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-08',214250,'A');
INSERT INTO "personas" VALUES('753',3,'CHAPARRO GUAIMARAL LIZ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',147467,'2011-03-16',911350,'A');
INSERT INTO "personas" VALUES('754',3,'CORTES DE SOLMINIHAC PABLO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117002,'2011-01-20',914020,'A');
INSERT INTO "personas" VALUES('755',3,'CHETAIL VINCENT','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',239124,'2010-08-23',836050,'A');
INSERT INTO "personas" VALUES('756',3,'PERUGORRIA RODRIGUEZ JORGE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2010-10-17',438210,'A');
INSERT INTO "personas" VALUES('757',3,'GOLLMANN ROBERTO JUAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',167269,'2011-03-28',682870,'A');
INSERT INTO "personas" VALUES('758',3,'VARELA SEPULVEDA MARIA PILAR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2010-07-26',99730,'A');
INSERT INTO "personas" VALUES('759',3,'MEYER WELIKSON MICHELE JANIK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-05-10',450030,'A');
INSERT INTO "personas" VALUES('76',1,'VANEGAS RODRIGUEZ OSCAR IVAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-20',568310,'A');
INSERT INTO "personas" VALUES('77',3,'GATICA SOTOMAYOR MAURICIO VICENTE','191821112','CRA 25 CALLE 100','409@terra.com.co','2011-02-03',117002,'2010-05-13',444970,'A');
INSERT INTO "personas" VALUES('79',1,'PENA VALENZUELA DANIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-19',264790,'A');
INSERT INTO "personas" VALUES('8',1,'NAVARRO PALENCIA HUGO RAFAEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',126968,'2011-05-05',579980,'A');
INSERT INTO "personas" VALUES('80',1,'BARRIOS CUADRADO DAVID','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-29',764140,'A');
INSERT INTO "personas" VALUES('802',3,'RECK GARRONE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118942,'2009-02-06',767700,'A');
INSERT INTO "personas" VALUES('81',1,'PARRA QUIROGA JOSE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-18',26330,'A');
INSERT INTO "personas" VALUES('811',8,'FEDERACION NACIONAL DE AVICULTORES ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-04-18',926010,'A');
INSERT INTO "personas" VALUES('812',1,'ORJUELA VELEZ JAIME ALFONSO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-22',257160,'A');
INSERT INTO "personas" VALUES('813',1,'PENA CHACON GUSTAVO ADOLFO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-08-27',507770,'A');
INSERT INTO "personas" VALUES('814',1,'RONDEROS MOJICA ANDRES FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127443,'2011-05-04',767370,'A');
INSERT INTO "personas" VALUES('815',1,'RICO NINO MARIO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127443,'2011-05-18',313540,'A');
INSERT INTO "personas" VALUES('817',3,'AVILA CHYTIL MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118471,'2011-07-14',387300,'A');
INSERT INTO "personas" VALUES('818',3,'JABLONSKI DUARTE SILVEIRA ESTER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2010-12-21',139740,'A');
INSERT INTO "personas" VALUES('819',3,'BUHLER MOSLER XIMENA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2011-06-20',536830,'A');
INSERT INTO "personas" VALUES('82',1,'CARRILLO GAMBOA JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-06-01',839240,'A');
INSERT INTO "personas" VALUES('820',3,'FALQUETO DALMIRO ANGELO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-06-21',264910,'A');
INSERT INTO "personas" VALUES('821',1,'RUGER GUSTAVO RODRIGUEZ TAMAYO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2010-04-12',714080,'A');
INSERT INTO "personas" VALUES('822',3,'JULIO RODRIGUEZ FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117002,'2011-08-16',775650,'A');
INSERT INTO "personas" VALUES('823',3,'CIBANIK RODOLFO MOISES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132554,'2011-09-19',736020,'A');
INSERT INTO "personas" VALUES('824',3,'JIMENEZ FRANCO EMMANUEL ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-17',353150,'A');
INSERT INTO "personas" VALUES('825',3,'GNECCO TREMEDAD','191821112','CRA 25 CALLE 100','818@hotmail.com','2011-02-03',171072,'2011-03-19',557700,'A');
INSERT INTO "personas" VALUES('826',3,'VILAR MENDOZA JOSE RAFAEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-29',729050,'A');
INSERT INTO "personas" VALUES('827',3,'GONZALEZ MOLINA CRISTIAN MAURICIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-06-20',972160,'A');
INSERT INTO "personas" VALUES('828',1,'GONTOVNIK HOBRECKT CARLOS DANIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-08-02',673620,'A');
INSERT INTO "personas" VALUES('829',3,'DIBARRAT URZUA SEBASTIAN RAIMUNDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-28',451650,'A');
INSERT INTO "personas" VALUES('830',3,'STOCCHERO HATSCHBACH GUILHERME','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118777,'2010-11-22',237370,'A');
INSERT INTO "personas" VALUES('831',1,'NAVAS PASSOS NARCISO EVELIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-04-21',831900,'A');
INSERT INTO "personas" VALUES('832',3,'LUNA SOBENES FAVIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-10-11',447400,'A');
INSERT INTO "personas" VALUES('833',3,'NUNEZ NOGUEIRA ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2011-03-19',741290,'A');
INSERT INTO "personas" VALUES('834',1,'CASTRO BELTRAN ARIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128188,'2011-05-15',364270,'A');
INSERT INTO "personas" VALUES('835',1,'TURBAY YAMIN MAURICIO JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-03-17',597490,'A');
INSERT INTO "personas" VALUES('836',1,'GOMEZ BARRAZA RODNEY LORENZO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-07',894610,'A');
INSERT INTO "personas" VALUES('837',1,'CUELLO LASCANO ROBERTO','191821112','CRA 25 CALLE 100','221@hotmail.es','2011-02-03',133535,'2011-07-11',680610,'A');
INSERT INTO "personas" VALUES('838',1,'PATERNINA PEINADO JOSE VICENTE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',133535,'2011-08-23',719190,'A');
INSERT INTO "personas" VALUES('839',1,'YEPES RUBIANO ALFONSO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-05-16',554130,'A');
INSERT INTO "personas" VALUES('84',1,'ALVIS RAMIREZ ALFREDO','191821112','CRA 25 CALLE 100','292@yahoo.com','2011-02-03',127662,'2011-09-16',68190,'A');
INSERT INTO "personas" VALUES('840',1,'ROCA LLANOS GUILLERMO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-08-22',613060,'A');
INSERT INTO "personas" VALUES('841',1,'RENDON TORRALVO ENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2011-05-26',402950,'A');
INSERT INTO "personas" VALUES('842',1,'BLANCO STAND GERMAN ELIECER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-07-17',175530,'A');
INSERT INTO "personas" VALUES('843',3,'BERNAL MAYRA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',131272,'2010-08-31',668820,'A');
INSERT INTO "personas" VALUES('844',1,'NAVARRO RUIZ LAZARO GREGORIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',126916,'2008-09-23',817520,'A');
INSERT INTO "personas" VALUES('846',3,'TUOMINEN OLLI PETTERI','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-09-01',953150,'A');
INSERT INTO "personas" VALUES('847',1,'ESPARRAGOZA DE LA ESPRIELLA ENRIQUE ALBERTO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2011-08-09',522340,'A');
INSERT INTO "personas" VALUES('848',3,'ARAYA ARIAS JUAN VICENTE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132165,'2011-08-09',752210,'A');
INSERT INTO "personas" VALUES('85',1,'GARCIA JORGE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-03-01',989420,'A');
INSERT INTO "personas" VALUES('850',1,'PARDO GOMEZ GERMAN ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132775,'2010-11-25',713690,'A');
INSERT INTO "personas" VALUES('851',1,'ATIQUE JOSE MANUEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2008-03-03',986250,'A');
INSERT INTO "personas" VALUES('852',1,'HERNANDEZ MEYER EDGARDO DE JESUS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-07-20',790190,'A');
INSERT INTO "personas" VALUES('853',1,'ZULUAGA DE LEON IVAN JESUS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-07-03',992210,'A');
INSERT INTO "personas" VALUES('854',1,'VILLARREAL ANGULO ENRIQUE ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-10-02',590450,'A');
INSERT INTO "personas" VALUES('855',1,'CELIA MARTINEZ APARICIO GIAN PIERO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2011-06-15',975620,'A');
INSERT INTO "personas" VALUES('857',3,'LIPARI RONALDO LUIS','191821112','CRA 25 CALLE 100','84@facebook.com','2011-02-03',118941,'2010-10-13',606990,'A');
INSERT INTO "personas" VALUES('858',1,'RAVACHI DAVILA ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2011-05-04',714620,'A');
INSERT INTO "personas" VALUES('859',3,'PINHEIRO OLIVEIRA LUCIANO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-06',752130,'A');
INSERT INTO "personas" VALUES('86',1,'GOMEZ LIS CARLOS EMILIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2009-12-22',742520,'A');
INSERT INTO "personas" VALUES('860',1,'PUGLIESE MERCADO LUIGGI ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-08-19',616780,'A');
INSERT INTO "personas" VALUES('862',1,'JANNA TELLO DANIEL JALIL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2010-08-07',287220,'A');
INSERT INTO "personas" VALUES('863',3,'MATTAR CARLOS HENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2009-04-26',953570,'A');
INSERT INTO "personas" VALUES('864',1,'MOLINA OLIER OSVALDO ENRIQUE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132775,'2011-04-18',906200,'A');
INSERT INTO "personas" VALUES('865',1,'BLANCO MCLIN DAVID ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-08-18',670290,'A');
INSERT INTO "personas" VALUES('866',1,'NARANJO ROMERO ALFREDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2010-08-25',632860,'A');
INSERT INTO "personas" VALUES('867',1,'SIMANCAS TRUJILLO RICARDO ANTONIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-04-07',153400,'A');
INSERT INTO "personas" VALUES('868',1,'ARENAS USME GERMAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126881,'2011-10-01',868430,'A');
INSERT INTO "personas" VALUES('869',5,'DIAZ CORDERO RODRIGO FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-11-04',881950,'A');
INSERT INTO "personas" VALUES('87',1,'CELIS PEREZ HERNANDO ALONSO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-10-05',744330,'A');
INSERT INTO "personas" VALUES('870',3,'BINDER ZBEDA JONATAHAN JANAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',131083,'2010-04-11',804460,'A');
INSERT INTO "personas" VALUES('871',1,'HINCAPIE HELLMAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-09-15',376440,'A');
INSERT INTO "personas" VALUES('872',3,'MONTEIRO LANAMAR ALFONSO DE BUSTAMANTE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118942,'2009-03-23',468820,'A');
INSERT INTO "personas" VALUES('873',3,'AGUDO CARMINATTI REGINA CELIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-01-04',214770,'A');
INSERT INTO "personas" VALUES('874',1,'GONZALEZ VILLALOBOS CRISTIAN MANUEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2011-09-26',667400,'A');
INSERT INTO "personas" VALUES('875',3,'GUELL VILLANUEVA ALVARO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2008-04-07',692670,'A');
INSERT INTO "personas" VALUES('876',3,'GRES ANAIS ROBERTO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-12-01',461180,'A');
INSERT INTO "personas" VALUES('877',3,'GAME MOCOCAIN JUAN ENRIQUE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-07',227890,'A');
INSERT INTO "personas" VALUES('878',1,'FERRER UCROS FERNANDO LEON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-06-22',755900,'A');
INSERT INTO "personas" VALUES('879',3,'HERRERA JAUREGUI CARLOS GUSTAVO','191821112','CRA 25 CALLE 100','599@facebook.com','2011-02-03',131272,'2010-07-22',95840,'A');
INSERT INTO "personas" VALUES('880',3,'BACALLAO HERNANDEZ ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126180,'2010-04-21',211480,'A');
INSERT INTO "personas" VALUES('881',1,'GIJON URBINA JAIME','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',144879,'2011-04-03',769910,'A');
INSERT INTO "personas" VALUES('882',3,'TRUSEN CHRISTOPH WOLFGANG','191821112','CRA 25 CALLE 100','338@yahoo.com.mx','2011-02-03',127591,'2010-10-24',215100,'A');
INSERT INTO "personas" VALUES('883',3,'ASHOURI ASKANDAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',157861,'2009-03-03',765760,'A');
INSERT INTO "personas" VALUES('885',1,'ALTAMAR WATTS JAIRO ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-08-20',620170,'A');
INSERT INTO "personas" VALUES('887',3,'QUINTANA BALTIERRA ROBERTO ALEX','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-06-21',891370,'A');
INSERT INTO "personas" VALUES('889',1,'CARILLO PATINO VICTOR HILARIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',130226,'2011-09-06',354570,'A');
INSERT INTO "personas" VALUES('89',1,'CONTRERAS PULIDO LINA MARIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-06',237480,'A');
INSERT INTO "personas" VALUES('890',1,'GELVES CANAS GENARO ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-02',355640,'A');
INSERT INTO "personas" VALUES('891',3,'CAGNONI DE MELO PAULA CRISTINA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2010-12-14',714490,'A');
INSERT INTO "personas" VALUES('892',3,'MENA AMESTICA PATRICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2011-03-22',505510,'A');
INSERT INTO "personas" VALUES('893',1,'CAICEDO ROMES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-07',384110,'A');
INSERT INTO "personas" VALUES('894',1,'ECHEVERRY TRUJILLO ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-06-08',404010,'A');
INSERT INTO "personas" VALUES('895',1,'CAJIA PEDRAZA ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-02',867700,'A');
INSERT INTO "personas" VALUES('896',2,'PALACIOS OLIVA ANDRES FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-05-24',126500,'A');
INSERT INTO "personas" VALUES('897',1,'GUTIERREZ QUINTERO FABIAN ESTEBAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2009-10-24',29380,'A');
INSERT INTO "personas" VALUES('899',3,'COBO GUEVARA LUIS FELIPE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-12-09',748860,'A');
INSERT INTO "personas" VALUES('9',1,'OSORIO RODRIGUEZ FELIPE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-09-27',904420,'A');
INSERT INTO "personas" VALUES('90',1,'LEYTON GONZALEZ FREDY RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-03-24',705130,'A');
INSERT INTO "personas" VALUES('901',1,'HERNANDEZ JOSE ANGEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',130266,'2011-05-23',964010,'A');
INSERT INTO "personas" VALUES('CELL3652',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('903',3,'GONZALEZ MALDONADO MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2010-11-13',576500,'A');
INSERT INTO "personas" VALUES('904',1,'OCHOA BARRIGA JORGE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',130266,'2011-05-05',401380,'A');
INSERT INTO "personas" VALUES('CELL3886',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('905',1,'OSORIO REDONDO JESUS DAVID','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127300,'2011-08-11',277390,'A');
INSERT INTO "personas" VALUES('906',1,'BAYONA BARRIENTOS JEAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-01-25',182820,'A');
INSERT INTO "personas" VALUES('907',1,'MARTINEZ GOMEZ CARLOS ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132775,'2010-03-11',81940,'A');
INSERT INTO "personas" VALUES('908',1,'PUELLO LOPEZ GUILLERMO LEON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-08-12',861240,'A');
INSERT INTO "personas" VALUES('909',1,'MOGOLLON LONDONO PEDRO LUIS CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132775,'2011-06-22',60380,'A');
INSERT INTO "personas" VALUES('91',1,'ORTIZ RIOS JAVIER ADOLFO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-12',813200,'A');
INSERT INTO "personas" VALUES('911',1,'HERRERA HOYOS CARLOS FRANCISCO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132775,'2010-09-12',409800,'A');
INSERT INTO "personas" VALUES('912',3,'RIM MYUNG HWAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-15',894450,'A');
INSERT INTO "personas" VALUES('913',3,'BIANCO DORIEN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-29',242820,'A');
INSERT INTO "personas" VALUES('914',3,'FROIMZON WIEN DANIEL','191821112','CRA 25 CALLE 100','348@yahoo.com','2011-02-03',132165,'2010-11-06',530780,'A');
INSERT INTO "personas" VALUES('915',3,'ALVEZ AZEVEDO JOAO MIGUEL','191821112','CRA 25 CALLE 100','861@hotmail.es','2011-02-03',127591,'2009-06-25',925420,'A');
INSERT INTO "personas" VALUES('916',3,'CARRASCO DIAZ LUIS ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-10-02',34780,'A');
INSERT INTO "personas" VALUES('917',3,'VIVALLOS MEDINA LEONEL EDMUNDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2010-09-12',397640,'A');
INSERT INTO "personas" VALUES('919',3,'LASSE ANDRE BARKLIEN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',286724,'2011-03-31',226390,'A');
INSERT INTO "personas" VALUES('92',1,'CUERVO CARDENAS ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-08',950630,'A');
INSERT INTO "personas" VALUES('920',3,'BARCELOS PLOTEGHER LILIA MARA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-07',480380,'A');
INSERT INTO "personas" VALUES('921',1,'JARAMILLO ARANGO JUAN DIEGO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127559,'2011-06-28',722700,'A');
INSERT INTO "personas" VALUES('93',3,'RUIZ PRIETO WILLIAM','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',131272,'2011-01-19',313540,'A');
INSERT INTO "personas" VALUES('932',7,'COMFENALCO ANTIOQUIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-05',515430,'A');
INSERT INTO "personas" VALUES('94',1,'GALLEGO JUAN GUILLERMO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-25',715830,'A');
INSERT INTO "personas" VALUES('944',3,'KARMELIC PAVLOV VESNA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',120066,'2010-08-07',585580,'A');
INSERT INTO "personas" VALUES('945',3,'RAMIREZ BORDON OSCAR','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-07-02',526250,'A');
INSERT INTO "personas" VALUES('946',3,'SORACCO CABEZA RODRIGO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-07-04',874490,'A');
INSERT INTO "personas" VALUES('949',1,'GALINDO JORGE ERNESTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127300,'2008-07-10',344110,'A');
INSERT INTO "personas" VALUES('950',3,'DR KNABLE THOMAS ERNST ALBERT','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',256231,'2009-11-17',685430,'A');
INSERT INTO "personas" VALUES('953',3,'VELASQUEZ JANETH','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-20',404650,'A');
INSERT INTO "personas" VALUES('954',3,'SOZA REX JOSE FRANCISCO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',150903,'2011-05-26',269790,'A');
INSERT INTO "personas" VALUES('955',3,'FONTANA GAETE JAIME PATRICIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-01-11',134970,'A');
INSERT INTO "personas" VALUES('957',3,'PEREZ MARTINEZ GRECIA INDIRA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2010-08-27',922610,'A');
INSERT INTO "personas" VALUES('96',1,'FORERO CUBILLOS JORGEARTURO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-25',45020,'A');
INSERT INTO "personas" VALUES('97',1,'SILVA ACOSTA MARIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-19',309580,'A');
INSERT INTO "personas" VALUES('978',3,'BLUMENTHAL JAIRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117630,'2010-04-22',653490,'A');
INSERT INTO "personas" VALUES('984',3,'SUN XIAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-01-17',203630,'A');
INSERT INTO "personas" VALUES('99',1,'CANO GUZMAN ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-23',135620,'A');
INSERT INTO "personas" VALUES('999',1,' DRAGER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-12-22',882070,'A');
INSERT INTO "personas" VALUES('CELL1020',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1021',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1083',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1153',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1179',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1183',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL126',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1326',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1329',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL133',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1413',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1426',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1529',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1614',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1651',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1760',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL179',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1857',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1879',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1902',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1921',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1962',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1992',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2006',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL206',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL215',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2187',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2307',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2322',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2497',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2641',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2736',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2805',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL281',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2905',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2963',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL3029',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL3090',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL3161',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL3302',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL3309',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL3325',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL3372',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL3422',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL3661',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4334',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4415',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4440',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4547',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4639',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4662',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4698',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL475',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4790',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4838',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4885',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL4939',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5064',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5066',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL51',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5102',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5116',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5187',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5192',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5206',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5226',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5250',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5282',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL536',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5401',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5415',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5503',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5506',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL554',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5544',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5595',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5648',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5801',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5821',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6179',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6201',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6277',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6288',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6358',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6369',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6408',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6418',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6425',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6439',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6509',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6533',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6556',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL673',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6731',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6766',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6775',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6802',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6834',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6842',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6890',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6953',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6957',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7024',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7198',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7216',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL728',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7314',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7316',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7418',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7431',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7432',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7513',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7522',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7617',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7623',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7708',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7777',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL787',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7907',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7951',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7956',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8004',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8058',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL811',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8136',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8162',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8187',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8286',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8300',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8316',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8339',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8366',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8389',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8446',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8487',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8546',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8578',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8643',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8774',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8829',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8846',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL8942',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9046',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9110',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL917',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9189',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9206',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9241',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9331',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9429',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9434',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9495',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9517',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9558',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9650',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9748',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9830',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9842',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9878',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9893',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9945',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('T-Cx200',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx201',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx202',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx203',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx204',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx205',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx206',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx207',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx208',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx209',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx210',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx211',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx212',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx213',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('T-Cx214',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personas" VALUES('CELL4021',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5255',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5730',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2540',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7376',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2614',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL5471',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2588',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL570',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2854',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL6683',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL1382',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL2051',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL7086',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9220',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personas" VALUES('CELL9701',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');

DROP TABLE IF EXISTS `personnes`;
CREATE TABLE `personnes` (
  `cedula` char(15) NOT NULL,
  `tipo_documento_id` int(3) NOT NULL,
  `nombres` varchar(100) NOT NULL DEFAULT '',
  `telefono` varchar(20) DEFAULT NULL,
  `direccion` varchar(100) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT '1970-01-01',
  `ciudad_id` int(10) DEFAULT '0',
  `creado_at` date DEFAULT NULL,
  `cupo` decimal(16,2) NOT NULL,
  `estado` char(1) NOT NULL,
  PRIMARY KEY (`cedula`)
);
INSERT INTO "personnes" VALUES('1',3,'HUANG ZHENGQUIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-18',6930,'I');
INSERT INTO "personnes" VALUES('100',1,'USME FERNANDEZ JUAN GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-04-15',439480,'A');
INSERT INTO "personnes" VALUES('1003',8,'SINMON PEREZ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-25',468610,'A');
INSERT INTO "personnes" VALUES('1009',8,'ARCINIEGAS Y VILLAMIZAR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-08-12',967680,'A');
INSERT INTO "personnes" VALUES('101',1,'CRANE DE NARVAEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-06-09',790540,'A');
INSERT INTO "personnes" VALUES('1011',8,'EL EVENTO','191821112','CRA 25 CALLE 100','596@terra.com.co','2011-02-03',127591,'2011-05-24',820390,'A');
INSERT INTO "personnes" VALUES('1020',7,'OSPINA YOLANDA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-02',222970,'A');
INSERT INTO "personnes" VALUES('1025',7,'CHEMIPLAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-08',918670,'A');
INSERT INTO "personnes" VALUES('1034',1,'TAXI FILMS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-09-01',962580,'A');
INSERT INTO "personnes" VALUES('104',1,'CASTELLANOS JIMENEZ NOE','191821112','CRA 25 CALLE 100','127@yahoo.es','2011-02-03',127591,'2011-10-05',95230,'A');
INSERT INTO "personnes" VALUES('1046',3,'JACQUET PIERRE MICHEL ALAIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',263489,'2011-07-23',90810,'A');
INSERT INTO "personnes" VALUES('1048',5,'SPOERER VELEZ CARLOS JORGE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-02-03',184920,'A');
INSERT INTO "personnes" VALUES('1049',3,'SIDNEI DA SILVA LUIZ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117630,'2011-07-02',850180,'A');
INSERT INTO "personnes" VALUES('105',1,'HERRERA SEQUERA ALVARO FRANCISCO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-26',77390,'A');
INSERT INTO "personnes" VALUES('1050',3,'CAVALCANTI YUE CARLA HANLI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-31',696130,'A');
INSERT INTO "personnes" VALUES('1052',1,'BARRETO RIVAS ELKIN MARTIN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',131508,'2011-09-19',562160,'A');
INSERT INTO "personnes" VALUES('1053',3,'WANDERLEY ANTONIO ERNESTO THOME','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150617,'2011-01-31',20490,'A');
INSERT INTO "personnes" VALUES('1054',3,'HE SHAN','191821112','CRA 25 CALLE 100','715@yahoo.es','2011-02-03',132958,'2010-10-05',415970,'A');
INSERT INTO "personnes" VALUES('1055',3,'ZHRNG XIM','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-05',18380,'A');
INSERT INTO "personnes" VALUES('1057',3,'NICKEL GEB. STUTZ KARIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-10-08',164850,'A');
INSERT INTO "personnes" VALUES('1058',1,'VELEZ PAREJA IGNACIO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132775,'2011-06-24',292250,'A');
INSERT INTO "personnes" VALUES('1059',3,'GURKE RALF ERNST','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',287570,'2011-06-15',966700,'A');
INSERT INTO "personnes" VALUES('106',1,'ESTRADA LONDONO JUAN SIMON','191821112','CRA 25 CALLE 100','8@terra.com.co','2011-02-03',128579,'2011-03-09',101260,'A');
INSERT INTO "personnes" VALUES('1060',1,'MEDRANO BARRIOS WILSON','191821112','CRA 25 CALLE 100','479@facebook.com','2011-02-03',132775,'2011-06-18',956740,'A');
INSERT INTO "personnes" VALUES('1061',1,'GERDTS PORTO HANS EDUARDO','191821112','CRA 25 CALLE 100','140@gmail.com','2011-02-03',127591,'2011-05-09',883590,'A');
INSERT INTO "personnes" VALUES('1062',1,'BORGE VISBAL JORGE FIDEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132775,'2011-07-14',547750,'A');
INSERT INTO "personnes" VALUES('1063',3,'GUTIERREZ JOSELYN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-06',87960,'A');
INSERT INTO "personnes" VALUES('1064',4,'OVIEDO PINZON MARYI YULEY','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127538,'2011-04-21',796560,'A');
INSERT INTO "personnes" VALUES('1065',1,'VILORA SILVA OMAR ESTEBAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2010-06-09',718910,'A');
INSERT INTO "personnes" VALUES('1066',3,'AGUIAR ROMAN RODRIGO HUMBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126674,'2011-06-28',204890,'A');
INSERT INTO "personnes" VALUES('1067',1,'GOMEZ AGAMEZ ADOLFO DEL CRISTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',131105,'2011-06-15',867730,'A');
INSERT INTO "personnes" VALUES('1068',3,'GARRIDO CECILIA','191821112','CRA 25 CALLE 100','973@yahoo.com.mx','2011-02-03',118777,'2010-08-16',723980,'A');
INSERT INTO "personnes" VALUES('1069',1,'JIMENEZ MANJARRES DAVID RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132775,'2010-12-17',16680,'A');
INSERT INTO "personnes" VALUES('107',1,'ARANGUREN TEJADA JORGE ENRIQUE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-16',274110,'A');
INSERT INTO "personnes" VALUES('1070',3,'OYARZUN TEJEDA ANDRES FERNANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-26',911490,'A');
INSERT INTO "personnes" VALUES('1071',3,'MARIN BUCK RAFAEL ENRIQUE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126180,'2011-05-04',507400,'A');
INSERT INTO "personnes" VALUES('1072',3,'VARGAS JOSE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126674,'2011-07-28',802540,'A');
INSERT INTO "personnes" VALUES('1073',3,'JUEZ JAIRALA JOSE ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',126180,'2010-04-09',490510,'A');
INSERT INTO "personnes" VALUES('1074',1,'APONTE PENSO HERNAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132879,'2011-05-27',44900,'A');
INSERT INTO "personnes" VALUES('1075',1,'PINERES BUSTILLO ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',126916,'2008-10-29',752980,'A');
INSERT INTO "personnes" VALUES('1076',1,'OTERA OMA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-04-29',630210,'A');
INSERT INTO "personnes" VALUES('1077',3,'CONTRERAS CHINCHILLA JUAN DOMINGO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',139844,'2011-06-21',892110,'A');
INSERT INTO "personnes" VALUES('1078',1,'GAMBA LAURENCIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-09-15',569940,'A');
INSERT INTO "personnes" VALUES('108',1,'MUNOZ ARANGO JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-01',66770,'A');
INSERT INTO "personnes" VALUES('1080',1,'PRADA ABAUZA CARLOS AUGUSTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-11-15',156870,'A');
INSERT INTO "personnes" VALUES('1081',1,'PAOLA CAROLINA PINTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-27',264350,'A');
INSERT INTO "personnes" VALUES('1082',1,'PALOMINO HERNANDEZ GERMAN JAVIER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2011-03-22',851120,'A');
INSERT INTO "personnes" VALUES('1084',1,'URIBE DANIEL ALBERTO','191821112','CRA 25 CALLE 100','602@hotmail.es','2011-02-03',127591,'2011-09-07',759470,'A');
INSERT INTO "personnes" VALUES('1085',1,'ARGUELLO CALDERON ARMANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-24',409660,'A');
INSERT INTO "personnes" VALUES('1087',1,'CARVAJAL HERNANDEZ CHRISTIAN ARMANDO','191821112','CRA 25 CALLE 100','296@yahoo.es','2011-02-03',159432,'2011-06-03',620410,'A');
INSERT INTO "personnes" VALUES('1088',1,'CASTRO BLANCO MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',150512,'2009-10-08',792400,'A');
INSERT INTO "personnes" VALUES('1089',1,'RIBEROS GUTIERREZ GUSTAVO ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-01-27',100800,'A');
INSERT INTO "personnes" VALUES('109',1,'BELTRAN MARIA LUZ DARY','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-06',511510,'A');
INSERT INTO "personnes" VALUES('1091',4,'ORTIZ ORTIZ BENIGNO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127538,'2011-08-05',331540,'A');
INSERT INTO "personnes" VALUES('1092',3,'JOHN CHRISTOPHER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-08',277320,'A');
INSERT INTO "personnes" VALUES('1093',1,'PARRA VILLAREAL MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',129499,'2011-08-23',391980,'A');
INSERT INTO "personnes" VALUES('1094',1,'BESGA RODRIGUEZ JUAN JAVIER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127300,'2011-09-23',127960,'A');
INSERT INTO "personnes" VALUES('1095',1,'ZAPATA MEZA EDGAR FERNANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',129499,'2011-05-19',463840,'A');
INSERT INTO "personnes" VALUES('1096',3,'CORNEJO BRAVO MARCO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2010-11-08',935340,'A');
INSERT INTO "personnes" VALUES('CELL3944',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('1099',1,'GARCIA PORRAS FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-14',243360,'A');
INSERT INTO "personnes" VALUES('11',1,'HERNANDEZ PARDO ARMANDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-31',197540,'A');
INSERT INTO "personnes" VALUES('110',1,'VANEGAS JULIAN ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-06',357260,'A');
INSERT INTO "personnes" VALUES('1101',1,'QUINTERO BURBANO GABRIEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',129499,'2011-08-20',57420,'A');
INSERT INTO "personnes" VALUES('1102',1,'BOHORQUEZ AFANADOR CHRISTIAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-19',214610,'A');
INSERT INTO "personnes" VALUES('1103',1,'MORA VARGAS JULIO ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-29',900790,'A');
INSERT INTO "personnes" VALUES('1104',1,'PINEDA JORGE ARMANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-21',860110,'A');
INSERT INTO "personnes" VALUES('1105',1,'TORO CEBALLOS GONZALO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',129499,'2011-08-18',598180,'A');
INSERT INTO "personnes" VALUES('1106',1,'SCHENIDER TORRES JAIME','191821112','CRA 25 CALLE 100','85@yahoo.com.mx','2011-02-03',127799,'2011-08-11',410590,'A');
INSERT INTO "personnes" VALUES('1107',1,'RUEDA VILLAMIZAR JAIME','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-11-15',258410,'A');
INSERT INTO "personnes" VALUES('1108',1,'RUEDA VILLAMIZAR RICARDO JAIME','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',129499,'2011-03-22',60260,'A');
INSERT INTO "personnes" VALUES('1109',1,'GOMEZ RODRIGUEZ HERNANDO ARTURO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-06-02',526080,'A');
INSERT INTO "personnes" VALUES('111',1,'FRANCISCO EDUARDO JAIME BOTERO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-09-09',251770,'A');
INSERT INTO "personnes" VALUES('1110',1,'HERNANDEZ MENDEZ EDGAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',129499,'2011-03-22',449610,'A');
INSERT INTO "personnes" VALUES('1113',1,'LEON HERNANDEZ OSCAR','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',129499,'2011-03-21',992090,'A');
INSERT INTO "personnes" VALUES('1114',1,'LIZARAZO CARRENO HUGO ARCENIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',133535,'2010-12-10',959490,'A');
INSERT INTO "personnes" VALUES('1115',1,'LIAN BARRERA GABRIEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-05-30',821170,'A');
INSERT INTO "personnes" VALUES('1117',3,'TELLEZ BEZAN FRANCISCO JAVIER ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117002,'2011-08-21',673430,'A');
INSERT INTO "personnes" VALUES('1118',1,'FUENTES ARIZA DIEGO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-09',684970,'A');
INSERT INTO "personnes" VALUES('1119',1,'MOLINA M. ROBINSON','191821112','CRA 25 CALLE 100','728@hotmail.com','2011-02-03',129447,'2010-09-19',404580,'A');
INSERT INTO "personnes" VALUES('112',1,'PATINO PINTO ARIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-10-06',187050,'A');
INSERT INTO "personnes" VALUES('1120',1,'ORTIZ DURAN BENIGNO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127538,'2011-08-05',967970,'A');
INSERT INTO "personnes" VALUES('1121',1,'CARVAJAL ALMEIDA LUIS RAUL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',129499,'2011-06-22',626140,'A');
INSERT INTO "personnes" VALUES('1122',1,'TORRES QUIROGA EDWIN SILVESTRE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',129447,'2011-08-17',226780,'A');
INSERT INTO "personnes" VALUES('1123',1,'VIVIESCAS JAIMES ALVARO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-10',255480,'A');
INSERT INTO "personnes" VALUES('1124',1,'MARTINEZ RUEDA JAVIER EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',129447,'2011-06-23',597040,'A');
INSERT INTO "personnes" VALUES('1125',1,'ANAYA FLORES JORGE ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',129499,'2011-06-04',218790,'A');
INSERT INTO "personnes" VALUES('1126',3,'TORRES MARTINEZ ANTONIO JESUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2010-09-02',302820,'A');
INSERT INTO "personnes" VALUES('1127',3,'CACHO LEVISIER JOSE MANUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',153276,'2009-06-25',857720,'A');
INSERT INTO "personnes" VALUES('1129',3,'ULLOA VALDIVIESO CRISTIAN ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-06-02',327570,'A');
INSERT INTO "personnes" VALUES('113',1,'HIGUERA CALA JAIME ENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-27',179950,'A');
INSERT INTO "personnes" VALUES('1130',1,'ARCINIEGAS WILLIAM','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126892,'2011-08-05',497420,'A');
INSERT INTO "personnes" VALUES('1131',1,'BAZA ACUNA JAVIER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',129447,'2010-12-10',504410,'A');
INSERT INTO "personnes" VALUES('1132',3,'BUIRA ROS CARLOS MARIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-04-27',29750,'A');
INSERT INTO "personnes" VALUES('1133',1,'RODRIGUEZ JAIME','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',129447,'2011-06-10',635560,'A');
INSERT INTO "personnes" VALUES('1134',1,'QUIROGA PEREZ NELSON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',129447,'2011-05-18',88520,'A');
INSERT INTO "personnes" VALUES('1135',1,'TATIANA AYALA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127122,'2011-07-01',535920,'A');
INSERT INTO "personnes" VALUES('1136',1,'OSORIO BENEDETTI FABIAN AUGUSTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132775,'2010-10-23',414060,'A');
INSERT INTO "personnes" VALUES('1139',1,'CELIS PINTO ARMANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2009-02-25',964970,'A');
INSERT INTO "personnes" VALUES('114',1,'VALDERRAMA CUERVO JOSE IGNACIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-02',338590,'A');
INSERT INTO "personnes" VALUES('1140',1,'ORTIZ ARENAS JUAN MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',129499,'2009-10-21',613300,'A');
INSERT INTO "personnes" VALUES('1141',1,'VALDIVIESO ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',134022,'2009-01-13',171590,'A');
INSERT INTO "personnes" VALUES('1144',1,'LOPEZ CASTILLO NELSON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',129499,'2010-09-09',823110,'A');
INSERT INTO "personnes" VALUES('1145',1,'CAVELIER LUIS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',126916,'2008-11-29',389220,'A');
INSERT INTO "personnes" VALUES('1146',1,'CAVELIER OTOYA LUIS EDURDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126916,'2010-05-25',476770,'A');
INSERT INTO "personnes" VALUES('1147',1,'GARCIA RUEDA JUAN CARLOS','191821112','CRA 25 CALLE 100','111@yahoo.es','2011-02-03',133535,'2010-09-12',216190,'A');
INSERT INTO "personnes" VALUES('1148',1,'LADINO GOMEZ OMAR ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-02',650640,'A');
INSERT INTO "personnes" VALUES('1149',1,'CARRENO ORTIZ OSCAR JAVIER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-15',604630,'A');
INSERT INTO "personnes" VALUES('115',1,'NARDEI BONILLO BRUNO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-16',153110,'A');
INSERT INTO "personnes" VALUES('1150',1,'MONTOYA BOZZI MAURICIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',129499,'2011-05-12',71240,'A');
INSERT INTO "personnes" VALUES('1152',1,'LORA RICHARD JAVIER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-09-15',497700,'A');
INSERT INTO "personnes" VALUES('1153',1,'SILVA PINZON MARCO ANTONIO','191821112','CRA 25 CALLE 100','915@hotmail.es','2011-02-03',127591,'2011-06-15',861670,'A');
INSERT INTO "personnes" VALUES('1154',3,'GEORGE J A KHALILIEH','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-20',815260,'A');
INSERT INTO "personnes" VALUES('1155',3,'CHACON MARIN CARLOS MANUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-07-26',491280,'A');
INSERT INTO "personnes" VALUES('1156',3,'OCHOA CHEHAB XAVIER ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',126180,'2011-06-13',10630,'A');
INSERT INTO "personnes" VALUES('1157',3,'ARAYA GARRI GABRIEL ALEXIS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-09-19',579320,'A');
INSERT INTO "personnes" VALUES('1158',3,'MACCHI ARIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116366,'2010-04-12',864690,'A');
INSERT INTO "personnes" VALUES('116',1,'GONZALEZ FANDINO JAIME EDUARDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-10',749800,'A');
INSERT INTO "personnes" VALUES('1160',1,'CAVALIER LUIS EDUARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',126916,'2009-08-27',333390,'A');
INSERT INTO "personnes" VALUES('CELL396',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('1161',3,'DOMINGUEZ DE OBREGON ILEANA DEL CARMEN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',139844,'2011-03-06',910490,'A');
INSERT INTO "personnes" VALUES('1162',2,'FALASCA CLAUDIO ARIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116511,'2011-07-10',552280,'A');
INSERT INTO "personnes" VALUES('1163',3,'MUTABARUKA PATRICK','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131352,'2011-03-22',29940,'A');
INSERT INTO "personnes" VALUES('1164',1,'DOMINGUEZ ATENCIA JIMMY CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-07-22',492860,'A');
INSERT INTO "personnes" VALUES('1165',4,'LLANO GONZALEZ ALBERTO MARIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127300,'2010-08-21',374490,'A');
INSERT INTO "personnes" VALUES('1166',3,'LOPEZ ROLDAN JOSE MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-07-31',393860,'A');
INSERT INTO "personnes" VALUES('1167',1,'GUTIERREZ DE PINERES JALILIE ARISTIDES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2010-12-09',845810,'A');
INSERT INTO "personnes" VALUES('1168',1,'HEYMANS PIERRE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2010-11-08',47470,'A');
INSERT INTO "personnes" VALUES('1169',1,'BOTERO OSORIO RUBEN DARIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2009-05-27',699940,'A');
INSERT INTO "personnes" VALUES('1170',3,'GARNHAM POBLETE ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',116396,'2011-03-27',357270,'A');
INSERT INTO "personnes" VALUES('1172',1,'DAJUD DURAN JOSE RODRIGO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2009-12-02',360910,'A');
INSERT INTO "personnes" VALUES('1173',1,'MARTINEZ MERCADO PEDRO PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-07-25',744930,'A');
INSERT INTO "personnes" VALUES('1174',1,'GARCIA AMADOR ANDRES EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2011-05-19',641930,'A');
INSERT INTO "personnes" VALUES('1176',1,'VARGAS VARELA LUIS GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',131568,'2011-08-30',948410,'A');
INSERT INTO "personnes" VALUES('1178',1,'GUTIERRES DE PINERES ARISTIDES','191821112','CRA 25 CALLE 100','217@hotmail.com','2011-02-03',133535,'2011-05-10',242490,'A');
INSERT INTO "personnes" VALUES('1179',3,'LEIZAOLA POZO JIMENA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132958,'2011-08-01',759800,'A');
INSERT INTO "personnes" VALUES('118',1,'FERNANDEZ VELOSO PEDRO HERNANDO','191821112','CRA 25 CALLE 100','452@hotmail.es','2011-02-03',128662,'2010-08-06',198830,'A');
INSERT INTO "personnes" VALUES('1180',3,'MARINO PAOLO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-12-24',71520,'A');
INSERT INTO "personnes" VALUES('1181',1,'MOLINA VIZCAINO GUSTAVO JORGE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-04-28',78220,'A');
INSERT INTO "personnes" VALUES('1182',3,'MEDEL GARCIA FABIAN RODRIGO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-04-25',176540,'A');
INSERT INTO "personnes" VALUES('1183',1,'LESMES ARIAS RUBEN DARIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-09-09',648020,'A');
INSERT INTO "personnes" VALUES('1184',1,'ALCALA MARTINEZ ALFREDO ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132775,'2010-07-23',710470,'A');
INSERT INTO "personnes" VALUES('1186',1,'LLAMAS FOLIACO LUIS ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-07',910210,'A');
INSERT INTO "personnes" VALUES('1187',1,'GUARDO DEL RIO LIBARDO FARID','191821112','CRA 25 CALLE 100','73@yahoo.com.mx','2011-02-03',128662,'2011-09-01',726050,'A');
INSERT INTO "personnes" VALUES('1188',3,'JEFFREY ARTHUR DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',115724,'2011-03-21',899630,'A');
INSERT INTO "personnes" VALUES('1189',1,'DAHL VELEZ JULIANA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',126916,'2011-05-23',320020,'A');
INSERT INTO "personnes" VALUES('119',3,'WALESKA DE LIMA ALMEIDA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-05-09',125240,'A');
INSERT INTO "personnes" VALUES('1190',3,'LUIS JOSE MANUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2008-04-04',901210,'A');
INSERT INTO "personnes" VALUES('1192',1,'AZUERO VALENTINA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-14',26310,'A');
INSERT INTO "personnes" VALUES('1193',1,'MARQUEZ GALINDO MAURICIO JAVIER','191821112','CRA 25 CALLE 100','729@yahoo.es','2011-02-03',131105,'2011-05-13',493560,'A');
INSERT INTO "personnes" VALUES('1195',1,'NIETO FRANCO JUAN FELIPE','191821112','CRA 25 CALLE 100','707@yahoo.com','2011-02-03',127591,'2011-07-30',463790,'A');
INSERT INTO "personnes" VALUES('1196',3,'ESTEVES JOAQUIM LUIS FERNANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-04-05',152270,'A');
INSERT INTO "personnes" VALUES('1197',4,'BARRERO KAREN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-12',369990,'A');
INSERT INTO "personnes" VALUES('1198',1,'CORRALES GUZMAN DELIO ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127689,'2011-08-03',393120,'A');
INSERT INTO "personnes" VALUES('1199',1,'CUELLAR TOCO EDGAR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127531,'2011-09-20',855640,'A');
INSERT INTO "personnes" VALUES('12',1,'MARIN PRIETO FREDY NELSON ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-23',641210,'A');
INSERT INTO "personnes" VALUES('120',1,'LOPEZ JARAMILLO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2009-04-17',29680,'A');
INSERT INTO "personnes" VALUES('1200',3,'SCHULTER ACHIM','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',291002,'2010-05-21',98860,'A');
INSERT INTO "personnes" VALUES('1201',3,'HOWELL LAURENCE ADRIAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',286785,'2011-05-22',927350,'A');
INSERT INTO "personnes" VALUES('1202',3,'ALCAZAR ESCARATE JAIME PATRICIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117002,'2011-08-25',340160,'A');
INSERT INTO "personnes" VALUES('1203',3,'HIDALGO FUENZALIDA GABRIEL RAUL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-05-03',918780,'A');
INSERT INTO "personnes" VALUES('1206',1,'VANEGAS HENAO ORLANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-27',832910,'A');
INSERT INTO "personnes" VALUES('1207',1,'PENARANDA ARIAS RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-19',832710,'A');
INSERT INTO "personnes" VALUES('1209',1,'LEZAMA CERVERA JUAN CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132775,'2011-09-14',825980,'A');
INSERT INTO "personnes" VALUES('121',1,'PULIDO JIMENEZ OSCAR HUMBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-29',772700,'A');
INSERT INTO "personnes" VALUES('1211',1,'TRUJILLO BOCANEGRA HAROL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127538,'2011-05-27',199260,'A');
INSERT INTO "personnes" VALUES('1212',1,'ALVAREZ TORRES MARIO RICARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-08-15',589960,'A');
INSERT INTO "personnes" VALUES('1213',1,'CORRALES VARON BELMER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-26',352030,'A');
INSERT INTO "personnes" VALUES('1214',3,'CUEVAS RODRIGUEZ MANUELA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-30',990250,'A');
INSERT INTO "personnes" VALUES('1216',1,'LOPEZ EDICSON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-31',505210,'A');
INSERT INTO "personnes" VALUES('1217',3,'GARCIA PALOMARES JUAN JAVIER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-07-31',840440,'A');
INSERT INTO "personnes" VALUES('1218',1,'ARCINIEGAS NARANJO RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127492,'2010-12-17',686610,'A');
INSERT INTO "personnes" VALUES('122',1,'GONZALEZ RIANO LEONARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128031,'2011-08-05',774450,'A');
INSERT INTO "personnes" VALUES('1220',1,'GARCIA GUTIERREZ WILLIAM','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-06-20',498680,'A');
INSERT INTO "personnes" VALUES('1221',3,'GOMEZ DE ALONSO ANGELA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-27',758300,'A');
INSERT INTO "personnes" VALUES('1222',1,'MEDINA QUIROGA JAMES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127538,'2011-01-16',295480,'A');
INSERT INTO "personnes" VALUES('1224',1,'ARCILA CORREA JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-03-20',125900,'A');
INSERT INTO "personnes" VALUES('1225',1,'QUIJANO REYES CARLOS ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127538,'2010-04-08',22100,'A');
INSERT INTO "personnes" VALUES('157',1,'ORTIZ RIOS ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-12',365330,'A');
INSERT INTO "personnes" VALUES('1226',1,'VARGAS GALLEGO JAIRO ALONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2009-07-30',732820,'A');
INSERT INTO "personnes" VALUES('1228',3,'NAPANGA MIRENGHI MARTIN','191821112','CRA 25 CALLE 100','153@yahoo.es','2011-02-03',132958,'2011-02-08',790400,'A');
INSERT INTO "personnes" VALUES('123',1,'LAMUS CASTELLANOS ANDRES RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-11',554160,'A');
INSERT INTO "personnes" VALUES('1230',1,'RIVEROS PINEROS JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127492,'2011-09-25',422220,'A');
INSERT INTO "personnes" VALUES('1231',3,'ESSER JUAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127327,'2011-04-01',635060,'A');
INSERT INTO "personnes" VALUES('1232',3,'DOMINGUEZ MORA MAURICIO ALFREDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-22',908630,'A');
INSERT INTO "personnes" VALUES('1233',3,'MOLINA FERNANDEZ FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-05-28',637990,'A');
INSERT INTO "personnes" VALUES('1234',3,'BELLO DANIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',196234,'2010-09-04',464040,'A');
INSERT INTO "personnes" VALUES('1235',3,'BENADAVA GUEVARA DAVID ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-05-18',406240,'A');
INSERT INTO "personnes" VALUES('1236',3,'RODRIGUEZ MATOS ROBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-03-22',639070,'A');
INSERT INTO "personnes" VALUES('1237',3,'TAPIA ALARCON PATRICIO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2010-07-06',976620,'A');
INSERT INTO "personnes" VALUES('1239',3,'VERCHERE ALFONSO CHRISTIAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117002,'2010-08-23',899600,'A');
INSERT INTO "personnes" VALUES('1241',1,'ESPINEL LUIS FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128206,'2009-03-09',302860,'A');
INSERT INTO "personnes" VALUES('1242',3,'VERGARA FERREIRA PATRICIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-10-03',713310,'A');
INSERT INTO "personnes" VALUES('1243',3,'ZUMARRAGA SIRVENT CRSTINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-08-24',657950,'A');
INSERT INTO "personnes" VALUES('1244',4,'ESCORCIA VASQUEZ TOMAS','191821112','CRA 25 CALLE 100','354@yahoo.com.mx','2011-02-03',128662,'2011-04-01',149830,'A');
INSERT INTO "personnes" VALUES('1245',4,'PARAMO CUENCA KELLY LORENA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127492,'2011-05-04',775300,'A');
INSERT INTO "personnes" VALUES('1246',4,'PEREZ LOPEZ VERONICA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-07-11',426990,'A');
INSERT INTO "personnes" VALUES('1247',4,'CHAPARRO RODRIGUEZ DANIELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-10-08',809070,'A');
INSERT INTO "personnes" VALUES('1249',4,'DIAZ MARTINEZ MARIA CAROLINA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2011-05-30',394740,'A');
INSERT INTO "personnes" VALUES('125',1,'CALDON RODRIGUEZ JAIME ARIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126968,'2011-07-29',574780,'A');
INSERT INTO "personnes" VALUES('1250',4,'PINEDA VASQUEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2010-09-03',680540,'A');
INSERT INTO "personnes" VALUES('1251',5,'MATIZ URIBE ANGELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-12-25',218470,'A');
INSERT INTO "personnes" VALUES('1253',1,'ZAMUDIO RICAURTE JAIRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126892,'2011-08-05',598160,'A');
INSERT INTO "personnes" VALUES('1254',1,'ALJURE FRANCISCO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-07-21',838660,'A');
INSERT INTO "personnes" VALUES('1255',3,'ARMESTO AIRA ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',196234,'2011-01-29',398840,'A');
INSERT INTO "personnes" VALUES('1257',1,'POTES GUEVARA JAIRO MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127858,'2011-03-17',194580,'A');
INSERT INTO "personnes" VALUES('1258',1,'BURBANO QUIROGA RAFAEL','191821112','CRA 25 CALLE 100','767@facebook.com','2011-02-03',127591,'2011-04-07',538220,'A');
INSERT INTO "personnes" VALUES('1259',1,'CARDONA GOMEZ JAVIR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-03-16',107380,'A');
INSERT INTO "personnes" VALUES('126',1,'PULIDO PARDO GUIDO IVAN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-10-05',531550,'A');
INSERT INTO "personnes" VALUES('1260',1,'LOPERA LEDESMA PABLO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-09-19',922240,'A');
INSERT INTO "personnes" VALUES('1263',1,'TRIBIN BARRIGA JUAN MANUEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2011-09-02',525330,'A');
INSERT INTO "personnes" VALUES('1264',1,'NAVIA LOPEZ ANDRES FELIPE ','191821112','CRA 25 CALLE 100','353@hotmail.es','2011-02-03',127300,'2011-07-15',591190,'A');
INSERT INTO "personnes" VALUES('1265',1,'CARDONA GOMEZ FABIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2010-11-18',379940,'A');
INSERT INTO "personnes" VALUES('1266',1,'ESCARRIA VILLEGAS ANDRES JULIAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-08-19',126160,'A');
INSERT INTO "personnes" VALUES('1268',1,'CASTRO HERNANDEZ ALVARO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2011-03-25',76260,'A');
INSERT INTO "personnes" VALUES('127',1,'RODRIGUEZ RODRIGUEZ GIOVANI FRANCISCO','191821112','CRA 25 CALLE 100','662@hotmail.es','2011-02-03',127591,'2011-09-29',933390,'A');
INSERT INTO "personnes" VALUES('1270',1,'LEAL HERNANDEZ MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-24',313610,'A');
INSERT INTO "personnes" VALUES('1272',1,'ORTIZ CARDONA WILLIAM ENRIQUE','191821112','CRA 25 CALLE 100','914@hotmail.com','2011-02-03',128662,'2011-09-13',272150,'A');
INSERT INTO "personnes" VALUES('1273',1,'ROMERO VAN GOMPEL HERNAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-09-07',832960,'A');
INSERT INTO "personnes" VALUES('1274',1,'BERMUDEZ LONDONO JHON FREDY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127300,'2011-08-29',348380,'A');
INSERT INTO "personnes" VALUES('1275',1,'URREA ALVAREZ NICOLAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-01',242980,'A');
INSERT INTO "personnes" VALUES('1276',1,'VALENCIA LLANOS RODRIGO AUGUSTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-04-11',169790,'A');
INSERT INTO "personnes" VALUES('1277',1,'PAZ VALENCIA GUILLERMO ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127300,'2011-08-05',120020,'A');
INSERT INTO "personnes" VALUES('1278',1,'MONROY CORREDOR GERARDO ALONSO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2011-06-25',90700,'A');
INSERT INTO "personnes" VALUES('1279',1,'RIOS MEDINA JAVIER ERMINSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-09-12',93440,'A');
INSERT INTO "personnes" VALUES('128',1,'GALLEGO GUZMAN MARIO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-06-25',72290,'A');
INSERT INTO "personnes" VALUES('1280',1,'GARCIA OSCAR EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127662,'2011-09-30',195090,'A');
INSERT INTO "personnes" VALUES('1282',1,'MURILLO PESELLIN GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-06-15',890530,'A');
INSERT INTO "personnes" VALUES('1284',1,'DIAZ ALVAREZ JOHNY','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2011-06-25',164130,'A');
INSERT INTO "personnes" VALUES('1285',1,'GARCES BELTRAN RAUL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2011-08-11',719220,'A');
INSERT INTO "personnes" VALUES('1286',1,'MATERON POVEDA LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-25',103710,'A');
INSERT INTO "personnes" VALUES('1287',1,'VALENCIA ALEXANDER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-10-23',360880,'A');
INSERT INTO "personnes" VALUES('1288',1,'PENA AGUDELO JOSE RAMON','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',134022,'2011-05-25',493280,'A');
INSERT INTO "personnes" VALUES('1289',1,'CORREA NUNEZ JORGE ALEXANDER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-08-18',383750,'A');
INSERT INTO "personnes" VALUES('129',1,'ALVAREZ RODRIGUEZ IVAN RICARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2008-01-28',561290,'A');
INSERT INTO "personnes" VALUES('1291',1,'BEJARANO ROSERO FREDDY ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-10-09',43400,'A');
INSERT INTO "personnes" VALUES('1292',1,'CASTILLO BARRIOS GUSTAVO ADOLFO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2011-06-17',900180,'A');
INSERT INTO "personnes" VALUES('CELL401',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('1296',1,'GALVEZ GUTIERREZ JUAN PABLO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2010-03-28',807090,'A');
INSERT INTO "personnes" VALUES('1297',3,'CRUZ GARCIA MILTON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',139844,'2011-03-21',75630,'A');
INSERT INTO "personnes" VALUES('1298',1,'VILLEGAS GUTIERREZ JOSE RICARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-11',956860,'A');
INSERT INTO "personnes" VALUES('13',1,'VACA MURCIA JESUS ALFREDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-04',613430,'A');
INSERT INTO "personnes" VALUES('1301',3,'BOTTI ALFONSO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',231989,'2011-04-04',910640,'A');
INSERT INTO "personnes" VALUES('1302',3,'COTINO HUESO LORENZO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-02-02',803450,'A');
INSERT INTO "personnes" VALUES('1304',3,'NESPOLI MANTOVANI LUIZ CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-04-18',16230,'A');
INSERT INTO "personnes" VALUES('1307',4,'AVILA GIL PAULA ANDREA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-19',711110,'A');
INSERT INTO "personnes" VALUES('1308',4,'VALLEJO PINEDA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-08-12',323490,'A');
INSERT INTO "personnes" VALUES('1312',1,'ROMERO OSCAR EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-17',642460,'A');
INSERT INTO "personnes" VALUES('1314',3,'LULLIES CONSTANZE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',245206,'2010-06-03',154970,'A');
INSERT INTO "personnes" VALUES('1315',1,'CHAPARRO GUTIERREZ JORGE ADRIANO','191821112','CRA 25 CALLE 100','284@hotmail.es','2011-02-03',127591,'2010-12-02',325440,'A');
INSERT INTO "personnes" VALUES('1316',1,'BARRANTES DISI RICARDO JOSE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132879,'2011-07-18',162270,'A');
INSERT INTO "personnes" VALUES('1317',3,'VERDES GAGO JOSE ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2010-03-10',835060,'A');
INSERT INTO "personnes" VALUES('1319',3,'MARTIN MARTINEZ GUSTAVO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2010-05-26',937220,'A');
INSERT INTO "personnes" VALUES('1320',3,'MOTTURA MASSIMO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2008-11-10',620640,'A');
INSERT INTO "personnes" VALUES('1321',3,'RUSSELL TIMOTHY JAMES','191821112','CRA 25 CALLE 100','502@hotmail.es','2011-02-03',145135,'2010-04-16',291560,'A');
INSERT INTO "personnes" VALUES('1322',3,'JAIN TARSEM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',190393,'2011-05-31',595890,'A');
INSERT INTO "personnes" VALUES('1323',3,'ORTEGA CEVALLOS JULIETA ELIZABETH','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-30',104760,'A');
INSERT INTO "personnes" VALUES('1324',3,'MULLER PICHAIDA ANDRES FELIPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-05-17',736130,'A');
INSERT INTO "personnes" VALUES('1325',3,'ALVEAR TELLEZ JULIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-01-23',366390,'A');
INSERT INTO "personnes" VALUES('1327',3,'MOYA LATORRE MARCELA CAROLINA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-05-17',18520,'A');
INSERT INTO "personnes" VALUES('1328',3,'LAMA ZAROR RODRIGO IGNACIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2010-10-27',221990,'A');
INSERT INTO "personnes" VALUES('1329',3,'HERNANDEZ CIFUENTES MAURICE JEANETTE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',139844,'2011-06-22',54410,'A');
INSERT INTO "personnes" VALUES('133',1,'CORDOBA HOYOS JUAN PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-20',966820,'A');
INSERT INTO "personnes" VALUES('1330',2,'HOCHKOFLER NOEMI CONSUELO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-27',606070,'A');
INSERT INTO "personnes" VALUES('1331',4,'RAMIREZ BARRERO DANIELA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',154563,'2011-04-18',867120,'A');
INSERT INTO "personnes" VALUES('1332',4,'DE LEON DURANGO RICARDO JOSE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131105,'2011-09-08',517400,'A');
INSERT INTO "personnes" VALUES('1333',4,'RODRIGUEZ MACIAS IVAN MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',129447,'2011-05-23',985620,'A');
INSERT INTO "personnes" VALUES('1334',4,'GUTIERREZ DE PINERES YANET MARIA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',133535,'2011-06-16',375890,'A');
INSERT INTO "personnes" VALUES('1335',4,'GUTIERREZ DE PINERES YANET MARIA GABRIELA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-06-16',922600,'A');
INSERT INTO "personnes" VALUES('1336',4,'CABRALES BECHARA JOSE MARIA','191821112','CRA 25 CALLE 100','708@hotmail.com','2011-02-03',131105,'2011-05-13',485330,'A');
INSERT INTO "personnes" VALUES('1337',4,'MEJIA TOBON LUIS DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127662,'2011-08-05',658860,'A');
INSERT INTO "personnes" VALUES('1338',3,'OROS NERCELLES CRISTIAN ANDRE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',144215,'2011-04-26',838310,'A');
INSERT INTO "personnes" VALUES('1339',3,'MORENO BRAVO CAROLINA ANDREA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',190393,'2010-12-08',214950,'A');
INSERT INTO "personnes" VALUES('134',1,'GONZALEZ LOPEZ DANIEL ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-08',178580,'A');
INSERT INTO "personnes" VALUES('1340',3,'FERNANDEZ GARRIDO MARCELO FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-07-08',559820,'A');
INSERT INTO "personnes" VALUES('1342',3,'SUMEGI IMRE ZOLTAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-16',91750,'A');
INSERT INTO "personnes" VALUES('1343',3,'CALDERON FLANDEZ SERGIO','191821112','CRA 25 CALLE 100','108@hotmail.com','2011-02-03',117002,'2010-12-12',996030,'A');
INSERT INTO "personnes" VALUES('1345',3,'CARBONELL ATCHUGARRY GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',116366,'2010-04-12',536390,'A');
INSERT INTO "personnes" VALUES('1346',3,'MONTEALEGRE AGUILAR FEDERICO ','191821112','CRA 25 CALLE 100','448@yahoo.es','2011-02-03',132165,'2011-08-08',567260,'A');
INSERT INTO "personnes" VALUES('1347',1,'HERNANDEZ MANCHEGO CARLOS JULIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-04-28',227130,'A');
INSERT INTO "personnes" VALUES('1348',1,'ARENAS ZARATE FERNEY ARNULFO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127963,'2011-03-26',433860,'A');
INSERT INTO "personnes" VALUES('1349',3,'DELFIM DINIZ PASSOS PINHEIRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',110784,'2010-04-17',487930,'A');
INSERT INTO "personnes" VALUES('135',1,'GARCIA SIMBAQUEBA RUBEN DARIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-25',992420,'A');
INSERT INTO "personnes" VALUES('1350',3,'BRAUN VALENZUELA FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-29',138050,'A');
INSERT INTO "personnes" VALUES('1351',3,'LEVIN FIORELLI ANDRES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',116366,'2011-04-10',226470,'A');
INSERT INTO "personnes" VALUES('1353',3,'BALTODANO ESQUIVEL LAURA CRISTINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132165,'2011-08-01',911660,'A');
INSERT INTO "personnes" VALUES('1354',4,'ESCOBAR  YEPES ANDREA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-19',403630,'A');
INSERT INTO "personnes" VALUES('1356',1,'GAGELI OSORIO ALEJANDRO','191821112','CRA 25 CALLE 100','228@yahoo.com.mx','2011-02-03',128662,'2011-07-14',205070,'A');
INSERT INTO "personnes" VALUES('1357',3,'CABAL ALVAREZ RUBEN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-08-14',175770,'A');
INSERT INTO "personnes" VALUES('1359',4,'HUERFANO JUAN DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-04',790970,'A');
INSERT INTO "personnes" VALUES('136',1,'OSORIO RAMIREZ LEONARDO','191821112','CRA 25 CALLE 100','686@yahoo.es','2011-02-03',128662,'2010-05-14',426380,'A');
INSERT INTO "personnes" VALUES('1360',4,'RAMON GARCIA MARIA PAULA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-01',163890,'A');
INSERT INTO "personnes" VALUES('1362',30,'ALVAREZ CLAVIO CARLA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127203,'2011-04-18',741020,'A');
INSERT INTO "personnes" VALUES('1363',3,'SERRA DURAN GERARDO ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-08-03',365490,'A');
INSERT INTO "personnes" VALUES('1364',3,'NORIEGA VALVERDE SILVIA MARCELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132775,'2011-02-27',604370,'A');
INSERT INTO "personnes" VALUES('1366',1,'JARAMILLO LOPEZ ALEJANDRO','191821112','CRA 25 CALLE 100','269@terra.com.co','2011-02-03',127559,'2010-11-08',813800,'A');
INSERT INTO "personnes" VALUES('1367',1,'MAZO ROLDAN CARLOS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-05-04',292880,'A');
INSERT INTO "personnes" VALUES('1368',1,'MURIEL ARCILA MAURICIO HERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-29',22970,'A');
INSERT INTO "personnes" VALUES('1369',1,'RAMIREZ CARLOS FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-14',236230,'A');
INSERT INTO "personnes" VALUES('137',1,'LUNA PEREZ JUAN PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',126881,'2011-08-05',154640,'A');
INSERT INTO "personnes" VALUES('1370',1,'GARCIA GRAJALES PEDRO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128166,'2011-10-09',112230,'A');
INSERT INTO "personnes" VALUES('1372',3,'GARCIA ESCOBAR ANA MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2011-03-29',925670,'A');
INSERT INTO "personnes" VALUES('1373',3,'ALVES DIAS CARLOS AUGUSTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-07',70940,'A');
INSERT INTO "personnes" VALUES('1374',3,'MATTOS CHRISTIANE GARCIA CID','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',183024,'2010-08-25',577700,'A');
INSERT INTO "personnes" VALUES('1376',1,'CARVAJAL ROJAS ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-10',645240,'A');
INSERT INTO "personnes" VALUES('1377',3,'MADARIAGA CADIZ CLAUDIO CRISTIAN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2011-10-04',199200,'A');
INSERT INTO "personnes" VALUES('1379',3,'MARIN YANEZ ALICIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-02-20',703870,'A');
INSERT INTO "personnes" VALUES('138',1,'DIAZ AVENDANO MARCELO IVAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-22',494080,'A');
INSERT INTO "personnes" VALUES('1381',3,'COSTA VILLEGAS LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117002,'2011-08-21',580670,'A');
INSERT INTO "personnes" VALUES('1382',3,'DAZA PEREZ JOSE LUIS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',122035,'2009-02-23',888000,'A');
INSERT INTO "personnes" VALUES('1385',4,'RIVEROS ARIAS MARIA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127492,'2011-09-26',35710,'A');
INSERT INTO "personnes" VALUES('1386',30,'TORO GIRALDO MATEO','191821112','CRA 25 CALLE 100','433@yahoo.com.mx','2011-02-03',127591,'2011-07-17',700730,'A');
INSERT INTO "personnes" VALUES('1387',4,'ROJAS YARA LAURA DANIELA MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-31',396530,'A');
INSERT INTO "personnes" VALUES('1388',3,'GALLEGO RODRIGO MARIA PILAR','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2009-04-19',880450,'A');
INSERT INTO "personnes" VALUES('1389',1,'PANTOJA VELASQUEZ JOSE ARMANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127300,'2011-08-05',212660,'A');
INSERT INTO "personnes" VALUES('139',1,'FRANCO GOMEZ HERNÁN EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-01-19',6450,'A');
INSERT INTO "personnes" VALUES('1390',3,'VAN DEN BORNE KEES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2010-01-28',421930,'A');
INSERT INTO "personnes" VALUES('1391',3,'MONDRAGON FLORES JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-08-22',471700,'A');
INSERT INTO "personnes" VALUES('1392',3,'BAGELLA MICHELE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-07-27',92720,'A');
INSERT INTO "personnes" VALUES('1393',3,'BISTIANCIC MACHADO ANA INES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',116366,'2010-08-02',48490,'A');
INSERT INTO "personnes" VALUES('1394',3,'BANADOS ORTIZ MARIA PILAR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-08-25',964280,'A');
INSERT INTO "personnes" VALUES('1395',1,'CHINDOY CHINDOY HERNANDO','191821112','CRA 25 CALLE 100','107@terra.com.co','2011-02-03',126892,'2011-08-25',675920,'A');
INSERT INTO "personnes" VALUES('1396',3,'SOTO NUNEZ ANDRES ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-10-02',486760,'A');
INSERT INTO "personnes" VALUES('1397',1,'DELGADO MARTINEZ LORGE ELIAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-23',406040,'A');
INSERT INTO "personnes" VALUES('1398',1,'LEON GUEVARA JAVIER ANIBAL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',126892,'2011-09-08',569930,'A');
INSERT INTO "personnes" VALUES('1399',1,'ZARAMA BASTIDAS LUIS GABRIEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126892,'2011-08-05',631540,'A');
INSERT INTO "personnes" VALUES('14',1,'MAGUIN HENNSSEY LUIS FERNANDO','191821112','CRA 25 CALLE 100','714@gmail.com','2011-02-03',127591,'2011-07-11',143540,'A');
INSERT INTO "personnes" VALUES('140',1,'CARRANZA CUY ALEXANDER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-25',550010,'A');
INSERT INTO "personnes" VALUES('1401',3,'REYNA CASTORENA JOSE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',189815,'2011-08-29',344970,'A');
INSERT INTO "personnes" VALUES('1402',1,'GFALLO BOTERO SERGIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-07-14',381100,'A');
INSERT INTO "personnes" VALUES('1403',1,'ARANGO ARAQUE JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-05-04',870590,'A');
INSERT INTO "personnes" VALUES('1404',3,'LASSNER NORBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118942,'2010-02-28',209650,'A');
INSERT INTO "personnes" VALUES('1405',1,'DURANGO MARIN HECTOR LEON','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'1970-02-02',436480,'A');
INSERT INTO "personnes" VALUES('1407',1,'FRANCO CASTANO DIEGO MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-06-28',457770,'A');
INSERT INTO "personnes" VALUES('1408',1,'HERNANDEZ SERGIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-05-29',628550,'A');
INSERT INTO "personnes" VALUES('1409',1,'CASTANO DUQUE CARLOS HUGO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-03-23',769410,'A');
INSERT INTO "personnes" VALUES('141',1,'CHAMORRO CHEDRAUI SERGIO ALBERTO','191821112','CRA 25 CALLE 100','922@yahoo.com.mx','2011-02-03',127591,'2011-05-07',730720,'A');
INSERT INTO "personnes" VALUES('1411',1,'RAMIREZ MONTOYA ADAMO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-04-13',498880,'A');
INSERT INTO "personnes" VALUES('1412',1,'GONZALEZ BENJUMEA OSCAR HUMBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-11-01',610150,'A');
INSERT INTO "personnes" VALUES('1413',1,'ARANGO ACEVEDO WALTER ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-10-07',554090,'A');
INSERT INTO "personnes" VALUES('1414',1,'ARANGO GALLO HUMBERTO LEON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-02-25',940010,'A');
INSERT INTO "personnes" VALUES('1415',1,'VELASQUEZ LUIS GONZALO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-07-06',37760,'A');
INSERT INTO "personnes" VALUES('1416',1,'MIRA AGUILAR FRANCISCO ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-30',368790,'A');
INSERT INTO "personnes" VALUES('1417',1,'RIVERA ARISTIZABAL CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-03-02',730670,'A');
INSERT INTO "personnes" VALUES('1418',1,'ARISTIZABAL ROLDAN ANDRES RICARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-02',546960,'A');
INSERT INTO "personnes" VALUES('142',1,'LOPEZ ZULETA MAURICIO ALEXANDER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-01',3550,'A');
INSERT INTO "personnes" VALUES('1420',1,'ESCORCIA ARAMBURO JUAN MARIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-04-01',73100,'A');
INSERT INTO "personnes" VALUES('1421',1,'CORREA PARRA RICARDO ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-08-05',737110,'A');
INSERT INTO "personnes" VALUES('1422',1,'RESTREPO NARANJO DANIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-09-15',466240,'A');
INSERT INTO "personnes" VALUES('1423',1,'VELASQUEZ CARLOS JUAN','191821112','CRA 25 CALLE 100','123@yahoo.com','2011-02-03',128662,'2010-06-09',119880,'A');
INSERT INTO "personnes" VALUES('1424',1,'MACIA GONZALEZ ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2010-11-12',200690,'A');
INSERT INTO "personnes" VALUES('1425',1,'BERRIO MEJIA HELBER ANTONIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2010-06-04',643800,'A');
INSERT INTO "personnes" VALUES('1427',1,'GOMEZ GUTIERREZ CARLOS ARIEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-09-08',153320,'A');
INSERT INTO "personnes" VALUES('1428',1,'RESTREPO LOPEZ JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-12',915770,'A');
INSERT INTO "personnes" VALUES('CELL4012',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('1429',1,'BARTH TOBAR LUIS FERNANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-02-23',118900,'A');
INSERT INTO "personnes" VALUES('143',1,'MUNERA BEDIYA JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-09-21',825600,'A');
INSERT INTO "personnes" VALUES('1430',1,'JIMENEZ VELEZ ANDRES EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-02-26',847160,'A');
INSERT INTO "personnes" VALUES('1431',1,'TAKAHASHI GAVIRIA NICOLAS KEIICHIRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-13',879120,'A');
INSERT INTO "personnes" VALUES('1432',1,'ESCOBAR JARAMILLO ESTEBAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2010-06-10',854110,'A');
INSERT INTO "personnes" VALUES('1433',1,'PALACIO NAVARRO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-08-18',633200,'A');
INSERT INTO "personnes" VALUES('1434',1,'LONDONO MUNOZ ADOLFO LEON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-09-14',603670,'A');
INSERT INTO "personnes" VALUES('1435',1,'PULGARIN JAIME ANDRES','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2009-11-01',118730,'A');
INSERT INTO "personnes" VALUES('1436',1,'FERRERA ZULUAGA LUIS FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-07-10',782630,'A');
INSERT INTO "personnes" VALUES('1437',1,'VASQUEZ VELEZ HABACUC','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-27',557000,'A');
INSERT INTO "personnes" VALUES('1438',1,'HENAO PALOMINO DIEGO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2009-05-06',437080,'A');
INSERT INTO "personnes" VALUES('1439',1,'HURTADO URIBE JUAN GONZALO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-01-11',514400,'A');
INSERT INTO "personnes" VALUES('144',1,'ALDANA RODOLFO AUGUSTO','191821112','CRA 25 CALLE 100','838@yahoo.es','2011-02-03',127591,'2011-08-07',117350,'A');
INSERT INTO "personnes" VALUES('1441',1,'URIBE DANIEL ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2010-11-19',760610,'A');
INSERT INTO "personnes" VALUES('1442',1,'PINEDA GALIANO JUAN CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-07-29',20770,'A');
INSERT INTO "personnes" VALUES('1443',1,'DUQUE BETANCOURT FABIO LEON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-11-26',822030,'A');
INSERT INTO "personnes" VALUES('1444',1,'JARAMILLO TORO HERNAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-04-27',47830,'A');
INSERT INTO "personnes" VALUES('145',1,'VASQUEZ ZAPATA JUAN CARLOS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-09',109940,'A');
INSERT INTO "personnes" VALUES('1450',1,'TOBON FRANCO MARCO ANTONIO','191821112','CRA 25 CALLE 100','545@facebook.com','2011-02-03',127591,'2011-05-03',889540,'A');
INSERT INTO "personnes" VALUES('1454',1,'LOTERO PAVAS CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-05-28',646750,'A');
INSERT INTO "personnes" VALUES('1455',1,'ESTRADA HENAO JAVIER ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128569,'2009-09-07',215460,'A');
INSERT INTO "personnes" VALUES('1456',1,'VALDERRAMA MAXIMILIANO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-23',137030,'A');
INSERT INTO "personnes" VALUES('1457',3,'ESTRADA ALVAREZ GONZALO ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',154903,'2011-05-02',38790,'A');
INSERT INTO "personnes" VALUES('1458',1,'PAUCAR VALLEJO JAIRO ALONSO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-10-15',782860,'A');
INSERT INTO "personnes" VALUES('1459',1,'RESTREPO GIRALDO JHON DARIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-04-04',797930,'A');
INSERT INTO "personnes" VALUES('146',1,'BAQUERO FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2010-03-03',197650,'A');
INSERT INTO "personnes" VALUES('1460',1,'RESTREPO DOMINGUEZ GUSTAVO ADOLFO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2009-05-18',641050,'A');
INSERT INTO "personnes" VALUES('1461',1,'YANOVICH JACKY','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-08-21',811470,'A');
INSERT INTO "personnes" VALUES('1462',1,'HINCAPIE ROLDAN JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-08-27',134200,'A');
INSERT INTO "personnes" VALUES('1463',3,'ZEA JORGE OLIVER','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',150699,'2011-03-12',236610,'A');
INSERT INTO "personnes" VALUES('1464',1,'OSCAR MAURICIO ECHAVARRIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-11-24',780440,'A');
INSERT INTO "personnes" VALUES('1465',1,'COSSIO GIL JOSE ALEXANDER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-10-01',192380,'A');
INSERT INTO "personnes" VALUES('1466',1,'GOMEZ CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-03-01',620580,'A');
INSERT INTO "personnes" VALUES('1467',1,'VILLALOBOS OCHOA ANDRES GABRIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-08-18',525740,'A');
INSERT INTO "personnes" VALUES('1470',1,'GARCIA GONZALEZ DAVID DARIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-09-17',986990,'A');
INSERT INTO "personnes" VALUES('1471',1,'RAMIREZ RESTREPO ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-04-03',162250,'A');
INSERT INTO "personnes" VALUES('1472',1,'VASQUEZ GUTIERREZ JUAN ANDRES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-05',850280,'A');
INSERT INTO "personnes" VALUES('1474',1,'ESCOBAR ARANGO DAVID','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-11-01',272460,'A');
INSERT INTO "personnes" VALUES('1475',1,'MEJIA TORO JUAN DAVID','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-05-02',68320,'A');
INSERT INTO "personnes" VALUES('1477',1,'ESCOBAR GOMEZ JUAN MANUEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127848,'2011-05-15',416150,'A');
INSERT INTO "personnes" VALUES('1478',1,'BETANCUR WILSON','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2008-02-09',508060,'A');
INSERT INTO "personnes" VALUES('1479',3,'ROMERO ARRAU GONZALO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-10',291880,'A');
INSERT INTO "personnes" VALUES('148',1,'REINA MORENO MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-08',699240,'A');
INSERT INTO "personnes" VALUES('1480',1,'CASTANO OSORIO JORGE ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127662,'2011-09-20',935200,'A');
INSERT INTO "personnes" VALUES('1482',1,'LOPEZ LOPERA ROBINSON FREDY','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-09-02',196280,'A');
INSERT INTO "personnes" VALUES('1484',1,'HERNAN DARIO RENDON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-03-18',312520,'A');
INSERT INTO "personnes" VALUES('1485',1,'MARTINEZ ARBOLEDA MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2010-11-03',821760,'A');
INSERT INTO "personnes" VALUES('1486',1,'RODRIGUEZ MORA CARLOS MORA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-09-16',171270,'A');
INSERT INTO "personnes" VALUES('1487',1,'PENAGOS VASQUEZ JOSE DOMINGO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-09-06',391080,'A');
INSERT INTO "personnes" VALUES('1488',1,'UERRA MEJIA DIEGO LEON','191821112','CRA 25 CALLE 100','704@hotmail.com','2011-02-03',144086,'2011-08-06',441570,'A');
INSERT INTO "personnes" VALUES('1491',1,'QUINTERO GUTIERREZ ABEL PASTOR','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2009-11-16',138100,'A');
INSERT INTO "personnes" VALUES('1492',1,'ALARCON YEPES IVAN DARIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',150699,'2010-05-03',145330,'A');
INSERT INTO "personnes" VALUES('1494',1,'HERNANDEZ VALLEJO ANDRES MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-09',125770,'A');
INSERT INTO "personnes" VALUES('1495',1,'MONTOYA MORENO LUIS MIGUEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-11-09',691770,'A');
INSERT INTO "personnes" VALUES('1497',1,'BARRERA CARLOS ANDRES','191821112','CRA 25 CALLE 100','62@yahoo.es','2011-02-03',127591,'2010-08-24',332550,'A');
INSERT INTO "personnes" VALUES('1498',1,'ARROYAVE FERNANDEZ PABLO EMILIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-05-12',418030,'A');
INSERT INTO "personnes" VALUES('1499',1,'GOMEZ ANGEL FELIPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-05-03',92480,'A');
INSERT INTO "personnes" VALUES('15',1,'AMSILI COHEN JOSEPH','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-07',877400,'A');
INSERT INTO "personnes" VALUES('CELL411',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('150',3,'ARDILA GUTIERREZ DANIEL MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-12',506760,'A');
INSERT INTO "personnes" VALUES('1500',1,'GONZALEZ DUQUE PABLO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-04-13',208330,'A');
INSERT INTO "personnes" VALUES('1502',1,'MEJIA BUSTAMANTE JUAN FELIPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-08-09',196000,'A');
INSERT INTO "personnes" VALUES('1506',1,'SUAREZ MONTOYA JUAN PABLO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128569,'2011-09-13',368250,'A');
INSERT INTO "personnes" VALUES('1508',1,'ALVAREZ GONZALEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-02-15',355190,'A');
INSERT INTO "personnes" VALUES('1509',1,'NIETO CORREA ANDRES FELIPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-03-31',899980,'A');
INSERT INTO "personnes" VALUES('1511',1,'HERNANDEZ GRANADOS JHONATHAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-08-30',471720,'A');
INSERT INTO "personnes" VALUES('1512',1,'CARDONA ALVAREZ DEIBY','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2010-10-05',55590,'A');
INSERT INTO "personnes" VALUES('1513',1,'TORRES MARULANDA JUAN ESTEBAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-10-20',862820,'A');
INSERT INTO "personnes" VALUES('1514',1,'RAMIREZ RAMIREZ JHON JAIRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-05-11',147310,'A');
INSERT INTO "personnes" VALUES('1515',1,'MONDRAGON TORO NICOLAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-01-19',148100,'A');
INSERT INTO "personnes" VALUES('1517',3,'SUIDA DIETER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2008-07-21',48580,'A');
INSERT INTO "personnes" VALUES('1518',3,'LEFTWICH ANDREW PAUL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',211610,'2011-06-07',347170,'A');
INSERT INTO "personnes" VALUES('1519',3,'RENTON ANDREW GEORGE PATRICK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2010-12-11',590120,'A');
INSERT INTO "personnes" VALUES('152',1,'BUSTOS MONZON CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-22',335160,'A');
INSERT INTO "personnes" VALUES('1521',3,'JOSE CUSTODIO DO ALTISSIMO NETONETO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',119814,'2011-04-28',775000,'A');
INSERT INTO "personnes" VALUES('1522',3,'GUARACI FRANCO DE PAIVA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',119167,'2011-04-28',147770,'A');
INSERT INTO "personnes" VALUES('1525',4,'MORENO TENORIO MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-20',888750,'A');
INSERT INTO "personnes" VALUES('1527',1,'VELASQUEZ HERNANDEZ JHON EDUARSON','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-07-19',161270,'A');
INSERT INTO "personnes" VALUES('1528',4,'VANEGAS ALEJANDRA','191821112','CRA 25 CALLE 100','185@yahoo.com','2011-02-03',127591,'2011-06-20',109830,'A');
INSERT INTO "personnes" VALUES('1529',3,'BARBABE CLAIRE LAURENCE ANNICK','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-04',65330,'A');
INSERT INTO "personnes" VALUES('153',1,'GONZALEZ TORREZ MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-01',762560,'A');
INSERT INTO "personnes" VALUES('1530',3,'COREA MARTINEZ GUILLERMO JOSE ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',135360,'2011-09-25',997190,'A');
INSERT INTO "personnes" VALUES('1531',3,'PACHECO RODRIGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117002,'2010-03-08',789960,'A');
INSERT INTO "personnes" VALUES('1532',3,'WELCH RICHARD WILLIAM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',190393,'2010-10-04',958210,'A');
INSERT INTO "personnes" VALUES('1533',3,'FOREMAN CAROLYN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',107159,'2011-05-23',421200,'A');
INSERT INTO "personnes" VALUES('1535',3,'ZAGAL SOTO CLAUDIA PAZ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2008-05-16',893130,'A');
INSERT INTO "personnes" VALUES('1536',3,'ZAGAL SOTO CLAUDIA PAZ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-10-08',771600,'A');
INSERT INTO "personnes" VALUES('1538',3,'BLANCO RODRIGUEZ JUAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',197162,'2011-04-02',578250,'A');
INSERT INTO "personnes" VALUES('154',1,'HENDEZ PUERTO JAVIER ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-25',807310,'A');
INSERT INTO "personnes" VALUES('1540',3,'CONTRERAS BRAIN JAVIER ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-02-22',42420,'A');
INSERT INTO "personnes" VALUES('1541',3,'RONDON HERNANDEZ MARYLIN DEL CARMEN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-09-29',145780,'A');
INSERT INTO "personnes" VALUES('1542',3,'ELJURI RAMIREZ EMIRA ELIZABETH','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132958,'2010-10-13',601670,'A');
INSERT INTO "personnes" VALUES('1544',3,'REYES LE ROY TOMAS FRANCISCO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2009-06-24',49990,'A');
INSERT INTO "personnes" VALUES('1545',3,'GHETEA GAMUZ JENNY','191821112','CRA 25 CALLE 100','675@gmail.com','2011-02-03',150699,'2010-05-29',536940,'A');
INSERT INTO "personnes" VALUES('1546',3,'DUARTE GONZALEZ ROONEY ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-06-20',534720,'A');
INSERT INTO "personnes" VALUES('1548',3,'BIZOT PHILIPPE PIERRE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',263813,'2011-03-02',709760,'A');
INSERT INTO "personnes" VALUES('1549',3,'PELUFFO RUBIO GUILLERMO JUAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',116366,'2011-05-09',360470,'A');
INSERT INTO "personnes" VALUES('1550',3,'AGLIATI YERKOVIC CAROLINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2010-06-01',673040,'A');
INSERT INTO "personnes" VALUES('1551',3,'SEPULVEDA LEDEZMA HENRY CORNELIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-08-15',283810,'A');
INSERT INTO "personnes" VALUES('1552',3,'CABRERA CARMINE JAIME FRANCO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2008-11-30',399940,'A');
INSERT INTO "personnes" VALUES('1553',3,'ZINNO PENA ALVARO ANTONIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116366,'2010-08-02',148270,'A');
INSERT INTO "personnes" VALUES('1554',3,'ROMERO BUCCICARDI JUAN CRISTOBAL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-08-01',541530,'A');
INSERT INTO "personnes" VALUES('1555',3,'FEFERKORN ABRAHAM','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',159312,'2011-06-12',262840,'A');
INSERT INTO "personnes" VALUES('1556',3,'MASSE CATESSON CAROLINE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131272,'2011-06-12',689600,'A');
INSERT INTO "personnes" VALUES('1557',3,'CATESSON ALEXANDRA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',131272,'2011-06-12',659470,'A');
INSERT INTO "personnes" VALUES('1558',3,'FUENTES HERNANDEZ RICARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-18',228540,'A');
INSERT INTO "personnes" VALUES('1559',3,'GUEVARA MENJIVAR WILSON ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-18',164310,'A');
INSERT INTO "personnes" VALUES('1560',3,'DANOWSKI NICOLAS JAMES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-02',135920,'A');
INSERT INTO "personnes" VALUES('1561',3,'CASTRO VELASQUEZ ISMAEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',121318,'2011-07-31',186670,'A');
INSERT INTO "personnes" VALUES('1562',3,'RODRIGUEZ CORNEJO CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-18',525590,'A');
INSERT INTO "personnes" VALUES('1563',3,'VANIA CAROLINA FLORES AVILA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-18',67950,'A');
INSERT INTO "personnes" VALUES('1564',3,'ARMERO RAMOS OSCAR ALEXANDER','191821112','CRA 25 CALLE 100','414@hotmail.com','2011-02-03',127591,'2011-09-18',762950,'A');
INSERT INTO "personnes" VALUES('1565',3,'ORELLANA MARTINEZ JUAN CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-18',610930,'A');
INSERT INTO "personnes" VALUES('1566',3,'BRATT BABONNEAU CARLOS MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-09-14',765800,'A');
INSERT INTO "personnes" VALUES('1567',3,'YANES FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150728,'2011-04-12',996200,'A');
INSERT INTO "personnes" VALUES('1568',3,'ANGULO TAMAYO SEBASTIAN GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126674,'2011-05-19',683600,'A');
INSERT INTO "personnes" VALUES('1569',3,'HENRIQUEZ JOSE LUIS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',138329,'2011-08-15',429390,'A');
INSERT INTO "personnes" VALUES('CELL4137',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('1570',3,'GARCIA VILLARROEL RAUL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',126189,'2011-06-12',96140,'A');
INSERT INTO "personnes" VALUES('1571',3,'SOLA HERNANDEZ JOSE FRANCISCO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-09-25',192530,'A');
INSERT INTO "personnes" VALUES('1572',3,'PEREZ PASTOR OSWALDO MAGARREY','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126674,'2011-05-25',674260,'A');
INSERT INTO "personnes" VALUES('1573',3,'MICHAN QUINONES FRANCISCO JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-06-21',793680,'A');
INSERT INTO "personnes" VALUES('1574',3,'GARCIA ARANDA OSCAR DAVID','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-08-15',945620,'A');
INSERT INTO "personnes" VALUES('1575',3,'GARCIA RIBAS JORDI','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-07-10',347070,'A');
INSERT INTO "personnes" VALUES('1576',3,'GALVAN ROMERO MARIA INMACULADA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-09-14',898480,'A');
INSERT INTO "personnes" VALUES('1577',3,'BOSH MOLINAS JUAN JOSE ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',198576,'2011-08-22',451190,'A');
INSERT INTO "personnes" VALUES('1578',3,'MARTIN TENA JOSE MARIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-04-24',560520,'A');
INSERT INTO "personnes" VALUES('1579',3,'HAWKINS ROBERT JAMES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-12',449010,'A');
INSERT INTO "personnes" VALUES('1580',3,'GHERARDI ALEJANDRO EMILIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',180063,'2010-11-15',563500,'A');
INSERT INTO "personnes" VALUES('1581',3,'TELLO JUAN EDUARDO','191821112','CRA 25 CALLE 100','192@hotmail.com','2011-02-03',138329,'2011-05-01',470460,'A');
INSERT INTO "personnes" VALUES('1583',3,'GUZMAN VALDIVIA CINTIA TATIANA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',199862,'2011-04-06',897580,'A');
INSERT INTO "personnes" VALUES('1584',3,'STUBBS MERCEDES CARMEN JOSEFINA DEL MILAGRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',199862,'2011-04-06',502510,'A');
INSERT INTO "personnes" VALUES('1585',3,'QUINTEIRO GORIS JOSE ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-17',819840,'A');
INSERT INTO "personnes" VALUES('1587',3,'RIVAS LORIA PRISCILLA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',205636,'2011-05-01',498720,'A');
INSERT INTO "personnes" VALUES('1588',3,'DE LA TORRE AUGUSTO PATRICIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',20404,'2011-08-31',718670,'A');
INSERT INTO "personnes" VALUES('159',1,'ALDANA PATINO NORMAN ALEXANDER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2009-10-10',201500,'A');
INSERT INTO "personnes" VALUES('1590',3,'TORRES VILLAR ROBERTO ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-08-10',329950,'A');
INSERT INTO "personnes" VALUES('1591',3,'PETRULLI CARMELO MORENO','191821112','CRA 25 CALLE 100','883@yahoo.com.mx','2011-02-03',127591,'2011-06-20',358180,'A');
INSERT INTO "personnes" VALUES('1592',3,'MUSCO ENZO FRANCESCO GIUSEPPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-04',801050,'A');
INSERT INTO "personnes" VALUES('1593',3,'RONCUZZI CLAUDIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127134,'2011-10-02',930700,'A');
INSERT INTO "personnes" VALUES('1594',3,'VELANI FRANCESCA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',199862,'2011-08-22',250360,'A');
INSERT INTO "personnes" VALUES('1596',3,'BENARROCH ASSOR DAVID ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-10-06',547310,'A');
INSERT INTO "personnes" VALUES('1597',3,'FLO VILLASECA ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-05-27',357520,'A');
INSERT INTO "personnes" VALUES('1598',3,'FONT RIBAS ANTONI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',196117,'2011-09-21',145660,'A');
INSERT INTO "personnes" VALUES('1599',3,'LOPEZ BARAHONA MONICA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2011-08-03',655740,'A');
INSERT INTO "personnes" VALUES('16',1,'FLOREZ PEREZ GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132572,'2011-03-30',956370,'A');
INSERT INTO "personnes" VALUES('160',1,'GIRALDO MENDIVELSO MARTIN EDISSON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-14',429010,'A');
INSERT INTO "personnes" VALUES('1600',3,'SCATTIATI ALDO ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',215245,'2011-07-10',841730,'A');
INSERT INTO "personnes" VALUES('1601',3,'MARONE CARLO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',101179,'2011-06-14',241420,'A');
INSERT INTO "personnes" VALUES('1602',3,'CHUVASHEVA ELENA ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',190393,'2011-08-21',681900,'A');
INSERT INTO "personnes" VALUES('1603',3,'GIGLIO FRANCISCO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',122035,'2011-09-19',685250,'A');
INSERT INTO "personnes" VALUES('1604',3,'JUSTO AMATE AGUSTIN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',174598,'2011-05-16',380560,'A');
INSERT INTO "personnes" VALUES('1605',3,'GUARDABASSI FABIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',281044,'2011-07-26',847060,'A');
INSERT INTO "personnes" VALUES('1606',3,'CALABRETTA FRAMCESCO ANTONIO MARIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',199862,'2011-08-22',93590,'A');
INSERT INTO "personnes" VALUES('1607',3,'TARTARINI MASSIMO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',196234,'2011-05-10',926800,'A');
INSERT INTO "personnes" VALUES('1608',3,'BOTTI GIAIME','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',231989,'2011-04-04',353210,'A');
INSERT INTO "personnes" VALUES('1610',3,'PILERI ANDREA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',205040,'2011-09-01',868590,'A');
INSERT INTO "personnes" VALUES('1612',3,'MARTIN GRACIA LUIS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-07-27',324320,'A');
INSERT INTO "personnes" VALUES('1613',3,'GRACIA MARTIN LUIS','191821112','CRA 25 CALLE 100','579@facebook.com','2011-02-03',198248,'2011-08-24',463560,'A');
INSERT INTO "personnes" VALUES('1614',3,'SERRAT SESE JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',196234,'2011-05-16',344840,'A');
INSERT INTO "personnes" VALUES('1615',3,'DEL LAGO AMPELIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-06-29',333510,'A');
INSERT INTO "personnes" VALUES('1616',3,'PERUGORRIA RODRIGUEZ JORGE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',148511,'2011-06-06',633040,'A');
INSERT INTO "personnes" VALUES('1617',3,'GIRAL CALVO IGNACIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-09-19',164670,'A');
INSERT INTO "personnes" VALUES('1618',3,'ALONSO CEBRIAN JOSE MARIA','191821112','CRA 25 CALLE 100','253@terra.com.co','2011-02-03',188640,'2011-03-23',924240,'A');
INSERT INTO "personnes" VALUES('162',1,'ARIZA PINEDA JOHN ALEXANDER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-11-27',415710,'A');
INSERT INTO "personnes" VALUES('1620',3,'OLMEDO CARDENETE DOMINGO MIGUEL','191821112','CRA 25 CALLE 100','608@terra.com.co','2011-02-03',135397,'2011-09-03',863200,'A');
INSERT INTO "personnes" VALUES('1622',3,'GIMENEZ BALDRES ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',182860,'2011-05-12',82660,'A');
INSERT INTO "personnes" VALUES('1623',3,'NUNEZ MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-05-23',609950,'A');
INSERT INTO "personnes" VALUES('1624',3,'PENATE CASTRO WENCESLAO LORENZO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',153607,'2011-09-13',801750,'A');
INSERT INTO "personnes" VALUES('1626',3,'ESCODA MIGUEL JOAN JOSEP','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-07-18',489310,'A');
INSERT INTO "personnes" VALUES('1628',3,'ESTRADA CAPILLA ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-07-26',81180,'A');
INSERT INTO "personnes" VALUES('163',1,'PERDOMO LOPEZ ANDRES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-05',456910,'A');
INSERT INTO "personnes" VALUES('1630',3,'SUBIRAIS MARIANA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',196234,'2011-09-08',138700,'A');
INSERT INTO "personnes" VALUES('1632',3,'ENSENAT VELASCO JAIME LUIS','191821112','CRA 25 CALLE 100','687@gmail.com','2011-02-03',188640,'2011-04-12',904560,'A');
INSERT INTO "personnes" VALUES('1633',3,'DIEZ POLANCO CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-05-24',530410,'A');
INSERT INTO "personnes" VALUES('1636',3,'CUADRA ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-09-04',688400,'A');
INSERT INTO "personnes" VALUES('1637',3,'UBRIC MUNOZ RAUL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',98790,'2011-05-30',139830,'A');
INSERT INTO "personnes" VALUES('CELL4159',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('1638',3,'NEDDERMANN GUJO RICARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-07-31',633990,'A');
INSERT INTO "personnes" VALUES('1639',3,'RENEDO ZALBA JAIME','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-03-13',750430,'A');
INSERT INTO "personnes" VALUES('164',1,'JIMENEZ PADILLA JOHAN MARCEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-05',37430,'A');
INSERT INTO "personnes" VALUES('1640',3,'FERNANDEZ MORENO DAVID','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-05-28',850180,'A');
INSERT INTO "personnes" VALUES('1641',3,'VERGARA SERRANO JUAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-06-30',999620,'A');
INSERT INTO "personnes" VALUES('1642',3,'MARTINEZ HUESO LUCAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',182860,'2011-06-29',447570,'A');
INSERT INTO "personnes" VALUES('1643',3,'FRANCO POBLET JUAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',196234,'2011-10-03',238990,'A');
INSERT INTO "personnes" VALUES('1644',3,'MORA HIDALGO MIGUEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-06',852250,'A');
INSERT INTO "personnes" VALUES('1645',3,'GARCIA COSO EMILIANO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-09-14',544260,'A');
INSERT INTO "personnes" VALUES('1646',3,'GIMENO ESCRIG ENRIQUE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',180124,'2011-09-20',164580,'A');
INSERT INTO "personnes" VALUES('1647',3,'MORCILLO LOPEZ RAMON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127538,'2011-04-16',190090,'A');
INSERT INTO "personnes" VALUES('1648',3,'RUBIO BONET MANUEL','191821112','CRA 25 CALLE 100','252@facebook.com','2011-02-03',196234,'2011-05-25',456740,'A');
INSERT INTO "personnes" VALUES('1649',3,'PRADO ABUIN FERNANDO ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-07-16',713400,'A');
INSERT INTO "personnes" VALUES('165',1,'RAMIREZ PALMA LUIS FELIPE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-10',816420,'A');
INSERT INTO "personnes" VALUES('1650',3,'DE VEGA PUJOL GEMA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-08-01',196780,'A');
INSERT INTO "personnes" VALUES('1651',3,'IBARGUEN ALFREDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2010-12-03',843720,'A');
INSERT INTO "personnes" VALUES('1652',3,'IBARGUEN ALFREDO','191821112','CRA 25 CALLE 100','856@hotmail.com','2011-02-03',188640,'2011-06-18',628250,'A');
INSERT INTO "personnes" VALUES('1654',3,'MATELLANES RODRIGUEZ NURIA PILAR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-10-05',165770,'A');
INSERT INTO "personnes" VALUES('1656',3,'VIDAURRAZAGA GUISOLA JUAN ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2011-08-08',495320,'A');
INSERT INTO "personnes" VALUES('1658',3,'GOMEZ ULLATE MARIA ELENA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-04-12',919090,'A');
INSERT INTO "personnes" VALUES('1659',3,'ALCAIDE ALONSO JUAN MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-05-02',152430,'A');
INSERT INTO "personnes" VALUES('166',1,'TUSTANOSKI RODOLFO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-12-03',969790,'A');
INSERT INTO "personnes" VALUES('1660',3,'LARROY GARCIA CRISTINA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-09-14',4900,'A');
INSERT INTO "personnes" VALUES('1661',3,'FERNANDEZ POYATO ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-09-10',567180,'A');
INSERT INTO "personnes" VALUES('1662',3,'TREVEJO PARDO JULIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-25',821200,'A');
INSERT INTO "personnes" VALUES('1663',3,'GORGA CASSINELLI VICTOR DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-05-30',404490,'A');
INSERT INTO "personnes" VALUES('1664',3,'MORUECO GONZALEZ JOSE ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-10-09',558820,'A');
INSERT INTO "personnes" VALUES('1665',3,'IRURETA FERNANDEZ PEDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',214283,'2011-09-14',580650,'A');
INSERT INTO "personnes" VALUES('1667',3,'TREVEJO PARDO JUAN ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-25',392020,'A');
INSERT INTO "personnes" VALUES('1668',3,'BOCOS NUNEZ MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',196234,'2011-10-08',279710,'A');
INSERT INTO "personnes" VALUES('1669',3,'LUIS CASTILLO JOSE AGUSTIN','191821112','CRA 25 CALLE 100','557@hotmail.es','2011-02-03',168202,'2011-06-16',222500,'A');
INSERT INTO "personnes" VALUES('167',1,'HURTADO BELALCAZAR JOHN JADY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127300,'2011-08-17',399710,'A');
INSERT INTO "personnes" VALUES('1670',3,'REDONDO GUTIERREZ EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-09-14',273350,'A');
INSERT INTO "personnes" VALUES('1671',3,'MADARIAGA ALONSO RAMON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2011-07-26',699240,'A');
INSERT INTO "personnes" VALUES('1673',3,'REY GONZALEZ LUIS JAVIER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-07-26',283190,'A');
INSERT INTO "personnes" VALUES('1676',3,'PEREZ ESTER ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-10-03',274900,'A');
INSERT INTO "personnes" VALUES('1677',3,'GOMEZ-GRACIA HUERTA ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-09-22',112260,'A');
INSERT INTO "personnes" VALUES('1678',3,'DAMASO PUENTE DIEGO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-05-25',736600,'A');
INSERT INTO "personnes" VALUES('168',1,'JUAN PABLO MARTINEZ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-08-15',89160,'A');
INSERT INTO "personnes" VALUES('1680',3,'DIEZ GONZALEZ LUIS MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-05-17',521280,'A');
INSERT INTO "personnes" VALUES('1681',3,'LOPEZ LOPEZ JOSE LUIS','191821112','CRA 25 CALLE 100','853@yahoo.com','2011-02-03',196234,'2010-12-13',567760,'A');
INSERT INTO "personnes" VALUES('1682',3,'MIRO LINARES FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133442,'2011-09-03',274930,'A');
INSERT INTO "personnes" VALUES('1683',3,'ROCA PINTADO MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-05-16',671410,'A');
INSERT INTO "personnes" VALUES('1684',3,'GARCIA BARTOLOME HORACIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-09-29',532220,'A');
INSERT INTO "personnes" VALUES('1686',3,'BALMASEDA DE AHUMADA DIEZ JUAN LUIS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',168202,'2011-04-13',637860,'A');
INSERT INTO "personnes" VALUES('1687',3,'FERNANDEZ IMAZ FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-04-10',248580,'A');
INSERT INTO "personnes" VALUES('1688',3,'ELIAS CASTELLS FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-05-19',329300,'A');
INSERT INTO "personnes" VALUES('1689',3,'ANIDO DIAZ DANIEL','191821112','CRA 25 CALLE 100','491@gmail.com','2011-02-03',188640,'2011-04-04',900780,'A');
INSERT INTO "personnes" VALUES('1691',3,'GATELL ARIMONT MARIA CRISTINA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',196234,'2011-09-17',877700,'A');
INSERT INTO "personnes" VALUES('1692',3,'RIVERA MUNOZ ADONI','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',211705,'2011-04-05',840470,'A');
INSERT INTO "personnes" VALUES('1693',3,'LUNA LOPEZ ALICIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-10-01',569270,'A');
INSERT INTO "personnes" VALUES('1695',3,'HAMMOND ANN ELIZABETH','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118021,'2011-05-17',916770,'A');
INSERT INTO "personnes" VALUES('1698',3,'RODRIGUEZ PARAJA MARIA CRISTINA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-07-15',649080,'A');
INSERT INTO "personnes" VALUES('1699',3,'RUIZ DIAZ JOSE IGNACIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-06-24',359540,'A');
INSERT INTO "personnes" VALUES('17',1,'SUAREZ CUEVAS FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',129499,'2011-08-31',149640,'A');
INSERT INTO "personnes" VALUES('170',1,'MARROQUIN AVILA FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-04',965840,'A');
INSERT INTO "personnes" VALUES('1700',3,'BACCHELLI ORTEGA JOSE MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',126180,'2011-06-07',850450,'A');
INSERT INTO "personnes" VALUES('1701',3,'IGLESIAS JOSE IGNACIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2010-09-14',173630,'A');
INSERT INTO "personnes" VALUES('1702',3,'GUTIEZ CUEVAS JULIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2010-09-07',316800,'A');
INSERT INTO "personnes" VALUES('CELL4183',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('1704',3,'CALDEIRO ZAMORA JESUS CARMELO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-05-09',365230,'A');
INSERT INTO "personnes" VALUES('1705',3,'ARBONA ABASCAL MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-02-27',636760,'A');
INSERT INTO "personnes" VALUES('1706',3,'COHEN AMAR MOISES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196766,'2011-05-20',88120,'A');
INSERT INTO "personnes" VALUES('1708',3,'FERNANDEZ COBOS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2010-11-09',387220,'A');
INSERT INTO "personnes" VALUES('1709',3,'CANAL VIVES JOAQUIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',196234,'2011-09-27',345150,'A');
INSERT INTO "personnes" VALUES('171',1,'LADINO MORENO JAVIER ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-25',89230,'A');
INSERT INTO "personnes" VALUES('1710',5,'GARCIA BERTRAND HECTOR','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-04-07',564100,'A');
INSERT INTO "personnes" VALUES('1711',1,'CONSTANZA MARIN ESCOBAR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127799,'2011-03-24',785060,'A');
INSERT INTO "personnes" VALUES('1712',1,'NUNEZ BATALLA FAUSTINO JORGE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-26',232970,'A');
INSERT INTO "personnes" VALUES('1713',3,'VILORA LAZARO ERICK MARTIN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-26',809690,'A');
INSERT INTO "personnes" VALUES('1715',3,'ELLIOT EDWARD JAMES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-26',318660,'A');
INSERT INTO "personnes" VALUES('1716',3,'ALCALDE ORTENO MAURICIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117002,'2011-07-23',544650,'A');
INSERT INTO "personnes" VALUES('1717',3,'CIARAVELLA STEFANO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',231989,'2011-06-13',767260,'A');
INSERT INTO "personnes" VALUES('1718',3,'URRA GONZALEZ PEDRO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-05-02',202370,'A');
INSERT INTO "personnes" VALUES('172',1,'GUERRERO ERNESTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-15',548610,'A');
INSERT INTO "personnes" VALUES('1720',3,'JIMENEZ RODRIGUEZ ANNET','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-05-25',943140,'A');
INSERT INTO "personnes" VALUES('1721',3,'LESCAY CASTELLANOS ARNALDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-09-14',585570,'A');
INSERT INTO "personnes" VALUES('1722',3,'OCHOA AGUILAR ELIADES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-25',98410,'A');
INSERT INTO "personnes" VALUES('1723',3,'RODRIGUEZ NUNES JOSE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-25',735340,'A');
INSERT INTO "personnes" VALUES('1724',3,'OCHOA BUSTAMANTE ELIADES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-25',381480,'A');
INSERT INTO "personnes" VALUES('1725',3,'MARTINEZ NIEVES JOSE ANGEL','191821112','CRA 25 CALLE 100','919@yahoo.es','2011-02-03',127591,'2011-05-25',701360,'A');
INSERT INTO "personnes" VALUES('1727',3,'DRAGONI ALAIN ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-25',707850,'A');
INSERT INTO "personnes" VALUES('1728',3,'FERNANDEZ LOPEZ MARCOS ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-25',452090,'A');
INSERT INTO "personnes" VALUES('1729',3,'MATURELL ROMERO JORGE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-25',136880,'A');
INSERT INTO "personnes" VALUES('173',1,'RUIZ CEBALLOS ALEXANDER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-04',475380,'A');
INSERT INTO "personnes" VALUES('1730',3,'LARA CASTELLANO LENNIS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-25',328150,'A');
INSERT INTO "personnes" VALUES('1731',3,'GRAHAM CRISTOPHER DRAKE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',203079,'2011-06-27',230120,'A');
INSERT INTO "personnes" VALUES('1732',3,'TORRE LUCA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-05-11',166120,'A');
INSERT INTO "personnes" VALUES('1733',3,'OCHOA HIDALGO EGLIS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-25',140250,'A');
INSERT INTO "personnes" VALUES('1734',3,'LOURERIO DELACROIX FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116511,'2011-09-28',202900,'A');
INSERT INTO "personnes" VALUES('1736',3,'LEVIN FIORELLI ANDRES','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',116366,'2011-08-07',360110,'A');
INSERT INTO "personnes" VALUES('1739',3,'BERRY R ALBERT','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',216125,'2011-08-16',22170,'A');
INSERT INTO "personnes" VALUES('174',1,'NIETO PARRA SEBASTIAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-05-11',731040,'A');
INSERT INTO "personnes" VALUES('1740',3,'MARSHALL ROBERT SHEPARD','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',150159,'2011-03-09',62860,'A');
INSERT INTO "personnes" VALUES('1741',3,'HENANDEZ ROY CHRISTOPHER JOHN PATRICK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',179614,'2011-09-26',247780,'A');
INSERT INTO "personnes" VALUES('1742',3,'LANDRY GUILLAUME','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',232263,'2011-04-27',50330,'A');
INSERT INTO "personnes" VALUES('1743',3,'VUCETIC ZELJKO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',232263,'2011-07-25',508320,'A');
INSERT INTO "personnes" VALUES('1744',3,'DE JUANA CELASCO MARIA DEL CARMEN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188640,'2011-04-16',390620,'A');
INSERT INTO "personnes" VALUES('1745',3,'LABONTE RONALD','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',269033,'2011-09-28',428120,'A');
INSERT INTO "personnes" VALUES('1746',3,'NEWMAN PHILIP MARK','191821112','CRA 25 CALLE 100','557@gmail.com','2011-02-03',231373,'2011-07-25',968750,'A');
INSERT INTO "personnes" VALUES('1747',3,'GRENIER MARIE PIERRE ','191821112','CRA 25 CALLE 100','409@facebook.com','2011-02-03',244158,'2011-07-03',559370,'A');
INSERT INTO "personnes" VALUES('1749',3,'SHINDER GARY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',244158,'2011-07-25',775000,'A');
INSERT INTO "personnes" VALUES('175',3,'GALLEGOS BASTIDAS CARLOS EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133211,'2011-08-10',229090,'A');
INSERT INTO "personnes" VALUES('1750',3,'LOPEZ DE GOICOCHEA ZABALA FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-09-13',203120,'A');
INSERT INTO "personnes" VALUES('1751',3,'CORRAL BELLON MANUEL','191821112','CRA 25 CALLE 100','538@yahoo.com','2011-02-03',177443,'2011-05-02',690610,'A');
INSERT INTO "personnes" VALUES('1752',3,'DE SOLA SOLVAS JUAN ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-10-02',843700,'A');
INSERT INTO "personnes" VALUES('1753',3,'GARCIA ALCALA DIAZ REGANON EVA MARIA','191821112','CRA 25 CALLE 100','398@yahoo.com','2011-02-03',118777,'2010-03-15',146680,'A');
INSERT INTO "personnes" VALUES('1754',3,'BIELA VILIAM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132958,'2011-08-16',202290,'A');
INSERT INTO "personnes" VALUES('1755',3,'GUIOT CANO JUAN PATRICK','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',232263,'2011-05-23',571390,'A');
INSERT INTO "personnes" VALUES('1756',3,'JIMENEZ DIAZ LUIS MIGUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-03-27',250100,'A');
INSERT INTO "personnes" VALUES('1757',3,'FOX ELEANORE MAE','191821112','CRA 25 CALLE 100','117@yahoo.com','2011-02-03',190393,'2011-05-04',536340,'A');
INSERT INTO "personnes" VALUES('1758',3,'TANG VAN SON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2011-05-07',931400,'A');
INSERT INTO "personnes" VALUES('1759',3,'SUTTON PETER RONALD','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',281673,'2011-06-01',47960,'A');
INSERT INTO "personnes" VALUES('176',1,'GOMEZ IVAN','191821112','CRA 25 CALLE 100','438@yahoo.com.mx','2011-02-03',127591,'2008-04-09',952310,'A');
INSERT INTO "personnes" VALUES('1762',3,'STOODY MATTHEW FRANCIS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-21',84320,'A');
INSERT INTO "personnes" VALUES('1763',3,'SEIX MASO ARNAU','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',150699,'2011-05-24',168880,'A');
INSERT INTO "personnes" VALUES('1764',3,'FERNANDEZ REDEL RAQUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-09-14',591440,'A');
INSERT INTO "personnes" VALUES('1765',3,'PORCAR DESCALS VICENNTE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',176745,'2011-04-24',450580,'A');
INSERT INTO "personnes" VALUES('1766',3,'PEREZ DE VILLEGAS TRILLO FIGUEROA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',196234,'2011-05-17',478560,'A');
INSERT INTO "personnes" VALUES('CELL4198',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('1767',3,'CELDRAN DEGANO ANGEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',196234,'2011-05-17',41040,'A');
INSERT INTO "personnes" VALUES('1768',3,'TERRAGO MARI FERRAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-09-30',769550,'A');
INSERT INTO "personnes" VALUES('1769',3,'SZUCHOVSZKY GERGELY','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',250256,'2011-05-23',724630,'A');
INSERT INTO "personnes" VALUES('177',1,'SEBASTIAN TORO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127443,'2011-07-14',74270,'A');
INSERT INTO "personnes" VALUES('1771',3,'TORIBIO JOSE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',226612,'2011-09-04',398570,'A');
INSERT INTO "personnes" VALUES('1772',3,'JOSE LUIS BAQUERA PEIRONCELLY','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2010-10-19',49360,'A');
INSERT INTO "personnes" VALUES('1773',3,'MADARIAGA VILLANUEVA MIGUEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',188640,'2011-04-12',51090,'A');
INSERT INTO "personnes" VALUES('1774',3,'VILLENA BORREGO ANTONIO','191821112','CRA 25 CALLE 100','830@terra.com.co','2011-02-03',188640,'2011-07-19',107400,'A');
INSERT INTO "personnes" VALUES('1776',3,'VILAR VILLALBA JOSE LUIS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',180124,'2011-09-20',596330,'A');
INSERT INTO "personnes" VALUES('1777',3,'CAGIGAL ORTIZ MACARENA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',214283,'2011-09-14',830530,'A');
INSERT INTO "personnes" VALUES('1778',3,'KORBA ATTILA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',250256,'2011-09-27',363650,'A');
INSERT INTO "personnes" VALUES('1779',3,'KORBA-ELIAS BARBARA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',250256,'2011-09-27',326670,'A');
INSERT INTO "personnes" VALUES('178',1,'AMSILI COHEN HANAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-08-29',514450,'A');
INSERT INTO "personnes" VALUES('1780',3,'PINDADO GOMEZ JESUS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',189053,'2011-04-26',542400,'A');
INSERT INTO "personnes" VALUES('1781',3,'IBARRONDO GOMEZ GRACIA ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',188640,'2011-09-21',731990,'A');
INSERT INTO "personnes" VALUES('1782',3,'MUNGUIRA GONZALEZ JUAN JULIAN','191821112','CRA 25 CALLE 100','54@hotmail.es','2011-02-03',188640,'2011-09-06',32730,'A');
INSERT INTO "personnes" VALUES('1784',3,'LANDMAN PIETER MARINUS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',294861,'2011-09-22',740260,'A');
INSERT INTO "personnes" VALUES('1789',3,'SUAREZ AINARA ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-05-17',503470,'A');
INSERT INTO "personnes" VALUES('179',1,'CARO JUNCO GUIOVANNY','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-03',349420,'A');
INSERT INTO "personnes" VALUES('1790',3,'MARTINEZ CHACON JOSE JOAQUIN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-05-20',592220,'A');
INSERT INTO "personnes" VALUES('1792',3,'MENDEZ DEL RION LUCIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',120639,'2011-06-16',476910,'A');
INSERT INTO "personnes" VALUES('1793',3,'VERHULST LAMBERTUS  CORNELIA FRANCISCUS ALPHONSUS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',295420,'2011-07-04',32410,'A');
INSERT INTO "personnes" VALUES('1794',3,'YANEZ YAGUE JESUS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',188640,'2011-07-10',731290,'A');
INSERT INTO "personnes" VALUES('1796',3,'GOMEZ ZORRILLA AMATE JOSE MARIOA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2011-07-12',602380,'A');
INSERT INTO "personnes" VALUES('1797',3,'LAIZ MORENO ENEKO','191821112','CRA 25 CALLE 100','219@gmail.com','2011-02-03',127591,'2011-08-05',334150,'A');
INSERT INTO "personnes" VALUES('1798',3,'MORODO RUIZ RUBEN DAVID','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-09-14',863620,'A');
INSERT INTO "personnes" VALUES('18',1,'GARZON VARGAS GUILLERMO FEDERICO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-29',879110,'A');
INSERT INTO "personnes" VALUES('1800',3,'ALFARO FAUS MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-09-14',987410,'A');
INSERT INTO "personnes" VALUES('1801',3,'MORRALLA VALLVERDU ENRIC','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',194601,'2011-07-18',990070,'A');
INSERT INTO "personnes" VALUES('1802',3,'BALBASTRE TEJEDOR JUAN VICENTE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',182860,'2011-08-24',988120,'A');
INSERT INTO "personnes" VALUES('1803',3,'MINGO REIZ FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2010-03-24',970400,'A');
INSERT INTO "personnes" VALUES('1804',3,'IRURETA FERNANDEZ JOSE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',214283,'2011-09-10',887630,'A');
INSERT INTO "personnes" VALUES('1807',3,'NEBRO MELLADO JOSE JUAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',168996,'2011-08-15',278540,'A');
INSERT INTO "personnes" VALUES('1808',3,'ALBERQUILLA OJEDA JOSE DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',188640,'2011-09-27',477070,'A');
INSERT INTO "personnes" VALUES('1809',3,'BUENDIA NORTE MARIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',131401,'2011-07-08',549720,'A');
INSERT INTO "personnes" VALUES('181',1,'CASTELLANOS FLORES RODRIGO ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-18',970470,'A');
INSERT INTO "personnes" VALUES('1811',3,'HILBERT ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',196234,'2011-09-08',937830,'A');
INSERT INTO "personnes" VALUES('1812',3,'GONZALES PINTO COTERILLO ADOLFO LORENZO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',214283,'2011-09-10',736970,'A');
INSERT INTO "personnes" VALUES('1813',3,'ARQUES ALVAREZ JOSE RICARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-04-04',871360,'A');
INSERT INTO "personnes" VALUES('1817',3,'CLAUSELL LOW ROBERTO EMILIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132775,'2011-09-28',348770,'A');
INSERT INTO "personnes" VALUES('1818',3,'BELICHON MARTINEZ JESUS ALVARO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-04-12',327010,'A');
INSERT INTO "personnes" VALUES('182',1,'GUZMAN NIETO JOSE MARIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-20',241130,'A');
INSERT INTO "personnes" VALUES('1821',3,'LINATI DE PUIG JORGE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',196234,'2011-05-18',47210,'A');
INSERT INTO "personnes" VALUES('1823',3,'SINBARRERA ROMA ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',196234,'2011-09-08',598380,'A');
INSERT INTO "personnes" VALUES('1826',2,'JUANES GARATE BRUNO ','191821112','CRA 25 CALLE 100','301@gmail.com','2011-02-03',118777,'2011-08-21',877650,'A');
INSERT INTO "personnes" VALUES('1827',3,'BOLOS GIMENO ROGELIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',200247,'2010-11-28',555470,'A');
INSERT INTO "personnes" VALUES('1828',3,'ZABALA ASTIGARRAGA JOSE MARIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',188640,'2011-09-20',144410,'A');
INSERT INTO "personnes" VALUES('1831',3,'MAPELLI CAFFARENA BORJA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',172381,'2011-09-04',58200,'A');
INSERT INTO "personnes" VALUES('1833',3,'LARMONIE LESLIE MARTIN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-30',604840,'A');
INSERT INTO "personnes" VALUES('1834',3,'WILLEMS ROBERT-JAN MICHAEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',288531,'2011-09-05',756530,'A');
INSERT INTO "personnes" VALUES('1835',3,'ANJEMA LAURENS JAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-08-29',968140,'A');
INSERT INTO "personnes" VALUES('1836',3,'VERHULST HENRICUS LAMBERTUS MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',295420,'2011-04-03',571100,'A');
INSERT INTO "personnes" VALUES('1837',3,'PIERROT JOZEF MARIE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',288733,'2011-05-18',951100,'A');
INSERT INTO "personnes" VALUES('1838',3,'EIKELBOOM HIDDE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-02',42210,'A');
INSERT INTO "personnes" VALUES('1839',3,'TAMBINI GOMEZ DE MUNG','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',180063,'2011-04-24',357740,'A');
INSERT INTO "personnes" VALUES('1840',3,'MAGANA PEREZ GERARDO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',135360,'2011-09-28',662060,'A');
INSERT INTO "personnes" VALUES('1841',3,'COURTOISIE BEYHAUT RAFAEL JUAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',116366,'2011-09-05',237070,'A');
INSERT INTO "personnes" VALUES('1842',3,'ROJAS BENJAMIN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-13',199170,'A');
INSERT INTO "personnes" VALUES('1843',3,'GARCIA VICENTE EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',150699,'2011-08-10',284650,'A');
INSERT INTO "personnes" VALUES('CELL4291',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('1844',3,'CESTTI LOPEZ RAFAEL GUSTAVO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',144215,'2011-09-27',825750,'A');
INSERT INTO "personnes" VALUES('1845',3,'URTECHO LOPEZ ARMANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',139272,'2011-09-28',274800,'A');
INSERT INTO "personnes" VALUES('1846',3,'SEGURA ESPINOZA ARMANDO SEBASTIAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',135360,'2011-09-28',896730,'A');
INSERT INTO "personnes" VALUES('1847',3,'GONZALEZ VEGA LUIS PASTOR','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',135360,'2011-05-18',659240,'A');
INSERT INTO "personnes" VALUES('185',1,'AYALA CARDENAS NELSON MAURICIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-25',855960,'A');
INSERT INTO "personnes" VALUES('1850',3,'ROTZINGER ROA KLAUS ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',116366,'2011-09-12',444250,'A');
INSERT INTO "personnes" VALUES('1851',3,'FRANCO DE LEON SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',116366,'2011-04-26',63840,'A');
INSERT INTO "personnes" VALUES('1852',3,'RIVAS GAGNONI LUIS ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',135360,'2011-05-18',986440,'A');
INSERT INTO "personnes" VALUES('1853',3,'BARRETO VELASQUEZ JOEL FERNANDO','191821112','CRA 25 CALLE 100','104@hotmail.es','2011-02-03',116511,'2011-04-27',740670,'A');
INSERT INTO "personnes" VALUES('1854',3,'SEVILLA AMAYA ORLANDO','191821112','CRA 25 CALLE 100','264@yahoo.com','2011-02-03',136995,'2011-05-18',744020,'A');
INSERT INTO "personnes" VALUES('1855',3,'VALFRE BRALICH ELEONORA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',116366,'2011-06-06',498080,'A');
INSERT INTO "personnes" VALUES('1857',3,'URDANETA DIAMANTES DIEGO ANDRES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-09-23',797590,'A');
INSERT INTO "personnes" VALUES('1858',3,'RAMIREZ ALVARADO ROBERT JESUS','191821112','CRA 25 CALLE 100','290@yahoo.com.mx','2011-02-03',127591,'2011-09-18',212850,'A');
INSERT INTO "personnes" VALUES('1859',3,'GUTTNER DENNIS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-25',671470,'A');
INSERT INTO "personnes" VALUES('186',1,'CARRASCO SUESCUN ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-15',36620,'A');
INSERT INTO "personnes" VALUES('1861',3,'HEGEMANN JOACHIM','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-25',579710,'A');
INSERT INTO "personnes" VALUES('1862',3,'MALCHER INGO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',292243,'2011-06-23',742060,'A');
INSERT INTO "personnes" VALUES('1864',3,'HOFFMEISTER MALTE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128206,'2011-09-06',629770,'A');
INSERT INTO "personnes" VALUES('1865',3,'BOHME ALEXANDRA LUCE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-14',235260,'A');
INSERT INTO "personnes" VALUES('1866',3,'HAMMAN FRANK THOMAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-13',286980,'A');
INSERT INTO "personnes" VALUES('1867',3,'GOPPERT MARKUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-09-05',729150,'A');
INSERT INTO "personnes" VALUES('1868',3,'BISCARO CAROLINA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-09-16',784790,'A');
INSERT INTO "personnes" VALUES('1869',3,'MASCHAT SEBASTIAN STEPHAN ANDREAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-02-03',736520,'A');
INSERT INTO "personnes" VALUES('1870',3,'WALTHER DANIEL CLAUS PETER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-24',328220,'A');
INSERT INTO "personnes" VALUES('1871',3,'NENTWIG DANIEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',289697,'2011-02-03',431550,'A');
INSERT INTO "personnes" VALUES('1872',3,'KARUTZ ALEX','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127662,'2011-03-17',173090,'A');
INSERT INTO "personnes" VALUES('1875',3,'KAY KUNNE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',289697,'2011-03-18',961400,'A');
INSERT INTO "personnes" VALUES('1876',2,'SCHLUMPF IVANA PATRICIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',245206,'2011-03-28',802690,'A');
INSERT INTO "personnes" VALUES('1877',3,'RODRIGUEZ BUSTILLO CONSUELO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',139067,'2011-03-21',129280,'A');
INSERT INTO "personnes" VALUES('1878',1,'REHWALDT RICHARD ULRICH','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',289697,'2009-10-25',238320,'A');
INSERT INTO "personnes" VALUES('1880',3,'FONSECA BEHRENS MANUELA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150699,'2011-08-18',303810,'A');
INSERT INTO "personnes" VALUES('1881',3,'VOGEL MIRKO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-09',107790,'A');
INSERT INTO "personnes" VALUES('1882',3,'WU WEI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',289697,'2011-03-04',627520,'A');
INSERT INTO "personnes" VALUES('1884',3,'KADOLSKY ANKE SIGRID','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',289697,'2010-10-07',188560,'A');
INSERT INTO "personnes" VALUES('1885',3,'PFLUCKER PLENGE CARLOS HERNAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',239124,'2011-08-15',500140,'A');
INSERT INTO "personnes" VALUES('1886',3,'PENA LAGOS MELENIA PATRICIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-18',935020,'A');
INSERT INTO "personnes" VALUES('1887',3,'CALVANO MARCO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2011-05-02',174690,'A');
INSERT INTO "personnes" VALUES('1888',3,'KUHLEN LOTHAR WILHELM','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',289232,'2011-08-30',68390,'A');
INSERT INTO "personnes" VALUES('1889',3,'QUIJANO RICO SOFIA VICTORIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',221939,'2011-06-13',817890,'A');
INSERT INTO "personnes" VALUES('189',1,'GOMEZ TRUJILLO SERGIO ANDRES','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-17',985980,'A');
INSERT INTO "personnes" VALUES('1890',3,'SCHILBERZ KARIN','191821112','CRA 25 CALLE 100','405@facebook.com','2011-02-03',287570,'2011-06-23',884260,'A');
INSERT INTO "personnes" VALUES('1891',3,'SCHILBERZ SOPHIE CAHRLOTTE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',287570,'2011-06-23',967640,'A');
INSERT INTO "personnes" VALUES('1892',3,'MOLINA MOLINA MILAGRO DE SUYAPA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',139844,'2011-07-26',185410,'A');
INSERT INTO "personnes" VALUES('1893',3,'BARRIENTOS ESCALANTE RAFAEL ALVARO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',139067,'2011-05-18',24110,'A');
INSERT INTO "personnes" VALUES('1895',3,'ENGELS FRANZBERNARD','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',292243,'2011-07-01',749430,'A');
INSERT INTO "personnes" VALUES('1896',3,'FRIEDHOFF SVEN WILHEM','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',289697,'2010-10-31',54090,'A');
INSERT INTO "personnes" VALUES('1897',3,'BARTELS CHRISTIAN JOHAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2011-07-25',22160,'A');
INSERT INTO "personnes" VALUES('1898',3,'NILS REMMEL','191821112','CRA 25 CALLE 100','214@gmail.com','2011-02-03',256231,'2011-08-05',948530,'A');
INSERT INTO "personnes" VALUES('1899',3,'DR SCHEIBE MATTHIAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',252431,'2011-09-26',676150,'A');
INSERT INTO "personnes" VALUES('19',1,'RIANO ROMERO ALBERTO ELIAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-12-14',946630,'A');
INSERT INTO "personnes" VALUES('190',1,'LLOREDA ORTIZ FELIPE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-12-20',30860,'A');
INSERT INTO "personnes" VALUES('1900',3,'CARRASCO CATERIANO PEDRO','191821112','CRA 25 CALLE 100','255@hotmail.com','2011-02-03',286578,'2011-05-02',535180,'A');
INSERT INTO "personnes" VALUES('1901',3,'ROSENBER DIRK PETER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-29',647450,'A');
INSERT INTO "personnes" VALUES('1902',3,'LAUBACH JOHANNES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',289697,'2011-05-01',631720,'A');
INSERT INTO "personnes" VALUES('1904',3,'GRUND STEFAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',256231,'2011-08-05',185990,'A');
INSERT INTO "personnes" VALUES('1905',3,'GRUND BEATE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',256231,'2011-08-05',281280,'A');
INSERT INTO "personnes" VALUES('1906',3,'CORZO PAULA MIRIANA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',180063,'2011-08-02',848400,'A');
INSERT INTO "personnes" VALUES('1907',3,'OESTERHAUS CORNELIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',256231,'2011-03-16',398170,'A');
INSERT INTO "personnes" VALUES('1908',1,'JUAN SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127300,'2011-05-12',445660,'A');
INSERT INTO "personnes" VALUES('1909',3,'VAN ZIJL CHRISTIAN ANDREAS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',286785,'2011-09-24',33800,'A');
INSERT INTO "personnes" VALUES('191',1,'CASTANEDA CABALLERO JUAN MANUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-28',196370,'A');
INSERT INTO "personnes" VALUES('1910',3,'LORZA RUIZ MYRIAM ESPERANZA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-29',831990,'A');
INSERT INTO "personnes" VALUES('192',1,'ZEA EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-09',889270,'A');
INSERT INTO "personnes" VALUES('193',1,'VELEZ VICTOR MANUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-10-22',857250,'A');
INSERT INTO "personnes" VALUES('194',1,'ARCINIEGAS GOMEZ ISMAEL','191821112','CRA 25 CALLE 100','937@hotmail.com','2011-02-03',127591,'2011-05-18',618450,'A');
INSERT INTO "personnes" VALUES('195',1,'LINAREZ PEDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-12',520470,'A');
INSERT INTO "personnes" VALUES('1952',3,'BERND ERNST HEINZ SCHUNEMANN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',255673,'2011-09-04',796820,'A');
INSERT INTO "personnes" VALUES('1953',3,'BUCHNER RICHARD ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-17',808430,'A');
INSERT INTO "personnes" VALUES('1954',3,'CHO YONG BEOM','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',173192,'2011-02-07',651670,'A');
INSERT INTO "personnes" VALUES('1955',3,'BERNECKER WALTER LUDWIG','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',256231,'2011-04-03',833080,'A');
INSERT INTO "personnes" VALUES('1956',3,'SCHIERENBECK THOMAS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',256231,'2011-05-03',210380,'A');
INSERT INTO "personnes" VALUES('1957',3,'STEGMANN WOLF DIETER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-08-27',552650,'A');
INSERT INTO "personnes" VALUES('1958',3,'LEBAGE GONZALEZ VALENTINA CECILIA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',131272,'2011-07-29',132130,'A');
INSERT INTO "personnes" VALUES('1959',3,'CABRERA MACCHI JOSE ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',180063,'2011-08-02',2700,'A');
INSERT INTO "personnes" VALUES('196',1,'OTERO BERNAL ALVARO ERNESTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-04-29',747030,'A');
INSERT INTO "personnes" VALUES('1960',3,'KOO BONKI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-15',617110,'A');
INSERT INTO "personnes" VALUES('1961',3,'JODJAHN DE CARVALHO BEIRAL FLAVIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-07-05',77460,'A');
INSERT INTO "personnes" VALUES('1963',3,'VIEIRA ROCHA MARQUES ELIANE TEREZINHA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118402,'2011-09-13',447430,'A');
INSERT INTO "personnes" VALUES('1965',3,'KELLEN CRISTINA GATTI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',126180,'2011-07-01',804020,'A');
INSERT INTO "personnes" VALUES('1966',3,'CHAVEZ MARLON TENORIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',120773,'2011-07-25',132310,'A');
INSERT INTO "personnes" VALUES('1967',3,'SERGIO COZZI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',125750,'2011-08-28',249500,'A');
INSERT INTO "personnes" VALUES('1968',3,'REZENDE LIMA JOSE MARCIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-08-23',850570,'A');
INSERT INTO "personnes" VALUES('1969',3,'RAMOS PEDRO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118942,'2011-08-03',504330,'A');
INSERT INTO "personnes" VALUES('1972',3,'ADAMS THOMAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118942,'2011-08-11',774000,'A');
INSERT INTO "personnes" VALUES('1973',3,'WALESKA NUCINI BOGO ANDREA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-23',859690,'A');
INSERT INTO "personnes" VALUES('1974',3,'GERMANO PAULO BUNN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118439,'2011-08-30',976440,'A');
INSERT INTO "personnes" VALUES('1975',3,'CALDEIRA FILHO RUBENS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118942,'2011-07-18',303120,'A');
INSERT INTO "personnes" VALUES('1976',3,'JOSE CUSTODIO DO ALTISSIMO NETONETO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',119814,'2011-09-08',586290,'A');
INSERT INTO "personnes" VALUES('1977',3,'GAMAS MARIA CRISTINA ALVES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-09-19',22070,'A');
INSERT INTO "personnes" VALUES('1979',3,'PORTO WEBER FERREIRA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-07',691340,'A');
INSERT INTO "personnes" VALUES('1980',3,'FONSECA LAURO PINTO','191821112','CRA 25 CALLE 100','104@hotmail.es','2011-02-03',127591,'2011-08-16',402140,'A');
INSERT INTO "personnes" VALUES('1981',3,'DUARTE ELENA CECILIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-06-15',936710,'A');
INSERT INTO "personnes" VALUES('1983',3,'CECHINEL CRISTIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118942,'2011-06-12',575530,'A');
INSERT INTO "personnes" VALUES('1984',3,'BATISTA PINHERO JOAO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-04-25',446250,'A');
INSERT INTO "personnes" VALUES('1987',1,'ISRAEL JOSE MAXWELL','191821112','CRA 25 CALLE 100','936@gmail.com','2011-02-03',125894,'2011-07-04',408350,'A');
INSERT INTO "personnes" VALUES('1988',3,'BATISTA CARVALHO RODRIGO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118864,'2011-09-19',488410,'A');
INSERT INTO "personnes" VALUES('1989',3,'RENO DA SILVEIRA EDNEIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118867,'2011-05-03',216990,'A');
INSERT INTO "personnes" VALUES('199',1,'BASTO CORREA FERNANDO ANTONIO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-21',616860,'A');
INSERT INTO "personnes" VALUES('1990',3,'SEIDLER KOHNERT G TEIXEIRA CHRISTINA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',119814,'2011-08-23',619730,'A');
INSERT INTO "personnes" VALUES('1992',3,'GUIMARAES COSTA LEONARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-04-20',379090,'A');
INSERT INTO "personnes" VALUES('1993',3,'BOTTA RODRIGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118777,'2011-09-16',552510,'A');
INSERT INTO "personnes" VALUES('1994',3,'ARAUJO DA SILVA MARCELO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',125666,'2011-08-03',625260,'A');
INSERT INTO "personnes" VALUES('1995',3,'DA SILVA FELIPE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118864,'2011-04-14',468760,'A');
INSERT INTO "personnes" VALUES('1996',3,'MANFIO RODRIGUEZ FERNANDO','191821112','CRA 25 CALLE 100','974@yahoo.com','2011-02-03',118777,'2011-03-23',468040,'A');
INSERT INTO "personnes" VALUES('1997',3,'NEIVA MORENO DE SOUZA CRISTIANE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-09-24',933900,'A');
INSERT INTO "personnes" VALUES('2',3,'CHEEVER MICHAEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-04',560090,'I');
INSERT INTO "personnes" VALUES('2000',3,'ROCHA GUSTAVO ADRIANO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118288,'2011-07-25',830340,'A');
INSERT INTO "personnes" VALUES('2001',3,'DE ANDRADE CARVALHO VIRGINIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-08-11',575760,'A');
INSERT INTO "personnes" VALUES('2002',3,'CAVALCANTI PIERECK GUILHERME','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',180063,'2011-08-01',387770,'A');
INSERT INTO "personnes" VALUES('2004',3,'HOEGEMANN RAMOS CARLOS FERNANDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-04',894550,'A');
INSERT INTO "personnes" VALUES('201',1,'LUIS FERNANDO AREVALO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-17',156730,'A');
INSERT INTO "personnes" VALUES('2010',3,'GOMES BUCHALA JORGE FERNANDO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-09-23',314800,'A');
INSERT INTO "personnes" VALUES('2011',3,'MARTINS SIMAIKA CATIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-06-01',155020,'A');
INSERT INTO "personnes" VALUES('2012',3,'MONICA CASECA BUENO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-05-16',830710,'A');
INSERT INTO "personnes" VALUES('2013',3,'ALBERTAL MARCELO ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118000,'2010-09-10',688480,'A');
INSERT INTO "personnes" VALUES('2015',3,'GOMES CANTARELLI JAIRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118761,'2011-01-11',685940,'A');
INSERT INTO "personnes" VALUES('2016',3,'CADETTI GARBELLINI ENILICE CRISTINA ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-11',578870,'A');
INSERT INTO "personnes" VALUES('2017',3,'SPIELKAMP KLAUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',150699,'2011-03-28',836540,'A');
INSERT INTO "personnes" VALUES('2019',3,'GARES HENRI PHILIPPE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',135190,'2011-04-05',720730,'A');
INSERT INTO "personnes" VALUES('CELL4308',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('202',1,'LUCIO CHAUSTRE ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-19',179240,'A');
INSERT INTO "personnes" VALUES('2023',3,'GRECO DE RESENDELUIZ ALFREDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',119814,'2011-04-25',647940,'A');
INSERT INTO "personnes" VALUES('2024',3,'CORTINA EVANDRO JOAO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118922,'2011-05-12',153970,'A');
INSERT INTO "personnes" VALUES('2026',3,'BASQUES MOURA GERALDO CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',119814,'2011-09-07',668250,'A');
INSERT INTO "personnes" VALUES('2027',3,'DA SILVA VALDECIR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-23',863150,'A');
INSERT INTO "personnes" VALUES('2028',3,'CHI MOW YUNG IVAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-21',311000,'A');
INSERT INTO "personnes" VALUES('2029',3,'YUNG MYRA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-21',965570,'A');
INSERT INTO "personnes" VALUES('2030',3,'MARTINS RAMALHO PATRICIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-03-23',894830,'A');
INSERT INTO "personnes" VALUES('2031',3,'DE LEMOS RIBEIRO GILBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118951,'2011-07-29',577430,'A');
INSERT INTO "personnes" VALUES('2032',3,'AIROLDI CLAUDIO','191821112','CRA 25 CALLE 100','973@terra.com.co','2011-02-03',127591,'2011-09-28',202650,'A');
INSERT INTO "personnes" VALUES('2033',3,'ARRUDA MENDES HEILMANN IONE TEREZA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',120773,'2011-09-07',280990,'A');
INSERT INTO "personnes" VALUES('2034',3,'TAVARES DE CARVALHO EDUARDO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118942,'2011-08-03',796980,'A');
INSERT INTO "personnes" VALUES('2036',3,'FERNANDES ALARCON RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-08-28',318730,'A');
INSERT INTO "personnes" VALUES('2037',3,'SUCHODOLKI SERGIO GUSMAO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',190393,'2011-07-13',167870,'A');
INSERT INTO "personnes" VALUES('2039',3,'ESTEVES MARCAL MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-02-24',912100,'A');
INSERT INTO "personnes" VALUES('2040',3,'CORSI LUIZ ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-03-25',911080,'A');
INSERT INTO "personnes" VALUES('2041',3,'LOPEZ MONICA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118795,'2011-05-03',819090,'A');
INSERT INTO "personnes" VALUES('2042',3,'QUINTANILHA LUIS CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-16',362230,'A');
INSERT INTO "personnes" VALUES('2043',3,'DE CARLI BRUNO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-05-03',353890,'A');
INSERT INTO "personnes" VALUES('2045',3,'MARINO FRANCA MARILIA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-07-04',352060,'A');
INSERT INTO "personnes" VALUES('2048',3,'VOIGT ALPHONSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118439,'2010-11-22',384150,'A');
INSERT INTO "personnes" VALUES('2049',3,'ALENCAR ARIMA TATIANA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-05-23',408590,'A');
INSERT INTO "personnes" VALUES('2050',3,'LINIS DE ALMEIDA NEILSON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',125666,'2011-08-03',890480,'A');
INSERT INTO "personnes" VALUES('2051',3,'PINHEIRO DE CASTRO BENETI','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2011-08-09',226640,'A');
INSERT INTO "personnes" VALUES('2052',3,'ALVES DO LAGO HELMANN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118942,'2011-08-01',461770,'A');
INSERT INTO "personnes" VALUES('2053',3,'OLIVO MARCO ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-22',628900,'A');
INSERT INTO "personnes" VALUES('2054',3,'WILLIAM DOMINGUES SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118085,'2011-08-23',759220,'A');
INSERT INTO "personnes" VALUES('2055',3,'DE SOUZA MENEZES KLEBER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-04-25',909400,'A');
INSERT INTO "personnes" VALUES('2056',3,'CABRAL NEIDE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-16',269340,'A');
INSERT INTO "personnes" VALUES('2057',3,'RODRIGUES RENATO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-06-15',618500,'A');
INSERT INTO "personnes" VALUES('2058',3,'SPADALE PEDRO JORGE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-08-03',284490,'A');
INSERT INTO "personnes" VALUES('2059',3,'MARTINS DE ALMEIDA GUSTAVO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-09-28',566920,'A');
INSERT INTO "personnes" VALUES('206',1,'TORRES HEBER MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-01-29',643210,'A');
INSERT INTO "personnes" VALUES('2060',3,'IKUNO CELINA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-06-08',981170,'A');
INSERT INTO "personnes" VALUES('2061',3,'DAL BELLO FABIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',129499,'2011-08-20',205050,'A');
INSERT INTO "personnes" VALUES('2062',3,'BENATES ADRIANA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-23',81770,'A');
INSERT INTO "personnes" VALUES('2063',3,'CARDOSO ALEXANDRE ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-23',793690,'A');
INSERT INTO "personnes" VALUES('2064',3,'ZANIOLO DE SOUZA CARLOS HENRIQUE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-09-19',723130,'A');
INSERT INTO "personnes" VALUES('2065',3,'DA SILVA LUIZ SIDNEI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-03-30',234590,'A');
INSERT INTO "personnes" VALUES('2066',3,'RUFATO DE SOUZA LUIZ FERNANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-08-29',3560,'A');
INSERT INTO "personnes" VALUES('2067',3,'DE MEDEIROS LUCIANA','191821112','CRA 25 CALLE 100','994@yahoo.com.mx','2011-02-03',118777,'2011-09-10',314020,'A');
INSERT INTO "personnes" VALUES('2068',3,'WOLFF PIAZERA DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118255,'2011-06-15',559430,'A');
INSERT INTO "personnes" VALUES('2069',3,'DA SILVA FORTUNA MARINA CLAUDIA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2011-09-23',855100,'A');
INSERT INTO "personnes" VALUES('2070',3,'PEREIRA BORGES LUCILA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',120773,'2011-07-26',597210,'A');
INSERT INTO "personnes" VALUES('2072',3,'PORROZZI DE ALMEIDA RENATO','191821112','CRA 25 CALLE 100','812@hotmail.es','2011-02-03',127591,'2011-06-13',312120,'A');
INSERT INTO "personnes" VALUES('2073',3,'KALICHSZTEINN RICARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-03-23',298330,'A');
INSERT INTO "personnes" VALUES('2074',3,'OCCHIALINI GUIMARAES ANA PAULA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118777,'2011-08-03',555310,'A');
INSERT INTO "personnes" VALUES('2075',3,'MAZZUCO FONTES LUIZ ROBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-05-23',881570,'A');
INSERT INTO "personnes" VALUES('2078',3,'TRAN DINH VAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-05-07',98560,'A');
INSERT INTO "personnes" VALUES('2079',3,'NGUYEN THI LE YEN','191821112','CRA 25 CALLE 100','249@yahoo.com.mx','2011-02-03',132958,'2011-05-07',298200,'A');
INSERT INTO "personnes" VALUES('208',1,'GOMEZ GONZALEZ JORGE MARIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-12',889010,'A');
INSERT INTO "personnes" VALUES('2080',3,'MILA DE LA ROCA JOHANA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2011-01-26',195350,'A');
INSERT INTO "personnes" VALUES('2081',3,'RODRIGUEZ DE FLORES LOURDES MARIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-16',82120,'A');
INSERT INTO "personnes" VALUES('2082',3,'FLORES PEREZ FRANCISCO GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-23',824550,'A');
INSERT INTO "personnes" VALUES('2083',3,'FRAGACHAN BETANCOUT FRANCISCO JO SE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-07-04',876400,'A');
INSERT INTO "personnes" VALUES('2084',3,'GAFARO MOLINA CARLOS JULIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-03-22',908370,'A');
INSERT INTO "personnes" VALUES('2085',3,'CACERES REYES JORGEANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-08-11',912630,'A');
INSERT INTO "personnes" VALUES('2086',3,'ALVAREZ RODRIGUEZ VICTOR ROGELIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132958,'2011-05-23',838040,'A');
INSERT INTO "personnes" VALUES('2087',3,'GARCES ALVARADO JHAGEIMA JOSEFINA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132958,'2011-04-29',452320,'A');
INSERT INTO "personnes" VALUES('CELL4324',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('2089',3,'FAVREAU CHOLLET JEAN PIERRE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132554,'2011-05-27',380470,'A');
INSERT INTO "personnes" VALUES('209',1,'CRUZ RODRIGEZ CARLOS ANDRES','191821112','CRA 25 CALLE 100','316@hotmail.es','2011-02-03',127591,'2011-06-28',953870,'A');
INSERT INTO "personnes" VALUES('2090',3,'GARAY LLUCH URBI ALAIN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-03-13',659870,'A');
INSERT INTO "personnes" VALUES('2091',3,'LETICIA LETICIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-07',157950,'A');
INSERT INTO "personnes" VALUES('2092',3,'VELASQUEZ RODULFO RAMON ARISTIDES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-09-23',810140,'A');
INSERT INTO "personnes" VALUES('2093',3,'PEREZ EDGAR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-06',576850,'A');
INSERT INTO "personnes" VALUES('2094',3,'PEREZ MARIELA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-07',453840,'A');
INSERT INTO "personnes" VALUES('2095',3,'PETRUZZI MANGIARANO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132958,'2011-03-27',538650,'A');
INSERT INTO "personnes" VALUES('2096',3,'LINARES GORI RICARDO RAMON','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-12',331730,'A');
INSERT INTO "personnes" VALUES('2097',3,'LAIRET OLIVEROS CAROLINE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-09-25',42680,'A');
INSERT INTO "personnes" VALUES('2099',3,'JIMENEZ GARCIA FERNANDO JOSE','191821112','CRA 25 CALLE 100','78@hotmail.es','2011-02-03',132958,'2011-07-21',963110,'A');
INSERT INTO "personnes" VALUES('21',1,'RUBIO ESCOBAR RUBEN DARIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-05-21',639240,'A');
INSERT INTO "personnes" VALUES('2100',3,'ZABALA MILAGROS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-20',160860,'A');
INSERT INTO "personnes" VALUES('2101',3,'VASQUEZ CRUZ NICOLEDANIELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132958,'2011-07-31',914990,'A');
INSERT INTO "personnes" VALUES('2102',3,'REYES FIGUERA RAMON ALEXANDER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',126674,'2011-04-03',92340,'A');
INSERT INTO "personnes" VALUES('2104',3,'RAMIREZ JIMENEZ MARYLIN CAROLINA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132958,'2011-06-14',306760,'A');
INSERT INTO "personnes" VALUES('2105',3,'TELLES GUILLEN INNA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-09-07',383520,'A');
INSERT INTO "personnes" VALUES('2106',3,'ALVAREZ CARMEN MARINA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-07-20',997340,'A');
INSERT INTO "personnes" VALUES('2107',3,'MARTINEZ YRIGOYEN NABUCODONOSOR','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-07-21',836110,'A');
INSERT INTO "personnes" VALUES('2108',5,'FERNANDEZ RUIZ IGNACIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-01',188530,'A');
INSERT INTO "personnes" VALUES('211',1,'RIVEROS GARCIA JORGE IVAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-01',650050,'A');
INSERT INTO "personnes" VALUES('2110',3,'CACERES REYES JORGE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2011-08-08',606030,'A');
INSERT INTO "personnes" VALUES('2111',3,'GELFI MARCOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',199862,'2011-05-17',727190,'A');
INSERT INTO "personnes" VALUES('2112',3,'CERDA CASTILLO CARMEN GLORIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-08-21',817870,'A');
INSERT INTO "personnes" VALUES('2113',3,'RANGEL FERNANDEZ LEONARDO JOSE','191821112','CRA 25 CALLE 100','856@hotmail.com','2011-02-03',133211,'2011-05-16',907750,'A');
INSERT INTO "personnes" VALUES('2114',3,'ROTHSCHILD VARGAS MICHAEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132165,'2011-02-05',85170,'A');
INSERT INTO "personnes" VALUES('2115',3,'RUIZ GRATEROL INGRID JOHANNA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132958,'2011-05-16',702600,'A');
INSERT INTO "personnes" VALUES('2116',2,'DEARMAS ALBERTO FERNANDO ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-07-19',257500,'A');
INSERT INTO "personnes" VALUES('2117',3,'BOSCAN ARRIETA ERICK HUMBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-07-12',179680,'A');
INSERT INTO "personnes" VALUES('2118',3,'GUILLEN DE TELLES NENCY JOSEFINA','191821112','CRA 25 CALLE 100','56@facebook.com','2011-02-03',132958,'2011-09-07',125900,'A');
INSERT INTO "personnes" VALUES('212',1,'BUSTAMANTE BUSTAMANTE CARLOS ENRIQUE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-26',943260,'A');
INSERT INTO "personnes" VALUES('2120',2,'MARK ANTHONY STUART','191821112','CRA 25 CALLE 100','661@terra.com.co','2011-02-03',127591,'2011-06-26',74600,'A');
INSERT INTO "personnes" VALUES('2122',3,'SCOCOZZA GIOVANNA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',190526,'2011-09-23',284220,'A');
INSERT INTO "personnes" VALUES('2125',3,'CHAVES MOLINA JULIO FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132165,'2011-09-22',295360,'A');
INSERT INTO "personnes" VALUES('2127',3,'BERNARDES DE SOUZA TONIATI VIRGINIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-30',565090,'A');
INSERT INTO "personnes" VALUES('2129',2,'BRIAN DAVIS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-19',78460,'A');
INSERT INTO "personnes" VALUES('213',1,'PAREJO CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-11',766120,'A');
INSERT INTO "personnes" VALUES('2131',3,'DE OLIVEIRA LOPES REGINALDO LAZARO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-10-05',404910,'A');
INSERT INTO "personnes" VALUES('2132',3,'DE MELO MING AZEVEDO PAULO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-10-05',440370,'A');
INSERT INTO "personnes" VALUES('2137',3,'SILVA JORGE ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-10-05',230570,'A');
INSERT INTO "personnes" VALUES('214',1,'CADENA RICARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-08',840,'A');
INSERT INTO "personnes" VALUES('2142',3,'VIEIRA VEIGA PEDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-30',85330,'A');
INSERT INTO "personnes" VALUES('2144',3,'ESCRIBANO LEONARDA DEL VALLE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2011-03-24',941440,'A');
INSERT INTO "personnes" VALUES('2145',3,'RODRIGUEZ MENENDEZ BERNARDO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',148511,'2011-08-02',588740,'A');
INSERT INTO "personnes" VALUES('2146',3,'GONZALEZ COURET DANIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',148511,'2011-08-09',119380,'A');
INSERT INTO "personnes" VALUES('2147',3,'GARCIA SOTO WILLIAM','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',135360,'2011-05-18',830660,'A');
INSERT INTO "personnes" VALUES('2148',3,'MENESES ORELLANA RICARDO TOMAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132165,'2011-06-13',795200,'A');
INSERT INTO "personnes" VALUES('2149',3,'GUEVARA JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-27',483990,'A');
INSERT INTO "personnes" VALUES('215',1,'BELTRAN PINZON JUAN CARLO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-08',705860,'A');
INSERT INTO "personnes" VALUES('2151',2,'LLANES GARRIDO JAVIER ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-30',719750,'A');
INSERT INTO "personnes" VALUES('2152',3,'CHAVARRIA CHAVES RAFAEL ADRIAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132165,'2011-09-20',495720,'A');
INSERT INTO "personnes" VALUES('2153',2,'MILBERT ANDREASPETER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-10',319370,'A');
INSERT INTO "personnes" VALUES('2154',2,'GOMEZ SILVA LOZANO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127300,'2011-05-30',109670,'A');
INSERT INTO "personnes" VALUES('2156',3,'WINTON ROBERT DOUGLAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',115551,'2011-08-08',622290,'A');
INSERT INTO "personnes" VALUES('2157',2,'ROMERO PINA MANUEL GUSTAVO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-05-05',340650,'A');
INSERT INTO "personnes" VALUES('2158',3,'KARWALSKI MATTHEW REECE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117229,'2011-08-29',836380,'A');
INSERT INTO "personnes" VALUES('2159',2,'KIM JUNG SIK ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-08',159950,'A');
INSERT INTO "personnes" VALUES('216',1,'MARTINEZ VALBUENA JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-25',526750,'A');
INSERT INTO "personnes" VALUES('2160',3,'AGAR ROBERT ALEXANDER','191821112','CRA 25 CALLE 100','81@hotmail.es','2011-02-03',116862,'2011-06-11',290620,'A');
INSERT INTO "personnes" VALUES('2161',3,'IGLESIAS EDGAR ALEXIS','191821112','CRA 25 CALLE 100','645@facebook.com','2011-02-03',131272,'2011-04-04',973240,'A');
INSERT INTO "personnes" VALUES('2163',2,'NOAIN MORENO CECILIA KARIM ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-22',51950,'A');
INSERT INTO "personnes" VALUES('2164',2,'FIGUEROA HEBEL ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-26',276760,'A');
INSERT INTO "personnes" VALUES('2166',5,'FRANDBERG DAN RICHARD VERNER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',134022,'2011-04-06',309480,'A');
INSERT INTO "personnes" VALUES('2168',2,'CONTRERAS LILLO EDUARDO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-27',389320,'A');
INSERT INTO "personnes" VALUES('2169',2,'BLANCO VALLE RICARDO ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-07-13',355950,'A');
INSERT INTO "personnes" VALUES('2171',2,'BELTRAN ZAVALA JIMI ALFONSO MIGUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',126674,'2011-08-22',991000,'A');
INSERT INTO "personnes" VALUES('2172',2,'RAMIRO OREGUI JOSE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2011-04-27',119700,'A');
INSERT INTO "personnes" VALUES('2175',2,'FENG PUYO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',302172,'2011-10-07',965660,'A');
INSERT INTO "personnes" VALUES('2176',3,'CLERICI GUIDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',116366,'2011-08-30',522970,'A');
INSERT INTO "personnes" VALUES('2177',1,'SEIJAS GUNTER LUIS MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-02',717890,'A');
INSERT INTO "personnes" VALUES('2178',2,'SHOSHANI MOSHE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-13',20520,'A');
INSERT INTO "personnes" VALUES('218',3,'HUCHICHALEO ARSENDIGA FRANCISCA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-05',690,'A');
INSERT INTO "personnes" VALUES('2181',2,'DOMINGO BARTOLOME LUIS FERNANDO','191821112','CRA 25 CALLE 100','173@terra.com.co','2011-02-03',127591,'2011-04-18',569030,'A');
INSERT INTO "personnes" VALUES('2182',3,'GONZALEZ RIJO JOSE ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-10-02',795610,'A');
INSERT INTO "personnes" VALUES('2183',2,'ANDROVICH MORENO LIZETH LILIAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127300,'2011-10-10',270970,'A');
INSERT INTO "personnes" VALUES('2184',2,'ARREAZA LUGO JESUS ALFREDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-08',968030,'A');
INSERT INTO "personnes" VALUES('2185',2,'NAVEDA CANELON KATHERINE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132775,'2011-09-14',27250,'A');
INSERT INTO "personnes" VALUES('2189',2,'LUGO BEHRENS DENISE SOFIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-08',253980,'A');
INSERT INTO "personnes" VALUES('2190',2,'ERICA ROSE MOLDENHAUVER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-25',175480,'A');
INSERT INTO "personnes" VALUES('2192',2,'SOLORZANO GARCIA ANDREINA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-25',50790,'A');
INSERT INTO "personnes" VALUES('2193',3,'DE LA COSTE MARIA CAROLINA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-26',907640,'A');
INSERT INTO "personnes" VALUES('2194',2,'MARTINEZ DIAZ JUAN JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-08',385810,'A');
INSERT INTO "personnes" VALUES('2195',2,'GALARRAGA ECHEVERRIA DAYEN ALI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-13',206150,'A');
INSERT INTO "personnes" VALUES('2196',2,'GUTIERREZ RAMIREZ HECTOR JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133211,'2011-06-07',873330,'A');
INSERT INTO "personnes" VALUES('2197',2,'LOPEZ GONZALEZ SILVIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127662,'2011-09-01',748170,'A');
INSERT INTO "personnes" VALUES('2198',2,'SEGARES LUTZ JOSE IGNACIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-07',120880,'A');
INSERT INTO "personnes" VALUES('2199',2,'NADER MARTIN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127538,'2011-08-12',359880,'A');
INSERT INTO "personnes" VALUES('22',1,'CARDOZO AMAYA JORGE HUMBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-25',908720,'A');
INSERT INTO "personnes" VALUES('2200',3,'NATERA BERMUDEZ OSWALDO JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2010-10-18',436740,'A');
INSERT INTO "personnes" VALUES('2201',2,'COSTA RICARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',150699,'2011-09-01',104090,'A');
INSERT INTO "personnes" VALUES('2202',5,'GRUNDY VALENZUELA ALAN PATRICK','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-08',210230,'A');
INSERT INTO "personnes" VALUES('2203',2,'MONTENEGRO DANIEL ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-26',738890,'A');
INSERT INTO "personnes" VALUES('2204',2,'TAMAI BUNGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-24',63730,'A');
INSERT INTO "personnes" VALUES('2205',5,'VINHAS FORTUNA EDSON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2011-09-23',102010,'A');
INSERT INTO "personnes" VALUES('2206',2,'RUIZ ERBS MARIO ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-07-19',318860,'A');
INSERT INTO "personnes" VALUES('2207',2,'VENTURA TINEO MARCEL ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-08',288240,'A');
INSERT INTO "personnes" VALUES('2210',2,'RAMIREZ GUZMAN RICARDO JAIME','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-28',338740,'A');
INSERT INTO "personnes" VALUES('2211',2,'STERNBERG GABRIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132958,'2011-09-04',18070,'A');
INSERT INTO "personnes" VALUES('2212',2,'MARTELLO ALEJOS ROGER ADOLFO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127443,'2011-06-20',74120,'A');
INSERT INTO "personnes" VALUES('2213',2,'CASTANEDA RAFAEL ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-25',316410,'A');
INSERT INTO "personnes" VALUES('2214',2,'LIMON MARTINEZ WILBERT DE JESUS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128904,'2011-09-19',359690,'A');
INSERT INTO "personnes" VALUES('2215',2,'PEREZ HERNANDEZ MONICA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133211,'2011-05-23',849240,'A');
INSERT INTO "personnes" VALUES('2216',2,'AWAD LOBATO RICARDO SEBASTIAN','191821112','CRA 25 CALLE 100','853@hotmail.com','2011-02-03',127591,'2011-04-12',167100,'A');
INSERT INTO "personnes" VALUES('2217',2,'CEPEDA VANEGAS ENDER ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-08-22',287770,'A');
INSERT INTO "personnes" VALUES('2218',2,'PEREZ CHIQUIN HECTOR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',132572,'2011-04-13',937580,'A');
INSERT INTO "personnes" VALUES('2220',5,'FRANCO DELGADILLO RONALD FERNANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132775,'2011-09-16',310190,'A');
INSERT INTO "personnes" VALUES('2222',2,'ALCAIDE ALONSO JUAN MIGUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-05-02',455360,'A');
INSERT INTO "personnes" VALUES('2223',3,'BROWNING BENJAMIN MARK','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-09',45230,'A');
INSERT INTO "personnes" VALUES('2225',3,'HARWOO BENJAMIN JOEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-09',164620,'A');
INSERT INTO "personnes" VALUES('2226',3,'HOEY TIMOTHY ROSS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-09',242910,'A');
INSERT INTO "personnes" VALUES('2227',3,'FERGUSON GARRY','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-28',720700,'A');
INSERT INTO "personnes" VALUES('2228',3,' NORMAN NEVILLE ROBERT','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',288493,'2011-06-29',874750,'A');
INSERT INTO "personnes" VALUES('2229',3,'KUK HYUN CHAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-03-22',211660,'A');
INSERT INTO "personnes" VALUES('223',1,'PINZON PLAZA MARCOS VINICIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-22',856300,'A');
INSERT INTO "personnes" VALUES('2230',3,'SLIPAK NATALIA ANDREA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-07-27',434070,'A');
INSERT INTO "personnes" VALUES('2231',3,'BONELLI MASSIMO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',170601,'2011-07-11',535340,'A');
INSERT INTO "personnes" VALUES('2233',3,'VUYLSTEKE ALEXANDER ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',284647,'2011-09-11',266530,'A');
INSERT INTO "personnes" VALUES('2234',3,'DRESSE ALAIN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',284272,'2011-04-19',209100,'A');
INSERT INTO "personnes" VALUES('2235',3,'PAIRON JEAN LOUIS MARIE RAIMOND','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',284272,'2011-03-03',245940,'A');
INSERT INTO "personnes" VALUES('2236',3,'DEVIANE ACHIM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',284272,'2010-11-14',602370,'A');
INSERT INTO "personnes" VALUES('2239',3,'DE CANNIERE LOUIS GEORFES HELE MARIE-JOZEF','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',285511,'2011-09-11',993540,'A');
INSERT INTO "personnes" VALUES('2240',1,'ERGO ROBERT','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-28',278270,'A');
INSERT INTO "personnes" VALUES('2241',3,'MYRTES RODRIGUEZ MORGANA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-09-18',410740,'A');
INSERT INTO "personnes" VALUES('2242',3,'BRECHBUEHL   HANSRUDOLF','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',249059,'2011-07-27',218900,'A');
INSERT INTO "personnes" VALUES('2243',3,'IVANA SCHLUMPF','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',245206,'2011-04-08',862270,'A');
INSERT INTO "personnes" VALUES('2244',3,'JESSICA JACCART','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',189512,'2011-08-28',654640,'A');
INSERT INTO "personnes" VALUES('2246',3,'PAUSELLI MARIANO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',210050,'2011-09-26',468090,'A');
INSERT INTO "personnes" VALUES('2247',3,'VOLONTEIRO RICCARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-04-13',281230,'A');
INSERT INTO "personnes" VALUES('2248',3,'HOFFMANN ALVIR ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',120773,'2011-08-23',1900,'A');
INSERT INTO "personnes" VALUES('2249',3,'MANTOVANI DANIEL FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-08-09',165820,'A');
INSERT INTO "personnes" VALUES('225',1,'DUARTE RUEDA JAVIER ALEXANDER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-29',293110,'A');
INSERT INTO "personnes" VALUES('2250',3,'LIMA DA COSTA BRENO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-03-23',823370,'A');
INSERT INTO "personnes" VALUES('2251',3,'TAMBORIN MACIEL MAGALI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-23',619420,'A');
INSERT INTO "personnes" VALUES('2252',3,'BELLO DE MUORA BIANCA','191821112','CRA 25 CALLE 100','969@gmail.com','2011-02-03',118942,'2011-08-03',626970,'A');
INSERT INTO "personnes" VALUES('2253',3,'VINHAS FORTUNA PIETRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2011-09-23',276600,'A');
INSERT INTO "personnes" VALUES('2255',3,'BLUMENTHAL JAIRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117630,'2011-07-20',680590,'A');
INSERT INTO "personnes" VALUES('2256',3,'DOS REIS FILHO ELPIDIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',120773,'2011-08-07',896720,'A');
INSERT INTO "personnes" VALUES('2257',3,'COIMBRA CARDOSO MUNARI FERNANDA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-09',441830,'A');
INSERT INTO "personnes" VALUES('2258',3,'LAZANHA FLAVIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118942,'2011-06-14',519000,'A');
INSERT INTO "personnes" VALUES('2259',3,'LAZANHA FLAVIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-06-14',269480,'A');
INSERT INTO "personnes" VALUES('226',1,'HUERFANO FLOREZ JOHN FAVER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-29',148340,'A');
INSERT INTO "personnes" VALUES('2260',3,'JOVETTA EDILSON','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118941,'2011-09-19',790430,'A');
INSERT INTO "personnes" VALUES('2261',3,'DE OLIVEIRA ANDRE RICARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2011-07-25',143680,'A');
INSERT INTO "personnes" VALUES('2263',3,'MUNDO TEIXEIRA CARVALHO SILVIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118864,'2011-09-19',304670,'A');
INSERT INTO "personnes" VALUES('2264',3,'FERREIRA CINTRA ADRIANO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-04-08',481910,'A');
INSERT INTO "personnes" VALUES('2265',3,'AUGUSTO DE OLIVEIRA MARCOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118685,'2011-08-09',495530,'A');
INSERT INTO "personnes" VALUES('2266',3,'CHEN ROBERTO LUIZ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-03-15',31920,'A');
INSERT INTO "personnes" VALUES('2268',3,'WROBLESKI DIENSTMANN RAQUEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117630,'2011-05-15',269320,'A');
INSERT INTO "personnes" VALUES('2269',3,'MALAGOLA GEDERSON','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118864,'2011-05-30',327540,'A');
INSERT INTO "personnes" VALUES('227',1,'LOPEZ ESCOBAR CARLOS ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-06',862360,'A');
INSERT INTO "personnes" VALUES('2271',3,'GOMES EVANDRO HENRIQUE','191821112','CRA 25 CALLE 100','199@hotmail.es','2011-02-03',118777,'2011-03-24',166100,'A');
INSERT INTO "personnes" VALUES('2273',3,'LANDEIRA FERNANDEZ JESUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-21',207990,'A');
INSERT INTO "personnes" VALUES('2274',3,'ROSSI RENATO','191821112','CRA 25 CALLE 100','791@hotmail.es','2011-02-03',118777,'2011-09-19',16170,'A');
INSERT INTO "personnes" VALUES('2275',3,'CALMON RANGEL PATRICIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-23',456890,'A');
INSERT INTO "personnes" VALUES('2277',3,'CIFU NETO ROQUE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-04-27',808940,'A');
INSERT INTO "personnes" VALUES('2278',3,'GONCALVES PRETO FRANCISCO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118942,'2011-07-25',336930,'A');
INSERT INTO "personnes" VALUES('2279',3,'JORGE JUNIOR ROBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118777,'2011-05-09',257840,'A');
INSERT INTO "personnes" VALUES('2281',3,'ELENCIUC DEMETRIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',118777,'2011-04-20',618510,'A');
INSERT INTO "personnes" VALUES('2283',3,'CUNHA MENDEZ RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',119855,'2011-07-18',431190,'A');
INSERT INTO "personnes" VALUES('2286',3,'DIAZ LENICE APARECIDA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-05-03',977840,'A');
INSERT INTO "personnes" VALUES('2288',3,'DE CARVALHO SIGEL TATIANA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118777,'2011-07-04',123920,'A');
INSERT INTO "personnes" VALUES('229',1,'GALARZA GIRALDO SERGIO ALDEMAR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-09-17',746930,'A');
INSERT INTO "personnes" VALUES('2290',3,'ACHOA MORANDI BORGUES SIBELE MARIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118777,'2011-09-12',553890,'A');
INSERT INTO "personnes" VALUES('2291',3,'EPAMINONDAS DE ALMEIDA DELIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-09-22',14080,'A');
INSERT INTO "personnes" VALUES('2293',3,'REIS CASTRO SHANA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-08-03',1430,'A');
INSERT INTO "personnes" VALUES('2294',3,'BERNARDES JUNIOR ARMANDO','191821112','CRA 25 CALLE 100','678@gmail.com','2011-02-03',127591,'2011-08-30',780930,'A');
INSERT INTO "personnes" VALUES('2295',3,'LEMOS DE SOUZA AGUIAR SERGIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118777,'2011-10-03',900370,'A');
INSERT INTO "personnes" VALUES('2296',3,'CARVALHO ADAMS KARIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118942,'2011-08-11',159040,'A');
INSERT INTO "personnes" VALUES('2297',3,'GALLINA SILVANA BRASILEIRA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-23',94110,'A');
INSERT INTO "personnes" VALUES('23',1,'COLMENARES PEDREROS EDUARDO ADOLFO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-02',625870,'A');
INSERT INTO "personnes" VALUES('2300',3,'TAVEIRA DE SIQUEIRA TANIA APARECIDA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-24',443910,'A');
INSERT INTO "personnes" VALUES('2301',3,'DA SIVA LIMA ANDRE LUIS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-23',165020,'A');
INSERT INTO "personnes" VALUES('2302',3,'GALVAO GUSTAVO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118942,'2011-09-12',493370,'A');
INSERT INTO "personnes" VALUES('2303',3,'DA COSTA CRUZ GABRIELA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-07-27',971800,'A');
INSERT INTO "personnes" VALUES('2304',3,'BERNHARD GOTTFRIED RABER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-04-30',378870,'A');
INSERT INTO "personnes" VALUES('2306',3,'ALDANA URIBE PABLO AXEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-05-08',758160,'A');
INSERT INTO "personnes" VALUES('2308',3,'FLORES ALONSO EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-04-26',995310,'A');
INSERT INTO "personnes" VALUES('CELL4330',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('2309',3,'MADRIGAL MIER Y TERAN LUIS FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-02-23',414650,'A');
INSERT INTO "personnes" VALUES('231',1,'ZAPATA CEBALLOS JUAN MANUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127662,'2011-08-16',430320,'A');
INSERT INTO "personnes" VALUES('2310',3,'GONZALEZ ALVARO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-05-19',87330,'A');
INSERT INTO "personnes" VALUES('2313',3,'MONTES PORTO ANDREA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-09-01',929180,'A');
INSERT INTO "personnes" VALUES('2314',3,'ROCHA SUSUNAGA SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2010-10-18',541540,'A');
INSERT INTO "personnes" VALUES('2315',3,'VASQUEZ CALERO FEDERICO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-22',920160,'A');
INSERT INTO "personnes" VALUES('2317',3,'GONZALEZ FERNANDEZ YUSSEN ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-26',120530,'A');
INSERT INTO "personnes" VALUES('2319',3,'ATTIAS WENGROWSKY DAVID','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150581,'2011-09-07',8580,'A');
INSERT INTO "personnes" VALUES('232',1,'OSPINA ABUCHAIBE ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-07-14',748960,'A');
INSERT INTO "personnes" VALUES('2320',3,'EFRON TOPOROVSKY INES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',116511,'2011-07-15',20810,'A');
INSERT INTO "personnes" VALUES('2321',3,'LUNA PLA DARIO','191821112','CRA 25 CALLE 100','95@terra.com.co','2011-02-03',145135,'2011-09-07',78320,'A');
INSERT INTO "personnes" VALUES('2322',1,'VAZQUEZ DANIELA','191821112','CRA 25 CALLE 100','190@gmail.com','2011-02-03',145135,'2011-05-19',329170,'A');
INSERT INTO "personnes" VALUES('2323',3,'BALBI BALBI JUAN DE DIOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-08-23',410880,'A');
INSERT INTO "personnes" VALUES('2324',3,'MARROQUIN FERNANDEZ GELACIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-03-23',66880,'A');
INSERT INTO "personnes" VALUES('2325',3,'VAZQUEZ ZAVALA ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-04-11',101770,'A');
INSERT INTO "personnes" VALUES('2326',3,'SOTO MARTINEZ MARIA ELENA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-23',308200,'A');
INSERT INTO "personnes" VALUES('2328',3,'HERNANDEZ MURILLO RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-08-22',253830,'A');
INSERT INTO "personnes" VALUES('233',1,'HADDAD LINERO YEBRAIL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',130608,'2010-06-17',453830,'A');
INSERT INTO "personnes" VALUES('2330',3,'TERMINEL HERNANDEZ DANIELA PATRICIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',190393,'2011-08-15',48940,'A');
INSERT INTO "personnes" VALUES('2331',3,'MIJARES FERNANDEZ MAGDALENA GUADALUPE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-07-31',558440,'A');
INSERT INTO "personnes" VALUES('2332',3,'GONZALEZ LUNA CARLOS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',146258,'2011-04-26',645400,'A');
INSERT INTO "personnes" VALUES('2333',3,'DIAZ TORREJON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-05-03',551690,'A');
INSERT INTO "personnes" VALUES('2335',3,'PADILLA GUTIERREZ JESUS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',456120,'A');
INSERT INTO "personnes" VALUES('2336',3,'TORRES CORONA JORGE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-04-11',813900,'A');
INSERT INTO "personnes" VALUES('2337',3,'CASTRO RAMSES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',150581,'2011-07-04',701120,'A');
INSERT INTO "personnes" VALUES('2338',3,'APARICIO VALLEJO RUSSELL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-03-16',63890,'A');
INSERT INTO "personnes" VALUES('2339',3,'ALBOR FERNANDEZ LUIS ARTURO','191821112','CRA 25 CALLE 100','574@gmail.com','2011-02-03',147467,'2011-05-09',216110,'A');
INSERT INTO "personnes" VALUES('234',1,'DOMINGUEZ GOMEZ JUAN CARLOS','191821112','CRA 25 CALLE 100','942@hotmail.com','2011-02-03',127591,'2010-08-22',22260,'A');
INSERT INTO "personnes" VALUES('2342',3,'REY ALEJANDRO','191821112','CRA 25 CALLE 100','110@facebook.com','2011-02-03',127591,'2011-03-04',313330,'A');
INSERT INTO "personnes" VALUES('2343',3,'MENDOZA GONZALES ADRIANA','191821112','CRA 25 CALLE 100','295@yahoo.com','2011-02-03',127591,'2011-03-23',178720,'A');
INSERT INTO "personnes" VALUES('2344',3,'RODRIGUEZ SEGOVIA JESUS ALONSO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-07-26',953590,'A');
INSERT INTO "personnes" VALUES('2345',3,'GONZALEZ PELAEZ EDUARDO DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-26',231790,'A');
INSERT INTO "personnes" VALUES('2347',3,'VILLEDA GARCIA DAVID','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',144939,'2011-05-29',795600,'A');
INSERT INTO "personnes" VALUES('2348',3,'FERRER BURGES EMILIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-04-11',83430,'A');
INSERT INTO "personnes" VALUES('2349',3,'NARRO ROBLES LUIS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-03-16',30330,'A');
INSERT INTO "personnes" VALUES('2350',3,'ZALDIVAR UGALDE CARLOS IGNACIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-06-19',901380,'A');
INSERT INTO "personnes" VALUES('2351',3,'VARGAS RODRIGUEZ VALENTE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',146258,'2011-04-26',415910,'A');
INSERT INTO "personnes" VALUES('2354',3,'DEL PIERO FRANCISCO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-09',19890,'A');
INSERT INTO "personnes" VALUES('2355',3,'VILLAREAL ANA CRISTINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-23',211810,'A');
INSERT INTO "personnes" VALUES('2356',3,'GARRIDO FERRAN JORGE ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-22',999370,'A');
INSERT INTO "personnes" VALUES('2357',3,'PEREZ PRECIADO EDMUNDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-22',361450,'A');
INSERT INTO "personnes" VALUES('2358',3,'AGUIRRE VIGNAU DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150581,'2011-08-21',809110,'A');
INSERT INTO "personnes" VALUES('2359',3,'LOPEZ SESMA TOMAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',146258,'2011-09-14',961200,'A');
INSERT INTO "personnes" VALUES('236',1,'VENTO BETANCOURT LUIS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-03-19',682230,'A');
INSERT INTO "personnes" VALUES('2360',3,'BERNAL MALDONADO GUILLERMO JAVIER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2011-09-19',378670,'A');
INSERT INTO "personnes" VALUES('2361',3,'GUZMAN DELGADO ALFREDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-22',9770,'A');
INSERT INTO "personnes" VALUES('2362',3,'GUZMAN DELGADO MARTIN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',912850,'A');
INSERT INTO "personnes" VALUES('2363',3,'GUSMAND ELGADO JORGE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-22',534910,'A');
INSERT INTO "personnes" VALUES('2364',3,'RENDON BUICK JORGE JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-26',936010,'A');
INSERT INTO "personnes" VALUES('2365',3,'HERNANDEZ HERNANDEZ HERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-22',75340,'A');
INSERT INTO "personnes" VALUES('2366',3,'ALVAREZ PAZ PEDRO RAFAEL ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-01-02',568650,'A');
INSERT INTO "personnes" VALUES('2367',3,'MIJARES DE LA BARREDA FERNANDA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-07-31',617240,'A');
INSERT INTO "personnes" VALUES('2368',3,'MARTINEZ LOPEZ MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-08-24',380250,'A');
INSERT INTO "personnes" VALUES('2369',3,'GAYTAN MILLAN YANERI','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-23',49520,'A');
INSERT INTO "personnes" VALUES('237',1,'BARGUIL ASSIS DAVID ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117460,'2009-09-03',161770,'A');
INSERT INTO "personnes" VALUES('2370',3,'DURAN HEREDIA FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-04-15',106850,'A');
INSERT INTO "personnes" VALUES('2371',3,'SEGURA MIJARES CRISTOBAL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-31',385700,'A');
INSERT INTO "personnes" VALUES('2372',3,'TEPOS VALTIERRA ERIK ARTURO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',116345,'2011-09-01',607930,'A');
INSERT INTO "personnes" VALUES('2373',3,'RODRIGUEZ AGUILAR EDMUNDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-05-04',882570,'A');
INSERT INTO "personnes" VALUES('2374',3,'MYSLABODSKI MICHAEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-03-08',589060,'A');
INSERT INTO "personnes" VALUES('2375',3,'HERNANDEZ MIRELES JATNIEL ELIOENAI','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-26',297600,'A');
INSERT INTO "personnes" VALUES('2376',3,'SNELL FERNANDEZ SYNTYHA ROCIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',720830,'A');
INSERT INTO "personnes" VALUES('2378',3,'HERNANDEZ EIVET AARON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-26',394200,'A');
INSERT INTO "personnes" VALUES('2379',3,'LOPEZ GARZA JAIME','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-22',837000,'A');
INSERT INTO "personnes" VALUES('238',1,'GARCIA PINO CARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-10',762140,'A');
INSERT INTO "personnes" VALUES('2381',3,'TOSCANO ESTRADA RUBEN ENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-22',500940,'A');
INSERT INTO "personnes" VALUES('2382',3,'RAMIREZ HUDSON ROGER SILVESTER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-22',497550,'A');
INSERT INTO "personnes" VALUES('2383',3,'RAMOS JUAN ANTONIO','191821112','CRA 25 CALLE 100','362@yahoo.es','2011-02-03',127591,'2011-08-22',984940,'A');
INSERT INTO "personnes" VALUES('2384',3,'CORTES CERVANTES ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-04-11',432020,'A');
INSERT INTO "personnes" VALUES('2385',3,'POZOS ESQUIVEL DAVID','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-09-27',205310,'A');
INSERT INTO "personnes" VALUES('2387',3,'ESTRADA AGUIRRE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-22',36470,'A');
INSERT INTO "personnes" VALUES('2388',3,'GARCIA RAMIREZ RAMON','191821112','CRA 25 CALLE 100','177@yahoo.es','2011-02-03',127591,'2011-08-22',990910,'A');
INSERT INTO "personnes" VALUES('2389',3,'PRUD HOMME GARCIA CUBAS XAVIER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-05-18',845140,'A');
INSERT INTO "personnes" VALUES('239',1,'PINZON ARDILA GUSTAVO ALFONSO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-01',325400,'A');
INSERT INTO "personnes" VALUES('2390',3,'ELIZABETH OCHOA ROJAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-05-21',252950,'A');
INSERT INTO "personnes" VALUES('2391',3,'MEZA ALVAREZ JOSE ALBERTO','191821112','CRA 25 CALLE 100','646@terra.com.co','2011-02-03',144939,'2011-05-09',729340,'A');
INSERT INTO "personnes" VALUES('2392',3,'HERRERA REYES RENATO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2010-02-28',887860,'A');
INSERT INTO "personnes" VALUES('2393',3,'MURILLO GARIBAY GILBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-08-20',251280,'A');
INSERT INTO "personnes" VALUES('2394',3,'GARCIA JIMENEZ CARLOS MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-10-09',592830,'A');
INSERT INTO "personnes" VALUES('2395',3,'GUAGNELLI MARTINEZ BLANCA MONICA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145184,'2010-10-05',210320,'A');
INSERT INTO "personnes" VALUES('2397',3,'GARCIA CISNEROS RAUL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-07-04',734530,'A');
INSERT INTO "personnes" VALUES('2398',3,'MIRANDA ROMO FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',853340,'A');
INSERT INTO "personnes" VALUES('24',1,'ARREGOCES GARZON NELSON ORLANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127783,'2011-08-12',403190,'A');
INSERT INTO "personnes" VALUES('240',1,'ARCINIEGAS GOMEZ ALBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-18',340590,'A');
INSERT INTO "personnes" VALUES('2400',3,'HERRERA ABARCA EDUARDO VICENTE ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-22',755620,'A');
INSERT INTO "personnes" VALUES('2403',3,'CASTRO MONCAYO LUIS ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-07-29',617260,'A');
INSERT INTO "personnes" VALUES('2404',3,'GUZMAN DELGADO OSBALDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-22',56250,'A');
INSERT INTO "personnes" VALUES('2405',3,'GARCIA LOPEZ DAVID','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-22',429500,'A');
INSERT INTO "personnes" VALUES('2406',3,'JIMENEZ GAMEZ RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',245206,'2011-03-23',978720,'A');
INSERT INTO "personnes" VALUES('2407',3,'BECERRA MARTINEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-08-23',605130,'A');
INSERT INTO "personnes" VALUES('2408',3,'GARCIA MARTINEZ BERNARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-22',89480,'A');
INSERT INTO "personnes" VALUES('2409',3,'URRUTIA RAYAS BALTAZAR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-22',632020,'A');
INSERT INTO "personnes" VALUES('241',1,'MEDINA AGUILA NESTOR EDUARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-09',726730,'A');
INSERT INTO "personnes" VALUES('2411',3,'VERGARA MENDOZAVICTOR HUGO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-06-15',562230,'A');
INSERT INTO "personnes" VALUES('2412',3,'MENDOZA MEDINA JORGE IGNACIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-22',136170,'A');
INSERT INTO "personnes" VALUES('2413',3,'CORONADO CASTILLO HUGO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',147529,'2011-05-09',994160,'A');
INSERT INTO "personnes" VALUES('2414',3,'GONZALEZ SOTO DELIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-03-23',562280,'A');
INSERT INTO "personnes" VALUES('2415',3,'HERNANDEZ FLORES STEPHANIE REYNA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-23',828940,'A');
INSERT INTO "personnes" VALUES('2416',3,'ABRAJAN GUERRERO MARIA DE LOS ANGELES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-03-23',457860,'A');
INSERT INTO "personnes" VALUES('2417',3,'HERNANDEZ LOERA ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-23',802490,'A');
INSERT INTO "personnes" VALUES('2418',3,'TARIN LOPEZ JOSE CARMEN','191821112','CRA 25 CALLE 100','117@gmail.com','2011-02-03',127591,'2011-03-23',638870,'A');
INSERT INTO "personnes" VALUES('242',1,'JULIO NARVAEZ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-05',611890,'A');
INSERT INTO "personnes" VALUES('2420',3,'BATTA MARQUEZ VICTOR ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-08-23',17820,'A');
INSERT INTO "personnes" VALUES('2423',3,'GONZALEZ REYES JUAN JOSE','191821112','CRA 25 CALLE 100','55@yahoo.es','2011-02-03',127591,'2011-07-26',758070,'A');
INSERT INTO "personnes" VALUES('2425',3,'ALVAREZ RODRIGUEZ HIRAM RAMSES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-23',847420,'A');
INSERT INTO "personnes" VALUES('2426',3,'FEMATT HERNANDEZ JESUS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-03-23',164130,'A');
INSERT INTO "personnes" VALUES('2427',3,'GUTIERRES ORTEGA FRANCISCO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-22',278410,'A');
INSERT INTO "personnes" VALUES('2428',3,'JIMENEZ DIAZ JUAN JORGE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-13',899650,'A');
INSERT INTO "personnes" VALUES('2429',3,'VILLANUEVA PEREZ MIGUEL ANGEL','191821112','CRA 25 CALLE 100','656@yahoo.es','2011-02-03',150449,'2011-03-23',663000,'A');
INSERT INTO "personnes" VALUES('243',1,'GOMEZ REYES ANDRES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',126674,'2009-12-20',879240,'A');
INSERT INTO "personnes" VALUES('2430',3,'CERON GOMEZ JOEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-03-21',616070,'A');
INSERT INTO "personnes" VALUES('2431',3,'LOPEZ LINALDI DEMETRIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-05-09',91360,'A');
INSERT INTO "personnes" VALUES('2432',3,'JOSEPH NATHAN PEDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-02',608580,'A');
INSERT INTO "personnes" VALUES('2433',3,'CARRENO PULIDO RUBEN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',147242,'2011-06-19',768810,'A');
INSERT INTO "personnes" VALUES('2434',3,'AREVALO MERCADO CARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-06-12',18320,'A');
INSERT INTO "personnes" VALUES('2436',3,'RAMIREZ QUEZADA ERIKA BELEM','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-03',870930,'A');
INSERT INTO "personnes" VALUES('2438',3,'TATTO PRIETO MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-05-19',382740,'A');
INSERT INTO "personnes" VALUES('2439',3,'LOPEZ AYALA LUIS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-10-08',916370,'A');
INSERT INTO "personnes" VALUES('244',1,'DEVIS EDGAR JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-10-08',560540,'A');
INSERT INTO "personnes" VALUES('2440',3,'HERNANDEZ TOVAR JORGE ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',144991,'2011-10-02',433650,'A');
INSERT INTO "personnes" VALUES('2441',3,'COLLIARD LOPEZ PETER GEORGE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-09',419120,'A');
INSERT INTO "personnes" VALUES('2442',3,'FLORES CHALA GARY','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-22',794670,'A');
INSERT INTO "personnes" VALUES('2443',3,'FANDINO MUNOZ ZAMIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-19',715970,'A');
INSERT INTO "personnes" VALUES('2444',3,'BARROSO VARGAS DIEGO ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-26',195840,'A');
INSERT INTO "personnes" VALUES('2446',3,'CRUZ RAMIREZ JUAN PEDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-07-14',569050,'A');
INSERT INTO "personnes" VALUES('2447',3,'TIJERINA ACOSTA SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-26',351280,'A');
INSERT INTO "personnes" VALUES('2449',3,'JASSO BARRERA CARLOS GUSTAVO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-08-24',192560,'A');
INSERT INTO "personnes" VALUES('245',1,'LENCHIG KALEDA SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-09-02',165000,'A');
INSERT INTO "personnes" VALUES('2450',3,'GARRIDO PATRON VICTOR','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-09-27',814970,'A');
INSERT INTO "personnes" VALUES('2451',3,'VELASQUEZ GUERRERO RUBEN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-20',497150,'A');
INSERT INTO "personnes" VALUES('2452',3,'CHOI SUNGKYU','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',209494,'2011-08-16',40860,'A');
INSERT INTO "personnes" VALUES('2453',3,'CONTRERAS LOPEZ SERGIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-08-05',712830,'A');
INSERT INTO "personnes" VALUES('2454',3,'CHAVEZ BATAA OSCAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',150699,'2011-06-14',441590,'A');
INSERT INTO "personnes" VALUES('2455',3,'LEE JONG HYUN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131272,'2011-10-10',69460,'A');
INSERT INTO "personnes" VALUES('2456',3,'MEDINA PADILLA CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',146589,'2011-04-20',22530,'A');
INSERT INTO "personnes" VALUES('2457',3,'FLORES CUEVAS DOTNARA LUZ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-05-17',904260,'A');
INSERT INTO "personnes" VALUES('2458',3,'LIU YONGCHAO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-10-09',453710,'A');
INSERT INTO "personnes" VALUES('2459',3,'CASTRO FERNANDES PORTOCARRERO JOSE MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',195892,'2011-06-14',555790,'A');
INSERT INTO "personnes" VALUES('246',1,'YAMHURE FONSECAN ERNESTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-10-03',143350,'A');
INSERT INTO "personnes" VALUES('2460',3,'DUAN WEI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-06-22',417820,'A');
INSERT INTO "personnes" VALUES('2461',3,'ZHU XUTAO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-18',421740,'A');
INSERT INTO "personnes" VALUES('2462',3,'MEI SHUANNIU','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-10-09',855240,'A');
INSERT INTO "personnes" VALUES('2464',3,'VEGA VACA LUIS ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-06-08',489110,'A');
INSERT INTO "personnes" VALUES('2465',3,'TANG YUMING','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',147578,'2011-03-26',412660,'A');
INSERT INTO "personnes" VALUES('2466',3,'VILLEDA GARCIA DAVID','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',144939,'2011-06-07',595990,'A');
INSERT INTO "personnes" VALUES('2467',3,'GARCIA GARZA BLANCA ARMIDA','191821112','CRA 25 CALLE 100','927@hotmail.com','2011-02-03',145135,'2011-05-20',741940,'A');
INSERT INTO "personnes" VALUES('2468',3,'HERNANDEZ MARTINEZ EMILIO JOAQUIN','191821112','CRA 25 CALLE 100','356@facebook.com','2011-02-03',145135,'2011-06-16',921740,'A');
INSERT INTO "personnes" VALUES('2469',3,'WANG FAN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',185363,'2011-08-20',382860,'A');
INSERT INTO "personnes" VALUES('247',1,'ROJAS RODRIGUEZ ALVARO HERNAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-09',221760,'A');
INSERT INTO "personnes" VALUES('2470',3,'WANG FEI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-10-09',149100,'A');
INSERT INTO "personnes" VALUES('2471',3,'BERNAL MALDONADO GUILLERMO JAVIER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118777,'2011-07-26',596900,'A');
INSERT INTO "personnes" VALUES('2472',3,'GUTIERREZ GOMEZ ARTURO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145184,'2011-07-24',537210,'A');
INSERT INTO "personnes" VALUES('2474',3,'LAN TYANYE ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-23',865050,'A');
INSERT INTO "personnes" VALUES('2475',3,'LAN SHUZHEN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-23',639240,'A');
INSERT INTO "personnes" VALUES('2476',3,'RODRIGUEZ GONZALEZ CARLOS ARTURO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',144616,'2011-08-09',601050,'A');
INSERT INTO "personnes" VALUES('2477',3,'HAIBO NI','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-20',87540,'A');
INSERT INTO "personnes" VALUES('2479',3,'RUIZ RODRIGUEZ GRACIELA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-05-20',910130,'A');
INSERT INTO "personnes" VALUES('248',1,'GONZALEZ RODRIGUEZ ANDRES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-03',678750,'A');
INSERT INTO "personnes" VALUES('2480',3,'OROZCO MACIAS NORMA LETICIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-09-20',647010,'A');
INSERT INTO "personnes" VALUES('2481',3,'MEZA ALVAREZ JOSE ALBERTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',144939,'2011-06-07',504670,'A');
INSERT INTO "personnes" VALUES('2482',3,'RODRIGUEZ FIGUEROA RODRIGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',146308,'2011-04-27',582290,'A');
INSERT INTO "personnes" VALUES('2483',3,'CARREON GUERRA ANA CECILIA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',110709,'2011-05-27',397440,'A');
INSERT INTO "personnes" VALUES('2484',3,'BOTELHO BARRETO CARLOS JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',195892,'2011-08-02',240350,'A');
INSERT INTO "personnes" VALUES('2485',3,'CORONADO CASTILLO HUGO','191821112','CRA 25 CALLE 100','209@yahoo.com.mx','2011-02-03',147529,'2011-06-07',9420,'A');
INSERT INTO "personnes" VALUES('2486',3,'DE FUENTES GARZA MARCELO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-18',326030,'A');
INSERT INTO "personnes" VALUES('2487',3,'GONZALEZ DUHART GUTIERREZ HORACIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-17',601920,'A');
INSERT INTO "personnes" VALUES('2488',3,'LOPEZ LINALDI DEMETRIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-06-07',31500,'A');
INSERT INTO "personnes" VALUES('2489',3,'CASTRO MONCAYO JOSE LUIS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-06-15',351720,'A');
INSERT INTO "personnes" VALUES('249',1,'CASTRO RIBEROS JULIAN ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-23',728470,'A');
INSERT INTO "personnes" VALUES('2490',3,'SERRALDE LOPEZ MARIA GUADALUPE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-25',664120,'A');
INSERT INTO "personnes" VALUES('2491',3,'GARRIDO PATRON VICTOR','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-09-29',265450,'A');
INSERT INTO "personnes" VALUES('2492',3,'BRAUN JUAN NICOLAS ANTONIE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-28',334880,'A');
INSERT INTO "personnes" VALUES('2493',3,'BANKA RAHUL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',141138,'2011-05-02',878070,'A');
INSERT INTO "personnes" VALUES('2494',1,'GARCIA MARTINEZ MARIA VIRGINIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-17',385690,'A');
INSERT INTO "personnes" VALUES('2495',1,'MARIA VIRGINIA','191821112','CRA 25 CALLE 100','298@yahoo.com.mx','2011-02-03',127591,'2011-04-16',294220,'A');
INSERT INTO "personnes" VALUES('2496',3,'GOMEZ ZENDEJAS MARIA ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145184,'2011-06-06',314060,'A');
INSERT INTO "personnes" VALUES('2498',3,'MENDEZ MARTINEZ RAUL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-07-10',496040,'A');
INSERT INTO "personnes" VALUES('2623',3,'ZAFIROPOULO ANA I','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-25',98170,'A');
INSERT INTO "personnes" VALUES('2499',3,'CARREON GUERRA ANA CECILIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-07-29',417240,'A');
INSERT INTO "personnes" VALUES('2501',3,'OLIVAR ARIAS ISMAEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-06-06',738850,'A');
INSERT INTO "personnes" VALUES('2502',3,'ABOUMRAD NASTA EMILE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',145135,'2011-07-26',899890,'A');
INSERT INTO "personnes" VALUES('2503',3,'RODRIGUEZ JIMENEZ ROBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-05-03',282900,'A');
INSERT INTO "personnes" VALUES('2504',3,'ESTADOS UNIDOS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',145135,'2011-07-27',714840,'A');
INSERT INTO "personnes" VALUES('2505',3,'SOTO MUNOZ MARCO GREGORIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-26',725480,'A');
INSERT INTO "personnes" VALUES('2506',3,'GARCIA MONTER ANA OTILIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',145135,'2011-10-05',482880,'A');
INSERT INTO "personnes" VALUES('2507',3,'THIRUKONDA VIGNESH','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',126180,'2011-05-02',237950,'A');
INSERT INTO "personnes" VALUES('2508',3,'RAMIREZ REATIAGA LYDA YOANA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',150699,'2011-06-26',741120,'A');
INSERT INTO "personnes" VALUES('2509',3,'SEPULVEDA RODRIGUEZ JESUS ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-26',991730,'A');
INSERT INTO "personnes" VALUES('251',1,'MEJIA PIZANO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-10',845000,'A');
INSERT INTO "personnes" VALUES('2510',3,'FRANCISCO MARIA DIAS COSTA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',179111,'2011-07-12',735330,'A');
INSERT INTO "personnes" VALUES('2511',3,'TEIXEIRA REGO DE OLIVEIRA TIAGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',179111,'2011-06-14',701430,'A');
INSERT INTO "personnes" VALUES('2512',3,'PHILLIP JAMES','191821112','CRA 25 CALLE 100','766@terra.com.co','2011-02-03',127591,'2011-09-28',301150,'A');
INSERT INTO "personnes" VALUES('2513',3,'ERXLEBEN ROBERT','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',216125,'2011-04-13',401460,'A');
INSERT INTO "personnes" VALUES('2514',3,'HUGHES  CONNORRICHARD','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2011-06-22',103880,'A');
INSERT INTO "personnes" VALUES('2515',3,'LEBLANC MICHAEL PAUL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',216125,'2011-08-09',314990,'A');
INSERT INTO "personnes" VALUES('2517',3,'DEVINE CHRISTOPHER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2011-06-22',371560,'A');
INSERT INTO "personnes" VALUES('2518',3,'WONG BRIAN TEK FUNG','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126885,'2011-09-22',67910,'A');
INSERT INTO "personnes" VALUES('2519',3,'BIDWALA IRFAN A','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',154811,'2011-03-28',224840,'A');
INSERT INTO "personnes" VALUES('252',1,'JIMENEZ LARRARTE JUAN GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-01',406770,'A');
INSERT INTO "personnes" VALUES('2520',3,'LEE HO YIN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',147578,'2011-08-29',920470,'A');
INSERT INTO "personnes" VALUES('2521',3,'DE MOURA MARTINS NUNO ALEXANDRE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196094,'2011-10-09',927850,'A');
INSERT INTO "personnes" VALUES('2522',3,'DA COSTA GOMES CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',179111,'2011-08-10',877850,'A');
INSERT INTO "personnes" VALUES('2523',3,'HOOGWAERTS PAUL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118777,'2011-02-11',605690,'A');
INSERT INTO "personnes" VALUES('2524',3,'LOPES MARQUES LUIS JOSE MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118942,'2011-09-20',394910,'A');
INSERT INTO "personnes" VALUES('2525',3,'CORREIA CAVACO JOSE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',178728,'2011-10-09',157470,'A');
INSERT INTO "personnes" VALUES('2526',3,'HALL JOHN WILLIAM','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-09',602620,'A');
INSERT INTO "personnes" VALUES('2527',3,'KNIGHT MARTIN GYLES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',113550,'2011-08-29',540670,'A');
INSERT INTO "personnes" VALUES('2528',3,'HINDS THMAS TRISTAN PELLEW','191821112','CRA 25 CALLE 100','337@yahoo.es','2011-02-03',116862,'2011-08-23',895500,'A');
INSERT INTO "personnes" VALUES('2529',3,'CARTON ALAN JOHN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-07-31',855510,'A');
INSERT INTO "personnes" VALUES('253',1,'AZCUENAGA RAMIREZ NICOLAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',298472,'2011-05-10',498840,'A');
INSERT INTO "personnes" VALUES('2530',3,'GHIM CHEOLL HO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-27',591060,'A');
INSERT INTO "personnes" VALUES('2531',3,'PHILLIPS NADIA SULLIVAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-28',388750,'A');
INSERT INTO "personnes" VALUES('2532',3,'CHANG KUKHYUN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-03-22',170560,'A');
INSERT INTO "personnes" VALUES('2533',3,'KANG SEOUNGHYUN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',173192,'2011-08-24',686540,'A');
INSERT INTO "personnes" VALUES('2534',3,'CHUNG BYANG HOON','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',125744,'2011-03-14',921030,'A');
INSERT INTO "personnes" VALUES('2535',3,'SHIN MIN CHUL ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',173192,'2011-08-24',545510,'A');
INSERT INTO "personnes" VALUES('2536',3,'CHOI JIN SUNG','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-15',964490,'A');
INSERT INTO "personnes" VALUES('2537',3,'CHOI SUNGMIN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-27',185910,'A');
INSERT INTO "personnes" VALUES('2538',3,'PARK JAESER ','191821112','CRA 25 CALLE 100','525@terra.com.co','2011-02-03',127591,'2011-09-03',36090,'A');
INSERT INTO "personnes" VALUES('2539',3,'KIM DAE HOON ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',173192,'2011-08-24',622700,'A');
INSERT INTO "personnes" VALUES('254',1,'AVENDANO PABON ROLANDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-05-12',273900,'A');
INSERT INTO "personnes" VALUES('2540',3,'LYNN MARIA CRISTINA NORMA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',116862,'2011-09-21',5220,'A');
INSERT INTO "personnes" VALUES('2541',3,'KIM CHINIL JULIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',147578,'2011-08-27',158030,'A');
INSERT INTO "personnes" VALUES('2543',3,'HALL JOHN WILLIAM','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-09',398290,'A');
INSERT INTO "personnes" VALUES('2544',3,'YOSUKE PERDOMO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',165600,'2011-07-26',668040,'A');
INSERT INTO "personnes" VALUES('2546',3,'AKAGI KAZAHIKO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-26',722510,'A');
INSERT INTO "personnes" VALUES('2547',3,'NELSON JONATHAN GARY','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-09',176570,'A');
INSERT INTO "personnes" VALUES('2548',3,'DUONG HOP BA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',116862,'2011-09-14',715310,'A');
INSERT INTO "personnes" VALUES('2549',3,'CHAO-VILLEGAS NIKOLE TUK HING','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',180063,'2011-04-05',46830,'A');
INSERT INTO "personnes" VALUES('255',1,'CORREA ALVARO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-27',872990,'A');
INSERT INTO "personnes" VALUES('2551',3,'APPELS LAURENT BERNHARD','191821112','CRA 25 CALLE 100','891@hotmail.es','2011-02-03',135190,'2011-08-16',300620,'A');
INSERT INTO "personnes" VALUES('2552',3,'PLAISIER ERIK JAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',289294,'2011-05-23',238440,'A');
INSERT INTO "personnes" VALUES('2553',3,'BLOK HENDRIK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',288552,'2011-03-27',290350,'A');
INSERT INTO "personnes" VALUES('2554',3,'NETTE ANNA STERRE','191821112','CRA 25 CALLE 100','621@yahoo.com.mx','2011-02-03',185363,'2011-07-30',736400,'A');
INSERT INTO "personnes" VALUES('2555',3,'FRIELING HANS ERIC','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',107469,'2011-07-31',810990,'A');
INSERT INTO "personnes" VALUES('2556',3,'RUTTE CORNELIA JANTINE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',143579,'2011-03-30',845710,'A');
INSERT INTO "personnes" VALUES('2557',3,'WALRAVEN PIETER PAUL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',289294,'2011-07-29',795620,'A');
INSERT INTO "personnes" VALUES('2558',3,'TREBES LAURENS JOHANNES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-11-22',440940,'A');
INSERT INTO "personnes" VALUES('2559',3,'KROESE  ROLANDWILLEBRORDUSMARIA','191821112','CRA 25 CALLE 100','188@facebook.com','2011-02-03',110643,'2011-06-09',817860,'A');
INSERT INTO "personnes" VALUES('256',1,'FARIAS GARCIA REINI','191821112','CRA 25 CALLE 100','615@hotmail.com','2011-02-03',127591,'2011-03-05',543220,'A');
INSERT INTO "personnes" VALUES('2560',3,'VAN DER HEIDE HENDRIK','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',291042,'2011-09-04',766460,'A');
INSERT INTO "personnes" VALUES('2561',3,'VAN DEN BERG DONAR ALEXANDER GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',190393,'2011-07-13',378720,'A');
INSERT INTO "personnes" VALUES('2562',3,'GODEFRIDUS JOHANNES ROPS ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127622,'2011-10-02',594240,'A');
INSERT INTO "personnes" VALUES('2564',3,'WAT YOK YIENG','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',287095,'2011-03-22',392370,'A');
INSERT INTO "personnes" VALUES('2565',3,'BUIS JACOBUS NICOLAAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-20',456810,'A');
INSERT INTO "personnes" VALUES('2567',3,'CHIPPER FRANCIUSCUS NICOLAAS ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',291599,'2011-07-28',164300,'A');
INSERT INTO "personnes" VALUES('2568',3,'ONNO ROUKENS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-11-28',500670,'A');
INSERT INTO "personnes" VALUES('2569',3,'PETRUS MARCELLINUS STEPHANUS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150699,'2011-06-25',10430,'A');
INSERT INTO "personnes" VALUES('2571',3,'VAN VOLLENHOVEN IVO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-08',719370,'A');
INSERT INTO "personnes" VALUES('2572',3,'LAMBOOIJ BART','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-09-20',946480,'A');
INSERT INTO "personnes" VALUES('2573',3,'LANSER MARIANA PAULINE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',289294,'2011-04-09',574270,'A');
INSERT INTO "personnes" VALUES('2575',3,'KLERKEN JOHANNES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',286101,'2011-05-24',436840,'A');
INSERT INTO "personnes" VALUES('2576',3,'KRAS JACOBUS NICOLAAS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',289294,'2011-09-26',88410,'A');
INSERT INTO "personnes" VALUES('2577',3,'FUCHS MICHAEL JOSEPH','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',185363,'2011-07-30',131530,'A');
INSERT INTO "personnes" VALUES('2578',3,'BIJVANK ERIK JAN WILLEM','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-11',392410,'A');
INSERT INTO "personnes" VALUES('2579',3,'SCHMIDT FRANC ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',106742,'2011-09-11',567470,'A');
INSERT INTO "personnes" VALUES('258',1,'SOTO GONZALEZ FRANCISCO LAZARO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',116511,'2011-05-07',856050,'A');
INSERT INTO "personnes" VALUES('2580',3,'VAN DER KOOIJ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',291277,'2011-07-10',660130,'A');
INSERT INTO "personnes" VALUES('2581',2,'KRIS ANDRE GEORGES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127300,'2011-07-26',598240,'A');
INSERT INTO "personnes" VALUES('2582',3,'HARDING LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',263813,'2011-05-08',10820,'A');
INSERT INTO "personnes" VALUES('2583',3,'ROLLI GUY JEAN ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',145135,'2011-05-31',259370,'A');
INSERT INTO "personnes" VALUES('2584',3,'NIETO PARRA SEBASTIAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',263813,'2011-07-04',264400,'A');
INSERT INTO "personnes" VALUES('2585',3,'LASTRA CHAVEZ PABLO ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',126674,'2011-05-25',543890,'A');
INSERT INTO "personnes" VALUES('2586',1,'ZAIDA MAYERLY','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-05-05',926250,'A');
INSERT INTO "personnes" VALUES('2587',1,'OSWALDO SOLORZANO CONTRERAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-28',999590,'A');
INSERT INTO "personnes" VALUES('2588',3,'ZHOU XUAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-18',219200,'A');
INSERT INTO "personnes" VALUES('2589',3,'HUANG ZHENGQUN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-18',97230,'A');
INSERT INTO "personnes" VALUES('259',1,'GALARZA NARANJO JAIME RENE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-18',988830,'A');
INSERT INTO "personnes" VALUES('2590',3,'HUANG ZHENQUIN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-18',828560,'A');
INSERT INTO "personnes" VALUES('2591',3,'WEIDEN MULLER AMURER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-29',851110,'A');
INSERT INTO "personnes" VALUES('2593',3,'OESTERHAUS CORNELIA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',256231,'2011-03-29',295960,'A');
INSERT INTO "personnes" VALUES('2594',3,'RINTALAHTI JUHA HENRIK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-23',170220,'A');
INSERT INTO "personnes" VALUES('2597',3,'VERWIJNEN JONAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',289697,'2011-02-03',638040,'A');
INSERT INTO "personnes" VALUES('2598',3,'SHAW ROBERT','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',157414,'2011-07-10',273550,'A');
INSERT INTO "personnes" VALUES('2599',3,'MAKINEN TIMO JUHANI','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',196234,'2011-09-13',453600,'A');
INSERT INTO "personnes" VALUES('260',1,'RIVERA CANON JOSE EDWARD','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127538,'2011-09-19',375990,'A');
INSERT INTO "personnes" VALUES('2600',3,'HONKANIEMI ARTO OLAVI','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',301387,'2011-09-06',447380,'A');
INSERT INTO "personnes" VALUES('2601',3,'DAGG JAMIE MICHAEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',216125,'2011-08-09',876080,'A');
INSERT INTO "personnes" VALUES('2602',3,'BOLAND PATRICK CHARLES ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',216125,'2011-09-14',38260,'A');
INSERT INTO "personnes" VALUES('2603',2,'ZULEYKA JERRYS RIVERA MENDOZA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',150347,'2011-03-27',563050,'A');
INSERT INTO "personnes" VALUES('2604',3,'DELGADO SEQUIRA FERRAO JOSE PEDRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',188228,'2011-08-16',700460,'A');
INSERT INTO "personnes" VALUES('2605',3,'YORRO LORA EDGAR MANUEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127689,'2011-06-17',813180,'A');
INSERT INTO "personnes" VALUES('2606',3,'CARRASCO RODRIGUEZQCARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127689,'2011-06-17',964520,'A');
INSERT INTO "personnes" VALUES('2607',30,'ORJUELA VELASQUEZ JULIANA MARIA','191821112','CRA 25 CALLE 100','372@terra.com.co','2011-02-03',132775,'2011-09-01',383070,'A');
INSERT INTO "personnes" VALUES('2608',3,'DUQUE DUTRA LUIS EDUARDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',118942,'2011-07-12',21780,'A');
INSERT INTO "personnes" VALUES('261',1,'MURCIA MARQUEZ NESTOR JAVIER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-19',913480,'A');
INSERT INTO "personnes" VALUES('2610',3,'NGUYEN HUU KHUONG','191821112','CRA 25 CALLE 100','457@facebook.com','2011-02-03',132958,'2011-05-07',733120,'A');
INSERT INTO "personnes" VALUES('2611',3,'NGUYEN VAN LAP','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-05-07',786510,'A');
INSERT INTO "personnes" VALUES('2612',3,'PHAM HUU THU','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132958,'2011-05-07',733200,'A');
INSERT INTO "personnes" VALUES('2613',3,'DANG MING CUONG','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2011-05-07',306460,'A');
INSERT INTO "personnes" VALUES('2614',3,'VU THI HONG HANH','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-05-07',332710,'A');
INSERT INTO "personnes" VALUES('2615',3,'CHAU TANG LANG','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-05-07',744190,'A');
INSERT INTO "personnes" VALUES('2616',3,'CHU BAN THING','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2011-05-07',722800,'A');
INSERT INTO "personnes" VALUES('2617',3,'NGUYEN QUANG THU','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132958,'2011-05-07',381420,'A');
INSERT INTO "personnes" VALUES('2618',3,'TRAN THI KIM OANH','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-05-07',738690,'A');
INSERT INTO "personnes" VALUES('2619',3,'NGUYEN VAN VINH','191821112','CRA 25 CALLE 100','422@yahoo.com.mx','2011-02-03',132958,'2011-05-07',549210,'A');
INSERT INTO "personnes" VALUES('262',1,'ABDULAZIS ELNESER KHALED','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-27',439430,'A');
INSERT INTO "personnes" VALUES('2620',3,'NGUYEN XUAN VY','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132958,'2011-05-07',529950,'A');
INSERT INTO "personnes" VALUES('2621',3,'HA MANH HOA','191821112','CRA 25 CALLE 100','439@gmail.com','2011-02-03',132958,'2011-05-07',2160,'A');
INSERT INTO "personnes" VALUES('2622',3,'ZAFIROPOULO STEVEN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-25',420930,'A');
INSERT INTO "personnes" VALUES('2624',3,'TEMIGTERRA MASSIMILIANO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',210050,'2011-09-26',228070,'A');
INSERT INTO "personnes" VALUES('2625',3,'CASSES TRINDADE HELGIO HENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118402,'2011-09-13',845850,'A');
INSERT INTO "personnes" VALUES('2626',3,'ASCOLI MASTROENI MARCO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',120773,'2011-09-07',545010,'A');
INSERT INTO "personnes" VALUES('2627',3,'MONTEIRO SOARES MARCOS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',120773,'2011-07-18',187530,'A');
INSERT INTO "personnes" VALUES('2629',3,'HALL ALVARO AUGUSTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',120773,'2011-08-02',950450,'A');
INSERT INTO "personnes" VALUES('2631',3,'ANDRADE CATUNDA RAFAEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',120773,'2011-08-23',370860,'A');
INSERT INTO "personnes" VALUES('2632',3,'MAGALHAES MAYRA ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118767,'2011-08-23',320960,'A');
INSERT INTO "personnes" VALUES('2633',3,'SPREAFICO MIRIAM ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118587,'2011-08-23',492220,'A');
INSERT INTO "personnes" VALUES('2634',3,'GOMES FERREIRA HELIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',125812,'2011-08-23',498220,'A');
INSERT INTO "personnes" VALUES('2635',3,'FERNANDES SENNA PIRES SERGIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-10-05',14460,'A');
INSERT INTO "personnes" VALUES('2636',3,'BALESTRO FLORIANO FABIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',120773,'2011-08-24',577630,'A');
INSERT INTO "personnes" VALUES('2637',3,'CABANA DE QUEIROZ ANDRADE ALAXANDRE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-23',844780,'A');
INSERT INTO "personnes" VALUES('2638',3,'DALBOSCO CARLA','191821112','CRA 25 CALLE 100','380@yahoo.com.mx','2011-02-03',127591,'2011-06-30',491010,'A');
INSERT INTO "personnes" VALUES('264',1,'ROMERO MONTOYA NICOLAY ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-13',965220,'A');
INSERT INTO "personnes" VALUES('2640',3,'BILLINI CRUZ RICARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',144215,'2011-03-27',130530,'A');
INSERT INTO "personnes" VALUES('2641',3,'VASQUES ARIAS DAVID','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',144509,'2011-08-19',890500,'A');
INSERT INTO "personnes" VALUES('2642',3,'ROJAS VOLQUEZ GLADYS MICHELLE','191821112','CRA 25 CALLE 100','852@gmail.com','2011-02-03',144215,'2011-07-25',60930,'A');
INSERT INTO "personnes" VALUES('2643',3,'LLANEZA GIL JUAN RAFAELMO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',144215,'2011-07-08',633120,'A');
INSERT INTO "personnes" VALUES('2646',3,'AVILA PEROZO IANKEL JACOB','191821112','CRA 25 CALLE 100','318@hotmail.com','2011-02-03',144215,'2011-09-03',125600,'A');
INSERT INTO "personnes" VALUES('2647',3,'REGULAR EDUARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-19',583540,'A');
INSERT INTO "personnes" VALUES('2648',3,'CORONADO BATISTA JOSE ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-19',540910,'A');
INSERT INTO "personnes" VALUES('2649',3,'OLIVIER JOSE VICTOR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',144509,'2011-08-19',953910,'A');
INSERT INTO "personnes" VALUES('2650',3,'YOO HOE TAEK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-08-25',146820,'A');
INSERT INTO "personnes" VALUES('266',1,'CUECA RODRIGUEZ CARLOS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-22',384280,'A');
INSERT INTO "personnes" VALUES('267',1,'NIETO ALVARADO ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2008-04-28',553450,'A');
INSERT INTO "personnes" VALUES('269',1,'LEAL HOLGUIN FRANCISCO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-25',411700,'A');
INSERT INTO "personnes" VALUES('27',1,'MORENO MORENO CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2009-09-15',995620,'A');
INSERT INTO "personnes" VALUES('270',1,'CANO IBANES JUAN FELIPE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-03',215260,'A');
INSERT INTO "personnes" VALUES('271',1,'RESTREPO HERRAN ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132775,'2011-04-18',841220,'A');
INSERT INTO "personnes" VALUES('272',3,'RIOS FRANCISCO JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',199862,'2011-03-24',560300,'A');
INSERT INTO "personnes" VALUES('273',1,'MADERO LORENZANA NICOLAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-03',277850,'A');
INSERT INTO "personnes" VALUES('274',1,'GOMEZ GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-09-24',708350,'A');
INSERT INTO "personnes" VALUES('275',1,'CONSUEGRA ARENAS ANDRES MAURICIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-09-09',708210,'A');
INSERT INTO "personnes" VALUES('276',1,'HURTADO ROJAS NICOLAS','191821112','CRA 25 CALLE 100','463@yahoo.com.mx','2011-02-03',127591,'2011-09-07',416000,'A');
INSERT INTO "personnes" VALUES('277',1,'MURCIA BAQUERO MARCO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-02',955370,'A');
INSERT INTO "personnes" VALUES('2773',3,'TAKUBO KAORI','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',165753,'2011-05-12',872390,'A');
INSERT INTO "personnes" VALUES('2774',3,'OKADA MAKOTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',165753,'2011-06-19',921480,'A');
INSERT INTO "personnes" VALUES('2775',3,'TAKEDA AKIO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',21062,'2011-06-19',990250,'A');
INSERT INTO "personnes" VALUES('2776',3,'KOIKE WATARU ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',165753,'2011-06-19',186800,'A');
INSERT INTO "personnes" VALUES('2777',3,'KUBO SHINEI','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',165753,'2011-02-13',963230,'A');
INSERT INTO "personnes" VALUES('2778',3,'KANNO YONEZO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',165600,'2011-07-26',255770,'A');
INSERT INTO "personnes" VALUES('278',3,'PARENT ELOIDE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',267980,'2011-05-01',528840,'A');
INSERT INTO "personnes" VALUES('2781',3,'SUNADA MINORU ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',165753,'2011-06-19',724450,'A');
INSERT INTO "personnes" VALUES('2782',3,'INOUE KASUYA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-22',87150,'A');
INSERT INTO "personnes" VALUES('2783',3,'OTAKE NOBUTOSHI','191821112','CRA 25 CALLE 100','208@facebook.com','2011-02-03',127591,'2011-06-11',262380,'A');
INSERT INTO "personnes" VALUES('2784',3,'MOTOI KEN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',165753,'2011-06-19',50470,'A');
INSERT INTO "personnes" VALUES('2785',3,'TANAKA KIYOTAKA ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',165753,'2011-06-19',465210,'A');
INSERT INTO "personnes" VALUES('2787',3,'YUMIKOPERDOMO','191821112','CRA 25 CALLE 100','600@yahoo.es','2011-02-03',165600,'2011-07-26',477550,'A');
INSERT INTO "personnes" VALUES('2788',3,'FUKUSHIMA KENZO','191821112','CRA 25 CALLE 100','599@gmail.com','2011-02-03',156960,'2011-05-30',863860,'A');
INSERT INTO "personnes" VALUES('2789',3,'GELGIN LEVENT NURI','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-26',886630,'A');
INSERT INTO "personnes" VALUES('279',1,'AVIATUR S. A.','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-02',778110,'A');
INSERT INTO "personnes" VALUES('2791',3,'GELGIN ENIS ENRE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-26',547940,'A');
INSERT INTO "personnes" VALUES('2792',3,'PAZ SOTO LUBRASCA MARIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',143954,'2011-06-27',215000,'A');
INSERT INTO "personnes" VALUES('2794',3,'MOURAD TAOUFIKI','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-13',511000,'A');
INSERT INTO "personnes" VALUES('2796',3,'DASTUS ALAIN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',218656,'2011-05-29',774010,'A');
INSERT INTO "personnes" VALUES('2797',3,'MCDONALD MICHAEL LORNE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',269033,'2011-07-19',85820,'A');
INSERT INTO "personnes" VALUES('2799',3,'KLESO MICHAEL QUENTIN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2011-07-26',277950,'A');
INSERT INTO "personnes" VALUES('28',1,'GONZALEZ ACUNA EDGAR MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-19',531710,'A');
INSERT INTO "personnes" VALUES('280',3,'NEME KARIM CHAIBAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',135967,'2010-05-02',304040,'A');
INSERT INTO "personnes" VALUES('2800',3,'CLERK CHARLES ALEXANDER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',244158,'2011-07-26',68490,'A');
INSERT INTO "personnes" VALUES('CELL3673',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('2801',3,'BURRIS MAURICE STEWARD','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-27',508600,'A');
INSERT INTO "personnes" VALUES('2802',1,'PINCHEN CLAIRE ELAINE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',216125,'2011-04-13',337530,'A');
INSERT INTO "personnes" VALUES('2803',3,'LETTNER EVA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',231224,'2011-09-20',161860,'A');
INSERT INTO "personnes" VALUES('2804',3,'CANUEL LUCIE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',146258,'2011-09-20',796710,'A');
INSERT INTO "personnes" VALUES('2805',3,'IGLESIAS CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',216125,'2011-08-02',497980,'A');
INSERT INTO "personnes" VALUES('2806',3,'PAQUIN JEAN FRANCOIS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',269033,'2011-03-27',99760,'A');
INSERT INTO "personnes" VALUES('2807',3,'FOURNIER DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',228688,'2011-05-19',4860,'A');
INSERT INTO "personnes" VALUES('2808',3,'BILODEAU MARTIN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-13',725030,'A');
INSERT INTO "personnes" VALUES('2809',3,'KELLNER PETER WILLIAM','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',130757,'2011-07-24',610570,'A');
INSERT INTO "personnes" VALUES('2810',3,'ZAZULAK INGRID ROSEMARIE','191821112','CRA 25 CALLE 100','683@facebook.com','2011-02-03',240550,'2011-09-11',877770,'A');
INSERT INTO "personnes" VALUES('2811',3,'RUCCI JHON MARIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',285188,'2011-05-10',557130,'A');
INSERT INTO "personnes" VALUES('2813',3,'JONCAS MARC','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',33265,'2011-03-21',90360,'A');
INSERT INTO "personnes" VALUES('2814',3,'DUCHARME ERICK','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-03-29',994750,'A');
INSERT INTO "personnes" VALUES('2816',3,'BAILLOD THOMAS DAVID ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',239124,'2010-10-20',529130,'A');
INSERT INTO "personnes" VALUES('2817',3,'MARTINEZ SORIA JOSE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',289697,'2011-09-06',537630,'A');
INSERT INTO "personnes" VALUES('2818',3,'TAMARA RABER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-04-30',100750,'A');
INSERT INTO "personnes" VALUES('2819',3,'BURGI VINCENT EMANUEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',245206,'2011-04-20',890860,'A');
INSERT INTO "personnes" VALUES('282',1,'HUESPED ASISTENTE A LA CONVENCION DE LA DIAN','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2009-06-24',17160,'A');
INSERT INTO "personnes" VALUES('2820',3,'ROBLES TORRALBA IVAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',238949,'2011-05-16',152030,'A');
INSERT INTO "personnes" VALUES('2821',3,'CONSUEGRA MARIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-06',87600,'A');
INSERT INTO "personnes" VALUES('2822',3,'CELMA ADROVER LAIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',190393,'2011-03-23',981880,'A');
INSERT INTO "personnes" VALUES('2823',3,'ALVAREZ JUAN PABLO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-06-20',646610,'A');
INSERT INTO "personnes" VALUES('2824',3,'VARGAS WOODROFFE FRANCISCO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',157414,'2011-06-22',287410,'A');
INSERT INTO "personnes" VALUES('2825',3,'GARCIA GUILLEN VICENTE LUIS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',144215,'2011-08-19',497230,'A');
INSERT INTO "personnes" VALUES('2826',3,'GOMEZ GARCIA DIAMANTES PATRICIA MARIA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',286785,'2011-09-22',623930,'A');
INSERT INTO "personnes" VALUES('2827',3,'PEREZ IGLESIAS BIBIANA','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',132958,'2011-09-30',627940,'A');
INSERT INTO "personnes" VALUES('2830',3,'VILLALONGA MORENES MARIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',169679,'2011-05-29',474910,'A');
INSERT INTO "personnes" VALUES('2831',3,'REY LOPEZ DAVID','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',150699,'2011-08-03',7380,'A');
INSERT INTO "personnes" VALUES('2832',3,'HOYO APARICIO JESUS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',116511,'2011-09-19',612180,'A');
INSERT INTO "personnes" VALUES('2836',3,'GOMEZ GARCIA LOPEZ CARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',150699,'2011-09-21',277540,'A');
INSERT INTO "personnes" VALUES('2839',3,'GALIMERTI MARCO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',235197,'2011-08-28',156870,'A');
INSERT INTO "personnes" VALUES('2840',3,'BAROZZI GIUSEPE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',231989,'2011-05-25',609500,'A');
INSERT INTO "personnes" VALUES('2841',3,'MARIAN RENATO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-12',576900,'A');
INSERT INTO "personnes" VALUES('2842',3,'FAENZA CARLO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',126180,'2011-05-19',55990,'A');
INSERT INTO "personnes" VALUES('2843',3,'PESOLILLO CARMINE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',203162,'2011-06-26',549230,'A');
INSERT INTO "personnes" VALUES('2844',3,'CHIODI FRANCESCO MARIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',199862,'2011-09-10',578210,'A');
INSERT INTO "personnes" VALUES('2845',3,'RUTA MARIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-06-19',243350,'A');
INSERT INTO "personnes" VALUES('2846',3,'BAZZONI MARINO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',101518,'2011-05-03',482140,'A');
INSERT INTO "personnes" VALUES('2848',3,'LAGASIO LEONARDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',231989,'2011-05-04',956670,'A');
INSERT INTO "personnes" VALUES('2849',3,'VIERA DA CUNHA PAULO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',190393,'2011-04-05',741520,'A');
INSERT INTO "personnes" VALUES('2850',3,'DAL BEN DENIS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',116511,'2011-05-26',837590,'A');
INSERT INTO "personnes" VALUES('2851',3,'GIANELLI HERIBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',233927,'2011-05-01',963400,'A');
INSERT INTO "personnes" VALUES('2852',3,'JUSTINO DA SILVA DJAMIR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-08',304200,'A');
INSERT INTO "personnes" VALUES('2853',3,'DIPASQUUALE GAETANO','191821112','CRA 25 CALLE 100','574@terra.com.co','2011-02-03',172888,'2011-07-11',630830,'A');
INSERT INTO "personnes" VALUES('2855',3,'CURI MAURO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',199862,'2011-06-19',315160,'A');
INSERT INTO "personnes" VALUES('2856',3,'DI DIO MARCO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-20',851210,'A');
INSERT INTO "personnes" VALUES('2857',3,'ROBERTI MENDONCA CAIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-11',310580,'A');
INSERT INTO "personnes" VALUES('2859',3,'RAMOS MORENO DE SOUZA ANDRE ','191821112','CRA 25 CALLE 100','133@facebook.com','2011-02-03',118777,'2011-09-24',64540,'A');
INSERT INTO "personnes" VALUES('286',8,'INEXMODA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-06-21',50150,'A');
INSERT INTO "personnes" VALUES('2860',3,'JODJAHN DE CARVALHO FLAVIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2011-06-27',324950,'A');
INSERT INTO "personnes" VALUES('2862',3,'LAGASIO LEONARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',231989,'2011-07-04',180760,'A');
INSERT INTO "personnes" VALUES('2863',3,'MOON SUNG RIUL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-08',610440,'A');
INSERT INTO "personnes" VALUES('2865',3,'VAIDYANATHAN VIKRAM','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-11',718220,'A');
INSERT INTO "personnes" VALUES('2866',3,'NARAYANASWAMY RAMSUNDAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',73079,'2011-10-02',61390,'A');
INSERT INTO "personnes" VALUES('2867',3,'VADADA VENKATA RAMESH KUMAR','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-10',152300,'A');
INSERT INTO "personnes" VALUES('2868',3,'RAMA KRISHNAN ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-10',577300,'A');
INSERT INTO "personnes" VALUES('2869',3,'JALAN PRASHANT','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',122035,'2011-05-02',429600,'A');
INSERT INTO "personnes" VALUES('2871',3,'CHANDRASEKAR VENKAT','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',112862,'2011-06-27',791800,'A');
INSERT INTO "personnes" VALUES('2872',3,'CUMBAKONAM SWAMINATHAN SUBRAMANIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-11',710650,'A');
INSERT INTO "personnes" VALUES('288',8,'BCD TRAVEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-23',645390,'A');
INSERT INTO "personnes" VALUES('289',3,'EMBAJADA ARGENTINA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'1970-02-02',749440,'A');
INSERT INTO "personnes" VALUES('CELL3789',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('290',3,'EMBAJADA DE BRASIL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-11-16',811030,'A');
INSERT INTO "personnes" VALUES('293',8,'ONU','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-09-19',584810,'A');
INSERT INTO "personnes" VALUES('299',1,'BLANDON GUZMAN JHON JAIRO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-01-13',201740,'A');
INSERT INTO "personnes" VALUES('304',3,'COHEN DANIEL DYLAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',286785,'2010-11-17',184850,'A');
INSERT INTO "personnes" VALUES('306',1,'CINDU ANDINA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2009-06-11',899230,'A');
INSERT INTO "personnes" VALUES('31',1,'GARRIDO LEONARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127662,'2010-09-12',801450,'A');
INSERT INTO "personnes" VALUES('310',3,'CORPORACION CLUB EL NOGAL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2010-08-27',918760,'A');
INSERT INTO "personnes" VALUES('314',3,'CHAWLA AARON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-08',295840,'A');
INSERT INTO "personnes" VALUES('317',3,'BAKER HUGHES','191821112','CRA 25 CALLE 100','694@hotmail.com','2011-02-03',127591,'2011-04-03',211990,'A');
INSERT INTO "personnes" VALUES('32',1,'PAEZ SEGURA JOSE ANTONIO','191821112','CRA 25 CALLE 100','675@gmail.com','2011-02-03',129447,'2011-08-22',717340,'A');
INSERT INTO "personnes" VALUES('320',1,'MORENO PAEZ FREDDY ALEXANDER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-31',971670,'A');
INSERT INTO "personnes" VALUES('322',1,'CALDERON CARDOZO GASTON EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-10-05',990640,'A');
INSERT INTO "personnes" VALUES('324',1,'ARCHILA MERA ALFREDOMANUEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-06-22',77200,'A');
INSERT INTO "personnes" VALUES('326',1,'MUNOZ AVILA HERNEY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-11-10',550920,'A');
INSERT INTO "personnes" VALUES('327',1,'CHAPARRO CUBILLOS FABIAN ANDRES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-15',685080,'A');
INSERT INTO "personnes" VALUES('329',1,'GOMEZ LOPEZ JUAN SEBASTIAN','191821112','CRA 25 CALLE 100','970@yahoo.com','2011-02-03',127591,'2011-03-20',808070,'A');
INSERT INTO "personnes" VALUES('33',1,'MARTINEZ MARINO HENRY HERNAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-04-20',182370,'A');
INSERT INTO "personnes" VALUES('330',3,'MAPSTONE NAOMI LEA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',122035,'2010-02-21',722380,'A');
INSERT INTO "personnes" VALUES('332',3,'ROSSI BURRI NELLY','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132165,'2010-05-10',771210,'A');
INSERT INTO "personnes" VALUES('333',1,'AVELLANEDA OVIEDO JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-25',293060,'A');
INSERT INTO "personnes" VALUES('334',1,'SUZA FLOREZ JUAN PABLO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-13',151650,'A');
INSERT INTO "personnes" VALUES('335',1,'ESGUERRA ALVARO ANDRES','191821112','CRA 25 CALLE 100','11@facebook.com','2011-02-03',127591,'2011-09-10',879080,'A');
INSERT INTO "personnes" VALUES('337',3,'DE LA HARPE MARTIN CARAPET WALTER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-27',64960,'A');
INSERT INTO "personnes" VALUES('339',1,'HERNANDEZ ACOSTA SERGIO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',129499,'2011-06-22',322570,'A');
INSERT INTO "personnes" VALUES('340',3,'ZARAMA DE LA ESPRIELLA MIGUEL PATRICIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-27',102360,'A');
INSERT INTO "personnes" VALUES('342',1,'CABRERA VASQUEZ JUAN PABLO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-01',413440,'A');
INSERT INTO "personnes" VALUES('343',3,'RICHARDSON BEN MARRIS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',286785,'2010-05-18',434890,'A');
INSERT INTO "personnes" VALUES('344',1,'OLARTE PINZON MIGUEL FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-30',934140,'A');
INSERT INTO "personnes" VALUES('345',1,'SOLER SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2011-04-20',366020,'A');
INSERT INTO "personnes" VALUES('346',1,'PRIETO JUAN ESTEBAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-07-12',27690,'A');
INSERT INTO "personnes" VALUES('349',1,'BARRERO VELASCO DAVID','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-01',472850,'A');
INSERT INTO "personnes" VALUES('35',1,'VELASQUEZ RAMOS JUAN MANUEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-13',251940,'A');
INSERT INTO "personnes" VALUES('350',1,'RANGEL GARCIA SERGIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-03-20',7880,'A');
INSERT INTO "personnes" VALUES('353',1,'ALVAREZ ACEVEDO JOHN FREDDY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-16',540070,'A');
INSERT INTO "personnes" VALUES('354',1,'VILLAMARIN HOME WILMAR ALFREDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-19',458810,'A');
INSERT INTO "personnes" VALUES('355',3,'SLUCHIN NAAMAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',263813,'2010-12-01',673830,'A');
INSERT INTO "personnes" VALUES('357',1,'BULLA BERNAL LUIS ERNESTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-14',942160,'A');
INSERT INTO "personnes" VALUES('358',1,'BRACCIA AVILA GIANCARLO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-01',732620,'A');
INSERT INTO "personnes" VALUES('359',1,'RODRIGUEZ PINTO RAUL DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-08-24',836600,'A');
INSERT INTO "personnes" VALUES('36',1,'MALDONADO ALVAREZ JAIRO ASDRUBAL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127300,'2011-06-19',980270,'A');
INSERT INTO "personnes" VALUES('362',1,'POMBO POLANCO JUAN BERNARDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-18',124130,'A');
INSERT INTO "personnes" VALUES('363',1,'CARDENAS SUAREZ CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127662,'2011-09-01',372920,'A');
INSERT INTO "personnes" VALUES('364',1,'RIVERA MAZO JOSE DAVID','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-06-10',492220,'A');
INSERT INTO "personnes" VALUES('365',1,'LEDERMAN CORDIKI JONATHAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-12-03',342340,'A');
INSERT INTO "personnes" VALUES('367',1,'BARRERA MARTINEZ LUIS CARLOS','191821112','CRA 25 CALLE 100','35@yahoo.com.mx','2011-02-03',127591,'2011-05-24',148130,'A');
INSERT INTO "personnes" VALUES('368',1,'SEPULVEDA RAMIREZ DANIEL MARCELO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-31',35560,'A');
INSERT INTO "personnes" VALUES('369',1,'QUINTERO DIAZ WILSON ASDRUBAL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-07-24',733430,'A');
INSERT INTO "personnes" VALUES('37',1,'RESTREPO SUAREZ HENRY BERNARDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2011-07-25',145540,'A');
INSERT INTO "personnes" VALUES('370',1,'ROJAS YARA WILLMAR ARLEY','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-12-03',560450,'A');
INSERT INTO "personnes" VALUES('371',3,'CARVER LOUISE EMILY','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',286785,'2010-10-07',601980,'A');
INSERT INTO "personnes" VALUES('372',3,'VINCENT DAVID','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',286785,'2011-03-06',328540,'A');
INSERT INTO "personnes" VALUES('374',1,'GONZALEZ DELGADO MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-08-18',198260,'A');
INSERT INTO "personnes" VALUES('375',1,'PAEZ SIMON','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-06-25',480970,'A');
INSERT INTO "personnes" VALUES('376',1,'CADOSCH DELMAR ELIE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-10-07',810080,'A');
INSERT INTO "personnes" VALUES('377',1,'HERRERA VASQUEZ DANIEL EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-06-30',607460,'A');
INSERT INTO "personnes" VALUES('378',1,'CORREAL ROJAS RONALD','191821112','CRA 25 CALLE 100','269@facebook.com','2011-02-03',127591,'2011-07-16',607080,'A');
INSERT INTO "personnes" VALUES('379',1,'VOIDONNIKOLAS MUNOS PANAGIOTIS','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-27',213010,'A');
INSERT INTO "personnes" VALUES('38',1,'CANAL ROJAS MAURICIO HERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-05-29',786900,'A');
INSERT INTO "personnes" VALUES('CELL3514',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('380',1,'DIAZ ECHEVERRI JUAN DAVID ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-20',243800,'A');
INSERT INTO "personnes" VALUES('381',1,'CIFUENTES MARIN HERNANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-26',579960,'A');
INSERT INTO "personnes" VALUES('382',3,'PAXTON LUCINDA HARRIET','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',107159,'2011-05-23',168420,'A');
INSERT INTO "personnes" VALUES('384',3,'POYNTON BRIAN GEORGE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',286785,'2011-03-20',5790,'A');
INSERT INTO "personnes" VALUES('385',3,'TERMIGNONI ADRIANO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-01-14',722320,'A');
INSERT INTO "personnes" VALUES('386',3,'CARDWELL PAULA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-02-17',594230,'A');
INSERT INTO "personnes" VALUES('389',1,'FONCECA MARTINEZ MIGUEL ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-25',778680,'A');
INSERT INTO "personnes" VALUES('39',1,'GARCIA SUAREZ WILLIAM ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-25',497880,'A');
INSERT INTO "personnes" VALUES('390',1,'GUERRERO NELSON','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-12-03',178650,'A');
INSERT INTO "personnes" VALUES('391',1,'VICTORIA PENA FERNANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-22',557200,'A');
INSERT INTO "personnes" VALUES('392',1,'VAN HISSENHOVEN FERRERO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-13',250060,'A');
INSERT INTO "personnes" VALUES('393',1,'CACERES ORDUZ JUAN GUILLERMO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-28',578690,'A');
INSERT INTO "personnes" VALUES('394',1,'QUINTERO ALVARO FELIPE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-17',143270,'A');
INSERT INTO "personnes" VALUES('395',1,'ANZOLA PEREZ CARLOSDAVID','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-04',980300,'A');
INSERT INTO "personnes" VALUES('397',1,'LLOREDA ORTIZ CARLOS JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-27',417470,'A');
INSERT INTO "personnes" VALUES('398',1,'GONZALES LONDONO SEBASTIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-06-19',672310,'A');
INSERT INTO "personnes" VALUES('4',1,'LONDONO DOMINGUEZ ERNESTO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-05',324610,'A');
INSERT INTO "personnes" VALUES('40',1,'MORENO ANGULO ORLANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-01',128690,'A');
INSERT INTO "personnes" VALUES('400',8,'TRANSELCA .A','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-04-14',528930,'A');
INSERT INTO "personnes" VALUES('403',1,'VERGARA MURILLO JUAN FERNANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-03-04',42900,'A');
INSERT INTO "personnes" VALUES('405',1,'CAPERA CAPERA HARRINSON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127799,'2011-06-12',961000,'A');
INSERT INTO "personnes" VALUES('407',1,'MORENO MORA WILLIAM EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-22',872780,'A');
INSERT INTO "personnes" VALUES('408',1,'HIGUERA ROA NICOLAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-03-28',910430,'A');
INSERT INTO "personnes" VALUES('409',1,'FORERO CASTILLO OSCAR ALEJANDRO','191821112','CRA 25 CALLE 100','988@terra.com.co','2011-02-03',127591,'2011-07-23',933810,'A');
INSERT INTO "personnes" VALUES('410',1,'LOPEZ MURCIA JULIAN DANIEL','191821112','CRA 25 CALLE 100','399@facebook.com','2011-02-03',127591,'2011-08-08',937790,'A');
INSERT INTO "personnes" VALUES('411',1,'ALZATE JOHN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-09-09',887490,'A');
INSERT INTO "personnes" VALUES('412',1,'GONZALES GONZALES ORLANDO ANDREY','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-30',624080,'A');
INSERT INTO "personnes" VALUES('413',1,'ESCOLANO VALENTIN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-08-05',457930,'A');
INSERT INTO "personnes" VALUES('414',1,'JARAMILLO RODRIGUEZ JUAN CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-12',417420,'A');
INSERT INTO "personnes" VALUES('415',1,'GARCIA MUNOZ DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-10-02',713300,'A');
INSERT INTO "personnes" VALUES('416',1,'PINEROS ARENAS JUAN DAVID','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-10-17',314260,'A');
INSERT INTO "personnes" VALUES('417',1,'ORTIZ ARROYAVE ANDRES','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-05-21',431370,'A');
INSERT INTO "personnes" VALUES('418',1,'BAYONA BARRIENTOS JEAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-12',214090,'A');
INSERT INTO "personnes" VALUES('419',1,'AGUDELO VASQUEZ JUAN FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-08-30',776360,'A');
INSERT INTO "personnes" VALUES('420',1,'CALLE DANIEL CJ PRODUCCIONES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-11-04',239500,'A');
INSERT INTO "personnes" VALUES('422',1,'CANO BETANCUR ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-08-20',623620,'A');
INSERT INTO "personnes" VALUES('423',1,'CALDAS BARRETO LUZ MIREYA','191821112','CRA 25 CALLE 100','991@facebook.com','2011-02-03',127591,'2011-05-22',512840,'A');
INSERT INTO "personnes" VALUES('424',1,'SIMBAQUEBA JOSE ERNESTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-25',693320,'A');
INSERT INTO "personnes" VALUES('425',1,'DE SILVESTRE CALERO LUIS GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-18',928110,'A');
INSERT INTO "personnes" VALUES('426',1,'ZORRO PERALTA YEZID','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-25',560560,'A');
INSERT INTO "personnes" VALUES('428',1,'SUAREZ OIDOR DARWIN LEONARDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',131272,'2011-09-05',410650,'A');
INSERT INTO "personnes" VALUES('429',1,'GIRAL CARRILLO LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-04-13',997850,'A');
INSERT INTO "personnes" VALUES('43',1,'MARULANDA VALENCIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-17',365550,'A');
INSERT INTO "personnes" VALUES('430',1,'CORDOBA GARCES JUAN PABLO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-18',757320,'A');
INSERT INTO "personnes" VALUES('431',1,'ARIAS TAMAYO DIEGO MAURICIO','191821112','CRA 25 CALLE 100','36@yahoo.com','2011-02-03',127591,'2011-09-05',793050,'A');
INSERT INTO "personnes" VALUES('432',1,'EICHMANN PERRET MARC WILLY','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-22',693270,'A');
INSERT INTO "personnes" VALUES('433',1,'DIAZ DANIEL ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2008-09-18',87200,'A');
INSERT INTO "personnes" VALUES('435',1,'FACCINI GONZALEZ HERMANN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2009-01-08',519420,'A');
INSERT INTO "personnes" VALUES('436',1,'URIBE DUQUE FELIPE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-28',528470,'A');
INSERT INTO "personnes" VALUES('437',1,'TAVERA GAONA GABREL LEAL','191821112','CRA 25 CALLE 100','280@terra.com.co','2011-02-03',127591,'2011-04-28',84120,'A');
INSERT INTO "personnes" VALUES('438',1,'ORDONEZ PARIS FERNANDO MAURICIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-09-26',835170,'A');
INSERT INTO "personnes" VALUES('439',1,'VILLEGAS ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-19',923520,'A');
INSERT INTO "personnes" VALUES('44',1,'MARTINEZ PEDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-08-13',738750,'A');
INSERT INTO "personnes" VALUES('440',1,'MARTINEZ RUEDA JUAN CARLOS','191821112','CRA 25 CALLE 100','805@hotmail.es','2011-02-03',127591,'2011-04-07',112050,'A');
INSERT INTO "personnes" VALUES('441',1,'ROLDAN JUAN CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-05-25',789720,'A');
INSERT INTO "personnes" VALUES('442',1,'PEREZ BRANDWAYN ELIYAU MOISES','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-10-20',612450,'A');
INSERT INTO "personnes" VALUES('443',1,'VALLEJO TORO JUAN DIEGO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128579,'2011-08-16',693080,'A');
INSERT INTO "personnes" VALUES('444',1,'TORRES CABRERA EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-03-19',628070,'A');
INSERT INTO "personnes" VALUES('445',1,'MERINO MEJIA GERMAN ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-28',61100,'A');
INSERT INTO "personnes" VALUES('447',1,'GOMEZ GOMEZ JUAN CARLOS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-08',923070,'A');
INSERT INTO "personnes" VALUES('448',1,'RAUSCH CHEHEBAR STEVEN JOSEPH','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-09-27',351540,'A');
INSERT INTO "personnes" VALUES('449',1,'RESTREPO TRUCCO ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-28',988500,'A');
INSERT INTO "personnes" VALUES('45',1,'GUTIERREZ JARAMILLO CARLOS MARIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',150699,'2011-08-22',597090,'A');
INSERT INTO "personnes" VALUES('450',1,'GOLDSTEIN VAIDA ELI JACK','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-11',887860,'A');
INSERT INTO "personnes" VALUES('451',1,'OLEA PINEDA EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-08-10',473800,'A');
INSERT INTO "personnes" VALUES('452',1,'JORGE OROZCO','191821112','CRA 25 CALLE 100','503@hotmail.es','2011-02-03',127591,'2011-06-02',705410,'A');
INSERT INTO "personnes" VALUES('454',1,'DE LA TORRE GOMEZ GERMAN ERNESTO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-03-03',411990,'A');
INSERT INTO "personnes" VALUES('456',1,'MADERO ARIAS JUAN PABLO','191821112','CRA 25 CALLE 100','452@hotmail.es','2011-02-03',127591,'2011-08-22',479090,'A');
INSERT INTO "personnes" VALUES('457',1,'GOMEZ MACHUCA ALVARO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-08-12',166430,'A');
INSERT INTO "personnes" VALUES('458',1,'MENDIETA TOBON DANIEL RICARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-08',394880,'A');
INSERT INTO "personnes" VALUES('459',1,'VILLADIEGO CORTINA JAVIER TOMAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-26',475110,'A');
INSERT INTO "personnes" VALUES('46',1,'FERRUCHO ARCINIEGAS JUAN CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-06',769220,'A');
INSERT INTO "personnes" VALUES('460',1,'DERESER HARTUNG ERNESTO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-12-25',190900,'A');
INSERT INTO "personnes" VALUES('461',1,'RAMIREZ PENA ALEJANDRO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-06-25',529190,'A');
INSERT INTO "personnes" VALUES('463',1,'IREGUI REYES LUIS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-07',778590,'A');
INSERT INTO "personnes" VALUES('464',1,'PINTO GOMEZ MAURICIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132775,'2010-06-24',673270,'A');
INSERT INTO "personnes" VALUES('465',1,'RAMIREZ RAMIREZ FERNANDO ALONSO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127799,'2011-10-01',30570,'A');
INSERT INTO "personnes" VALUES('466',1,'BERRIDO TRUJILLO JORGE HENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',132775,'2011-10-06',133040,'A');
INSERT INTO "personnes" VALUES('467',1,'RIVERA CARVAJAL RAFAEL HUMBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-07-20',573500,'A');
INSERT INTO "personnes" VALUES('468',3,'FLOREZ PUENTES IVAN ALFONSO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',145135,'2011-05-08',468380,'A');
INSERT INTO "personnes" VALUES('469',1,'BALLESTEROS FLOREZ IVAN DARIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-06-02',621410,'A');
INSERT INTO "personnes" VALUES('47',1,'MARIN FLOREZ OMAR EDUARDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-30',54840,'A');
INSERT INTO "personnes" VALUES('470',1,'RODRIGO PENA HERRERA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',237734,'2011-10-04',701890,'A');
INSERT INTO "personnes" VALUES('471',1,'RODRIGUEZ SILVA ROGELIO','191821112','CRA 25 CALLE 100','163@gmail.com','2011-02-03',127591,'2011-05-26',645210,'A');
INSERT INTO "personnes" VALUES('473',1,'VASQUEZ VELANDIA JUAN GABRIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',196234,'2011-05-04',666330,'A');
INSERT INTO "personnes" VALUES('474',1,'ROBLEDO JAIME','191821112','CRA 25 CALLE 100','409@yahoo.com','2011-02-03',127591,'2011-05-31',970480,'A');
INSERT INTO "personnes" VALUES('475',1,'GRIMBERG DIAZ PHILIP','191821112','CRA 25 CALLE 100','723@yahoo.com','2011-02-03',127591,'2011-03-30',853430,'A');
INSERT INTO "personnes" VALUES('476',1,'CHAUSTRE GARCIA JUAN PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-26',355670,'A');
INSERT INTO "personnes" VALUES('477',1,'GOMEZ FLOREZ IGNASIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-09-14',218090,'A');
INSERT INTO "personnes" VALUES('478',1,'LUIS ALBERTO CABRERA PUENTES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2011-05-26',23420,'A');
INSERT INTO "personnes" VALUES('479',1,'MARTINEZ ZAPATA JUAN CARLOS','191821112','CRA 25 CALLE 100','234@gmail.com','2011-02-03',127122,'2011-07-01',462840,'A');
INSERT INTO "personnes" VALUES('48',1,'PARRA IBANEZ FABIAN ERNESTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-02-01',966520,'A');
INSERT INTO "personnes" VALUES('480',3,'WESTERBERG JAN RICKARD','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',300701,'2011-02-01',243940,'A');
INSERT INTO "personnes" VALUES('484',1,'RODRIGUEZ VILLALOBOS EDGAR FERNANDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-19',860320,'A');
INSERT INTO "personnes" VALUES('486',1,'NAVARRO REYES DIEGO FELIPE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-01',530150,'A');
INSERT INTO "personnes" VALUES('487',1,'NOGUERA RICAURTE ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-01-21',384100,'A');
INSERT INTO "personnes" VALUES('488',1,'RUIZ VEJARANO CARLOS DANIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-09-27',330030,'A');
INSERT INTO "personnes" VALUES('489',1,'CORREA PEREZ ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-12-14',497860,'A');
INSERT INTO "personnes" VALUES('49',1,'FLOREZ PEREZ RUBIEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-23',668090,'A');
INSERT INTO "personnes" VALUES('490',1,'REYES GOMEZ LUIS ALEJANDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-26',499210,'A');
INSERT INTO "personnes" VALUES('491',3,'BERNAL LEON ALBERTO JOSE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',150699,'2011-03-29',2470,'A');
INSERT INTO "personnes" VALUES('492',1,'FELIPE JARAMILLO CARO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2009-10-31',514700,'A');
INSERT INTO "personnes" VALUES('493',1,'GOMEZ PARRA GERMAN DARIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-01-29',566100,'A');
INSERT INTO "personnes" VALUES('494',1,'VALLEJO RAMIREZ CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-13',286390,'A');
INSERT INTO "personnes" VALUES('495',1,'DIAZ LONDONO HUGO MARIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-06',733670,'A');
INSERT INTO "personnes" VALUES('496',3,'VAN BAKERGEM RONALD JAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2008-11-05',809190,'A');
INSERT INTO "personnes" VALUES('497',1,'MENDEZ RAMIREZ JOSE LEONARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-10',844920,'A');
INSERT INTO "personnes" VALUES('498',3,'QUI TANILLA HENRIQUEZ PAUL ANTONIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-10',797030,'A');
INSERT INTO "personnes" VALUES('499',3,'PELEATO FLOREAL','191821112','CRA 25 CALLE 100','531@hotmail.com','2011-02-03',188640,'2011-04-23',450370,'A');
INSERT INTO "personnes" VALUES('50',1,'SILVA GUZMAN MAURICIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-03-24',440890,'A');
INSERT INTO "personnes" VALUES('502',3,'LEO ULF GORAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',300701,'2010-07-26',181840,'A');
INSERT INTO "personnes" VALUES('503',3,'KARLSSON DANIEL','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',300701,'2011-07-22',50680,'A');
INSERT INTO "personnes" VALUES('504',1,'JIMENEZ JANER ALEJANDRO','191821112','CRA 25 CALLE 100','889@hotmail.es','2011-02-03',203272,'2011-08-29',707880,'A');
INSERT INTO "personnes" VALUES('506',1,'PABON OCHOA ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-14',813050,'A');
INSERT INTO "personnes" VALUES('507',1,'ACHURY CADENA CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-26',903240,'A');
INSERT INTO "personnes" VALUES('508',1,'ECHEVERRY GARZON SEBASTIN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-23',77050,'A');
INSERT INTO "personnes" VALUES('509',1,'PINEROS PENA LUIS CARLOS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-07-29',675550,'A');
INSERT INTO "personnes" VALUES('CELL3562',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('51',1,'CAICEDO URREA JAIME ORLANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127300,'2011-08-17',200160,'A');
INSERT INTO "personnes" VALUES('CELL3795',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('510',1,'MARTINEZ MARTINEZ LUIS EDUARDO','191821112','CRA 25 CALLE 100','586@facebook.com','2011-02-03',127591,'2010-08-28',146600,'A');
INSERT INTO "personnes" VALUES('511',1,'MOLANO PENA JESUS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-02-05',706320,'A');
INSERT INTO "personnes" VALUES('512',3,'RUDOLPHY FONTAINE ANDRES','191821112','CRA 25 CALLE 100','492@yahoo.com','2011-02-03',117002,'2011-04-12',91820,'A');
INSERT INTO "personnes" VALUES('513',1,'NEIRA CHAVARRO JOHN JAIRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-05-12',340120,'A');
INSERT INTO "personnes" VALUES('514',3,'MENDEZ VILLALOBOS ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',145135,'2011-03-25',425160,'A');
INSERT INTO "personnes" VALUES('515',3,'HERNANDEZ OLIVA JOSE DE LA CRUZ','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',145135,'2011-03-25',105440,'A');
INSERT INTO "personnes" VALUES('518',3,'JANCO NICOLAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-15',955830,'A');
INSERT INTO "personnes" VALUES('52',1,'TAPIA MUNOZ JAIRO RICARDO','191821112','CRA 25 CALLE 100','920@hotmail.es','2011-02-03',127591,'2011-10-05',678130,'A');
INSERT INTO "personnes" VALUES('520',1,'ALVARADO JAVIER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-26',895550,'A');
INSERT INTO "personnes" VALUES('521',1,'HUERFANO SOTO JONATHAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-30',619910,'A');
INSERT INTO "personnes" VALUES('522',1,'HUERFANO SOTO JONATHAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-04',412900,'A');
INSERT INTO "personnes" VALUES('523',1,'RODRIGEZ GOMEZ WILMAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-05-14',204790,'A');
INSERT INTO "personnes" VALUES('525',1,'ARROYO BAPTISTE DIEGO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-04-09',311810,'A');
INSERT INTO "personnes" VALUES('526',1,'PULECIO BOEK DANIEL','191821112','CRA 25 CALLE 100','718@gmail.com','2011-02-03',127591,'2011-08-12',203350,'A');
INSERT INTO "personnes" VALUES('527',1,'ESLAVA VELEZ SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-10-08',81300,'A');
INSERT INTO "personnes" VALUES('528',1,'CASTRO FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-05-06',796470,'A');
INSERT INTO "personnes" VALUES('53',1,'HINCAPIE MARTINEZ RICARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127573,'2011-09-26',790180,'A');
INSERT INTO "personnes" VALUES('530',1,'ZORRILLA PUJANA NICOLAS','191821112','CRA 25 CALLE 100','312@yahoo.es','2011-02-03',127591,'2011-06-06',302750,'A');
INSERT INTO "personnes" VALUES('531',1,'ZORRILLA PUJANA NICOLAS','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-06',298440,'A');
INSERT INTO "personnes" VALUES('532',1,'PRETEL ARTEAGA MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-09',583980,'A');
INSERT INTO "personnes" VALUES('533',1,'RAMOS VERGARA HUMBERTO CARLOS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',131105,'2010-05-13',24560,'A');
INSERT INTO "personnes" VALUES('534',1,'BONILLA PINEROS DIEGO FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-09-20',370880,'A');
INSERT INTO "personnes" VALUES('535',1,'BELTRAN TRIVINO JULIAN DAVID','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-11-06',780710,'A');
INSERT INTO "personnes" VALUES('536',3,'BLOD ULF FREDERICK EDWARD','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-06',790900,'A');
INSERT INTO "personnes" VALUES('537',1,'VANEGAS OROZCO SEBASTIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-11-10',612400,'A');
INSERT INTO "personnes" VALUES('538',3,'ORUE VALLE MONICA CECILIA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',97885,'2011-09-15',689270,'A');
INSERT INTO "personnes" VALUES('539',1,'AGUDELO BEDOYA ANDRES JOSE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2011-05-24',609160,'A');
INSERT INTO "personnes" VALUES('54',1,'DE HOYOS TRESPALACIOS MAURICIO ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-04-21',916500,'A');
INSERT INTO "personnes" VALUES('540',3,'HEIJKENSKJOLD PER JESPER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-04-06',977980,'A');
INSERT INTO "personnes" VALUES('541',3,'GONZALEZ ALVARADO LUIS RAUL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-08-27',62430,'A');
INSERT INTO "personnes" VALUES('543',1,'GRUPO SURAMERICA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-08-24',703760,'A');
INSERT INTO "personnes" VALUES('545',1,'CORPORACION CONTEXTO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-09-08',809570,'A');
INSERT INTO "personnes" VALUES('546',3,'LUNDIN JOHAN ERIK ','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-29',895330,'A');
INSERT INTO "personnes" VALUES('548',3,'VEGERANO JOSE ','191821112','CRA 25 CALLE 100','221@facebook.com','2011-02-03',190393,'2011-06-05',553780,'A');
INSERT INTO "personnes" VALUES('549',3,'SERRANO MADRID CLAUDIA INES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-07-27',625060,'A');
INSERT INTO "personnes" VALUES('55',1,'TAFUR GOMEZ ALEXANDER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127300,'2010-09-12',211980,'A');
INSERT INTO "personnes" VALUES('550',1,'MARTINEZ ACEVEDO MAURICIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-10-06',463920,'A');
INSERT INTO "personnes" VALUES('551',1,'GONZALEZ MORENO PABLO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-07-21',444450,'A');
INSERT INTO "personnes" VALUES('552',1,'MEJIA ROJAS ANDRES FELIPE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-08-02',830470,'A');
INSERT INTO "personnes" VALUES('553',3,'RODRIGUEZ ANTHONY HANSEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-16',819000,'A');
INSERT INTO "personnes" VALUES('554',1,'ABUCHAIBE ANNICCHRICO JOSE ANTONIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-05-31',603610,'A');
INSERT INTO "personnes" VALUES('555',3,'MOYES KIMBERLY','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-08',561020,'A');
INSERT INTO "personnes" VALUES('556',3,'MONTINI MARIO JOSE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118942,'2010-03-16',994280,'A');
INSERT INTO "personnes" VALUES('557',3,'HOGBERG DANIEL TOBIAS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-06-15',288350,'A');
INSERT INTO "personnes" VALUES('559',1,'OROZCO PFEIZER MARTIN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-10-07',429520,'A');
INSERT INTO "personnes" VALUES('56',1,'NARINO ROJAS GABRIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-27',310390,'A');
INSERT INTO "personnes" VALUES('560',1,'GARCIA MONTOYA ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-06-02',770840,'A');
INSERT INTO "personnes" VALUES('562',1,'VELASQUEZ PALACIO MANUEL ORLANDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-06-23',515670,'A');
INSERT INTO "personnes" VALUES('563',1,'GALLEGO PEREZ DIEGO ALEJANDRO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-04-14',881460,'A');
INSERT INTO "personnes" VALUES('564',1,'RUEDA URREGO JUAN ESTEBAN','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-05-04',860270,'A');
INSERT INTO "personnes" VALUES('565',1,'RESTREPO DEL TORO MAURICIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-10',656960,'A');
INSERT INTO "personnes" VALUES('567',1,'TORO VALENCIA FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-08-04',549090,'A');
INSERT INTO "personnes" VALUES('568',1,'VILLEGAS LUIS ALFONSO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-02',633490,'A');
INSERT INTO "personnes" VALUES('569',3,'RIDSTROM CHRISTER ANDERS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',300701,'2011-09-06',520150,'A');
INSERT INTO "personnes" VALUES('57',1,'TOVAR ARANGO JOHN JAIME','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127662,'2010-07-03',916010,'A');
INSERT INTO "personnes" VALUES('570',3,'SHEPHERD DAVID','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2008-05-11',700280,'A');
INSERT INTO "personnes" VALUES('573',3,'BENGTSSON JOHAN ANDREAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-06',196830,'A');
INSERT INTO "personnes" VALUES('574',3,'PERSSON HANS JONAS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-09',172340,'A');
INSERT INTO "personnes" VALUES('575',3,'SYNNEBY BJORN ERIK','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-06-15',271210,'A');
INSERT INTO "personnes" VALUES('CELL381',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('577',3,'COHEN PAUL KIRTAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-25',381490,'A');
INSERT INTO "personnes" VALUES('578',3,'ROMERO BRAVO FERNANDO EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-08-21',390360,'A');
INSERT INTO "personnes" VALUES('579',3,'GUTHRIE ROBERT DEAN','191821112','CRA 25 CALLE 100','794@gmail.com','2011-02-03',161705,'2010-07-20',807350,'A');
INSERT INTO "personnes" VALUES('58',1,'TORRES ESCOBAR JAIRO ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-06-17',648860,'A');
INSERT INTO "personnes" VALUES('580',3,'ROCASERMENO MONTENEGRO MARIO JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',139844,'2010-12-01',865650,'A');
INSERT INTO "personnes" VALUES('581',1,'COCK JORGE EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2011-08-19',906210,'A');
INSERT INTO "personnes" VALUES('582',3,'REISS ANDREAS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2009-01-31',934120,'A');
INSERT INTO "personnes" VALUES('584',3,'ECHEVERRIA CASTILLO GERMAN FRANCISCO','191821112','CRA 25 CALLE 100','982@yahoo.com','2011-02-03',139844,'2011-07-20',957370,'A');
INSERT INTO "personnes" VALUES('585',3,'BRANDT CARLOS GUSTAVO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-10',931030,'A');
INSERT INTO "personnes" VALUES('586',3,'VEGA NUNEZ GILBERTO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-14',783010,'A');
INSERT INTO "personnes" VALUES('587',1,'BEJAR MUNOZ JORDI','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',196234,'2010-10-08',121990,'A');
INSERT INTO "personnes" VALUES('588',3,'WADSO KERSTIN ELIZABETH','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-09-17',260890,'A');
INSERT INTO "personnes" VALUES('59',1,'RAMOS FORERO JAVIER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-06-20',496300,'A');
INSERT INTO "personnes" VALUES('590',1,'RODRIGUEZ BETANCOURT JAVIER AUGUSTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127538,'2011-05-23',909850,'A');
INSERT INTO "personnes" VALUES('592',1,'ARBOLEDA HALABY RODRIGO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',150699,'2009-02-03',939170,'A');
INSERT INTO "personnes" VALUES('593',1,'CURE CURE CARLOS ALFREDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',150699,'2011-07-11',494600,'A');
INSERT INTO "personnes" VALUES('594',3,'VIDELA PEREZ OSCAR EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-07-13',655510,'A');
INSERT INTO "personnes" VALUES('595',1,'GONZALEZ GAVIRIA NESTOR','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2009-09-28',793760,'A');
INSERT INTO "personnes" VALUES('596',3,'IZQUIERDO DELGADO DIONISIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2009-09-24',2250,'A');
INSERT INTO "personnes" VALUES('597',1,'MORENO DAIRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127300,'2011-06-14',629990,'A');
INSERT INTO "personnes" VALUES('598',1,'RESTREPO FERNNDEZ SOTO JOSE MANUEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-08-31',143210,'A');
INSERT INTO "personnes" VALUES('599',3,'YERYES VERGARA MARIA SOLEDAD','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-10-11',826060,'A');
INSERT INTO "personnes" VALUES('6',1,'GUZMAN ESCOBAR JOSE VICENTE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-10',26390,'A');
INSERT INTO "personnes" VALUES('60',1,'ELEJALDE ESCOBAR TOMAS ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-11-09',534910,'A');
INSERT INTO "personnes" VALUES('601',1,'ESCAF ESCAF WILLIAM MIGUEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',150699,'2011-07-26',25190,'A');
INSERT INTO "personnes" VALUES('602',1,'CEBALLOS ZULUAGA JOSE ALEJANDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2011-05-03',23920,'A');
INSERT INTO "personnes" VALUES('603',1,'OLIVELLA GUERRERO RAFAEL ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',134022,'2010-06-23',44040,'A');
INSERT INTO "personnes" VALUES('604',1,'ESCOBAR GALLO CARLOS HUGO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-08-09',148420,'A');
INSERT INTO "personnes" VALUES('605',1,'ESCORCIA RAMIREZ EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128569,'2011-04-01',609990,'A');
INSERT INTO "personnes" VALUES('606',1,'MELGAREJO MORENO PAULA ANDREA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-05',604700,'A');
INSERT INTO "personnes" VALUES('607',1,'TOBON CALLE CARLOS GUILLERMO','191821112','CRA 25 CALLE 100','689@hotmail.es','2011-02-03',128662,'2011-03-16',193510,'A');
INSERT INTO "personnes" VALUES('608',3,'TREVINO NOPHAL SILVANO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',110709,'2011-05-27',153470,'A');
INSERT INTO "personnes" VALUES('609',1,'CARDER VELEZ EDWIN JOHN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-09-04',186830,'A');
INSERT INTO "personnes" VALUES('61',1,'GASCA DAZA VICTOR HERNANDO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-09-09',185660,'A');
INSERT INTO "personnes" VALUES('610',3,'DAVIS JOHN BRADLEY','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-04-06',473740,'A');
INSERT INTO "personnes" VALUES('611',1,'BAQUERO SLDARRIAGA ALVARO ALEJANDRO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-09-15',808210,'A');
INSERT INTO "personnes" VALUES('612',3,'SERRACIN ARAUZ YANIRA YAMILET','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',131272,'2011-06-09',619820,'A');
INSERT INTO "personnes" VALUES('613',1,'MORA SOTO ALVARO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-09-20',674450,'A');
INSERT INTO "personnes" VALUES('614',1,'SUAREZ RODRIGUEZ HERNANDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',145135,'2011-03-29',512820,'A');
INSERT INTO "personnes" VALUES('616',1,'BAQUERO GARCIA JORGE LUIS','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2010-07-14',165160,'A');
INSERT INTO "personnes" VALUES('617',3,'ABADI MADURO MOISES SIMON','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',131272,'2009-03-31',203640,'A');
INSERT INTO "personnes" VALUES('62',3,'FLOWER LYNDON BRUCE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',231373,'2011-05-16',323560,'A');
INSERT INTO "personnes" VALUES('624',8,'OLARTE LEONARDO','191821112','CRA 25 CALLE 100','6@hotmail.com','2011-02-03',127591,'2011-06-03',219790,'A');
INSERT INTO "personnes" VALUES('63',1,'RUBIO CORTES OSCAR','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-04-28',60830,'A');
INSERT INTO "personnes" VALUES('630',5,'PROEXPORT','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',128662,'2010-08-12',708320,'A');
INSERT INTO "personnes" VALUES('632',8,'SUPER COFFEE ','191821112','CRA 25 CALLE 100','792@hotmail.es','2011-02-03',127591,'2011-08-30',306460,'A');
INSERT INTO "personnes" VALUES('636',8,'NOGAL ASESORIAS FINANCIERAS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-04-07',752150,'A');
INSERT INTO "personnes" VALUES('64',1,'GUERRA MARTINEZ MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-24',333480,'A');
INSERT INTO "personnes" VALUES('645',8,'GIZ - PROFIS','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-08-31',566330,'A');
INSERT INTO "personnes" VALUES('652',3,'QBE DEL ISTMO COMPANIA DE REASEGUROS ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-07-14',932190,'A');
INSERT INTO "personnes" VALUES('655',3,'CORP. CENTRO DE ESTUDIOS DE DERECHO JUSTICIA Y SOCIEDAD','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-05-04',440370,'A');
INSERT INTO "personnes" VALUES('659',3,'GOOD YEAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2010-09-24',993830,'A');
INSERT INTO "personnes" VALUES('660',3,'ARCINIEGAS Y VILLAMIZAR','191821112','CRA 25 CALLE 100','258@yahoo.com','2011-02-03',127591,'2010-12-02',787450,'A');
INSERT INTO "personnes" VALUES('67',1,'LOPEZ HOYOS JUAN DIEGO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127662,'2010-04-13',665230,'A');
INSERT INTO "personnes" VALUES('670',8,'APPLUS NORCONTROL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2011-09-06',83210,'A');
INSERT INTO "personnes" VALUES('672',3,'KERLL SEBASTIAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',287273,'2010-12-19',501610,'A');
INSERT INTO "personnes" VALUES('673',1,'RESTREPO MOLINA RAMIRO ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',144215,'2010-12-18',457290,'A');
INSERT INTO "personnes" VALUES('674',1,'PEREZ GIL JOSE IGNACIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-08-18',781610,'A');
INSERT INTO "personnes" VALUES('CELL3840',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('676',1,'GARCIA LONDONO FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-08-23',336160,'A');
INSERT INTO "personnes" VALUES('677',3,'RIJLAARSDAM KARIN AN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-07-03',72210,'A');
INSERT INTO "personnes" VALUES('679',1,'LIZCANO MONTEALEGRE ARNULFO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127203,'2011-02-01',546170,'A');
INSERT INTO "personnes" VALUES('68',1,'MARTINEZ SILVA EDGAR','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-29',54250,'A');
INSERT INTO "personnes" VALUES('680',3,'OLIVARI MAYER PATRICIA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',122642,'2011-08-01',673170,'A');
INSERT INTO "personnes" VALUES('682',3,'CHEVALIER FRANCK PIERRE CHARLES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',263813,'2010-12-01',617280,'A');
INSERT INTO "personnes" VALUES('683',3,'NG WAI WING ','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126909,'2011-06-14',904310,'A');
INSERT INTO "personnes" VALUES('684',3,'MULLER DOMINGUEZ CARLOS ANDRES','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-05-22',669700,'A');
INSERT INTO "personnes" VALUES('685',3,'MOSQUEDA DOMNGUEZ ANGEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-04-08',635580,'A');
INSERT INTO "personnes" VALUES('686',3,'LARREGUI MARIN LEON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-04-08',168800,'A');
INSERT INTO "personnes" VALUES('687',3,'VARGAS VERGARA ALEJANDRO BRAULIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',159245,'2011-09-14',937260,'A');
INSERT INTO "personnes" VALUES('688',3,'SKINNER LYNN  CHERYL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-12',179890,'A');
INSERT INTO "personnes" VALUES('689',1,'URIBE CORREA LEONARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128662,'2010-07-29',87680,'A');
INSERT INTO "personnes" VALUES('690',1,'TAMAYO JARAMILLO FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',128662,'2010-11-10',898730,'A');
INSERT INTO "personnes" VALUES('691',3,'MOTABAN DE BORGES PAULA ELENA','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132958,'2010-09-24',230610,'A');
INSERT INTO "personnes" VALUES('692',5,'FERNANDEZ NALDA JOSE MANUEL ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-06-28',456850,'A');
INSERT INTO "personnes" VALUES('693',1,'GOMEZ RESTREPO JUAN FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-06-28',592420,'A');
INSERT INTO "personnes" VALUES('694',1,'CARDENAS TAMAYO JOSE JAIME','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-08-08',591550,'A');
INSERT INTO "personnes" VALUES('696',1,'RESTREPO ARANGO ALEJANDRO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-03-31',127820,'A');
INSERT INTO "personnes" VALUES('697',1,'ROCABADO PASTRANA ROBERT JAVIER','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127443,'2011-08-13',97600,'A');
INSERT INTO "personnes" VALUES('698',3,'JARVINEN JOONAS JORI KRISTIAN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',196234,'2011-05-29',104560,'A');
INSERT INTO "personnes" VALUES('699',1,'MORENO PEREZ HERNAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',128662,'2011-08-30',230000,'A');
INSERT INTO "personnes" VALUES('7',1,'PUYANA RAMOS GUILLERMO ALBERTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-08-27',331830,'A');
INSERT INTO "personnes" VALUES('70',1,'GALINDO MANZANO JAVIER FRANCISCO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-31',214890,'A');
INSERT INTO "personnes" VALUES('701',1,'ROMERO PEREZ ARCESIO JOSE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',132775,'2011-07-13',491650,'A');
INSERT INTO "personnes" VALUES('703',1,'CHAPARRO AGUDELO LEONARDO VIRGILIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',128662,'2011-05-04',271320,'A');
INSERT INTO "personnes" VALUES('704',5,'VASQUEZ YANIS MARIA DEL PILAR','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-10-13',508820,'A');
INSERT INTO "personnes" VALUES('705',3,'BARBERO JOSE ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',116511,'2010-09-13',730170,'A');
INSERT INTO "personnes" VALUES('706',1,'CARMONA HERNANDEZ MIGUEL ANGEL','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2010-11-08',124380,'A');
INSERT INTO "personnes" VALUES('707',1,'PEREZ SUAREZ JORGE ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132775,'2011-09-14',431370,'A');
INSERT INTO "personnes" VALUES('708',1,'ROJAS JORGE MARIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',130135,'2011-04-01',783740,'A');
INSERT INTO "personnes" VALUES('71',1,'DIAZ JUAN PABLO/JULES JAVIER','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-10-01',247860,'A');
INSERT INTO "personnes" VALUES('711',3,'CATALDO CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',116773,'2011-06-06',984810,'A');
INSERT INTO "personnes" VALUES('716',5,'MACIAS PIZARRO PATRICIO ','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2011-06-07',376260,'A');
INSERT INTO "personnes" VALUES('717',1,'RENDON MAYA DAVID ALEXANDER','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',130273,'2010-07-25',332310,'A');
INSERT INTO "personnes" VALUES('718',3,'DE HILDEBRAND E GRISI FILHO CELSO CLAUDIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-11',532740,'A');
INSERT INTO "personnes" VALUES('719',3,'ALLIEL FACUSSE JULIO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-06-20',666800,'A');
INSERT INTO "personnes" VALUES('72',1,'LOPEZ ROJAS VICTOR DANIEL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-07-11',594640,'A');
INSERT INTO "personnes" VALUES('720',3,'CHEMELLO JIMENEZ GAETANO ALBERTO FRANCISCO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132958,'2010-06-23',735760,'A');
INSERT INTO "personnes" VALUES('721',3,'GARCIA BEZANILLA RODOLFO EDUARDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',128662,'2010-04-12',678420,'A');
INSERT INTO "personnes" VALUES('722',1,'ARIAS EDWIN','191821112','CRA 25 CALLE 100','13@terra.com.co','2011-02-03',127492,'2008-04-24',184800,'A');
INSERT INTO "personnes" VALUES('723',3,'SOHN JANG WON','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-06-07',888750,'A');
INSERT INTO "personnes" VALUES('724',3,'WILHELM GIOVINE JAIME ROBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',115263,'2011-09-20',889340,'A');
INSERT INTO "personnes" VALUES('726',3,'CASTILLERO DANIA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',131272,'2011-05-13',234270,'A');
INSERT INTO "personnes" VALUES('727',3,'PORTUGAL LANGHORST MAX GUILLERMO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-03-13',829960,'A');
INSERT INTO "personnes" VALUES('729',3,'ALFONSO HERRANZ AGUSTIN ALFONSO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-07-21',745060,'A');
INSERT INTO "personnes" VALUES('73',1,'DAVILA MENDEZ OSCAR DIEGO','191821112','CRA 25 CALLE 100','991@yahoo.com.mx','2011-02-03',128569,'2011-08-31',229630,'A');
INSERT INTO "personnes" VALUES('730',3,'ALFONSO HERRANZ AGUSTIN CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2010-03-31',384360,'A');
INSERT INTO "personnes" VALUES('731',1,'NOGUERA RAMIREZ CARLOS ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-07-14',686610,'A');
INSERT INTO "personnes" VALUES('732',1,'ACOSTA PERALTA FABIAN ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',134030,'2011-06-21',279960,'A');
INSERT INTO "personnes" VALUES('733',3,'MAC LEAN PINA PEDRO SEGUNDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-05-23',339980,'A');
INSERT INTO "personnes" VALUES('734',1,'LEON ARCOS ALEX','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2011-05-04',860020,'A');
INSERT INTO "personnes" VALUES('736',3,'LAMARCA GARCIA GERMAN JULIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-04-29',820700,'A');
INSERT INTO "personnes" VALUES('737',1,'PORTO VELASQUEZ LUIS MIGUEL','191821112','CRA 25 CALLE 100','321@hotmail.es','2011-02-03',133535,'2011-08-17',263060,'A');
INSERT INTO "personnes" VALUES('738',1,'BUENAVENTURA MEDINA ERICK WILSON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',133535,'2011-09-18',853180,'A');
INSERT INTO "personnes" VALUES('739',1,'LEVY ARRAZOLA RALPH MARC','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2011-09-27',476720,'A');
INSERT INTO "personnes" VALUES('CELL3614',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('74',1,'RAMIREZ SORA EDISON','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-03',364220,'A');
INSERT INTO "personnes" VALUES('740',3,'MOON HYUNSIK ','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',173192,'2011-05-15',824080,'A');
INSERT INTO "personnes" VALUES('741',3,'LHUILLIER TRONCOSO GASTON MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-09-07',690230,'A');
INSERT INTO "personnes" VALUES('742',3,'UNDURRAGA PELLEGRINI GONZALO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',117002,'2010-11-21',978900,'A');
INSERT INTO "personnes" VALUES('743',1,'SOLANO TRIBIN NICOLAS SIMON','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',134022,'2011-03-16',823800,'A');
INSERT INTO "personnes" VALUES('744',1,'NOGUERA BENAVIDES JACOBO ALONSO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2010-10-06',182300,'A');
INSERT INTO "personnes" VALUES('745',1,'GARCIA LEON MARCO ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2008-04-16',440110,'A');
INSERT INTO "personnes" VALUES('746',1,'EMILIANI ROJAS ALEXANDER ALFONSO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-09-12',653640,'A');
INSERT INTO "personnes" VALUES('748',1,'CARRENO POULSEN HELGEN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-05-06',778370,'A');
INSERT INTO "personnes" VALUES('749',1,'ALVARADO FANDINO ANDRES EDUARDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2008-11-05',48280,'A');
INSERT INTO "personnes" VALUES('750',1,'DIAZ GRANADOS JUAN PABLO.','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-01-12',906290,'A');
INSERT INTO "personnes" VALUES('751',1,'OVALLE BETANCOURT ALBERTO JOSE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',134022,'2011-08-14',386620,'A');
INSERT INTO "personnes" VALUES('752',3,'GUTIERREZ VERGARA JOSE MIGUEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-05-08',214250,'A');
INSERT INTO "personnes" VALUES('753',3,'CHAPARRO GUAIMARAL LIZ','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',147467,'2011-03-16',911350,'A');
INSERT INTO "personnes" VALUES('754',3,'CORTES DE SOLMINIHAC PABLO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117002,'2011-01-20',914020,'A');
INSERT INTO "personnes" VALUES('755',3,'CHETAIL VINCENT','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',239124,'2010-08-23',836050,'A');
INSERT INTO "personnes" VALUES('756',3,'PERUGORRIA RODRIGUEZ JORGE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2010-10-17',438210,'A');
INSERT INTO "personnes" VALUES('757',3,'GOLLMANN ROBERTO JUAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',167269,'2011-03-28',682870,'A');
INSERT INTO "personnes" VALUES('758',3,'VARELA SEPULVEDA MARIA PILAR','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',118777,'2010-07-26',99730,'A');
INSERT INTO "personnes" VALUES('759',3,'MEYER WELIKSON MICHELE JANIK','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-05-10',450030,'A');
INSERT INTO "personnes" VALUES('76',1,'VANEGAS RODRIGUEZ OSCAR IVAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-06-20',568310,'A');
INSERT INTO "personnes" VALUES('77',3,'GATICA SOTOMAYOR MAURICIO VICENTE','191821112','CRA 25 CALLE 100','409@terra.com.co','2011-02-03',117002,'2010-05-13',444970,'A');
INSERT INTO "personnes" VALUES('79',1,'PENA VALENZUELA DANIEL','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-19',264790,'A');
INSERT INTO "personnes" VALUES('8',1,'NAVARRO PALENCIA HUGO RAFAEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',126968,'2011-05-05',579980,'A');
INSERT INTO "personnes" VALUES('80',1,'BARRIOS CUADRADO DAVID','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-07-29',764140,'A');
INSERT INTO "personnes" VALUES('802',3,'RECK GARRONE','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118942,'2009-02-06',767700,'A');
INSERT INTO "personnes" VALUES('81',1,'PARRA QUIROGA JOSE ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-18',26330,'A');
INSERT INTO "personnes" VALUES('811',8,'FEDERACION NACIONAL DE AVICULTORES ','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-04-18',926010,'A');
INSERT INTO "personnes" VALUES('812',1,'ORJUELA VELEZ JAIME ALFONSO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-06-22',257160,'A');
INSERT INTO "personnes" VALUES('813',1,'PENA CHACON GUSTAVO ADOLFO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2011-08-27',507770,'A');
INSERT INTO "personnes" VALUES('814',1,'RONDEROS MOJICA ANDRES FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127443,'2011-05-04',767370,'A');
INSERT INTO "personnes" VALUES('815',1,'RICO NINO MARIO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127443,'2011-05-18',313540,'A');
INSERT INTO "personnes" VALUES('817',3,'AVILA CHYTIL MANUEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',118471,'2011-07-14',387300,'A');
INSERT INTO "personnes" VALUES('818',3,'JABLONSKI DUARTE SILVEIRA ESTER','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',118942,'2010-12-21',139740,'A');
INSERT INTO "personnes" VALUES('819',3,'BUHLER MOSLER XIMENA ALEJANDRA','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2011-06-20',536830,'A');
INSERT INTO "personnes" VALUES('82',1,'CARRILLO GAMBOA JUAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-06-01',839240,'A');
INSERT INTO "personnes" VALUES('820',3,'FALQUETO DALMIRO ANGELO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-06-21',264910,'A');
INSERT INTO "personnes" VALUES('821',1,'RUGER GUSTAVO RODRIGUEZ TAMAYO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2010-04-12',714080,'A');
INSERT INTO "personnes" VALUES('822',3,'JULIO RODRIGUEZ FRANCISCO JAVIER','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',117002,'2011-08-16',775650,'A');
INSERT INTO "personnes" VALUES('823',3,'CIBANIK RODOLFO MOISES','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132554,'2011-09-19',736020,'A');
INSERT INTO "personnes" VALUES('824',3,'JIMENEZ FRANCO EMMANUEL ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-03-17',353150,'A');
INSERT INTO "personnes" VALUES('825',3,'GNECCO TREMEDAD','191821112','CRA 25 CALLE 100','818@hotmail.com','2011-02-03',171072,'2011-03-19',557700,'A');
INSERT INTO "personnes" VALUES('826',3,'VILAR MENDOZA JOSE RAFAEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-29',729050,'A');
INSERT INTO "personnes" VALUES('827',3,'GONZALEZ MOLINA CRISTIAN MAURICIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-06-20',972160,'A');
INSERT INTO "personnes" VALUES('828',1,'GONTOVNIK HOBRECKT CARLOS DANIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-08-02',673620,'A');
INSERT INTO "personnes" VALUES('829',3,'DIBARRAT URZUA SEBASTIAN RAIMUNDO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-28',451650,'A');
INSERT INTO "personnes" VALUES('830',3,'STOCCHERO HATSCHBACH GUILHERME','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',118777,'2010-11-22',237370,'A');
INSERT INTO "personnes" VALUES('831',1,'NAVAS PASSOS NARCISO EVELIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-04-21',831900,'A');
INSERT INTO "personnes" VALUES('832',3,'LUNA SOBENES FAVIAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-10-11',447400,'A');
INSERT INTO "personnes" VALUES('833',3,'NUNEZ NOGUEIRA ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',188640,'2011-03-19',741290,'A');
INSERT INTO "personnes" VALUES('834',1,'CASTRO BELTRAN ARIEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',128188,'2011-05-15',364270,'A');
INSERT INTO "personnes" VALUES('835',1,'TURBAY YAMIN MAURICIO JOSE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',188640,'2011-03-17',597490,'A');
INSERT INTO "personnes" VALUES('836',1,'GOMEZ BARRAZA RODNEY LORENZO','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-10-07',894610,'A');
INSERT INTO "personnes" VALUES('837',1,'CUELLO LASCANO ROBERTO','191821112','CRA 25 CALLE 100','221@hotmail.es','2011-02-03',133535,'2011-07-11',680610,'A');
INSERT INTO "personnes" VALUES('838',1,'PATERNINA PEINADO JOSE VICENTE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',133535,'2011-08-23',719190,'A');
INSERT INTO "personnes" VALUES('839',1,'YEPES RUBIANO ALFONSO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-05-16',554130,'A');
INSERT INTO "personnes" VALUES('84',1,'ALVIS RAMIREZ ALFREDO','191821112','CRA 25 CALLE 100','292@yahoo.com','2011-02-03',127662,'2011-09-16',68190,'A');
INSERT INTO "personnes" VALUES('840',1,'ROCA LLANOS GUILLERMO ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-08-22',613060,'A');
INSERT INTO "personnes" VALUES('841',1,'RENDON TORRALVO ENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2011-05-26',402950,'A');
INSERT INTO "personnes" VALUES('842',1,'BLANCO STAND GERMAN ELIECER','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-07-17',175530,'A');
INSERT INTO "personnes" VALUES('843',3,'BERNAL MAYRA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',131272,'2010-08-31',668820,'A');
INSERT INTO "personnes" VALUES('844',1,'NAVARRO RUIZ LAZARO GREGORIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',126916,'2008-09-23',817520,'A');
INSERT INTO "personnes" VALUES('846',3,'TUOMINEN OLLI PETTERI','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2010-09-01',953150,'A');
INSERT INTO "personnes" VALUES('847',1,'ESPARRAGOZA DE LA ESPRIELLA ENRIQUE ALBERTO ','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',133535,'2011-08-09',522340,'A');
INSERT INTO "personnes" VALUES('848',3,'ARAYA ARIAS JUAN VICENTE','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',132165,'2011-08-09',752210,'A');
INSERT INTO "personnes" VALUES('85',1,'GARCIA JORGE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-03-01',989420,'A');
INSERT INTO "personnes" VALUES('850',1,'PARDO GOMEZ GERMAN ENRIQUE','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132775,'2010-11-25',713690,'A');
INSERT INTO "personnes" VALUES('851',1,'ATIQUE JOSE MANUEL','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2008-03-03',986250,'A');
INSERT INTO "personnes" VALUES('852',1,'HERNANDEZ MEYER EDGARDO DE JESUS','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-07-20',790190,'A');
INSERT INTO "personnes" VALUES('853',1,'ZULUAGA DE LEON IVAN JESUS','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-07-03',992210,'A');
INSERT INTO "personnes" VALUES('854',1,'VILLARREAL ANGULO ENRIQUE ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',133535,'2011-10-02',590450,'A');
INSERT INTO "personnes" VALUES('855',1,'CELIA MARTINEZ APARICIO GIAN PIERO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',133535,'2011-06-15',975620,'A');
INSERT INTO "personnes" VALUES('857',3,'LIPARI RONALDO LUIS','191821112','CRA 25 CALLE 100','84@facebook.com','2011-02-03',118941,'2010-10-13',606990,'A');
INSERT INTO "personnes" VALUES('858',1,'RAVACHI DAVILA ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2011-05-04',714620,'A');
INSERT INTO "personnes" VALUES('859',3,'PINHEIRO OLIVEIRA LUCIANO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-04-06',752130,'A');
INSERT INTO "personnes" VALUES('86',1,'GOMEZ LIS CARLOS EMILIO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2009-12-22',742520,'A');
INSERT INTO "personnes" VALUES('860',1,'PUGLIESE MERCADO LUIGGI ALBERTO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-08-19',616780,'A');
INSERT INTO "personnes" VALUES('862',1,'JANNA TELLO DANIEL JALIL','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',133535,'2010-08-07',287220,'A');
INSERT INTO "personnes" VALUES('863',3,'MATTAR CARLOS HENRIQUE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2009-04-26',953570,'A');
INSERT INTO "personnes" VALUES('864',1,'MOLINA OLIER OSVALDO ENRIQUE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132775,'2011-04-18',906200,'A');
INSERT INTO "personnes" VALUES('865',1,'BLANCO MCLIN DAVID ALBERTO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2010-08-18',670290,'A');
INSERT INTO "personnes" VALUES('866',1,'NARANJO ROMERO ALFREDO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',133535,'2010-08-25',632860,'A');
INSERT INTO "personnes" VALUES('867',1,'SIMANCAS TRUJILLO RICARDO ANTONIO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-04-07',153400,'A');
INSERT INTO "personnes" VALUES('868',1,'ARENAS USME GERMAN','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',126881,'2011-10-01',868430,'A');
INSERT INTO "personnes" VALUES('869',5,'DIAZ CORDERO RODRIGO FERNANDO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-11-04',881950,'A');
INSERT INTO "personnes" VALUES('87',1,'CELIS PEREZ HERNANDO ALONSO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-10-05',744330,'A');
INSERT INTO "personnes" VALUES('870',3,'BINDER ZBEDA JONATAHAN JANAN','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',131083,'2010-04-11',804460,'A');
INSERT INTO "personnes" VALUES('871',1,'HINCAPIE HELLMAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2010-09-15',376440,'A');
INSERT INTO "personnes" VALUES('872',3,'MONTEIRO LANAMAR ALFONSO DE BUSTAMANTE','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',118942,'2009-03-23',468820,'A');
INSERT INTO "personnes" VALUES('873',3,'AGUDO CARMINATTI REGINA CELIA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2011-01-04',214770,'A');
INSERT INTO "personnes" VALUES('874',1,'GONZALEZ VILLALOBOS CRISTIAN MANUEL','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',133535,'2011-09-26',667400,'A');
INSERT INTO "personnes" VALUES('875',3,'GUELL VILLANUEVA ALVARO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2008-04-07',692670,'A');
INSERT INTO "personnes" VALUES('876',3,'GRES ANAIS ROBERTO ANDRES','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2010-12-01',461180,'A');
INSERT INTO "personnes" VALUES('877',3,'GAME MOCOCAIN JUAN ENRIQUE','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-08-07',227890,'A');
INSERT INTO "personnes" VALUES('878',1,'FERRER UCROS FERNANDO LEON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-06-22',755900,'A');
INSERT INTO "personnes" VALUES('879',3,'HERRERA JAUREGUI CARLOS GUSTAVO','191821112','CRA 25 CALLE 100','599@facebook.com','2011-02-03',131272,'2010-07-22',95840,'A');
INSERT INTO "personnes" VALUES('880',3,'BACALLAO HERNANDEZ ANTONIO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',126180,'2010-04-21',211480,'A');
INSERT INTO "personnes" VALUES('881',1,'GIJON URBINA JAIME','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',144879,'2011-04-03',769910,'A');
INSERT INTO "personnes" VALUES('882',3,'TRUSEN CHRISTOPH WOLFGANG','191821112','CRA 25 CALLE 100','338@yahoo.com.mx','2011-02-03',127591,'2010-10-24',215100,'A');
INSERT INTO "personnes" VALUES('883',3,'ASHOURI ASKANDAR','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',157861,'2009-03-03',765760,'A');
INSERT INTO "personnes" VALUES('885',1,'ALTAMAR WATTS JAIRO ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-08-20',620170,'A');
INSERT INTO "personnes" VALUES('887',3,'QUINTANA BALTIERRA ROBERTO ALEX','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',117002,'2011-06-21',891370,'A');
INSERT INTO "personnes" VALUES('889',1,'CARILLO PATINO VICTOR HILARIO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',130226,'2011-09-06',354570,'A');
INSERT INTO "personnes" VALUES('89',1,'CONTRERAS PULIDO LINA MARIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-08-06',237480,'A');
INSERT INTO "personnes" VALUES('890',1,'GELVES CANAS GENARO ALBERTO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-04-02',355640,'A');
INSERT INTO "personnes" VALUES('891',3,'CAGNONI DE MELO PAULA CRISTINA','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',118777,'2010-12-14',714490,'A');
INSERT INTO "personnes" VALUES('892',3,'MENA AMESTICA PATRICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2011-03-22',505510,'A');
INSERT INTO "personnes" VALUES('893',1,'CAICEDO ROMES','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-04-07',384110,'A');
INSERT INTO "personnes" VALUES('894',1,'ECHEVERRY TRUJILLO ARMANDO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-06-08',404010,'A');
INSERT INTO "personnes" VALUES('895',1,'CAJIA PEDRAZA ANTONIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2011-09-02',867700,'A');
INSERT INTO "personnes" VALUES('896',2,'PALACIOS OLIVA ANDRES FELIPE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',117002,'2011-05-24',126500,'A');
INSERT INTO "personnes" VALUES('897',1,'GUTIERREZ QUINTERO FABIAN ESTEBAN','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2009-10-24',29380,'A');
INSERT INTO "personnes" VALUES('899',3,'COBO GUEVARA LUIS FELIPE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-12-09',748860,'A');
INSERT INTO "personnes" VALUES('9',1,'OSORIO RODRIGUEZ FELIPE','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2010-09-27',904420,'A');
INSERT INTO "personnes" VALUES('90',1,'LEYTON GONZALEZ FREDY RAFAEL','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-03-24',705130,'A');
INSERT INTO "personnes" VALUES('901',1,'HERNANDEZ JOSE ANGEL','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',130266,'2011-05-23',964010,'A');
INSERT INTO "personnes" VALUES('CELL3652',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('903',3,'GONZALEZ MALDONADO MAURICIO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',117002,'2010-11-13',576500,'A');
INSERT INTO "personnes" VALUES('904',1,'OCHOA BARRIGA JORGE','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',130266,'2011-05-05',401380,'A');
INSERT INTO "personnes" VALUES('CELL3886',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('905',1,'OSORIO REDONDO JESUS DAVID','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127300,'2011-08-11',277390,'A');
INSERT INTO "personnes" VALUES('906',1,'BAYONA BARRIENTOS JEAN CARLOS','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-01-25',182820,'A');
INSERT INTO "personnes" VALUES('907',1,'MARTINEZ GOMEZ CARLOS ENRIQUE','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132775,'2010-03-11',81940,'A');
INSERT INTO "personnes" VALUES('908',1,'PUELLO LOPEZ GUILLERMO LEON','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',133535,'2011-08-12',861240,'A');
INSERT INTO "personnes" VALUES('909',1,'MOGOLLON LONDONO PEDRO LUIS CARLOS','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',132775,'2011-06-22',60380,'A');
INSERT INTO "personnes" VALUES('91',1,'ORTIZ RIOS JAVIER ADOLFO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127591,'2011-05-12',813200,'A');
INSERT INTO "personnes" VALUES('911',1,'HERRERA HOYOS CARLOS FRANCISCO','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',132775,'2010-09-12',409800,'A');
INSERT INTO "personnes" VALUES('912',3,'RIM MYUNG HWAN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-05-15',894450,'A');
INSERT INTO "personnes" VALUES('913',3,'BIANCO DORIEN','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-29',242820,'A');
INSERT INTO "personnes" VALUES('914',3,'FROIMZON WIEN DANIEL','191821112','CRA 25 CALLE 100','348@yahoo.com','2011-02-03',132165,'2010-11-06',530780,'A');
INSERT INTO "personnes" VALUES('915',3,'ALVEZ AZEVEDO JOAO MIGUEL','191821112','CRA 25 CALLE 100','861@hotmail.es','2011-02-03',127591,'2009-06-25',925420,'A');
INSERT INTO "personnes" VALUES('916',3,'CARRASCO DIAZ LUIS ANTONIO','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',127591,'2011-10-02',34780,'A');
INSERT INTO "personnes" VALUES('917',3,'VIVALLOS MEDINA LEONEL EDMUNDO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2010-09-12',397640,'A');
INSERT INTO "personnes" VALUES('919',3,'LASSE ANDRE BARKLIEN','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',286724,'2011-03-31',226390,'A');
INSERT INTO "personnes" VALUES('92',1,'CUERVO CARDENAS ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-09-08',950630,'A');
INSERT INTO "personnes" VALUES('920',3,'BARCELOS PLOTEGHER LILIA MARA','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127591,'2011-08-07',480380,'A');
INSERT INTO "personnes" VALUES('921',1,'JARAMILLO ARANGO JUAN DIEGO','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',127559,'2011-06-28',722700,'A');
INSERT INTO "personnes" VALUES('93',3,'RUIZ PRIETO WILLIAM','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',131272,'2011-01-19',313540,'A');
INSERT INTO "personnes" VALUES('932',7,'COMFENALCO ANTIOQUIA','191821112','CRA 25 CALLE 100','@facebook.com','2011-02-03',128662,'2011-05-05',515430,'A');
INSERT INTO "personnes" VALUES('94',1,'GALLEGO JUAN GUILLERMO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-06-25',715830,'A');
INSERT INTO "personnes" VALUES('944',3,'KARMELIC PAVLOV VESNA','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',120066,'2010-08-07',585580,'A');
INSERT INTO "personnes" VALUES('945',3,'RAMIREZ BORDON OSCAR','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',128662,'2010-07-02',526250,'A');
INSERT INTO "personnes" VALUES('946',3,'SORACCO CABEZA RODRIGO ANDRES','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',117002,'2011-07-04',874490,'A');
INSERT INTO "personnes" VALUES('949',1,'GALINDO JORGE ERNESTO','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',127300,'2008-07-10',344110,'A');
INSERT INTO "personnes" VALUES('950',3,'DR KNABLE THOMAS ERNST ALBERT','191821112','CRA 25 CALLE 100','@terra.com.co','2011-02-03',256231,'2009-11-17',685430,'A');
INSERT INTO "personnes" VALUES('953',3,'VELASQUEZ JANETH','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-20',404650,'A');
INSERT INTO "personnes" VALUES('954',3,'SOZA REX JOSE FRANCISCO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',150903,'2011-05-26',269790,'A');
INSERT INTO "personnes" VALUES('955',3,'FONTANA GAETE JAIME PATRICIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',117002,'2011-01-11',134970,'A');
INSERT INTO "personnes" VALUES('957',3,'PEREZ MARTINEZ GRECIA INDIRA','191821112','CRA 25 CALLE 100','@hotmail.es','2011-02-03',132958,'2010-08-27',922610,'A');
INSERT INTO "personnes" VALUES('96',1,'FORERO CUBILLOS JORGEARTURO','191821112','CRA 25 CALLE 100','@hotmail.com','2011-02-03',127591,'2011-07-25',45020,'A');
INSERT INTO "personnes" VALUES('97',1,'SILVA ACOSTA MARIO','191821112','CRA 25 CALLE 100','@yahoo.es','2011-02-03',127591,'2011-09-19',309580,'A');
INSERT INTO "personnes" VALUES('978',3,'BLUMENTHAL JAIRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',117630,'2010-04-22',653490,'A');
INSERT INTO "personnes" VALUES('984',3,'SUN XIAN','191821112','CRA 25 CALLE 100','@yahoo.com.mx','2011-02-03',127591,'2011-01-17',203630,'A');
INSERT INTO "personnes" VALUES('99',1,'CANO GUZMAN ALEJANDRO','191821112','CRA 25 CALLE 100','@gmail.com','2011-02-03',127591,'2011-08-23',135620,'A');
INSERT INTO "personnes" VALUES('999',1,' DRAGER','191821112','CRA 25 CALLE 100','@yahoo.com','2011-02-03',127591,'2010-12-22',882070,'A');
INSERT INTO "personnes" VALUES('CELL1020',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1021',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1083',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1153',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1179',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1183',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL126',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1326',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1329',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL133',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1413',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1426',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1529',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1614',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1651',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1760',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL179',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1857',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1879',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1902',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1921',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1962',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL1992',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2006',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL206',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL215',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2187',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2307',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2322',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2497',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2641',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2736',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2805',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL281',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2905',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL2963',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL3029',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL3090',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL3161',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL3302',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL3309',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL3325',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL3372',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL3422',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL3661',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4334',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4415',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4440',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4547',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4639',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4662',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4698',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL475',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4790',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4838',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4885',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL4939',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5064',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5066',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL51',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5102',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5116',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5187',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5192',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5206',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5226',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5250',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5282',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL536',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5401',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5415',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5503',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5506',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL554',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5544',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5595',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5648',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5801',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL5821',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6179',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6201',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6277',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6288',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6358',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6369',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6408',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6418',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6425',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6439',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6509',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6533',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6556',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL673',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6731',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6766',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6775',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6802',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6834',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6842',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6890',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6953',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL6957',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7024',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7198',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7216',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL728',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7314',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7316',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7418',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7431',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7432',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7513',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7522',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7617',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7623',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7708',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7777',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL787',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7907',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7951',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL7956',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8004',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8058',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL811',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8136',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8162',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8187',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8286',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8300',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8316',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8339',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8366',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8389',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8446',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8487',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8546',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8578',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8643',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8774',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8829',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8846',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL8942',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9046',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9110',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL917',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9189',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9206',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9241',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9331',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9429',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9434',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9495',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9517',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9558',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9650',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9748',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9830',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9842',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9878',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9893',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('CELL9945',1,'LOST','1',NULL,NULL,NULL,NULL,NULL,20000,'A');
INSERT INTO "personnes" VALUES('T-Cx200',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx201',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx202',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx203',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx204',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx205',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx206',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx207',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx208',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx209',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx210',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx211',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx212',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx213',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');
INSERT INTO "personnes" VALUES('T-Cx214',1,'LOST LOST','1',NULL,NULL,NULL,NULL,NULL,0,'A');

DROP TABLE IF EXISTS `prueba`;
CREATE TABLE `prueba` (
  `id` INTEGER NOT NULL PRIMARY KEY,
  `nombre` varchar(120) NOT NULL,
  `estado` char(1) NOT NULL
);

DROP TABLE IF EXISTS `robots`;
CREATE TABLE `robots` (
  `id` INTEGER NOT NULL PRIMARY KEY,
  `name` varchar(70) NOT NULL,
  `type` varchar(32) NOT NULL default 'mechanical',
  `year` int(11) NOT NULL default 1900,
  `datetime` datetime NOT NULL,
  `deleted` datetime default NULL,
  `text` text NOT NULL
);
INSERT INTO "robots" VALUES(1,'Robotina','mechanical',1972,'1972/01/01 00:00:00',NULL,'text');
INSERT INTO "robots" VALUES(2,'Astro Boy','mechanical',1952,'1952/01/01 00:00:00',NULL,'text');
INSERT INTO "robots" VALUES(3,'Terminator','cyborg',2029,'2029/01/01 00:00:00',NULL,'text');

DROP TABLE IF EXISTS `robots_parts`;
CREATE TABLE `robots_parts` (
  `id` INTEGER NOT NULL PRIMARY KEY,
  `robots_id` int(10) NOT NULL,
  `parts_id` int(10) NOT NULL,
  CONSTRAINT `robots_parts_ibfk_1` FOREIGN KEY (`robots_id`) REFERENCES `robots` (`id`),
  CONSTRAINT `robots_parts_ibfk_2` FOREIGN KEY (`parts_id`) REFERENCES `parts` (`id`)
);
INSERT INTO "robots_parts" VALUES(1,1,1);
INSERT INTO "robots_parts" VALUES(2,1,2);
INSERT INTO "robots_parts" VALUES(3,1,3);

DROP TABLE IF EXISTS `subscriptores`;
CREATE TABLE `subscriptores` (
  `id` INTEGER NOT NULL PRIMARY KEY,
  `email` varchar(70) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `status` char(1) NOT NULL
);
INSERT INTO "subscriptores" VALUES(43,'fuego@hotmail.com','2012-04-14 23:30:33','P');

DROP TABLE IF EXISTS `tipo_documento`;
CREATE TABLE `tipo_documento` (
  `id` INTEGER NOT NULL PRIMARY KEY,
  `detalle` varchar(32) NOT NULL
);
INSERT INTO "tipo_documento" VALUES(1,'TIPO 0');
INSERT INTO "tipo_documento" VALUES(2,'TIPO 1');
INSERT INTO "tipo_documento" VALUES(3,'TIPO 2');
INSERT INTO "tipo_documento" VALUES(4,'TIPO 3');
INSERT INTO "tipo_documento" VALUES(5,'TIPO 4');
INSERT INTO "tipo_documento" VALUES(6,'TIPO 5');
INSERT INTO "tipo_documento" VALUES(7,'TIPO 6');
INSERT INTO "tipo_documento" VALUES(8,'TIPO 7');
INSERT INTO "tipo_documento" VALUES(9,'TIPO 8');
INSERT INTO "tipo_documento" VALUES(10,'TIPO 9');
INSERT INTO "tipo_documento" VALUES(11,'TIPO 10');
INSERT INTO "tipo_documento" VALUES(12,'TIPO 11');
INSERT INTO "tipo_documento" VALUES(13,'TIPO 12');
INSERT INTO "tipo_documento" VALUES(14,'TIPO 13');
INSERT INTO "tipo_documento" VALUES(15,'TIPO 14');
INSERT INTO "tipo_documento" VALUES(16,'TIPO 15');
INSERT INTO "tipo_documento" VALUES(17,'TIPO 16');
INSERT INTO "tipo_documento" VALUES(18,'TIPO 17');
INSERT INTO "tipo_documento" VALUES(19,'TIPO 18');
INSERT INTO "tipo_documento" VALUES(20,'TIPO 19');
INSERT INTO "tipo_documento" VALUES(21,'TIPO 20');
INSERT INTO "tipo_documento" VALUES(22,'TIPO 21');
INSERT INTO "tipo_documento" VALUES(23,'TIPO 22');
INSERT INTO "tipo_documento" VALUES(24,'TIPO 23');
INSERT INTO "tipo_documento" VALUES(25,'TIPO 24');
INSERT INTO "tipo_documento" VALUES(26,'TIPO 25');
INSERT INTO "tipo_documento" VALUES(27,'TIPO 26');
INSERT INTO "tipo_documento" VALUES(28,'TIPO 27');
INSERT INTO "tipo_documento" VALUES(29,'TIPO 28');
INSERT INTO "tipo_documento" VALUES(30,'TIPO 29');
INSERT INTO "tipo_documento" VALUES(31,'TIPO 30');
INSERT INTO "tipo_documento" VALUES(32,'TIPO 31');
INSERT INTO "tipo_documento" VALUES(33,'TIPO 32');
INSERT INTO "tipo_documento" VALUES(34,'TIPO 33');
INSERT INTO "tipo_documento" VALUES(35,'TIPO 34');
INSERT INTO "tipo_documento" VALUES(36,'TIPO 35');
INSERT INTO "tipo_documento" VALUES(37,'TIPO 36');
INSERT INTO "tipo_documento" VALUES(38,'TIPO 37');
INSERT INTO "tipo_documento" VALUES(39,'TIPO 38');
INSERT INTO "tipo_documento" VALUES(40,'TIPO 39');
INSERT INTO "tipo_documento" VALUES(41,'TIPO 40');
INSERT INTO "tipo_documento" VALUES(42,'TIPO 41');
INSERT INTO "tipo_documento" VALUES(43,'TIPO 42');
INSERT INTO "tipo_documento" VALUES(44,'TIPO 43');
INSERT INTO "tipo_documento" VALUES(45,'TIPO 44');
INSERT INTO "tipo_documento" VALUES(46,'TIPO 45');
INSERT INTO "tipo_documento" VALUES(47,'TIPO 46');
INSERT INTO "tipo_documento" VALUES(48,'TIPO 47');
INSERT INTO "tipo_documento" VALUES(49,'TIPO 48');
INSERT INTO "tipo_documento" VALUES(50,'TIPO 49');
INSERT INTO "tipo_documento" VALUES(51,'TIPO 50');
INSERT INTO "tipo_documento" VALUES(52,'TIPO 51');
INSERT INTO "tipo_documento" VALUES(53,'TIPO 52');
INSERT INTO "tipo_documento" VALUES(54,'TIPO 53');
INSERT INTO "tipo_documento" VALUES(55,'TIPO 54');
INSERT INTO "tipo_documento" VALUES(56,'TIPO 55');
INSERT INTO "tipo_documento" VALUES(57,'TIPO 56');
INSERT INTO "tipo_documento" VALUES(58,'TIPO 57');
INSERT INTO "tipo_documento" VALUES(59,'TIPO 58');
INSERT INTO "tipo_documento" VALUES(60,'TIPO 59');
INSERT INTO "tipo_documento" VALUES(61,'TIPO 60');
INSERT INTO "tipo_documento" VALUES(62,'TIPO 61');
INSERT INTO "tipo_documento" VALUES(63,'TIPO 62');
INSERT INTO "tipo_documento" VALUES(64,'TIPO 63');
INSERT INTO "tipo_documento" VALUES(65,'TIPO 64');
INSERT INTO "tipo_documento" VALUES(66,'TIPO 65');
INSERT INTO "tipo_documento" VALUES(67,'TIPO 66');
INSERT INTO "tipo_documento" VALUES(68,'TIPO 67');
INSERT INTO "tipo_documento" VALUES(69,'TIPO 68');
INSERT INTO "tipo_documento" VALUES(70,'TIPO 69');
INSERT INTO "tipo_documento" VALUES(71,'TIPO 70');
INSERT INTO "tipo_documento" VALUES(72,'TIPO 71');
INSERT INTO "tipo_documento" VALUES(73,'TIPO 72');
INSERT INTO "tipo_documento" VALUES(74,'TIPO 73');
INSERT INTO "tipo_documento" VALUES(75,'TIPO 74');
INSERT INTO "tipo_documento" VALUES(76,'TIPO 75');
INSERT INTO "tipo_documento" VALUES(77,'TIPO 76');
INSERT INTO "tipo_documento" VALUES(78,'TIPO 77');
INSERT INTO "tipo_documento" VALUES(79,'TIPO 78');
INSERT INTO "tipo_documento" VALUES(80,'TIPO 79');
INSERT INTO "tipo_documento" VALUES(81,'TIPO 80');
INSERT INTO "tipo_documento" VALUES(82,'TIPO 81');
INSERT INTO "tipo_documento" VALUES(83,'TIPO 82');
INSERT INTO "tipo_documento" VALUES(84,'TIPO 83');
INSERT INTO "tipo_documento" VALUES(85,'TIPO 84');
INSERT INTO "tipo_documento" VALUES(86,'TIPO 85');
INSERT INTO "tipo_documento" VALUES(87,'TIPO 86');
INSERT INTO "tipo_documento" VALUES(88,'TIPO 87');
INSERT INTO "tipo_documento" VALUES(89,'TIPO 88');
INSERT INTO "tipo_documento" VALUES(90,'TIPO 89');
INSERT INTO "tipo_documento" VALUES(91,'TIPO 90');
INSERT INTO "tipo_documento" VALUES(92,'TIPO 91');
INSERT INTO "tipo_documento" VALUES(93,'TIPO 92');
INSERT INTO "tipo_documento" VALUES(94,'TIPO 93');
INSERT INTO "tipo_documento" VALUES(95,'TIPO 94');
INSERT INTO "tipo_documento" VALUES(96,'TIPO 95');
INSERT INTO "tipo_documento" VALUES(97,'TIPO 96');
INSERT INTO "tipo_documento" VALUES(98,'TIPO 97');
INSERT INTO "tipo_documento" VALUES(99,'TIPO 98');
INSERT INTO "tipo_documento" VALUES(100,'TIPO 99');
INSERT INTO "tipo_documento" VALUES(101,'TIPO 100');
INSERT INTO "tipo_documento" VALUES(102,'TIPO 101');
INSERT INTO "tipo_documento" VALUES(103,'TIPO 102');
INSERT INTO "tipo_documento" VALUES(104,'TIPO 103');
INSERT INTO "tipo_documento" VALUES(105,'TIPO 104');
INSERT INTO "tipo_documento" VALUES(106,'TIPO 105');
INSERT INTO "tipo_documento" VALUES(107,'TIPO 106');
INSERT INTO "tipo_documento" VALUES(108,'TIPO 107');
INSERT INTO "tipo_documento" VALUES(109,'TIPO 108');
INSERT INTO "tipo_documento" VALUES(110,'TIPO 109');
INSERT INTO "tipo_documento" VALUES(111,'TIPO 110');
INSERT INTO "tipo_documento" VALUES(112,'TIPO 111');
INSERT INTO "tipo_documento" VALUES(113,'TIPO 112');
INSERT INTO "tipo_documento" VALUES(114,'TIPO 113');
INSERT INTO "tipo_documento" VALUES(115,'TIPO 114');
INSERT INTO "tipo_documento" VALUES(116,'TIPO 115');
INSERT INTO "tipo_documento" VALUES(117,'TIPO 116');
INSERT INTO "tipo_documento" VALUES(118,'TIPO 117');
INSERT INTO "tipo_documento" VALUES(119,'TIPO 118');
INSERT INTO "tipo_documento" VALUES(120,'TIPO 119');
INSERT INTO "tipo_documento" VALUES(121,'TIPO 120');
INSERT INTO "tipo_documento" VALUES(122,'TIPO 121');
INSERT INTO "tipo_documento" VALUES(123,'TIPO 122');
INSERT INTO "tipo_documento" VALUES(124,'TIPO 123');
INSERT INTO "tipo_documento" VALUES(125,'TIPO 124');
INSERT INTO "tipo_documento" VALUES(126,'TIPO 125');
INSERT INTO "tipo_documento" VALUES(127,'TIPO 126');
INSERT INTO "tipo_documento" VALUES(128,'TIPO 127');
INSERT INTO "tipo_documento" VALUES(129,'TIPO 128');
INSERT INTO "tipo_documento" VALUES(130,'TIPO 129');
INSERT INTO "tipo_documento" VALUES(131,'TIPO 130');
INSERT INTO "tipo_documento" VALUES(132,'TIPO 131');
INSERT INTO "tipo_documento" VALUES(133,'TIPO 132');
INSERT INTO "tipo_documento" VALUES(134,'TIPO 133');
INSERT INTO "tipo_documento" VALUES(135,'TIPO 134');
INSERT INTO "tipo_documento" VALUES(136,'TIPO 135');
INSERT INTO "tipo_documento" VALUES(137,'TIPO 136');
INSERT INTO "tipo_documento" VALUES(138,'TIPO 137');
INSERT INTO "tipo_documento" VALUES(139,'TIPO 138');
INSERT INTO "tipo_documento" VALUES(140,'TIPO 139');
INSERT INTO "tipo_documento" VALUES(141,'TIPO 140');
INSERT INTO "tipo_documento" VALUES(142,'TIPO 141');
INSERT INTO "tipo_documento" VALUES(143,'TIPO 142');
INSERT INTO "tipo_documento" VALUES(144,'TIPO 143');
INSERT INTO "tipo_documento" VALUES(145,'TIPO 144');
INSERT INTO "tipo_documento" VALUES(146,'TIPO 145');
INSERT INTO "tipo_documento" VALUES(147,'TIPO 146');
INSERT INTO "tipo_documento" VALUES(148,'TIPO 147');
INSERT INTO "tipo_documento" VALUES(149,'TIPO 148');
INSERT INTO "tipo_documento" VALUES(150,'TIPO 149');
INSERT INTO "tipo_documento" VALUES(151,'TIPO 150');
INSERT INTO "tipo_documento" VALUES(152,'TIPO 151');
INSERT INTO "tipo_documento" VALUES(153,'TIPO 152');
INSERT INTO "tipo_documento" VALUES(154,'TIPO 153');
INSERT INTO "tipo_documento" VALUES(155,'TIPO 154');
INSERT INTO "tipo_documento" VALUES(156,'TIPO 155');
INSERT INTO "tipo_documento" VALUES(157,'TIPO 156');
INSERT INTO "tipo_documento" VALUES(158,'TIPO 157');
INSERT INTO "tipo_documento" VALUES(159,'TIPO 158');
INSERT INTO "tipo_documento" VALUES(160,'TIPO 159');
INSERT INTO "tipo_documento" VALUES(161,'TIPO 160');
INSERT INTO "tipo_documento" VALUES(162,'TIPO 161');
INSERT INTO "tipo_documento" VALUES(163,'TIPO 162');
INSERT INTO "tipo_documento" VALUES(164,'TIPO 163');
INSERT INTO "tipo_documento" VALUES(165,'TIPO 164');
INSERT INTO "tipo_documento" VALUES(166,'TIPO 165');
INSERT INTO "tipo_documento" VALUES(167,'TIPO 166');
INSERT INTO "tipo_documento" VALUES(168,'TIPO 167');
INSERT INTO "tipo_documento" VALUES(169,'TIPO 168');
INSERT INTO "tipo_documento" VALUES(170,'TIPO 169');
INSERT INTO "tipo_documento" VALUES(171,'TIPO 170');
INSERT INTO "tipo_documento" VALUES(172,'TIPO 171');
INSERT INTO "tipo_documento" VALUES(173,'TIPO 172');
INSERT INTO "tipo_documento" VALUES(174,'TIPO 173');
INSERT INTO "tipo_documento" VALUES(175,'TIPO 174');
INSERT INTO "tipo_documento" VALUES(176,'TIPO 175');
INSERT INTO "tipo_documento" VALUES(177,'TIPO 176');
INSERT INTO "tipo_documento" VALUES(178,'TIPO 177');
INSERT INTO "tipo_documento" VALUES(179,'TIPO 178');
INSERT INTO "tipo_documento" VALUES(180,'TIPO 179');
INSERT INTO "tipo_documento" VALUES(181,'TIPO 180');
INSERT INTO "tipo_documento" VALUES(182,'TIPO 181');
INSERT INTO "tipo_documento" VALUES(183,'TIPO 182');
INSERT INTO "tipo_documento" VALUES(184,'TIPO 183');
INSERT INTO "tipo_documento" VALUES(185,'TIPO 184');
INSERT INTO "tipo_documento" VALUES(186,'TIPO 185');
INSERT INTO "tipo_documento" VALUES(187,'TIPO 186');
INSERT INTO "tipo_documento" VALUES(188,'TIPO 187');
INSERT INTO "tipo_documento" VALUES(189,'TIPO 188');
INSERT INTO "tipo_documento" VALUES(190,'TIPO 189');
INSERT INTO "tipo_documento" VALUES(191,'TIPO 190');
INSERT INTO "tipo_documento" VALUES(192,'TIPO 191');
INSERT INTO "tipo_documento" VALUES(193,'TIPO 192');
INSERT INTO "tipo_documento" VALUES(194,'TIPO 193');
INSERT INTO "tipo_documento" VALUES(195,'TIPO 194');
INSERT INTO "tipo_documento" VALUES(196,'TIPO 195');
INSERT INTO "tipo_documento" VALUES(197,'TIPO 196');
INSERT INTO "tipo_documento" VALUES(198,'TIPO 197');
INSERT INTO "tipo_documento" VALUES(199,'TIPO 198');
INSERT INTO "tipo_documento" VALUES(200,'TIPO 199');
INSERT INTO "tipo_documento" VALUES(201,'TIPO 200');
INSERT INTO "tipo_documento" VALUES(202,'TIPO 201');
INSERT INTO "tipo_documento" VALUES(203,'TIPO 202');
INSERT INTO "tipo_documento" VALUES(204,'TIPO 203');
INSERT INTO "tipo_documento" VALUES(205,'TIPO 204');
INSERT INTO "tipo_documento" VALUES(206,'TIPO 205');
INSERT INTO "tipo_documento" VALUES(207,'TIPO 206');
INSERT INTO "tipo_documento" VALUES(208,'TIPO 207');
INSERT INTO "tipo_documento" VALUES(209,'TIPO 208');
INSERT INTO "tipo_documento" VALUES(210,'TIPO 209');
INSERT INTO "tipo_documento" VALUES(211,'TIPO 210');
INSERT INTO "tipo_documento" VALUES(212,'TIPO 211');
INSERT INTO "tipo_documento" VALUES(213,'TIPO 212');
INSERT INTO "tipo_documento" VALUES(214,'TIPO 213');
INSERT INTO "tipo_documento" VALUES(215,'TIPO 214');
INSERT INTO "tipo_documento" VALUES(216,'TIPO 215');
INSERT INTO "tipo_documento" VALUES(217,'TIPO 216');
INSERT INTO "tipo_documento" VALUES(218,'TIPO 217');
INSERT INTO "tipo_documento" VALUES(219,'TIPO 218');
INSERT INTO "tipo_documento" VALUES(220,'TIPO 219');
INSERT INTO "tipo_documento" VALUES(221,'TIPO 220');
INSERT INTO "tipo_documento" VALUES(222,'TIPO 221');
INSERT INTO "tipo_documento" VALUES(223,'TIPO 222');
INSERT INTO "tipo_documento" VALUES(224,'TIPO 223');
INSERT INTO "tipo_documento" VALUES(225,'TIPO 224');
INSERT INTO "tipo_documento" VALUES(226,'TIPO 225');
INSERT INTO "tipo_documento" VALUES(227,'TIPO 226');
INSERT INTO "tipo_documento" VALUES(228,'TIPO 227');
INSERT INTO "tipo_documento" VALUES(229,'TIPO 228');
INSERT INTO "tipo_documento" VALUES(230,'TIPO 229');
INSERT INTO "tipo_documento" VALUES(231,'TIPO 230');
INSERT INTO "tipo_documento" VALUES(232,'TIPO 231');
INSERT INTO "tipo_documento" VALUES(233,'TIPO 232');
INSERT INTO "tipo_documento" VALUES(234,'TIPO 233');
INSERT INTO "tipo_documento" VALUES(235,'TIPO 234');
INSERT INTO "tipo_documento" VALUES(236,'TIPO 235');
INSERT INTO "tipo_documento" VALUES(237,'TIPO 236');
INSERT INTO "tipo_documento" VALUES(238,'TIPO 237');
INSERT INTO "tipo_documento" VALUES(239,'TIPO 238');
INSERT INTO "tipo_documento" VALUES(240,'TIPO 239');
INSERT INTO "tipo_documento" VALUES(241,'TIPO 240');
INSERT INTO "tipo_documento" VALUES(242,'TIPO 241');
INSERT INTO "tipo_documento" VALUES(243,'TIPO 242');
INSERT INTO "tipo_documento" VALUES(244,'TIPO 243');
INSERT INTO "tipo_documento" VALUES(245,'TIPO 244');
INSERT INTO "tipo_documento" VALUES(246,'TIPO 245');
INSERT INTO "tipo_documento" VALUES(247,'TIPO 246');
INSERT INTO "tipo_documento" VALUES(248,'TIPO 247');
INSERT INTO "tipo_documento" VALUES(249,'TIPO 248');
INSERT INTO "tipo_documento" VALUES(250,'TIPO 249');
INSERT INTO "tipo_documento" VALUES(251,'TIPO 250');
INSERT INTO "tipo_documento" VALUES(252,'TIPO 251');
INSERT INTO "tipo_documento" VALUES(253,'TIPO 252');
INSERT INTO "tipo_documento" VALUES(254,'TIPO 253');
INSERT INTO "tipo_documento" VALUES(255,'TIPO 254');
INSERT INTO "tipo_documento" VALUES(256,'TIPO 255');
INSERT INTO "tipo_documento" VALUES(257,'TIPO 256');
INSERT INTO "tipo_documento" VALUES(258,'TIPO 257');
INSERT INTO "tipo_documento" VALUES(259,'TIPO 258');
INSERT INTO "tipo_documento" VALUES(260,'TIPO 259');
INSERT INTO "tipo_documento" VALUES(261,'TIPO 260');
INSERT INTO "tipo_documento" VALUES(262,'TIPO 261');
INSERT INTO "tipo_documento" VALUES(263,'TIPO 262');
INSERT INTO "tipo_documento" VALUES(264,'TIPO 263');
INSERT INTO "tipo_documento" VALUES(265,'TIPO 264');
INSERT INTO "tipo_documento" VALUES(266,'TIPO 265');
INSERT INTO "tipo_documento" VALUES(267,'TIPO 266');
INSERT INTO "tipo_documento" VALUES(268,'TIPO 267');
INSERT INTO "tipo_documento" VALUES(269,'TIPO 268');
INSERT INTO "tipo_documento" VALUES(270,'TIPO 269');
INSERT INTO "tipo_documento" VALUES(271,'TIPO 270');
INSERT INTO "tipo_documento" VALUES(272,'TIPO 271');
INSERT INTO "tipo_documento" VALUES(273,'TIPO 272');
INSERT INTO "tipo_documento" VALUES(274,'TIPO 273');
INSERT INTO "tipo_documento" VALUES(275,'TIPO 274');
INSERT INTO "tipo_documento" VALUES(276,'TIPO 275');
INSERT INTO "tipo_documento" VALUES(277,'TIPO 276');
INSERT INTO "tipo_documento" VALUES(278,'TIPO 277');
INSERT INTO "tipo_documento" VALUES(279,'TIPO 278');
INSERT INTO "tipo_documento" VALUES(280,'TIPO 279');
INSERT INTO "tipo_documento" VALUES(281,'TIPO 280');
INSERT INTO "tipo_documento" VALUES(282,'TIPO 281');
INSERT INTO "tipo_documento" VALUES(283,'TIPO 282');
INSERT INTO "tipo_documento" VALUES(284,'TIPO 283');
INSERT INTO "tipo_documento" VALUES(285,'TIPO 284');
INSERT INTO "tipo_documento" VALUES(286,'TIPO 285');
INSERT INTO "tipo_documento" VALUES(287,'TIPO 286');
INSERT INTO "tipo_documento" VALUES(288,'TIPO 287');
INSERT INTO "tipo_documento" VALUES(289,'TIPO 288');
INSERT INTO "tipo_documento" VALUES(290,'TIPO 289');
INSERT INTO "tipo_documento" VALUES(291,'TIPO 290');
INSERT INTO "tipo_documento" VALUES(292,'TIPO 291');
INSERT INTO "tipo_documento" VALUES(293,'TIPO 292');
INSERT INTO "tipo_documento" VALUES(294,'TIPO 293');
INSERT INTO "tipo_documento" VALUES(295,'TIPO 294');
INSERT INTO "tipo_documento" VALUES(296,'TIPO 295');
INSERT INTO "tipo_documento" VALUES(297,'TIPO 296');
INSERT INTO "tipo_documento" VALUES(298,'TIPO 297');
INSERT INTO "tipo_documento" VALUES(299,'TIPO 298');
INSERT INTO "tipo_documento" VALUES(300,'TIPO 299');
INSERT INTO "tipo_documento" VALUES(301,'TIPO 300');
INSERT INTO "tipo_documento" VALUES(302,'TIPO 301');
INSERT INTO "tipo_documento" VALUES(303,'TIPO 302');
INSERT INTO "tipo_documento" VALUES(304,'TIPO 303');
INSERT INTO "tipo_documento" VALUES(305,'TIPO 304');
INSERT INTO "tipo_documento" VALUES(306,'TIPO 305');
INSERT INTO "tipo_documento" VALUES(307,'TIPO 306');
INSERT INTO "tipo_documento" VALUES(308,'TIPO 307');
INSERT INTO "tipo_documento" VALUES(309,'TIPO 308');
INSERT INTO "tipo_documento" VALUES(310,'TIPO 309');
INSERT INTO "tipo_documento" VALUES(311,'TIPO 310');
INSERT INTO "tipo_documento" VALUES(312,'TIPO 311');
INSERT INTO "tipo_documento" VALUES(313,'TIPO 312');
INSERT INTO "tipo_documento" VALUES(314,'TIPO 313');
INSERT INTO "tipo_documento" VALUES(315,'TIPO 314');
INSERT INTO "tipo_documento" VALUES(316,'TIPO 315');
INSERT INTO "tipo_documento" VALUES(317,'TIPO 316');
INSERT INTO "tipo_documento" VALUES(318,'TIPO 317');
INSERT INTO "tipo_documento" VALUES(319,'TIPO 318');
INSERT INTO "tipo_documento" VALUES(320,'TIPO 319');
INSERT INTO "tipo_documento" VALUES(321,'TIPO 320');
INSERT INTO "tipo_documento" VALUES(322,'TIPO 321');
INSERT INTO "tipo_documento" VALUES(323,'TIPO 322');
INSERT INTO "tipo_documento" VALUES(324,'TIPO 323');
INSERT INTO "tipo_documento" VALUES(325,'TIPO 324');
INSERT INTO "tipo_documento" VALUES(326,'TIPO 325');
INSERT INTO "tipo_documento" VALUES(327,'TIPO 326');
INSERT INTO "tipo_documento" VALUES(328,'TIPO 327');
INSERT INTO "tipo_documento" VALUES(329,'TIPO 328');
INSERT INTO "tipo_documento" VALUES(330,'TIPO 329');
INSERT INTO "tipo_documento" VALUES(331,'TIPO 330');
INSERT INTO "tipo_documento" VALUES(332,'TIPO 331');
INSERT INTO "tipo_documento" VALUES(333,'TIPO 332');
INSERT INTO "tipo_documento" VALUES(334,'TIPO 333');
INSERT INTO "tipo_documento" VALUES(335,'TIPO 334');
INSERT INTO "tipo_documento" VALUES(336,'TIPO 335');
INSERT INTO "tipo_documento" VALUES(337,'TIPO 336');
INSERT INTO "tipo_documento" VALUES(338,'TIPO 337');
INSERT INTO "tipo_documento" VALUES(339,'TIPO 338');
INSERT INTO "tipo_documento" VALUES(340,'TIPO 339');
INSERT INTO "tipo_documento" VALUES(341,'TIPO 340');
INSERT INTO "tipo_documento" VALUES(342,'TIPO 341');
INSERT INTO "tipo_documento" VALUES(343,'TIPO 342');
INSERT INTO "tipo_documento" VALUES(344,'TIPO 343');
INSERT INTO "tipo_documento" VALUES(345,'TIPO 344');
INSERT INTO "tipo_documento" VALUES(346,'TIPO 345');
INSERT INTO "tipo_documento" VALUES(347,'TIPO 346');
INSERT INTO "tipo_documento" VALUES(348,'TIPO 347');
INSERT INTO "tipo_documento" VALUES(349,'TIPO 348');
INSERT INTO "tipo_documento" VALUES(350,'TIPO 349');
INSERT INTO "tipo_documento" VALUES(351,'TIPO 350');
INSERT INTO "tipo_documento" VALUES(352,'TIPO 351');
INSERT INTO "tipo_documento" VALUES(353,'TIPO 352');
INSERT INTO "tipo_documento" VALUES(354,'TIPO 353');
INSERT INTO "tipo_documento" VALUES(355,'TIPO 354');
INSERT INTO "tipo_documento" VALUES(356,'TIPO 355');
INSERT INTO "tipo_documento" VALUES(357,'TIPO 356');
INSERT INTO "tipo_documento" VALUES(358,'TIPO 357');
INSERT INTO "tipo_documento" VALUES(359,'TIPO 358');
INSERT INTO "tipo_documento" VALUES(360,'TIPO 359');
INSERT INTO "tipo_documento" VALUES(361,'TIPO 360');
INSERT INTO "tipo_documento" VALUES(362,'TIPO 361');
INSERT INTO "tipo_documento" VALUES(363,'TIPO 362');
INSERT INTO "tipo_documento" VALUES(364,'TIPO 363');
INSERT INTO "tipo_documento" VALUES(365,'TIPO 364');
INSERT INTO "tipo_documento" VALUES(366,'TIPO 365');
INSERT INTO "tipo_documento" VALUES(367,'TIPO 366');
INSERT INTO "tipo_documento" VALUES(368,'TIPO 367');
INSERT INTO "tipo_documento" VALUES(369,'TIPO 368');
INSERT INTO "tipo_documento" VALUES(370,'TIPO 369');
INSERT INTO "tipo_documento" VALUES(371,'TIPO 370');
INSERT INTO "tipo_documento" VALUES(372,'TIPO 371');
INSERT INTO "tipo_documento" VALUES(373,'TIPO 372');
INSERT INTO "tipo_documento" VALUES(374,'TIPO 373');
INSERT INTO "tipo_documento" VALUES(375,'TIPO 374');
INSERT INTO "tipo_documento" VALUES(376,'TIPO 375');
INSERT INTO "tipo_documento" VALUES(377,'TIPO 376');
INSERT INTO "tipo_documento" VALUES(378,'TIPO 377');
INSERT INTO "tipo_documento" VALUES(379,'TIPO 378');
INSERT INTO "tipo_documento" VALUES(380,'TIPO 379');
INSERT INTO "tipo_documento" VALUES(381,'TIPO 380');
INSERT INTO "tipo_documento" VALUES(382,'TIPO 381');
INSERT INTO "tipo_documento" VALUES(383,'TIPO 382');
INSERT INTO "tipo_documento" VALUES(384,'TIPO 383');
INSERT INTO "tipo_documento" VALUES(385,'TIPO 384');
INSERT INTO "tipo_documento" VALUES(386,'TIPO 385');
INSERT INTO "tipo_documento" VALUES(387,'TIPO 386');
INSERT INTO "tipo_documento" VALUES(388,'TIPO 387');
INSERT INTO "tipo_documento" VALUES(389,'TIPO 388');
INSERT INTO "tipo_documento" VALUES(390,'TIPO 389');
INSERT INTO "tipo_documento" VALUES(391,'TIPO 390');
INSERT INTO "tipo_documento" VALUES(392,'TIPO 391');
INSERT INTO "tipo_documento" VALUES(393,'TIPO 392');
INSERT INTO "tipo_documento" VALUES(394,'TIPO 393');
INSERT INTO "tipo_documento" VALUES(395,'TIPO 394');
INSERT INTO "tipo_documento" VALUES(396,'TIPO 395');
INSERT INTO "tipo_documento" VALUES(397,'TIPO 396');
INSERT INTO "tipo_documento" VALUES(398,'TIPO 397');
INSERT INTO "tipo_documento" VALUES(399,'TIPO 398');
INSERT INTO "tipo_documento" VALUES(400,'TIPO 399');
INSERT INTO "tipo_documento" VALUES(401,'TIPO 400');
INSERT INTO "tipo_documento" VALUES(402,'TIPO 401');
INSERT INTO "tipo_documento" VALUES(403,'TIPO 402');
INSERT INTO "tipo_documento" VALUES(404,'TIPO 403');
INSERT INTO "tipo_documento" VALUES(405,'TIPO 404');
INSERT INTO "tipo_documento" VALUES(406,'TIPO 405');
INSERT INTO "tipo_documento" VALUES(407,'TIPO 406');
INSERT INTO "tipo_documento" VALUES(408,'TIPO 407');
INSERT INTO "tipo_documento" VALUES(409,'TIPO 408');
INSERT INTO "tipo_documento" VALUES(410,'TIPO 409');
INSERT INTO "tipo_documento" VALUES(411,'TIPO 410');
INSERT INTO "tipo_documento" VALUES(412,'TIPO 411');
INSERT INTO "tipo_documento" VALUES(413,'TIPO 412');
INSERT INTO "tipo_documento" VALUES(414,'TIPO 413');
INSERT INTO "tipo_documento" VALUES(415,'TIPO 414');
INSERT INTO "tipo_documento" VALUES(416,'TIPO 415');
INSERT INTO "tipo_documento" VALUES(417,'TIPO 416');
INSERT INTO "tipo_documento" VALUES(418,'TIPO 417');
INSERT INTO "tipo_documento" VALUES(419,'TIPO 418');
INSERT INTO "tipo_documento" VALUES(420,'TIPO 419');
INSERT INTO "tipo_documento" VALUES(421,'TIPO 420');
INSERT INTO "tipo_documento" VALUES(422,'TIPO 421');
INSERT INTO "tipo_documento" VALUES(423,'TIPO 422');
INSERT INTO "tipo_documento" VALUES(424,'TIPO 423');
INSERT INTO "tipo_documento" VALUES(425,'TIPO 424');
INSERT INTO "tipo_documento" VALUES(426,'TIPO 425');
INSERT INTO "tipo_documento" VALUES(427,'TIPO 426');
INSERT INTO "tipo_documento" VALUES(428,'TIPO 427');
INSERT INTO "tipo_documento" VALUES(429,'TIPO 428');
INSERT INTO "tipo_documento" VALUES(430,'TIPO 429');
INSERT INTO "tipo_documento" VALUES(431,'TIPO 430');
INSERT INTO "tipo_documento" VALUES(432,'TIPO 431');
INSERT INTO "tipo_documento" VALUES(433,'TIPO 432');
INSERT INTO "tipo_documento" VALUES(434,'TIPO 433');
INSERT INTO "tipo_documento" VALUES(435,'TIPO 434');
INSERT INTO "tipo_documento" VALUES(436,'TIPO 435');
INSERT INTO "tipo_documento" VALUES(437,'TIPO 436');
INSERT INTO "tipo_documento" VALUES(438,'TIPO 437');
INSERT INTO "tipo_documento" VALUES(439,'TIPO 438');
INSERT INTO "tipo_documento" VALUES(440,'TIPO 439');
INSERT INTO "tipo_documento" VALUES(441,'TIPO 440');
INSERT INTO "tipo_documento" VALUES(442,'TIPO 441');
INSERT INTO "tipo_documento" VALUES(443,'TIPO 442');
INSERT INTO "tipo_documento" VALUES(444,'TIPO 443');
INSERT INTO "tipo_documento" VALUES(445,'TIPO 444');
INSERT INTO "tipo_documento" VALUES(446,'TIPO 445');
INSERT INTO "tipo_documento" VALUES(447,'TIPO 446');
INSERT INTO "tipo_documento" VALUES(448,'TIPO 447');
INSERT INTO "tipo_documento" VALUES(449,'TIPO 448');
INSERT INTO "tipo_documento" VALUES(450,'TIPO 449');
INSERT INTO "tipo_documento" VALUES(451,'TIPO 450');
INSERT INTO "tipo_documento" VALUES(452,'TIPO 451');
INSERT INTO "tipo_documento" VALUES(453,'TIPO 452');
INSERT INTO "tipo_documento" VALUES(454,'TIPO 453');
INSERT INTO "tipo_documento" VALUES(455,'TIPO 454');
INSERT INTO "tipo_documento" VALUES(456,'TIPO 455');
INSERT INTO "tipo_documento" VALUES(457,'TIPO 456');
INSERT INTO "tipo_documento" VALUES(458,'TIPO 457');
INSERT INTO "tipo_documento" VALUES(459,'TIPO 458');
INSERT INTO "tipo_documento" VALUES(460,'TIPO 459');
INSERT INTO "tipo_documento" VALUES(461,'TIPO 460');
INSERT INTO "tipo_documento" VALUES(462,'TIPO 461');
INSERT INTO "tipo_documento" VALUES(463,'TIPO 462');
INSERT INTO "tipo_documento" VALUES(464,'TIPO 463');
INSERT INTO "tipo_documento" VALUES(465,'TIPO 464');
INSERT INTO "tipo_documento" VALUES(466,'TIPO 465');
INSERT INTO "tipo_documento" VALUES(467,'TIPO 466');
INSERT INTO "tipo_documento" VALUES(468,'TIPO 467');
INSERT INTO "tipo_documento" VALUES(469,'TIPO 468');
INSERT INTO "tipo_documento" VALUES(470,'TIPO 469');
INSERT INTO "tipo_documento" VALUES(471,'TIPO 470');
INSERT INTO "tipo_documento" VALUES(472,'TIPO 471');
INSERT INTO "tipo_documento" VALUES(473,'TIPO 472');
INSERT INTO "tipo_documento" VALUES(474,'TIPO 473');
INSERT INTO "tipo_documento" VALUES(475,'TIPO 474');
INSERT INTO "tipo_documento" VALUES(476,'TIPO 475');
INSERT INTO "tipo_documento" VALUES(477,'TIPO 476');
INSERT INTO "tipo_documento" VALUES(478,'TIPO 477');
INSERT INTO "tipo_documento" VALUES(479,'TIPO 478');
INSERT INTO "tipo_documento" VALUES(480,'TIPO 479');
INSERT INTO "tipo_documento" VALUES(481,'TIPO 480');
INSERT INTO "tipo_documento" VALUES(482,'TIPO 481');
INSERT INTO "tipo_documento" VALUES(483,'TIPO 482');
INSERT INTO "tipo_documento" VALUES(484,'TIPO 483');
INSERT INTO "tipo_documento" VALUES(485,'TIPO 484');
INSERT INTO "tipo_documento" VALUES(486,'TIPO 485');
INSERT INTO "tipo_documento" VALUES(487,'TIPO 486');
INSERT INTO "tipo_documento" VALUES(488,'TIPO 487');
INSERT INTO "tipo_documento" VALUES(489,'TIPO 488');
INSERT INTO "tipo_documento" VALUES(490,'TIPO 489');
INSERT INTO "tipo_documento" VALUES(491,'TIPO 490');
INSERT INTO "tipo_documento" VALUES(492,'TIPO 491');
INSERT INTO "tipo_documento" VALUES(493,'TIPO 492');
INSERT INTO "tipo_documento" VALUES(494,'TIPO 493');
INSERT INTO "tipo_documento" VALUES(495,'TIPO 494');
INSERT INTO "tipo_documento" VALUES(496,'TIPO 495');
INSERT INTO "tipo_documento" VALUES(497,'TIPO 496');
INSERT INTO "tipo_documento" VALUES(498,'TIPO 497');
INSERT INTO "tipo_documento" VALUES(499,'TIPO 498');
INSERT INTO "tipo_documento" VALUES(500,'TIPO 499');
INSERT INTO "tipo_documento" VALUES(501,'TIPO 500');
INSERT INTO "tipo_documento" VALUES(502,'TIPO 501');
INSERT INTO "tipo_documento" VALUES(503,'TIPO 502');
INSERT INTO "tipo_documento" VALUES(504,'TIPO 503');
INSERT INTO "tipo_documento" VALUES(505,'TIPO 504');
INSERT INTO "tipo_documento" VALUES(506,'TIPO 505');
INSERT INTO "tipo_documento" VALUES(507,'TIPO 506');
INSERT INTO "tipo_documento" VALUES(508,'TIPO 507');
INSERT INTO "tipo_documento" VALUES(509,'TIPO 508');
INSERT INTO "tipo_documento" VALUES(510,'TIPO 509');
INSERT INTO "tipo_documento" VALUES(511,'TIPO 510');
INSERT INTO "tipo_documento" VALUES(512,'TIPO 511');
INSERT INTO "tipo_documento" VALUES(513,'TIPO 512');
INSERT INTO "tipo_documento" VALUES(514,'TIPO 513');
INSERT INTO "tipo_documento" VALUES(515,'TIPO 514');
INSERT INTO "tipo_documento" VALUES(516,'TIPO 515');
INSERT INTO "tipo_documento" VALUES(517,'TIPO 516');
INSERT INTO "tipo_documento" VALUES(518,'TIPO 517');
INSERT INTO "tipo_documento" VALUES(519,'TIPO 518');
INSERT INTO "tipo_documento" VALUES(520,'TIPO 519');
INSERT INTO "tipo_documento" VALUES(521,'TIPO 520');
INSERT INTO "tipo_documento" VALUES(522,'TIPO 521');
INSERT INTO "tipo_documento" VALUES(523,'TIPO 522');
INSERT INTO "tipo_documento" VALUES(524,'TIPO 523');
INSERT INTO "tipo_documento" VALUES(525,'TIPO 524');
INSERT INTO "tipo_documento" VALUES(526,'TIPO 525');
INSERT INTO "tipo_documento" VALUES(527,'TIPO 526');
INSERT INTO "tipo_documento" VALUES(528,'TIPO 527');
INSERT INTO "tipo_documento" VALUES(529,'TIPO 528');
INSERT INTO "tipo_documento" VALUES(530,'TIPO 529');
INSERT INTO "tipo_documento" VALUES(531,'TIPO 530');
INSERT INTO "tipo_documento" VALUES(532,'TIPO 531');
INSERT INTO "tipo_documento" VALUES(533,'TIPO 532');
INSERT INTO "tipo_documento" VALUES(534,'TIPO 533');
INSERT INTO "tipo_documento" VALUES(535,'TIPO 534');
INSERT INTO "tipo_documento" VALUES(536,'TIPO 535');
INSERT INTO "tipo_documento" VALUES(537,'TIPO 536');
INSERT INTO "tipo_documento" VALUES(538,'TIPO 537');
INSERT INTO "tipo_documento" VALUES(539,'TIPO 538');
INSERT INTO "tipo_documento" VALUES(540,'TIPO 539');
INSERT INTO "tipo_documento" VALUES(541,'TIPO 540');
INSERT INTO "tipo_documento" VALUES(542,'TIPO 541');
INSERT INTO "tipo_documento" VALUES(543,'TIPO 542');
INSERT INTO "tipo_documento" VALUES(544,'TIPO 543');
INSERT INTO "tipo_documento" VALUES(545,'TIPO 544');
INSERT INTO "tipo_documento" VALUES(546,'TIPO 545');
INSERT INTO "tipo_documento" VALUES(547,'TIPO 546');
INSERT INTO "tipo_documento" VALUES(548,'TIPO 547');
INSERT INTO "tipo_documento" VALUES(549,'TIPO 548');
INSERT INTO "tipo_documento" VALUES(550,'TIPO 549');
INSERT INTO "tipo_documento" VALUES(551,'TIPO 550');
INSERT INTO "tipo_documento" VALUES(552,'TIPO 551');
INSERT INTO "tipo_documento" VALUES(553,'TIPO 552');
INSERT INTO "tipo_documento" VALUES(554,'TIPO 553');
INSERT INTO "tipo_documento" VALUES(555,'TIPO 554');
INSERT INTO "tipo_documento" VALUES(556,'TIPO 555');
INSERT INTO "tipo_documento" VALUES(557,'TIPO 556');
INSERT INTO "tipo_documento" VALUES(558,'TIPO 557');
INSERT INTO "tipo_documento" VALUES(559,'TIPO 558');
INSERT INTO "tipo_documento" VALUES(560,'TIPO 559');
INSERT INTO "tipo_documento" VALUES(561,'TIPO 560');
INSERT INTO "tipo_documento" VALUES(562,'TIPO 561');
INSERT INTO "tipo_documento" VALUES(563,'TIPO 562');
INSERT INTO "tipo_documento" VALUES(564,'TIPO 563');
INSERT INTO "tipo_documento" VALUES(565,'TIPO 564');
INSERT INTO "tipo_documento" VALUES(566,'TIPO 565');
INSERT INTO "tipo_documento" VALUES(567,'TIPO 566');
INSERT INTO "tipo_documento" VALUES(568,'TIPO 567');
INSERT INTO "tipo_documento" VALUES(569,'TIPO 568');
INSERT INTO "tipo_documento" VALUES(570,'TIPO 569');
INSERT INTO "tipo_documento" VALUES(571,'TIPO 570');
INSERT INTO "tipo_documento" VALUES(572,'TIPO 571');
INSERT INTO "tipo_documento" VALUES(573,'TIPO 572');
INSERT INTO "tipo_documento" VALUES(574,'TIPO 573');
INSERT INTO "tipo_documento" VALUES(575,'TIPO 574');
INSERT INTO "tipo_documento" VALUES(576,'TIPO 575');
INSERT INTO "tipo_documento" VALUES(577,'TIPO 576');
INSERT INTO "tipo_documento" VALUES(578,'TIPO 577');
INSERT INTO "tipo_documento" VALUES(579,'TIPO 578');
INSERT INTO "tipo_documento" VALUES(580,'TIPO 579');
INSERT INTO "tipo_documento" VALUES(581,'TIPO 580');
INSERT INTO "tipo_documento" VALUES(582,'TIPO 581');
INSERT INTO "tipo_documento" VALUES(583,'TIPO 582');
INSERT INTO "tipo_documento" VALUES(584,'TIPO 583');
INSERT INTO "tipo_documento" VALUES(585,'TIPO 584');
INSERT INTO "tipo_documento" VALUES(586,'TIPO 585');
INSERT INTO "tipo_documento" VALUES(587,'TIPO 586');
INSERT INTO "tipo_documento" VALUES(588,'TIPO 587');
INSERT INTO "tipo_documento" VALUES(589,'TIPO 588');
INSERT INTO "tipo_documento" VALUES(590,'TIPO 589');
INSERT INTO "tipo_documento" VALUES(591,'TIPO 590');
INSERT INTO "tipo_documento" VALUES(592,'TIPO 591');
INSERT INTO "tipo_documento" VALUES(593,'TIPO 592');
INSERT INTO "tipo_documento" VALUES(594,'TIPO 593');
INSERT INTO "tipo_documento" VALUES(595,'TIPO 594');
INSERT INTO "tipo_documento" VALUES(596,'TIPO 595');
INSERT INTO "tipo_documento" VALUES(597,'TIPO 596');
INSERT INTO "tipo_documento" VALUES(598,'TIPO 597');
INSERT INTO "tipo_documento" VALUES(599,'TIPO 598');
INSERT INTO "tipo_documento" VALUES(600,'TIPO 599');
INSERT INTO "tipo_documento" VALUES(601,'TIPO 600');
INSERT INTO "tipo_documento" VALUES(602,'TIPO 601');
INSERT INTO "tipo_documento" VALUES(603,'TIPO 602');
INSERT INTO "tipo_documento" VALUES(604,'TIPO 603');
INSERT INTO "tipo_documento" VALUES(605,'TIPO 604');
INSERT INTO "tipo_documento" VALUES(606,'TIPO 605');
INSERT INTO "tipo_documento" VALUES(607,'TIPO 606');
INSERT INTO "tipo_documento" VALUES(608,'TIPO 607');
INSERT INTO "tipo_documento" VALUES(609,'TIPO 608');
INSERT INTO "tipo_documento" VALUES(610,'TIPO 609');
INSERT INTO "tipo_documento" VALUES(611,'TIPO 610');
INSERT INTO "tipo_documento" VALUES(612,'TIPO 611');
INSERT INTO "tipo_documento" VALUES(613,'TIPO 612');
INSERT INTO "tipo_documento" VALUES(614,'TIPO 613');
INSERT INTO "tipo_documento" VALUES(615,'TIPO 614');
INSERT INTO "tipo_documento" VALUES(616,'TIPO 615');
INSERT INTO "tipo_documento" VALUES(617,'TIPO 616');
INSERT INTO "tipo_documento" VALUES(618,'TIPO 617');
INSERT INTO "tipo_documento" VALUES(619,'TIPO 618');
INSERT INTO "tipo_documento" VALUES(620,'TIPO 619');
INSERT INTO "tipo_documento" VALUES(621,'TIPO 620');
INSERT INTO "tipo_documento" VALUES(622,'TIPO 621');
INSERT INTO "tipo_documento" VALUES(623,'TIPO 622');
INSERT INTO "tipo_documento" VALUES(624,'TIPO 623');
INSERT INTO "tipo_documento" VALUES(625,'TIPO 624');
INSERT INTO "tipo_documento" VALUES(626,'TIPO 625');
INSERT INTO "tipo_documento" VALUES(627,'TIPO 626');
INSERT INTO "tipo_documento" VALUES(628,'TIPO 627');
INSERT INTO "tipo_documento" VALUES(629,'TIPO 628');
INSERT INTO "tipo_documento" VALUES(630,'TIPO 629');
INSERT INTO "tipo_documento" VALUES(631,'TIPO 630');
INSERT INTO "tipo_documento" VALUES(632,'TIPO 631');
INSERT INTO "tipo_documento" VALUES(633,'TIPO 632');
INSERT INTO "tipo_documento" VALUES(634,'TIPO 633');
INSERT INTO "tipo_documento" VALUES(635,'TIPO 634');
INSERT INTO "tipo_documento" VALUES(636,'TIPO 635');
INSERT INTO "tipo_documento" VALUES(637,'TIPO 636');
INSERT INTO "tipo_documento" VALUES(638,'TIPO 637');
INSERT INTO "tipo_documento" VALUES(639,'TIPO 638');
INSERT INTO "tipo_documento" VALUES(640,'TIPO 639');
INSERT INTO "tipo_documento" VALUES(641,'TIPO 640');
INSERT INTO "tipo_documento" VALUES(642,'TIPO 641');
INSERT INTO "tipo_documento" VALUES(643,'TIPO 642');
INSERT INTO "tipo_documento" VALUES(644,'TIPO 643');
INSERT INTO "tipo_documento" VALUES(645,'TIPO 644');
INSERT INTO "tipo_documento" VALUES(646,'TIPO 645');
INSERT INTO "tipo_documento" VALUES(647,'TIPO 646');
INSERT INTO "tipo_documento" VALUES(648,'TIPO 647');
INSERT INTO "tipo_documento" VALUES(649,'TIPO 648');
INSERT INTO "tipo_documento" VALUES(650,'TIPO 649');
INSERT INTO "tipo_documento" VALUES(651,'TIPO 650');
INSERT INTO "tipo_documento" VALUES(652,'TIPO 651');
INSERT INTO "tipo_documento" VALUES(653,'TIPO 652');
INSERT INTO "tipo_documento" VALUES(654,'TIPO 653');
INSERT INTO "tipo_documento" VALUES(655,'TIPO 654');
INSERT INTO "tipo_documento" VALUES(656,'TIPO 655');
INSERT INTO "tipo_documento" VALUES(657,'TIPO 656');
INSERT INTO "tipo_documento" VALUES(658,'TIPO 657');
INSERT INTO "tipo_documento" VALUES(659,'TIPO 658');
INSERT INTO "tipo_documento" VALUES(660,'TIPO 659');
INSERT INTO "tipo_documento" VALUES(661,'TIPO 660');
INSERT INTO "tipo_documento" VALUES(662,'TIPO 661');
INSERT INTO "tipo_documento" VALUES(663,'TIPO 662');
INSERT INTO "tipo_documento" VALUES(664,'TIPO 663');
INSERT INTO "tipo_documento" VALUES(665,'TIPO 664');
INSERT INTO "tipo_documento" VALUES(666,'TIPO 665');
INSERT INTO "tipo_documento" VALUES(667,'TIPO 666');
INSERT INTO "tipo_documento" VALUES(668,'TIPO 667');
INSERT INTO "tipo_documento" VALUES(669,'TIPO 668');
INSERT INTO "tipo_documento" VALUES(670,'TIPO 669');
INSERT INTO "tipo_documento" VALUES(671,'TIPO 670');
INSERT INTO "tipo_documento" VALUES(672,'TIPO 671');
INSERT INTO "tipo_documento" VALUES(673,'TIPO 672');
INSERT INTO "tipo_documento" VALUES(674,'TIPO 673');
INSERT INTO "tipo_documento" VALUES(675,'TIPO 674');
INSERT INTO "tipo_documento" VALUES(676,'TIPO 675');
INSERT INTO "tipo_documento" VALUES(677,'TIPO 676');
INSERT INTO "tipo_documento" VALUES(678,'TIPO 677');
INSERT INTO "tipo_documento" VALUES(679,'TIPO 678');
INSERT INTO "tipo_documento" VALUES(680,'TIPO 679');
INSERT INTO "tipo_documento" VALUES(681,'TIPO 680');
INSERT INTO "tipo_documento" VALUES(682,'TIPO 681');
INSERT INTO "tipo_documento" VALUES(683,'TIPO 682');
INSERT INTO "tipo_documento" VALUES(684,'TIPO 683');
INSERT INTO "tipo_documento" VALUES(685,'TIPO 684');
INSERT INTO "tipo_documento" VALUES(686,'TIPO 685');
INSERT INTO "tipo_documento" VALUES(687,'TIPO 686');
INSERT INTO "tipo_documento" VALUES(688,'TIPO 687');
INSERT INTO "tipo_documento" VALUES(689,'TIPO 688');
INSERT INTO "tipo_documento" VALUES(690,'TIPO 689');
INSERT INTO "tipo_documento" VALUES(691,'TIPO 690');
INSERT INTO "tipo_documento" VALUES(692,'TIPO 691');
INSERT INTO "tipo_documento" VALUES(693,'TIPO 692');
INSERT INTO "tipo_documento" VALUES(694,'TIPO 693');
INSERT INTO "tipo_documento" VALUES(695,'TIPO 694');
INSERT INTO "tipo_documento" VALUES(696,'TIPO 695');
INSERT INTO "tipo_documento" VALUES(697,'TIPO 696');
INSERT INTO "tipo_documento" VALUES(698,'TIPO 697');
INSERT INTO "tipo_documento" VALUES(699,'TIPO 698');
INSERT INTO "tipo_documento" VALUES(700,'TIPO 699');
INSERT INTO "tipo_documento" VALUES(701,'TIPO 700');
INSERT INTO "tipo_documento" VALUES(702,'TIPO 701');
INSERT INTO "tipo_documento" VALUES(703,'TIPO 702');
INSERT INTO "tipo_documento" VALUES(704,'TIPO 703');
INSERT INTO "tipo_documento" VALUES(705,'TIPO 704');
INSERT INTO "tipo_documento" VALUES(706,'TIPO 705');
INSERT INTO "tipo_documento" VALUES(707,'TIPO 706');
INSERT INTO "tipo_documento" VALUES(708,'TIPO 707');
INSERT INTO "tipo_documento" VALUES(709,'TIPO 708');
INSERT INTO "tipo_documento" VALUES(710,'TIPO 709');
INSERT INTO "tipo_documento" VALUES(711,'TIPO 710');
INSERT INTO "tipo_documento" VALUES(712,'TIPO 711');
INSERT INTO "tipo_documento" VALUES(713,'TIPO 712');
INSERT INTO "tipo_documento" VALUES(714,'TIPO 713');
INSERT INTO "tipo_documento" VALUES(715,'TIPO 714');
INSERT INTO "tipo_documento" VALUES(716,'TIPO 715');
INSERT INTO "tipo_documento" VALUES(717,'TIPO 716');
INSERT INTO "tipo_documento" VALUES(718,'TIPO 717');
INSERT INTO "tipo_documento" VALUES(719,'TIPO 718');
INSERT INTO "tipo_documento" VALUES(720,'TIPO 719');
INSERT INTO "tipo_documento" VALUES(721,'TIPO 720');
INSERT INTO "tipo_documento" VALUES(722,'TIPO 721');
INSERT INTO "tipo_documento" VALUES(723,'TIPO 722');
INSERT INTO "tipo_documento" VALUES(724,'TIPO 723');
INSERT INTO "tipo_documento" VALUES(725,'TIPO 724');
INSERT INTO "tipo_documento" VALUES(726,'TIPO 725');
INSERT INTO "tipo_documento" VALUES(727,'TIPO 726');
INSERT INTO "tipo_documento" VALUES(728,'TIPO 727');
INSERT INTO "tipo_documento" VALUES(729,'TIPO 728');
INSERT INTO "tipo_documento" VALUES(730,'TIPO 729');
INSERT INTO "tipo_documento" VALUES(731,'TIPO 730');
INSERT INTO "tipo_documento" VALUES(732,'TIPO 731');
INSERT INTO "tipo_documento" VALUES(733,'TIPO 732');
INSERT INTO "tipo_documento" VALUES(734,'TIPO 733');
INSERT INTO "tipo_documento" VALUES(735,'TIPO 734');
INSERT INTO "tipo_documento" VALUES(736,'TIPO 735');
INSERT INTO "tipo_documento" VALUES(737,'TIPO 736');
INSERT INTO "tipo_documento" VALUES(738,'TIPO 737');
INSERT INTO "tipo_documento" VALUES(739,'TIPO 738');
INSERT INTO "tipo_documento" VALUES(740,'TIPO 739');
INSERT INTO "tipo_documento" VALUES(741,'TIPO 740');
INSERT INTO "tipo_documento" VALUES(742,'TIPO 741');
INSERT INTO "tipo_documento" VALUES(743,'TIPO 742');
INSERT INTO "tipo_documento" VALUES(744,'TIPO 743');
INSERT INTO "tipo_documento" VALUES(745,'TIPO 744');
INSERT INTO "tipo_documento" VALUES(746,'TIPO 745');
INSERT INTO "tipo_documento" VALUES(747,'TIPO 746');
INSERT INTO "tipo_documento" VALUES(748,'TIPO 747');
INSERT INTO "tipo_documento" VALUES(749,'TIPO 748');
INSERT INTO "tipo_documento" VALUES(750,'TIPO 749');
INSERT INTO "tipo_documento" VALUES(751,'TIPO 750');
INSERT INTO "tipo_documento" VALUES(752,'TIPO 751');
INSERT INTO "tipo_documento" VALUES(753,'TIPO 752');
INSERT INTO "tipo_documento" VALUES(754,'TIPO 753');
INSERT INTO "tipo_documento" VALUES(755,'TIPO 754');
INSERT INTO "tipo_documento" VALUES(756,'TIPO 755');
INSERT INTO "tipo_documento" VALUES(757,'TIPO 756');
INSERT INTO "tipo_documento" VALUES(758,'TIPO 757');
INSERT INTO "tipo_documento" VALUES(759,'TIPO 758');
INSERT INTO "tipo_documento" VALUES(760,'TIPO 759');
INSERT INTO "tipo_documento" VALUES(761,'TIPO 760');
INSERT INTO "tipo_documento" VALUES(762,'TIPO 761');
INSERT INTO "tipo_documento" VALUES(763,'TIPO 762');
INSERT INTO "tipo_documento" VALUES(764,'TIPO 763');
INSERT INTO "tipo_documento" VALUES(765,'TIPO 764');
INSERT INTO "tipo_documento" VALUES(766,'TIPO 765');
INSERT INTO "tipo_documento" VALUES(767,'TIPO 766');
INSERT INTO "tipo_documento" VALUES(768,'TIPO 767');
INSERT INTO "tipo_documento" VALUES(769,'TIPO 768');
INSERT INTO "tipo_documento" VALUES(770,'TIPO 769');
INSERT INTO "tipo_documento" VALUES(771,'TIPO 770');
INSERT INTO "tipo_documento" VALUES(772,'TIPO 771');
INSERT INTO "tipo_documento" VALUES(773,'TIPO 772');
INSERT INTO "tipo_documento" VALUES(774,'TIPO 773');
INSERT INTO "tipo_documento" VALUES(775,'TIPO 774');
INSERT INTO "tipo_documento" VALUES(776,'TIPO 775');
INSERT INTO "tipo_documento" VALUES(777,'TIPO 776');
INSERT INTO "tipo_documento" VALUES(778,'TIPO 777');
INSERT INTO "tipo_documento" VALUES(779,'TIPO 778');
INSERT INTO "tipo_documento" VALUES(780,'TIPO 779');
INSERT INTO "tipo_documento" VALUES(781,'TIPO 780');
INSERT INTO "tipo_documento" VALUES(782,'TIPO 781');
INSERT INTO "tipo_documento" VALUES(783,'TIPO 782');
INSERT INTO "tipo_documento" VALUES(784,'TIPO 783');
INSERT INTO "tipo_documento" VALUES(785,'TIPO 784');
INSERT INTO "tipo_documento" VALUES(786,'TIPO 785');
INSERT INTO "tipo_documento" VALUES(787,'TIPO 786');
INSERT INTO "tipo_documento" VALUES(788,'TIPO 787');
INSERT INTO "tipo_documento" VALUES(789,'TIPO 788');
INSERT INTO "tipo_documento" VALUES(790,'TIPO 789');
INSERT INTO "tipo_documento" VALUES(791,'TIPO 790');
INSERT INTO "tipo_documento" VALUES(792,'TIPO 791');
INSERT INTO "tipo_documento" VALUES(793,'TIPO 792');
INSERT INTO "tipo_documento" VALUES(794,'TIPO 793');
INSERT INTO "tipo_documento" VALUES(795,'TIPO 794');
INSERT INTO "tipo_documento" VALUES(796,'TIPO 795');
INSERT INTO "tipo_documento" VALUES(797,'TIPO 796');
INSERT INTO "tipo_documento" VALUES(798,'TIPO 797');
INSERT INTO "tipo_documento" VALUES(799,'TIPO 798');
INSERT INTO "tipo_documento" VALUES(800,'TIPO 799');
INSERT INTO "tipo_documento" VALUES(801,'TIPO 800');
INSERT INTO "tipo_documento" VALUES(802,'TIPO 801');
INSERT INTO "tipo_documento" VALUES(803,'TIPO 802');
INSERT INTO "tipo_documento" VALUES(804,'TIPO 803');
INSERT INTO "tipo_documento" VALUES(805,'TIPO 804');
INSERT INTO "tipo_documento" VALUES(806,'TIPO 805');
INSERT INTO "tipo_documento" VALUES(807,'TIPO 806');
INSERT INTO "tipo_documento" VALUES(808,'TIPO 807');
INSERT INTO "tipo_documento" VALUES(809,'TIPO 808');
INSERT INTO "tipo_documento" VALUES(810,'TIPO 809');
INSERT INTO "tipo_documento" VALUES(811,'TIPO 810');
INSERT INTO "tipo_documento" VALUES(812,'TIPO 811');
INSERT INTO "tipo_documento" VALUES(813,'TIPO 812');
INSERT INTO "tipo_documento" VALUES(814,'TIPO 813');
INSERT INTO "tipo_documento" VALUES(815,'TIPO 814');
INSERT INTO "tipo_documento" VALUES(816,'TIPO 815');
INSERT INTO "tipo_documento" VALUES(817,'TIPO 816');
INSERT INTO "tipo_documento" VALUES(818,'TIPO 817');
INSERT INTO "tipo_documento" VALUES(819,'TIPO 818');
INSERT INTO "tipo_documento" VALUES(820,'TIPO 819');
INSERT INTO "tipo_documento" VALUES(821,'TIPO 820');
INSERT INTO "tipo_documento" VALUES(822,'TIPO 821');
INSERT INTO "tipo_documento" VALUES(823,'TIPO 822');
INSERT INTO "tipo_documento" VALUES(824,'TIPO 823');
INSERT INTO "tipo_documento" VALUES(825,'TIPO 824');
INSERT INTO "tipo_documento" VALUES(826,'TIPO 825');
INSERT INTO "tipo_documento" VALUES(827,'TIPO 826');
INSERT INTO "tipo_documento" VALUES(828,'TIPO 827');
INSERT INTO "tipo_documento" VALUES(829,'TIPO 828');
INSERT INTO "tipo_documento" VALUES(830,'TIPO 829');
INSERT INTO "tipo_documento" VALUES(831,'TIPO 830');
INSERT INTO "tipo_documento" VALUES(832,'TIPO 831');
INSERT INTO "tipo_documento" VALUES(833,'TIPO 832');
INSERT INTO "tipo_documento" VALUES(834,'TIPO 833');
INSERT INTO "tipo_documento" VALUES(835,'TIPO 834');
INSERT INTO "tipo_documento" VALUES(836,'TIPO 835');
INSERT INTO "tipo_documento" VALUES(837,'TIPO 836');
INSERT INTO "tipo_documento" VALUES(838,'TIPO 837');
INSERT INTO "tipo_documento" VALUES(839,'TIPO 838');
INSERT INTO "tipo_documento" VALUES(840,'TIPO 839');
INSERT INTO "tipo_documento" VALUES(841,'TIPO 840');
INSERT INTO "tipo_documento" VALUES(842,'TIPO 841');
INSERT INTO "tipo_documento" VALUES(843,'TIPO 842');
INSERT INTO "tipo_documento" VALUES(844,'TIPO 843');
INSERT INTO "tipo_documento" VALUES(845,'TIPO 844');
INSERT INTO "tipo_documento" VALUES(846,'TIPO 845');
INSERT INTO "tipo_documento" VALUES(847,'TIPO 846');
INSERT INTO "tipo_documento" VALUES(848,'TIPO 847');
INSERT INTO "tipo_documento" VALUES(849,'TIPO 848');
INSERT INTO "tipo_documento" VALUES(850,'TIPO 849');
INSERT INTO "tipo_documento" VALUES(851,'TIPO 850');
INSERT INTO "tipo_documento" VALUES(852,'TIPO 851');
INSERT INTO "tipo_documento" VALUES(853,'TIPO 852');
INSERT INTO "tipo_documento" VALUES(854,'TIPO 853');
INSERT INTO "tipo_documento" VALUES(855,'TIPO 854');
INSERT INTO "tipo_documento" VALUES(856,'TIPO 855');
INSERT INTO "tipo_documento" VALUES(857,'TIPO 856');
INSERT INTO "tipo_documento" VALUES(858,'TIPO 857');
INSERT INTO "tipo_documento" VALUES(859,'TIPO 858');
INSERT INTO "tipo_documento" VALUES(860,'TIPO 859');
INSERT INTO "tipo_documento" VALUES(861,'TIPO 860');
INSERT INTO "tipo_documento" VALUES(862,'TIPO 861');
INSERT INTO "tipo_documento" VALUES(863,'TIPO 862');
INSERT INTO "tipo_documento" VALUES(864,'TIPO 863');
INSERT INTO "tipo_documento" VALUES(865,'TIPO 864');
INSERT INTO "tipo_documento" VALUES(866,'TIPO 865');
INSERT INTO "tipo_documento" VALUES(867,'TIPO 866');
INSERT INTO "tipo_documento" VALUES(868,'TIPO 867');
INSERT INTO "tipo_documento" VALUES(869,'TIPO 868');
INSERT INTO "tipo_documento" VALUES(870,'TIPO 869');
INSERT INTO "tipo_documento" VALUES(871,'TIPO 870');
INSERT INTO "tipo_documento" VALUES(872,'TIPO 871');
INSERT INTO "tipo_documento" VALUES(873,'TIPO 872');
INSERT INTO "tipo_documento" VALUES(874,'TIPO 873');
INSERT INTO "tipo_documento" VALUES(875,'TIPO 874');
INSERT INTO "tipo_documento" VALUES(876,'TIPO 875');
INSERT INTO "tipo_documento" VALUES(877,'TIPO 876');
INSERT INTO "tipo_documento" VALUES(878,'TIPO 877');
INSERT INTO "tipo_documento" VALUES(879,'TIPO 878');
INSERT INTO "tipo_documento" VALUES(880,'TIPO 879');
INSERT INTO "tipo_documento" VALUES(881,'TIPO 880');
INSERT INTO "tipo_documento" VALUES(882,'TIPO 881');
INSERT INTO "tipo_documento" VALUES(883,'TIPO 882');
INSERT INTO "tipo_documento" VALUES(884,'TIPO 883');
INSERT INTO "tipo_documento" VALUES(885,'TIPO 884');
INSERT INTO "tipo_documento" VALUES(886,'TIPO 885');
INSERT INTO "tipo_documento" VALUES(887,'TIPO 886');
INSERT INTO "tipo_documento" VALUES(888,'TIPO 887');
INSERT INTO "tipo_documento" VALUES(889,'TIPO 888');
INSERT INTO "tipo_documento" VALUES(890,'TIPO 889');
INSERT INTO "tipo_documento" VALUES(891,'TIPO 890');
INSERT INTO "tipo_documento" VALUES(892,'TIPO 891');
INSERT INTO "tipo_documento" VALUES(893,'TIPO 892');
INSERT INTO "tipo_documento" VALUES(894,'TIPO 893');
INSERT INTO "tipo_documento" VALUES(895,'TIPO 894');
INSERT INTO "tipo_documento" VALUES(896,'TIPO 895');
INSERT INTO "tipo_documento" VALUES(897,'TIPO 896');
INSERT INTO "tipo_documento" VALUES(898,'TIPO 897');
INSERT INTO "tipo_documento" VALUES(899,'TIPO 898');
INSERT INTO "tipo_documento" VALUES(900,'TIPO 899');
INSERT INTO "tipo_documento" VALUES(901,'TIPO 900');
INSERT INTO "tipo_documento" VALUES(902,'TIPO 901');
INSERT INTO "tipo_documento" VALUES(903,'TIPO 902');
INSERT INTO "tipo_documento" VALUES(904,'TIPO 903');
INSERT INTO "tipo_documento" VALUES(905,'TIPO 904');
INSERT INTO "tipo_documento" VALUES(906,'TIPO 905');
INSERT INTO "tipo_documento" VALUES(907,'TIPO 906');
INSERT INTO "tipo_documento" VALUES(908,'TIPO 907');
INSERT INTO "tipo_documento" VALUES(909,'TIPO 908');
INSERT INTO "tipo_documento" VALUES(910,'TIPO 909');
INSERT INTO "tipo_documento" VALUES(911,'TIPO 910');
INSERT INTO "tipo_documento" VALUES(912,'TIPO 911');
INSERT INTO "tipo_documento" VALUES(913,'TIPO 912');
INSERT INTO "tipo_documento" VALUES(914,'TIPO 913');
INSERT INTO "tipo_documento" VALUES(915,'TIPO 914');
INSERT INTO "tipo_documento" VALUES(916,'TIPO 915');
INSERT INTO "tipo_documento" VALUES(917,'TIPO 916');
INSERT INTO "tipo_documento" VALUES(918,'TIPO 917');
INSERT INTO "tipo_documento" VALUES(919,'TIPO 918');
INSERT INTO "tipo_documento" VALUES(920,'TIPO 919');
INSERT INTO "tipo_documento" VALUES(921,'TIPO 920');
INSERT INTO "tipo_documento" VALUES(922,'TIPO 921');
INSERT INTO "tipo_documento" VALUES(923,'TIPO 922');
INSERT INTO "tipo_documento" VALUES(924,'TIPO 923');
INSERT INTO "tipo_documento" VALUES(925,'TIPO 924');
INSERT INTO "tipo_documento" VALUES(926,'TIPO 925');
INSERT INTO "tipo_documento" VALUES(927,'TIPO 926');
INSERT INTO "tipo_documento" VALUES(928,'TIPO 927');
INSERT INTO "tipo_documento" VALUES(929,'TIPO 928');
INSERT INTO "tipo_documento" VALUES(930,'TIPO 929');
INSERT INTO "tipo_documento" VALUES(931,'TIPO 930');
INSERT INTO "tipo_documento" VALUES(932,'TIPO 931');
INSERT INTO "tipo_documento" VALUES(933,'TIPO 932');
INSERT INTO "tipo_documento" VALUES(934,'TIPO 933');
INSERT INTO "tipo_documento" VALUES(935,'TIPO 934');
INSERT INTO "tipo_documento" VALUES(936,'TIPO 935');
INSERT INTO "tipo_documento" VALUES(937,'TIPO 936');
INSERT INTO "tipo_documento" VALUES(938,'TIPO 937');
INSERT INTO "tipo_documento" VALUES(939,'TIPO 938');
INSERT INTO "tipo_documento" VALUES(940,'TIPO 939');
INSERT INTO "tipo_documento" VALUES(941,'TIPO 940');
INSERT INTO "tipo_documento" VALUES(942,'TIPO 941');
INSERT INTO "tipo_documento" VALUES(943,'TIPO 942');
INSERT INTO "tipo_documento" VALUES(944,'TIPO 943');
INSERT INTO "tipo_documento" VALUES(945,'TIPO 944');
INSERT INTO "tipo_documento" VALUES(946,'TIPO 945');
INSERT INTO "tipo_documento" VALUES(947,'TIPO 946');
INSERT INTO "tipo_documento" VALUES(948,'TIPO 947');
INSERT INTO "tipo_documento" VALUES(949,'TIPO 948');
INSERT INTO "tipo_documento" VALUES(950,'TIPO 949');
INSERT INTO "tipo_documento" VALUES(951,'TIPO 950');
INSERT INTO "tipo_documento" VALUES(952,'TIPO 951');
INSERT INTO "tipo_documento" VALUES(953,'TIPO 952');
INSERT INTO "tipo_documento" VALUES(954,'TIPO 953');
INSERT INTO "tipo_documento" VALUES(955,'TIPO 954');
INSERT INTO "tipo_documento" VALUES(956,'TIPO 955');
INSERT INTO "tipo_documento" VALUES(957,'TIPO 956');
INSERT INTO "tipo_documento" VALUES(958,'TIPO 957');
INSERT INTO "tipo_documento" VALUES(959,'TIPO 958');
INSERT INTO "tipo_documento" VALUES(960,'TIPO 959');
INSERT INTO "tipo_documento" VALUES(961,'TIPO 960');
INSERT INTO "tipo_documento" VALUES(962,'TIPO 961');
INSERT INTO "tipo_documento" VALUES(963,'TIPO 962');
INSERT INTO "tipo_documento" VALUES(964,'TIPO 963');
INSERT INTO "tipo_documento" VALUES(965,'TIPO 964');
INSERT INTO "tipo_documento" VALUES(966,'TIPO 965');
INSERT INTO "tipo_documento" VALUES(967,'TIPO 966');
INSERT INTO "tipo_documento" VALUES(968,'TIPO 967');
INSERT INTO "tipo_documento" VALUES(969,'TIPO 968');
INSERT INTO "tipo_documento" VALUES(970,'TIPO 969');
INSERT INTO "tipo_documento" VALUES(971,'TIPO 970');
INSERT INTO "tipo_documento" VALUES(972,'TIPO 971');
INSERT INTO "tipo_documento" VALUES(973,'TIPO 972');
INSERT INTO "tipo_documento" VALUES(974,'TIPO 973');
INSERT INTO "tipo_documento" VALUES(975,'TIPO 974');
INSERT INTO "tipo_documento" VALUES(976,'TIPO 975');
INSERT INTO "tipo_documento" VALUES(977,'TIPO 976');
INSERT INTO "tipo_documento" VALUES(978,'TIPO 977');
INSERT INTO "tipo_documento" VALUES(979,'TIPO 978');
INSERT INTO "tipo_documento" VALUES(980,'TIPO 979');
INSERT INTO "tipo_documento" VALUES(981,'TIPO 980');
INSERT INTO "tipo_documento" VALUES(982,'TIPO 981');
INSERT INTO "tipo_documento" VALUES(983,'TIPO 982');
INSERT INTO "tipo_documento" VALUES(984,'TIPO 983');
INSERT INTO "tipo_documento" VALUES(985,'TIPO 984');
INSERT INTO "tipo_documento" VALUES(986,'TIPO 985');
INSERT INTO "tipo_documento" VALUES(987,'TIPO 986');
INSERT INTO "tipo_documento" VALUES(988,'TIPO 987');
INSERT INTO "tipo_documento" VALUES(989,'TIPO 988');
INSERT INTO "tipo_documento" VALUES(990,'TIPO 989');
INSERT INTO "tipo_documento" VALUES(991,'TIPO 990');
INSERT INTO "tipo_documento" VALUES(992,'TIPO 991');
INSERT INTO "tipo_documento" VALUES(993,'TIPO 992');
INSERT INTO "tipo_documento" VALUES(994,'TIPO 993');
INSERT INTO "tipo_documento" VALUES(995,'TIPO 994');
INSERT INTO "tipo_documento" VALUES(996,'TIPO 995');
INSERT INTO "tipo_documento" VALUES(997,'TIPO 996');
INSERT INTO "tipo_documento" VALUES(998,'TIPO 997');
INSERT INTO "tipo_documento" VALUES(999,'TIPO 998');
INSERT INTO "tipo_documento" VALUES(1000,'TIPO 999');
INSERT INTO "tipo_documento" VALUES(1001,'TIPO 1000');
INSERT INTO "tipo_documento" VALUES(1002,'TIPO 1001');
INSERT INTO "tipo_documento" VALUES(1003,'TIPO 1002');
INSERT INTO "tipo_documento" VALUES(1004,'TIPO 1003');
INSERT INTO "tipo_documento" VALUES(1005,'TIPO 1004');
INSERT INTO "tipo_documento" VALUES(1006,'TIPO 1005');
INSERT INTO "tipo_documento" VALUES(1007,'TIPO 1006');
INSERT INTO "tipo_documento" VALUES(1008,'TIPO 1007');
INSERT INTO "tipo_documento" VALUES(1009,'TIPO 1008');
INSERT INTO "tipo_documento" VALUES(1010,'TIPO 1009');
INSERT INTO "tipo_documento" VALUES(1011,'TIPO 1010');
INSERT INTO "tipo_documento" VALUES(1012,'TIPO 1011');
INSERT INTO "tipo_documento" VALUES(1013,'TIPO 1012');
INSERT INTO "tipo_documento" VALUES(1014,'TIPO 1013');
INSERT INTO "tipo_documento" VALUES(1015,'TIPO 1014');
INSERT INTO "tipo_documento" VALUES(1016,'TIPO 1015');
INSERT INTO "tipo_documento" VALUES(1017,'TIPO 1016');
INSERT INTO "tipo_documento" VALUES(1018,'TIPO 1017');
INSERT INTO "tipo_documento" VALUES(1019,'TIPO 1018');
INSERT INTO "tipo_documento" VALUES(1020,'TIPO 1019');
INSERT INTO "tipo_documento" VALUES(1021,'TIPO 1020');
INSERT INTO "tipo_documento" VALUES(1022,'TIPO 1021');
INSERT INTO "tipo_documento" VALUES(1023,'TIPO 1022');
INSERT INTO "tipo_documento" VALUES(1024,'TIPO 1023');
INSERT INTO "tipo_documento" VALUES(1025,'TIPO 1024');
INSERT INTO "tipo_documento" VALUES(1026,'TIPO 1025');
INSERT INTO "tipo_documento" VALUES(1027,'TIPO 1026');
INSERT INTO "tipo_documento" VALUES(1028,'TIPO 1027');
INSERT INTO "tipo_documento" VALUES(1029,'TIPO 1028');
INSERT INTO "tipo_documento" VALUES(1030,'TIPO 1029');
INSERT INTO "tipo_documento" VALUES(1031,'TIPO 1030');
INSERT INTO "tipo_documento" VALUES(1032,'TIPO 1031');
INSERT INTO "tipo_documento" VALUES(1033,'TIPO 1032');
INSERT INTO "tipo_documento" VALUES(1034,'TIPO 1033');
INSERT INTO "tipo_documento" VALUES(1035,'TIPO 1034');
INSERT INTO "tipo_documento" VALUES(1036,'TIPO 1035');
INSERT INTO "tipo_documento" VALUES(1037,'TIPO 1036');
INSERT INTO "tipo_documento" VALUES(1038,'TIPO 1037');
INSERT INTO "tipo_documento" VALUES(1039,'TIPO 1038');
INSERT INTO "tipo_documento" VALUES(1040,'TIPO 1039');
INSERT INTO "tipo_documento" VALUES(1041,'TIPO 1040');
INSERT INTO "tipo_documento" VALUES(1042,'TIPO 1041');
INSERT INTO "tipo_documento" VALUES(1043,'TIPO 1042');
INSERT INTO "tipo_documento" VALUES(1044,'TIPO 1043');
INSERT INTO "tipo_documento" VALUES(1045,'TIPO 1044');
INSERT INTO "tipo_documento" VALUES(1046,'TIPO 1045');
INSERT INTO "tipo_documento" VALUES(1047,'TIPO 1046');
INSERT INTO "tipo_documento" VALUES(1048,'TIPO 1047');
INSERT INTO "tipo_documento" VALUES(1049,'TIPO 1048');
INSERT INTO "tipo_documento" VALUES(1050,'TIPO 1049');
INSERT INTO "tipo_documento" VALUES(1051,'TIPO 1050');
INSERT INTO "tipo_documento" VALUES(1052,'TIPO 1051');
INSERT INTO "tipo_documento" VALUES(1053,'TIPO 1052');
INSERT INTO "tipo_documento" VALUES(1054,'TIPO 1053');
INSERT INTO "tipo_documento" VALUES(1055,'TIPO 1054');
INSERT INTO "tipo_documento" VALUES(1056,'TIPO 1055');
INSERT INTO "tipo_documento" VALUES(1057,'TIPO 1056');
INSERT INTO "tipo_documento" VALUES(1058,'TIPO 1057');
INSERT INTO "tipo_documento" VALUES(1059,'TIPO 1058');
INSERT INTO "tipo_documento" VALUES(1060,'TIPO 1059');
INSERT INTO "tipo_documento" VALUES(1061,'TIPO 1060');
INSERT INTO "tipo_documento" VALUES(1062,'TIPO 1061');
INSERT INTO "tipo_documento" VALUES(1063,'TIPO 1062');
INSERT INTO "tipo_documento" VALUES(1064,'TIPO 1063');
INSERT INTO "tipo_documento" VALUES(1065,'TIPO 1064');
INSERT INTO "tipo_documento" VALUES(1066,'TIPO 1065');
INSERT INTO "tipo_documento" VALUES(1067,'TIPO 1066');
INSERT INTO "tipo_documento" VALUES(1068,'TIPO 1067');
INSERT INTO "tipo_documento" VALUES(1069,'TIPO 1068');
INSERT INTO "tipo_documento" VALUES(1070,'TIPO 1069');
INSERT INTO "tipo_documento" VALUES(1071,'TIPO 1070');
INSERT INTO "tipo_documento" VALUES(1072,'TIPO 1071');
INSERT INTO "tipo_documento" VALUES(1073,'TIPO 1072');
INSERT INTO "tipo_documento" VALUES(1074,'TIPO 1073');
INSERT INTO "tipo_documento" VALUES(1075,'TIPO 1074');
INSERT INTO "tipo_documento" VALUES(1076,'TIPO 1075');
INSERT INTO "tipo_documento" VALUES(1077,'TIPO 1076');
INSERT INTO "tipo_documento" VALUES(1078,'TIPO 1077');
INSERT INTO "tipo_documento" VALUES(1079,'TIPO 1078');
INSERT INTO "tipo_documento" VALUES(1080,'TIPO 1079');
INSERT INTO "tipo_documento" VALUES(1081,'TIPO 1080');
INSERT INTO "tipo_documento" VALUES(1082,'TIPO 1081');
INSERT INTO "tipo_documento" VALUES(1083,'TIPO 1082');
INSERT INTO "tipo_documento" VALUES(1084,'TIPO 1083');
INSERT INTO "tipo_documento" VALUES(1085,'TIPO 1084');
INSERT INTO "tipo_documento" VALUES(1086,'TIPO 1085');
INSERT INTO "tipo_documento" VALUES(1087,'TIPO 1086');
INSERT INTO "tipo_documento" VALUES(1088,'TIPO 1087');
INSERT INTO "tipo_documento" VALUES(1089,'TIPO 1088');
INSERT INTO "tipo_documento" VALUES(1090,'TIPO 1089');
INSERT INTO "tipo_documento" VALUES(1091,'TIPO 1090');
INSERT INTO "tipo_documento" VALUES(1092,'TIPO 1091');
INSERT INTO "tipo_documento" VALUES(1093,'TIPO 1092');
INSERT INTO "tipo_documento" VALUES(1094,'TIPO 1093');
INSERT INTO "tipo_documento" VALUES(1095,'TIPO 1094');
INSERT INTO "tipo_documento" VALUES(1096,'TIPO 1095');
INSERT INTO "tipo_documento" VALUES(1097,'TIPO 1096');
INSERT INTO "tipo_documento" VALUES(1098,'TIPO 1097');
INSERT INTO "tipo_documento" VALUES(1099,'TIPO 1098');
INSERT INTO "tipo_documento" VALUES(1100,'TIPO 1099');
INSERT INTO "tipo_documento" VALUES(1101,'TIPO 1100');
INSERT INTO "tipo_documento" VALUES(1102,'TIPO 1101');
INSERT INTO "tipo_documento" VALUES(1103,'TIPO 1102');
INSERT INTO "tipo_documento" VALUES(1104,'TIPO 1103');
INSERT INTO "tipo_documento" VALUES(1105,'TIPO 1104');
INSERT INTO "tipo_documento" VALUES(1106,'TIPO 1105');
INSERT INTO "tipo_documento" VALUES(1107,'TIPO 1106');
INSERT INTO "tipo_documento" VALUES(1108,'TIPO 1107');
INSERT INTO "tipo_documento" VALUES(1109,'TIPO 1108');
INSERT INTO "tipo_documento" VALUES(1110,'TIPO 1109');
INSERT INTO "tipo_documento" VALUES(1111,'TIPO 1110');
INSERT INTO "tipo_documento" VALUES(1112,'TIPO 1111');
INSERT INTO "tipo_documento" VALUES(1113,'TIPO 1112');
INSERT INTO "tipo_documento" VALUES(1114,'TIPO 1113');
INSERT INTO "tipo_documento" VALUES(1115,'TIPO 1114');
INSERT INTO "tipo_documento" VALUES(1116,'TIPO 1115');
INSERT INTO "tipo_documento" VALUES(1117,'TIPO 1116');
INSERT INTO "tipo_documento" VALUES(1118,'TIPO 1117');
INSERT INTO "tipo_documento" VALUES(1119,'TIPO 1118');
INSERT INTO "tipo_documento" VALUES(1120,'TIPO 1119');
INSERT INTO "tipo_documento" VALUES(1121,'TIPO 1120');
INSERT INTO "tipo_documento" VALUES(1122,'TIPO 1121');
INSERT INTO "tipo_documento" VALUES(1123,'TIPO 1122');
INSERT INTO "tipo_documento" VALUES(1124,'TIPO 1123');
INSERT INTO "tipo_documento" VALUES(1125,'TIPO 1124');
INSERT INTO "tipo_documento" VALUES(1126,'TIPO 1125');
INSERT INTO "tipo_documento" VALUES(1127,'TIPO 1126');
INSERT INTO "tipo_documento" VALUES(1128,'TIPO 1127');
INSERT INTO "tipo_documento" VALUES(1129,'TIPO 1128');
INSERT INTO "tipo_documento" VALUES(1130,'TIPO 1129');
INSERT INTO "tipo_documento" VALUES(1131,'TIPO 1130');
INSERT INTO "tipo_documento" VALUES(1132,'TIPO 1131');
INSERT INTO "tipo_documento" VALUES(1133,'TIPO 1132');
INSERT INTO "tipo_documento" VALUES(1134,'TIPO 1133');
INSERT INTO "tipo_documento" VALUES(1135,'TIPO 1134');
INSERT INTO "tipo_documento" VALUES(1136,'TIPO 1135');
INSERT INTO "tipo_documento" VALUES(1137,'TIPO 1136');
INSERT INTO "tipo_documento" VALUES(1138,'TIPO 1137');
INSERT INTO "tipo_documento" VALUES(1139,'TIPO 1138');
INSERT INTO "tipo_documento" VALUES(1140,'TIPO 1139');
INSERT INTO "tipo_documento" VALUES(1141,'TIPO 1140');
INSERT INTO "tipo_documento" VALUES(1142,'TIPO 1141');
INSERT INTO "tipo_documento" VALUES(1143,'TIPO 1142');
INSERT INTO "tipo_documento" VALUES(1144,'TIPO 1143');
INSERT INTO "tipo_documento" VALUES(1145,'TIPO 1144');
INSERT INTO "tipo_documento" VALUES(1146,'TIPO 1145');
INSERT INTO "tipo_documento" VALUES(1147,'TIPO 1146');
INSERT INTO "tipo_documento" VALUES(1148,'TIPO 1147');
INSERT INTO "tipo_documento" VALUES(1149,'TIPO 1148');
INSERT INTO "tipo_documento" VALUES(1150,'TIPO 1149');
INSERT INTO "tipo_documento" VALUES(1151,'TIPO 1150');
INSERT INTO "tipo_documento" VALUES(1152,'TIPO 1151');
INSERT INTO "tipo_documento" VALUES(1153,'TIPO 1152');
INSERT INTO "tipo_documento" VALUES(1154,'TIPO 1153');
INSERT INTO "tipo_documento" VALUES(1155,'TIPO 1154');
INSERT INTO "tipo_documento" VALUES(1156,'TIPO 1155');
INSERT INTO "tipo_documento" VALUES(1157,'TIPO 1156');
INSERT INTO "tipo_documento" VALUES(1158,'TIPO 1157');
INSERT INTO "tipo_documento" VALUES(1159,'TIPO 1158');
INSERT INTO "tipo_documento" VALUES(1160,'TIPO 1159');
INSERT INTO "tipo_documento" VALUES(1161,'TIPO 1160');
INSERT INTO "tipo_documento" VALUES(1162,'TIPO 1161');
INSERT INTO "tipo_documento" VALUES(1163,'TIPO 1162');
INSERT INTO "tipo_documento" VALUES(1164,'TIPO 1163');
INSERT INTO "tipo_documento" VALUES(1165,'TIPO 1164');
INSERT INTO "tipo_documento" VALUES(1166,'TIPO 1165');
INSERT INTO "tipo_documento" VALUES(1167,'TIPO 1166');
INSERT INTO "tipo_documento" VALUES(1168,'TIPO 1167');
INSERT INTO "tipo_documento" VALUES(1169,'TIPO 1168');
INSERT INTO "tipo_documento" VALUES(1170,'TIPO 1169');
INSERT INTO "tipo_documento" VALUES(1171,'TIPO 1170');
INSERT INTO "tipo_documento" VALUES(1172,'TIPO 1171');
INSERT INTO "tipo_documento" VALUES(1173,'TIPO 1172');
INSERT INTO "tipo_documento" VALUES(1174,'TIPO 1173');
INSERT INTO "tipo_documento" VALUES(1175,'TIPO 1174');
INSERT INTO "tipo_documento" VALUES(1176,'TIPO 1175');
INSERT INTO "tipo_documento" VALUES(1177,'TIPO 1176');
INSERT INTO "tipo_documento" VALUES(1178,'TIPO 1177');
INSERT INTO "tipo_documento" VALUES(1179,'TIPO 1178');
INSERT INTO "tipo_documento" VALUES(1180,'TIPO 1179');
INSERT INTO "tipo_documento" VALUES(1181,'TIPO 1180');
INSERT INTO "tipo_documento" VALUES(1182,'TIPO 1181');
INSERT INTO "tipo_documento" VALUES(1183,'TIPO 1182');
INSERT INTO "tipo_documento" VALUES(1184,'TIPO 1183');
INSERT INTO "tipo_documento" VALUES(1185,'TIPO 1184');
INSERT INTO "tipo_documento" VALUES(1186,'TIPO 1185');
INSERT INTO "tipo_documento" VALUES(1187,'TIPO 1186');
INSERT INTO "tipo_documento" VALUES(1188,'TIPO 1187');
INSERT INTO "tipo_documento" VALUES(1189,'TIPO 1188');
INSERT INTO "tipo_documento" VALUES(1190,'TIPO 1189');
INSERT INTO "tipo_documento" VALUES(1191,'TIPO 1190');
INSERT INTO "tipo_documento" VALUES(1192,'TIPO 1191');
INSERT INTO "tipo_documento" VALUES(1193,'TIPO 1192');
INSERT INTO "tipo_documento" VALUES(1194,'TIPO 1193');
INSERT INTO "tipo_documento" VALUES(1195,'TIPO 1194');
INSERT INTO "tipo_documento" VALUES(1196,'TIPO 1195');
INSERT INTO "tipo_documento" VALUES(1197,'TIPO 1196');
INSERT INTO "tipo_documento" VALUES(1198,'TIPO 1197');
INSERT INTO "tipo_documento" VALUES(1199,'TIPO 1198');
INSERT INTO "tipo_documento" VALUES(1200,'TIPO 1199');
INSERT INTO "tipo_documento" VALUES(1201,'TIPO 1200');
INSERT INTO "tipo_documento" VALUES(1202,'TIPO 1201');
INSERT INTO "tipo_documento" VALUES(1203,'TIPO 1202');
INSERT INTO "tipo_documento" VALUES(1204,'TIPO 1203');
INSERT INTO "tipo_documento" VALUES(1205,'TIPO 1204');
INSERT INTO "tipo_documento" VALUES(1206,'TIPO 1205');
INSERT INTO "tipo_documento" VALUES(1207,'TIPO 1206');
INSERT INTO "tipo_documento" VALUES(1208,'TIPO 1207');
INSERT INTO "tipo_documento" VALUES(1209,'TIPO 1208');
INSERT INTO "tipo_documento" VALUES(1210,'TIPO 1209');
INSERT INTO "tipo_documento" VALUES(1211,'TIPO 1210');
INSERT INTO "tipo_documento" VALUES(1212,'TIPO 1211');
INSERT INTO "tipo_documento" VALUES(1213,'TIPO 1212');
INSERT INTO "tipo_documento" VALUES(1214,'TIPO 1213');
INSERT INTO "tipo_documento" VALUES(1215,'TIPO 1214');
INSERT INTO "tipo_documento" VALUES(1216,'TIPO 1215');
INSERT INTO "tipo_documento" VALUES(1217,'TIPO 1216');
INSERT INTO "tipo_documento" VALUES(1218,'TIPO 1217');
INSERT INTO "tipo_documento" VALUES(1219,'TIPO 1218');
INSERT INTO "tipo_documento" VALUES(1220,'TIPO 1219');
INSERT INTO "tipo_documento" VALUES(1221,'TIPO 1220');
INSERT INTO "tipo_documento" VALUES(1222,'TIPO 1221');
INSERT INTO "tipo_documento" VALUES(1223,'TIPO 1222');
INSERT INTO "tipo_documento" VALUES(1224,'TIPO 1223');
INSERT INTO "tipo_documento" VALUES(1225,'TIPO 1224');
INSERT INTO "tipo_documento" VALUES(1226,'TIPO 1225');
INSERT INTO "tipo_documento" VALUES(1227,'TIPO 1226');
INSERT INTO "tipo_documento" VALUES(1228,'TIPO 1227');
INSERT INTO "tipo_documento" VALUES(1229,'TIPO 1228');
INSERT INTO "tipo_documento" VALUES(1230,'TIPO 1229');
INSERT INTO "tipo_documento" VALUES(1231,'TIPO 1230');
INSERT INTO "tipo_documento" VALUES(1232,'TIPO 1231');
INSERT INTO "tipo_documento" VALUES(1233,'TIPO 1232');
INSERT INTO "tipo_documento" VALUES(1234,'TIPO 1233');
INSERT INTO "tipo_documento" VALUES(1235,'TIPO 1234');
INSERT INTO "tipo_documento" VALUES(1236,'TIPO 1235');
INSERT INTO "tipo_documento" VALUES(1237,'TIPO 1236');
INSERT INTO "tipo_documento" VALUES(1238,'TIPO 1237');
INSERT INTO "tipo_documento" VALUES(1239,'TIPO 1238');
INSERT INTO "tipo_documento" VALUES(1240,'TIPO 1239');
INSERT INTO "tipo_documento" VALUES(1241,'TIPO 1240');
INSERT INTO "tipo_documento" VALUES(1242,'TIPO 1241');
INSERT INTO "tipo_documento" VALUES(1243,'TIPO 1242');
INSERT INTO "tipo_documento" VALUES(1244,'TIPO 1243');
INSERT INTO "tipo_documento" VALUES(1245,'TIPO 1244');
INSERT INTO "tipo_documento" VALUES(1246,'TIPO 1245');
INSERT INTO "tipo_documento" VALUES(1247,'TIPO 1246');
INSERT INTO "tipo_documento" VALUES(1248,'TIPO 1247');
INSERT INTO "tipo_documento" VALUES(1249,'TIPO 1248');
INSERT INTO "tipo_documento" VALUES(1250,'TIPO 1249');
INSERT INTO "tipo_documento" VALUES(1251,'TIPO 1250');
INSERT INTO "tipo_documento" VALUES(1252,'TIPO 1251');
INSERT INTO "tipo_documento" VALUES(1253,'TIPO 1252');
INSERT INTO "tipo_documento" VALUES(1254,'TIPO 1253');
INSERT INTO "tipo_documento" VALUES(1255,'TIPO 1254');
INSERT INTO "tipo_documento" VALUES(1256,'TIPO 1255');
INSERT INTO "tipo_documento" VALUES(1257,'TIPO 1256');
INSERT INTO "tipo_documento" VALUES(1258,'TIPO 1257');
INSERT INTO "tipo_documento" VALUES(1259,'TIPO 1258');
INSERT INTO "tipo_documento" VALUES(1260,'TIPO 1259');
INSERT INTO "tipo_documento" VALUES(1261,'TIPO 1260');
INSERT INTO "tipo_documento" VALUES(1262,'TIPO 1261');
INSERT INTO "tipo_documento" VALUES(1263,'TIPO 1262');
INSERT INTO "tipo_documento" VALUES(1264,'TIPO 1263');
INSERT INTO "tipo_documento" VALUES(1265,'TIPO 1264');
INSERT INTO "tipo_documento" VALUES(1266,'TIPO 1265');
INSERT INTO "tipo_documento" VALUES(1267,'TIPO 1266');
INSERT INTO "tipo_documento" VALUES(1268,'TIPO 1267');
INSERT INTO "tipo_documento" VALUES(1269,'TIPO 1268');
INSERT INTO "tipo_documento" VALUES(1270,'TIPO 1269');
INSERT INTO "tipo_documento" VALUES(1271,'TIPO 1270');
INSERT INTO "tipo_documento" VALUES(1272,'TIPO 1271');
INSERT INTO "tipo_documento" VALUES(1273,'TIPO 1272');
INSERT INTO "tipo_documento" VALUES(1274,'TIPO 1273');
INSERT INTO "tipo_documento" VALUES(1275,'TIPO 1274');
INSERT INTO "tipo_documento" VALUES(1276,'TIPO 1275');
INSERT INTO "tipo_documento" VALUES(1277,'TIPO 1276');
INSERT INTO "tipo_documento" VALUES(1278,'TIPO 1277');
INSERT INTO "tipo_documento" VALUES(1279,'TIPO 1278');
INSERT INTO "tipo_documento" VALUES(1280,'TIPO 1279');
INSERT INTO "tipo_documento" VALUES(1281,'TIPO 1280');
INSERT INTO "tipo_documento" VALUES(1282,'TIPO 1281');
INSERT INTO "tipo_documento" VALUES(1283,'TIPO 1282');
INSERT INTO "tipo_documento" VALUES(1284,'TIPO 1283');
INSERT INTO "tipo_documento" VALUES(1285,'TIPO 1284');
INSERT INTO "tipo_documento" VALUES(1286,'TIPO 1285');
INSERT INTO "tipo_documento" VALUES(1287,'TIPO 1286');
INSERT INTO "tipo_documento" VALUES(1288,'TIPO 1287');
INSERT INTO "tipo_documento" VALUES(1289,'TIPO 1288');
INSERT INTO "tipo_documento" VALUES(1290,'TIPO 1289');
INSERT INTO "tipo_documento" VALUES(1291,'TIPO 1290');
INSERT INTO "tipo_documento" VALUES(1292,'TIPO 1291');
INSERT INTO "tipo_documento" VALUES(1293,'TIPO 1292');
INSERT INTO "tipo_documento" VALUES(1294,'TIPO 1293');
INSERT INTO "tipo_documento" VALUES(1295,'TIPO 1294');
INSERT INTO "tipo_documento" VALUES(1296,'TIPO 1295');
INSERT INTO "tipo_documento" VALUES(1297,'TIPO 1296');
INSERT INTO "tipo_documento" VALUES(1298,'TIPO 1297');
INSERT INTO "tipo_documento" VALUES(1299,'TIPO 1298');
INSERT INTO "tipo_documento" VALUES(1300,'TIPO 1299');
INSERT INTO "tipo_documento" VALUES(1301,'TIPO 1300');
INSERT INTO "tipo_documento" VALUES(1302,'TIPO 1301');
INSERT INTO "tipo_documento" VALUES(1303,'TIPO 1302');
INSERT INTO "tipo_documento" VALUES(1304,'TIPO 1303');
INSERT INTO "tipo_documento" VALUES(1305,'TIPO 1304');
INSERT INTO "tipo_documento" VALUES(1306,'TIPO 1305');
INSERT INTO "tipo_documento" VALUES(1307,'TIPO 1306');
INSERT INTO "tipo_documento" VALUES(1308,'TIPO 1307');
INSERT INTO "tipo_documento" VALUES(1309,'TIPO 1308');
INSERT INTO "tipo_documento" VALUES(1310,'TIPO 1309');
INSERT INTO "tipo_documento" VALUES(1311,'TIPO 1310');
INSERT INTO "tipo_documento" VALUES(1312,'TIPO 1311');
INSERT INTO "tipo_documento" VALUES(1313,'TIPO 1312');
INSERT INTO "tipo_documento" VALUES(1314,'TIPO 1313');
INSERT INTO "tipo_documento" VALUES(1315,'TIPO 1314');
INSERT INTO "tipo_documento" VALUES(1316,'TIPO 1315');
INSERT INTO "tipo_documento" VALUES(1317,'TIPO 1316');
INSERT INTO "tipo_documento" VALUES(1318,'TIPO 1317');
INSERT INTO "tipo_documento" VALUES(1319,'TIPO 1318');
INSERT INTO "tipo_documento" VALUES(1320,'TIPO 1319');
INSERT INTO "tipo_documento" VALUES(1321,'TIPO 1320');
INSERT INTO "tipo_documento" VALUES(1322,'TIPO 1321');
INSERT INTO "tipo_documento" VALUES(1323,'TIPO 1322');
INSERT INTO "tipo_documento" VALUES(1324,'TIPO 1323');
INSERT INTO "tipo_documento" VALUES(1325,'TIPO 1324');
INSERT INTO "tipo_documento" VALUES(1326,'TIPO 1325');
INSERT INTO "tipo_documento" VALUES(1327,'TIPO 1326');
INSERT INTO "tipo_documento" VALUES(1328,'TIPO 1327');
INSERT INTO "tipo_documento" VALUES(1329,'TIPO 1328');
INSERT INTO "tipo_documento" VALUES(1330,'TIPO 1329');
INSERT INTO "tipo_documento" VALUES(1331,'TIPO 1330');
INSERT INTO "tipo_documento" VALUES(1332,'TIPO 1331');
INSERT INTO "tipo_documento" VALUES(1333,'TIPO 1332');
INSERT INTO "tipo_documento" VALUES(1334,'TIPO 1333');
INSERT INTO "tipo_documento" VALUES(1335,'TIPO 1334');
INSERT INTO "tipo_documento" VALUES(1336,'TIPO 1335');
INSERT INTO "tipo_documento" VALUES(1337,'TIPO 1336');
INSERT INTO "tipo_documento" VALUES(1338,'TIPO 1337');
INSERT INTO "tipo_documento" VALUES(1339,'TIPO 1338');
INSERT INTO "tipo_documento" VALUES(1340,'TIPO 1339');
INSERT INTO "tipo_documento" VALUES(1341,'TIPO 1340');
INSERT INTO "tipo_documento" VALUES(1342,'TIPO 1341');
INSERT INTO "tipo_documento" VALUES(1343,'TIPO 1342');
INSERT INTO "tipo_documento" VALUES(1344,'TIPO 1343');
INSERT INTO "tipo_documento" VALUES(1345,'TIPO 1344');
INSERT INTO "tipo_documento" VALUES(1346,'TIPO 1345');
INSERT INTO "tipo_documento" VALUES(1347,'TIPO 1346');
INSERT INTO "tipo_documento" VALUES(1348,'TIPO 1347');
INSERT INTO "tipo_documento" VALUES(1349,'TIPO 1348');
INSERT INTO "tipo_documento" VALUES(1350,'TIPO 1349');
INSERT INTO "tipo_documento" VALUES(1351,'TIPO 1350');
INSERT INTO "tipo_documento" VALUES(1352,'TIPO 1351');
INSERT INTO "tipo_documento" VALUES(1353,'TIPO 1352');
INSERT INTO "tipo_documento" VALUES(1354,'TIPO 1353');
INSERT INTO "tipo_documento" VALUES(1355,'TIPO 1354');
INSERT INTO "tipo_documento" VALUES(1356,'TIPO 1355');
INSERT INTO "tipo_documento" VALUES(1357,'TIPO 1356');
INSERT INTO "tipo_documento" VALUES(1358,'TIPO 1357');
INSERT INTO "tipo_documento" VALUES(1359,'TIPO 1358');
INSERT INTO "tipo_documento" VALUES(1360,'TIPO 1359');
INSERT INTO "tipo_documento" VALUES(1361,'TIPO 1360');
INSERT INTO "tipo_documento" VALUES(1362,'TIPO 1361');
INSERT INTO "tipo_documento" VALUES(1363,'TIPO 1362');
INSERT INTO "tipo_documento" VALUES(1364,'TIPO 1363');
INSERT INTO "tipo_documento" VALUES(1365,'TIPO 1364');
INSERT INTO "tipo_documento" VALUES(1366,'TIPO 1365');
INSERT INTO "tipo_documento" VALUES(1367,'TIPO 1366');
INSERT INTO "tipo_documento" VALUES(1368,'TIPO 1367');
INSERT INTO "tipo_documento" VALUES(1369,'TIPO 1368');
INSERT INTO "tipo_documento" VALUES(1370,'TIPO 1369');
INSERT INTO "tipo_documento" VALUES(1371,'TIPO 1370');
INSERT INTO "tipo_documento" VALUES(1372,'TIPO 1371');
INSERT INTO "tipo_documento" VALUES(1373,'TIPO 1372');
INSERT INTO "tipo_documento" VALUES(1374,'TIPO 1373');
INSERT INTO "tipo_documento" VALUES(1375,'TIPO 1374');
INSERT INTO "tipo_documento" VALUES(1376,'TIPO 1375');
INSERT INTO "tipo_documento" VALUES(1377,'TIPO 1376');
INSERT INTO "tipo_documento" VALUES(1378,'TIPO 1377');
INSERT INTO "tipo_documento" VALUES(1379,'TIPO 1378');
INSERT INTO "tipo_documento" VALUES(1380,'TIPO 1379');
INSERT INTO "tipo_documento" VALUES(1381,'TIPO 1380');
INSERT INTO "tipo_documento" VALUES(1382,'TIPO 1381');
INSERT INTO "tipo_documento" VALUES(1383,'TIPO 1382');
INSERT INTO "tipo_documento" VALUES(1384,'TIPO 1383');
INSERT INTO "tipo_documento" VALUES(1385,'TIPO 1384');
INSERT INTO "tipo_documento" VALUES(1386,'TIPO 1385');
INSERT INTO "tipo_documento" VALUES(1387,'TIPO 1386');
INSERT INTO "tipo_documento" VALUES(1388,'TIPO 1387');
INSERT INTO "tipo_documento" VALUES(1389,'TIPO 1388');
INSERT INTO "tipo_documento" VALUES(1390,'TIPO 1389');
INSERT INTO "tipo_documento" VALUES(1391,'TIPO 1390');
INSERT INTO "tipo_documento" VALUES(1392,'TIPO 1391');
INSERT INTO "tipo_documento" VALUES(1393,'TIPO 1392');
INSERT INTO "tipo_documento" VALUES(1394,'TIPO 1393');
INSERT INTO "tipo_documento" VALUES(1395,'TIPO 1394');
INSERT INTO "tipo_documento" VALUES(1396,'TIPO 1395');
INSERT INTO "tipo_documento" VALUES(1397,'TIPO 1396');
INSERT INTO "tipo_documento" VALUES(1398,'TIPO 1397');
INSERT INTO "tipo_documento" VALUES(1399,'TIPO 1398');
INSERT INTO "tipo_documento" VALUES(1400,'TIPO 1399');
INSERT INTO "tipo_documento" VALUES(1401,'TIPO 1400');
INSERT INTO "tipo_documento" VALUES(1402,'TIPO 1401');
INSERT INTO "tipo_documento" VALUES(1403,'TIPO 1402');
INSERT INTO "tipo_documento" VALUES(1404,'TIPO 1403');
INSERT INTO "tipo_documento" VALUES(1405,'TIPO 1404');
INSERT INTO "tipo_documento" VALUES(1406,'TIPO 1405');
INSERT INTO "tipo_documento" VALUES(1407,'TIPO 1406');
INSERT INTO "tipo_documento" VALUES(1408,'TIPO 1407');
INSERT INTO "tipo_documento" VALUES(1409,'TIPO 1408');
INSERT INTO "tipo_documento" VALUES(1410,'TIPO 1409');
INSERT INTO "tipo_documento" VALUES(1411,'TIPO 1410');
INSERT INTO "tipo_documento" VALUES(1412,'TIPO 1411');
INSERT INTO "tipo_documento" VALUES(1413,'TIPO 1412');
INSERT INTO "tipo_documento" VALUES(1414,'TIPO 1413');
INSERT INTO "tipo_documento" VALUES(1415,'TIPO 1414');
INSERT INTO "tipo_documento" VALUES(1416,'TIPO 1415');
INSERT INTO "tipo_documento" VALUES(1417,'TIPO 1416');
INSERT INTO "tipo_documento" VALUES(1418,'TIPO 1417');
INSERT INTO "tipo_documento" VALUES(1419,'TIPO 1418');
INSERT INTO "tipo_documento" VALUES(1420,'TIPO 1419');
INSERT INTO "tipo_documento" VALUES(1421,'TIPO 1420');
INSERT INTO "tipo_documento" VALUES(1422,'TIPO 1421');
INSERT INTO "tipo_documento" VALUES(1423,'TIPO 1422');
INSERT INTO "tipo_documento" VALUES(1424,'TIPO 1423');
INSERT INTO "tipo_documento" VALUES(1425,'TIPO 1424');
INSERT INTO "tipo_documento" VALUES(1426,'TIPO 1425');
INSERT INTO "tipo_documento" VALUES(1427,'TIPO 1426');
INSERT INTO "tipo_documento" VALUES(1428,'TIPO 1427');
INSERT INTO "tipo_documento" VALUES(1429,'TIPO 1428');
INSERT INTO "tipo_documento" VALUES(1430,'TIPO 1429');
INSERT INTO "tipo_documento" VALUES(1431,'TIPO 1430');
INSERT INTO "tipo_documento" VALUES(1432,'TIPO 1431');
INSERT INTO "tipo_documento" VALUES(1433,'TIPO 1432');
INSERT INTO "tipo_documento" VALUES(1434,'TIPO 1433');
INSERT INTO "tipo_documento" VALUES(1435,'TIPO 1434');
INSERT INTO "tipo_documento" VALUES(1436,'TIPO 1435');
INSERT INTO "tipo_documento" VALUES(1437,'TIPO 1436');
INSERT INTO "tipo_documento" VALUES(1438,'TIPO 1437');
INSERT INTO "tipo_documento" VALUES(1439,'TIPO 1438');
INSERT INTO "tipo_documento" VALUES(1440,'TIPO 1439');
INSERT INTO "tipo_documento" VALUES(1441,'TIPO 1440');
INSERT INTO "tipo_documento" VALUES(1442,'TIPO 1441');
INSERT INTO "tipo_documento" VALUES(1443,'TIPO 1442');
INSERT INTO "tipo_documento" VALUES(1444,'TIPO 1443');
INSERT INTO "tipo_documento" VALUES(1445,'TIPO 1444');
INSERT INTO "tipo_documento" VALUES(1446,'TIPO 1445');
INSERT INTO "tipo_documento" VALUES(1447,'TIPO 1446');
INSERT INTO "tipo_documento" VALUES(1448,'TIPO 1447');
INSERT INTO "tipo_documento" VALUES(1449,'TIPO 1448');
INSERT INTO "tipo_documento" VALUES(1450,'TIPO 1449');
INSERT INTO "tipo_documento" VALUES(1451,'TIPO 1450');
INSERT INTO "tipo_documento" VALUES(1452,'TIPO 1451');
INSERT INTO "tipo_documento" VALUES(1453,'TIPO 1452');
INSERT INTO "tipo_documento" VALUES(1454,'TIPO 1453');
INSERT INTO "tipo_documento" VALUES(1455,'TIPO 1454');
INSERT INTO "tipo_documento" VALUES(1456,'TIPO 1455');
INSERT INTO "tipo_documento" VALUES(1457,'TIPO 1456');
INSERT INTO "tipo_documento" VALUES(1458,'TIPO 1457');
INSERT INTO "tipo_documento" VALUES(1459,'TIPO 1458');
INSERT INTO "tipo_documento" VALUES(1460,'TIPO 1459');
INSERT INTO "tipo_documento" VALUES(1461,'TIPO 1460');
INSERT INTO "tipo_documento" VALUES(1462,'TIPO 1461');
INSERT INTO "tipo_documento" VALUES(1463,'TIPO 1462');
INSERT INTO "tipo_documento" VALUES(1464,'TIPO 1463');
INSERT INTO "tipo_documento" VALUES(1465,'TIPO 1464');
INSERT INTO "tipo_documento" VALUES(1466,'TIPO 1465');
INSERT INTO "tipo_documento" VALUES(1467,'TIPO 1466');
INSERT INTO "tipo_documento" VALUES(1468,'TIPO 1467');
INSERT INTO "tipo_documento" VALUES(1469,'TIPO 1468');
INSERT INTO "tipo_documento" VALUES(1470,'TIPO 1469');
INSERT INTO "tipo_documento" VALUES(1471,'TIPO 1470');
INSERT INTO "tipo_documento" VALUES(1472,'TIPO 1471');
INSERT INTO "tipo_documento" VALUES(1473,'TIPO 1472');
INSERT INTO "tipo_documento" VALUES(1474,'TIPO 1473');
INSERT INTO "tipo_documento" VALUES(1475,'TIPO 1474');
INSERT INTO "tipo_documento" VALUES(1476,'TIPO 1475');
INSERT INTO "tipo_documento" VALUES(1477,'TIPO 1476');
INSERT INTO "tipo_documento" VALUES(1478,'TIPO 1477');
INSERT INTO "tipo_documento" VALUES(1479,'TIPO 1478');
INSERT INTO "tipo_documento" VALUES(1480,'TIPO 1479');
INSERT INTO "tipo_documento" VALUES(1481,'TIPO 1480');
INSERT INTO "tipo_documento" VALUES(1482,'TIPO 1481');
INSERT INTO "tipo_documento" VALUES(1483,'TIPO 1482');
INSERT INTO "tipo_documento" VALUES(1484,'TIPO 1483');
INSERT INTO "tipo_documento" VALUES(1485,'TIPO 1484');
INSERT INTO "tipo_documento" VALUES(1486,'TIPO 1485');
INSERT INTO "tipo_documento" VALUES(1487,'TIPO 1486');
INSERT INTO "tipo_documento" VALUES(1488,'TIPO 1487');
INSERT INTO "tipo_documento" VALUES(1489,'TIPO 1488');
INSERT INTO "tipo_documento" VALUES(1490,'TIPO 1489');
INSERT INTO "tipo_documento" VALUES(1491,'TIPO 1490');
INSERT INTO "tipo_documento" VALUES(1492,'TIPO 1491');
INSERT INTO "tipo_documento" VALUES(1493,'TIPO 1492');
INSERT INTO "tipo_documento" VALUES(1494,'TIPO 1493');
INSERT INTO "tipo_documento" VALUES(1495,'TIPO 1494');
INSERT INTO "tipo_documento" VALUES(1496,'TIPO 1495');
INSERT INTO "tipo_documento" VALUES(1497,'TIPO 1496');
INSERT INTO "tipo_documento" VALUES(1498,'TIPO 1497');
INSERT INTO "tipo_documento" VALUES(1499,'TIPO 1498');
INSERT INTO "tipo_documento" VALUES(1500,'TIPO 1499');
INSERT INTO "tipo_documento" VALUES(1501,'TIPO 1500');
INSERT INTO "tipo_documento" VALUES(1502,'TIPO 1501');
INSERT INTO "tipo_documento" VALUES(1503,'TIPO 1502');
INSERT INTO "tipo_documento" VALUES(1504,'TIPO 1503');
INSERT INTO "tipo_documento" VALUES(1505,'TIPO 1504');
INSERT INTO "tipo_documento" VALUES(1506,'TIPO 1505');
INSERT INTO "tipo_documento" VALUES(1507,'TIPO 1506');
INSERT INTO "tipo_documento" VALUES(1508,'TIPO 1507');
INSERT INTO "tipo_documento" VALUES(1509,'TIPO 1508');
INSERT INTO "tipo_documento" VALUES(1510,'TIPO 1509');
INSERT INTO "tipo_documento" VALUES(1511,'TIPO 1510');
INSERT INTO "tipo_documento" VALUES(1512,'TIPO 1511');
INSERT INTO "tipo_documento" VALUES(1513,'TIPO 1512');
INSERT INTO "tipo_documento" VALUES(1514,'TIPO 1513');
INSERT INTO "tipo_documento" VALUES(1515,'TIPO 1514');
INSERT INTO "tipo_documento" VALUES(1516,'TIPO 1515');
INSERT INTO "tipo_documento" VALUES(1517,'TIPO 1516');
INSERT INTO "tipo_documento" VALUES(1518,'TIPO 1517');
INSERT INTO "tipo_documento" VALUES(1519,'TIPO 1518');
INSERT INTO "tipo_documento" VALUES(1520,'TIPO 1519');
INSERT INTO "tipo_documento" VALUES(1521,'TIPO 1520');
INSERT INTO "tipo_documento" VALUES(1522,'TIPO 1521');
INSERT INTO "tipo_documento" VALUES(1523,'TIPO 1522');
INSERT INTO "tipo_documento" VALUES(1524,'TIPO 1523');
INSERT INTO "tipo_documento" VALUES(1525,'TIPO 1524');
INSERT INTO "tipo_documento" VALUES(1526,'TIPO 1525');
INSERT INTO "tipo_documento" VALUES(1527,'TIPO 1526');
INSERT INTO "tipo_documento" VALUES(1528,'TIPO 1527');
INSERT INTO "tipo_documento" VALUES(1529,'TIPO 1528');
INSERT INTO "tipo_documento" VALUES(1530,'TIPO 1529');
INSERT INTO "tipo_documento" VALUES(1531,'TIPO 1530');
INSERT INTO "tipo_documento" VALUES(1532,'TIPO 1531');
INSERT INTO "tipo_documento" VALUES(1533,'TIPO 1532');
INSERT INTO "tipo_documento" VALUES(1534,'TIPO 1533');
INSERT INTO "tipo_documento" VALUES(1535,'TIPO 1534');
INSERT INTO "tipo_documento" VALUES(1536,'TIPO 1535');
INSERT INTO "tipo_documento" VALUES(1537,'TIPO 1536');
INSERT INTO "tipo_documento" VALUES(1538,'TIPO 1537');
INSERT INTO "tipo_documento" VALUES(1539,'TIPO 1538');
INSERT INTO "tipo_documento" VALUES(1540,'TIPO 1539');
INSERT INTO "tipo_documento" VALUES(1541,'TIPO 1540');
INSERT INTO "tipo_documento" VALUES(1542,'TIPO 1541');
INSERT INTO "tipo_documento" VALUES(1543,'TIPO 1542');
INSERT INTO "tipo_documento" VALUES(1544,'TIPO 1543');
INSERT INTO "tipo_documento" VALUES(1545,'TIPO 1544');
INSERT INTO "tipo_documento" VALUES(1546,'TIPO 1545');
INSERT INTO "tipo_documento" VALUES(1547,'TIPO 1546');
INSERT INTO "tipo_documento" VALUES(1548,'TIPO 1547');
INSERT INTO "tipo_documento" VALUES(1549,'TIPO 1548');
INSERT INTO "tipo_documento" VALUES(1550,'TIPO 1549');
INSERT INTO "tipo_documento" VALUES(1551,'TIPO 1550');
INSERT INTO "tipo_documento" VALUES(1552,'TIPO 1551');
INSERT INTO "tipo_documento" VALUES(1553,'TIPO 1552');
INSERT INTO "tipo_documento" VALUES(1554,'TIPO 1553');
INSERT INTO "tipo_documento" VALUES(1555,'TIPO 1554');
INSERT INTO "tipo_documento" VALUES(1556,'TIPO 1555');
INSERT INTO "tipo_documento" VALUES(1557,'TIPO 1556');
INSERT INTO "tipo_documento" VALUES(1558,'TIPO 1557');
INSERT INTO "tipo_documento" VALUES(1559,'TIPO 1558');
INSERT INTO "tipo_documento" VALUES(1560,'TIPO 1559');
INSERT INTO "tipo_documento" VALUES(1561,'TIPO 1560');
INSERT INTO "tipo_documento" VALUES(1562,'TIPO 1561');
INSERT INTO "tipo_documento" VALUES(1563,'TIPO 1562');
INSERT INTO "tipo_documento" VALUES(1564,'TIPO 1563');
INSERT INTO "tipo_documento" VALUES(1565,'TIPO 1564');
INSERT INTO "tipo_documento" VALUES(1566,'TIPO 1565');
INSERT INTO "tipo_documento" VALUES(1567,'TIPO 1566');
INSERT INTO "tipo_documento" VALUES(1568,'TIPO 1567');
INSERT INTO "tipo_documento" VALUES(1569,'TIPO 1568');
INSERT INTO "tipo_documento" VALUES(1570,'TIPO 1569');
INSERT INTO "tipo_documento" VALUES(1571,'TIPO 1570');
INSERT INTO "tipo_documento" VALUES(1572,'TIPO 1571');
INSERT INTO "tipo_documento" VALUES(1573,'TIPO 1572');
INSERT INTO "tipo_documento" VALUES(1574,'TIPO 1573');
INSERT INTO "tipo_documento" VALUES(1575,'TIPO 1574');
INSERT INTO "tipo_documento" VALUES(1576,'TIPO 1575');
INSERT INTO "tipo_documento" VALUES(1577,'TIPO 1576');
INSERT INTO "tipo_documento" VALUES(1578,'TIPO 1577');
INSERT INTO "tipo_documento" VALUES(1579,'TIPO 1578');
INSERT INTO "tipo_documento" VALUES(1580,'TIPO 1579');
INSERT INTO "tipo_documento" VALUES(1581,'TIPO 1580');
INSERT INTO "tipo_documento" VALUES(1582,'TIPO 1581');
INSERT INTO "tipo_documento" VALUES(1583,'TIPO 1582');
INSERT INTO "tipo_documento" VALUES(1584,'TIPO 1583');
INSERT INTO "tipo_documento" VALUES(1585,'TIPO 1584');
INSERT INTO "tipo_documento" VALUES(1586,'TIPO 1585');
INSERT INTO "tipo_documento" VALUES(1587,'TIPO 1586');
INSERT INTO "tipo_documento" VALUES(1588,'TIPO 1587');
INSERT INTO "tipo_documento" VALUES(1589,'TIPO 1588');
INSERT INTO "tipo_documento" VALUES(1590,'TIPO 1589');
INSERT INTO "tipo_documento" VALUES(1591,'TIPO 1590');
INSERT INTO "tipo_documento" VALUES(1592,'TIPO 1591');
INSERT INTO "tipo_documento" VALUES(1593,'TIPO 1592');
INSERT INTO "tipo_documento" VALUES(1594,'TIPO 1593');
INSERT INTO "tipo_documento" VALUES(1595,'TIPO 1594');
INSERT INTO "tipo_documento" VALUES(1596,'TIPO 1595');
INSERT INTO "tipo_documento" VALUES(1597,'TIPO 1596');
INSERT INTO "tipo_documento" VALUES(1598,'TIPO 1597');
INSERT INTO "tipo_documento" VALUES(1599,'TIPO 1598');
INSERT INTO "tipo_documento" VALUES(1600,'TIPO 1599');
INSERT INTO "tipo_documento" VALUES(1601,'TIPO 1600');
INSERT INTO "tipo_documento" VALUES(1602,'TIPO 1601');
INSERT INTO "tipo_documento" VALUES(1603,'TIPO 1602');
INSERT INTO "tipo_documento" VALUES(1604,'TIPO 1603');
INSERT INTO "tipo_documento" VALUES(1605,'TIPO 1604');
INSERT INTO "tipo_documento" VALUES(1606,'TIPO 1605');
INSERT INTO "tipo_documento" VALUES(1607,'TIPO 1606');
INSERT INTO "tipo_documento" VALUES(1608,'TIPO 1607');
INSERT INTO "tipo_documento" VALUES(1609,'TIPO 1608');
INSERT INTO "tipo_documento" VALUES(1610,'TIPO 1609');
INSERT INTO "tipo_documento" VALUES(1611,'TIPO 1610');
INSERT INTO "tipo_documento" VALUES(1612,'TIPO 1611');
INSERT INTO "tipo_documento" VALUES(1613,'TIPO 1612');
INSERT INTO "tipo_documento" VALUES(1614,'TIPO 1613');
INSERT INTO "tipo_documento" VALUES(1615,'TIPO 1614');
INSERT INTO "tipo_documento" VALUES(1616,'TIPO 1615');
INSERT INTO "tipo_documento" VALUES(1617,'TIPO 1616');
INSERT INTO "tipo_documento" VALUES(1618,'TIPO 1617');
INSERT INTO "tipo_documento" VALUES(1619,'TIPO 1618');
INSERT INTO "tipo_documento" VALUES(1620,'TIPO 1619');
INSERT INTO "tipo_documento" VALUES(1621,'TIPO 1620');
INSERT INTO "tipo_documento" VALUES(1622,'TIPO 1621');
INSERT INTO "tipo_documento" VALUES(1623,'TIPO 1622');
INSERT INTO "tipo_documento" VALUES(1624,'TIPO 1623');
INSERT INTO "tipo_documento" VALUES(1625,'TIPO 1624');
INSERT INTO "tipo_documento" VALUES(1626,'TIPO 1625');
INSERT INTO "tipo_documento" VALUES(1627,'TIPO 1626');
INSERT INTO "tipo_documento" VALUES(1628,'TIPO 1627');
INSERT INTO "tipo_documento" VALUES(1629,'TIPO 1628');
INSERT INTO "tipo_documento" VALUES(1630,'TIPO 1629');
INSERT INTO "tipo_documento" VALUES(1631,'TIPO 1630');
INSERT INTO "tipo_documento" VALUES(1632,'TIPO 1631');
INSERT INTO "tipo_documento" VALUES(1633,'TIPO 1632');
INSERT INTO "tipo_documento" VALUES(1634,'TIPO 1633');
INSERT INTO "tipo_documento" VALUES(1635,'TIPO 1634');
INSERT INTO "tipo_documento" VALUES(1636,'TIPO 1635');
INSERT INTO "tipo_documento" VALUES(1637,'TIPO 1636');
INSERT INTO "tipo_documento" VALUES(1638,'TIPO 1637');
INSERT INTO "tipo_documento" VALUES(1639,'TIPO 1638');
INSERT INTO "tipo_documento" VALUES(1640,'TIPO 1639');
INSERT INTO "tipo_documento" VALUES(1641,'TIPO 1640');
INSERT INTO "tipo_documento" VALUES(1642,'TIPO 1641');
INSERT INTO "tipo_documento" VALUES(1643,'TIPO 1642');
INSERT INTO "tipo_documento" VALUES(1644,'TIPO 1643');
INSERT INTO "tipo_documento" VALUES(1645,'TIPO 1644');
INSERT INTO "tipo_documento" VALUES(1646,'TIPO 1645');
INSERT INTO "tipo_documento" VALUES(1647,'TIPO 1646');
INSERT INTO "tipo_documento" VALUES(1648,'TIPO 1647');
INSERT INTO "tipo_documento" VALUES(1649,'TIPO 1648');
INSERT INTO "tipo_documento" VALUES(1650,'TIPO 1649');
INSERT INTO "tipo_documento" VALUES(1651,'TIPO 1650');
INSERT INTO "tipo_documento" VALUES(1652,'TIPO 1651');
INSERT INTO "tipo_documento" VALUES(1653,'TIPO 1652');
INSERT INTO "tipo_documento" VALUES(1654,'TIPO 1653');
INSERT INTO "tipo_documento" VALUES(1655,'TIPO 1654');
INSERT INTO "tipo_documento" VALUES(1656,'TIPO 1655');
INSERT INTO "tipo_documento" VALUES(1657,'TIPO 1656');
INSERT INTO "tipo_documento" VALUES(1658,'TIPO 1657');
INSERT INTO "tipo_documento" VALUES(1659,'TIPO 1658');
INSERT INTO "tipo_documento" VALUES(1660,'TIPO 1659');
INSERT INTO "tipo_documento" VALUES(1661,'TIPO 1660');
INSERT INTO "tipo_documento" VALUES(1662,'TIPO 1661');
INSERT INTO "tipo_documento" VALUES(1663,'TIPO 1662');
INSERT INTO "tipo_documento" VALUES(1664,'TIPO 1663');
INSERT INTO "tipo_documento" VALUES(1665,'TIPO 1664');
INSERT INTO "tipo_documento" VALUES(1666,'TIPO 1665');
INSERT INTO "tipo_documento" VALUES(1667,'TIPO 1666');
INSERT INTO "tipo_documento" VALUES(1668,'TIPO 1667');
INSERT INTO "tipo_documento" VALUES(1669,'TIPO 1668');
INSERT INTO "tipo_documento" VALUES(1670,'TIPO 1669');
INSERT INTO "tipo_documento" VALUES(1671,'TIPO 1670');
INSERT INTO "tipo_documento" VALUES(1672,'TIPO 1671');
INSERT INTO "tipo_documento" VALUES(1673,'TIPO 1672');
INSERT INTO "tipo_documento" VALUES(1674,'TIPO 1673');
INSERT INTO "tipo_documento" VALUES(1675,'TIPO 1674');
INSERT INTO "tipo_documento" VALUES(1676,'TIPO 1675');
INSERT INTO "tipo_documento" VALUES(1677,'TIPO 1676');
INSERT INTO "tipo_documento" VALUES(1678,'TIPO 1677');
INSERT INTO "tipo_documento" VALUES(1679,'TIPO 1678');
INSERT INTO "tipo_documento" VALUES(1680,'TIPO 1679');
INSERT INTO "tipo_documento" VALUES(1681,'TIPO 1680');
INSERT INTO "tipo_documento" VALUES(1682,'TIPO 1681');
INSERT INTO "tipo_documento" VALUES(1683,'TIPO 1682');
INSERT INTO "tipo_documento" VALUES(1684,'TIPO 1683');
INSERT INTO "tipo_documento" VALUES(1685,'TIPO 1684');
INSERT INTO "tipo_documento" VALUES(1686,'TIPO 1685');
INSERT INTO "tipo_documento" VALUES(1687,'TIPO 1686');
INSERT INTO "tipo_documento" VALUES(1688,'TIPO 1687');
INSERT INTO "tipo_documento" VALUES(1689,'TIPO 1688');
INSERT INTO "tipo_documento" VALUES(1690,'TIPO 1689');
INSERT INTO "tipo_documento" VALUES(1691,'TIPO 1690');
INSERT INTO "tipo_documento" VALUES(1692,'TIPO 1691');
INSERT INTO "tipo_documento" VALUES(1693,'TIPO 1692');
INSERT INTO "tipo_documento" VALUES(1694,'TIPO 1693');
INSERT INTO "tipo_documento" VALUES(1695,'TIPO 1694');
INSERT INTO "tipo_documento" VALUES(1696,'TIPO 1695');
INSERT INTO "tipo_documento" VALUES(1697,'TIPO 1696');
INSERT INTO "tipo_documento" VALUES(1698,'TIPO 1697');
INSERT INTO "tipo_documento" VALUES(1699,'TIPO 1698');
INSERT INTO "tipo_documento" VALUES(1700,'TIPO 1699');
INSERT INTO "tipo_documento" VALUES(1701,'TIPO 1700');
INSERT INTO "tipo_documento" VALUES(1702,'TIPO 1701');
INSERT INTO "tipo_documento" VALUES(1703,'TIPO 1702');
INSERT INTO "tipo_documento" VALUES(1704,'TIPO 1703');
INSERT INTO "tipo_documento" VALUES(1705,'TIPO 1704');
INSERT INTO "tipo_documento" VALUES(1706,'TIPO 1705');
INSERT INTO "tipo_documento" VALUES(1707,'TIPO 1706');
INSERT INTO "tipo_documento" VALUES(1708,'TIPO 1707');
INSERT INTO "tipo_documento" VALUES(1709,'TIPO 1708');
INSERT INTO "tipo_documento" VALUES(1710,'TIPO 1709');
INSERT INTO "tipo_documento" VALUES(1711,'TIPO 1710');
INSERT INTO "tipo_documento" VALUES(1712,'TIPO 1711');
INSERT INTO "tipo_documento" VALUES(1713,'TIPO 1712');
INSERT INTO "tipo_documento" VALUES(1714,'TIPO 1713');
INSERT INTO "tipo_documento" VALUES(1715,'TIPO 1714');
INSERT INTO "tipo_documento" VALUES(1716,'TIPO 1715');
INSERT INTO "tipo_documento" VALUES(1717,'TIPO 1716');
INSERT INTO "tipo_documento" VALUES(1718,'TIPO 1717');
INSERT INTO "tipo_documento" VALUES(1719,'TIPO 1718');
INSERT INTO "tipo_documento" VALUES(1720,'TIPO 1719');
INSERT INTO "tipo_documento" VALUES(1721,'TIPO 1720');
INSERT INTO "tipo_documento" VALUES(1722,'TIPO 1721');
INSERT INTO "tipo_documento" VALUES(1723,'TIPO 1722');
INSERT INTO "tipo_documento" VALUES(1724,'TIPO 1723');
INSERT INTO "tipo_documento" VALUES(1725,'TIPO 1724');
INSERT INTO "tipo_documento" VALUES(1726,'TIPO 1725');
INSERT INTO "tipo_documento" VALUES(1727,'TIPO 1726');
INSERT INTO "tipo_documento" VALUES(1728,'TIPO 1727');
INSERT INTO "tipo_documento" VALUES(1729,'TIPO 1728');
INSERT INTO "tipo_documento" VALUES(1730,'TIPO 1729');
INSERT INTO "tipo_documento" VALUES(1731,'TIPO 1730');
INSERT INTO "tipo_documento" VALUES(1732,'TIPO 1731');
INSERT INTO "tipo_documento" VALUES(1733,'TIPO 1732');
INSERT INTO "tipo_documento" VALUES(1734,'TIPO 1733');
INSERT INTO "tipo_documento" VALUES(1735,'TIPO 1734');
INSERT INTO "tipo_documento" VALUES(1736,'TIPO 1735');
INSERT INTO "tipo_documento" VALUES(1737,'TIPO 1736');
INSERT INTO "tipo_documento" VALUES(1738,'TIPO 1737');
INSERT INTO "tipo_documento" VALUES(1739,'TIPO 1738');
INSERT INTO "tipo_documento" VALUES(1740,'TIPO 1739');
INSERT INTO "tipo_documento" VALUES(1741,'TIPO 1740');
INSERT INTO "tipo_documento" VALUES(1742,'TIPO 1741');
INSERT INTO "tipo_documento" VALUES(1743,'TIPO 1742');
INSERT INTO "tipo_documento" VALUES(1744,'TIPO 1743');
INSERT INTO "tipo_documento" VALUES(1745,'TIPO 1744');
INSERT INTO "tipo_documento" VALUES(1746,'TIPO 1745');
INSERT INTO "tipo_documento" VALUES(1747,'TIPO 1746');
INSERT INTO "tipo_documento" VALUES(1748,'TIPO 1747');
INSERT INTO "tipo_documento" VALUES(1749,'TIPO 1748');
INSERT INTO "tipo_documento" VALUES(1750,'TIPO 1749');
INSERT INTO "tipo_documento" VALUES(1751,'TIPO 1750');
INSERT INTO "tipo_documento" VALUES(1752,'TIPO 1751');
INSERT INTO "tipo_documento" VALUES(1753,'TIPO 1752');
INSERT INTO "tipo_documento" VALUES(1754,'TIPO 1753');
INSERT INTO "tipo_documento" VALUES(1755,'TIPO 1754');
INSERT INTO "tipo_documento" VALUES(1756,'TIPO 1755');
INSERT INTO "tipo_documento" VALUES(1757,'TIPO 1756');
INSERT INTO "tipo_documento" VALUES(1758,'TIPO 1757');
INSERT INTO "tipo_documento" VALUES(1759,'TIPO 1758');
INSERT INTO "tipo_documento" VALUES(1760,'TIPO 1759');
INSERT INTO "tipo_documento" VALUES(1761,'TIPO 1760');
INSERT INTO "tipo_documento" VALUES(1762,'TIPO 1761');
INSERT INTO "tipo_documento" VALUES(1763,'TIPO 1762');
INSERT INTO "tipo_documento" VALUES(1764,'TIPO 1763');
INSERT INTO "tipo_documento" VALUES(1765,'TIPO 1764');
INSERT INTO "tipo_documento" VALUES(1766,'TIPO 1765');
INSERT INTO "tipo_documento" VALUES(1767,'TIPO 1766');
INSERT INTO "tipo_documento" VALUES(1768,'TIPO 1767');
INSERT INTO "tipo_documento" VALUES(1769,'TIPO 1768');
INSERT INTO "tipo_documento" VALUES(1770,'TIPO 1769');
INSERT INTO "tipo_documento" VALUES(1771,'TIPO 1770');
INSERT INTO "tipo_documento" VALUES(1772,'TIPO 1771');
INSERT INTO "tipo_documento" VALUES(1773,'TIPO 1772');
INSERT INTO "tipo_documento" VALUES(1774,'TIPO 1773');
INSERT INTO "tipo_documento" VALUES(1775,'TIPO 1774');
INSERT INTO "tipo_documento" VALUES(1776,'TIPO 1775');
INSERT INTO "tipo_documento" VALUES(1777,'TIPO 1776');
INSERT INTO "tipo_documento" VALUES(1778,'TIPO 1777');
INSERT INTO "tipo_documento" VALUES(1779,'TIPO 1778');
INSERT INTO "tipo_documento" VALUES(1780,'TIPO 1779');
INSERT INTO "tipo_documento" VALUES(1781,'TIPO 1780');
INSERT INTO "tipo_documento" VALUES(1782,'TIPO 1781');
INSERT INTO "tipo_documento" VALUES(1783,'TIPO 1782');
INSERT INTO "tipo_documento" VALUES(1784,'TIPO 1783');
INSERT INTO "tipo_documento" VALUES(1785,'TIPO 1784');
INSERT INTO "tipo_documento" VALUES(1786,'TIPO 1785');
INSERT INTO "tipo_documento" VALUES(1787,'TIPO 1786');
INSERT INTO "tipo_documento" VALUES(1788,'TIPO 1787');
INSERT INTO "tipo_documento" VALUES(1789,'TIPO 1788');
INSERT INTO "tipo_documento" VALUES(1790,'TIPO 1789');
INSERT INTO "tipo_documento" VALUES(1791,'TIPO 1790');
INSERT INTO "tipo_documento" VALUES(1792,'TIPO 1791');
INSERT INTO "tipo_documento" VALUES(1793,'TIPO 1792');
INSERT INTO "tipo_documento" VALUES(1794,'TIPO 1793');
INSERT INTO "tipo_documento" VALUES(1795,'TIPO 1794');
INSERT INTO "tipo_documento" VALUES(1796,'TIPO 1795');
INSERT INTO "tipo_documento" VALUES(1797,'TIPO 1796');
INSERT INTO "tipo_documento" VALUES(1798,'TIPO 1797');
INSERT INTO "tipo_documento" VALUES(1799,'TIPO 1798');
INSERT INTO "tipo_documento" VALUES(1800,'TIPO 1799');
INSERT INTO "tipo_documento" VALUES(1801,'TIPO 1800');
INSERT INTO "tipo_documento" VALUES(1802,'TIPO 1801');
INSERT INTO "tipo_documento" VALUES(1803,'TIPO 1802');
INSERT INTO "tipo_documento" VALUES(1804,'TIPO 1803');
INSERT INTO "tipo_documento" VALUES(1805,'TIPO 1804');
INSERT INTO "tipo_documento" VALUES(1806,'TIPO 1805');
INSERT INTO "tipo_documento" VALUES(1807,'TIPO 1806');
INSERT INTO "tipo_documento" VALUES(1808,'TIPO 1807');
INSERT INTO "tipo_documento" VALUES(1809,'TIPO 1808');
INSERT INTO "tipo_documento" VALUES(1810,'TIPO 1809');
INSERT INTO "tipo_documento" VALUES(1811,'TIPO 1810');
INSERT INTO "tipo_documento" VALUES(1812,'TIPO 1811');
INSERT INTO "tipo_documento" VALUES(1813,'TIPO 1812');
INSERT INTO "tipo_documento" VALUES(1814,'TIPO 1813');
INSERT INTO "tipo_documento" VALUES(1815,'TIPO 1814');
INSERT INTO "tipo_documento" VALUES(1816,'TIPO 1815');
INSERT INTO "tipo_documento" VALUES(1817,'TIPO 1816');
INSERT INTO "tipo_documento" VALUES(1818,'TIPO 1817');
INSERT INTO "tipo_documento" VALUES(1819,'TIPO 1818');
INSERT INTO "tipo_documento" VALUES(1820,'TIPO 1819');
INSERT INTO "tipo_documento" VALUES(1821,'TIPO 1820');
INSERT INTO "tipo_documento" VALUES(1822,'TIPO 1821');
INSERT INTO "tipo_documento" VALUES(1823,'TIPO 1822');
INSERT INTO "tipo_documento" VALUES(1824,'TIPO 1823');
INSERT INTO "tipo_documento" VALUES(1825,'TIPO 1824');
INSERT INTO "tipo_documento" VALUES(1826,'TIPO 1825');
INSERT INTO "tipo_documento" VALUES(1827,'TIPO 1826');
INSERT INTO "tipo_documento" VALUES(1828,'TIPO 1827');
INSERT INTO "tipo_documento" VALUES(1829,'TIPO 1828');
INSERT INTO "tipo_documento" VALUES(1830,'TIPO 1829');
INSERT INTO "tipo_documento" VALUES(1831,'TIPO 1830');
INSERT INTO "tipo_documento" VALUES(1832,'TIPO 1831');
INSERT INTO "tipo_documento" VALUES(1833,'TIPO 1832');
INSERT INTO "tipo_documento" VALUES(1834,'TIPO 1833');
INSERT INTO "tipo_documento" VALUES(1835,'TIPO 1834');
INSERT INTO "tipo_documento" VALUES(1836,'TIPO 1835');
INSERT INTO "tipo_documento" VALUES(1837,'TIPO 1836');
INSERT INTO "tipo_documento" VALUES(1838,'TIPO 1837');
INSERT INTO "tipo_documento" VALUES(1839,'TIPO 1838');
INSERT INTO "tipo_documento" VALUES(1840,'TIPO 1839');
INSERT INTO "tipo_documento" VALUES(1841,'TIPO 1840');
INSERT INTO "tipo_documento" VALUES(1842,'TIPO 1841');
INSERT INTO "tipo_documento" VALUES(1843,'TIPO 1842');
INSERT INTO "tipo_documento" VALUES(1844,'TIPO 1843');
INSERT INTO "tipo_documento" VALUES(1845,'TIPO 1844');
INSERT INTO "tipo_documento" VALUES(1846,'TIPO 1845');
INSERT INTO "tipo_documento" VALUES(1847,'TIPO 1846');
INSERT INTO "tipo_documento" VALUES(1848,'TIPO 1847');
INSERT INTO "tipo_documento" VALUES(1849,'TIPO 1848');
INSERT INTO "tipo_documento" VALUES(1850,'TIPO 1849');
INSERT INTO "tipo_documento" VALUES(1851,'TIPO 1850');
INSERT INTO "tipo_documento" VALUES(1852,'TIPO 1851');
INSERT INTO "tipo_documento" VALUES(1853,'TIPO 1852');
INSERT INTO "tipo_documento" VALUES(1854,'TIPO 1853');
INSERT INTO "tipo_documento" VALUES(1855,'TIPO 1854');
INSERT INTO "tipo_documento" VALUES(1856,'TIPO 1855');
INSERT INTO "tipo_documento" VALUES(1857,'TIPO 1856');
INSERT INTO "tipo_documento" VALUES(1858,'TIPO 1857');
INSERT INTO "tipo_documento" VALUES(1859,'TIPO 1858');
INSERT INTO "tipo_documento" VALUES(1860,'TIPO 1859');
INSERT INTO "tipo_documento" VALUES(1861,'TIPO 1860');
INSERT INTO "tipo_documento" VALUES(1862,'TIPO 1861');
INSERT INTO "tipo_documento" VALUES(1863,'TIPO 1862');
INSERT INTO "tipo_documento" VALUES(1864,'TIPO 1863');
INSERT INTO "tipo_documento" VALUES(1865,'TIPO 1864');
INSERT INTO "tipo_documento" VALUES(1866,'TIPO 1865');
INSERT INTO "tipo_documento" VALUES(1867,'TIPO 1866');
INSERT INTO "tipo_documento" VALUES(1868,'TIPO 1867');
INSERT INTO "tipo_documento" VALUES(1869,'TIPO 1868');
INSERT INTO "tipo_documento" VALUES(1870,'TIPO 1869');
INSERT INTO "tipo_documento" VALUES(1871,'TIPO 1870');
INSERT INTO "tipo_documento" VALUES(1872,'TIPO 1871');
INSERT INTO "tipo_documento" VALUES(1873,'TIPO 1872');
INSERT INTO "tipo_documento" VALUES(1874,'TIPO 1873');
INSERT INTO "tipo_documento" VALUES(1875,'TIPO 1874');
INSERT INTO "tipo_documento" VALUES(1876,'TIPO 1875');
INSERT INTO "tipo_documento" VALUES(1877,'TIPO 1876');
INSERT INTO "tipo_documento" VALUES(1878,'TIPO 1877');
INSERT INTO "tipo_documento" VALUES(1879,'TIPO 1878');
INSERT INTO "tipo_documento" VALUES(1880,'TIPO 1879');
INSERT INTO "tipo_documento" VALUES(1881,'TIPO 1880');
INSERT INTO "tipo_documento" VALUES(1882,'TIPO 1881');
INSERT INTO "tipo_documento" VALUES(1883,'TIPO 1882');
INSERT INTO "tipo_documento" VALUES(1884,'TIPO 1883');
INSERT INTO "tipo_documento" VALUES(1885,'TIPO 1884');
INSERT INTO "tipo_documento" VALUES(1886,'TIPO 1885');
INSERT INTO "tipo_documento" VALUES(1887,'TIPO 1886');
INSERT INTO "tipo_documento" VALUES(1888,'TIPO 1887');
INSERT INTO "tipo_documento" VALUES(1889,'TIPO 1888');
INSERT INTO "tipo_documento" VALUES(1890,'TIPO 1889');
INSERT INTO "tipo_documento" VALUES(1891,'TIPO 1890');
INSERT INTO "tipo_documento" VALUES(1892,'TIPO 1891');
INSERT INTO "tipo_documento" VALUES(1893,'TIPO 1892');
INSERT INTO "tipo_documento" VALUES(1894,'TIPO 1893');
INSERT INTO "tipo_documento" VALUES(1895,'TIPO 1894');
INSERT INTO "tipo_documento" VALUES(1896,'TIPO 1895');
INSERT INTO "tipo_documento" VALUES(1897,'TIPO 1896');
INSERT INTO "tipo_documento" VALUES(1898,'TIPO 1897');
INSERT INTO "tipo_documento" VALUES(1899,'TIPO 1898');
INSERT INTO "tipo_documento" VALUES(1900,'TIPO 1899');
INSERT INTO "tipo_documento" VALUES(1901,'TIPO 1900');
INSERT INTO "tipo_documento" VALUES(1902,'TIPO 1901');
INSERT INTO "tipo_documento" VALUES(1903,'TIPO 1902');
INSERT INTO "tipo_documento" VALUES(1904,'TIPO 1903');
INSERT INTO "tipo_documento" VALUES(1905,'TIPO 1904');
INSERT INTO "tipo_documento" VALUES(1906,'TIPO 1905');
INSERT INTO "tipo_documento" VALUES(1907,'TIPO 1906');
INSERT INTO "tipo_documento" VALUES(1908,'TIPO 1907');
INSERT INTO "tipo_documento" VALUES(1909,'TIPO 1908');
INSERT INTO "tipo_documento" VALUES(1910,'TIPO 1909');
INSERT INTO "tipo_documento" VALUES(1911,'TIPO 1910');
INSERT INTO "tipo_documento" VALUES(1912,'TIPO 1911');
INSERT INTO "tipo_documento" VALUES(1913,'TIPO 1912');
INSERT INTO "tipo_documento" VALUES(1914,'TIPO 1913');
INSERT INTO "tipo_documento" VALUES(1915,'TIPO 1914');
INSERT INTO "tipo_documento" VALUES(1916,'TIPO 1915');
INSERT INTO "tipo_documento" VALUES(1917,'TIPO 1916');
INSERT INTO "tipo_documento" VALUES(1918,'TIPO 1917');
INSERT INTO "tipo_documento" VALUES(1919,'TIPO 1918');
INSERT INTO "tipo_documento" VALUES(1920,'TIPO 1919');
INSERT INTO "tipo_documento" VALUES(1921,'TIPO 1920');
INSERT INTO "tipo_documento" VALUES(1922,'TIPO 1921');
INSERT INTO "tipo_documento" VALUES(1923,'TIPO 1922');
INSERT INTO "tipo_documento" VALUES(1924,'TIPO 1923');
INSERT INTO "tipo_documento" VALUES(1925,'TIPO 1924');
INSERT INTO "tipo_documento" VALUES(1926,'TIPO 1925');
INSERT INTO "tipo_documento" VALUES(1927,'TIPO 1926');
INSERT INTO "tipo_documento" VALUES(1928,'TIPO 1927');
INSERT INTO "tipo_documento" VALUES(1929,'TIPO 1928');
INSERT INTO "tipo_documento" VALUES(1930,'TIPO 1929');
INSERT INTO "tipo_documento" VALUES(1931,'TIPO 1930');
INSERT INTO "tipo_documento" VALUES(1932,'TIPO 1931');
INSERT INTO "tipo_documento" VALUES(1933,'TIPO 1932');
INSERT INTO "tipo_documento" VALUES(1934,'TIPO 1933');
INSERT INTO "tipo_documento" VALUES(1935,'TIPO 1934');
INSERT INTO "tipo_documento" VALUES(1936,'TIPO 1935');
INSERT INTO "tipo_documento" VALUES(1937,'TIPO 1936');
INSERT INTO "tipo_documento" VALUES(1938,'TIPO 1937');
INSERT INTO "tipo_documento" VALUES(1939,'TIPO 1938');
INSERT INTO "tipo_documento" VALUES(1940,'TIPO 1939');
INSERT INTO "tipo_documento" VALUES(1941,'TIPO 1940');
INSERT INTO "tipo_documento" VALUES(1942,'TIPO 1941');
INSERT INTO "tipo_documento" VALUES(1943,'TIPO 1942');
INSERT INTO "tipo_documento" VALUES(1944,'TIPO 1943');
INSERT INTO "tipo_documento" VALUES(1945,'TIPO 1944');
INSERT INTO "tipo_documento" VALUES(1946,'TIPO 1945');
INSERT INTO "tipo_documento" VALUES(1947,'TIPO 1946');
INSERT INTO "tipo_documento" VALUES(1948,'TIPO 1947');
INSERT INTO "tipo_documento" VALUES(1949,'TIPO 1948');
INSERT INTO "tipo_documento" VALUES(1950,'TIPO 1949');
INSERT INTO "tipo_documento" VALUES(1951,'TIPO 1950');
INSERT INTO "tipo_documento" VALUES(1952,'TIPO 1951');
INSERT INTO "tipo_documento" VALUES(1953,'TIPO 1952');
INSERT INTO "tipo_documento" VALUES(1954,'TIPO 1953');
INSERT INTO "tipo_documento" VALUES(1955,'TIPO 1954');
INSERT INTO "tipo_documento" VALUES(1956,'TIPO 1955');
INSERT INTO "tipo_documento" VALUES(1957,'TIPO 1956');
INSERT INTO "tipo_documento" VALUES(1958,'TIPO 1957');
INSERT INTO "tipo_documento" VALUES(1959,'TIPO 1958');
INSERT INTO "tipo_documento" VALUES(1960,'TIPO 1959');
INSERT INTO "tipo_documento" VALUES(1961,'TIPO 1960');
INSERT INTO "tipo_documento" VALUES(1962,'TIPO 1961');
INSERT INTO "tipo_documento" VALUES(1963,'TIPO 1962');
INSERT INTO "tipo_documento" VALUES(1964,'TIPO 1963');
INSERT INTO "tipo_documento" VALUES(1965,'TIPO 1964');
INSERT INTO "tipo_documento" VALUES(1966,'TIPO 1965');
INSERT INTO "tipo_documento" VALUES(1967,'TIPO 1966');
INSERT INTO "tipo_documento" VALUES(1968,'TIPO 1967');
INSERT INTO "tipo_documento" VALUES(1969,'TIPO 1968');
INSERT INTO "tipo_documento" VALUES(1970,'TIPO 1969');
INSERT INTO "tipo_documento" VALUES(1971,'TIPO 1970');
INSERT INTO "tipo_documento" VALUES(1972,'TIPO 1971');
INSERT INTO "tipo_documento" VALUES(1973,'TIPO 1972');
INSERT INTO "tipo_documento" VALUES(1974,'TIPO 1973');
INSERT INTO "tipo_documento" VALUES(1975,'TIPO 1974');
INSERT INTO "tipo_documento" VALUES(1976,'TIPO 1975');
INSERT INTO "tipo_documento" VALUES(1977,'TIPO 1976');
INSERT INTO "tipo_documento" VALUES(1978,'TIPO 1977');
INSERT INTO "tipo_documento" VALUES(1979,'TIPO 1978');
INSERT INTO "tipo_documento" VALUES(1980,'TIPO 1979');
INSERT INTO "tipo_documento" VALUES(1981,'TIPO 1980');
INSERT INTO "tipo_documento" VALUES(1982,'TIPO 1981');
INSERT INTO "tipo_documento" VALUES(1983,'TIPO 1982');
INSERT INTO "tipo_documento" VALUES(1984,'TIPO 1983');
INSERT INTO "tipo_documento" VALUES(1985,'TIPO 1984');
INSERT INTO "tipo_documento" VALUES(1986,'TIPO 1985');
INSERT INTO "tipo_documento" VALUES(1987,'TIPO 1986');
INSERT INTO "tipo_documento" VALUES(1988,'TIPO 1987');
INSERT INTO "tipo_documento" VALUES(1989,'TIPO 1988');
INSERT INTO "tipo_documento" VALUES(1990,'TIPO 1989');
INSERT INTO "tipo_documento" VALUES(1991,'TIPO 1990');
INSERT INTO "tipo_documento" VALUES(1992,'TIPO 1991');
INSERT INTO "tipo_documento" VALUES(1993,'TIPO 1992');
INSERT INTO "tipo_documento" VALUES(1994,'TIPO 1993');
INSERT INTO "tipo_documento" VALUES(1995,'TIPO 1994');
INSERT INTO "tipo_documento" VALUES(1996,'TIPO 1995');
INSERT INTO "tipo_documento" VALUES(1997,'TIPO 1996');
INSERT INTO "tipo_documento" VALUES(1998,'TIPO 1997');
INSERT INTO "tipo_documento" VALUES(1999,'TIPO 1998');
INSERT INTO "tipo_documento" VALUES(2000,'TIPO 1999');
CREATE INDEX `personas_estado` ON `personas` (`estado`);
CREATE INDEX `personas_ciudad_id` ON `personas` (`ciudad_id`);
CREATE INDEX `personas_estado_2` ON `personas` (`estado`,`nombres`);
CREATE INDEX `personnes_ciudad_id` ON `personnes` (`ciudad_id`);
CREATE INDEX `personnes_estado` ON `personnes` (`estado`);
CREATE INDEX `personnes_cupo` ON `personnes` (`cupo`);
CREATE INDEX `prueba_estado` ON `prueba` (`estado`);
CREATE INDEX `robots_parts_robots_id` on `robots_parts` (`robots_id`);
CREATE INDEX `robots_parts_parts_id` on `robots_parts` (`parts_id`);

DROP TABLE IF EXISTS `COMPANY`;
CREATE TABLE COMPANY (
   ID INT PRIMARY KEY     NOT NULL,
   NAME           TEXT    NOT NULL,
   AGE            INT     NOT NULL,
   ADDRESS        CHAR(50),
   SALARY         REAL
);

CREATE INDEX salary_index ON COMPANY (salary);
CREATE UNIQUE INDEX name_index ON COMPANY (name);

DROP TABLE IF EXISTS `table_with_string_field`;
CREATE TABLE `table_with_string_field` (
  `id` INTEGER NOT NULL PRIMARY KEY,
  `field` varchar(70) NOT NULL
);
INSERT INTO "table_with_string_field" VALUES(1,'String one');
INSERT INTO "table_with_string_field" VALUES(2,'String two');
INSERT INTO "table_with_string_field" VALUES(3,'Another one string');

COMMIT;
