/* pghp - hp2623a version of low level pgraf routines using hpgr */
#include <stdio.h>
#define PSCALE 33.9
#define PYOFF 20.;
static float aj[8];
static int iptr;
static char esc,cr,buffer[100];

pginit()
/* initialize graphics device */
{
  ginit();
  gclear(1);
}

pgflsh()
/* flush graphics device */
{
  flsh();
  fprintf(stderr,"type return to continue ... ");
  while (getchar() != '\n');
}

pgmove(x,y)
/* move with pen up */
float x,y;
{
  penup();
  plot(x,y);
}

pgdraw(x,y,lt1)
/* draw a line */
float x,y;
int lt1;
{
  int lcon[5],lt,color;
  lcon[1] = 1;
  lcon[2] = 5;
  lcon[3] = 7;
  lcon[4] = 8;
  lt = lt1;
  color = 0;
  while (lt < 1) {
    lt += 4;
    color--;
  }
  while (lt > 4) {
    lt -= 4;
    color++;
  }
  ltype(lcon[lt]);
  pendn();
  plot(x,y);
}

pgtext(x,y,text)
/* write text */
float x,y;
char *text;
{
  ontxt(x,y,1,1);
  printf("%s",text);
  offtxt();
}

pginfo(dcx,dcy)
/* return character cell size information */
float *dcx,*dcy;
{
  *dcx = 0.1944;
  *dcy = 0.2778;
}

hard()
/* make hard copy */
{
  char huffer[100];
  char hold[20],i[5];
  sprintf(hold,"%cc%c&p5d5u0C%cbZ",esc,esc,esc);
  sprintf(huffer,"%s%s",buffer,hold);
  sprintf(buffer,"%s",huffer);
  iptr = iptr + 15;
  flsh();
  printf("Hit return to continue.");
  scanf("%c%c",&i[0],&i[1]);
}

ginit()
/* initialization routine */
{
  esc = '\033';
  cr = 13;
  iptr = 1;
  buffer[0] = '\0';
}

gclear(i)
/* clear or set screen and set write mode */
int i;
{
  char huffer[100];
  if ((iptr + 9) > 70) flsh();
  if (i == 1)
    sprintf(huffer,"%s%c*dA%c*m2A",buffer,esc,esc);
  else
    sprintf(huffer,"%s%c*dB%c*m1A",buffer,esc,esc);
  sprintf(buffer,"%s",huffer);
  iptr = iptr + 10;
}

flsh()
/* flush routine */
{
  printf("%s\n",buffer);
  ginit();
}

penup()
/* raise pen */
{
  char huffer[100];
  if ((iptr + 5) > 70) flsh();
  sprintf(huffer,"%s%c*paZ",buffer,esc);
  sprintf(buffer,"%s",huffer);
  iptr = iptr + 6;
}

pendn()
/* lower pen */
{
  char huffer[100];
  if ((iptr + 5) > 70) flsh();
  sprintf(huffer,"%s%c*pbZ",buffer,esc);
  sprintf(buffer,"%s",huffer);
  iptr = iptr + 6;
}

plot(x,y)
/* move pen to (x,y) */
float x,y;
{
  char huffer[100];
  char hold[15];
  int ix, iy;
  ix = PSCALE*x + .5;
  iy = PSCALE*y + PYOFF;
  if (ix < 0) ix = 0;
  if (ix > 511) ix = 511;
  if (iy < 0) iy = 0;
  if (iy > 359) iy = 359;
  sprintf(hold,"%c*p%d,%dZ",esc,ix,iy);
  if ((iptr + 11) > 70) flsh();
  sprintf(huffer,"%s%s",buffer,hold);
  sprintf(buffer,"%s",huffer);
  iptr = iptr + 11;
}

ltype(ityp)
/* sets line type */
int ityp;
{
  char huffer[100],hold[8];
  int jtyp;
  jtyp = ityp;
  if (jtyp < 1) jtyp = 1;
  if (jtyp > 11) jtyp = 11;
  sprintf(hold,"%c*m%dbZ",esc,jtyp);
  if ((iptr + 8) > 70) flsh();
  sprintf(huffer,"%s%s",buffer,hold);
  sprintf(buffer,"%s",huffer);
  iptr = iptr + 8;
}

ontxt(x,y,isiz,ior)
/* turn on text mode */
float x,y;
int isiz,ior;
{
  char huffer[100];
  int jsiz,jor;
  float b;
  jsiz = isiz;
  if (jsiz < 1) jsiz = 1;
  if (jsiz > 8) jsiz = 8;
  jor = ior;
  if (jor < 1) jor = 1;
  if (jor > 4) jor = 4;
  penup();
  b = .33333*jsiz+0.06666;
  if (jor == 1) plot(x,y+b);
  else if (jor == 2) plot(x-b,y);
  else if (jor == 3) plot(x,y-b);
  else if (jor == 4) plot(x+b,y);
  flsh();
  sprintf(huffer,"%c*m%dm%dn2Q%c*dS",esc,jsiz,jor,esc);
  sprintf(buffer,"%s",huffer);
  iptr = iptr + 13;
  flsh();
}

offtxt()
/* turn off text mode */
{
  char huffer[100];
  if ((iptr+ 4) > 70) flsh();
  sprintf(huffer,"%s%c*dT",buffer,esc);
  sprintf(buffer,"%s",huffer);
  iptr = iptr + 4;
  flsh();
}
