#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include <sys/types.h>
#include <sys/stat.h>

#include "verify.h"

/* perl interface for netpgpverify */

typedef struct {
	pgpv_t		*pgp;
	pgpv_cursor_t	*cursor;
} PGPV;

/* create a verify instance */
PGPV *
PGPV_open(void)
{
	PGPV	*pgpv;

	pgpv = Newz(0, pgpv, 1, PGPV);
	if (pgpv == NULL) {
		return NULL;
	}
	pgpv->pgp = pgpv_new();
	pgpv->cursor = pgpv_new_cursor();
	return pgpv;
}

/* destroy verify instance */
int
PGPV_delete(PGPV *pgpv)
{
	if (pgpv != NULL) {
		pgpv_close(pgpv->pgp);
		pgpv_cursor_close(pgpv->cursor);
		memset(pgpv, 0x0, sizeof(*pgpv));
		Safefree(pgpv);
	}
	return 0;
}

/* print the time nicely */
static void
ptime(int64_t secs)
{
        time_t  t;

        t = (time_t)secs;
        printf("%s", ctime(&t));
}

/* print entry n */
static void
pentry(pgpv_t *pgp, int n, const char *modifiers)
{
        size_t   cc;
        char    *s;

        cc = pgpv_get_entry(pgp, (unsigned)n, &s, modifiers);
        fwrite(s, 1, cc, stdout);
        free(s);
}

MODULE = Netpgp::Verify		PACKAGE = Netpgp::Verify		

PROTOTYPES: ENABLE

PGPV *
PGPV_open()

int
PGPV_delete(pgpv)
	PGPV *pgpv

int
read_pubring(self, ...)
	SV *self
PREINIT:
	PGPV *pgpv;
	struct stat	st;
	const void *file;
	STRLEN size;
	int	ok;
PPCODE:
	pgpv = INT2PTR(PGPV *, SvIV(SvRV(SvRV(self))));
	file = (const void *)(SvPV(ST(1), size));
	if (stat(file, &st) == 0) {
		size = -1;
	}
	ok = pgpv_read_pubring(pgpv->pgp, file, size);
	if (!ok && size < 0) {
		printf("%s not found\n", file);
	}
	XSRETURN(ok);

int
read_ssh_key(self, ...)
	SV *self
PREINIT:
	PGPV *pgpv;
	struct stat	st;
	const void *file;
	STRLEN size;
	int	ok;
PPCODE:
	pgpv = INT2PTR(PGPV *, SvIV(SvRV(SvRV(self))));
	file = (const void *)(SvPV(ST(1), size));
	if (stat(file, &st) == 0) {
		size = -1;
	}
	ok = pgpv_read_ssh_pubkeys(pgpv->pgp, file, size);
	if (!ok && size < 0) {
		printf("%s not found\n", file);
	}
	XSRETURN(ok);



int
verify(self, ...)
	SV *self
PREINIT:
	PGPV *pgpv;
	const char *file;
	struct stat	st;
	STRLEN size;
	int	el;
	int	ok;
PPCODE:
	pgpv = INT2PTR(PGPV *, SvIV(SvRV(SvRV(self))));
	file = (const void *)(SvPV(ST(1), size));
	ok = 0;
	if (stat(file, &st) == 0) {
		size = -1;
	}
	if (pgpv_verify(pgpv->cursor, pgpv->pgp, file, size)) {
		printf("Good signature for %s made ", file);
		ptime(pgpv_get_cursor_num(pgpv->cursor, "sigtime"));
		el = pgpv_get_cursor_element(pgpv->cursor, 0);
		pentry(pgpv->pgp, el, NULL);
		ok = 1;
	}
	XSRETURN(ok);

int
cat(self, ...)
	SV *self
PREINIT:
	const char *file;
	struct stat	st;
	size_t	cookie;
	char	*data;
	size_t	cc;
	PGPV *pgpv;
	STRLEN size;
	int	el;
	int	ok;
	SV	*str;
PPCODE:
	pgpv = INT2PTR(PGPV *, SvIV(SvRV(SvRV(self))));
	file = (const void *)(SvPV(ST(1), size));
	ok = 0;
	if (stat(file, &st) == 0) {
		size = -1;
	}
	if ((cookie = pgpv_verify(pgpv->cursor, pgpv->pgp, file, size)) != 0) {
		if ((cc = pgpv_get_verified(pgpv->cursor, cookie, &data)) > 0) {
			str = sv_newmortal();
			sv_upgrade(str, SVt_PV);
			SvPOK_on(str);
			SvPV_set(str, data);
			SvCUR_set(str, cc + 1);
			SvFAKE_on(str);
			SvREADONLY_on(str);
			ST(0) = str;
			ok = 1;
		}
	}
	XSRETURN(ok);

int
dump(self, ...)
	SV *self
PREINIT:
	const char *file;
	struct stat	st;
	size_t	cookie;
	char	*data;
	size_t	cc;
	PGPV *pgpv;
	STRLEN size;
	int	el;
	int	ok;
	SV	*str;
PPCODE:
	pgpv = INT2PTR(PGPV *, SvIV(SvRV(SvRV(self))));
	file = (const void *)(SvPV(ST(1), size));
	ok = 0;
	if (stat(file, &st) == 0) {
		size = -1;
	}
	if ((cookie = pgpv_verify(pgpv->cursor, pgpv->pgp, file, size)) != 0) {
		cc = pgpv_dump(pgpv->pgp, &data);
		str = sv_newmortal();
		sv_upgrade(str, SVt_PV);
		SvPOK_on(str);
		SvPV_set(str, data);
		SvCUR_set(str, cc + 1);
		SvFAKE_on(str);
		SvREADONLY_on(str);
		ST(0) = str;
		ok = 1;
	}
	XSRETURN(ok);

