/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */

# include <stdio.h>
# include <signal.h>
# include <string.h>
# include <errno.h>

# include <begemot.h>
# include "../cdefs.h"
# include "util.h"

RCSID("$Id: catchsig.c 444 2000-11-14 12:11:23Z hbb $")

void
catch_signal(int sig, void (*act)(int))
{
	struct sigaction	sa, osa;
	sigset_t		set;

	sigemptyset(&set);
	sa.sa_mask = set;
	sa.sa_handler = act;
	sa.sa_flags = SA_RESTART;
	if(sigaction(sig, &sa, &osa))
		panic("unexpected error in sigaction: %s", strerror(errno));
}
