#!/bin/bash
#
# $Id: p11.sh 496 2002-09-04 12:58:18Z hbb $
#
# p11          Start/Stop p11.
#
# Author: Eric Moret
#	This file is for Linux systems (tested on RH73).
#
# chkconfig: 345 91 59
# description: p11 is a DEC pdp-11 emulator
# processname: p11
# config: /etc/p11conf
# pidfile: /var/run/p11.pid

# Source function library.
. /etc/init.d/functions

RETVAL=0
P11="/usr/bin/p11"
P11CONF="/etc/p11conf"
OPTIONS="-d -c "
prog="p11"

# See how we were called.
  

start() {
	echo -n $"Starting $prog: "
	initlog -c "$P11 $OPTIONS $P11CONF" && success || failure
	RETVAL=$?
	echo
	[ $RETVAL -eq 0 ] && touch /var/lock/subsys/p11
	return $RETVAL
}

stop() {
	echo -n $"Stopping $prog: "
	killproc $P11 -TERM
	RETVAL=$?
	echo
	[ $RETVAL -eq 0 ] && rm -f /var/lock/subsys/p11
	return $RETVAL
}	

rhstatus() {
	status p11
}	

restart() {
  	stop
	start
}	

case "$1" in
  start)
  	start
	;;
  stop)
  	stop
	;;
  restart)
  	restart
	;;
  status)
  	rhstatus
	;;
  condrestart)
  	[ -f /var/lock/subsys/p11 ] && restart || :
	;;
  *)
	echo $"Usage: $0 {start|stop|status|restart|condrestart}"
	exit 1
esac

exit $?
