/* 
 * otpCalc - A one time password calculator.
 *
 * Copyright (C) 2001 Anthony D. Urso
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "crypto.h"
#include "macros.h"
#include "utility.h"

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */

GtkWidget *di_about;

void about(void)
{

	GtkWidget *la_about, *bu_about_close;


	if (di_about != NULL)
		return;

	di_about = gtk_dialog_new();
	gtk_window_set_wmclass(GTK_WINDOW(di_about), "otpCalc", "About");
	gtk_window_set_title(GTK_WINDOW(di_about), "About otpCalc");

	la_about = gtk_label_new(
		"otpCalc " VERSION "\n\n"
		"Copyright (c) 2001, 2004 Anthony D. Urso\n\n"
#ifndef HAVE_MD4
		"This software contains these algorithms:\n"
		"RSA Data Security, Inc. MD4 Message-Digest Algorithm\n"
#endif
#ifndef HAVE_MD5
		"RSA Data Security, Inc. MD5 Message-Digest Algorithm\n\n"
#endif
		"Updates available from:\n"
		"http://killa.net/infosec/otpCalc/"
	);

	gtk_misc_set_padding(GTK_MISC(la_about), 10, 10);

	bu_about_close = gtk_button_new_with_label("Close");

	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(di_about)->vbox),
			  la_about);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(di_about)->action_area),
			  bu_about_close);

	gtk_signal_connect_object(GTK_OBJECT(bu_about_close), "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  (gpointer)di_about);

	gtk_widget_show_all(di_about);

}

void calculate(void)
{

	void (*hashes[4])();

	gchar *challenge, *passwd, *message, *response;
	struct tokens *set;
	extern GtkWidget *te_challenge, *te_passwd, *te_response;
	unsigned short i;
	unsigned char results[9];


	hashes[SKEY] = md4lite;
	hashes[MD4] = md4lite;
	hashes[MD5] = md5lite;
	hashes[RMD160] = rmd160lite;
	hashes[SHA1] = sha1lite;

	challenge = gtk_editable_get_chars(GTK_EDITABLE(te_challenge), 0, -1);
	set = g_malloc0(sizeof(struct tokens));
	set->seed = g_malloc(strlen(challenge));

	if (!parse(challenge, set)) {
		gtk_entry_set_text(GTK_ENTRY(te_response), "invalid challenge");
		g_free(challenge);
		g_free(set->seed);
		g_free(set);
		return;
	}

	g_free(challenge);

	passwd = gtk_editable_get_chars(GTK_EDITABLE(te_passwd), 0, -1);
	if (set->alg != SKEY)
		g_strdown(set->seed);
	message = g_strconcat(set->seed, passwd, NULL);

	g_free(set->seed);
	g_free(passwd);

	(*hashes[set->alg])(message, strlen(message));
	memcpy(results, message, 8);
	g_free(message);

	for (i = 0; i < set->seq; i++)
		(*hashes[set->alg])(results, 8);

	g_free(set);

	results[8] = parity(results);

	response = g_malloc(31);
	sixwords(results, response);
	gtk_entry_set_text(GTK_ENTRY(te_response), response);
	g_free(response);
	gtk_editable_select_region(GTK_EDITABLE(te_response), 0, -1);

}

void clear(void)
{

	extern GtkWidget *te_challenge, *te_passwd, *te_response;

	gtk_editable_delete_text(GTK_EDITABLE(te_challenge), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(te_passwd), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(te_response), 0, -1);

}

void click(GtkWidget *unused, GtkWidget *button)
{

	gtk_button_clicked(GTK_BUTTON(button));

}

void netwarn(void)
{

	gchar *d;
	GtkWidget *di_netwarn, *la_netwarn, *aa_netwarn,
		*bu_netwarn_ok, *bu_netwarn_canc;

	if (((d = getenv("DISPLAY")) == NULL) || (!g_strncasecmp(d, ":", 1)))
		return;

	di_netwarn = gtk_dialog_new();
	gtk_window_set_wmclass(GTK_WINDOW(di_netwarn), "otpCalc", "Warn");
	gtk_window_set_title(GTK_WINDOW(di_netwarn), "Warning!");
	gtk_window_set_position(GTK_WINDOW(di_netwarn), GTK_WIN_POS_CENTER);

	la_netwarn = gtk_label_new(
		"It is unsafe to use otpCalc over an unencrypted X"
	        " connection.\n\nProceed anyway?"
	);
	gtk_misc_set_padding(GTK_MISC(la_netwarn), 10, 10);
	gtk_label_set_line_wrap(GTK_LABEL(la_netwarn), TRUE);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(di_netwarn)->vbox),
			  la_netwarn);

	aa_netwarn = GTK_DIALOG(di_netwarn)->action_area;

	bu_netwarn_ok = gtk_button_new_with_label("Yes");
	gtk_container_add(GTK_CONTAINER(aa_netwarn), bu_netwarn_ok);

	bu_netwarn_canc = gtk_button_new_with_label("No");
	gtk_container_add(GTK_CONTAINER(aa_netwarn), bu_netwarn_canc);

	gtk_signal_connect_object(GTK_OBJECT(bu_netwarn_ok), "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  (gpointer)di_netwarn);

	gtk_signal_connect_object(GTK_OBJECT(bu_netwarn_canc), "clicked",
				  GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

	gtk_widget_show_all(di_netwarn);

}


void selector(GtkWidget *widget, GtkSelectionData *selection, gpointer data)
{

	struct tokens *set;
	extern GtkWidget *te_challenge;
	unsigned short parsed;


	if (selection->length < 1) 
		return;

	set = g_malloc(sizeof(struct tokens));
	set->seed = g_malloc(selection->length);

	parsed = parse(selection->data, set);

	g_free(set->seed);
	g_free(set);

	if (!parsed)
		return;

	gtk_entry_set_text(GTK_ENTRY(te_challenge), selection->data);

}


void sethash(unsigned short new)
{

	extern unsigned short hash;

	hash = new;
	
}


void focus(GtkWidget *widget, gpointer data)
{

	static GdkAtom targets;
	extern unsigned short autopaste;


	if (!autopaste)
		return;

	targets = gdk_atom_intern("STRING", FALSE);

	gtk_selection_convert(widget, GDK_SELECTION_PRIMARY, targets,
			      GDK_CURRENT_TIME);


}
