/*
 * directory.c - Table directory manipulation.
 *
    Copyright (C) 2001  Yao Zhang

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * yaoz@users.sourceforge.net
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "ot.h"

FontDirectory *new_font_directory(void)
{
    FontDirectory *fontDirectory;

    fontDirectory = (FontDirectory *)calloc(1, sizeof(FontDirectory));

    return fontDirectory;
}

void delete_font_directory(FontDirectory *fontDirectory)
{
    if (fontDirectory->tableDirectory != NULL) {
        free(fontDirectory->tableDirectory);
    }

    if (fontDirectory->buffer != NULL) {
        free(fontDirectory->buffer);
    }
    free(fontDirectory);
}

void read_font_directory(char *file, FontDirectory *fontDirectory)
{
    register uint8_t *p;
    FILE *fp;
    int i, n;

    fontDirectory->length = 4 + 4*2;
    fontDirectory->buffer = (uint8_t *)calloc(1, fontDirectory->length);

    fp = fopen(file, "r");
    if (fp == NULL) {
        printf("Cannot open font file: %s\n", file);
        return;
    }

    /* Offset Subtable */
    fread(fontDirectory->buffer, fontDirectory->length, 1, fp);
    p = fontDirectory->buffer;
    fontDirectory->offsetSubtable.version = GET4B(p);
    fontDirectory->offsetSubtable.numTables = GET2B(p);
    fontDirectory->offsetSubtable.searchRange = GET2B(p);
    fontDirectory->offsetSubtable.entrySelector = GET2B(p);
    fontDirectory->offsetSubtable.rangeShift = GET2B(p);

    free(fontDirectory->buffer);

    n = fontDirectory->offsetSubtable.numTables;
    fontDirectory->tableDirectory
            = (TableDirectoryEntry *)calloc(n, sizeof(TableDirectoryEntry));

    fontDirectory->length = 4 + 4*2 + n*(4*4);
    fontDirectory->buffer = (uint8_t *)calloc(1, fontDirectory->length);

    /* Table Directory */
    fseek(fp, 0, SEEK_SET);
    fread(fontDirectory->buffer, fontDirectory->length, 1, fp);
    p = fontDirectory->buffer + 4 + 4*2;
    for (i = 0; i < n; i++) {
        TableDirectoryEntry *tableDirectoryEntry;

        tableDirectoryEntry = &fontDirectory->tableDirectory[i];
        memcpy(tableDirectoryEntry->tag, p, 4); p += 4;
        tableDirectoryEntry->checkSum = GET4B(p);
        tableDirectoryEntry->offset = GET4B(p);
        tableDirectoryEntry->length = GET4B(p);
    }

    fclose(fp);
}

void print_offset_subtable(const OffsetSubtable *offsetSubtable)
{
    printf("sfnt vertion: 0x%08X, ", offsetSubtable->version);
    printf("numTables: %u;\n", offsetSubtable->numTables);
    printf("searchRange: %u, ", offsetSubtable->searchRange);
    printf("entrySelector: %u, ", offsetSubtable->entrySelector);
    printf("rangeShift: %u.\n", offsetSubtable->rangeShift);
}

static void print_tag(const char tag[4])
{
    printf("'%c%c%c%c', ", tag[0], tag[1], tag[2], tag[3]);
}

void print_table_directory_entry(const TableDirectoryEntry *tableDirectoryEntry)
{
    printf("tag: ");    print_tag((char *)&tableDirectoryEntry->tag);
    printf("checkSum: %u, ", tableDirectoryEntry->checkSum);
    printf("offset: %u, ", tableDirectoryEntry->offset);
    printf("length: %u.\n", tableDirectoryEntry->length);
}
