/*
 * Purpose: Filter coefficient tables for GRC3 sample rate converter
 */

/*
 * This file is part of Open Sound System
 *
 * Copyright (C) 4Front Technologies 1996-2008.
 *
 * This software is released under the BSD license.
 * See the COPYING file included in the main directory of this source
 * distribution for the license terms and conditions
 */


static int32_t filter_data[8193] = {
  0, -5008, -10058, -15150, -20285, -25462, -30682, -35945, -41250,
  -46598, -51990, -57425, -62903, -68425, -73990, -79599, -85252, -90949,
  -96690, -102475, -108304, -114178, -120097, -126060, -132068, -138121,
  -144219, -150362, -156550, -162784, -169063, -175387, -181758, -188174,
  -194636, -201145, -207699, -214300, -220947, -227641, -234381, -241168,
  -248001, -254882, -261810, -268785, -275807, -282876, -289993, -297157,
  -304369, -311629, -318937, -326293, -333697, -341149, -348649, -356197,
  -363794, -371440, -379134, -386877, -394669, -402510, -410400, -418339,
  -426328, -434365, -442452, -450589, -458775, -467011, -475297, -483632,
  -492018, -500453, -508939, -517475, -526061, -534698, -543385, -552122,
  -560911, -569750, -578639, -587580, -596572, -605615, -614708, -623853,
  -633050, -642297, -651597, -660947, -670349, -679803, -689309, -698866,
  -708475, -718136, -727849, -737615, -747432, -757301, -767223, -777197,
  -787224, -797303, -807434, -817618, -827855, -838144, -848486, -858881,
  -869329, -879830, -890384, -900990, -911650, -922363, -933129, -943949,
  -954822, -965748, -976727, -987760, -998846, -1009986, -1021179,
  -1032426, -1043727, -1055082, -1066490, -1077952, -1089467, -1101037,
  -1112660, -1124337, -1136069, -1147854, -1159693, -1171587, -1183534,
  -1195535, -1207591, -1219701, -1231865, -1244083, -1256355, -1268682,
  -1281063, -1293498, -1305988, -1318532, -1331130, -1343783, -1356490,
  -1369251, -1382067, -1394937, -1407862, -1420841, -1433874, -1446962,
  -1460105, -1473302, -1486553, -1499859, -1513219, -1526634, -1540103,
  -1553627, -1567205, -1580838, -1594525, -1608267, -1622063, -1635913,
  -1649818, -1663778, -1677791, -1691859, -1705982, -1720159, -1734390,
  -1748676, -1763015, -1777410, -1791858, -1806361, -1820917, -1835528,
  -1850194, -1864913, -1879686, -1894514, -1909395, -1924331, -1939320,
  -1954364, -1969461, -1984612, -1999817, -2015076, -2030388, -2045755,
  -2061174, -2076648, -2092175, -2107755, -2123389, -2139076, -2154817,
  -2170611, -2186458, -2202358, -2218312, -2234318, -2250378, -2266490,
  -2282656, -2298874, -2315144, -2331468, -2347844, -2364273, -2380754,
  -2397287, -2413873, -2430511, -2447201, -2463943, -2480737, -2497583,
  -2514481, -2531431, -2548432, -2565485, -2582589, -2599745, -2616951,
  -2634210, -2651519, -2668879, -2686290, -2703752, -2721265, -2738828,
  -2756441, -2774105, -2791820, -2809584, -2827399, -2845263, -2863178,
  -2881142, -2899155, -2917218, -2935331, -2953492, -2971703, -2989963,
  -3008272, -3026629, -3045035, -3063490, -3081993, -3100544, -3119143,
  -3137790, -3156485, -3175227, -3194017, -3212855, -3231739, -3250671,
  -3269650, -3288675, -3307747, -3326866, -3346031, -3365242, -3384499,
  -3403802, -3423151, -3442545, -3461985, -3481469, -3500999, -3520574,
  -3540193, -3559857, -3579565, -3599318, -3619114, -3638955, -3658838,
  -3678766, -3698736, -3718750, -3738807, -3758906, -3779048, -3799232,
  -3819458, -3839727, -3860037, -3880388, -3900781, -3921215, -3941690,
  -3962206, -3982762, -4003359, -4023995, -4044672, -4065388, -4086144,
  -4106939, -4127772, -4148645, -4169557, -4190506, -4211494, -4232520,
  -4253583, -4274684, -4295822, -4316997, -4338209, -4359457, -4380741,
  -4402062, -4423418, -4444810, -4466237, -4487699, -4509196, -4530728,
  -4552293, -4573893, -4595526, -4617193, -4638894, -4660627, -4682393,
  -4704191, -4726021, -4747884, -4769778, -4791703, -4813660, -4835647,
  -4857665, -4879713, -4901791, -4923898, -4946036, -4968202, -4990397,
  -5012620, -5034872, -5057152, -5079459, -5101793, -5124155, -5146544,
  -5168958, -5191399, -5213866, -5236358, -5258876, -5281418, -5303985,
  -5326576, -5349191, -5371830, -5394492, -5417177, -5439884, -5462614,
  -5485366, -5508139, -5530934, -5553750, -5576586, -5599443, -5622320,
  -5645216, -5668131, -5691066, -5714019, -5736990, -5759979, -5782986,
  -5806010, -5829050, -5852108, -5875181, -5898270, -5921374, -5944493,
  -5967627, -5990775, -6013937, -6037113, -6060301, -6083503, -6106717,
  -6129942, -6153180, -6176428, -6199688, -6222958, -6246238, -6269528,
  -6292827, -6316134, -6339451, -6362775, -6386107, -6409447, -6432793,
  -6456146, -6479504, -6502869, -6526239, -6549613, -6572992, -6596375,
  -6619762, -6643151, -6666544, -6689938, -6713335, -6736733, -6760132,
  -6783532, -6806931, -6830331, -6853730, -6877127, -6900523, -6923917,
  -6947309, -6970697, -6994083, -7017464, -7040841, -7064213, -7087580,
  -7110942, -7134297, -7157646, -7180988, -7204322, -7227648, -7250966,
  -7274275, -7297575, -7320865, -7344144, -7367413, -7390670, -7413916,
  -7437149, -7460370, -7483577, -7506771, -7529951, -7553115, -7576265,
  -7599399, -7622517, -7645618, -7668702, -7691769, -7714817, -7737847,
  -7760857, -7783848, -7806818, -7829768, -7852697, -7875604, -7898488,
  -7921350, -7944189, -7967004, -7989794, -8012560, -8035300, -8058014,
  -8080702, -8103363, -8125996, -8148602, -8171178, -8193726, -8216244,
  -8238732, -8261189, -8283614, -8306008, -8328370, -8350698, -8372993,
  -8395254, -8417481, -8439672, -8461827, -8483947, -8506029, -8528074,
  -8550081, -8572050, -8593979, -8615869, -8637718, -8659527, -8681294,
  -8703020, -8724702, -8746342, -8767938, -8789490, -8810996, -8832458,
  -8853873, -8875242, -8896563, -8917837, -8939062, -8960238, -8981365,
  -9002441, -9023467, -9044441, -9065363, -9086233, -9107050, -9127812,
  -9148520, -9169174, -9189771, -9210312, -9230797, -9251224, -9271593,
  -9291903, -9312154, -9332344, -9352475, -9372544, -9392551, -9412496,
  -9432378, -9452196, -9471949, -9491638, -9511261, -9530818, -9550308,
  -9569730, -9589084, -9608370, -9627586, -9646732, -9665807, -9684811,
  -9703743, -9722602, -9741388, -9760100, -9778737, -9797299, -9815785,
  -9834195, -9852527, -9870782, -9888957, -9907054, -9925071, -9943007,
  -9960862, -9978635, -9996326, -10013933, -10031457, -10048896,
  -10066250, -10083518, -10100699, -10117793, -10134799, -10151717,
  -10168545, -10185284, -10201931, -10218488, -10234952, -10251324,
  -10267603, -10283787, -10299877, -10315871, -10331769, -10347571,
  -10363275, -10378880, -10394387, -10409794, -10425102, -10440308,
  -10455412, -10470414, -10485313, -10500109, -10514799, -10529385,
  -10543865, -10558238, -10572504, -10586662, -10600712, -10614652,
  -10628482, -10642201, -10655809, -10669304, -10682687, -10695956,
  -10709110, -10722150, -10735074, -10747881, -10760571, -10773143,
  -10785597, -10797931, -10810145, -10822238, -10834210, -10846060,
  -10857786, -10869389, -10880868, -10892221, -10903449, -10914550,
  -10925524, -10936370, -10947087, -10957674, -10968131, -10978458,
  -10988653, -10998715, -11008644, -11018440, -11028100, -11037626,
  -11047015, -11056268, -11065383, -11074360, -11083198, -11091897,
  -11100455, -11108871, -11117146, -11125278, -11133267, -11141112,
  -11148811, -11156366, -11163774, -11171034, -11178147, -11185112,
  -11191927, -11198592, -11205107, -11211469, -11217680, -11223738,
  -11229642, -11235391, -11240985, -11246424, -11251705, -11256830,
  -11261796, -11266603, -11271250, -11275738, -11280064, -11284228,
  -11288229, -11292067, -11295741, -11299250, -11302594, -11305771,
  -11308781, -11311624, -11314298, -11316802, -11319136, -11321300,
  -11323292, -11325112, -11326759, -11328232, -11329531, -11330654,
  -11331601, -11332372, -11332965, -11333380, -11333616, -11333673,
  -11333549, -11333243, -11332756, -11332087, -11331233, -11330196,
  -11328974, -11327566, -11325972, -11324191, -11322222, -11320064,
  -11317717, -11315181, -11312453, -11309534, -11306422, -11303118,
  -11299620, -11295928, -11292040, -11287956, -11283676, -11279199,
  -11274523, -11269648, -11264574, -11259300, -11253825, -11248148,
  -11242268, -11236185, -11229898, -11223407, -11216710, -11209808,
  -11202698, -11195381, -11187855, -11180121, -11172176, -11164022,
  -11155656, -11147078, -11138288, -11129284, -11120067, -11110634,
  -11100987, -11091123, -11081042, -11070743, -11060227, -11049491,
  -11038536, -11027360, -11015963, -11004344, -10992502, -10980438,
  -10968149, -10955636, -10942897, -10929933, -10916742, -10903323,
  -10889676, -10875800, -10861695, -10847359, -10832793, -10817995,
  -10802964, -10787701, -10772204, -10756473, -10740507, -10724305,
  -10707866, -10691191, -10674278, -10657126, -10639735, -10622105,
  -10604234, -10586122, -10567768, -10549172, -10530332, -10511249,
  -10491921, -10472349, -10452530, -10432465, -10412153, -10391593,
  -10370785, -10349728, -10328421, -10306864, -10285055, -10262996,
  -10240683, -10218118, -10195300, -10172227, -10148899, -10125316,
  -10101477, -10077381, -10053027, -10028416, -10003546, -9978417,
  -9953028, -9927378, -9901467, -9875295, -9848860, -9822162, -9795201,
  -9767976, -9740485, -9712730, -9684708, -9656420, -9627865, -9599042,
  -9569950, -9540590, -9510960, -9481060, -9450889, -9420447, -9389733,
  -9358746, -9327487, -9295954, -9264146, -9232064, -9199707, -9167074,
  -9134164, -9100978, -9067513, -9033771, -8999750, -8965450, -8930870,
  -8896009, -8860868, -8825446, -8789741, -8753754, -8717485, -8680931,
  -8644094, -8606972, -8569564, -8531872, -8493893, -8455627, -8417075,
  -8378234, -8339106, -8299689, -8259982, -8219986, -8179700, -8139123,
  -8098255, -8057095, -8015644, -7973899, -7931862, -7889531, -7846906,
  -7803987, -7760772, -7717262, -7673457, -7629355, -7584956, -7540260,
  -7495266, -7449974, -7404384, -7358495, -7312306, -7265817, -7219028,
  -7171938, -7124548, -7076855, -7028861, -6980564, -6931964, -6883062,
  -6833855, -6784345, -6734530, -6684410, -6633986, -6583255, -6532219,
  -6480876, -6429227, -6377270, -6325007, -6272435, -6219555, -6166367,
  -6112869, -6059063, -6004947, -5950521, -5895784, -5840737, -5785380,
  -5729711, -5673730, -5617437, -5560832, -5503915, -5446685, -5389142,
  -5331285, -5273114, -5214629, -5155830, -5096717, -5037288, -4977544,
  -4917485, -4857110, -4796419, -4735412, -4674088, -4612447, -4550490,
  -4488215, -4425622, -4362712, -4299484, -4235937, -4172072, -4107888,
  -4043386, -3978564, -3913423, -3847962, -3782181, -3716081, -3649660,
  -3582919, -3515858, -3448476, -3380773, -3312749, -3244403, -3175736,
  -3106748, -3037438, -2967806, -2897852, -2827576, -2756978, -2686057,
  -2614814, -2543248, -2471359, -2399147, -2326612, -2253755, -2180573,
  -2107069, -2033241, -1959090, -1884615, -1809816, -1734694, -1659247,
  -1583477, -1507383, -1430965, -1354223, -1277157, -1199766, -1122052,
  -1044013, -965650, -886963, -807951, -728615, -648955, -568970,
  -488662, -408029, -327071, -245790, -164184, -82254, 0, 82578, 165480,
  248707, 332258, 416132, 500331, 584853, 669699, 754868, 840362, 926179,
  1012319, 1098782, 1185569, 1272679, 1360112, 1447867, 1535946, 1624347,
  1713070, 1802116, 1891484, 1981174, 2071186, 2161520, 2252175, 2343152,
  2434450, 2526069, 2618009, 2710269, 2802850, 2895751, 2988972, 3082513,
  3176374, 3270554, 3365053, 3459871, 3555008, 3650463, 3746236, 3842327,
  3938736, 4035462, 4132505, 4229866, 4327542, 4425535, 4523844, 4622468,
  4721408, 4820662, 4920232, 5020116, 5120313, 5220825, 5321649, 5422787,
  5524237, 5626000, 5728075, 5830461, 5933158, 6036166, 6139484, 6243112,
  6347050, 6451297, 6555852, 6660716, 6765888, 6871368, 6977154, 7083247,
  7189646, 7296351, 7403360, 7510675, 7618294, 7726217, 7834442, 7942971,
  8051802, 8160935, 8270369, 8380104, 8490139, 8600474, 8711108, 8822040,
  8933271, 9044799, 9156625, 9268746, 9381163, 9493876, 9606883, 9720185,
  9833780, 9947667, 10061847, 10176319, 10291082, 10406135, 10521477,
  10637109, 10753030, 10869238, 10985733, 11102515, 11219583, 11336935,
  11454572, 11572493, 11690697, 11809184, 11927952, 12047000, 12166329,
  12285938, 12405825, 12525990, 12646433, 12767152, 12888146, 13009416,
  13130960, 13252777, 13374866, 13497228, 13619860, 13742763, 13865935,
  13989376, 14113084, 14237059, 14361300, 14485807, 14610577, 14735612,
  14860908, 14986467, 15112286, 15238366, 15364704, 15491301, 15618155,
  15745265, 15872631, 16000251, 16128124, 16256251, 16384629, 16513258,
  16642136, 16771263, 16900639, 17030261, 17160128, 17290241, 17420598,
  17551197, 17682039, 17813121, 17944443, 18076003, 18207802, 18339837,
  18472107, 18604612, 18737351, 18870322, 19003525, 19136957, 19270619,
  19404509, 19538626, 19672969, 19807536, 19942327, 20077340, 20212575,
  20348030, 20483703, 20619595, 20755703, 20892027, 21028565, 21165316,
  21302279, 21439453, 21576836, 21714428, 21852227, 21990231, 22128440,
  22266852, 22405467, 22544282, 22683297, 22822510, 22961920, 23101526,
  23241327, 23381320, 23521506, 23661882, 23802447, 23943200, 24084139,
  24225264, 24366573, 24508064, 24649736, 24791588, 24933619, 25075826,
  25218209, 25360767, 25503497, 25646399, 25789470, 25932711, 26076118,
  26219691, 26363429, 26507329, 26651391, 26795613, 26939993, 27084530,
  27229223, 27374069, 27519068, 27664219, 27809518, 27954966, 28100560,
  28246299, 28392181, 28538206, 28684370, 28830674, 28977114, 29123690,
  29270400, 29417243, 29564216, 29711319, 29858549, 30005906, 30153386,
  30300990, 30448715, 30596559, 30744521, 30892599, 31040792, 31189098,
  31337515, 31486042, 31634676, 31783417, 31932262, 32081209, 32230258,
  32379407, 32528652, 32677994, 32827430, 32976958, 33126577, 33276285,
  33426079, 33575960, 33725923, 33875969, 34026094, 34176298, 34326578,
  34476933, 34627360, 34777858, 34928426, 35079060, 35229760, 35380524,
  35531349, 35682234, 35833177, 35984177, 36135230, 36286336, 36437492,
  36588696, 36739948, 36891244, 37042582, 37193962, 37345380, 37496836,
  37648326, 37799849, 37951404, 38102987, 38254598, 38406234, 38557893,
  38709574, 38861273, 39012990, 39164722, 39316467, 39468223, 39619988,
  39771761, 39923538, 40075319, 40227100, 40378880, 40530657, 40682429,
  40834193, 40985948, 41137691, 41289421, 41441135, 41592831, 41744507,
  41896161, 42047790, 42199394, 42350969, 42502513, 42654024, 42805501,
  42956940, 43108340, 43259699, 43411013, 43562283, 43713504, 43864674,
  44015793, 44166856, 44317863, 44468811, 44619697, 44770520, 44921276,
  45071965, 45222584, 45373130, 45523601, 45673995, 45824309, 45974542,
  46124691, 46274754, 46424728, 46574611, 46724402, 46874096, 47023693,
  47173190, 47322584, 47471874, 47621056, 47770129, 47919090, 48067936,
  48216667, 48365278, 48513768, 48662134, 48810374, 48958486, 49106467,
  49254314, 49402026, 49549600, 49697033, 49844323, 49991468, 50138465,
  50285312, 50432007, 50578546, 50724927, 50871148, 51017207, 51163101,
  51308828, 51454384, 51599768, 51744978, 51890009, 52034861, 52179531,
  52324015, 52468312, 52612419, 52756334, 52900054, 53043576, 53186898,
  53330017, 53472931, 53615638, 53758134, 53900418, 54042486, 54184336,
  54325965, 54467372, 54608552, 54749505, 54890226, 55030714, 55170966,
  55310979, 55450751, 55590279, 55729560, 55868593, 56007373, 56145899,
  56284168, 56422177, 56559924, 56697406, 56834620, 56971564, 57108235,
  57244630, 57380747, 57516584, 57652136, 57787402, 57922379, 58057064,
  58191455, 58325549, 58459343, 58592835, 58726021, 58858900, 58991468,
  59123722, 59255660, 59387280, 59518578, 59649552, 59780199, 59910516,
  60040500, 60170150, 60299461, 60428432, 60557059, 60685340, 60813272,
  60940852, 61068078, 61194946, 61321454, 61447599, 61573379, 61698790,
  61823830, 61948496, 62072785, 62196694, 62320221, 62443363, 62566117,
  62688480, 62810449, 62932022, 63053195, 63173967, 63294333, 63414292,
  63533840, 63652975, 63771693, 63889993, 64007870, 64125323, 64242348,
  64358943, 64475104, 64590829, 64706115, 64820960, 64935359, 65049311,
  65162813, 65275861, 65388453, 65500586, 65612257, 65723464, 65834202,
  65944471, 66054265, 66163584, 66272423, 66380781, 66488653, 66596037,
  66702931, 66809331, 66915235, 67020639, 67125541, 67229938, 67333827,
  67437205, 67540069, 67642416, 67744244, 67845548, 67946328, 68046579,
  68146299, 68245484, 68344132, 68442241, 68539806, 68636826, 68733296,
  68829215, 68924580, 69019387, 69113633, 69207316, 69300433, 69392980,
  69484956, 69576356, 69667179, 69757420, 69847078, 69936149, 70024630,
  70112519, 70199812, 70286506, 70372600, 70458089, 70542971, 70627242,
  70710901, 70793944, 70876367, 70958169, 71039346, 71119895, 71199814,
  71279099, 71357748, 71435757, 71513124, 71589846, 71665919, 71741341,
  71816110, 71890221, 71963672, 72036461, 72108584, 72180038, 72250821,
  72320929, 72390359, 72459110, 72527177, 72594558, 72661250, 72727250,
  72792555, 72857162, 72921068, 72984271, 73046767, 73108554, 73169628,
  73229987, 73289628, 73348548, 73406744, 73464213, 73520952, 73576958,
  73632229, 73686762, 73740553, 73793599, 73845899, 73897448, 73948245,
  73998286, 74047568, 74096088, 74143844, 74190833, 74237052, 74282497,
  74327167, 74371058, 74414167, 74456491, 74498028, 74538775, 74578729,
  74617887, 74656246, 74693804, 74730556, 74766502, 74801637, 74835960,
  74869466, 74902154, 74934020, 74965062, 74995277, 75024662, 75053214,
  75080931, 75107809, 75133846, 75159038, 75183384, 75206881, 75229525,
  75251313, 75272244, 75292314, 75311521, 75329861, 75347332, 75363931,
  75379655, 75394502, 75408469, 75421553, 75433752, 75445062, 75455481,
  75465006, 75473634, 75481363, 75488190, 75494112, 75499127, 75503232,
  75506423, 75508699, 75510057, 75510494, 75510007, 75508593, 75506251,
  75502977, 75498768, 75493622, 75487537, 75480509, 75472536, 75463616,
  75453745, 75442921, 75431142, 75418405, 75404706, 75390045, 75374417,
  75357820, 75340253, 75321711, 75302193, 75281696, 75260217, 75237755,
  75214305, 75189867, 75164436, 75138011, 75110589, 75082168, 75052745,
  75022317, 74990882, 74958438, 74924982, 74890511, 74855023, 74818516,
  74780986, 74742433, 74702852, 74662242, 74620600, 74577924, 74534211,
  74489459, 74443665, 74396828, 74348944, 74300011, 74250027, 74198989,
  74146896, 74093744, 74039531, 73984255, 73927914, 73870505, 73812026,
  73752475, 73691848, 73630145, 73567362, 73503498, 73438549, 73372514,
  73305391, 73237177, 73167870, 73097467, 73025967, 72953367, 72879664,
  72804858, 72728945, 72651923, 72573791, 72494545, 72414184, 72332705,
  72250107, 72166387, 72081544, 71995574, 71908476, 71820247, 71730886,
  71640391, 71548759, 71455988, 71362077, 71267022, 71170823, 71073477,
  70974982, 70875335, 70774536, 70672581, 70569470, 70465199, 70359767,
  70253173, 70145413, 70036486, 69926391, 69815124, 69702685, 69589071,
  69474281, 69358312, 69241163, 69122831, 69003315, 68882614, 68760724,
  68637645, 68513374, 68387910, 68261251, 68133395, 68004340, 67874085,
  67742628, 67609966, 67476099, 67341025, 67204741, 67067246, 66928539,
  66788617, 66647480, 66505125, 66361550, 66216755, 66070737, 65923495,
  65775027, 65625332, 65474407, 65322252, 65168865, 65014245, 64858389,
  64701296, 64542965, 64383394, 64222582, 64060527, 63897228, 63732683,
  63566891, 63399850, 63231560, 63062018, 62891223, 62719173, 62545869,
  62371307, 62195487, 62018407, 61840066, 61660463, 61479596, 61297465,
  61114067, 60929401, 60743467, 60556263, 60367788, 60178041, 59987020,
  59794724, 59601152, 59406303, 59210175, 59012769, 58814081, 58614112,
  58412861, 58210325, 58006505, 57801398, 57595005, 57387323, 57178353,
  56968092, 56756540, 56543697, 56329560, 56114129, 55897404, 55679382,
  55460064, 55239448, 55017534, 54794321, 54569807, 54343992, 54116875,
  53888456, 53658733, 53427705, 53195373, 52961735, 52726790, 52490538,
  52252979, 52014110, 51773932, 51532444, 51289646, 51045536, 50800114,
  50553379, 50305332, 50055970, 49805295, 49553305, 49299999, 49045377,
  48789439, 48532184, 48273612, 48013722, 47752513, 47489986, 47226140,
  46960975, 46694489, 46426683, 46157557, 45887110, 45615341, 45342251,
  45067839, 44792105, 44515048, 44236669, 43956967, 43675942, 43393594,
  43109922, 42824927, 42538608, 42250965, 41961998, 41671707, 41380092,
  41087152, 40792889, 40497301, 40200388, 39902152, 39602591, 39301705,
  38999496, 38695962, 38391104, 38084922, 37777416, 37468587, 37158433,
  36846957, 36534157, 36220034, 35904588, 35587820, 35269729, 34950316,
  34629581, 34307525, 33984147, 33659449, 33333430, 33006091, 32677432,
  32347454, 32016157, 31683541, 31349607, 31014356, 30677788, 30339903,
  30000701, 29660185, 29318353, 28975207, 28630747, 28284974, 27937889,
  27589491, 27239783, 26888763, 26536434, 26182796, 25827849, 25471595,
  25114034, 24755167, 24394994, 24033517, 23670736, 23306653, 22941268,
  22574582, 22206595, 21837310, 21466726, 21094846, 20721669, 20347197,
  19971430, 19594371, 19216020, 18836377, 18455445, 18073224, 17689715,
  17304920, 16918840, 16531475, 16142828, 15752899, 15361690, 14969201,
  14575435, 14180392, 13784074, 13386483, 12987618, 12587483, 12186078,
  11783404, 11379464, 10974259, 10567789, 10160057, 9751064, 9340812,
  8929302, 8516536, 8102515, 7687241, 7270716, 6852941, 6433918, 6013649,
  5592135, 5169378, 4745379, 4320142, 3893666, 3465955, 3037010, 2606833,
  2175425, 1742789, 1308927, 873840, 437530, 0, -438749, -878714,
  -1319895, -1762288, -2205891, -2650704, -3096722, -3543945, -3992370,
  -4441994, -4892817, -5344835, -5798047, -6252449, -6708041, -7164819,
  -7622781, -8081925, -8542249, -9003750, -9466426, -9930274, -10395292,
  -10861478, -11328829, -11797343, -12267017, -12737848, -13209835,
  -13682974, -14157263, -14632699, -15109280, -15587003, -16065865,
  -16545864, -17026997, -17509261, -17992654, -18477173, -18962814,
  -19449576, -19937455, -20426448, -20916554, -21407767, -21900087,
  -22393509, -22888032, -23383651, -23880364, -24378168, -24877061,
  -25377038, -25878096, -26380234, -26883447, -27387732, -27893087,
  -28399507, -28906991, -29415534, -29925134, -30435787, -30947490,
  -31460239, -31974032, -32488864, -33004733, -33521636, -34039568,
  -34558526, -35078507, -35599508, -36121524, -36644553, -37168591,
  -37693634, -38219679, -38746722, -39274760, -39803789, -40333804,
  -40864804, -41396783, -41929739, -42463667, -42998563, -43534425,
  -44071247, -44609027, -45147760, -45687443, -46228072, -46769642,
  -47312150, -47855592, -48399964, -48945262, -49491481, -50038619,
  -50586671, -51135632, -51685499, -52236267, -52787933, -53340493,
  -53893941, -54448274, -55003488, -55559578, -56116541, -56674371,
  -57233065, -57792619, -58353027, -58914286, -59476391, -60039338,
  -60603122, -61167739, -61733184, -62299454, -62866543, -63434446,
  -64003160, -64572680, -65143001, -65714119, -66286029, -66858726,
  -67432205, -68006463, -68581493, -69157292, -69733855, -70311177,
  -70889253, -71468078, -72047648, -72627957, -73209001, -73790775,
  -74373274, -74956492, -75540426, -76125070, -76710418, -77296467,
  -77883210, -78470644, -79058762, -79647560, -80237032, -80827174,
  -81417980, -82009445, -82601564, -83194331, -83787742, -84381790,
  -84976472, -85571781, -86167712, -86764260, -87361419, -87959184,
  -88557550, -89156511, -89756062, -90356197, -90956910, -91558197,
  -92160052, -92762468, -93365441, -93968965, -94573035, -95177644,
  -95782787, -96388459, -96994653, -97601364, -98208587, -98816315,
  -99424542, -100033264, -100642473, -101252165, -101862333, -102472972,
  -103084075, -103695637, -104307652, -104920114, -105533016, -106146354,
  -106760120, -107374309, -107988915, -108603931, -109219352, -109835171,
  -110451383, -111067981, -111684959, -112302311, -112920031, -113538112,
  -114156548, -114775333, -115394461, -116013925, -116633719, -117253837,
  -117874272, -118495017, -119116068, -119737416, -120359056, -120980982,
  -121603186, -122225662, -122848404, -123471405, -124094659, -124718159,
  -125341898, -125965871, -126590069, -127214487, -127839118, -128463956,
  -129088992, -129714222, -130339638, -130965233, -131591001, -132216934,
  -132843027, -133469271, -134095661, -134722189, -135348849, -135975634,
  -136602536, -137229549, -137856666, -138483880, -139111183, -139738570,
  -140366032, -140993563, -141621156, -142248804, -142876499, -143504234,
  -144132003, -144759798, -145387612, -146015437, -146643268, -147271095,
  -147898913, -148526714, -149154490, -149782234, -150409940, -151037599,
  -151665205, -152292749, -152920226, -153547626, -154174943, -154802170,
  -155429298, -156056321, -156683231, -157310021, -157936682, -158563208,
  -159189591, -159815823, -160441897, -161067806, -161693540, -162319094,
  -162944459, -163569628, -164194593, -164819346, -165443880, -166068186,
  -166692258, -167316087, -167939666, -168562986, -169186041, -169808822,
  -170431321, -171053531, -171675443, -172297050, -172918344, -173539318,
  -174159962, -174780269, -175400231, -176019841, -176639090, -177257970,
  -177876473, -178494592, -179112317, -179729642, -180346558, -180963056,
  -181579129, -182194769, -182809968, -183424717, -184039008, -184652833,
  -185266184, -185879053, -186491431, -187103311, -187714683, -188325540,
  -188935874, -189545675, -190154937, -190763650, -191371806, -191979397,
  -192586415, -193192850, -193798696, -194403942, -195008582, -195612606,
  -196216006, -196818774, -197420901, -198022379, -198623199, -199223352,
  -199822831, -200421626, -201019730, -201617132, -202213826, -202809803,
  -203405053, -203999568, -204593340, -205186360, -205778619, -206370109,
  -206960821, -207550746, -208139876, -208728202, -209315715, -209902407,
  -210488268, -211073290, -211657465, -212240783, -212823236, -213404815,
  -213985511, -214565315, -215144219, -215722214, -216299290, -216875439,
  -217450653, -218024921, -218598236, -219170588, -219741969, -220312370,
  -220881781, -221450194, -222017599, -222583989, -223149353, -223713683,
  -224276970, -224839205, -225400379, -225960482, -226519507, -227077443,
  -227634282, -228190015, -228744632, -229298125, -229850484, -230401700,
  -230951765, -231500669, -232048403, -232594958, -233140324, -233684493,
  -234227456, -234769203, -235309725, -235849013, -236387058, -236923850,
  -237459380, -237993640, -238526620, -239058310, -239588702, -240117786,
  -240645553, -241171993, -241697098, -242220859, -242743265, -243264307,
  -243783977, -244302265, -244819162, -245334658, -245848744, -246361411,
  -246872650, -247382450, -247890803, -248397700, -248903130, -249407085,
  -249909556, -250410532, -250910005, -251407964, -251904402, -252399308,
  -252892673, -253384487, -253874742, -254363427, -254850533, -255336052,
  -255819972, -256302286, -256782983, -257262054, -257739490, -258215281,
  -258689417, -259161890, -259632689, -260101806, -260569231, -261034953,
  -261498965, -261961256, -262421817, -262880637, -263337709, -263793022,
  -264246567, -264698334, -265148314, -265596497, -266042874, -266487435,
  -266930171, -267371072, -267810128, -268247331, -268682670, -269116136,
  -269547720, -269977411, -270405201, -270831079, -271255037, -271677064,
  -272097152, -272515290, -272931469, -273345680, -273757913, -274168157,
  -274576405, -274982646, -275386871, -275789069, -276189232, -276587351,
  -276983414, -277377413, -277769339, -278159181, -278546930, -278932577,
  -279316112, -279697526, -280076808, -280453949, -280828940, -281201771,
  -281572433, -281940916, -282307210, -282671306, -283033194, -283392865,
  -283750310, -284105518, -284458480, -284809186, -285157627, -285503794,
  -285847677, -286189266, -286528551, -286865524, -287200175, -287532494,
  -287862471, -288190097, -288515363, -288838259, -289158775, -289476902,
  -289792630, -290105951, -290416853, -290725329, -291031368, -291334961,
  -291636098, -291934769, -292230967, -292524680, -292815899, -293104615,
  -293390819, -293674500, -293955650, -294234259, -294510318, -294783816,
  -295054745, -295323096, -295588858, -295852022, -296112579, -296370519,
  -296625834, -296878513, -297128547, -297375927, -297620644, -297862687,
  -298102048, -298338717, -298572685, -298803942, -299032480, -299258288,
  -299481358, -299701680, -299919244, -300134042, -300346064, -300555300,
  -300761742, -300965381, -301166206, -301364208, -301559379, -301751709,
  -301941189, -302127809, -302311561, -302492435, -302670421, -302845511,
  -303017695, -303186965, -303353310, -303516723, -303677192, -303834711,
  -303989268, -304140856, -304289465, -304435086, -304577709, -304717326,
  -304853928, -304987505, -305118048, -305245549, -305369998, -305491386,
  -305609704, -305724944, -305837095, -305946150, -306052098, -306154932,
  -306254642, -306351219, -306444655, -306534939, -306622064, -306706020,
  -306786799, -306864392, -306938789, -307009982, -307077962, -307142720,
  -307204248, -307262536, -307317575, -307369358, -307417875, -307463117,
  -307505075, -307543742, -307579107, -307611163, -307639901, -307665312,
  -307687386, -307706117, -307721495, -307733510, -307742156, -307747423,
  -307749302, -307747785, -307742864, -307734529, -307722773, -307707586,
  -307688961, -307666888, -307641360, -307612367, -307579902, -307543956,
  -307504521, -307461587, -307415147, -307365193, -307311715, -307254707,
  -307194158, -307130062, -307062410, -306991193, -306916403, -306838032,
  -306756072, -306670514, -306581351, -306488574, -306392175, -306292147,
  -306188479, -306081166, -305970198, -305855568, -305737267, -305615288,
  -305489622, -305360261, -305227198, -305090425, -304949933, -304805715,
  -304657762, -304506068, -304350623, -304191420, -304028452, -303861711,
  -303691188, -303516876, -303338767, -303156854, -302971128, -302781583,
  -302588210, -302391001, -302189950, -301985049, -301776289, -301563664,
  -301347165, -301126786, -300902518, -300674355, -300442288, -300206311,
  -299966416, -299722595, -299474842, -299223148, -298967507, -298707910,
  -298444352, -298176824, -297905320, -297629831, -297350352, -297066874,
  -296779390, -296487894, -296192379, -295892836, -295589260, -295281642,
  -294969977, -294654256, -294334474, -294010623, -293682695, -293350685,
  -293014586, -292674389, -292330090, -291981680, -291629153, -291272503,
  -290911722, -290546803, -290177741, -289804529, -289427159, -289045625,
  -288659921, -288270039, -287875974, -287477719, -287075268, -286668613,
  -286257749, -285842669, -285423367, -284999835, -284572069, -284140062,
  -283703807, -283263297, -282818528, -282369493, -281916184, -281458597,
  -280996726, -280530563, -280060103, -279585340, -279106268, -278622881,
  -278135172, -277643137, -277146768, -276646061, -276141009, -275631606,
  -275117847, -274599726, -274077237, -273550374, -273019132, -272483504,
  -271943486, -271399072, -270850256, -270297032, -269739396, -269177341,
  -268610862, -268039954, -267464611, -266884827, -266300599, -265711919,
  -265118783, -264521186, -263919122, -263312586, -262701573, -262086078,
  -261466096, -260841621, -260212648, -259579173, -258941191, -258298696,
  -257651684, -257000149, -256344088, -255683494, -255018363, -254348691,
  -253674472, -252995702, -252312376, -251624490, -250932038, -250235017,
  -249533421, -248827247, -248116489, -247401144, -246681206, -245956672,
  -245227536, -244493795, -243755445, -243012480, -242264897, -241512692,
  -240755860, -239994397, -239228300, -238457563, -237682183, -236902156,
  -236117479, -235328146, -234534154, -233735499, -232932177, -232124185,
  -231311519, -230494175, -229672148, -228845437, -228014036, -227177942,
  -226337152, -225491662, -224641469, -223786568, -222926958, -222062633,
  -221193591, -220319829, -219441343, -218558130, -217670186, -216777509,
  -215880095, -214977941, -214071044, -213159401, -212243009, -211321865,
  -210395966, -209465308, -208529890, -207589708, -206644759, -205695041,
  -204740551, -203781286, -202817243, -201848420, -200874814, -199896423,
  -198913244, -197925275, -196932512, -195934954, -194932599, -193925443,
  -192913485, -191896723, -190875153, -189848774, -188817584, -187781580,
  -186740761, -185695124, -184644668, -183589390, -182529288, -181464360,
  -180394606, -179320022, -178240607, -177156359, -176067277, -174973358,
  -173874601, -172771005, -171662568, -170549288, -169431164, -168308195,
  -167180378, -166047713, -164910199, -163767833, -162620615, -161468543,
  -160311616, -159149834, -157983194, -156811696, -155635339, -154454122,
  -153268044, -152077104, -150881300, -149680633, -148475101, -147264703,
  -146049440, -144829310, -143604312, -142374446, -141139711, -139900107,
  -138655633, -137406289, -136152075, -134892989, -133629032, -132360204,
  -131086504, -129807931, -128524486, -127236169, -125942979, -124644917,
  -123341982, -122034174, -120721494, -119403941, -118081516, -116754219,
  -115422050, -114085009, -112743097, -111396314, -110044660, -108688136,
  -107326742, -105960479, -104589347, -103213348, -101832480, -100446746,
  -99056145, -97660680, -96260349, -94855155, -93445098, -92030179,
  -90610398, -89185758, -87756259, -86321901, -84882687, -83438617,
  -81989693, -80535915, -79077286, -77613805, -76145476, -74672298,
  -73194275, -71711406, -70223693, -68731139, -67233745, -65731512,
  -64224442, -62712537, -61195798, -59674228, -58147828, -56616601,
  -55080547, -53539670, -51993970, -50443451, -48888115, -47327963,
  -45762997, -44193220, -42618635, -41039243, -39455047, -37866049,
  -36272253, -34673659, -33070271, -31462091, -29849123, -28231368,
  -26608829, -24981509, -23349412, -21712538, -20070893, -18424478,
  -16773296, -15117351, -13456645, -11791182, -10120965, -8445996,
  -6766279, -5081818, -3392616, -1698675, 0, 1703406, 3411540, 5124399,
  6841978, 8564275, 10291285, 12023005, 13759430, 15500559, 17246385,
  18996906, 20752118, 22512017, 24276599, 26045859, 27819794, 29598400,
  31381673, 33169607, 34962200, 36759446, 38561342, 40367883, 42179065,
  43994882, 45815332, 47640409, 49470108, 51304425, 53143356, 54986895,
  56835038, 58687780, 60545117, 62407042, 64273553, 66144642, 68020306,
  69900540, 71785337, 73674694, 75568605, 77467064, 79370067, 81277609,
  83189683, 85106284, 87027407, 88953047, 90883198, 92817854, 94757010,
  96700660, 98648799, 100601420, 102558519, 104520088, 106486122,
  108456616, 110431564, 112410958, 114394794, 116383065, 118375765,
  120372889, 122374429, 124380379, 126390734, 128405486, 130424630,
  132448159, 134476066, 136508346, 138544991, 140585995, 142631351,
  144681053, 146735094, 148793467, 150856165, 152923182, 154994510,
  157070143, 159150073, 161234294, 163322799, 165415580, 167512631,
  169613943, 171719511, 173829326, 175943381, 178061669, 180184183,
  182310915, 184441857, 186577003, 188716344, 190859873, 193007582,
  195159464, 197315510, 199475714, 201640066, 203808560, 205981188,
  208157941, 210338811, 212523791, 214712872, 216906046, 219103306,
  221304642, 223510047, 225719513, 227933030, 230150591, 232372188,
  234597811, 236827453, 239061104, 241298757, 243540402, 245786031,
  248035636, 250289207, 252546735, 254808213, 257073630, 259342979,
  261616250, 263893434, 266174523, 268459506, 270748376, 273041122,
  275337736, 277638209, 279942530, 282250692, 284562684, 286878497,
  289198122, 291521549, 293848768, 296179771, 298514547, 300853087,
  303195382, 305541421, 307891194, 310244693, 312601907, 314962825,
  317327440, 319695739, 322067714, 324443354, 326822650, 329205590,
  331592166, 333982366, 336376181, 338773600, 341174613, 343579210,
  345987380, 348399112, 350814397, 353233224, 355655582, 358081460,
  360510849, 362943737, 365380114, 367819968, 370263290, 372710068,
  375160291, 377613949, 380071030, 382531525, 384995420, 387462707,
  389933372, 392407406, 394884798, 397365535, 399849607, 402337002,
  404827710, 407321718, 409819016, 412319591, 414823433, 417330530,
  419840871, 422354443, 424871236, 427391237, 429914435, 432440818,
  434970374, 437503092, 440038960, 442577966, 445120097, 447665343,
  450213690, 452765128, 455319643, 457877224, 460437859, 463001536,
  465568241, 468137964, 470710692, 473286412, 475865112, 478446779,
  481031403, 483618969, 486209465, 488802879, 491399199, 493998411,
  496600503, 499205463, 501813277, 504423933, 507037418, 509653720,
  512272825, 514894721, 517519395, 520146833, 522777023, 525409952,
  528045606, 530683974, 533325040, 535968794, 538615220, 541264306,
  543916039, 546570406, 549227393, 551886986, 554549173, 557213939,
  559881273, 562551159, 565223585, 567898537, 570576001, 573255964,
  575938412, 578623331, 581310708, 584000529, 586692781, 589387448,
  592084519, 594783978, 597485811, 600190006, 602896547, 605605421,
  608316615, 611030112, 613745901, 616463966, 619184293, 621906869,
  624631679, 627358708, 630087943, 632819369, 635552972, 638288737,
  641026651, 643766698, 646508864, 649253135, 651999496, 654747932,
  657498430, 660250974, 663005549, 665762142, 668520737, 671281320,
  674043876, 676808390, 679574848, 682343233, 685113533, 687885731,
  690659813, 693435764, 696213569, 698993212, 701774680, 704557956,
  707343026, 710129874, 712918486, 715708846, 718500939, 721294750,
  724090264, 726887464, 729686337, 732486866, 735289037, 738092833,
  740898240, 743705242, 746513823, 749323968, 752135662, 754948889,
  757763634, 760579880, 763397612, 766216815, 769037473, 771859570,
  774683090, 777508018, 780334339, 783162035, 785991092, 788821493,
  791653222, 794486265, 797320604, 800156225, 802993110, 805831244,
  808670611, 811511195, 814352979, 817195949, 820040087, 822885378,
  825731805, 828579352, 831428004, 834277743, 837128554, 839980420,
  842833325, 845687253, 848542187, 851398111, 854255009, 857112865,
  859971661, 862831382, 865692011, 868553531, 871415927, 874279181,
  877143277, 880008198, 882873929, 885740451, 888607750, 891475807,
  894344607, 897214133, 900084367, 902955294, 905826897, 908699158,
  911572062, 914445591, 917319728, 920194457, 923069761, 925945623,
  928822026, 931698954, 934576388, 937454313, 940332712, 943211567,
  946090861, 948970578, 951850700, 954731211, 957612093, 960493330,
  963374903, 966256797, 969138994, 972021477, 974904229, 977787232,
  980670470, 983553925, 986437580, 989321418, 992205421, 995089573,
  997973855, 1000858252, 1003742745, 1006627317, 1009511951, 1012396630,
  1015281336, 1018166051, 1021050759, 1023935442, 1026820083, 1029704664,
  1032589168, 1035473577, 1038357874, 1041242041, 1044126061, 1047009917,
  1049893591, 1052777065, 1055660322, 1058543344, 1061426114, 1064308615,
  1067190828, 1070072736, 1072954322, 1075835567, 1078716455, 1081596968,
  1084477087, 1087356796, 1090236076, 1093114911, 1095993281, 1098871171,
  1101748561, 1104625435, 1107501774, 1110377561, 1113252778, 1116127408,
  1119001432, 1121874833, 1124747593, 1127619694, 1130491119, 1133361849,
  1136231867, 1139101156, 1141969696, 1144837472, 1147704463, 1150570654,
  1153436026, 1156300560, 1159164240, 1162027048, 1164888964, 1167749973,
  1170610055, 1173469194, 1176327370, 1179184566, 1182040765, 1184895947,
  1187750097, 1190603194, 1193455223, 1196306164, 1199155999, 1202004711,
  1204852283, 1207698695, 1210543930, 1213387970, 1216230797, 1219072393,
  1221912740, 1224751821, 1227589616, 1230426109, 1233261281, 1236095115,
  1238927592, 1241758694, 1244588403, 1247416702, 1250243573, 1253068996,
  1255892955, 1258715432, 1261536408, 1264355866, 1267173787, 1269990154,
  1272804948, 1275618151, 1278429747, 1281239715, 1284048040, 1286854702,
  1289659683, 1292462966, 1295264533, 1298064366, 1300862446, 1303658756,
  1306453277, 1309245992, 1312036883, 1314825932, 1317613121, 1320398431,
  1323181846, 1325963346, 1328742914, 1331520532, 1334296182, 1337069847,
  1339841507, 1342611145, 1345378744, 1348144285, 1350907751, 1353669123,
  1356428383, 1359185514, 1361940498, 1364693317, 1367443952, 1370192386,
  1372938602, 1375682580, 1378424304, 1381163756, 1383900917, 1386635769,
  1389368295, 1392098478, 1394826298, 1397551739, 1400274782, 1402995410,
  1405713605, 1408429348, 1411142623, 1413853411, 1416561695, 1419267457,
  1421970678, 1424671342, 1427369431, 1430064926, 1432757810, 1435448066,
  1438135675, 1440820620, 1443502883, 1446182447, 1448859293, 1451533405,
  1454204764, 1456873353, 1459539154, 1462202150, 1464862322, 1467519654,
  1470174128, 1472825725, 1475474430, 1478120223, 1480763087, 1483403006,
  1486039961, 1488673934, 1491304909, 1493932868, 1496557793, 1499179667,
  1501798473, 1504414192, 1507026808, 1509636304, 1512242661, 1514845862,
  1517445890, 1520042728, 1522636358, 1525226763, 1527813926, 1530397829,
  1532978455, 1535555786, 1538129807, 1540700498, 1543267843, 1545831826,
  1548392428, 1550949632, 1553503421, 1556053779, 1558600688, 1561144130,
  1563684089, 1566220548, 1568753490, 1571282897, 1573808752, 1576331039,
  1578849741, 1581364840, 1583876320, 1586384163, 1588888353, 1591388873,
  1593885705, 1596378834, 1598868242, 1601353912, 1603835828, 1606313972,
  1608788328, 1611258880, 1613725610, 1616188502, 1618647538, 1621102703,
  1623553980, 1626001352, 1628444803, 1630884315, 1633319872, 1635751459,
  1638179057, 1640602651, 1643022225, 1645437761, 1647849243, 1650256655,
  1652659981, 1655059203, 1657454307, 1659845275, 1662232091, 1664614738,
  1666993202, 1669367464, 1671737510, 1674103322, 1676464885, 1678822182,
  1681175198, 1683523917, 1685868321, 1688208396, 1690544125, 1692875492,
  1695202481, 1697525076, 1699843261, 1702157021, 1704466340, 1706771201,
  1709071589, 1711367487, 1713658881, 1715945755, 1718228092, 1720505877,
  1722779095, 1725047729, 1727311765, 1729571186, 1731825977, 1734076122,
  1736321606, 1738562414, 1740798529, 1743029938, 1745256623, 1747478570,
  1749695763, 1751908188, 1754115828, 1756318669, 1758516695, 1760709892,
  1762898243, 1765081734, 1767260350, 1769434075, 1771602895, 1773766795,
  1775925759, 1778079773, 1780228821, 1782372889, 1784511962, 1786646024,
  1788775063, 1790899061, 1793018005, 1795131880, 1797240672, 1799344365,
  1801442945, 1803536397, 1805624707, 1807707860, 1809785843, 1811858639,
  1813926236, 1815988618, 1818045771, 1820097680, 1822144333, 1824185713,
  1826221808, 1828252602, 1830278082, 1832298233, 1834313041, 1836322493,
  1838326575, 1840325271, 1842318569, 1844306454, 1846288912, 1848265930,
  1850237494, 1852203589, 1854164203, 1856119322, 1858068931, 1860013017,
  1861951567, 1863884566, 1865812002, 1867733861, 1869650129, 1871560793,
  1873465840, 1875365256, 1877259027, 1879147141, 1881029585, 1882906344,
  1884777407, 1886642759, 1888502388, 1890356280, 1892204422, 1894046803,
  1895883407, 1897714224, 1899539239, 1901358440, 1903171814, 1904979348,
  1906781030, 1908576847, 1910366786, 1912150835, 1913928980, 1915701210,
  1917467513, 1919227874, 1920982283, 1922730727, 1924473193, 1926209669,
  1927940142, 1929664602, 1931383035, 1933095429, 1934801772, 1936502052,
  1938196258, 1939884376, 1941566396, 1943242305, 1944912092, 1946575744,
  1948233249, 1949884597, 1951529776, 1953168773, 1954801577, 1956428177,
  1958048560, 1959662717, 1961270634, 1962872301, 1964467707, 1966056839,
  1967639687, 1969216240, 1970786486, 1972350414, 1973908014, 1975459273,
  1977004182, 1978542728, 1980074901, 1981600691, 1983120086, 1984633076,
  1986139649, 1987639796, 1989133505, 1990620766, 1992101568, 1993575901,
  1995043754, 1996505116, 1997959979, 1999408330, 2000850159, 2002285457,
  2003714214, 2005136418, 2006552060, 2007961130, 2009363618, 2010759513,
  2012148807, 2013531488, 2014907547, 2016276974, 2017639760, 2018995894,
  2020345368, 2021688171, 2023024294, 2024353727, 2025676460, 2026992485,
  2028301792, 2029604372, 2030900215, 2032189312, 2033471653, 2034747231,
  2036016034, 2037278056, 2038533285, 2039781714, 2041023334, 2042258135,
  2043486109, 2044707247, 2045921540, 2047128980, 2048329558, 2049523265,
  2050710093, 2051890033, 2053063077, 2054229216, 2055388443, 2056540748,
  2057686124, 2058824562, 2059956054, 2061080592, 2062198169, 2063308775,
  2064412403, 2065509045, 2066598694, 2067681340, 2068756978, 2069825598,
  2070887194, 2071941757, 2072989280, 2074029756, 2075063177, 2076089536,
  2077108824, 2078121036, 2079126164, 2080124199, 2081115137, 2082098968,
  2083075686, 2084045285, 2085007757, 2085963094, 2086911292, 2087852341,
  2088786237, 2089712971, 2090632538, 2091544930, 2092450142, 2093348167,
  2094238997, 2095122628, 2095999052, 2096868263, 2097730255, 2098585021,
  2099432556, 2100272854, 2101105908, 2101931712, 2102750261, 2103561548,
  2104365568, 2105162315, 2105951783, 2106733967, 2107508860, 2108276458,
  2109036754, 2109789744, 2110535421, 2111273781, 2112004818, 2112728527,
  2113444903, 2114153940, 2114855633, 2115549978, 2116236969, 2116916601,
  2117588870, 2118253770, 2118911297, 2119561447, 2120204213, 2120839593,
  2121467580, 2122088171, 2122701361, 2123307146, 2123905522, 2124496483,
  2125080026, 2125656147, 2126224841, 2126786104, 2127339932, 2127886322,
  2128425269, 2128956770, 2129480819, 2129997415, 2130506553, 2131008229,
  2131502440, 2131989182, 2132468452, 2132940246, 2133404560, 2133861392,
  2134310739, 2134752596, 2135186961, 2135613830, 2136033201, 2136445070,
  2136849435, 2137246292, 2137635639, 2138017473, 2138391791, 2138758590,
  2139117868, 2139469622, 2139813850, 2140150549, 2140479716, 2140801350,
  2141115448, 2141422007, 2141721026, 2142012503, 2142296434, 2142572819,
  2142841655, 2143102940, 2143356672, 2143602850, 2143841472, 2144072535,
  2144296039, 2144511982, 2144720361, 2144921177, 2145114426, 2145300109,
  2145478223, 2145648767, 2145811739, 2145967140, 2146114967, 2146255220,
  2146387897, 2146512998, 2146630522, 2146740467, 2146842833, 2146937620,
  2147024826, 2147104451, 2147176495, 2147240956, 2147297835, 2147347131,
  2147388843, 2147422972, 2147449517, 2147468478, 2147479854, 2147483646,
  2147479854, 2147468478, 2147449517, 2147422972, 2147388843, 2147347131,
  2147297835, 2147240956, 2147176495, 2147104451, 2147024826, 2146937620,
  2146842833, 2146740467, 2146630522, 2146512998, 2146387897, 2146255220,
  2146114967, 2145967140, 2145811739, 2145648767, 2145478223, 2145300109,
  2145114426, 2144921177, 2144720361, 2144511982, 2144296039, 2144072535,
  2143841472, 2143602850, 2143356672, 2143102940, 2142841655, 2142572819,
  2142296434, 2142012503, 2141721026, 2141422007, 2141115448, 2140801350,
  2140479716, 2140150549, 2139813850, 2139469622, 2139117868, 2138758590,
  2138391791, 2138017473, 2137635639, 2137246292, 2136849435, 2136445070,
  2136033201, 2135613830, 2135186961, 2134752596, 2134310739, 2133861392,
  2133404560, 2132940246, 2132468452, 2131989182, 2131502440, 2131008229,
  2130506553, 2129997415, 2129480819, 2128956770, 2128425269, 2127886322,
  2127339932, 2126786104, 2126224841, 2125656147, 2125080026, 2124496483,
  2123905522, 2123307146, 2122701361, 2122088171, 2121467580, 2120839593,
  2120204213, 2119561447, 2118911297, 2118253770, 2117588870, 2116916601,
  2116236969, 2115549978, 2114855633, 2114153940, 2113444903, 2112728527,
  2112004818, 2111273781, 2110535421, 2109789744, 2109036754, 2108276458,
  2107508860, 2106733967, 2105951783, 2105162315, 2104365568, 2103561548,
  2102750261, 2101931712, 2101105908, 2100272854, 2099432556, 2098585021,
  2097730255, 2096868263, 2095999052, 2095122628, 2094238997, 2093348167,
  2092450142, 2091544930, 2090632538, 2089712971, 2088786237, 2087852341,
  2086911292, 2085963094, 2085007757, 2084045285, 2083075686, 2082098968,
  2081115137, 2080124199, 2079126164, 2078121036, 2077108824, 2076089536,
  2075063177, 2074029756, 2072989280, 2071941757, 2070887194, 2069825598,
  2068756978, 2067681340, 2066598694, 2065509045, 2064412403, 2063308775,
  2062198169, 2061080592, 2059956054, 2058824562, 2057686124, 2056540748,
  2055388443, 2054229216, 2053063077, 2051890033, 2050710093, 2049523265,
  2048329558, 2047128980, 2045921540, 2044707247, 2043486109, 2042258135,
  2041023334, 2039781714, 2038533285, 2037278056, 2036016034, 2034747231,
  2033471653, 2032189312, 2030900215, 2029604372, 2028301792, 2026992485,
  2025676460, 2024353727, 2023024294, 2021688171, 2020345368, 2018995894,
  2017639760, 2016276974, 2014907547, 2013531488, 2012148807, 2010759513,
  2009363618, 2007961130, 2006552060, 2005136418, 2003714214, 2002285457,
  2000850159, 1999408330, 1997959979, 1996505116, 1995043754, 1993575901,
  1992101568, 1990620766, 1989133505, 1987639796, 1986139649, 1984633076,
  1983120086, 1981600691, 1980074901, 1978542728, 1977004182, 1975459273,
  1973908014, 1972350414, 1970786486, 1969216240, 1967639687, 1966056839,
  1964467707, 1962872301, 1961270634, 1959662717, 1958048560, 1956428177,
  1954801577, 1953168773, 1951529776, 1949884597, 1948233249, 1946575744,
  1944912092, 1943242305, 1941566396, 1939884376, 1938196258, 1936502052,
  1934801772, 1933095429, 1931383035, 1929664602, 1927940142, 1926209669,
  1924473193, 1922730727, 1920982283, 1919227874, 1917467513, 1915701210,
  1913928980, 1912150835, 1910366786, 1908576847, 1906781030, 1904979348,
  1903171814, 1901358440, 1899539239, 1897714224, 1895883407, 1894046803,
  1892204422, 1890356280, 1888502388, 1886642759, 1884777407, 1882906344,
  1881029585, 1879147141, 1877259027, 1875365256, 1873465840, 1871560793,
  1869650129, 1867733861, 1865812002, 1863884566, 1861951567, 1860013017,
  1858068931, 1856119322, 1854164203, 1852203589, 1850237494, 1848265930,
  1846288912, 1844306454, 1842318569, 1840325271, 1838326575, 1836322493,
  1834313041, 1832298233, 1830278082, 1828252602, 1826221808, 1824185713,
  1822144333, 1820097680, 1818045771, 1815988618, 1813926236, 1811858639,
  1809785843, 1807707860, 1805624707, 1803536397, 1801442945, 1799344365,
  1797240672, 1795131880, 1793018005, 1790899061, 1788775063, 1786646024,
  1784511962, 1782372889, 1780228821, 1778079773, 1775925759, 1773766795,
  1771602895, 1769434075, 1767260350, 1765081734, 1762898243, 1760709892,
  1758516695, 1756318669, 1754115828, 1751908188, 1749695763, 1747478570,
  1745256623, 1743029938, 1740798529, 1738562414, 1736321606, 1734076122,
  1731825977, 1729571186, 1727311765, 1725047729, 1722779095, 1720505877,
  1718228092, 1715945755, 1713658881, 1711367487, 1709071589, 1706771201,
  1704466340, 1702157021, 1699843261, 1697525076, 1695202481, 1692875492,
  1690544125, 1688208396, 1685868321, 1683523917, 1681175198, 1678822182,
  1676464885, 1674103322, 1671737510, 1669367464, 1666993202, 1664614738,
  1662232091, 1659845275, 1657454307, 1655059203, 1652659981, 1650256655,
  1647849243, 1645437761, 1643022225, 1640602651, 1638179057, 1635751459,
  1633319872, 1630884315, 1628444803, 1626001352, 1623553980, 1621102703,
  1618647538, 1616188502, 1613725610, 1611258880, 1608788328, 1606313972,
  1603835828, 1601353912, 1598868242, 1596378834, 1593885705, 1591388873,
  1588888353, 1586384163, 1583876320, 1581364840, 1578849741, 1576331039,
  1573808752, 1571282897, 1568753490, 1566220548, 1563684089, 1561144130,
  1558600688, 1556053779, 1553503421, 1550949632, 1548392428, 1545831826,
  1543267843, 1540700498, 1538129807, 1535555786, 1532978455, 1530397829,
  1527813926, 1525226763, 1522636358, 1520042728, 1517445890, 1514845862,
  1512242661, 1509636304, 1507026808, 1504414192, 1501798473, 1499179667,
  1496557793, 1493932868, 1491304909, 1488673934, 1486039961, 1483403006,
  1480763087, 1478120223, 1475474430, 1472825725, 1470174128, 1467519654,
  1464862322, 1462202150, 1459539154, 1456873353, 1454204764, 1451533405,
  1448859293, 1446182447, 1443502883, 1440820620, 1438135675, 1435448066,
  1432757810, 1430064926, 1427369431, 1424671342, 1421970678, 1419267457,
  1416561695, 1413853411, 1411142623, 1408429348, 1405713605, 1402995410,
  1400274782, 1397551739, 1394826298, 1392098478, 1389368295, 1386635769,
  1383900917, 1381163756, 1378424304, 1375682580, 1372938602, 1370192386,
  1367443952, 1364693317, 1361940498, 1359185514, 1356428383, 1353669123,
  1350907751, 1348144285, 1345378744, 1342611145, 1339841507, 1337069847,
  1334296182, 1331520532, 1328742914, 1325963346, 1323181846, 1320398431,
  1317613121, 1314825932, 1312036883, 1309245992, 1306453277, 1303658756,
  1300862446, 1298064366, 1295264533, 1292462966, 1289659683, 1286854702,
  1284048040, 1281239715, 1278429747, 1275618151, 1272804948, 1269990154,
  1267173787, 1264355866, 1261536408, 1258715432, 1255892955, 1253068996,
  1250243573, 1247416702, 1244588403, 1241758694, 1238927592, 1236095115,
  1233261281, 1230426109, 1227589616, 1224751821, 1221912740, 1219072393,
  1216230797, 1213387970, 1210543930, 1207698695, 1204852283, 1202004711,
  1199155999, 1196306164, 1193455223, 1190603194, 1187750097, 1184895947,
  1182040765, 1179184566, 1176327370, 1173469194, 1170610055, 1167749973,
  1164888964, 1162027048, 1159164240, 1156300560, 1153436026, 1150570654,
  1147704463, 1144837472, 1141969696, 1139101156, 1136231867, 1133361849,
  1130491119, 1127619694, 1124747593, 1121874833, 1119001432, 1116127408,
  1113252778, 1110377561, 1107501774, 1104625435, 1101748561, 1098871171,
  1095993281, 1093114911, 1090236076, 1087356796, 1084477087, 1081596968,
  1078716455, 1075835567, 1072954322, 1070072736, 1067190828, 1064308615,
  1061426114, 1058543344, 1055660322, 1052777065, 1049893591, 1047009917,
  1044126061, 1041242041, 1038357874, 1035473577, 1032589168, 1029704664,
  1026820083, 1023935442, 1021050759, 1018166051, 1015281336, 1012396630,
  1009511951, 1006627317, 1003742745, 1000858252, 997973855, 995089573,
  992205421, 989321418, 986437580, 983553925, 980670470, 977787232,
  974904229, 972021477, 969138994, 966256797, 963374903, 960493330,
  957612093, 954731211, 951850700, 948970578, 946090861, 943211567,
  940332712, 937454313, 934576388, 931698954, 928822026, 925945623,
  923069761, 920194457, 917319728, 914445591, 911572062, 908699158,
  905826897, 902955294, 900084367, 897214133, 894344607, 891475807,
  888607750, 885740451, 882873929, 880008198, 877143277, 874279181,
  871415927, 868553531, 865692011, 862831382, 859971661, 857112865,
  854255009, 851398111, 848542187, 845687253, 842833325, 839980420,
  837128554, 834277743, 831428004, 828579352, 825731805, 822885378,
  820040087, 817195949, 814352979, 811511195, 808670611, 805831244,
  802993110, 800156225, 797320604, 794486265, 791653222, 788821493,
  785991092, 783162035, 780334339, 777508018, 774683090, 771859570,
  769037473, 766216815, 763397612, 760579880, 757763634, 754948889,
  752135662, 749323968, 746513823, 743705242, 740898240, 738092833,
  735289037, 732486866, 729686337, 726887464, 724090264, 721294750,
  718500939, 715708846, 712918486, 710129874, 707343026, 704557956,
  701774680, 698993212, 696213569, 693435764, 690659813, 687885731,
  685113533, 682343233, 679574848, 676808390, 674043876, 671281320,
  668520737, 665762142, 663005549, 660250974, 657498430, 654747932,
  651999496, 649253135, 646508864, 643766698, 641026651, 638288737,
  635552972, 632819369, 630087943, 627358708, 624631679, 621906869,
  619184293, 616463966, 613745901, 611030112, 608316615, 605605421,
  602896547, 600190006, 597485811, 594783978, 592084519, 589387448,
  586692781, 584000529, 581310708, 578623331, 575938412, 573255964,
  570576001, 567898537, 565223585, 562551159, 559881273, 557213939,
  554549173, 551886986, 549227393, 546570406, 543916039, 541264306,
  538615220, 535968794, 533325040, 530683974, 528045606, 525409952,
  522777023, 520146833, 517519395, 514894721, 512272825, 509653720,
  507037418, 504423933, 501813277, 499205463, 496600503, 493998411,
  491399199, 488802879, 486209465, 483618969, 481031403, 478446779,
  475865112, 473286412, 470710692, 468137964, 465568241, 463001536,
  460437859, 457877224, 455319643, 452765128, 450213690, 447665343,
  445120097, 442577966, 440038960, 437503092, 434970374, 432440818,
  429914435, 427391237, 424871236, 422354443, 419840871, 417330530,
  414823433, 412319591, 409819016, 407321718, 404827710, 402337002,
  399849607, 397365535, 394884798, 392407406, 389933372, 387462707,
  384995420, 382531525, 380071030, 377613949, 375160291, 372710068,
  370263290, 367819968, 365380114, 362943737, 360510849, 358081460,
  355655582, 353233224, 350814397, 348399112, 345987380, 343579210,
  341174613, 338773600, 336376181, 333982366, 331592166, 329205590,
  326822650, 324443354, 322067714, 319695739, 317327440, 314962825,
  312601907, 310244693, 307891194, 305541421, 303195382, 300853087,
  298514547, 296179771, 293848768, 291521549, 289198122, 286878497,
  284562684, 282250692, 279942530, 277638209, 275337736, 273041122,
  270748376, 268459506, 266174523, 263893434, 261616250, 259342979,
  257073630, 254808213, 252546735, 250289207, 248035636, 245786031,
  243540402, 241298757, 239061104, 236827453, 234597811, 232372188,
  230150591, 227933030, 225719513, 223510047, 221304642, 219103306,
  216906046, 214712872, 212523791, 210338811, 208157941, 205981188,
  203808560, 201640066, 199475714, 197315510, 195159464, 193007582,
  190859873, 188716344, 186577003, 184441857, 182310915, 180184183,
  178061669, 175943381, 173829326, 171719511, 169613943, 167512631,
  165415580, 163322799, 161234294, 159150073, 157070143, 154994510,
  152923182, 150856165, 148793467, 146735094, 144681053, 142631351,
  140585995, 138544991, 136508346, 134476066, 132448159, 130424630,
  128405486, 126390734, 124380379, 122374429, 120372889, 118375765,
  116383065, 114394794, 112410958, 110431564, 108456616, 106486122,
  104520088, 102558519, 100601420, 98648799, 96700660, 94757010,
  92817854, 90883198, 88953047, 87027407, 85106284, 83189683, 81277609,
  79370067, 77467064, 75568605, 73674694, 71785337, 69900540, 68020306,
  66144642, 64273553, 62407042, 60545117, 58687780, 56835038, 54986895,
  53143356, 51304425, 49470108, 47640409, 45815332, 43994882, 42179065,
  40367883, 38561342, 36759446, 34962200, 33169607, 31381673, 29598400,
  27819794, 26045859, 24276599, 22512017, 20752118, 18996906, 17246385,
  15500559, 13759430, 12023005, 10291285, 8564275, 6841978, 5124399,
  3411540, 1703406, 0, -1698675, -3392616, -5081818, -6766279, -8445996,
  -10120965, -11791182, -13456645, -15117351, -16773296, -18424478,
  -20070893, -21712538, -23349412, -24981509, -26608829, -28231368,
  -29849123, -31462091, -33070271, -34673659, -36272253, -37866049,
  -39455047, -41039243, -42618635, -44193220, -45762997, -47327963,
  -48888115, -50443451, -51993970, -53539670, -55080547, -56616601,
  -58147828, -59674228, -61195798, -62712537, -64224442, -65731512,
  -67233745, -68731139, -70223693, -71711406, -73194275, -74672298,
  -76145476, -77613805, -79077286, -80535915, -81989693, -83438617,
  -84882687, -86321901, -87756259, -89185758, -90610398, -92030179,
  -93445098, -94855155, -96260349, -97660680, -99056145, -100446746,
  -101832480, -103213348, -104589347, -105960479, -107326742, -108688136,
  -110044660, -111396314, -112743097, -114085009, -115422050, -116754219,
  -118081516, -119403941, -120721494, -122034174, -123341982, -124644917,
  -125942979, -127236169, -128524486, -129807931, -131086504, -132360204,
  -133629032, -134892989, -136152075, -137406289, -138655633, -139900107,
  -141139711, -142374446, -143604312, -144829310, -146049440, -147264703,
  -148475101, -149680633, -150881300, -152077104, -153268044, -154454122,
  -155635339, -156811696, -157983194, -159149834, -160311616, -161468543,
  -162620615, -163767833, -164910199, -166047713, -167180378, -168308195,
  -169431164, -170549288, -171662568, -172771005, -173874601, -174973358,
  -176067277, -177156359, -178240607, -179320022, -180394606, -181464360,
  -182529288, -183589390, -184644668, -185695124, -186740761, -187781580,
  -188817584, -189848774, -190875153, -191896723, -192913485, -193925443,
  -194932599, -195934954, -196932512, -197925275, -198913244, -199896423,
  -200874814, -201848420, -202817243, -203781286, -204740551, -205695041,
  -206644759, -207589708, -208529890, -209465308, -210395966, -211321865,
  -212243009, -213159401, -214071044, -214977941, -215880095, -216777509,
  -217670186, -218558130, -219441343, -220319829, -221193591, -222062633,
  -222926958, -223786568, -224641469, -225491662, -226337152, -227177942,
  -228014036, -228845437, -229672148, -230494175, -231311519, -232124185,
  -232932177, -233735499, -234534154, -235328146, -236117479, -236902156,
  -237682183, -238457563, -239228300, -239994397, -240755860, -241512692,
  -242264897, -243012480, -243755445, -244493795, -245227536, -245956672,
  -246681206, -247401144, -248116489, -248827247, -249533421, -250235017,
  -250932038, -251624490, -252312376, -252995702, -253674472, -254348691,
  -255018363, -255683494, -256344088, -257000149, -257651684, -258298696,
  -258941191, -259579173, -260212648, -260841621, -261466096, -262086078,
  -262701573, -263312586, -263919122, -264521186, -265118783, -265711919,
  -266300599, -266884827, -267464611, -268039954, -268610862, -269177341,
  -269739396, -270297032, -270850256, -271399072, -271943486, -272483504,
  -273019132, -273550374, -274077237, -274599726, -275117847, -275631606,
  -276141009, -276646061, -277146768, -277643137, -278135172, -278622881,
  -279106268, -279585340, -280060103, -280530563, -280996726, -281458597,
  -281916184, -282369493, -282818528, -283263297, -283703807, -284140062,
  -284572069, -284999835, -285423367, -285842669, -286257749, -286668613,
  -287075268, -287477719, -287875974, -288270039, -288659921, -289045625,
  -289427159, -289804529, -290177741, -290546803, -290911722, -291272503,
  -291629153, -291981680, -292330090, -292674389, -293014586, -293350685,
  -293682695, -294010623, -294334474, -294654256, -294969977, -295281642,
  -295589260, -295892836, -296192379, -296487894, -296779390, -297066874,
  -297350352, -297629831, -297905320, -298176824, -298444352, -298707910,
  -298967507, -299223148, -299474842, -299722595, -299966416, -300206311,
  -300442288, -300674355, -300902518, -301126786, -301347165, -301563664,
  -301776289, -301985049, -302189950, -302391001, -302588210, -302781583,
  -302971128, -303156854, -303338767, -303516876, -303691188, -303861711,
  -304028452, -304191420, -304350623, -304506068, -304657762, -304805715,
  -304949933, -305090425, -305227198, -305360261, -305489622, -305615288,
  -305737267, -305855568, -305970198, -306081166, -306188479, -306292147,
  -306392175, -306488574, -306581351, -306670514, -306756072, -306838032,
  -306916403, -306991193, -307062410, -307130062, -307194158, -307254707,
  -307311715, -307365193, -307415147, -307461587, -307504521, -307543956,
  -307579902, -307612367, -307641360, -307666888, -307688961, -307707586,
  -307722773, -307734529, -307742864, -307747785, -307749302, -307747423,
  -307742156, -307733510, -307721495, -307706117, -307687386, -307665312,
  -307639901, -307611163, -307579107, -307543742, -307505075, -307463117,
  -307417875, -307369358, -307317575, -307262536, -307204248, -307142720,
  -307077962, -307009982, -306938789, -306864392, -306786799, -306706020,
  -306622064, -306534939, -306444655, -306351219, -306254642, -306154932,
  -306052098, -305946150, -305837095, -305724944, -305609704, -305491386,
  -305369998, -305245549, -305118048, -304987505, -304853928, -304717326,
  -304577709, -304435086, -304289465, -304140856, -303989268, -303834711,
  -303677192, -303516723, -303353310, -303186965, -303017695, -302845511,
  -302670421, -302492435, -302311561, -302127809, -301941189, -301751709,
  -301559379, -301364208, -301166206, -300965381, -300761742, -300555300,
  -300346064, -300134042, -299919244, -299701680, -299481358, -299258288,
  -299032480, -298803942, -298572685, -298338717, -298102048, -297862687,
  -297620644, -297375927, -297128547, -296878513, -296625834, -296370519,
  -296112579, -295852022, -295588858, -295323096, -295054745, -294783816,
  -294510318, -294234259, -293955650, -293674500, -293390819, -293104615,
  -292815899, -292524680, -292230967, -291934769, -291636098, -291334961,
  -291031368, -290725329, -290416853, -290105951, -289792630, -289476902,
  -289158775, -288838259, -288515363, -288190097, -287862471, -287532494,
  -287200175, -286865524, -286528551, -286189266, -285847677, -285503794,
  -285157627, -284809186, -284458480, -284105518, -283750310, -283392865,
  -283033194, -282671306, -282307210, -281940916, -281572433, -281201771,
  -280828940, -280453949, -280076808, -279697526, -279316112, -278932577,
  -278546930, -278159181, -277769339, -277377413, -276983414, -276587351,
  -276189232, -275789069, -275386871, -274982646, -274576405, -274168157,
  -273757913, -273345680, -272931469, -272515290, -272097152, -271677064,
  -271255037, -270831079, -270405201, -269977411, -269547720, -269116136,
  -268682670, -268247331, -267810128, -267371072, -266930171, -266487435,
  -266042874, -265596497, -265148314, -264698334, -264246567, -263793022,
  -263337709, -262880637, -262421817, -261961256, -261498965, -261034953,
  -260569231, -260101806, -259632689, -259161890, -258689417, -258215281,
  -257739490, -257262054, -256782983, -256302286, -255819972, -255336052,
  -254850533, -254363427, -253874742, -253384487, -252892673, -252399308,
  -251904402, -251407964, -250910005, -250410532, -249909556, -249407085,
  -248903130, -248397700, -247890803, -247382450, -246872650, -246361411,
  -245848744, -245334658, -244819162, -244302265, -243783977, -243264307,
  -242743265, -242220859, -241697098, -241171993, -240645553, -240117786,
  -239588702, -239058310, -238526620, -237993640, -237459380, -236923850,
  -236387058, -235849013, -235309725, -234769203, -234227456, -233684493,
  -233140324, -232594958, -232048403, -231500669, -230951765, -230401700,
  -229850484, -229298125, -228744632, -228190015, -227634282, -227077443,
  -226519507, -225960482, -225400379, -224839205, -224276970, -223713683,
  -223149353, -222583989, -222017599, -221450194, -220881781, -220312370,
  -219741969, -219170588, -218598236, -218024921, -217450653, -216875439,
  -216299290, -215722214, -215144219, -214565315, -213985511, -213404815,
  -212823236, -212240783, -211657465, -211073290, -210488268, -209902407,
  -209315715, -208728202, -208139876, -207550746, -206960821, -206370109,
  -205778619, -205186360, -204593340, -203999568, -203405053, -202809803,
  -202213826, -201617132, -201019730, -200421626, -199822831, -199223352,
  -198623199, -198022379, -197420901, -196818774, -196216006, -195612606,
  -195008582, -194403942, -193798696, -193192850, -192586415, -191979397,
  -191371806, -190763650, -190154937, -189545675, -188935874, -188325540,
  -187714683, -187103311, -186491431, -185879053, -185266184, -184652833,
  -184039008, -183424717, -182809968, -182194769, -181579129, -180963056,
  -180346558, -179729642, -179112317, -178494592, -177876473, -177257970,
  -176639090, -176019841, -175400231, -174780269, -174159962, -173539318,
  -172918344, -172297050, -171675443, -171053531, -170431321, -169808822,
  -169186041, -168562986, -167939666, -167316087, -166692258, -166068186,
  -165443880, -164819346, -164194593, -163569628, -162944459, -162319094,
  -161693540, -161067806, -160441897, -159815823, -159189591, -158563208,
  -157936682, -157310021, -156683231, -156056321, -155429298, -154802170,
  -154174943, -153547626, -152920226, -152292749, -151665205, -151037599,
  -150409940, -149782234, -149154490, -148526714, -147898913, -147271095,
  -146643268, -146015437, -145387612, -144759798, -144132003, -143504234,
  -142876499, -142248804, -141621156, -140993563, -140366032, -139738570,
  -139111183, -138483880, -137856666, -137229549, -136602536, -135975634,
  -135348849, -134722189, -134095661, -133469271, -132843027, -132216934,
  -131591001, -130965233, -130339638, -129714222, -129088992, -128463956,
  -127839118, -127214487, -126590069, -125965871, -125341898, -124718159,
  -124094659, -123471405, -122848404, -122225662, -121603186, -120980982,
  -120359056, -119737416, -119116068, -118495017, -117874272, -117253837,
  -116633719, -116013925, -115394461, -114775333, -114156548, -113538112,
  -112920031, -112302311, -111684959, -111067981, -110451383, -109835171,
  -109219352, -108603931, -107988915, -107374309, -106760120, -106146354,
  -105533016, -104920114, -104307652, -103695637, -103084075, -102472972,
  -101862333, -101252165, -100642473, -100033264, -99424542, -98816315,
  -98208587, -97601364, -96994653, -96388459, -95782787, -95177644,
  -94573035, -93968965, -93365441, -92762468, -92160052, -91558197,
  -90956910, -90356197, -89756062, -89156511, -88557550, -87959184,
  -87361419, -86764260, -86167712, -85571781, -84976472, -84381790,
  -83787742, -83194331, -82601564, -82009445, -81417980, -80827174,
  -80237032, -79647560, -79058762, -78470644, -77883210, -77296467,
  -76710418, -76125070, -75540426, -74956492, -74373274, -73790775,
  -73209001, -72627957, -72047648, -71468078, -70889253, -70311177,
  -69733855, -69157292, -68581493, -68006463, -67432205, -66858726,
  -66286029, -65714119, -65143001, -64572680, -64003160, -63434446,
  -62866543, -62299454, -61733184, -61167739, -60603122, -60039338,
  -59476391, -58914286, -58353027, -57792619, -57233065, -56674371,
  -56116541, -55559578, -55003488, -54448274, -53893941, -53340493,
  -52787933, -52236267, -51685499, -51135632, -50586671, -50038619,
  -49491481, -48945262, -48399964, -47855592, -47312150, -46769642,
  -46228072, -45687443, -45147760, -44609027, -44071247, -43534425,
  -42998563, -42463667, -41929739, -41396783, -40864804, -40333804,
  -39803789, -39274760, -38746722, -38219679, -37693634, -37168591,
  -36644553, -36121524, -35599508, -35078507, -34558526, -34039568,
  -33521636, -33004733, -32488864, -31974032, -31460239, -30947490,
  -30435787, -29925134, -29415534, -28906991, -28399507, -27893087,
  -27387732, -26883447, -26380234, -25878096, -25377038, -24877061,
  -24378168, -23880364, -23383651, -22888032, -22393509, -21900087,
  -21407767, -20916554, -20426448, -19937455, -19449576, -18962814,
  -18477173, -17992654, -17509261, -17026997, -16545864, -16065865,
  -15587003, -15109280, -14632699, -14157263, -13682974, -13209835,
  -12737848, -12267017, -11797343, -11328829, -10861478, -10395292,
  -9930274, -9466426, -9003750, -8542249, -8081925, -7622781, -7164819,
  -6708041, -6252449, -5798047, -5344835, -4892817, -4441994, -3992370,
  -3543945, -3096722, -2650704, -2205891, -1762288, -1319895, -878714,
  -438749, 0, 437530, 873840, 1308927, 1742789, 2175425, 2606833,
  3037010, 3465955, 3893666, 4320142, 4745379, 5169378, 5592135, 6013649,
  6433918, 6852941, 7270716, 7687241, 8102515, 8516536, 8929302, 9340812,
  9751064, 10160057, 10567789, 10974259, 11379464, 11783404, 12186078,
  12587483, 12987618, 13386483, 13784074, 14180392, 14575435, 14969201,
  15361690, 15752899, 16142828, 16531475, 16918840, 17304920, 17689715,
  18073224, 18455445, 18836377, 19216020, 19594371, 19971430, 20347197,
  20721669, 21094846, 21466726, 21837310, 22206595, 22574582, 22941268,
  23306653, 23670736, 24033517, 24394994, 24755167, 25114034, 25471595,
  25827849, 26182796, 26536434, 26888763, 27239783, 27589491, 27937889,
  28284974, 28630747, 28975207, 29318353, 29660185, 30000701, 30339903,
  30677788, 31014356, 31349607, 31683541, 32016157, 32347454, 32677432,
  33006091, 33333430, 33659449, 33984147, 34307525, 34629581, 34950316,
  35269729, 35587820, 35904588, 36220034, 36534157, 36846957, 37158433,
  37468587, 37777416, 38084922, 38391104, 38695962, 38999496, 39301705,
  39602591, 39902152, 40200388, 40497301, 40792889, 41087152, 41380092,
  41671707, 41961998, 42250965, 42538608, 42824927, 43109922, 43393594,
  43675942, 43956967, 44236669, 44515048, 44792105, 45067839, 45342251,
  45615341, 45887110, 46157557, 46426683, 46694489, 46960975, 47226140,
  47489986, 47752513, 48013722, 48273612, 48532184, 48789439, 49045377,
  49299999, 49553305, 49805295, 50055970, 50305332, 50553379, 50800114,
  51045536, 51289646, 51532444, 51773932, 52014110, 52252979, 52490538,
  52726790, 52961735, 53195373, 53427705, 53658733, 53888456, 54116875,
  54343992, 54569807, 54794321, 55017534, 55239448, 55460064, 55679382,
  55897404, 56114129, 56329560, 56543697, 56756540, 56968092, 57178353,
  57387323, 57595005, 57801398, 58006505, 58210325, 58412861, 58614112,
  58814081, 59012769, 59210175, 59406303, 59601152, 59794724, 59987020,
  60178041, 60367788, 60556263, 60743467, 60929401, 61114067, 61297465,
  61479596, 61660463, 61840066, 62018407, 62195487, 62371307, 62545869,
  62719173, 62891223, 63062018, 63231560, 63399850, 63566891, 63732683,
  63897228, 64060527, 64222582, 64383394, 64542965, 64701296, 64858389,
  65014245, 65168865, 65322252, 65474407, 65625332, 65775027, 65923495,
  66070737, 66216755, 66361550, 66505125, 66647480, 66788617, 66928539,
  67067246, 67204741, 67341025, 67476099, 67609966, 67742628, 67874085,
  68004340, 68133395, 68261251, 68387910, 68513374, 68637645, 68760724,
  68882614, 69003315, 69122831, 69241163, 69358312, 69474281, 69589071,
  69702685, 69815124, 69926391, 70036486, 70145413, 70253173, 70359767,
  70465199, 70569470, 70672581, 70774536, 70875335, 70974982, 71073477,
  71170823, 71267022, 71362077, 71455988, 71548759, 71640391, 71730886,
  71820247, 71908476, 71995574, 72081544, 72166387, 72250107, 72332705,
  72414184, 72494545, 72573791, 72651923, 72728945, 72804858, 72879664,
  72953367, 73025967, 73097467, 73167870, 73237177, 73305391, 73372514,
  73438549, 73503498, 73567362, 73630145, 73691848, 73752475, 73812026,
  73870505, 73927914, 73984255, 74039531, 74093744, 74146896, 74198989,
  74250027, 74300011, 74348944, 74396828, 74443665, 74489459, 74534211,
  74577924, 74620600, 74662242, 74702852, 74742433, 74780986, 74818516,
  74855023, 74890511, 74924982, 74958438, 74990882, 75022317, 75052745,
  75082168, 75110589, 75138011, 75164436, 75189867, 75214305, 75237755,
  75260217, 75281696, 75302193, 75321711, 75340253, 75357820, 75374417,
  75390045, 75404706, 75418405, 75431142, 75442921, 75453745, 75463616,
  75472536, 75480509, 75487537, 75493622, 75498768, 75502977, 75506251,
  75508593, 75510007, 75510494, 75510057, 75508699, 75506423, 75503232,
  75499127, 75494112, 75488190, 75481363, 75473634, 75465006, 75455481,
  75445062, 75433752, 75421553, 75408469, 75394502, 75379655, 75363931,
  75347332, 75329861, 75311521, 75292314, 75272244, 75251313, 75229525,
  75206881, 75183384, 75159038, 75133846, 75107809, 75080931, 75053214,
  75024662, 74995277, 74965062, 74934020, 74902154, 74869466, 74835960,
  74801637, 74766502, 74730556, 74693804, 74656246, 74617887, 74578729,
  74538775, 74498028, 74456491, 74414167, 74371058, 74327167, 74282497,
  74237052, 74190833, 74143844, 74096088, 74047568, 73998286, 73948245,
  73897448, 73845899, 73793599, 73740553, 73686762, 73632229, 73576958,
  73520952, 73464213, 73406744, 73348548, 73289628, 73229987, 73169628,
  73108554, 73046767, 72984271, 72921068, 72857162, 72792555, 72727250,
  72661250, 72594558, 72527177, 72459110, 72390359, 72320929, 72250821,
  72180038, 72108584, 72036461, 71963672, 71890221, 71816110, 71741341,
  71665919, 71589846, 71513124, 71435757, 71357748, 71279099, 71199814,
  71119895, 71039346, 70958169, 70876367, 70793944, 70710901, 70627242,
  70542971, 70458089, 70372600, 70286506, 70199812, 70112519, 70024630,
  69936149, 69847078, 69757420, 69667179, 69576356, 69484956, 69392980,
  69300433, 69207316, 69113633, 69019387, 68924580, 68829215, 68733296,
  68636826, 68539806, 68442241, 68344132, 68245484, 68146299, 68046579,
  67946328, 67845548, 67744244, 67642416, 67540069, 67437205, 67333827,
  67229938, 67125541, 67020639, 66915235, 66809331, 66702931, 66596037,
  66488653, 66380781, 66272423, 66163584, 66054265, 65944471, 65834202,
  65723464, 65612257, 65500586, 65388453, 65275861, 65162813, 65049311,
  64935359, 64820960, 64706115, 64590829, 64475104, 64358943, 64242348,
  64125323, 64007870, 63889993, 63771693, 63652975, 63533840, 63414292,
  63294333, 63173967, 63053195, 62932022, 62810449, 62688480, 62566117,
  62443363, 62320221, 62196694, 62072785, 61948496, 61823830, 61698790,
  61573379, 61447599, 61321454, 61194946, 61068078, 60940852, 60813272,
  60685340, 60557059, 60428432, 60299461, 60170150, 60040500, 59910516,
  59780199, 59649552, 59518578, 59387280, 59255660, 59123722, 58991468,
  58858900, 58726021, 58592835, 58459343, 58325549, 58191455, 58057064,
  57922379, 57787402, 57652136, 57516584, 57380747, 57244630, 57108235,
  56971564, 56834620, 56697406, 56559924, 56422177, 56284168, 56145899,
  56007373, 55868593, 55729560, 55590279, 55450751, 55310979, 55170966,
  55030714, 54890226, 54749505, 54608552, 54467372, 54325965, 54184336,
  54042486, 53900418, 53758134, 53615638, 53472931, 53330017, 53186898,
  53043576, 52900054, 52756334, 52612419, 52468312, 52324015, 52179531,
  52034861, 51890009, 51744978, 51599768, 51454384, 51308828, 51163101,
  51017207, 50871148, 50724927, 50578546, 50432007, 50285312, 50138465,
  49991468, 49844323, 49697033, 49549600, 49402026, 49254314, 49106467,
  48958486, 48810374, 48662134, 48513768, 48365278, 48216667, 48067936,
  47919090, 47770129, 47621056, 47471874, 47322584, 47173190, 47023693,
  46874096, 46724402, 46574611, 46424728, 46274754, 46124691, 45974542,
  45824309, 45673995, 45523601, 45373130, 45222584, 45071965, 44921276,
  44770520, 44619697, 44468811, 44317863, 44166856, 44015793, 43864674,
  43713504, 43562283, 43411013, 43259699, 43108340, 42956940, 42805501,
  42654024, 42502513, 42350969, 42199394, 42047790, 41896161, 41744507,
  41592831, 41441135, 41289421, 41137691, 40985948, 40834193, 40682429,
  40530657, 40378880, 40227100, 40075319, 39923538, 39771761, 39619988,
  39468223, 39316467, 39164722, 39012990, 38861273, 38709574, 38557893,
  38406234, 38254598, 38102987, 37951404, 37799849, 37648326, 37496836,
  37345380, 37193962, 37042582, 36891244, 36739948, 36588696, 36437492,
  36286336, 36135230, 35984177, 35833177, 35682234, 35531349, 35380524,
  35229760, 35079060, 34928426, 34777858, 34627360, 34476933, 34326578,
  34176298, 34026094, 33875969, 33725923, 33575960, 33426079, 33276285,
  33126577, 32976958, 32827430, 32677994, 32528652, 32379407, 32230258,
  32081209, 31932262, 31783417, 31634676, 31486042, 31337515, 31189098,
  31040792, 30892599, 30744521, 30596559, 30448715, 30300990, 30153386,
  30005906, 29858549, 29711319, 29564216, 29417243, 29270400, 29123690,
  28977114, 28830674, 28684370, 28538206, 28392181, 28246299, 28100560,
  27954966, 27809518, 27664219, 27519068, 27374069, 27229223, 27084530,
  26939993, 26795613, 26651391, 26507329, 26363429, 26219691, 26076118,
  25932711, 25789470, 25646399, 25503497, 25360767, 25218209, 25075826,
  24933619, 24791588, 24649736, 24508064, 24366573, 24225264, 24084139,
  23943200, 23802447, 23661882, 23521506, 23381320, 23241327, 23101526,
  22961920, 22822510, 22683297, 22544282, 22405467, 22266852, 22128440,
  21990231, 21852227, 21714428, 21576836, 21439453, 21302279, 21165316,
  21028565, 20892027, 20755703, 20619595, 20483703, 20348030, 20212575,
  20077340, 19942327, 19807536, 19672969, 19538626, 19404509, 19270619,
  19136957, 19003525, 18870322, 18737351, 18604612, 18472107, 18339837,
  18207802, 18076003, 17944443, 17813121, 17682039, 17551197, 17420598,
  17290241, 17160128, 17030261, 16900639, 16771263, 16642136, 16513258,
  16384629, 16256251, 16128124, 16000251, 15872631, 15745265, 15618155,
  15491301, 15364704, 15238366, 15112286, 14986467, 14860908, 14735612,
  14610577, 14485807, 14361300, 14237059, 14113084, 13989376, 13865935,
  13742763, 13619860, 13497228, 13374866, 13252777, 13130960, 13009416,
  12888146, 12767152, 12646433, 12525990, 12405825, 12285938, 12166329,
  12047000, 11927952, 11809184, 11690697, 11572493, 11454572, 11336935,
  11219583, 11102515, 10985733, 10869238, 10753030, 10637109, 10521477,
  10406135, 10291082, 10176319, 10061847, 9947667, 9833780, 9720185,
  9606883, 9493876, 9381163, 9268746, 9156625, 9044799, 8933271, 8822040,
  8711108, 8600474, 8490139, 8380104, 8270369, 8160935, 8051802, 7942971,
  7834442, 7726217, 7618294, 7510675, 7403360, 7296351, 7189646, 7083247,
  6977154, 6871368, 6765888, 6660716, 6555852, 6451297, 6347050, 6243112,
  6139484, 6036166, 5933158, 5830461, 5728075, 5626000, 5524237, 5422787,
  5321649, 5220825, 5120313, 5020116, 4920232, 4820662, 4721408, 4622468,
  4523844, 4425535, 4327542, 4229866, 4132505, 4035462, 3938736, 3842327,
  3746236, 3650463, 3555008, 3459871, 3365053, 3270554, 3176374, 3082513,
  2988972, 2895751, 2802850, 2710269, 2618009, 2526069, 2434450, 2343152,
  2252175, 2161520, 2071186, 1981174, 1891484, 1802116, 1713070, 1624347,
  1535946, 1447867, 1360112, 1272679, 1185569, 1098782, 1012319, 926179,
  840362, 754868, 669699, 584853, 500331, 416132, 332258, 248707, 165480,
  82578, 0, -82254, -164184, -245790, -327071, -408029, -488662, -568970,
  -648955, -728615, -807951, -886963, -965650, -1044013, -1122052,
  -1199766, -1277157, -1354223, -1430965, -1507383, -1583477, -1659247,
  -1734694, -1809816, -1884615, -1959090, -2033241, -2107069, -2180573,
  -2253755, -2326612, -2399147, -2471359, -2543248, -2614814, -2686057,
  -2756978, -2827576, -2897852, -2967806, -3037438, -3106748, -3175736,
  -3244403, -3312749, -3380773, -3448476, -3515858, -3582919, -3649660,
  -3716081, -3782181, -3847962, -3913423, -3978564, -4043386, -4107888,
  -4172072, -4235937, -4299484, -4362712, -4425622, -4488215, -4550490,
  -4612447, -4674088, -4735412, -4796419, -4857110, -4917485, -4977544,
  -5037288, -5096717, -5155830, -5214629, -5273114, -5331285, -5389142,
  -5446685, -5503915, -5560832, -5617437, -5673730, -5729711, -5785380,
  -5840737, -5895784, -5950521, -6004947, -6059063, -6112869, -6166367,
  -6219555, -6272435, -6325007, -6377270, -6429227, -6480876, -6532219,
  -6583255, -6633986, -6684410, -6734530, -6784345, -6833855, -6883062,
  -6931964, -6980564, -7028861, -7076855, -7124548, -7171938, -7219028,
  -7265817, -7312306, -7358495, -7404384, -7449974, -7495266, -7540260,
  -7584956, -7629355, -7673457, -7717262, -7760772, -7803987, -7846906,
  -7889531, -7931862, -7973899, -8015644, -8057095, -8098255, -8139123,
  -8179700, -8219986, -8259982, -8299689, -8339106, -8378234, -8417075,
  -8455627, -8493893, -8531872, -8569564, -8606972, -8644094, -8680931,
  -8717485, -8753754, -8789741, -8825446, -8860868, -8896009, -8930870,
  -8965450, -8999750, -9033771, -9067513, -9100978, -9134164, -9167074,
  -9199707, -9232064, -9264146, -9295954, -9327487, -9358746, -9389733,
  -9420447, -9450889, -9481060, -9510960, -9540590, -9569950, -9599042,
  -9627865, -9656420, -9684708, -9712730, -9740485, -9767976, -9795201,
  -9822162, -9848860, -9875295, -9901467, -9927378, -9953028, -9978417,
  -10003546, -10028416, -10053027, -10077381, -10101477, -10125316,
  -10148899, -10172227, -10195300, -10218118, -10240683, -10262996,
  -10285055, -10306864, -10328421, -10349728, -10370785, -10391593,
  -10412153, -10432465, -10452530, -10472349, -10491921, -10511249,
  -10530332, -10549172, -10567768, -10586122, -10604234, -10622105,
  -10639735, -10657126, -10674278, -10691191, -10707866, -10724305,
  -10740507, -10756473, -10772204, -10787701, -10802964, -10817995,
  -10832793, -10847359, -10861695, -10875800, -10889676, -10903323,
  -10916742, -10929933, -10942897, -10955636, -10968149, -10980438,
  -10992502, -11004344, -11015963, -11027360, -11038536, -11049491,
  -11060227, -11070743, -11081042, -11091123, -11100987, -11110634,
  -11120067, -11129284, -11138288, -11147078, -11155656, -11164022,
  -11172176, -11180121, -11187855, -11195381, -11202698, -11209808,
  -11216710, -11223407, -11229898, -11236185, -11242268, -11248148,
  -11253825, -11259300, -11264574, -11269648, -11274523, -11279199,
  -11283676, -11287956, -11292040, -11295928, -11299620, -11303118,
  -11306422, -11309534, -11312453, -11315181, -11317717, -11320064,
  -11322222, -11324191, -11325972, -11327566, -11328974, -11330196,
  -11331233, -11332087, -11332756, -11333243, -11333549, -11333673,
  -11333616, -11333380, -11332965, -11332372, -11331601, -11330654,
  -11329531, -11328232, -11326759, -11325112, -11323292, -11321300,
  -11319136, -11316802, -11314298, -11311624, -11308781, -11305771,
  -11302594, -11299250, -11295741, -11292067, -11288229, -11284228,
  -11280064, -11275738, -11271250, -11266603, -11261796, -11256830,
  -11251705, -11246424, -11240985, -11235391, -11229642, -11223738,
  -11217680, -11211469, -11205107, -11198592, -11191927, -11185112,
  -11178147, -11171034, -11163774, -11156366, -11148811, -11141112,
  -11133267, -11125278, -11117146, -11108871, -11100455, -11091897,
  -11083198, -11074360, -11065383, -11056268, -11047015, -11037626,
  -11028100, -11018440, -11008644, -10998715, -10988653, -10978458,
  -10968131, -10957674, -10947087, -10936370, -10925524, -10914550,
  -10903449, -10892221, -10880868, -10869389, -10857786, -10846060,
  -10834210, -10822238, -10810145, -10797931, -10785597, -10773143,
  -10760571, -10747881, -10735074, -10722150, -10709110, -10695956,
  -10682687, -10669304, -10655809, -10642201, -10628482, -10614652,
  -10600712, -10586662, -10572504, -10558238, -10543865, -10529385,
  -10514799, -10500109, -10485313, -10470414, -10455412, -10440308,
  -10425102, -10409794, -10394387, -10378880, -10363275, -10347571,
  -10331769, -10315871, -10299877, -10283787, -10267603, -10251324,
  -10234952, -10218488, -10201931, -10185284, -10168545, -10151717,
  -10134799, -10117793, -10100699, -10083518, -10066250, -10048896,
  -10031457, -10013933, -9996326, -9978635, -9960862, -9943007, -9925071,
  -9907054, -9888957, -9870782, -9852527, -9834195, -9815785, -9797299,
  -9778737, -9760100, -9741388, -9722602, -9703743, -9684811, -9665807,
  -9646732, -9627586, -9608370, -9589084, -9569730, -9550308, -9530818,
  -9511261, -9491638, -9471949, -9452196, -9432378, -9412496, -9392551,
  -9372544, -9352475, -9332344, -9312154, -9291903, -9271593, -9251224,
  -9230797, -9210312, -9189771, -9169174, -9148520, -9127812, -9107050,
  -9086233, -9065363, -9044441, -9023467, -9002441, -8981365, -8960238,
  -8939062, -8917837, -8896563, -8875242, -8853873, -8832458, -8810996,
  -8789490, -8767938, -8746342, -8724702, -8703020, -8681294, -8659527,
  -8637718, -8615869, -8593979, -8572050, -8550081, -8528074, -8506029,
  -8483947, -8461827, -8439672, -8417481, -8395254, -8372993, -8350698,
  -8328370, -8306008, -8283614, -8261189, -8238732, -8216244, -8193726,
  -8171178, -8148602, -8125996, -8103363, -8080702, -8058014, -8035300,
  -8012560, -7989794, -7967004, -7944189, -7921350, -7898488, -7875604,
  -7852697, -7829768, -7806818, -7783848, -7760857, -7737847, -7714817,
  -7691769, -7668702, -7645618, -7622517, -7599399, -7576265, -7553115,
  -7529951, -7506771, -7483577, -7460370, -7437149, -7413916, -7390670,
  -7367413, -7344144, -7320865, -7297575, -7274275, -7250966, -7227648,
  -7204322, -7180988, -7157646, -7134297, -7110942, -7087580, -7064213,
  -7040841, -7017464, -6994083, -6970697, -6947309, -6923917, -6900523,
  -6877127, -6853730, -6830331, -6806931, -6783532, -6760132, -6736733,
  -6713335, -6689938, -6666544, -6643151, -6619762, -6596375, -6572992,
  -6549613, -6526239, -6502869, -6479504, -6456146, -6432793, -6409447,
  -6386107, -6362775, -6339451, -6316134, -6292827, -6269528, -6246238,
  -6222958, -6199688, -6176428, -6153180, -6129942, -6106717, -6083503,
  -6060301, -6037113, -6013937, -5990775, -5967627, -5944493, -5921374,
  -5898270, -5875181, -5852108, -5829050, -5806010, -5782986, -5759979,
  -5736990, -5714019, -5691066, -5668131, -5645216, -5622320, -5599443,
  -5576586, -5553750, -5530934, -5508139, -5485366, -5462614, -5439884,
  -5417177, -5394492, -5371830, -5349191, -5326576, -5303985, -5281418,
  -5258876, -5236358, -5213866, -5191399, -5168958, -5146544, -5124155,
  -5101793, -5079459, -5057152, -5034872, -5012620, -4990397, -4968202,
  -4946036, -4923898, -4901791, -4879713, -4857665, -4835647, -4813660,
  -4791703, -4769778, -4747884, -4726021, -4704191, -4682393, -4660627,
  -4638894, -4617193, -4595526, -4573893, -4552293, -4530728, -4509196,
  -4487699, -4466237, -4444810, -4423418, -4402062, -4380741, -4359457,
  -4338209, -4316997, -4295822, -4274684, -4253583, -4232520, -4211494,
  -4190506, -4169557, -4148645, -4127772, -4106939, -4086144, -4065388,
  -4044672, -4023995, -4003359, -3982762, -3962206, -3941690, -3921215,
  -3900781, -3880388, -3860037, -3839727, -3819458, -3799232, -3779048,
  -3758906, -3738807, -3718750, -3698736, -3678766, -3658838, -3638955,
  -3619114, -3599318, -3579565, -3559857, -3540193, -3520574, -3500999,
  -3481469, -3461985, -3442545, -3423151, -3403802, -3384499, -3365242,
  -3346031, -3326866, -3307747, -3288675, -3269650, -3250671, -3231739,
  -3212855, -3194017, -3175227, -3156485, -3137790, -3119143, -3100544,
  -3081993, -3063490, -3045035, -3026629, -3008272, -2989963, -2971703,
  -2953492, -2935331, -2917218, -2899155, -2881142, -2863178, -2845263,
  -2827399, -2809584, -2791820, -2774105, -2756441, -2738828, -2721265,
  -2703752, -2686290, -2668879, -2651519, -2634210, -2616951, -2599745,
  -2582589, -2565485, -2548432, -2531431, -2514481, -2497583, -2480737,
  -2463943, -2447201, -2430511, -2413873, -2397287, -2380754, -2364273,
  -2347844, -2331468, -2315144, -2298874, -2282656, -2266490, -2250378,
  -2234318, -2218312, -2202358, -2186458, -2170611, -2154817, -2139076,
  -2123389, -2107755, -2092175, -2076648, -2061174, -2045755, -2030388,
  -2015076, -1999817, -1984612, -1969461, -1954364, -1939320, -1924331,
  -1909395, -1894514, -1879686, -1864913, -1850194, -1835528, -1820917,
  -1806361, -1791858, -1777410, -1763015, -1748676, -1734390, -1720159,
  -1705982, -1691859, -1677791, -1663778, -1649818, -1635913, -1622063,
  -1608267, -1594525, -1580838, -1567205, -1553627, -1540103, -1526634,
  -1513219, -1499859, -1486553, -1473302, -1460105, -1446962, -1433874,
  -1420841, -1407862, -1394937, -1382067, -1369251, -1356490, -1343783,
  -1331130, -1318532, -1305988, -1293498, -1281063, -1268682, -1256355,
  -1244083, -1231865, -1219701, -1207591, -1195535, -1183534, -1171587,
  -1159693, -1147854, -1136069, -1124337, -1112660, -1101037, -1089467,
  -1077952, -1066490, -1055082, -1043727, -1032426, -1021179, -1009986,
  -998846, -987760, -976727, -965748, -954822, -943949, -933129, -922363,
  -911650, -900990, -890384, -879830, -869329, -858881, -848486, -838144,
  -827855, -817618, -807434, -797303, -787224, -777197, -767223, -757301,
  -747432, -737615, -727849, -718136, -708475, -698866, -689309, -679803,
  -670349, -660947, -651597, -642297, -633050, -623853, -614708, -605615,
  -596572, -587580, -578639, -569750, -560911, -552122, -543385, -534698,
  -526061, -517475, -508939, -500453, -492018, -483632, -475297, -467011,
  -458775, -450589, -442452, -434365, -426328, -418339, -410400, -402510,
  -394669, -386877, -379134, -371440, -363794, -356197, -348649, -341149,
  -333697, -326293, -318937, -311629, -304369, -297157, -289993, -282876,
  -275807, -268785, -261810, -254882, -248001, -241168, -234381, -227641,
  -220947, -214300, -207699, -201145, -194636, -188174, -181758, -175387,
  -169063, -162784, -156550, -150362, -144219, -138121, -132068, -126060,
  -120097, -114178, -108304, -102475, -96690, -90949, -85252, -79599,
  -73990, -68425, -62903, -57425, -51990, -46598, -41250, -35945, -30682,
  -25462, -20285, -15150, -10058, -5008, 0
};
