## 1.6.3 (Unreleased)

ENHANCEMENTS:

BUG FIXES:

## 1.6.2

ENHANCEMENTS:
* Allow referencing the output from a test run in the local variables block of another run (tofu test). ([#1293](https://github.com/opentofu/opentofu/pull/1293))

BUG FIXES:

## 1.6.1

ENHANCEMENTS:

* Allow test run blocks to reference previous run block's module outputs ([#1129](https://github.com/opentofu/opentofu/pull/1129))

BUG FIXES:

* Fix access to known references when using a import block for module resources ([#1105](https://github.com/opentofu/opentofu/pull/1105))
* Fix Global Schema Cache not working in provider acceptance tests ([#1054](https://github.com/opentofu/opentofu/pull/1054))
* Fix `tofu show` and `tofu state show` not working with state files referencing Terraform registry providers in some instances ([#1141](https://github.com/opentofu/opentofu/pull/1141))
* Improved stability on 32-bit architectures ([#1154](https://github.com/opentofu/opentofu/pull/1154))

## 1.6.0

IMPORTANT NOTES:

- Conditional GPG Validation Bypass for Default Registry - ([#309](https://github.com/opentofu/opentofu/pull/309)): A temporary change has been introduced to skip GPG validation under specific conditions. This behavior is tracked under issue #309 and applies as follows:
  - **Registry Scope**: This change only affects provider packages from the default registry.
  - **Key Availability**: GPG validation will be skipped when and only when the provider's GPG keys are not available in the default registry.
  - **Temporary Measure**: This is a stopgap measure until GPG keys for all providers can be populated in the default registry.

  While this offers operational flexibility, it does reduce the level of security assurance for affected packages. Users who prioritize security should set the `OPENTOFU_ENFORCE_GPG_VALIDATION` environment variable to `true` to enforce GPG validation of all providers.

  **Future Removal**: We intend to remove this feature once all GPG keys are populated in the default registry, reverting to a strict GPG validation process for all providers.

UPGRADE NOTES:

* The `cloud` and `remote` backends will no longer default to `app.terraform.io` hostname and will require the hostname to be explicitly specified ([#291](https://github.com/opentofu/opentofu/pull/291));
* The `login` and `logout` commands will no longer default to `app.terraform.io` hostname and will require the hostname to be explicitly provided as a command-line argument ([#291](https://github.com/opentofu/opentofu/pull/291));
* prevent future possible incompatibility with states that include unknown `check` block result kinds.  ([#355](https://github.com/opentofu/opentofu/pull/355));

NEW FEATURES:

* `tofu test`: The previously experimental `tofu test` command has been moved out of experimental. This comes with a significant change in how OpenTofu tests are written and executed.

  OpenTofu tests are written within `.tftest.hcl` files, controlled by a series of `run` blocks. Each `run` block will execute an OpenTofu plan or apply command against the OpenTofu configuration under test and can execute conditions against the resultant plan and state.

ENHANCEMENTS:

* config: OpenTofu can now track some additional detail about values that won't be known until the apply step, such as the range of possible lengths for a collection or whether an unknown value can possibly be null. When this information is available, OpenTofu can potentially generate known results for some operations on unknown values. This doesn't mean that OpenTofu can immediately track that detail in all cases, but the type system now contains the facility for that and so over time we will improve the level of detail generated by built-in functions, language operators, OpenTofu providers, etc. ([#33234](https://github.com/hashicorp/terraform/issues/33234))
* jsonplan: Added `errored` field to JSON plan output, indicating whether a plan errored. ([#33372](https://github.com/hashicorp/terraform/issues/33372))
* cloud: Remote plans on cloud backends can now be saved using the `-out` flag, referenced in the `show` command, and applied by specifying the plan file name. ([#33492](https://github.com/hashicorp/terraform/issues/33492))
* config: The `import` block `id` field now accepts an expression referencing other values such as resource attributes, as long as the value is a string known at plan time. ([#33618](https://github.com/hashicorp/terraform/issues/33618))
* telemetry: All checkpoint telemetry was removed ([#151](https://github.com/opentofu/opentofu/pull/151))
* state: Provider addresses in the statefile referring to registry.terraform.io will be treated as referring to registry.opentofu.org unless the full provider address is specified in the config or `OPENTOFU_STATEFILE_PROVIDER_ADDRESS_TRANSLATION` is set to `0`. ([#773](https://github.com/opentofu/opentofu/pull/773))
* The default provider namespace has been changed from "hasicorp" to "opentofu". This only impacts providers that do not explicitly have a namespace set, ex "aws" vs "hasicorp/aws". This change should be transparent and not require action to be taken by users.
* init: Ensured that the `tofu init` command has consistent spelling of the word `initialization` in its output. ([#855](https://github.com/opentofu/opentofu/pull/855/files))
* init: A warning is now emitted when two providers who share the same name are detected.  This can help prevent misconfigurations when switching a project to use a fork of a provider.  This currently only functions for the opentofu and hashicorp namespaces ([#1009](https://github.com/opentofu/opentofu/pull/1009))

BUG FIXES:

* The upstream dependency that OpenTofu uses for service discovery of OpenTofu-native services such as cloud backend state storage was previously not concurrency-safe, but OpenTofu was treating it as if it was in situations like when a configuration has multiple `terraform_remote_state` blocks all using the "remote" backend. OpenTofu is now using a newer version of that library which updates its internal caches in a concurrency-safe way. ([#33364](https://github.com/hashicorp/terraform/issues/33364))
* Transitive dependencies were lost during apply when the referenced resource expanded into zero instances ([#33403](https://github.com/hashicorp/terraform/issues/33403))
* OpenTofu will no longer override SSH settings in local git configuration when installing modules. ([#33592](https://github.com/hashicorp/terraform/issues/33592))
* Handle file-operation errors in `internal/states/statemgr`. ([#278](https://github.com/opentofu/opentofu/issues/278))
* `tofu init`: OpenTofu will no longer allow downloading remote modules to invalid paths. ([#356](https://github.com/opentofu/opentofu/issues/356))
* tofu_remote_state: Fixed a potential unsafe read panic when reading from multiple tofu_remote_state data sources ([#357](https://github.com/opentofu/opentofu/issues/357))
* OpenTofu will now attempt to create the configuration directory `~/.terraform.d` on startup. ([#442](https://github.com/opentofu/opentofu/issues/442))
* Conditionals with an unknown condition and sensitive branch won't crash anymore. ([#717](https://github.com/opentofu/opentofu/issues/717))
* Fixed panic when using sensitive inputs for the ID field of an import configuration block ([#665](https://github.com/opentofu/opentofu/pull/665))
* Fixes the ability to use KMS key aliases in the S3 backend ([#669](https://github.com/opentofu/opentofu/issues/669))
* `GIT_SSH_COMMAND` environment variable is no longer ignored when downloading modules ([#717](https://github.com/opento
* cloud: fixed a bug that would prevent nested symlinks from being dereferenced into the config sent to Cloud ([#686](https://github.com/opentofu/opentofu/issues/686)) 
* cloud: state snapshots could not be disabled when header x-terraform-snapshot-interval is absent ([#687](https://github.com/opentofu/opentofu/issues/687))
* Fixed crash during tofu destroy inside module with variable validation ([#817](https://github.com/opentofu/opentofu/issues/817))
* Fixed regression where `tofu` was not ignoring GPG signing key expiration by default ([822](https://github.com/opentofu/opentofu/issues/822))
  - Added experimental env variable to enforce checking of GPG signing key expiration `OPENTOFU_ENFORCE_GPG_EXPIRATION=true`
  - This is planned to default to `true` in a future release.
* cloud: fixed a bug related to `workspaces` configuration not correctly recognizing TF_WORKSPACE environment variable ([#814](https://github.com/opentofu/opentofu/issues/814))

S3 BACKEND:

* The S3 backend was upgraded to use the V2 of the AWS SDK for Go ([#691](https://github.com/opentofu/opentofu/issues/691))
* Adds support for `shared_config_files` and `shared_credentials_files` arguments and deprecates the `shared_credentials_file` argument. ([#690](https://github.com/opentofu/opentofu/issues/690))
* Arguments associated with assuming an IAM role were moved into a nested block - `assume_role`.
  This deprecates the arguments `role_arn`, `session_name`, `external_id`, `assume_role_duration_seconds`, `assume_role_policy`, `assume_role_policy_arns`, `assume_role_tags`, and `assume_role_transitive_tag_keys`. ([#747](https://github.com/opentofu/opentofu/issues/747))
* Adds support for the `assume_role_with_web_identity` block. ([#689](https://github.com/opentofu/opentofu/issues/689))
* Adds support for account whitelisting using the `forbidden_account_ids` and `allowed_account_ids` arguments. ([#699](https://github.com/opentofu/opentofu/issues/699))
* Adds the `custom_ca_bundle` argument. ([#689](https://github.com/opentofu/opentofu/issues/689))
* Adds support for the `sts_region` argument. ([#695](https://github.com/opentofu/opentofu/issues/695))
* Adds support for `ec2_metadata_service_endpoint` and `ec2_metadata_service_endpoint_mode` arguments to enable overriding the EC2 metadata service (IMDS) endpoint. ([#693](https://github.com/opentofu/opentofu/issues/693))
* Adds support for the `retry_mode` attribute. ([#698](https://github.com/opentofu/opentofu/issues/698))
* Adds support for the `http_proxy`, `insecure`, `use_dualstack_endpoint`, and `use_fips_endpoint` attributes. ([#694](https://github.com/opentofu/opentofu/issues/694))
* Adds support for the `use_path_style` argument and deprecates the `force_path_style` argument. ([#783](https://github.com/opentofu/opentofu/issues/783))
* Adds support for customizing the AWS API endpoints. ([#775](https://github.com/opentofu/opentofu/issues/775))
* Adds support for the `skip_requesting_account_id` attribute. ([#774](https://github.com/opentofu/opentofu/issues/774))
* Adds support for the `skip_s3_checksum` argument to allow users to disable checksum on S3 uploads for compatibility with non AWS "S3-compatible" APIs. ([#778](https://github.com/opentofu/opentofu/issues/778))
* Adds support for the `https_proxy` attribute to allow users to use proxy when accessing the AWS API. It can be also sourced from the `HTTPS_PROXY` environment variable. ([#675](https://github.com/opentofu/opentofu/issues/675))
* Adds support for the `no_proxy` attribute to allow users to specify hosts that should be excluded from proxying when accessing the AWS API. This can also be sourced from the `NO_PROXY` environment variable. ([#675](https://github.com/opentofu/opentofu/issues/675))
* `tofu init`: Fixed subsequent runs for s3 backend ([#820](https://github.com/opentofu/opentofu/issues/820)).
* S3 backend endpoints without proto:// default to https:// instead of failing ([#821](https://github.com/opentofu/opentofu/issues/821))
* Most S3 compatible remote state backends should now work without checksum errors / 400s ([#821](https://github.com/opentofu/opentofu/issues/821))
* Logging has been re-added to S3 remote state calls ([#821](https://github.com/opentofu/opentofu/issues/821))
* Fixed validation for certain optional fields ([875](https://github.com/opentofu/opentofu/issues/875))

## Previous Releases

For information on prior major and minor releases, see their changelogs:

None yet
