/*
 * Copyright (C) 2000-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmstats.h,v 1.4 2004/01/16 16:48:35 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.4 $
 * $Log: rmstats.h,v $
 * Revision 1.4  2004/01/16 16:48:35  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.3  2003/11/05 15:31:54  wes
 * Updated to use new RMtime object introduced in 1.5.1.
 *
 * Revision 1.2  2003/02/02 02:07:16  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.3  2003/01/16 22:21:17  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.2  2002/04/30 19:33:49  wes
 * Updated copyright dates.
 *
 * Revision 1.1  2001/03/31 17:12:11  wes
 * v1.4.0-alpha-2 checkin.
 *
 */

#ifndef __rmstats_h
#define __rmstats_h

#include <rm/rm.h>

#ifdef RM_X
#include <sys/types.h>
#include <sys/time.h>
#endif

#ifdef RM_WIN
#include <sys/types.h>
#include <sys/timeb.h>
/* see _ftime() */
#endif

typedef struct RMstats
{
    RMtime textureDownloadTime[2], renderStageTime[2], viewStageTime[2];

    int    nNodes, nPrims;
    int    nTriangles, nQuads, nVectors, nPoints;
    int    nTextures, nPixelBytes;
} RMstats;

#ifdef __cplusplus
extern "C" {
#endif

RMenum rmRenderStatsBegin (void); /* tmp */
RMenum rmRenderStatsEnd   (void); /* tmp */
RMenum rmPrintRenderStats (void); /* tmp */


#ifdef __cplusplus
}
#endif

#endif
/* EOF */
