/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmglobal.c,v 1.5 2004/03/10 01:46:20 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.5 $
 * $Log: rmglobal.c,v $
 * Revision 1.5  2004/03/10 01:46:20  wes
 * Set default spotlight exponent to be 2.0.
 *
 * Revision 1.4  2004/01/16 16:45:12  wes
 * Updated copyright line for 2004.
 *
 * Revision 1.3  2003/12/06 03:26:06  wes
 * Documentation tweaks to RMtime routines, updates to RMtime routines for
 * Windows.
 *
 * Revision 1.2  2003/02/02 02:07:15  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.13  2003/01/16 22:21:17  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.12  2003/01/11 18:44:22  wes
 * Added global control over whether or not display lists are used during
 * rendering by adding the new RMpipe controls rmPipeSetDisplayListEnable()
 * and rmPipeGetDisplayListEnable().
 *
 * Revision 1.11  2002/12/02 16:24:56  wes
 * Bug fixes:
 * (1) fixed memory leak in rmPrimitiveSetText;
 * (2) fixed problem with textProps not being applied to 2nd and later
 * strings in an RM_TEXT text primitive.
 *
 * Revision 1.10  2002/08/29 22:20:32  wes
 *
 * Massive upgrade to accommodate dynamic object reallocation within
 * the component manager, and within the context cache. Use the
 * debug #define DEBUG_LEVEL DEBUG_REALLOC_TRACE to get a printf
 * whenever a realloc occurs. With this upgrade, there are no
 * OpenRM limits on the size of the scene graph. There will be external
 * limits, such as the amount of RAM and the amount of space available
 * to your OpenGL implementation.
 *
 * Revision 1.9  2002/08/17 15:09:15  wes
 * Changed RM_COMPONENT_POOL_SIZE to be a global variable in rmglobal.c.
 * It was previously a #define. As a global variable, it can be set prior
 * to rmInit() to control the size of the component manager's object pool.
 * This will be helpful for apps that consume lots of scene graph resources.
 *
 * Revision 1.8  2002/04/30 19:31:59  wes
 * Updated copyright dates.
 *
 * Revision 1.7  2001/05/26 14:34:34  wes
 * Changed spotlight cutoff angle default value from 90.0 to 60.0.
 *
 * Revision 1.6  2001/03/31 17:12:38  wes
 * v1.4.0-alpha-2 checkin.
 *
 * Revision 1.5  2000/12/03 22:35:38  wes
 * Mods for thread safety.
 *
 * Revision 1.4  2000/05/17 14:23:14  wes
 * Fixed compile warnings on RM_DEFAULT_FONT_FAMILY and RM_DEFAULT_FONT_SIZE.
 *
 * Revision 1.3  2000/05/14 23:37:50  wes
 * Added constants for default font family, size, etc. used
 * for initializing RMtextProps objects upon creation.
 *
 * Revision 1.2  2000/04/20 16:29:47  wes
 * Documentation additions/enhancements, some code rearragement.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

/*
 * this file contains global variables...this is a good place to
 * set default values for the system. we use global variables rather
 * than #define's to avoid compile warnings.
 */

#include <rm/rm.h>
#include "rmprivat.h"

RMcolor4D RM_DEFAULT_BACKGROUND_COLOR = {0.19, 0.19, 0.3, 1.0};
float     RM_DEFAULT_DEPTH_VALUE = 1.0F;

/* default light values: these are assigned to a new RMlight object when created with rmLightNew() */
RMenum     RM_DEFAULT_LIGHT_TYPE = RM_LIGHT_DIRECTIONAL;
RMvertex3D RM_DEFAULT_LIGHT_XYZ = {0.0F, 0.0F, 1.0F};
RMcolor4D  RM_DEFAULT_LIGHT_AMBIENT_COLOR = {0.0F, 0.0F, 0.0F, 1.0F};
RMcolor4D  RM_DEFAULT_LIGHT_DIFFUSE_COLOR = {0.75F, 0.75F, 0.75F, 1.0F};
RMcolor4D  RM_DEFAULT_LIGHT_SPECULAR_COLOR = {0.1F, 0.1F, 0.1F, 1.0F};
RMvertex3D RM_DEFAULT_LIGHT_SPOT_DIRECTION = {0.0F, 0.0F, -1.0F};
float      RM_DEFAULT_LIGHT_SPOT_EXPONENT = 2.0F;
float      RM_DEFAULT_LIGHT_SPOT_CUTOFF = 60.0F;
float      RM_DEFAULT_LIGHT_CONSTANT_ATTENUATION = 1.0F;
float      RM_DEFAULT_LIGHT_LINEAR_ATTENUATION = 0.0F;
float      RM_DEFAULT_LIGHT_QUADRATIC_ATTENUATION = 0.0F;
RMenum     RM_DEFAULT_LIGHT_ENABLE = RM_TRUE;

/* default 2D camera parameters */
float RM_DEFAULT_2DCAMERA_XMIN = -1.0;
float RM_DEFAULT_2DCAMERA_YMIN = -1.0;
float RM_DEFAULT_2DCAMERA_XMAX = 1.0;
float RM_DEFAULT_2DCAMERA_YMAX = 1.0;
float RM_DEFAULT_2DCAMERA_ASPECT = 1.0;

/* default 3D camera parameters */
RMvertex3D RM_DEFAULT_3DCAMERA_EYE = {10.0, 10.0, 50.0};
RMvertex3D RM_DEFAULT_3DCAMERA_LOOKAT = {0.0, 0.0, 0.0};
RMvertex3D RM_DEFAULT_3DCAMERA_UP = {0.0, 1.0, 0.0};
float      RM_DEFAULT_3DCAMERA_HITHER = 2.0;
float      RM_DEFAULT_3DCAMERA_YON = 40.0;
float      RM_DEFAULT_3DCAMERA_ASPECT = 1.0;
float      RM_DEFAULT_3DCAMERA_FOV = 45.0;
RMenum     RM_DEFAULT_3DCAMERA_PROJECTION = RM_PROJECTION_PERSPECTIVE;

/* default color values assigned a node by rmNodeNew() */
RMcolor4D RM_DEFAULT_AMBIENT_COLOR = {0.5F, 0.5F, 0.5F, 1.0F};
RMcolor4D RM_DEFAULT_DIFFUSE_COLOR = {0.6F, 0.6F, 0.6F, 1.0F};
RMcolor4D RM_DEFAULT_SPECULAR_COLOR = {0.7F, 0.7F, 0.7F, 1.0F};
RMcolor4D RM_DEFAULT_UNLIT_COLOR = {1.0F, 1.0F, 1.0F, 1.0F};
float     RM_DEFAULT_SPECULAR_EXPONENT = 10.0F;
float     RM_DEFAULT_OPACITY = 1.0F;

/* default text rendering parameters */
RMenum RM_DEFAULT_HJUSTIFY    = RM_LEFT;
RMenum RM_DEFAULT_VJUSTIFY    = RM_BOTTOM;
int    RM_DEFAULT_FONT_FAMILY = RM_FONT_SANS;
int    RM_DEFAULT_FONT_SIZE   = RM_FONT_M;
RMenum RM_DEFAULT_FONT_BOLD   = RM_FALSE;
RMenum RM_DEFAULT_FONT_ITALIC = RM_FALSE;

/* default policy on use of display lists */
RMenum RM_DEFAULT_PRIMITIVE_DISPLAY_LIST_ENABLE = RM_TRUE;
RMenum RM_DEFAULT_PIPE_DISPLAY_LIST_ENBALE = RM_TRUE;

/* component manager headers */
RMcompMgrHdr *global_RMimagePool = NULL;
RMcompMgrHdr *global_RMprimitivePool = NULL;
RMcompMgrHdr *global_RMnodePool = NULL;
RMcompMgrHdr *global_RMtexturePool = NULL;
RMcompMgrHdr *global_RMtextPropsPool = NULL;

#ifdef RM_WIN
/* on Win32, we need to obtain some information about the platform's
   capabilities prior to using any timing stuff. the following variable
   is set from a routine called by rmInit(). */
double static_Win32ClockFrequency=0.0F;
#endif


/*
 * this controls how finely spheres are tesselated.  increasing the number
 * (10 is a good number) will produce nice pictures but will take a long
 * time to render. at a future date, this value will be computed dynamically
 * as a function of pixel coverage, so don't count on it for too long.
 * (04/16/97)
 */
int RM_SPHERE_SUBDIVISIONS = 4;

/* default clipping plane parameters */
RMvertex3D RM_DEFAULT_CLIP_PLANE_POINT = {0.0, 0.0, 0.0};
RMvertex3D RM_DEFAULT_CLIP_PLANE_NORMAL = {0.0, 0.0, -1.0};

/* line styles */
RMLinestyleEnum rmlinestyles[RM_MAX_LINESTYLES] =
{
    {				/* this one is for solid lines. this is
				 the default everywhere, so we don't need
				 to put anything in this enum entry. */
	0,			/* the enumeration value */
	0, 0			/* opengl values */
     },
     {
	/* RM_LINES_DASHED */
				/* this one is for dashed lines */
	 1,			/* the enumeration value */
	 1, 0x00ff		/* values for OpenGL - this will create
				 dashes and blank spaces that are 8/72
				 inches long (assuming 72dpi on the monitor) */
     },
     {
	/* RM_LINES_DOTTED */
				/* this one is for dashed lines */
	 2,			/* the enumeration value */
	 1, 0x1111		/* values for OpenGL - this will create
				 dots and blank spaces that are 1/72
				 inches long (assuming 72dpi on the monitor) */
     },
     {
	/* RM_LINES_DOT_DASH */
				/* this one is for dashed lines */
	 1,			/* the enumeration value */
	 2, 0x07C1		/* values for OpenGL - this will create
				 dots and blank spaces that are 1/72
				 inches long (assuming 72dpi on the monitor) */
     },
     {
	/* RM_LINES_DASH_DASH_DOT */
				/* this one is for dashed lines */
	 2,			/* the enumeration value */
	 2, 0x1C71		/* values for OpenGL - this will create
				 dots and blank spaces that are 1/72
				 inches long (assuming 72dpi on the monitor) */
     }
};


/* line width */
RMLinewidthEnum rmlinewidths[RM_MAX_LINEWEIGHTS]=
{
    {0, 1.0},	/* RM_LINEWIDTH_1, RM_LINEWIDTH_NARROW */
    {1, 2.0},	/* RM_LINEWIDTH_2, RM_LINEWIDTH_MEDIUM */
    {2, 3.0},	/* RM_LINEWIDTH_3 */
    {3, 4.0},	/* RM_LINEWIDTH_4, RM_LINEWIDTH_HEAVY */
    {4, 5.0},	/* RM_LINEWIDTH_5  */
    {5, 6.0},	/* RM_LINEWIDTH_6 */
    {6, 7.0},	/* RM_LINEWIDTH_7 */
    {7, 8.0}	/* RM_LINEWIDTH_8 */
};


/* PRIVATE */
int
private_rmLinestyleToIndex(RMenum style_enum)
{
    int rstat;

    /* convert a line style enumerator to an index into rmlinestyles array */
    switch(style_enum)
       {
       case RM_LINES_DASHED:
	  rstat = 1;
	  break;
	  
       case RM_LINES_DOTTED:
	  rstat = 2;
	  break;
	  
       case RM_LINES_DOT_DASH:
	  rstat = 3;
	  break;
	  
       case RM_LINES_DASH_DASH_DOT:
	  rstat = 4;
	  break;
	  
       default: /* bogus line style enum - default to solid */
       case RM_LINES_SOLID:
	  rstat = 0;
	  break;
       }
    return(rstat);
}


/* PRIVATE */
int
private_rmLinewidthToIndex(RMenum style_enum)
{
    int rstat;

    /* convert from line width enumerator to an index into rmlinewidths array */
    switch(style_enum)
       {
       case RM_LINEWIDTH_1:
       case RM_LINEWIDTH_NARROW:
	  rstat = 0;
	  break;
	  
       case RM_LINEWIDTH_2:
       case RM_LINEWIDTH_MEDIUM:
	  rstat = 1;
	  break;
	  
       case RM_LINEWIDTH_3:
	  rstat = 2;
	  break;
	  
       case RM_LINEWIDTH_HEAVY:
       case RM_LINEWIDTH_4:
	  rstat = 3;
	  break;
	  
       case RM_LINEWIDTH_5:
	  rstat = 4;
	  break;
	  
       case RM_LINEWIDTH_6:
	  rstat = 5;
	  break;
	  
       case RM_LINEWIDTH_7:
	  rstat = 6;
	  break;
	  
       case RM_LINEWIDTH_8:
	  rstat = 7;
	  break;
	  
       default: /* bogus line width enum */
	  rstat = 0;
	  break;
       }
    return(rstat);
}
/* EOF */
