/*
 * h323plugins.h
 *
 * H.323 codec plugins handler
 *
 * Open H323 Library
 *
 * Copyright (C) 2004 Post Increment
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open H323 Library.
 *
 * The Initial Developer of the Original Code is Post Increment
 *
 * Contributor(s): ______________________________________.
 *
 * $Log: h323pluginmgr.h,v $
 * Revision 1.17  2004/08/26 08:05:02  csoutheren
 * Codecs now appear in abstract factory system
 * Fixed Windows factory bootstrap system (again)
 *
 * Revision 1.16  2004/06/30 12:31:09  rjongbloed
 * Rewrite of plug in system to use single global variable for all factories to avoid all sorts
 *   of issues with startup orders and Windows DLL multiple instances.
 *
 * Revision 1.15  2004/06/03 23:20:46  csoutheren
 * Fixed compile problem on some gcc variants
 *
 * Revision 1.14  2004/06/01 07:30:27  csoutheren
 * Removed accidental cut & paste in new code that removed capabilities
 *
 * Revision 1.13  2004/06/01 05:49:27  csoutheren
 * Added code to cleanup some allocated memory upon shutdown
 *
 * Revision 1.12  2004/05/23 12:40:34  rjongbloed
 * Simplified call for getting H323 plug manager instance
 *
 * Revision 1.11  2004/05/18 23:03:10  csoutheren
 * Added empty destructor to prevent gcc 3.3.3 from getting link errors.
 *
 * Revision 1.10  2004/05/18 22:32:54  csoutheren
 * Added pragma inteface
 *
 * Revision 1.9  2004/05/18 22:26:28  csoutheren
 * Initial support for embedded codecs
 * Fixed problems with streamed codec support
 * Updates for abstract factory loading methods
 *
 * Revision 1.8  2004/05/18 06:02:25  csoutheren
 * Deferred plugin codec loading until after main has executed by using abstract factory classes
 *
 * Revision 1.7  2004/05/12 13:41:26  csoutheren
 * Added support for getting lists of media formats from plugin manager
 *
 * Revision 1.6  2004/04/22 22:35:00  csoutheren
 * Fixed mispelling of Guilhem Tardy - my apologies to him
 *
 * Revision 1.5  2004/04/22 14:22:20  csoutheren
 * Added RFC 2190 H.263 code as created by Guilhem Tardy and AliceStreet
 * Many thanks to them for their contributions.
 *
 * Revision 1.4  2004/04/14 08:14:40  csoutheren
 * Changed to use generic plugin manager
 *
 * Revision 1.3  2004/04/09 12:24:18  csoutheren
 * Renamed h323plugin.h to opalplugin.h, and modified everything else
 * as required
 *
 * Revision 1.2  2004/04/03 10:38:24  csoutheren
 * Added in initial cut at codec plugin code. Branches are for wimps :)
 *
 * Revision 1.1.2.1  2004/03/31 11:03:16  csoutheren
 * Initial public version
 *
 * Revision 1.2  2004/01/27 14:55:46  craigs
 * Implemented static linking of new codecs
 *
 * Revision 1.1  2004/01/04 13:37:51  craigs
 * Implementation of codec plugins
 *
 *
 */

#ifndef __OPAL_H323PLUGINMGR_H
#define __OPAL_H323PLUGINMGR_H

#ifdef P_USE_PRAGMA
#pragma interface
#endif

#include <ptlib/pluginmgr.h>
#include <opalplugin.h>
#include <mediafmt.h>
#include <ptlib/pfactory.h>

namespace PWLibStupidLinkerHacks {

#ifndef NO_H323_VIDEO
extern int h261Loader;
extern int rfc2190h263Loader;
#endif

extern int opalwavfileLoader;

extern void H323BootStrapPlugins();
extern void H323BootStrapNonPlugins();

} // namespace PWLibStupidLinkerHacks


class H323PluginCodecManager : public PPluginModuleManager
{
  PCLASSINFO(H323PluginCodecManager, PPluginModuleManager);
  public:
    H323PluginCodecManager(PPluginManager * pluginMgr = NULL);
    ~H323PluginCodecManager();

    void RegisterStaticCodec(const char * name,
                             PluginCodec_GetAPIVersionFunction getApiVerFn,
                             PluginCodec_GetCodecFunction getCodecFn);

    void OnLoadPlugin(PDynaLink & dll, INT code);

    static OpalMediaFormat::List GetMediaFormats();
    static void AddFormat(const OpalMediaFormat & fmt);

    virtual void OnShutdown();

  protected:
    void CreateCapabilityAndMediaFormat(
      PluginCodec_Definition * _encoderCodec,
      PluginCodec_Definition * _decoderCodec
    );

    static OpalMediaFormat::List & GetMediaFormatList();
    static PMutex & GetMediaFormatMutex();

    void RegisterCodecs  (unsigned int count, void * codecList);
    void UnregisterCodecs(unsigned int count, void * codecList);

    friend void PWLibStupidLinkerHacks::H323BootStrapPlugins();
};

class H323DynaLink : public PDynaLink
{
  PCLASSINFO(H323DynaLink, PDynaLink)
    
 public:
  H323DynaLink(const char * basename, const char * reason);

  virtual void Load();
  virtual BOOL IsLoaded()
  { PWaitAndSignal m(processLock); return isLoadedOK; }
  virtual BOOL LoadPlugin (const PString & fileName);

protected:
  PMutex processLock;
  BOOL isLoadedOK;
  const char * baseName;
  const char * reason;
};

//////////////////////////////////////////////////////
//
//  this is the base class for codecs accesible via the abstract factory functions
//

class OpalFactoryCodec : public PObject {
  PCLASSINFO(OpalFactoryCodec, PObject)
  public:
    virtual const struct PluginCodec_Definition * GetDefinition()
    { return NULL; }

    virtual PString GetInputFormat() const = 0;
    virtual PString GetOutputFormat() const = 0;

    virtual int Encode(const void * from, unsigned * fromLen,
                             void * to,   unsigned * toLen,
                     unsigned int * flag) = 0;

    virtual unsigned int GetSampleRate() const = 0;
    virtual unsigned int GetBitsPerSec() const = 0;
    virtual unsigned int GetFrameTime() const = 0;
    virtual unsigned int GetSamplesPerFrame() const = 0;
    virtual unsigned int GetBytesPerFrame() const = 0;
    virtual unsigned int GetRecommendedFramesPerPacket() const = 0;
    virtual unsigned int GetMaxFramesPerPacket() const = 0;
    virtual BYTE         GetRTPPayload() const = 0;
    virtual PString      GetSDPFormat() const = 0;
};

#endif
