/*
	VerboseException.h for OBPager, a pager dockapp designed to work with OpenBox or any netwm-compliant window manager.
	
	Copyright (c) 2004 - Roy Wood
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	See the COPYING file for a copy of the GNU General Public License.
*/


#ifndef __VERBOSE_EXCEPTION_H__
#define __VERBOSE_EXCEPTION_H__


#include <string>
#include <stdexcept>



/*
	This class is designed to be used as a "verbose" exception class.  
	
	In particular, it includes support for specifying the source-file, source-function, source-line, and exception message.
*/



// This macro is very handy....

#define THROW_VERBOSE_EXCEPTION(__msg__) throw VerboseException(__msg__,__func__,__FILE__,__LINE__);



// The VerboseException class....

class VerboseException : public std::runtime_error
{
public:
	
	// Various constructors....

	VerboseException(const std::string& descr) : 
		std::runtime_error(descr.c_str()), mFunctionName(""), mSrcFile(""), mSrcLine(0)
	{
		// Nothing to do here
	}
	

	VerboseException(const std::string& descr, const std::string& func) :
		std::runtime_error(descr.c_str()), mFunctionName(func), mSrcFile(""), mSrcLine(0)
	{
		// Nothing to do here
	}
	

	VerboseException(const std::string& descr, const std::string& srcfile, const int line) : 
		std::runtime_error(descr.c_str()), mFunctionName(""), mSrcFile(srcfile), mSrcLine(line)
	{
		// Nothing to do here
	}
	

	VerboseException(const std::string& descr, const std::string& func, const std::string& srcfile, const int line) : 
		std::runtime_error(descr.c_str()), mFunctionName(func), mSrcFile(srcfile), mSrcLine(line)
	{
		// Nothing to do here
	}

	
	
	// Force it virtual
	
	virtual ~VerboseException() throw()
	{
	
	}
	
	
	// A couple of methods to get back the extra info available in a VerboseException
	
	std::string& whatFunction() { return mFunctionName; }
	
	std::string& whatSrcFile() { return mSrcFile; }
	
	int whatSrcLine() { return mSrcLine; }


private:

	std::string mFunctionName;
	std::string mSrcFile;
	int mSrcLine;
};

#endif
