/*
 * util.h
 *
 * Copyright (c) 2002 Maksim Yevmenkin <m_evmenkin@yahoo.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: util.h,v 1.10 2010/10/22 17:04:11 max Exp $
 * $FreeBSD$
 */

#ifndef _UTIL_H_
#define _UTIL_H_

int obexapp_util_locale_init(void);
void obexapp_util_locale_fini(void);
int obexapp_util_locale_from_utf8(char const *src, size_t srclen, char *dst, size_t dstlen);
int obexapp_util_locale_to_utf8(char const *src, size_t srclen, char *dst, size_t dstlen);
int obexapp_util_locale_from_utf16be(uint8_t const *src, size_t srclen, char *dst, size_t dstlen);
int obexapp_util_locale_to_utf16be(char const *src, size_t srclen, uint8_t *dst, size_t dstlen);

ssize_t obexapp_util_read(int fd, uint8_t *buffer, size_t buffer_length);
ssize_t obexapp_util_write(int fd, uint8_t const *buffer, size_t buffer_length);
int obexapp_util_display_folder_listing(char const *ls);
char *	obexapp_util_gets(char const *prompt, char *buffer, int buffer_size);
char *	obexapp_util_strsep(char **sp, char const *delim);
int	obexapp_util_mkstemp(char const *name, char *temp, int temp_size);
int obexapp_util_errno2response(int error);

#endif /* ndef _UTIL_H_ */

