/*
 * obexapp.h
 *
 * Copyright (c) 2002-2009 Maksim Yevmenkin <m_evmenkin@yahoo.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: obexapp.h,v 1.11 2010/10/22 17:04:11 max Exp $
 * $FreeBSD$
 */

#ifndef _OBEXAPP_H_
#define _OBEXAPP_H_

/*
 * Defines 
 */

#define OBEXAPP_ROOT_DIR		"/var/spool/obex"
#define OBEXAPP_DEFAULT_OBJECT		"default.vcf"
#define OBEXAPP_TRANSPORT_TIMEOUT	5
#define OBEXAPP_BUFFER_SIZE		65536	/* 64Kbytes */

#define OBEXAPP_PACK_RSP_CODES(h, l)	((((h) & 0xff) << 8) | ((l) & 0xff))
#define OBEXAPP_UNPACK_HI_RSP_CODE(c)	(((c) >> 8) & 0xff)
#define OBEXAPP_UNPACK_LO_RSP_CODE(c)	((c) & 0xff)

#define OBEXAPP_GET			1	/* regular GET */
#define OBEXAPP_GET_FOLDER_LISTING	2	/* GET ls folder */
#define OBEXAPP_GET_CAPABILITY		3	/* GET capability object */
#define OBEXAPP_PUT			4	/* regular PUT */
#define OBEXAPP_PUT_CREATE_EMPTY	5	/* PUT create-empty */
#define OBEXAPP_PUT_DELETE		6	/* PUT delete */
#define OBEXAPP_SETPATH			7	/* regular SETPATH */
#define OBEXAPP_SETPATH_MKDIR		8	/* SETPATH mkdir */
#define OBEXAPP_SETPATH_PARENT		9	/* SETPATH cd .. */
#define OBEXAPP_SETPATH_ROOT		10	/* SETPATH cd / */

#define OBEXAPP_PSTREAM_START		1	/* PUT stream started */
#define OBEXAPP_PSTREAM_CONTINUE	2	/* PUT stream continued */
#define OBEXAPP_PSTREAM_END		3	/* PUT stream ended */

#define	OBEXAPP_INVALID_CONNECTION_ID	(uint32_t)(0xffffffff)

typedef	void (obexapp_event_handler_t)(obex_t *, obex_object_t *, int, int);
typedef	int  (obexapp_request_handler_t)(obex_t *, obex_object_t *, int);

/*
 * OBEX context
 */

struct context
{
	bdaddr_t		 raddr;          /* remote address */
	bdaddr_t		 laddr;          /* local address */
	uint8_t			 channel;	 /* RFCOMM channel */
	char			*root;           /* root path */
	char			*user;           /* user */

	obex_t			*handle;         /* OBEX handle */
	uint32_t		 connection_id;  /* connection ID */

	unsigned		 opcode     : 8; /* opcode */
	unsigned		 rsp        : 8; /* response code */
	unsigned		 pstream    : 8; /* PUT stream state */
	unsigned		 direct     : 1; /* using stdin/stdout? */
	unsigned		 server     : 1; /* server mode? */
	unsigned		 secure     : 1; /* secure mode? */
	unsigned		 done       : 1; /* done? */
	unsigned 		 fbs        : 1; /* Folder Browsing Service */
	unsigned		 vroot	    : 1; /* virtualize device's root */
	unsigned		 ni         : 1; /* non-interactive? */
	unsigned		 reserved   : 1;

	/* local SDP session (server only) */
	void			*ss;

	/* Dynamic buffer for OBEX_GET_FOLDER_LISTING and OBEX_GET_CAPABILITY */
	char			*ls;
	int			 ls_size;

	/* file name and temp file name for GET/PUT */
	char			*file;
	char			*temp;

	/* transport file descriptor and buffer */
	int			 tfd;
	uint8_t			*tbuffer;

	/* stream file descriptor and buffer */
	int			 sfd;
	uint8_t			*sbuffer;
	size_t			 stotal;
	time_t			 stime;

	int			 mtu;            /* OBEX MTU */

	/* credentials */
	uid_t			 uid;
	gid_t			 gid;
};
typedef struct context		context_t;
typedef struct context *	context_p;

/*
 * OBEX Connect header
 */

struct obex_connect_hdr
{
	uint8_t		version;
        uint8_t		flags;
        uint16_t	mtu;
} __attribute__ ((packed));
typedef struct obex_connect_hdr	obex_connect_hdr_t;

/*
 * OBEX SetPath header
 */

struct obex_setpath_hdr 
{
	uint8_t	flags;
	uint8_t	constants;
} __attribute__ ((packed));
typedef struct obex_setpath_hdr	obex_setpath_hdr_t;

#endif /* _OBEXAPP_H_ */

