package variables

// There are total 5 sources of variables
// 1. VariablesMap - Variables defined in the template  (available at Request.options.Variables in protocols)
// 2. PayloadsMap  - Payloads defined in the template   (available at Request.generator in protocols)
// 3. OptionsMap   - Variables passed using CLI Options (+ Env) (available at generators.BuildPayloadFromOptions)
// 4. DynamicMap   - Variables Obtained by extracting data from templates  (available at Request.ExecuteWithResults + merged with previous internalEvent)
// 5. ProtocolMap  - Variables generated by Evaluation Request / Responses of xyz protocol (available in Request.Make)
// 6. ConstantsMap  - Constants defined in the template (available at Request.options.Constants in protocols)

// As we can tell , all variables sources are not linear i.e why they need to re-evaluated
// consider example
// variables:
//  - name: "username@{{Host}}"

// Linear Sources (once obtained no need to re-evaluate)
// simply put they don't contain references to other variables
// 1. OptionsMap
// 2. DynamicMap
// 3. ProtocolMap

// Non-Linear Sources (need to re-evaluate)
// 1. VariablesMap
// 2. PayloadsMap
// Every time Linear Sources are updated , Non-Linear Sources need to be re-evaluated

// Constants (no need to re-evaluate, should contain only scalars)
