/*
 *
 * (C) 2013-24 - ntop.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

/*
  NOTE

  This is the companion file of nProbe/template.h
*/

#ifndef _NTOP_FLOW_H_
#define _NTOP_FLOW_H_

#define UNKNOWN_FLOW_ELEMENT (u_int32_t) - 1
#define UNKNOWN_PEN (u_int32_t) - 1

#define NTOP_PEN 35632
#define NTOP_BASE_ID 57472

/* 1024 custom ntop elements for v9 should be enough */
#define NTOP_BASE_NETFLOW_ID NTOP_BASE_ID + 1024

#define IN_BYTES 1
#define SYSTEM_ID 1
#define IN_PKTS 2
#define INTERFACE_ID 2
#define FLOWS 3
#define LINE_CARD 3
#define PROTOCOL 4
#define PROTOCOL_MAP NTOP_BASE_NETFLOW_ID + 4
#define NETFLOW_CACHE 4
#define SRC_TOS 5
#define TEMPLATE_ID 5
#define TCP_FLAGS 6
#define L4_SRC_PORT 7
#define L4_SRC_PORT_MAP NTOP_BASE_NETFLOW_ID + 7
#define IPV4_SRC_ADDR 8
#define IPV4_SRC_MASK 9
#define INPUT_SNMP 10
#define L4_DST_PORT 11
#define L4_DST_PORT_MAP NTOP_BASE_NETFLOW_ID + 11
#define L4_SRV_PORT NTOP_BASE_NETFLOW_ID + 12
#define L4_SRV_PORT_MAP NTOP_BASE_NETFLOW_ID + 13
#define IPV4_DST_ADDR 12
#define IPV4_DST_MASK 13
#define OUTPUT_SNMP 14
#define IPV4_NEXT_HOP 15
#define SRC_AS 16
#define DST_AS 17
#define BGP_IPV4_NEXT_HOP 18
#define MUL_DST_PKTS 19
#define MUL_DST_BYTES 20
#define LAST_SWITCHED 21
#define FIRST_SWITCHED 22
#define OUT_BYTES 23
#define OUT_PKTS 24
#define IPV6_SRC_ADDR 27
#define IPV6_DST_ADDR 28
#define IPV6_SRC_MASK 29
#define IPV6_DST_MASK 30
#define IPV6_FLOW_LABEL 31
#define ICMP_TYPE 32
#define MUL_IGMP_TYPE 33
#define SAMPLING_INTERVAL 34
#define SAMPLING_ALGORITHM 35
#define FLOW_ACTIVE_TIMEOUT 36
#define FLOW_INACTIVE_TIMEOUT 37
#define ENGINE_TYPE 38
#define ENGINE_ID 39
#define TOTAL_BYTES_EXP 40
#define TOTAL_PKTS_EXP 41
#define TOTAL_FLOWS_EXP 42
#define MIN_TTL 52
#define MAX_TTL 53
#define DST_TOS 55
#define IN_SRC_MAC 56
#define OUT_DST_MAC 57
#define SRC_VLAN 58
#define DST_VLAN 59
#define DOT1Q_SRC_VLAN 243
#define DOT1Q_DST_VLAN 254

#define IP_PROTOCOL_VERSION 60
#define DIRECTION 61
#define IPV6_NEXT_HOP 62
#define BPG_IPV6_NEXT_HOP 63
#define IPV6_OPTION_HEADERS 64
#define MPLS_LABEL_1 70
#define MPLS_LABEL_2 71
#define MPLS_LABEL_3 72
#define MPLS_LABEL_4 73
#define MPLS_LABEL_5 74
#define MPLS_LABEL_6 75
#define MPLS_LABEL_7 76
#define MPLS_LABEL_8 77
#define MPLS_LABEL_9 78
#define MPLS_LABEL_10 79
#define IN_DST_MAC 80
#define OUT_SRC_MAC 81
#define INTERFACE_NAME 82
#define APPLICATION_ID 95
#define PACKET_SECTION_OFFSET 102
#define SAMPLED_PACKET_SIZE 103
#define SAMPLED_PACKET_ID 104
#define BGP_NEXT_ADJACENT_ASN 128
#define BGP_PREV_ADJACENT_ASN 129
#define EXPORTER_IPV4_ADDRESS 130
#define EXPORTER_IPV6_ADDRESS 131
#define FLOW_END_REASON 136
#define FLOW_ID 148
#define FLOW_START_SEC 150
#define FLOW_END_SEC 151
#define FLOW_START_MILLISECONDS 152
#define FLOW_END_MILLISECONDS 153
#define FLOW_START_MICROSECONDS 154
#define FLOW_END_MICROSECONDS 155
#define FLOW_START_NANOSECONDS 156
#define FLOW_END_NANOSECONDS 157
#define FLOW_DURATION_MILLISECONDS 161
#define FLOW_DURATION_MICROSECONDS 162
#define ICMP_IPV4_TYPE 176
#define ICMP_IPV4_CODE 177
#define TCP_SRC_PORT 182
#define TCP_DST_PORT 183
#define INITIATOR_OCTETS 231
#define RESPONDER_OCTETS 232
#define FIREWALL_EVENT 233
#define INGRESS_VRFID 234
#define BIFLOW_DIRECTION 239
#define POST_NAT_SRC_IPV4_ADDR 225
#define POST_NAT_DST_IPV4_ADDR 226
#define POST_NAT_SRC_TRANSPORT_PORT 227
#define POST_NAT_DST_TRANSPORT_PORT 228
#define OBSERVATION_POINT_TYPE 277
#define INITIATOR_PKTS 298
#define RESPONDER_PKTS 299
#define OBSERVATION_POINT_ID 300
#define SELECTOR_ID 302
#define IPFIX_SAMPLING_ALGORITHM 304
#define SAMPLING_SIZE 309
#define SAMPLING_POPULATION 310
#define FRAME_LENGTH 312
#define PACKETS_OBSERVED 318
#define PACKETS_SELECTED 319
#define SELECTOR_NAME 335
#define SRC_FRAGMENTS NTOP_BASE_ID + 80
#define DST_FRAGMENTS NTOP_BASE_ID + 81
#define SRC_AS_MAP NTOP_BASE_ID + 443
#define DST_AS_MAP NTOP_BASE_ID + 444
#define NPROBE_IPV4_ADDRESS NTOP_BASE_ID + 471 /* Exported only via ZMQ */
/* NTOP_BASE_ID+82 ->87  Available (deprecated) */
#define CLIENT_TCP_FLAGS NTOP_BASE_ID + 78
#define SERVER_TCP_FLAGS NTOP_BASE_ID + 79
#define NUM_PKTS_UP_TO_128_BYTES NTOP_BASE_ID + 88
#define NUM_PKTS_128_TO_256_BYTES NTOP_BASE_ID + 89
#define NUM_PKTS_256_TO_512_BYTES NTOP_BASE_ID + 90
#define NUM_PKTS_512_TO_1024_BYTES NTOP_BASE_ID + 91
#define NUM_PKTS_1024_TO_1514_BYTES NTOP_BASE_ID + 92
#define NUM_PKTS_OVER_1514_BYTES NTOP_BASE_ID + 93
#define CUMULATIVE_ICMP_TYPE NTOP_BASE_ID + 98
#define SRC_IP_COUNTRY NTOP_BASE_ID + 101
#define SRC_IP_CITY NTOP_BASE_ID + 102
#define DST_IP_COUNTRY NTOP_BASE_ID + 103
#define DST_IP_CITY NTOP_BASE_ID + 104
#define FLOW_PROTO_PORT NTOP_BASE_ID + 105
#define UPSTREAM_TUNNEL_ID NTOP_BASE_ID + 106
#define LONGEST_FLOW_PKT NTOP_BASE_ID + 107
#define SHORTEST_FLOW_PKT NTOP_BASE_ID + 108
#define RETRANSMITTED_IN_PKTS NTOP_BASE_ID + 109
#define RETRANSMITTED_OUT_PKTS NTOP_BASE_ID + 110
#define OOORDER_IN_PKTS NTOP_BASE_ID + 111
#define OOORDER_OUT_PKTS NTOP_BASE_ID + 112
#define UNTUNNELED_PROTOCOL NTOP_BASE_ID + 113
#define UNTUNNELED_IPV4_SRC_ADDR NTOP_BASE_ID + 114
#define UNTUNNELED_L4_SRC_PORT NTOP_BASE_ID + 115
#define UNTUNNELED_IPV4_DST_ADDR NTOP_BASE_ID + 116
#define UNTUNNELED_L4_DST_PORT NTOP_BASE_ID + 117
#define L7_PROTO NTOP_BASE_ID + 118
#define L7_PROTO_NAME NTOP_BASE_ID + 119
#define L7_INFO NTOP_BASE_ID + 539
#define L7_CONFIDENCE NTOP_BASE_ID + 560
#define DOWNSTREAM_TUNNEL_ID NTOP_BASE_ID + 120
#define FLOW_USER_NAME NTOP_BASE_ID + 121
#define NPROBE_INSTANCE_NAME NTOP_BASE_ID + 122
#define CLIENT_NW_LATENCY_MS NTOP_BASE_ID + 123
#define SERVER_NW_LATENCY_MS NTOP_BASE_ID + 124
#define APPL_LATENCY_MS NTOP_BASE_ID + 125
#define PLUGIN_NAME NTOP_BASE_ID + 126
#define RETRANSMITTED_IN_BYTES NTOP_BASE_ID + 127
#define RETRANSMITTED_OUT_BYTES NTOP_BASE_ID + 128
#define SRC_IP_LONG NTOP_BASE_ID + 448
#define SRC_IP_LAT NTOP_BASE_ID + 449
#define DST_IP_LONG NTOP_BASE_ID + 450
#define DST_IP_LAT NTOP_BASE_ID + 451
#define UNTUNNELED_IPV6_SRC_ADDR NTOP_BASE_ID + 396
#define UNTUNNELED_IPV6_DST_ADDR NTOP_BASE_ID + 397
#define NUM_PKTS_TTL_EQ_1 NTOP_BASE_ID + 347
#define NUM_PKTS_TTL_2_5 NTOP_BASE_ID + 346
#define NUM_PKTS_TTL_5_32 NTOP_BASE_ID + 334
#define NUM_PKTS_TTL_32_64 NTOP_BASE_ID + 335
#define NUM_PKTS_TTL_64_96 NTOP_BASE_ID + 336
#define NUM_PKTS_TTL_96_128 NTOP_BASE_ID + 337
#define NUM_PKTS_TTL_128_160 NTOP_BASE_ID + 338
#define NUM_PKTS_TTL_160_192 NTOP_BASE_ID + 339
#define NUM_PKTS_TTL_192_224 NTOP_BASE_ID + 340
#define NUM_PKTS_TTL_224_255 NTOP_BASE_ID + 341
#define IN_SRC_OSI_SAP NTOP_BASE_ID + 349
#define OUT_DST_OSI_SAP NTOP_BASE_ID + 350
#define DURATION_IN NTOP_BASE_ID + 391
#define DURATION_OUT NTOP_BASE_ID + 392
#define TCP_WIN_MIN_IN NTOP_BASE_ID + 415
#define TCP_WIN_MAX_IN NTOP_BASE_ID + 416
#define TCP_WIN_MSS_IN NTOP_BASE_ID + 417
#define TCP_WIN_SCALE_IN NTOP_BASE_ID + 418
#define TCP_WIN_MIN_OUT NTOP_BASE_ID + 419
#define TCP_WIN_MAX_OUT NTOP_BASE_ID + 420
#define TCP_WIN_MSS_OUT NTOP_BASE_ID + 421
#define TCP_WIN_SCALE_OUT NTOP_BASE_ID + 422
#define PAYLOAD_HASH NTOP_BASE_ID + 438
#define UPSTREAM_SESSION_ID NTOP_BASE_ID + 446
#define DOWNSTREAM_SESSION_ID NTOP_BASE_ID + 447
#define TLS_SERVER_NAME NTOP_BASE_ID + 188
#define BITTORRENT_HASH NTOP_BASE_ID + 189
#define TLS_CIPHER NTOP_BASE_ID + 493
#define SSL_UNSAFE_CIPHER NTOP_BASE_ID + 494
#define L7_PROTO_RISK NTOP_BASE_ID + 509
#define HASSHC_HASH NTOP_BASE_ID + 525
#define HASSHS_HASH NTOP_BASE_ID + 526
#define FLOW_VERDICT NTOP_BASE_ID + 522
#define L7_ERROR_CODE NTOP_BASE_ID + 554
#define L7_RISK_INFO NTOP_BASE_ID + 555
#define JA4C_HASH NTOP_BASE_ID + 576
#define FLOW_SOURCE  NTOP_BASE_ID+579 /* 0 = packets, 1 = collected NetFlow/IPFIX, 2 = collected sFlow/nfLite */

/* eBPF / Process */
#define SRC_PROC_PID NTOP_BASE_ID + 168
#define SRC_PROC_NAME NTOP_BASE_ID + 169
#define SRC_PROC_UID NTOP_BASE_ID + 425
#define SRC_PROC_USER_NAME NTOP_BASE_ID + 372
#define SRC_FATHER_PROC_PID NTOP_BASE_ID + 373
#define SRC_FATHER_PROC_NAME NTOP_BASE_ID + 374
#define SRC_FATHER_PROC_PKG_NAME NTOP_BASE_ID + 561
#define SRC_FATHER_PROC_UID NTOP_BASE_ID + 564
#define SRC_FATHER_PROC_USER_NAME NTOP_BASE_ID + 565
#define SRC_PROC_ACTUAL_MEMORY NTOP_BASE_ID + 383
#define SRC_PROC_PEAK_MEMORY NTOP_BASE_ID + 384
#define SRC_PROC_AVERAGE_CPU_LOAD NTOP_BASE_ID + 385
#define SRC_PROC_NUM_PAGE_FAULTS NTOP_BASE_ID + 386
#define SRC_PROC_PCTG_IOWAIT NTOP_BASE_ID + 393
#define SRC_PROC_PKG_NAME NTOP_BASE_ID + 540
#define SRC_PROC_CMDLINE NTOP_BASE_ID + 556
#define SRC_PROC_CONTAINER_ID NTOP_BASE_ID + 558

#define DST_PROC_PID NTOP_BASE_ID + 375
#define DST_PROC_NAME NTOP_BASE_ID + 376
#define DST_PROC_UID NTOP_BASE_ID + 426
#define DST_PROC_USER_NAME NTOP_BASE_ID + 377
#define DST_FATHER_PROC_PID NTOP_BASE_ID + 378
#define DST_FATHER_PROC_NAME NTOP_BASE_ID + 379
#define DST_FATHER_PROC_PKG_NAME NTOP_BASE_ID + 563
#define DST_FATHER_PROC_UID NTOP_BASE_ID + 567
#define DST_FATHER_PROC_USER_NAME NTOP_BASE_ID + 568
#define DST_PROC_ACTUAL_MEMORY NTOP_BASE_ID + 387
#define DST_PROC_PEAK_MEMORY NTOP_BASE_ID + 388
#define DST_PROC_AVERAGE_CPU_LOAD NTOP_BASE_ID + 389
#define DST_PROC_NUM_PAGE_FAULTS NTOP_BASE_ID + 390
#define DST_PROC_PCTG_IOWAIT NTOP_BASE_ID + 394
#define DST_PROC_PKG_NAME NTOP_BASE_ID + 541
#define DST_PROC_CMDLINE NTOP_BASE_ID + 557
#define DST_PROC_CONTAINER_ID NTOP_BASE_ID + 559

/* SIP */
#define SIP_CALL_ID NTOP_BASE_ID + 130
#define SIP_CALLING_PARTY NTOP_BASE_ID + 131
#define SIP_CALLED_PARTY NTOP_BASE_ID + 132
#define SIP_RTP_CODECS NTOP_BASE_ID + 133
#define SIP_INVITE_TIME NTOP_BASE_ID + 134
#define SIP_TRYING_TIME NTOP_BASE_ID + 135
#define SIP_RINGING_TIME NTOP_BASE_ID + 136
#define SIP_INVITE_OK_TIME NTOP_BASE_ID + 137
#define SIP_INVITE_FAILURE_TIME NTOP_BASE_ID + 138
#define SIP_BYE_TIME NTOP_BASE_ID + 139
#define SIP_BYE_OK_TIME NTOP_BASE_ID + 140
#define SIP_CANCEL_TIME NTOP_BASE_ID + 141
#define SIP_CANCEL_OK_TIME NTOP_BASE_ID + 142
#define SIP_RTP_IPV4_SRC_ADDR NTOP_BASE_ID + 143
#define SIP_RTP_L4_SRC_PORT NTOP_BASE_ID + 144
#define SIP_RTP_IPV4_DST_ADDR NTOP_BASE_ID + 145
#define SIP_RTP_L4_DST_PORT NTOP_BASE_ID + 146
#define SIP_RESPONSE_CODE NTOP_BASE_ID + 147
#define SIP_REASON_CAUSE NTOP_BASE_ID + 148
#define SIP_C_IP NTOP_BASE_ID + 362
#define SIP_CALL_STATE NTOP_BASE_ID + 363

/* EPP - Identifiers reserved but not used by any plugin */
#define EPP_REGISTRAR_NAME NTOP_BASE_ID + 364
#define EPP_CMD NTOP_BASE_ID + 365
#define EPP_CMD_ARGS NTOP_BASE_ID + 366
#define EPP_RSP_CODE NTOP_BASE_ID + 367
#define EPP_REASON_STR NTOP_BASE_ID + 368
#define EPP_SERVER_NAME NTOP_BASE_ID + 369

/* RTP */
#define RTP_SSRC NTOP_BASE_ID + 437
#define RTP_FIRST_SEQ NTOP_BASE_ID + 150
#define RTP_FIRST_TS NTOP_BASE_ID + 151
#define RTP_LAST_SEQ NTOP_BASE_ID + 152
#define RTP_LAST_TS NTOP_BASE_ID + 153
#define RTP_IN_JITTER NTOP_BASE_ID + 154
#define RTP_OUT_JITTER NTOP_BASE_ID + 155
#define RTP_IN_PKT_LOST NTOP_BASE_ID + 156
#define RTP_OUT_PKT_LOST NTOP_BASE_ID + 157
#define RTP_IN_PAYLOAD_TYPE NTOP_BASE_ID + 161
#define RTP_OUT_PAYLOAD_TYPE NTOP_BASE_ID + 158
#define RTP_IN_MAX_DELTA NTOP_BASE_ID + 159
#define RTP_OUT_MAX_DELTA NTOP_BASE_ID + 160
#define RTP_SIP_CALL_ID NTOP_BASE_ID + 348
#define RTP_MOS NTOP_BASE_ID + 434
#define RTP_R_FACTOR NTOP_BASE_ID + 436
#define RTP_IN_MOS NTOP_BASE_ID + 370
#define RTP_IN_R_FACTOR NTOP_BASE_ID + 371
#define RTP_OUT_MOS NTOP_BASE_ID + 432
#define RTP_OUT_R_FACTOR NTOP_BASE_ID + 433
#define RTP_RTT NTOP_BASE_ID + 380
#define RTP_IN_TRANSIT NTOP_BASE_ID + 381
#define RTP_OUT_TRANSIT NTOP_BASE_ID + 382
#define RTP_DTMF_TONES NTOP_BASE_ID + 395
#define RTP_IN_PKT_DROP NTOP_BASE_ID + 430
#define RTP_OUT_PKT_DROP NTOP_BASE_ID + 431

/* HTTP */
#define HTTP_URL NTOP_BASE_ID + 180
#define HTTP_METHOD NTOP_BASE_ID + 360
#define HTTP_RET_CODE NTOP_BASE_ID + 181
#define HTTP_REFERER NTOP_BASE_ID + 182
#define HTTP_USER_AGENT NTOP_BASE_ID + 183
#define HTTP_MIME NTOP_BASE_ID + 184
#define HTTP_HOST NTOP_BASE_ID + 187
#define HTTP_SITE NTOP_BASE_ID + 361

/* SMTP */
#define SMTP_MAIL_FROM NTOP_BASE_ID + 185
#define SMTP_RCPT_TO NTOP_BASE_ID + 186

/* MySQL */
#define MYSQL_SRV_VERSION NTOP_BASE_ID + 195
#define MYSQL_USERNAME NTOP_BASE_ID + 196
#define MYSQL_DB NTOP_BASE_ID + 197
#define MYSQL_QUERY NTOP_BASE_ID + 198
#define MYSQL_RESPONSE NTOP_BASE_ID + 199
#define MYSQL_APPL_LATENCY_USEC NTOP_BASE_ID + 320

/* Oracle */
#define ORACLE_USERNAME NTOP_BASE_ID + 200
#define ORACLE_QUERY NTOP_BASE_ID + 201
#define ORACLE_RSP_CODE NTOP_BASE_ID + 202
#define ORACLE_RSP_STRING NTOP_BASE_ID + 203
#define ORACLE_QUERY_DURATION NTOP_BASE_ID + 204

/* DNS */
#define DNS_QUERY NTOP_BASE_ID + 205
#define DNS_QUERY_ID NTOP_BASE_ID + 206
#define DNS_QUERY_TYPE NTOP_BASE_ID + 207
#define DNS_RET_CODE NTOP_BASE_ID + 208
#define DNS_NUM_ANSWERS NTOP_BASE_ID + 209
#define DNS_TTL_ANSWER NTOP_BASE_ID + 352
#define DNS_RESPONSE NTOP_BASE_ID + 398

/* POP */
#define POP_USER NTOP_BASE_ID + 210

/* GTPv1 */
#define GTPV1_REQ_MSG_TYPE NTOP_BASE_ID + 220
#define GTPV1_RSP_MSG_TYPE NTOP_BASE_ID + 221
#define GTPV1_C2S_TEID_DATA NTOP_BASE_ID + 222
#define GTPV1_C2S_TEID_CTRL NTOP_BASE_ID + 223
#define GTPV1_S2C_TEID_DATA NTOP_BASE_ID + 224
#define GTPV1_S2C_TEID_CTRL NTOP_BASE_ID + 225
#define GTPV1_END_USER_IP NTOP_BASE_ID + 226
#define GTPV1_END_USER_IMSI NTOP_BASE_ID + 227
#define GTPV1_END_USER_MSISDN NTOP_BASE_ID + 228
#define GTPV1_END_USER_IMEI NTOP_BASE_ID + 229
#define GTPV1_APN_NAME NTOP_BASE_ID + 230
#define GTPV1_RAI_MCC NTOP_BASE_ID + 231
#define GTPV1_RAI_MNC NTOP_BASE_ID + 232
#define GTPV1_RAI_LAC NTOP_BASE_ID + 342
#define GTPV1_RAI_RAC NTOP_BASE_ID + 343
#define GTPV1_ULI_MCC NTOP_BASE_ID + 344
#define GTPV1_ULI_MNC NTOP_BASE_ID + 345
#define GTPV1_ULI_CELL_LAC NTOP_BASE_ID + 233
#define GTPV1_ULI_CELL_CI NTOP_BASE_ID + 234
#define GTPV1_ULI_SAC NTOP_BASE_ID + 235
#define GTPV1_RESPONSE_CAUSE NTOP_BASE_ID + 332
#define GTPV1_RAT_TYPE NTOP_BASE_ID + 236

/* Radius */
#define RADIUS_REQ_MSG_TYPE NTOP_BASE_ID + 240
#define RADIUS_RSP_MSG_TYPE NTOP_BASE_ID + 241
#define RADIUS_USER_NAME NTOP_BASE_ID + 242
#define RADIUS_CALLING_STATION_ID NTOP_BASE_ID + 243
#define RADIUS_CALLED_STATION_ID NTOP_BASE_ID + 244
#define RADIUS_NAS_IP_ADDR NTOP_BASE_ID + 245
#define RADIUS_NAS_IDENTIFIER NTOP_BASE_ID + 246
#define RADIUS_USER_IMSI NTOP_BASE_ID + 247
#define RADIUS_USER_IMEI NTOP_BASE_ID + 248
#define RADIUS_FRAMED_IP_ADDR NTOP_BASE_ID + 249
#define RADIUS_ACCT_SESSION_ID NTOP_BASE_ID + 250
#define RADIUS_ACCT_STATUS_TYPE NTOP_BASE_ID + 251
#define RADIUS_ACCT_IN_OCTETS NTOP_BASE_ID + 252
#define RADIUS_ACCT_OUT_OCTETS NTOP_BASE_ID + 253
#define RADIUS_ACCT_IN_PKTS NTOP_BASE_ID + 254
#define RADIUS_ACCT_OUT_PKTS NTOP_BASE_ID + 255

/* IMAP */
#define IMAP_LOGIN NTOP_BASE_ID + 260

/* GTPv2 */
#define GTPV2_REQ_MSG_TYPE NTOP_BASE_ID + 270
#define GTPV2_RSP_MSG_TYPE NTOP_BASE_ID + 271
#define GTPV2_C2S_S1U_GTPU_TEID NTOP_BASE_ID + 272
#define GTPV2_C2S_S1U_GTPU_IP NTOP_BASE_ID + 273
#define GTPV2_S2C_S1U_GTPU_TEID NTOP_BASE_ID + 274
#define GTPV2_S2C_S1U_GTPU_IP NTOP_BASE_ID + 275
#define GTPV2_END_USER_IMSI NTOP_BASE_ID + 276
#define GTPV2_END_USER_MSISDN NTOP_BASE_ID + 277
#define GTPV2_APN_NAME NTOP_BASE_ID + 278
#define GTPV2_ULI_MCC NTOP_BASE_ID + 279
#define GTPV2_ULI_MNC NTOP_BASE_ID + 280
#define GTPV2_ULI_CELL_TAC NTOP_BASE_ID + 281
#define GTPV2_ULI_CELL_ID NTOP_BASE_ID + 282
#define GTPV2_RAT_TYPE NTOP_BASE_ID + 283
#define GTPV2_PDN_IP NTOP_BASE_ID + 284
#define GTPV2_END_USER_IMEI NTOP_BASE_ID + 285
#define GTPV2_RESPONSE_CAUSE NTOP_BASE_ID + 333
#define GTPV2_S5_S8_GTPC_TEID NTOP_BASE_ID + 435
#define GTPV2_C2S_S5_S8_GTPU_TEID NTOP_BASE_ID + 439
#define GTPV2_S2C_S5_S8_GTPU_TEID NTOP_BASE_ID + 440
#define GTPV2_C2S_S5_S8_GTPU_IP NTOP_BASE_ID + 441
#define GTPV2_S2C_S5_S8_GTPU_IP NTOP_BASE_ID + 442

/* BGP */
#define SRC_AS_PATH_1 NTOP_BASE_ID + 290
#define SRC_AS_PATH_2 NTOP_BASE_ID + 291
#define SRC_AS_PATH_3 NTOP_BASE_ID + 292
#define SRC_AS_PATH_4 NTOP_BASE_ID + 293
#define SRC_AS_PATH_5 NTOP_BASE_ID + 294
#define SRC_AS_PATH_6 NTOP_BASE_ID + 295
#define SRC_AS_PATH_7 NTOP_BASE_ID + 296
#define SRC_AS_PATH_8 NTOP_BASE_ID + 297
#define SRC_AS_PATH_9 NTOP_BASE_ID + 298
#define SRC_AS_PATH_10 NTOP_BASE_ID + 299
#define DST_AS_PATH_1 NTOP_BASE_ID + 300
#define DST_AS_PATH_2 NTOP_BASE_ID + 301
#define DST_AS_PATH_3 NTOP_BASE_ID + 302
#define DST_AS_PATH_4 NTOP_BASE_ID + 303
#define DST_AS_PATH_5 NTOP_BASE_ID + 304
#define DST_AS_PATH_6 NTOP_BASE_ID + 305
#define DST_AS_PATH_7 NTOP_BASE_ID + 306
#define DST_AS_PATH_8 NTOP_BASE_ID + 307
#define DST_AS_PATH_9 NTOP_BASE_ID + 308
#define DST_AS_PATH_10 NTOP_BASE_ID + 309

/* GTPv0 */
/* Note NTOP_BASE_ID+320 is used by MySQL */
#define GTPV0_REQ_MSG_TYPE NTOP_BASE_ID + 321
#define GTPV0_RSP_MSG_TYPE NTOP_BASE_ID + 322
#define GTPV0_TID NTOP_BASE_ID + 323
#define GTPV0_END_USER_IP NTOP_BASE_ID + 324
#define GTPV0_END_USER_MSISDN NTOP_BASE_ID + 325
#define GTPV0_APN_NAME NTOP_BASE_ID + 326
#define GTPV0_RAI_MCC NTOP_BASE_ID + 327
#define GTPV0_RAI_MNC NTOP_BASE_ID + 328
#define GTPV0_RAI_CELL_LAC NTOP_BASE_ID + 329
#define GTPV0_RAI_CELL_RAC NTOP_BASE_ID + 330
#define GTPV0_RESPONSE_CAUSE NTOP_BASE_ID + 331

#define WHOIS_DAS_DOMAIN NTOP_BASE_ID + 351

#define DHCP_CLIENT_MAC NTOP_BASE_ID + 353
#define DHCP_CLIENT_IP NTOP_BASE_ID + 354
#define DHCP_CLIENT_NAME NTOP_BASE_ID + 355
#define DHCP_REMOTE_ID NTOP_BASE_ID + 423
#define DHCP_SUBSCRIBER_ID NTOP_BASE_ID + 424
#define DHCP_MESSAGE_TYPE NTOP_BASE_ID + 429

#define FTP_LOGIN NTOP_BASE_ID + 356
#define FTP_PASSWORD NTOP_BASE_ID + 357
#define FTP_COMMAND NTOP_BASE_ID + 358
#define FTP_COMMAND_RET_CODE NTOP_BASE_ID + 359

/* Diameter */
#define DIAMETER_REQ_MSG_TYPE NTOP_BASE_ID + 399
#define DIAMETER_RSP_MSG_TYPE NTOP_BASE_ID + 400
#define DIAMETER_REQ_ORIGIN_HOST NTOP_BASE_ID + 401
#define DIAMETER_RSP_ORIGIN_HOST NTOP_BASE_ID + 402
#define DIAMETER_REQ_USER_NAME NTOP_BASE_ID + 403
#define DIAMETER_RSP_RESULT_CODE NTOP_BASE_ID + 404
#define DIAMETER_EXP_RES_VENDOR_ID NTOP_BASE_ID + 405
#define DIAMETER_EXP_RES_RESULT_CODE NTOP_BASE_ID + 406
#define DIAMETER_HOP_BY_HOP_ID NTOP_BASE_ID + 445

/* S1AP */
#define S1AP_ENB_UE_S1AP_ID NTOP_BASE_ID + 407
#define S1AP_MME_UE_S1AP_ID NTOP_BASE_ID + 408
#define S1AP_MSG_EMM_TYPE_MME_TO_ENB NTOP_BASE_ID + 409
#define S1AP_MSG_ESM_TYPE_MME_TO_ENB NTOP_BASE_ID + 410
#define S1AP_MSG_EMM_TYPE_ENB_TO_MME NTOP_BASE_ID + 411
#define S1AP_MSG_ESM_TYPE_ENB_TO_MME NTOP_BASE_ID + 412
#define S1AP_CAUSE_ENB_TO_MME NTOP_BASE_ID + 413
#define S1AP_DETAILED_CAUSE_ENB_TO_MME NTOP_BASE_ID + 414

/* PaloAlto */
#define APPLICATION_NAME NTOP_BASE_ID + 427 /* App-Id */
#define USER_NAME NTOP_BASE_ID + 428        /* User-Id */

#define L7_PROTO_RISK_NAME NTOP_BASE_ID + 510
#define TLS_REQUESTED_SNI NTOP_BASE_ID + 511
#define TLS_SERVER_NAMES NTOP_BASE_ID + 512
#define TLS_ALPN NTOP_BASE_ID + 513
#define TLS_CERT_ISSUER_DN NTOP_BASE_ID + 514
#define TLS_CERT_SUBJECT_DN NTOP_BASE_ID + 515
#define SRC_ADDR_LOCAL NTOP_BASE_ID + 516
#define SRC_ADDR_BLACKLISTED NTOP_BASE_ID + 517
#define SRC_ADDR_SERVICES NTOP_BASE_ID + 518
#define DST_ADDR_LOCAL NTOP_BASE_ID + 519
#define DST_ADDR_BLACKLISTED NTOP_BASE_ID + 520
#define DST_ADDR_SERVICES NTOP_BASE_ID + 521
#define SRC_NAME NTOP_BASE_ID + 522
#define DST_NAME NTOP_BASE_ID + 523
#define COMMUNITY_ID NTOP_BASE_ID + 524
#define L7_CATEGORY NTOP_BASE_ID + 509
#define FLOW_RISK NTOP_BASE_ID + 508
#define SRC_ASN NTOP_BASE_ID + 525
#define DST_ASN NTOP_BASE_ID + 526
#define PROBE_IP NTOP_BASE_ID + 527
#define L4_PROTO_NAME NTOP_BASE_ID + 528
#define L7_CATEGORY_ID NTOP_BASE_ID + 529
#define NTOPNG_INSTANCE_NAME NTOP_BASE_ID + 530
#define L7_RISK_SCORE NTOP_BASE_ID + 531
#define FLOW_TIME NTOP_BASE_ID + 532
#define PROFILE NTOP_BASE_ID + 533
#define STATUS NTOP_BASE_ID + 534
#define MAJOR_CONNECTION_STATE NTOP_BASE_ID + 535
#define MINOR_CONNECTION_STATE NTOP_BASE_ID + 536
#define L7_SERVICE NTOP_BASE_ID+582
#define UNIQUE_SOURCE_ID NTOP_BASE_ID+589 /* Unique nProbe + exporter flow source identifier */

/* sFlow Counter Fields */
#define SFLOW_DEVICE_IP 0
#define SFLOW_SAMPLES_GENERATED 1
#define SFLOW_IF_INDEX 2
#define SFLOW_IF_NAME 3
#define SFLOW_IF_TYPE 4
#define SFLOW_IF_SPEED 5
#define SFLOW_IF_DIRECTION 6
#define SFLOW_IF_ADMIN_STATUS 7
#define SFLOW_IF_OPER_STATUS 8
#define SFLOW_IF_IN_OCTETS 9
#define SFLOW_IF_IN_PACKETS 10
#define SFLOW_IF_IN_ERRORS 11
#define SFLOW_IF_OUT_OCTETS 12
#define SFLOW_IF_OUT_PACKETS 13
#define SFLOW_IF_OUT_ERRORS 14
#define SFLOW_IF_PROMISCUOUS_MODE 15

#endif /* _NTOP_FLOW_H_ */
