//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// サブウィンドウ
//

#include "wxsubwindow.h"
#include "fontmanager.h"
#include "wxmainframe.h"
#include "wxtextscreen.h"

//
// サブウィンドウ (基本クラス)
//

// イベントテーブル
wxBEGIN_EVENT_TABLE(WXSubWindow, inherited)
	EVT_CLOSE(WXSubWindow::OnClose)
wxEND_EVENT_TABLE()

// コンストラクタ
WXSubWindow::WXSubWindow(wxWindow *parent, wxWindowID id, const wxString& name,
	int style)
	: inherited(parent, id, name, wxDefaultPosition, wxDefaultSize, style)
{
}

// デストラクタ
WXSubWindow::~WXSubWindow()
{
}

// クローズイベント
void
WXSubWindow::OnClose(wxCloseEvent& event)
{
	// ウィンドウリストから自身を削除
	auto mainframe = dynamic_cast<WXMainFrame*>(GetParent());
	mainframe->DeleteWindow(this);
}

// フォントサイズ変更
void
WXSubWindow::FontChanged()
{
	// WXTextPanel 派生の子コントロールに対し FontChanged() を呼ぶ
	for (auto child : GetChildren()) {
		auto textpanel = dynamic_cast<WXTextPanel*>(child);
		if (textpanel) {
			textpanel->FontChanged();
		}
	}

	Fit();
}

// 中身に応じてこのウィンドウの大きさを変更。
// このウィンドウを sizer が支配しているか、
// このウィンドウにコントロールが1つしかない時に使える。
//
// コントロールが複数ある場合、どう配置するかの情報がないのでここでは処理
// 出来ない。これを継承したウィンドウが Fit() をオーバーライドし、適切に
// ウィンドウサイズを計算して SetClientSize() すること。
void
WXSubWindow::Fit()
{
	wxSize csize;

	auto *topsizer = GetSizer();
	if (topsizer) {
		// Sizer があればそれがサイズを知っている
		csize = topsizer->ComputeFittingClientSize(this);
	} else {
		// Sizer を使ってなければ子コントロールは1人のはず
		auto& children = GetChildren();
		assert(children.GetCount() == 1);
		auto child = children[0];
		csize = child->GetSize();
	}
	SetClientSize(csize);
}
