//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// wxWidgets のヘッダをよろしく読み込むためのヘッダ
//

#pragma once

// wx のシステムヘッダ内で警告出られてもどうしようもないのでワーニング抑制
#if defined(__clang__)
#define PRAGMA_PUSH_WARNINGS	\
	_Pragma("clang diagnostic push")	\
	_Pragma("clang diagnostic ignored \"-Weverything\"")
#define PRAGMA_POP_WARNINGS	\
	_Pragma("clang diagnostic pop")
#else
#define PRAGMA_PUSH_WARNINGS	\
	_Pragma("GCC diagnostic push")	\
	_Pragma("GCC diagnostic ignored \"-Wcast-qual\"")	\
	_Pragma("GCC diagnostic ignored \"-Wignored-qualifiers\"")
#define PRAGMA_POP_WARNINGS	\
	_Pragma("GCC diagnostic pop")
#endif


PRAGMA_PUSH_WARNINGS

#include <wx/wxprec.h>
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

PRAGMA_POP_WARNINGS
