//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// Pluto-X (独自の仮想ボード)
//

#pragma once

#include "device.h"

class PlutoDevice : public IODevice
{
	using inherited = IODevice;
	static const uint32 baseaddr = 0xeac000;

 public:
	PlutoDevice();
	~PlutoDevice() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;

 private:
	// ホストファイル起動
	uint32 ROM_Load();

	// ROM
	static const uint16 rom[];
};
