//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// NEWS の各種制御ポート(?)
//

#pragma once

#include "device.h"
#include "event.h"
#include <array>

class DipswDevice;
class NewsInterrupt;
class TextScreen;

class NewsCtlrDevice : public IODevice
{
	using inherited = IODevice;

	// システムタイマーの周期
	static const uint64 TIMER_PERIOD	= 10_msec;

 public:
	// LED 種別
	static const uint LED_GREEN		= 0x01;
	static const uint LED_ORANGE	= 0x02;

 public:
	NewsCtlrDevice();
	~NewsCtlrDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;

	uint GetLED() const { return led; }

	void MonitorUpdateNewsCtlr(TextScreen& screen, int y);

 private:
	uint8 GetIDROM(uint32 addr) const;
	uint8 GetDIPSW() const;
	void WriteLED(uint32 data);
	void WriteTimer(uint32 data);
	void TimerCallback(Event&);
	void ChangeInterrupt();

	// 割り込みコントローラ
	NewsInterrupt *interrupt {};

	// 256 x 4bit ROM (ここではデータをバイト単位で保持する)
	std::array<uint8, 128> oidrom {};

	uint led {};
	// タイマー
	bool timer_intr {};
	bool timer_enable {};

	// システムタイマーが刻んている時刻。
	uint64 stime {};

	// システムタイマーを実時間に同期する場合 true
	bool sync_rt {};

	DipswDevice *dipsw {};

	Event timer_event { this };
};

static inline NewsCtlrDevice *GetNewsCtlrDevice() {
	return Object::GetObject<NewsCtlrDevice>(OBJ_NEWSCTLR);
}
