//
// nono
// Copyright (C) 2023 nono project
// Licensed under nono-license.txt
//

//
// Nereid バンクメモリ
//

#pragma once

#include "device.h"
#include "mainbus.h"

class BankRAMDevice : public IODevice
{
	using inherited = IODevice;
 public:
	BankRAMDevice(uint objid_, int ram_size_MB);
	~BankRAMDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

	// バンクページ取得・設定
	uint32 GetPage() const { return page; }
	void SetPage(uint32 page);

	// バンクメモリ容量 [MB]を取得 (負数は扱わない)
	uint GetSize() const { return ram_size / 1024 / 1024; }

	// アクセス状況の取得とクリア
	void FetchAccStat(uint8 *buf);

 private:
	// アドレスデコーダ
	inline uint32 Decoder(uint32 addr) const;

	std::unique_ptr<uint8[]> ram {};
	uint ram_size {};

	// ページ番号 (レジスタ値、マスク前)
	uint32 page {};

	// ページ番号をリニアアドレスにした状態で保持。
	uint32 pageaddr {};

	// アクセス状況
	alignas(8) uint8 accstat_read[AccStat::BANKLEN] {};
	alignas(8) uint8 accstat_write[AccStat::BANKLEN] {};
};

// GetBankRAMDevice() は用意していない。
// BankRAMDevice は存在しない場合があるので FindObject() を使うこと。
