//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

#pragma once

#include "header.h"

// NetBSD の <sys/exec_aout.h>、<sys/aout_mids.h> あたり参考。

#define AOUT_MID(x)		(((x) >> 16) & 0x3ff)
#define AOUT_MAGIC(x)	((x) & 0xffff)
#define AOUT_OMAGIC		(0x0107)
#define AOUT_NMAGIC		(0x0108)
#define AOUT_ZMAGIC		(0x010b)

struct aout_header {
	// magic はネットワークバイトオーダ。
	//
	//     3                   2                   1                   0
	//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
	// +------------+-------------------+-------------------------------+
	// |    flags   |    machine id     |               magic           |
	// +------------+-------------------+-------------------------------+
	uint32 magic;
	// 以下はホストバイトオーダ。
	uint32 textsize;
	uint32 datasize;
	uint32 bsssize;
	uint32 symsize;
	uint32 entry;
	uint32 textrelsize;
	uint32 datarelsize;
};
