//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// HD64180 逆アセンブラ
//

#pragma once

#include "disasm.h"
#include "hd64180.h"

class hd64180disasm final : public  DisasmLine
{
	using inherited = DisasmLine;

 public:
	hd64180disasm();
	~hd64180disasm() override;

	// 逆アセンブルを実行
	bool Exec(DebuggerMemoryStream *mem_) override;

 private:
	uint8 fetch1();
	uint16 fetch2();

	uint16 ppc {};
	ixiy_t ixiy {};
	uint32 ixd {};		// (IX+d)/(IY+d)
	uint8 op {};		// 直近の命令ワード

	std::string name {};
	std::string arg1 {};
	std::string arg2 {};

	std::string HL();
	std::string HLin();
	std::string IXin();
	std::string ww();
	std::string wwin();
	std::string zz();
	std::string rrr();
	std::string sss();
	std::string rrrsss(uint);
	std::string fff() const;
	std::string bbb() const;
	std::string imm8();
	std::string imm16();
	std::string disp8();

	void ops_ddfd(ixiy_t);

#define OP_PROTO(name)	void __CONCAT(op_,name)()
#include "hd64180ops.h"
	OP_PROTO(00);
	OP_PROTO(illegal);
	OP_PROTO(undef);
#undef OP_PROTO
};
