<!--
 nono
 Copyright (C) 2021 nono project
 Licensed under nono-license.txt
-->
<?php require_once "common.php"; ?>
<html>
<head>
<?php print_head_common(); ?>
<title>nono: Upgrade to 0.2.0</title>
</head>
<body>
<h3>nono</h3>
<hr>

<h4>ver 0.1.x から ver 0.2.0 への移行方法 <q>How to migrate from ver 0.1.x to ver 0.2.0</q></h4>
<div class="main1">
ver 0.1.x と ver 0.2.0 には2つの非互換があり、そのままでは以前と同じ動作はしません。
<q>There are two incompatibilities between ver 0.1.x and ver 0.2.0,
so it will not work the same as before.</q>

<dl>
<dt>1. 設定ファイルのネットワーク関連項目の変更
<q>Configuration changes about network</q>
<dd>ver 0.1.x の以下の2つの設定項目は廃止になりました。
<q>These two items in 0.1.x have been removed.</q>
<br>
<blockquote style="background-color: var(--light-pink);"><pre>
ethernet-hostdriver     = (default: none)
ethernet-hostdevice     = (default: auto)
</pre></blockquote>
代わりに次の5つが追加されています。
設定方法は<a href="index.html#configuration">本編ドキュメントの設定の章</a>を参照してください。
ホストドライバは以前はデフォルトでオフでしたがデフォルトでオン(auto)に変更になっています。
<q>Instead, the following five items have been added.
See <a href="index.html#configuration">Configuration section in the main document</a>
to setup.
The host driver used to be disabled by default before,
but now it is enabled(auto) by default.</q>
<blockquote style="background-color: white;"><pre>
hostnet-driver          = (default: auto)
hostnet-afpacket-ifname = (default: auto)
hostnet-bpf-ifname      = (defualt: auto)
hostnet-tap-devpath     = (default: auto)
hostnet-fallback        = (default: 0)
</pre></blockquote>
</dd>

<dt>2. LUNA-88K の NVRAM サポートについて <q>About NVRAM in LUNA-88K</q>
<dd>
LUNA-88K では本来 PROM が NVRAM の情報を元に起動先を決定しますが、
nono ver 0.1.x は NVRAM を (ファイルを作るだけで) 一切サポートしておらず、
OpenBSD/luna88k を起動するために起動先ファイル名を boot と決め打ちしていました。
ver 0.2.0 で NVRAM をサポートしたため、
内蔵互換 ROM で起動するとまず NVRAM がチェックサム不正のため初期化されます。
更に初期化された NVRAM の起動ファイル名は vmunix であるため、
そのままでは OpenBSD/luna88k を起動できません。
Emulated ROM Monitor が起動したら以下のように入力してください。
<q>On LUNA-88K, originally PROM determines the boot target by referring NVRAM.
Since nono ver 0.1.x didn't support NVRAM (though it created NVRAM.DAT file),
it used hard-coded boot filename "boot" in order to boot OpenBSD/luna88k.
nono ver 0.2.0 supports NVRAM, so at first it initializes the NVRAM
due to checksum mismatch.
In addition, the boot filename in the initialized NVRAM is "vmunix",
so it cannot boot OpenBSD/luna88k.
To boot it, enter as following on Emulated ROM Monitor.</q>
<blockquote><pre>
nvram boot_filename boot[Enter]
y
b[Enter]
</pre></blockquote>
この内容は NVRAM.DAT に記録されるので次回以降は直接 OpenBSD が起動します。
<q>The information you have just entered is recorded in the NVRAM,
so next time it boots OpenBSD automatically.</q>
</div>


<hr>
nono project
</body>
</html>
