/* $Header: /home/vikas/netmgt/nocol/src/nsmon/RCS/nstest.c,v 1.5 1994/05/16 02:06:13 vikas Exp $ */

/*+ 
 * FUNCTION:
 * 	Small standalone program to test the NOCOL nsmon() monitor.
 *
 * AUTHOR:
 *	S. Spencer Sun, spencer@phoenix.princeton.edu
 */

#include "nsmon.h"

usage()
{
  fprintf(stderr,
    "Usage: nstest [ -d ] [-A (AA only)] [ -T query type ] [ -t timeout (secs) ] \n");
  fprintf(stderr, "\t<nameserver>  <request>  [ <nameserver> <request> ]...\n");
  fprintf(stderr, "  e.g.\t nstest -A -T 6 nisc.jvnc.net  jvnc.net\n");
  fprintf(stderr, "  type T_SOA=6, T_A=1, T_ANY=255\n");
  exit(1);
}

main(argc, argv)
  int argc;
  char *argv[];
{
  int class, type, timeout, ch;
  int aaonly = 0, debug = 0;
  extern char *optarg;
  extern int optind;

  class = C_IN; type = T_SOA; timeout = 15;

  while ((ch = getopt(argc, argv, "AdT:t:")) != EOF) {
    switch (ch) {
      case 'A':
        aaonly = 1; break;
      case 'd':
        debug++ ; debug ++; break;	/* set real high debug level */
      case 'T':
        type = atoi(optarg); break;
      case 't':
        timeout = atoi(optarg); break;
      default:
        usage(); break;
    }
  }
  argc -= optind;
  if (argc < 1) {
    fprintf(stderr, "nstest: no servers/requests were specified\n");
    usage() ;
    return 1;
  }
  for (argv += optind; argc >=2; argc -=2, argv +=2) {
    printf("Server: %s  Request: %s  return code: %d\n",
	   argv[0], argv[1], 
	   nsmon(argv[0], argv[1], class, type, timeout, aaonly, debug));
  }
  if (argc) 
    fprintf(stderr, "nstest: Missing request\n");
  return 0;
}
