/* $Header: /home/vikas/src/nocol/eventselect/RCS/eventselect.c,v 1.9 1998/07/31 18:16:25 vikas Exp $ */

/*+ 
 ** Program to parse all NOCOL data files and print out (in LOG format)
 ** all events matching the specified (command line) criterion.
 **
 **	-vikas@navya.com	Sep 27, 1993
 **/

/* Copyright 1993 JvNCnet */

/*
 * $Log: eventselect.c,v $
 * Revision 1.9  1998/07/31 18:16:25  vikas
 * Small typo
 *
 * Revision 1.8  1997/03/21 04:59:59  vikas
 * Cleanup for release
 *
 * Revision 1.7  1997/02/14 12:26:36  vikas
 * Was doing a define instead of static char rcsid[]
 *
 * Revision 1.6  1994/06/12 16:37:47  vikas
 * Changed all references from 'myname' and 'debugflag' to
 * 'prognm' and 'debug' since these are the names used throughout.
 *
 * Revision 1.5  1994/05/16  01:25:30  vikas
 * *** empty log message ***
 *
 *
 * Revision 1.3  1993/10/22  14:24:07  aggarwal
 * Now also handles numbers as levels.
 *
 * Revision 1.2  1993/10/14  16:59:10  aggarwal
 * Small change in the usage message.
 *
 * Revision 1.1  1993/10/02  05:23:01  aggarwal
 * Initial revision
 *
 */

#ifndef lint
static char rcsid[] = "$Id: eventselect.c,v 1.9 1998/07/31 18:16:25 vikas Exp $" ;
#endif

#include "nocol.h"
#include <fcntl.h>		/* for O_RDONLY definition */

int	logevents, minseverity = E_INFO ;
int	debug;			/* referenced in libnocol.a also */
char 	*prognm;		/* referenced in libnocol.a also */
time_t	fromtime, totime ;	/* user specified */

char *(senderlist[40]);		/* list of command-line sender names */
char *(sitenamelist[40]);

main(argc, argv)
     int argc;
     char **argv;
{
    extern char *optarg;
    extern int  optind;
    int c, sitei =0, senderi =0 ;

    prognm = argv[0] ;

    while ((c = getopt(argc, argv, "dlv:s:f:t:S:")) != EOF)
      switch(c)
      {
       case 'd':
          debug++;
	  fprintf(stderr, "%s: DEBUG turned on\n", prognm);
          break;
       case 'l':
	  logevents++ ;		/* send to noclogd logging daemon */
          break ;
       case 'v':
	  switch(tolower(optarg[0]))
	  {
	   case 'c': case '1': minseverity = E_CRITICAL; break;
	   case 'e': case '2': minseverity = E_ERROR; break;
	   case 'w': case '3': minseverity = E_WARNING; break;
	   case 'i': case '4': minseverity = E_INFO; break;
	  }
          break ;
       case 's':
	  senderlist[senderi++] = optarg ;
          break ;
       case 'S':
	  sitenamelist[sitei++] = optarg ;
          break ;
       case 'f':			/* From time */
	  if (optarg[0] == '+')		/* time given as delta seconds */
	  {
	      time_t  t = time((long *)NULL);
	      fromtime = t - atoi(++optarg) ;
	  }
	  else
	    fromtime = get_date(optarg, NULL) ;
	  if (fromtime < 0)
	    fromtime = 0;
          break ;
       case 't':			/* To time */
	  if (optarg[0] == '+')		/* time given as delta seconds */
	  {
	      time_t  t = time((long *)NULL);
	      totime = t - atoi(++optarg) ;
	  }
	  else
	    totime = get_date(optarg, NULL) ;
          break ;
       case '?':
       default:
          fprintf(stderr, "%s: Unknown flag: %c\n", prognm, optarg);
          fprintf(stderr, "Usage: %s [-d (debug)] [-l (logevents)]\n", prognm);
          fprintf(stderr, "\t[-v <severity as Critical/Error/Warn/Info>]\n");
	  fprintf(stderr, "\t[-s <sendername>] [-S <sitename>]\n");
	  fprintf(stderr, "\t[-f <FromTime>] [-t <ToTime>] ");
	  fprintf(stderr, "(can specify deltaTimeSecs as +300)\n");
	  fprintf(stderr, "[data-files if not from stdin]\n");
          exit (1);
      }

    /*
     * Check times
     */

    if (totime <= 0)
      totime = time((long *)NULL) + 100000;	/* curtime + large number*/
    if (fromtime  &&  totime  &&  totime <= fromtime)
    {
	fprintf(stderr,	"%s: Ignoring EndTime since specified EndTime %s",
		prognm, ctime(&totime));
	fprintf(stderr, "\t is less than FromTime %s\n", ctime(&fromtime) );
	totime = time((long *)NULL) + 100000;
    }

    if (debug)
    {
	char **s ;

	fprintf(stderr, "%s (debug):\n", prognm);
	fprintf(stderr, "\tlogevents= %s, MinSeverity= %s\n",
		logevents ? "YES" : "NO", severity_txt[minseverity]);

	fprintf(stderr, "\tFrom= %s",ctime(&fromtime));
	fprintf(stderr, "\tTo= %s", ctime(&totime));
	fprintf(stderr, "\tSenders= ");
	if ((s = senderlist) && *s)
	  fprintf(stderr, "%s /", *s++);
	fprintf(stderr, "\n");
	fprintf(stderr, "\tSitenames= ");
	if ((s = sitenamelist) && *s)
	  fprintf(stderr, "%s /", *s++);
	fprintf(stderr, "\n");
    }

    if (optind >= argc)			/* no command line args */
      proc_datafile (fileno(stdin));	/* process STDIN */
    else                                /* specified input files  */
      while ( optind < argc )
      {
	  int fd ;

          if (debug)
            fprintf(stderr,"debug (main): processing input file %s\n",
                    argv[optind]);
          if ((fd = open(argv[optind], O_RDONLY)) < 0) /* Cannot open */
          {
              fprintf(stderr,"%s: Error in read open ", prognm);
              perror(argv[optind]);
          }
          else
          {
              proc_datafile (fd);
	      close(fd);
          }
          ++optind ;            /* next file    */
      }                         /* end while()  */

}	/* end:  main()  */

