.SH NAME
snmptest - communicates with a network entity using SNMP Requests
.SH SYNOPSIS
snmptest host community
.SH DESCRIPTION
Snmptest is a flexible SNMP application that can monitor and manage
information on a network entity.
.PP
The
.I host
specification may be either a host name or an internet address
specified in "dot notation"
.PP
After invoking the program, a command line interpreter proceeds to
accept commands.  It will prompt with:
.PP
.I Please enter the variable name:
.PP
At this point you can enter one or more variable names, one per line.
A blank line is a command to send a request for each of the variables
(in a single packet) to the remote entity. Each variable name is given
in the format specified in
.IR variables (5).
For example
.PP
.I snmpget snmp-example.net.cmu.edu public
.br
.I Please enter the variable name: system.sysdescr.0
.br
.I Please enter the variable name: 
.PP
Will return some information about the request and reply packets, as
well as the information:
.PP
.I Name: system.sysDescr.0
.br
.I OCTET STRING- (ascii):	Unix 4.3BSD
.PP
Upon startup, the program defaults to sending a GET Request packet.
This can be changed to a GET NEXT Request or a SET Request by typing
the commands "$N" or "$S" repectively.  Typing "$G" will go back to
the GET Request mode.
.PP
The command "$D" will toggle the dumping of each sent and received
packet.
.PP
When in the "SET Request" mode, more information is requested by the
prompt for each variable.  The prompt:
.PP
.I Please enter variable type  [i|s|x|d|n|o|t|a]:
.PP
requests the type of the variable be entered.  Type "i" for an
integer, "s" for an octet string in ascii, "x" for an octet string as
hex bytes seperated by whitespace, "d" for an octet string as decimal
bytes seperated by whitespace, , "a" for an ip address in dotted IP
notation, and "o" for an object identifier.
.br
At this point a value will be prompted for:
.PP
.I Please enter new value: 
.PP
If this is an integer value, just type the integer (in decimal).  If
it is a string, type in white-space seperated decimal numbers, one per
byte of the string.  Again type a blank line at the prompt for the
variable name to send the packet.
.PP
At the variable name line, typing "$Q" will quit the program.
.PP
Adding a "-d" to the argument list will cause the application to dump
input and output packets.
.PP
