/* $Id: filter.c,v 1.1.1.1 1998/07/29 15:14:29 proff Exp $
 * $Copyright$
 */

#include "nglobal.h"
#include "acc.h"

#include "filter.h"

/*
 * returns the name of the filter that matched, or
 * NULL
 */

/**** cf. xover optimised version in xover.c *****/

static int score_match(struct filter *f, char *text, int len, int score)
{
#ifdef USE_REGEX
	if (nn_regexec(&f->preg, text, len, 0, 0, 0)==0)
#else
	if (matchExp(f->pat, text, len, f->ignore_case, 0))
#endif
	{
		score+=f->weight;
		switch (f->weight_op)
		{
		case '*':
			score*=f->weight;
			break;
		case '/':
			score/=f->weight;
			break;
		default:
			break;
		}
	}
	return score;
}

EXPORT char *filterText(enum scope_enum scope, struct authent *auth, char *head, int head_len, char *article, int article_len, char *body, int body_len)
{
	struct filter *f;
	struct filter_chain *fc;
	int score;
	for (fc=auth->filter_chain; fc; fc=fc->next)
	{
		score = 0;
		for (f=fc->filter; f; f=f->next)
		{
			switch (f->scope)
			{
				case sc_head:
					if (scope != sc_head && head)
						continue;
					score = score_match (f, head, head_len, score);
					break;
				case sc_ahead:
					if (!head)
						continue;
					score = score_match (f, head, head_len, score);
					break;
				case sc_body:
					if (!body)
						continue;
					score = score_match (f, body, body_len, score);
					break;
				case sc_article:
					if (!article)
						continue;
					score = score_match (f, article, article_len, score);
					break;
				default:
					continue;
			}
			if (score >= 10000)
				return fc->name;
			if (score <=-10000)
				return NULL;
		}
		if (score>=100)
			return fc->name;
	}
	return NULL;
}
