.\" Automatically generated from an mdoc input file.  Do not edit.
.\" nihtest-case.mdoc -- nihtest test case format description
.\" Copyright (C) 2020-2023 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of nihtest, a testing framework.
.\" The authors can be contacted at <nihtest@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "NIHTEST-CASE" "5" "April 10, 2024" "NiH" "File Formats Manual"
.nh
.if n .ad l
.SH "NAME"
\fBnihtest-case\fR
\- test case format for nihtest
.SH "DESCRIPTION"
nihtest(1)
is a testing tool.
It uses
\fI.test\fR
files as input.
This man page describes the format of these test files.
.PP
Lines beginning with
\(lq\&#\(rq
are comments.
.PP
The following commands are recognized.
The
\fBreturn\fR
and
\fBargs\fR
commands must appear exactly once, the others are optional.
.TP 22n
\fBarguments\fR [\fIargument ...\fR]
Run the program with command line arguments
\fIargs\fR.
Shell style quoting is supported.
.TP 22n
\fBdescription\fR \fItext\fR
Describes the purpose of the test.
.TP 22n
\fBenvironment-clear\fR
Only variables explicitly set or passed through are included in the environment passed to the tested program.
.TP 22n
\fBenvironment-passthrough\fR \fIvariable ...\fR
Passes the named environment variables from the environment
nihtest(1)
is run in to the tested program.
.TP 22n
\fBenvironment-set\fR \fIvariable value\fR
Set the environment variable
\fIvariable\fR
to
\fIvalue\fR.
.TP 22n
\fBenvironment-unset\fR \fIvariable ...\fR
Removes the named environment variables.
.TP 22n
\fBfeatures\fR \fIfeature ...\fR
Only run test if all
\fIfeature\fRs
are present, otherwise skip it.
The features are extracted from a top-level
\fIconfig.h\fR
file.
If the string
\fRFOO\fR
is defined in the file, the feature
\fRFOO\fR
is assumed to be available, otherwise not.
See also the description of
\fBtop-build-directory\fR
in
nihtest-config(5).
.TP 22n
\fBfile\fR \fIname in\fR [\fIout\fR]
The arguments
\fIin\fR
and
\fIout\fR
specify the contents of the file
\fIname\fR
in the test directory before and after the program is run, respectively.
If
\fIout\fR
is omitted, the file is expected to remain unchanged.
.sp
\(lq{}\(rq
specifies that the file does not exist (i. e. that it is created or deleted by the program).
.sp
For
\(lq<inline>\(rq
the contents of the file are taken from the test case, up to a line consisting of
\(lqend-of-inline-data\(rq.
If both
\fIin\fR
and
\fIout\fR
are
\(lq<inline>\(rq,
the input data comes first.
Otherwise the argument specifies the name of the file to copy or compare againts.
.TP 22n
\fBmkdir\fR \fIname\fR
Create directory
\fIname\fR
in the test directory.
.TP 22n
\fBprecheck\fR \fIcommand\fR [\fIargument ...\fR]
If
\fIcommand\fR
exits with non-zero status, skip the test.
.TP 22n
\fBpreload\fR \fIobject\fR
Pre-load the shared object
\fIobject\fR
before running the program.
.sp
This is not supported on macOS and Windows, where tests with
\fBpreload\fR
will be skipped.
.TP 22n
\fBprogram\fR \fIname\fR
Run
\fIname\fR.
See the description of
\fBarguments\fR
above for its command line arguments.
If this directive is omitted,
\fBdefault-program\fR
from
\fInihtest.conf\fR
is run.
.TP 22n
\fBread-only\fR \fIname\fR
The file or directory
\fIname\fR
will be made read-only.
.TP 22n
\fBreturn\fR \fIexit-code\fR
\fIexit-code\fR
is the expected exit code (usually 0 on success).
.TP 22n
\fBset-modification-time\fR \fIfile\fR \fItime\fR
Set the modification of
\fIfile\fR
in the sandbox to
\fItime\fR,
which can be either in ISO-8601 format or seconds since Unix epoch.
.TP 22n
\fBstderr\fR [\fIfile\fR]
Specify the expect standard error output (stderr).
If
\fIfile\fR
is given, the output is compared with that file,
otherwise the expected text is taken from the following lines of the test case, up to a line consisting of
\(lqend-of-inline-data\(rq.
.TP 22n
\fBstderr-replace\fR \fIpattern replacement\fR
Run regular expression replacement over the standard error output
and the expected output as provided by
\fBstderr\fR
before comparing them.
\fIpattern\fR
is the match expression,
\fIreplacement\fR
is the replacement expression.
In the replacement expression,
\(lq$1\(rq
to
\(lq$9\(rq
are replaced with the content of the corresponding
\(lq(...)\(rq
match in the
\fIpattern\fR.
See
re_format(7)
for details.
.TP 22n
\fBstdin\fR [\fIfile\fR]
If
\fIfile\fR
is given, standard input (stdin) is redirected from this file, which means the program has direct access to the file, including the ability to seek within it.
.sp
Otherwise the text provided to the program via a pipe is taken from the test case, up to a line consisting of
\(lqend-of-inline-data\(rq.
.TP 22n
\fBstdout\fR [\fIfile\fR]
Specify the expect standard output (stdout).
If
\fIfile\fR
is given, the output is compared with that file,
otherwise the expected text is taken from the following lines of the test case, up to a line consisting of
\(lqend-of-inline-data\(rq.
.TP 22n
\fBstdout-replace\fR \fIpattern replacement\fR
Run regular expression replacement over the standard output
and the expected output as provided by
\fBstdout\fR
before comparing them.
See
\fBstderr-replace\fR
for details.
.TP 22n
\fBtest-case-source\fR \fIfilename\fR
Use
\fIfilename\fR
to refer to test case in error messages.
This is useful if the test case is created by a script.
.TP 22n
\fBworking-directory\fR \fIdirectory\fR
Run the program in the subdirectory
\fIdirectory\fR
inside the sandbox.
The directory will be created if it doesn't exist.
.SH "SEE ALSO"
nihtest(1),
nihtest-config(5)
