/* util.c: general utilities module for newsfetch program */
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <pwd.h>
#include <string.h>
#include "newsfetch.h"

extern int errno;
extern FILE *rcfp, *rctmpfp;
extern char lockfile[100];

/* self explanatory */
void gethome(char *homedir)
{
	struct passwd *userinfo;

	userinfo = getpwuid(getuid());
	if (userinfo != NULL)
		strcpy(homedir, userinfo->pw_dir);
	else {
		perror("getpwname");
		exit(1);
	}

}

/* we get information and/or create rcfiles ? */
void default_rcfiles(char *homedir, char *rcfile, char *copycmd)
{
	/*struct passwd *userinfo;*/
	char rctmpfile[100];

	if (rcfile[0] == '\0') {

		strcpy(rcfile, homedir);
		strcat(rcfile, "/");
		strcat(rcfile, NEWSFETCHRC);
	}
	sprintf(rctmpfile, "%s.tmp", rcfile);
	sprintf(copycmd, "cp %s %s.old;cp %s %s\n", 
			rcfile, rcfile, rctmpfile, rcfile);
	if ((rcfp = fopen(rcfile, "r")) == NULL) {
		fprintf(stderr, "Can not open file %s...aborting\n", rcfile);
		exit_now(1);
	}
	if ((rctmpfp = fopen(rctmpfile, "w+")) == NULL) {
		fprintf(stderr, "Can not create file %s ...aborting\n", 
				rctmpfile);
		exit_now(1);
	}
}

/* create a procmailrc file */
void generate_procmailrc(char *homedir, char *rcfile, 
				char *dirname, char *pipe_command)
{
	FILE *fp, *fpf, *fpr;
	char *tmp, buf[200], group[180], filterfile[100], procmailrcfile[100];
	int i, j;
	char *title = "generated by newsfetch";

	strcpy(filterfile, homedir);
	strcat(filterfile, "/");
	strcat(filterfile, PROCMAIL_TMPL);

	if ((fpf = fopen(filterfile, "r")) == NULL) {
		strcpy(filterfile, homedir);
		strcat(filterfile, "/");
		strcat(filterfile, ".procmailrc");
		if ((fpf = fopen(filterfile, "r")) == NULL) {
			fprintf(stderr, "can not open file %s/%s or %s\n", 
				homedir, PROCMAIL_TMPL, filterfile);
			exit_now(-1);
		}
	}
	if ((fp = fopen(rcfile, "r")) == NULL) {
		fprintf(stderr, "can not open file %s\n", rcfile);
		exit_now(-1);
	}
	strcpy(procmailrcfile, homedir);
	strcat(procmailrcfile, "/");
	strcat(procmailrcfile, PROCMAIL_RC);
	strcat(pipe_command, procmailrcfile);

	if ((fpr = fopen(procmailrcfile, "w+")) == NULL) {
		fprintf(stderr, "Can not create file %s \n", procmailrcfile);
		exit_now(-1);
	}
	tmp = fgets(buf, 199, fpf);
	while (tmp != NULL) {
		fprintf(fpr, "%s", buf);
		tmp = fgets(buf, 199, fpf);
	}
	fclose(fpf);

	fprintf(fpr, "%s\n", title);

	tmp = fgets(buf, 199, fp);
	while (tmp != NULL) {
		for (i = 0; buf[i] == 0x20; i++);
		if (buf[i] == '#')
			for (i++; buf[i] == 0x20; i++);
		if (buf[i] != '\n') {
			sscanf(&buf[i], "%s %d %d", group, &i, &j);
			fprintf(fpr, "\n:0\n* ^newsfetch:.*%s\n%s/%s\n", 
			 group, dirname[0] == '\0' ? "." : dirname, group);
		}
		tmp = fgets(buf, 199, fp);
	}
	fclose(fp);
	fflush(fpr);
	fclose(fpr);
}

/* another self explanatory function */
int create_directory(char *dirname)
{
	struct stat dirstat;
/*	int i; */

	if (stat(dirname, &dirstat) == 0) {
		if (!S_ISDIR(dirstat.st_mode)) {
			fprintf(stderr, "%s is not a directory\n", dirname);
			return (0);
		}
		if ((access(dirname, W_OK)) < 0) {
			perror(dirname);
			return (0);
		}
	} else {
		if (errno == ENOENT) {
			if (mkdir(dirname, (S_IRUSR | S_IWUSR | S_IXUSR)) < 0) {
				perror(dirname);
				return (0);
			}
		} else {
			perror(dirname);
			return (0);
		}

	}
	return (1);
}

/* this is used to execute a command after reordering the syntax */
void mkcmd(char *src, char *search, char *replace, char *dest)
{
	char *tmp, *src_tmp;

	src_tmp = src;
	dest[0] = '\0';

	while (1) {
		tmp = (char *) strstr(src_tmp, search);
		if (tmp != NULL) {
			strncat(dest, src_tmp, tmp - src_tmp);
			strcat(dest, replace);
			src_tmp = tmp + strlen(search);
		} else {
			strcat(dest, src_tmp);
			return;
		}
	}
}



