.\"
.\" netname.man,v 1.13 2011/12/08 04:01:42 kim Exp
.\"
.Dd December 7, 2011
.Dt NETNAME 1
.Os
.Sh NAME 
.Nm netname
.Nd Return the canonical network name and/or addresses of a host
.Sh SYNOPSIS
.Nm
.Op Fl adn46
.Op Ar host | address
.Nm
.Fl v
.Sh DESCRIPTION
.Nm
returns the canonical name of the given host or address on standard output.
If no host is given, the name of the local machine is used.
.Pp
If the
.Fl d
option is specified, only the domain part of the canonical name is returned.
A top-level name (a name without any dots) is its own domain.
.Pp
The
.Fl n
option returns all the addresses found for the host. You can limit addresses
to IPv4 addresses using the
.Fl 4
option, or to IPv6 addresses using the
.Fl 6
option instead.
.Pp
The
.Fl a
option will perform a reverse lookup on each address and print it with its
associated name. This is primarily useful for debugging DNS and the resolver
functionality of the host.
.Pp
Use the
.Fl v
option to check the version of the binary.
.Sh EXAMPLES
.Bd -literal
HOST=$(netname)
setenv HOST `netname`
.Ed
.Sh DIAGNOSTICS
.Ex -std
.Pp
.Bl -tag -width M -compact
.It 0
Successful completion.
.It 1
Incorrect usage.
.It 2
Failed to retrieve information.
.El
.Sh SEE ALSO
.Xr hostname 1 ,
.Xr nodename 1 ,
.Xr uname 1 ,
.Xr uname 2 ,
.Xr getaddrinfo 3 ,
.Xr getnameinfo 3
.Sh AUTHORS
.An "Kimmo Suominen" Aq kim@tac.nyc.ny.us
.Sh BUGS
No known bugs.
