
/* Handle sharing of our own files */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <glib.h>

#include "gnutella.h"
#include "interface.h"

guint32 files_scanned = 0;
guint32 kbytes_scanned = 0;
guint32 bytes_scanned = 0;


GSList *extensions = NULL;
GSList *shared_dirs = NULL;
GSList *shared_files = NULL;

gchar stmp_1[4096];
gchar stmp_2[4096];

guint32 monitor_items = 0;

/* ------------------------------------------------------------------------------------------------ */

void share_init(void)
{
	share_scan();
}

/* Get the file extensions to scan */

void parse_extensions(gchar *str)
{
	gchar ** exts = g_strsplit(str, ";", 0);
	gchar *x, *s;
	guint i, e;
	GSList *l = (GSList *) NULL;

	if (extensions)
	{
		l = extensions;
		while (l) { g_free(l->data); l = l->next; }
		g_slist_free(extensions);
		extensions = NULL;
	}

	e = i = 0;

	while (exts[i])
	{
		s = exts[i];
		while (*s == ' ' || *s == '\t' || *s == '.' || *s == '*' || *s == '?') s++;
		if (*s)
		{
			x = s + strlen(s);
			while (--x > s && (*x == ' ' || *x == '\t' || *x == '*' || *x == '?')) *x = 0;
			if (*s) extensions = g_slist_append(extensions, g_strdup(s));
		}
		i++;
	}

	g_strfreev(exts);
}

/* Shared dirs */

void shared_dirs_parse(gchar *str)
{
	gchar ** dirs = g_strsplit(str, ":", 0);
	guint i;

	GSList *l = (GSList *) NULL;

	if (shared_dirs)
	{
		l = shared_dirs;
		while (l) { g_free(l->data); l = l->next; }
		g_slist_free(shared_dirs);
		shared_dirs = NULL;
	}

	i = 0;

	while (dirs[i])
	{
		if (is_directory(dirs[i])) shared_dirs = g_slist_append(shared_dirs, g_strdup(dirs[i]));
		i++;
	}

	g_strfreev(dirs);
}

void shared_dir_add(gchar *path)
{
	if (!is_directory(path)) return;

	shared_dirs = g_slist_append(shared_dirs, g_strdup(path));

	gui_update_shared_dirs();
}

/* recurse_scan();
 *The directories that are given as shared will be completly transversed
 *including all files and directories. An entry of "/" would search the
 *the whole file system.
 */
 
void recurse_scan(gchar *dir, gchar *basedir)
{ 
 GSList *exts = NULL;
  DIR *directory;                                  /* Directory stream used by opendir, readdir etc.. */
  struct dirent *dir_entry;
  gchar *full = NULL , *sl = "/";
  gchar *file_directory = NULL;
  gchar *file_directory_path = NULL;

  struct shared_file *found = NULL;
  struct stat file_stat;

  if (!(directory = opendir(dir))) return;

  while ((dir_entry = readdir(directory))) {

	if (dir_entry->d_name[0] == '.') continue;

    if (dir[strlen(dir)-1] ==  '/')
      full = g_strconcat(dir,  dir_entry->d_name, NULL);
    else
      full = g_strconcat(dir, sl, dir_entry->d_name, NULL);

	if (is_directory(full)) {
	  g_free(full);
	  if (dir[strlen(dir)-1] ==  '/')
		full = g_strconcat(dir, dir_entry->d_name, sl, NULL);
	  else
		full = g_strconcat(dir, sl, dir_entry->d_name, sl, NULL);

	  recurse_scan(full, basedir);
	  g_free(full);
	  continue;
	}

	for (exts = extensions; exts; exts = exts->next) 
	  if (strstr(dir_entry->d_name, exts->data)) {

		if (stat(full, &file_stat) == -1) {
		  printf("recurse_scan() Shared dir scan - Can't stat %s.\n", full);
        break; //XXX Was continue. Who patched this? Why?
		}

		found = (struct shared_file *)g_malloc0(sizeof(struct shared_file));

		/* As long as we've got one file in this directory (so it'll be
		 * freed in share_scan()), allocate these strings.
		 */
		if(!file_directory)
		  file_directory = g_strdup(dir);
		if(!file_directory_path) {
		  file_directory_path = g_strdup(dir + strlen(basedir));
		  g_strdown(file_directory_path);
		}

		found->file_name = g_strdup(dir_entry->d_name);
		found->file_name_lowercase = g_strdup(found->file_name);
		g_strdown(found->file_name_lowercase);
		found->file_directory = file_directory;
		found->file_directory_path = file_directory_path;
		found->file_size = file_stat.st_size;
		found->file_index = ++files_scanned;

		shared_files = g_slist_append(shared_files, found);

		bytes_scanned += file_stat.st_size;
		kbytes_scanned += bytes_scanned/1024;
		bytes_scanned %= 1024;
		break; /* for loop */
	  }
	g_free(full);
  }
  closedir(directory);
}  



void share_scan(void)
{
	GSList *l;
	gchar *last_dir = NULL, *last_lower_dir = NULL;

	files_scanned = 0;
	bytes_scanned = 0;
	kbytes_scanned = 0;

	for (l = shared_files; l; l = l->next) { // free all records, last_dir is only allocated once, handle it special
		struct shared_file *sf = l->data;
		g_free(sf->file_name);
		g_free(sf->file_name_lowercase);
		if (last_dir && last_dir != sf->file_directory) { // switched to new dir, free the last one
			g_free(last_dir);
			}
		last_dir = sf->file_directory;
		if (last_lower_dir && last_lower_dir != sf->file_directory_path) { // compare pointers
			g_free(last_lower_dir);
			}
		last_lower_dir = sf->file_directory_path;
		}

	if(last_lower_dir) /* free the last one */
	  g_free(last_lower_dir);
	if(last_dir)
	  g_free(last_dir);

	g_slist_free(shared_files);
	shared_files = NULL;

	for (l = shared_dirs; l; l = l->next)
	  recurse_scan(l->data, l->data);
	gui_update_files_scanned();
}

void dejunk(char *str)
{
  
  int c = 0, x = 0;
  
  c = strlen(str);

  for (;x<c;x++)
    if (str[x] < 34 || str[x] > 125) str[x] = ' ';
 
  return;
}


// Do a full AND match of the filename against the search phrase (already lowercase)

int share_match(char *s_filename, char *query)
{
  char *a;
  char *q2;
  char *s2;
  char *loc;
  int i;

  // Copy query and filename so strtok doesn't trash them
  q2 = g_strdup(query);
  s2 = g_strdup(s_filename);

// break the query string into words ("tokens"). For example,
// if the query is "john smith .jpg" the tokens will be "john",
// "smith" and "jpg" tabs are handled as spaces

  a = strtok(q2, " \t"); // get first token
  if (a == 0) {
    g_free(q2);
    g_free(s2);
    return 0;
  }

// Check each token to see if it's in the string

  while (a) {
    loc = strstr(s2, a); // is there a match?
    if (loc == 0) {
		g_free(q2);
		g_free(s2);
	 	return 0; // all must match
		}

    // "Erase" the matched text, so that two occurrances of the
    // same keyword in query will require two occurrances of that
    // word in the string.
    for(i=0; a[i]; i++) {
		if (loc[i]) {
          loc[i] = ' ';
        }
      }
    a = strtok(0, " \t"); // go to next token
  }

	g_free(q2);
	g_free(s2);
	return 1; // if we got this far we have a match
}


/* Searches requests (from others nodes) 
 * Basic matching. The search request is made lowercase and
 * is matched to the filenames in the LL.
*/

void search_request(struct gnutella_node *n)
{

  GSList *files = NULL;
  guchar found_files = 0;
  guint32 size = 0, pos = 0, pl = 0;
  guint16 req_speed;
  gchar *search, trailer[10];
  guchar *found_data = NULL, *final = NULL;
  struct gnutella_header packet_head;
  struct gnutella_search_results_out search_head; 
  gchar *last_dir = NULL;
//  gchar *dir_matches = NULL;

	if (monitor_enabled)	/* Update the search monitor */
	{
		gchar *titles[1];

		gtk_clist_freeze(GTK_CLIST(clist_monitor));

		if (monitor_items < monitor_max_items) monitor_items++;
		else gtk_clist_remove(GTK_CLIST(clist_monitor), GTK_CLIST(clist_monitor)->rows - 1);

		titles[0] = n->buffer + 2;

		gtk_clist_prepend(GTK_CLIST(clist_monitor), titles);

		gtk_clist_set_selectable (GTK_CLIST(clist_monitor), 0, FALSE);

		gtk_clist_thaw(GTK_CLIST(clist_monitor));
	}

	// Don't bother if we aren't sharing
	if (max_uploads == 0) return;
	search = n->buffer+2;
	memcpy(&req_speed, n->buffer, 2); // move the requested minimum speed to a guint16
	if (strlen(search) < 2) return; // short search phrase, forget it
	// if guy is farther than 3 hops, save bandwidth when returning lots of hits from short queries like mp3
	// the idea here is to give some responses but not too many
	if ((strlen(search) < 5) && (n->header.hops > 3)) return;
	if (n->header.hops > my_ttl) return; // are they are too far away to receive our reply?
	if (connection_speed < req_speed) return; // they requested a higher speed connection

	global_searches++; // display counter
	dejunk(search);
	g_strdown(search);

	found_data = (guchar *)g_malloc0(1*sizeof(guchar));

	/* So far, searches just search for a string match, nothing fancy.. */

	for (files = shared_files; files; files = files->next) {
	    struct shared_file *sf = (struct shared_file *)files->data;

      // shows path to shared directory /home/username/dir/shared
 		//printf("search %s, directory %s\n", search, ((struct shared_file *)(*files).data)->file_directory);
 		//printf("2directory %s\n", sf->file_directory_path); // blank unless you have sub directories in shared dir
 		//printf("lower filename %s\n", sf->file_name_lowercase); // file name all lowercase

		if(last_dir != sf->file_directory_path) {
			last_dir = sf->file_directory_path;
//			dir_matches = strstr(last_dir, search); // this would have matched your entire directory, why?
			}

//		if (dir_matches || strstr(sf->file_name_lowercase, search)) {
		if (share_match(sf->file_name_lowercase, search)) { // full AND match of whole string

	      /* Add to calling nodes found list. */
			found_data = g_realloc(found_data, (size + 8 + strlen(sf->file_name) + 2)*sizeof(guchar));

	      WRITE_GUINT32_LE( sf->file_index, &found_data[pos]);
	      
	      WRITE_GUINT32_LE( sf->file_size, &found_data[pos+4]);
	      
	      memcpy(&found_data[pos + 8], sf->file_name, strlen(sf->file_name));

			/* the size of the search results header 8 bytes, plus the string length - NULL, plus two NULL's */
	      
			size += 8 + strlen(sf->file_name) + 2;

			pos = size - 2;

			found_data[pos] = '\0'; found_data[pos + 1] = '\0';
		
		/* Position equals the next byte to be writen to */
			pos += 2;

			found_files++;
		
		/* Allow -1 to mean unlimited, and 0 to avoid returning any results
		 * (but not now, since this check happens after one has been found
		 * one.)
		 *
		 * XXX longer term, just use a checkbox: "[] limit searches to ______ results"
		 */

		/* Also, can't fit more than 255 results into a response packet.
		 * This can go away when we can send more than one packet per
		 * search. 
		 */
			if (((search_max_items != -1) && (found_files > search_max_items)) ||
					(found_files == 255)) break;
			}
		} // for loop


	if (found_files > 0) {

		if (dbg > 3) {
			// temp1 = ip_port_to_gchar(n->ip, n->port); // ip:port if you ever wanted to know the host we send to
			printf("Share hit %u files '%s' req_speed=%u ttl=%u hops=%u\n",
				(gint)found_files, search, req_speed, (gint)n->header.ttl, (gint)n->header.hops);
			}

	  strncpy(trailer,vendor_code,4); // Vendor Code
	  found_data = g_realloc(found_data, size + 23); // we add the trailer and GUID 7 + 16
	  trailer[4] = 2; // "open data size" is 2 bytes, started using this in V1.3
	  trailer[5] = 0x0C; // reset the bits
	  trailer[6] = 0x01;
	  // format bit 3= has uploaded, 2= busy, and on trailer[5] bit 0= need push
	  if (running_uploads >= max_uploads) trailer[6] = trailer[6] | 0x04; // busy bit high
	  if (count_uploads > 0) trailer[6] = trailer[6] | 0x08; // show we have uploaded at least one file
	  memcpy(&found_data[pos], &trailer, 7); // store the trailer
	  pos += 7;
	  memcpy(&found_data[pos], &guid, 16); // store the GUID
	  pos += 16;
	  size += 23; // count all the added bytes

	  /* Payload size including the search results header, actual results */
	  pl = size+sizeof(struct gnutella_search_results_out);

	  memcpy(&packet_head.muid, &(*n).header.muid, 16);

	  packet_head.function = GTA_MSG_SEARCH_RESULTS;
	  packet_head.ttl = my_ttl;
	  packet_head.hops = 0;
	  memcpy(&packet_head.size, &pl, 4);

	  memcpy(&search_head.num_recs, &found_files , 1);

	  WRITE_GUINT16_LE(listen_port, search_head.host_port);

	  WRITE_GUINT32_BE(force_local_ip ? forced_local_ip : local_ip, search_head.host_ip);

	  WRITE_GUINT32_LE(connection_speed, search_head.host_speed);

 	  final = (guchar *)g_malloc0(size+sizeof(struct gnutella_header)+sizeof(struct gnutella_search_results_out));

	  memcpy(final, &packet_head , sizeof(struct gnutella_header));

	  memcpy(&final[sizeof(struct gnutella_header)], &search_head , sizeof(struct gnutella_search_results_out));

	  memcpy(&final[sizeof(struct gnutella_header)+sizeof(struct gnutella_search_results_out)], found_data , size); 

	  // search request returns are not considered a priority packet, sorry
	  sendto_one(n, (guchar *)final, NULL, size+sizeof(struct gnutella_header)+sizeof(struct gnutella_search_results_out), FALSE);

	  if (final) g_free(final);
  	}

	if (found_data) g_free(found_data);

}

  


/* vi: set ts=3: */
