
/* Filter search results */

#include "gnutella.h"

#include "search.h"
#include "filter.h"


// Do a full AND match of the filename against the search phrase

int filter_and__match(char *s_filename, char *query)
{
  char *a;
  char *q2;
  char *s2;
  char *loc;
  int i;

  // Copy query and filename so strtok doesn't trash them
  q2 = g_strdup(query);
  s2 = g_strdup(s_filename);

  g_strdown(q2); // make them both lowercase
  g_strdown(s2);

// break the query string into words ("tokens"). For example,
// if the query is "john smith .jpg" the tokens will be "john",
// "smith" and "jpg" tabs are handled as spaces

  a = strtok(q2, " \t"); // get first token
  if (a == 0) {
    g_free(q2);
    g_free(s2);
    return 0;
  }

// Check each token to see if it's in the string

  while (a) {
    loc = strstr(s2, a); // is there a match?
    if (loc == 0) {
		g_free(q2);
		g_free(s2);
	 	return 0; // all must match
		}

    // "Erase" the matched text, so that two occurrances of the
    // same keyword in query will require two occurrances of that
    // word in the string.
    for(i=0; a[i]; i++) {
		if (loc[i]) {
          loc[i] = ' ';
        }
      }
    a = strtok(0, " \t"); // go to next token
  }

	g_free(q2);
	g_free(s2);
	return 1; // if we got this far we have a match
}


gboolean filter_record(struct search *sch, struct record *rec)
{
	/* Check a particular record against the search filters and the global filters */
	/* Returns TRUE if the record can be displayed, FALSE if not */

	if (search_strict_and && !sch->passive) { // config value for strict AND checking && not in passive mode
		if (!filter_and__match(rec->name, sch->query)) return FALSE; // full AND match of whole string
		}

	return TRUE;
}
