#!/usr/bin/perl

##############################################################################
# filter_sql.pl
#
# Example perl & MySql automation filter script for NapShare
#
# This gets the information line from NapShare, breaks it up and prints
# the info to a log file and searches for duplicate size files in your
# database created by the companion NapShare "mysql_admin.pl" script.
#
# Always test your perl programs from a command prompt first, and beware of
# strange results returned by other clients.
#
# This was called with filter "extern" and the string
# "???perl filter_sql.pl", you can take out the ??? later but it will
# show you the time it took to run this program. It's important not to
# spend too much time here or you will lose network connections and strange
# things may happen as timers overlap.
# If you see a lot of "Time 1s" returned, meaning it takes 1 second to
# execute this routine most of the time, then you probably need a faster
# CPU to do what you want to do with perl. Try doing it with a shell script or
# compile your own C program. If you only filter a few files every 10 seconds
# or so, you may be ok.
# Permissions were set to 755 (CHMOD 755)
#
# The "status" variable is sent as a decimal int but is really a uint16,
# see search.h for bit positions. You would have to convert it and use &&.
#
# This program is released under the GNU Public License (GPL) and is
# "open source". By using it you release the authors of NapShare from
# any and all liablilty resulting from it's use. You use this program
# at your own risk.
#
##############################################################################


### My Local Variables  

# The name of the log file to write to
$LogFile = "filter_log.txt";

$database = "filelist";	## the name of our database
$user = "yourusername";		## username for database
$password = "yourpassword";		## password for database

use DBI;

### The program

	# get the entire information line from NapShare
	$instring = $ARGV[0];

	# here we split the string up into filename, size and tag info
	($filename, $size, $speed, $status, $search, $tag) = split(/\//,$instring,6);

	# open the log file
	if (-e $LogFile) {  # file exist, open with append
		open(LOG,">>$LogFile") || die("Can't open $LogFile: $!\n");
		}
	else {  # new logfile open with write access
		open(LOG,">$LogFile") || die("Can't open $LogFile: $!\n");
		}


	if ($size > 300000) { # 300K is a good size to start at
		&mysql_connect;  ## connect to database server

		&mysql_execute("SELECT * FROM napshare WHERE size = $size LIMIT 1");
		if ($sth) {
			if (($id,$filename1,$size1) = $sth->fetchrow()) {
				print LOG "----FILE= $size1 $filename1\n";
				print LOG "DUP-SIZE= $size $filename\n";
				close(LOG);
				&mysql_disconnect;
				exit 1;  # don't queue this file
				}
			}
		}




	&mysql_disconnect;

	&gettime;  # go get the time

	print LOG<<EOH;

Time: $date
Line: $instring
Filename: $filename
Size: $size
Speed: $speed
Status: $status
Search: $search
Tag: $tag
EOH

	close(LOG);


exit 0; # exit - yes, queue the file



### Example exit lines

## exit 1;  # exit - don't queue the file

## exit 0;  # exit - yes, queue the file



#######################
# MySql connect to database Subroutine

sub mysql_connect {

undef($dbh);

$dsn = "DBI:mysql:$database";

$dbh = DBI->connect($dsn, $user, $password) or &error(no_database); ## here's where we connect

if ( !defined $dbh ) { &error(no_database); }

if ($dbg > 0) { print "Connected to database.\n\n"; }
}



#######################
# MySql disconnect from database Subroutine

sub mysql_disconnect {

if ( defined $sth ) { $sth->finish; }

# Disconnect the database handle. This actually
# - disconnects you from the database specified
# - by $dbh

if ( defined $dbh ) { $dbh->disconnect; }

if ($dbg > 0) { print "Disconnected from database.\n\n"; }
}



#######################
# MySql execute command Subroutine

sub mysql_execute {

undef($sth);
undef($rc);

$cmd1 = $_[0];

$sth = $dbh->prepare("$cmd1") or &error(no_database);

if ( !defined $sth ) { &error(no_database); }

$rc = $sth->execute or &error(no_database);  #do the command that was 'prepared' before

if ( !defined $rc ) { &error(no_database); }

if ($dbg > 0) { print "Execute command complete '$cmd1'.\n\n"; }

}


sub error {
   $err1 = $_[0];

   if ($err1 eq 'no_database') {
      print "ERROR - no database\n";
   }
   else {
      print "ERROR!  A Undefined Error Occured.\n";
   }
   exit 1;
}




##############################################################################
#	Generate time.
##############################################################################
sub gettime {
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	$year = $year + 1900;
	$date = sprintf("%02d:%02d:%02d %02d/%02d/%04d",
		$hour,$min,$sec,$mon+1,$mday,$year);
	$day = sprintf("%02d/%02d/%04d",$mon+1,$mday,$year);
	$today = sprintf("%02d",$mday);
	$month = sprintf("%02d",$mon+1);
}





